#![deny(unused_allocation)]
#![deny(unused_comparisons)]
extern crate cortex_m;
#[cfg(feature = "rt")]
extern crate cortex_m_rt;
extern crate vcell;
use core::marker::PhantomData;
use core::ops::Deref;
///Number available in the NVIC for configuring priority
pub const NVIC_PRIO_BITS: u8 = 4;
#[cfg(feature = "rt")]
extern "C" {
    fn WWDG();
    fn PVD();
    fn RTC_TAMP();
    fn RTC_WKUP();
    fn FLASH();
    fn RCC();
    fn EXTI0();
    fn EXTI1();
    fn EXTI2();
    fn EXTI3();
    fn EXTI4();
    fn DMA1_CHANNEL1();
    fn DMA1_CHANNEL2();
    fn DMA1_CHANNEL3();
    fn DMA1_CHANNEL4();
    fn DMA1_CHANNEL5();
    fn DMA1_CHANNEL6();
    fn DMA1_CHANNEL7();
    fn ADC1();
    fn USB_HP();
    fn USB_LP();
    fn C2SEV();
    fn COMP();
    fn EXTI5_9();
    fn TIM1_BRK();
    fn TIM1_UP();
    fn TIM1_TRG_COM_TIM17();
    fn TIM1_CC();
    fn TIM2();
    fn PKA();
    fn I2C1_EV();
    fn I2C1_ER();
    fn I2C3_EV();
    fn I2C3_ER();
    fn SPI1();
    fn SPI2();
    fn USART1();
    fn LPUART1();
    fn SAI1();
    fn TSC();
    fn EXTI10_15();
    fn RTC_ALARM();
    fn CRS_IT();
    fn PWR_SOTF();
    fn IPCC_C1_RX_IT();
    fn IPCC_C1_TX_IT();
    fn HSEM();
    fn LPTIM1();
    fn LPTIM2();
    fn LCD();
    fn QUADSPI();
    fn AES1();
    fn AES2();
    fn TRUE_RNG();
    fn FPU();
    fn DMA2_CH1();
    fn DMA2_CH2();
    fn DMA2_CH3();
    fn DMA2_CH4();
    fn DMA2_CH5();
    fn DMA2_CH6();
    fn DMA2_CH7();
    fn DMAMUX_OVR();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 63] = [
    Vector { _handler: WWDG },
    Vector { _handler: PVD },
    Vector { _handler: RTC_TAMP },
    Vector { _handler: RTC_WKUP },
    Vector { _handler: FLASH },
    Vector { _handler: RCC },
    Vector { _handler: EXTI0 },
    Vector { _handler: EXTI1 },
    Vector { _handler: EXTI2 },
    Vector { _handler: EXTI3 },
    Vector { _handler: EXTI4 },
    Vector {
        _handler: DMA1_CHANNEL1,
    },
    Vector {
        _handler: DMA1_CHANNEL2,
    },
    Vector {
        _handler: DMA1_CHANNEL3,
    },
    Vector {
        _handler: DMA1_CHANNEL4,
    },
    Vector {
        _handler: DMA1_CHANNEL5,
    },
    Vector {
        _handler: DMA1_CHANNEL6,
    },
    Vector {
        _handler: DMA1_CHANNEL7,
    },
    Vector { _handler: ADC1 },
    Vector { _handler: USB_HP },
    Vector { _handler: USB_LP },
    Vector { _handler: C2SEV },
    Vector { _handler: COMP },
    Vector { _handler: EXTI5_9 },
    Vector { _handler: TIM1_BRK },
    Vector { _handler: TIM1_UP },
    Vector {
        _handler: TIM1_TRG_COM_TIM17,
    },
    Vector { _handler: TIM1_CC },
    Vector { _handler: TIM2 },
    Vector { _handler: PKA },
    Vector { _handler: I2C1_EV },
    Vector { _handler: I2C1_ER },
    Vector { _handler: I2C3_EV },
    Vector { _handler: I2C3_ER },
    Vector { _handler: SPI1 },
    Vector { _handler: SPI2 },
    Vector { _handler: USART1 },
    Vector { _handler: LPUART1 },
    Vector { _handler: SAI1 },
    Vector { _handler: TSC },
    Vector {
        _handler: EXTI10_15,
    },
    Vector {
        _handler: RTC_ALARM,
    },
    Vector { _handler: CRS_IT },
    Vector { _handler: PWR_SOTF },
    Vector {
        _handler: IPCC_C1_RX_IT,
    },
    Vector {
        _handler: IPCC_C1_TX_IT,
    },
    Vector { _handler: HSEM },
    Vector { _handler: LPTIM1 },
    Vector { _handler: LPTIM2 },
    Vector { _handler: LCD },
    Vector { _handler: QUADSPI },
    Vector { _handler: AES1 },
    Vector { _handler: AES2 },
    Vector { _handler: TRUE_RNG },
    Vector { _handler: FPU },
    Vector { _handler: DMA2_CH1 },
    Vector { _handler: DMA2_CH2 },
    Vector { _handler: DMA2_CH3 },
    Vector { _handler: DMA2_CH4 },
    Vector { _handler: DMA2_CH5 },
    Vector { _handler: DMA2_CH6 },
    Vector { _handler: DMA2_CH7 },
    Vector {
        _handler: DMAMUX_OVR,
    },
];
///Enumeration of all the interrupts
#[derive(Copy, Clone, Debug)]
#[repr(u8)]
pub enum Interrupt {
    ///0 - Window Watchdog interrupt
    WWDG = 0,
    ///1 - PVD through EXTI\[16\]
    ///(C1IMR2\[20\])
    PVD = 1,
    ///2 - RTC/TAMP/CSS on LSE through EXTI line 19 interrupt
    RTC_TAMP = 2,
    ///3 - RTC wakeup interrupt through EXTI\[19\]
    RTC_WKUP = 3,
    ///4 - Flash global interrupt
    FLASH = 4,
    ///5 - RCC global interrupt
    RCC = 5,
    ///6 - EXTI line 0 interrupt through EXTI\[0\]
    EXTI0 = 6,
    ///7 - EXTI line 0 interrupt through EXTI\[1\]
    EXTI1 = 7,
    ///8 - EXTI line 0 interrupt through EXTI\[2\]
    EXTI2 = 8,
    ///9 - EXTI line 0 interrupt through EXTI\[3\]
    EXTI3 = 9,
    ///10 - EXTI line 0 interrupt through EXTI\[4\]
    EXTI4 = 10,
    ///11 - DMA1 Channel1 global interrupt
    DMA1_CHANNEL1 = 11,
    ///12 - DMA1 Channel2 global interrupt
    DMA1_CHANNEL2 = 12,
    ///13 - DMA1 Channel3 interrupt
    DMA1_CHANNEL3 = 13,
    ///14 - DMA1 Channel4 interrupt
    DMA1_CHANNEL4 = 14,
    ///15 - DMA1 Channel5 interrupt
    DMA1_CHANNEL5 = 15,
    ///16 - DMA1 Channel6 interrupt
    DMA1_CHANNEL6 = 16,
    ///17 - DMA1 Channel 7 interrupt
    DMA1_CHANNEL7 = 17,
    ///18 - ADC1 global interrupt
    ADC1 = 18,
    ///19 - USB high priority interrupt
    USB_HP = 19,
    ///20 - USB low priority interrupt (including USB wakeup)
    USB_LP = 20,
    ///21 - CPU2 SEV through EXTI\[40\]
    C2SEV = 21,
    ///22 - COMP2 & COMP1 interrupt through AIEC\[21:20\]
    COMP = 22,
    ///23 - EXTI line \[9:5\]
    ///interrupt through EXTI\[9:5\]
    EXTI5_9 = 23,
    ///24 - Timer 1 break interrupt
    TIM1_BRK = 24,
    ///25 - Timer 1 Update
    TIM1_UP = 25,
    ///26 - TIM1 Trigger and Commutation interrupts and TIM17 global interrupt
    TIM1_TRG_COM_TIM17 = 26,
    ///27 - TIM1 Capture Compare interrupt
    TIM1_CC = 27,
    ///28 - TIM2 global interrupt
    TIM2 = 28,
    ///29 - Private key accelerator interrupt
    PKA = 29,
    ///30 - I2C1 event interrupt
    I2C1_EV = 30,
    ///31 - I2C1 error interrupt
    I2C1_ER = 31,
    ///32 - I2C3 event interrupt
    I2C3_EV = 32,
    ///33 - I2C3 error interrupt
    I2C3_ER = 33,
    ///34 - SPI 1 global interrupt
    SPI1 = 34,
    ///35 - SPI1 global interrupt
    SPI2 = 35,
    ///36 - USART1 global interrupt
    USART1 = 36,
    ///37 - LPUART1 global interrupt
    LPUART1 = 37,
    ///38 - SAI1 global interrupt
    SAI1 = 38,
    ///39 - TSC global interrupt
    TSC = 39,
    ///40 - EXTI line \[15:10\]
    ///interrupt through EXTI\[15:10\]
    EXTI10_15 = 40,
    ///41 - RTC Alarms (A and B) interrupt through AIEC
    RTC_ALARM = 41,
    ///42 - CRS interrupt
    CRS_IT = 42,
    ///43 - PWR switching on the fly interrupt
    PWR_SOTF = 43,
    ///44 - IPCC CPU1 RX occupied interrupt
    IPCC_C1_RX_IT = 44,
    ///45 - IPCC CPU1 TX free interrupt
    IPCC_C1_TX_IT = 45,
    ///46 - Semaphore interrupt 0 to CPU1
    HSEM = 46,
    ///47 - LPtimer 1 global interrupt
    LPTIM1 = 47,
    ///48 - LPtimer 2 global interrupt
    LPTIM2 = 48,
    ///49 - LCD global interrupt
    LCD = 49,
    ///50 - QSPI global interrupt
    QUADSPI = 50,
    ///51 - AES1 global interrupt
    AES1 = 51,
    ///52 - AES2 global interrupt
    AES2 = 52,
    ///53 - True random number generator interrupt
    TRUE_RNG = 53,
    ///54 - Floating point unit interrupt
    FPU = 54,
    ///55 - DMA2 channel 1 interrupt
    DMA2_CH1 = 55,
    ///56 - DMA2 channel 2 interrupt
    DMA2_CH2 = 56,
    ///57 - DMA2 channel 3 interrupt
    DMA2_CH3 = 57,
    ///58 - DMA2 channel 4 interrupt
    DMA2_CH4 = 58,
    ///59 - DMA2 channel 5 interrupt
    DMA2_CH5 = 59,
    ///60 - DMA2 channel 6 interrupt
    DMA2_CH6 = 60,
    ///61 - DMA2 channel 7 interrupt
    DMA2_CH7 = 61,
    ///62 - DMAMUX overrun interrupt
    DMAMUX_OVR = 62,
}
unsafe impl bare_metal::Nr for Interrupt {
    #[inline(always)]
    fn nr(&self) -> u8 {
        *self as u8
    }
}
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
///Direct memory access controller
pub struct DMA1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA1 {}
impl DMA1 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dma1::RegisterBlock {
        0x4002_0000 as *const _
    }
}
impl Deref for DMA1 {
    type Target = dma1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DMA1::ptr() }
    }
}
///Direct memory access controller
pub mod dma1 {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - interrupt status register
        pub isr: ISR,
        ///0x04 - interrupt flag clear register
        pub ifcr: IFCR,
        ///0x08 - channel x configuration register
        pub ccr1: CCR1,
        ///0x0c - channel x number of data register
        pub cndtr1: CNDTR1,
        ///0x10 - channel x peripheral address register
        pub cpar1: CPAR1,
        ///0x14 - channel x memory address register
        pub cmar1: CMAR1,
        _reserved6: [u8; 4usize],
        ///0x1c - channel x configuration register
        pub ccr2: CCR2,
        ///0x20 - channel x number of data register
        pub cndtr2: CNDTR2,
        ///0x24 - channel x peripheral address register
        pub cpar2: CPAR2,
        ///0x28 - channel x memory address register
        pub cmar2: CMAR2,
        _reserved10: [u8; 4usize],
        ///0x30 - channel x configuration register
        pub ccr3: CCR3,
        ///0x34 - channel x number of data register
        pub cndtr3: CNDTR3,
        ///0x38 - channel x peripheral address register
        pub cpar3: CPAR3,
        ///0x3c - channel x memory address register
        pub cmar3: CMAR3,
        _reserved14: [u8; 4usize],
        ///0x44 - channel x configuration register
        pub ccr4: CCR4,
        ///0x48 - channel x number of data register
        pub cndtr4: CNDTR4,
        ///0x4c - channel x peripheral address register
        pub cpar4: CPAR4,
        ///0x50 - channel x memory address register
        pub cmar4: CMAR4,
        _reserved18: [u8; 4usize],
        ///0x58 - channel x configuration register
        pub ccr5: CCR5,
        ///0x5c - channel x number of data register
        pub cndtr5: CNDTR5,
        ///0x60 - channel x peripheral address register
        pub cpar5: CPAR5,
        ///0x64 - channel x memory address register
        pub cmar5: CMAR5,
        _reserved22: [u8; 4usize],
        ///0x6c - channel x configuration register
        pub ccr6: CCR6,
        ///0x70 - channel x number of data register
        pub cndtr6: CNDTR6,
        ///0x74 - channel x peripheral address register
        pub cpar6: CPAR6,
        ///0x78 - channel x memory address register
        pub cmar6: CMAR6,
        _reserved26: [u8; 4usize],
        ///0x80 - channel x configuration register
        pub ccr7: CCR7,
        ///0x84 - channel x number of data register
        pub cndtr7: CNDTR7,
        ///0x88 - channel x peripheral address register
        pub cpar7: CPAR7,
        ///0x8c - channel x memory address register
        pub cmar7: CMAR7,
    }
    ///interrupt status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [isr](isr) module
    pub type ISR = crate::Reg<u32, _ISR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ISR;
    ///`read()` method returns [isr::R](isr::R) reader structure
    impl crate::Readable for ISR {}
    ///interrupt status register
    pub mod isr {
        ///Reader of register ISR
        pub type R = crate::R<u32, super::ISR>;
        ///Reader of field `TEIF7`
        pub type TEIF7_R = crate::R<bool, bool>;
        ///Reader of field `HTIF7`
        pub type HTIF7_R = crate::R<bool, bool>;
        ///Reader of field `TCIF7`
        pub type TCIF7_R = crate::R<bool, bool>;
        ///Reader of field `GIF7`
        pub type GIF7_R = crate::R<bool, bool>;
        ///Reader of field `TEIF6`
        pub type TEIF6_R = crate::R<bool, bool>;
        ///Reader of field `HTIF6`
        pub type HTIF6_R = crate::R<bool, bool>;
        ///Reader of field `TCIF6`
        pub type TCIF6_R = crate::R<bool, bool>;
        ///Reader of field `GIF6`
        pub type GIF6_R = crate::R<bool, bool>;
        ///Reader of field `TEIF5`
        pub type TEIF5_R = crate::R<bool, bool>;
        ///Reader of field `HTIF5`
        pub type HTIF5_R = crate::R<bool, bool>;
        ///Reader of field `TCIF5`
        pub type TCIF5_R = crate::R<bool, bool>;
        ///Reader of field `GIF5`
        pub type GIF5_R = crate::R<bool, bool>;
        ///Reader of field `TEIF4`
        pub type TEIF4_R = crate::R<bool, bool>;
        ///Reader of field `HTIF4`
        pub type HTIF4_R = crate::R<bool, bool>;
        ///Reader of field `TCIF4`
        pub type TCIF4_R = crate::R<bool, bool>;
        ///Reader of field `GIF4`
        pub type GIF4_R = crate::R<bool, bool>;
        ///Reader of field `TEIF3`
        pub type TEIF3_R = crate::R<bool, bool>;
        ///Reader of field `HTIF3`
        pub type HTIF3_R = crate::R<bool, bool>;
        ///Reader of field `TCIF3`
        pub type TCIF3_R = crate::R<bool, bool>;
        ///Reader of field `GIF3`
        pub type GIF3_R = crate::R<bool, bool>;
        ///Reader of field `TEIF2`
        pub type TEIF2_R = crate::R<bool, bool>;
        ///Reader of field `HTIF2`
        pub type HTIF2_R = crate::R<bool, bool>;
        ///Reader of field `TCIF2`
        pub type TCIF2_R = crate::R<bool, bool>;
        ///Reader of field `GIF2`
        pub type GIF2_R = crate::R<bool, bool>;
        ///Reader of field `TEIF1`
        pub type TEIF1_R = crate::R<bool, bool>;
        ///Reader of field `HTIF1`
        pub type HTIF1_R = crate::R<bool, bool>;
        ///Reader of field `TCIF1`
        pub type TCIF1_R = crate::R<bool, bool>;
        ///Reader of field `GIF1`
        pub type GIF1_R = crate::R<bool, bool>;
        impl R {
            ///Bit 27 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif7(&self) -> TEIF7_R {
                TEIF7_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif7(&self) -> HTIF7_R {
                HTIF7_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif7(&self) -> TCIF7_R {
                TCIF7_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif7(&self) -> GIF7_R {
                GIF7_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif6(&self) -> TEIF6_R {
                TEIF6_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif6(&self) -> HTIF6_R {
                HTIF6_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif6(&self) -> TCIF6_R {
                TCIF6_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif6(&self) -> GIF6_R {
                GIF6_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif5(&self) -> TEIF5_R {
                TEIF5_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif5(&self) -> HTIF5_R {
                HTIF5_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif5(&self) -> TCIF5_R {
                TCIF5_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif5(&self) -> GIF5_R {
                GIF5_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif4(&self) -> TEIF4_R {
                TEIF4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif4(&self) -> HTIF4_R {
                HTIF4_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif4(&self) -> TCIF4_R {
                TCIF4_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif4(&self) -> GIF4_R {
                GIF4_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif3(&self) -> TEIF3_R {
                TEIF3_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif3(&self) -> HTIF3_R {
                HTIF3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif3(&self) -> TCIF3_R {
                TCIF3_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif3(&self) -> GIF3_R {
                GIF3_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif2(&self) -> TEIF2_R {
                TEIF2_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif2(&self) -> HTIF2_R {
                HTIF2_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif2(&self) -> TCIF2_R {
                TCIF2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif2(&self) -> GIF2_R {
                GIF2_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif1(&self) -> TEIF1_R {
                TEIF1_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif1(&self) -> HTIF1_R {
                HTIF1_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif1(&self) -> TCIF1_R {
                TCIF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif1(&self) -> GIF1_R {
                GIF1_R::new((self.bits & 0x01) != 0)
            }
        }
    }
    ///interrupt flag clear register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ifcr](ifcr) module
    pub type IFCR = crate::Reg<u32, _IFCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IFCR;
    ///`write(|w| ..)` method takes [ifcr::W](ifcr::W) writer structure
    impl crate::Writable for IFCR {}
    ///interrupt flag clear register
    pub mod ifcr {
        ///Writer for register IFCR
        pub type W = crate::W<u32, super::IFCR>;
        ///Register IFCR `reset()`'s with value 0
        impl crate::ResetValue for super::IFCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `CTEIF7`
        pub struct CTEIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Write proxy for field `CHTIF7`
        pub struct CHTIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Write proxy for field `CTCIF7`
        pub struct CTCIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Write proxy for field `CGIF7`
        pub struct CGIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Write proxy for field `CTEIF6`
        pub struct CTEIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Write proxy for field `CHTIF6`
        pub struct CHTIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Write proxy for field `CTCIF6`
        pub struct CTCIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Write proxy for field `CGIF6`
        pub struct CGIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Write proxy for field `CTEIF5`
        pub struct CTEIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Write proxy for field `CHTIF5`
        pub struct CHTIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Write proxy for field `CTCIF5`
        pub struct CTCIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Write proxy for field `CGIF5`
        pub struct CGIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Write proxy for field `CTEIF4`
        pub struct CTEIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Write proxy for field `CHTIF4`
        pub struct CHTIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Write proxy for field `CTCIF4`
        pub struct CTCIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Write proxy for field `CGIF4`
        pub struct CGIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Write proxy for field `CTEIF3`
        pub struct CTEIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Write proxy for field `CHTIF3`
        pub struct CHTIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Write proxy for field `CTCIF3`
        pub struct CTCIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Write proxy for field `CGIF3`
        pub struct CGIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Write proxy for field `CTEIF2`
        pub struct CTEIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Write proxy for field `CHTIF2`
        pub struct CHTIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Write proxy for field `CTCIF2`
        pub struct CTCIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Write proxy for field `CGIF2`
        pub struct CGIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Write proxy for field `CTEIF1`
        pub struct CTEIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Write proxy for field `CHTIF1`
        pub struct CHTIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Write proxy for field `CTCIF1`
        pub struct CTCIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Write proxy for field `CGIF1`
        pub struct CGIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl W {
            ///Bit 27 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif7(&mut self) -> CTEIF7_W {
                CTEIF7_W { w: self }
            }
            ///Bit 26 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif7(&mut self) -> CHTIF7_W {
                CHTIF7_W { w: self }
            }
            ///Bit 25 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif7(&mut self) -> CTCIF7_W {
                CTCIF7_W { w: self }
            }
            ///Bit 24 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif7(&mut self) -> CGIF7_W {
                CGIF7_W { w: self }
            }
            ///Bit 23 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif6(&mut self) -> CTEIF6_W {
                CTEIF6_W { w: self }
            }
            ///Bit 22 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif6(&mut self) -> CHTIF6_W {
                CHTIF6_W { w: self }
            }
            ///Bit 21 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif6(&mut self) -> CTCIF6_W {
                CTCIF6_W { w: self }
            }
            ///Bit 20 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif6(&mut self) -> CGIF6_W {
                CGIF6_W { w: self }
            }
            ///Bit 19 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif5(&mut self) -> CTEIF5_W {
                CTEIF5_W { w: self }
            }
            ///Bit 18 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif5(&mut self) -> CHTIF5_W {
                CHTIF5_W { w: self }
            }
            ///Bit 17 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif5(&mut self) -> CTCIF5_W {
                CTCIF5_W { w: self }
            }
            ///Bit 16 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif5(&mut self) -> CGIF5_W {
                CGIF5_W { w: self }
            }
            ///Bit 15 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif4(&mut self) -> CTEIF4_W {
                CTEIF4_W { w: self }
            }
            ///Bit 14 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif4(&mut self) -> CHTIF4_W {
                CHTIF4_W { w: self }
            }
            ///Bit 13 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif4(&mut self) -> CTCIF4_W {
                CTCIF4_W { w: self }
            }
            ///Bit 12 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif4(&mut self) -> CGIF4_W {
                CGIF4_W { w: self }
            }
            ///Bit 11 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif3(&mut self) -> CTEIF3_W {
                CTEIF3_W { w: self }
            }
            ///Bit 10 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif3(&mut self) -> CHTIF3_W {
                CHTIF3_W { w: self }
            }
            ///Bit 9 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif3(&mut self) -> CTCIF3_W {
                CTCIF3_W { w: self }
            }
            ///Bit 8 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif3(&mut self) -> CGIF3_W {
                CGIF3_W { w: self }
            }
            ///Bit 7 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif2(&mut self) -> CTEIF2_W {
                CTEIF2_W { w: self }
            }
            ///Bit 6 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif2(&mut self) -> CHTIF2_W {
                CHTIF2_W { w: self }
            }
            ///Bit 5 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif2(&mut self) -> CTCIF2_W {
                CTCIF2_W { w: self }
            }
            ///Bit 4 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif2(&mut self) -> CGIF2_W {
                CGIF2_W { w: self }
            }
            ///Bit 3 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif1(&mut self) -> CTEIF1_W {
                CTEIF1_W { w: self }
            }
            ///Bit 2 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif1(&mut self) -> CHTIF1_W {
                CHTIF1_W { w: self }
            }
            ///Bit 1 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif1(&mut self) -> CTCIF1_W {
                CTCIF1_W { w: self }
            }
            ///Bit 0 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif1(&mut self) -> CGIF1_W {
                CGIF1_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr1](ccr1) module
    pub type CCR1 = crate::Reg<u32, _CCR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR1;
    ///`read()` method returns [ccr1::R](ccr1::R) reader structure
    impl crate::Readable for CCR1 {}
    ///`write(|w| ..)` method takes [ccr1::W](ccr1::W) writer structure
    impl crate::Writable for CCR1 {}
    ///channel x configuration register
    pub mod ccr1 {
        ///Reader of register CCR1
        pub type R = crate::R<u32, super::CCR1>;
        ///Writer for register CCR1
        pub type W = crate::W<u32, super::CCR1>;
        ///Register CCR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr1](cndtr1) module
    pub type CNDTR1 = crate::Reg<u32, _CNDTR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR1;
    ///`read()` method returns [cndtr1::R](cndtr1::R) reader structure
    impl crate::Readable for CNDTR1 {}
    ///`write(|w| ..)` method takes [cndtr1::W](cndtr1::W) writer structure
    impl crate::Writable for CNDTR1 {}
    ///channel x number of data register
    pub mod cndtr1 {
        ///Reader of register CNDTR1
        pub type R = crate::R<u32, super::CNDTR1>;
        ///Writer for register CNDTR1
        pub type W = crate::W<u32, super::CNDTR1>;
        ///Register CNDTR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar1](cpar1) module
    pub type CPAR1 = crate::Reg<u32, _CPAR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR1;
    ///`read()` method returns [cpar1::R](cpar1::R) reader structure
    impl crate::Readable for CPAR1 {}
    ///`write(|w| ..)` method takes [cpar1::W](cpar1::W) writer structure
    impl crate::Writable for CPAR1 {}
    ///channel x peripheral address register
    pub mod cpar1 {
        ///Reader of register CPAR1
        pub type R = crate::R<u32, super::CPAR1>;
        ///Writer for register CPAR1
        pub type W = crate::W<u32, super::CPAR1>;
        ///Register CPAR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar1](cmar1) module
    pub type CMAR1 = crate::Reg<u32, _CMAR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR1;
    ///`read()` method returns [cmar1::R](cmar1::R) reader structure
    impl crate::Readable for CMAR1 {}
    ///`write(|w| ..)` method takes [cmar1::W](cmar1::W) writer structure
    impl crate::Writable for CMAR1 {}
    ///channel x memory address register
    pub mod cmar1 {
        ///Reader of register CMAR1
        pub type R = crate::R<u32, super::CMAR1>;
        ///Writer for register CMAR1
        pub type W = crate::W<u32, super::CMAR1>;
        ///Register CMAR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr2](ccr2) module
    pub type CCR2 = crate::Reg<u32, _CCR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR2;
    ///`read()` method returns [ccr2::R](ccr2::R) reader structure
    impl crate::Readable for CCR2 {}
    ///`write(|w| ..)` method takes [ccr2::W](ccr2::W) writer structure
    impl crate::Writable for CCR2 {}
    ///channel x configuration register
    pub mod ccr2 {
        ///Reader of register CCR2
        pub type R = crate::R<u32, super::CCR2>;
        ///Writer for register CCR2
        pub type W = crate::W<u32, super::CCR2>;
        ///Register CCR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr2](cndtr2) module
    pub type CNDTR2 = crate::Reg<u32, _CNDTR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR2;
    ///`read()` method returns [cndtr2::R](cndtr2::R) reader structure
    impl crate::Readable for CNDTR2 {}
    ///`write(|w| ..)` method takes [cndtr2::W](cndtr2::W) writer structure
    impl crate::Writable for CNDTR2 {}
    ///channel x number of data register
    pub mod cndtr2 {
        ///Reader of register CNDTR2
        pub type R = crate::R<u32, super::CNDTR2>;
        ///Writer for register CNDTR2
        pub type W = crate::W<u32, super::CNDTR2>;
        ///Register CNDTR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar2](cpar2) module
    pub type CPAR2 = crate::Reg<u32, _CPAR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR2;
    ///`read()` method returns [cpar2::R](cpar2::R) reader structure
    impl crate::Readable for CPAR2 {}
    ///`write(|w| ..)` method takes [cpar2::W](cpar2::W) writer structure
    impl crate::Writable for CPAR2 {}
    ///channel x peripheral address register
    pub mod cpar2 {
        ///Reader of register CPAR2
        pub type R = crate::R<u32, super::CPAR2>;
        ///Writer for register CPAR2
        pub type W = crate::W<u32, super::CPAR2>;
        ///Register CPAR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar2](cmar2) module
    pub type CMAR2 = crate::Reg<u32, _CMAR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR2;
    ///`read()` method returns [cmar2::R](cmar2::R) reader structure
    impl crate::Readable for CMAR2 {}
    ///`write(|w| ..)` method takes [cmar2::W](cmar2::W) writer structure
    impl crate::Writable for CMAR2 {}
    ///channel x memory address register
    pub mod cmar2 {
        ///Reader of register CMAR2
        pub type R = crate::R<u32, super::CMAR2>;
        ///Writer for register CMAR2
        pub type W = crate::W<u32, super::CMAR2>;
        ///Register CMAR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr3](ccr3) module
    pub type CCR3 = crate::Reg<u32, _CCR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR3;
    ///`read()` method returns [ccr3::R](ccr3::R) reader structure
    impl crate::Readable for CCR3 {}
    ///`write(|w| ..)` method takes [ccr3::W](ccr3::W) writer structure
    impl crate::Writable for CCR3 {}
    ///channel x configuration register
    pub mod ccr3 {
        ///Reader of register CCR3
        pub type R = crate::R<u32, super::CCR3>;
        ///Writer for register CCR3
        pub type W = crate::W<u32, super::CCR3>;
        ///Register CCR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr3](cndtr3) module
    pub type CNDTR3 = crate::Reg<u32, _CNDTR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR3;
    ///`read()` method returns [cndtr3::R](cndtr3::R) reader structure
    impl crate::Readable for CNDTR3 {}
    ///`write(|w| ..)` method takes [cndtr3::W](cndtr3::W) writer structure
    impl crate::Writable for CNDTR3 {}
    ///channel x number of data register
    pub mod cndtr3 {
        ///Reader of register CNDTR3
        pub type R = crate::R<u32, super::CNDTR3>;
        ///Writer for register CNDTR3
        pub type W = crate::W<u32, super::CNDTR3>;
        ///Register CNDTR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar3](cpar3) module
    pub type CPAR3 = crate::Reg<u32, _CPAR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR3;
    ///`read()` method returns [cpar3::R](cpar3::R) reader structure
    impl crate::Readable for CPAR3 {}
    ///`write(|w| ..)` method takes [cpar3::W](cpar3::W) writer structure
    impl crate::Writable for CPAR3 {}
    ///channel x peripheral address register
    pub mod cpar3 {
        ///Reader of register CPAR3
        pub type R = crate::R<u32, super::CPAR3>;
        ///Writer for register CPAR3
        pub type W = crate::W<u32, super::CPAR3>;
        ///Register CPAR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar3](cmar3) module
    pub type CMAR3 = crate::Reg<u32, _CMAR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR3;
    ///`read()` method returns [cmar3::R](cmar3::R) reader structure
    impl crate::Readable for CMAR3 {}
    ///`write(|w| ..)` method takes [cmar3::W](cmar3::W) writer structure
    impl crate::Writable for CMAR3 {}
    ///channel x memory address register
    pub mod cmar3 {
        ///Reader of register CMAR3
        pub type R = crate::R<u32, super::CMAR3>;
        ///Writer for register CMAR3
        pub type W = crate::W<u32, super::CMAR3>;
        ///Register CMAR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr4](ccr4) module
    pub type CCR4 = crate::Reg<u32, _CCR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR4;
    ///`read()` method returns [ccr4::R](ccr4::R) reader structure
    impl crate::Readable for CCR4 {}
    ///`write(|w| ..)` method takes [ccr4::W](ccr4::W) writer structure
    impl crate::Writable for CCR4 {}
    ///channel x configuration register
    pub mod ccr4 {
        ///Reader of register CCR4
        pub type R = crate::R<u32, super::CCR4>;
        ///Writer for register CCR4
        pub type W = crate::W<u32, super::CCR4>;
        ///Register CCR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr4](cndtr4) module
    pub type CNDTR4 = crate::Reg<u32, _CNDTR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR4;
    ///`read()` method returns [cndtr4::R](cndtr4::R) reader structure
    impl crate::Readable for CNDTR4 {}
    ///`write(|w| ..)` method takes [cndtr4::W](cndtr4::W) writer structure
    impl crate::Writable for CNDTR4 {}
    ///channel x number of data register
    pub mod cndtr4 {
        ///Reader of register CNDTR4
        pub type R = crate::R<u32, super::CNDTR4>;
        ///Writer for register CNDTR4
        pub type W = crate::W<u32, super::CNDTR4>;
        ///Register CNDTR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar4](cpar4) module
    pub type CPAR4 = crate::Reg<u32, _CPAR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR4;
    ///`read()` method returns [cpar4::R](cpar4::R) reader structure
    impl crate::Readable for CPAR4 {}
    ///`write(|w| ..)` method takes [cpar4::W](cpar4::W) writer structure
    impl crate::Writable for CPAR4 {}
    ///channel x peripheral address register
    pub mod cpar4 {
        ///Reader of register CPAR4
        pub type R = crate::R<u32, super::CPAR4>;
        ///Writer for register CPAR4
        pub type W = crate::W<u32, super::CPAR4>;
        ///Register CPAR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar4](cmar4) module
    pub type CMAR4 = crate::Reg<u32, _CMAR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR4;
    ///`read()` method returns [cmar4::R](cmar4::R) reader structure
    impl crate::Readable for CMAR4 {}
    ///`write(|w| ..)` method takes [cmar4::W](cmar4::W) writer structure
    impl crate::Writable for CMAR4 {}
    ///channel x memory address register
    pub mod cmar4 {
        ///Reader of register CMAR4
        pub type R = crate::R<u32, super::CMAR4>;
        ///Writer for register CMAR4
        pub type W = crate::W<u32, super::CMAR4>;
        ///Register CMAR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr5](ccr5) module
    pub type CCR5 = crate::Reg<u32, _CCR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR5;
    ///`read()` method returns [ccr5::R](ccr5::R) reader structure
    impl crate::Readable for CCR5 {}
    ///`write(|w| ..)` method takes [ccr5::W](ccr5::W) writer structure
    impl crate::Writable for CCR5 {}
    ///channel x configuration register
    pub mod ccr5 {
        ///Reader of register CCR5
        pub type R = crate::R<u32, super::CCR5>;
        ///Writer for register CCR5
        pub type W = crate::W<u32, super::CCR5>;
        ///Register CCR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr5](cndtr5) module
    pub type CNDTR5 = crate::Reg<u32, _CNDTR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR5;
    ///`read()` method returns [cndtr5::R](cndtr5::R) reader structure
    impl crate::Readable for CNDTR5 {}
    ///`write(|w| ..)` method takes [cndtr5::W](cndtr5::W) writer structure
    impl crate::Writable for CNDTR5 {}
    ///channel x number of data register
    pub mod cndtr5 {
        ///Reader of register CNDTR5
        pub type R = crate::R<u32, super::CNDTR5>;
        ///Writer for register CNDTR5
        pub type W = crate::W<u32, super::CNDTR5>;
        ///Register CNDTR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar5](cpar5) module
    pub type CPAR5 = crate::Reg<u32, _CPAR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR5;
    ///`read()` method returns [cpar5::R](cpar5::R) reader structure
    impl crate::Readable for CPAR5 {}
    ///`write(|w| ..)` method takes [cpar5::W](cpar5::W) writer structure
    impl crate::Writable for CPAR5 {}
    ///channel x peripheral address register
    pub mod cpar5 {
        ///Reader of register CPAR5
        pub type R = crate::R<u32, super::CPAR5>;
        ///Writer for register CPAR5
        pub type W = crate::W<u32, super::CPAR5>;
        ///Register CPAR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar5](cmar5) module
    pub type CMAR5 = crate::Reg<u32, _CMAR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR5;
    ///`read()` method returns [cmar5::R](cmar5::R) reader structure
    impl crate::Readable for CMAR5 {}
    ///`write(|w| ..)` method takes [cmar5::W](cmar5::W) writer structure
    impl crate::Writable for CMAR5 {}
    ///channel x memory address register
    pub mod cmar5 {
        ///Reader of register CMAR5
        pub type R = crate::R<u32, super::CMAR5>;
        ///Writer for register CMAR5
        pub type W = crate::W<u32, super::CMAR5>;
        ///Register CMAR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr6](ccr6) module
    pub type CCR6 = crate::Reg<u32, _CCR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR6;
    ///`read()` method returns [ccr6::R](ccr6::R) reader structure
    impl crate::Readable for CCR6 {}
    ///`write(|w| ..)` method takes [ccr6::W](ccr6::W) writer structure
    impl crate::Writable for CCR6 {}
    ///channel x configuration register
    pub mod ccr6 {
        ///Reader of register CCR6
        pub type R = crate::R<u32, super::CCR6>;
        ///Writer for register CCR6
        pub type W = crate::W<u32, super::CCR6>;
        ///Register CCR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr6](cndtr6) module
    pub type CNDTR6 = crate::Reg<u32, _CNDTR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR6;
    ///`read()` method returns [cndtr6::R](cndtr6::R) reader structure
    impl crate::Readable for CNDTR6 {}
    ///`write(|w| ..)` method takes [cndtr6::W](cndtr6::W) writer structure
    impl crate::Writable for CNDTR6 {}
    ///channel x number of data register
    pub mod cndtr6 {
        ///Reader of register CNDTR6
        pub type R = crate::R<u32, super::CNDTR6>;
        ///Writer for register CNDTR6
        pub type W = crate::W<u32, super::CNDTR6>;
        ///Register CNDTR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar6](cpar6) module
    pub type CPAR6 = crate::Reg<u32, _CPAR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR6;
    ///`read()` method returns [cpar6::R](cpar6::R) reader structure
    impl crate::Readable for CPAR6 {}
    ///`write(|w| ..)` method takes [cpar6::W](cpar6::W) writer structure
    impl crate::Writable for CPAR6 {}
    ///channel x peripheral address register
    pub mod cpar6 {
        ///Reader of register CPAR6
        pub type R = crate::R<u32, super::CPAR6>;
        ///Writer for register CPAR6
        pub type W = crate::W<u32, super::CPAR6>;
        ///Register CPAR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar6](cmar6) module
    pub type CMAR6 = crate::Reg<u32, _CMAR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR6;
    ///`read()` method returns [cmar6::R](cmar6::R) reader structure
    impl crate::Readable for CMAR6 {}
    ///`write(|w| ..)` method takes [cmar6::W](cmar6::W) writer structure
    impl crate::Writable for CMAR6 {}
    ///channel x memory address register
    pub mod cmar6 {
        ///Reader of register CMAR6
        pub type R = crate::R<u32, super::CMAR6>;
        ///Writer for register CMAR6
        pub type W = crate::W<u32, super::CMAR6>;
        ///Register CMAR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr7](ccr7) module
    pub type CCR7 = crate::Reg<u32, _CCR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR7;
    ///`read()` method returns [ccr7::R](ccr7::R) reader structure
    impl crate::Readable for CCR7 {}
    ///`write(|w| ..)` method takes [ccr7::W](ccr7::W) writer structure
    impl crate::Writable for CCR7 {}
    ///channel x configuration register
    pub mod ccr7 {
        ///Reader of register CCR7
        pub type R = crate::R<u32, super::CCR7>;
        ///Writer for register CCR7
        pub type W = crate::W<u32, super::CCR7>;
        ///Register CCR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr7](cndtr7) module
    pub type CNDTR7 = crate::Reg<u32, _CNDTR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR7;
    ///`read()` method returns [cndtr7::R](cndtr7::R) reader structure
    impl crate::Readable for CNDTR7 {}
    ///`write(|w| ..)` method takes [cndtr7::W](cndtr7::W) writer structure
    impl crate::Writable for CNDTR7 {}
    ///channel x number of data register
    pub mod cndtr7 {
        ///Reader of register CNDTR7
        pub type R = crate::R<u32, super::CNDTR7>;
        ///Writer for register CNDTR7
        pub type W = crate::W<u32, super::CNDTR7>;
        ///Register CNDTR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar7](cpar7) module
    pub type CPAR7 = crate::Reg<u32, _CPAR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR7;
    ///`read()` method returns [cpar7::R](cpar7::R) reader structure
    impl crate::Readable for CPAR7 {}
    ///`write(|w| ..)` method takes [cpar7::W](cpar7::W) writer structure
    impl crate::Writable for CPAR7 {}
    ///channel x peripheral address register
    pub mod cpar7 {
        ///Reader of register CPAR7
        pub type R = crate::R<u32, super::CPAR7>;
        ///Writer for register CPAR7
        pub type W = crate::W<u32, super::CPAR7>;
        ///Register CPAR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar7](cmar7) module
    pub type CMAR7 = crate::Reg<u32, _CMAR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR7;
    ///`read()` method returns [cmar7::R](cmar7::R) reader structure
    impl crate::Readable for CMAR7 {}
    ///`write(|w| ..)` method takes [cmar7::W](cmar7::W) writer structure
    impl crate::Writable for CMAR7 {}
    ///channel x memory address register
    pub mod cmar7 {
        ///Reader of register CMAR7
        pub type R = crate::R<u32, super::CMAR7>;
        ///Writer for register CMAR7
        pub type W = crate::W<u32, super::CMAR7>;
        ///Register CMAR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
}
///Direct memory access controller
pub struct DMA2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA2 {}
impl DMA2 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dma2::RegisterBlock {
        0x4002_0400 as *const _
    }
}
impl Deref for DMA2 {
    type Target = dma2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DMA2::ptr() }
    }
}
///Direct memory access controller
pub mod dma2 {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - interrupt status register
        pub isr: ISR,
        ///0x04 - interrupt flag clear register
        pub ifcr: IFCR,
        ///0x08 - channel x configuration register
        pub ccr1: CCR1,
        ///0x0c - channel x number of data register
        pub cndtr1: CNDTR1,
        ///0x10 - channel x peripheral address register
        pub cpar1: CPAR1,
        ///0x14 - channel x memory address register
        pub cmar1: CMAR1,
        _reserved6: [u8; 4usize],
        ///0x1c - channel x configuration register
        pub ccr2: CCR2,
        ///0x20 - channel x number of data register
        pub cndtr2: CNDTR2,
        ///0x24 - channel x peripheral address register
        pub cpar2: CPAR2,
        ///0x28 - channel x memory address register
        pub cmar2: CMAR2,
        _reserved10: [u8; 4usize],
        ///0x30 - channel x configuration register
        pub ccr3: CCR3,
        ///0x34 - channel x number of data register
        pub cndtr3: CNDTR3,
        ///0x38 - channel x peripheral address register
        pub cpar3: CPAR3,
        ///0x3c - channel x memory address register
        pub cmar3: CMAR3,
        _reserved14: [u8; 4usize],
        ///0x44 - channel x configuration register
        pub ccr4: CCR4,
        ///0x48 - channel x number of data register
        pub cndtr4: CNDTR4,
        ///0x4c - channel x peripheral address register
        pub cpar4: CPAR4,
        ///0x50 - channel x memory address register
        pub cmar4: CMAR4,
        _reserved18: [u8; 4usize],
        ///0x58 - channel x configuration register
        pub ccr5: CCR5,
        ///0x5c - channel x number of data register
        pub cndtr5: CNDTR5,
        ///0x60 - channel x peripheral address register
        pub cpar5: CPAR5,
        ///0x64 - channel x memory address register
        pub cmar5: CMAR5,
        _reserved22: [u8; 4usize],
        ///0x6c - channel x configuration register
        pub ccr6: CCR6,
        ///0x70 - channel x number of data register
        pub cndtr6: CNDTR6,
        ///0x74 - channel x peripheral address register
        pub cpar6: CPAR6,
        ///0x78 - channel x memory address register
        pub cmar6: CMAR6,
        _reserved26: [u8; 4usize],
        ///0x80 - channel x configuration register
        pub ccr7: CCR7,
        ///0x84 - channel x number of data register
        pub cndtr7: CNDTR7,
        ///0x88 - channel x peripheral address register
        pub cpar7: CPAR7,
        ///0x8c - channel x memory address register
        pub cmar7: CMAR7,
        _reserved30: [u8; 24usize],
        ///0xa8 - channel selection register
        pub cselr: CSELR,
    }
    ///interrupt status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [isr](isr) module
    pub type ISR = crate::Reg<u32, _ISR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ISR;
    ///`read()` method returns [isr::R](isr::R) reader structure
    impl crate::Readable for ISR {}
    ///interrupt status register
    pub mod isr {
        ///Reader of register ISR
        pub type R = crate::R<u32, super::ISR>;
        ///Reader of field `TEIF7`
        pub type TEIF7_R = crate::R<bool, bool>;
        ///Reader of field `HTIF7`
        pub type HTIF7_R = crate::R<bool, bool>;
        ///Reader of field `TCIF7`
        pub type TCIF7_R = crate::R<bool, bool>;
        ///Reader of field `GIF7`
        pub type GIF7_R = crate::R<bool, bool>;
        ///Reader of field `TEIF6`
        pub type TEIF6_R = crate::R<bool, bool>;
        ///Reader of field `HTIF6`
        pub type HTIF6_R = crate::R<bool, bool>;
        ///Reader of field `TCIF6`
        pub type TCIF6_R = crate::R<bool, bool>;
        ///Reader of field `GIF6`
        pub type GIF6_R = crate::R<bool, bool>;
        ///Reader of field `TEIF5`
        pub type TEIF5_R = crate::R<bool, bool>;
        ///Reader of field `HTIF5`
        pub type HTIF5_R = crate::R<bool, bool>;
        ///Reader of field `TCIF5`
        pub type TCIF5_R = crate::R<bool, bool>;
        ///Reader of field `GIF5`
        pub type GIF5_R = crate::R<bool, bool>;
        ///Reader of field `TEIF4`
        pub type TEIF4_R = crate::R<bool, bool>;
        ///Reader of field `HTIF4`
        pub type HTIF4_R = crate::R<bool, bool>;
        ///Reader of field `TCIF4`
        pub type TCIF4_R = crate::R<bool, bool>;
        ///Reader of field `GIF4`
        pub type GIF4_R = crate::R<bool, bool>;
        ///Reader of field `TEIF3`
        pub type TEIF3_R = crate::R<bool, bool>;
        ///Reader of field `HTIF3`
        pub type HTIF3_R = crate::R<bool, bool>;
        ///Reader of field `TCIF3`
        pub type TCIF3_R = crate::R<bool, bool>;
        ///Reader of field `GIF3`
        pub type GIF3_R = crate::R<bool, bool>;
        ///Reader of field `TEIF2`
        pub type TEIF2_R = crate::R<bool, bool>;
        ///Reader of field `HTIF2`
        pub type HTIF2_R = crate::R<bool, bool>;
        ///Reader of field `TCIF2`
        pub type TCIF2_R = crate::R<bool, bool>;
        ///Reader of field `GIF2`
        pub type GIF2_R = crate::R<bool, bool>;
        ///Reader of field `TEIF1`
        pub type TEIF1_R = crate::R<bool, bool>;
        ///Reader of field `HTIF1`
        pub type HTIF1_R = crate::R<bool, bool>;
        ///Reader of field `TCIF1`
        pub type TCIF1_R = crate::R<bool, bool>;
        ///Reader of field `GIF1`
        pub type GIF1_R = crate::R<bool, bool>;
        impl R {
            ///Bit 27 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif7(&self) -> TEIF7_R {
                TEIF7_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif7(&self) -> HTIF7_R {
                HTIF7_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif7(&self) -> TCIF7_R {
                TCIF7_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif7(&self) -> GIF7_R {
                GIF7_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif6(&self) -> TEIF6_R {
                TEIF6_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif6(&self) -> HTIF6_R {
                HTIF6_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif6(&self) -> TCIF6_R {
                TCIF6_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif6(&self) -> GIF6_R {
                GIF6_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif5(&self) -> TEIF5_R {
                TEIF5_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif5(&self) -> HTIF5_R {
                HTIF5_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif5(&self) -> TCIF5_R {
                TCIF5_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif5(&self) -> GIF5_R {
                GIF5_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif4(&self) -> TEIF4_R {
                TEIF4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif4(&self) -> HTIF4_R {
                HTIF4_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif4(&self) -> TCIF4_R {
                TCIF4_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif4(&self) -> GIF4_R {
                GIF4_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif3(&self) -> TEIF3_R {
                TEIF3_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif3(&self) -> HTIF3_R {
                HTIF3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif3(&self) -> TCIF3_R {
                TCIF3_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif3(&self) -> GIF3_R {
                GIF3_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif2(&self) -> TEIF2_R {
                TEIF2_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif2(&self) -> HTIF2_R {
                HTIF2_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif2(&self) -> TCIF2_R {
                TCIF2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif2(&self) -> GIF2_R {
                GIF2_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif1(&self) -> TEIF1_R {
                TEIF1_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif1(&self) -> HTIF1_R {
                HTIF1_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif1(&self) -> TCIF1_R {
                TCIF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif1(&self) -> GIF1_R {
                GIF1_R::new((self.bits & 0x01) != 0)
            }
        }
    }
    ///interrupt flag clear register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ifcr](ifcr) module
    pub type IFCR = crate::Reg<u32, _IFCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IFCR;
    ///`write(|w| ..)` method takes [ifcr::W](ifcr::W) writer structure
    impl crate::Writable for IFCR {}
    ///interrupt flag clear register
    pub mod ifcr {
        ///Writer for register IFCR
        pub type W = crate::W<u32, super::IFCR>;
        ///Register IFCR `reset()`'s with value 0
        impl crate::ResetValue for super::IFCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `CTEIF7`
        pub struct CTEIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Write proxy for field `CHTIF7`
        pub struct CHTIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Write proxy for field `CTCIF7`
        pub struct CTCIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Write proxy for field `CGIF7`
        pub struct CGIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Write proxy for field `CTEIF6`
        pub struct CTEIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Write proxy for field `CHTIF6`
        pub struct CHTIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Write proxy for field `CTCIF6`
        pub struct CTCIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Write proxy for field `CGIF6`
        pub struct CGIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Write proxy for field `CTEIF5`
        pub struct CTEIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Write proxy for field `CHTIF5`
        pub struct CHTIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Write proxy for field `CTCIF5`
        pub struct CTCIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Write proxy for field `CGIF5`
        pub struct CGIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Write proxy for field `CTEIF4`
        pub struct CTEIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Write proxy for field `CHTIF4`
        pub struct CHTIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Write proxy for field `CTCIF4`
        pub struct CTCIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Write proxy for field `CGIF4`
        pub struct CGIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Write proxy for field `CTEIF3`
        pub struct CTEIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Write proxy for field `CHTIF3`
        pub struct CHTIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Write proxy for field `CTCIF3`
        pub struct CTCIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Write proxy for field `CGIF3`
        pub struct CGIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Write proxy for field `CTEIF2`
        pub struct CTEIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Write proxy for field `CHTIF2`
        pub struct CHTIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Write proxy for field `CTCIF2`
        pub struct CTCIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Write proxy for field `CGIF2`
        pub struct CGIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Write proxy for field `CTEIF1`
        pub struct CTEIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Write proxy for field `CHTIF1`
        pub struct CHTIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Write proxy for field `CTCIF1`
        pub struct CTCIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Write proxy for field `CGIF1`
        pub struct CGIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl W {
            ///Bit 27 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif7(&mut self) -> CTEIF7_W {
                CTEIF7_W { w: self }
            }
            ///Bit 26 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif7(&mut self) -> CHTIF7_W {
                CHTIF7_W { w: self }
            }
            ///Bit 25 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif7(&mut self) -> CTCIF7_W {
                CTCIF7_W { w: self }
            }
            ///Bit 24 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif7(&mut self) -> CGIF7_W {
                CGIF7_W { w: self }
            }
            ///Bit 23 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif6(&mut self) -> CTEIF6_W {
                CTEIF6_W { w: self }
            }
            ///Bit 22 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif6(&mut self) -> CHTIF6_W {
                CHTIF6_W { w: self }
            }
            ///Bit 21 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif6(&mut self) -> CTCIF6_W {
                CTCIF6_W { w: self }
            }
            ///Bit 20 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif6(&mut self) -> CGIF6_W {
                CGIF6_W { w: self }
            }
            ///Bit 19 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif5(&mut self) -> CTEIF5_W {
                CTEIF5_W { w: self }
            }
            ///Bit 18 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif5(&mut self) -> CHTIF5_W {
                CHTIF5_W { w: self }
            }
            ///Bit 17 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif5(&mut self) -> CTCIF5_W {
                CTCIF5_W { w: self }
            }
            ///Bit 16 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif5(&mut self) -> CGIF5_W {
                CGIF5_W { w: self }
            }
            ///Bit 15 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif4(&mut self) -> CTEIF4_W {
                CTEIF4_W { w: self }
            }
            ///Bit 14 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif4(&mut self) -> CHTIF4_W {
                CHTIF4_W { w: self }
            }
            ///Bit 13 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif4(&mut self) -> CTCIF4_W {
                CTCIF4_W { w: self }
            }
            ///Bit 12 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif4(&mut self) -> CGIF4_W {
                CGIF4_W { w: self }
            }
            ///Bit 11 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif3(&mut self) -> CTEIF3_W {
                CTEIF3_W { w: self }
            }
            ///Bit 10 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif3(&mut self) -> CHTIF3_W {
                CHTIF3_W { w: self }
            }
            ///Bit 9 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif3(&mut self) -> CTCIF3_W {
                CTCIF3_W { w: self }
            }
            ///Bit 8 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif3(&mut self) -> CGIF3_W {
                CGIF3_W { w: self }
            }
            ///Bit 7 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif2(&mut self) -> CTEIF2_W {
                CTEIF2_W { w: self }
            }
            ///Bit 6 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif2(&mut self) -> CHTIF2_W {
                CHTIF2_W { w: self }
            }
            ///Bit 5 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif2(&mut self) -> CTCIF2_W {
                CTCIF2_W { w: self }
            }
            ///Bit 4 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif2(&mut self) -> CGIF2_W {
                CGIF2_W { w: self }
            }
            ///Bit 3 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif1(&mut self) -> CTEIF1_W {
                CTEIF1_W { w: self }
            }
            ///Bit 2 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif1(&mut self) -> CHTIF1_W {
                CHTIF1_W { w: self }
            }
            ///Bit 1 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif1(&mut self) -> CTCIF1_W {
                CTCIF1_W { w: self }
            }
            ///Bit 0 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif1(&mut self) -> CGIF1_W {
                CGIF1_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr1](ccr1) module
    pub type CCR1 = crate::Reg<u32, _CCR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR1;
    ///`read()` method returns [ccr1::R](ccr1::R) reader structure
    impl crate::Readable for CCR1 {}
    ///`write(|w| ..)` method takes [ccr1::W](ccr1::W) writer structure
    impl crate::Writable for CCR1 {}
    ///channel x configuration register
    pub mod ccr1 {
        ///Reader of register CCR1
        pub type R = crate::R<u32, super::CCR1>;
        ///Writer for register CCR1
        pub type W = crate::W<u32, super::CCR1>;
        ///Register CCR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr1](cndtr1) module
    pub type CNDTR1 = crate::Reg<u32, _CNDTR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR1;
    ///`read()` method returns [cndtr1::R](cndtr1::R) reader structure
    impl crate::Readable for CNDTR1 {}
    ///`write(|w| ..)` method takes [cndtr1::W](cndtr1::W) writer structure
    impl crate::Writable for CNDTR1 {}
    ///channel x number of data register
    pub mod cndtr1 {
        ///Reader of register CNDTR1
        pub type R = crate::R<u32, super::CNDTR1>;
        ///Writer for register CNDTR1
        pub type W = crate::W<u32, super::CNDTR1>;
        ///Register CNDTR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar1](cpar1) module
    pub type CPAR1 = crate::Reg<u32, _CPAR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR1;
    ///`read()` method returns [cpar1::R](cpar1::R) reader structure
    impl crate::Readable for CPAR1 {}
    ///`write(|w| ..)` method takes [cpar1::W](cpar1::W) writer structure
    impl crate::Writable for CPAR1 {}
    ///channel x peripheral address register
    pub mod cpar1 {
        ///Reader of register CPAR1
        pub type R = crate::R<u32, super::CPAR1>;
        ///Writer for register CPAR1
        pub type W = crate::W<u32, super::CPAR1>;
        ///Register CPAR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar1](cmar1) module
    pub type CMAR1 = crate::Reg<u32, _CMAR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR1;
    ///`read()` method returns [cmar1::R](cmar1::R) reader structure
    impl crate::Readable for CMAR1 {}
    ///`write(|w| ..)` method takes [cmar1::W](cmar1::W) writer structure
    impl crate::Writable for CMAR1 {}
    ///channel x memory address register
    pub mod cmar1 {
        ///Reader of register CMAR1
        pub type R = crate::R<u32, super::CMAR1>;
        ///Writer for register CMAR1
        pub type W = crate::W<u32, super::CMAR1>;
        ///Register CMAR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr2](ccr2) module
    pub type CCR2 = crate::Reg<u32, _CCR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR2;
    ///`read()` method returns [ccr2::R](ccr2::R) reader structure
    impl crate::Readable for CCR2 {}
    ///`write(|w| ..)` method takes [ccr2::W](ccr2::W) writer structure
    impl crate::Writable for CCR2 {}
    ///channel x configuration register
    pub mod ccr2 {
        ///Reader of register CCR2
        pub type R = crate::R<u32, super::CCR2>;
        ///Writer for register CCR2
        pub type W = crate::W<u32, super::CCR2>;
        ///Register CCR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr2](cndtr2) module
    pub type CNDTR2 = crate::Reg<u32, _CNDTR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR2;
    ///`read()` method returns [cndtr2::R](cndtr2::R) reader structure
    impl crate::Readable for CNDTR2 {}
    ///`write(|w| ..)` method takes [cndtr2::W](cndtr2::W) writer structure
    impl crate::Writable for CNDTR2 {}
    ///channel x number of data register
    pub mod cndtr2 {
        ///Reader of register CNDTR2
        pub type R = crate::R<u32, super::CNDTR2>;
        ///Writer for register CNDTR2
        pub type W = crate::W<u32, super::CNDTR2>;
        ///Register CNDTR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar2](cpar2) module
    pub type CPAR2 = crate::Reg<u32, _CPAR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR2;
    ///`read()` method returns [cpar2::R](cpar2::R) reader structure
    impl crate::Readable for CPAR2 {}
    ///`write(|w| ..)` method takes [cpar2::W](cpar2::W) writer structure
    impl crate::Writable for CPAR2 {}
    ///channel x peripheral address register
    pub mod cpar2 {
        ///Reader of register CPAR2
        pub type R = crate::R<u32, super::CPAR2>;
        ///Writer for register CPAR2
        pub type W = crate::W<u32, super::CPAR2>;
        ///Register CPAR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar2](cmar2) module
    pub type CMAR2 = crate::Reg<u32, _CMAR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR2;
    ///`read()` method returns [cmar2::R](cmar2::R) reader structure
    impl crate::Readable for CMAR2 {}
    ///`write(|w| ..)` method takes [cmar2::W](cmar2::W) writer structure
    impl crate::Writable for CMAR2 {}
    ///channel x memory address register
    pub mod cmar2 {
        ///Reader of register CMAR2
        pub type R = crate::R<u32, super::CMAR2>;
        ///Writer for register CMAR2
        pub type W = crate::W<u32, super::CMAR2>;
        ///Register CMAR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr3](ccr3) module
    pub type CCR3 = crate::Reg<u32, _CCR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR3;
    ///`read()` method returns [ccr3::R](ccr3::R) reader structure
    impl crate::Readable for CCR3 {}
    ///`write(|w| ..)` method takes [ccr3::W](ccr3::W) writer structure
    impl crate::Writable for CCR3 {}
    ///channel x configuration register
    pub mod ccr3 {
        ///Reader of register CCR3
        pub type R = crate::R<u32, super::CCR3>;
        ///Writer for register CCR3
        pub type W = crate::W<u32, super::CCR3>;
        ///Register CCR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr3](cndtr3) module
    pub type CNDTR3 = crate::Reg<u32, _CNDTR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR3;
    ///`read()` method returns [cndtr3::R](cndtr3::R) reader structure
    impl crate::Readable for CNDTR3 {}
    ///`write(|w| ..)` method takes [cndtr3::W](cndtr3::W) writer structure
    impl crate::Writable for CNDTR3 {}
    ///channel x number of data register
    pub mod cndtr3 {
        ///Reader of register CNDTR3
        pub type R = crate::R<u32, super::CNDTR3>;
        ///Writer for register CNDTR3
        pub type W = crate::W<u32, super::CNDTR3>;
        ///Register CNDTR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar3](cpar3) module
    pub type CPAR3 = crate::Reg<u32, _CPAR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR3;
    ///`read()` method returns [cpar3::R](cpar3::R) reader structure
    impl crate::Readable for CPAR3 {}
    ///`write(|w| ..)` method takes [cpar3::W](cpar3::W) writer structure
    impl crate::Writable for CPAR3 {}
    ///channel x peripheral address register
    pub mod cpar3 {
        ///Reader of register CPAR3
        pub type R = crate::R<u32, super::CPAR3>;
        ///Writer for register CPAR3
        pub type W = crate::W<u32, super::CPAR3>;
        ///Register CPAR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar3](cmar3) module
    pub type CMAR3 = crate::Reg<u32, _CMAR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR3;
    ///`read()` method returns [cmar3::R](cmar3::R) reader structure
    impl crate::Readable for CMAR3 {}
    ///`write(|w| ..)` method takes [cmar3::W](cmar3::W) writer structure
    impl crate::Writable for CMAR3 {}
    ///channel x memory address register
    pub mod cmar3 {
        ///Reader of register CMAR3
        pub type R = crate::R<u32, super::CMAR3>;
        ///Writer for register CMAR3
        pub type W = crate::W<u32, super::CMAR3>;
        ///Register CMAR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr4](ccr4) module
    pub type CCR4 = crate::Reg<u32, _CCR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR4;
    ///`read()` method returns [ccr4::R](ccr4::R) reader structure
    impl crate::Readable for CCR4 {}
    ///`write(|w| ..)` method takes [ccr4::W](ccr4::W) writer structure
    impl crate::Writable for CCR4 {}
    ///channel x configuration register
    pub mod ccr4 {
        ///Reader of register CCR4
        pub type R = crate::R<u32, super::CCR4>;
        ///Writer for register CCR4
        pub type W = crate::W<u32, super::CCR4>;
        ///Register CCR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr4](cndtr4) module
    pub type CNDTR4 = crate::Reg<u32, _CNDTR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR4;
    ///`read()` method returns [cndtr4::R](cndtr4::R) reader structure
    impl crate::Readable for CNDTR4 {}
    ///`write(|w| ..)` method takes [cndtr4::W](cndtr4::W) writer structure
    impl crate::Writable for CNDTR4 {}
    ///channel x number of data register
    pub mod cndtr4 {
        ///Reader of register CNDTR4
        pub type R = crate::R<u32, super::CNDTR4>;
        ///Writer for register CNDTR4
        pub type W = crate::W<u32, super::CNDTR4>;
        ///Register CNDTR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar4](cpar4) module
    pub type CPAR4 = crate::Reg<u32, _CPAR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR4;
    ///`read()` method returns [cpar4::R](cpar4::R) reader structure
    impl crate::Readable for CPAR4 {}
    ///`write(|w| ..)` method takes [cpar4::W](cpar4::W) writer structure
    impl crate::Writable for CPAR4 {}
    ///channel x peripheral address register
    pub mod cpar4 {
        ///Reader of register CPAR4
        pub type R = crate::R<u32, super::CPAR4>;
        ///Writer for register CPAR4
        pub type W = crate::W<u32, super::CPAR4>;
        ///Register CPAR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar4](cmar4) module
    pub type CMAR4 = crate::Reg<u32, _CMAR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR4;
    ///`read()` method returns [cmar4::R](cmar4::R) reader structure
    impl crate::Readable for CMAR4 {}
    ///`write(|w| ..)` method takes [cmar4::W](cmar4::W) writer structure
    impl crate::Writable for CMAR4 {}
    ///channel x memory address register
    pub mod cmar4 {
        ///Reader of register CMAR4
        pub type R = crate::R<u32, super::CMAR4>;
        ///Writer for register CMAR4
        pub type W = crate::W<u32, super::CMAR4>;
        ///Register CMAR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr5](ccr5) module
    pub type CCR5 = crate::Reg<u32, _CCR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR5;
    ///`read()` method returns [ccr5::R](ccr5::R) reader structure
    impl crate::Readable for CCR5 {}
    ///`write(|w| ..)` method takes [ccr5::W](ccr5::W) writer structure
    impl crate::Writable for CCR5 {}
    ///channel x configuration register
    pub mod ccr5 {
        ///Reader of register CCR5
        pub type R = crate::R<u32, super::CCR5>;
        ///Writer for register CCR5
        pub type W = crate::W<u32, super::CCR5>;
        ///Register CCR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr5](cndtr5) module
    pub type CNDTR5 = crate::Reg<u32, _CNDTR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR5;
    ///`read()` method returns [cndtr5::R](cndtr5::R) reader structure
    impl crate::Readable for CNDTR5 {}
    ///`write(|w| ..)` method takes [cndtr5::W](cndtr5::W) writer structure
    impl crate::Writable for CNDTR5 {}
    ///channel x number of data register
    pub mod cndtr5 {
        ///Reader of register CNDTR5
        pub type R = crate::R<u32, super::CNDTR5>;
        ///Writer for register CNDTR5
        pub type W = crate::W<u32, super::CNDTR5>;
        ///Register CNDTR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar5](cpar5) module
    pub type CPAR5 = crate::Reg<u32, _CPAR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR5;
    ///`read()` method returns [cpar5::R](cpar5::R) reader structure
    impl crate::Readable for CPAR5 {}
    ///`write(|w| ..)` method takes [cpar5::W](cpar5::W) writer structure
    impl crate::Writable for CPAR5 {}
    ///channel x peripheral address register
    pub mod cpar5 {
        ///Reader of register CPAR5
        pub type R = crate::R<u32, super::CPAR5>;
        ///Writer for register CPAR5
        pub type W = crate::W<u32, super::CPAR5>;
        ///Register CPAR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar5](cmar5) module
    pub type CMAR5 = crate::Reg<u32, _CMAR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR5;
    ///`read()` method returns [cmar5::R](cmar5::R) reader structure
    impl crate::Readable for CMAR5 {}
    ///`write(|w| ..)` method takes [cmar5::W](cmar5::W) writer structure
    impl crate::Writable for CMAR5 {}
    ///channel x memory address register
    pub mod cmar5 {
        ///Reader of register CMAR5
        pub type R = crate::R<u32, super::CMAR5>;
        ///Writer for register CMAR5
        pub type W = crate::W<u32, super::CMAR5>;
        ///Register CMAR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr6](ccr6) module
    pub type CCR6 = crate::Reg<u32, _CCR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR6;
    ///`read()` method returns [ccr6::R](ccr6::R) reader structure
    impl crate::Readable for CCR6 {}
    ///`write(|w| ..)` method takes [ccr6::W](ccr6::W) writer structure
    impl crate::Writable for CCR6 {}
    ///channel x configuration register
    pub mod ccr6 {
        ///Reader of register CCR6
        pub type R = crate::R<u32, super::CCR6>;
        ///Writer for register CCR6
        pub type W = crate::W<u32, super::CCR6>;
        ///Register CCR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr6](cndtr6) module
    pub type CNDTR6 = crate::Reg<u32, _CNDTR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR6;
    ///`read()` method returns [cndtr6::R](cndtr6::R) reader structure
    impl crate::Readable for CNDTR6 {}
    ///`write(|w| ..)` method takes [cndtr6::W](cndtr6::W) writer structure
    impl crate::Writable for CNDTR6 {}
    ///channel x number of data register
    pub mod cndtr6 {
        ///Reader of register CNDTR6
        pub type R = crate::R<u32, super::CNDTR6>;
        ///Writer for register CNDTR6
        pub type W = crate::W<u32, super::CNDTR6>;
        ///Register CNDTR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar6](cpar6) module
    pub type CPAR6 = crate::Reg<u32, _CPAR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR6;
    ///`read()` method returns [cpar6::R](cpar6::R) reader structure
    impl crate::Readable for CPAR6 {}
    ///`write(|w| ..)` method takes [cpar6::W](cpar6::W) writer structure
    impl crate::Writable for CPAR6 {}
    ///channel x peripheral address register
    pub mod cpar6 {
        ///Reader of register CPAR6
        pub type R = crate::R<u32, super::CPAR6>;
        ///Writer for register CPAR6
        pub type W = crate::W<u32, super::CPAR6>;
        ///Register CPAR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar6](cmar6) module
    pub type CMAR6 = crate::Reg<u32, _CMAR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR6;
    ///`read()` method returns [cmar6::R](cmar6::R) reader structure
    impl crate::Readable for CMAR6 {}
    ///`write(|w| ..)` method takes [cmar6::W](cmar6::W) writer structure
    impl crate::Writable for CMAR6 {}
    ///channel x memory address register
    pub mod cmar6 {
        ///Reader of register CMAR6
        pub type R = crate::R<u32, super::CMAR6>;
        ///Writer for register CMAR6
        pub type W = crate::W<u32, super::CMAR6>;
        ///Register CMAR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr7](ccr7) module
    pub type CCR7 = crate::Reg<u32, _CCR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR7;
    ///`read()` method returns [ccr7::R](ccr7::R) reader structure
    impl crate::Readable for CCR7 {}
    ///`write(|w| ..)` method takes [ccr7::W](ccr7::W) writer structure
    impl crate::Writable for CCR7 {}
    ///channel x configuration register
    pub mod ccr7 {
        ///Reader of register CCR7
        pub type R = crate::R<u32, super::CCR7>;
        ///Writer for register CCR7
        pub type W = crate::W<u32, super::CCR7>;
        ///Register CCR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, bool>;
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, u8>;
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, bool>;
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, bool>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, bool>;
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, bool>;
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, bool>;
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, bool>;
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr7](cndtr7) module
    pub type CNDTR7 = crate::Reg<u32, _CNDTR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR7;
    ///`read()` method returns [cndtr7::R](cndtr7::R) reader structure
    impl crate::Readable for CNDTR7 {}
    ///`write(|w| ..)` method takes [cndtr7::W](cndtr7::W) writer structure
    impl crate::Writable for CNDTR7 {}
    ///channel x number of data register
    pub mod cndtr7 {
        ///Reader of register CNDTR7
        pub type R = crate::R<u32, super::CNDTR7>;
        ///Writer for register CNDTR7
        pub type W = crate::W<u32, super::CNDTR7>;
        ///Register CNDTR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar7](cpar7) module
    pub type CPAR7 = crate::Reg<u32, _CPAR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR7;
    ///`read()` method returns [cpar7::R](cpar7::R) reader structure
    impl crate::Readable for CPAR7 {}
    ///`write(|w| ..)` method takes [cpar7::W](cpar7::W) writer structure
    impl crate::Writable for CPAR7 {}
    ///channel x peripheral address register
    pub mod cpar7 {
        ///Reader of register CPAR7
        pub type R = crate::R<u32, super::CPAR7>;
        ///Writer for register CPAR7
        pub type W = crate::W<u32, super::CPAR7>;
        ///Register CPAR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar7](cmar7) module
    pub type CMAR7 = crate::Reg<u32, _CMAR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR7;
    ///`read()` method returns [cmar7::R](cmar7::R) reader structure
    impl crate::Readable for CMAR7 {}
    ///`write(|w| ..)` method takes [cmar7::W](cmar7::W) writer structure
    impl crate::Writable for CMAR7 {}
    ///channel x memory address register
    pub mod cmar7 {
        ///Reader of register CMAR7
        pub type R = crate::R<u32, super::CMAR7>;
        ///Writer for register CMAR7
        pub type W = crate::W<u32, super::CMAR7>;
        ///Register CMAR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel selection register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cselr](cselr) module
    pub type CSELR = crate::Reg<u32, _CSELR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CSELR;
    ///`read()` method returns [cselr::R](cselr::R) reader structure
    impl crate::Readable for CSELR {}
    ///`write(|w| ..)` method takes [cselr::W](cselr::W) writer structure
    impl crate::Writable for CSELR {}
    ///channel selection register
    pub mod cselr {
        ///Reader of register CSELR
        pub type R = crate::R<u32, super::CSELR>;
        ///Writer for register CSELR
        pub type W = crate::W<u32, super::CSELR>;
        ///Register CSELR `reset()`'s with value 0
        impl crate::ResetValue for super::CSELR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `C7S`
        pub type C7S_R = crate::R<u8, u8>;
        ///Write proxy for field `C7S`
        pub struct C7S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C7S_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 24)) | (((value as u32) & 0x0f) << 24);
                self.w
            }
        }
        ///Reader of field `C6S`
        pub type C6S_R = crate::R<u8, u8>;
        ///Write proxy for field `C6S`
        pub struct C6S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C6S_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 20)) | (((value as u32) & 0x0f) << 20);
                self.w
            }
        }
        ///Reader of field `C5S`
        pub type C5S_R = crate::R<u8, u8>;
        ///Write proxy for field `C5S`
        pub struct C5S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C5S_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 16)) | (((value as u32) & 0x0f) << 16);
                self.w
            }
        }
        ///Reader of field `C4S`
        pub type C4S_R = crate::R<u8, u8>;
        ///Write proxy for field `C4S`
        pub struct C4S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C4S_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 12)) | (((value as u32) & 0x0f) << 12);
                self.w
            }
        }
        ///Reader of field `C3S`
        pub type C3S_R = crate::R<u8, u8>;
        ///Write proxy for field `C3S`
        pub struct C3S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C3S_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 8)) | (((value as u32) & 0x0f) << 8);
                self.w
            }
        }
        ///Reader of field `C2S`
        pub type C2S_R = crate::R<u8, u8>;
        ///Write proxy for field `C2S`
        pub struct C2S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C2S_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 4)) | (((value as u32) & 0x0f) << 4);
                self.w
            }
        }
        ///Reader of field `C1S`
        pub type C1S_R = crate::R<u8, u8>;
        ///Write proxy for field `C1S`
        pub struct C1S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C1S_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | ((value as u32) & 0x0f);
                self.w
            }
        }
        impl R {
            ///Bits 24:27 - DMA channel 7 selection
            #[inline(always)]
            pub fn c7s(&self) -> C7S_R {
                C7S_R::new(((self.bits >> 24) & 0x0f) as u8)
            }
            ///Bits 20:23 - DMA channel 6 selection
            #[inline(always)]
            pub fn c6s(&self) -> C6S_R {
                C6S_R::new(((self.bits >> 20) & 0x0f) as u8)
            }
            ///Bits 16:19 - DMA channel 5 selection
            #[inline(always)]
            pub fn c5s(&self) -> C5S_R {
                C5S_R::new(((self.bits >> 16) & 0x0f) as u8)
            }
            ///Bits 12:15 - DMA channel 4 selection
            #[inline(always)]
            pub fn c4s(&self) -> C4S_R {
                C4S_R::new(((self.bits >> 12) & 0x0f) as u8)
            }
            ///Bits 8:11 - DMA channel 3 selection
            #[inline(always)]
            pub fn c3s(&self) -> C3S_R {
                C3S_R::new(((self.bits >> 8) & 0x0f) as u8)
            }
            ///Bits 4:7 - DMA channel 2 selection
            #[inline(always)]
            pub fn c2s(&self) -> C2S_R {
                C2S_R::new(((self.bits >> 4) & 0x0f) as u8)
            }
            ///Bits 0:3 - DMA channel 1 selection
            #[inline(always)]
            pub fn c1s(&self) -> C1S_R {
                C1S_R::new((self.bits & 0x0f) as u8)
            }
        }
        impl W {
            ///Bits 24:27 - DMA channel 7 selection
            #[inline(always)]
            pub fn c7s(&mut self) -> C7S_W {
                C7S_W { w: self }
            }
            ///Bits 20:23 - DMA channel 6 selection
            #[inline(always)]
            pub fn c6s(&mut self) -> C6S_W {
                C6S_W { w: self }
            }
            ///Bits 16:19 - DMA channel 5 selection
            #[inline(always)]
            pub fn c5s(&mut self) -> C5S_W {
                C5S_W { w: self }
            }
            ///Bits 12:15 - DMA channel 4 selection
            #[inline(always)]
            pub fn c4s(&mut self) -> C4S_W {
                C4S_W { w: self }
            }
            ///Bits 8:11 - DMA channel 3 selection
            #[inline(always)]
            pub fn c3s(&mut self) -> C3S_W {
                C3S_W { w: self }
            }
            ///Bits 4:7 - DMA channel 2 selection
            #[inline(always)]
            pub fn c2s(&mut self) -> C2S_W {
                C2S_W { w: self }
            }
            ///Bits 0:3 - DMA channel 1 selection
            #[inline(always)]
            pub fn c1s(&mut self) -> C1S_W {
                C1S_W { w: self }
            }
        }
    }
}
///Direct memory access Multiplexer
pub struct DMAMUX1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMAMUX1 {}
impl DMAMUX1 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dmamux1::RegisterBlock {
        0x4002_0800 as *const _
    }
}
impl Deref for DMAMUX1 {
    type Target = dmamux1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DMAMUX1::ptr() }
    }
}
///Direct memory access Multiplexer
pub mod dmamux1 {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - DMA Multiplexer Channel 0 Control register
        pub c0cr: C0CR,
        ///0x04 - DMA Multiplexer Channel 1 Control register
        pub c1cr: C1CR,
        ///0x08 - DMA Multiplexer Channel 2 Control register
        pub c2cr: C2CR,
        ///0x0c - DMA Multiplexer Channel 3 Control register
        pub c3cr: C3CR,
        ///0x10 - DMA Multiplexer Channel 4 Control register
        pub c4cr: C4CR,
        ///0x14 - DMA Multiplexer Channel 5 Control register
        pub c5cr: C5CR,
        ///0x18 - DMA Multiplexer Channel 6 Control register
        pub c6cr: C6CR,
        ///0x1c - DMA Multiplexer Channel 7 Control register
        pub c7cr: C7CR,
        ///0x20 - DMA Multiplexer Channel 8 Control register
        pub c8cr: C8CR,
        ///0x24 - DMA Multiplexer Channel 9 Control register
        pub c9cr: C9CR,
        ///0x28 - DMA Multiplexer Channel 10 Control register
        pub c10cr: C10CR,
        ///0x2c - DMA Multiplexer Channel 11 Control register
        pub c11cr: C11CR,
        ///0x30 - DMA Multiplexer Channel 12 Control register
        pub c12cr: C12CR,
        ///0x34 - DMA Multiplexer Channel 13 Control register
        pub c13cr: C13CR,
        _reserved14: [u8; 72usize],
        ///0x80 - DMA Multiplexer Channel Status register
        pub csr: CSR,
        ///0x84 - DMA Channel Clear Flag Register
        pub cfr: CFR,
        _reserved16: [u8; 120usize],
        ///0x100 - DMA Request Generator 0 Control Register
        pub rg0cr: RG0CR,
        ///0x104 - DMA Request Generator 1 Control Register
        pub rg1cr: RG1CR,
        ///0x108 - DMA Request Generator 2 Control Register
        pub rg2cr: RG2CR,
        ///0x10c - DMA Request Generator 3 Control Register
        pub rg3cr: RG3CR,
        _reserved20: [u8; 48usize],
        ///0x140 - DMA Request Generator Status Register
        pub rgsr: RGSR,
        ///0x144 - DMA Request Generator Clear Flag Register
        pub rgcfr: RGCFR,
    }
    ///DMA Multiplexer Channel 0 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c0cr](c0cr) module
    pub type C0CR = crate::Reg<u32, _C0CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C0CR;
    ///`read()` method returns [c0cr::R](c0cr::R) reader structure
    impl crate::Readable for C0CR {}
    ///`write(|w| ..)` method takes [c0cr::W](c0cr::W) writer structure
    impl crate::Writable for C0CR {}
    ///DMA Multiplexer Channel 0 Control register
    pub mod c0cr {
        ///Reader of register C0CR
        pub type R = crate::R<u32, super::C0CR>;
        ///Writer for register C0CR
        pub type W = crate::W<u32, super::C0CR>;
        ///Register C0CR `reset()`'s with value 0
        impl crate::ResetValue for super::C0CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 1 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c1cr](c1cr) module
    pub type C1CR = crate::Reg<u32, _C1CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C1CR;
    ///`read()` method returns [c1cr::R](c1cr::R) reader structure
    impl crate::Readable for C1CR {}
    ///`write(|w| ..)` method takes [c1cr::W](c1cr::W) writer structure
    impl crate::Writable for C1CR {}
    ///DMA Multiplexer Channel 1 Control register
    pub mod c1cr {
        ///Reader of register C1CR
        pub type R = crate::R<u32, super::C1CR>;
        ///Writer for register C1CR
        pub type W = crate::W<u32, super::C1CR>;
        ///Register C1CR `reset()`'s with value 0
        impl crate::ResetValue for super::C1CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 2 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c2cr](c2cr) module
    pub type C2CR = crate::Reg<u32, _C2CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C2CR;
    ///`read()` method returns [c2cr::R](c2cr::R) reader structure
    impl crate::Readable for C2CR {}
    ///`write(|w| ..)` method takes [c2cr::W](c2cr::W) writer structure
    impl crate::Writable for C2CR {}
    ///DMA Multiplexer Channel 2 Control register
    pub mod c2cr {
        ///Reader of register C2CR
        pub type R = crate::R<u32, super::C2CR>;
        ///Writer for register C2CR
        pub type W = crate::W<u32, super::C2CR>;
        ///Register C2CR `reset()`'s with value 0
        impl crate::ResetValue for super::C2CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 3 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c3cr](c3cr) module
    pub type C3CR = crate::Reg<u32, _C3CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C3CR;
    ///`read()` method returns [c3cr::R](c3cr::R) reader structure
    impl crate::Readable for C3CR {}
    ///`write(|w| ..)` method takes [c3cr::W](c3cr::W) writer structure
    impl crate::Writable for C3CR {}
    ///DMA Multiplexer Channel 3 Control register
    pub mod c3cr {
        ///Reader of register C3CR
        pub type R = crate::R<u32, super::C3CR>;
        ///Writer for register C3CR
        pub type W = crate::W<u32, super::C3CR>;
        ///Register C3CR `reset()`'s with value 0
        impl crate::ResetValue for super::C3CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 4 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c4cr](c4cr) module
    pub type C4CR = crate::Reg<u32, _C4CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C4CR;
    ///`read()` method returns [c4cr::R](c4cr::R) reader structure
    impl crate::Readable for C4CR {}
    ///`write(|w| ..)` method takes [c4cr::W](c4cr::W) writer structure
    impl crate::Writable for C4CR {}
    ///DMA Multiplexer Channel 4 Control register
    pub mod c4cr {
        ///Reader of register C4CR
        pub type R = crate::R<u32, super::C4CR>;
        ///Writer for register C4CR
        pub type W = crate::W<u32, super::C4CR>;
        ///Register C4CR `reset()`'s with value 0
        impl crate::ResetValue for super::C4CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 5 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c5cr](c5cr) module
    pub type C5CR = crate::Reg<u32, _C5CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C5CR;
    ///`read()` method returns [c5cr::R](c5cr::R) reader structure
    impl crate::Readable for C5CR {}
    ///`write(|w| ..)` method takes [c5cr::W](c5cr::W) writer structure
    impl crate::Writable for C5CR {}
    ///DMA Multiplexer Channel 5 Control register
    pub mod c5cr {
        ///Reader of register C5CR
        pub type R = crate::R<u32, super::C5CR>;
        ///Writer for register C5CR
        pub type W = crate::W<u32, super::C5CR>;
        ///Register C5CR `reset()`'s with value 0
        impl crate::ResetValue for super::C5CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 6 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c6cr](c6cr) module
    pub type C6CR = crate::Reg<u32, _C6CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C6CR;
    ///`read()` method returns [c6cr::R](c6cr::R) reader structure
    impl crate::Readable for C6CR {}
    ///`write(|w| ..)` method takes [c6cr::W](c6cr::W) writer structure
    impl crate::Writable for C6CR {}
    ///DMA Multiplexer Channel 6 Control register
    pub mod c6cr {
        ///Reader of register C6CR
        pub type R = crate::R<u32, super::C6CR>;
        ///Writer for register C6CR
        pub type W = crate::W<u32, super::C6CR>;
        ///Register C6CR `reset()`'s with value 0
        impl crate::ResetValue for super::C6CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 7 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c7cr](c7cr) module
    pub type C7CR = crate::Reg<u32, _C7CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C7CR;
    ///`read()` method returns [c7cr::R](c7cr::R) reader structure
    impl crate::Readable for C7CR {}
    ///`write(|w| ..)` method takes [c7cr::W](c7cr::W) writer structure
    impl crate::Writable for C7CR {}
    ///DMA Multiplexer Channel 7 Control register
    pub mod c7cr {
        ///Reader of register C7CR
        pub type R = crate::R<u32, super::C7CR>;
        ///Writer for register C7CR
        pub type W = crate::W<u32, super::C7CR>;
        ///Register C7CR `reset()`'s with value 0
        impl crate::ResetValue for super::C7CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 8 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c8cr](c8cr) module
    pub type C8CR = crate::Reg<u32, _C8CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C8CR;
    ///`read()` method returns [c8cr::R](c8cr::R) reader structure
    impl crate::Readable for C8CR {}
    ///`write(|w| ..)` method takes [c8cr::W](c8cr::W) writer structure
    impl crate::Writable for C8CR {}
    ///DMA Multiplexer Channel 8 Control register
    pub mod c8cr {
        ///Reader of register C8CR
        pub type R = crate::R<u32, super::C8CR>;
        ///Writer for register C8CR
        pub type W = crate::W<u32, super::C8CR>;
        ///Register C8CR `reset()`'s with value 0
        impl crate::ResetValue for super::C8CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 9 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c9cr](c9cr) module
    pub type C9CR = crate::Reg<u32, _C9CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C9CR;
    ///`read()` method returns [c9cr::R](c9cr::R) reader structure
    impl crate::Readable for C9CR {}
    ///`write(|w| ..)` method takes [c9cr::W](c9cr::W) writer structure
    impl crate::Writable for C9CR {}
    ///DMA Multiplexer Channel 9 Control register
    pub mod c9cr {
        ///Reader of register C9CR
        pub type R = crate::R<u32, super::C9CR>;
        ///Writer for register C9CR
        pub type W = crate::W<u32, super::C9CR>;
        ///Register C9CR `reset()`'s with value 0
        impl crate::ResetValue for super::C9CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 10 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c10cr](c10cr) module
    pub type C10CR = crate::Reg<u32, _C10CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C10CR;
    ///`read()` method returns [c10cr::R](c10cr::R) reader structure
    impl crate::Readable for C10CR {}
    ///`write(|w| ..)` method takes [c10cr::W](c10cr::W) writer structure
    impl crate::Writable for C10CR {}
    ///DMA Multiplexer Channel 10 Control register
    pub mod c10cr {
        ///Reader of register C10CR
        pub type R = crate::R<u32, super::C10CR>;
        ///Writer for register C10CR
        pub type W = crate::W<u32, super::C10CR>;
        ///Register C10CR `reset()`'s with value 0
        impl crate::ResetValue for super::C10CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 11 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c11cr](c11cr) module
    pub type C11CR = crate::Reg<u32, _C11CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C11CR;
    ///`read()` method returns [c11cr::R](c11cr::R) reader structure
    impl crate::Readable for C11CR {}
    ///`write(|w| ..)` method takes [c11cr::W](c11cr::W) writer structure
    impl crate::Writable for C11CR {}
    ///DMA Multiplexer Channel 11 Control register
    pub mod c11cr {
        ///Reader of register C11CR
        pub type R = crate::R<u32, super::C11CR>;
        ///Writer for register C11CR
        pub type W = crate::W<u32, super::C11CR>;
        ///Register C11CR `reset()`'s with value 0
        impl crate::ResetValue for super::C11CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 12 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c12cr](c12cr) module
    pub type C12CR = crate::Reg<u32, _C12CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C12CR;
    ///`read()` method returns [c12cr::R](c12cr::R) reader structure
    impl crate::Readable for C12CR {}
    ///`write(|w| ..)` method takes [c12cr::W](c12cr::W) writer structure
    impl crate::Writable for C12CR {}
    ///DMA Multiplexer Channel 12 Control register
    pub mod c12cr {
        ///Reader of register C12CR
        pub type R = crate::R<u32, super::C12CR>;
        ///Writer for register C12CR
        pub type W = crate::W<u32, super::C12CR>;
        ///Register C12CR `reset()`'s with value 0
        impl crate::ResetValue for super::C12CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel 13 Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c13cr](c13cr) module
    pub type C13CR = crate::Reg<u32, _C13CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C13CR;
    ///`read()` method returns [c13cr::R](c13cr::R) reader structure
    impl crate::Readable for C13CR {}
    ///`write(|w| ..)` method takes [c13cr::W](c13cr::W) writer structure
    impl crate::Writable for C13CR {}
    ///DMA Multiplexer Channel 13 Control register
    pub mod c13cr {
        ///Reader of register C13CR
        pub type R = crate::R<u32, super::C13CR>;
        ///Writer for register C13CR
        pub type W = crate::W<u32, super::C13CR>;
        ///Register C13CR `reset()`'s with value 0
        impl crate::ResetValue for super::C13CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - SYNC_ID
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Nb request
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Sync polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event Generation Enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization Overrun Interrupt Enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:7 - DMA Request ID
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///DMA Multiplexer Channel Status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [csr](csr) module
    pub type CSR = crate::Reg<u32, _CSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CSR;
    ///`read()` method returns [csr::R](csr::R) reader structure
    impl crate::Readable for CSR {}
    ///DMA Multiplexer Channel Status register
    pub mod csr {
        ///Reader of register CSR
        pub type R = crate::R<u32, super::CSR>;
        ///Reader of field `SOF0`
        pub type SOF0_R = crate::R<bool, bool>;
        ///Reader of field `SOF1`
        pub type SOF1_R = crate::R<bool, bool>;
        ///Reader of field `SOF2`
        pub type SOF2_R = crate::R<bool, bool>;
        ///Reader of field `SOF3`
        pub type SOF3_R = crate::R<bool, bool>;
        ///Reader of field `SOF4`
        pub type SOF4_R = crate::R<bool, bool>;
        ///Reader of field `SOF5`
        pub type SOF5_R = crate::R<bool, bool>;
        ///Reader of field `SOF6`
        pub type SOF6_R = crate::R<bool, bool>;
        ///Reader of field `SOF7`
        pub type SOF7_R = crate::R<bool, bool>;
        ///Reader of field `SOF8`
        pub type SOF8_R = crate::R<bool, bool>;
        ///Reader of field `SOF9`
        pub type SOF9_R = crate::R<bool, bool>;
        ///Reader of field `SOF10`
        pub type SOF10_R = crate::R<bool, bool>;
        ///Reader of field `SOF11`
        pub type SOF11_R = crate::R<bool, bool>;
        ///Reader of field `SOF12`
        pub type SOF12_R = crate::R<bool, bool>;
        ///Reader of field `SOF13`
        pub type SOF13_R = crate::R<bool, bool>;
        impl R {
            ///Bit 0 - Synchronization Overrun Flag 0
            #[inline(always)]
            pub fn sof0(&self) -> SOF0_R {
                SOF0_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - Synchronization Overrun Flag 1
            #[inline(always)]
            pub fn sof1(&self) -> SOF1_R {
                SOF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 2 - Synchronization Overrun Flag 2
            #[inline(always)]
            pub fn sof2(&self) -> SOF2_R {
                SOF2_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 3 - Synchronization Overrun Flag 3
            #[inline(always)]
            pub fn sof3(&self) -> SOF3_R {
                SOF3_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 4 - Synchronization Overrun Flag 4
            #[inline(always)]
            pub fn sof4(&self) -> SOF4_R {
                SOF4_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 5 - Synchronization Overrun Flag 5
            #[inline(always)]
            pub fn sof5(&self) -> SOF5_R {
                SOF5_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 6 - Synchronization Overrun Flag 6
            #[inline(always)]
            pub fn sof6(&self) -> SOF6_R {
                SOF6_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 7 - Synchronization Overrun Flag 7
            #[inline(always)]
            pub fn sof7(&self) -> SOF7_R {
                SOF7_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization Overrun Flag 8
            #[inline(always)]
            pub fn sof8(&self) -> SOF8_R {
                SOF8_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 9 - Synchronization Overrun Flag 9
            #[inline(always)]
            pub fn sof9(&self) -> SOF9_R {
                SOF9_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 10 - Synchronization Overrun Flag 10
            #[inline(always)]
            pub fn sof10(&self) -> SOF10_R {
                SOF10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 11 - Synchronization Overrun Flag 11
            #[inline(always)]
            pub fn sof11(&self) -> SOF11_R {
                SOF11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 12 - Synchronization Overrun Flag 12
            #[inline(always)]
            pub fn sof12(&self) -> SOF12_R {
                SOF12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 13 - Synchronization Overrun Flag 13
            #[inline(always)]
            pub fn sof13(&self) -> SOF13_R {
                SOF13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
        }
    }
    ///DMA Channel Clear Flag Register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cfr](cfr) module
    pub type CFR = crate::Reg<u32, _CFR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CFR;
    ///`write(|w| ..)` method takes [cfr::W](cfr::W) writer structure
    impl crate::Writable for CFR {}
    ///DMA Channel Clear Flag Register
    pub mod cfr {
        ///Writer for register CFR
        pub type W = crate::W<u32, super::CFR>;
        ///Register CFR `reset()`'s with value 0
        impl crate::ResetValue for super::CFR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `CSOF0`
        pub struct CSOF0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF0_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Write proxy for field `CSOF1`
        pub struct CSOF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Write proxy for field `CSOF2`
        pub struct CSOF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Write proxy for field `CSOF3`
        pub struct CSOF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Write proxy for field `CSOF4`
        pub struct CSOF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Write proxy for field `CSOF5`
        pub struct CSOF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Write proxy for field `CSOF6`
        pub struct CSOF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Write proxy for field `CSOF7`
        pub struct CSOF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Write proxy for field `CSOF8`
        pub struct CSOF8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF8_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Write proxy for field `CSOF9`
        pub struct CSOF9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF9_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Write proxy for field `CSOF10`
        pub struct CSOF10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Write proxy for field `CSOF11`
        pub struct CSOF11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Write proxy for field `CSOF12`
        pub struct CSOF12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Write proxy for field `CSOF13`
        pub struct CSOF13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        impl W {
            ///Bit 0 - Synchronization Clear Overrun Flag 0
            #[inline(always)]
            pub fn csof0(&mut self) -> CSOF0_W {
                CSOF0_W { w: self }
            }
            ///Bit 1 - Synchronization Clear Overrun Flag 1
            #[inline(always)]
            pub fn csof1(&mut self) -> CSOF1_W {
                CSOF1_W { w: self }
            }
            ///Bit 2 - Synchronization Clear Overrun Flag 2
            #[inline(always)]
            pub fn csof2(&mut self) -> CSOF2_W {
                CSOF2_W { w: self }
            }
            ///Bit 3 - Synchronization Clear Overrun Flag 3
            #[inline(always)]
            pub fn csof3(&mut self) -> CSOF3_W {
                CSOF3_W { w: self }
            }
            ///Bit 4 - Synchronization Clear Overrun Flag 4
            #[inline(always)]
            pub fn csof4(&mut self) -> CSOF4_W {
                CSOF4_W { w: self }
            }
            ///Bit 5 - Synchronization Clear Overrun Flag 5
            #[inline(always)]
            pub fn csof5(&mut self) -> CSOF5_W {
                CSOF5_W { w: self }
            }
            ///Bit 6 - Synchronization Clear Overrun Flag 6
            #[inline(always)]
            pub fn csof6(&mut self) -> CSOF6_W {
                CSOF6_W { w: self }
            }
            ///Bit 7 - Synchronization Clear Overrun Flag 7
            #[inline(always)]
            pub fn csof7(&mut self) -> CSOF7_W {
                CSOF7_W { w: self }
            }
            ///Bit 8 - Synchronization Clear Overrun Flag 8
            #[inline(always)]
            pub fn csof8(&mut self) -> CSOF8_W {
                CSOF8_W { w: self }
            }
            ///Bit 9 - Synchronization Clear Overrun Flag 9
            #[inline(always)]
            pub fn csof9(&mut self) -> CSOF9_W {
                CSOF9_W { w: self }
            }
            ///Bit 10 - Synchronization Clear Overrun Flag 10
            #[inline(always)]
            pub fn csof10(&mut self) -> CSOF10_W {
                CSOF10_W { w: self }
            }
            ///Bit 11 - Synchronization Clear Overrun Flag 11
            #[inline(always)]
            pub fn csof11(&mut self) -> CSOF11_W {
                CSOF11_W { w: self }
            }
            ///Bit 12 - Synchronization Clear Overrun Flag 12
            #[inline(always)]
            pub fn csof12(&mut self) -> CSOF12_W {
                CSOF12_W { w: self }
            }
            ///Bit 13 - Synchronization Clear Overrun Flag 13
            #[inline(always)]
            pub fn csof13(&mut self) -> CSOF13_W {
                CSOF13_W { w: self }
            }
        }
    }
    ///DMA Request Generator 0 Control Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rg0cr](rg0cr) module
    pub type RG0CR = crate::Reg<u32, _RG0CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RG0CR;
    ///`read()` method returns [rg0cr::R](rg0cr::R) reader structure
    impl crate::Readable for RG0CR {}
    ///`write(|w| ..)` method takes [rg0cr::W](rg0cr::W) writer structure
    impl crate::Writable for RG0CR {}
    ///DMA Request Generator 0 Control Register
    pub mod rg0cr {
        ///Reader of register RG0CR
        pub type R = crate::R<u32, super::RG0CR>;
        ///Writer for register RG0CR
        pub type W = crate::W<u32, super::RG0CR>;
        ///Register RG0CR `reset()`'s with value 0
        impl crate::ResetValue for super::RG0CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `GNBREQ`
        pub type GNBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `GNBREQ`
        pub struct GNBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GNBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `GPOL`
        pub type GPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `GPOL`
        pub struct GPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `GE`
        pub type GE_R = crate::R<bool, bool>;
        ///Write proxy for field `GE`
        pub struct GE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `OIE`
        pub type OIE_R = crate::R<bool, bool>;
        ///Write proxy for field `OIE`
        pub struct OIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `SIG_ID`
        pub type SIG_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SIG_ID`
        pub struct SIG_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SIG_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        impl R {
            ///Bits 19:23 - Number of Request
            #[inline(always)]
            pub fn gnbreq(&self) -> GNBREQ_R {
                GNBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Generation Polarity
            #[inline(always)]
            pub fn gpol(&self) -> GPOL_R {
                GPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Generation Enable
            #[inline(always)]
            pub fn ge(&self) -> GE_R {
                GE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 8 - Overrun Interrupt Enable
            #[inline(always)]
            pub fn oie(&self) -> OIE_R {
                OIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:4 - Signal ID
            #[inline(always)]
            pub fn sig_id(&self) -> SIG_ID_R {
                SIG_ID_R::new((self.bits & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 19:23 - Number of Request
            #[inline(always)]
            pub fn gnbreq(&mut self) -> GNBREQ_W {
                GNBREQ_W { w: self }
            }
            ///Bits 17:18 - Generation Polarity
            #[inline(always)]
            pub fn gpol(&mut self) -> GPOL_W {
                GPOL_W { w: self }
            }
            ///Bit 16 - Generation Enable
            #[inline(always)]
            pub fn ge(&mut self) -> GE_W {
                GE_W { w: self }
            }
            ///Bit 8 - Overrun Interrupt Enable
            #[inline(always)]
            pub fn oie(&mut self) -> OIE_W {
                OIE_W { w: self }
            }
            ///Bits 0:4 - Signal ID
            #[inline(always)]
            pub fn sig_id(&mut self) -> SIG_ID_W {
                SIG_ID_W { w: self }
            }
        }
    }
    ///DMA Request Generator 1 Control Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rg1cr](rg1cr) module
    pub type RG1CR = crate::Reg<u32, _RG1CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RG1CR;
    ///`read()` method returns [rg1cr::R](rg1cr::R) reader structure
    impl crate::Readable for RG1CR {}
    ///`write(|w| ..)` method takes [rg1cr::W](rg1cr::W) writer structure
    impl crate::Writable for RG1CR {}
    ///DMA Request Generator 1 Control Register
    pub mod rg1cr {
        ///Reader of register RG1CR
        pub type R = crate::R<u32, super::RG1CR>;
        ///Writer for register RG1CR
        pub type W = crate::W<u32, super::RG1CR>;
        ///Register RG1CR `reset()`'s with value 0
        impl crate::ResetValue for super::RG1CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `GNBREQ`
        pub type GNBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `GNBREQ`
        pub struct GNBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GNBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `GPOL`
        pub type GPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `GPOL`
        pub struct GPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `GE`
        pub type GE_R = crate::R<bool, bool>;
        ///Write proxy for field `GE`
        pub struct GE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `OIE`
        pub type OIE_R = crate::R<bool, bool>;
        ///Write proxy for field `OIE`
        pub struct OIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `SIG_ID`
        pub type SIG_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SIG_ID`
        pub struct SIG_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SIG_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        impl R {
            ///Bits 19:23 - Number of Request
            #[inline(always)]
            pub fn gnbreq(&self) -> GNBREQ_R {
                GNBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Generation Polarity
            #[inline(always)]
            pub fn gpol(&self) -> GPOL_R {
                GPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Generation Enable
            #[inline(always)]
            pub fn ge(&self) -> GE_R {
                GE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 8 - Overrun Interrupt Enable
            #[inline(always)]
            pub fn oie(&self) -> OIE_R {
                OIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:4 - Signal ID
            #[inline(always)]
            pub fn sig_id(&self) -> SIG_ID_R {
                SIG_ID_R::new((self.bits & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 19:23 - Number of Request
            #[inline(always)]
            pub fn gnbreq(&mut self) -> GNBREQ_W {
                GNBREQ_W { w: self }
            }
            ///Bits 17:18 - Generation Polarity
            #[inline(always)]
            pub fn gpol(&mut self) -> GPOL_W {
                GPOL_W { w: self }
            }
            ///Bit 16 - Generation Enable
            #[inline(always)]
            pub fn ge(&mut self) -> GE_W {
                GE_W { w: self }
            }
            ///Bit 8 - Overrun Interrupt Enable
            #[inline(always)]
            pub fn oie(&mut self) -> OIE_W {
                OIE_W { w: self }
            }
            ///Bits 0:4 - Signal ID
            #[inline(always)]
            pub fn sig_id(&mut self) -> SIG_ID_W {
                SIG_ID_W { w: self }
            }
        }
    }
    ///DMA Request Generator 2 Control Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rg2cr](rg2cr) module
    pub type RG2CR = crate::Reg<u32, _RG2CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RG2CR;
    ///`read()` method returns [rg2cr::R](rg2cr::R) reader structure
    impl crate::Readable for RG2CR {}
    ///`write(|w| ..)` method takes [rg2cr::W](rg2cr::W) writer structure
    impl crate::Writable for RG2CR {}
    ///DMA Request Generator 2 Control Register
    pub mod rg2cr {
        ///Reader of register RG2CR
        pub type R = crate::R<u32, super::RG2CR>;
        ///Writer for register RG2CR
        pub type W = crate::W<u32, super::RG2CR>;
        ///Register RG2CR `reset()`'s with value 0
        impl crate::ResetValue for super::RG2CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `GNBREQ`
        pub type GNBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `GNBREQ`
        pub struct GNBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GNBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `GPOL`
        pub type GPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `GPOL`
        pub struct GPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `GE`
        pub type GE_R = crate::R<bool, bool>;
        ///Write proxy for field `GE`
        pub struct GE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `OIE`
        pub type OIE_R = crate::R<bool, bool>;
        ///Write proxy for field `OIE`
        pub struct OIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `SIG_ID`
        pub type SIG_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SIG_ID`
        pub struct SIG_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SIG_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        impl R {
            ///Bits 19:23 - Number of Request
            #[inline(always)]
            pub fn gnbreq(&self) -> GNBREQ_R {
                GNBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Generation Polarity
            #[inline(always)]
            pub fn gpol(&self) -> GPOL_R {
                GPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Generation Enable
            #[inline(always)]
            pub fn ge(&self) -> GE_R {
                GE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 8 - Overrun Interrupt Enable
            #[inline(always)]
            pub fn oie(&self) -> OIE_R {
                OIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:4 - Signal ID
            #[inline(always)]
            pub fn sig_id(&self) -> SIG_ID_R {
                SIG_ID_R::new((self.bits & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 19:23 - Number of Request
            #[inline(always)]
            pub fn gnbreq(&mut self) -> GNBREQ_W {
                GNBREQ_W { w: self }
            }
            ///Bits 17:18 - Generation Polarity
            #[inline(always)]
            pub fn gpol(&mut self) -> GPOL_W {
                GPOL_W { w: self }
            }
            ///Bit 16 - Generation Enable
            #[inline(always)]
            pub fn ge(&mut self) -> GE_W {
                GE_W { w: self }
            }
            ///Bit 8 - Overrun Interrupt Enable
            #[inline(always)]
            pub fn oie(&mut self) -> OIE_W {
                OIE_W { w: self }
            }
            ///Bits 0:4 - Signal ID
            #[inline(always)]
            pub fn sig_id(&mut self) -> SIG_ID_W {
                SIG_ID_W { w: self }
            }
        }
    }
    ///DMA Request Generator 3 Control Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rg3cr](rg3cr) module
    pub type RG3CR = crate::Reg<u32, _RG3CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RG3CR;
    ///`read()` method returns [rg3cr::R](rg3cr::R) reader structure
    impl crate::Readable for RG3CR {}
    ///`write(|w| ..)` method takes [rg3cr::W](rg3cr::W) writer structure
    impl crate::Writable for RG3CR {}
    ///DMA Request Generator 3 Control Register
    pub mod rg3cr {
        ///Reader of register RG3CR
        pub type R = crate::R<u32, super::RG3CR>;
        ///Writer for register RG3CR
        pub type W = crate::W<u32, super::RG3CR>;
        ///Register RG3CR `reset()`'s with value 0
        impl crate::ResetValue for super::RG3CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `GNBREQ`
        pub type GNBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `GNBREQ`
        pub struct GNBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GNBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `GPOL`
        pub type GPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `GPOL`
        pub struct GPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `GE`
        pub type GE_R = crate::R<bool, bool>;
        ///Write proxy for field `GE`
        pub struct GE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `OIE`
        pub type OIE_R = crate::R<bool, bool>;
        ///Write proxy for field `OIE`
        pub struct OIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `SIG_ID`
        pub type SIG_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SIG_ID`
        pub struct SIG_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SIG_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        impl R {
            ///Bits 19:23 - Number of Request
            #[inline(always)]
            pub fn gnbreq(&self) -> GNBREQ_R {
                GNBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Generation Polarity
            #[inline(always)]
            pub fn gpol(&self) -> GPOL_R {
                GPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Generation Enable
            #[inline(always)]
            pub fn ge(&self) -> GE_R {
                GE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 8 - Overrun Interrupt Enable
            #[inline(always)]
            pub fn oie(&self) -> OIE_R {
                OIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:4 - Signal ID
            #[inline(always)]
            pub fn sig_id(&self) -> SIG_ID_R {
                SIG_ID_R::new((self.bits & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 19:23 - Number of Request
            #[inline(always)]
            pub fn gnbreq(&mut self) -> GNBREQ_W {
                GNBREQ_W { w: self }
            }
            ///Bits 17:18 - Generation Polarity
            #[inline(always)]
            pub fn gpol(&mut self) -> GPOL_W {
                GPOL_W { w: self }
            }
            ///Bit 16 - Generation Enable
            #[inline(always)]
            pub fn ge(&mut self) -> GE_W {
                GE_W { w: self }
            }
            ///Bit 8 - Overrun Interrupt Enable
            #[inline(always)]
            pub fn oie(&mut self) -> OIE_W {
                OIE_W { w: self }
            }
            ///Bits 0:4 - Signal ID
            #[inline(always)]
            pub fn sig_id(&mut self) -> SIG_ID_W {
                SIG_ID_W { w: self }
            }
        }
    }
    ///DMA Request Generator Status Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rgsr](rgsr) module
    pub type RGSR = crate::Reg<u32, _RGSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RGSR;
    ///`read()` method returns [rgsr::R](rgsr::R) reader structure
    impl crate::Readable for RGSR {}
    ///DMA Request Generator Status Register
    pub mod rgsr {
        ///Reader of register RGSR
        pub type R = crate::R<u32, super::RGSR>;
        ///Reader of field `OF0`
        pub type OF0_R = crate::R<bool, bool>;
        ///Reader of field `OF1`
        pub type OF1_R = crate::R<bool, bool>;
        ///Reader of field `OF2`
        pub type OF2_R = crate::R<bool, bool>;
        ///Reader of field `OF3`
        pub type OF3_R = crate::R<bool, bool>;
        impl R {
            ///Bit 0 - Generator Overrun Flag 0
            #[inline(always)]
            pub fn of0(&self) -> OF0_R {
                OF0_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - Generator Overrun Flag 1
            #[inline(always)]
            pub fn of1(&self) -> OF1_R {
                OF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 2 - Generator Overrun Flag 2
            #[inline(always)]
            pub fn of2(&self) -> OF2_R {
                OF2_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 3 - Generator Overrun Flag 3
            #[inline(always)]
            pub fn of3(&self) -> OF3_R {
                OF3_R::new(((self.bits >> 3) & 0x01) != 0)
            }
        }
    }
    ///DMA Request Generator Clear Flag Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rgcfr](rgcfr) module
    pub type RGCFR = crate::Reg<u32, _RGCFR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RGCFR;
    ///`read()` method returns [rgcfr::R](rgcfr::R) reader structure
    impl crate::Readable for RGCFR {}
    ///DMA Request Generator Clear Flag Register
    pub mod rgcfr {
        ///Reader of register RGCFR
        pub type R = crate::R<u32, super::RGCFR>;
        ///Reader of field `CSOF0`
        pub type CSOF0_R = crate::R<bool, bool>;
        ///Reader of field `CSOF1`
        pub type CSOF1_R = crate::R<bool, bool>;
        ///Reader of field `CSOF2`
        pub type CSOF2_R = crate::R<bool, bool>;
        ///Reader of field `CSOF3`
        pub type CSOF3_R = crate::R<bool, bool>;
        impl R {
            ///Bit 0 - Generator Clear Overrun Flag 0
            #[inline(always)]
            pub fn csof0(&self) -> CSOF0_R {
                CSOF0_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - Generator Clear Overrun Flag 1
            #[inline(always)]
            pub fn csof1(&self) -> CSOF1_R {
                CSOF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 2 - Generator Clear Overrun Flag 2
            #[inline(always)]
            pub fn csof2(&self) -> CSOF2_R {
                CSOF2_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 3 - Generator Clear Overrun Flag 3
            #[inline(always)]
            pub fn csof3(&self) -> CSOF3_R {
                CSOF3_R::new(((self.bits >> 3) & 0x01) != 0)
            }
        }
    }
}
///Cyclic redundancy check calculation unit
pub struct CRC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRC {}
impl CRC {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const crc::RegisterBlock {
        0x4002_3000 as *const _
    }
}
impl Deref for CRC {
    type Target = crc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*CRC::ptr() }
    }
}
///Cyclic redundancy check calculation unit
pub mod crc {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - Data register
        pub dr: DR,
        ///0x04 - Independent data register
        pub idr: IDR,
        ///0x08 - Control register
        pub cr: CR,
        _reserved3: [u8; 4usize],
        ///0x10 - Initial CRC value
        pub init: INIT,
        ///0x14 - polynomial
        pub pol: POL,
    }
    ///Data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dr](dr) module
    pub type DR = crate::Reg<u32, _DR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DR;
    ///`read()` method returns [dr::R](dr::R) reader structure
    impl crate::Readable for DR {}
    ///`write(|w| ..)` method takes [dr::W](dr::W) writer structure
    impl crate::Writable for DR {}
    ///Data register
    pub mod dr {
        ///Reader of register DR
        pub type R = crate::R<u32, super::DR>;
        ///Writer for register DR
        pub type W = crate::W<u32, super::DR>;
        ///Register DR `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::DR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `DR`
        pub type DR_R = crate::R<u32, u32>;
        ///Write proxy for field `DR`
        pub struct DR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Data register bits
            #[inline(always)]
            pub fn dr(&self) -> DR_R {
                DR_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Data register bits
            #[inline(always)]
            pub fn dr(&mut self) -> DR_W {
                DR_W { w: self }
            }
        }
    }
    ///Independent data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [idr](idr) module
    pub type IDR = crate::Reg<u32, _IDR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IDR;
    ///`read()` method returns [idr::R](idr::R) reader structure
    impl crate::Readable for IDR {}
    ///`write(|w| ..)` method takes [idr::W](idr::W) writer structure
    impl crate::Writable for IDR {}
    ///Independent data register
    pub mod idr {
        ///Reader of register IDR
        pub type R = crate::R<u32, super::IDR>;
        ///Writer for register IDR
        pub type W = crate::W<u32, super::IDR>;
        ///Register IDR `reset()`'s with value 0
        impl crate::ResetValue for super::IDR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `IDR`
        pub type IDR_R = crate::R<u32, u32>;
        ///Write proxy for field `IDR`
        pub struct IDR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IDR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - General-purpose 32-bit data register bits
            #[inline(always)]
            pub fn idr(&self) -> IDR_R {
                IDR_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - General-purpose 32-bit data register bits
            #[inline(always)]
            pub fn idr(&mut self) -> IDR_W {
                IDR_W { w: self }
            }
        }
    }
    ///Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///Control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `REV_OUT`
        pub type REV_OUT_R = crate::R<bool, bool>;
        ///Write proxy for field `REV_OUT`
        pub struct REV_OUT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> REV_OUT_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `REV_IN`
        pub type REV_IN_R = crate::R<u8, u8>;
        ///Write proxy for field `REV_IN`
        pub struct REV_IN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> REV_IN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 5)) | (((value as u32) & 0x03) << 5);
                self.w
            }
        }
        ///Reader of field `POLYSIZE`
        pub type POLYSIZE_R = crate::R<u8, u8>;
        ///Write proxy for field `POLYSIZE`
        pub struct POLYSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> POLYSIZE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 3)) | (((value as u32) & 0x03) << 3);
                self.w
            }
        }
        ///Reader of field `RESET`
        pub type RESET_R = crate::R<bool, bool>;
        ///Write proxy for field `RESET`
        pub struct RESET_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RESET_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 7 - Reverse output data
            #[inline(always)]
            pub fn rev_out(&self) -> REV_OUT_R {
                REV_OUT_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bits 5:6 - Reverse input data
            #[inline(always)]
            pub fn rev_in(&self) -> REV_IN_R {
                REV_IN_R::new(((self.bits >> 5) & 0x03) as u8)
            }
            ///Bits 3:4 - Polynomial size
            #[inline(always)]
            pub fn polysize(&self) -> POLYSIZE_R {
                POLYSIZE_R::new(((self.bits >> 3) & 0x03) as u8)
            }
            ///Bit 0 - RESET bit
            #[inline(always)]
            pub fn reset(&self) -> RESET_R {
                RESET_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 7 - Reverse output data
            #[inline(always)]
            pub fn rev_out(&mut self) -> REV_OUT_W {
                REV_OUT_W { w: self }
            }
            ///Bits 5:6 - Reverse input data
            #[inline(always)]
            pub fn rev_in(&mut self) -> REV_IN_W {
                REV_IN_W { w: self }
            }
            ///Bits 3:4 - Polynomial size
            #[inline(always)]
            pub fn polysize(&mut self) -> POLYSIZE_W {
                POLYSIZE_W { w: self }
            }
            ///Bit 0 - RESET bit
            #[inline(always)]
            pub fn reset(&mut self) -> RESET_W {
                RESET_W { w: self }
            }
        }
    }
    ///Initial CRC value
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [init](init) module
    pub type INIT = crate::Reg<u32, _INIT>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _INIT;
    ///`read()` method returns [init::R](init::R) reader structure
    impl crate::Readable for INIT {}
    ///`write(|w| ..)` method takes [init::W](init::W) writer structure
    impl crate::Writable for INIT {}
    ///Initial CRC value
    pub mod init {
        ///Reader of register INIT
        pub type R = crate::R<u32, super::INIT>;
        ///Writer for register INIT
        pub type W = crate::W<u32, super::INIT>;
        ///Register INIT `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::INIT {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `CRC_INIT`
        pub type CRC_INIT_R = crate::R<u32, u32>;
        ///Write proxy for field `CRC_INIT`
        pub struct CRC_INIT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CRC_INIT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Programmable initial CRC value
            #[inline(always)]
            pub fn crc_init(&self) -> CRC_INIT_R {
                CRC_INIT_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Programmable initial CRC value
            #[inline(always)]
            pub fn crc_init(&mut self) -> CRC_INIT_W {
                CRC_INIT_W { w: self }
            }
        }
    }
    ///polynomial
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [pol](pol) module
    pub type POL = crate::Reg<u32, _POL>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _POL;
    ///`read()` method returns [pol::R](pol::R) reader structure
    impl crate::Readable for POL {}
    ///`write(|w| ..)` method takes [pol::W](pol::W) writer structure
    impl crate::Writable for POL {}
    ///polynomial
    pub mod pol {
        ///Reader of register POL
        pub type R = crate::R<u32, super::POL>;
        ///Writer for register POL
        pub type W = crate::W<u32, super::POL>;
        ///Register POL `reset()`'s with value 0x04c1_1db7
        impl crate::ResetValue for super::POL {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x04c1_1db7
            }
        }
        ///Reader of field `POL`
        pub type POL_R = crate::R<u32, u32>;
        ///Write proxy for field `POL`
        pub struct POL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> POL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Programmable polynomial
            #[inline(always)]
            pub fn pol(&self) -> POL_R {
                POL_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Programmable polynomial
            #[inline(always)]
            pub fn pol(&mut self) -> POL_W {
                POL_W { w: self }
            }
        }
    }
}
///Liquid crystal display controller
pub struct LCD {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LCD {}
impl LCD {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const lcd::RegisterBlock {
        0x4000_2400 as *const _
    }
}
impl Deref for LCD {
    type Target = lcd::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*LCD::ptr() }
    }
}
///Liquid crystal display controller
pub mod lcd {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - control register
        pub cr: CR,
        ///0x04 - frame control register
        pub fcr: FCR,
        ///0x08 - status register
        pub sr: SR,
        ///0x0c - clear register
        pub clr: CLR,
        _reserved4: [u8; 4usize],
        ///0x14 - display memory
        pub ram_com0: RAM_COM0,
        _reserved5: [u8; 4usize],
        ///0x1c - display memory
        pub ram_com1: RAM_COM1,
        _reserved6: [u8; 4usize],
        ///0x24 - display memory
        pub ram_com2: RAM_COM2,
        _reserved7: [u8; 4usize],
        ///0x2c - display memory
        pub ram_com3: RAM_COM3,
        _reserved8: [u8; 4usize],
        ///0x34 - display memory
        pub ram_com4: RAM_COM4,
        _reserved9: [u8; 4usize],
        ///0x3c - display memory
        pub ram_com5: RAM_COM5,
        _reserved10: [u8; 4usize],
        ///0x44 - display memory
        pub ram_com6: RAM_COM6,
        _reserved11: [u8; 4usize],
        ///0x4c - display memory
        pub ram_com7: RAM_COM7,
    }
    ///control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `BIAS`
        pub type BIAS_R = crate::R<u8, u8>;
        ///Write proxy for field `BIAS`
        pub struct BIAS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BIAS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 5)) | (((value as u32) & 0x03) << 5);
                self.w
            }
        }
        ///Reader of field `DUTY`
        pub type DUTY_R = crate::R<u8, u8>;
        ///Write proxy for field `DUTY`
        pub struct DUTY_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DUTY_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 2)) | (((value as u32) & 0x07) << 2);
                self.w
            }
        }
        ///Reader of field `VSEL`
        pub type VSEL_R = crate::R<bool, bool>;
        ///Write proxy for field `VSEL`
        pub struct VSEL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> VSEL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `LCDEN`
        pub type LCDEN_R = crate::R<bool, bool>;
        ///Write proxy for field `LCDEN`
        pub struct LCDEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LCDEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `MUX_SEG`
        pub type MUX_SEG_R = crate::R<bool, bool>;
        ///Write proxy for field `MUX_SEG`
        pub struct MUX_SEG_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MUX_SEG_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `BUFEN`
        pub type BUFEN_R = crate::R<bool, bool>;
        ///Write proxy for field `BUFEN`
        pub struct BUFEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BUFEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        impl R {
            ///Bits 5:6 - Bias selector
            #[inline(always)]
            pub fn bias(&self) -> BIAS_R {
                BIAS_R::new(((self.bits >> 5) & 0x03) as u8)
            }
            ///Bits 2:4 - Duty selection
            #[inline(always)]
            pub fn duty(&self) -> DUTY_R {
                DUTY_R::new(((self.bits >> 2) & 0x07) as u8)
            }
            ///Bit 1 - Voltage source selection
            #[inline(always)]
            pub fn vsel(&self) -> VSEL_R {
                VSEL_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - LCD controller enable
            #[inline(always)]
            pub fn lcden(&self) -> LCDEN_R {
                LCDEN_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 7 - Mux segment enable
            #[inline(always)]
            pub fn mux_seg(&self) -> MUX_SEG_R {
                MUX_SEG_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 8 - Voltage output buffer enable
            #[inline(always)]
            pub fn bufen(&self) -> BUFEN_R {
                BUFEN_R::new(((self.bits >> 8) & 0x01) != 0)
            }
        }
        impl W {
            ///Bits 5:6 - Bias selector
            #[inline(always)]
            pub fn bias(&mut self) -> BIAS_W {
                BIAS_W { w: self }
            }
            ///Bits 2:4 - Duty selection
            #[inline(always)]
            pub fn duty(&mut self) -> DUTY_W {
                DUTY_W { w: self }
            }
            ///Bit 1 - Voltage source selection
            #[inline(always)]
            pub fn vsel(&mut self) -> VSEL_W {
                VSEL_W { w: self }
            }
            ///Bit 0 - LCD controller enable
            #[inline(always)]
            pub fn lcden(&mut self) -> LCDEN_W {
                LCDEN_W { w: self }
            }
            ///Bit 7 - Mux segment enable
            #[inline(always)]
            pub fn mux_seg(&mut self) -> MUX_SEG_W {
                MUX_SEG_W { w: self }
            }
            ///Bit 8 - Voltage output buffer enable
            #[inline(always)]
            pub fn bufen(&mut self) -> BUFEN_W {
                BUFEN_W { w: self }
            }
        }
    }
    ///frame control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [fcr](fcr) module
    pub type FCR = crate::Reg<u32, _FCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _FCR;
    ///`read()` method returns [fcr::R](fcr::R) reader structure
    impl crate::Readable for FCR {}
    ///`write(|w| ..)` method takes [fcr::W](fcr::W) writer structure
    impl crate::Writable for FCR {}
    ///frame control register
    pub mod fcr {
        ///Reader of register FCR
        pub type R = crate::R<u32, super::FCR>;
        ///Writer for register FCR
        pub type W = crate::W<u32, super::FCR>;
        ///Register FCR `reset()`'s with value 0
        impl crate::ResetValue for super::FCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PS`
        pub type PS_R = crate::R<u8, u8>;
        ///Write proxy for field `PS`
        pub struct PS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 22)) | (((value as u32) & 0x0f) << 22);
                self.w
            }
        }
        ///Reader of field `DIV`
        pub type DIV_R = crate::R<u8, u8>;
        ///Write proxy for field `DIV`
        pub struct DIV_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIV_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 18)) | (((value as u32) & 0x0f) << 18);
                self.w
            }
        }
        ///Reader of field `BLINK`
        pub type BLINK_R = crate::R<u8, u8>;
        ///Write proxy for field `BLINK`
        pub struct BLINK_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BLINK_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 16)) | (((value as u32) & 0x03) << 16);
                self.w
            }
        }
        ///Reader of field `BLINKF`
        pub type BLINKF_R = crate::R<u8, u8>;
        ///Write proxy for field `BLINKF`
        pub struct BLINKF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BLINKF_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 13)) | (((value as u32) & 0x07) << 13);
                self.w
            }
        }
        ///Reader of field `CC`
        pub type CC_R = crate::R<u8, u8>;
        ///Write proxy for field `CC`
        pub struct CC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CC_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 10)) | (((value as u32) & 0x07) << 10);
                self.w
            }
        }
        ///Reader of field `DEAD`
        pub type DEAD_R = crate::R<u8, u8>;
        ///Write proxy for field `DEAD`
        pub struct DEAD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DEAD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 7)) | (((value as u32) & 0x07) << 7);
                self.w
            }
        }
        ///Reader of field `PON`
        pub type PON_R = crate::R<u8, u8>;
        ///Write proxy for field `PON`
        pub struct PON_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PON_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 4)) | (((value as u32) & 0x07) << 4);
                self.w
            }
        }
        ///Reader of field `UDDIE`
        pub type UDDIE_R = crate::R<bool, bool>;
        ///Write proxy for field `UDDIE`
        pub struct UDDIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> UDDIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `SOFIE`
        pub type SOFIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOFIE`
        pub struct SOFIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOFIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `HD`
        pub type HD_R = crate::R<bool, bool>;
        ///Write proxy for field `HD`
        pub struct HD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HD_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bits 22:25 - PS 16-bit prescaler
            #[inline(always)]
            pub fn ps(&self) -> PS_R {
                PS_R::new(((self.bits >> 22) & 0x0f) as u8)
            }
            ///Bits 18:21 - DIV clock divider
            #[inline(always)]
            pub fn div(&self) -> DIV_R {
                DIV_R::new(((self.bits >> 18) & 0x0f) as u8)
            }
            ///Bits 16:17 - Blink mode selection
            #[inline(always)]
            pub fn blink(&self) -> BLINK_R {
                BLINK_R::new(((self.bits >> 16) & 0x03) as u8)
            }
            ///Bits 13:15 - Blink frequency selection
            #[inline(always)]
            pub fn blinkf(&self) -> BLINKF_R {
                BLINKF_R::new(((self.bits >> 13) & 0x07) as u8)
            }
            ///Bits 10:12 - Contrast control
            #[inline(always)]
            pub fn cc(&self) -> CC_R {
                CC_R::new(((self.bits >> 10) & 0x07) as u8)
            }
            ///Bits 7:9 - Dead time duration
            #[inline(always)]
            pub fn dead(&self) -> DEAD_R {
                DEAD_R::new(((self.bits >> 7) & 0x07) as u8)
            }
            ///Bits 4:6 - Pulse ON duration
            #[inline(always)]
            pub fn pon(&self) -> PON_R {
                PON_R::new(((self.bits >> 4) & 0x07) as u8)
            }
            ///Bit 3 - Update display done interrupt enable
            #[inline(always)]
            pub fn uddie(&self) -> UDDIE_R {
                UDDIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 1 - Start of frame interrupt enable
            #[inline(always)]
            pub fn sofie(&self) -> SOFIE_R {
                SOFIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - High drive enable
            #[inline(always)]
            pub fn hd(&self) -> HD_R {
                HD_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bits 22:25 - PS 16-bit prescaler
            #[inline(always)]
            pub fn ps(&mut self) -> PS_W {
                PS_W { w: self }
            }
            ///Bits 18:21 - DIV clock divider
            #[inline(always)]
            pub fn div(&mut self) -> DIV_W {
                DIV_W { w: self }
            }
            ///Bits 16:17 - Blink mode selection
            #[inline(always)]
            pub fn blink(&mut self) -> BLINK_W {
                BLINK_W { w: self }
            }
            ///Bits 13:15 - Blink frequency selection
            #[inline(always)]
            pub fn blinkf(&mut self) -> BLINKF_W {
                BLINKF_W { w: self }
            }
            ///Bits 10:12 - Contrast control
            #[inline(always)]
            pub fn cc(&mut self) -> CC_W {
                CC_W { w: self }
            }
            ///Bits 7:9 - Dead time duration
            #[inline(always)]
            pub fn dead(&mut self) -> DEAD_W {
                DEAD_W { w: self }
            }
            ///Bits 4:6 - Pulse ON duration
            #[inline(always)]
            pub fn pon(&mut self) -> PON_W {
                PON_W { w: self }
            }
            ///Bit 3 - Update display done interrupt enable
            #[inline(always)]
            pub fn uddie(&mut self) -> UDDIE_W {
                UDDIE_W { w: self }
            }
            ///Bit 1 - Start of frame interrupt enable
            #[inline(always)]
            pub fn sofie(&mut self) -> SOFIE_W {
                SOFIE_W { w: self }
            }
            ///Bit 0 - High drive enable
            #[inline(always)]
            pub fn hd(&mut self) -> HD_W {
                HD_W { w: self }
            }
        }
    }
    ///status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [sr](sr) module
    pub type SR = crate::Reg<u32, _SR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SR;
    ///`read()` method returns [sr::R](sr::R) reader structure
    impl crate::Readable for SR {}
    ///`write(|w| ..)` method takes [sr::W](sr::W) writer structure
    impl crate::Writable for SR {}
    ///status register
    pub mod sr {
        ///Reader of register SR
        pub type R = crate::R<u32, super::SR>;
        ///Writer for register SR
        pub type W = crate::W<u32, super::SR>;
        ///Register SR `reset()`'s with value 0x20
        impl crate::ResetValue for super::SR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x20
            }
        }
        ///Reader of field `FCRSF`
        pub type FCRSF_R = crate::R<bool, bool>;
        ///Reader of field `RDY`
        pub type RDY_R = crate::R<bool, bool>;
        ///Reader of field `UDD`
        pub type UDD_R = crate::R<bool, bool>;
        ///Reader of field `UDR`
        pub type UDR_R = crate::R<bool, bool>;
        ///Write proxy for field `UDR`
        pub struct UDR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> UDR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `SOF`
        pub type SOF_R = crate::R<bool, bool>;
        ///Reader of field `ENS`
        pub type ENS_R = crate::R<bool, bool>;
        impl R {
            ///Bit 5 - LCD Frame Control Register Synchronization flag
            #[inline(always)]
            pub fn fcrsf(&self) -> FCRSF_R {
                FCRSF_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Ready flag
            #[inline(always)]
            pub fn rdy(&self) -> RDY_R {
                RDY_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Update Display Done
            #[inline(always)]
            pub fn udd(&self) -> UDD_R {
                UDD_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Update display request
            #[inline(always)]
            pub fn udr(&self) -> UDR_R {
                UDR_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Start of frame flag
            #[inline(always)]
            pub fn sof(&self) -> SOF_R {
                SOF_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - ENS
            #[inline(always)]
            pub fn ens(&self) -> ENS_R {
                ENS_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 2 - Update display request
            #[inline(always)]
            pub fn udr(&mut self) -> UDR_W {
                UDR_W { w: self }
            }
        }
    }
    ///clear register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [clr](clr) module
    pub type CLR = crate::Reg<u32, _CLR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CLR;
    ///`write(|w| ..)` method takes [clr::W](clr::W) writer structure
    impl crate::Writable for CLR {}
    ///clear register
    pub mod clr {
        ///Writer for register CLR
        pub type W = crate::W<u32, super::CLR>;
        ///Register CLR `reset()`'s with value 0
        impl crate::ResetValue for super::CLR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `UDDC`
        pub struct UDDC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> UDDC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Write proxy for field `SOFC`
        pub struct SOFC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOFC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        impl W {
            ///Bit 3 - Update display done clear
            #[inline(always)]
            pub fn uddc(&mut self) -> UDDC_W {
                UDDC_W { w: self }
            }
            ///Bit 1 - Start of frame flag clear
            #[inline(always)]
            pub fn sofc(&mut self) -> SOFC_W {
                SOFC_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com0](ram_com0) module
    pub type RAM_COM0 = crate::Reg<u32, _RAM_COM0>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM0;
    ///`read()` method returns [ram_com0::R](ram_com0::R) reader structure
    impl crate::Readable for RAM_COM0 {}
    ///`write(|w| ..)` method takes [ram_com0::W](ram_com0::W) writer structure
    impl crate::Writable for RAM_COM0 {}
    ///display memory
    pub mod ram_com0 {
        ///Reader of register RAM_COM0
        pub type R = crate::R<u32, super::RAM_COM0>;
        ///Writer for register RAM_COM0
        pub type W = crate::W<u32, super::RAM_COM0>;
        ///Register RAM_COM0 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM0 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com1](ram_com1) module
    pub type RAM_COM1 = crate::Reg<u32, _RAM_COM1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM1;
    ///`read()` method returns [ram_com1::R](ram_com1::R) reader structure
    impl crate::Readable for RAM_COM1 {}
    ///`write(|w| ..)` method takes [ram_com1::W](ram_com1::W) writer structure
    impl crate::Writable for RAM_COM1 {}
    ///display memory
    pub mod ram_com1 {
        ///Reader of register RAM_COM1
        pub type R = crate::R<u32, super::RAM_COM1>;
        ///Writer for register RAM_COM1
        pub type W = crate::W<u32, super::RAM_COM1>;
        ///Register RAM_COM1 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com2](ram_com2) module
    pub type RAM_COM2 = crate::Reg<u32, _RAM_COM2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM2;
    ///`read()` method returns [ram_com2::R](ram_com2::R) reader structure
    impl crate::Readable for RAM_COM2 {}
    ///`write(|w| ..)` method takes [ram_com2::W](ram_com2::W) writer structure
    impl crate::Writable for RAM_COM2 {}
    ///display memory
    pub mod ram_com2 {
        ///Reader of register RAM_COM2
        pub type R = crate::R<u32, super::RAM_COM2>;
        ///Writer for register RAM_COM2
        pub type W = crate::W<u32, super::RAM_COM2>;
        ///Register RAM_COM2 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com3](ram_com3) module
    pub type RAM_COM3 = crate::Reg<u32, _RAM_COM3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM3;
    ///`read()` method returns [ram_com3::R](ram_com3::R) reader structure
    impl crate::Readable for RAM_COM3 {}
    ///`write(|w| ..)` method takes [ram_com3::W](ram_com3::W) writer structure
    impl crate::Writable for RAM_COM3 {}
    ///display memory
    pub mod ram_com3 {
        ///Reader of register RAM_COM3
        pub type R = crate::R<u32, super::RAM_COM3>;
        ///Writer for register RAM_COM3
        pub type W = crate::W<u32, super::RAM_COM3>;
        ///Register RAM_COM3 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com4](ram_com4) module
    pub type RAM_COM4 = crate::Reg<u32, _RAM_COM4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM4;
    ///`read()` method returns [ram_com4::R](ram_com4::R) reader structure
    impl crate::Readable for RAM_COM4 {}
    ///`write(|w| ..)` method takes [ram_com4::W](ram_com4::W) writer structure
    impl crate::Writable for RAM_COM4 {}
    ///display memory
    pub mod ram_com4 {
        ///Reader of register RAM_COM4
        pub type R = crate::R<u32, super::RAM_COM4>;
        ///Writer for register RAM_COM4
        pub type W = crate::W<u32, super::RAM_COM4>;
        ///Register RAM_COM4 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com5](ram_com5) module
    pub type RAM_COM5 = crate::Reg<u32, _RAM_COM5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM5;
    ///`read()` method returns [ram_com5::R](ram_com5::R) reader structure
    impl crate::Readable for RAM_COM5 {}
    ///`write(|w| ..)` method takes [ram_com5::W](ram_com5::W) writer structure
    impl crate::Writable for RAM_COM5 {}
    ///display memory
    pub mod ram_com5 {
        ///Reader of register RAM_COM5
        pub type R = crate::R<u32, super::RAM_COM5>;
        ///Writer for register RAM_COM5
        pub type W = crate::W<u32, super::RAM_COM5>;
        ///Register RAM_COM5 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com6](ram_com6) module
    pub type RAM_COM6 = crate::Reg<u32, _RAM_COM6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM6;
    ///`read()` method returns [ram_com6::R](ram_com6::R) reader structure
    impl crate::Readable for RAM_COM6 {}
    ///`write(|w| ..)` method takes [ram_com6::W](ram_com6::W) writer structure
    impl crate::Writable for RAM_COM6 {}
    ///display memory
    pub mod ram_com6 {
        ///Reader of register RAM_COM6
        pub type R = crate::R<u32, super::RAM_COM6>;
        ///Writer for register RAM_COM6
        pub type W = crate::W<u32, super::RAM_COM6>;
        ///Register RAM_COM6 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com7](ram_com7) module
    pub type RAM_COM7 = crate::Reg<u32, _RAM_COM7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM7;
    ///`read()` method returns [ram_com7::R](ram_com7::R) reader structure
    impl crate::Readable for RAM_COM7 {}
    ///`write(|w| ..)` method takes [ram_com7::W](ram_com7::W) writer structure
    impl crate::Writable for RAM_COM7 {}
    ///display memory
    pub mod ram_com7 {
        ///Reader of register RAM_COM7
        pub type R = crate::R<u32, super::RAM_COM7>;
        ///Writer for register RAM_COM7
        pub type W = crate::W<u32, super::RAM_COM7>;
        ///Register RAM_COM7 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
}
///Touch sensing controller
pub struct TSC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TSC {}
impl TSC {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const tsc::RegisterBlock {
        0x4002_4000 as *const _
    }
}
impl Deref for TSC {
    type Target = tsc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*TSC::ptr() }
    }
}
///Touch sensing controller
pub mod tsc {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - control register
        pub cr: CR,
        ///0x04 - interrupt enable register
        pub ier: IER,
        ///0x08 - interrupt clear register
        pub icr: ICR,
        ///0x0c - interrupt status register
        pub isr: ISR,
        ///0x10 - I/O hysteresis control register
        pub iohcr: IOHCR,
        _reserved5: [u8; 4usize],
        ///0x18 - I/O analog switch control register
        pub ioascr: IOASCR,
        _reserved6: [u8; 4usize],
        ///0x20 - I/O sampling control register
        pub ioscr: IOSCR,
        _reserved7: [u8; 4usize],
        ///0x28 - I/O channel control register
        pub ioccr: IOCCR,
        _reserved8: [u8; 4usize],
        ///0x30 - I/O group control status register
        pub iogcsr: IOGCSR,
        ///0x34 - I/O group x counter register
        pub iog1cr: IOG1CR,
        ///0x38 - I/O group x counter register
        pub iog2cr: IOG2CR,
        ///0x3c - I/O group x counter register
        pub iog3cr: IOG3CR,
        ///0x40 - I/O group x counter register
        pub iog4cr: IOG4CR,
        ///0x44 - I/O group x counter register
        pub iog5cr: IOG5CR,
        ///0x48 - I/O group x counter register
        pub iog6cr: IOG6CR,
        ///0x4c - I/O group x counter register
        pub iog7cr: IOG7CR,
    }
    ///control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CTPH`
        pub type CTPH_R = crate::R<u8, u8>;
        ///Write proxy for field `CTPH`
        pub struct CTPH_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTPH_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 28)) | (((value as u32) & 0x0f) << 28);
                self.w
            }
        }
        ///Reader of field `CTPL`
        pub type CTPL_R = crate::R<u8, u8>;
        ///Write proxy for field `CTPL`
        pub struct CTPL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTPL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 24)) | (((value as u32) & 0x0f) << 24);
                self.w
            }
        }
        ///Reader of field `SSD`
        pub type SSD_R = crate::R<u8, u8>;
        ///Write proxy for field `SSD`
        pub struct SSD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x7f << 17)) | (((value as u32) & 0x7f) << 17);
                self.w
            }
        }
        ///Reader of field `SSE`
        pub type SSE_R = crate::R<bool, bool>;
        ///Write proxy for field `SSE`
        pub struct SSE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `SSPSC`
        pub type SSPSC_R = crate::R<bool, bool>;
        ///Write proxy for field `SSPSC`
        pub struct SSPSC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSPSC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `PGPSC`
        pub type PGPSC_R = crate::R<u8, u8>;
        ///Write proxy for field `PGPSC`
        pub struct PGPSC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PGPSC_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 12)) | (((value as u32) & 0x07) << 12);
                self.w
            }
        }
        ///Reader of field `MCV`
        pub type MCV_R = crate::R<u8, u8>;
        ///Write proxy for field `MCV`
        pub struct MCV_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCV_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 5)) | (((value as u32) & 0x07) << 5);
                self.w
            }
        }
        ///Reader of field `IODEF`
        pub type IODEF_R = crate::R<bool, bool>;
        ///Write proxy for field `IODEF`
        pub struct IODEF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IODEF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `SYNCPOL`
        pub type SYNCPOL_R = crate::R<bool, bool>;
        ///Write proxy for field `SYNCPOL`
        pub struct SYNCPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNCPOL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `AM`
        pub type AM_R = crate::R<bool, bool>;
        ///Write proxy for field `AM`
        pub struct AM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> AM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `START`
        pub type START_R = crate::R<bool, bool>;
        ///Write proxy for field `START`
        pub struct START_W<'a> {
            w: &'a mut W,
        }
        impl<'a> START_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `TSCE`
        pub type TSCE_R = crate::R<bool, bool>;
        ///Write proxy for field `TSCE`
        pub struct TSCE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSCE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bits 28:31 - Charge transfer pulse high
            #[inline(always)]
            pub fn ctph(&self) -> CTPH_R {
                CTPH_R::new(((self.bits >> 28) & 0x0f) as u8)
            }
            ///Bits 24:27 - Charge transfer pulse low
            #[inline(always)]
            pub fn ctpl(&self) -> CTPL_R {
                CTPL_R::new(((self.bits >> 24) & 0x0f) as u8)
            }
            ///Bits 17:23 - Spread spectrum deviation
            #[inline(always)]
            pub fn ssd(&self) -> SSD_R {
                SSD_R::new(((self.bits >> 17) & 0x7f) as u8)
            }
            ///Bit 16 - Spread spectrum enable
            #[inline(always)]
            pub fn sse(&self) -> SSE_R {
                SSE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - Spread spectrum prescaler
            #[inline(always)]
            pub fn sspsc(&self) -> SSPSC_R {
                SSPSC_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bits 12:14 - pulse generator prescaler
            #[inline(always)]
            pub fn pgpsc(&self) -> PGPSC_R {
                PGPSC_R::new(((self.bits >> 12) & 0x07) as u8)
            }
            ///Bits 5:7 - Max count value
            #[inline(always)]
            pub fn mcv(&self) -> MCV_R {
                MCV_R::new(((self.bits >> 5) & 0x07) as u8)
            }
            ///Bit 4 - I/O Default mode
            #[inline(always)]
            pub fn iodef(&self) -> IODEF_R {
                IODEF_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Synchronization pin polarity
            #[inline(always)]
            pub fn syncpol(&self) -> SYNCPOL_R {
                SYNCPOL_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Acquisition mode
            #[inline(always)]
            pub fn am(&self) -> AM_R {
                AM_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Start a new acquisition
            #[inline(always)]
            pub fn start(&self) -> START_R {
                START_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Touch sensing controller enable
            #[inline(always)]
            pub fn tsce(&self) -> TSCE_R {
                TSCE_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bits 28:31 - Charge transfer pulse high
            #[inline(always)]
            pub fn ctph(&mut self) -> CTPH_W {
                CTPH_W { w: self }
            }
            ///Bits 24:27 - Charge transfer pulse low
            #[inline(always)]
            pub fn ctpl(&mut self) -> CTPL_W {
                CTPL_W { w: self }
            }
            ///Bits 17:23 - Spread spectrum deviation
            #[inline(always)]
            pub fn ssd(&mut self) -> SSD_W {
                SSD_W { w: self }
            }
            ///Bit 16 - Spread spectrum enable
            #[inline(always)]
            pub fn sse(&mut self) -> SSE_W {
                SSE_W { w: self }
            }
            ///Bit 15 - Spread spectrum prescaler
            #[inline(always)]
            pub fn sspsc(&mut self) -> SSPSC_W {
                SSPSC_W { w: self }
            }
            ///Bits 12:14 - pulse generator prescaler
            #[inline(always)]
            pub fn pgpsc(&mut self) -> PGPSC_W {
                PGPSC_W { w: self }
            }
            ///Bits 5:7 - Max count value
            #[inline(always)]
            pub fn mcv(&mut self) -> MCV_W {
                MCV_W { w: self }
            }
            ///Bit 4 - I/O Default mode
            #[inline(always)]
            pub fn iodef(&mut self) -> IODEF_W {
                IODEF_W { w: self }
            }
            ///Bit 3 - Synchronization pin polarity
            #[inline(always)]
            pub fn syncpol(&mut self) -> SYNCPOL_W {
                SYNCPOL_W { w: self }
            }
            ///Bit 2 - Acquisition mode
            #[inline(always)]
            pub fn am(&mut self) -> AM_W {
                AM_W { w: self }
            }
            ///Bit 1 - Start a new acquisition
            #[inline(always)]
            pub fn start(&mut self) -> START_W {
                START_W { w: self }
            }
            ///Bit 0 - Touch sensing controller enable
            #[inline(always)]
            pub fn tsce(&mut self) -> TSCE_W {
                TSCE_W { w: self }
            }
        }
    }
    ///interrupt enable register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ier](ier) module
    pub type IER = crate::Reg<u32, _IER>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IER;
    ///`read()` method returns [ier::R](ier::R) reader structure
    impl crate::Readable for IER {}
    ///`write(|w| ..)` method takes [ier::W](ier::W) writer structure
    impl crate::Writable for IER {}
    ///interrupt enable register
    pub mod ier {
        ///Reader of register IER
        pub type R = crate::R<u32, super::IER>;
        ///Writer for register IER
        pub type W = crate::W<u32, super::IER>;
        ///Register IER `reset()`'s with value 0
        impl crate::ResetValue for super::IER {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEIE`
        pub type MCEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEIE`
        pub struct MCEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAIE`
        pub type EOAIE_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAIE`
        pub struct EOAIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error interrupt enable
            #[inline(always)]
            pub fn mceie(&self) -> MCEIE_R {
                MCEIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition interrupt enable
            #[inline(always)]
            pub fn eoaie(&self) -> EOAIE_R {
                EOAIE_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error interrupt enable
            #[inline(always)]
            pub fn mceie(&mut self) -> MCEIE_W {
                MCEIE_W { w: self }
            }
            ///Bit 0 - End of acquisition interrupt enable
            #[inline(always)]
            pub fn eoaie(&mut self) -> EOAIE_W {
                EOAIE_W { w: self }
            }
        }
    }
    ///interrupt clear register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [icr](icr) module
    pub type ICR = crate::Reg<u32, _ICR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ICR;
    ///`read()` method returns [icr::R](icr::R) reader structure
    impl crate::Readable for ICR {}
    ///`write(|w| ..)` method takes [icr::W](icr::W) writer structure
    impl crate::Writable for ICR {}
    ///interrupt clear register
    pub mod icr {
        ///Reader of register ICR
        pub type R = crate::R<u32, super::ICR>;
        ///Writer for register ICR
        pub type W = crate::W<u32, super::ICR>;
        ///Register ICR `reset()`'s with value 0
        impl crate::ResetValue for super::ICR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEIC`
        pub type MCEIC_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEIC`
        pub struct MCEIC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEIC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAIC`
        pub type EOAIC_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAIC`
        pub struct EOAIC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAIC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error interrupt clear
            #[inline(always)]
            pub fn mceic(&self) -> MCEIC_R {
                MCEIC_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition interrupt clear
            #[inline(always)]
            pub fn eoaic(&self) -> EOAIC_R {
                EOAIC_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error interrupt clear
            #[inline(always)]
            pub fn mceic(&mut self) -> MCEIC_W {
                MCEIC_W { w: self }
            }
            ///Bit 0 - End of acquisition interrupt clear
            #[inline(always)]
            pub fn eoaic(&mut self) -> EOAIC_W {
                EOAIC_W { w: self }
            }
        }
    }
    ///interrupt status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [isr](isr) module
    pub type ISR = crate::Reg<u32, _ISR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ISR;
    ///`read()` method returns [isr::R](isr::R) reader structure
    impl crate::Readable for ISR {}
    ///`write(|w| ..)` method takes [isr::W](isr::W) writer structure
    impl crate::Writable for ISR {}
    ///interrupt status register
    pub mod isr {
        ///Reader of register ISR
        pub type R = crate::R<u32, super::ISR>;
        ///Writer for register ISR
        pub type W = crate::W<u32, super::ISR>;
        ///Register ISR `reset()`'s with value 0
        impl crate::ResetValue for super::ISR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEF`
        pub type MCEF_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEF`
        pub struct MCEF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAF`
        pub type EOAF_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAF`
        pub struct EOAF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error flag
            #[inline(always)]
            pub fn mcef(&self) -> MCEF_R {
                MCEF_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition flag
            #[inline(always)]
            pub fn eoaf(&self) -> EOAF_R {
                EOAF_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error flag
            #[inline(always)]
            pub fn mcef(&mut self) -> MCEF_W {
                MCEF_W { w: self }
            }
            ///Bit 0 - End of acquisition flag
            #[inline(always)]
            pub fn eoaf(&mut self) -> EOAF_W {
                EOAF_W { w: self }
            }
        }
    }
    ///I/O hysteresis control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [iohcr](iohcr) module
    pub type IOHCR = crate::Reg<u32, _IOHCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOHCR;
    ///`read()` method returns [iohcr::R](iohcr::R) reader structure
    impl crate::Readable for IOHCR {}
    ///`write(|w| ..)` method takes [iohcr::W](iohcr::W) writer structure
    impl crate::Writable for IOHCR {}
    ///I/O hysteresis control register
    pub mod iohcr {
        ///Reader of register IOHCR
        pub type R = crate::R<u32, super::IOHCR>;
        ///Writer for register IOHCR
        pub type W = crate::W<u32, super::IOHCR>;
        ///Register IOHCR `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::IOHCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O analog switch control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ioascr](ioascr) module
    pub type IOASCR = crate::Reg<u32, _IOASCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOASCR;
    ///`read()` method returns [ioascr::R](ioascr::R) reader structure
    impl crate::Readable for IOASCR {}
    ///`write(|w| ..)` method takes [ioascr::W](ioascr::W) writer structure
    impl crate::Writable for IOASCR {}
    ///I/O analog switch control register
    pub mod ioascr {
        ///Reader of register IOASCR
        pub type R = crate::R<u32, super::IOASCR>;
        ///Writer for register IOASCR
        pub type W = crate::W<u32, super::IOASCR>;
        ///Register IOASCR `reset()`'s with value 0
        impl crate::ResetValue for super::IOASCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O sampling control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ioscr](ioscr) module
    pub type IOSCR = crate::Reg<u32, _IOSCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOSCR;
    ///`read()` method returns [ioscr::R](ioscr::R) reader structure
    impl crate::Readable for IOSCR {}
    ///`write(|w| ..)` method takes [ioscr::W](ioscr::W) writer structure
    impl crate::Writable for IOSCR {}
    ///I/O sampling control register
    pub mod ioscr {
        ///Reader of register IOSCR
        pub type R = crate::R<u32, super::IOSCR>;
        ///Writer for register IOSCR
        pub type W = crate::W<u32, super::IOSCR>;
        ///Register IOSCR `reset()`'s with value 0
        impl crate::ResetValue for super::IOSCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
          