# Supported Devices

## STM32F0

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32f0x0` | STM32F030, STM32F070 | [RM0360](https://www.st.com/resource/en/reference_manual/dm00091010.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f0x0-value-line.html) |
| `stm32f0x1` | STM32F031, STM32F051, STM32F071, STM32F091 | [RM0091](https://www.st.com/resource/en/reference_manual/dm00031936.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f0x1.html) |
| `stm32f0x2` | STM32F042, STM32F072 | [RM0091](https://www.st.com/resource/en/reference_manual/dm00031936.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f0x2.html) |
| `stm32f0x8` | STM32F038, STM32F048, STM32F058, STM32F078, STM32F098 | [RM0091](https://www.st.com/resource/en/reference_manual/dm00031936.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f0x8.html) |



## STM32F1

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32f100` | STM32F100 | [RM0041](https://www.st.com/resource/en/reference_manual/cd00246267.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f100-value-line.html) |
| `stm32f101` | STM32F101 | [RM0008](https://www.st.com/resource/en/reference_manual/cd00171190.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f101.html) |
| `stm32f102` | STM32F102 | [RM0008](https://www.st.com/resource/en/reference_manual/cd00171190.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f102.html) |
| `stm32f103` | STM32F103 | [RM0008](https://www.st.com/resource/en/reference_manual/cd00171190.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f103.html) |
| `stm32f107` | STM32F105, STM32F107 | [RM0008](https://www.st.com/resource/en/reference_manual/cd00171190.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f105-107.html) |



## STM32F2

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32f215` | STM32F205, STM32F215 | [RM0033](https://www.st.com/resource/en/reference_manual/cd00225773.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f2x5.html) |
| `stm32f217` | STM32F207, STM32F217 | [RM0033](https://www.st.com/resource/en/reference_manual/cd00225773.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f2x7.html) |



## STM32F3

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32f301` | STM32F301, STM32F318 | [RM0366](https://www.st.com/resource/en/reference_manual/dm00094350.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f301.html) |
| `stm32f302` | STM32F302 | [RM0365](https://www.st.com/resource/en/reference_manual/dm00094349.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f302.html) |
| `stm32f303` | STM32F303, STM32F328, STM32F358, STM32F398 | [RM0316](https://www.st.com/resource/en/reference_manual/dm00043574.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f303.html) |
| `stm32f373` | STM32F373, STM32F378 | [RM0313](https://www.st.com/resource/en/reference_manual/dm00041563.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f373.html) |
| `stm32f3x4` | STM32F334 | [RM0364](https://www.st.com/resource/en/reference_manual/dm00093941.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f334.html) |



## STM32F4

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32f401` | STM32F401 | [RM0368](https://www.st.com/resource/en/reference_manual/dm00096844.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f401.html) |
| `stm32f405` | STM32F405, STM32F415 | [RM0090](https://www.st.com/resource/en/reference_manual/dm00031020.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f405-415.html) |
| `stm32f407` | STM32F407, STM32F417 | [RM0090](https://www.st.com/resource/en/reference_manual/dm00031020.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f407-417.html) |
| `stm32f410` | STM32F410 | [RM0401](https://www.st.com/resource/en/reference_manual/dm00180366.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f410.html) |
| `stm32f411` | STM32F411 | [RM0383](https://www.st.com/resource/en/reference_manual/dm00119316.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f411.html) |
| `stm32f412` | STM32F412 | [RM0402](https://www.st.com/resource/en/reference_manual/dm00180369.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f412.html) |
| `stm32f413` | STM32F413, STM32F423 | [RM0430](https://www.st.com/resource/en/reference_manual/dm00305666.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f413-423.html) |
| `stm32f427` | STM32F427, STM32F437 | [RM0090](https://www.st.com/resource/en/reference_manual/dm00031020.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f427-437.html) |
| `stm32f429` | STM32F429, STM32F439 | [RM0090](https://www.st.com/resource/en/reference_manual/dm00031020.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f429-439.html) |
| `stm32f446` | STM32F446 | [RM0390](https://www.st.com/resource/en/reference_manual/dm00135183.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f446.html) |
| `stm32f469` | STM32F469, STM32F479 | [RM0386](https://www.st.com/resource/en/reference_manual/dm00127514.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f469-479.html) |



## STM32F7

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32f730` | STM32F730 | [RM0431](https://www.st.com/resource/en/reference_manual/dm00305990.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x0-value-line.html) |
| `stm32f750` | STM32F750 | [RM0385](https://www.st.com/resource/en/reference_manual/dm00124865.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x0-value-line.html) |
| `stm32f7x2` | STM32F722, STM32F732 | [RM0431](https://www.st.com/resource/en/reference_manual/dm00305990.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x2.html) |
| `stm32f7x3` | STM32F723, STM32F733 | [RM0431](https://www.st.com/resource/en/reference_manual/dm00305990.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x3.html) |
| `stm32f745` | STM32F745 | [RM0385](https://www.st.com/resource/en/reference_manual/dm00124865.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x5.html) |
| `stm32f765` | STM32F765 | [RM0410](https://www.st.com/resource/en/reference_manual/dm00224583.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x5.html) |
| `stm32f7x6` | STM32F746, STM32F756 | [RM0385](https://www.st.com/resource/en/reference_manual/dm00124865.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x6.html) |
| `stm32f7x7` | STM32F767, STM32F777 | [RM0410](https://www.st.com/resource/en/reference_manual/dm00224583.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x7.html) |
| `stm32f7x9` | STM32F769, STM32F778, STM32F779 | [RM0410](https://www.st.com/resource/en/reference_manual/dm00224583.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f7x9.html) |



## STM32H7

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32h743` | STM32H743 | [RM0433](https://www.st.com/resource/en/reference_manual/dm00314099.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32h743-753.html) |
| `stm32h743v` | STM32H743V | [RM0433](https://www.st.com/resource/en/reference_manual/dm00314099.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32h743-753.html) |
| `stm32h753` | STM32H753 | [RM0433](https://www.st.com/resource/en/reference_manual/dm00314099.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32h743-753.html) |
| `stm32h753v` | STM32H753V | [RM0433](https://www.st.com/resource/en/reference_manual/dm00314099.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32h743-753.html) |
| `stm32h735` | STM32H723, STM32H725, STM32H730, STM32H733, STM32H735 | [RM0468](https://www.st.com/resource/en/reference_manual/dm00603761.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32h730-value-line.html) |
| `stm32h7b3` | STM32H7A3, STM32H7B3, STM32H7B0 | [RM0455](https://www.st.com/resource/en/reference_manual/dm00463927.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32h7a3-7b3.html) |
| `stm32h747cm7` | STM32H745 (CM7), STM32H747 (CM7), STM32H755 (CM7), STM32H757 (CM7) | [RM0399](https://www.st.com/resource/en/reference_manual/dm00176879.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32h747-757.html) |
| `stm32h747cm4` | STM32H745 (CM4), STM32H747 (CM4), STM32H755 (CM4), STM32H757 (CM4) | [RM0399](https://www.st.com/resource/en/reference_manual/dm00176879.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32h747-757.html) |



## STM32L0

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32l0x0` | STM32L010 | [RM0451](https://www.st.com/resource/en/reference_manual/dm00443854-ultralowpower-stm32l0x0-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l0x0-value-line.html) |
| `stm32l0x1` | STM32L011, STM32L021, STM32L031, STM32L041, STM32L051, STM32L071, STM32L081 | [RM0377](https://www.st.com/resource/en/reference_manual/dm00108282.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l0x1.html) |
| `stm32l0x2` | STM32L052, STM32L062, STM32L072, STM32L082 | [RM0376](https://www.st.com/resource/en/reference_manual/dm00108281.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l0x2.html) |
| `stm32l0x3` | STM32L053, STM32L063, STM32L073, STM32L083 | [RM0367](https://www.st.com/resource/en/reference_manual/dm00095744.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l0x3.html) |



## STM32L1

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32l100` | STM32L100 | [RM0038](https://www.st.com/resource/en/reference_manual/cd00240193.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l100-value-line.html) |
| `stm32l151` | STM32L151, STM32L152 | [RM0038](https://www.st.com/resource/en/reference_manual/cd00240193.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l151-152.html) |
| `stm32l162` | STM32L162 | [RM0038](https://www.st.com/resource/en/reference_manual/cd00240193.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l162.html) |



## STM32L4

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32l4x1` | STM32L431, STM32L451, STM32L471 | [RM0394](https://www.st.com/resource/en/reference_manual/dm00151940.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l4x1.html) |
| `stm32l4x2` | STM32L432, STM32L442, STM32L452, STM32L462 | [RM0394](https://www.st.com/resource/en/reference_manual/dm00151940.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l4x2.html) |
| `stm32l412` | STM32L412, STM32L422 | [RM0394](https://www.st.com/resource/en/reference_manual/dm00151940.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l4x2.html) |
| `stm32l4x3` | STM32L433, STM32L443 | [RM0394](https://www.st.com/resource/en/reference_manual/dm00151940.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l4x3.html) |
| `stm32l4x5` | STM32L475 | [RM0351](https://www.st.com/resource/en/reference_manual/dm00083560.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l4x5.html) |
| `stm32l4x6` | STM32L476, STM32L486, STM32L496, STM32L4A6 | [RM0351](https://www.st.com/resource/en/reference_manual/dm00083560.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l4x6.html) |
| `stm32l4r9` | STM32L4R9, STM32L4S9 | [RM0432](https://www.st.com/resource/en/reference_manual/dm00310109.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32l4r9-s9.html) |



## STM32L5

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32l552` | STM32L552 | [RM0438](https://www.st.com/resource/en/reference_manual/dm00346336.pdf), [st.com](https://www.st.com/content/st_com/en/products/microcontrollers/stm32-32-bit-arm-cortex-mcus/stm32-ultra-low-power-mcus/stm32l5-series/stm32l5x2.html) |
| `stm32l562` | STM32L562 | [RM0438](https://www.st.com/resource/en/reference_manual/dm00346336.pdf), [st.com](https://www.st.com/content/st_com/en/products/microcontrollers/stm32-32-bit-arm-cortex-mcus/stm32-ultra-low-power-mcus/stm32l5-series/stm32l5x2.html) |



## STM32G0

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32g030` | STM32G030 | [RM0454](https://www.st.com/resource/en/reference_manual/dm00463896-stm32g0x0-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x0-value-line.html) |
| `stm32g050` | STM32G050 | [RM0454](https://www.st.com/resource/en/reference_manual/dm00463896-stm32g0x0-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x0-value-line.html) |
| `stm32g070` | STM32G070 | [RM0454](https://www.st.com/resource/en/reference_manual/dm00463896-stm32g0x0-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x0-value-line.html) |
| `stm32g0b0` | STM32G0b0 | [RM0454](https://www.st.com/resource/en/reference_manual/dm00463896-stm32g0x0-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x0-value-line.html) |
| `stm32g031` | STM32G031 | [RM0444](https://www.st.com/resource/en/reference_manual/dm00371828-stm32g0x1-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x1.html) |
| `stm32g041` | STM32G041 | [RM0444](https://www.st.com/resource/en/reference_manual/dm00371828-stm32g0x1-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x1.html) |
| `stm32g051` | STM32G051 | [RM0444](https://www.st.com/resource/en/reference_manual/dm00371828-stm32g0x1-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x1.html) |
| `stm32g061` | STM32G061 | [RM0444](https://www.st.com/resource/en/reference_manual/dm00371828-stm32g0x1-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x1.html) |
| `stm32g071` | STM32G071 | [RM0444](https://www.st.com/resource/en/reference_manual/dm00371828-stm32g0x1-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x1.html) |
| `stm32g081` | STM32G081 | [RM0444](https://www.st.com/resource/en/reference_manual/dm00371828-stm32g0x1-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x1.html) |
| `stm32g0b1` | STM32G0b1 | [RM0444](https://www.st.com/resource/en/reference_manual/dm00371828-stm32g0x1-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x1.html) |
| `stm32g0c1` | STM32G0c1 | [RM0444](https://www.st.com/resource/en/reference_manual/dm00371828-stm32g0x1-advanced-armbased-32bit-mcus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g0x1.html) |



## STM32G4

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32g4x1` | STM32G431, STM32G441, STM32G491 | [RM0440](https://www.st.com/resource/en/reference_manual/dm00355726.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g4x1.html) |
| `stm32g4x3` | STM32G473, STM32G483 | [RM0440](https://www.st.com/resource/en/reference_manual/dm00355726.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g4x3.html) |
| `stm32g4x4` | STM32G474, STM32G484 | [RM0440](https://www.st.com/resource/en/reference_manual/dm00355726.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32g4x4.html) |



## STM32MP1

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32mp157` | STM32MP157 | [RM0436](https://www.st.com/resource/en/reference_manual/dm00366355-stm32mp157-advanced-armbased-32bit-mpus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32mp157.html) |
| `stm32mp153` | STM32MP153 | [RM0442](https://www.st.com/resource/en/reference_manual/rm0442-stm32mp153-advanced-armbased-32bit-mpus-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32mp153.html) |



## STM32WL

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32wle5` | STM32WLE5 | [RM0461](https://www.st.com/resource/en/reference_manual/dm00530369-stm32wlex-advanced-armbased-32bit-mcus-with-subghz-radio-solution-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32wlex.html) |
| `stm32wl5x_cm4` | STM32WL5X (CM4) | [RM0453](https://www.st.com/resource/en/reference_manual/dm00451556-stm32wl5x-advanced-armbased-32bit-mcus-with-subghz-radio-solution-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32wl5x.html) |
| `stm32wl5x_cm0p` | STM32WL5X (CM0+) | [RM0453](https://www.st.com/resource/en/reference_manual/dm00451556-stm32wl5x-advanced-armbased-32bit-mcus-with-subghz-radio-solution-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32wl5x.html) |



## STM32WB

| Feature | Devices | Links |
|:-------:|:-------:|:-----:|
| `stm32wb55` | STM32WB55 | [RM0434](https://www.st.com/resource/en/reference_manual/dm00318631-multiprotocol-wireless-32bit-mcu-armbased-cortexm4-with-fpu-bluetooth-lowenergy-and-802154-radio-solution-stmicroelectronics.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32wbx5.html) |



