#![allow(non_snake_case, non_upper_case_globals)]
#![allow(non_camel_case_types)]
//! RCC
//!
//! Used by: stm32mp153, stm32mp157

#[cfg(not(feature = "nosync"))]
pub use crate::stm32mp::peripherals::rcc::Instance;
pub use crate::stm32mp::peripherals::rcc::{RegisterBlock, ResetValues};
pub use crate::stm32mp::peripherals::rcc::{
    RCC_ADCCKSELR, RCC_AHB2RSTCLRR, RCC_AHB2RSTSETR, RCC_AHB3RSTCLRR, RCC_AHB3RSTSETR,
    RCC_AHB4RSTCLRR, RCC_AHB4RSTSETR, RCC_AHB5RSTCLRR, RCC_AHB5RSTSETR, RCC_AHB6RSTCLRR,
    RCC_AHB6RSTSETR, RCC_APB1DIVR, RCC_APB1RSTCLRR, RCC_APB1RSTSETR, RCC_APB2DIVR, RCC_APB2RSTCLRR,
    RCC_APB2RSTSETR, RCC_APB3DIVR, RCC_APB3RSTCLRR, RCC_APB3RSTSETR, RCC_APB4DIVR, RCC_APB4RSTCLRR,
    RCC_APB4RSTSETR, RCC_APB5DIVR, RCC_APB5RSTCLRR, RCC_APB5RSTSETR, RCC_ASSCKSELR, RCC_AXIDIVR,
    RCC_BDCR, RCC_BR_RSTSCLRR, RCC_CECCKSELR, RCC_CPERCKSELR, RCC_CSICFGR, RCC_DBGCFGR,
    RCC_DDRITFCR, RCC_DSICKSELR, RCC_ETHCKSELR, RCC_FDCANCKSELR, RCC_FMCCKSELR, RCC_HSICFGR,
    RCC_I2C12CKSELR, RCC_I2C35CKSELR, RCC_I2C46CKSELR, RCC_IDR, RCC_LPTIM1CKSELR,
    RCC_LPTIM23CKSELR, RCC_LPTIM45CKSELR, RCC_MCO1CFGR, RCC_MCO2CFGR, RCC_MCUDIVR,
    RCC_MC_AHB2ENCLRR, RCC_MC_AHB2ENSETR, RCC_MC_AHB2LPENCLRR, RCC_MC_AHB2LPENSETR,
    RCC_MC_AHB3ENCLRR, RCC_MC_AHB3ENSETR, RCC_MC_AHB3LPENCLRR, RCC_MC_AHB3LPENSETR,
    RCC_MC_AHB4ENCLRR, RCC_MC_AHB4ENSETR, RCC_MC_AHB4LPENCLRR, RCC_MC_AHB4LPENSETR,
    RCC_MC_AHB5ENCLRR, RCC_MC_AHB5ENSETR, RCC_MC_AHB5LPENCLRR, RCC_MC_AHB5LPENSETR,
    RCC_MC_AHB6ENCLRR, RCC_MC_AHB6ENSETR, RCC_MC_AHB6LPENCLRR, RCC_MC_AHB6LPENSETR,
    RCC_MC_APB1ENCLRR, RCC_MC_APB1ENSETR, RCC_MC_APB1LPENCLRR, RCC_MC_APB1LPENSETR,
    RCC_MC_APB2ENCLRR, RCC_MC_APB2ENSETR, RCC_MC_APB2LPENCLRR, RCC_MC_APB2LPENSETR,
    RCC_MC_APB3ENCLRR, RCC_MC_APB3ENSETR, RCC_MC_APB3LPENCLRR, RCC_MC_APB3LPENSETR,
    RCC_MC_APB4ENCLRR, RCC_MC_APB4ENSETR, RCC_MC_APB4LPENCLRR, RCC_MC_APB4LPENSETR,
    RCC_MC_APB5ENCLRR, RCC_MC_APB5ENSETR, RCC_MC_APB5LPENCLRR, RCC_MC_APB5LPENSETR,
    RCC_MC_AXIMENCLRR, RCC_MC_AXIMENSETR, RCC_MC_AXIMLPENCLRR, RCC_MC_AXIMLPENSETR, RCC_MC_CIER,
    RCC_MC_CIFR, RCC_MC_MLAHBENCLRR, RCC_MC_MLAHBENSETR, RCC_MC_MLAHBLPENCLRR,
    RCC_MC_MLAHBLPENSETR, RCC_MC_RSTSCLRR, RCC_MPCKDIVR, RCC_MPCKSELR, RCC_MP_AHB2ENCLRR,
    RCC_MP_AHB2ENSETR, RCC_MP_AHB2LPENCLRR, RCC_MP_AHB2LPENSETR, RCC_MP_AHB3ENCLRR,
    RCC_MP_AHB3ENSETR, RCC_MP_AHB3LPENCLRR, RCC_MP_AHB3LPENSETR, RCC_MP_AHB4ENCLRR,
    RCC_MP_AHB4ENSETR, RCC_MP_AHB4LPENCLRR, RCC_MP_AHB4LPENSETR, RCC_MP_AHB5ENCLRR,
    RCC_MP_AHB5ENSETR, RCC_MP_AHB5LPENCLRR, RCC_MP_AHB5LPENSETR, RCC_MP_AHB6ENCLRR,
    RCC_MP_AHB6ENSETR, RCC_MP_AHB6LPENCLRR, RCC_MP_AHB6LPENSETR, RCC_MP_APB1ENCLRR,
    RCC_MP_APB1ENSETR, RCC_MP_APB1LPENCLRR, RCC_MP_APB1LPENSETR, RCC_MP_APB2ENCLRR,
    RCC_MP_APB2ENSETR, RCC_MP_APB2LPENCLRR, RCC_MP_APB2LPENSETR, RCC_MP_APB3ENCLRR,
    RCC_MP_APB3ENSETR, RCC_MP_APB3LPENCLRR, RCC_MP_APB3LPENSETR, RCC_MP_APB4ENCLRR,
    RCC_MP_APB4ENSETR, RCC_MP_APB4LPENCLRR, RCC_MP_APB4LPENSETR, RCC_MP_APB5ENCLRR,
    RCC_MP_APB5ENSETR, RCC_MP_APB5LPENCLRR, RCC_MP_APB5LPENSETR, RCC_MP_APRSTCR, RCC_MP_APRSTSR,
    RCC_MP_AXIMLPENCLRR, RCC_MP_AXIMLPENSETR, RCC_MP_BOOTCR, RCC_MP_CIER, RCC_MP_CIFR, RCC_MP_GCR,
    RCC_MP_GRSTCSETR, RCC_MP_IWDGFZCLRR, RCC_MP_IWDGFZSETR, RCC_MP_MLAHBENCLRR, RCC_MP_MLAHBENSETR,
    RCC_MP_MLAHBLPENCLRR, RCC_MP_MLAHBLPENSETR, RCC_MP_RSTSCLRR, RCC_MP_RSTSSETR, RCC_MP_SREQCLRR,
    RCC_MP_SREQSETR, RCC_MP_TZAHB6ENCLRR, RCC_MP_TZAHB6ENSETR, RCC_MP_TZAHB6LPENCLRR,
    RCC_MP_TZAHB6LPENSETR, RCC_MSSCKSELR, RCC_OCENCLRR, RCC_OCENSETR, RCC_OCRDYR, RCC_PLL1CFGR1,
    RCC_PLL1CFGR2, RCC_PLL1CR, RCC_PLL1CSGR, RCC_PLL1FRACR, RCC_PLL2CFGR1, RCC_PLL2CFGR2,
    RCC_PLL2CR, RCC_PLL2CSGR, RCC_PLL2FRACR, RCC_PLL3CFGR1, RCC_PLL3CFGR2, RCC_PLL3CR,
    RCC_PLL3CSGR, RCC_PLL3FRACR, RCC_PLL4CFGR1, RCC_PLL4CFGR2, RCC_PLL4CR, RCC_PLL4CSGR,
    RCC_PLL4FRACR, RCC_PWRLPDLYCR, RCC_QSPICKSELR, RCC_RCK12SELR, RCC_RCK3SELR, RCC_RCK4SELR,
    RCC_RDLSICR, RCC_RNG1CKSELR, RCC_RNG2CKSELR, RCC_RTCDIVR, RCC_SAI1CKSELR, RCC_SAI2CKSELR,
    RCC_SAI3CKSELR, RCC_SAI4CKSELR, RCC_SDMMC12CKSELR, RCC_SDMMC3CKSELR, RCC_SIDR, RCC_SPDIFCKSELR,
    RCC_SPI2S1CKSELR, RCC_SPI2S23CKSELR, RCC_SPI45CKSELR, RCC_SPI6CKSELR, RCC_STGENCKSELR,
    RCC_TIMG1PRER, RCC_TIMG2PRER, RCC_TZAHB6RSTCLRR, RCC_TZAHB6RSTSETR, RCC_TZCR, RCC_UART1CKSELR,
    RCC_UART24CKSELR, RCC_UART35CKSELR, RCC_UART6CKSELR, RCC_UART78CKSELR, RCC_USBCKSELR, RCC_VERR,
};

/// Access functions for the RCC peripheral instance
pub mod RCC {
    use super::ResetValues;

    #[cfg(not(feature = "nosync"))]
    use super::Instance;

    #[cfg(not(feature = "nosync"))]
    const INSTANCE: Instance = Instance {
        addr: 0x50000000,
        _marker: ::core::marker::PhantomData,
    };

    /// Reset values for each field in RCC
    pub const reset: ResetValues = ResetValues {
        RCC_TZCR: 0x00000003,
        RCC_OCENSETR: 0x00000001,
        RCC_OCENCLRR: 0x00000001,
        RCC_HSICFGR: 0x00000000,
        RCC_CSICFGR: 0x00001000,
        RCC_MPCKSELR: 0x80000000,
        RCC_ASSCKSELR: 0x80000000,
        RCC_RCK12SELR: 0x80000000,
        RCC_MPCKDIVR: 0x80000001,
        RCC_AXIDIVR: 0x80000000,
        RCC_APB4DIVR: 0x80000000,
        RCC_APB5DIVR: 0x80000000,
        RCC_RTCDIVR: 0x00000000,
        RCC_MSSCKSELR: 0x80000000,
        RCC_PLL1CR: 0x00000000,
        RCC_PLL1CFGR1: 0x00010031,
        RCC_PLL1CFGR2: 0x00010100,
        RCC_PLL1FRACR: 0x00000000,
        RCC_PLL1CSGR: 0x00000000,
        RCC_PLL2CR: 0x00000000,
        RCC_PLL2CFGR1: 0x00010063,
        RCC_PLL2CFGR2: 0x00010101,
        RCC_PLL2FRACR: 0x00000000,
        RCC_PLL2CSGR: 0x00000000,
        RCC_I2C46CKSELR: 0x00000000,
        RCC_SPI6CKSELR: 0x00000000,
        RCC_UART1CKSELR: 0x00000000,
        RCC_RNG1CKSELR: 0x00000000,
        RCC_CPERCKSELR: 0x00000000,
        RCC_STGENCKSELR: 0x00000000,
        RCC_DDRITFCR: 0x000FD02A,
        RCC_MP_BOOTCR: 0x00000000,
        RCC_MP_SREQSETR: 0x00000000,
        RCC_MP_SREQCLRR: 0x00000000,
        RCC_MP_GCR: 0x00000000,
        RCC_MP_APRSTCR: 0x00007F00,
        RCC_MP_APRSTSR: 0x00000000,
        RCC_BDCR: 0x00000020,
        RCC_RDLSICR: 0x00000000,
        RCC_APB4RSTSETR: 0x00000000,
        RCC_APB4RSTCLRR: 0x00000000,
        RCC_APB5RSTSETR: 0x00000000,
        RCC_APB5RSTCLRR: 0x00000000,
        RCC_AHB5RSTSETR: 0x00000000,
        RCC_AHB5RSTCLRR: 0x00000000,
        RCC_AHB6RSTSETR: 0x00000000,
        RCC_AHB6RSTCLRR: 0x00000000,
        RCC_TZAHB6RSTSETR: 0x00000000,
        RCC_TZAHB6RSTCLRR: 0x00000000,
        RCC_MP_APB4ENSETR: 0x00000000,
        RCC_MP_APB4ENCLRR: 0x00000000,
        RCC_MP_APB5ENSETR: 0x00000000,
        RCC_MP_APB5ENCLRR: 0x00000000,
        RCC_MP_AHB5ENSETR: 0x00010000,
        RCC_MP_AHB5ENCLRR: 0x00010000,
        RCC_MP_AHB6ENSETR: 0x00000000,
        RCC_MP_AHB6ENCLRR: 0x00000000,
        RCC_MP_TZAHB6ENSETR: 0x00000000,
        RCC_MP_TZAHB6ENCLRR: 0x00000000,
        RCC_MC_APB4ENSETR: 0x00000000,
        RCC_MC_APB4ENCLRR: 0x00000000,
        RCC_MC_APB5ENSETR: 0x00000000,
        RCC_MC_APB5ENCLRR: 0x00000000,
        RCC_MC_AHB5ENSETR: 0x00000000,
        RCC_MC_AHB5ENCLRR: 0x00000000,
        RCC_MC_AHB6ENSETR: 0x00000000,
        RCC_MC_AHB6ENCLRR: 0x00000000,
        RCC_MP_APB4LPENSETR: 0x00118111,
        RCC_MP_APB4LPENCLRR: 0x00118111,
        RCC_MP_APB5LPENSETR: 0x0011391D,
        RCC_MP_APB5LPENCLRR: 0x0011391D,
        RCC_MP_AHB5LPENSETR: 0x00000171,
        RCC_MP_AHB5LPENCLRR: 0x00000171,
        RCC_MP_AHB6LPENSETR: 0x011357A1,
        RCC_MP_AHB6LPENCLRR: 0x011357A1,
        RCC_MP_TZAHB6LPENSETR: 0x00000001,
        RCC_MP_TZAHB6LPENCLRR: 0x00000001,
        RCC_MC_APB4LPENSETR: 0x00110111,
        RCC_MC_APB4LPENCLRR: 0x00110111,
        RCC_MC_APB5LPENSETR: 0x0011391D,
        RCC_MC_APB5LPENCLRR: 0x0011391D,
        RCC_MC_AHB5LPENSETR: 0x00000171,
        RCC_MC_AHB5LPENCLRR: 0x00000171,
        RCC_MC_AHB6LPENSETR: 0x011357A1,
        RCC_MC_AHB6LPENCLRR: 0x011357A1,
        RCC_BR_RSTSCLRR: 0x00000015,
        RCC_MP_GRSTCSETR: 0x00000000,
        RCC_MP_RSTSCLRR: 0x00000000,
        RCC_MP_IWDGFZSETR: 0x00000000,
        RCC_MP_IWDGFZCLRR: 0x00000000,
        RCC_MP_CIER: 0x00000000,
        RCC_MP_CIFR: 0x00000000,
        RCC_PWRLPDLYCR: 0x00000000,
        RCC_MP_RSTSSETR: 0x00000000,
        RCC_MCO1CFGR: 0x00000000,
        RCC_MCO2CFGR: 0x00000000,
        RCC_OCRDYR: 0x00000000,
        RCC_DBGCFGR: 0x00000001,
        RCC_RCK3SELR: 0x80000000,
        RCC_RCK4SELR: 0x80000000,
        RCC_TIMG1PRER: 0x80000000,
        RCC_TIMG2PRER: 0x80000000,
        RCC_MCUDIVR: 0x80000000,
        RCC_APB1DIVR: 0x80000000,
        RCC_APB2DIVR: 0x80000000,
        RCC_APB3DIVR: 0x80000000,
        RCC_PLL3CR: 0x00000000,
        RCC_PLL3CFGR1: 0x00010031,
        RCC_PLL3CFGR2: 0x00010101,
        RCC_PLL3FRACR: 0x00000000,
        RCC_PLL3CSGR: 0x00000000,
        RCC_PLL4CR: 0x00000000,
        RCC_PLL4CFGR1: 0x00010031,
        RCC_PLL4CFGR2: 0x00000000,
        RCC_PLL4FRACR: 0x00000000,
        RCC_PLL4CSGR: 0x00000000,
        RCC_I2C12CKSELR: 0x00000000,
        RCC_I2C35CKSELR: 0x00000000,
        RCC_SAI1CKSELR: 0x00000000,
        RCC_SAI2CKSELR: 0x00000000,
        RCC_SAI3CKSELR: 0x00000000,
        RCC_SAI4CKSELR: 0x00000000,
        RCC_SPI2S1CKSELR: 0x00000000,
        RCC_SPI2S23CKSELR: 0x00000000,
        RCC_SPI45CKSELR: 0x00000000,
        RCC_UART6CKSELR: 0x00000000,
        RCC_UART24CKSELR: 0x00000000,
        RCC_UART35CKSELR: 0x00000000,
        RCC_UART78CKSELR: 0x00000000,
        RCC_SDMMC12CKSELR: 0x00000003,
        RCC_SDMMC3CKSELR: 0x00000000,
        RCC_ETHCKSELR: 0x00000000,
        RCC_QSPICKSELR: 0x00000000,
        RCC_FMCCKSELR: 0x00000000,
        RCC_FDCANCKSELR: 0x00000000,
        RCC_SPDIFCKSELR: 0x00000000,
        RCC_CECCKSELR: 0x00000000,
        RCC_USBCKSELR: 0x00000000,
        RCC_RNG2CKSELR: 0x00000000,
        RCC_DSICKSELR: 0x00000000,
        RCC_ADCCKSELR: 0x00000000,
        RCC_LPTIM45CKSELR: 0x00000000,
        RCC_LPTIM23CKSELR: 0x00000000,
        RCC_LPTIM1CKSELR: 0x00000000,
        RCC_APB1RSTSETR: 0x00000000,
        RCC_APB1RSTCLRR: 0x00000000,
        RCC_APB2RSTSETR: 0x00000000,
        RCC_APB2RSTCLRR: 0x00000000,
        RCC_APB3RSTSETR: 0x00000000,
        RCC_APB3RSTCLRR: 0x00000000,
        RCC_AHB2RSTSETR: 0x00000000,
        RCC_AHB2RSTCLRR: 0x00000000,
        RCC_AHB3RSTSETR: 0x00000000,
        RCC_AHB3RSTCLRR: 0x00000000,
        RCC_AHB4RSTSETR: 0x00000000,
        RCC_AHB4RSTCLRR: 0x00000000,
        RCC_MP_APB1ENSETR: 0x00000000,
        RCC_MP_APB1ENCLRR: 0x00000000,
        RCC_MP_APB2ENSETR: 0x00000000,
        RCC_MP_APB2ENCLRR: 0x00000000,
        RCC_MP_APB3ENSETR: 0x00000000,
        RCC_MP_APB3ENCLRR: 0x00000000,
        RCC_MP_AHB2ENSETR: 0x00000000,
        RCC_MP_AHB2ENCLRR: 0x00000000,
        RCC_MP_AHB3ENSETR: 0x00000000,
        RCC_MP_AHB3ENCLRR: 0x00000000,
        RCC_MP_AHB4ENSETR: 0x00000000,
        RCC_MP_AHB4ENCLRR: 0x00000000,
        RCC_MP_MLAHBENSETR: 0x00000010,
        RCC_MP_MLAHBENCLRR: 0x00000010,
        RCC_MC_APB1ENSETR: 0x00000000,
        RCC_MC_APB1ENCLRR: 0x00000000,
        RCC_MC_APB2ENSETR: 0x00000000,
        RCC_MC_APB2ENCLRR: 0x00000000,
        RCC_MC_APB3ENSETR: 0x00000000,
        RCC_MC_APB3ENCLRR: 0x00000000,
        RCC_MC_AHB2ENSETR: 0x00000000,
        RCC_MC_AHB2ENCLRR: 0x00000000,
        RCC_MC_AHB3ENSETR: 0x00000000,
        RCC_MC_AHB3ENCLRR: 0x00000000,
        RCC_MC_AHB4ENSETR: 0x00000000,
        RCC_MC_AHB4ENCLRR: 0x00000000,
        RCC_MC_AXIMENSETR: 0x00000000,
        RCC_MC_AXIMENCLRR: 0x00000000,
        RCC_MC_MLAHBENSETR: 0x00000010,
        RCC_MC_MLAHBENCLRR: 0x00000010,
        RCC_MP_APB1LPENSETR: 0xADEFDBFF,
        RCC_MP_APB1LPENCLRR: 0xADEFDBFF,
        RCC_MP_APB2LPENSETR: 0x0137271F,
        RCC_MP_APB2LPENCLRR: 0x0137271F,
        RCC_MP_APB3LPENSETR: 0x0003290F,
        RCC_MP_APB3LPENCLRR: 0x0003290F,
        RCC_MP_AHB2LPENSETR: 0x00010127,
        RCC_MP_AHB2LPENCLRR: 0x00010127,
        RCC_MP_AHB3LPENSETR: 0x000018F1,
        RCC_MP_AHB3LPENCLRR: 0x000018F1,
        RCC_MP_AHB4LPENSETR: 0x000007FF,
        RCC_MP_AHB4LPENCLRR: 0x000007FF,
        RCC_MP_AXIMLPENSETR: 0x00000001,
        RCC_MP_AXIMLPENCLRR: 0x00000001,
        RCC_MP_MLAHBLPENSETR: 0x00000017,
        RCC_MP_MLAHBLPENCLRR: 0x00000017,
        RCC_MC_APB1LPENSETR: 0xBDEFDBFF,
        RCC_MC_APB1LPENCLRR: 0xBDEFDBFF,
        RCC_MC_APB2LPENSETR: 0x0137271F,
        RCC_MC_APB2LPENCLRR: 0x0137271F,
        RCC_MC_APB3LPENSETR: 0x0003290F,
        RCC_MC_APB3LPENCLRR: 0x0003290F,
        RCC_MC_AHB2LPENSETR: 0x00010127,
        RCC_MC_AHB2LPENCLRR: 0x00010127,
        RCC_MC_AHB3LPENSETR: 0x000018F1,
        RCC_MC_AHB3LPENCLRR: 0x000018F1,
        RCC_MC_AHB4LPENSETR: 0x000007FF,
        RCC_MC_AHB4LPENCLRR: 0x000007FF,
        RCC_MC_AXIMLPENSETR: 0x00000001,
        RCC_MC_AXIMLPENCLRR: 0x00000001,
        RCC_MC_MLAHBLPENSETR: 0x00000017,
        RCC_MC_MLAHBLPENCLRR: 0x00000017,
        RCC_MC_RSTSCLRR: 0x00000015,
        RCC_MC_CIER: 0x00000000,
        RCC_MC_CIFR: 0x00000000,
        RCC_VERR: 0x00000011,
        RCC_IDR: 0x00000001,
        RCC_SIDR: 0xA3C5DD04,
    };

    #[cfg(not(feature = "nosync"))]
    #[allow(renamed_and_removed_lints)]
    #[allow(private_no_mangle_statics)]
    #[no_mangle]
    static mut RCC_TAKEN: bool = false;

    /// Safe access to RCC
    ///
    /// This function returns `Some(Instance)` if this instance is not
    /// currently taken, and `None` if it is. This ensures that if you
    /// do get `Some(Instance)`, you are ensured unique access to
    /// the peripheral and there cannot be data races (unless other
    /// code uses `unsafe`, of course). You can then pass the
    /// `Instance` around to other functions as required. When you're
    /// done with it, you can call `release(instance)` to return it.
    ///
    /// `Instance` itself dereferences to a `RegisterBlock`, which
    /// provides access to the peripheral's registers.
    #[cfg(not(feature = "nosync"))]
    #[inline]
    pub fn take() -> Option<Instance> {
        external_cortex_m::interrupt::free(|_| unsafe {
            if RCC_TAKEN {
                None
            } else {
                RCC_TAKEN = true;
                Some(INSTANCE)
            }
        })
    }

    /// Release exclusive access to RCC
    ///
    /// This function allows you to return an `Instance` so that it
    /// is available to `take()` again. This function will panic if
    /// you return a different `Instance` or if this instance is not
    /// already taken.
    #[cfg(not(feature = "nosync"))]
    #[inline]
    pub fn release(inst: Instance) {
        external_cortex_m::interrupt::free(|_| unsafe {
            if RCC_TAKEN && inst.addr == INSTANCE.addr {
                RCC_TAKEN = false;
            } else {
                panic!("Released a peripheral which was not taken");
            }
        });
    }

    /// Unsafely steal RCC
    ///
    /// This function is similar to take() but forcibly takes the
    /// Instance, marking it as taken irregardless of its previous
    /// state.
    #[cfg(not(feature = "nosync"))]
    #[inline]
    pub unsafe fn steal() -> Instance {
        RCC_TAKEN = true;
        INSTANCE
    }
}

/// Raw pointer to RCC
///
/// Dereferencing this is unsafe because you are not ensured unique
/// access to the peripheral, so you may encounter data races with
/// other users of this peripheral. It is up to you to ensure you
/// will not cause data races.
///
/// This constant is provided for ease of use in unsafe code: you can
/// simply call for example `write_reg!(gpio, GPIOA, ODR, 1);`.
pub const RCC: *const RegisterBlock = 0x50000000 as *const _;
