#![allow(non_snake_case, non_upper_case_globals)]
#![allow(non_camel_case_types)]
//! MDMA1
//!
//! Used by: stm32mp153, stm32mp157

#[cfg(not(feature = "nosync"))]
pub use crate::stm32mp::peripherals::mdma::Instance;
pub use crate::stm32mp::peripherals::mdma::{RegisterBlock, ResetValues};
pub use crate::stm32mp::peripherals::mdma::{
    MDMA_C0BNDTR, MDMA_C0BRUR, MDMA_C0CR, MDMA_C0DAR, MDMA_C0ESR, MDMA_C0IFCR, MDMA_C0ISR,
    MDMA_C0LAR, MDMA_C0MAR, MDMA_C0MDR, MDMA_C0SAR, MDMA_C0TBR, MDMA_C0TCR, MDMA_C10BNDTR,
    MDMA_C10BRUR, MDMA_C10CR, MDMA_C10DAR, MDMA_C10ESR, MDMA_C10IFCR, MDMA_C10ISR, MDMA_C10LAR,
    MDMA_C10MAR, MDMA_C10MDR, MDMA_C10SAR, MDMA_C10TBR, MDMA_C10TCR, MDMA_C11BNDTR, MDMA_C11BRUR,
    MDMA_C11CR, MDMA_C11DAR, MDMA_C11ESR, MDMA_C11IFCR, MDMA_C11ISR, MDMA_C11LAR, MDMA_C11MAR,
    MDMA_C11MDR, MDMA_C11SAR, MDMA_C11TBR, MDMA_C11TCR, MDMA_C12BNDTR, MDMA_C12BRUR, MDMA_C12CR,
    MDMA_C12DAR, MDMA_C12ESR, MDMA_C12IFCR, MDMA_C12ISR, MDMA_C12LAR, MDMA_C12MAR, MDMA_C12MDR,
    MDMA_C12SAR, MDMA_C12TBR, MDMA_C12TCR, MDMA_C13BNDTR, MDMA_C13BRUR, MDMA_C13CR, MDMA_C13DAR,
    MDMA_C13ESR, MDMA_C13IFCR, MDMA_C13ISR, MDMA_C13LAR, MDMA_C13MAR, MDMA_C13MDR, MDMA_C13SAR,
    MDMA_C13TBR, MDMA_C13TCR, MDMA_C14BNDTR, MDMA_C14BRUR, MDMA_C14CR, MDMA_C14DAR, MDMA_C14ESR,
    MDMA_C14IFCR, MDMA_C14ISR, MDMA_C14LAR, MDMA_C14MAR, MDMA_C14MDR, MDMA_C14SAR, MDMA_C14TBR,
    MDMA_C14TCR, MDMA_C15BNDTR, MDMA_C15BRUR, MDMA_C15CR, MDMA_C15DAR, MDMA_C15ESR, MDMA_C15IFCR,
    MDMA_C15ISR, MDMA_C15LAR, MDMA_C15MAR, MDMA_C15MDR, MDMA_C15SAR, MDMA_C15TBR, MDMA_C15TCR,
    MDMA_C16BNDTR, MDMA_C16BRUR, MDMA_C16CR, MDMA_C16DAR, MDMA_C16ESR, MDMA_C16IFCR, MDMA_C16ISR,
    MDMA_C16LAR, MDMA_C16MAR, MDMA_C16MDR, MDMA_C16SAR, MDMA_C16TBR, MDMA_C16TCR, MDMA_C17BNDTR,
    MDMA_C17BRUR, MDMA_C17CR, MDMA_C17DAR, MDMA_C17ESR, MDMA_C17IFCR, MDMA_C17ISR, MDMA_C17LAR,
    MDMA_C17MAR, MDMA_C17MDR, MDMA_C17SAR, MDMA_C17TBR, MDMA_C17TCR, MDMA_C18BNDTR, MDMA_C18BRUR,
    MDMA_C18CR, MDMA_C18DAR, MDMA_C18ESR, MDMA_C18IFCR, MDMA_C18ISR, MDMA_C18LAR, MDMA_C18MAR,
    MDMA_C18MDR, MDMA_C18SAR, MDMA_C18TBR, MDMA_C18TCR, MDMA_C19BNDTR, MDMA_C19BRUR, MDMA_C19CR,
    MDMA_C19DAR, MDMA_C19ESR, MDMA_C19IFCR, MDMA_C19ISR, MDMA_C19LAR, MDMA_C19MAR, MDMA_C19MDR,
    MDMA_C19SAR, MDMA_C19TBR, MDMA_C19TCR, MDMA_C1BNDTR, MDMA_C1BRUR, MDMA_C1CR, MDMA_C1DAR,
    MDMA_C1ESR, MDMA_C1IFCR, MDMA_C1ISR, MDMA_C1LAR, MDMA_C1MAR, MDMA_C1MDR, MDMA_C1SAR,
    MDMA_C1TBR, MDMA_C1TCR, MDMA_C20BNDTR, MDMA_C20BRUR, MDMA_C20CR, MDMA_C20DAR, MDMA_C20ESR,
    MDMA_C20IFCR, MDMA_C20ISR, MDMA_C20LAR, MDMA_C20MAR, MDMA_C20MDR, MDMA_C20SAR, MDMA_C20TBR,
    MDMA_C20TCR, MDMA_C21BNDTR, MDMA_C21BRUR, MDMA_C21CR, MDMA_C21DAR, MDMA_C21ESR, MDMA_C21IFCR,
    MDMA_C21ISR, MDMA_C21LAR, MDMA_C21MAR, MDMA_C21MDR, MDMA_C21SAR, MDMA_C21TBR, MDMA_C21TCR,
    MDMA_C22BNDTR, MDMA_C22BRUR, MDMA_C22CR, MDMA_C22DAR, MDMA_C22ESR, MDMA_C22IFCR, MDMA_C22ISR,
    MDMA_C22LAR, MDMA_C22MAR, MDMA_C22MDR, MDMA_C22SAR, MDMA_C22TBR, MDMA_C22TCR, MDMA_C23BNDTR,
    MDMA_C23BRUR, MDMA_C23CR, MDMA_C23DAR, MDMA_C23ESR, MDMA_C23IFCR, MDMA_C23ISR, MDMA_C23LAR,
    MDMA_C23MAR, MDMA_C23MDR, MDMA_C23SAR, MDMA_C23TBR, MDMA_C23TCR, MDMA_C24BNDTR, MDMA_C24BRUR,
    MDMA_C24CR, MDMA_C24DAR, MDMA_C24ESR, MDMA_C24IFCR, MDMA_C24ISR, MDMA_C24LAR, MDMA_C24MAR,
    MDMA_C24MDR, MDMA_C24SAR, MDMA_C24TBR, MDMA_C24TCR, MDMA_C25BNDTR, MDMA_C25BRUR, MDMA_C25CR,
    MDMA_C25DAR, MDMA_C25ESR, MDMA_C25IFCR, MDMA_C25ISR, MDMA_C25LAR, MDMA_C25MAR, MDMA_C25MDR,
    MDMA_C25SAR, MDMA_C25TBR, MDMA_C25TCR, MDMA_C26BNDTR, MDMA_C26BRUR, MDMA_C26CR, MDMA_C26DAR,
    MDMA_C26ESR, MDMA_C26IFCR, MDMA_C26ISR, MDMA_C26LAR, MDMA_C26MAR, MDMA_C26MDR, MDMA_C26SAR,
    MDMA_C26TBR, MDMA_C26TCR, MDMA_C27BNDTR, MDMA_C27BRUR, MDMA_C27CR, MDMA_C27DAR, MDMA_C27ESR,
    MDMA_C27IFCR, MDMA_C27ISR, MDMA_C27LAR, MDMA_C27MAR, MDMA_C27MDR, MDMA_C27SAR, MDMA_C27TBR,
    MDMA_C27TCR, MDMA_C28BNDTR, MDMA_C28BRUR, MDMA_C28CR, MDMA_C28DAR, MDMA_C28ESR, MDMA_C28IFCR,
    MDMA_C28ISR, MDMA_C28LAR, MDMA_C28MAR, MDMA_C28MDR, MDMA_C28SAR, MDMA_C28TBR, MDMA_C28TCR,
    MDMA_C29BNDTR, MDMA_C29BRUR, MDMA_C29CR, MDMA_C29DAR, MDMA_C29ESR, MDMA_C29IFCR, MDMA_C29ISR,
    MDMA_C29LAR, MDMA_C29MAR, MDMA_C29MDR, MDMA_C29SAR, MDMA_C29TBR, MDMA_C29TCR, MDMA_C2BNDTR,
    MDMA_C2BRUR, MDMA_C2CR, MDMA_C2DAR, MDMA_C2ESR, MDMA_C2IFCR, MDMA_C2ISR, MDMA_C2LAR,
    MDMA_C2MAR, MDMA_C2MDR, MDMA_C2SAR, MDMA_C2TBR, MDMA_C2TCR, MDMA_C30BNDTR, MDMA_C30BRUR,
    MDMA_C30CR, MDMA_C30DAR, MDMA_C30ESR, MDMA_C30IFCR, MDMA_C30ISR, MDMA_C30LAR, MDMA_C30MAR,
    MDMA_C30MDR, MDMA_C30SAR, MDMA_C30TBR, MDMA_C30TCR, MDMA_C31BNDTR, MDMA_C31BRUR, MDMA_C31CR,
    MDMA_C31DAR, MDMA_C31ESR, MDMA_C31IFCR, MDMA_C31ISR, MDMA_C31LAR, MDMA_C31MAR, MDMA_C31MDR,
    MDMA_C31SAR, MDMA_C31TBR, MDMA_C31TCR, MDMA_C3BNDTR, MDMA_C3BRUR, MDMA_C3CR, MDMA_C3DAR,
    MDMA_C3ESR, MDMA_C3IFCR, MDMA_C3ISR, MDMA_C3LAR, MDMA_C3MAR, MDMA_C3MDR, MDMA_C3SAR,
    MDMA_C3TBR, MDMA_C3TCR, MDMA_C4BNDTR, MDMA_C4BRUR, MDMA_C4CR, MDMA_C4DAR, MDMA_C4ESR,
    MDMA_C4IFCR, MDMA_C4ISR, MDMA_C4LAR, MDMA_C4MAR, MDMA_C4MDR, MDMA_C4SAR, MDMA_C4TBR,
    MDMA_C4TCR, MDMA_C5BNDTR, MDMA_C5BRUR, MDMA_C5CR, MDMA_C5DAR, MDMA_C5ESR, MDMA_C5IFCR,
    MDMA_C5ISR, MDMA_C5LAR, MDMA_C5MAR, MDMA_C5MDR, MDMA_C5SAR, MDMA_C5TBR, MDMA_C5TCR,
    MDMA_C6BNDTR, MDMA_C6BRUR, MDMA_C6CR, MDMA_C6DAR, MDMA_C6ESR, MDMA_C6IFCR, MDMA_C6ISR,
    MDMA_C6LAR, MDMA_C6MAR, MDMA_C6MDR, MDMA_C6SAR, MDMA_C6TBR, MDMA_C6TCR, MDMA_C7BNDTR,
    MDMA_C7BRUR, MDMA_C7CR, MDMA_C7DAR, MDMA_C7ESR, MDMA_C7IFCR, MDMA_C7ISR, MDMA_C7LAR,
    MDMA_C7MAR, MDMA_C7MDR, MDMA_C7SAR, MDMA_C7TBR, MDMA_C7TCR, MDMA_C8BNDTR, MDMA_C8BRUR,
    MDMA_C8CR, MDMA_C8DAR, MDMA_C8ESR, MDMA_C8IFCR, MDMA_C8ISR, MDMA_C8LAR, MDMA_C8MAR, MDMA_C8MDR,
    MDMA_C8SAR, MDMA_C8TBR, MDMA_C8TCR, MDMA_C9BNDTR, MDMA_C9BRUR, MDMA_C9CR, MDMA_C9DAR,
    MDMA_C9ESR, MDMA_C9IFCR, MDMA_C9ISR, MDMA_C9LAR, MDMA_C9MAR, MDMA_C9MDR, MDMA_C9SAR,
    MDMA_C9TBR, MDMA_C9TCR, MDMA_GISR0, MDMA_SGISR0,
};

/// Access functions for the MDMA peripheral instance
pub mod MDMA {
    use super::ResetValues;

    #[cfg(not(feature = "nosync"))]
    use super::Instance;

    #[cfg(not(feature = "nosync"))]
    const INSTANCE: Instance = Instance {
        addr: 0x58000000,
        _marker: ::core::marker::PhantomData,
    };

    /// Reset values for each field in MDMA
    pub const reset: ResetValues = ResetValues {
        MDMA_GISR0: 0x00000000,
        MDMA_SGISR0: 0x00000000,
        MDMA_C0ISR: 0x00000000,
        MDMA_C0IFCR: 0x00000000,
        MDMA_C0ESR: 0x00000000,
        MDMA_C0CR: 0x00000000,
        MDMA_C0TCR: 0x00000000,
        MDMA_C0BNDTR: 0x00000000,
        MDMA_C0SAR: 0x00000000,
        MDMA_C0DAR: 0x00000000,
        MDMA_C0BRUR: 0x00000000,
        MDMA_C0LAR: 0x00000000,
        MDMA_C0TBR: 0x00000000,
        MDMA_C0MAR: 0x00000000,
        MDMA_C0MDR: 0x00000000,
        MDMA_C1ISR: 0x00000000,
        MDMA_C1IFCR: 0x00000000,
        MDMA_C1ESR: 0x00000000,
        MDMA_C1CR: 0x00000000,
        MDMA_C1TCR: 0x00000000,
        MDMA_C1BNDTR: 0x00000000,
        MDMA_C1SAR: 0x00000000,
        MDMA_C1DAR: 0x00000000,
        MDMA_C1BRUR: 0x00000000,
        MDMA_C1LAR: 0x00000000,
        MDMA_C1TBR: 0x00000000,
        MDMA_C1MAR: 0x00000000,
        MDMA_C1MDR: 0x00000000,
        MDMA_C2ISR: 0x00000000,
        MDMA_C2IFCR: 0x00000000,
        MDMA_C2ESR: 0x00000000,
        MDMA_C2CR: 0x00000000,
        MDMA_C2TCR: 0x00000000,
        MDMA_C2BNDTR: 0x00000000,
        MDMA_C2SAR: 0x00000000,
        MDMA_C2DAR: 0x00000000,
        MDMA_C2BRUR: 0x00000000,
        MDMA_C2LAR: 0x00000000,
        MDMA_C2TBR: 0x00000000,
        MDMA_C2MAR: 0x00000000,
        MDMA_C2MDR: 0x00000000,
        MDMA_C3ISR: 0x00000000,
        MDMA_C3IFCR: 0x00000000,
        MDMA_C3ESR: 0x00000000,
        MDMA_C3CR: 0x00000000,
        MDMA_C3TCR: 0x00000000,
        MDMA_C3BNDTR: 0x00000000,
        MDMA_C3SAR: 0x00000000,
        MDMA_C3DAR: 0x00000000,
        MDMA_C3BRUR: 0x00000000,
        MDMA_C3LAR: 0x00000000,
        MDMA_C3TBR: 0x00000000,
        MDMA_C3MAR: 0x00000000,
        MDMA_C3MDR: 0x00000000,
        MDMA_C4ISR: 0x00000000,
        MDMA_C4IFCR: 0x00000000,
        MDMA_C4ESR: 0x00000000,
        MDMA_C4CR: 0x00000000,
        MDMA_C4TCR: 0x00000000,
        MDMA_C4BNDTR: 0x00000000,
        MDMA_C4SAR: 0x00000000,
        MDMA_C4DAR: 0x00000000,
        MDMA_C4BRUR: 0x00000000,
        MDMA_C4LAR: 0x00000000,
        MDMA_C4TBR: 0x00000000,
        MDMA_C4MAR: 0x00000000,
        MDMA_C4MDR: 0x00000000,
        MDMA_C5ISR: 0x00000000,
        MDMA_C5IFCR: 0x00000000,
        MDMA_C5ESR: 0x00000000,
        MDMA_C5CR: 0x00000000,
        MDMA_C5TCR: 0x00000000,
        MDMA_C5BNDTR: 0x00000000,
        MDMA_C5SAR: 0x00000000,
        MDMA_C5DAR: 0x00000000,
        MDMA_C5BRUR: 0x00000000,
        MDMA_C5LAR: 0x00000000,
        MDMA_C5TBR: 0x00000000,
        MDMA_C5MAR: 0x00000000,
        MDMA_C5MDR: 0x00000000,
        MDMA_C6ISR: 0x00000000,
        MDMA_C6IFCR: 0x00000000,
        MDMA_C6ESR: 0x00000000,
        MDMA_C6CR: 0x00000000,
        MDMA_C6TCR: 0x00000000,
        MDMA_C6BNDTR: 0x00000000,
        MDMA_C6SAR: 0x00000000,
        MDMA_C6DAR: 0x00000000,
        MDMA_C6BRUR: 0x00000000,
        MDMA_C6LAR: 0x00000000,
        MDMA_C6TBR: 0x00000000,
        MDMA_C6MAR: 0x00000000,
        MDMA_C6MDR: 0x00000000,
        MDMA_C7ISR: 0x00000000,
        MDMA_C7IFCR: 0x00000000,
        MDMA_C7ESR: 0x00000000,
        MDMA_C7CR: 0x00000000,
        MDMA_C7TCR: 0x00000000,
        MDMA_C7BNDTR: 0x00000000,
        MDMA_C7SAR: 0x00000000,
        MDMA_C7DAR: 0x00000000,
        MDMA_C7BRUR: 0x00000000,
        MDMA_C7LAR: 0x00000000,
        MDMA_C7TBR: 0x00000000,
        MDMA_C7MAR: 0x00000000,
        MDMA_C7MDR: 0x00000000,
        MDMA_C8ISR: 0x00000000,
        MDMA_C8IFCR: 0x00000000,
        MDMA_C8ESR: 0x00000000,
        MDMA_C8CR: 0x00000000,
        MDMA_C8TCR: 0x00000000,
        MDMA_C8BNDTR: 0x00000000,
        MDMA_C8SAR: 0x00000000,
        MDMA_C8DAR: 0x00000000,
        MDMA_C8BRUR: 0x00000000,
        MDMA_C8LAR: 0x00000000,
        MDMA_C8TBR: 0x00000000,
        MDMA_C8MAR: 0x00000000,
        MDMA_C8MDR: 0x00000000,
        MDMA_C9ISR: 0x00000000,
        MDMA_C9IFCR: 0x00000000,
        MDMA_C9ESR: 0x00000000,
        MDMA_C9CR: 0x00000000,
        MDMA_C9TCR: 0x00000000,
        MDMA_C9BNDTR: 0x00000000,
        MDMA_C9SAR: 0x00000000,
        MDMA_C9DAR: 0x00000000,
        MDMA_C9BRUR: 0x00000000,
        MDMA_C9LAR: 0x00000000,
        MDMA_C9TBR: 0x00000000,
        MDMA_C9MAR: 0x00000000,
        MDMA_C9MDR: 0x00000000,
        MDMA_C10ISR: 0x00000000,
        MDMA_C10IFCR: 0x00000000,
        MDMA_C10ESR: 0x00000000,
        MDMA_C10CR: 0x00000000,
        MDMA_C10TCR: 0x00000000,
        MDMA_C10BNDTR: 0x00000000,
        MDMA_C10SAR: 0x00000000,
        MDMA_C10DAR: 0x00000000,
        MDMA_C10BRUR: 0x00000000,
        MDMA_C10LAR: 0x00000000,
        MDMA_C10TBR: 0x00000000,
        MDMA_C10MAR: 0x00000000,
        MDMA_C10MDR: 0x00000000,
        MDMA_C11ISR: 0x00000000,
        MDMA_C11IFCR: 0x00000000,
        MDMA_C11ESR: 0x00000000,
        MDMA_C11CR: 0x00000000,
        MDMA_C11TCR: 0x00000000,
        MDMA_C11BNDTR: 0x00000000,
        MDMA_C11SAR: 0x00000000,
        MDMA_C11DAR: 0x00000000,
        MDMA_C11BRUR: 0x00000000,
        MDMA_C11LAR: 0x00000000,
        MDMA_C11TBR: 0x00000000,
        MDMA_C11MAR: 0x00000000,
        MDMA_C11MDR: 0x00000000,
        MDMA_C12ISR: 0x00000000,
        MDMA_C12IFCR: 0x00000000,
        MDMA_C12ESR: 0x00000000,
        MDMA_C12CR: 0x00000000,
        MDMA_C12TCR: 0x00000000,
        MDMA_C12BNDTR: 0x00000000,
        MDMA_C12SAR: 0x00000000,
        MDMA_C12DAR: 0x00000000,
        MDMA_C12BRUR: 0x00000000,
        MDMA_C12LAR: 0x00000000,
        MDMA_C12TBR: 0x00000000,
        MDMA_C12MAR: 0x00000000,
        MDMA_C12MDR: 0x00000000,
        MDMA_C13ISR: 0x00000000,
        MDMA_C13IFCR: 0x00000000,
        MDMA_C13ESR: 0x00000000,
        MDMA_C13CR: 0x00000000,
        MDMA_C13TCR: 0x00000000,
        MDMA_C13BNDTR: 0x00000000,
        MDMA_C13SAR: 0x00000000,
        MDMA_C13DAR: 0x00000000,
        MDMA_C13BRUR: 0x00000000,
        MDMA_C13LAR: 0x00000000,
        MDMA_C13TBR: 0x00000000,
        MDMA_C13MAR: 0x00000000,
        MDMA_C13MDR: 0x00000000,
        MDMA_C14ISR: 0x00000000,
        MDMA_C14IFCR: 0x00000000,
        MDMA_C14ESR: 0x00000000,
        MDMA_C14CR: 0x00000000,
        MDMA_C14TCR: 0x00000000,
        MDMA_C14BNDTR: 0x00000000,
        MDMA_C14SAR: 0x00000000,
        MDMA_C14DAR: 0x00000000,
        MDMA_C14BRUR: 0x00000000,
        MDMA_C14LAR: 0x00000000,
        MDMA_C14TBR: 0x00000000,
        MDMA_C14MAR: 0x00000000,
        MDMA_C14MDR: 0x00000000,
        MDMA_C15ISR: 0x00000000,
        MDMA_C15IFCR: 0x00000000,
        MDMA_C15ESR: 0x00000000,
        MDMA_C15CR: 0x00000000,
        MDMA_C15TCR: 0x00000000,
        MDMA_C15BNDTR: 0x00000000,
        MDMA_C15SAR: 0x00000000,
        MDMA_C15DAR: 0x00000000,
        MDMA_C15BRUR: 0x00000000,
        MDMA_C15LAR: 0x00000000,
        MDMA_C15TBR: 0x00000000,
        MDMA_C15MAR: 0x00000000,
        MDMA_C15MDR: 0x00000000,
        MDMA_C16ISR: 0x00000000,
        MDMA_C16IFCR: 0x00000000,
        MDMA_C16ESR: 0x00000000,
        MDMA_C16CR: 0x00000000,
        MDMA_C16TCR: 0x00000000,
        MDMA_C16BNDTR: 0x00000000,
        MDMA_C16SAR: 0x00000000,
        MDMA_C16DAR: 0x00000000,
        MDMA_C16BRUR: 0x00000000,
        MDMA_C16LAR: 0x00000000,
        MDMA_C16TBR: 0x00000000,
        MDMA_C16MAR: 0x00000000,
        MDMA_C16MDR: 0x00000000,
        MDMA_C17ISR: 0x00000000,
        MDMA_C17IFCR: 0x00000000,
        MDMA_C17ESR: 0x00000000,
        MDMA_C17CR: 0x00000000,
        MDMA_C17TCR: 0x00000000,
        MDMA_C17BNDTR: 0x00000000,
        MDMA_C17SAR: 0x00000000,
        MDMA_C17DAR: 0x00000000,
        MDMA_C17BRUR: 0x00000000,
        MDMA_C17LAR: 0x00000000,
        MDMA_C17TBR: 0x00000000,
        MDMA_C17MAR: 0x00000000,
        MDMA_C17MDR: 0x00000000,
        MDMA_C18ISR: 0x00000000,
        MDMA_C18IFCR: 0x00000000,
        MDMA_C18ESR: 0x00000000,
        MDMA_C18CR: 0x00000000,
        MDMA_C18TCR: 0x00000000,
        MDMA_C18BNDTR: 0x00000000,
        MDMA_C18SAR: 0x00000000,
        MDMA_C18DAR: 0x00000000,
        MDMA_C18BRUR: 0x00000000,
        MDMA_C18LAR: 0x00000000,
        MDMA_C18TBR: 0x00000000,
        MDMA_C18MAR: 0x00000000,
        MDMA_C18MDR: 0x00000000,
        MDMA_C19ISR: 0x00000000,
        MDMA_C19IFCR: 0x00000000,
        MDMA_C19ESR: 0x00000000,
        MDMA_C19CR: 0x00000000,
        MDMA_C19TCR: 0x00000000,
        MDMA_C19BNDTR: 0x00000000,
        MDMA_C19SAR: 0x00000000,
        MDMA_C19DAR: 0x00000000,
        MDMA_C19BRUR: 0x00000000,
        MDMA_C19LAR: 0x00000000,
        MDMA_C19TBR: 0x00000000,
        MDMA_C19MAR: 0x00000000,
        MDMA_C19MDR: 0x00000000,
        MDMA_C20ISR: 0x00000000,
        MDMA_C20IFCR: 0x00000000,
        MDMA_C20ESR: 0x00000000,
        MDMA_C20CR: 0x00000000,
        MDMA_C20TCR: 0x00000000,
        MDMA_C20BNDTR: 0x00000000,
        MDMA_C20SAR: 0x00000000,
        MDMA_C20DAR: 0x00000000,
        MDMA_C20BRUR: 0x00000000,
        MDMA_C20LAR: 0x00000000,
        MDMA_C20TBR: 0x00000000,
        MDMA_C20MAR: 0x00000000,
        MDMA_C20MDR: 0x00000000,
        MDMA_C21ISR: 0x00000000,
        MDMA_C21IFCR: 0x00000000,
        MDMA_C21ESR: 0x00000000,
        MDMA_C21CR: 0x00000000,
        MDMA_C21TCR: 0x00000000,
        MDMA_C21BNDTR: 0x00000000,
        MDMA_C21SAR: 0x00000000,
        MDMA_C21DAR: 0x00000000,
        MDMA_C21BRUR: 0x00000000,
        MDMA_C21LAR: 0x00000000,
        MDMA_C21TBR: 0x00000000,
        MDMA_C21MAR: 0x00000000,
        MDMA_C21MDR: 0x00000000,
        MDMA_C22ISR: 0x00000000,
        MDMA_C22IFCR: 0x00000000,
        MDMA_C22ESR: 0x00000000,
        MDMA_C22CR: 0x00000000,
        MDMA_C22TCR: 0x00000000,
        MDMA_C22BNDTR: 0x00000000,
        MDMA_C22SAR: 0x00000000,
        MDMA_C22DAR: 0x00000000,
        MDMA_C22BRUR: 0x00000000,
        MDMA_C22LAR: 0x00000000,
        MDMA_C22TBR: 0x00000000,
        MDMA_C22MAR: 0x00000000,
        MDMA_C22MDR: 0x00000000,
        MDMA_C23ISR: 0x00000000,
        MDMA_C23IFCR: 0x00000000,
        MDMA_C23ESR: 0x00000000,
        MDMA_C23CR: 0x00000000,
        MDMA_C23TCR: 0x00000000,
        MDMA_C23BNDTR: 0x00000000,
        MDMA_C23SAR: 0x00000000,
        MDMA_C23DAR: 0x00000000,
        MDMA_C23BRUR: 0x00000000,
        MDMA_C23LAR: 0x00000000,
        MDMA_C23TBR: 0x00000000,
        MDMA_C23MAR: 0x00000000,
        MDMA_C23MDR: 0x00000000,
        MDMA_C24ISR: 0x00000000,
        MDMA_C24IFCR: 0x00000000,
        MDMA_C24ESR: 0x00000000,
        MDMA_C24CR: 0x00000000,
        MDMA_C24TCR: 0x00000000,
        MDMA_C24BNDTR: 0x00000000,
        MDMA_C24SAR: 0x00000000,
        MDMA_C24DAR: 0x00000000,
        MDMA_C24BRUR: 0x00000000,
        MDMA_C24LAR: 0x00000000,
        MDMA_C24TBR: 0x00000000,
        MDMA_C24MAR: 0x00000000,
        MDMA_C24MDR: 0x00000000,
        MDMA_C25ISR: 0x00000000,
        MDMA_C25IFCR: 0x00000000,
        MDMA_C25ESR: 0x00000000,
        MDMA_C25CR: 0x00000000,
        MDMA_C25TCR: 0x00000000,
        MDMA_C25BNDTR: 0x00000000,
        MDMA_C25SAR: 0x00000000,
        MDMA_C25DAR: 0x00000000,
        MDMA_C25BRUR: 0x00000000,
        MDMA_C25LAR: 0x00000000,
        MDMA_C25TBR: 0x00000000,
        MDMA_C25MAR: 0x00000000,
        MDMA_C25MDR: 0x00000000,
        MDMA_C26ISR: 0x00000000,
        MDMA_C26IFCR: 0x00000000,
        MDMA_C26ESR: 0x00000000,
        MDMA_C26CR: 0x00000000,
        MDMA_C26TCR: 0x00000000,
        MDMA_C26BNDTR: 0x00000000,
        MDMA_C26SAR: 0x00000000,
        MDMA_C26DAR: 0x00000000,
        MDMA_C26BRUR: 0x00000000,
        MDMA_C26LAR: 0x00000000,
        MDMA_C26TBR: 0x00000000,
        MDMA_C26MAR: 0x00000000,
        MDMA_C26MDR: 0x00000000,
        MDMA_C27ISR: 0x00000000,
        MDMA_C27IFCR: 0x00000000,
        MDMA_C27ESR: 0x00000000,
        MDMA_C27CR: 0x00000000,
        MDMA_C27TCR: 0x00000000,
        MDMA_C27BNDTR: 0x00000000,
        MDMA_C27SAR: 0x00000000,
        MDMA_C27DAR: 0x00000000,
        MDMA_C27BRUR: 0x00000000,
        MDMA_C27LAR: 0x00000000,
        MDMA_C27TBR: 0x00000000,
        MDMA_C27MAR: 0x00000000,
        MDMA_C27MDR: 0x00000000,
        MDMA_C28ISR: 0x00000000,
        MDMA_C28IFCR: 0x00000000,
        MDMA_C28ESR: 0x00000000,
        MDMA_C28CR: 0x00000000,
        MDMA_C28TCR: 0x00000000,
        MDMA_C28BNDTR: 0x00000000,
        MDMA_C28SAR: 0x00000000,
        MDMA_C28DAR: 0x00000000,
        MDMA_C28BRUR: 0x00000000,
        MDMA_C28LAR: 0x00000000,
        MDMA_C28TBR: 0x00000000,
        MDMA_C28MAR: 0x00000000,
        MDMA_C28MDR: 0x00000000,
        MDMA_C29ISR: 0x00000000,
        MDMA_C29IFCR: 0x00000000,
        MDMA_C29ESR: 0x00000000,
        MDMA_C29CR: 0x00000000,
        MDMA_C29TCR: 0x00000000,
        MDMA_C29BNDTR: 0x00000000,
        MDMA_C29SAR: 0x00000000,
        MDMA_C29DAR: 0x00000000,
        MDMA_C29BRUR: 0x00000000,
        MDMA_C29LAR: 0x00000000,
        MDMA_C29TBR: 0x00000000,
        MDMA_C29MAR: 0x00000000,
        MDMA_C29MDR: 0x00000000,
        MDMA_C30ISR: 0x00000000,
        MDMA_C30IFCR: 0x00000000,
        MDMA_C30ESR: 0x00000000,
        MDMA_C30CR: 0x00000000,
        MDMA_C30TCR: 0x00000000,
        MDMA_C30BNDTR: 0x00000000,
        MDMA_C30SAR: 0x00000000,
        MDMA_C30DAR: 0x00000000,
        MDMA_C30BRUR: 0x00000000,
        MDMA_C30LAR: 0x00000000,
        MDMA_C30TBR: 0x00000000,
        MDMA_C30MAR: 0x00000000,
        MDMA_C30MDR: 0x00000000,
        MDMA_C31ISR: 0x00000000,
        MDMA_C31IFCR: 0x00000000,
        MDMA_C31ESR: 0x00000000,
        MDMA_C31CR: 0x00000000,
        MDMA_C31TCR: 0x00000000,
        MDMA_C31BNDTR: 0x00000000,
        MDMA_C31SAR: 0x00000000,
        MDMA_C31DAR: 0x00000000,
        MDMA_C31BRUR: 0x00000000,
        MDMA_C31LAR: 0x00000000,
        MDMA_C31TBR: 0x00000000,
        MDMA_C31MAR: 0x00000000,
        MDMA_C31MDR: 0x00000000,
    };

    #[cfg(not(feature = "nosync"))]
    #[allow(renamed_and_removed_lints)]
    #[allow(private_no_mangle_statics)]
    #[no_mangle]
    static mut MDMA_TAKEN: bool = false;

    /// Safe access to MDMA
    ///
    /// This function returns `Some(Instance)` if this instance is not
    /// currently taken, and `None` if it is. This ensures that if you
    /// do get `Some(Instance)`, you are ensured unique access to
    /// the peripheral and there cannot be data races (unless other
    /// code uses `unsafe`, of course). You can then pass the
    /// `Instance` around to other functions as required. When you're
    /// done with it, you can call `release(instance)` to return it.
    ///
    /// `Instance` itself dereferences to a `RegisterBlock`, which
    /// provides access to the peripheral's registers.
    #[cfg(not(feature = "nosync"))]
    #[inline]
    pub fn take() -> Option<Instance> {
        external_cortex_m::interrupt::free(|_| unsafe {
            if MDMA_TAKEN {
                None
            } else {
                MDMA_TAKEN = true;
                Some(INSTANCE)
            }
        })
    }

    /// Release exclusive access to MDMA
    ///
    /// This function allows you to return an `Instance` so that it
    /// is available to `take()` again. This function will panic if
    /// you return a different `Instance` or if this instance is not
    /// already taken.
    #[cfg(not(feature = "nosync"))]
    #[inline]
    pub fn release(inst: Instance) {
        external_cortex_m::interrupt::free(|_| unsafe {
            if MDMA_TAKEN && inst.addr == INSTANCE.addr {
                MDMA_TAKEN = false;
            } else {
                panic!("Released a peripheral which was not taken");
            }
        });
    }

    /// Unsafely steal MDMA
    ///
    /// This function is similar to take() but forcibly takes the
    /// Instance, marking it as taken irregardless of its previous
    /// state.
    #[cfg(not(feature = "nosync"))]
    #[inline]
    pub unsafe fn steal() -> Instance {
        MDMA_TAKEN = true;
        INSTANCE
    }
}

/// Raw pointer to MDMA
///
/// Dereferencing this is unsafe because you are not ensured unique
/// access to the peripheral, so you may encounter data races with
/// other users of this peripheral. It is up to you to ensure you
/// will not cause data races.
///
/// This constant is provided for ease of use in unsafe code: you can
/// simply call for example `write_reg!(gpio, GPIOA, ODR, 1);`.
pub const MDMA: *const RegisterBlock = 0x58000000 as *const _;
