#![allow(non_snake_case, non_upper_case_globals)]
#![allow(non_camel_case_types)]
//! Liquid crystal display controller
//!
//! Used by: stm32l100, stm32l151, stm32l162

use crate::{RWRegister, WORegister};
#[cfg(not(feature = "nosync"))]
use core::marker::PhantomData;

/// control register
pub mod CR {

    /// Mux segment enable
    pub mod MUX_SEG {
        /// Offset (7 bits)
        pub const offset: u32 = 7;
        /// Mask (1 bit: 1 << 7)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Bias selector
    pub mod BIAS {
        /// Offset (5 bits)
        pub const offset: u32 = 5;
        /// Mask (2 bits: 0b11 << 5)
        pub const mask: u32 = 0b11 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Duty selection
    pub mod DUTY {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (3 bits: 0b111 << 2)
        pub const mask: u32 = 0b111 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Voltage source selection
    pub mod VSEL {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// LCD controller enable
    pub mod LCDEN {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// frame control register
pub mod FCR {

    /// PS 16-bit prescaler
    pub mod PS {
        /// Offset (22 bits)
        pub const offset: u32 = 22;
        /// Mask (4 bits: 0b1111 << 22)
        pub const mask: u32 = 0b1111 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// DIV clock divider
    pub mod DIV {
        /// Offset (18 bits)
        pub const offset: u32 = 18;
        /// Mask (4 bits: 0b1111 << 18)
        pub const mask: u32 = 0b1111 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Blink mode selection
    pub mod BLINK {
        /// Offset (16 bits)
        pub const offset: u32 = 16;
        /// Mask (2 bits: 0b11 << 16)
        pub const mask: u32 = 0b11 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Blink frequency selection
    pub mod BLINKF {
        /// Offset (13 bits)
        pub const offset: u32 = 13;
        /// Mask (3 bits: 0b111 << 13)
        pub const mask: u32 = 0b111 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Contrast control
    pub mod CC {
        /// Offset (10 bits)
        pub const offset: u32 = 10;
        /// Mask (3 bits: 0b111 << 10)
        pub const mask: u32 = 0b111 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Dead time duration
    pub mod DEAD {
        /// Offset (7 bits)
        pub const offset: u32 = 7;
        /// Mask (3 bits: 0b111 << 7)
        pub const mask: u32 = 0b111 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Pulse ON duration
    pub mod PON {
        /// Offset (4 bits)
        pub const offset: u32 = 4;
        /// Mask (3 bits: 0b111 << 4)
        pub const mask: u32 = 0b111 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Update display done interrupt enable
    pub mod UDDIE {
        /// Offset (3 bits)
        pub const offset: u32 = 3;
        /// Mask (1 bit: 1 << 3)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Start of frame interrupt enable
    pub mod SOFIE {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// High drive enable
    pub mod HD {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// status register
pub mod SR {

    /// LCD Frame Control Register Synchronization flag
    pub mod FCRSF {
        /// Offset (5 bits)
        pub const offset: u32 = 5;
        /// Mask (1 bit: 1 << 5)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Ready flag
    pub mod RDY {
        /// Offset (4 bits)
        pub const offset: u32 = 4;
        /// Mask (1 bit: 1 << 4)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Update Display Done
    pub mod UDD {
        /// Offset (3 bits)
        pub const offset: u32 = 3;
        /// Mask (1 bit: 1 << 3)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Update display request
    pub mod UDR {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (1 bit: 1 << 2)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Start of frame flag
    pub mod SOF {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// LCD enabled status
    pub mod ENS {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// clear register
pub mod CLR {

    /// Update display done clear
    pub mod UDDC {
        /// Offset (3 bits)
        pub const offset: u32 = 3;
        /// Mask (1 bit: 1 << 3)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// Start of frame flag clear
    pub mod SOFC {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// display memory
pub mod RAM_COM0 {

    /// S31
    pub mod S31 {
        /// Offset (31 bits)
        pub const offset: u32 = 31;
        /// Mask (1 bit: 1 << 31)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S30
    pub mod S30 {
        /// Offset (30 bits)
        pub const offset: u32 = 30;
        /// Mask (1 bit: 1 << 30)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S29
    pub mod S29 {
        /// Offset (29 bits)
        pub const offset: u32 = 29;
        /// Mask (1 bit: 1 << 29)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S28
    pub mod S28 {
        /// Offset (28 bits)
        pub const offset: u32 = 28;
        /// Mask (1 bit: 1 << 28)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S27
    pub mod S27 {
        /// Offset (27 bits)
        pub const offset: u32 = 27;
        /// Mask (1 bit: 1 << 27)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S26
    pub mod S26 {
        /// Offset (26 bits)
        pub const offset: u32 = 26;
        /// Mask (1 bit: 1 << 26)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S25
    pub mod S25 {
        /// Offset (25 bits)
        pub const offset: u32 = 25;
        /// Mask (1 bit: 1 << 25)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S24
    pub mod S24 {
        /// Offset (24 bits)
        pub const offset: u32 = 24;
        /// Mask (1 bit: 1 << 24)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S23
    pub mod S23 {
        /// Offset (23 bits)
        pub const offset: u32 = 23;
        /// Mask (1 bit: 1 << 23)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S22
    pub mod S22 {
        /// Offset (22 bits)
        pub const offset: u32 = 22;
        /// Mask (1 bit: 1 << 22)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S21
    pub mod S21 {
        /// Offset (21 bits)
        pub const offset: u32 = 21;
        /// Mask (1 bit: 1 << 21)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S20
    pub mod S20 {
        /// Offset (20 bits)
        pub const offset: u32 = 20;
        /// Mask (1 bit: 1 << 20)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S19
    pub mod S19 {
        /// Offset (19 bits)
        pub const offset: u32 = 19;
        /// Mask (1 bit: 1 << 19)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S18
    pub mod S18 {
        /// Offset (18 bits)
        pub const offset: u32 = 18;
        /// Mask (1 bit: 1 << 18)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S17
    pub mod S17 {
        /// Offset (17 bits)
        pub const offset: u32 = 17;
        /// Mask (1 bit: 1 << 17)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S16
    pub mod S16 {
        /// Offset (16 bits)
        pub const offset: u32 = 16;
        /// Mask (1 bit: 1 << 16)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S15
    pub mod S15 {
        /// Offset (15 bits)
        pub const offset: u32 = 15;
        /// Mask (1 bit: 1 << 15)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S14
    pub mod S14 {
        /// Offset (14 bits)
        pub const offset: u32 = 14;
        /// Mask (1 bit: 1 << 14)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S13
    pub mod S13 {
        /// Offset (13 bits)
        pub const offset: u32 = 13;
        /// Mask (1 bit: 1 << 13)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S12
    pub mod S12 {
        /// Offset (12 bits)
        pub const offset: u32 = 12;
        /// Mask (1 bit: 1 << 12)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S11
    pub mod S11 {
        /// Offset (11 bits)
        pub const offset: u32 = 11;
        /// Mask (1 bit: 1 << 11)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S10
    pub mod S10 {
        /// Offset (10 bits)
        pub const offset: u32 = 10;
        /// Mask (1 bit: 1 << 10)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S09
    pub mod S09 {
        /// Offset (9 bits)
        pub const offset: u32 = 9;
        /// Mask (1 bit: 1 << 9)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S08
    pub mod S08 {
        /// Offset (8 bits)
        pub const offset: u32 = 8;
        /// Mask (1 bit: 1 << 8)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S07
    pub mod S07 {
        /// Offset (7 bits)
        pub const offset: u32 = 7;
        /// Mask (1 bit: 1 << 7)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S06
    pub mod S06 {
        /// Offset (6 bits)
        pub const offset: u32 = 6;
        /// Mask (1 bit: 1 << 6)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S05
    pub mod S05 {
        /// Offset (5 bits)
        pub const offset: u32 = 5;
        /// Mask (1 bit: 1 << 5)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S04
    pub mod S04 {
        /// Offset (4 bits)
        pub const offset: u32 = 4;
        /// Mask (1 bit: 1 << 4)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S03
    pub mod S03 {
        /// Offset (3 bits)
        pub const offset: u32 = 3;
        /// Mask (1 bit: 1 << 3)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S02
    pub mod S02 {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (1 bit: 1 << 2)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S01
    pub mod S01 {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// S00
    pub mod S00 {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// display memory
pub mod RAM_COM1 {
    pub use super::RAM_COM0::S00;
    pub use super::RAM_COM0::S01;
    pub use super::RAM_COM0::S02;
    pub use super::RAM_COM0::S03;
    pub use super::RAM_COM0::S04;
    pub use super::RAM_COM0::S05;
    pub use super::RAM_COM0::S06;
    pub use super::RAM_COM0::S07;
    pub use super::RAM_COM0::S08;
    pub use super::RAM_COM0::S09;
    pub use super::RAM_COM0::S10;
    pub use super::RAM_COM0::S11;
    pub use super::RAM_COM0::S12;
    pub use super::RAM_COM0::S13;
    pub use super::RAM_COM0::S14;
    pub use super::RAM_COM0::S15;
    pub use super::RAM_COM0::S16;
    pub use super::RAM_COM0::S17;
    pub use super::RAM_COM0::S18;
    pub use super::RAM_COM0::S19;
    pub use super::RAM_COM0::S20;
    pub use super::RAM_COM0::S21;
    pub use super::RAM_COM0::S22;
    pub use super::RAM_COM0::S23;
    pub use super::RAM_COM0::S24;
    pub use super::RAM_COM0::S25;
    pub use super::RAM_COM0::S26;
    pub use super::RAM_COM0::S27;
    pub use super::RAM_COM0::S28;
    pub use super::RAM_COM0::S29;
    pub use super::RAM_COM0::S30;
    pub use super::RAM_COM0::S31;
}

/// display memory
pub mod RAM_COM2 {
    pub use super::RAM_COM0::S00;
    pub use super::RAM_COM0::S01;
    pub use super::RAM_COM0::S02;
    pub use super::RAM_COM0::S03;
    pub use super::RAM_COM0::S04;
    pub use super::RAM_COM0::S05;
    pub use super::RAM_COM0::S06;
    pub use super::RAM_COM0::S07;
    pub use super::RAM_COM0::S08;
    pub use super::RAM_COM0::S09;
    pub use super::RAM_COM0::S10;
    pub use super::RAM_COM0::S11;
    pub use super::RAM_COM0::S12;
    pub use super::RAM_COM0::S13;
    pub use super::RAM_COM0::S14;
    pub use super::RAM_COM0::S15;
    pub use super::RAM_COM0::S16;
    pub use super::RAM_COM0::S17;
    pub use super::RAM_COM0::S18;
    pub use super::RAM_COM0::S19;
    pub use super::RAM_COM0::S20;
    pub use super::RAM_COM0::S21;
    pub use super::RAM_COM0::S22;
    pub use super::RAM_COM0::S23;
    pub use super::RAM_COM0::S24;
    pub use super::RAM_COM0::S25;
    pub use super::RAM_COM0::S26;
    pub use super::RAM_COM0::S27;
    pub use super::RAM_COM0::S28;
    pub use super::RAM_COM0::S29;
    pub use super::RAM_COM0::S30;
    pub use super::RAM_COM0::S31;
}

/// display memory
pub mod RAM_COM3 {
    pub use super::RAM_COM0::S00;
    pub use super::RAM_COM0::S01;
    pub use super::RAM_COM0::S02;
    pub use super::RAM_COM0::S03;
    pub use super::RAM_COM0::S04;
    pub use super::RAM_COM0::S05;
    pub use super::RAM_COM0::S06;
    pub use super::RAM_COM0::S07;
    pub use super::RAM_COM0::S08;
    pub use super::RAM_COM0::S09;
    pub use super::RAM_COM0::S10;
    pub use super::RAM_COM0::S11;
    pub use super::RAM_COM0::S12;
    pub use super::RAM_COM0::S13;
    pub use super::RAM_COM0::S14;
    pub use super::RAM_COM0::S15;
    pub use super::RAM_COM0::S16;
    pub use super::RAM_COM0::S17;
    pub use super::RAM_COM0::S18;
    pub use super::RAM_COM0::S19;
    pub use super::RAM_COM0::S20;
    pub use super::RAM_COM0::S21;
    pub use super::RAM_COM0::S22;
    pub use super::RAM_COM0::S23;
    pub use super::RAM_COM0::S24;
    pub use super::RAM_COM0::S25;
    pub use super::RAM_COM0::S26;
    pub use super::RAM_COM0::S27;
    pub use super::RAM_COM0::S28;
    pub use super::RAM_COM0::S29;
    pub use super::RAM_COM0::S30;
    pub use super::RAM_COM0::S31;
}

/// display memory
pub mod RAM_COM4 {
    pub use super::RAM_COM0::S00;
    pub use super::RAM_COM0::S01;
    pub use super::RAM_COM0::S02;
    pub use super::RAM_COM0::S03;
    pub use super::RAM_COM0::S04;
    pub use super::RAM_COM0::S05;
    pub use super::RAM_COM0::S06;
    pub use super::RAM_COM0::S07;
    pub use super::RAM_COM0::S08;
    pub use super::RAM_COM0::S09;
    pub use super::RAM_COM0::S10;
    pub use super::RAM_COM0::S11;
    pub use super::RAM_COM0::S12;
    pub use super::RAM_COM0::S13;
    pub use super::RAM_COM0::S14;
    pub use super::RAM_COM0::S15;
    pub use super::RAM_COM0::S16;
    pub use super::RAM_COM0::S17;
    pub use super::RAM_COM0::S18;
    pub use super::RAM_COM0::S19;
    pub use super::RAM_COM0::S20;
    pub use super::RAM_COM0::S21;
    pub use super::RAM_COM0::S22;
    pub use super::RAM_COM0::S23;
    pub use super::RAM_COM0::S24;
    pub use super::RAM_COM0::S25;
    pub use super::RAM_COM0::S26;
    pub use super::RAM_COM0::S27;
    pub use super::RAM_COM0::S28;
    pub use super::RAM_COM0::S29;
    pub use super::RAM_COM0::S30;
    pub use super::RAM_COM0::S31;
}

/// display memory
pub mod RAM_COM5 {
    pub use super::RAM_COM0::S00;
    pub use super::RAM_COM0::S01;
    pub use super::RAM_COM0::S02;
    pub use super::RAM_COM0::S03;
    pub use super::RAM_COM0::S04;
    pub use super::RAM_COM0::S05;
    pub use super::RAM_COM0::S06;
    pub use super::RAM_COM0::S07;
    pub use super::RAM_COM0::S08;
    pub use super::RAM_COM0::S09;
    pub use super::RAM_COM0::S10;
    pub use super::RAM_COM0::S11;
    pub use super::RAM_COM0::S12;
    pub use super::RAM_COM0::S13;
    pub use super::RAM_COM0::S14;
    pub use super::RAM_COM0::S15;
    pub use super::RAM_COM0::S16;
    pub use super::RAM_COM0::S17;
    pub use super::RAM_COM0::S18;
    pub use super::RAM_COM0::S19;
    pub use super::RAM_COM0::S20;
    pub use super::RAM_COM0::S21;
    pub use super::RAM_COM0::S22;
    pub use super::RAM_COM0::S23;
    pub use super::RAM_COM0::S24;
    pub use super::RAM_COM0::S25;
    pub use super::RAM_COM0::S26;
    pub use super::RAM_COM0::S27;
    pub use super::RAM_COM0::S28;
    pub use super::RAM_COM0::S29;
    pub use super::RAM_COM0::S30;
    pub use super::RAM_COM0::S31;
}

/// display memory
pub mod RAM_COM6 {
    pub use super::RAM_COM0::S00;
    pub use super::RAM_COM0::S01;
    pub use super::RAM_COM0::S02;
    pub use super::RAM_COM0::S03;
    pub use super::RAM_COM0::S04;
    pub use super::RAM_COM0::S05;
    pub use super::RAM_COM0::S06;
    pub use super::RAM_COM0::S07;
    pub use super::RAM_COM0::S08;
    pub use super::RAM_COM0::S09;
    pub use super::RAM_COM0::S10;
    pub use super::RAM_COM0::S11;
    pub use super::RAM_COM0::S12;
    pub use super::RAM_COM0::S13;
    pub use super::RAM_COM0::S14;
    pub use super::RAM_COM0::S15;
    pub use super::RAM_COM0::S16;
    pub use super::RAM_COM0::S17;
    pub use super::RAM_COM0::S18;
    pub use super::RAM_COM0::S19;
    pub use super::RAM_COM0::S20;
    pub use super::RAM_COM0::S21;
    pub use super::RAM_COM0::S22;
    pub use super::RAM_COM0::S23;
    pub use super::RAM_COM0::S24;
    pub use super::RAM_COM0::S25;
    pub use super::RAM_COM0::S26;
    pub use super::RAM_COM0::S27;
    pub use super::RAM_COM0::S28;
    pub use super::RAM_COM0::S29;
    pub use super::RAM_COM0::S30;
    pub use super::RAM_COM0::S31;
}

/// display memory
pub mod RAM_COM7 {
    pub use super::RAM_COM0::S00;
    pub use super::RAM_COM0::S01;
    pub use super::RAM_COM0::S02;
    pub use super::RAM_COM0::S03;
    pub use super::RAM_COM0::S04;
    pub use super::RAM_COM0::S05;
    pub use super::RAM_COM0::S06;
    pub use super::RAM_COM0::S07;
    pub use super::RAM_COM0::S08;
    pub use super::RAM_COM0::S09;
    pub use super::RAM_COM0::S10;
    pub use super::RAM_COM0::S11;
    pub use super::RAM_COM0::S12;
    pub use super::RAM_COM0::S13;
    pub use super::RAM_COM0::S14;
    pub use super::RAM_COM0::S15;
    pub use super::RAM_COM0::S16;
    pub use super::RAM_COM0::S17;
    pub use super::RAM_COM0::S18;
    pub use super::RAM_COM0::S19;
    pub use super::RAM_COM0::S20;
    pub use super::RAM_COM0::S21;
    pub use super::RAM_COM0::S22;
    pub use super::RAM_COM0::S23;
    pub use super::RAM_COM0::S24;
    pub use super::RAM_COM0::S25;
    pub use super::RAM_COM0::S26;
    pub use super::RAM_COM0::S27;
    pub use super::RAM_COM0::S28;
    pub use super::RAM_COM0::S29;
    pub use super::RAM_COM0::S30;
    pub use super::RAM_COM0::S31;
}
#[repr(C)]
pub struct RegisterBlock {
    /// control register
    pub CR: RWRegister<u32>,

    /// frame control register
    pub FCR: RWRegister<u32>,

    /// status register
    pub SR: RWRegister<u32>,

    /// clear register
    pub CLR: WORegister<u32>,

    _reserved1: [u32; 1],

    /// display memory
    pub RAM_COM0: RWRegister<u32>,

    _reserved2: [u32; 1],

    /// display memory
    pub RAM_COM1: RWRegister<u32>,

    _reserved3: [u32; 1],

    /// display memory
    pub RAM_COM2: RWRegister<u32>,

    _reserved4: [u32; 1],

    /// display memory
    pub RAM_COM3: RWRegister<u32>,

    _reserved5: [u32; 1],

    /// display memory
    pub RAM_COM4: RWRegister<u32>,

    _reserved6: [u32; 1],

    /// display memory
    pub RAM_COM5: RWRegister<u32>,

    _reserved7: [u32; 1],

    /// display memory
    pub RAM_COM6: RWRegister<u32>,

    _reserved8: [u32; 1],

    /// display memory
    pub RAM_COM7: RWRegister<u32>,
}
pub struct ResetValues {
    pub CR: u32,
    pub FCR: u32,
    pub SR: u32,
    pub CLR: u32,
    pub RAM_COM0: u32,
    pub RAM_COM1: u32,
    pub RAM_COM2: u32,
    pub RAM_COM3: u32,
    pub RAM_COM4: u32,
    pub RAM_COM5: u32,
    pub RAM_COM6: u32,
    pub RAM_COM7: u32,
}
#[cfg(not(feature = "nosync"))]
pub struct Instance {
    pub(crate) addr: u32,
    pub(crate) _marker: PhantomData<*const RegisterBlock>,
}
#[cfg(not(feature = "nosync"))]
impl ::core::ops::Deref for Instance {
    type Target = RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &RegisterBlock {
        unsafe { &*(self.addr as *const _) }
    }
}
#[cfg(feature = "rtic")]
unsafe impl Send for Instance {}
