#![allow(non_snake_case, non_upper_case_globals)]
#![allow(non_camel_case_types)]
//! Tamper and backup registers
//!
//! Used by: stm32g431, stm32g441, stm32g471, stm32g473, stm32g474, stm32g483, stm32g484, stm32g491, stm32g4a1

use crate::{RORegister, RWRegister};
#[cfg(not(feature = "nosync"))]
use core::marker::PhantomData;

/// control register 1
pub mod CR1 {

    /// TAMP1E
    pub mod TAMP1E {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP2E
    pub mod TAMP2E {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP2E
    pub mod TAMP3E {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (1 bit: 1 << 2)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP3E
    pub mod ITAMP3E {
        /// Offset (18 bits)
        pub const offset: u32 = 18;
        /// Mask (1 bit: 1 << 18)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP4E
    pub mod ITAMP4E {
        /// Offset (19 bits)
        pub const offset: u32 = 19;
        /// Mask (1 bit: 1 << 19)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP5E
    pub mod ITAMP5E {
        /// Offset (20 bits)
        pub const offset: u32 = 20;
        /// Mask (1 bit: 1 << 20)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP6E
    pub mod ITAMP6E {
        /// Offset (21 bits)
        pub const offset: u32 = 21;
        /// Mask (1 bit: 1 << 21)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// control register 2
pub mod CR2 {

    /// TAMP1NOER
    pub mod TAMP1NOER {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP2NOER
    pub mod TAMP2NOER {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP3NOER
    pub mod TAMP3NOER {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (1 bit: 1 << 2)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP1MSK
    pub mod TAMP1MSK {
        /// Offset (16 bits)
        pub const offset: u32 = 16;
        /// Mask (1 bit: 1 << 16)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP2MSK
    pub mod TAMP2MSK {
        /// Offset (17 bits)
        pub const offset: u32 = 17;
        /// Mask (1 bit: 1 << 17)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP3MSK
    pub mod TAMP3MSK {
        /// Offset (18 bits)
        pub const offset: u32 = 18;
        /// Mask (1 bit: 1 << 18)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP1TRG
    pub mod TAMP1TRG {
        /// Offset (24 bits)
        pub const offset: u32 = 24;
        /// Mask (1 bit: 1 << 24)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP2TRG
    pub mod TAMP2TRG {
        /// Offset (25 bits)
        pub const offset: u32 = 25;
        /// Mask (1 bit: 1 << 25)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP3TRG
    pub mod TAMP3TRG {
        /// Offset (26 bits)
        pub const offset: u32 = 26;
        /// Mask (1 bit: 1 << 26)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// TAMP filter control register
pub mod FLTCR {

    /// TAMPFREQ
    pub mod TAMPFREQ {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (3 bits: 0b111 << 0)
        pub const mask: u32 = 0b111 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMPFLT
    pub mod TAMPFLT {
        /// Offset (3 bits)
        pub const offset: u32 = 3;
        /// Mask (2 bits: 0b11 << 3)
        pub const mask: u32 = 0b11 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMPPRCH
    pub mod TAMPPRCH {
        /// Offset (5 bits)
        pub const offset: u32 = 5;
        /// Mask (2 bits: 0b11 << 5)
        pub const mask: u32 = 0b11 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMPPUDIS
    pub mod TAMPPUDIS {
        /// Offset (7 bits)
        pub const offset: u32 = 7;
        /// Mask (1 bit: 1 << 7)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// TAMP interrupt enable register
pub mod IER {

    /// TAMP1IE
    pub mod TAMP1IE {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP2IE
    pub mod TAMP2IE {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP3IE
    pub mod TAMP3IE {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (1 bit: 1 << 2)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP3IE
    pub mod ITAMP3IE {
        /// Offset (18 bits)
        pub const offset: u32 = 18;
        /// Mask (1 bit: 1 << 18)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP4IE
    pub mod ITAMP4IE {
        /// Offset (19 bits)
        pub const offset: u32 = 19;
        /// Mask (1 bit: 1 << 19)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP5IE
    pub mod ITAMP5IE {
        /// Offset (20 bits)
        pub const offset: u32 = 20;
        /// Mask (1 bit: 1 << 20)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP6IE
    pub mod ITAMP6IE {
        /// Offset (21 bits)
        pub const offset: u32 = 21;
        /// Mask (1 bit: 1 << 21)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// TAMP status register
pub mod SR {

    /// TAMP1F
    pub mod TAMP1F {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP2F
    pub mod TAMP2F {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP3F
    pub mod TAMP3F {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (1 bit: 1 << 2)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP3F
    pub mod ITAMP3F {
        /// Offset (18 bits)
        pub const offset: u32 = 18;
        /// Mask (1 bit: 1 << 18)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP4F
    pub mod ITAMP4F {
        /// Offset (19 bits)
        pub const offset: u32 = 19;
        /// Mask (1 bit: 1 << 19)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP5F
    pub mod ITAMP5F {
        /// Offset (20 bits)
        pub const offset: u32 = 20;
        /// Mask (1 bit: 1 << 20)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP6F
    pub mod ITAMP6F {
        /// Offset (21 bits)
        pub const offset: u32 = 21;
        /// Mask (1 bit: 1 << 21)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// TAMP masked interrupt status register
pub mod MISR {

    /// TAMP1MF:
    pub mod TAMP1MF {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP2MF
    pub mod TAMP2MF {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// TAMP3MF
    pub mod TAMP3MF {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (1 bit: 1 << 2)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP3MF
    pub mod ITAMP3MF {
        /// Offset (18 bits)
        pub const offset: u32 = 18;
        /// Mask (1 bit: 1 << 18)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP4MF
    pub mod ITAMP4MF {
        /// Offset (19 bits)
        pub const offset: u32 = 19;
        /// Mask (1 bit: 1 << 19)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP5MF
    pub mod ITAMP5MF {
        /// Offset (20 bits)
        pub const offset: u32 = 20;
        /// Mask (1 bit: 1 << 20)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// ITAMP6MF
    pub mod ITAMP6MF {
        /// Offset (21 bits)
        pub const offset: u32 = 21;
        /// Mask (1 bit: 1 << 21)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// TAMP status clear register
pub mod SCR {

    /// CTAMP1F
    pub mod CTAMP1F {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (1 bit: 1 << 0)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// CTAMP2F
    pub mod CTAMP2F {
        /// Offset (1 bits)
        pub const offset: u32 = 1;
        /// Mask (1 bit: 1 << 1)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// CTAMP3F
    pub mod CTAMP3F {
        /// Offset (2 bits)
        pub const offset: u32 = 2;
        /// Mask (1 bit: 1 << 2)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// CITAMP3F
    pub mod CITAMP3F {
        /// Offset (18 bits)
        pub const offset: u32 = 18;
        /// Mask (1 bit: 1 << 18)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// CITAMP4F
    pub mod CITAMP4F {
        /// Offset (19 bits)
        pub const offset: u32 = 19;
        /// Mask (1 bit: 1 << 19)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// CITAMP5F
    pub mod CITAMP5F {
        /// Offset (20 bits)
        pub const offset: u32 = 20;
        /// Mask (1 bit: 1 << 20)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }

    /// CITAMP6F
    pub mod CITAMP6F {
        /// Offset (21 bits)
        pub const offset: u32 = 21;
        /// Mask (1 bit: 1 << 21)
        pub const mask: u32 = 1 << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// TAMP backup register
pub mod BKP0R {

    /// BKP
    pub mod BKP {
        /// Offset (0 bits)
        pub const offset: u32 = 0;
        /// Mask (32 bits: 0xffffffff << 0)
        pub const mask: u32 = 0xffffffff << offset;
        /// Read-only values (empty)
        pub mod R {}
        /// Write-only values (empty)
        pub mod W {}
        /// Read-write values (empty)
        pub mod RW {}
    }
}

/// TAMP backup register
pub mod BKP1R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP2R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP3R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP4R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP5R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP6R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP7R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP8R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP9R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP10R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP11R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP12R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP13R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP14R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP15R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP16R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP17R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP18R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP19R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP20R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP21R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP22R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP23R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP24R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP25R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP26R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP27R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP28R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP29R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP30R {
    pub use super::BKP0R::BKP;
}

/// TAMP backup register
pub mod BKP31R {
    pub use super::BKP0R::BKP;
}
#[repr(C)]
pub struct RegisterBlock {
    /// control register 1
    pub CR1: RWRegister<u32>,

    /// control register 2
    pub CR2: RWRegister<u32>,

    _reserved1: [u32; 1],

    /// TAMP filter control register
    pub FLTCR: RWRegister<u32>,

    _reserved2: [u32; 7],

    /// TAMP interrupt enable register
    pub IER: RWRegister<u32>,

    /// TAMP status register
    pub SR: RORegister<u32>,

    /// TAMP masked interrupt status register
    pub MISR: RORegister<u32>,

    _reserved3: [u32; 1],

    /// TAMP status clear register
    pub SCR: RWRegister<u32>,

    _reserved4: [u32; 48],

    /// TAMP backup register
    pub BKP0R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP1R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP2R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP3R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP4R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP5R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP6R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP7R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP8R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP9R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP10R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP11R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP12R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP13R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP14R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP15R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP16R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP17R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP18R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP19R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP20R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP21R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP22R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP23R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP24R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP25R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP26R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP27R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP28R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP29R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP30R: RWRegister<u32>,

    /// TAMP backup register
    pub BKP31R: RWRegister<u32>,
}
pub struct ResetValues {
    pub CR1: u32,
    pub CR2: u32,
    pub FLTCR: u32,
    pub IER: u32,
    pub SR: u32,
    pub MISR: u32,
    pub SCR: u32,
    pub BKP0R: u32,
    pub BKP1R: u32,
    pub BKP2R: u32,
    pub BKP3R: u32,
    pub BKP4R: u32,
    pub BKP5R: u32,
    pub BKP6R: u32,
    pub BKP7R: u32,
    pub BKP8R: u32,
    pub BKP9R: u32,
    pub BKP10R: u32,
    pub BKP11R: u32,
    pub BKP12R: u32,
    pub BKP13R: u32,
    pub BKP14R: u32,
    pub BKP15R: u32,
    pub BKP16R: u32,
    pub BKP17R: u32,
    pub BKP18R: u32,
    pub BKP19R: u32,
    pub BKP20R: u32,
    pub BKP21R: u32,
    pub BKP22R: u32,
    pub BKP23R: u32,
    pub BKP24R: u32,
    pub BKP25R: u32,
    pub BKP26R: u32,
    pub BKP27R: u32,
    pub BKP28R: u32,
    pub BKP29R: u32,
    pub BKP30R: u32,
    pub BKP31R: u32,
}
#[cfg(not(feature = "nosync"))]
pub struct Instance {
    pub(crate) addr: u32,
    pub(crate) _marker: PhantomData<*const RegisterBlock>,
}
#[cfg(not(feature = "nosync"))]
impl ::core::ops::Deref for Instance {
    type Target = RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &RegisterBlock {
        unsafe { &*(self.addr as *const _) }
    }
}
#[cfg(feature = "rtic")]
unsafe impl Send for Instance {}
