#[doc = "Register `LTDC_GCR` reader"]
pub struct R(crate::R<LTDC_GCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LTDC_GCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LTDC_GCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LTDC_GCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LTDC_GCR` writer"]
pub struct W(crate::W<LTDC_GCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LTDC_GCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LTDC_GCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LTDC_GCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LTDCEN` reader - LTDCEN"]
pub struct LTDCEN_R(crate::FieldReader<bool, bool>);
impl LTDCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        LTDCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LTDCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LTDCEN` writer - LTDCEN"]
pub struct LTDCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> LTDCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `DBW` reader - DBW"]
pub struct DBW_R(crate::FieldReader<u8, u8>);
impl DBW_R {
    pub(crate) fn new(bits: u8) -> Self {
        DBW_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DBW_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DGW` reader - DGW"]
pub struct DGW_R(crate::FieldReader<u8, u8>);
impl DGW_R {
    pub(crate) fn new(bits: u8) -> Self {
        DGW_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DGW_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DRW` reader - DRW"]
pub struct DRW_R(crate::FieldReader<u8, u8>);
impl DRW_R {
    pub(crate) fn new(bits: u8) -> Self {
        DRW_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DRW_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DEN` reader - DEN"]
pub struct DEN_R(crate::FieldReader<bool, bool>);
impl DEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        DEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DEN` writer - DEN"]
pub struct DEN_W<'a> {
    w: &'a mut W,
}
impl<'a> DEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `PCPOL` reader - PCPOL"]
pub struct PCPOL_R(crate::FieldReader<bool, bool>);
impl PCPOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCPOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCPOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCPOL` writer - PCPOL"]
pub struct PCPOL_W<'a> {
    w: &'a mut W,
}
impl<'a> PCPOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | ((value as u32 & 0x01) << 28);
        self.w
    }
}
#[doc = "Field `DEPOL` reader - DEPOL"]
pub struct DEPOL_R(crate::FieldReader<bool, bool>);
impl DEPOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        DEPOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DEPOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DEPOL` writer - DEPOL"]
pub struct DEPOL_W<'a> {
    w: &'a mut W,
}
impl<'a> DEPOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | ((value as u32 & 0x01) << 29);
        self.w
    }
}
#[doc = "Field `VSPOL` reader - VSPOL"]
pub struct VSPOL_R(crate::FieldReader<bool, bool>);
impl VSPOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        VSPOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VSPOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VSPOL` writer - VSPOL"]
pub struct VSPOL_W<'a> {
    w: &'a mut W,
}
impl<'a> VSPOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
#[doc = "Field `HSPOL` reader - HSPOL"]
pub struct HSPOL_R(crate::FieldReader<bool, bool>);
impl HSPOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        HSPOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HSPOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HSPOL` writer - HSPOL"]
pub struct HSPOL_W<'a> {
    w: &'a mut W,
}
impl<'a> HSPOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - LTDCEN"]
    #[inline(always)]
    pub fn ltdcen(&self) -> LTDCEN_R {
        LTDCEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 4:6 - DBW"]
    #[inline(always)]
    pub fn dbw(&self) -> DBW_R {
        DBW_R::new(((self.bits >> 4) & 0x07) as u8)
    }
    #[doc = "Bits 8:10 - DGW"]
    #[inline(always)]
    pub fn dgw(&self) -> DGW_R {
        DGW_R::new(((self.bits >> 8) & 0x07) as u8)
    }
    #[doc = "Bits 12:14 - DRW"]
    #[inline(always)]
    pub fn drw(&self) -> DRW_R {
        DRW_R::new(((self.bits >> 12) & 0x07) as u8)
    }
    #[doc = "Bit 16 - DEN"]
    #[inline(always)]
    pub fn den(&self) -> DEN_R {
        DEN_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 28 - PCPOL"]
    #[inline(always)]
    pub fn pcpol(&self) -> PCPOL_R {
        PCPOL_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bit 29 - DEPOL"]
    #[inline(always)]
    pub fn depol(&self) -> DEPOL_R {
        DEPOL_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 30 - VSPOL"]
    #[inline(always)]
    pub fn vspol(&self) -> VSPOL_R {
        VSPOL_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 31 - HSPOL"]
    #[inline(always)]
    pub fn hspol(&self) -> HSPOL_R {
        HSPOL_R::new(((self.bits >> 31) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - LTDCEN"]
    #[inline(always)]
    pub fn ltdcen(&mut self) -> LTDCEN_W {
        LTDCEN_W { w: self }
    }
    #[doc = "Bit 16 - DEN"]
    #[inline(always)]
    pub fn den(&mut self) -> DEN_W {
        DEN_W { w: self }
    }
    #[doc = "Bit 28 - PCPOL"]
    #[inline(always)]
    pub fn pcpol(&mut self) -> PCPOL_W {
        PCPOL_W { w: self }
    }
    #[doc = "Bit 29 - DEPOL"]
    #[inline(always)]
    pub fn depol(&mut self) -> DEPOL_W {
        DEPOL_W { w: self }
    }
    #[doc = "Bit 30 - VSPOL"]
    #[inline(always)]
    pub fn vspol(&mut self) -> VSPOL_W {
        VSPOL_W { w: self }
    }
    #[doc = "Bit 31 - HSPOL"]
    #[inline(always)]
    pub fn hspol(&mut self) -> HSPOL_W {
        HSPOL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "This register defines the global configuration of the LCD-TFT controller.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ltdc_gcr](index.html) module"]
pub struct LTDC_GCR_SPEC;
impl crate::RegisterSpec for LTDC_GCR_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ltdc_gcr::R](R) reader structure"]
impl crate::Readable for LTDC_GCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ltdc_gcr::W](W) writer structure"]
impl crate::Writable for LTDC_GCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LTDC_GCR to value 0x2220"]
impl crate::Resettable for LTDC_GCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x2220
    }
}
