#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - FDCAN core release register"]
    pub fdcan_crel: crate::Reg<fdcan_crel::FDCAN_CREL_SPEC>,
    #[doc = "0x04 - FDCAN Endian register"]
    pub fdcan_endn: crate::Reg<fdcan_endn::FDCAN_ENDN_SPEC>,
    _reserved2: [u8; 0x04],
    #[doc = "0x0c - This register is dedicated to data bit timing phase and only writable if bits FDCAN_CCCR.CCE and FDCAN_CCCR.INIT are set. The CAN time quantum may be programmed in the range from 1 to 32 FDCAN clock periods. tq = (DBRP + 1) FDCAN clock periods. DTSEG1 is the sum of Prop_Seg and Phase_Seg1. DTSEG2 is Phase_Seg2. Therefore the length of the bit time is (DTSEG1 + DTSEG2 + 3) tq for programmed values, or (Sync_Seg+Prop_Seg+Phase_Seg1+Phase_Seg2) tq for functional values. The information processing time (IPT) is zero, meaning the data for the next bit is available at the first clock edge after the sample point."]
    pub fdcan_dbtp: crate::Reg<fdcan_dbtp::FDCAN_DBTP_SPEC>,
    #[doc = "0x10 - Write access to this register has to be enabled by setting bit FDCAN_CCCR.TEST to 1. All register functions are set to their reset values when bit FDCAN_CCCR.TEST is reset. Loop back mode and software control of Tx pin FDCANx_TX are hardware test modes. Programming TX differently from 00 may disturb the message transfer on the CAN bus."]
    pub fdcan_test: crate::Reg<fdcan_test::FDCAN_TEST_SPEC>,
    #[doc = "0x14 - The RAM watchdog monitors the READY output of the message RAM. A message RAM access starts the message RAM watchdog counter with the value configured by the FDCAN_RWD.WDC bits. The counter is reloaded with FDCAN_RWD.WDC bits when the message RAM signals successful completion by activating its READY output. In case there is no response from the message RAM until the counter has counted down to 0, the counter stops and interrupt flag FDCAN_IR.WDI bit is set. The RAM watchdog counter is clocked by the fdcan_pclk clock."]
    pub fdcan_rwd: crate::Reg<fdcan_rwd::FDCAN_RWD_SPEC>,
    #[doc = "0x18 - For details about setting and resetting of single bits see Software initialization."]
    pub fdcan_cccr: crate::Reg<fdcan_cccr::FDCAN_CCCR_SPEC>,
    #[doc = "0x1c - This register is dedicated to the nominal bit timing used during the arbitration phase."]
    pub fdcan_nbtp: crate::Reg<fdcan_nbtp::FDCAN_NBTP_SPEC>,
    #[doc = "0x20 - FDCAN timestamp counter configuration register"]
    pub fdcan_tscc: crate::Reg<fdcan_tscc::FDCAN_TSCC_SPEC>,
    #[doc = "0x24 - FDCAN timestamp counter value register"]
    pub fdcan_tscv: crate::Reg<fdcan_tscv::FDCAN_TSCV_SPEC>,
    #[doc = "0x28 - FDCAN timeout counter configuration register"]
    pub fdcan_tocc: crate::Reg<fdcan_tocc::FDCAN_TOCC_SPEC>,
    #[doc = "0x2c - FDCAN timeout counter value register"]
    pub fdcan_tocv: crate::Reg<fdcan_tocv::FDCAN_TOCV_SPEC>,
    _reserved11: [u8; 0x10],
    #[doc = "0x40 - FDCAN error counter register"]
    pub fdcan_ecr: crate::Reg<fdcan_ecr::FDCAN_ECR_SPEC>,
    #[doc = "0x44 - FDCAN protocol status register"]
    pub fdcan_psr: crate::Reg<fdcan_psr::FDCAN_PSR_SPEC>,
    #[doc = "0x48 - FDCAN transmitter delay compensation register"]
    pub fdcan_tdcr: crate::Reg<fdcan_tdcr::FDCAN_TDCR_SPEC>,
    _reserved14: [u8; 0x04],
    #[doc = "0x50 - The flags are set when one of the listed conditions is detected (edge-sensitive). The flags remain set until the Host clears them. A flag is cleared by writing a 1 to the corresponding bit position. Writing a 0 has no effect. A hard reset will clear the register. The configuration of IE controls whether an interrupt is generated. The configuration of ILS controls on which interrupt line an interrupt is signaled."]
    pub fdcan_ir: crate::Reg<fdcan_ir::FDCAN_IR_SPEC>,
    #[doc = "0x54 - The settings in the interrupt enable register determine which status changes in the interrupt register will be signaled on an interrupt line."]
    pub fdcan_ie: crate::Reg<fdcan_ie::FDCAN_IE_SPEC>,
    #[doc = "0x58 - This register assigns an interrupt generated by a specific interrupt flag from the interrupt register to one of the two module interrupt lines. For interrupt generation the respective interrupt line has to be enabled via FDCAN_ILE.EINT0 and FDCAN_ILE.EINT1."]
    pub fdcan_ils: crate::Reg<fdcan_ils::FDCAN_ILS_SPEC>,
    #[doc = "0x5c - Each of the two interrupt lines to the CPU can be enabled/disabled separately by programming bits EINT0 and EINT1."]
    pub fdcan_ile: crate::Reg<fdcan_ile::FDCAN_ILE_SPEC>,
    _reserved18: [u8; 0x20],
    #[doc = "0x80 - Global settings for message ID filtering. The global filter configuration register controls the filter path for standard and extended messages as described in Figure708: Standard message ID filter path and Figure709: Extended message ID filter path."]
    pub fdcan_gfc: crate::Reg<fdcan_gfc::FDCAN_GFC_SPEC>,
    #[doc = "0x84 - Settings for 11-bit standard message ID filtering.The standard ID filter configuration register controls the filter path for standard messages as described in Figure708."]
    pub fdcan_sidfc: crate::Reg<fdcan_sidfc::FDCAN_SIDFC_SPEC>,
    #[doc = "0x88 - Settings for 29-bit extended message ID filtering. The FDCAN extended ID filter configuration register controls the filter path for standard messages as described in Figure709: Extended message ID filter path."]
    pub fdcan_xidfc: crate::Reg<fdcan_xidfc::FDCAN_XIDFC_SPEC>,
    _reserved21: [u8; 0x04],
    #[doc = "0x90 - FDCAN extended ID and mask register"]
    pub fdcan_xidam: crate::Reg<fdcan_xidam::FDCAN_XIDAM_SPEC>,
    #[doc = "0x94 - This register is updated every time a message ID filter element configured to generate a priority event match. This can be used to monitor the status of incoming high priority messages and to enable fast access to these messages."]
    pub fdcan_hpms: crate::Reg<fdcan_hpms::FDCAN_HPMS_SPEC>,
    #[doc = "0x98 - FDCAN new data 1 register"]
    pub fdcan_ndat1: crate::Reg<fdcan_ndat1::FDCAN_NDAT1_SPEC>,
    #[doc = "0x9c - FDCAN new data 2 register"]
    pub fdcan_ndat2: crate::Reg<fdcan_ndat2::FDCAN_NDAT2_SPEC>,
    #[doc = "0xa0 - FDCAN Rx FIFO 0 configuration register"]
    pub fdcan_rxf0c: crate::Reg<fdcan_rxf0c::FDCAN_RXF0C_SPEC>,
    #[doc = "0xa4 - FDCAN Rx FIFO 0 status register"]
    pub fdcan_rxf0s: crate::Reg<fdcan_rxf0s::FDCAN_RXF0S_SPEC>,
    #[doc = "0xa8 - FDCAN Rx FIFO 0 acknowledge register"]
    pub fdcan_rxf0a: crate::Reg<fdcan_rxf0a::FDCAN_RXF0A_SPEC>,
    #[doc = "0xac - FDCAN Rx buffer configuration register"]
    pub fdcan_rxbc: crate::Reg<fdcan_rxbc::FDCAN_RXBC_SPEC>,
    #[doc = "0xb0 - FDCAN Rx FIFO 1 configuration register"]
    pub fdcan_rxf1c: crate::Reg<fdcan_rxf1c::FDCAN_RXF1C_SPEC>,
    #[doc = "0xb4 - FDCAN Rx FIFO 1 status register"]
    pub fdcan_rxf1s: crate::Reg<fdcan_rxf1s::FDCAN_RXF1S_SPEC>,
    #[doc = "0xb8 - FDCAN Rx FIFO 1 acknowledge register"]
    pub fdcan_rxf1a: crate::Reg<fdcan_rxf1a::FDCAN_RXF1A_SPEC>,
    #[doc = "0xbc - Configures the number of data bytes belonging to an Rx buffer / Rx FIFO element. Data field sizes higher than 8 bytes are intended for CAN FD operation only."]
    pub fdcan_rxesc: crate::Reg<fdcan_rxesc::FDCAN_RXESC_SPEC>,
    #[doc = "0xc0 - FDCAN Tx buffer configuration register"]
    pub fdcan_txbc: crate::Reg<fdcan_txbc::FDCAN_TXBC_SPEC>,
    #[doc = "0xc4 - The Tx FIFO/queue status is related to the pending Tx requests listed in register FDCAN_TXBRP. Therefore the effect of add/cancellation requests may be delayed due to a running Tx scan (FDCAN_TXBRP not yet updated)."]
    pub fdcan_txfqs: crate::Reg<fdcan_txfqs::FDCAN_TXFQS_SPEC>,
    #[doc = "0xc8 - Configures the number of data bytes belonging to a Tx buffer element. Data field sizes &gt;8 bytes are intended for CAN FD operation only."]
    pub fdcan_txesc: crate::Reg<fdcan_txesc::FDCAN_TXESC_SPEC>,
    _reserved36: [u8; 0x04],
    #[doc = "0xd0 - FDCAN Tx buffer add request register"]
    pub fdcan_txbar: crate::Reg<fdcan_txbar::FDCAN_TXBAR_SPEC>,
    #[doc = "0xd4 - FDCAN Tx buffer cancellation request register"]
    pub fdcan_txbcr: crate::Reg<fdcan_txbcr::FDCAN_TXBCR_SPEC>,
    #[doc = "0xd8 - FDCAN Tx buffer transmission occurred register"]
    pub fdcan_txbto: crate::Reg<fdcan_txbto::FDCAN_TXBTO_SPEC>,
    #[doc = "0xdc - FDCAN Tx buffer cancellation finished register"]
    pub fdcan_txbcf: crate::Reg<fdcan_txbcf::FDCAN_TXBCF_SPEC>,
    #[doc = "0xe0 - FDCAN Tx buffer transmission interrupt enable register"]
    pub fdcan_txbtie: crate::Reg<fdcan_txbtie::FDCAN_TXBTIE_SPEC>,
    #[doc = "0xe4 - FDCAN Tx buffer cancellation finished interrupt enable register"]
    pub fdcan_txbcie: crate::Reg<fdcan_txbcie::FDCAN_TXBCIE_SPEC>,
    _reserved42: [u8; 0x08],
    #[doc = "0xf0 - FDCAN Tx event FIFO configuration register"]
    pub fdcan_txefc: crate::Reg<fdcan_txefc::FDCAN_TXEFC_SPEC>,
    #[doc = "0xf4 - FDCAN Tx event FIFO status register"]
    pub fdcan_txefs: crate::Reg<fdcan_txefs::FDCAN_TXEFS_SPEC>,
    #[doc = "0xf8 - FDCAN Tx event FIFO acknowledge register"]
    pub fdcan_txefa: crate::Reg<fdcan_txefa::FDCAN_TXEFA_SPEC>,
    _reserved45: [u8; 0x04],
    #[doc = "0x100 - FDCAN TT trigger memory configuration register"]
    pub fdcan_tttmc: crate::Reg<fdcan_tttmc::FDCAN_TTTMC_SPEC>,
    #[doc = "0x104 - FDCAN TT reference message configuration register"]
    pub fdcan_ttrmc: crate::Reg<fdcan_ttrmc::FDCAN_TTRMC_SPEC>,
    #[doc = "0x108 - FDCAN TT operation configuration register"]
    pub fdcan_ttocf: crate::Reg<fdcan_ttocf::FDCAN_TTOCF_SPEC>,
    #[doc = "0x10c - FDCAN TT matrix limits register"]
    pub fdcan_ttmlm: crate::Reg<fdcan_ttmlm::FDCAN_TTMLM_SPEC>,
    #[doc = "0x110 - The length of the NTU is given by: NTU = CAN clock period x NC/DC. NC is an 18-bit value. Its high part, NCH\\[17:16\\]
is hard wired to 0b01. Therefore the range of NC extends from 0x10000 to 0x1FFFF. The value configured by NCL is the initial value for FDCAN_TURNA.NAV\\[15:0\\]. DC is set to 0x1000 by hardware reset and it may not be written to 0x0000. Level 1: NC 4 * DC and NTU = CAN bit time Levels 0 and 2: NC 8 * DC The actual value of FDCAN_TUR may be changed by the clock drift compensation function of TTCAN level 0 and level 2 in order to adjust the node local view of the NTU to the time master view of the NTU. DC will not be changed by the automatic drift compensation, FDCAN_TURNA.NAV may be adjusted around NC in the range of the synchronization deviation limit given by FDCAN_TTOCF.LDSDL. NC and DC should be programmed to the largest suitable values in achieve the best computational accuracy for the drift compensation process."]
    pub fdcan_turcf: crate::Reg<fdcan_turcf::FDCAN_TURCF_SPEC>,
    #[doc = "0x114 - FDCAN TT operation control register"]
    pub fdcan_ttocn: crate::Reg<fdcan_ttocn::FDCAN_TTOCN_SPEC>,
    #[doc = "0x118 - If TTOST.WGDT is set, the next reference message will be transmitted with the Master_Ref_Mark modified by the preset value and with Disc_Bit = 1, presetting the global time in all nodes simultaneously. TP is reset to 0x0000 each time a reference message with Disc_Bit = 1 becomes valid or if the node is not the current time master. TP is locked while FDCAN_TTOST.WGTD = 1 after setting FDCAN_TTOCN.SGT until the reference message with Disc_Bit = 1 becomes valid or until the node is no longer the current time master."]
    pub fdcan_ttgtp: crate::Reg<fdcan_ttgtp::FDCAN_TTGTP_SPEC>,
    #[doc = "0x11c - A time mark interrupt (FDCAN_TTIR.TMI = 1) is generated when the time base indicated by FDCAN_TTOCN.TMC (cycle time, local time, or global time) has the same value as TM."]
    pub fdcan_tttmk: crate::Reg<fdcan_tttmk::FDCAN_TTTMK_SPEC>,
    #[doc = "0x120 - The flags are set when one of the listed conditions is detected (edge-sensitive). The flags remain set until the Host clears them. A flag is cleared by writing a 1 to the corresponding bit position. Writing a 0 has no effect. A hard reset will clear the register."]
    pub fdcan_ttir: crate::Reg<fdcan_ttir::FDCAN_TTIR_SPEC>,
    #[doc = "0x124 - The settings in the TT interrupt enable register determine which status changes in the TT interrupt register will result in an interrupt."]
    pub fdcan_ttie: crate::Reg<fdcan_ttie::FDCAN_TTIE_SPEC>,
    #[doc = "0x128 - The TT interrupt Line select register assigns an interrupt generated by a specific interrupt flag from the TT interrupt register to one of the two module interrupt lines. For interrupt generation the respective interrupt line has to be enabled via FDCAN_ILE.EINT0 and FDCAN_ILE.EINT1."]
    pub fdcan_ttils: crate::Reg<fdcan_ttils::FDCAN_TTILS_SPEC>,
    #[doc = "0x12c - FDCAN TT operation status register"]
    pub fdcan_ttost: crate::Reg<fdcan_ttost::FDCAN_TTOST_SPEC>,
    #[doc = "0x130 - There is no drift compensation in TTCAN level 1."]
    pub fdcan_turna: crate::Reg<fdcan_turna::FDCAN_TURNA_SPEC>,
    #[doc = "0x134 - FDCAN TT local and global time register"]
    pub fdcan_ttlgt: crate::Reg<fdcan_ttlgt::FDCAN_TTLGT_SPEC>,
    #[doc = "0x138 - FDCAN TT cycle time and count register"]
    pub fdcan_ttctc: crate::Reg<fdcan_ttctc::FDCAN_TTCTC_SPEC>,
    #[doc = "0x13c - FDCAN TT capture time register"]
    pub fdcan_ttcpt: crate::Reg<fdcan_ttcpt::FDCAN_TTCPT_SPEC>,
    #[doc = "0x140 - FDCAN TT cycle sync mark register"]
    pub fdcan_ttcsm: crate::Reg<fdcan_ttcsm::FDCAN_TTCSM_SPEC>,
    _reserved62: [u8; 0x01bc],
    #[doc = "0x300 - The settings in the FDCAN_TTTS register select the input to be used as event trigger and stop watch trigger."]
    pub fdcan_ttts: crate::Reg<fdcan_ttts::FDCAN_TTTS_SPEC>,
}
#[doc = "FDCAN_CREL register accessor: an alias for `Reg<FDCAN_CREL_SPEC>`"]
pub type FDCAN_CREL = crate::Reg<fdcan_crel::FDCAN_CREL_SPEC>;
#[doc = "FDCAN core release register"]
pub mod fdcan_crel;
#[doc = "FDCAN_ENDN register accessor: an alias for `Reg<FDCAN_ENDN_SPEC>`"]
pub type FDCAN_ENDN = crate::Reg<fdcan_endn::FDCAN_ENDN_SPEC>;
#[doc = "FDCAN Endian register"]
pub mod fdcan_endn;
#[doc = "FDCAN_DBTP register accessor: an alias for `Reg<FDCAN_DBTP_SPEC>`"]
pub type FDCAN_DBTP = crate::Reg<fdcan_dbtp::FDCAN_DBTP_SPEC>;
#[doc = "This register is dedicated to data bit timing phase and only writable if bits FDCAN_CCCR.CCE and FDCAN_CCCR.INIT are set. The CAN time quantum may be programmed in the range from 1 to 32 FDCAN clock periods. tq = (DBRP + 1) FDCAN clock periods. DTSEG1 is the sum of Prop_Seg and Phase_Seg1. DTSEG2 is Phase_Seg2. Therefore the length of the bit time is (DTSEG1 + DTSEG2 + 3) tq for programmed values, or (Sync_Seg+Prop_Seg+Phase_Seg1+Phase_Seg2) tq for functional values. The information processing time (IPT) is zero, meaning the data for the next bit is available at the first clock edge after the sample point."]
pub mod fdcan_dbtp;
#[doc = "FDCAN_TEST register accessor: an alias for `Reg<FDCAN_TEST_SPEC>`"]
pub type FDCAN_TEST = crate::Reg<fdcan_test::FDCAN_TEST_SPEC>;
#[doc = "Write access to this register has to be enabled by setting bit FDCAN_CCCR.TEST to 1. All register functions are set to their reset values when bit FDCAN_CCCR.TEST is reset. Loop back mode and software control of Tx pin FDCANx_TX are hardware test modes. Programming TX differently from 00 may disturb the message transfer on the CAN bus."]
pub mod fdcan_test;
#[doc = "FDCAN_RWD register accessor: an alias for `Reg<FDCAN_RWD_SPEC>`"]
pub type FDCAN_RWD = crate::Reg<fdcan_rwd::FDCAN_RWD_SPEC>;
#[doc = "The RAM watchdog monitors the READY output of the message RAM. A message RAM access starts the message RAM watchdog counter with the value configured by the FDCAN_RWD.WDC bits. The counter is reloaded with FDCAN_RWD.WDC bits when the message RAM signals successful completion by activating its READY output. In case there is no response from the message RAM until the counter has counted down to 0, the counter stops and interrupt flag FDCAN_IR.WDI bit is set. The RAM watchdog counter is clocked by the fdcan_pclk clock."]
pub mod fdcan_rwd;
#[doc = "FDCAN_CCCR register accessor: an alias for `Reg<FDCAN_CCCR_SPEC>`"]
pub type FDCAN_CCCR = crate::Reg<fdcan_cccr::FDCAN_CCCR_SPEC>;
#[doc = "For details about setting and resetting of single bits see Software initialization."]
pub mod fdcan_cccr;
#[doc = "FDCAN_NBTP register accessor: an alias for `Reg<FDCAN_NBTP_SPEC>`"]
pub type FDCAN_NBTP = crate::Reg<fdcan_nbtp::FDCAN_NBTP_SPEC>;
#[doc = "This register is dedicated to the nominal bit timing used during the arbitration phase."]
pub mod fdcan_nbtp;
#[doc = "FDCAN_TSCC register accessor: an alias for `Reg<FDCAN_TSCC_SPEC>`"]
pub type FDCAN_TSCC = crate::Reg<fdcan_tscc::FDCAN_TSCC_SPEC>;
#[doc = "FDCAN timestamp counter configuration register"]
pub mod fdcan_tscc;
#[doc = "FDCAN_TSCV register accessor: an alias for `Reg<FDCAN_TSCV_SPEC>`"]
pub type FDCAN_TSCV = crate::Reg<fdcan_tscv::FDCAN_TSCV_SPEC>;
#[doc = "FDCAN timestamp counter value register"]
pub mod fdcan_tscv;
#[doc = "FDCAN_TOCC register accessor: an alias for `Reg<FDCAN_TOCC_SPEC>`"]
pub type FDCAN_TOCC = crate::Reg<fdcan_tocc::FDCAN_TOCC_SPEC>;
#[doc = "FDCAN timeout counter configuration register"]
pub mod fdcan_tocc;
#[doc = "FDCAN_TOCV register accessor: an alias for `Reg<FDCAN_TOCV_SPEC>`"]
pub type FDCAN_TOCV = crate::Reg<fdcan_tocv::FDCAN_TOCV_SPEC>;
#[doc = "FDCAN timeout counter value register"]
pub mod fdcan_tocv;
#[doc = "FDCAN_ECR register accessor: an alias for `Reg<FDCAN_ECR_SPEC>`"]
pub type FDCAN_ECR = crate::Reg<fdcan_ecr::FDCAN_ECR_SPEC>;
#[doc = "FDCAN error counter register"]
pub mod fdcan_ecr;
#[doc = "FDCAN_PSR register accessor: an alias for `Reg<FDCAN_PSR_SPEC>`"]
pub type FDCAN_PSR = crate::Reg<fdcan_psr::FDCAN_PSR_SPEC>;
#[doc = "FDCAN protocol status register"]
pub mod fdcan_psr;
#[doc = "FDCAN_TDCR register accessor: an alias for `Reg<FDCAN_TDCR_SPEC>`"]
pub type FDCAN_TDCR = crate::Reg<fdcan_tdcr::FDCAN_TDCR_SPEC>;
#[doc = "FDCAN transmitter delay compensation register"]
pub mod fdcan_tdcr;
#[doc = "FDCAN_IR register accessor: an alias for `Reg<FDCAN_IR_SPEC>`"]
pub type FDCAN_IR = crate::Reg<fdcan_ir::FDCAN_IR_SPEC>;
#[doc = "The flags are set when one of the listed conditions is detected (edge-sensitive). The flags remain set until the Host clears them. A flag is cleared by writing a 1 to the corresponding bit position. Writing a 0 has no effect. A hard reset will clear the register. The configuration of IE controls whether an interrupt is generated. The configuration of ILS controls on which interrupt line an interrupt is signaled."]
pub mod fdcan_ir;
#[doc = "FDCAN_IE register accessor: an alias for `Reg<FDCAN_IE_SPEC>`"]
pub type FDCAN_IE = crate::Reg<fdcan_ie::FDCAN_IE_SPEC>;
#[doc = "The settings in the interrupt enable register determine which status changes in the interrupt register will be signaled on an interrupt line."]
pub mod fdcan_ie;
#[doc = "FDCAN_ILS register accessor: an alias for `Reg<FDCAN_ILS_SPEC>`"]
pub type FDCAN_ILS = crate::Reg<fdcan_ils::FDCAN_ILS_SPEC>;
#[doc = "This register assigns an interrupt generated by a specific interrupt flag from the interrupt register to one of the two module interrupt lines. For interrupt generation the respective interrupt line has to be enabled via FDCAN_ILE.EINT0 and FDCAN_ILE.EINT1."]
pub mod fdcan_ils;
#[doc = "FDCAN_ILE register accessor: an alias for `Reg<FDCAN_ILE_SPEC>`"]
pub type FDCAN_ILE = crate::Reg<fdcan_ile::FDCAN_ILE_SPEC>;
#[doc = "Each of the two interrupt lines to the CPU can be enabled/disabled separately by programming bits EINT0 and EINT1."]
pub mod fdcan_ile;
#[doc = "FDCAN_GFC register accessor: an alias for `Reg<FDCAN_GFC_SPEC>`"]
pub type FDCAN_GFC = crate::Reg<fdcan_gfc::FDCAN_GFC_SPEC>;
#[doc = "Global settings for message ID filtering. The global filter configuration register controls the filter path for standard and extended messages as described in Figure708: Standard message ID filter path and Figure709: Extended message ID filter path."]
pub mod fdcan_gfc;
#[doc = "FDCAN_SIDFC register accessor: an alias for `Reg<FDCAN_SIDFC_SPEC>`"]
pub type FDCAN_SIDFC = crate::Reg<fdcan_sidfc::FDCAN_SIDFC_SPEC>;
#[doc = "Settings for 11-bit standard message ID filtering.The standard ID filter configuration register controls the filter path for standard messages as described in Figure708."]
pub mod fdcan_sidfc;
#[doc = "FDCAN_XIDFC register accessor: an alias for `Reg<FDCAN_XIDFC_SPEC>`"]
pub type FDCAN_XIDFC = crate::Reg<fdcan_xidfc::FDCAN_XIDFC_SPEC>;
#[doc = "Settings for 29-bit extended message ID filtering. The FDCAN extended ID filter configuration register controls the filter path for standard messages as described in Figure709: Extended message ID filter path."]
pub mod fdcan_xidfc;
#[doc = "FDCAN_XIDAM register accessor: an alias for `Reg<FDCAN_XIDAM_SPEC>`"]
pub type FDCAN_XIDAM = crate::Reg<fdcan_xidam::FDCAN_XIDAM_SPEC>;
#[doc = "FDCAN extended ID and mask register"]
pub mod fdcan_xidam;
#[doc = "FDCAN_HPMS register accessor: an alias for `Reg<FDCAN_HPMS_SPEC>`"]
pub type FDCAN_HPMS = crate::Reg<fdcan_hpms::FDCAN_HPMS_SPEC>;
#[doc = "This register is updated every time a message ID filter element configured to generate a priority event match. This can be used to monitor the status of incoming high priority messages and to enable fast access to these messages."]
pub mod fdcan_hpms;
#[doc = "FDCAN_NDAT1 register accessor: an alias for `Reg<FDCAN_NDAT1_SPEC>`"]
pub type FDCAN_NDAT1 = crate::Reg<fdcan_ndat1::FDCAN_NDAT1_SPEC>;
#[doc = "FDCAN new data 1 register"]
pub mod fdcan_ndat1;
#[doc = "FDCAN_NDAT2 register accessor: an alias for `Reg<FDCAN_NDAT2_SPEC>`"]
pub type FDCAN_NDAT2 = crate::Reg<fdcan_ndat2::FDCAN_NDAT2_SPEC>;
#[doc = "FDCAN new data 2 register"]
pub mod fdcan_ndat2;
#[doc = "FDCAN_RXF0C register accessor: an alias for `Reg<FDCAN_RXF0C_SPEC>`"]
pub type FDCAN_RXF0C = crate::Reg<fdcan_rxf0c::FDCAN_RXF0C_SPEC>;
#[doc = "FDCAN Rx FIFO 0 configuration register"]
pub mod fdcan_rxf0c;
#[doc = "FDCAN_RXF0S register accessor: an alias for `Reg<FDCAN_RXF0S_SPEC>`"]
pub type FDCAN_RXF0S = crate::Reg<fdcan_rxf0s::FDCAN_RXF0S_SPEC>;
#[doc = "FDCAN Rx FIFO 0 status register"]
pub mod fdcan_rxf0s;
#[doc = "FDCAN_RXF0A register accessor: an alias for `Reg<FDCAN_RXF0A_SPEC>`"]
pub type FDCAN_RXF0A = crate::Reg<fdcan_rxf0a::FDCAN_RXF0A_SPEC>;
#[doc = "FDCAN Rx FIFO 0 acknowledge register"]
pub mod fdcan_rxf0a;
#[doc = "FDCAN_RXBC register accessor: an alias for `Reg<FDCAN_RXBC_SPEC>`"]
pub type FDCAN_RXBC = crate::Reg<fdcan_rxbc::FDCAN_RXBC_SPEC>;
#[doc = "FDCAN Rx buffer configuration register"]
pub mod fdcan_rxbc;
#[doc = "FDCAN_RXF1C register accessor: an alias for `Reg<FDCAN_RXF1C_SPEC>`"]
pub type FDCAN_RXF1C = crate::Reg<fdcan_rxf1c::FDCAN_RXF1C_SPEC>;
#[doc = "FDCAN Rx FIFO 1 configuration register"]
pub mod fdcan_rxf1c;
#[doc = "FDCAN_RXF1S register accessor: an alias for `Reg<FDCAN_RXF1S_SPEC>`"]
pub type FDCAN_RXF1S = crate::Reg<fdcan_rxf1s::FDCAN_RXF1S_SPEC>;
#[doc = "FDCAN Rx FIFO 1 status register"]
pub mod fdcan_rxf1s;
#[doc = "FDCAN_RXF1A register accessor: an alias for `Reg<FDCAN_RXF1A_SPEC>`"]
pub type FDCAN_RXF1A = crate::Reg<fdcan_rxf1a::FDCAN_RXF1A_SPEC>;
#[doc = "FDCAN Rx FIFO 1 acknowledge register"]
pub mod fdcan_rxf1a;
#[doc = "FDCAN_RXESC register accessor: an alias for `Reg<FDCAN_RXESC_SPEC>`"]
pub type FDCAN_RXESC = crate::Reg<fdcan_rxesc::FDCAN_RXESC_SPEC>;
#[doc = "Configures the number of data bytes belonging to an Rx buffer / Rx FIFO element. Data field sizes higher than 8 bytes are intended for CAN FD operation only."]
pub mod fdcan_rxesc;
#[doc = "FDCAN_TXBC register accessor: an alias for `Reg<FDCAN_TXBC_SPEC>`"]
pub type FDCAN_TXBC = crate::Reg<fdcan_txbc::FDCAN_TXBC_SPEC>;
#[doc = "FDCAN Tx buffer configuration register"]
pub mod fdcan_txbc;
#[doc = "FDCAN_TXFQS register accessor: an alias for `Reg<FDCAN_TXFQS_SPEC>`"]
pub type FDCAN_TXFQS = crate::Reg<fdcan_txfqs::FDCAN_TXFQS_SPEC>;
#[doc = "The Tx FIFO/queue status is related to the pending Tx requests listed in register FDCAN_TXBRP. Therefore the effect of add/cancellation requests may be delayed due to a running Tx scan (FDCAN_TXBRP not yet updated)."]
pub mod fdcan_txfqs;
#[doc = "FDCAN_TXESC register accessor: an alias for `Reg<FDCAN_TXESC_SPEC>`"]
pub type FDCAN_TXESC = crate::Reg<fdcan_txesc::FDCAN_TXESC_SPEC>;
#[doc = "Configures the number of data bytes belonging to a Tx buffer element. Data field sizes &gt;8 bytes are intended for CAN FD operation only."]
pub mod fdcan_txesc;
#[doc = "FDCAN_TXBAR register accessor: an alias for `Reg<FDCAN_TXBAR_SPEC>`"]
pub type FDCAN_TXBAR = crate::Reg<fdcan_txbar::FDCAN_TXBAR_SPEC>;
#[doc = "FDCAN Tx buffer add request register"]
pub mod fdcan_txbar;
#[doc = "FDCAN_TXBCR register accessor: an alias for `Reg<FDCAN_TXBCR_SPEC>`"]
pub type FDCAN_TXBCR = crate::Reg<fdcan_txbcr::FDCAN_TXBCR_SPEC>;
#[doc = "FDCAN Tx buffer cancellation request register"]
pub mod fdcan_txbcr;
#[doc = "FDCAN_TXBTO register accessor: an alias for `Reg<FDCAN_TXBTO_SPEC>`"]
pub type FDCAN_TXBTO = crate::Reg<fdcan_txbto::FDCAN_TXBTO_SPEC>;
#[doc = "FDCAN Tx buffer transmission occurred register"]
pub mod fdcan_txbto;
#[doc = "FDCAN_TXBCF register accessor: an alias for `Reg<FDCAN_TXBCF_SPEC>`"]
pub type FDCAN_TXBCF = crate::Reg<fdcan_txbcf::FDCAN_TXBCF_SPEC>;
#[doc = "FDCAN Tx buffer cancellation finished register"]
pub mod fdcan_txbcf;
#[doc = "FDCAN_TXBTIE register accessor: an alias for `Reg<FDCAN_TXBTIE_SPEC>`"]
pub type FDCAN_TXBTIE = crate::Reg<fdcan_txbtie::FDCAN_TXBTIE_SPEC>;
#[doc = "FDCAN Tx buffer transmission interrupt enable register"]
pub mod fdcan_txbtie;
#[doc = "FDCAN_TXBCIE register accessor: an alias for `Reg<FDCAN_TXBCIE_SPEC>`"]
pub type FDCAN_TXBCIE = crate::Reg<fdcan_txbcie::FDCAN_TXBCIE_SPEC>;
#[doc = "FDCAN Tx buffer cancellation finished interrupt enable register"]
pub mod fdcan_txbcie;
#[doc = "FDCAN_TXEFC register accessor: an alias for `Reg<FDCAN_TXEFC_SPEC>`"]
pub type FDCAN_TXEFC = crate::Reg<fdcan_txefc::FDCAN_TXEFC_SPEC>;
#[doc = "FDCAN Tx event FIFO configuration register"]
pub mod fdcan_txefc;
#[doc = "FDCAN_TXEFS register accessor: an alias for `Reg<FDCAN_TXEFS_SPEC>`"]
pub type FDCAN_TXEFS = crate::Reg<fdcan_txefs::FDCAN_TXEFS_SPEC>;
#[doc = "FDCAN Tx event FIFO status register"]
pub mod fdcan_txefs;
#[doc = "FDCAN_TXEFA register accessor: an alias for `Reg<FDCAN_TXEFA_SPEC>`"]
pub type FDCAN_TXEFA = crate::Reg<fdcan_txefa::FDCAN_TXEFA_SPEC>;
#[doc = "FDCAN Tx event FIFO acknowledge register"]
pub mod fdcan_txefa;
#[doc = "FDCAN_TTTMC register accessor: an alias for `Reg<FDCAN_TTTMC_SPEC>`"]
pub type FDCAN_TTTMC = crate::Reg<fdcan_tttmc::FDCAN_TTTMC_SPEC>;
#[doc = "FDCAN TT trigger memory configuration register"]
pub mod fdcan_tttmc;
#[doc = "FDCAN_TTRMC register accessor: an alias for `Reg<FDCAN_TTRMC_SPEC>`"]
pub type FDCAN_TTRMC = crate::Reg<fdcan_ttrmc::FDCAN_TTRMC_SPEC>;
#[doc = "FDCAN TT reference message configuration register"]
pub mod fdcan_ttrmc;
#[doc = "FDCAN_TTOCF register accessor: an alias for `Reg<FDCAN_TTOCF_SPEC>`"]
pub type FDCAN_TTOCF = crate::Reg<fdcan_ttocf::FDCAN_TTOCF_SPEC>;
#[doc = "FDCAN TT operation configuration register"]
pub mod fdcan_ttocf;
#[doc = "FDCAN_TTMLM register accessor: an alias for `Reg<FDCAN_TTMLM_SPEC>`"]
pub type FDCAN_TTMLM = crate::Reg<fdcan_ttmlm::FDCAN_TTMLM_SPEC>;
#[doc = "FDCAN TT matrix limits register"]
pub mod fdcan_ttmlm;
#[doc = "FDCAN_TURCF register accessor: an alias for `Reg<FDCAN_TURCF_SPEC>`"]
pub type FDCAN_TURCF = crate::Reg<fdcan_turcf::FDCAN_TURCF_SPEC>;
#[doc = "The length of the NTU is given by: NTU = CAN clock period x NC/DC. NC is an 18-bit value. Its high part, NCH\\[17:16\\]
is hard wired to 0b01. Therefore the range of NC extends from 0x10000 to 0x1FFFF. The value configured by NCL is the initial value for FDCAN_TURNA.NAV\\[15:0\\]. DC is set to 0x1000 by hardware reset and it may not be written to 0x0000. Level 1: NC 4 * DC and NTU = CAN bit time Levels 0 and 2: NC 8 * DC The actual value of FDCAN_TUR may be changed by the clock drift compensation function of TTCAN level 0 and level 2 in order to adjust the node local view of the NTU to the time master view of the NTU. DC will not be changed by the automatic drift compensation, FDCAN_TURNA.NAV may be adjusted around NC in the range of the synchronization deviation limit given by FDCAN_TTOCF.LDSDL. NC and DC should be programmed to the largest suitable values in achieve the best computational accuracy for the drift compensation process."]
pub mod fdcan_turcf;
#[doc = "FDCAN_TTOCN register accessor: an alias for `Reg<FDCAN_TTOCN_SPEC>`"]
pub type FDCAN_TTOCN = crate::Reg<fdcan_ttocn::FDCAN_TTOCN_SPEC>;
#[doc = "FDCAN TT operation control register"]
pub mod fdcan_ttocn;
#[doc = "FDCAN_TTGTP register accessor: an alias for `Reg<FDCAN_TTGTP_SPEC>`"]
pub type FDCAN_TTGTP = crate::Reg<fdcan_ttgtp::FDCAN_TTGTP_SPEC>;
#[doc = "If TTOST.WGDT is set, the next reference message will be transmitted with the Master_Ref_Mark modified by the preset value and with Disc_Bit = 1, presetting the global time in all nodes simultaneously. TP is reset to 0x0000 each time a reference message with Disc_Bit = 1 becomes valid or if the node is not the current time master. TP is locked while FDCAN_TTOST.WGTD = 1 after setting FDCAN_TTOCN.SGT until the reference message with Disc_Bit = 1 becomes valid or until the node is no longer the current time master."]
pub mod fdcan_ttgtp;
#[doc = "FDCAN_TTTMK register accessor: an alias for `Reg<FDCAN_TTTMK_SPEC>`"]
pub type FDCAN_TTTMK = crate::Reg<fdcan_tttmk::FDCAN_TTTMK_SPEC>;
#[doc = "A time mark interrupt (FDCAN_TTIR.TMI = 1) is generated when the time base indicated by FDCAN_TTOCN.TMC (cycle time, local time, or global time) has the same value as TM."]
pub mod fdcan_tttmk;
#[doc = "FDCAN_TTIR register accessor: an alias for `Reg<FDCAN_TTIR_SPEC>`"]
pub type FDCAN_TTIR = crate::Reg<fdcan_ttir::FDCAN_TTIR_SPEC>;
#[doc = "The flags are set when one of the listed conditions is detected (edge-sensitive). The flags remain set until the Host clears them. A flag is cleared by writing a 1 to the corresponding bit position. Writing a 0 has no effect. A hard reset will clear the register."]
pub mod fdcan_ttir;
#[doc = "FDCAN_TTIE register accessor: an alias for `Reg<FDCAN_TTIE_SPEC>`"]
pub type FDCAN_TTIE = crate::Reg<fdcan_ttie::FDCAN_TTIE_SPEC>;
#[doc = "The settings in the TT interrupt enable register determine which status changes in the TT interrupt register will result in an interrupt."]
pub mod fdcan_ttie;
#[doc = "FDCAN_TTILS register accessor: an alias for `Reg<FDCAN_TTILS_SPEC>`"]
pub type FDCAN_TTILS = crate::Reg<fdcan_ttils::FDCAN_TTILS_SPEC>;
#[doc = "The TT interrupt Line select register assigns an interrupt generated by a specific interrupt flag from the TT interrupt register to one of the two module interrupt lines. For interrupt generation the respective interrupt line has to be enabled via FDCAN_ILE.EINT0 and FDCAN_ILE.EINT1."]
pub mod fdcan_ttils;
#[doc = "FDCAN_TTOST register accessor: an alias for `Reg<FDCAN_TTOST_SPEC>`"]
pub type FDCAN_TTOST = crate::Reg<fdcan_ttost::FDCAN_TTOST_SPEC>;
#[doc = "FDCAN TT operation status register"]
pub mod fdcan_ttost;
#[doc = "FDCAN_TURNA register accessor: an alias for `Reg<FDCAN_TURNA_SPEC>`"]
pub type FDCAN_TURNA = crate::Reg<fdcan_turna::FDCAN_TURNA_SPEC>;
#[doc = "There is no drift compensation in TTCAN level 1."]
pub mod fdcan_turna;
#[doc = "FDCAN_TTLGT register accessor: an alias for `Reg<FDCAN_TTLGT_SPEC>`"]
pub type FDCAN_TTLGT = crate::Reg<fdcan_ttlgt::FDCAN_TTLGT_SPEC>;
#[doc = "FDCAN TT local and global time register"]
pub mod fdcan_ttlgt;
#[doc = "FDCAN_TTCTC register accessor: an alias for `Reg<FDCAN_TTCTC_SPEC>`"]
pub type FDCAN_TTCTC = crate::Reg<fdcan_ttctc::FDCAN_TTCTC_SPEC>;
#[doc = "FDCAN TT cycle time and count register"]
pub mod fdcan_ttctc;
#[doc = "FDCAN_TTCPT register accessor: an alias for `Reg<FDCAN_TTCPT_SPEC>`"]
pub type FDCAN_TTCPT = crate::Reg<fdcan_ttcpt::FDCAN_TTCPT_SPEC>;
#[doc = "FDCAN TT capture time register"]
pub mod fdcan_ttcpt;
#[doc = "FDCAN_TTCSM register accessor: an alias for `Reg<FDCAN_TTCSM_SPEC>`"]
pub type FDCAN_TTCSM = crate::Reg<fdcan_ttcsm::FDCAN_TTCSM_SPEC>;
#[doc = "FDCAN TT cycle sync mark register"]
pub mod fdcan_ttcsm;
#[doc = "FDCAN_TTTS register accessor: an alias for `Reg<FDCAN_TTTS_SPEC>`"]
pub type FDCAN_TTTS = crate::Reg<fdcan_ttts::FDCAN_TTTS_SPEC>;
#[doc = "The settings in the FDCAN_TTTS register select the input to be used as event trigger and stop watch trigger."]
pub mod fdcan_ttts;
