#[doc = "Register `DAC_CCR` reader"]
pub struct R(crate::R<DAC_CCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DAC_CCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DAC_CCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DAC_CCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DAC_CCR` writer"]
pub struct W(crate::W<DAC_CCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DAC_CCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DAC_CCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DAC_CCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `OTRIM1` reader - OTRIM1"]
pub struct OTRIM1_R(crate::FieldReader<u8, u8>);
impl OTRIM1_R {
    pub(crate) fn new(bits: u8) -> Self {
        OTRIM1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OTRIM1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OTRIM1` writer - OTRIM1"]
pub struct OTRIM1_W<'a> {
    w: &'a mut W,
}
impl<'a> OTRIM1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u32 & 0x1f);
        self.w
    }
}
#[doc = "Field `OTRIM2` reader - OTRIM2"]
pub struct OTRIM2_R(crate::FieldReader<u8, u8>);
impl OTRIM2_R {
    pub(crate) fn new(bits: u8) -> Self {
        OTRIM2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OTRIM2_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OTRIM2` writer - OTRIM2"]
pub struct OTRIM2_W<'a> {
    w: &'a mut W,
}
impl<'a> OTRIM2_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 16)) | ((value as u32 & 0x1f) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:4 - OTRIM1"]
    #[inline(always)]
    pub fn otrim1(&self) -> OTRIM1_R {
        OTRIM1_R::new((self.bits & 0x1f) as u8)
    }
    #[doc = "Bits 16:20 - OTRIM2"]
    #[inline(always)]
    pub fn otrim2(&self) -> OTRIM2_R {
        OTRIM2_R::new(((self.bits >> 16) & 0x1f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:4 - OTRIM1"]
    #[inline(always)]
    pub fn otrim1(&mut self) -> OTRIM1_W {
        OTRIM1_W { w: self }
    }
    #[doc = "Bits 16:20 - OTRIM2"]
    #[inline(always)]
    pub fn otrim2(&mut self) -> OTRIM2_W {
        OTRIM2_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "DAC calibration control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dac_ccr](index.html) module"]
pub struct DAC_CCR_SPEC;
impl crate::RegisterSpec for DAC_CCR_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [dac_ccr::R](R) reader structure"]
impl crate::Readable for DAC_CCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [dac_ccr::W](W) writer structure"]
impl crate::Writable for DAC_CCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DAC_CCR to value 0"]
impl crate::Resettable for DAC_CCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
