#![deny(unused_allocation)]
#![deny(unused_comparisons)]
extern crate cortex_m;
#[cfg(feature = "rt")]
extern crate cortex_m_rt;
extern crate vcell;
use core::marker::PhantomData;
use core::ops::Deref;
///Number available in the NVIC for configuring priority
pub const NVIC_PRIO_BITS: u8 = 4;
#[cfg(feature = "rt")]
extern "C" {
    fn WWDG();
    fn PVD();
    fn TAMP_STAMP();
    fn RTC_WKUP();
    fn FLASH();
    fn RCC();
    fn EXTI0();
    fn EXTI1();
    fn EXTI2();
    fn EXTI3();
    fn EXTI4();
    fn DMA1_CH1();
    fn DMA1_CH2();
    fn DMA1_CH3();
    fn DMA1_CH4();
    fn DMA1_CH5();
    fn DMA1_CH6();
    fn DMA1_CH7();
    fn ADC1_2();
    fn CAN1_TX();
    fn CAN1_RX0();
    fn CAN1_RX1();
    fn CAN1_SCE();
    fn EXTI9_5();
    fn TIM15();
    fn TIM16();
    fn TIM1_CC();
    fn TIM2();
    fn I2C1_EV();
    fn I2C1_ER();
    fn I2C2_EV();
    fn I2C2_ER();
    fn SPI1();
    fn SPI2();
    fn USART1();
    fn USART2();
    fn USART3();
    fn EXTI15_10();
    fn RTC_ALARM();
    fn SDMMC();
    fn SPI3();
    fn TIM6_DAC();
    fn TIM7();
    fn DMA2_CH1();
    fn DMA2_CH2();
    fn DMA2_CH3();
    fn DMA2_CH4();
    fn DMA2_CH5();
    fn COMP();
    fn LPTIM1();
    fn LPTIM2();
    fn USB_FS();
    fn DMA2_CH6();
    fn DMA2_CH7();
    fn I2C3_EV();
    fn I2C3_ER();
    fn SAI1();
    fn SWPMI1();
    fn TSC();
    fn LCD();
    fn RNG();
    fn CRS();
    fn FPU();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 82] = [
    Vector { _handler: WWDG },
    Vector { _handler: PVD },
    Vector {
        _handler: TAMP_STAMP,
    },
    Vector { _handler: RTC_WKUP },
    Vector { _handler: FLASH },
    Vector { _handler: RCC },
    Vector { _handler: EXTI0 },
    Vector { _handler: EXTI1 },
    Vector { _handler: EXTI2 },
    Vector { _handler: EXTI3 },
    Vector { _handler: EXTI4 },
    Vector { _handler: DMA1_CH1 },
    Vector { _handler: DMA1_CH2 },
    Vector { _handler: DMA1_CH3 },
    Vector { _handler: DMA1_CH4 },
    Vector { _handler: DMA1_CH5 },
    Vector { _handler: DMA1_CH6 },
    Vector { _handler: DMA1_CH7 },
    Vector { _handler: ADC1_2 },
    Vector { _handler: CAN1_TX },
    Vector { _handler: CAN1_RX0 },
    Vector { _handler: CAN1_RX1 },
    Vector { _handler: CAN1_SCE },
    Vector { _handler: EXTI9_5 },
    Vector { _handler: TIM15 },
    Vector { _handler: TIM16 },
    Vector { _reserved: 0 },
    Vector { _handler: TIM1_CC },
    Vector { _handler: TIM2 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: I2C1_EV },
    Vector { _handler: I2C1_ER },
    Vector { _handler: I2C2_EV },
    Vector { _handler: I2C2_ER },
    Vector { _handler: SPI1 },
    Vector { _handler: SPI2 },
    Vector { _handler: USART1 },
    Vector { _handler: USART2 },
    Vector { _handler: USART3 },
    Vector {
        _handler: EXTI15_10,
    },
    Vector {
        _handler: RTC_ALARM,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: SDMMC },
    Vector { _reserved: 0 },
    Vector { _handler: SPI3 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: TIM6_DAC },
    Vector { _handler: TIM7 },
    Vector { _handler: DMA2_CH1 },
    Vector { _handler: DMA2_CH2 },
    Vector { _handler: DMA2_CH3 },
    Vector { _handler: DMA2_CH4 },
    Vector { _handler: DMA2_CH5 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: COMP },
    Vector { _handler: LPTIM1 },
    Vector { _handler: LPTIM2 },
    Vector { _handler: USB_FS },
    Vector { _handler: DMA2_CH6 },
    Vector { _handler: DMA2_CH7 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: I2C3_EV },
    Vector { _handler: I2C3_ER },
    Vector { _handler: SAI1 },
    Vector { _reserved: 0 },
    Vector { _handler: SWPMI1 },
    Vector { _handler: TSC },
    Vector { _handler: LCD },
    Vector { _handler: RNG },
    Vector { _handler: CRS },
    Vector { _handler: FPU },
];
///Enumeration of all the interrupts
#[derive(Copy, Clone, Debug)]
#[repr(u8)]
pub enum Interrupt {
    ///0 - Window Watchdog interrupt
    WWDG = 0,
    ///1 - PVD through EXTI line detection
    PVD = 1,
    ///2 - Tamper and TimeStamp interrupts
    TAMP_STAMP = 2,
    ///3 - RTC Tamper or TimeStamp /CSS on LSE through EXTI line 19 interrupts
    RTC_WKUP = 3,
    ///4 - Flash global interrupt
    FLASH = 4,
    ///5 - RCC global interrupt
    RCC = 5,
    ///6 - EXTI Line 0 interrupt
    EXTI0 = 6,
    ///7 - EXTI Line 1 interrupt
    EXTI1 = 7,
    ///8 - EXTI Line 2 interrupt
    EXTI2 = 8,
    ///9 - EXTI Line 3 interrupt
    EXTI3 = 9,
    ///10 - EXTI Line4 interrupt
    EXTI4 = 10,
    ///11 - DMA1 Channel1 global interrupt
    DMA1_CH1 = 11,
    ///12 - DMA1 Channel2 global interrupt
    DMA1_CH2 = 12,
    ///13 - DMA1 Channel3 interrupt
    DMA1_CH3 = 13,
    ///14 - DMA1 Channel4 interrupt
    DMA1_CH4 = 14,
    ///15 - DMA1 Channel5 interrupt
    DMA1_CH5 = 15,
    ///16 - DMA1 Channel6 interrupt
    DMA1_CH6 = 16,
    ///17 - DMA1 Channel 7 interrupt
    DMA1_CH7 = 17,
    ///18 - ADC1 and ADC2 global interrupt
    ADC1_2 = 18,
    ///19 - CAN1 TX interrupts
    CAN1_TX = 19,
    ///20 - CAN1 RX0 interrupts
    CAN1_RX0 = 20,
    ///21 - CAN1 RX1 interrupts
    CAN1_RX1 = 21,
    ///22 - CAN1 SCE interrupt
    CAN1_SCE = 22,
    ///23 - EXTI Line5 to Line9 interrupts
    EXTI9_5 = 23,
    ///24 - Timer 15 global interrupt
    TIM15 = 24,
    ///25 - Timer 16 global interrupt
    TIM16 = 25,
    ///27 - TIM1 Capture Compare interrupt
    TIM1_CC = 27,
    ///28 - TIM2 global interrupt
    TIM2 = 28,
    ///31 - I2C1 event interrupt
    I2C1_EV = 31,
    ///32 - I2C1 error interrupt
    I2C1_ER = 32,
    ///33 - I2C2 event interrupt
    I2C2_EV = 33,
    ///34 - I2C2 error interrupt
    I2C2_ER = 34,
    ///35 - SPI1 global interrupt
    SPI1 = 35,
    ///36 - SPI2 global interrupt
    SPI2 = 36,
    ///37 - USART1 global interrupt
    USART1 = 37,
    ///38 - USART2 global interrupt
    USART2 = 38,
    ///39 - USART3 global interrupt
    USART3 = 39,
    ///40 - EXTI Lines 10 to 15 interrupts
    EXTI15_10 = 40,
    ///41 - RTC alarms through EXTI line 18 interrupts
    RTC_ALARM = 41,
    ///49 - SDMMC global Interrupt
    SDMMC = 49,
    ///51 - SPI3 global Interrupt
    SPI3 = 51,
    ///54 - TIM6 global and DAC1 and 2 underrun error interrupts
    TIM6_DAC = 54,
    ///55 - TIM7 global interrupt
    TIM7 = 55,
    ///56 - DMA2 Channel 1 global Interrupt
    DMA2_CH1 = 56,
    ///57 - DMA2 Channel 2 global Interrupt
    DMA2_CH2 = 57,
    ///58 - DMA2 Channel 3 global Interrupt
    DMA2_CH3 = 58,
    ///59 - DMA2 Channel 4 global Interrupt
    DMA2_CH4 = 59,
    ///60 - DMA2 Channel 5 global Interrupt
    DMA2_CH5 = 60,
    ///64 - COMP1 and COMP2 interrupts
    COMP = 64,
    ///65 - LP TIM1 interrupt
    LPTIM1 = 65,
    ///66 - LP TIM2 interrupt
    LPTIM2 = 66,
    ///67 - USB event interrupt through EXTI
    USB_FS = 67,
    ///68 - DMA2 Channel 6 global Interrupt
    DMA2_CH6 = 68,
    ///69 - DMA2 Channel 7 global Interrupt
    DMA2_CH7 = 69,
    ///72 - I2C3 event interrupt
    I2C3_EV = 72,
    ///73 - I2C3 error interrupt
    I2C3_ER = 73,
    ///74 - SAI1 global interrupt
    SAI1 = 74,
    ///76 - SWPMI1 global interrupt
    SWPMI1 = 76,
    ///77 - TSC global interrupt
    TSC = 77,
    ///78 - LCD global interrupt
    LCD = 78,
    ///79 - RNG global interrupt
    RNG = 79,
    ///80 - CRS global interrupt
    CRS = 80,
    ///81 - Floating point interrupt
    FPU = 81,
}
unsafe impl bare_metal::Nr for Interrupt {
    #[inline(always)]
    fn nr(&self) -> u8 {
        *self as u8
    }
}
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
///Digital-to-analog converter
pub struct DAC1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DAC1 {}
impl DAC1 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dac1::RegisterBlock {
        0x4000_7400 as *const _
    }
}
impl Deref for DAC1 {
    type Target = dac1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DAC1::ptr() }
    }
}
///Digital-to-analog converter
pub mod dac1 {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - control register
        pub cr: CR,
        ///0x04 - software trigger register
        pub swtrigr: SWTRIGR,
        ///0x08 - channel1 12-bit right-aligned data holding register
        pub dhr12r1: DHR12R1,
        ///0x0c - channel1 12-bit left-aligned data holding register
        pub dhr12l1: DHR12L1,
        ///0x10 - channel1 8-bit right-aligned data holding register
        pub dhr8r1: DHR8R1,
        ///0x14 - channel2 12-bit right aligned data holding register
        pub dhr12r2: DHR12R2,
        ///0x18 - channel2 12-bit left aligned data holding register
        pub dhr12l2: DHR12L2,
        ///0x1c - channel2 8-bit right-aligned data holding register
        pub dhr8r2: DHR8R2,
        ///0x20 - Dual DAC 12-bit right-aligned data holding register
        pub dhr12rd: DHR12RD,
        ///0x24 - DUAL DAC 12-bit left aligned data holding register
        pub dhr12ld: DHR12LD,
        ///0x28 - DUAL DAC 8-bit right aligned data holding register
        pub dhr8rd: DHR8RD,
        ///0x2c - channel1 data output register
        pub dor1: DOR1,
        ///0x30 - channel2 data output register
        pub dor2: DOR2,
        ///0x34 - status register
        pub sr: SR,
        ///0x38 - calibration control register
        pub ccr: CCR,
        ///0x3c - mode control register
        pub mcr: MCR,
        ///0x40 - Sample and Hold sample time register 1
        pub shsr1: SHSR1,
        ///0x44 - Sample and Hold sample time register 2
        pub shsr2: SHSR2,
        ///0x48 - Sample and Hold hold time register
        pub shhr: SHHR,
        ///0x4c - Sample and Hold refresh time register
        pub shrr: SHRR,
    }
    ///control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `EN1`
        pub type EN1_R = crate::R<bool, bool>;
        ///Write proxy for field `EN1`
        pub struct EN1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `TEN1`
        pub type TEN1_R = crate::R<bool, bool>;
        ///Write proxy for field `TEN1`
        pub struct TEN1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEN1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TSEL1`
        pub type TSEL1_R = crate::R<u8, u8>;
        ///Write proxy for field `TSEL1`
        pub struct TSEL1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSEL1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 3)) | (((value as u32) & 0x07) << 3);
                self.w
            }
        }
        ///Reader of field `WAVE1`
        pub type WAVE1_R = crate::R<u8, u8>;
        ///Write proxy for field `WAVE1`
        pub struct WAVE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WAVE1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 6)) | (((value as u32) & 0x03) << 6);
                self.w
            }
        }
        ///Reader of field `MAMP1`
        pub type MAMP1_R = crate::R<u8, u8>;
        ///Write proxy for field `MAMP1`
        pub struct MAMP1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MAMP1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 8)) | (((value as u32) & 0x0f) << 8);
                self.w
            }
        }
        ///Reader of field `DMAEN1`
        pub type DMAEN1_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAEN1`
        pub struct DMAEN1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAEN1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `DMAUDRIE1`
        pub type DMAUDRIE1_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAUDRIE1`
        pub struct DMAUDRIE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAUDRIE1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `CEN1`
        pub type CEN1_R = crate::R<bool, bool>;
        ///Write proxy for field `CEN1`
        pub struct CEN1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CEN1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `EN2`
        pub type EN2_R = crate::R<bool, bool>;
        ///Write proxy for field `EN2`
        pub struct EN2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `TEN2`
        pub type TEN2_R = crate::R<bool, bool>;
        ///Write proxy for field `TEN2`
        pub struct TEN2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEN2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `TSEL2`
        pub type TSEL2_R = crate::R<u8, u8>;
        ///Write proxy for field `TSEL2`
        pub struct TSEL2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSEL2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 19)) | (((value as u32) & 0x07) << 19);
                self.w
            }
        }
        ///Reader of field `WAVE2`
        pub type WAVE2_R = crate::R<u8, u8>;
        ///Write proxy for field `WAVE2`
        pub struct WAVE2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WAVE2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 22)) | (((value as u32) & 0x03) << 22);
                self.w
            }
        }
        ///Reader of field `MAMP2`
        pub type MAMP2_R = crate::R<u8, u8>;
        ///Write proxy for field `MAMP2`
        pub struct MAMP2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MAMP2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 24)) | (((value as u32) & 0x0f) << 24);
                self.w
            }
        }
        ///Reader of field `DMAEN2`
        pub type DMAEN2_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAEN2`
        pub struct DMAEN2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAEN2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `DMAUDRIE2`
        pub type DMAUDRIE2_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAUDRIE2`
        pub struct DMAUDRIE2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAUDRIE2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `CEN2`
        pub type CEN2_R = crate::R<bool, bool>;
        ///Write proxy for field `CEN2`
        pub struct CEN2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CEN2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        impl R {
            ///Bit 0 - DAC channel1 enable
            #[inline(always)]
            pub fn en1(&self) -> EN1_R {
                EN1_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 2 - DAC channel1 trigger enable
            #[inline(always)]
            pub fn ten1(&self) -> TEN1_R {
                TEN1_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bits 3:5 - DAC channel1 trigger selection
            #[inline(always)]
            pub fn tsel1(&self) -> TSEL1_R {
                TSEL1_R::new(((self.bits >> 3) & 0x07) as u8)
            }
            ///Bits 6:7 - DAC channel1 noise/triangle wave generation enable
            #[inline(always)]
            pub fn wave1(&self) -> WAVE1_R {
                WAVE1_R::new(((self.bits >> 6) & 0x03) as u8)
            }
            ///Bits 8:11 - DAC channel1 mask/amplitude selector
            #[inline(always)]
            pub fn mamp1(&self) -> MAMP1_R {
                MAMP1_R::new(((self.bits >> 8) & 0x0f) as u8)
            }
            ///Bit 12 - DAC channel1 DMA enable
            #[inline(always)]
            pub fn dmaen1(&self) -> DMAEN1_R {
                DMAEN1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 13 - DAC channel1 DMA Underrun Interrupt enable
            #[inline(always)]
            pub fn dmaudrie1(&self) -> DMAUDRIE1_R {
                DMAUDRIE1_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 14 - DAC Channel 1 calibration enable
            #[inline(always)]
            pub fn cen1(&self) -> CEN1_R {
                CEN1_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 16 - DAC channel2 enable
            #[inline(always)]
            pub fn en2(&self) -> EN2_R {
                EN2_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 18 - DAC channel2 trigger enable
            #[inline(always)]
            pub fn ten2(&self) -> TEN2_R {
                TEN2_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bits 19:21 - DAC channel2 trigger selection
            #[inline(always)]
            pub fn tsel2(&self) -> TSEL2_R {
                TSEL2_R::new(((self.bits >> 19) & 0x07) as u8)
            }
            ///Bits 22:23 - DAC channel2 noise/triangle wave generation enable
            #[inline(always)]
            pub fn wave2(&self) -> WAVE2_R {
                WAVE2_R::new(((self.bits >> 22) & 0x03) as u8)
            }
            ///Bits 24:27 - DAC channel2 mask/amplitude selector
            #[inline(always)]
            pub fn mamp2(&self) -> MAMP2_R {
                MAMP2_R::new(((self.bits >> 24) & 0x0f) as u8)
            }
            ///Bit 28 - DAC channel2 DMA enable
            #[inline(always)]
            pub fn dmaen2(&self) -> DMAEN2_R {
                DMAEN2_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 29 - DAC channel2 DMA underrun interrupt enable
            #[inline(always)]
            pub fn dmaudrie2(&self) -> DMAUDRIE2_R {
                DMAUDRIE2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 30 - DAC Channel 2 calibration enable
            #[inline(always)]
            pub fn cen2(&self) -> CEN2_R {
                CEN2_R::new(((self.bits >> 30) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 0 - DAC channel1 enable
            #[inline(always)]
            pub fn en1(&mut self) -> EN1_W {
                EN1_W { w: self }
            }
            ///Bit 2 - DAC channel1 trigger enable
            #[inline(always)]
            pub fn ten1(&mut self) -> TEN1_W {
                TEN1_W { w: self }
            }
            ///Bits 3:5 - DAC channel1 trigger selection
            #[inline(always)]
            pub fn tsel1(&mut self) -> TSEL1_W {
                TSEL1_W { w: self }
            }
            ///Bits 6:7 - DAC channel1 noise/triangle wave generation enable
            #[inline(always)]
            pub fn wave1(&mut self) -> WAVE1_W {
                WAVE1_W { w: self }
            }
            ///Bits 8:11 - DAC channel1 mask/amplitude selector
            #[inline(always)]
            pub fn mamp1(&mut self) -> MAMP1_W {
                MAMP1_W { w: self }
            }
            ///Bit 12 - DAC channel1 DMA enable
            #[inline(always)]
            pub fn dmaen1(&mut self) -> DMAEN1_W {
                DMAEN1_W { w: self }
            }
            ///Bit 13 - DAC channel1 DMA Underrun Interrupt enable
            #[inline(always)]
            pub fn dmaudrie1(&mut self) -> DMAUDRIE1_W {
                DMAUDRIE1_W { w: self }
            }
            ///Bit 14 - DAC Channel 1 calibration enable
            #[inline(always)]
            pub fn cen1(&mut self) -> CEN1_W {
                CEN1_W { w: self }
            }
            ///Bit 16 - DAC channel2 enable
            #[inline(always)]
            pub fn en2(&mut self) -> EN2_W {
                EN2_W { w: self }
            }
            ///Bit 18 - DAC channel2 trigger enable
            #[inline(always)]
            pub fn ten2(&mut self) -> TEN2_W {
                TEN2_W { w: self }
            }
            ///Bits 19:21 - DAC channel2 trigger selection
            #[inline(always)]
            pub fn tsel2(&mut self) -> TSEL2_W {
                TSEL2_W { w: self }
            }
            ///Bits 22:23 - DAC channel2 noise/triangle wave generation enable
            #[inline(always)]
            pub fn wave2(&mut self) -> WAVE2_W {
                WAVE2_W { w: self }
            }
            ///Bits 24:27 - DAC channel2 mask/amplitude selector
            #[inline(always)]
            pub fn mamp2(&mut self) -> MAMP2_W {
                MAMP2_W { w: self }
            }
            ///Bit 28 - DAC channel2 DMA enable
            #[inline(always)]
            pub fn dmaen2(&mut self) -> DMAEN2_W {
                DMAEN2_W { w: self }
            }
            ///Bit 29 - DAC channel2 DMA underrun interrupt enable
            #[inline(always)]
            pub fn dmaudrie2(&mut self) -> DMAUDRIE2_W {
                DMAUDRIE2_W { w: self }
            }
            ///Bit 30 - DAC Channel 2 calibration enable
            #[inline(always)]
            pub fn cen2(&mut self) -> CEN2_W {
                CEN2_W { w: self }
            }
        }
    }
    ///software trigger register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [swtrigr](swtrigr) module
    pub type SWTRIGR = crate::Reg<u32, _SWTRIGR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SWTRIGR;
    ///`write(|w| ..)` method takes [swtrigr::W](swtrigr::W) writer structure
    impl crate::Writable for SWTRIGR {}
    ///software trigger register
    pub mod swtrigr {
        ///Writer for register SWTRIGR
        pub type W = crate::W<u32, super::SWTRIGR>;
        ///Register SWTRIGR `reset()`'s with value 0
        impl crate::ResetValue for super::SWTRIGR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `SWTRIG1`
        pub struct SWTRIG1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SWTRIG1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Write proxy for field `SWTRIG2`
        pub struct SWTRIG2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SWTRIG2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        impl W {
            ///Bit 0 - DAC channel1 software trigger
            #[inline(always)]
            pub fn swtrig1(&mut self) -> SWTRIG1_W {
                SWTRIG1_W { w: self }
            }
            ///Bit 1 - DAC channel2 software trigger
            #[inline(always)]
            pub fn swtrig2(&mut self) -> SWTRIG2_W {
                SWTRIG2_W { w: self }
            }
        }
    }
    ///channel1 12-bit right-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12r1](dhr12r1) module
    pub type DHR12R1 = crate::Reg<u32, _DHR12R1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12R1;
    ///`read()` method returns [dhr12r1::R](dhr12r1::R) reader structure
    impl crate::Readable for DHR12R1 {}
    ///`write(|w| ..)` method takes [dhr12r1::W](dhr12r1::W) writer structure
    impl crate::Writable for DHR12R1 {}
    ///channel1 12-bit right-aligned data holding register
    pub mod dhr12r1 {
        ///Reader of register DHR12R1
        pub type R = crate::R<u32, super::DHR12R1>;
        ///Writer for register DHR12R1
        pub type W = crate::W<u32, super::DHR12R1>;
        ///Register DHR12R1 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12R1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - DAC channel1 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new((self.bits & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - DAC channel1 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
        }
    }
    ///channel1 12-bit left-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12l1](dhr12l1) module
    pub type DHR12L1 = crate::Reg<u32, _DHR12L1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12L1;
    ///`read()` method returns [dhr12l1::R](dhr12l1::R) reader structure
    impl crate::Readable for DHR12L1 {}
    ///`write(|w| ..)` method takes [dhr12l1::W](dhr12l1::W) writer structure
    impl crate::Writable for DHR12L1 {}
    ///channel1 12-bit left-aligned data holding register
    pub mod dhr12l1 {
        ///Reader of register DHR12L1
        pub type R = crate::R<u32, super::DHR12L1>;
        ///Writer for register DHR12L1
        pub type W = crate::W<u32, super::DHR12L1>;
        ///Register DHR12L1 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12L1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 4)) | (((value as u32) & 0x0fff) << 4);
                self.w
            }
        }
        impl R {
            ///Bits 4:15 - DAC channel1 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new(((self.bits >> 4) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 4:15 - DAC channel1 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
        }
    }
    ///channel1 8-bit right-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr8r1](dhr8r1) module
    pub type DHR8R1 = crate::Reg<u32, _DHR8R1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR8R1;
    ///`read()` method returns [dhr8r1::R](dhr8r1::R) reader structure
    impl crate::Readable for DHR8R1 {}
    ///`write(|w| ..)` method takes [dhr8r1::W](dhr8r1::W) writer structure
    impl crate::Writable for DHR8R1 {}
    ///channel1 8-bit right-aligned data holding register
    pub mod dhr8r1 {
        ///Reader of register DHR8R1
        pub type R = crate::R<u32, super::DHR8R1>;
        ///Writer for register DHR8R1
        pub type W = crate::W<u32, super::DHR8R1>;
        ///Register DHR8R1 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR8R1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u8, u8>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - DAC channel1 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - DAC channel1 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
        }
    }
    ///channel2 12-bit right aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12r2](dhr12r2) module
    pub type DHR12R2 = crate::Reg<u32, _DHR12R2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12R2;
    ///`read()` method returns [dhr12r2::R](dhr12r2::R) reader structure
    impl crate::Readable for DHR12R2 {}
    ///`write(|w| ..)` method takes [dhr12r2::W](dhr12r2::W) writer structure
    impl crate::Writable for DHR12R2 {}
    ///channel2 12-bit right aligned data holding register
    pub mod dhr12r2 {
        ///Reader of register DHR12R2
        pub type R = crate::R<u32, super::DHR12R2>;
        ///Writer for register DHR12R2
        pub type W = crate::W<u32, super::DHR12R2>;
        ///Register DHR12R2 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12R2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - DAC channel2 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new((self.bits & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - DAC channel2 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///channel2 12-bit left aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12l2](dhr12l2) module
    pub type DHR12L2 = crate::Reg<u32, _DHR12L2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12L2;
    ///`read()` method returns [dhr12l2::R](dhr12l2::R) reader structure
    impl crate::Readable for DHR12L2 {}
    ///`write(|w| ..)` method takes [dhr12l2::W](dhr12l2::W) writer structure
    impl crate::Writable for DHR12L2 {}
    ///channel2 12-bit left aligned data holding register
    pub mod dhr12l2 {
        ///Reader of register DHR12L2
        pub type R = crate::R<u32, super::DHR12L2>;
        ///Writer for register DHR12L2
        pub type W = crate::W<u32, super::DHR12L2>;
        ///Register DHR12L2 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12L2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 4)) | (((value as u32) & 0x0fff) << 4);
                self.w
            }
        }
        impl R {
            ///Bits 4:15 - DAC channel2 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new(((self.bits >> 4) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 4:15 - DAC channel2 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///channel2 8-bit right-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr8r2](dhr8r2) module
    pub type DHR8R2 = crate::Reg<u32, _DHR8R2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR8R2;
    ///`read()` method returns [dhr8r2::R](dhr8r2::R) reader structure
    impl crate::Readable for DHR8R2 {}
    ///`write(|w| ..)` method takes [dhr8r2::W](dhr8r2::W) writer structure
    impl crate::Writable for DHR8R2 {}
    ///channel2 8-bit right-aligned data holding register
    pub mod dhr8r2 {
        ///Reader of register DHR8R2
        pub type R = crate::R<u32, super::DHR8R2>;
        ///Writer for register DHR8R2
        pub type W = crate::W<u32, super::DHR8R2>;
        ///Register DHR8R2 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR8R2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u8, u8>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - DAC channel2 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - DAC channel2 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///Dual DAC 12-bit right-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12rd](dhr12rd) module
    pub type DHR12RD = crate::Reg<u32, _DHR12RD>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12RD;
    ///`read()` method returns [dhr12rd::R](dhr12rd::R) reader structure
    impl crate::Readable for DHR12RD {}
    ///`write(|w| ..)` method takes [dhr12rd::W](dhr12rd::W) writer structure
    impl crate::Writable for DHR12RD {}
    ///Dual DAC 12-bit right-aligned data holding register
    pub mod dhr12rd {
        ///Reader of register DHR12RD
        pub type R = crate::R<u32, super::DHR12RD>;
        ///Writer for register DHR12RD
        pub type W = crate::W<u32, super::DHR12RD>;
        ///Register DHR12RD `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12RD {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 16)) | (((value as u32) & 0x0fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - DAC channel1 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new((self.bits & 0x0fff) as u16)
            }
            ///Bits 16:27 - DAC channel2 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new(((self.bits >> 16) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - DAC channel1 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
            ///Bits 16:27 - DAC channel2 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///DUAL DAC 12-bit left aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12ld](dhr12ld) module
    pub type DHR12LD = crate::Reg<u32, _DHR12LD>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12LD;
    ///`read()` method returns [dhr12ld::R](dhr12ld::R) reader structure
    impl crate::Readable for DHR12LD {}
    ///`write(|w| ..)` method takes [dhr12ld::W](dhr12ld::W) writer structure
    impl crate::Writable for DHR12LD {}
    ///DUAL DAC 12-bit left aligned data holding register
    pub mod dhr12ld {
        ///Reader of register DHR12LD
        pub type R = crate::R<u32, super::DHR12LD>;
        ///Writer for register DHR12LD
        pub type W = crate::W<u32, super::DHR12LD>;
        ///Register DHR12LD `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12LD {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 4)) | (((value as u32) & 0x0fff) << 4);
                self.w
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 20)) | (((value as u32) & 0x0fff) << 20);
                self.w
            }
        }
        impl R {
            ///Bits 4:15 - DAC channel1 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new(((self.bits >> 4) & 0x0fff) as u16)
            }
            ///Bits 20:31 - DAC channel2 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new(((self.bits >> 20) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 4:15 - DAC channel1 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
            ///Bits 20:31 - DAC channel2 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///DUAL DAC 8-bit right aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr8rd](dhr8rd) module
    pub type DHR8RD = crate::Reg<u32, _DHR8RD>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR8RD;
    ///`read()` method returns [dhr8rd::R](dhr8rd::R) reader structure
    impl crate::Readable for DHR8RD {}
    ///`write(|w| ..)` method takes [dhr8rd::W](dhr8rd::W) writer structure
    impl crate::Writable for DHR8RD {}
    ///DUAL DAC 8-bit right aligned data holding register
    pub mod dhr8rd {
        ///Reader of register DHR8RD
        pub type R = crate::R<u32, super::DHR8RD>;
        ///Writer for register DHR8RD
        pub type W = crate::W<u32, super::DHR8RD>;
        ///Register DHR8RD `reset()`'s with value 0
        impl crate::ResetValue for super::DHR8RD {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u8, u8>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u8, u8>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - DAC channel1 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 8:15 - DAC channel2 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new(((self.bits >> 8) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - DAC channel1 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
            ///Bits 8:15 - DAC channel2 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///channel1 data output register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dor1](dor1) module
    pub type DOR1 = crate::Reg<u32, _DOR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DOR1;
    ///`read()` method returns [dor1::R](dor1::R) reader structure
    impl crate::Readable for DOR1 {}
    ///channel1 data output register
    pub mod dor1 {
        ///Reader of register DOR1
        pub type R = crate::R<u32, super::DOR1>;
        ///Reader of field `DACC1DOR`
        pub type DACC1DOR_R = crate::R<u16, u16>;
        impl R {
            ///Bits 0:11 - DAC channel1 data output
            #[inline(always)]
            pub fn dacc1dor(&self) -> DACC1DOR_R {
                DACC1DOR_R::new((self.bits & 0x0fff) as u16)
            }
        }
    }
    ///channel2 data output register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dor2](dor2) module
    pub type DOR2 = crate::Reg<u32, _DOR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DOR2;
    ///`read()` method returns [dor2::R](dor2::R) reader structure
    impl crate::Readable for DOR2 {}
    ///channel2 data output register
    pub mod dor2 {
        ///Reader of register DOR2
        pub type R = crate::R<u32, super::DOR2>;
        ///Reader of field `DACC2DOR`
        pub type DACC2DOR_R = crate::R<u16, u16>;
        impl R {
            ///Bits 0:11 - DAC channel2 data output
            #[inline(always)]
            pub fn dacc2dor(&self) -> DACC2DOR_R {
                DACC2DOR_R::new((self.bits & 0x0fff) as u16)
            }
        }
    }
    ///status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [sr](sr) module
    pub type SR = crate::Reg<u32, _SR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SR;
    ///`read()` method returns [sr::R](sr::R) reader structure
    impl crate::Readable for SR {}
    ///`write(|w| ..)` method takes [sr::W](sr::W) writer structure
    impl crate::Writable for SR {}
    ///status register
    pub mod sr {
        ///Reader of register SR
        pub type R = crate::R<u32, super::SR>;
        ///Writer for register SR
        pub type W = crate::W<u32, super::SR>;
        ///Register SR `reset()`'s with value 0
        impl crate::ResetValue for super::SR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DMAUDR1`
        pub type DMAUDR1_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAUDR1`
        pub struct DMAUDR1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAUDR1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `CAL_FLAG1`
        pub type CAL_FLAG1_R = crate::R<bool, bool>;
        ///Reader of field `BWST1`
        pub type BWST1_R = crate::R<bool, bool>;
        ///Reader of field `DMAUDR2`
        pub type DMAUDR2_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAUDR2`
        pub struct DMAUDR2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAUDR2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `CAL_FLAG2`
        pub type CAL_FLAG2_R = crate::R<bool, bool>;
        ///Reader of field `BWST2`
        pub type BWST2_R = crate::R<bool, bool>;
        impl R {
            ///Bit 13 - DAC channel1 DMA underrun flag
            #[inline(always)]
            pub fn dmaudr1(&self) -> DMAUDR1_R {
                DMAUDR1_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 14 - DAC Channel 1 calibration offset status
            #[inline(always)]
            pub fn cal_flag1(&self) -> CAL_FLAG1_R {
                CAL_FLAG1_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 15 - DAC Channel 1 busy writing sample time flag
            #[inline(always)]
            pub fn bwst1(&self) -> BWST1_R {
                BWST1_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 29 - DAC channel2 DMA underrun flag
            #[inline(always)]
            pub fn dmaudr2(&self) -> DMAUDR2_R {
                DMAUDR2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 30 - DAC Channel 2 calibration offset status
            #[inline(always)]
            pub fn cal_flag2(&self) -> CAL_FLAG2_R {
                CAL_FLAG2_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 31 - DAC Channel 2 busy writing sample time flag
            #[inline(always)]
            pub fn bwst2(&self) -> BWST2_R {
                BWST2_R::new(((self.bits >> 31) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 13 - DAC channel1 DMA underrun flag
            #[inline(always)]
            pub fn dmaudr1(&mut self) -> DMAUDR1_W {
                DMAUDR1_W { w: self }
            }
            ///Bit 29 - DAC channel2 DMA underrun flag
            #[inline(always)]
            pub fn dmaudr2(&mut self) -> DMAUDR2_W {
                DMAUDR2_W { w: self }
            }
        }
    }
    ///calibration control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr](ccr) module
    pub type CCR = crate::Reg<u32, _CCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR;
    ///`read()` method returns [ccr::R](ccr::R) reader structure
    impl crate::Readable for CCR {}
    ///`write(|w| ..)` method takes [ccr::W](ccr::W) writer structure
    impl crate::Writable for CCR {}
    ///calibration control register
    pub mod ccr {
        ///Reader of register CCR
        pub type R = crate::R<u32, super::CCR>;
        ///Writer for register CCR
        pub type W = crate::W<u32, super::CCR>;
        ///Register CCR `reset()`'s with value 0
        impl crate::ResetValue for super::CCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `OTRIM1`
        pub type OTRIM1_R = crate::R<u8, u8>;
        ///Write proxy for field `OTRIM1`
        pub struct OTRIM1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OTRIM1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        ///Reader of field `OTRIM2`
        pub type OTRIM2_R = crate::R<u8, u8>;
        ///Write proxy for field `OTRIM2`
        pub struct OTRIM2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OTRIM2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 16)) | (((value as u32) & 0x1f) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:4 - DAC Channel 1 offset trimming value
            #[inline(always)]
            pub fn otrim1(&self) -> OTRIM1_R {
                OTRIM1_R::new((self.bits & 0x1f) as u8)
            }
            ///Bits 16:20 - DAC Channel 2 offset trimming value
            #[inline(always)]
            pub fn otrim2(&self) -> OTRIM2_R {
                OTRIM2_R::new(((self.bits >> 16) & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 0:4 - DAC Channel 1 offset trimming value
            #[inline(always)]
            pub fn otrim1(&mut self) -> OTRIM1_W {
                OTRIM1_W { w: self }
            }
            ///Bits 16:20 - DAC Channel 2 offset trimming value
            #[inline(always)]
            pub fn otrim2(&mut self) -> OTRIM2_W {
                OTRIM2_W { w: self }
            }
        }
    }
    ///mode control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [mcr](mcr) module
    pub type MCR = crate::Reg<u32, _MCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _MCR;
    ///`read()` method returns [mcr::R](mcr::R) reader structure
    impl crate::Readable for MCR {}
    ///`write(|w| ..)` method takes [mcr::W](mcr::W) writer structure
    impl crate::Writable for MCR {}
    ///mode control register
    pub mod mcr {
        ///Reader of register MCR
        pub type R = crate::R<u32, super::MCR>;
        ///Writer for register MCR
        pub type W = crate::W<u32, super::MCR>;
        ///Register MCR `reset()`'s with value 0
        impl crate::ResetValue for super::MCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MODE1`
        pub type MODE1_R = crate::R<u8, u8>;
        ///Write proxy for field `MODE1`
        pub struct MODE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MODE1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07) | ((value as u32) & 0x07);
                self.w
            }
        }
        ///Reader of field `MODE2`
        pub type MODE2_R = crate::R<u8, u8>;
        ///Write proxy for field `MODE2`
        pub struct MODE2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MODE2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 16)) | (((value as u32) & 0x07) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:2 - DAC Channel 1 mode
            #[inline(always)]
            pub fn mode1(&self) -> MODE1_R {
                MODE1_R::new((self.bits & 0x07) as u8)
            }
            ///Bits 16:18 - DAC Channel 2 mode
            #[inline(always)]
            pub fn mode2(&self) -> MODE2_R {
                MODE2_R::new(((self.bits >> 16) & 0x07) as u8)
            }
        }
        impl W {
            ///Bits 0:2 - DAC Channel 1 mode
            #[inline(always)]
            pub fn mode1(&mut self) -> MODE1_W {
                MODE1_W { w: self }
            }
            ///Bits 16:18 - DAC Channel 2 mode
            #[inline(always)]
            pub fn mode2(&mut self) -> MODE2_W {
                MODE2_W { w: self }
            }
        }
    }
    ///Sample and Hold sample time register 1
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [shsr1](shsr1) module
    pub type SHSR1 = crate::Reg<u32, _SHSR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SHSR1;
    ///`read()` method returns [shsr1::R](shsr1::R) reader structure
    impl crate::Readable for SHSR1 {}
    ///`write(|w| ..)` method takes [shsr1::W](shsr1::W) writer structure
    impl crate::Writable for SHSR1 {}
    ///Sample and Hold sample time register 1
    pub mod shsr1 {
        ///Reader of register SHSR1
        pub type R = crate::R<u32, super::SHSR1>;
        ///Writer for register SHSR1
        pub type W = crate::W<u32, super::SHSR1>;
        ///Register SHSR1 `reset()`'s with value 0
        impl crate::ResetValue for super::SHSR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `TSAMPLE1`
        pub type TSAMPLE1_R = crate::R<u16, u16>;
        ///Write proxy for field `TSAMPLE1`
        pub struct TSAMPLE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSAMPLE1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x03ff) | ((value as u32) & 0x03ff);
                self.w
            }
        }
        impl R {
            ///Bits 0:9 - DAC Channel 1 sample Time
            #[inline(always)]
            pub fn tsample1(&self) -> TSAMPLE1_R {
                TSAMPLE1_R::new((self.bits & 0x03ff) as u16)
            }
        }
        impl W {
            ///Bits 0:9 - DAC Channel 1 sample Time
            #[inline(always)]
            pub fn tsample1(&mut self) -> TSAMPLE1_W {
                TSAMPLE1_W { w: self }
            }
        }
    }
    ///Sample and Hold sample time register 2
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [shsr2](shsr2) module
    pub type SHSR2 = crate::Reg<u32, _SHSR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SHSR2;
    ///`read()` method returns [shsr2::R](shsr2::R) reader structure
    impl crate::Readable for SHSR2 {}
    ///`write(|w| ..)` method takes [shsr2::W](shsr2::W) writer structure
    impl crate::Writable for SHSR2 {}
    ///Sample and Hold sample time register 2
    pub mod shsr2 {
        ///Reader of register SHSR2
        pub type R = crate::R<u32, super::SHSR2>;
        ///Writer for register SHSR2
        pub type W = crate::W<u32, super::SHSR2>;
        ///Register SHSR2 `reset()`'s with value 0
        impl crate::ResetValue for super::SHSR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `TSAMPLE2`
        pub type TSAMPLE2_R = crate::R<u16, u16>;
        ///Write proxy for field `TSAMPLE2`
        pub struct TSAMPLE2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSAMPLE2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x03ff) | ((value as u32) & 0x03ff);
                self.w
            }
        }
        impl R {
            ///Bits 0:9 - DAC Channel 2 sample Time
            #[inline(always)]
            pub fn tsample2(&self) -> TSAMPLE2_R {
                TSAMPLE2_R::new((self.bits & 0x03ff) as u16)
            }
        }
        impl W {
            ///Bits 0:9 - DAC Channel 2 sample Time
            #[inline(always)]
            pub fn tsample2(&mut self) -> TSAMPLE2_W {
                TSAMPLE2_W { w: self }
            }
        }
    }
    ///Sample and Hold hold time register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [shhr](shhr) module
    pub type SHHR = crate::Reg<u32, _SHHR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SHHR;
    ///`read()` method returns [shhr::R](shhr::R) reader structure
    impl crate::Readable for SHHR {}
    ///`write(|w| ..)` method takes [shhr::W](shhr::W) writer structure
    impl crate::Writable for SHHR {}
    ///Sample and Hold hold time register
    pub mod shhr {
        ///Reader of register SHHR
        pub type R = crate::R<u32, super::SHHR>;
        ///Writer for register SHHR
        pub type W = crate::W<u32, super::SHHR>;
        ///Register SHHR `reset()`'s with value 0x0001_0001
        impl crate::ResetValue for super::SHHR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x0001_0001
            }
        }
        ///Reader of field `THOLD1`
        pub type THOLD1_R = crate::R<u16, u16>;
        ///Write proxy for field `THOLD1`
        pub struct THOLD1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> THOLD1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x03ff) | ((value as u32) & 0x03ff);
                self.w
            }
        }
        ///Reader of field `THOLD2`
        pub type THOLD2_R = crate::R<u16, u16>;
        ///Write proxy for field `THOLD2`
        pub struct THOLD2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> THOLD2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03ff << 16)) | (((value as u32) & 0x03ff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:9 - DAC Channel 1 hold Time
            #[inline(always)]
            pub fn thold1(&self) -> THOLD1_R {
                THOLD1_R::new((self.bits & 0x03ff) as u16)
            }
            ///Bits 16:25 - DAC Channel 2 hold time
            #[inline(always)]
            pub fn thold2(&self) -> THOLD2_R {
                THOLD2_R::new(((self.bits >> 16) & 0x03ff) as u16)
            }
        }
        impl W {
            ///Bits 0:9 - DAC Channel 1 hold Time
            #[inline(always)]
            pub fn thold1(&mut self) -> THOLD1_W {
                THOLD1_W { w: self }
            }
            ///Bits 16:25 - DAC Channel 2 hold time
            #[inline(always)]
            pub fn thold2(&mut self) -> THOLD2_W {
                THOLD2_W { w: self }
            }
        }
    }
    ///Sample and Hold refresh time register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [shrr](shrr) module
    pub type SHRR = crate::Reg<u32, _SHRR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SHRR;
    ///`read()` method returns [shrr::R](shrr::R) reader structure
    impl crate::Readable for SHRR {}
    ///`write(|w| ..)` method takes [shrr::W](shrr::W) writer structure
    impl crate::Writable for SHRR {}
    ///Sample and Hold refresh time register
    pub mod shrr {
        ///Reader of register SHRR
        pub type R = crate::R<u32, super::SHRR>;
        ///Writer for register SHRR
        pub type W = crate::W<u32, super::SHRR>;
        ///Register SHRR `reset()`'s with value 0x01
        impl crate::ResetValue for super::SHRR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x01
            }
        }
        ///Reader of field `TREFRESH1`
        pub type TREFRESH1_R = crate::R<u8, u8>;
        ///Write proxy for field `TREFRESH1`
        pub struct TREFRESH1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TREFRESH1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `TREFRESH2`
        pub type TREFRESH2_R = crate::R<u8, u8>;
        ///Write proxy for field `TREFRESH2`
        pub struct TREFRESH2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TREFRESH2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - DAC Channel 1 refresh Time
            #[inline(always)]
            pub fn trefresh1(&self) -> TREFRESH1_R {
                TREFRESH1_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 16:23 - DAC Channel 2 refresh Time
            #[inline(always)]
            pub fn trefresh2(&self) -> TREFRESH2_R {
                TREFRESH2_R::new(((self.bits >> 16) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - DAC Channel 1 refresh Time
            #[inline(always)]
            pub fn trefresh1(&mut self) -> TREFRESH1_W {
                TREFRESH1_W { w: self }
            }
            ///Bits 16:23 - DAC Channel 2 refresh Time
            #[inline(always)]
            pub fn trefresh2(&mut self) -> TREFRESH2_W {
                TREFRESH2_W { w: self }
            }
        }
    }
}
///Direct memory access controller
pub struct DMA1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA1 {}
impl DMA1 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dma1::RegisterBlock {
        0x4002_0000 as *const _
    }
}
impl Deref for DMA1 {
    type Target = dma1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DMA1::ptr() }
    }
}
///Direct memory access controller
pub mod dma1 {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - interrupt status register
        pub isr: ISR,
        ///0x04 - interrupt flag clear register
        pub ifcr: IFCR,
        ///0x08 - channel x configuration register
        pub ccr1: CCR1,
        ///0x0c - channel x number of data register
        pub cndtr1: CNDTR1,
        ///0x10 - channel x peripheral address register
        pub cpar1: CPAR1,
        ///0x14 - channel x memory address register
        pub cmar1: CMAR1,
        _reserved6: [u8; 4usize],
        ///0x1c - channel x configuration register
        pub ccr2: CCR2,
        ///0x20 - channel x number of data register
        pub cndtr2: CNDTR2,
        ///0x24 - channel x peripheral address register
        pub cpar2: CPAR2,
        ///0x28 - channel x memory address register
        pub cmar2: CMAR2,
        _reserved10: [u8; 4usize],
        ///0x30 - channel x configuration register
        pub ccr3: CCR3,
        ///0x34 - channel x number of data register
        pub cndtr3: CNDTR3,
        ///0x38 - channel x peripheral address register
        pub cpar3: CPAR3,
        ///0x3c - channel x memory address register
        pub cmar3: CMAR3,
        _reserved14: [u8; 4usize],
        ///0x44 - channel x configuration register
        pub ccr4: CCR4,
        ///0x48 - channel x number of data register
        pub cndtr4: CNDTR4,
        ///0x4c - channel x peripheral address register
        pub cpar4: CPAR4,
        ///0x50 - channel x memory address register
        pub cmar4: CMAR4,
        _reserved18: [u8; 4usize],
        ///0x58 - channel x configuration register
        pub ccr5: CCR5,
        ///0x5c - channel x number of data register
        pub cndtr5: CNDTR5,
        ///0x60 - channel x peripheral address register
        pub cpar5: CPAR5,
        ///0x64 - channel x memory address register
        pub cmar5: CMAR5,
        _reserved22: [u8; 4usize],
        ///0x6c - channel x configuration register
        pub ccr6: CCR6,
        ///0x70 - channel x number of data register
        pub cndtr6: CNDTR6,
        ///0x74 - channel x peripheral address register
        pub cpar6: CPAR6,
        ///0x78 - channel x memory address register
        pub cmar6: CMAR6,
        _reserved26: [u8; 4usize],
        ///0x80 - channel x configuration register
        pub ccr7: CCR7,
        ///0x84 - channel x number of data register
        pub cndtr7: CNDTR7,
        ///0x88 - channel x peripheral address register
        pub cpar7: CPAR7,
        ///0x8c - channel x memory address register
        pub cmar7: CMAR7,
        _reserved30: [u8; 24usize],
        ///0xa8 - channel selection register
        pub cselr: CSELR,
    }
    ///interrupt status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [isr](isr) module
    pub type ISR = crate::Reg<u32, _ISR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ISR;
    ///`read()` method returns [isr::R](isr::R) reader structure
    impl crate::Readable for ISR {}
    ///interrupt status register
    pub mod isr {
        ///Reader of register ISR
        pub type R = crate::R<u32, super::ISR>;
        ///Channel x transfer error flag (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIF7_A {
            ///0: No transfer error
            NOERROR = 0,
            ///1: A transfer error has occured
            ERROR = 1,
        }
        impl From<TEIF7_A> for bool {
            #[inline(always)]
            fn from(variant: TEIF7_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIF7`
        pub type TEIF7_R = crate::R<bool, TEIF7_A>;
        impl TEIF7_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIF7_A {
                match self.bits {
                    false => TEIF7_A::NOERROR,
                    true => TEIF7_A::ERROR,
                }
            }
            ///Checks if the value of the field is `NOERROR`
            #[inline(always)]
            pub fn is_no_error(&self) -> bool {
                *self == TEIF7_A::NOERROR
            }
            ///Checks if the value of the field is `ERROR`
            #[inline(always)]
            pub fn is_error(&self) -> bool {
                *self == TEIF7_A::ERROR
            }
        }
        ///Channel x half transfer flag (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIF7_A {
            ///0: No half transfer event
            NOTHALF = 0,
            ///1: A half transfer event has occured
            HALF = 1,
        }
        impl From<HTIF7_A> for bool {
            #[inline(always)]
            fn from(variant: HTIF7_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIF7`
        pub type HTIF7_R = crate::R<bool, HTIF7_A>;
        impl HTIF7_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIF7_A {
                match self.bits {
                    false => HTIF7_A::NOTHALF,
                    true => HTIF7_A::HALF,
                }
            }
            ///Checks if the value of the field is `NOTHALF`
            #[inline(always)]
            pub fn is_not_half(&self) -> bool {
                *self == HTIF7_A::NOTHALF
            }
            ///Checks if the value of the field is `HALF`
            #[inline(always)]
            pub fn is_half(&self) -> bool {
                *self == HTIF7_A::HALF
            }
        }
        ///Channel x transfer complete flag (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIF7_A {
            ///0: No transfer complete event
            NOTCOMPLETE = 0,
            ///1: A transfer complete event has occured
            COMPLETE = 1,
        }
        impl From<TCIF7_A> for bool {
            #[inline(always)]
            fn from(variant: TCIF7_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIF7`
        pub type TCIF7_R = crate::R<bool, TCIF7_A>;
        impl TCIF7_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIF7_A {
                match self.bits {
                    false => TCIF7_A::NOTCOMPLETE,
                    true => TCIF7_A::COMPLETE,
                }
            }
            ///Checks if the value of the field is `NOTCOMPLETE`
            #[inline(always)]
            pub fn is_not_complete(&self) -> bool {
                *self == TCIF7_A::NOTCOMPLETE
            }
            ///Checks if the value of the field is `COMPLETE`
            #[inline(always)]
            pub fn is_complete(&self) -> bool {
                *self == TCIF7_A::COMPLETE
            }
        }
        ///Channel x global interrupt flag (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum GIF7_A {
            ///0: No transfer error, half event, complete event
            NOEVENT = 0,
            ///1: A transfer error, half event or complete event has occured
            EVENT = 1,
        }
        impl From<GIF7_A> for bool {
            #[inline(always)]
            fn from(variant: GIF7_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `GIF7`
        pub type GIF7_R = crate::R<bool, GIF7_A>;
        impl GIF7_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> GIF7_A {
                match self.bits {
                    false => GIF7_A::NOEVENT,
                    true => GIF7_A::EVENT,
                }
            }
            ///Checks if the value of the field is `NOEVENT`
            #[inline(always)]
            pub fn is_no_event(&self) -> bool {
                *self == GIF7_A::NOEVENT
            }
            ///Checks if the value of the field is `EVENT`
            #[inline(always)]
            pub fn is_event(&self) -> bool {
                *self == GIF7_A::EVENT
            }
        }
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF6_A = TEIF7_A;
        ///Reader of field `TEIF6`
        pub type TEIF6_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF6_A = HTIF7_A;
        ///Reader of field `HTIF6`
        pub type HTIF6_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF6_A = TCIF7_A;
        ///Reader of field `TCIF6`
        pub type TCIF6_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF6_A = GIF7_A;
        ///Reader of field `GIF6`
        pub type GIF6_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF5_A = TEIF7_A;
        ///Reader of field `TEIF5`
        pub type TEIF5_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF5_A = HTIF7_A;
        ///Reader of field `HTIF5`
        pub type HTIF5_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF5_A = TCIF7_A;
        ///Reader of field `TCIF5`
        pub type TCIF5_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF5_A = GIF7_A;
        ///Reader of field `GIF5`
        pub type GIF5_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF4_A = TEIF7_A;
        ///Reader of field `TEIF4`
        pub type TEIF4_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF4_A = HTIF7_A;
        ///Reader of field `HTIF4`
        pub type HTIF4_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF4_A = TCIF7_A;
        ///Reader of field `TCIF4`
        pub type TCIF4_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF4_A = GIF7_A;
        ///Reader of field `GIF4`
        pub type GIF4_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF3_A = TEIF7_A;
        ///Reader of field `TEIF3`
        pub type TEIF3_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF3_A = HTIF7_A;
        ///Reader of field `HTIF3`
        pub type HTIF3_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF3_A = TCIF7_A;
        ///Reader of field `TCIF3`
        pub type TCIF3_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF3_A = GIF7_A;
        ///Reader of field `GIF3`
        pub type GIF3_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF2_A = TEIF7_A;
        ///Reader of field `TEIF2`
        pub type TEIF2_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF2_A = HTIF7_A;
        ///Reader of field `HTIF2`
        pub type HTIF2_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF2_A = TCIF7_A;
        ///Reader of field `TCIF2`
        pub type TCIF2_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF2_A = GIF7_A;
        ///Reader of field `GIF2`
        pub type GIF2_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF1_A = TEIF7_A;
        ///Reader of field `TEIF1`
        pub type TEIF1_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF1_A = HTIF7_A;
        ///Reader of field `HTIF1`
        pub type HTIF1_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF1_A = TCIF7_A;
        ///Reader of field `TCIF1`
        pub type TCIF1_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF1_A = GIF7_A;
        ///Reader of field `GIF1`
        pub type GIF1_R = crate::R<bool, GIF7_A>;
        impl R {
            ///Bit 27 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif7(&self) -> TEIF7_R {
                TEIF7_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif7(&self) -> HTIF7_R {
                HTIF7_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif7(&self) -> TCIF7_R {
                TCIF7_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif7(&self) -> GIF7_R {
                GIF7_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif6(&self) -> TEIF6_R {
                TEIF6_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif6(&self) -> HTIF6_R {
                HTIF6_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif6(&self) -> TCIF6_R {
                TCIF6_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif6(&self) -> GIF6_R {
                GIF6_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif5(&self) -> TEIF5_R {
                TEIF5_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif5(&self) -> HTIF5_R {
                HTIF5_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif5(&self) -> TCIF5_R {
                TCIF5_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif5(&self) -> GIF5_R {
                GIF5_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif4(&self) -> TEIF4_R {
                TEIF4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif4(&self) -> HTIF4_R {
                HTIF4_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif4(&self) -> TCIF4_R {
                TCIF4_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif4(&self) -> GIF4_R {
                GIF4_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif3(&self) -> TEIF3_R {
                TEIF3_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif3(&self) -> HTIF3_R {
                HTIF3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif3(&self) -> TCIF3_R {
                TCIF3_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif3(&self) -> GIF3_R {
                GIF3_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif2(&self) -> TEIF2_R {
                TEIF2_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif2(&self) -> HTIF2_R {
                HTIF2_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif2(&self) -> TCIF2_R {
                TCIF2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif2(&self) -> GIF2_R {
                GIF2_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif1(&self) -> TEIF1_R {
                TEIF1_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif1(&self) -> HTIF1_R {
                HTIF1_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif1(&self) -> TCIF1_R {
                TCIF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif1(&self) -> GIF1_R {
                GIF1_R::new((self.bits & 0x01) != 0)
            }
        }
    }
    ///interrupt flag clear register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ifcr](ifcr) module
    pub type IFCR = crate::Reg<u32, _IFCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IFCR;
    ///`write(|w| ..)` method takes [ifcr::W](ifcr::W) writer structure
    impl crate::Writable for IFCR {}
    ///interrupt flag clear register
    pub mod ifcr {
        ///Writer for register IFCR
        pub type W = crate::W<u32, super::IFCR>;
        ///Register IFCR `reset()`'s with value 0
        impl crate::ResetValue for super::IFCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CTEIF7_AW {
            ///1: Clears the TEIF flag in the ISR register
            CLEAR = 1,
        }
        impl From<CTEIF7_AW> for bool {
            #[inline(always)]
            fn from(variant: CTEIF7_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `CTEIF7`
        pub struct CTEIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF7_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF7_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CHTIF7_AW {
            ///1: Clears the HTIF flag in the ISR register
            CLEAR = 1,
        }
        impl From<CHTIF7_AW> for bool {
            #[inline(always)]
            fn from(variant: CHTIF7_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `CHTIF7`
        pub struct CHTIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF7_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF7_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CTCIF7_AW {
            ///1: Clears the TCIF flag in the ISR register
            CLEAR = 1,
        }
        impl From<CTCIF7_AW> for bool {
            #[inline(always)]
            fn from(variant: CTCIF7_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `CTCIF7`
        pub struct CTCIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF7_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF7_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CGIF7_AW {
            ///1: Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            CLEAR = 1,
        }
        impl From<CGIF7_AW> for bool {
            #[inline(always)]
            fn from(variant: CGIF7_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `CGIF7`
        pub struct CGIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF7_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF7_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF6_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF6`
        pub struct CTEIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF6_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF6_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF6_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF6`
        pub struct CHTIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF6_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF6_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF6_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF6`
        pub struct CTCIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF6_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF6_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF6_AW = CGIF7_AW;
        ///Write proxy for field `CGIF6`
        pub struct CGIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF6_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF6_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF5_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF5`
        pub struct CTEIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF5_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF5_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF5_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF5`
        pub struct CHTIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF5_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF5_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF5_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF5`
        pub struct CTCIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF5_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF5_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF5_AW = CGIF7_AW;
        ///Write proxy for field `CGIF5`
        pub struct CGIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF5_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF5_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF4_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF4`
        pub struct CTEIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF4_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF4_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF4_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF4`
        pub struct CHTIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF4_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF4_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF4_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF4`
        pub struct CTCIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF4_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF4_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF4_AW = CGIF7_AW;
        ///Write proxy for field `CGIF4`
        pub struct CGIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF4_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF4_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF3_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF3`
        pub struct CTEIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF3_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF3_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF3_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF3`
        pub struct CHTIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF3_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF3_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF3_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF3`
        pub struct CTCIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF3_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF3_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF3_AW = CGIF7_AW;
        ///Write proxy for field `CGIF3`
        pub struct CGIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF3_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF3_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF2_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF2`
        pub struct CTEIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF2_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF2_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF2_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF2`
        pub struct CHTIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF2_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF2_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF2_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF2`
        pub struct CTCIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF2_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF2_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF2_AW = CGIF7_AW;
        ///Write proxy for field `CGIF2`
        pub struct CGIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF2_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF2_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF1_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF1`
        pub struct CTEIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF1_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF1_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF1_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF1`
        pub struct CHTIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF1_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF1_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF1_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF1`
        pub struct CTCIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF1_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF1_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF1_AW = CGIF7_AW;
        ///Write proxy for field `CGIF1`
        pub struct CGIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF1_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF1_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl W {
            ///Bit 27 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif7(&mut self) -> CTEIF7_W {
                CTEIF7_W { w: self }
            }
            ///Bit 26 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif7(&mut self) -> CHTIF7_W {
                CHTIF7_W { w: self }
            }
            ///Bit 25 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif7(&mut self) -> CTCIF7_W {
                CTCIF7_W { w: self }
            }
            ///Bit 24 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif7(&mut self) -> CGIF7_W {
                CGIF7_W { w: self }
            }
            ///Bit 23 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif6(&mut self) -> CTEIF6_W {
                CTEIF6_W { w: self }
            }
            ///Bit 22 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif6(&mut self) -> CHTIF6_W {
                CHTIF6_W { w: self }
            }
            ///Bit 21 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif6(&mut self) -> CTCIF6_W {
                CTCIF6_W { w: self }
            }
            ///Bit 20 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif6(&mut self) -> CGIF6_W {
                CGIF6_W { w: self }
            }
            ///Bit 19 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif5(&mut self) -> CTEIF5_W {
                CTEIF5_W { w: self }
            }
            ///Bit 18 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif5(&mut self) -> CHTIF5_W {
                CHTIF5_W { w: self }
            }
            ///Bit 17 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif5(&mut self) -> CTCIF5_W {
                CTCIF5_W { w: self }
            }
            ///Bit 16 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif5(&mut self) -> CGIF5_W {
                CGIF5_W { w: self }
            }
            ///Bit 15 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif4(&mut self) -> CTEIF4_W {
                CTEIF4_W { w: self }
            }
            ///Bit 14 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif4(&mut self) -> CHTIF4_W {
                CHTIF4_W { w: self }
            }
            ///Bit 13 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif4(&mut self) -> CTCIF4_W {
                CTCIF4_W { w: self }
            }
            ///Bit 12 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif4(&mut self) -> CGIF4_W {
                CGIF4_W { w: self }
            }
            ///Bit 11 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif3(&mut self) -> CTEIF3_W {
                CTEIF3_W { w: self }
            }
            ///Bit 10 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif3(&mut self) -> CHTIF3_W {
                CHTIF3_W { w: self }
            }
            ///Bit 9 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif3(&mut self) -> CTCIF3_W {
                CTCIF3_W { w: self }
            }
            ///Bit 8 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif3(&mut self) -> CGIF3_W {
                CGIF3_W { w: self }
            }
            ///Bit 7 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif2(&mut self) -> CTEIF2_W {
                CTEIF2_W { w: self }
            }
            ///Bit 6 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif2(&mut self) -> CHTIF2_W {
                CHTIF2_W { w: self }
            }
            ///Bit 5 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif2(&mut self) -> CTCIF2_W {
                CTCIF2_W { w: self }
            }
            ///Bit 4 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif2(&mut self) -> CGIF2_W {
                CGIF2_W { w: self }
            }
            ///Bit 3 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif1(&mut self) -> CTEIF1_W {
                CTEIF1_W { w: self }
            }
            ///Bit 2 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif1(&mut self) -> CHTIF1_W {
                CHTIF1_W { w: self }
            }
            ///Bit 1 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif1(&mut self) -> CTCIF1_W {
                CTCIF1_W { w: self }
            }
            ///Bit 0 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif1(&mut self) -> CGIF1_W {
                CGIF1_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr1](ccr1) module
    pub type CCR1 = crate::Reg<u32, _CCR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR1;
    ///`read()` method returns [ccr1::R](ccr1::R) reader structure
    impl crate::Readable for CCR1 {}
    ///`write(|w| ..)` method takes [ccr1::W](ccr1::W) writer structure
    impl crate::Writable for CCR1 {}
    ///channel x configuration register
    pub mod ccr1 {
        ///Reader of register CCR1
        pub type R = crate::R<u32, super::CCR1>;
        ///Writer for register CCR1
        pub type W = crate::W<u32, super::CCR1>;
        ///Register CCR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr1](cndtr1) module
    pub type CNDTR1 = crate::Reg<u32, _CNDTR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR1;
    ///`read()` method returns [cndtr1::R](cndtr1::R) reader structure
    impl crate::Readable for CNDTR1 {}
    ///`write(|w| ..)` method takes [cndtr1::W](cndtr1::W) writer structure
    impl crate::Writable for CNDTR1 {}
    ///channel x number of data register
    pub mod cndtr1 {
        ///Reader of register CNDTR1
        pub type R = crate::R<u32, super::CNDTR1>;
        ///Writer for register CNDTR1
        pub type W = crate::W<u32, super::CNDTR1>;
        ///Register CNDTR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar1](cpar1) module
    pub type CPAR1 = crate::Reg<u32, _CPAR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR1;
    ///`read()` method returns [cpar1::R](cpar1::R) reader structure
    impl crate::Readable for CPAR1 {}
    ///`write(|w| ..)` method takes [cpar1::W](cpar1::W) writer structure
    impl crate::Writable for CPAR1 {}
    ///channel x peripheral address register
    pub mod cpar1 {
        ///Reader of register CPAR1
        pub type R = crate::R<u32, super::CPAR1>;
        ///Writer for register CPAR1
        pub type W = crate::W<u32, super::CPAR1>;
        ///Register CPAR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar1](cmar1) module
    pub type CMAR1 = crate::Reg<u32, _CMAR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR1;
    ///`read()` method returns [cmar1::R](cmar1::R) reader structure
    impl crate::Readable for CMAR1 {}
    ///`write(|w| ..)` method takes [cmar1::W](cmar1::W) writer structure
    impl crate::Writable for CMAR1 {}
    ///channel x memory address register
    pub mod cmar1 {
        ///Reader of register CMAR1
        pub type R = crate::R<u32, super::CMAR1>;
        ///Writer for register CMAR1
        pub type W = crate::W<u32, super::CMAR1>;
        ///Register CMAR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr2](ccr2) module
    pub type CCR2 = crate::Reg<u32, _CCR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR2;
    ///`read()` method returns [ccr2::R](ccr2::R) reader structure
    impl crate::Readable for CCR2 {}
    ///`write(|w| ..)` method takes [ccr2::W](ccr2::W) writer structure
    impl crate::Writable for CCR2 {}
    ///channel x configuration register
    pub mod ccr2 {
        ///Reader of register CCR2
        pub type R = crate::R<u32, super::CCR2>;
        ///Writer for register CCR2
        pub type W = crate::W<u32, super::CCR2>;
        ///Register CCR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr2](cndtr2) module
    pub type CNDTR2 = crate::Reg<u32, _CNDTR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR2;
    ///`read()` method returns [cndtr2::R](cndtr2::R) reader structure
    impl crate::Readable for CNDTR2 {}
    ///`write(|w| ..)` method takes [cndtr2::W](cndtr2::W) writer structure
    impl crate::Writable for CNDTR2 {}
    ///channel x number of data register
    pub mod cndtr2 {
        ///Reader of register CNDTR2
        pub type R = crate::R<u32, super::CNDTR2>;
        ///Writer for register CNDTR2
        pub type W = crate::W<u32, super::CNDTR2>;
        ///Register CNDTR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar2](cpar2) module
    pub type CPAR2 = crate::Reg<u32, _CPAR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR2;
    ///`read()` method returns [cpar2::R](cpar2::R) reader structure
    impl crate::Readable for CPAR2 {}
    ///`write(|w| ..)` method takes [cpar2::W](cpar2::W) writer structure
    impl crate::Writable for CPAR2 {}
    ///channel x peripheral address register
    pub mod cpar2 {
        ///Reader of register CPAR2
        pub type R = crate::R<u32, super::CPAR2>;
        ///Writer for register CPAR2
        pub type W = crate::W<u32, super::CPAR2>;
        ///Register CPAR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar2](cmar2) module
    pub type CMAR2 = crate::Reg<u32, _CMAR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR2;
    ///`read()` method returns [cmar2::R](cmar2::R) reader structure
    impl crate::Readable for CMAR2 {}
    ///`write(|w| ..)` method takes [cmar2::W](cmar2::W) writer structure
    impl crate::Writable for CMAR2 {}
    ///channel x memory address register
    pub mod cmar2 {
        ///Reader of register CMAR2
        pub type R = crate::R<u32, super::CMAR2>;
        ///Writer for register CMAR2
        pub type W = crate::W<u32, super::CMAR2>;
        ///Register CMAR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr3](ccr3) module
    pub type CCR3 = crate::Reg<u32, _CCR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR3;
    ///`read()` method returns [ccr3::R](ccr3::R) reader structure
    impl crate::Readable for CCR3 {}
    ///`write(|w| ..)` method takes [ccr3::W](ccr3::W) writer structure
    impl crate::Writable for CCR3 {}
    ///channel x configuration register
    pub mod ccr3 {
        ///Reader of register CCR3
        pub type R = crate::R<u32, super::CCR3>;
        ///Writer for register CCR3
        pub type W = crate::W<u32, super::CCR3>;
        ///Register CCR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr3](cndtr3) module
    pub type CNDTR3 = crate::Reg<u32, _CNDTR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR3;
    ///`read()` method returns [cndtr3::R](cndtr3::R) reader structure
    impl crate::Readable for CNDTR3 {}
    ///`write(|w| ..)` method takes [cndtr3::W](cndtr3::W) writer structure
    impl crate::Writable for CNDTR3 {}
    ///channel x number of data register
    pub mod cndtr3 {
        ///Reader of register CNDTR3
        pub type R = crate::R<u32, super::CNDTR3>;
        ///Writer for register CNDTR3
        pub type W = crate::W<u32, super::CNDTR3>;
        ///Register CNDTR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar3](cpar3) module
    pub type CPAR3 = crate::Reg<u32, _CPAR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR3;
    ///`read()` method returns [cpar3::R](cpar3::R) reader structure
    impl crate::Readable for CPAR3 {}
    ///`write(|w| ..)` method takes [cpar3::W](cpar3::W) writer structure
    impl crate::Writable for CPAR3 {}
    ///channel x peripheral address register
    pub mod cpar3 {
        ///Reader of register CPAR3
        pub type R = crate::R<u32, super::CPAR3>;
        ///Writer for register CPAR3
        pub type W = crate::W<u32, super::CPAR3>;
        ///Register CPAR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar3](cmar3) module
    pub type CMAR3 = crate::Reg<u32, _CMAR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR3;
    ///`read()` method returns [cmar3::R](cmar3::R) reader structure
    impl crate::Readable for CMAR3 {}
    ///`write(|w| ..)` method takes [cmar3::W](cmar3::W) writer structure
    impl crate::Writable for CMAR3 {}
    ///channel x memory address register
    pub mod cmar3 {
        ///Reader of register CMAR3
        pub type R = crate::R<u32, super::CMAR3>;
        ///Writer for register CMAR3
        pub type W = crate::W<u32, super::CMAR3>;
        ///Register CMAR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr4](ccr4) module
    pub type CCR4 = crate::Reg<u32, _CCR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR4;
    ///`read()` method returns [ccr4::R](ccr4::R) reader structure
    impl crate::Readable for CCR4 {}
    ///`write(|w| ..)` method takes [ccr4::W](ccr4::W) writer structure
    impl crate::Writable for CCR4 {}
    ///channel x configuration register
    pub mod ccr4 {
        ///Reader of register CCR4
        pub type R = crate::R<u32, super::CCR4>;
        ///Writer for register CCR4
        pub type W = crate::W<u32, super::CCR4>;
        ///Register CCR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr4](cndtr4) module
    pub type CNDTR4 = crate::Reg<u32, _CNDTR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR4;
    ///`read()` method returns [cndtr4::R](cndtr4::R) reader structure
    impl crate::Readable for CNDTR4 {}
    ///`write(|w| ..)` method takes [cndtr4::W](cndtr4::W) writer structure
    impl crate::Writable for CNDTR4 {}
    ///channel x number of data register
    pub mod cndtr4 {
        ///Reader of register CNDTR4
        pub type R = crate::R<u32, super::CNDTR4>;
        ///Writer for register CNDTR4
        pub type W = crate::W<u32, super::CNDTR4>;
        ///Register CNDTR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar4](cpar4) module
    pub type CPAR4 = crate::Reg<u32, _CPAR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR4;
    ///`read()` method returns [cpar4::R](cpar4::R) reader structure
    impl crate::Readable for CPAR4 {}
    ///`write(|w| ..)` method takes [cpar4::W](cpar4::W) writer structure
    impl crate::Writable for CPAR4 {}
    ///channel x peripheral address register
    pub mod cpar4 {
        ///Reader of register CPAR4
        pub type R = crate::R<u32, super::CPAR4>;
        ///Writer for register CPAR4
        pub type W = crate::W<u32, super::CPAR4>;
        ///Register CPAR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar4](cmar4) module
    pub type CMAR4 = crate::Reg<u32, _CMAR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR4;
    ///`read()` method returns [cmar4::R](cmar4::R) reader structure
    impl crate::Readable for CMAR4 {}
    ///`write(|w| ..)` method takes [cmar4::W](cmar4::W) writer structure
    impl crate::Writable for CMAR4 {}
    ///channel x memory address register
    pub mod cmar4 {
        ///Reader of register CMAR4
        pub type R = crate::R<u32, super::CMAR4>;
        ///Writer for register CMAR4
        pub type W = crate::W<u32, super::CMAR4>;
        ///Register CMAR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr5](ccr5) module
    pub type CCR5 = crate::Reg<u32, _CCR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR5;
    ///`read()` method returns [ccr5::R](ccr5::R) reader structure
    impl crate::Readable for CCR5 {}
    ///`write(|w| ..)` method takes [ccr5::W](ccr5::W) writer structure
    impl crate::Writable for CCR5 {}
    ///channel x configuration register
    pub mod ccr5 {
        ///Reader of register CCR5
        pub type R = crate::R<u32, super::CCR5>;
        ///Writer for register CCR5
        pub type W = crate::W<u32, super::CCR5>;
        ///Register CCR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr5](cndtr5) module
    pub type CNDTR5 = crate::Reg<u32, _CNDTR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR5;
    ///`read()` method returns [cndtr5::R](cndtr5::R) reader structure
    impl crate::Readable for CNDTR5 {}
    ///`write(|w| ..)` method takes [cndtr5::W](cndtr5::W) writer structure
    impl crate::Writable for CNDTR5 {}
    ///channel x number of data register
    pub mod cndtr5 {
        ///Reader of register CNDTR5
        pub type R = crate::R<u32, super::CNDTR5>;
        ///Writer for register CNDTR5
        pub type W = crate::W<u32, super::CNDTR5>;
        ///Register CNDTR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar5](cpar5) module
    pub type CPAR5 = crate::Reg<u32, _CPAR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR5;
    ///`read()` method returns [cpar5::R](cpar5::R) reader structure
    impl crate::Readable for CPAR5 {}
    ///`write(|w| ..)` method takes [cpar5::W](cpar5::W) writer structure
    impl crate::Writable for CPAR5 {}
    ///channel x peripheral address register
    pub mod cpar5 {
        ///Reader of register CPAR5
        pub type R = crate::R<u32, super::CPAR5>;
        ///Writer for register CPAR5
        pub type W = crate::W<u32, super::CPAR5>;
        ///Register CPAR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar5](cmar5) module
    pub type CMAR5 = crate::Reg<u32, _CMAR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR5;
    ///`read()` method returns [cmar5::R](cmar5::R) reader structure
    impl crate::Readable for CMAR5 {}
    ///`write(|w| ..)` method takes [cmar5::W](cmar5::W) writer structure
    impl crate::Writable for CMAR5 {}
    ///channel x memory address register
    pub mod cmar5 {
        ///Reader of register CMAR5
        pub type R = crate::R<u32, super::CMAR5>;
        ///Writer for register CMAR5
        pub type W = crate::W<u32, super::CMAR5>;
        ///Register CMAR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr6](ccr6) module
    pub type CCR6 = crate::Reg<u32, _CCR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR6;
    ///`read()` method returns [ccr6::R](ccr6::R) reader structure
    impl crate::Readable for CCR6 {}
    ///`write(|w| ..)` method takes [ccr6::W](ccr6::W) writer structure
    impl crate::Writable for CCR6 {}
    ///channel x configuration register
    pub mod ccr6 {
        ///Reader of register CCR6
        pub type R = crate::R<u32, super::CCR6>;
        ///Writer for register CCR6
        pub type W = crate::W<u32, super::CCR6>;
        ///Register CCR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr6](cndtr6) module
    pub type CNDTR6 = crate::Reg<u32, _CNDTR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR6;
    ///`read()` method returns [cndtr6::R](cndtr6::R) reader structure
    impl crate::Readable for CNDTR6 {}
    ///`write(|w| ..)` method takes [cndtr6::W](cndtr6::W) writer structure
    impl crate::Writable for CNDTR6 {}
    ///channel x number of data register
    pub mod cndtr6 {
        ///Reader of register CNDTR6
        pub type R = crate::R<u32, super::CNDTR6>;
        ///Writer for register CNDTR6
        pub type W = crate::W<u32, super::CNDTR6>;
        ///Register CNDTR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar6](cpar6) module
    pub type CPAR6 = crate::Reg<u32, _CPAR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR6;
    ///`read()` method returns [cpar6::R](cpar6::R) reader structure
    impl crate::Readable for CPAR6 {}
    ///`write(|w| ..)` method takes [cpar6::W](cpar6::W) writer structure
    impl crate::Writable for CPAR6 {}
    ///channel x peripheral address register
    pub mod cpar6 {
        ///Reader of register CPAR6
        pub type R = crate::R<u32, super::CPAR6>;
        ///Writer for register CPAR6
        pub type W = crate::W<u32, super::CPAR6>;
        ///Register CPAR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar6](cmar6) module
    pub type CMAR6 = crate::Reg<u32, _CMAR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR6;
    ///`read()` method returns [cmar6::R](cmar6::R) reader structure
    impl crate::Readable for CMAR6 {}
    ///`write(|w| ..)` method takes [cmar6::W](cmar6::W) writer structure
    impl crate::Writable for CMAR6 {}
    ///channel x memory address register
    pub mod cmar6 {
        ///Reader of register CMAR6
        pub type R = crate::R<u32, super::CMAR6>;
        ///Writer for register CMAR6
        pub type W = crate::W<u32, super::CMAR6>;
        ///Register CMAR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr7](ccr7) module
    pub type CCR7 = crate::Reg<u32, _CCR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR7;
    ///`read()` method returns [ccr7::R](ccr7::R) reader structure
    impl crate::Readable for CCR7 {}
    ///`write(|w| ..)` method takes [ccr7::W](ccr7::W) writer structure
    impl crate::Writable for CCR7 {}
    ///channel x configuration register
    pub mod ccr7 {
        ///Reader of register CCR7
        pub type R = crate::R<u32, super::CCR7>;
        ///Writer for register CCR7
        pub type W = crate::W<u32, super::CCR7>;
        ///Register CCR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr7](cndtr7) module
    pub type CNDTR7 = crate::Reg<u32, _CNDTR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR7;
    ///`read()` method returns [cndtr7::R](cndtr7::R) reader structure
    impl crate::Readable for CNDTR7 {}
    ///`write(|w| ..)` method takes [cndtr7::W](cndtr7::W) writer structure
    impl crate::Writable for CNDTR7 {}
    ///channel x number of data register
    pub mod cndtr7 {
        ///Reader of register CNDTR7
        pub type R = crate::R<u32, super::CNDTR7>;
        ///Writer for register CNDTR7
        pub type W = crate::W<u32, super::CNDTR7>;
        ///Register CNDTR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar7](cpar7) module
    pub type CPAR7 = crate::Reg<u32, _CPAR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR7;
    ///`read()` method returns [cpar7::R](cpar7::R) reader structure
    impl crate::Readable for CPAR7 {}
    ///`write(|w| ..)` method takes [cpar7::W](cpar7::W) writer structure
    impl crate::Writable for CPAR7 {}
    ///channel x peripheral address register
    pub mod cpar7 {
        ///Reader of register CPAR7
        pub type R = crate::R<u32, super::CPAR7>;
        ///Writer for register CPAR7
        pub type W = crate::W<u32, super::CPAR7>;
        ///Register CPAR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar7](cmar7) module
    pub type CMAR7 = crate::Reg<u32, _CMAR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR7;
    ///`read()` method returns [cmar7::R](cmar7::R) reader structure
    impl crate::Readable for CMAR7 {}
    ///`write(|w| ..)` method takes [cmar7::W](cmar7::W) writer structure
    impl crate::Writable for CMAR7 {}
    ///channel x memory address register
    pub mod cmar7 {
        ///Reader of register CMAR7
        pub type R = crate::R<u32, super::CMAR7>;
        ///Writer for register CMAR7
        pub type W = crate::W<u32, super::CMAR7>;
        ///Register CMAR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel selection register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cselr](cselr) module
    pub type CSELR = crate::Reg<u32, _CSELR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CSELR;
    ///`read()` method returns [cselr::R](cselr::R) reader structure
    impl crate::Readable for CSELR {}
    ///`write(|w| ..)` method takes [cselr::W](cselr::W) writer structure
    impl crate::Writable for CSELR {}
    ///channel selection register
    pub mod cselr {
        ///Reader of register CSELR
        pub type R = crate::R<u32, super::CSELR>;
        ///Writer for register CSELR
        pub type W = crate::W<u32, super::CSELR>;
        ///Register CSELR `reset()`'s with value 0
        impl crate::ResetValue for super::CSELR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///DMA channel 7 selection
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum C7S_A {
            ///0: Default mapping
            NOMAPPING = 0,
            ///1: Mapping 1
            MAP1 = 1,
            ///2: Mapping 2
            MAP2 = 2,
            ///3: Mapping 3
            MAP3 = 3,
            ///4: Mapping 4
            MAP4 = 4,
            ///5: Mapping 5
            MAP5 = 5,
            ///6: Mapping 6
            MAP6 = 6,
            ///7: Mapping 7
            MAP7 = 7,
            ///8: Mapping 8
            MAP8 = 8,
            ///9: Mapping 9
            MAP9 = 9,
            ///10: Mapping 10
            MAP10 = 10,
            ///11: Mapping 11
            MAP11 = 11,
            ///12: Mapping 12
            MAP12 = 12,
            ///13: Mapping 13
            MAP13 = 13,
            ///14: Mapping 14
            MAP14 = 14,
            ///15: Mapping 15
            MAP15 = 15,
        }
        impl From<C7S_A> for u8 {
            #[inline(always)]
            fn from(variant: C7S_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `C7S`
        pub type C7S_R = crate::R<u8, C7S_A>;
        impl C7S_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> C7S_A {
                match self.bits {
                    0 => C7S_A::NOMAPPING,
                    1 => C7S_A::MAP1,
                    2 => C7S_A::MAP2,
                    3 => C7S_A::MAP3,
                    4 => C7S_A::MAP4,
                    5 => C7S_A::MAP5,
                    6 => C7S_A::MAP6,
                    7 => C7S_A::MAP7,
                    8 => C7S_A::MAP8,
                    9 => C7S_A::MAP9,
                    10 => C7S_A::MAP10,
                    11 => C7S_A::MAP11,
                    12 => C7S_A::MAP12,
                    13 => C7S_A::MAP13,
                    14 => C7S_A::MAP14,
                    15 => C7S_A::MAP15,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `NOMAPPING`
            #[inline(always)]
            pub fn is_no_mapping(&self) -> bool {
                *self == C7S_A::NOMAPPING
            }
            ///Checks if the value of the field is `MAP1`
            #[inline(always)]
            pub fn is_map1(&self) -> bool {
                *self == C7S_A::MAP1
            }
            ///Checks if the value of the field is `MAP2`
            #[inline(always)]
            pub fn is_map2(&self) -> bool {
                *self == C7S_A::MAP2
            }
            ///Checks if the value of the field is `MAP3`
            #[inline(always)]
            pub fn is_map3(&self) -> bool {
                *self == C7S_A::MAP3
            }
            ///Checks if the value of the field is `MAP4`
            #[inline(always)]
            pub fn is_map4(&self) -> bool {
                *self == C7S_A::MAP4
            }
            ///Checks if the value of the field is `MAP5`
            #[inline(always)]
            pub fn is_map5(&self) -> bool {
                *self == C7S_A::MAP5
            }
            ///Checks if the value of the field is `MAP6`
            #[inline(always)]
            pub fn is_map6(&self) -> bool {
                *self == C7S_A::MAP6
            }
            ///Checks if the value of the field is `MAP7`
            #[inline(always)]
            pub fn is_map7(&self) -> bool {
                *self == C7S_A::MAP7
            }
            ///Checks if the value of the field is `MAP8`
            #[inline(always)]
            pub fn is_map8(&self) -> bool {
                *self == C7S_A::MAP8
            }
            ///Checks if the value of the field is `MAP9`
            #[inline(always)]
            pub fn is_map9(&self) -> bool {
                *self == C7S_A::MAP9
            }
            ///Checks if the value of the field is `MAP10`
            #[inline(always)]
            pub fn is_map10(&self) -> bool {
                *self == C7S_A::MAP10
            }
            ///Checks if the value of the field is `MAP11`
            #[inline(always)]
            pub fn is_map11(&self) -> bool {
                *self == C7S_A::MAP11
            }
            ///Checks if the value of the field is `MAP12`
            #[inline(always)]
            pub fn is_map12(&self) -> bool {
                *self == C7S_A::MAP12
            }
            ///Checks if the value of the field is `MAP13`
            #[inline(always)]
            pub fn is_map13(&self) -> bool {
                *self == C7S_A::MAP13
            }
            ///Checks if the value of the field is `MAP14`
            #[inline(always)]
            pub fn is_map14(&self) -> bool {
                *self == C7S_A::MAP14
            }
            ///Checks if the value of the field is `MAP15`
            #[inline(always)]
            pub fn is_map15(&self) -> bool {
                *self == C7S_A::MAP15
            }
        }
        ///Write proxy for field `C7S`
        pub struct C7S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C7S_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: C7S_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Default mapping
            #[inline(always)]
            pub fn no_mapping(self) -> &'a mut W {
                self.variant(C7S_A::NOMAPPING)
            }
            ///Mapping 1
            #[inline(always)]
            pub fn map1(self) -> &'a mut W {
                self.variant(C7S_A::MAP1)
            }
            ///Mapping 2
            #[inline(always)]
            pub fn map2(self) -> &'a mut W {
                self.variant(C7S_A::MAP2)
            }
            ///Mapping 3
            #[inline(always)]
            pub fn map3(self) -> &'a mut W {
                self.variant(C7S_A::MAP3)
            }
            ///Mapping 4
            #[inline(always)]
            pub fn map4(self) -> &'a mut W {
                self.variant(C7S_A::MAP4)
            }
            ///Mapping 5
            #[inline(always)]
            pub fn map5(self) -> &'a mut W {
                self.variant(C7S_A::MAP5)
            }
            ///Mapping 6
            #[inline(always)]
            pub fn map6(self) -> &'a mut W {
                self.variant(C7S_A::MAP6)
            }
            ///Mapping 7
            #[inline(always)]
            pub fn map7(self) -> &'a mut W {
                self.variant(C7S_A::MAP7)
            }
            ///Mapping 8
            #[inline(always)]
            pub fn map8(self) -> &'a mut W {
                self.variant(C7S_A::MAP8)
            }
            ///Mapping 9
            #[inline(always)]
            pub fn map9(self) -> &'a mut W {
                self.variant(C7S_A::MAP9)
            }
            ///Mapping 10
            #[inline(always)]
            pub fn map10(self) -> &'a mut W {
                self.variant(C7S_A::MAP10)
            }
            ///Mapping 11
            #[inline(always)]
            pub fn map11(self) -> &'a mut W {
                self.variant(C7S_A::MAP11)
            }
            ///Mapping 12
            #[inline(always)]
            pub fn map12(self) -> &'a mut W {
                self.variant(C7S_A::MAP12)
            }
            ///Mapping 13
            #[inline(always)]
            pub fn map13(self) -> &'a mut W {
                self.variant(C7S_A::MAP13)
            }
            ///Mapping 14
            #[inline(always)]
            pub fn map14(self) -> &'a mut W {
                self.variant(C7S_A::MAP14)
            }
            ///Mapping 15
            #[inline(always)]
            pub fn map15(self) -> &'a mut W {
                self.variant(C7S_A::MAP15)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 24)) | (((value as u32) & 0x0f) << 24);
                self.w
            }
        }
        ///DMA channel 6 selection
        pub type C6S_A = C7S_A;
        ///Reader of field `C6S`
        pub type C6S_R = crate::R<u8, C7S_A>;
        ///Write proxy for field `C6S`
        pub struct C6S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C6S_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: C6S_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Default mapping
            #[inline(always)]
            pub fn no_mapping(self) -> &'a mut W {
                self.variant(C7S_A::NOMAPPING)
            }
            ///Mapping 1
            #[inline(always)]
            pub fn map1(self) -> &'a mut W {
                self.variant(C7S_A::MAP1)
            }
            ///Mapping 2
            #[inline(always)]
            pub fn map2(self) -> &'a mut W {
                self.variant(C7S_A::MAP2)
            }
            ///Mapping 3
            #[inline(always)]
            pub fn map3(self) -> &'a mut W {
                self.variant(C7S_A::MAP3)
            }
            ///Mapping 4
            #[inline(always)]
            pub fn map4(self) -> &'a mut W {
                self.variant(C7S_A::MAP4)
            }
            ///Mapping 5
            #[inline(always)]
            pub fn map5(self) -> &'a mut W {
                self.variant(C7S_A::MAP5)
            }
            ///Mapping 6
            #[inline(always)]
            pub fn map6(self) -> &'a mut W {
                self.variant(C7S_A::MAP6)
            }
            ///Mapping 7
            #[inline(always)]
            pub fn map7(self) -> &'a mut W {
                self.variant(C7S_A::MAP7)
            }
            ///Mapping 8
            #[inline(always)]
            pub fn map8(self) -> &'a mut W {
                self.variant(C7S_A::MAP8)
            }
            ///Mapping 9
            #[inline(always)]
            pub fn map9(self) -> &'a mut W {
                self.variant(C7S_A::MAP9)
            }
            ///Mapping 10
            #[inline(always)]
            pub fn map10(self) -> &'a mut W {
                self.variant(C7S_A::MAP10)
            }
            ///Mapping 11
            #[inline(always)]
            pub fn map11(self) -> &'a mut W {
                self.variant(C7S_A::MAP11)
            }
            ///Mapping 12
            #[inline(always)]
            pub fn map12(self) -> &'a mut W {
                self.variant(C7S_A::MAP12)
            }
            ///Mapping 13
            #[inline(always)]
            pub fn map13(self) -> &'a mut W {
                self.variant(C7S_A::MAP13)
            }
            ///Mapping 14
            #[inline(always)]
            pub fn map14(self) -> &'a mut W {
                self.variant(C7S_A::MAP14)
            }
            ///Mapping 15
            #[inline(always)]
            pub fn map15(self) -> &'a mut W {
                self.variant(C7S_A::MAP15)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 20)) | (((value as u32) & 0x0f) << 20);
                self.w
            }
        }
        ///DMA channel 5 selection
        pub type C5S_A = C7S_A;
        ///Reader of field `C5S`
        pub type C5S_R = crate::R<u8, C7S_A>;
        ///Write proxy for field `C5S`
        pub struct C5S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C5S_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: C5S_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Default mapping
            #[inline(always)]
            pub fn no_mapping(self) -> &'a mut W {
                self.variant(C7S_A::NOMAPPING)
            }
            ///Mapping 1
            #[inline(always)]
            pub fn map1(self) -> &'a mut W {
                self.variant(C7S_A::MAP1)
            }
            ///Mapping 2
            #[inline(always)]
            pub fn map2(self) -> &'a mut W {
                self.variant(C7S_A::MAP2)
            }
            ///Mapping 3
            #[inline(always)]
            pub fn map3(self) -> &'a mut W {
                self.variant(C7S_A::MAP3)
            }
            ///Mapping 4
            #[inline(always)]
            pub fn map4(self) -> &'a mut W {
                self.variant(C7S_A::MAP4)
            }
            ///Mapping 5
            #[inline(always)]
            pub fn map5(self) -> &'a mut W {
                self.variant(C7S_A::MAP5)
            }
            ///Mapping 6
            #[inline(always)]
            pub fn map6(self) -> &'a mut W {
                self.variant(C7S_A::MAP6)
            }
            ///Mapping 7
            #[inline(always)]
            pub fn map7(self) -> &'a mut W {
                self.variant(C7S_A::MAP7)
            }
            ///Mapping 8
            #[inline(always)]
            pub fn map8(self) -> &'a mut W {
                self.variant(C7S_A::MAP8)
            }
            ///Mapping 9
            #[inline(always)]
            pub fn map9(self) -> &'a mut W {
                self.variant(C7S_A::MAP9)
            }
            ///Mapping 10
            #[inline(always)]
            pub fn map10(self) -> &'a mut W {
                self.variant(C7S_A::MAP10)
            }
            ///Mapping 11
            #[inline(always)]
            pub fn map11(self) -> &'a mut W {
                self.variant(C7S_A::MAP11)
            }
            ///Mapping 12
            #[inline(always)]
            pub fn map12(self) -> &'a mut W {
                self.variant(C7S_A::MAP12)
            }
            ///Mapping 13
            #[inline(always)]
            pub fn map13(self) -> &'a mut W {
                self.variant(C7S_A::MAP13)
            }
            ///Mapping 14
            #[inline(always)]
            pub fn map14(self) -> &'a mut W {
                self.variant(C7S_A::MAP14)
            }
            ///Mapping 15
            #[inline(always)]
            pub fn map15(self) -> &'a mut W {
                self.variant(C7S_A::MAP15)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 16)) | (((value as u32) & 0x0f) << 16);
                self.w
            }
        }
        ///DMA channel 4 selection
        pub type C4S_A = C7S_A;
        ///Reader of field `C4S`
        pub type C4S_R = crate::R<u8, C7S_A>;
        ///Write proxy for field `C4S`
        pub struct C4S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C4S_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: C4S_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Default mapping
            #[inline(always)]
            pub fn no_mapping(self) -> &'a mut W {
                self.variant(C7S_A::NOMAPPING)
            }
            ///Mapping 1
            #[inline(always)]
            pub fn map1(self) -> &'a mut W {
                self.variant(C7S_A::MAP1)
            }
            ///Mapping 2
            #[inline(always)]
            pub fn map2(self) -> &'a mut W {
                self.variant(C7S_A::MAP2)
            }
            ///Mapping 3
            #[inline(always)]
            pub fn map3(self) -> &'a mut W {
                self.variant(C7S_A::MAP3)
            }
            ///Mapping 4
            #[inline(always)]
            pub fn map4(self) -> &'a mut W {
                self.variant(C7S_A::MAP4)
            }
            ///Mapping 5
            #[inline(always)]
            pub fn map5(self) -> &'a mut W {
                self.variant(C7S_A::MAP5)
            }
            ///Mapping 6
            #[inline(always)]
            pub fn map6(self) -> &'a mut W {
                self.variant(C7S_A::MAP6)
            }
            ///Mapping 7
            #[inline(always)]
            pub fn map7(self) -> &'a mut W {
                self.variant(C7S_A::MAP7)
            }
            ///Mapping 8
            #[inline(always)]
            pub fn map8(self) -> &'a mut W {
                self.variant(C7S_A::MAP8)
            }
            ///Mapping 9
            #[inline(always)]
            pub fn map9(self) -> &'a mut W {
                self.variant(C7S_A::MAP9)
            }
            ///Mapping 10
            #[inline(always)]
            pub fn map10(self) -> &'a mut W {
                self.variant(C7S_A::MAP10)
            }
            ///Mapping 11
            #[inline(always)]
            pub fn map11(self) -> &'a mut W {
                self.variant(C7S_A::MAP11)
            }
            ///Mapping 12
            #[inline(always)]
            pub fn map12(self) -> &'a mut W {
                self.variant(C7S_A::MAP12)
            }
            ///Mapping 13
            #[inline(always)]
            pub fn map13(self) -> &'a mut W {
                self.variant(C7S_A::MAP13)
            }
            ///Mapping 14
            #[inline(always)]
            pub fn map14(self) -> &'a mut W {
                self.variant(C7S_A::MAP14)
            }
            ///Mapping 15
            #[inline(always)]
            pub fn map15(self) -> &'a mut W {
                self.variant(C7S_A::MAP15)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 12)) | (((value as u32) & 0x0f) << 12);
                self.w
            }
        }
        ///DMA channel 3 selection
        pub type C3S_A = C7S_A;
        ///Reader of field `C3S`
        pub type C3S_R = crate::R<u8, C7S_A>;
        ///Write proxy for field `C3S`
        pub struct C3S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C3S_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: C3S_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Default mapping
            #[inline(always)]
            pub fn no_mapping(self) -> &'a mut W {
                self.variant(C7S_A::NOMAPPING)
            }
            ///Mapping 1
            #[inline(always)]
            pub fn map1(self) -> &'a mut W {
                self.variant(C7S_A::MAP1)
            }
            ///Mapping 2
            #[inline(always)]
            pub fn map2(self) -> &'a mut W {
                self.variant(C7S_A::MAP2)
            }
            ///Mapping 3
            #[inline(always)]
            pub fn map3(self) -> &'a mut W {
                self.variant(C7S_A::MAP3)
            }
            ///Mapping 4
            #[inline(always)]
            pub fn map4(self) -> &'a mut W {
                self.variant(C7S_A::MAP4)
            }
            ///Mapping 5
            #[inline(always)]
            pub fn map5(self) -> &'a mut W {
                self.variant(C7S_A::MAP5)
            }
            ///Mapping 6
            #[inline(always)]
            pub fn map6(self) -> &'a mut W {
                self.variant(C7S_A::MAP6)
            }
            ///Mapping 7
            #[inline(always)]
            pub fn map7(self) -> &'a mut W {
                self.variant(C7S_A::MAP7)
            }
            ///Mapping 8
            #[inline(always)]
            pub fn map8(self) -> &'a mut W {
                self.variant(C7S_A::MAP8)
            }
            ///Mapping 9
            #[inline(always)]
            pub fn map9(self) -> &'a mut W {
                self.variant(C7S_A::MAP9)
            }
            ///Mapping 10
            #[inline(always)]
            pub fn map10(self) -> &'a mut W {
                self.variant(C7S_A::MAP10)
            }
            ///Mapping 11
            #[inline(always)]
            pub fn map11(self) -> &'a mut W {
                self.variant(C7S_A::MAP11)
            }
            ///Mapping 12
            #[inline(always)]
            pub fn map12(self) -> &'a mut W {
                self.variant(C7S_A::MAP12)
            }
            ///Mapping 13
            #[inline(always)]
            pub fn map13(self) -> &'a mut W {
                self.variant(C7S_A::MAP13)
            }
            ///Mapping 14
            #[inline(always)]
            pub fn map14(self) -> &'a mut W {
                self.variant(C7S_A::MAP14)
            }
            ///Mapping 15
            #[inline(always)]
            pub fn map15(self) -> &'a mut W {
                self.variant(C7S_A::MAP15)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 8)) | (((value as u32) & 0x0f) << 8);
                self.w
            }
        }
        ///DMA channel 2 selection
        pub type C2S_A = C7S_A;
        ///Reader of field `C2S`
        pub type C2S_R = crate::R<u8, C7S_A>;
        ///Write proxy for field `C2S`
        pub struct C2S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C2S_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: C2S_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Default mapping
            #[inline(always)]
            pub fn no_mapping(self) -> &'a mut W {
                self.variant(C7S_A::NOMAPPING)
            }
            ///Mapping 1
            #[inline(always)]
            pub fn map1(self) -> &'a mut W {
                self.variant(C7S_A::MAP1)
            }
            ///Mapping 2
            #[inline(always)]
            pub fn map2(self) -> &'a mut W {
                self.variant(C7S_A::MAP2)
            }
            ///Mapping 3
            #[inline(always)]
            pub fn map3(self) -> &'a mut W {
                self.variant(C7S_A::MAP3)
            }
            ///Mapping 4
            #[inline(always)]
            pub fn map4(self) -> &'a mut W {
                self.variant(C7S_A::MAP4)
            }
            ///Mapping 5
            #[inline(always)]
            pub fn map5(self) -> &'a mut W {
                self.variant(C7S_A::MAP5)
            }
            ///Mapping 6
            #[inline(always)]
            pub fn map6(self) -> &'a mut W {
                self.variant(C7S_A::MAP6)
            }
            ///Mapping 7
            #[inline(always)]
            pub fn map7(self) -> &'a mut W {
                self.variant(C7S_A::MAP7)
            }
            ///Mapping 8
            #[inline(always)]
            pub fn map8(self) -> &'a mut W {
                self.variant(C7S_A::MAP8)
            }
            ///Mapping 9
            #[inline(always)]
            pub fn map9(self) -> &'a mut W {
                self.variant(C7S_A::MAP9)
            }
            ///Mapping 10
            #[inline(always)]
            pub fn map10(self) -> &'a mut W {
                self.variant(C7S_A::MAP10)
            }
            ///Mapping 11
            #[inline(always)]
            pub fn map11(self) -> &'a mut W {
                self.variant(C7S_A::MAP11)
            }
            ///Mapping 12
            #[inline(always)]
            pub fn map12(self) -> &'a mut W {
                self.variant(C7S_A::MAP12)
            }
            ///Mapping 13
            #[inline(always)]
            pub fn map13(self) -> &'a mut W {
                self.variant(C7S_A::MAP13)
            }
            ///Mapping 14
            #[inline(always)]
            pub fn map14(self) -> &'a mut W {
                self.variant(C7S_A::MAP14)
            }
            ///Mapping 15
            #[inline(always)]
            pub fn map15(self) -> &'a mut W {
                self.variant(C7S_A::MAP15)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 4)) | (((value as u32) & 0x0f) << 4);
                self.w
            }
        }
        ///DMA channel 1 selection
        pub type C1S_A = C7S_A;
        ///Reader of field `C1S`
        pub type C1S_R = crate::R<u8, C7S_A>;
        ///Write proxy for field `C1S`
        pub struct C1S_W<'a> {
            w: &'a mut W,
        }
        impl<'a> C1S_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: C1S_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Default mapping
            #[inline(always)]
            pub fn no_mapping(self) -> &'a mut W {
                self.variant(C7S_A::NOMAPPING)
            }
            ///Mapping 1
            #[inline(always)]
            pub fn map1(self) -> &'a mut W {
                self.variant(C7S_A::MAP1)
            }
            ///Mapping 2
            #[inline(always)]
            pub fn map2(self) -> &'a mut W {
                self.variant(C7S_A::MAP2)
            }
            ///Mapping 3
            #[inline(always)]
            pub fn map3(self) -> &'a mut W {
                self.variant(C7S_A::MAP3)
            }
            ///Mapping 4
            #[inline(always)]
            pub fn map4(self) -> &'a mut W {
                self.variant(C7S_A::MAP4)
            }
            ///Mapping 5
            #[inline(always)]
            pub fn map5(self) -> &'a mut W {
                self.variant(C7S_A::MAP5)
            }
            ///Mapping 6
            #[inline(always)]
            pub fn map6(self) -> &'a mut W {
                self.variant(C7S_A::MAP6)
            }
            ///Mapping 7
            #[inline(always)]
            pub fn map7(self) -> &'a mut W {
                self.variant(C7S_A::MAP7)
            }
            ///Mapping 8
            #[inline(always)]
            pub fn map8(self) -> &'a mut W {
                self.variant(C7S_A::MAP8)
            }
            ///Mapping 9
            #[inline(always)]
            pub fn map9(self) -> &'a mut W {
                self.variant(C7S_A::MAP9)
            }
            ///Mapping 10
            #[inline(always)]
            pub fn map10(self) -> &'a mut W {
                self.variant(C7S_A::MAP10)
            }
            ///Mapping 11
            #[inline(always)]
            pub fn map11(self) -> &'a mut W {
                self.variant(C7S_A::MAP11)
            }
            ///Mapping 12
            #[inline(always)]
            pub fn map12(self) -> &'a mut W {
                self.variant(C7S_A::MAP12)
            }
            ///Mapping 13
            #[inline(always)]
            pub fn map13(self) -> &'a mut W {
                self.variant(C7S_A::MAP13)
            }
            ///Mapping 14
            #[inline(always)]
            pub fn map14(self) -> &'a mut W {
                self.variant(C7S_A::MAP14)
            }
            ///Mapping 15
            #[inline(always)]
            pub fn map15(self) -> &'a mut W {
                self.variant(C7S_A::MAP15)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | ((value as u32) & 0x0f);
                self.w
            }
        }
        impl R {
            ///Bits 24:27 - DMA channel 7 selection
            #[inline(always)]
            pub fn c7s(&self) -> C7S_R {
                C7S_R::new(((self.bits >> 24) & 0x0f) as u8)
            }
            ///Bits 20:23 - DMA channel 6 selection
            #[inline(always)]
            pub fn c6s(&self) -> C6S_R {
                C6S_R::new(((self.bits >> 20) & 0x0f) as u8)
            }
            ///Bits 16:19 - DMA channel 5 selection
            #[inline(always)]
            pub fn c5s(&self) -> C5S_R {
                C5S_R::new(((self.bits >> 16) & 0x0f) as u8)
            }
            ///Bits 12:15 - DMA channel 4 selection
            #[inline(always)]
            pub fn c4s(&self) -> C4S_R {
                C4S_R::new(((self.bits >> 12) & 0x0f) as u8)
            }
            ///Bits 8:11 - DMA channel 3 selection
            #[inline(always)]
            pub fn c3s(&self) -> C3S_R {
                C3S_R::new(((self.bits >> 8) & 0x0f) as u8)
            }
            ///Bits 4:7 - DMA channel 2 selection
            #[inline(always)]
            pub fn c2s(&self) -> C2S_R {
                C2S_R::new(((self.bits >> 4) & 0x0f) as u8)
            }
            ///Bits 0:3 - DMA channel 1 selection
            #[inline(always)]
            pub fn c1s(&self) -> C1S_R {
                C1S_R::new((self.bits & 0x0f) as u8)
            }
        }
        impl W {
            ///Bits 24:27 - DMA channel 7 selection
            #[inline(always)]
            pub fn c7s(&mut self) -> C7S_W {
                C7S_W { w: self }
            }
            ///Bits 20:23 - DMA channel 6 selection
            #[inline(always)]
            pub fn c6s(&mut self) -> C6S_W {
                C6S_W { w: self }
            }
            ///Bits 16:19 - DMA channel 5 selection
            #[inline(always)]
            pub fn c5s(&mut self) -> C5S_W {
                C5S_W { w: self }
            }
            ///Bits 12:15 - DMA channel 4 selection
            #[inline(always)]
            pub fn c4s(&mut self) -> C4S_W {
                C4S_W { w: self }
            }
            ///Bits 8:11 - DMA channel 3 selection
            #[inline(always)]
            pub fn c3s(&mut self) -> C3S_W {
                C3S_W { w: self }
            }
            ///Bits 4:7 - DMA channel 2 selection
            #[inline(always)]
            pub fn c2s(&mut self) -> C2S_W {
                C2S_W { w: self }
            }
            ///Bits 0:3 - DMA channel 1 selection
            #[inline(always)]
            pub fn c1s(&mut self) -> C1S_W {
                C1S_W { w: self }
            }
        }
    }
}
///Direct memory access controller
pub struct DMA2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA2 {}
impl DMA2 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dma1::RegisterBlock {
        0x4002_0400 as *const _
    }
}
impl Deref for DMA2 {
    type Target = dma1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DMA2::ptr() }
    }
}
///Cyclic redundancy check calculation unit
pub struct CRC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRC {}
impl CRC {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const crc::RegisterBlock {
        0x4002_3000 as *const _
    }
}
impl Deref for CRC {
    type Target = crc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*CRC::ptr() }
    }
}
///Cyclic redundancy check calculation unit
pub mod crc {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        _reserved_0_dr: [u8; 4usize],
        ///0x04 - Independent data register
        pub idr: IDR,
        ///0x08 - Control register
        pub cr: CR,
        _reserved3: [u8; 4usize],
        ///0x10 - Initial CRC value
        pub init: INIT,
        ///0x14 - polynomial
        pub pol: POL,
    }
    impl RegisterBlock {
        ///0x00 - Data register - half-word sized
        #[inline(always)]
        pub fn dr16(&self) -> &DR16 {
            unsafe { &*(((self as *const Self) as *const u8).add(0usize) as *const DR16) }
        }
        ///0x00 - Data register - half-word sized
        #[inline(always)]
        pub fn dr16_mut(&self) -> &mut DR16 {
            unsafe { &mut *(((self as *const Self) as *mut u8).add(0usize) as *mut DR16) }
        }
        ///0x00 - Data register - byte sized
        #[inline(always)]
        pub fn dr8(&self) -> &DR8 {
            unsafe { &*(((self as *const Self) as *const u8).add(0usize) as *const DR8) }
        }
        ///0x00 - Data register - byte sized
        #[inline(always)]
        pub fn dr8_mut(&self) -> &mut DR8 {
            unsafe { &mut *(((self as *const Self) as *mut u8).add(0usize) as *mut DR8) }
        }
        ///0x00 - Data register
        #[inline(always)]
        pub fn dr(&self) -> &DR {
            unsafe { &*(((self as *const Self) as *const u8).add(0usize) as *const DR) }
        }
        ///0x00 - Data register
        #[inline(always)]
        pub fn dr_mut(&self) -> &mut DR {
            unsafe { &mut *(((self as *const Self) as *mut u8).add(0usize) as *mut DR) }
        }
    }
    ///Data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dr](dr) module
    pub type DR = crate::Reg<u32, _DR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DR;
    ///`read()` method returns [dr::R](dr::R) reader structure
    impl crate::Readable for DR {}
    ///`write(|w| ..)` method takes [dr::W](dr::W) writer structure
    impl crate::Writable for DR {}
    ///Data register
    pub mod dr {
        ///Reader of register DR
        pub type R = crate::R<u32, super::DR>;
        ///Writer for register DR
        pub type W = crate::W<u32, super::DR>;
        ///Register DR `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::DR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `DR`
        pub type DR_R = crate::R<u32, u32>;
        ///Write proxy for field `DR`
        pub struct DR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Data register bits
            #[inline(always)]
            pub fn dr(&self) -> DR_R {
                DR_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Data register bits
            #[inline(always)]
            pub fn dr(&mut self) -> DR_W {
                DR_W { w: self }
            }
        }
    }
    ///Independent data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [idr](idr) module
    pub type IDR = crate::Reg<u32, _IDR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IDR;
    ///`read()` method returns [idr::R](idr::R) reader structure
    impl crate::Readable for IDR {}
    ///`write(|w| ..)` method takes [idr::W](idr::W) writer structure
    impl crate::Writable for IDR {}
    ///Independent data register
    pub mod idr {
        ///Reader of register IDR
        pub type R = crate::R<u32, super::IDR>;
        ///Writer for register IDR
        pub type W = crate::W<u32, super::IDR>;
        ///Register IDR `reset()`'s with value 0
        impl crate::ResetValue for super::IDR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `IDR`
        pub type IDR_R = crate::R<u8, u8>;
        ///Write proxy for field `IDR`
        pub struct IDR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IDR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - General-purpose 8-bit data register bits
            #[inline(always)]
            pub fn idr(&self) -> IDR_R {
                IDR_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - General-purpose 8-bit data register bits
            #[inline(always)]
            pub fn idr(&mut self) -> IDR_W {
                IDR_W { w: self }
            }
        }
    }
    ///Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///Control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reverse output data
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum REV_OUT_A {
            ///0: Bit order not affected
            NORMAL = 0,
            ///1: Bit reversed output
            REVERSED = 1,
        }
        impl From<REV_OUT_A> for bool {
            #[inline(always)]
            fn from(variant: REV_OUT_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `REV_OUT`
        pub type REV_OUT_R = crate::R<bool, REV_OUT_A>;
        impl REV_OUT_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> REV_OUT_A {
                match self.bits {
                    false => REV_OUT_A::NORMAL,
                    true => REV_OUT_A::REVERSED,
                }
            }
            ///Checks if the value of the field is `NORMAL`
            #[inline(always)]
            pub fn is_normal(&self) -> bool {
                *self == REV_OUT_A::NORMAL
            }
            ///Checks if the value of the field is `REVERSED`
            #[inline(always)]
            pub fn is_reversed(&self) -> bool {
                *self == REV_OUT_A::REVERSED
            }
        }
        ///Write proxy for field `REV_OUT`
        pub struct REV_OUT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> REV_OUT_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: REV_OUT_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Bit order not affected
            #[inline(always)]
            pub fn normal(self) -> &'a mut W {
                self.variant(REV_OUT_A::NORMAL)
            }
            ///Bit reversed output
            #[inline(always)]
            pub fn reversed(self) -> &'a mut W {
                self.variant(REV_OUT_A::REVERSED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reverse input data
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum REV_IN_A {
            ///0: Bit order not affected
            NORMAL = 0,
            ///1: Bit reversal done by byte
            BYTE = 1,
            ///2: Bit reversal done by half-word
            HALFWORD = 2,
            ///3: Bit reversal done by word
            WORD = 3,
        }
        impl From<REV_IN_A> for u8 {
            #[inline(always)]
            fn from(variant: REV_IN_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `REV_IN`
        pub type REV_IN_R = crate::R<u8, REV_IN_A>;
        impl REV_IN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> REV_IN_A {
                match self.bits {
                    0 => REV_IN_A::NORMAL,
                    1 => REV_IN_A::BYTE,
                    2 => REV_IN_A::HALFWORD,
                    3 => REV_IN_A::WORD,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `NORMAL`
            #[inline(always)]
            pub fn is_normal(&self) -> bool {
                *self == REV_IN_A::NORMAL
            }
            ///Checks if the value of the field is `BYTE`
            #[inline(always)]
            pub fn is_byte(&self) -> bool {
                *self == REV_IN_A::BYTE
            }
            ///Checks if the value of the field is `HALFWORD`
            #[inline(always)]
            pub fn is_half_word(&self) -> bool {
                *self == REV_IN_A::HALFWORD
            }
            ///Checks if the value of the field is `WORD`
            #[inline(always)]
            pub fn is_word(&self) -> bool {
                *self == REV_IN_A::WORD
            }
        }
        ///Write proxy for field `REV_IN`
        pub struct REV_IN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> REV_IN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: REV_IN_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Bit order not affected
            #[inline(always)]
            pub fn normal(self) -> &'a mut W {
                self.variant(REV_IN_A::NORMAL)
            }
            ///Bit reversal done by byte
            #[inline(always)]
            pub fn byte(self) -> &'a mut W {
                self.variant(REV_IN_A::BYTE)
            }
            ///Bit reversal done by half-word
            #[inline(always)]
            pub fn half_word(self) -> &'a mut W {
                self.variant(REV_IN_A::HALFWORD)
            }
            ///Bit reversal done by word
            #[inline(always)]
            pub fn word(self) -> &'a mut W {
                self.variant(REV_IN_A::WORD)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 5)) | (((value as u32) & 0x03) << 5);
                self.w
            }
        }
        ///Polynomial size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum POLYSIZE_A {
            ///0: 32-bit polynomial
            POLYSIZE32 = 0,
            ///1: 16-bit polynomial
            POLYSIZE16 = 1,
            ///2: 8-bit polynomial
            POLYSIZE8 = 2,
            ///3: 7-bit polynomial
            POLYSIZE7 = 3,
        }
        impl From<POLYSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: POLYSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `POLYSIZE`
        pub type POLYSIZE_R = crate::R<u8, POLYSIZE_A>;
        impl POLYSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> POLYSIZE_A {
                match self.bits {
                    0 => POLYSIZE_A::POLYSIZE32,
                    1 => POLYSIZE_A::POLYSIZE16,
                    2 => POLYSIZE_A::POLYSIZE8,
                    3 => POLYSIZE_A::POLYSIZE7,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `POLYSIZE32`
            #[inline(always)]
            pub fn is_polysize32(&self) -> bool {
                *self == POLYSIZE_A::POLYSIZE32
            }
            ///Checks if the value of the field is `POLYSIZE16`
            #[inline(always)]
            pub fn is_polysize16(&self) -> bool {
                *self == POLYSIZE_A::POLYSIZE16
            }
            ///Checks if the value of the field is `POLYSIZE8`
            #[inline(always)]
            pub fn is_polysize8(&self) -> bool {
                *self == POLYSIZE_A::POLYSIZE8
            }
            ///Checks if the value of the field is `POLYSIZE7`
            #[inline(always)]
            pub fn is_polysize7(&self) -> bool {
                *self == POLYSIZE_A::POLYSIZE7
            }
        }
        ///Write proxy for field `POLYSIZE`
        pub struct POLYSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> POLYSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: POLYSIZE_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///32-bit polynomial
            #[inline(always)]
            pub fn polysize32(self) -> &'a mut W {
                self.variant(POLYSIZE_A::POLYSIZE32)
            }
            ///16-bit polynomial
            #[inline(always)]
            pub fn polysize16(self) -> &'a mut W {
                self.variant(POLYSIZE_A::POLYSIZE16)
            }
            ///8-bit polynomial
            #[inline(always)]
            pub fn polysize8(self) -> &'a mut W {
                self.variant(POLYSIZE_A::POLYSIZE8)
            }
            ///7-bit polynomial
            #[inline(always)]
            pub fn polysize7(self) -> &'a mut W {
                self.variant(POLYSIZE_A::POLYSIZE7)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 3)) | (((value as u32) & 0x03) << 3);
                self.w
            }
        }
        ///RESET bit
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum RESET_AW {
            ///1: Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
            RESET = 1,
        }
        impl From<RESET_AW> for bool {
            #[inline(always)]
            fn from(variant: RESET_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `RESET`
        pub struct RESET_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RESET_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: RESET_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
            #[inline(always)]
            pub fn reset(self) -> &'a mut W {
                self.variant(RESET_AW::RESET)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 7 - Reverse output data
            #[inline(always)]
            pub fn rev_out(&self) -> REV_OUT_R {
                REV_OUT_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bits 5:6 - Reverse input data
            #[inline(always)]
            pub fn rev_in(&self) -> REV_IN_R {
                REV_IN_R::new(((self.bits >> 5) & 0x03) as u8)
            }
            ///Bits 3:4 - Polynomial size
            #[inline(always)]
            pub fn polysize(&self) -> POLYSIZE_R {
                POLYSIZE_R::new(((self.bits >> 3) & 0x03) as u8)
            }
        }
        impl W {
            ///Bit 7 - Reverse output data
            #[inline(always)]
            pub fn rev_out(&mut self) -> REV_OUT_W {
                REV_OUT_W { w: self }
            }
            ///Bits 5:6 - Reverse input data
            #[inline(always)]
            pub fn rev_in(&mut self) -> REV_IN_W {
                REV_IN_W { w: self }
            }
            ///Bits 3:4 - Polynomial size
            #[inline(always)]
            pub fn polysize(&mut self) -> POLYSIZE_W {
                POLYSIZE_W { w: self }
            }
            ///Bit 0 - RESET bit
            #[inline(always)]
            pub fn reset(&mut self) -> RESET_W {
                RESET_W { w: self }
            }
        }
    }
    ///Initial CRC value
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [init](init) module
    pub type INIT = crate::Reg<u32, _INIT>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _INIT;
    ///`read()` method returns [init::R](init::R) reader structure
    impl crate::Readable for INIT {}
    ///`write(|w| ..)` method takes [init::W](init::W) writer structure
    impl crate::Writable for INIT {}
    ///Initial CRC value
    pub mod init {
        ///Reader of register INIT
        pub type R = crate::R<u32, super::INIT>;
        ///Writer for register INIT
        pub type W = crate::W<u32, super::INIT>;
        ///Register INIT `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::INIT {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `INIT`
        pub type INIT_R = crate::R<u32, u32>;
        ///Write proxy for field `INIT`
        pub struct INIT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> INIT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Programmable initial CRC value
            #[inline(always)]
            pub fn init(&self) -> INIT_R {
                INIT_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Programmable initial CRC value
            #[inline(always)]
            pub fn init(&mut self) -> INIT_W {
                INIT_W { w: self }
            }
        }
    }
    ///polynomial
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [pol](pol) module
    pub type POL = crate::Reg<u32, _POL>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _POL;
    ///`read()` method returns [pol::R](pol::R) reader structure
    impl crate::Readable for POL {}
    ///`write(|w| ..)` method takes [pol::W](pol::W) writer structure
    impl crate::Writable for POL {}
    ///polynomial
    pub mod pol {
        ///Reader of register POL
        pub type R = crate::R<u32, super::POL>;
        ///Writer for register POL
        pub type W = crate::W<u32, super::POL>;
        ///Register POL `reset()`'s with value 0x04c1_1db7
        impl crate::ResetValue for super::POL {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x04c1_1db7
            }
        }
        ///Reader of field `Polynomialcoefficients`
        pub type POLYNOMIALCOEFFICIENTS_R = crate::R<u32, u32>;
        ///Write proxy for field `Polynomialcoefficients`
        pub struct POLYNOMIALCOEFFICIENTS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> POLYNOMIALCOEFFICIENTS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Programmable polynomial
            #[inline(always)]
            pub fn polynomialcoefficients(&self) -> POLYNOMIALCOEFFICIENTS_R {
                POLYNOMIALCOEFFICIENTS_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Programmable polynomial
            #[inline(always)]
            pub fn polynomialcoefficients(&mut self) -> POLYNOMIALCOEFFICIENTS_W {
                POLYNOMIALCOEFFICIENTS_W { w: self }
            }
        }
    }
    ///Data register - byte sized
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dr8](dr8) module
    pub type DR8 = crate::Reg<u8, _DR8>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DR8;
    ///`read()` method returns [dr8::R](dr8::R) reader structure
    impl crate::Readable for DR8 {}
    ///`write(|w| ..)` method takes [dr8::W](dr8::W) writer structure
    impl crate::Writable for DR8 {}
    ///Data register - byte sized
    pub mod dr8 {
        ///Reader of register DR8
        pub type R = crate::R<u8, super::DR8>;
        ///Writer for register DR8
        pub type W = crate::W<u8, super::DR8>;
        ///Register DR8 `reset()`'s with value 0xff
        impl crate::ResetValue for super::DR8 {
            type Type = u8;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xff
            }
        }
        ///Reader of field `DR8`
        pub type DR8_R = crate::R<u8, u8>;
        ///Write proxy for field `DR8`
        pub struct DR8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DR8_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u8) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Data register bits
            #[inline(always)]
            pub fn dr8(&self) -> DR8_R {
                DR8_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Data register bits
            #[inline(always)]
            pub fn dr8(&mut self) -> DR8_W {
                DR8_W { w: self }
            }
        }
    }
    ///Data register - half-word sized
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dr16](dr16) module
    pub type DR16 = crate::Reg<u16, _DR16>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DR16;
    ///`read()` method returns [dr16::R](dr16::R) reader structure
    impl crate::Readable for DR16 {}
    ///`write(|w| ..)` method takes [dr16::W](dr16::W) writer structure
    impl crate::Writable for DR16 {}
    ///Data register - half-word sized
    pub mod dr16 {
        ///Reader of register DR16
        pub type R = crate::R<u16, super::DR16>;
        ///Writer for register DR16
        pub type W = crate::W<u16, super::DR16>;
        ///Register DR16 `reset()`'s with value 0xffff
        impl crate::ResetValue for super::DR16 {
            type Type = u16;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff
            }
        }
        ///Reader of field `DR16`
        pub type DR16_R = crate::R<u16, u16>;
        ///Write proxy for field `DR16`
        pub struct DR16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DR16_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u16) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Data register bits
            #[inline(always)]
            pub fn dr16(&self) -> DR16_R {
                DR16_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Data register bits
            #[inline(always)]
            pub fn dr16(&mut self) -> DR16_W {
                DR16_W { w: self }
            }
        }
    }
}
///Liquid crystal display controller
pub struct LCD {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LCD {}
impl LCD {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const lcd::RegisterBlock {
        0x4000_2400 as *const _
    }
}
impl Deref for LCD {
    type Target = lcd::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*LCD::ptr() }
    }
}
///Liquid crystal display controller
pub mod lcd {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - control register
        pub cr: CR,
        ///0x04 - frame control register
        pub fcr: FCR,
        ///0x08 - status register
        pub sr: SR,
        ///0x0c - clear register
        pub clr: CLR,
        _reserved4: [u8; 4usize],
        ///0x14 - display memory
        pub ram_com0: RAM_COM0,
        _reserved5: [u8; 4usize],
        ///0x1c - display memory
        pub ram_com1: RAM_COM1,
        _reserved6: [u8; 4usize],
        ///0x24 - display memory
        pub ram_com2: RAM_COM2,
        _reserved7: [u8; 4usize],
        ///0x2c - display memory
        pub ram_com3: RAM_COM3,
        _reserved8: [u8; 4usize],
        ///0x34 - display memory
        pub ram_com4: RAM_COM4,
        _reserved9: [u8; 4usize],
        ///0x3c - display memory
        pub ram_com5: RAM_COM5,
        _reserved10: [u8; 4usize],
        ///0x44 - display memory
        pub ram_com6: RAM_COM6,
        _reserved11: [u8; 4usize],
        ///0x4c - display memory
        pub ram_com7: RAM_COM7,
    }
    ///control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `BIAS`
        pub type BIAS_R = crate::R<u8, u8>;
        ///Write proxy for field `BIAS`
        pub struct BIAS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BIAS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 5)) | (((value as u32) & 0x03) << 5);
                self.w
            }
        }
        ///Reader of field `DUTY`
        pub type DUTY_R = crate::R<u8, u8>;
        ///Write proxy for field `DUTY`
        pub struct DUTY_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DUTY_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 2)) | (((value as u32) & 0x07) << 2);
                self.w
            }
        }
        ///Reader of field `VSEL`
        pub type VSEL_R = crate::R<bool, bool>;
        ///Write proxy for field `VSEL`
        pub struct VSEL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> VSEL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `LCDEN`
        pub type LCDEN_R = crate::R<bool, bool>;
        ///Write proxy for field `LCDEN`
        pub struct LCDEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LCDEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `MUX_SEG`
        pub type MUX_SEG_R = crate::R<bool, bool>;
        ///Write proxy for field `MUX_SEG`
        pub struct MUX_SEG_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MUX_SEG_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `BUFEN`
        pub type BUFEN_R = crate::R<bool, bool>;
        ///Write proxy for field `BUFEN`
        pub struct BUFEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BUFEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        impl R {
            ///Bits 5:6 - Bias selector
            #[inline(always)]
            pub fn bias(&self) -> BIAS_R {
                BIAS_R::new(((self.bits >> 5) & 0x03) as u8)
            }
            ///Bits 2:4 - Duty selection
            #[inline(always)]
            pub fn duty(&self) -> DUTY_R {
                DUTY_R::new(((self.bits >> 2) & 0x07) as u8)
            }
            ///Bit 1 - Voltage source selection
            #[inline(always)]
            pub fn vsel(&self) -> VSEL_R {
                VSEL_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - LCD controller enable
            #[inline(always)]
            pub fn lcden(&self) -> LCDEN_R {
                LCDEN_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 7 - Mux segment enable
            #[inline(always)]
            pub fn mux_seg(&self) -> MUX_SEG_R {
                MUX_SEG_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 8 - Voltage output buffer enable
            #[inline(always)]
            pub fn bufen(&self) -> BUFEN_R {
                BUFEN_R::new(((self.bits >> 8) & 0x01) != 0)
            }
        }
        impl W {
            ///Bits 5:6 - Bias selector
            #[inline(always)]
            pub fn bias(&mut self) -> BIAS_W {
                BIAS_W { w: self }
            }
            ///Bits 2:4 - Duty selection
            #[inline(always)]
            pub fn duty(&mut self) -> DUTY_W {
                DUTY_W { w: self }
            }
            ///Bit 1 - Voltage source selection
            #[inline(always)]
            pub fn vsel(&mut self) -> VSEL_W {
                VSEL_W { w: self }
            }
            ///Bit 0 - LCD controller enable
            #[inline(always)]
            pub fn lcden(&mut self) -> LCDEN_W {
                LCDEN_W { w: self }
            }
            ///Bit 7 - Mux segment enable
            #[inline(always)]
            pub fn mux_seg(&mut self) -> MUX_SEG_W {
                MUX_SEG_W { w: self }
            }
            ///Bit 8 - Voltage output buffer enable
            #[inline(always)]
            pub fn bufen(&mut self) -> BUFEN_W {
                BUFEN_W { w: self }
            }
        }
    }
    ///frame control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [fcr](fcr) module
    pub type FCR = crate::Reg<u32, _FCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _FCR;
    ///`read()` method returns [fcr::R](fcr::R) reader structure
    impl crate::Readable for FCR {}
    ///`write(|w| ..)` method takes [fcr::W](fcr::W) writer structure
    impl crate::Writable for FCR {}
    ///frame control register
    pub mod fcr {
        ///Reader of register FCR
        pub type R = crate::R<u32, super::FCR>;
        ///Writer for register FCR
        pub type W = crate::W<u32, super::FCR>;
        ///Register FCR `reset()`'s with value 0
        impl crate::ResetValue for super::FCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PS`
        pub type PS_R = crate::R<u8, u8>;
        ///Write proxy for field `PS`
        pub struct PS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 22)) | (((value as u32) & 0x0f) << 22);
                self.w
            }
        }
        ///Reader of field `DIV`
        pub type DIV_R = crate::R<u8, u8>;
        ///Write proxy for field `DIV`
        pub struct DIV_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIV_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 18)) | (((value as u32) & 0x0f) << 18);
                self.w
            }
        }
        ///Reader of field `BLINK`
        pub type BLINK_R = crate::R<u8, u8>;
        ///Write proxy for field `BLINK`
        pub struct BLINK_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BLINK_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 16)) | (((value as u32) & 0x03) << 16);
                self.w
            }
        }
        ///Reader of field `BLINKF`
        pub type BLINKF_R = crate::R<u8, u8>;
        ///Write proxy for field `BLINKF`
        pub struct BLINKF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BLINKF_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 13)) | (((value as u32) & 0x07) << 13);
                self.w
            }
        }
        ///Reader of field `CC`
        pub type CC_R = crate::R<u8, u8>;
        ///Write proxy for field `CC`
        pub struct CC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CC_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 10)) | (((value as u32) & 0x07) << 10);
                self.w
            }
        }
        ///Reader of field `DEAD`
        pub type DEAD_R = crate::R<u8, u8>;
        ///Write proxy for field `DEAD`
        pub struct DEAD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DEAD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 7)) | (((value as u32) & 0x07) << 7);
                self.w
            }
        }
        ///Reader of field `PON`
        pub type PON_R = crate::R<u8, u8>;
        ///Write proxy for field `PON`
        pub struct PON_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PON_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 4)) | (((value as u32) & 0x07) << 4);
                self.w
            }
        }
        ///Reader of field `UDDIE`
        pub type UDDIE_R = crate::R<bool, bool>;
        ///Write proxy for field `UDDIE`
        pub struct UDDIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> UDDIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `SOFIE`
        pub type SOFIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOFIE`
        pub struct SOFIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOFIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `HD`
        pub type HD_R = crate::R<bool, bool>;
        ///Write proxy for field `HD`
        pub struct HD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HD_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bits 22:25 - PS 16-bit prescaler
            #[inline(always)]
            pub fn ps(&self) -> PS_R {
                PS_R::new(((self.bits >> 22) & 0x0f) as u8)
            }
            ///Bits 18:21 - DIV clock divider
            #[inline(always)]
            pub fn div(&self) -> DIV_R {
                DIV_R::new(((self.bits >> 18) & 0x0f) as u8)
            }
            ///Bits 16:17 - Blink mode selection
            #[inline(always)]
            pub fn blink(&self) -> BLINK_R {
                BLINK_R::new(((self.bits >> 16) & 0x03) as u8)
            }
            ///Bits 13:15 - Blink frequency selection
            #[inline(always)]
            pub fn blinkf(&self) -> BLINKF_R {
                BLINKF_R::new(((self.bits >> 13) & 0x07) as u8)
            }
            ///Bits 10:12 - Contrast control
            #[inline(always)]
            pub fn cc(&self) -> CC_R {
                CC_R::new(((self.bits >> 10) & 0x07) as u8)
            }
            ///Bits 7:9 - Dead time duration
            #[inline(always)]
            pub fn dead(&self) -> DEAD_R {
                DEAD_R::new(((self.bits >> 7) & 0x07) as u8)
            }
            ///Bits 4:6 - Pulse ON duration
            #[inline(always)]
            pub fn pon(&self) -> PON_R {
                PON_R::new(((self.bits >> 4) & 0x07) as u8)
            }
            ///Bit 3 - Update display done interrupt enable
            #[inline(always)]
            pub fn uddie(&self) -> UDDIE_R {
                UDDIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 1 - Start of frame interrupt enable
            #[inline(always)]
            pub fn sofie(&self) -> SOFIE_R {
                SOFIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - High drive enable
            #[inline(always)]
            pub fn hd(&self) -> HD_R {
                HD_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bits 22:25 - PS 16-bit prescaler
            #[inline(always)]
            pub fn ps(&mut self) -> PS_W {
                PS_W { w: self }
            }
            ///Bits 18:21 - DIV clock divider
            #[inline(always)]
            pub fn div(&mut self) -> DIV_W {
                DIV_W { w: self }
            }
            ///Bits 16:17 - Blink mode selection
            #[inline(always)]
            pub fn blink(&mut self) -> BLINK_W {
                BLINK_W { w: self }
            }
            ///Bits 13:15 - Blink frequency selection
            #[inline(always)]
            pub fn blinkf(&mut self) -> BLINKF_W {
                BLINKF_W { w: self }
            }
            ///Bits 10:12 - Contrast control
            #[inline(always)]
            pub fn cc(&mut self) -> CC_W {
                CC_W { w: self }
            }
            ///Bits 7:9 - Dead time duration
            #[inline(always)]
            pub fn dead(&mut self) -> DEAD_W {
                DEAD_W { w: self }
            }
            ///Bits 4:6 - Pulse ON duration
            #[inline(always)]
            pub fn pon(&mut self) -> PON_W {
                PON_W { w: self }
            }
            ///Bit 3 - Update display done interrupt enable
            #[inline(always)]
            pub fn uddie(&mut self) -> UDDIE_W {
                UDDIE_W { w: self }
            }
            ///Bit 1 - Start of frame interrupt enable
            #[inline(always)]
            pub fn sofie(&mut self) -> SOFIE_W {
                SOFIE_W { w: self }
            }
            ///Bit 0 - High drive enable
            #[inline(always)]
            pub fn hd(&mut self) -> HD_W {
                HD_W { w: self }
            }
        }
    }
    ///status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [sr](sr) module
    pub type SR = crate::Reg<u32, _SR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SR;
    ///`read()` method returns [sr::R](sr::R) reader structure
    impl crate::Readable for SR {}
    ///`write(|w| ..)` method takes [sr::W](sr::W) writer structure
    impl crate::Writable for SR {}
    ///status register
    pub mod sr {
        ///Reader of register SR
        pub type R = crate::R<u32, super::SR>;
        ///Writer for register SR
        pub type W = crate::W<u32, super::SR>;
        ///Register SR `reset()`'s with value 0x20
        impl crate::ResetValue for super::SR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x20
            }
        }
        ///Reader of field `FCRSF`
        pub type FCRSF_R = crate::R<bool, bool>;
        ///Reader of field `RDY`
        pub type RDY_R = crate::R<bool, bool>;
        ///Reader of field `UDD`
        pub type UDD_R = crate::R<bool, bool>;
        ///Write proxy for field `UDR`
        pub struct UDR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> UDR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `SOF`
        pub type SOF_R = crate::R<bool, bool>;
        ///Reader of field `ENS`
        pub type ENS_R = crate::R<bool, bool>;
        impl R {
            ///Bit 5 - LCD Frame Control Register Synchronization flag
            #[inline(always)]
            pub fn fcrsf(&self) -> FCRSF_R {
                FCRSF_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Ready flag
            #[inline(always)]
            pub fn rdy(&self) -> RDY_R {
                RDY_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Update Display Done
            #[inline(always)]
            pub fn udd(&self) -> UDD_R {
                UDD_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 1 - Start of frame flag
            #[inline(always)]
            pub fn sof(&self) -> SOF_R {
                SOF_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - ENS
            #[inline(always)]
            pub fn ens(&self) -> ENS_R {
                ENS_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 2 - Update display request
            #[inline(always)]
            pub fn udr(&mut self) -> UDR_W {
                UDR_W { w: self }
            }
        }
    }
    ///clear register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [clr](clr) module
    pub type CLR = crate::Reg<u32, _CLR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CLR;
    ///`write(|w| ..)` method takes [clr::W](clr::W) writer structure
    impl crate::Writable for CLR {}
    ///clear register
    pub mod clr {
        ///Writer for register CLR
        pub type W = crate::W<u32, super::CLR>;
        ///Register CLR `reset()`'s with value 0
        impl crate::ResetValue for super::CLR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `UDDC`
        pub struct UDDC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> UDDC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Write proxy for field `SOFC`
        pub struct SOFC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOFC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        impl W {
            ///Bit 3 - Update display done clear
            #[inline(always)]
            pub fn uddc(&mut self) -> UDDC_W {
                UDDC_W { w: self }
            }
            ///Bit 1 - Start of frame flag clear
            #[inline(always)]
            pub fn sofc(&mut self) -> SOFC_W {
                SOFC_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com0](ram_com0) module
    pub type RAM_COM0 = crate::Reg<u32, _RAM_COM0>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM0;
    ///`read()` method returns [ram_com0::R](ram_com0::R) reader structure
    impl crate::Readable for RAM_COM0 {}
    ///`write(|w| ..)` method takes [ram_com0::W](ram_com0::W) writer structure
    impl crate::Writable for RAM_COM0 {}
    ///display memory
    pub mod ram_com0 {
        ///Reader of register RAM_COM0
        pub type R = crate::R<u32, super::RAM_COM0>;
        ///Writer for register RAM_COM0
        pub type W = crate::W<u32, super::RAM_COM0>;
        ///Register RAM_COM0 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM0 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com1](ram_com1) module
    pub type RAM_COM1 = crate::Reg<u32, _RAM_COM1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM1;
    ///`read()` method returns [ram_com1::R](ram_com1::R) reader structure
    impl crate::Readable for RAM_COM1 {}
    ///`write(|w| ..)` method takes [ram_com1::W](ram_com1::W) writer structure
    impl crate::Writable for RAM_COM1 {}
    ///display memory
    pub mod ram_com1 {
        ///Reader of register RAM_COM1
        pub type R = crate::R<u32, super::RAM_COM1>;
        ///Writer for register RAM_COM1
        pub type W = crate::W<u32, super::RAM_COM1>;
        ///Register RAM_COM1 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com2](ram_com2) module
    pub type RAM_COM2 = crate::Reg<u32, _RAM_COM2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM2;
    ///`read()` method returns [ram_com2::R](ram_com2::R) reader structure
    impl crate::Readable for RAM_COM2 {}
    ///`write(|w| ..)` method takes [ram_com2::W](ram_com2::W) writer structure
    impl crate::Writable for RAM_COM2 {}
    ///display memory
    pub mod ram_com2 {
        ///Reader of register RAM_COM2
        pub type R = crate::R<u32, super::RAM_COM2>;
        ///Writer for register RAM_COM2
        pub type W = crate::W<u32, super::RAM_COM2>;
        ///Register RAM_COM2 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com3](ram_com3) module
    pub type RAM_COM3 = crate::Reg<u32, _RAM_COM3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM3;
    ///`read()` method returns [ram_com3::R](ram_com3::R) reader structure
    impl crate::Readable for RAM_COM3 {}
    ///`write(|w| ..)` method takes [ram_com3::W](ram_com3::W) writer structure
    impl crate::Writable for RAM_COM3 {}
    ///display memory
    pub mod ram_com3 {
        ///Reader of register RAM_COM3
        pub type R = crate::R<u32, super::RAM_COM3>;
        ///Writer for register RAM_COM3
        pub type W = crate::W<u32, super::RAM_COM3>;
        ///Register RAM_COM3 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com4](ram_com4) module
    pub type RAM_COM4 = crate::Reg<u32, _RAM_COM4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM4;
    ///`read()` method returns [ram_com4::R](ram_com4::R) reader structure
    impl crate::Readable for RAM_COM4 {}
    ///`write(|w| ..)` method takes [ram_com4::W](ram_com4::W) writer structure
    impl crate::Writable for RAM_COM4 {}
    ///display memory
    pub mod ram_com4 {
        ///Reader of register RAM_COM4
        pub type R = crate::R<u32, super::RAM_COM4>;
        ///Writer for register RAM_COM4
        pub type W = crate::W<u32, super::RAM_COM4>;
        ///Register RAM_COM4 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com5](ram_com5) module
    pub type RAM_COM5 = crate::Reg<u32, _RAM_COM5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM5;
    ///`read()` method returns [ram_com5::R](ram_com5::R) reader structure
    impl crate::Readable for RAM_COM5 {}
    ///`write(|w| ..)` method takes [ram_com5::W](ram_com5::W) writer structure
    impl crate::Writable for RAM_COM5 {}
    ///display memory
    pub mod ram_com5 {
        ///Reader of register RAM_COM5
        pub type R = crate::R<u32, super::RAM_COM5>;
        ///Writer for register RAM_COM5
        pub type W = crate::W<u32, super::RAM_COM5>;
        ///Register RAM_COM5 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com6](ram_com6) module
    pub type RAM_COM6 = crate::Reg<u32, _RAM_COM6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM6;
    ///`read()` method returns [ram_com6::R](ram_com6::R) reader structure
    impl crate::Readable for RAM_COM6 {}
    ///`write(|w| ..)` method takes [ram_com6::W](ram_com6::W) writer structure
    impl crate::Writable for RAM_COM6 {}
    ///display memory
    pub mod ram_com6 {
        ///Reader of register RAM_COM6
        pub type R = crate::R<u32, super::RAM_COM6>;
        ///Writer for register RAM_COM6
        pub type W = crate::W<u32, super::RAM_COM6>;
        ///Register RAM_COM6 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
    ///display memory
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ram_com7](ram_com7) module
    pub type RAM_COM7 = crate::Reg<u32, _RAM_COM7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RAM_COM7;
    ///`read()` method returns [ram_com7::R](ram_com7::R) reader structure
    impl crate::Readable for RAM_COM7 {}
    ///`write(|w| ..)` method takes [ram_com7::W](ram_com7::W) writer structure
    impl crate::Writable for RAM_COM7 {}
    ///display memory
    pub mod ram_com7 {
        ///Reader of register RAM_COM7
        pub type R = crate::R<u32, super::RAM_COM7>;
        ///Writer for register RAM_COM7
        pub type W = crate::W<u32, super::RAM_COM7>;
        ///Register RAM_COM7 `reset()`'s with value 0
        impl crate::ResetValue for super::RAM_COM7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `S31`
        pub type S31_R = crate::R<bool, bool>;
        ///Write proxy for field `S31`
        pub struct S31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S31_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `S30`
        pub type S30_R = crate::R<bool, bool>;
        ///Write proxy for field `S30`
        pub struct S30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S30_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `S29`
        pub type S29_R = crate::R<bool, bool>;
        ///Write proxy for field `S29`
        pub struct S29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S29_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `S28`
        pub type S28_R = crate::R<bool, bool>;
        ///Write proxy for field `S28`
        pub struct S28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S28_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `S27`
        pub type S27_R = crate::R<bool, bool>;
        ///Write proxy for field `S27`
        pub struct S27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S27_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `S26`
        pub type S26_R = crate::R<bool, bool>;
        ///Write proxy for field `S26`
        pub struct S26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S26_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `S25`
        pub type S25_R = crate::R<bool, bool>;
        ///Write proxy for field `S25`
        pub struct S25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S25_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `S24`
        pub type S24_R = crate::R<bool, bool>;
        ///Write proxy for field `S24`
        pub struct S24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S24_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `S23`
        pub type S23_R = crate::R<bool, bool>;
        ///Write proxy for field `S23`
        pub struct S23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S23_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `S22`
        pub type S22_R = crate::R<bool, bool>;
        ///Write proxy for field `S22`
        pub struct S22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S22_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `S21`
        pub type S21_R = crate::R<bool, bool>;
        ///Write proxy for field `S21`
        pub struct S21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S21_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `S20`
        pub type S20_R = crate::R<bool, bool>;
        ///Write proxy for field `S20`
        pub struct S20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S20_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `S19`
        pub type S19_R = crate::R<bool, bool>;
        ///Write proxy for field `S19`
        pub struct S19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S19_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `S18`
        pub type S18_R = crate::R<bool, bool>;
        ///Write proxy for field `S18`
        pub struct S18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S18_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `S17`
        pub type S17_R = crate::R<bool, bool>;
        ///Write proxy for field `S17`
        pub struct S17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S17_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `S16`
        pub type S16_R = crate::R<bool, bool>;
        ///Write proxy for field `S16`
        pub struct S16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S16_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `S15`
        pub type S15_R = crate::R<bool, bool>;
        ///Write proxy for field `S15`
        pub struct S15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S15_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `S14`
        pub type S14_R = crate::R<bool, bool>;
        ///Write proxy for field `S14`
        pub struct S14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S14_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `S13`
        pub type S13_R = crate::R<bool, bool>;
        ///Write proxy for field `S13`
        pub struct S13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `S12`
        pub type S12_R = crate::R<bool, bool>;
        ///Write proxy for field `S12`
        pub struct S12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `S11`
        pub type S11_R = crate::R<bool, bool>;
        ///Write proxy for field `S11`
        pub struct S11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `S10`
        pub type S10_R = crate::R<bool, bool>;
        ///Write proxy for field `S10`
        pub struct S10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `S09`
        pub type S09_R = crate::R<bool, bool>;
        ///Write proxy for field `S09`
        pub struct S09_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S09_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `S08`
        pub type S08_R = crate::R<bool, bool>;
        ///Write proxy for field `S08`
        pub struct S08_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S08_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `S07`
        pub type S07_R = crate::R<bool, bool>;
        ///Write proxy for field `S07`
        pub struct S07_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S07_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `S06`
        pub type S06_R = crate::R<bool, bool>;
        ///Write proxy for field `S06`
        pub struct S06_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S06_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `S05`
        pub type S05_R = crate::R<bool, bool>;
        ///Write proxy for field `S05`
        pub struct S05_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S05_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `S04`
        pub type S04_R = crate::R<bool, bool>;
        ///Write proxy for field `S04`
        pub struct S04_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S04_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `S03`
        pub type S03_R = crate::R<bool, bool>;
        ///Write proxy for field `S03`
        pub struct S03_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S03_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `S02`
        pub type S02_R = crate::R<bool, bool>;
        ///Write proxy for field `S02`
        pub struct S02_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S02_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `S01`
        pub type S01_R = crate::R<bool, bool>;
        ///Write proxy for field `S01`
        pub struct S01_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S01_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `S00`
        pub type S00_R = crate::R<bool, bool>;
        ///Write proxy for field `S00`
        pub struct S00_W<'a> {
            w: &'a mut W,
        }
        impl<'a> S00_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&self) -> S31_R {
                S31_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&self) -> S30_R {
                S30_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&self) -> S29_R {
                S29_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&self) -> S28_R {
                S28_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&self) -> S27_R {
                S27_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&self) -> S26_R {
                S26_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&self) -> S25_R {
                S25_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&self) -> S24_R {
                S24_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&self) -> S23_R {
                S23_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&self) -> S22_R {
                S22_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&self) -> S21_R {
                S21_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&self) -> S20_R {
                S20_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&self) -> S19_R {
                S19_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&self) -> S18_R {
                S18_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&self) -> S17_R {
                S17_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&self) -> S16_R {
                S16_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&self) -> S15_R {
                S15_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&self) -> S14_R {
                S14_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&self) -> S13_R {
                S13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&self) -> S12_R {
                S12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&self) -> S11_R {
                S11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&self) -> S10_R {
                S10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&self) -> S09_R {
                S09_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&self) -> S08_R {
                S08_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&self) -> S07_R {
                S07_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&self) -> S06_R {
                S06_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&self) -> S05_R {
                S05_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&self) -> S04_R {
                S04_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&self) -> S03_R {
                S03_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&self) -> S02_R {
                S02_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&self) -> S01_R {
                S01_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&self) -> S00_R {
                S00_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - S31
            #[inline(always)]
            pub fn s31(&mut self) -> S31_W {
                S31_W { w: self }
            }
            ///Bit 30 - S30
            #[inline(always)]
            pub fn s30(&mut self) -> S30_W {
                S30_W { w: self }
            }
            ///Bit 29 - S29
            #[inline(always)]
            pub fn s29(&mut self) -> S29_W {
                S29_W { w: self }
            }
            ///Bit 28 - S28
            #[inline(always)]
            pub fn s28(&mut self) -> S28_W {
                S28_W { w: self }
            }
            ///Bit 27 - S27
            #[inline(always)]
            pub fn s27(&mut self) -> S27_W {
                S27_W { w: self }
            }
            ///Bit 26 - S26
            #[inline(always)]
            pub fn s26(&mut self) -> S26_W {
                S26_W { w: self }
            }
            ///Bit 25 - S25
            #[inline(always)]
            pub fn s25(&mut self) -> S25_W {
                S25_W { w: self }
            }
            ///Bit 24 - S24
            #[inline(always)]
            pub fn s24(&mut self) -> S24_W {
                S24_W { w: self }
            }
            ///Bit 23 - S23
            #[inline(always)]
            pub fn s23(&mut self) -> S23_W {
                S23_W { w: self }
            }
            ///Bit 22 - S22
            #[inline(always)]
            pub fn s22(&mut self) -> S22_W {
                S22_W { w: self }
            }
            ///Bit 21 - S21
            #[inline(always)]
            pub fn s21(&mut self) -> S21_W {
                S21_W { w: self }
            }
            ///Bit 20 - S20
            #[inline(always)]
            pub fn s20(&mut self) -> S20_W {
                S20_W { w: self }
            }
            ///Bit 19 - S19
            #[inline(always)]
            pub fn s19(&mut self) -> S19_W {
                S19_W { w: self }
            }
            ///Bit 18 - S18
            #[inline(always)]
            pub fn s18(&mut self) -> S18_W {
                S18_W { w: self }
            }
            ///Bit 17 - S17
            #[inline(always)]
            pub fn s17(&mut self) -> S17_W {
                S17_W { w: self }
            }
            ///Bit 16 - S16
            #[inline(always)]
            pub fn s16(&mut self) -> S16_W {
                S16_W { w: self }
            }
            ///Bit 15 - S15
            #[inline(always)]
            pub fn s15(&mut self) -> S15_W {
                S15_W { w: self }
            }
            ///Bit 14 - S14
            #[inline(always)]
            pub fn s14(&mut self) -> S14_W {
                S14_W { w: self }
            }
            ///Bit 13 - S13
            #[inline(always)]
            pub fn s13(&mut self) -> S13_W {
                S13_W { w: self }
            }
            ///Bit 12 - S12
            #[inline(always)]
            pub fn s12(&mut self) -> S12_W {
                S12_W { w: self }
            }
            ///Bit 11 - S11
            #[inline(always)]
            pub fn s11(&mut self) -> S11_W {
                S11_W { w: self }
            }
            ///Bit 10 - S10
            #[inline(always)]
            pub fn s10(&mut self) -> S10_W {
                S10_W { w: self }
            }
            ///Bit 9 - S09
            #[inline(always)]
            pub fn s09(&mut self) -> S09_W {
                S09_W { w: self }
            }
            ///Bit 8 - S08
            #[inline(always)]
            pub fn s08(&mut self) -> S08_W {
                S08_W { w: self }
            }
            ///Bit 7 - S07
            #[inline(always)]
            pub fn s07(&mut self) -> S07_W {
                S07_W { w: self }
            }
            ///Bit 6 - S06
            #[inline(always)]
            pub fn s06(&mut self) -> S06_W {
                S06_W { w: self }
            }
            ///Bit 5 - S05
            #[inline(always)]
            pub fn s05(&mut self) -> S05_W {
                S05_W { w: self }
            }
            ///Bit 4 - S04
            #[inline(always)]
            pub fn s04(&mut self) -> S04_W {
                S04_W { w: self }
            }
            ///Bit 3 - S03
            #[inline(always)]
            pub fn s03(&mut self) -> S03_W {
                S03_W { w: self }
            }
            ///Bit 2 - S02
            #[inline(always)]
            pub fn s02(&mut self) -> S02_W {
                S02_W { w: self }
            }
            ///Bit 1 - S01
            #[inline(always)]
            pub fn s01(&mut self) -> S01_W {
                S01_W { w: self }
            }
            ///Bit 0 - S00
            #[inline(always)]
            pub fn s00(&mut self) -> S00_W {
                S00_W { w: self }
            }
        }
    }
}
///Touch sensing controller
pub struct TSC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TSC {}
impl TSC {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const tsc::RegisterBlock {
        0x4002_4000 as *const _
    }
}
impl Deref for TSC {
    type Target = tsc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*TSC::ptr() }
    }
}
///Touch sensing controller
pub mod tsc {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - control register
        pub cr: CR,
        ///0x04 - interrupt enable register
        pub ier: IER,
        ///0x08 - interrupt clear register
        pub icr: ICR,
        ///0x0c - interrupt status register
        pub isr: ISR,
        ///0x10 - I/O hysteresis control register
        pub iohcr: IOHCR,
        _reserved5: [u8; 4usize],
        ///0x18 - I/O analog switch control register
        pub ioascr: IOASCR,
        _reserved6: [u8; 4usize],
        ///0x20 - I/O sampling control register
        pub ioscr: IOSCR,
        _reserved7: [u8; 4usize],
        ///0x28 - I/O channel control register
        pub ioccr: IOCCR,
        _reserved8: [u8; 4usize],
        ///0x30 - I/O group control status register
        pub iogcsr: IOGCSR,
        ///0x34 - I/O group x counter register
        pub iog1cr: IOGCR,
        ///0x38 - I/O group x counter register
        pub iog2cr: IOGCR,
        ///0x3c - I/O group x counter register
        pub iog3cr: IOGCR,
        ///0x40 - I/O group x counter register
        pub iog4cr: IOGCR,
        ///0x44 - I/O group x counter register
        pub iog5cr: IOGCR,
        ///0x48 - I/O group x counter register
        pub iog6cr: IOGCR,
        ///0x4c - I/O group x counter register
        pub iog7cr: IOGCR,
        ///0x50 - I/O group x counter register
        pub iog8cr: IOGCR,
    }
    ///control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CTPH`
        pub type CTPH_R = crate::R<u8, u8>;
        ///Write proxy for field `CTPH`
        pub struct CTPH_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTPH_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 28)) | (((value as u32) & 0x0f) << 28);
                self.w
            }
        }
        ///Reader of field `CTPL`
        pub type CTPL_R = crate::R<u8, u8>;
        ///Write proxy for field `CTPL`
        pub struct CTPL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTPL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 24)) | (((value as u32) & 0x0f) << 24);
                self.w
            }
        }
        ///Reader of field `SSD`
        pub type SSD_R = crate::R<u8, u8>;
        ///Write proxy for field `SSD`
        pub struct SSD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x7f << 17)) | (((value as u32) & 0x7f) << 17);
                self.w
            }
        }
        ///Reader of field `SSE`
        pub type SSE_R = crate::R<bool, bool>;
        ///Write proxy for field `SSE`
        pub struct SSE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `SSPSC`
        pub type SSPSC_R = crate::R<bool, bool>;
        ///Write proxy for field `SSPSC`
        pub struct SSPSC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSPSC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `PGPSC`
        pub type PGPSC_R = crate::R<u8, u8>;
        ///Write proxy for field `PGPSC`
        pub struct PGPSC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PGPSC_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 12)) | (((value as u32) & 0x07) << 12);
                self.w
            }
        }
        ///Reader of field `MCV`
        pub type MCV_R = crate::R<u8, u8>;
        ///Write proxy for field `MCV`
        pub struct MCV_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCV_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 5)) | (((value as u32) & 0x07) << 5);
                self.w
            }
        }
        ///Reader of field `IODEF`
        pub type IODEF_R = crate::R<bool, bool>;
        ///Write proxy for field `IODEF`
        pub struct IODEF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IODEF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `SYNCPOL`
        pub type SYNCPOL_R = crate::R<bool, bool>;
        ///Write proxy for field `SYNCPOL`
        pub struct SYNCPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNCPOL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `AM`
        pub type AM_R = crate::R<bool, bool>;
        ///Write proxy for field `AM`
        pub struct AM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> AM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `START`
        pub type START_R = crate::R<bool, bool>;
        ///Write proxy for field `START`
        pub struct START_W<'a> {
            w: &'a mut W,
        }
        impl<'a> START_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `TSCE`
        pub type TSCE_R = crate::R<bool, bool>;
        ///Write proxy for field `TSCE`
        pub struct TSCE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSCE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bits 28:31 - Charge transfer pulse high
            #[inline(always)]
            pub fn ctph(&self) -> CTPH_R {
                CTPH_R::new(((self.bits >> 28) & 0x0f) as u8)
            }
            ///Bits 24:27 - Charge transfer pulse low
            #[inline(always)]
            pub fn ctpl(&self) -> CTPL_R {
                CTPL_R::new(((self.bits >> 24) & 0x0f) as u8)
            }
            ///Bits 17:23 - Spread spectrum deviation
            #[inline(always)]
            pub fn ssd(&self) -> SSD_R {
                SSD_R::new(((self.bits >> 17) & 0x7f) as u8)
            }
            ///Bit 16 - Spread spectrum enable
            #[inline(always)]
            pub fn sse(&self) -> SSE_R {
                SSE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - Spread spectrum prescaler
            #[inline(always)]
            pub fn sspsc(&self) -> SSPSC_R {
                SSPSC_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bits 12:14 - pulse generator prescaler
            #[inline(always)]
            pub fn pgpsc(&self) -> PGPSC_R {
                PGPSC_R::new(((self.bits >> 12) & 0x07) as u8)
            }
            ///Bits 5:7 - Max count value
            #[inline(always)]
            pub fn mcv(&self) -> MCV_R {
                MCV_R::new(((self.bits >> 5) & 0x07) as u8)
            }
            ///Bit 4 - I/O Default mode
            #[inline(always)]
            pub fn iodef(&self) -> IODEF_R {
                IODEF_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Synchronization pin polarity
            #[inline(always)]
            pub fn syncpol(&self) -> SYNCPOL_R {
                SYNCPOL_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Acquisition mode
            #[inline(always)]
            pub fn am(&self) -> AM_R {
                AM_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Start a new acquisition
            #[inline(always)]
            pub fn start(&self) -> START_R {
                START_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Touch sensing controller enable
            #[inline(always)]
            pub fn tsce(&self) -> TSCE_R {
                TSCE_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bits 28:31 - Charge transfer pulse high
            #[inline(always)]
            pub fn ctph(&mut self) -> CTPH_W {
                CTPH_W { w: self }
            }
            ///Bits 24:27 - Charge transfer pulse low
            #[inline(always)]
            pub fn ctpl(&mut self) -> CTPL_W {
                CTPL_W { w: self }
            }
            ///Bits 17:23 - Spread spectrum deviation
            #[inline(always)]
            pub fn ssd(&mut self) -> SSD_W {
                SSD_W { w: self }
            }
            ///Bit 16 - Spread spectrum enable
            #[inline(always)]
            pub fn sse(&mut self) -> SSE_W {
                SSE_W { w: self }
            }
            ///Bit 15 - Spread spectrum prescaler
            #[inline(always)]
            pub fn sspsc(&mut self) -> SSPSC_W {
                SSPSC_W { w: self }
            }
            ///Bits 12:14 - pulse generator prescaler
            #[inline(always)]
            pub fn pgpsc(&mut self) -> PGPSC_W {
                PGPSC_W { w: self }
            }
            ///Bits 5:7 - Max count value
            #[inline(always)]
            pub fn mcv(&mut self) -> MCV_W {
                MCV_W { w: self }
            }
            ///Bit 4 - I/O Default mode
            #[inline(always)]
            pub fn iodef(&mut self) -> IODEF_W {
                IODEF_W { w: self }
            }
            ///Bit 3 - Synchronization pin polarity
            #[inline(always)]
            pub fn syncpol(&mut self) -> SYNCPOL_W {
                SYNCPOL_W { w: self }
            }
            ///Bit 2 - Acquisition mode
            #[inline(always)]
            pub fn am(&mut self) -> AM_W {
                AM_W { w: self }
            }
            ///Bit 1 - Start a new acquisition
            #[inline(always)]
            pub fn start(&mut self) -> START_W {
                START_W { w: self }
            }
            ///Bit 0 - Touch sensing controller enable
            #[inline(always)]
            pub fn tsce(&mut self) -> TSCE_W {
                TSCE_W { w: self }
            }
        }
    }
    ///interrupt enable register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ier](ier) module
    pub type IER = crate::Reg<u32, _IER>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IER;
    ///`read()` method returns [ier::R](ier::R) reader structure
    impl crate::Readable for IER {}
    ///`write(|w| ..)` method takes [ier::W](ier::W) writer structure
    impl crate::Writable for IER {}
    ///interrupt enable register
    pub mod ier {
        ///Reader of register IER
        pub type R = crate::R<u32, super::IER>;
        ///Writer for register IER
        pub type W = crate::W<u32, super::IER>;
        ///Register IER `reset()`'s with value 0
        impl crate::ResetValue for super::IER {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEIE`
        pub type MCEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEIE`
        pub struct MCEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAIE`
        pub type EOAIE_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAIE`
        pub struct EOAIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error interrupt enable
            #[inline(always)]
            pub fn mceie(&self) -> MCEIE_R {
                MCEIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition interrupt enable
            #[inline(always)]
            pub fn eoaie(&self) -> EOAIE_R {
                EOAIE_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error interrupt enable
            #[inline(always)]
            pub fn mceie(&mut self) -> MCEIE_W {
                MCEIE_W { w: self }
            }
            ///Bit 0 - End of acquisition interrupt enable
            #[inline(always)]
            pub fn eoaie(&mut self) -> EOAIE_W {
                EOAIE_W { w: self }
            }
        }
    }
    ///interrupt clear register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [icr](icr) module
    pub type ICR = crate::Reg<u32, _ICR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ICR;
    ///`read()` method returns [icr::R](icr::R) reader structure
    impl crate::Readable for ICR {}
    ///`write(|w| ..)` method takes [icr::W](icr::W) writer structure
    impl crate::Writable for ICR {}
    ///interrupt clear register
    pub mod icr {
        ///Reader of register ICR
        pub type R = crate::R<u32, super::ICR>;
        ///Writer for register ICR
        pub type W = crate::W<u32, super::ICR>;
        ///Register ICR `reset()`'s with value 0
        impl crate::ResetValue for super::ICR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEIC`
        pub type MCEIC_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEIC`
        pub struct MCEIC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEIC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAIC`
        pub type EOAIC_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAIC`
        pub struct EOAIC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAIC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error interrupt clear
            #[inline(always)]
            pub fn mceic(&self) -> MCEIC_R {
                MCEIC_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition interrupt clear
            #[inline(always)]
            pub fn eoaic(&self) -> EOAIC_R {
                EOAIC_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error interrupt clear
            #[inline(always)]
            pub fn mceic(&mut self) -> MCEIC_W {
                MCEIC_W { w: self }
            }
            ///Bit 0 - End of acquisition interrupt clear
            #[inline(always)]
            pub fn eoaic(&mut self) -> EOAIC_W {
                EOAIC_W { w: self }
            }
        }
    }
    ///interrupt status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [isr](isr) module
    pub type ISR = crate::Reg<u32, _ISR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ISR;
    ///`read()` method returns [isr::R](isr::R) reader structure
    impl crate::Readable for ISR {}
    ///`write(|w| ..)` method takes [isr::W](isr::W) writer structure
    impl crate::Writable for ISR {}
    ///interrupt status register
    pub mod isr {
        ///Reader of register ISR
        pub type R = crate::R<u32, super::ISR>;
        ///Writer for register ISR
        pub type W = crate::W<u32, super::ISR>;
        ///Register ISR `reset()`'s with value 0
        impl crate::ResetValue for super::ISR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEF`
        pub type MCEF_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEF`
        pub struct MCEF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAF`
        pub type EOAF_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAF`
        pub struct EOAF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error flag
            #[inline(always)]
            pub fn mcef(&self) -> MCEF_R {
                MCEF_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition flag
            #[inline(always)]
            pub fn eoaf(&self) -> EOAF_R {
                EOAF_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error flag
            #[inline(always)]
            pub fn mcef(&mut self) -> MCEF_W {
                MCEF_W { w: self }
            }
            ///Bit 0 - End of acquisition flag
            #[inline(always)]
            pub fn eoaf(&mut self) -> EOAF_W {
                EOAF_W { w: self }
            }
        }
    }
    ///I/O hysteresis control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [iohcr](iohcr) module
    pub type IOHCR = crate::Reg<u32, _IOHCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOHCR;
    ///`read()` method returns [iohcr::R](iohcr::R) reader structure
    impl crate::Readable for IOHCR {}
    ///`write(|w| ..)` method takes [iohcr::W](iohcr::W) writer structure
    impl crate::Writable for IOHCR {}
    ///I/O hysteresis control register
    pub mod iohcr {
        ///Reader of register IOHCR
        pub type R = crate::R<u32, super::IOHCR>;
        ///Writer for register IOHCR
        pub type W = crate::W<u32, super::IOHCR>;
        ///Register IOHCR `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::IOHCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `G8_IO4`
        pub type G8_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO4`
        pub struct G8_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `G8_IO3`
        pub type G8_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO3`
        pub struct G8_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `G8_IO2`
        pub type G8_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO2`
        pub struct G8_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `G8_IO1`
        pub type G8_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO1`
        pub struct G8_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&self) -> G8_IO4_R {
                G8_IO4_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&self) -> G8_IO3_R {
                G8_IO3_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&self) -> G8_IO2_R {
                G8_IO2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&self) -> G8_IO1_R {
                G8_IO1_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&mut self) -> G8_IO4_W {
                G8_IO4_W { w: self }
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&mut self) -> G8_IO3_W {
                G8_IO3_W { w: self }
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&mut self) -> G8_IO2_W {
                G8_IO2_W { w: self }
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&mut self) -> G8_IO1_W {
                G8_IO1_W { w: self }
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O analog switch control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ioascr](ioascr) module
    pub type IOASCR = crate::Reg<u32, _IOASCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOASCR;
    ///`read()` method returns [ioascr::R](ioascr::R) reader structure
    impl crate::Readable for IOASCR {}
    ///`write(|w| ..)` method takes [ioascr::W](ioascr::W) writer structure
    impl crate::Writable for IOASCR {}
    ///I/O analog switch control register
    pub mod ioascr {
        ///Reader of register IOASCR
        pub type R = crate::R<u32, super::IOASCR>;
        ///Writer for register IOASCR
        pub type W = crate::W<u32, super::IOASCR>;
        ///Register IOASCR `reset()`'s with value 0
        impl crate::ResetValue for super::IOASCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G8_IO4`
        pub type G8_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO4`
        pub struct G8_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `G8_IO3`
        pub type G8_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO3`
        pub struct G8_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `G8_IO2`
        pub type G8_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO2`
        pub struct G8_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `G8_IO1`
        pub type G8_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO1`
        pub struct G8_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&self) -> G8_IO4_R {
                G8_IO4_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&self) -> G8_IO3_R {
                G8_IO3_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&self) -> G8_IO2_R {
                G8_IO2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&self) -> G8_IO1_R {
                G8_IO1_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&mut self) -> G8_IO4_W {
                G8_IO4_W { w: self }
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&mut self) -> G8_IO3_W {
                G8_IO3_W { w: self }
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&mut self) -> G8_IO2_W {
                G8_IO2_W { w: self }
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&mut self) -> G8_IO1_W {
                G8_IO1_W { w: self }
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O sampling control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ioscr](ioscr) module
    pub type IOSCR = crate::Reg<u32, _IOSCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOSCR;
    ///`read()` method returns [ioscr::R](ioscr::R) reader structure
    impl crate::Readable for IOSCR {}
    ///`write(|w| ..)` method takes [ioscr::W](ioscr::W) writer structure
    impl crate::Writable for IOSCR {}
    ///I/O sampling control register
    pub mod ioscr {
        ///Reader of register IOSCR
        pub type R = crate::R<u32, super::IOSCR>;
        ///Writer for register IOSCR
        pub type W = crate::W<u32, super::IOSCR>;
        ///Register IOSCR `reset()`'s with value 0
        impl crate::ResetValue for super::IOSCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G8_IO4`
        pub type G8_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO4`
        pub struct G8_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `G8_IO3`
        pub type G8_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO3`
        pub struct G8_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `G8_IO2`
        pub type G8_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO2`
        pub struct G8_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `G8_IO1`
        pub type G8_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO1`
        pub struct G8_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&self) -> G8_IO4_R {
                G8_IO4_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&self) -> G8_IO3_R {
                G8_IO3_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&self) -> G8_IO2_R {
                G8_IO2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&self) -> G8_IO1_R {
                G8_IO1_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&mut self) -> G8_IO4_W {
                G8_IO4_W { w: self }
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&mut self) -> G8_IO3_W {
                G8_IO3_W { w: self }
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&mut self) -> G8_IO2_W {
                G8_IO2_W { w: self }
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&mut self) -> G8_IO1_W {
                G8_IO1_W { w: self }
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O channel control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ioccr](ioccr) module
    pub type IOCCR = crate::Reg<u32, _IOCCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOCCR;
    ///`read()` method returns [ioccr::R](ioccr::R) reader structure
    impl crate::Readable for IOCCR {}
    ///`write(|w| ..)` method takes [ioccr::W](ioccr::W) writer structure
    impl crate::Writable for IOCCR {}
    ///I/O channel control register
    pub mod ioccr {
        ///Reader of register IOCCR
        pub type R = crate::R<u32, super::IOCCR>;
        ///Writer for register IOCCR
        pub type W = crate::W<u32, super::IOCCR>;
        ///Register IOCCR `reset()`'s with value 0
        impl crate::ResetValue for super::IOCCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G8_IO4`
        pub type G8_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO4`
        pub struct G8_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `G8_IO3`
        pub type G8_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO3`
        pub struct G8_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `G8_IO2`
        pub type G8_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO2`
        pub struct G8_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `G8_IO1`
        pub type G8_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO1`
        pub struct G8_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&self) -> G8_IO4_R {
                G8_IO4_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&self) -> G8_IO3_R {
                G8_IO3_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&self) -> G8_IO2_R {
                G8_IO2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&self) -> G8_IO1_R {
                G8_IO1_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&mut self) -> G8_IO4_W {
                G8_IO4_W { w: self }
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&mut self) -> G8_IO3_W {
                G8_IO3_W { w: self }
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&mut self) -> G8_IO2_W {
                G8_IO2_W { w: self }
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&mut self) -> G8_IO1_W {
                G8_IO1_W { w: self }
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O group control status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [iogcsr](iogcsr) module
    pub type IOGCSR = crate::Reg<u32, _IOGCSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOGCSR;
    ///`read()` method returns [iogcsr::R](iogcsr::R) reader structure
    impl crate::Readable for IOGCSR {}
    ///`write(|w| ..)` method takes [iogcsr::W](iogcsr::W) writer structure
    impl crate::Writable for IOGCSR {}
    ///I/O group control status register
    pub mod iogcsr {
        ///Reader of register IOGCSR
  