#![deny(unused_allocation)]
#![deny(unused_comparisons)]
extern crate cortex_m;
#[cfg(feature = "rt")]
extern crate cortex_m_rt;
extern crate vcell;
use core::marker::PhantomData;
use core::ops::Deref;
///Number available in the NVIC for configuring priority
pub const NVIC_PRIO_BITS: u8 = 4;
#[cfg(feature = "rt")]
extern "C" {
    fn WWDG();
    fn PVD_PVM();
    fn TAMP_STAMP();
    fn RTC_WKUP();
    fn FLASH();
    fn RCC();
    fn EXTI0();
    fn EXTI1();
    fn EXTI2();
    fn EXTI3();
    fn EXTI4();
    fn DMA1_CH1();
    fn DMA1_CH2();
    fn DMA1_CH3();
    fn DMA1_CH4();
    fn DMA1_CH5();
    fn DMA1_CH6();
    fn DMA1_CH7();
    fn ADC1();
    fn CAN1_TX();
    fn CAN1_RX0();
    fn CAN1_RX1();
    fn CAN1_SCE();
    fn EXTI9_5();
    fn TIM1_BRK_TIM15();
    fn TIM1_UP_TIM16();
    fn TIM1_TRG_COM_TIM17();
    fn TIM1_CC();
    fn TIM2();
    fn TIM3();
    fn TIM4();
    fn I2C1_EV();
    fn I2C1_ER();
    fn I2C2_EV();
    fn I2C2_ER();
    fn SPI1();
    fn SPI2();
    fn USART1();
    fn USART2();
    fn USART3();
    fn EXTI15_10();
    fn RTC_ALARM();
    fn DFSDM1_FLT3();
    fn TIM8_BRK();
    fn TIM8_UP();
    fn TIM8_TRG_COM();
    fn TIM8_CC();
    fn ADC3();
    fn FMC();
    fn SDMMC1();
    fn TIM5();
    fn SPI3();
    fn UART4();
    fn UART5();
    fn TIM6_DACUNDER();
    fn TIM7();
    fn DMA2_CH1();
    fn DMA2_CH2();
    fn DMA2_CH3();
    fn DMA2_CH4();
    fn DMA2_CH5();
    fn DFSDM1_FLT0();
    fn DFSDM1_FLT1();
    fn DFSDM1_FLT2();
    fn COMP();
    fn LPTIM1();
    fn LPTIM2();
    fn OTG_FS();
    fn DMA2_CH6();
    fn DMA2_CH7();
    fn LPUART1();
    fn OCTOSPI1();
    fn I2C3_EV();
    fn I2C3_ER();
    fn SAI1();
    fn SAI2();
    fn OCTOSPI2();
    fn TSC();
    fn DSIHSOT();
    fn AES();
    fn RNG_HASH();
    fn FPU();
    fn CRS();
    fn I2C4_ER();
    fn I2C4_EV();
    fn DCMI();
    fn DMA2D();
    fn LCD_TFT();
    fn LCD_TFT_ER();
    fn GFXMMU();
    fn DMAMUX_OVR();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 95] = [
    Vector { _handler: WWDG },
    Vector { _handler: PVD_PVM },
    Vector {
        _handler: TAMP_STAMP,
    },
    Vector { _handler: RTC_WKUP },
    Vector { _handler: FLASH },
    Vector { _handler: RCC },
    Vector { _handler: EXTI0 },
    Vector { _handler: EXTI1 },
    Vector { _handler: EXTI2 },
    Vector { _handler: EXTI3 },
    Vector { _handler: EXTI4 },
    Vector { _handler: DMA1_CH1 },
    Vector { _handler: DMA1_CH2 },
    Vector { _handler: DMA1_CH3 },
    Vector { _handler: DMA1_CH4 },
    Vector { _handler: DMA1_CH5 },
    Vector { _handler: DMA1_CH6 },
    Vector { _handler: DMA1_CH7 },
    Vector { _handler: ADC1 },
    Vector { _handler: CAN1_TX },
    Vector { _handler: CAN1_RX0 },
    Vector { _handler: CAN1_RX1 },
    Vector { _handler: CAN1_SCE },
    Vector { _handler: EXTI9_5 },
    Vector {
        _handler: TIM1_BRK_TIM15,
    },
    Vector {
        _handler: TIM1_UP_TIM16,
    },
    Vector {
        _handler: TIM1_TRG_COM_TIM17,
    },
    Vector { _handler: TIM1_CC },
    Vector { _handler: TIM2 },
    Vector { _handler: TIM3 },
    Vector { _handler: TIM4 },
    Vector { _handler: I2C1_EV },
    Vector { _handler: I2C1_ER },
    Vector { _handler: I2C2_EV },
    Vector { _handler: I2C2_ER },
    Vector { _handler: SPI1 },
    Vector { _handler: SPI2 },
    Vector { _handler: USART1 },
    Vector { _handler: USART2 },
    Vector { _handler: USART3 },
    Vector {
        _handler: EXTI15_10,
    },
    Vector {
        _handler: RTC_ALARM,
    },
    Vector {
        _handler: DFSDM1_FLT3,
    },
    Vector { _handler: TIM8_BRK },
    Vector { _handler: TIM8_UP },
    Vector {
        _handler: TIM8_TRG_COM,
    },
    Vector { _handler: TIM8_CC },
    Vector { _handler: ADC3 },
    Vector { _handler: FMC },
    Vector { _handler: SDMMC1 },
    Vector { _handler: TIM5 },
    Vector { _handler: SPI3 },
    Vector { _handler: UART4 },
    Vector { _handler: UART5 },
    Vector {
        _handler: TIM6_DACUNDER,
    },
    Vector { _handler: TIM7 },
    Vector { _handler: DMA2_CH1 },
    Vector { _handler: DMA2_CH2 },
    Vector { _handler: DMA2_CH3 },
    Vector { _handler: DMA2_CH4 },
    Vector { _handler: DMA2_CH5 },
    Vector {
        _handler: DFSDM1_FLT0,
    },
    Vector {
        _handler: DFSDM1_FLT1,
    },
    Vector {
        _handler: DFSDM1_FLT2,
    },
    Vector { _handler: COMP },
    Vector { _handler: LPTIM1 },
    Vector { _handler: LPTIM2 },
    Vector { _handler: OTG_FS },
    Vector { _handler: DMA2_CH6 },
    Vector { _handler: DMA2_CH7 },
    Vector { _handler: LPUART1 },
    Vector { _handler: OCTOSPI1 },
    Vector { _handler: I2C3_EV },
    Vector { _handler: I2C3_ER },
    Vector { _handler: SAI1 },
    Vector { _handler: SAI2 },
    Vector { _handler: OCTOSPI2 },
    Vector { _handler: TSC },
    Vector { _handler: DSIHSOT },
    Vector { _handler: AES },
    Vector { _handler: RNG_HASH },
    Vector { _handler: FPU },
    Vector { _handler: CRS },
    Vector { _handler: I2C4_ER },
    Vector { _handler: I2C4_EV },
    Vector { _handler: DCMI },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: DMA2D },
    Vector { _handler: LCD_TFT },
    Vector {
        _handler: LCD_TFT_ER,
    },
    Vector { _handler: GFXMMU },
    Vector {
        _handler: DMAMUX_OVR,
    },
];
///Enumeration of all the interrupts
#[derive(Copy, Clone, Debug)]
#[repr(u8)]
pub enum Interrupt {
    ///0 - Window Watchdog interrupt
    WWDG = 0,
    ///1 - PVD through EXTI line detection
    PVD_PVM = 1,
    ///2 - Tamper and TimeStamp interrupts
    TAMP_STAMP = 2,
    ///3 - RTC Tamper or TimeStamp /CSS on LSE through EXTI line 19 interrupts
    RTC_WKUP = 3,
    ///4 - Flash global interrupt
    FLASH = 4,
    ///5 - RCC global interrupt
    RCC = 5,
    ///6 - EXTI Line 0 interrupt
    EXTI0 = 6,
    ///7 - EXTI Line 1 interrupt
    EXTI1 = 7,
    ///8 - EXTI Line 2 interrupt
    EXTI2 = 8,
    ///9 - EXTI Line 3 interrupt
    EXTI3 = 9,
    ///10 - EXTI Line 4 interrupt
    EXTI4 = 10,
    ///11 - DMA1 Channel1 global interrupt
    DMA1_CH1 = 11,
    ///12 - DMA1 Channel2 global interrupt
    DMA1_CH2 = 12,
    ///13 - DMA1 Channel3 interrupt
    DMA1_CH3 = 13,
    ///14 - DMA1 Channel4 interrupt
    DMA1_CH4 = 14,
    ///15 - DMA1 Channel5 interrupt
    DMA1_CH5 = 15,
    ///16 - DMA1 Channel6 interrupt
    DMA1_CH6 = 16,
    ///17 - DMA1 Channel 7 interrupt
    DMA1_CH7 = 17,
    ///18 - ADC1 and ADC2 global interrupt
    ADC1 = 18,
    ///19 - CAN1 TX interrupts
    CAN1_TX = 19,
    ///20 - CAN1 RX0 interrupts
    CAN1_RX0 = 20,
    ///21 - CAN1 RX1 interrupts
    CAN1_RX1 = 21,
    ///22 - CAN1 SCE interrupt
    CAN1_SCE = 22,
    ///23 - EXTI Line5 to Line9 interrupts
    EXTI9_5 = 23,
    ///24 - TIM1 Break/TIM15 global interrupts
    TIM1_BRK_TIM15 = 24,
    ///25 - TIM1 Update/TIM16 global interrupts
    TIM1_UP_TIM16 = 25,
    ///26 - TIM1 Trigger and Commutation interrupts and TIM17 global interrupt
    TIM1_TRG_COM_TIM17 = 26,
    ///27 - TIM1 Capture Compare interrupt
    TIM1_CC = 27,
    ///28 - TIM2 global interrupt
    TIM2 = 28,
    ///29 - TIM3 global interrupt
    TIM3 = 29,
    ///30 - TIM4 global interrupt
    TIM4 = 30,
    ///31 - I2C1 event interrupt
    I2C1_EV = 31,
    ///32 - I2C1 error interrupt
    I2C1_ER = 32,
    ///33 - I2C2 event interrupt
    I2C2_EV = 33,
    ///34 - I2C2 error interrupt
    I2C2_ER = 34,
    ///35 - SPI1 global interrupt
    SPI1 = 35,
    ///36 - SPI2 global interrupt
    SPI2 = 36,
    ///37 - USART1 global interrupt
    USART1 = 37,
    ///38 - USART2 global interrupt
    USART2 = 38,
    ///39 - USART3 global interrupt
    USART3 = 39,
    ///40 - EXTI Lines 10 to 15 interrupts
    EXTI15_10 = 40,
    ///41 - RTC alarms through EXTI line 18 interrupts
    RTC_ALARM = 41,
    ///42 - DFSDM1_FLT3 global interrupt
    DFSDM1_FLT3 = 42,
    ///43 - TIM8 Break Interrupt
    TIM8_BRK = 43,
    ///44 - TIM8 Update Interrupt
    TIM8_UP = 44,
    ///45 - TIM8 Trigger and Commutation Interrupt
    TIM8_TRG_COM = 45,
    ///46 - TIM8 Capture Compare Interrupt
    TIM8_CC = 46,
    ///47 - ADC3 global interrupt
    ADC3 = 47,
    ///48 - FMC global Interrupt
    FMC = 48,
    ///49 - SDMMC global Interrupt
    SDMMC1 = 49,
    ///50 - TIM5 global Interrupt
    TIM5 = 50,
    ///51 - SPI3 global Interrupt
    SPI3 = 51,
    ///52 - UART4 global Interrupt
    UART4 = 52,
    ///53 - UART5 global Interrupt
    UART5 = 53,
    ///54 - TIM6 global and DAC1 and 2 underrun error interrupts
    TIM6_DACUNDER = 54,
    ///55 - TIM7 global interrupt
    TIM7 = 55,
    ///56 - DMA2 Channel 1 global Interrupt
    DMA2_CH1 = 56,
    ///57 - DMA2 Channel 2 global Interrupt
    DMA2_CH2 = 57,
    ///58 - DMA2 Channel 3 global Interrupt
    DMA2_CH3 = 58,
    ///59 - DMA2 Channel 4 global Interrupt
    DMA2_CH4 = 59,
    ///60 - DMA2 Channel 5 global Interrupt
    DMA2_CH5 = 60,
    ///61 - DFSDM1_FLT0 global interrupt
    DFSDM1_FLT0 = 61,
    ///62 - DFSDM1_FLT1 global interrupt
    DFSDM1_FLT1 = 62,
    ///63 - DFSDM1_FLT2 global interrupt
    DFSDM1_FLT2 = 63,
    ///64 - COMP1 and COMP2 interrupts
    COMP = 64,
    ///65 - LP TIM1 interrupt
    LPTIM1 = 65,
    ///66 - LP TIM2 interrupt
    LPTIM2 = 66,
    ///67 - USB OTG FS global Interrupt
    OTG_FS = 67,
    ///68 - DMA2 Channel 6 global Interrupt
    DMA2_CH6 = 68,
    ///69 - DMA2 Channel 7 global Interrupt
    DMA2_CH7 = 69,
    ///70 - LPUART1 global interrupt
    LPUART1 = 70,
    ///71 - OCTOSPI1 global interrupt
    OCTOSPI1 = 71,
    ///72 - I2C3 event interrupt
    I2C3_EV = 72,
    ///73 - I2C3 error interrupt
    I2C3_ER = 73,
    ///74 - SAI1 global interrupt
    SAI1 = 74,
    ///75 - SAI2 global interrupt
    SAI2 = 75,
    ///76 - OCTOSPI2 global interrupt
    OCTOSPI2 = 76,
    ///77 - TSC global interrupt
    TSC = 77,
    ///78 - DSI global interrupt
    DSIHSOT = 78,
    ///79 - AES global interrupt
    AES = 79,
    ///80 - RNG and HASH global interrupt
    RNG_HASH = 80,
    ///81 - Floating point interrupt
    FPU = 81,
    ///82 - CRS global interrupt
    CRS = 82,
    ///83 - I2C4 error interrupt
    I2C4_ER = 83,
    ///84 - I2C4 event interrupt
    I2C4_EV = 84,
    ///85 - DCMI global interrupt
    DCMI = 85,
    ///90 - DMA2D global interrupt
    DMA2D = 90,
    ///91 - LTDC global interrupt
    LCD_TFT = 91,
    ///92 - LTDC global error interrupt
    LCD_TFT_ER = 92,
    ///93 - GFXMMU global error interrupt
    GFXMMU = 93,
    ///94 - DMAMUX Overrun interrupt
    DMAMUX_OVR = 94,
}
unsafe impl bare_metal::Nr for Interrupt {
    #[inline(always)]
    fn nr(&self) -> u8 {
        *self as u8
    }
}
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
///Digital-to-analog converter
pub struct DAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DAC {}
impl DAC {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dac::RegisterBlock {
        0x4000_7400 as *const _
    }
}
impl Deref for DAC {
    type Target = dac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DAC::ptr() }
    }
}
///Digital-to-analog converter
pub mod dac {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - control register
        pub cr: CR,
        ///0x04 - software trigger register
        pub swtrigr: SWTRIGR,
        ///0x08 - channel1 12-bit right-aligned data holding register
        pub dhr12r1: DHR12R1,
        ///0x0c - channel1 12-bit left-aligned data holding register
        pub dhr12l1: DHR12L1,
        ///0x10 - channel1 8-bit right-aligned data holding register
        pub dhr8r1: DHR8R1,
        ///0x14 - channel2 12-bit right aligned data holding register
        pub dhr12r2: DHR12R2,
        ///0x18 - channel2 12-bit left aligned data holding register
        pub dhr12l2: DHR12L2,
        ///0x1c - channel2 8-bit right-aligned data holding register
        pub dhr8r2: DHR8R2,
        ///0x20 - Dual DAC 12-bit right-aligned data holding register
        pub dhr12rd: DHR12RD,
        ///0x24 - DUAL DAC 12-bit left aligned data holding register
        pub dhr12ld: DHR12LD,
        ///0x28 - DUAL DAC 8-bit right aligned data holding register
        pub dhr8rd: DHR8RD,
        ///0x2c - channel1 data output register
        pub dor1: DOR1,
        ///0x30 - channel2 data output register
        pub dor2: DOR2,
        ///0x34 - status register
        pub sr: SR,
        ///0x38 - calibration control register
        pub ccr: CCR,
        ///0x3c - mode control register
        pub mcr: MCR,
        ///0x40 - Sample and Hold sample time register 1
        pub shsr1: SHSR1,
        ///0x44 - Sample and Hold sample time register 2
        pub shsr2: SHSR2,
        ///0x48 - Sample and Hold hold time register
        pub shhr: SHHR,
        ///0x4c - Sample and Hold refresh time register
        pub shrr: SHRR,
    }
    ///control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `EN1`
        pub type EN1_R = crate::R<bool, bool>;
        ///Write proxy for field `EN1`
        pub struct EN1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `TEN1`
        pub type TEN1_R = crate::R<bool, bool>;
        ///Write proxy for field `TEN1`
        pub struct TEN1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEN1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `TSEL1`
        pub type TSEL1_R = crate::R<u8, u8>;
        ///Write proxy for field `TSEL1`
        pub struct TSEL1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSEL1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 3)) | (((value as u32) & 0x07) << 3);
                self.w
            }
        }
        ///Reader of field `WAVE1`
        pub type WAVE1_R = crate::R<u8, u8>;
        ///Write proxy for field `WAVE1`
        pub struct WAVE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WAVE1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 6)) | (((value as u32) & 0x03) << 6);
                self.w
            }
        }
        ///Reader of field `MAMP1`
        pub type MAMP1_R = crate::R<u8, u8>;
        ///Write proxy for field `MAMP1`
        pub struct MAMP1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MAMP1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 8)) | (((value as u32) & 0x0f) << 8);
                self.w
            }
        }
        ///Reader of field `DMAEN1`
        pub type DMAEN1_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAEN1`
        pub struct DMAEN1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAEN1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `DMAUDRIE1`
        pub type DMAUDRIE1_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAUDRIE1`
        pub struct DMAUDRIE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAUDRIE1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `CEN1`
        pub type CEN1_R = crate::R<bool, bool>;
        ///Write proxy for field `CEN1`
        pub struct CEN1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CEN1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `EN2`
        pub type EN2_R = crate::R<bool, bool>;
        ///Write proxy for field `EN2`
        pub struct EN2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `TEN2`
        pub type TEN2_R = crate::R<bool, bool>;
        ///Write proxy for field `TEN2`
        pub struct TEN2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEN2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `TSEL2`
        pub type TSEL2_R = crate::R<u8, u8>;
        ///Write proxy for field `TSEL2`
        pub struct TSEL2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSEL2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 19)) | (((value as u32) & 0x07) << 19);
                self.w
            }
        }
        ///Reader of field `WAVE2`
        pub type WAVE2_R = crate::R<u8, u8>;
        ///Write proxy for field `WAVE2`
        pub struct WAVE2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WAVE2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 22)) | (((value as u32) & 0x03) << 22);
                self.w
            }
        }
        ///Reader of field `MAMP2`
        pub type MAMP2_R = crate::R<u8, u8>;
        ///Write proxy for field `MAMP2`
        pub struct MAMP2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MAMP2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 24)) | (((value as u32) & 0x0f) << 24);
                self.w
            }
        }
        ///Reader of field `DMAEN2`
        pub type DMAEN2_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAEN2`
        pub struct DMAEN2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAEN2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `DMAUDRIE2`
        pub type DMAUDRIE2_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAUDRIE2`
        pub struct DMAUDRIE2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAUDRIE2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `CEN2`
        pub type CEN2_R = crate::R<bool, bool>;
        ///Write proxy for field `CEN2`
        pub struct CEN2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CEN2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        impl R {
            ///Bit 0 - DAC channel1 enable
            #[inline(always)]
            pub fn en1(&self) -> EN1_R {
                EN1_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 2 - DAC channel1 trigger enable
            #[inline(always)]
            pub fn ten1(&self) -> TEN1_R {
                TEN1_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bits 3:5 - DAC channel1 trigger selection
            #[inline(always)]
            pub fn tsel1(&self) -> TSEL1_R {
                TSEL1_R::new(((self.bits >> 3) & 0x07) as u8)
            }
            ///Bits 6:7 - DAC channel1 noise/triangle wave generation enable
            #[inline(always)]
            pub fn wave1(&self) -> WAVE1_R {
                WAVE1_R::new(((self.bits >> 6) & 0x03) as u8)
            }
            ///Bits 8:11 - DAC channel1 mask/amplitude selector
            #[inline(always)]
            pub fn mamp1(&self) -> MAMP1_R {
                MAMP1_R::new(((self.bits >> 8) & 0x0f) as u8)
            }
            ///Bit 12 - DAC channel1 DMA enable
            #[inline(always)]
            pub fn dmaen1(&self) -> DMAEN1_R {
                DMAEN1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 13 - DAC channel1 DMA Underrun Interrupt enable
            #[inline(always)]
            pub fn dmaudrie1(&self) -> DMAUDRIE1_R {
                DMAUDRIE1_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 14 - DAC Channel 1 calibration enable
            #[inline(always)]
            pub fn cen1(&self) -> CEN1_R {
                CEN1_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 16 - DAC channel2 enable
            #[inline(always)]
            pub fn en2(&self) -> EN2_R {
                EN2_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 18 - DAC channel2 trigger enable
            #[inline(always)]
            pub fn ten2(&self) -> TEN2_R {
                TEN2_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bits 19:21 - DAC channel2 trigger selection
            #[inline(always)]
            pub fn tsel2(&self) -> TSEL2_R {
                TSEL2_R::new(((self.bits >> 19) & 0x07) as u8)
            }
            ///Bits 22:23 - DAC channel2 noise/triangle wave generation enable
            #[inline(always)]
            pub fn wave2(&self) -> WAVE2_R {
                WAVE2_R::new(((self.bits >> 22) & 0x03) as u8)
            }
            ///Bits 24:27 - DAC channel2 mask/amplitude selector
            #[inline(always)]
            pub fn mamp2(&self) -> MAMP2_R {
                MAMP2_R::new(((self.bits >> 24) & 0x0f) as u8)
            }
            ///Bit 28 - DAC channel2 DMA enable
            #[inline(always)]
            pub fn dmaen2(&self) -> DMAEN2_R {
                DMAEN2_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 29 - DAC channel2 DMA underrun interrupt enable
            #[inline(always)]
            pub fn dmaudrie2(&self) -> DMAUDRIE2_R {
                DMAUDRIE2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 30 - DAC Channel 2 calibration enable
            #[inline(always)]
            pub fn cen2(&self) -> CEN2_R {
                CEN2_R::new(((self.bits >> 30) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 0 - DAC channel1 enable
            #[inline(always)]
            pub fn en1(&mut self) -> EN1_W {
                EN1_W { w: self }
            }
            ///Bit 2 - DAC channel1 trigger enable
            #[inline(always)]
            pub fn ten1(&mut self) -> TEN1_W {
                TEN1_W { w: self }
            }
            ///Bits 3:5 - DAC channel1 trigger selection
            #[inline(always)]
            pub fn tsel1(&mut self) -> TSEL1_W {
                TSEL1_W { w: self }
            }
            ///Bits 6:7 - DAC channel1 noise/triangle wave generation enable
            #[inline(always)]
            pub fn wave1(&mut self) -> WAVE1_W {
                WAVE1_W { w: self }
            }
            ///Bits 8:11 - DAC channel1 mask/amplitude selector
            #[inline(always)]
            pub fn mamp1(&mut self) -> MAMP1_W {
                MAMP1_W { w: self }
            }
            ///Bit 12 - DAC channel1 DMA enable
            #[inline(always)]
            pub fn dmaen1(&mut self) -> DMAEN1_W {
                DMAEN1_W { w: self }
            }
            ///Bit 13 - DAC channel1 DMA Underrun Interrupt enable
            #[inline(always)]
            pub fn dmaudrie1(&mut self) -> DMAUDRIE1_W {
                DMAUDRIE1_W { w: self }
            }
            ///Bit 14 - DAC Channel 1 calibration enable
            #[inline(always)]
            pub fn cen1(&mut self) -> CEN1_W {
                CEN1_W { w: self }
            }
            ///Bit 16 - DAC channel2 enable
            #[inline(always)]
            pub fn en2(&mut self) -> EN2_W {
                EN2_W { w: self }
            }
            ///Bit 18 - DAC channel2 trigger enable
            #[inline(always)]
            pub fn ten2(&mut self) -> TEN2_W {
                TEN2_W { w: self }
            }
            ///Bits 19:21 - DAC channel2 trigger selection
            #[inline(always)]
            pub fn tsel2(&mut self) -> TSEL2_W {
                TSEL2_W { w: self }
            }
            ///Bits 22:23 - DAC channel2 noise/triangle wave generation enable
            #[inline(always)]
            pub fn wave2(&mut self) -> WAVE2_W {
                WAVE2_W { w: self }
            }
            ///Bits 24:27 - DAC channel2 mask/amplitude selector
            #[inline(always)]
            pub fn mamp2(&mut self) -> MAMP2_W {
                MAMP2_W { w: self }
            }
            ///Bit 28 - DAC channel2 DMA enable
            #[inline(always)]
            pub fn dmaen2(&mut self) -> DMAEN2_W {
                DMAEN2_W { w: self }
            }
            ///Bit 29 - DAC channel2 DMA underrun interrupt enable
            #[inline(always)]
            pub fn dmaudrie2(&mut self) -> DMAUDRIE2_W {
                DMAUDRIE2_W { w: self }
            }
            ///Bit 30 - DAC Channel 2 calibration enable
            #[inline(always)]
            pub fn cen2(&mut self) -> CEN2_W {
                CEN2_W { w: self }
            }
        }
    }
    ///software trigger register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [swtrigr](swtrigr) module
    pub type SWTRIGR = crate::Reg<u32, _SWTRIGR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SWTRIGR;
    ///`write(|w| ..)` method takes [swtrigr::W](swtrigr::W) writer structure
    impl crate::Writable for SWTRIGR {}
    ///software trigger register
    pub mod swtrigr {
        ///Writer for register SWTRIGR
        pub type W = crate::W<u32, super::SWTRIGR>;
        ///Register SWTRIGR `reset()`'s with value 0
        impl crate::ResetValue for super::SWTRIGR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `SWTRIG1`
        pub struct SWTRIG1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SWTRIG1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Write proxy for field `SWTRIG2`
        pub struct SWTRIG2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SWTRIG2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        impl W {
            ///Bit 0 - DAC channel1 software trigger
            #[inline(always)]
            pub fn swtrig1(&mut self) -> SWTRIG1_W {
                SWTRIG1_W { w: self }
            }
            ///Bit 1 - DAC channel2 software trigger
            #[inline(always)]
            pub fn swtrig2(&mut self) -> SWTRIG2_W {
                SWTRIG2_W { w: self }
            }
        }
    }
    ///channel1 12-bit right-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12r1](dhr12r1) module
    pub type DHR12R1 = crate::Reg<u32, _DHR12R1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12R1;
    ///`read()` method returns [dhr12r1::R](dhr12r1::R) reader structure
    impl crate::Readable for DHR12R1 {}
    ///`write(|w| ..)` method takes [dhr12r1::W](dhr12r1::W) writer structure
    impl crate::Writable for DHR12R1 {}
    ///channel1 12-bit right-aligned data holding register
    pub mod dhr12r1 {
        ///Reader of register DHR12R1
        pub type R = crate::R<u32, super::DHR12R1>;
        ///Writer for register DHR12R1
        pub type W = crate::W<u32, super::DHR12R1>;
        ///Register DHR12R1 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12R1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - DAC channel1 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new((self.bits & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - DAC channel1 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
        }
    }
    ///channel1 12-bit left-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12l1](dhr12l1) module
    pub type DHR12L1 = crate::Reg<u32, _DHR12L1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12L1;
    ///`read()` method returns [dhr12l1::R](dhr12l1::R) reader structure
    impl crate::Readable for DHR12L1 {}
    ///`write(|w| ..)` method takes [dhr12l1::W](dhr12l1::W) writer structure
    impl crate::Writable for DHR12L1 {}
    ///channel1 12-bit left-aligned data holding register
    pub mod dhr12l1 {
        ///Reader of register DHR12L1
        pub type R = crate::R<u32, super::DHR12L1>;
        ///Writer for register DHR12L1
        pub type W = crate::W<u32, super::DHR12L1>;
        ///Register DHR12L1 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12L1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 4)) | (((value as u32) & 0x0fff) << 4);
                self.w
            }
        }
        impl R {
            ///Bits 4:15 - DAC channel1 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new(((self.bits >> 4) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 4:15 - DAC channel1 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
        }
    }
    ///channel1 8-bit right-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr8r1](dhr8r1) module
    pub type DHR8R1 = crate::Reg<u32, _DHR8R1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR8R1;
    ///`read()` method returns [dhr8r1::R](dhr8r1::R) reader structure
    impl crate::Readable for DHR8R1 {}
    ///`write(|w| ..)` method takes [dhr8r1::W](dhr8r1::W) writer structure
    impl crate::Writable for DHR8R1 {}
    ///channel1 8-bit right-aligned data holding register
    pub mod dhr8r1 {
        ///Reader of register DHR8R1
        pub type R = crate::R<u32, super::DHR8R1>;
        ///Writer for register DHR8R1
        pub type W = crate::W<u32, super::DHR8R1>;
        ///Register DHR8R1 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR8R1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u8, u8>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - DAC channel1 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - DAC channel1 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
        }
    }
    ///channel2 12-bit right aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12r2](dhr12r2) module
    pub type DHR12R2 = crate::Reg<u32, _DHR12R2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12R2;
    ///`read()` method returns [dhr12r2::R](dhr12r2::R) reader structure
    impl crate::Readable for DHR12R2 {}
    ///`write(|w| ..)` method takes [dhr12r2::W](dhr12r2::W) writer structure
    impl crate::Writable for DHR12R2 {}
    ///channel2 12-bit right aligned data holding register
    pub mod dhr12r2 {
        ///Reader of register DHR12R2
        pub type R = crate::R<u32, super::DHR12R2>;
        ///Writer for register DHR12R2
        pub type W = crate::W<u32, super::DHR12R2>;
        ///Register DHR12R2 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12R2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - DAC channel2 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new((self.bits & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - DAC channel2 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///channel2 12-bit left aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12l2](dhr12l2) module
    pub type DHR12L2 = crate::Reg<u32, _DHR12L2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12L2;
    ///`read()` method returns [dhr12l2::R](dhr12l2::R) reader structure
    impl crate::Readable for DHR12L2 {}
    ///`write(|w| ..)` method takes [dhr12l2::W](dhr12l2::W) writer structure
    impl crate::Writable for DHR12L2 {}
    ///channel2 12-bit left aligned data holding register
    pub mod dhr12l2 {
        ///Reader of register DHR12L2
        pub type R = crate::R<u32, super::DHR12L2>;
        ///Writer for register DHR12L2
        pub type W = crate::W<u32, super::DHR12L2>;
        ///Register DHR12L2 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12L2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 4)) | (((value as u32) & 0x0fff) << 4);
                self.w
            }
        }
        impl R {
            ///Bits 4:15 - DAC channel2 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new(((self.bits >> 4) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 4:15 - DAC channel2 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///channel2 8-bit right-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr8r2](dhr8r2) module
    pub type DHR8R2 = crate::Reg<u32, _DHR8R2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR8R2;
    ///`read()` method returns [dhr8r2::R](dhr8r2::R) reader structure
    impl crate::Readable for DHR8R2 {}
    ///`write(|w| ..)` method takes [dhr8r2::W](dhr8r2::W) writer structure
    impl crate::Writable for DHR8R2 {}
    ///channel2 8-bit right-aligned data holding register
    pub mod dhr8r2 {
        ///Reader of register DHR8R2
        pub type R = crate::R<u32, super::DHR8R2>;
        ///Writer for register DHR8R2
        pub type W = crate::W<u32, super::DHR8R2>;
        ///Register DHR8R2 `reset()`'s with value 0
        impl crate::ResetValue for super::DHR8R2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u8, u8>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - DAC channel2 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - DAC channel2 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///Dual DAC 12-bit right-aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12rd](dhr12rd) module
    pub type DHR12RD = crate::Reg<u32, _DHR12RD>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12RD;
    ///`read()` method returns [dhr12rd::R](dhr12rd::R) reader structure
    impl crate::Readable for DHR12RD {}
    ///`write(|w| ..)` method takes [dhr12rd::W](dhr12rd::W) writer structure
    impl crate::Writable for DHR12RD {}
    ///Dual DAC 12-bit right-aligned data holding register
    pub mod dhr12rd {
        ///Reader of register DHR12RD
        pub type R = crate::R<u32, super::DHR12RD>;
        ///Writer for register DHR12RD
        pub type W = crate::W<u32, super::DHR12RD>;
        ///Register DHR12RD `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12RD {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 16)) | (((value as u32) & 0x0fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - DAC channel1 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new((self.bits & 0x0fff) as u16)
            }
            ///Bits 16:27 - DAC channel2 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new(((self.bits >> 16) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - DAC channel1 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
            ///Bits 16:27 - DAC channel2 12-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///DUAL DAC 12-bit left aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr12ld](dhr12ld) module
    pub type DHR12LD = crate::Reg<u32, _DHR12LD>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR12LD;
    ///`read()` method returns [dhr12ld::R](dhr12ld::R) reader structure
    impl crate::Readable for DHR12LD {}
    ///`write(|w| ..)` method takes [dhr12ld::W](dhr12ld::W) writer structure
    impl crate::Writable for DHR12LD {}
    ///DUAL DAC 12-bit left aligned data holding register
    pub mod dhr12ld {
        ///Reader of register DHR12LD
        pub type R = crate::R<u32, super::DHR12LD>;
        ///Writer for register DHR12LD
        pub type W = crate::W<u32, super::DHR12LD>;
        ///Register DHR12LD `reset()`'s with value 0
        impl crate::ResetValue for super::DHR12LD {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 4)) | (((value as u32) & 0x0fff) << 4);
                self.w
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u16, u16>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 20)) | (((value as u32) & 0x0fff) << 20);
                self.w
            }
        }
        impl R {
            ///Bits 4:15 - DAC channel1 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new(((self.bits >> 4) & 0x0fff) as u16)
            }
            ///Bits 20:31 - DAC channel2 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new(((self.bits >> 20) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 4:15 - DAC channel1 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
            ///Bits 20:31 - DAC channel2 12-bit left-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///DUAL DAC 8-bit right aligned data holding register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dhr8rd](dhr8rd) module
    pub type DHR8RD = crate::Reg<u32, _DHR8RD>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DHR8RD;
    ///`read()` method returns [dhr8rd::R](dhr8rd::R) reader structure
    impl crate::Readable for DHR8RD {}
    ///`write(|w| ..)` method takes [dhr8rd::W](dhr8rd::W) writer structure
    impl crate::Writable for DHR8RD {}
    ///DUAL DAC 8-bit right aligned data holding register
    pub mod dhr8rd {
        ///Reader of register DHR8RD
        pub type R = crate::R<u32, super::DHR8RD>;
        ///Writer for register DHR8RD
        pub type W = crate::W<u32, super::DHR8RD>;
        ///Register DHR8RD `reset()`'s with value 0
        impl crate::ResetValue for super::DHR8RD {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DACC1DHR`
        pub type DACC1DHR_R = crate::R<u8, u8>;
        ///Write proxy for field `DACC1DHR`
        pub struct DACC1DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC1DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `DACC2DHR`
        pub type DACC2DHR_R = crate::R<u8, u8>;
        ///Write proxy for field `DACC2DHR`
        pub struct DACC2DHR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DACC2DHR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - DAC channel1 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&self) -> DACC1DHR_R {
                DACC1DHR_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 8:15 - DAC channel2 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&self) -> DACC2DHR_R {
                DACC2DHR_R::new(((self.bits >> 8) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - DAC channel1 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc1dhr(&mut self) -> DACC1DHR_W {
                DACC1DHR_W { w: self }
            }
            ///Bits 8:15 - DAC channel2 8-bit right-aligned data
            #[inline(always)]
            pub fn dacc2dhr(&mut self) -> DACC2DHR_W {
                DACC2DHR_W { w: self }
            }
        }
    }
    ///channel1 data output register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dor1](dor1) module
    pub type DOR1 = crate::Reg<u32, _DOR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DOR1;
    ///`read()` method returns [dor1::R](dor1::R) reader structure
    impl crate::Readable for DOR1 {}
    ///channel1 data output register
    pub mod dor1 {
        ///Reader of register DOR1
        pub type R = crate::R<u32, super::DOR1>;
        ///Reader of field `DACC1DOR`
        pub type DACC1DOR_R = crate::R<u16, u16>;
        impl R {
            ///Bits 0:11 - DAC channel1 data output
            #[inline(always)]
            pub fn dacc1dor(&self) -> DACC1DOR_R {
                DACC1DOR_R::new((self.bits & 0x0fff) as u16)
            }
        }
    }
    ///channel2 data output register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dor2](dor2) module
    pub type DOR2 = crate::Reg<u32, _DOR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DOR2;
    ///`read()` method returns [dor2::R](dor2::R) reader structure
    impl crate::Readable for DOR2 {}
    ///channel2 data output register
    pub mod dor2 {
        ///Reader of register DOR2
        pub type R = crate::R<u32, super::DOR2>;
        ///Reader of field `DACC2DOR`
        pub type DACC2DOR_R = crate::R<u16, u16>;
        impl R {
            ///Bits 0:11 - DAC channel2 data output
            #[inline(always)]
            pub fn dacc2dor(&self) -> DACC2DOR_R {
                DACC2DOR_R::new((self.bits & 0x0fff) as u16)
            }
        }
    }
    ///status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [sr](sr) module
    pub type SR = crate::Reg<u32, _SR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SR;
    ///`read()` method returns [sr::R](sr::R) reader structure
    impl crate::Readable for SR {}
    ///`write(|w| ..)` method takes [sr::W](sr::W) writer structure
    impl crate::Writable for SR {}
    ///status register
    pub mod sr {
        ///Reader of register SR
        pub type R = crate::R<u32, super::SR>;
        ///Writer for register SR
        pub type W = crate::W<u32, super::SR>;
        ///Register SR `reset()`'s with value 0
        impl crate::ResetValue for super::SR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DMAUDR1`
        pub type DMAUDR1_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAUDR1`
        pub struct DMAUDR1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAUDR1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `CAL_FLAG1`
        pub type CAL_FLAG1_R = crate::R<bool, bool>;
        ///Reader of field `BWST1`
        pub type BWST1_R = crate::R<bool, bool>;
        ///Reader of field `DMAUDR2`
        pub type DMAUDR2_R = crate::R<bool, bool>;
        ///Write proxy for field `DMAUDR2`
        pub struct DMAUDR2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAUDR2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `CAL_FLAG2`
        pub type CAL_FLAG2_R = crate::R<bool, bool>;
        ///Reader of field `BWST2`
        pub type BWST2_R = crate::R<bool, bool>;
        impl R {
            ///Bit 13 - DAC channel1 DMA underrun flag
            #[inline(always)]
            pub fn dmaudr1(&self) -> DMAUDR1_R {
                DMAUDR1_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 14 - DAC Channel 1 calibration offset status
            #[inline(always)]
            pub fn cal_flag1(&self) -> CAL_FLAG1_R {
                CAL_FLAG1_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 15 - DAC Channel 1 busy writing sample time flag
            #[inline(always)]
            pub fn bwst1(&self) -> BWST1_R {
                BWST1_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 29 - DAC channel2 DMA underrun flag
            #[inline(always)]
            pub fn dmaudr2(&self) -> DMAUDR2_R {
                DMAUDR2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 30 - DAC Channel 2 calibration offset status
            #[inline(always)]
            pub fn cal_flag2(&self) -> CAL_FLAG2_R {
                CAL_FLAG2_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 31 - DAC Channel 2 busy writing sample time flag
            #[inline(always)]
            pub fn bwst2(&self) -> BWST2_R {
                BWST2_R::new(((self.bits >> 31) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 13 - DAC channel1 DMA underrun flag
            #[inline(always)]
            pub fn dmaudr1(&mut self) -> DMAUDR1_W {
                DMAUDR1_W { w: self }
            }
            ///Bit 29 - DAC channel2 DMA underrun flag
            #[inline(always)]
            pub fn dmaudr2(&mut self) -> DMAUDR2_W {
                DMAUDR2_W { w: self }
            }
        }
    }
    ///calibration control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr](ccr) module
    pub type CCR = crate::Reg<u32, _CCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR;
    ///`read()` method returns [ccr::R](ccr::R) reader structure
    impl crate::Readable for CCR {}
    ///`write(|w| ..)` method takes [ccr::W](ccr::W) writer structure
    impl crate::Writable for CCR {}
    ///calibration control register
    pub mod ccr {
        ///Reader of register CCR
        pub type R = crate::R<u32, super::CCR>;
        ///Writer for register CCR
        pub type W = crate::W<u32, super::CCR>;
        ///Register CCR `reset()`'s with value 0
        impl crate::ResetValue for super::CCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `OTRIM1`
        pub type OTRIM1_R = crate::R<u8, u8>;
        ///Write proxy for field `OTRIM1`
        pub struct OTRIM1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OTRIM1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        ///Reader of field `OTRIM2`
        pub type OTRIM2_R = crate::R<u8, u8>;
        ///Write proxy for field `OTRIM2`
        pub struct OTRIM2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OTRIM2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 16)) | (((value as u32) & 0x1f) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:4 - DAC Channel 1 offset trimming value
            #[inline(always)]
            pub fn otrim1(&self) -> OTRIM1_R {
                OTRIM1_R::new((self.bits & 0x1f) as u8)
            }
            ///Bits 16:20 - DAC Channel 2 offset trimming value
            #[inline(always)]
            pub fn otrim2(&self) -> OTRIM2_R {
                OTRIM2_R::new(((self.bits >> 16) & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 0:4 - DAC Channel 1 offset trimming value
            #[inline(always)]
            pub fn otrim1(&mut self) -> OTRIM1_W {
                OTRIM1_W { w: self }
            }
            ///Bits 16:20 - DAC Channel 2 offset trimming value
            #[inline(always)]
            pub fn otrim2(&mut self) -> OTRIM2_W {
                OTRIM2_W { w: self }
            }
        }
    }
    ///mode control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [mcr](mcr) module
    pub type MCR = crate::Reg<u32, _MCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _MCR;
    ///`read()` method returns [mcr::R](mcr::R) reader structure
    impl crate::Readable for MCR {}
    ///`write(|w| ..)` method takes [mcr::W](mcr::W) writer structure
    impl crate::Writable for MCR {}
    ///mode control register
    pub mod mcr {
        ///Reader of register MCR
        pub type R = crate::R<u32, super::MCR>;
        ///Writer for register MCR
        pub type W = crate::W<u32, super::MCR>;
        ///Register MCR `reset()`'s with value 0
        impl crate::ResetValue for super::MCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MODE1`
        pub type MODE1_R = crate::R<u8, u8>;
        ///Write proxy for field `MODE1`
        pub struct MODE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MODE1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07) | ((value as u32) & 0x07);
                self.w
            }
        }
        ///Reader of field `MODE2`
        pub type MODE2_R = crate::R<u8, u8>;
        ///Write proxy for field `MODE2`
        pub struct MODE2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MODE2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 16)) | (((value as u32) & 0x07) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:2 - DAC Channel 1 mode
            #[inline(always)]
            pub fn mode1(&self) -> MODE1_R {
                MODE1_R::new((self.bits & 0x07) as u8)
            }
            ///Bits 16:18 - DAC Channel 2 mode
            #[inline(always)]
            pub fn mode2(&self) -> MODE2_R {
                MODE2_R::new(((self.bits >> 16) & 0x07) as u8)
            }
        }
        impl W {
            ///Bits 0:2 - DAC Channel 1 mode
            #[inline(always)]
            pub fn mode1(&mut self) -> MODE1_W {
                MODE1_W { w: self }
            }
            ///Bits 16:18 - DAC Channel 2 mode
            #[inline(always)]
            pub fn mode2(&mut self) -> MODE2_W {
                MODE2_W { w: self }
            }
        }
    }
    ///Sample and Hold sample time register 1
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [shsr1](shsr1) module
    pub type SHSR1 = crate::Reg<u32, _SHSR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SHSR1;
    ///`read()` method returns [shsr1::R](shsr1::R) reader structure
    impl crate::Readable for SHSR1 {}
    ///`write(|w| ..)` method takes [shsr1::W](shsr1::W) writer structure
    impl crate::Writable for SHSR1 {}
    ///Sample and Hold sample time register 1
    pub mod shsr1 {
        ///Reader of register SHSR1
        pub type R = crate::R<u32, super::SHSR1>;
        ///Writer for register SHSR1
        pub type W = crate::W<u32, super::SHSR1>;
        ///Register SHSR1 `reset()`'s with value 0
        impl crate::ResetValue for super::SHSR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `TSAMPLE1`
        pub type TSAMPLE1_R = crate::R<u16, u16>;
        ///Write proxy for field `TSAMPLE1`
        pub struct TSAMPLE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSAMPLE1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x03ff) | ((value as u32) & 0x03ff);
                self.w
            }
        }
        impl R {
            ///Bits 0:9 - DAC Channel 1 sample Time
            #[inline(always)]
            pub fn tsample1(&self) -> TSAMPLE1_R {
                TSAMPLE1_R::new((self.bits & 0x03ff) as u16)
            }
        }
        impl W {
            ///Bits 0:9 - DAC Channel 1 sample Time
            #[inline(always)]
            pub fn tsample1(&mut self) -> TSAMPLE1_W {
                TSAMPLE1_W { w: self }
            }
        }
    }
    ///Sample and Hold sample time register 2
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [shsr2](shsr2) module
    pub type SHSR2 = crate::Reg<u32, _SHSR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SHSR2;
    ///`read()` method returns [shsr2::R](shsr2::R) reader structure
    impl crate::Readable for SHSR2 {}
    ///`write(|w| ..)` method takes [shsr2::W](shsr2::W) writer structure
    impl crate::Writable for SHSR2 {}
    ///Sample and Hold sample time register 2
    pub mod shsr2 {
        ///Reader of register SHSR2
        pub type R = crate::R<u32, super::SHSR2>;
        ///Writer for register SHSR2
        pub type W = crate::W<u32, super::SHSR2>;
        ///Register SHSR2 `reset()`'s with value 0
        impl crate::ResetValue for super::SHSR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `TSAMPLE2`
        pub type TSAMPLE2_R = crate::R<u16, u16>;
        ///Write proxy for field `TSAMPLE2`
        pub struct TSAMPLE2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSAMPLE2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x03ff) | ((value as u32) & 0x03ff);
                self.w
            }
        }
        impl R {
            ///Bits 0:9 - DAC Channel 2 sample Time
            #[inline(always)]
            pub fn tsample2(&self) -> TSAMPLE2_R {
                TSAMPLE2_R::new((self.bits & 0x03ff) as u16)
            }
        }
        impl W {
            ///Bits 0:9 - DAC Channel 2 sample Time
            #[inline(always)]
            pub fn tsample2(&mut self) -> TSAMPLE2_W {
                TSAMPLE2_W { w: self }
            }
        }
    }
    ///Sample and Hold hold time register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [shhr](shhr) module
    pub type SHHR = crate::Reg<u32, _SHHR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SHHR;
    ///`read()` method returns [shhr::R](shhr::R) reader structure
    impl crate::Readable for SHHR {}
    ///`write(|w| ..)` method takes [shhr::W](shhr::W) writer structure
    impl crate::Writable for SHHR {}
    ///Sample and Hold hold time register
    pub mod shhr {
        ///Reader of register SHHR
        pub type R = crate::R<u32, super::SHHR>;
        ///Writer for register SHHR
        pub type W = crate::W<u32, super::SHHR>;
        ///Register SHHR `reset()`'s with value 0x0001_0001
        impl crate::ResetValue for super::SHHR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x0001_0001
            }
        }
        ///Reader of field `THOLD1`
        pub type THOLD1_R = crate::R<u16, u16>;
        ///Write proxy for field `THOLD1`
        pub struct THOLD1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> THOLD1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x03ff) | ((value as u32) & 0x03ff);
                self.w
            }
        }
        ///Reader of field `THOLD2`
        pub type THOLD2_R = crate::R<u16, u16>;
        ///Write proxy for field `THOLD2`
        pub struct THOLD2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> THOLD2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03ff << 16)) | (((value as u32) & 0x03ff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:9 - DAC Channel 1 hold Time
            #[inline(always)]
            pub fn thold1(&self) -> THOLD1_R {
                THOLD1_R::new((self.bits & 0x03ff) as u16)
            }
            ///Bits 16:25 - DAC Channel 2 hold time
            #[inline(always)]
            pub fn thold2(&self) -> THOLD2_R {
                THOLD2_R::new(((self.bits >> 16) & 0x03ff) as u16)
            }
        }
        impl W {
            ///Bits 0:9 - DAC Channel 1 hold Time
            #[inline(always)]
            pub fn thold1(&mut self) -> THOLD1_W {
                THOLD1_W { w: self }
            }
            ///Bits 16:25 - DAC Channel 2 hold time
            #[inline(always)]
            pub fn thold2(&mut self) -> THOLD2_W {
                THOLD2_W { w: self }
            }
        }
    }
    ///Sample and Hold refresh time register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [shrr](shrr) module
    pub type SHRR = crate::Reg<u32, _SHRR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SHRR;
    ///`read()` method returns [shrr::R](shrr::R) reader structure
    impl crate::Readable for SHRR {}
    ///`write(|w| ..)` method takes [shrr::W](shrr::W) writer structure
    impl crate::Writable for SHRR {}
    ///Sample and Hold refresh time register
    pub mod shrr {
        ///Reader of register SHRR
        pub type R = crate::R<u32, super::SHRR>;
        ///Writer for register SHRR
        pub type W = crate::W<u32, super::SHRR>;
        ///Register SHRR `reset()`'s with value 0x01
        impl crate::ResetValue for super::SHRR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x01
            }
        }
        ///Reader of field `TREFRESH1`
        pub type TREFRESH1_R = crate::R<u8, u8>;
        ///Write proxy for field `TREFRESH1`
        pub struct TREFRESH1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TREFRESH1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `TREFRESH2`
        pub type TREFRESH2_R = crate::R<u8, u8>;
        ///Write proxy for field `TREFRESH2`
        pub struct TREFRESH2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TREFRESH2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - DAC Channel 1 refresh Time
            #[inline(always)]
            pub fn trefresh1(&self) -> TREFRESH1_R {
                TREFRESH1_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 16:23 - DAC Channel 2 refresh Time
            #[inline(always)]
            pub fn trefresh2(&self) -> TREFRESH2_R {
                TREFRESH2_R::new(((self.bits >> 16) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - DAC Channel 1 refresh Time
            #[inline(always)]
            pub fn trefresh1(&mut self) -> TREFRESH1_W {
                TREFRESH1_W { w: self }
            }
            ///Bits 16:23 - DAC Channel 2 refresh Time
            #[inline(always)]
            pub fn trefresh2(&mut self) -> TREFRESH2_W {
                TREFRESH2_W { w: self }
            }
        }
    }
}
///Direct memory access controller
pub struct DMA1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA1 {}
impl DMA1 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dma1::RegisterBlock {
        0x4002_0000 as *const _
    }
}
impl Deref for DMA1 {
    type Target = dma1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DMA1::ptr() }
    }
}
///Direct memory access controller
pub mod dma1 {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - interrupt status register
        pub isr: ISR,
        ///0x04 - interrupt flag clear register
        pub ifcr: IFCR,
        ///0x08 - channel x configuration register
        pub ccr1: CCR1,
        ///0x0c - channel x number of data register
        pub cndtr1: CNDTR1,
        ///0x10 - channel x peripheral address register
        pub cpar1: CPAR1,
        ///0x14 - channel x memory address register
        pub cmar1: CMAR1,
        _reserved6: [u8; 4usize],
        ///0x1c - channel x configuration register
        pub ccr2: CCR2,
        ///0x20 - channel x number of data register
        pub cndtr2: CNDTR2,
        ///0x24 - channel x peripheral address register
        pub cpar2: CPAR2,
        ///0x28 - channel x memory address register
        pub cmar2: CMAR2,
        _reserved10: [u8; 4usize],
        ///0x30 - channel x configuration register
        pub ccr3: CCR3,
        ///0x34 - channel x number of data register
        pub cndtr3: CNDTR3,
        ///0x38 - channel x peripheral address register
        pub cpar3: CPAR3,
        ///0x3c - channel x memory address register
        pub cmar3: CMAR3,
        _reserved14: [u8; 4usize],
        ///0x44 - channel x configuration register
        pub ccr4: CCR4,
        ///0x48 - channel x number of data register
        pub cndtr4: CNDTR4,
        ///0x4c - channel x peripheral address register
        pub cpar4: CPAR4,
        ///0x50 - channel x memory address register
        pub cmar4: CMAR4,
        _reserved18: [u8; 4usize],
        ///0x58 - channel x configuration register
        pub ccr5: CCR5,
        ///0x5c - channel x number of data register
        pub cndtr5: CNDTR5,
        ///0x60 - channel x peripheral address register
        pub cpar5: CPAR5,
        ///0x64 - channel x memory address register
        pub cmar5: CMAR5,
        _reserved22: [u8; 4usize],
        ///0x6c - channel x configuration register
        pub ccr6: CCR6,
        ///0x70 - channel x number of data register
        pub cndtr6: CNDTR6,
        ///0x74 - channel x peripheral address register
        pub cpar6: CPAR6,
        ///0x78 - channel x memory address register
        pub cmar6: CMAR6,
        _reserved26: [u8; 4usize],
        ///0x80 - channel x configuration register
        pub ccr7: CCR7,
        ///0x84 - channel x number of data register
        pub cndtr7: CNDTR7,
        ///0x88 - channel x peripheral address register
        pub cpar7: CPAR7,
        ///0x8c - channel x memory address register
        pub cmar7: CMAR7,
    }
    ///interrupt status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [isr](isr) module
    pub type ISR = crate::Reg<u32, _ISR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ISR;
    ///`read()` method returns [isr::R](isr::R) reader structure
    impl crate::Readable for ISR {}
    ///interrupt status register
    pub mod isr {
        ///Reader of register ISR
        pub type R = crate::R<u32, super::ISR>;
        ///Channel x transfer error flag (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIF7_A {
            ///0: No transfer error
            NOERROR = 0,
            ///1: A transfer error has occured
            ERROR = 1,
        }
        impl From<TEIF7_A> for bool {
            #[inline(always)]
            fn from(variant: TEIF7_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIF7`
        pub type TEIF7_R = crate::R<bool, TEIF7_A>;
        impl TEIF7_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIF7_A {
                match self.bits {
                    false => TEIF7_A::NOERROR,
                    true => TEIF7_A::ERROR,
                }
            }
            ///Checks if the value of the field is `NOERROR`
            #[inline(always)]
            pub fn is_no_error(&self) -> bool {
                *self == TEIF7_A::NOERROR
            }
            ///Checks if the value of the field is `ERROR`
            #[inline(always)]
            pub fn is_error(&self) -> bool {
                *self == TEIF7_A::ERROR
            }
        }
        ///Channel x half transfer flag (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIF7_A {
            ///0: No half transfer event
            NOTHALF = 0,
            ///1: A half transfer event has occured
            HALF = 1,
        }
        impl From<HTIF7_A> for bool {
            #[inline(always)]
            fn from(variant: HTIF7_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIF7`
        pub type HTIF7_R = crate::R<bool, HTIF7_A>;
        impl HTIF7_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIF7_A {
                match self.bits {
                    false => HTIF7_A::NOTHALF,
                    true => HTIF7_A::HALF,
                }
            }
            ///Checks if the value of the field is `NOTHALF`
            #[inline(always)]
            pub fn is_not_half(&self) -> bool {
                *self == HTIF7_A::NOTHALF
            }
            ///Checks if the value of the field is `HALF`
            #[inline(always)]
            pub fn is_half(&self) -> bool {
                *self == HTIF7_A::HALF
            }
        }
        ///Channel x transfer complete flag (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIF7_A {
            ///0: No transfer complete event
            NOTCOMPLETE = 0,
            ///1: A transfer complete event has occured
            COMPLETE = 1,
        }
        impl From<TCIF7_A> for bool {
            #[inline(always)]
            fn from(variant: TCIF7_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIF7`
        pub type TCIF7_R = crate::R<bool, TCIF7_A>;
        impl TCIF7_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIF7_A {
                match self.bits {
                    false => TCIF7_A::NOTCOMPLETE,
                    true => TCIF7_A::COMPLETE,
                }
            }
            ///Checks if the value of the field is `NOTCOMPLETE`
            #[inline(always)]
            pub fn is_not_complete(&self) -> bool {
                *self == TCIF7_A::NOTCOMPLETE
            }
            ///Checks if the value of the field is `COMPLETE`
            #[inline(always)]
            pub fn is_complete(&self) -> bool {
                *self == TCIF7_A::COMPLETE
            }
        }
        ///Channel x global interrupt flag (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum GIF7_A {
            ///0: No transfer error, half event, complete event
            NOEVENT = 0,
            ///1: A transfer error, half event or complete event has occured
            EVENT = 1,
        }
        impl From<GIF7_A> for bool {
            #[inline(always)]
            fn from(variant: GIF7_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `GIF7`
        pub type GIF7_R = crate::R<bool, GIF7_A>;
        impl GIF7_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> GIF7_A {
                match self.bits {
                    false => GIF7_A::NOEVENT,
                    true => GIF7_A::EVENT,
                }
            }
            ///Checks if the value of the field is `NOEVENT`
            #[inline(always)]
            pub fn is_no_event(&self) -> bool {
                *self == GIF7_A::NOEVENT
            }
            ///Checks if the value of the field is `EVENT`
            #[inline(always)]
            pub fn is_event(&self) -> bool {
                *self == GIF7_A::EVENT
            }
        }
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF6_A = TEIF7_A;
        ///Reader of field `TEIF6`
        pub type TEIF6_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF6_A = HTIF7_A;
        ///Reader of field `HTIF6`
        pub type HTIF6_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF6_A = TCIF7_A;
        ///Reader of field `TCIF6`
        pub type TCIF6_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF6_A = GIF7_A;
        ///Reader of field `GIF6`
        pub type GIF6_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF5_A = TEIF7_A;
        ///Reader of field `TEIF5`
        pub type TEIF5_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF5_A = HTIF7_A;
        ///Reader of field `HTIF5`
        pub type HTIF5_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF5_A = TCIF7_A;
        ///Reader of field `TCIF5`
        pub type TCIF5_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF5_A = GIF7_A;
        ///Reader of field `GIF5`
        pub type GIF5_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF4_A = TEIF7_A;
        ///Reader of field `TEIF4`
        pub type TEIF4_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF4_A = HTIF7_A;
        ///Reader of field `HTIF4`
        pub type HTIF4_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF4_A = TCIF7_A;
        ///Reader of field `TCIF4`
        pub type TCIF4_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF4_A = GIF7_A;
        ///Reader of field `GIF4`
        pub type GIF4_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF3_A = TEIF7_A;
        ///Reader of field `TEIF3`
        pub type TEIF3_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF3_A = HTIF7_A;
        ///Reader of field `HTIF3`
        pub type HTIF3_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF3_A = TCIF7_A;
        ///Reader of field `TCIF3`
        pub type TCIF3_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF3_A = GIF7_A;
        ///Reader of field `GIF3`
        pub type GIF3_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF2_A = TEIF7_A;
        ///Reader of field `TEIF2`
        pub type TEIF2_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF2_A = HTIF7_A;
        ///Reader of field `HTIF2`
        pub type HTIF2_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF2_A = TCIF7_A;
        ///Reader of field `TCIF2`
        pub type TCIF2_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF2_A = GIF7_A;
        ///Reader of field `GIF2`
        pub type GIF2_R = crate::R<bool, GIF7_A>;
        ///Channel x transfer error flag (x = 1 ..7)
        pub type TEIF1_A = TEIF7_A;
        ///Reader of field `TEIF1`
        pub type TEIF1_R = crate::R<bool, TEIF7_A>;
        ///Channel x half transfer flag (x = 1 ..7)
        pub type HTIF1_A = HTIF7_A;
        ///Reader of field `HTIF1`
        pub type HTIF1_R = crate::R<bool, HTIF7_A>;
        ///Channel x transfer complete flag (x = 1 ..7)
        pub type TCIF1_A = TCIF7_A;
        ///Reader of field `TCIF1`
        pub type TCIF1_R = crate::R<bool, TCIF7_A>;
        ///Channel x global interrupt flag (x = 1 ..7)
        pub type GIF1_A = GIF7_A;
        ///Reader of field `GIF1`
        pub type GIF1_R = crate::R<bool, GIF7_A>;
        impl R {
            ///Bit 27 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif7(&self) -> TEIF7_R {
                TEIF7_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif7(&self) -> HTIF7_R {
                HTIF7_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif7(&self) -> TCIF7_R {
                TCIF7_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif7(&self) -> GIF7_R {
                GIF7_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif6(&self) -> TEIF6_R {
                TEIF6_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif6(&self) -> HTIF6_R {
                HTIF6_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif6(&self) -> TCIF6_R {
                TCIF6_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif6(&self) -> GIF6_R {
                GIF6_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif5(&self) -> TEIF5_R {
                TEIF5_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif5(&self) -> HTIF5_R {
                HTIF5_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif5(&self) -> TCIF5_R {
                TCIF5_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif5(&self) -> GIF5_R {
                GIF5_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif4(&self) -> TEIF4_R {
                TEIF4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif4(&self) -> HTIF4_R {
                HTIF4_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif4(&self) -> TCIF4_R {
                TCIF4_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif4(&self) -> GIF4_R {
                GIF4_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif3(&self) -> TEIF3_R {
                TEIF3_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif3(&self) -> HTIF3_R {
                HTIF3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif3(&self) -> TCIF3_R {
                TCIF3_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif3(&self) -> GIF3_R {
                GIF3_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif2(&self) -> TEIF2_R {
                TEIF2_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif2(&self) -> HTIF2_R {
                HTIF2_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif2(&self) -> TCIF2_R {
                TCIF2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif2(&self) -> GIF2_R {
                GIF2_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Channel x transfer error flag (x = 1 ..7)
            #[inline(always)]
            pub fn teif1(&self) -> TEIF1_R {
                TEIF1_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Channel x half transfer flag (x = 1 ..7)
            #[inline(always)]
            pub fn htif1(&self) -> HTIF1_R {
                HTIF1_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Channel x transfer complete flag (x = 1 ..7)
            #[inline(always)]
            pub fn tcif1(&self) -> TCIF1_R {
                TCIF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel x global interrupt flag (x = 1 ..7)
            #[inline(always)]
            pub fn gif1(&self) -> GIF1_R {
                GIF1_R::new((self.bits & 0x01) != 0)
            }
        }
    }
    ///interrupt flag clear register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ifcr](ifcr) module
    pub type IFCR = crate::Reg<u32, _IFCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IFCR;
    ///`write(|w| ..)` method takes [ifcr::W](ifcr::W) writer structure
    impl crate::Writable for IFCR {}
    ///interrupt flag clear register
    pub mod ifcr {
        ///Writer for register IFCR
        pub type W = crate::W<u32, super::IFCR>;
        ///Register IFCR `reset()`'s with value 0
        impl crate::ResetValue for super::IFCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CTEIF7_AW {
            ///1: Clears the TEIF flag in the ISR register
            CLEAR = 1,
        }
        impl From<CTEIF7_AW> for bool {
            #[inline(always)]
            fn from(variant: CTEIF7_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `CTEIF7`
        pub struct CTEIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF7_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF7_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CHTIF7_AW {
            ///1: Clears the HTIF flag in the ISR register
            CLEAR = 1,
        }
        impl From<CHTIF7_AW> for bool {
            #[inline(always)]
            fn from(variant: CHTIF7_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `CHTIF7`
        pub struct CHTIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF7_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF7_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CTCIF7_AW {
            ///1: Clears the TCIF flag in the ISR register
            CLEAR = 1,
        }
        impl From<CTCIF7_AW> for bool {
            #[inline(always)]
            fn from(variant: CTCIF7_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `CTCIF7`
        pub struct CTCIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF7_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF7_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CGIF7_AW {
            ///1: Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            CLEAR = 1,
        }
        impl From<CGIF7_AW> for bool {
            #[inline(always)]
            fn from(variant: CGIF7_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `CGIF7`
        pub struct CGIF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF7_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF7_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF6_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF6`
        pub struct CTEIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF6_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF6_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF6_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF6`
        pub struct CHTIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF6_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF6_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF6_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF6`
        pub struct CTCIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF6_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF6_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF6_AW = CGIF7_AW;
        ///Write proxy for field `CGIF6`
        pub struct CGIF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF6_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF6_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF5_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF5`
        pub struct CTEIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF5_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF5_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF5_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF5`
        pub struct CHTIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF5_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF5_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF5_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF5`
        pub struct CTCIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF5_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF5_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF5_AW = CGIF7_AW;
        ///Write proxy for field `CGIF5`
        pub struct CGIF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF5_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF5_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF4_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF4`
        pub struct CTEIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF4_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF4_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF4_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF4`
        pub struct CHTIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF4_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF4_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF4_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF4`
        pub struct CTCIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF4_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF4_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF4_AW = CGIF7_AW;
        ///Write proxy for field `CGIF4`
        pub struct CGIF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF4_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF4_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF3_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF3`
        pub struct CTEIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF3_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF3_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF3_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF3`
        pub struct CHTIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF3_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF3_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF3_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF3`
        pub struct CTCIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF3_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF3_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF3_AW = CGIF7_AW;
        ///Write proxy for field `CGIF3`
        pub struct CGIF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF3_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF3_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF2_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF2`
        pub struct CTEIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF2_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF2_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF2_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF2`
        pub struct CHTIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF2_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF2_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF2_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF2`
        pub struct CTCIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF2_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF2_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF2_AW = CGIF7_AW;
        ///Write proxy for field `CGIF2`
        pub struct CGIF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF2_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF2_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Channel x transfer error clear (x = 1 ..7)
        pub type CTEIF1_AW = CTEIF7_AW;
        ///Write proxy for field `CTEIF1`
        pub struct CTEIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTEIF1_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTEIF1_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TEIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTEIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Channel x half transfer clear (x = 1 ..7)
        pub type CHTIF1_AW = CHTIF7_AW;
        ///Write proxy for field `CHTIF1`
        pub struct CHTIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CHTIF1_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CHTIF1_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the HTIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CHTIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Channel x transfer complete clear (x = 1 ..7)
        pub type CTCIF1_AW = CTCIF7_AW;
        ///Write proxy for field `CTCIF1`
        pub struct CTCIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTCIF1_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CTCIF1_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the TCIF flag in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CTCIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel x global interrupt clear (x = 1 ..7)
        pub type CGIF1_AW = CGIF7_AW;
        ///Write proxy for field `CGIF1`
        pub struct CGIF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CGIF1_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CGIF1_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
            #[inline(always)]
            pub fn clear(self) -> &'a mut W {
                self.variant(CGIF7_AW::CLEAR)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl W {
            ///Bit 27 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif7(&mut self) -> CTEIF7_W {
                CTEIF7_W { w: self }
            }
            ///Bit 26 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif7(&mut self) -> CHTIF7_W {
                CHTIF7_W { w: self }
            }
            ///Bit 25 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif7(&mut self) -> CTCIF7_W {
                CTCIF7_W { w: self }
            }
            ///Bit 24 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif7(&mut self) -> CGIF7_W {
                CGIF7_W { w: self }
            }
            ///Bit 23 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif6(&mut self) -> CTEIF6_W {
                CTEIF6_W { w: self }
            }
            ///Bit 22 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif6(&mut self) -> CHTIF6_W {
                CHTIF6_W { w: self }
            }
            ///Bit 21 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif6(&mut self) -> CTCIF6_W {
                CTCIF6_W { w: self }
            }
            ///Bit 20 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif6(&mut self) -> CGIF6_W {
                CGIF6_W { w: self }
            }
            ///Bit 19 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif5(&mut self) -> CTEIF5_W {
                CTEIF5_W { w: self }
            }
            ///Bit 18 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif5(&mut self) -> CHTIF5_W {
                CHTIF5_W { w: self }
            }
            ///Bit 17 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif5(&mut self) -> CTCIF5_W {
                CTCIF5_W { w: self }
            }
            ///Bit 16 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif5(&mut self) -> CGIF5_W {
                CGIF5_W { w: self }
            }
            ///Bit 15 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif4(&mut self) -> CTEIF4_W {
                CTEIF4_W { w: self }
            }
            ///Bit 14 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif4(&mut self) -> CHTIF4_W {
                CHTIF4_W { w: self }
            }
            ///Bit 13 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif4(&mut self) -> CTCIF4_W {
                CTCIF4_W { w: self }
            }
            ///Bit 12 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif4(&mut self) -> CGIF4_W {
                CGIF4_W { w: self }
            }
            ///Bit 11 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif3(&mut self) -> CTEIF3_W {
                CTEIF3_W { w: self }
            }
            ///Bit 10 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif3(&mut self) -> CHTIF3_W {
                CHTIF3_W { w: self }
            }
            ///Bit 9 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif3(&mut self) -> CTCIF3_W {
                CTCIF3_W { w: self }
            }
            ///Bit 8 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif3(&mut self) -> CGIF3_W {
                CGIF3_W { w: self }
            }
            ///Bit 7 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif2(&mut self) -> CTEIF2_W {
                CTEIF2_W { w: self }
            }
            ///Bit 6 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif2(&mut self) -> CHTIF2_W {
                CHTIF2_W { w: self }
            }
            ///Bit 5 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif2(&mut self) -> CTCIF2_W {
                CTCIF2_W { w: self }
            }
            ///Bit 4 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif2(&mut self) -> CGIF2_W {
                CGIF2_W { w: self }
            }
            ///Bit 3 - Channel x transfer error clear (x = 1 ..7)
            #[inline(always)]
            pub fn cteif1(&mut self) -> CTEIF1_W {
                CTEIF1_W { w: self }
            }
            ///Bit 2 - Channel x half transfer clear (x = 1 ..7)
            #[inline(always)]
            pub fn chtif1(&mut self) -> CHTIF1_W {
                CHTIF1_W { w: self }
            }
            ///Bit 1 - Channel x transfer complete clear (x = 1 ..7)
            #[inline(always)]
            pub fn ctcif1(&mut self) -> CTCIF1_W {
                CTCIF1_W { w: self }
            }
            ///Bit 0 - Channel x global interrupt clear (x = 1 ..7)
            #[inline(always)]
            pub fn cgif1(&mut self) -> CGIF1_W {
                CGIF1_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr1](ccr1) module
    pub type CCR1 = crate::Reg<u32, _CCR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR1;
    ///`read()` method returns [ccr1::R](ccr1::R) reader structure
    impl crate::Readable for CCR1 {}
    ///`write(|w| ..)` method takes [ccr1::W](ccr1::W) writer structure
    impl crate::Writable for CCR1 {}
    ///channel x configuration register
    pub mod ccr1 {
        ///Reader of register CCR1
        pub type R = crate::R<u32, super::CCR1>;
        ///Writer for register CCR1
        pub type W = crate::W<u32, super::CCR1>;
        ///Register CCR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr1](cndtr1) module
    pub type CNDTR1 = crate::Reg<u32, _CNDTR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR1;
    ///`read()` method returns [cndtr1::R](cndtr1::R) reader structure
    impl crate::Readable for CNDTR1 {}
    ///`write(|w| ..)` method takes [cndtr1::W](cndtr1::W) writer structure
    impl crate::Writable for CNDTR1 {}
    ///channel x number of data register
    pub mod cndtr1 {
        ///Reader of register CNDTR1
        pub type R = crate::R<u32, super::CNDTR1>;
        ///Writer for register CNDTR1
        pub type W = crate::W<u32, super::CNDTR1>;
        ///Register CNDTR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar1](cpar1) module
    pub type CPAR1 = crate::Reg<u32, _CPAR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR1;
    ///`read()` method returns [cpar1::R](cpar1::R) reader structure
    impl crate::Readable for CPAR1 {}
    ///`write(|w| ..)` method takes [cpar1::W](cpar1::W) writer structure
    impl crate::Writable for CPAR1 {}
    ///channel x peripheral address register
    pub mod cpar1 {
        ///Reader of register CPAR1
        pub type R = crate::R<u32, super::CPAR1>;
        ///Writer for register CPAR1
        pub type W = crate::W<u32, super::CPAR1>;
        ///Register CPAR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar1](cmar1) module
    pub type CMAR1 = crate::Reg<u32, _CMAR1>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR1;
    ///`read()` method returns [cmar1::R](cmar1::R) reader structure
    impl crate::Readable for CMAR1 {}
    ///`write(|w| ..)` method takes [cmar1::W](cmar1::W) writer structure
    impl crate::Writable for CMAR1 {}
    ///channel x memory address register
    pub mod cmar1 {
        ///Reader of register CMAR1
        pub type R = crate::R<u32, super::CMAR1>;
        ///Writer for register CMAR1
        pub type W = crate::W<u32, super::CMAR1>;
        ///Register CMAR1 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR1 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr2](ccr2) module
    pub type CCR2 = crate::Reg<u32, _CCR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR2;
    ///`read()` method returns [ccr2::R](ccr2::R) reader structure
    impl crate::Readable for CCR2 {}
    ///`write(|w| ..)` method takes [ccr2::W](ccr2::W) writer structure
    impl crate::Writable for CCR2 {}
    ///channel x configuration register
    pub mod ccr2 {
        ///Reader of register CCR2
        pub type R = crate::R<u32, super::CCR2>;
        ///Writer for register CCR2
        pub type W = crate::W<u32, super::CCR2>;
        ///Register CCR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr2](cndtr2) module
    pub type CNDTR2 = crate::Reg<u32, _CNDTR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR2;
    ///`read()` method returns [cndtr2::R](cndtr2::R) reader structure
    impl crate::Readable for CNDTR2 {}
    ///`write(|w| ..)` method takes [cndtr2::W](cndtr2::W) writer structure
    impl crate::Writable for CNDTR2 {}
    ///channel x number of data register
    pub mod cndtr2 {
        ///Reader of register CNDTR2
        pub type R = crate::R<u32, super::CNDTR2>;
        ///Writer for register CNDTR2
        pub type W = crate::W<u32, super::CNDTR2>;
        ///Register CNDTR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar2](cpar2) module
    pub type CPAR2 = crate::Reg<u32, _CPAR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR2;
    ///`read()` method returns [cpar2::R](cpar2::R) reader structure
    impl crate::Readable for CPAR2 {}
    ///`write(|w| ..)` method takes [cpar2::W](cpar2::W) writer structure
    impl crate::Writable for CPAR2 {}
    ///channel x peripheral address register
    pub mod cpar2 {
        ///Reader of register CPAR2
        pub type R = crate::R<u32, super::CPAR2>;
        ///Writer for register CPAR2
        pub type W = crate::W<u32, super::CPAR2>;
        ///Register CPAR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar2](cmar2) module
    pub type CMAR2 = crate::Reg<u32, _CMAR2>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR2;
    ///`read()` method returns [cmar2::R](cmar2::R) reader structure
    impl crate::Readable for CMAR2 {}
    ///`write(|w| ..)` method takes [cmar2::W](cmar2::W) writer structure
    impl crate::Writable for CMAR2 {}
    ///channel x memory address register
    pub mod cmar2 {
        ///Reader of register CMAR2
        pub type R = crate::R<u32, super::CMAR2>;
        ///Writer for register CMAR2
        pub type W = crate::W<u32, super::CMAR2>;
        ///Register CMAR2 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR2 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr3](ccr3) module
    pub type CCR3 = crate::Reg<u32, _CCR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR3;
    ///`read()` method returns [ccr3::R](ccr3::R) reader structure
    impl crate::Readable for CCR3 {}
    ///`write(|w| ..)` method takes [ccr3::W](ccr3::W) writer structure
    impl crate::Writable for CCR3 {}
    ///channel x configuration register
    pub mod ccr3 {
        ///Reader of register CCR3
        pub type R = crate::R<u32, super::CCR3>;
        ///Writer for register CCR3
        pub type W = crate::W<u32, super::CCR3>;
        ///Register CCR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr3](cndtr3) module
    pub type CNDTR3 = crate::Reg<u32, _CNDTR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR3;
    ///`read()` method returns [cndtr3::R](cndtr3::R) reader structure
    impl crate::Readable for CNDTR3 {}
    ///`write(|w| ..)` method takes [cndtr3::W](cndtr3::W) writer structure
    impl crate::Writable for CNDTR3 {}
    ///channel x number of data register
    pub mod cndtr3 {
        ///Reader of register CNDTR3
        pub type R = crate::R<u32, super::CNDTR3>;
        ///Writer for register CNDTR3
        pub type W = crate::W<u32, super::CNDTR3>;
        ///Register CNDTR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar3](cpar3) module
    pub type CPAR3 = crate::Reg<u32, _CPAR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR3;
    ///`read()` method returns [cpar3::R](cpar3::R) reader structure
    impl crate::Readable for CPAR3 {}
    ///`write(|w| ..)` method takes [cpar3::W](cpar3::W) writer structure
    impl crate::Writable for CPAR3 {}
    ///channel x peripheral address register
    pub mod cpar3 {
        ///Reader of register CPAR3
        pub type R = crate::R<u32, super::CPAR3>;
        ///Writer for register CPAR3
        pub type W = crate::W<u32, super::CPAR3>;
        ///Register CPAR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar3](cmar3) module
    pub type CMAR3 = crate::Reg<u32, _CMAR3>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR3;
    ///`read()` method returns [cmar3::R](cmar3::R) reader structure
    impl crate::Readable for CMAR3 {}
    ///`write(|w| ..)` method takes [cmar3::W](cmar3::W) writer structure
    impl crate::Writable for CMAR3 {}
    ///channel x memory address register
    pub mod cmar3 {
        ///Reader of register CMAR3
        pub type R = crate::R<u32, super::CMAR3>;
        ///Writer for register CMAR3
        pub type W = crate::W<u32, super::CMAR3>;
        ///Register CMAR3 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR3 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr4](ccr4) module
    pub type CCR4 = crate::Reg<u32, _CCR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR4;
    ///`read()` method returns [ccr4::R](ccr4::R) reader structure
    impl crate::Readable for CCR4 {}
    ///`write(|w| ..)` method takes [ccr4::W](ccr4::W) writer structure
    impl crate::Writable for CCR4 {}
    ///channel x configuration register
    pub mod ccr4 {
        ///Reader of register CCR4
        pub type R = crate::R<u32, super::CCR4>;
        ///Writer for register CCR4
        pub type W = crate::W<u32, super::CCR4>;
        ///Register CCR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr4](cndtr4) module
    pub type CNDTR4 = crate::Reg<u32, _CNDTR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR4;
    ///`read()` method returns [cndtr4::R](cndtr4::R) reader structure
    impl crate::Readable for CNDTR4 {}
    ///`write(|w| ..)` method takes [cndtr4::W](cndtr4::W) writer structure
    impl crate::Writable for CNDTR4 {}
    ///channel x number of data register
    pub mod cndtr4 {
        ///Reader of register CNDTR4
        pub type R = crate::R<u32, super::CNDTR4>;
        ///Writer for register CNDTR4
        pub type W = crate::W<u32, super::CNDTR4>;
        ///Register CNDTR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar4](cpar4) module
    pub type CPAR4 = crate::Reg<u32, _CPAR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR4;
    ///`read()` method returns [cpar4::R](cpar4::R) reader structure
    impl crate::Readable for CPAR4 {}
    ///`write(|w| ..)` method takes [cpar4::W](cpar4::W) writer structure
    impl crate::Writable for CPAR4 {}
    ///channel x peripheral address register
    pub mod cpar4 {
        ///Reader of register CPAR4
        pub type R = crate::R<u32, super::CPAR4>;
        ///Writer for register CPAR4
        pub type W = crate::W<u32, super::CPAR4>;
        ///Register CPAR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar4](cmar4) module
    pub type CMAR4 = crate::Reg<u32, _CMAR4>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR4;
    ///`read()` method returns [cmar4::R](cmar4::R) reader structure
    impl crate::Readable for CMAR4 {}
    ///`write(|w| ..)` method takes [cmar4::W](cmar4::W) writer structure
    impl crate::Writable for CMAR4 {}
    ///channel x memory address register
    pub mod cmar4 {
        ///Reader of register CMAR4
        pub type R = crate::R<u32, super::CMAR4>;
        ///Writer for register CMAR4
        pub type W = crate::W<u32, super::CMAR4>;
        ///Register CMAR4 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR4 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr5](ccr5) module
    pub type CCR5 = crate::Reg<u32, _CCR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR5;
    ///`read()` method returns [ccr5::R](ccr5::R) reader structure
    impl crate::Readable for CCR5 {}
    ///`write(|w| ..)` method takes [ccr5::W](ccr5::W) writer structure
    impl crate::Writable for CCR5 {}
    ///channel x configuration register
    pub mod ccr5 {
        ///Reader of register CCR5
        pub type R = crate::R<u32, super::CCR5>;
        ///Writer for register CCR5
        pub type W = crate::W<u32, super::CCR5>;
        ///Register CCR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr5](cndtr5) module
    pub type CNDTR5 = crate::Reg<u32, _CNDTR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR5;
    ///`read()` method returns [cndtr5::R](cndtr5::R) reader structure
    impl crate::Readable for CNDTR5 {}
    ///`write(|w| ..)` method takes [cndtr5::W](cndtr5::W) writer structure
    impl crate::Writable for CNDTR5 {}
    ///channel x number of data register
    pub mod cndtr5 {
        ///Reader of register CNDTR5
        pub type R = crate::R<u32, super::CNDTR5>;
        ///Writer for register CNDTR5
        pub type W = crate::W<u32, super::CNDTR5>;
        ///Register CNDTR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar5](cpar5) module
    pub type CPAR5 = crate::Reg<u32, _CPAR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR5;
    ///`read()` method returns [cpar5::R](cpar5::R) reader structure
    impl crate::Readable for CPAR5 {}
    ///`write(|w| ..)` method takes [cpar5::W](cpar5::W) writer structure
    impl crate::Writable for CPAR5 {}
    ///channel x peripheral address register
    pub mod cpar5 {
        ///Reader of register CPAR5
        pub type R = crate::R<u32, super::CPAR5>;
        ///Writer for register CPAR5
        pub type W = crate::W<u32, super::CPAR5>;
        ///Register CPAR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar5](cmar5) module
    pub type CMAR5 = crate::Reg<u32, _CMAR5>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR5;
    ///`read()` method returns [cmar5::R](cmar5::R) reader structure
    impl crate::Readable for CMAR5 {}
    ///`write(|w| ..)` method takes [cmar5::W](cmar5::W) writer structure
    impl crate::Writable for CMAR5 {}
    ///channel x memory address register
    pub mod cmar5 {
        ///Reader of register CMAR5
        pub type R = crate::R<u32, super::CMAR5>;
        ///Writer for register CMAR5
        pub type W = crate::W<u32, super::CMAR5>;
        ///Register CMAR5 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR5 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr6](ccr6) module
    pub type CCR6 = crate::Reg<u32, _CCR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR6;
    ///`read()` method returns [ccr6::R](ccr6::R) reader structure
    impl crate::Readable for CCR6 {}
    ///`write(|w| ..)` method takes [ccr6::W](ccr6::W) writer structure
    impl crate::Writable for CCR6 {}
    ///channel x configuration register
    pub mod ccr6 {
        ///Reader of register CCR6
        pub type R = crate::R<u32, super::CCR6>;
        ///Writer for register CCR6
        pub type W = crate::W<u32, super::CCR6>;
        ///Register CCR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr6](cndtr6) module
    pub type CNDTR6 = crate::Reg<u32, _CNDTR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR6;
    ///`read()` method returns [cndtr6::R](cndtr6::R) reader structure
    impl crate::Readable for CNDTR6 {}
    ///`write(|w| ..)` method takes [cndtr6::W](cndtr6::W) writer structure
    impl crate::Writable for CNDTR6 {}
    ///channel x number of data register
    pub mod cndtr6 {
        ///Reader of register CNDTR6
        pub type R = crate::R<u32, super::CNDTR6>;
        ///Writer for register CNDTR6
        pub type W = crate::W<u32, super::CNDTR6>;
        ///Register CNDTR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar6](cpar6) module
    pub type CPAR6 = crate::Reg<u32, _CPAR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR6;
    ///`read()` method returns [cpar6::R](cpar6::R) reader structure
    impl crate::Readable for CPAR6 {}
    ///`write(|w| ..)` method takes [cpar6::W](cpar6::W) writer structure
    impl crate::Writable for CPAR6 {}
    ///channel x peripheral address register
    pub mod cpar6 {
        ///Reader of register CPAR6
        pub type R = crate::R<u32, super::CPAR6>;
        ///Writer for register CPAR6
        pub type W = crate::W<u32, super::CPAR6>;
        ///Register CPAR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar6](cmar6) module
    pub type CMAR6 = crate::Reg<u32, _CMAR6>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR6;
    ///`read()` method returns [cmar6::R](cmar6::R) reader structure
    impl crate::Readable for CMAR6 {}
    ///`write(|w| ..)` method takes [cmar6::W](cmar6::W) writer structure
    impl crate::Writable for CMAR6 {}
    ///channel x memory address register
    pub mod cmar6 {
        ///Reader of register CMAR6
        pub type R = crate::R<u32, super::CMAR6>;
        ///Writer for register CMAR6
        pub type W = crate::W<u32, super::CMAR6>;
        ///Register CMAR6 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR6 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
    ///channel x configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ccr7](ccr7) module
    pub type CCR7 = crate::Reg<u32, _CCR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CCR7;
    ///`read()` method returns [ccr7::R](ccr7::R) reader structure
    impl crate::Readable for CCR7 {}
    ///`write(|w| ..)` method takes [ccr7::W](ccr7::W) writer structure
    impl crate::Writable for CCR7 {}
    ///channel x configuration register
    pub mod ccr7 {
        ///Reader of register CCR7
        pub type R = crate::R<u32, super::CCR7>;
        ///Writer for register CCR7
        pub type W = crate::W<u32, super::CCR7>;
        ///Register CCR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CCR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Memory to memory mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MEM2MEM_A {
            ///0: Memory to memory mode disabled
            DISABLED = 0,
            ///1: Memory to memory mode enabled
            ENABLED = 1,
        }
        impl From<MEM2MEM_A> for bool {
            #[inline(always)]
            fn from(variant: MEM2MEM_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MEM2MEM`
        pub type MEM2MEM_R = crate::R<bool, MEM2MEM_A>;
        impl MEM2MEM_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MEM2MEM_A {
                match self.bits {
                    false => MEM2MEM_A::DISABLED,
                    true => MEM2MEM_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MEM2MEM_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MEM2MEM_A::ENABLED
            }
        }
        ///Write proxy for field `MEM2MEM`
        pub struct MEM2MEM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MEM2MEM_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MEM2MEM_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Memory to memory mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::DISABLED)
            }
            ///Memory to memory mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MEM2MEM_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Channel priority level
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PL_A {
            ///0: Low priority
            LOW = 0,
            ///1: Medium priority
            MEDIUM = 1,
            ///2: High priority
            HIGH = 2,
            ///3: Very high priority
            VERYHIGH = 3,
        }
        impl From<PL_A> for u8 {
            #[inline(always)]
            fn from(variant: PL_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PL`
        pub type PL_R = crate::R<u8, PL_A>;
        impl PL_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PL_A {
                match self.bits {
                    0 => PL_A::LOW,
                    1 => PL_A::MEDIUM,
                    2 => PL_A::HIGH,
                    3 => PL_A::VERYHIGH,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `LOW`
            #[inline(always)]
            pub fn is_low(&self) -> bool {
                *self == PL_A::LOW
            }
            ///Checks if the value of the field is `MEDIUM`
            #[inline(always)]
            pub fn is_medium(&self) -> bool {
                *self == PL_A::MEDIUM
            }
            ///Checks if the value of the field is `HIGH`
            #[inline(always)]
            pub fn is_high(&self) -> bool {
                *self == PL_A::HIGH
            }
            ///Checks if the value of the field is `VERYHIGH`
            #[inline(always)]
            pub fn is_very_high(&self) -> bool {
                *self == PL_A::VERYHIGH
            }
        }
        ///Write proxy for field `PL`
        pub struct PL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PL_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PL_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Low priority
            #[inline(always)]
            pub fn low(self) -> &'a mut W {
                self.variant(PL_A::LOW)
            }
            ///Medium priority
            #[inline(always)]
            pub fn medium(self) -> &'a mut W {
                self.variant(PL_A::MEDIUM)
            }
            ///High priority
            #[inline(always)]
            pub fn high(self) -> &'a mut W {
                self.variant(PL_A::HIGH)
            }
            ///Very high priority
            #[inline(always)]
            pub fn very_high(self) -> &'a mut W {
                self.variant(PL_A::VERYHIGH)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 12)) | (((value as u32) & 0x03) << 12);
                self.w
            }
        }
        ///Memory size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum MSIZE_A {
            ///0: 8-bit size
            BITS8 = 0,
            ///1: 16-bit size
            BITS16 = 1,
            ///2: 32-bit size
            BITS32 = 2,
        }
        impl From<MSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: MSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `MSIZE`
        pub type MSIZE_R = crate::R<u8, MSIZE_A>;
        impl MSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<u8, MSIZE_A> {
                use crate::Variant::*;
                match self.bits {
                    0 => Val(MSIZE_A::BITS8),
                    1 => Val(MSIZE_A::BITS16),
                    2 => Val(MSIZE_A::BITS32),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `BITS8`
            #[inline(always)]
            pub fn is_bits8(&self) -> bool {
                *self == MSIZE_A::BITS8
            }
            ///Checks if the value of the field is `BITS16`
            #[inline(always)]
            pub fn is_bits16(&self) -> bool {
                *self == MSIZE_A::BITS16
            }
            ///Checks if the value of the field is `BITS32`
            #[inline(always)]
            pub fn is_bits32(&self) -> bool {
                *self == MSIZE_A::BITS32
            }
        }
        ///Write proxy for field `MSIZE`
        pub struct MSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 10)) | (((value as u32) & 0x03) << 10);
                self.w
            }
        }
        ///Peripheral size
        pub type PSIZE_A = MSIZE_A;
        ///Reader of field `PSIZE`
        pub type PSIZE_R = crate::R<u8, MSIZE_A>;
        ///Write proxy for field `PSIZE`
        pub struct PSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PSIZE_A) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///8-bit size
            #[inline(always)]
            pub fn bits8(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS8)
            }
            ///16-bit size
            #[inline(always)]
            pub fn bits16(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS16)
            }
            ///32-bit size
            #[inline(always)]
            pub fn bits32(self) -> &'a mut W {
                self.variant(MSIZE_A::BITS32)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 8)) | (((value as u32) & 0x03) << 8);
                self.w
            }
        }
        ///Memory increment mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum MINC_A {
            ///0: Increment mode disabled
            DISABLED = 0,
            ///1: Increment mode enabled
            ENABLED = 1,
        }
        impl From<MINC_A> for bool {
            #[inline(always)]
            fn from(variant: MINC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `MINC`
        pub type MINC_R = crate::R<bool, MINC_A>;
        impl MINC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> MINC_A {
                match self.bits {
                    false => MINC_A::DISABLED,
                    true => MINC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == MINC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == MINC_A::ENABLED
            }
        }
        ///Write proxy for field `MINC`
        pub struct MINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: MINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Peripheral increment mode
        pub type PINC_A = MINC_A;
        ///Reader of field `PINC`
        pub type PINC_R = crate::R<bool, MINC_A>;
        ///Write proxy for field `PINC`
        pub struct PINC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PINC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PINC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Increment mode disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(MINC_A::DISABLED)
            }
            ///Increment mode enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(MINC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Circular mode
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum CIRC_A {
            ///0: Circular buffer disabled
            DISABLED = 0,
            ///1: Circular buffer enabled
            ENABLED = 1,
        }
        impl From<CIRC_A> for bool {
            #[inline(always)]
            fn from(variant: CIRC_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `CIRC`
        pub type CIRC_R = crate::R<bool, CIRC_A>;
        impl CIRC_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> CIRC_A {
                match self.bits {
                    false => CIRC_A::DISABLED,
                    true => CIRC_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == CIRC_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == CIRC_A::ENABLED
            }
        }
        ///Write proxy for field `CIRC`
        pub struct CIRC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CIRC_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: CIRC_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Circular buffer disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(CIRC_A::DISABLED)
            }
            ///Circular buffer enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(CIRC_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Data transfer direction
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum DIR_A {
            ///0: Read from peripheral
            FROMPERIPHERAL = 0,
            ///1: Read from memory
            FROMMEMORY = 1,
        }
        impl From<DIR_A> for bool {
            #[inline(always)]
            fn from(variant: DIR_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `DIR`
        pub type DIR_R = crate::R<bool, DIR_A>;
        impl DIR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> DIR_A {
                match self.bits {
                    false => DIR_A::FROMPERIPHERAL,
                    true => DIR_A::FROMMEMORY,
                }
            }
            ///Checks if the value of the field is `FROMPERIPHERAL`
            #[inline(always)]
            pub fn is_from_peripheral(&self) -> bool {
                *self == DIR_A::FROMPERIPHERAL
            }
            ///Checks if the value of the field is `FROMMEMORY`
            #[inline(always)]
            pub fn is_from_memory(&self) -> bool {
                *self == DIR_A::FROMMEMORY
            }
        }
        ///Write proxy for field `DIR`
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: DIR_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Read from peripheral
            #[inline(always)]
            pub fn from_peripheral(self) -> &'a mut W {
                self.variant(DIR_A::FROMPERIPHERAL)
            }
            ///Read from memory
            #[inline(always)]
            pub fn from_memory(self) -> &'a mut W {
                self.variant(DIR_A::FROMMEMORY)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Transfer error interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TEIE_A {
            ///0: Transfer Error interrupt disabled
            DISABLED = 0,
            ///1: Transfer Error interrupt enabled
            ENABLED = 1,
        }
        impl From<TEIE_A> for bool {
            #[inline(always)]
            fn from(variant: TEIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TEIE`
        pub type TEIE_R = crate::R<bool, TEIE_A>;
        impl TEIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TEIE_A {
                match self.bits {
                    false => TEIE_A::DISABLED,
                    true => TEIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TEIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TEIE_A::ENABLED
            }
        }
        ///Write proxy for field `TEIE`
        pub struct TEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TEIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TEIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Error interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TEIE_A::DISABLED)
            }
            ///Transfer Error interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TEIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Half transfer interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum HTIE_A {
            ///0: Half Transfer interrupt disabled
            DISABLED = 0,
            ///1: Half Transfer interrupt enabled
            ENABLED = 1,
        }
        impl From<HTIE_A> for bool {
            #[inline(always)]
            fn from(variant: HTIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `HTIE`
        pub type HTIE_R = crate::R<bool, HTIE_A>;
        impl HTIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> HTIE_A {
                match self.bits {
                    false => HTIE_A::DISABLED,
                    true => HTIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == HTIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == HTIE_A::ENABLED
            }
        }
        ///Write proxy for field `HTIE`
        pub struct HTIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HTIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: HTIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Half Transfer interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(HTIE_A::DISABLED)
            }
            ///Half Transfer interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(HTIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Transfer complete interrupt enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum TCIE_A {
            ///0: Transfer Complete interrupt disabled
            DISABLED = 0,
            ///1: Transfer Complete interrupt enabled
            ENABLED = 1,
        }
        impl From<TCIE_A> for bool {
            #[inline(always)]
            fn from(variant: TCIE_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `TCIE`
        pub type TCIE_R = crate::R<bool, TCIE_A>;
        impl TCIE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> TCIE_A {
                match self.bits {
                    false => TCIE_A::DISABLED,
                    true => TCIE_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == TCIE_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == TCIE_A::ENABLED
            }
        }
        ///Write proxy for field `TCIE`
        pub struct TCIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TCIE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: TCIE_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Transfer Complete interrupt disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(TCIE_A::DISABLED)
            }
            ///Transfer Complete interrupt enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(TCIE_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Channel enable
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EN_A {
            ///0: Channel disabled
            DISABLED = 0,
            ///1: Channel enabled
            ENABLED = 1,
        }
        impl From<EN_A> for bool {
            #[inline(always)]
            fn from(variant: EN_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EN`
        pub type EN_R = crate::R<bool, EN_A>;
        impl EN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EN_A {
                match self.bits {
                    false => EN_A::DISABLED,
                    true => EN_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == EN_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == EN_A::ENABLED
            }
        }
        ///Write proxy for field `EN`
        pub struct EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EN_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Channel disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(EN_A::DISABLED)
            }
            ///Channel enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(EN_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&self) -> MEM2MEM_R {
                MEM2MEM_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&self) -> PL_R {
                PL_R::new(((self.bits >> 12) & 0x03) as u8)
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&self) -> MSIZE_R {
                MSIZE_R::new(((self.bits >> 10) & 0x03) as u8)
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&self) -> PSIZE_R {
                PSIZE_R::new(((self.bits >> 8) & 0x03) as u8)
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&self) -> MINC_R {
                MINC_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&self) -> PINC_R {
                PINC_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&self) -> CIRC_R {
                CIRC_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&self) -> TEIE_R {
                TEIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&self) -> HTIE_R {
                HTIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&self) -> TCIE_R {
                TCIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&self) -> EN_R {
                EN_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 14 - Memory to memory mode
            #[inline(always)]
            pub fn mem2mem(&mut self) -> MEM2MEM_W {
                MEM2MEM_W { w: self }
            }
            ///Bits 12:13 - Channel priority level
            #[inline(always)]
            pub fn pl(&mut self) -> PL_W {
                PL_W { w: self }
            }
            ///Bits 10:11 - Memory size
            #[inline(always)]
            pub fn msize(&mut self) -> MSIZE_W {
                MSIZE_W { w: self }
            }
            ///Bits 8:9 - Peripheral size
            #[inline(always)]
            pub fn psize(&mut self) -> PSIZE_W {
                PSIZE_W { w: self }
            }
            ///Bit 7 - Memory increment mode
            #[inline(always)]
            pub fn minc(&mut self) -> MINC_W {
                MINC_W { w: self }
            }
            ///Bit 6 - Peripheral increment mode
            #[inline(always)]
            pub fn pinc(&mut self) -> PINC_W {
                PINC_W { w: self }
            }
            ///Bit 5 - Circular mode
            #[inline(always)]
            pub fn circ(&mut self) -> CIRC_W {
                CIRC_W { w: self }
            }
            ///Bit 4 - Data transfer direction
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            ///Bit 3 - Transfer error interrupt enable
            #[inline(always)]
            pub fn teie(&mut self) -> TEIE_W {
                TEIE_W { w: self }
            }
            ///Bit 2 - Half transfer interrupt enable
            #[inline(always)]
            pub fn htie(&mut self) -> HTIE_W {
                HTIE_W { w: self }
            }
            ///Bit 1 - Transfer complete interrupt enable
            #[inline(always)]
            pub fn tcie(&mut self) -> TCIE_W {
                TCIE_W { w: self }
            }
            ///Bit 0 - Channel enable
            #[inline(always)]
            pub fn en(&mut self) -> EN_W {
                EN_W { w: self }
            }
        }
    }
    ///channel x number of data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cndtr7](cndtr7) module
    pub type CNDTR7 = crate::Reg<u32, _CNDTR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CNDTR7;
    ///`read()` method returns [cndtr7::R](cndtr7::R) reader structure
    impl crate::Readable for CNDTR7 {}
    ///`write(|w| ..)` method takes [cndtr7::W](cndtr7::W) writer structure
    impl crate::Writable for CNDTR7 {}
    ///channel x number of data register
    pub mod cndtr7 {
        ///Reader of register CNDTR7
        pub type R = crate::R<u32, super::CNDTR7>;
        ///Writer for register CNDTR7
        pub type W = crate::W<u32, super::CNDTR7>;
        ///Register CNDTR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CNDTR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `NDT`
        pub type NDT_R = crate::R<u16, u16>;
        ///Write proxy for field `NDT`
        pub struct NDT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NDT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&self) -> NDT_R {
                NDT_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Number of data to transfer
            #[inline(always)]
            pub fn ndt(&mut self) -> NDT_W {
                NDT_W { w: self }
            }
        }
    }
    ///channel x peripheral address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpar7](cpar7) module
    pub type CPAR7 = crate::Reg<u32, _CPAR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPAR7;
    ///`read()` method returns [cpar7::R](cpar7::R) reader structure
    impl crate::Readable for CPAR7 {}
    ///`write(|w| ..)` method takes [cpar7::W](cpar7::W) writer structure
    impl crate::Writable for CPAR7 {}
    ///channel x peripheral address register
    pub mod cpar7 {
        ///Reader of register CPAR7
        pub type R = crate::R<u32, super::CPAR7>;
        ///Writer for register CPAR7
        pub type W = crate::W<u32, super::CPAR7>;
        ///Register CPAR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CPAR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PA`
        pub type PA_R = crate::R<u32, u32>;
        ///Write proxy for field `PA`
        pub struct PA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&self) -> PA_R {
                PA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Peripheral address
            #[inline(always)]
            pub fn pa(&mut self) -> PA_W {
                PA_W { w: self }
            }
        }
    }
    ///channel x memory address register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cmar7](cmar7) module
    pub type CMAR7 = crate::Reg<u32, _CMAR7>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CMAR7;
    ///`read()` method returns [cmar7::R](cmar7::R) reader structure
    impl crate::Readable for CMAR7 {}
    ///`write(|w| ..)` method takes [cmar7::W](cmar7::W) writer structure
    impl crate::Writable for CMAR7 {}
    ///channel x memory address register
    pub mod cmar7 {
        ///Reader of register CMAR7
        pub type R = crate::R<u32, super::CMAR7>;
        ///Writer for register CMAR7
        pub type W = crate::W<u32, super::CMAR7>;
        ///Register CMAR7 `reset()`'s with value 0
        impl crate::ResetValue for super::CMAR7 {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MA`
        pub type MA_R = crate::R<u32, u32>;
        ///Write proxy for field `MA`
        pub struct MA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&self) -> MA_R {
                MA_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Memory address
            #[inline(always)]
            pub fn ma(&mut self) -> MA_W {
                MA_W { w: self }
            }
        }
    }
}
///Direct memory access controller
pub struct DMA2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA2 {}
impl DMA2 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dma1::RegisterBlock {
        0x4002_0400 as *const _
    }
}
impl Deref for DMA2 {
    type Target = dma1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DMA2::ptr() }
    }
}
///DMA request multiplexer
pub struct DMAMUX1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMAMUX1 {}
impl DMAMUX1 {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const dmamux1::RegisterBlock {
        0x4002_0800 as *const _
    }
}
impl Deref for DMAMUX1 {
    type Target = dmamux1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*DMAMUX1::ptr() }
    }
}
///DMA request multiplexer
pub mod dmamux1 {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - channel 0 configuration register
        pub c0cr: C0CR,
        ///0x04 - channel 1 configuration register
        pub c1cr: C1CR,
        ///0x08 - channel 2 configuration register
        pub c2cr: C2CR,
        ///0x0c - channel 3 configuration register
        pub c3cr: C3CR,
        ///0x10 - channel 4 configuration register
        pub c4cr: C4CR,
        ///0x14 - channel 5 configuration register
        pub c5cr: C5CR,
        ///0x18 - channel 6 configuration register
        pub c6cr: C6CR,
        ///0x1c - channel 7 configuration register
        pub c7cr: C7CR,
        ///0x20 - channel 8 configuration register
        pub c8cr: C8CR,
        ///0x24 - channel 9 configuration register
        pub c9cr: C9CR,
        ///0x28 - channel 10 configuration register
        pub c10cr: C10CR,
        ///0x2c - channel 11 configuration register
        pub c11cr: C11CR,
        ///0x30 - channel 12 configuration register
        pub c12cr: C12CR,
        ///0x34 - channel 13 configuration register
        pub c13cr: C13CR,
        _reserved14: [u8; 72usize],
        ///0x80 - channel status register
        pub csr: CSR,
        ///0x84 - clear flag register
        pub cfr: CFR,
        _reserved16: [u8; 120usize],
        ///0x100 - request generator channel 0 configuration register
        pub rg0cr: RG0CR,
        ///0x104 - request generator channel 1 configuration register
        pub rg1cr: RG1CR,
        ///0x108 - request generator channel 2 configuration register
        pub rg2cr: RG2CR,
        ///0x10c - request generator channel 3 configuration register
        pub rg3cr: RG3CR,
        _reserved20: [u8; 48usize],
        ///0x140 - request generator interrupt status register
        pub rgsr: RGSR,
        ///0x144 - request generator interrupt clear flag register
        pub rgcfr: RGCFR,
    }
    ///channel 0 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c0cr](c0cr) module
    pub type C0CR = crate::Reg<u32, _C0CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C0CR;
    ///`read()` method returns [c0cr::R](c0cr::R) reader structure
    impl crate::Readable for C0CR {}
    ///`write(|w| ..)` method takes [c0cr::W](c0cr::W) writer structure
    impl crate::Writable for C0CR {}
    ///channel 0 configuration register
    pub mod c0cr {
        ///Reader of register C0CR
        pub type R = crate::R<u32, super::C0CR>;
        ///Writer for register C0CR
        pub type W = crate::W<u32, super::C0CR>;
        ///Register C0CR `reset()`'s with value 0
        impl crate::ResetValue for super::C0CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 1 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c1cr](c1cr) module
    pub type C1CR = crate::Reg<u32, _C1CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C1CR;
    ///`read()` method returns [c1cr::R](c1cr::R) reader structure
    impl crate::Readable for C1CR {}
    ///`write(|w| ..)` method takes [c1cr::W](c1cr::W) writer structure
    impl crate::Writable for C1CR {}
    ///channel 1 configuration register
    pub mod c1cr {
        ///Reader of register C1CR
        pub type R = crate::R<u32, super::C1CR>;
        ///Writer for register C1CR
        pub type W = crate::W<u32, super::C1CR>;
        ///Register C1CR `reset()`'s with value 0
        impl crate::ResetValue for super::C1CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 2 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c2cr](c2cr) module
    pub type C2CR = crate::Reg<u32, _C2CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C2CR;
    ///`read()` method returns [c2cr::R](c2cr::R) reader structure
    impl crate::Readable for C2CR {}
    ///`write(|w| ..)` method takes [c2cr::W](c2cr::W) writer structure
    impl crate::Writable for C2CR {}
    ///channel 2 configuration register
    pub mod c2cr {
        ///Reader of register C2CR
        pub type R = crate::R<u32, super::C2CR>;
        ///Writer for register C2CR
        pub type W = crate::W<u32, super::C2CR>;
        ///Register C2CR `reset()`'s with value 0
        impl crate::ResetValue for super::C2CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 3 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c3cr](c3cr) module
    pub type C3CR = crate::Reg<u32, _C3CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C3CR;
    ///`read()` method returns [c3cr::R](c3cr::R) reader structure
    impl crate::Readable for C3CR {}
    ///`write(|w| ..)` method takes [c3cr::W](c3cr::W) writer structure
    impl crate::Writable for C3CR {}
    ///channel 3 configuration register
    pub mod c3cr {
        ///Reader of register C3CR
        pub type R = crate::R<u32, super::C3CR>;
        ///Writer for register C3CR
        pub type W = crate::W<u32, super::C3CR>;
        ///Register C3CR `reset()`'s with value 0
        impl crate::ResetValue for super::C3CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 4 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c4cr](c4cr) module
    pub type C4CR = crate::Reg<u32, _C4CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C4CR;
    ///`read()` method returns [c4cr::R](c4cr::R) reader structure
    impl crate::Readable for C4CR {}
    ///`write(|w| ..)` method takes [c4cr::W](c4cr::W) writer structure
    impl crate::Writable for C4CR {}
    ///channel 4 configuration register
    pub mod c4cr {
        ///Reader of register C4CR
        pub type R = crate::R<u32, super::C4CR>;
        ///Writer for register C4CR
        pub type W = crate::W<u32, super::C4CR>;
        ///Register C4CR `reset()`'s with value 0
        impl crate::ResetValue for super::C4CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 5 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c5cr](c5cr) module
    pub type C5CR = crate::Reg<u32, _C5CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C5CR;
    ///`read()` method returns [c5cr::R](c5cr::R) reader structure
    impl crate::Readable for C5CR {}
    ///`write(|w| ..)` method takes [c5cr::W](c5cr::W) writer structure
    impl crate::Writable for C5CR {}
    ///channel 5 configuration register
    pub mod c5cr {
        ///Reader of register C5CR
        pub type R = crate::R<u32, super::C5CR>;
        ///Writer for register C5CR
        pub type W = crate::W<u32, super::C5CR>;
        ///Register C5CR `reset()`'s with value 0
        impl crate::ResetValue for super::C5CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 6 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c6cr](c6cr) module
    pub type C6CR = crate::Reg<u32, _C6CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C6CR;
    ///`read()` method returns [c6cr::R](c6cr::R) reader structure
    impl crate::Readable for C6CR {}
    ///`write(|w| ..)` method takes [c6cr::W](c6cr::W) writer structure
    impl crate::Writable for C6CR {}
    ///channel 6 configuration register
    pub mod c6cr {
        ///Reader of register C6CR
        pub type R = crate::R<u32, super::C6CR>;
        ///Writer for register C6CR
        pub type W = crate::W<u32, super::C6CR>;
        ///Register C6CR `reset()`'s with value 0
        impl crate::ResetValue for super::C6CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 7 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c7cr](c7cr) module
    pub type C7CR = crate::Reg<u32, _C7CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C7CR;
    ///`read()` method returns [c7cr::R](c7cr::R) reader structure
    impl crate::Readable for C7CR {}
    ///`write(|w| ..)` method takes [c7cr::W](c7cr::W) writer structure
    impl crate::Writable for C7CR {}
    ///channel 7 configuration register
    pub mod c7cr {
        ///Reader of register C7CR
        pub type R = crate::R<u32, super::C7CR>;
        ///Writer for register C7CR
        pub type W = crate::W<u32, super::C7CR>;
        ///Register C7CR `reset()`'s with value 0
        impl crate::ResetValue for super::C7CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 8 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c8cr](c8cr) module
    pub type C8CR = crate::Reg<u32, _C8CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C8CR;
    ///`read()` method returns [c8cr::R](c8cr::R) reader structure
    impl crate::Readable for C8CR {}
    ///`write(|w| ..)` method takes [c8cr::W](c8cr::W) writer structure
    impl crate::Writable for C8CR {}
    ///channel 8 configuration register
    pub mod c8cr {
        ///Reader of register C8CR
        pub type R = crate::R<u32, super::C8CR>;
        ///Writer for register C8CR
        pub type W = crate::W<u32, super::C8CR>;
        ///Register C8CR `reset()`'s with value 0
        impl crate::ResetValue for super::C8CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 9 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c9cr](c9cr) module
    pub type C9CR = crate::Reg<u32, _C9CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C9CR;
    ///`read()` method returns [c9cr::R](c9cr::R) reader structure
    impl crate::Readable for C9CR {}
    ///`write(|w| ..)` method takes [c9cr::W](c9cr::W) writer structure
    impl crate::Writable for C9CR {}
    ///channel 9 configuration register
    pub mod c9cr {
        ///Reader of register C9CR
        pub type R = crate::R<u32, super::C9CR>;
        ///Writer for register C9CR
        pub type W = crate::W<u32, super::C9CR>;
        ///Register C9CR `reset()`'s with value 0
        impl crate::ResetValue for super::C9CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 10 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c10cr](c10cr) module
    pub type C10CR = crate::Reg<u32, _C10CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C10CR;
    ///`read()` method returns [c10cr::R](c10cr::R) reader structure
    impl crate::Readable for C10CR {}
    ///`write(|w| ..)` method takes [c10cr::W](c10cr::W) writer structure
    impl crate::Writable for C10CR {}
    ///channel 10 configuration register
    pub mod c10cr {
        ///Reader of register C10CR
        pub type R = crate::R<u32, super::C10CR>;
        ///Writer for register C10CR
        pub type W = crate::W<u32, super::C10CR>;
        ///Register C10CR `reset()`'s with value 0
        impl crate::ResetValue for super::C10CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 11 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c11cr](c11cr) module
    pub type C11CR = crate::Reg<u32, _C11CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C11CR;
    ///`read()` method returns [c11cr::R](c11cr::R) reader structure
    impl crate::Readable for C11CR {}
    ///`write(|w| ..)` method takes [c11cr::W](c11cr::W) writer structure
    impl crate::Writable for C11CR {}
    ///channel 11 configuration register
    pub mod c11cr {
        ///Reader of register C11CR
        pub type R = crate::R<u32, super::C11CR>;
        ///Writer for register C11CR
        pub type W = crate::W<u32, super::C11CR>;
        ///Register C11CR `reset()`'s with value 0
        impl crate::ResetValue for super::C11CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 12 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c12cr](c12cr) module
    pub type C12CR = crate::Reg<u32, _C12CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C12CR;
    ///`read()` method returns [c12cr::R](c12cr::R) reader structure
    impl crate::Readable for C12CR {}
    ///`write(|w| ..)` method takes [c12cr::W](c12cr::W) writer structure
    impl crate::Writable for C12CR {}
    ///channel 12 configuration register
    pub mod c12cr {
        ///Reader of register C12CR
        pub type R = crate::R<u32, super::C12CR>;
        ///Writer for register C12CR
        pub type W = crate::W<u32, super::C12CR>;
        ///Register C12CR `reset()`'s with value 0
        impl crate::ResetValue for super::C12CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel 13 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [c13cr](c13cr) module
    pub type C13CR = crate::Reg<u32, _C13CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _C13CR;
    ///`read()` method returns [c13cr::R](c13cr::R) reader structure
    impl crate::Readable for C13CR {}
    ///`write(|w| ..)` method takes [c13cr::W](c13cr::W) writer structure
    impl crate::Writable for C13CR {}
    ///channel 13 configuration register
    pub mod c13cr {
        ///Reader of register C13CR
        pub type R = crate::R<u32, super::C13CR>;
        ///Writer for register C13CR
        pub type W = crate::W<u32, super::C13CR>;
        ///Register C13CR `reset()`'s with value 0
        impl crate::ResetValue for super::C13CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `SYNC_ID`
        pub type SYNC_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SYNC_ID`
        pub struct SYNC_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNC_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 24)) | (((value as u32) & 0x1f) << 24);
                self.w
            }
        }
        ///Reader of field `NBREQ`
        pub type NBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `NBREQ`
        pub struct NBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `SPOL`
        pub type SPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `SPOL`
        pub struct SPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `SE`
        pub type SE_R = crate::R<bool, bool>;
        ///Write proxy for field `SE`
        pub struct SE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `EGE`
        pub type EGE_R = crate::R<bool, bool>;
        ///Write proxy for field `EGE`
        pub struct EGE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EGE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `SOIE`
        pub type SOIE_R = crate::R<bool, bool>;
        ///Write proxy for field `SOIE`
        pub struct SOIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `DMAREQ_ID`
        pub type DMAREQ_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `DMAREQ_ID`
        pub struct DMAREQ_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DMAREQ_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&self) -> SYNC_ID_R {
                SYNC_ID_R::new(((self.bits >> 24) & 0x1f) as u8)
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&self) -> NBREQ_R {
                NBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&self) -> SPOL_R {
                SPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&self) -> SE_R {
                SE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&self) -> EGE_R {
                EGE_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&self) -> SOIE_R {
                SOIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&self) -> DMAREQ_ID_R {
                DMAREQ_ID_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bits 24:28 - Synchronization identification
            #[inline(always)]
            pub fn sync_id(&mut self) -> SYNC_ID_W {
                SYNC_ID_W { w: self }
            }
            ///Bits 19:23 - Number of DMA requests minus 1 to forward
            #[inline(always)]
            pub fn nbreq(&mut self) -> NBREQ_W {
                NBREQ_W { w: self }
            }
            ///Bits 17:18 - Synchronization polarity
            #[inline(always)]
            pub fn spol(&mut self) -> SPOL_W {
                SPOL_W { w: self }
            }
            ///Bit 16 - Synchronization enable
            #[inline(always)]
            pub fn se(&mut self) -> SE_W {
                SE_W { w: self }
            }
            ///Bit 9 - Event generation enable
            #[inline(always)]
            pub fn ege(&mut self) -> EGE_W {
                EGE_W { w: self }
            }
            ///Bit 8 - Synchronization overrun interrupt enable
            #[inline(always)]
            pub fn soie(&mut self) -> SOIE_W {
                SOIE_W { w: self }
            }
            ///Bits 0:6 - DMA request identification
            #[inline(always)]
            pub fn dmareq_id(&mut self) -> DMAREQ_ID_W {
                DMAREQ_ID_W { w: self }
            }
        }
    }
    ///channel status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [csr](csr) module
    pub type CSR = crate::Reg<u32, _CSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CSR;
    ///`read()` method returns [csr::R](csr::R) reader structure
    impl crate::Readable for CSR {}
    ///channel status register
    pub mod csr {
        ///Reader of register CSR
        pub type R = crate::R<u32, super::CSR>;
        ///Reader of field `SOF0`
        pub type SOF0_R = crate::R<bool, bool>;
        ///Reader of field `SOF1`
        pub type SOF1_R = crate::R<bool, bool>;
        ///Reader of field `SOF2`
        pub type SOF2_R = crate::R<bool, bool>;
        ///Reader of field `SOF3`
        pub type SOF3_R = crate::R<bool, bool>;
        ///Reader of field `SOF4`
        pub type SOF4_R = crate::R<bool, bool>;
        ///Reader of field `SOF5`
        pub type SOF5_R = crate::R<bool, bool>;
        ///Reader of field `SOF6`
        pub type SOF6_R = crate::R<bool, bool>;
        ///Reader of field `SOF7`
        pub type SOF7_R = crate::R<bool, bool>;
        ///Reader of field `SOF8`
        pub type SOF8_R = crate::R<bool, bool>;
        ///Reader of field `SOF9`
        pub type SOF9_R = crate::R<bool, bool>;
        ///Reader of field `SOF10`
        pub type SOF10_R = crate::R<bool, bool>;
        ///Reader of field `SOF11`
        pub type SOF11_R = crate::R<bool, bool>;
        ///Reader of field `SOF12`
        pub type SOF12_R = crate::R<bool, bool>;
        ///Reader of field `SOF13`
        pub type SOF13_R = crate::R<bool, bool>;
        impl R {
            ///Bit 0 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof0(&self) -> SOF0_R {
                SOF0_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof1(&self) -> SOF1_R {
                SOF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 2 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof2(&self) -> SOF2_R {
                SOF2_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 3 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof3(&self) -> SOF3_R {
                SOF3_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 4 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof4(&self) -> SOF4_R {
                SOF4_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 5 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof5(&self) -> SOF5_R {
                SOF5_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 6 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof6(&self) -> SOF6_R {
                SOF6_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 7 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof7(&self) -> SOF7_R {
                SOF7_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 8 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof8(&self) -> SOF8_R {
                SOF8_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 9 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof9(&self) -> SOF9_R {
                SOF9_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 10 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof10(&self) -> SOF10_R {
                SOF10_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 11 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof11(&self) -> SOF11_R {
                SOF11_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 12 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof12(&self) -> SOF12_R {
                SOF12_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 13 - Synchronization overrun event flag
            #[inline(always)]
            pub fn sof13(&self) -> SOF13_R {
                SOF13_R::new(((self.bits >> 13) & 0x01) != 0)
            }
        }
    }
    ///clear flag register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cfr](cfr) module
    pub type CFR = crate::Reg<u32, _CFR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CFR;
    ///`write(|w| ..)` method takes [cfr::W](cfr::W) writer structure
    impl crate::Writable for CFR {}
    ///clear flag register
    pub mod cfr {
        ///Writer for register CFR
        pub type W = crate::W<u32, super::CFR>;
        ///Register CFR `reset()`'s with value 0
        impl crate::ResetValue for super::CFR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `CSOF0`
        pub struct CSOF0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF0_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Write proxy for field `CSOF1`
        pub struct CSOF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Write proxy for field `CSOF2`
        pub struct CSOF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Write proxy for field `CSOF3`
        pub struct CSOF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Write proxy for field `CSOF4`
        pub struct CSOF4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Write proxy for field `CSOF5`
        pub struct CSOF5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF5_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Write proxy for field `CSOF6`
        pub struct CSOF6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF6_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Write proxy for field `CSOF7`
        pub struct CSOF7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF7_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Write proxy for field `CSOF8`
        pub struct CSOF8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF8_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Write proxy for field `CSOF9`
        pub struct CSOF9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF9_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Write proxy for field `CSOF10`
        pub struct CSOF10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF10_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Write proxy for field `CSOF11`
        pub struct CSOF11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF11_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Write proxy for field `CSOF12`
        pub struct CSOF12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF12_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Write proxy for field `CSOF13`
        pub struct CSOF13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CSOF13_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        impl W {
            ///Bit 0 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof0(&mut self) -> CSOF0_W {
                CSOF0_W { w: self }
            }
            ///Bit 1 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof1(&mut self) -> CSOF1_W {
                CSOF1_W { w: self }
            }
            ///Bit 2 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof2(&mut self) -> CSOF2_W {
                CSOF2_W { w: self }
            }
            ///Bit 3 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof3(&mut self) -> CSOF3_W {
                CSOF3_W { w: self }
            }
            ///Bit 4 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof4(&mut self) -> CSOF4_W {
                CSOF4_W { w: self }
            }
            ///Bit 5 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof5(&mut self) -> CSOF5_W {
                CSOF5_W { w: self }
            }
            ///Bit 6 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof6(&mut self) -> CSOF6_W {
                CSOF6_W { w: self }
            }
            ///Bit 7 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof7(&mut self) -> CSOF7_W {
                CSOF7_W { w: self }
            }
            ///Bit 8 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof8(&mut self) -> CSOF8_W {
                CSOF8_W { w: self }
            }
            ///Bit 9 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof9(&mut self) -> CSOF9_W {
                CSOF9_W { w: self }
            }
            ///Bit 10 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof10(&mut self) -> CSOF10_W {
                CSOF10_W { w: self }
            }
            ///Bit 11 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof11(&mut self) -> CSOF11_W {
                CSOF11_W { w: self }
            }
            ///Bit 12 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof12(&mut self) -> CSOF12_W {
                CSOF12_W { w: self }
            }
            ///Bit 13 - Clear synchronization overrun event flag
            #[inline(always)]
            pub fn csof13(&mut self) -> CSOF13_W {
                CSOF13_W { w: self }
            }
        }
    }
    ///request generator channel 0 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rg0cr](rg0cr) module
    pub type RG0CR = crate::Reg<u32, _RG0CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RG0CR;
    ///`read()` method returns [rg0cr::R](rg0cr::R) reader structure
    impl crate::Readable for RG0CR {}
    ///`write(|w| ..)` method takes [rg0cr::W](rg0cr::W) writer structure
    impl crate::Writable for RG0CR {}
    ///request generator channel 0 configuration register
    pub mod rg0cr {
        ///Reader of register RG0CR
        pub type R = crate::R<u32, super::RG0CR>;
        ///Writer for register RG0CR
        pub type W = crate::W<u32, super::RG0CR>;
        ///Register RG0CR `reset()`'s with value 0
        impl crate::ResetValue for super::RG0CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `GNBREQ`
        pub type GNBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `GNBREQ`
        pub struct GNBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GNBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `GPOL`
        pub type GPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `GPOL`
        pub struct GPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `GE`
        pub type GE_R = crate::R<bool, bool>;
        ///Write proxy for field `GE`
        pub struct GE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `OIE`
        pub type OIE_R = crate::R<bool, bool>;
        ///Write proxy for field `OIE`
        pub struct OIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `SIG_ID`
        pub type SIG_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SIG_ID`
        pub struct SIG_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SIG_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        impl R {
            ///Bits 19:23 - Number of DMA requests to be generated minus 1
            #[inline(always)]
            pub fn gnbreq(&self) -> GNBREQ_R {
                GNBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - DMA request generator trigger polarity
            #[inline(always)]
            pub fn gpol(&self) -> GPOL_R {
                GPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - DMA request generator channel 0 enable
            #[inline(always)]
            pub fn ge(&self) -> GE_R {
                GE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 8 - Trigger overrun interrupt enable
            #[inline(always)]
            pub fn oie(&self) -> OIE_R {
                OIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:4 - Signal identification
            #[inline(always)]
            pub fn sig_id(&self) -> SIG_ID_R {
                SIG_ID_R::new((self.bits & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 19:23 - Number of DMA requests to be generated minus 1
            #[inline(always)]
            pub fn gnbreq(&mut self) -> GNBREQ_W {
                GNBREQ_W { w: self }
            }
            ///Bits 17:18 - DMA request generator trigger polarity
            #[inline(always)]
            pub fn gpol(&mut self) -> GPOL_W {
                GPOL_W { w: self }
            }
            ///Bit 16 - DMA request generator channel 0 enable
            #[inline(always)]
            pub fn ge(&mut self) -> GE_W {
                GE_W { w: self }
            }
            ///Bit 8 - Trigger overrun interrupt enable
            #[inline(always)]
            pub fn oie(&mut self) -> OIE_W {
                OIE_W { w: self }
            }
            ///Bits 0:4 - Signal identification
            #[inline(always)]
            pub fn sig_id(&mut self) -> SIG_ID_W {
                SIG_ID_W { w: self }
            }
        }
    }
    ///request generator channel 1 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rg1cr](rg1cr) module
    pub type RG1CR = crate::Reg<u32, _RG1CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RG1CR;
    ///`read()` method returns [rg1cr::R](rg1cr::R) reader structure
    impl crate::Readable for RG1CR {}
    ///`write(|w| ..)` method takes [rg1cr::W](rg1cr::W) writer structure
    impl crate::Writable for RG1CR {}
    ///request generator channel 1 configuration register
    pub mod rg1cr {
        ///Reader of register RG1CR
        pub type R = crate::R<u32, super::RG1CR>;
        ///Writer for register RG1CR
        pub type W = crate::W<u32, super::RG1CR>;
        ///Register RG1CR `reset()`'s with value 0
        impl crate::ResetValue for super::RG1CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `GNBREQ`
        pub type GNBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `GNBREQ`
        pub struct GNBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GNBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `GPOL`
        pub type GPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `GPOL`
        pub struct GPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `GE`
        pub type GE_R = crate::R<bool, bool>;
        ///Write proxy for field `GE`
        pub struct GE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `OIE`
        pub type OIE_R = crate::R<bool, bool>;
        ///Write proxy for field `OIE`
        pub struct OIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `SIG_ID`
        pub type SIG_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SIG_ID`
        pub struct SIG_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SIG_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        impl R {
            ///Bits 19:23 - Number of DMA requests to be generated minus 1
            #[inline(always)]
            pub fn gnbreq(&self) -> GNBREQ_R {
                GNBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - DMA request generator trigger polarity
            #[inline(always)]
            pub fn gpol(&self) -> GPOL_R {
                GPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - DMA request generator channel 1 enable
            #[inline(always)]
            pub fn ge(&self) -> GE_R {
                GE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 8 - Trigger overrun interrupt enable
            #[inline(always)]
            pub fn oie(&self) -> OIE_R {
                OIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:4 - Signal identification
            #[inline(always)]
            pub fn sig_id(&self) -> SIG_ID_R {
                SIG_ID_R::new((self.bits & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 19:23 - Number of DMA requests to be generated minus 1
            #[inline(always)]
            pub fn gnbreq(&mut self) -> GNBREQ_W {
                GNBREQ_W { w: self }
            }
            ///Bits 17:18 - DMA request generator trigger polarity
            #[inline(always)]
            pub fn gpol(&mut self) -> GPOL_W {
                GPOL_W { w: self }
            }
            ///Bit 16 - DMA request generator channel 1 enable
            #[inline(always)]
            pub fn ge(&mut self) -> GE_W {
                GE_W { w: self }
            }
            ///Bit 8 - Trigger overrun interrupt enable
            #[inline(always)]
            pub fn oie(&mut self) -> OIE_W {
                OIE_W { w: self }
            }
            ///Bits 0:4 - Signal identification
            #[inline(always)]
            pub fn sig_id(&mut self) -> SIG_ID_W {
                SIG_ID_W { w: self }
            }
        }
    }
    ///request generator channel 2 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rg2cr](rg2cr) module
    pub type RG2CR = crate::Reg<u32, _RG2CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RG2CR;
    ///`read()` method returns [rg2cr::R](rg2cr::R) reader structure
    impl crate::Readable for RG2CR {}
    ///`write(|w| ..)` method takes [rg2cr::W](rg2cr::W) writer structure
    impl crate::Writable for RG2CR {}
    ///request generator channel 2 configuration register
    pub mod rg2cr {
        ///Reader of register RG2CR
        pub type R = crate::R<u32, super::RG2CR>;
        ///Writer for register RG2CR
        pub type W = crate::W<u32, super::RG2CR>;
        ///Register RG2CR `reset()`'s with value 0
        impl crate::ResetValue for super::RG2CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `GNBREQ`
        pub type GNBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `GNBREQ`
        pub struct GNBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GNBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `GPOL`
        pub type GPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `GPOL`
        pub struct GPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `GE`
        pub type GE_R = crate::R<bool, bool>;
        ///Write proxy for field `GE`
        pub struct GE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `OIE`
        pub type OIE_R = crate::R<bool, bool>;
        ///Write proxy for field `OIE`
        pub struct OIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `SIG_ID`
        pub type SIG_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SIG_ID`
        pub struct SIG_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SIG_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        impl R {
            ///Bits 19:23 - Number of DMA requests to be generated minus 1
            #[inline(always)]
            pub fn gnbreq(&self) -> GNBREQ_R {
                GNBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - DMA request generator trigger polarity
            #[inline(always)]
            pub fn gpol(&self) -> GPOL_R {
                GPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - DMA request generator channel 2 enable
            #[inline(always)]
            pub fn ge(&self) -> GE_R {
                GE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 8 - Trigger overrun interrupt enable
            #[inline(always)]
            pub fn oie(&self) -> OIE_R {
                OIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:4 - Signal identification
            #[inline(always)]
            pub fn sig_id(&self) -> SIG_ID_R {
                SIG_ID_R::new((self.bits & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 19:23 - Number of DMA requests to be generated minus 1
            #[inline(always)]
            pub fn gnbreq(&mut self) -> GNBREQ_W {
                GNBREQ_W { w: self }
            }
            ///Bits 17:18 - DMA request generator trigger polarity
            #[inline(always)]
            pub fn gpol(&mut self) -> GPOL_W {
                GPOL_W { w: self }
            }
            ///Bit 16 - DMA request generator channel 2 enable
            #[inline(always)]
            pub fn ge(&mut self) -> GE_W {
                GE_W { w: self }
            }
            ///Bit 8 - Trigger overrun interrupt enable
            #[inline(always)]
            pub fn oie(&mut self) -> OIE_W {
                OIE_W { w: self }
            }
            ///Bits 0:4 - Signal identification
            #[inline(always)]
            pub fn sig_id(&mut self) -> SIG_ID_W {
                SIG_ID_W { w: self }
            }
        }
    }
    ///request generator channel 3 configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rg3cr](rg3cr) module
    pub type RG3CR = crate::Reg<u32, _RG3CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RG3CR;
    ///`read()` method returns [rg3cr::R](rg3cr::R) reader structure
    impl crate::Readable for RG3CR {}
    ///`write(|w| ..)` method takes [rg3cr::W](rg3cr::W) writer structure
    impl crate::Writable for RG3CR {}
    ///request generator channel 3 configuration register
    pub mod rg3cr {
        ///Reader of register RG3CR
        pub type R = crate::R<u32, super::RG3CR>;
        ///Writer for register RG3CR
        pub type W = crate::W<u32, super::RG3CR>;
        ///Register RG3CR `reset()`'s with value 0
        impl crate::ResetValue for super::RG3CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `GNBREQ`
        pub type GNBREQ_R = crate::R<u8, u8>;
        ///Write proxy for field `GNBREQ`
        pub struct GNBREQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GNBREQ_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1f << 19)) | (((value as u32) & 0x1f) << 19);
                self.w
            }
        }
        ///Reader of field `GPOL`
        pub type GPOL_R = crate::R<u8, u8>;
        ///Write proxy for field `GPOL`
        pub struct GPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GPOL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 17)) | (((value as u32) & 0x03) << 17);
                self.w
            }
        }
        ///Reader of field `GE`
        pub type GE_R = crate::R<bool, bool>;
        ///Write proxy for field `GE`
        pub struct GE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `OIE`
        pub type OIE_R = crate::R<bool, bool>;
        ///Write proxy for field `OIE`
        pub struct OIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> OIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `SIG_ID`
        pub type SIG_ID_R = crate::R<u8, u8>;
        ///Write proxy for field `SIG_ID`
        pub struct SIG_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SIG_ID_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
                self.w
            }
        }
        impl R {
            ///Bits 19:23 - Number of DMA requests to be generated minus 1
            #[inline(always)]
            pub fn gnbreq(&self) -> GNBREQ_R {
                GNBREQ_R::new(((self.bits >> 19) & 0x1f) as u8)
            }
            ///Bits 17:18 - DMA request generator trigger polarity
            #[inline(always)]
            pub fn gpol(&self) -> GPOL_R {
                GPOL_R::new(((self.bits >> 17) & 0x03) as u8)
            }
            ///Bit 16 - DMA request generator channel 3 enable
            #[inline(always)]
            pub fn ge(&self) -> GE_R {
                GE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 8 - Trigger overrun interrupt enable
            #[inline(always)]
            pub fn oie(&self) -> OIE_R {
                OIE_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bits 0:4 - Signal identification
            #[inline(always)]
            pub fn sig_id(&self) -> SIG_ID_R {
                SIG_ID_R::new((self.bits & 0x1f) as u8)
            }
        }
        impl W {
            ///Bits 19:23 - Number of DMA requests to be generated minus 1
            #[inline(always)]
            pub fn gnbreq(&mut self) -> GNBREQ_W {
                GNBREQ_W { w: self }
            }
            ///Bits 17:18 - DMA request generator trigger polarity
            #[inline(always)]
            pub fn gpol(&mut self) -> GPOL_W {
                GPOL_W { w: self }
            }
            ///Bit 16 - DMA request generator channel 3 enable
            #[inline(always)]
            pub fn ge(&mut self) -> GE_W {
                GE_W { w: self }
            }
            ///Bit 8 - Trigger overrun interrupt enable
            #[inline(always)]
            pub fn oie(&mut self) -> OIE_W {
                OIE_W { w: self }
            }
            ///Bits 0:4 - Signal identification
            #[inline(always)]
            pub fn sig_id(&mut self) -> SIG_ID_W {
                SIG_ID_W { w: self }
            }
        }
    }
    ///request generator interrupt status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rgsr](rgsr) module
    pub type RGSR = crate::Reg<u32, _RGSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RGSR;
    ///`read()` method returns [rgsr::R](rgsr::R) reader structure
    impl crate::Readable for RGSR {}
    ///request generator interrupt status register
    pub mod rgsr {
        ///Reader of register RGSR
        pub type R = crate::R<u32, super::RGSR>;
        ///Reader of field `OF3`
        pub type OF3_R = crate::R<bool, bool>;
        ///Reader of field `OF2`
        pub type OF2_R = crate::R<bool, bool>;
        ///Reader of field `OF1`
        pub type OF1_R = crate::R<bool, bool>;
        ///Reader of field `OF0`
        pub type OF0_R = crate::R<bool, bool>;
        impl R {
            ///Bit 3 - Trigger overrun event flag
            #[inline(always)]
            pub fn of3(&self) -> OF3_R {
                OF3_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Trigger overrun event flag
            #[inline(always)]
            pub fn of2(&self) -> OF2_R {
                OF2_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Trigger overrun event flag
            #[inline(always)]
            pub fn of1(&self) -> OF1_R {
                OF1_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Trigger overrun event flag
            #[inline(always)]
            pub fn of0(&self) -> OF0_R {
                OF0_R::new((self.bits & 0x01) != 0)
            }
        }
    }
    ///request generator interrupt clear flag register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rgcfr](rgcfr) module
    pub type RGCFR = crate::Reg<u32, _RGCFR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RGCFR;
    ///`write(|w| ..)` method takes [rgcfr::W](rgcfr::W) writer structure
    impl crate::Writable for RGCFR {}
    ///request generator interrupt clear flag register
    pub mod rgcfr {
        ///Writer for register RGCFR
        pub type W = crate::W<u32, super::RGCFR>;
        ///Register RGCFR `reset()`'s with value 0
        impl crate::ResetValue for super::RGCFR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `COF3`
        pub struct COF3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COF3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Write proxy for field `COF2`
        pub struct COF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COF2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Write proxy for field `COF1`
        pub struct COF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COF1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Write proxy for field `COF0`
        pub struct COF0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COF0_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl W {
            ///Bit 3 - Clear trigger overrun event flag
            #[inline(always)]
            pub fn cof3(&mut self) -> COF3_W {
                COF3_W { w: self }
            }
            ///Bit 2 - Clear trigger overrun event flag
            #[inline(always)]
            pub fn cof2(&mut self) -> COF2_W {
                COF2_W { w: self }
            }
            ///Bit 1 - Clear trigger overrun event flag
            #[inline(always)]
            pub fn cof1(&mut self) -> COF1_W {
                COF1_W { w: self }
            }
            ///Bit 0 - Clear trigger overrun event flag
            #[inline(always)]
            pub fn cof0(&mut self) -> COF0_W {
                COF0_W { w: self }
            }
        }
    }
}
///Cyclic redundancy check calculation unit
pub struct CRC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRC {}
impl CRC {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const crc::RegisterBlock {
        0x4002_3000 as *const _
    }
}
impl Deref for CRC {
    type Target = crc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*CRC::ptr() }
    }
}
///Cyclic redundancy check calculation unit
pub mod crc {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        _reserved_0_dr: [u8; 4usize],
        ///0x04 - Independent data register
        pub idr: IDR,
        ///0x08 - Control register
        pub cr: CR,
        _reserved3: [u8; 4usize],
        ///0x10 - Initial CRC value
        pub init: INIT,
        ///0x14 - polynomial
        pub pol: POL,
    }
    impl RegisterBlock {
        ///0x00 - Data register - half-word sized
        #[inline(always)]
        pub fn dr16(&self) -> &DR16 {
            unsafe { &*(((self as *const Self) as *const u8).add(0usize) as *const DR16) }
        }
        ///0x00 - Data register - half-word sized
        #[inline(always)]
        pub fn dr16_mut(&self) -> &mut DR16 {
            unsafe { &mut *(((self as *const Self) as *mut u8).add(0usize) as *mut DR16) }
        }
        ///0x00 - Data register - byte sized
        #[inline(always)]
        pub fn dr8(&self) -> &DR8 {
            unsafe { &*(((self as *const Self) as *const u8).add(0usize) as *const DR8) }
        }
        ///0x00 - Data register - byte sized
        #[inline(always)]
        pub fn dr8_mut(&self) -> &mut DR8 {
            unsafe { &mut *(((self as *const Self) as *mut u8).add(0usize) as *mut DR8) }
        }
        ///0x00 - Data register
        #[inline(always)]
        pub fn dr(&self) -> &DR {
            unsafe { &*(((self as *const Self) as *const u8).add(0usize) as *const DR) }
        }
        ///0x00 - Data register
        #[inline(always)]
        pub fn dr_mut(&self) -> &mut DR {
            unsafe { &mut *(((self as *const Self) as *mut u8).add(0usize) as *mut DR) }
        }
    }
    ///Data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dr](dr) module
    pub type DR = crate::Reg<u32, _DR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DR;
    ///`read()` method returns [dr::R](dr::R) reader structure
    impl crate::Readable for DR {}
    ///`write(|w| ..)` method takes [dr::W](dr::W) writer structure
    impl crate::Writable for DR {}
    ///Data register
    pub mod dr {
        ///Reader of register DR
        pub type R = crate::R<u32, super::DR>;
        ///Writer for register DR
        pub type W = crate::W<u32, super::DR>;
        ///Register DR `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::DR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `DR`
        pub type DR_R = crate::R<u32, u32>;
        ///Write proxy for field `DR`
        pub struct DR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Data register bits
            #[inline(always)]
            pub fn dr(&self) -> DR_R {
                DR_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Data register bits
            #[inline(always)]
            pub fn dr(&mut self) -> DR_W {
                DR_W { w: self }
            }
        }
    }
    ///Independent data register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [idr](idr) module
    pub type IDR = crate::Reg<u32, _IDR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IDR;
    ///`read()` method returns [idr::R](idr::R) reader structure
    impl crate::Readable for IDR {}
    ///`write(|w| ..)` method takes [idr::W](idr::W) writer structure
    impl crate::Writable for IDR {}
    ///Independent data register
    pub mod idr {
        ///Reader of register IDR
        pub type R = crate::R<u32, super::IDR>;
        ///Writer for register IDR
        pub type W = crate::W<u32, super::IDR>;
        ///Register IDR `reset()`'s with value 0
        impl crate::ResetValue for super::IDR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `IDR`
        pub type IDR_R = crate::R<u8, u8>;
        ///Write proxy for field `IDR`
        pub struct IDR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IDR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - General-purpose 8-bit data register bits
            #[inline(always)]
            pub fn idr(&self) -> IDR_R {
                IDR_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - General-purpose 8-bit data register bits
            #[inline(always)]
            pub fn idr(&mut self) -> IDR_W {
                IDR_W { w: self }
            }
        }
    }
    ///Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///Control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reverse output data
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum REV_OUT_A {
            ///0: Bit order not affected
            NORMAL = 0,
            ///1: Bit reversed output
            REVERSED = 1,
        }
        impl From<REV_OUT_A> for bool {
            #[inline(always)]
            fn from(variant: REV_OUT_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `REV_OUT`
        pub type REV_OUT_R = crate::R<bool, REV_OUT_A>;
        impl REV_OUT_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> REV_OUT_A {
                match self.bits {
                    false => REV_OUT_A::NORMAL,
                    true => REV_OUT_A::REVERSED,
                }
            }
            ///Checks if the value of the field is `NORMAL`
            #[inline(always)]
            pub fn is_normal(&self) -> bool {
                *self == REV_OUT_A::NORMAL
            }
            ///Checks if the value of the field is `REVERSED`
            #[inline(always)]
            pub fn is_reversed(&self) -> bool {
                *self == REV_OUT_A::REVERSED
            }
        }
        ///Write proxy for field `REV_OUT`
        pub struct REV_OUT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> REV_OUT_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: REV_OUT_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Bit order not affected
            #[inline(always)]
            pub fn normal(self) -> &'a mut W {
                self.variant(REV_OUT_A::NORMAL)
            }
            ///Bit reversed output
            #[inline(always)]
            pub fn reversed(self) -> &'a mut W {
                self.variant(REV_OUT_A::REVERSED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reverse input data
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum REV_IN_A {
            ///0: Bit order not affected
            NORMAL = 0,
            ///1: Bit reversal done by byte
            BYTE = 1,
            ///2: Bit reversal done by half-word
            HALFWORD = 2,
            ///3: Bit reversal done by word
            WORD = 3,
        }
        impl From<REV_IN_A> for u8 {
            #[inline(always)]
            fn from(variant: REV_IN_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `REV_IN`
        pub type REV_IN_R = crate::R<u8, REV_IN_A>;
        impl REV_IN_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> REV_IN_A {
                match self.bits {
                    0 => REV_IN_A::NORMAL,
                    1 => REV_IN_A::BYTE,
                    2 => REV_IN_A::HALFWORD,
                    3 => REV_IN_A::WORD,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `NORMAL`
            #[inline(always)]
            pub fn is_normal(&self) -> bool {
                *self == REV_IN_A::NORMAL
            }
            ///Checks if the value of the field is `BYTE`
            #[inline(always)]
            pub fn is_byte(&self) -> bool {
                *self == REV_IN_A::BYTE
            }
            ///Checks if the value of the field is `HALFWORD`
            #[inline(always)]
            pub fn is_half_word(&self) -> bool {
                *self == REV_IN_A::HALFWORD
            }
            ///Checks if the value of the field is `WORD`
            #[inline(always)]
            pub fn is_word(&self) -> bool {
                *self == REV_IN_A::WORD
            }
        }
        ///Write proxy for field `REV_IN`
        pub struct REV_IN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> REV_IN_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: REV_IN_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Bit order not affected
            #[inline(always)]
            pub fn normal(self) -> &'a mut W {
                self.variant(REV_IN_A::NORMAL)
            }
            ///Bit reversal done by byte
            #[inline(always)]
            pub fn byte(self) -> &'a mut W {
                self.variant(REV_IN_A::BYTE)
            }
            ///Bit reversal done by half-word
            #[inline(always)]
            pub fn half_word(self) -> &'a mut W {
                self.variant(REV_IN_A::HALFWORD)
            }
            ///Bit reversal done by word
            #[inline(always)]
            pub fn word(self) -> &'a mut W {
                self.variant(REV_IN_A::WORD)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 5)) | (((value as u32) & 0x03) << 5);
                self.w
            }
        }
        ///Polynomial size
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum POLYSIZE_A {
            ///0: 32-bit polynomial
            POLYSIZE32 = 0,
            ///1: 16-bit polynomial
            POLYSIZE16 = 1,
            ///2: 8-bit polynomial
            POLYSIZE8 = 2,
            ///3: 7-bit polynomial
            POLYSIZE7 = 3,
        }
        impl From<POLYSIZE_A> for u8 {
            #[inline(always)]
            fn from(variant: POLYSIZE_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `POLYSIZE`
        pub type POLYSIZE_R = crate::R<u8, POLYSIZE_A>;
        impl POLYSIZE_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> POLYSIZE_A {
                match self.bits {
                    0 => POLYSIZE_A::POLYSIZE32,
                    1 => POLYSIZE_A::POLYSIZE16,
                    2 => POLYSIZE_A::POLYSIZE8,
                    3 => POLYSIZE_A::POLYSIZE7,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `POLYSIZE32`
            #[inline(always)]
            pub fn is_polysize32(&self) -> bool {
                *self == POLYSIZE_A::POLYSIZE32
            }
            ///Checks if the value of the field is `POLYSIZE16`
            #[inline(always)]
            pub fn is_polysize16(&self) -> bool {
                *self == POLYSIZE_A::POLYSIZE16
            }
            ///Checks if the value of the field is `POLYSIZE8`
            #[inline(always)]
            pub fn is_polysize8(&self) -> bool {
                *self == POLYSIZE_A::POLYSIZE8
            }
            ///Checks if the value of the field is `POLYSIZE7`
            #[inline(always)]
            pub fn is_polysize7(&self) -> bool {
                *self == POLYSIZE_A::POLYSIZE7
            }
        }
        ///Write proxy for field `POLYSIZE`
        pub struct POLYSIZE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> POLYSIZE_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: POLYSIZE_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///32-bit polynomial
            #[inline(always)]
            pub fn polysize32(self) -> &'a mut W {
                self.variant(POLYSIZE_A::POLYSIZE32)
            }
            ///16-bit polynomial
            #[inline(always)]
            pub fn polysize16(self) -> &'a mut W {
                self.variant(POLYSIZE_A::POLYSIZE16)
            }
            ///8-bit polynomial
            #[inline(always)]
            pub fn polysize8(self) -> &'a mut W {
                self.variant(POLYSIZE_A::POLYSIZE8)
            }
            ///7-bit polynomial
            #[inline(always)]
            pub fn polysize7(self) -> &'a mut W {
                self.variant(POLYSIZE_A::POLYSIZE7)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 3)) | (((value as u32) & 0x03) << 3);
                self.w
            }
        }
        ///RESET bit
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum RESET_AW {
            ///1: Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
            RESET = 1,
        }
        impl From<RESET_AW> for bool {
            #[inline(always)]
            fn from(variant: RESET_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `RESET`
        pub struct RESET_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RESET_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: RESET_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
            #[inline(always)]
            pub fn reset(self) -> &'a mut W {
                self.variant(RESET_AW::RESET)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 7 - Reverse output data
            #[inline(always)]
            pub fn rev_out(&self) -> REV_OUT_R {
                REV_OUT_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bits 5:6 - Reverse input data
            #[inline(always)]
            pub fn rev_in(&self) -> REV_IN_R {
                REV_IN_R::new(((self.bits >> 5) & 0x03) as u8)
            }
            ///Bits 3:4 - Polynomial size
            #[inline(always)]
            pub fn polysize(&self) -> POLYSIZE_R {
                POLYSIZE_R::new(((self.bits >> 3) & 0x03) as u8)
            }
        }
        impl W {
            ///Bit 7 - Reverse output data
            #[inline(always)]
            pub fn rev_out(&mut self) -> REV_OUT_W {
                REV_OUT_W { w: self }
            }
            ///Bits 5:6 - Reverse input data
            #[inline(always)]
            pub fn rev_in(&mut self) -> REV_IN_W {
                REV_IN_W { w: self }
            }
            ///Bits 3:4 - Polynomial size
            #[inline(always)]
            pub fn polysize(&mut self) -> POLYSIZE_W {
                POLYSIZE_W { w: self }
            }
            ///Bit 0 - RESET bit
            #[inline(always)]
            pub fn reset(&mut self) -> RESET_W {
                RESET_W { w: self }
            }
        }
    }
    ///Initial CRC value
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [init](init) module
    pub type INIT = crate::Reg<u32, _INIT>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _INIT;
    ///`read()` method returns [init::R](init::R) reader structure
    impl crate::Readable for INIT {}
    ///`write(|w| ..)` method takes [init::W](init::W) writer structure
    impl crate::Writable for INIT {}
    ///Initial CRC value
    pub mod init {
        ///Reader of register INIT
        pub type R = crate::R<u32, super::INIT>;
        ///Writer for register INIT
        pub type W = crate::W<u32, super::INIT>;
        ///Register INIT `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::INIT {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `INIT`
        pub type INIT_R = crate::R<u32, u32>;
        ///Write proxy for field `INIT`
        pub struct INIT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> INIT_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Programmable initial CRC value
            #[inline(always)]
            pub fn init(&self) -> INIT_R {
                INIT_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Programmable initial CRC value
            #[inline(always)]
            pub fn init(&mut self) -> INIT_W {
                INIT_W { w: self }
            }
        }
    }
    ///polynomial
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [pol](pol) module
    pub type POL = crate::Reg<u32, _POL>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _POL;
    ///`read()` method returns [pol::R](pol::R) reader structure
    impl crate::Readable for POL {}
    ///`write(|w| ..)` method takes [pol::W](pol::W) writer structure
    impl crate::Writable for POL {}
    ///polynomial
    pub mod pol {
        ///Reader of register POL
        pub type R = crate::R<u32, super::POL>;
        ///Writer for register POL
        pub type W = crate::W<u32, super::POL>;
        ///Register POL `reset()`'s with value 0x04c1_1db7
        impl crate::ResetValue for super::POL {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x04c1_1db7
            }
        }
        ///Reader of field `Polynomialcoefficients`
        pub type POLYNOMIALCOEFFICIENTS_R = crate::R<u32, u32>;
        ///Write proxy for field `Polynomialcoefficients`
        pub struct POLYNOMIALCOEFFICIENTS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> POLYNOMIALCOEFFICIENTS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Programmable polynomial
            #[inline(always)]
            pub fn polynomialcoefficients(&self) -> POLYNOMIALCOEFFICIENTS_R {
                POLYNOMIALCOEFFICIENTS_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Programmable polynomial
            #[inline(always)]
            pub fn polynomialcoefficients(&mut self) -> POLYNOMIALCOEFFICIENTS_W {
                POLYNOMIALCOEFFICIENTS_W { w: self }
            }
        }
    }
    ///Data register - byte sized
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dr8](dr8) module
    pub type DR8 = crate::Reg<u8, _DR8>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DR8;
    ///`read()` method returns [dr8::R](dr8::R) reader structure
    impl crate::Readable for DR8 {}
    ///`write(|w| ..)` method takes [dr8::W](dr8::W) writer structure
    impl crate::Writable for DR8 {}
    ///Data register - byte sized
    pub mod dr8 {
        ///Reader of register DR8
        pub type R = crate::R<u8, super::DR8>;
        ///Writer for register DR8
        pub type W = crate::W<u8, super::DR8>;
        ///Register DR8 `reset()`'s with value 0xff
        impl crate::ResetValue for super::DR8 {
            type Type = u8;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xff
            }
        }
        ///Reader of field `DR8`
        pub type DR8_R = crate::R<u8, u8>;
        ///Write proxy for field `DR8`
        pub struct DR8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DR8_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u8) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Data register bits
            #[inline(always)]
            pub fn dr8(&self) -> DR8_R {
                DR8_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Data register bits
            #[inline(always)]
            pub fn dr8(&mut self) -> DR8_W {
                DR8_W { w: self }
            }
        }
    }
    ///Data register - half-word sized
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [dr16](dr16) module
    pub type DR16 = crate::Reg<u16, _DR16>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _DR16;
    ///`read()` method returns [dr16::R](dr16::R) reader structure
    impl crate::Readable for DR16 {}
    ///`write(|w| ..)` method takes [dr16::W](dr16::W) writer structure
    impl crate::Writable for DR16 {}
    ///Data register - half-word sized
    pub mod dr16 {
        ///Reader of register DR16
        pub type R = crate::R<u16, super::DR16>;
        ///Writer for register DR16
        pub type W = crate::W<u16, super::DR16>;
        ///Register DR16 `reset()`'s with value 0xffff
        impl crate::ResetValue for super::DR16 {
            type Type = u16;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff
            }
        }
        ///Reader of field `DR16`
        pub type DR16_R = crate::R<u16, u16>;
        ///Write proxy for field `DR16`
        pub struct DR16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DR16_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u16) & 0xffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:15 - Data register bits
            #[inline(always)]
            pub fn dr16(&self) -> DR16_R {
                DR16_R::new((self.bits & 0xffff) as u16)
            }
        }
        impl W {
            ///Bits 0:15 - Data register bits
            #[inline(always)]
            pub fn dr16(&mut self) -> DR16_W {
                DR16_W { w: self }
            }
        }
    }
}
///Liquid crystal display controller
pub struct LTCD {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LTCD {}
impl LTCD {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const ltcd::RegisterBlock {
        0x4001_6800 as *const _
    }
}
impl Deref for LTCD {
    type Target = ltcd::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*LTCD::ptr() }
    }
}
///Liquid crystal display controller
pub mod ltcd {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        _reserved0: [u8; 8usize],
        ///0x08 - LTDC Synchronization Size Configuration Register
        pub sscr: SSCR,
        ///0x0c - LTDC Back Porch Configuration Register
        pub bpcr: BPCR,
        ///0x10 - LTDC Active Width Configuration Register
        pub awcr: AWCR,
        ///0x14 - LTDC Total Width Configuration Register
        pub twcr: TWCR,
        ///0x18 - LTDC Global Control Register
        pub gcr: GCR,
        _reserved5: [u8; 8usize],
        ///0x24 - LTDC Shadow Reload Configuration Register
        pub srcr: SRCR,
        _reserved6: [u8; 4usize],
        ///0x2c - LTDC Background Color Configuration Register
        pub bccr: BCCR,
        _reserved7: [u8; 4usize],
        ///0x34 - LTDC Interrupt Enable Register
        pub ier: IER,
        ///0x38 - LTDC Interrupt Status Register
        pub isr: ISR,
        ///0x3c - LTDC Interrupt Clear Register
        pub icr: ICR,
        ///0x40 - LTDC Line Interrupt Position Configuration Register
        pub lipcr: LIPCR,
        ///0x44 - LTDC Current Position Status Register
        pub cpsr: CPSR,
        ///0x48 - LTDC Current Display Status Register
        pub cdsr: CDSR,
        _reserved13: [u8; 56usize],
        ///0x84 - LTDC Layer Control Register
        pub l1cr: L1CR,
        ///0x88 - LTDC Layer Window Horizontal Position Configuration Register
        pub l1whpcr: L1WHPCR,
        ///0x8c - LTDC Layer Window Vertical Position Configuration Register
        pub l1wvpcr: L1WVPCR,
        ///0x90 - LTDC Layer Color Keying Configuration Register
        pub l1ckcr: L1CKCR,
        ///0x94 - LTDC Layer Pixel Format Configuration Register
        pub l1pfcr: L1PFCR,
        ///0x98 - LTDC Layer Constant Alpha Configuration Register
        pub l1cacr: L1CACR,
        ///0x9c - LTDC Layer Default Color Configuration Register
        pub l1dccr: L1DCCR,
        ///0xa0 - LTDC Layer Blending Factors Configuration Register
        pub l1bfcr: L1BFCR,
        _reserved21: [u8; 8usize],
        ///0xac - LTDC Layer Color Frame Buffer Address Register
        pub l1cfbar: L1CFBAR,
        ///0xb0 - LTDC Layer Color Frame Buffer Length Register
        pub l1cfblr: L1CFBLR,
        ///0xb4 - LTDC Layer ColorFrame Buffer Line Number Register
        pub l1cfblnr: L1CFBLNR,
        _reserved24: [u8; 12usize],
        ///0xc4 - LTDC Layerx CLUT Write Register
        pub l1clutwr: L1CLUTWR,
        _reserved25: [u8; 60usize],
        ///0x104 - LTDC Layer Control Register
        pub l2cr: L2CR,
        ///0x108 - LTDC Layerx Window Horizontal Position Configuration Register
        pub l2whpcr: L2WHPCR,
        ///0x10c - LTDC Layer Window Vertical Position Configuration Register
        pub l2wvpcr: L2WVPCR,
        ///0x110 - LTDC Layer Color Keying Configuration Register
        pub l2ckcr: L2CKCR,
        ///0x114 - LTDC Layer Pixel Format Configuration Register
        pub l2pfcr: L2PFCR,
        ///0x118 - LTDC Layer Constant Alpha Configuration Register
        pub l2cacr: L2CACR,
        ///0x11c - LTDC Layer Default Color Configuration Register
        pub l2dccr: L2DCCR,
        _reserved32: [u8; 4usize],
        ///0x124 - LTDC Layer Blending Factors Configuration Register
        pub l2bfcr: L2BFCR,
        _reserved33: [u8; 4usize],
        ///0x12c - LTDC Layer Color Frame Buffer Address Register
        pub l2cfbar: L2CFBAR,
        ///0x130 - LTDC Layer Color Frame Buffer Length Register
        pub l2cfblr: L2CFBLR,
        ///0x134 - LTDC Layer ColorFrame Buffer Line Number Register
        pub l2cfblnr: L2CFBLNR,
        _reserved36: [u8; 12usize],
        ///0x144 - LTDC Layerx CLUT Write Register
        pub l2clutwr: L2CLUTWR,
    }
    ///LTDC Synchronization Size Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [sscr](sscr) module
    pub type SSCR = crate::Reg<u32, _SSCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SSCR;
    ///`read()` method returns [sscr::R](sscr::R) reader structure
    impl crate::Readable for SSCR {}
    ///`write(|w| ..)` method takes [sscr::W](sscr::W) writer structure
    impl crate::Writable for SSCR {}
    ///LTDC Synchronization Size Configuration Register
    pub mod sscr {
        ///Reader of register SSCR
        pub type R = crate::R<u32, super::SSCR>;
        ///Writer for register SSCR
        pub type W = crate::W<u32, super::SSCR>;
        ///Register SSCR `reset()`'s with value 0
        impl crate::ResetValue for super::SSCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `VSH`
        pub type VSH_R = crate::R<u16, u16>;
        ///Write proxy for field `VSH`
        pub struct VSH_W<'a> {
            w: &'a mut W,
        }
        impl<'a> VSH_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        ///Reader of field `HSW`
        pub type HSW_R = crate::R<u16, u16>;
        ///Write proxy for field `HSW`
        pub struct HSW_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HSW_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 16)) | (((value as u32) & 0x0fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Vertical Synchronization Height (in units of horizontal scan line)
            #[inline(always)]
            pub fn vsh(&self) -> VSH_R {
                VSH_R::new((self.bits & 0x07ff) as u16)
            }
            ///Bits 16:27 - Horizontal Synchronization Width (in units of pixel clock period)
            #[inline(always)]
            pub fn hsw(&self) -> HSW_R {
                HSW_R::new(((self.bits >> 16) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Vertical Synchronization Height (in units of horizontal scan line)
            #[inline(always)]
            pub fn vsh(&mut self) -> VSH_W {
                VSH_W { w: self }
            }
            ///Bits 16:27 - Horizontal Synchronization Width (in units of pixel clock period)
            #[inline(always)]
            pub fn hsw(&mut self) -> HSW_W {
                HSW_W { w: self }
            }
        }
    }
    ///LTDC Back Porch Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [bpcr](bpcr) module
    pub type BPCR = crate::Reg<u32, _BPCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _BPCR;
    ///`read()` method returns [bpcr::R](bpcr::R) reader structure
    impl crate::Readable for BPCR {}
    ///`write(|w| ..)` method takes [bpcr::W](bpcr::W) writer structure
    impl crate::Writable for BPCR {}
    ///LTDC Back Porch Configuration Register
    pub mod bpcr {
        ///Reader of register BPCR
        pub type R = crate::R<u32, super::BPCR>;
        ///Writer for register BPCR
        pub type W = crate::W<u32, super::BPCR>;
        ///Register BPCR `reset()`'s with value 0
        impl crate::ResetValue for super::BPCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `AVBP`
        pub type AVBP_R = crate::R<u16, u16>;
        ///Write proxy for field `AVBP`
        pub struct AVBP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> AVBP_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        ///Reader of field `AHBP`
        pub type AHBP_R = crate::R<u16, u16>;
        ///Write proxy for field `AHBP`
        pub struct AHBP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> AHBP_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 16)) | (((value as u32) & 0x0fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Accumulated Vertical back porch (in units of horizontal scan line)
            #[inline(always)]
            pub fn avbp(&self) -> AVBP_R {
                AVBP_R::new((self.bits & 0x07ff) as u16)
            }
            ///Bits 16:27 - Accumulated Horizontal back porch (in units of pixel clock period)
            #[inline(always)]
            pub fn ahbp(&self) -> AHBP_R {
                AHBP_R::new(((self.bits >> 16) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Accumulated Vertical back porch (in units of horizontal scan line)
            #[inline(always)]
            pub fn avbp(&mut self) -> AVBP_W {
                AVBP_W { w: self }
            }
            ///Bits 16:27 - Accumulated Horizontal back porch (in units of pixel clock period)
            #[inline(always)]
            pub fn ahbp(&mut self) -> AHBP_W {
                AHBP_W { w: self }
            }
        }
    }
    ///LTDC Active Width Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [awcr](awcr) module
    pub type AWCR = crate::Reg<u32, _AWCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _AWCR;
    ///`read()` method returns [awcr::R](awcr::R) reader structure
    impl crate::Readable for AWCR {}
    ///`write(|w| ..)` method takes [awcr::W](awcr::W) writer structure
    impl crate::Writable for AWCR {}
    ///LTDC Active Width Configuration Register
    pub mod awcr {
        ///Reader of register AWCR
        pub type R = crate::R<u32, super::AWCR>;
        ///Writer for register AWCR
        pub type W = crate::W<u32, super::AWCR>;
        ///Register AWCR `reset()`'s with value 0
        impl crate::ResetValue for super::AWCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `AAH`
        pub type AAH_R = crate::R<u16, u16>;
        ///Write proxy for field `AAH`
        pub struct AAH_W<'a> {
            w: &'a mut W,
        }
        impl<'a> AAH_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        ///Reader of field `AAW`
        pub type AAW_R = crate::R<u16, u16>;
        ///Write proxy for field `AAW`
        pub struct AAW_W<'a> {
            w: &'a mut W,
        }
        impl<'a> AAW_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 16)) | (((value as u32) & 0x0fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Accumulated Active Height (in units of horizontal scan line)
            #[inline(always)]
            pub fn aah(&self) -> AAH_R {
                AAH_R::new((self.bits & 0x07ff) as u16)
            }
            ///Bits 16:27 - Accumulated Active Width (in units of pixel clock period)
            #[inline(always)]
            pub fn aaw(&self) -> AAW_R {
                AAW_R::new(((self.bits >> 16) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Accumulated Active Height (in units of horizontal scan line)
            #[inline(always)]
            pub fn aah(&mut self) -> AAH_W {
                AAH_W { w: self }
            }
            ///Bits 16:27 - Accumulated Active Width (in units of pixel clock period)
            #[inline(always)]
            pub fn aaw(&mut self) -> AAW_W {
                AAW_W { w: self }
            }
        }
    }
    ///LTDC Total Width Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [twcr](twcr) module
    pub type TWCR = crate::Reg<u32, _TWCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _TWCR;
    ///`read()` method returns [twcr::R](twcr::R) reader structure
    impl crate::Readable for TWCR {}
    ///`write(|w| ..)` method takes [twcr::W](twcr::W) writer structure
    impl crate::Writable for TWCR {}
    ///LTDC Total Width Configuration Register
    pub mod twcr {
        ///Reader of register TWCR
        pub type R = crate::R<u32, super::TWCR>;
        ///Writer for register TWCR
        pub type W = crate::W<u32, super::TWCR>;
        ///Register TWCR `reset()`'s with value 0
        impl crate::ResetValue for super::TWCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `TOTALH`
        pub type TOTALH_R = crate::R<u16, u16>;
        ///Write proxy for field `TOTALH`
        pub struct TOTALH_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TOTALH_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        ///Reader of field `TOTALW`
        pub type TOTALW_R = crate::R<u16, u16>;
        ///Write proxy for field `TOTALW`
        pub struct TOTALW_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TOTALW_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 16)) | (((value as u32) & 0x0fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Total Height (in units of horizontal scan line)
            #[inline(always)]
            pub fn totalh(&self) -> TOTALH_R {
                TOTALH_R::new((self.bits & 0x07ff) as u16)
            }
            ///Bits 16:27 - Total Width (in units of pixel clock period)
            #[inline(always)]
            pub fn totalw(&self) -> TOTALW_R {
                TOTALW_R::new(((self.bits >> 16) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Total Height (in units of horizontal scan line)
            #[inline(always)]
            pub fn totalh(&mut self) -> TOTALH_W {
                TOTALH_W { w: self }
            }
            ///Bits 16:27 - Total Width (in units of pixel clock period)
            #[inline(always)]
            pub fn totalw(&mut self) -> TOTALW_W {
                TOTALW_W { w: self }
            }
        }
    }
    ///LTDC Global Control Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [gcr](gcr) module
    pub type GCR = crate::Reg<u32, _GCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _GCR;
    ///`read()` method returns [gcr::R](gcr::R) reader structure
    impl crate::Readable for GCR {}
    ///`write(|w| ..)` method takes [gcr::W](gcr::W) writer structure
    impl crate::Writable for GCR {}
    ///LTDC Global Control Register
    pub mod gcr {
        ///Reader of register GCR
        pub type R = crate::R<u32, super::GCR>;
        ///Writer for register GCR
        pub type W = crate::W<u32, super::GCR>;
        ///Register GCR `reset()`'s with value 0x2220
        impl crate::ResetValue for super::GCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x2220
            }
        }
        ///Reader of field `LTDCEN`
        pub type LTDCEN_R = crate::R<bool, bool>;
        ///Write proxy for field `LTDCEN`
        pub struct LTDCEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LTDCEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `DBW`
        pub type DBW_R = crate::R<u8, u8>;
        ///Reader of field `DGW`
        pub type DGW_R = crate::R<u8, u8>;
        ///Reader of field `DRW`
        pub type DRW_R = crate::R<u8, u8>;
        ///Reader of field `DEN`
        pub type DEN_R = crate::R<bool, bool>;
        ///Write proxy for field `DEN`
        pub struct DEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `PCPOL`
        pub type PCPOL_R = crate::R<bool, bool>;
        ///Write proxy for field `PCPOL`
        pub struct PCPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PCPOL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `DEPOL`
        pub type DEPOL_R = crate::R<bool, bool>;
        ///Write proxy for field `DEPOL`
        pub struct DEPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DEPOL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `VSPOL`
        pub type VSPOL_R = crate::R<bool, bool>;
        ///Write proxy for field `VSPOL`
        pub struct VSPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> VSPOL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `HSPOL`
        pub type HSPOL_R = crate::R<bool, bool>;
        ///Write proxy for field `HSPOL`
        pub struct HSPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> HSPOL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        impl R {
            ///Bit 0 - LCD-TFT controller enable bit
            #[inline(always)]
            pub fn ltdcen(&self) -> LTDCEN_R {
                LTDCEN_R::new((self.bits & 0x01) != 0)
            }
            ///Bits 4:6 - Dither Blue Width
            #[inline(always)]
            pub fn dbw(&self) -> DBW_R {
                DBW_R::new(((self.bits >> 4) & 0x07) as u8)
            }
            ///Bits 8:10 - Dither Green Width
            #[inline(always)]
            pub fn dgw(&self) -> DGW_R {
                DGW_R::new(((self.bits >> 8) & 0x07) as u8)
            }
            ///Bits 12:14 - Dither Red Width
            #[inline(always)]
            pub fn drw(&self) -> DRW_R {
                DRW_R::new(((self.bits >> 12) & 0x07) as u8)
            }
            ///Bit 16 - Dither Enable
            #[inline(always)]
            pub fn den(&self) -> DEN_R {
                DEN_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 28 - Pixel Clock Polarity
            #[inline(always)]
            pub fn pcpol(&self) -> PCPOL_R {
                PCPOL_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 29 - Not Data Enable Polarity
            #[inline(always)]
            pub fn depol(&self) -> DEPOL_R {
                DEPOL_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 30 - Vertical Synchronization Polarity
            #[inline(always)]
            pub fn vspol(&self) -> VSPOL_R {
                VSPOL_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 31 - Horizontal Synchronization Polarity
            #[inline(always)]
            pub fn hspol(&self) -> HSPOL_R {
                HSPOL_R::new(((self.bits >> 31) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 0 - LCD-TFT controller enable bit
            #[inline(always)]
            pub fn ltdcen(&mut self) -> LTDCEN_W {
                LTDCEN_W { w: self }
            }
            ///Bit 16 - Dither Enable
            #[inline(always)]
            pub fn den(&mut self) -> DEN_W {
                DEN_W { w: self }
            }
            ///Bit 28 - Pixel Clock Polarity
            #[inline(always)]
            pub fn pcpol(&mut self) -> PCPOL_W {
                PCPOL_W { w: self }
            }
            ///Bit 29 - Not Data Enable Polarity
            #[inline(always)]
            pub fn depol(&mut self) -> DEPOL_W {
                DEPOL_W { w: self }
            }
            ///Bit 30 - Vertical Synchronization Polarity
            #[inline(always)]
            pub fn vspol(&mut self) -> VSPOL_W {
                VSPOL_W { w: self }
            }
            ///Bit 31 - Horizontal Synchronization Polarity
            #[inline(always)]
            pub fn hspol(&mut self) -> HSPOL_W {
                HSPOL_W { w: self }
            }
        }
    }
    ///LTDC Shadow Reload Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [srcr](srcr) module
    pub type SRCR = crate::Reg<u32, _SRCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SRCR;
    ///`read()` method returns [srcr::R](srcr::R) reader structure
    impl crate::Readable for SRCR {}
    ///`write(|w| ..)` method takes [srcr::W](srcr::W) writer structure
    impl crate::Writable for SRCR {}
    ///LTDC Shadow Reload Configuration Register
    pub mod srcr {
        ///Reader of register SRCR
        pub type R = crate::R<u32, super::SRCR>;
        ///Writer for register SRCR
        pub type W = crate::W<u32, super::SRCR>;
        ///Register SRCR `reset()`'s with value 0
        impl crate::ResetValue for super::SRCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `IMR`
        pub type IMR_R = crate::R<bool, bool>;
        ///Write proxy for field `IMR`
        pub struct IMR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IMR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `VBR`
        pub type VBR_R = crate::R<bool, bool>;
        ///Write proxy for field `VBR`
        pub struct VBR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> VBR_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        impl R {
            ///Bit 0 - Immediate Reload
            #[inline(always)]
            pub fn imr(&self) -> IMR_R {
                IMR_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - Vertical Blanking Reload
            #[inline(always)]
            pub fn vbr(&self) -> VBR_R {
                VBR_R::new(((self.bits >> 1) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 0 - Immediate Reload
            #[inline(always)]
            pub fn imr(&mut self) -> IMR_W {
                IMR_W { w: self }
            }
            ///Bit 1 - Vertical Blanking Reload
            #[inline(always)]
            pub fn vbr(&mut self) -> VBR_W {
                VBR_W { w: self }
            }
        }
    }
    ///LTDC Background Color Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [bccr](bccr) module
    pub type BCCR = crate::Reg<u32, _BCCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _BCCR;
    ///`read()` method returns [bccr::R](bccr::R) reader structure
    impl crate::Readable for BCCR {}
    ///`write(|w| ..)` method takes [bccr::W](bccr::W) writer structure
    impl crate::Writable for BCCR {}
    ///LTDC Background Color Configuration Register
    pub mod bccr {
        ///Reader of register BCCR
        pub type R = crate::R<u32, super::BCCR>;
        ///Writer for register BCCR
        pub type W = crate::W<u32, super::BCCR>;
        ///Register BCCR `reset()`'s with value 0
        impl crate::ResetValue for super::BCCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `BCBLUE`
        pub type BCBLUE_R = crate::R<u8, u8>;
        ///Write proxy for field `BCBLUE`
        pub struct BCBLUE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BCBLUE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `BCGREEN`
        pub type BCGREEN_R = crate::R<u8, u8>;
        ///Write proxy for field `BCGREEN`
        pub struct BCGREEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BCGREEN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        ///Reader of field `BCRED`
        pub type BCRED_R = crate::R<u8, u8>;
        ///Write proxy for field `BCRED`
        pub struct BCRED_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BCRED_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Background Color Blue value
            #[inline(always)]
            pub fn bcblue(&self) -> BCBLUE_R {
                BCBLUE_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 8:15 - Background Color Green value
            #[inline(always)]
            pub fn bcgreen(&self) -> BCGREEN_R {
                BCGREEN_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            ///Bits 16:23 - Background Color Red value
            #[inline(always)]
            pub fn bcred(&self) -> BCRED_R {
                BCRED_R::new(((self.bits >> 16) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Background Color Blue value
            #[inline(always)]
            pub fn bcblue(&mut self) -> BCBLUE_W {
                BCBLUE_W { w: self }
            }
            ///Bits 8:15 - Background Color Green value
            #[inline(always)]
            pub fn bcgreen(&mut self) -> BCGREEN_W {
                BCGREEN_W { w: self }
            }
            ///Bits 16:23 - Background Color Red value
            #[inline(always)]
            pub fn bcred(&mut self) -> BCRED_W {
                BCRED_W { w: self }
            }
        }
    }
    ///LTDC Interrupt Enable Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ier](ier) module
    pub type IER = crate::Reg<u32, _IER>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IER;
    ///`read()` method returns [ier::R](ier::R) reader structure
    impl crate::Readable for IER {}
    ///`write(|w| ..)` method takes [ier::W](ier::W) writer structure
    impl crate::Writable for IER {}
    ///LTDC Interrupt Enable Register
    pub mod ier {
        ///Reader of register IER
        pub type R = crate::R<u32, super::IER>;
        ///Writer for register IER
        pub type W = crate::W<u32, super::IER>;
        ///Register IER `reset()`'s with value 0
        impl crate::ResetValue for super::IER {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `LIE`
        pub type LIE_R = crate::R<bool, bool>;
        ///Write proxy for field `LIE`
        pub struct LIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `FUIE`
        pub type FUIE_R = crate::R<bool, bool>;
        ///Write proxy for field `FUIE`
        pub struct FUIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FUIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `TERRIE`
        pub type TERRIE_R = crate::R<bool, bool>;
        ///Write proxy for field `TERRIE`
        pub struct TERRIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TERRIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `RRIE`
        pub type RRIE_R = crate::R<bool, bool>;
        ///Write proxy for field `RRIE`
        pub struct RRIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RRIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        impl R {
            ///Bit 0 - Line Interrupt Enable
            #[inline(always)]
            pub fn lie(&self) -> LIE_R {
                LIE_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - FIFO Underrun Interrupt Enable
            #[inline(always)]
            pub fn fuie(&self) -> FUIE_R {
                FUIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 2 - Transfer Error Interrupt Enable
            #[inline(always)]
            pub fn terrie(&self) -> TERRIE_R {
                TERRIE_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 3 - Register Reload interrupt enable
            #[inline(always)]
            pub fn rrie(&self) -> RRIE_R {
                RRIE_R::new(((self.bits >> 3) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 0 - Line Interrupt Enable
            #[inline(always)]
            pub fn lie(&mut self) -> LIE_W {
                LIE_W { w: self }
            }
            ///Bit 1 - FIFO Underrun Interrupt Enable
            #[inline(always)]
            pub fn fuie(&mut self) -> FUIE_W {
                FUIE_W { w: self }
            }
            ///Bit 2 - Transfer Error Interrupt Enable
            #[inline(always)]
            pub fn terrie(&mut self) -> TERRIE_W {
                TERRIE_W { w: self }
            }
            ///Bit 3 - Register Reload interrupt enable
            #[inline(always)]
            pub fn rrie(&mut self) -> RRIE_W {
                RRIE_W { w: self }
            }
        }
    }
    ///LTDC Interrupt Status Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [isr](isr) module
    pub type ISR = crate::Reg<u32, _ISR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ISR;
    ///`read()` method returns [isr::R](isr::R) reader structure
    impl crate::Readable for ISR {}
    ///LTDC Interrupt Status Register
    pub mod isr {
        ///Reader of register ISR
        pub type R = crate::R<u32, super::ISR>;
        ///Reader of field `LIF`
        pub type LIF_R = crate::R<bool, bool>;
        ///Reader of field `FUIF`
        pub type FUIF_R = crate::R<bool, bool>;
        ///Reader of field `TERRIF`
        pub type TERRIF_R = crate::R<bool, bool>;
        ///Reader of field `RRIF`
        pub type RRIF_R = crate::R<bool, bool>;
        impl R {
            ///Bit 0 - Line Interrupt flag
            #[inline(always)]
            pub fn lif(&self) -> LIF_R {
                LIF_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - FIFO Underrun Interrupt flag
            #[inline(always)]
            pub fn fuif(&self) -> FUIF_R {
                FUIF_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 2 - Transfer Error interrupt flag
            #[inline(always)]
            pub fn terrif(&self) -> TERRIF_R {
                TERRIF_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 3 - Register Reload Interrupt Flag
            #[inline(always)]
            pub fn rrif(&self) -> RRIF_R {
                RRIF_R::new(((self.bits >> 3) & 0x01) != 0)
            }
        }
    }
    ///LTDC Interrupt Clear Register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [icr](icr) module
    pub type ICR = crate::Reg<u32, _ICR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ICR;
    ///`write(|w| ..)` method takes [icr::W](icr::W) writer structure
    impl crate::Writable for ICR {}
    ///LTDC Interrupt Clear Register
    pub mod icr {
        ///Writer for register ICR
        pub type W = crate::W<u32, super::ICR>;
        ///Register ICR `reset()`'s with value 0
        impl crate::ResetValue for super::ICR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `CLIF`
        pub struct CLIF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CLIF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Write proxy for field `CFUIF`
        pub struct CFUIF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFUIF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Write proxy for field `CTERRIF`
        pub struct CTERRIF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTERRIF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Write proxy for field `CRRIF`
        pub struct CRRIF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CRRIF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        impl W {
            ///Bit 0 - Clears the Line Interrupt Flag
            #[inline(always)]
            pub fn clif(&mut self) -> CLIF_W {
                CLIF_W { w: self }
            }
            ///Bit 1 - Clears the FIFO Underrun Interrupt flag
            #[inline(always)]
            pub fn cfuif(&mut self) -> CFUIF_W {
                CFUIF_W { w: self }
            }
            ///Bit 2 - Clears the Transfer Error Interrupt Flag
            #[inline(always)]
            pub fn cterrif(&mut self) -> CTERRIF_W {
                CTERRIF_W { w: self }
            }
            ///Bit 3 - Clears Register Reload Interrupt Flag
            #[inline(always)]
            pub fn crrif(&mut self) -> CRRIF_W {
                CRRIF_W { w: self }
            }
        }
    }
    ///LTDC Line Interrupt Position Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [lipcr](lipcr) module
    pub type LIPCR = crate::Reg<u32, _LIPCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _LIPCR;
    ///`read()` method returns [lipcr::R](lipcr::R) reader structure
    impl crate::Readable for LIPCR {}
    ///`write(|w| ..)` method takes [lipcr::W](lipcr::W) writer structure
    impl crate::Writable for LIPCR {}
    ///LTDC Line Interrupt Position Configuration Register
    pub mod lipcr {
        ///Reader of register LIPCR
        pub type R = crate::R<u32, super::LIPCR>;
        ///Writer for register LIPCR
        pub type W = crate::W<u32, super::LIPCR>;
        ///Register LIPCR `reset()`'s with value 0
        impl crate::ResetValue for super::LIPCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `LIPOS`
        pub type LIPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `LIPOS`
        pub struct LIPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LIPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Line Interrupt Position
            #[inline(always)]
            pub fn lipos(&self) -> LIPOS_R {
                LIPOS_R::new((self.bits & 0x07ff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Line Interrupt Position
            #[inline(always)]
            pub fn lipos(&mut self) -> LIPOS_W {
                LIPOS_W { w: self }
            }
        }
    }
    ///LTDC Current Position Status Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cpsr](cpsr) module
    pub type CPSR = crate::Reg<u32, _CPSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CPSR;
    ///`read()` method returns [cpsr::R](cpsr::R) reader structure
    impl crate::Readable for CPSR {}
    ///LTDC Current Position Status Register
    pub mod cpsr {
        ///Reader of register CPSR
        pub type R = crate::R<u32, super::CPSR>;
        ///Reader of field `CYPOS`
        pub type CYPOS_R = crate::R<u16, u16>;
        ///Reader of field `CXPOS`
        pub type CXPOS_R = crate::R<u16, u16>;
        impl R {
            ///Bits 0:15 - Current Y Position
            #[inline(always)]
            pub fn cypos(&self) -> CYPOS_R {
                CYPOS_R::new((self.bits & 0xffff) as u16)
            }
            ///Bits 16:31 - Current X Position
            #[inline(always)]
            pub fn cxpos(&self) -> CXPOS_R {
                CXPOS_R::new(((self.bits >> 16) & 0xffff) as u16)
            }
        }
    }
    ///LTDC Current Display Status Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cdsr](cdsr) module
    pub type CDSR = crate::Reg<u32, _CDSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CDSR;
    ///`read()` method returns [cdsr::R](cdsr::R) reader structure
    impl crate::Readable for CDSR {}
    ///LTDC Current Display Status Register
    pub mod cdsr {
        ///Reader of register CDSR
        pub type R = crate::R<u32, super::CDSR>;
        ///Reader of field `VDES`
        pub type VDES_R = crate::R<bool, bool>;
        ///Reader of field `HDES`
        pub type HDES_R = crate::R<bool, bool>;
        ///Reader of field `VSYNCS`
        pub type VSYNCS_R = crate::R<bool, bool>;
        ///Reader of field `HSYNCS`
        pub type HSYNCS_R = crate::R<bool, bool>;
        impl R {
            ///Bit 0 - Vertical Data Enable display Status
            #[inline(always)]
            pub fn vdes(&self) -> VDES_R {
                VDES_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - Horizontal Data Enable display Status
            #[inline(always)]
            pub fn hdes(&self) -> HDES_R {
                HDES_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 2 - Vertical Synchronization display Status
            #[inline(always)]
            pub fn vsyncs(&self) -> VSYNCS_R {
                VSYNCS_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 3 - Horizontal Synchronization display Status
            #[inline(always)]
            pub fn hsyncs(&self) -> HSYNCS_R {
                HSYNCS_R::new(((self.bits >> 3) & 0x01) != 0)
            }
        }
    }
    ///LTDC Layer Control Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1cr](l1cr) module
    pub type L1CR = crate::Reg<u32, _L1CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1CR;
    ///`read()` method returns [l1cr::R](l1cr::R) reader structure
    impl crate::Readable for L1CR {}
    ///`write(|w| ..)` method takes [l1cr::W](l1cr::W) writer structure
    impl crate::Writable for L1CR {}
    ///LTDC Layer Control Register
    pub mod l1cr {
        ///Reader of register L1CR
        pub type R = crate::R<u32, super::L1CR>;
        ///Writer for register L1CR
        pub type W = crate::W<u32, super::L1CR>;
        ///Register L1CR `reset()`'s with value 0
        impl crate::ResetValue for super::L1CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `LEN`
        pub type LEN_R = crate::R<bool, bool>;
        ///Write proxy for field `LEN`
        pub struct LEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `COLKEN`
        pub type COLKEN_R = crate::R<bool, bool>;
        ///Write proxy for field `COLKEN`
        pub struct COLKEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COLKEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `CLUTEN`
        pub type CLUTEN_R = crate::R<bool, bool>;
        ///Write proxy for field `CLUTEN`
        pub struct CLUTEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CLUTEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        impl R {
            ///Bit 0 - Layer Enable
            #[inline(always)]
            pub fn len(&self) -> LEN_R {
                LEN_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - Color Keying Enable
            #[inline(always)]
            pub fn colken(&self) -> COLKEN_R {
                COLKEN_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 4 - Color Look-Up Table Enable
            #[inline(always)]
            pub fn cluten(&self) -> CLUTEN_R {
                CLUTEN_R::new(((self.bits >> 4) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 0 - Layer Enable
            #[inline(always)]
            pub fn len(&mut self) -> LEN_W {
                LEN_W { w: self }
            }
            ///Bit 1 - Color Keying Enable
            #[inline(always)]
            pub fn colken(&mut self) -> COLKEN_W {
                COLKEN_W { w: self }
            }
            ///Bit 4 - Color Look-Up Table Enable
            #[inline(always)]
            pub fn cluten(&mut self) -> CLUTEN_W {
                CLUTEN_W { w: self }
            }
        }
    }
    ///LTDC Layer Control Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2cr](l2cr) module
    pub type L2CR = crate::Reg<u32, _L2CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2CR;
    ///`read()` method returns [l2cr::R](l2cr::R) reader structure
    impl crate::Readable for L2CR {}
    ///`write(|w| ..)` method takes [l2cr::W](l2cr::W) writer structure
    impl crate::Writable for L2CR {}
    ///LTDC Layer Control Register
    pub mod l2cr {
        ///Reader of register L2CR
        pub type R = crate::R<u32, super::L2CR>;
        ///Writer for register L2CR
        pub type W = crate::W<u32, super::L2CR>;
        ///Register L2CR `reset()`'s with value 0
        impl crate::ResetValue for super::L2CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `LEN`
        pub type LEN_R = crate::R<bool, bool>;
        ///Write proxy for field `LEN`
        pub struct LEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `COLKEN`
        pub type COLKEN_R = crate::R<bool, bool>;
        ///Write proxy for field `COLKEN`
        pub struct COLKEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COLKEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `CLUTEN`
        pub type CLUTEN_R = crate::R<bool, bool>;
        ///Write proxy for field `CLUTEN`
        pub struct CLUTEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CLUTEN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        impl R {
            ///Bit 0 - Layer Enable
            #[inline(always)]
            pub fn len(&self) -> LEN_R {
                LEN_R::new((self.bits & 0x01) != 0)
            }
            ///Bit 1 - Color Keying Enable
            #[inline(always)]
            pub fn colken(&self) -> COLKEN_R {
                COLKEN_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 4 - Color Look-Up Table Enable
            #[inline(always)]
            pub fn cluten(&self) -> CLUTEN_R {
                CLUTEN_R::new(((self.bits >> 4) & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 0 - Layer Enable
            #[inline(always)]
            pub fn len(&mut self) -> LEN_W {
                LEN_W { w: self }
            }
            ///Bit 1 - Color Keying Enable
            #[inline(always)]
            pub fn colken(&mut self) -> COLKEN_W {
                COLKEN_W { w: self }
            }
            ///Bit 4 - Color Look-Up Table Enable
            #[inline(always)]
            pub fn cluten(&mut self) -> CLUTEN_W {
                CLUTEN_W { w: self }
            }
        }
    }
    ///LTDC Layer Window Horizontal Position Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1whpcr](l1whpcr) module
    pub type L1WHPCR = crate::Reg<u32, _L1WHPCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1WHPCR;
    ///`read()` method returns [l1whpcr::R](l1whpcr::R) reader structure
    impl crate::Readable for L1WHPCR {}
    ///`write(|w| ..)` method takes [l1whpcr::W](l1whpcr::W) writer structure
    impl crate::Writable for L1WHPCR {}
    ///LTDC Layer Window Horizontal Position Configuration Register
    pub mod l1whpcr {
        ///Reader of register L1WHPCR
        pub type R = crate::R<u32, super::L1WHPCR>;
        ///Writer for register L1WHPCR
        pub type W = crate::W<u32, super::L1WHPCR>;
        ///Register L1WHPCR `reset()`'s with value 0
        impl crate::ResetValue for super::L1WHPCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `WHSTPOS`
        pub type WHSTPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `WHSTPOS`
        pub struct WHSTPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WHSTPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        ///Reader of field `WHSPPOS`
        pub type WHSPPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `WHSPPOS`
        pub struct WHSPPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WHSPPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 16)) | (((value as u32) & 0x0fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - Window Horizontal Start Position
            #[inline(always)]
            pub fn whstpos(&self) -> WHSTPOS_R {
                WHSTPOS_R::new((self.bits & 0x0fff) as u16)
            }
            ///Bits 16:27 - Window Horizontal Stop Position
            #[inline(always)]
            pub fn whsppos(&self) -> WHSPPOS_R {
                WHSPPOS_R::new(((self.bits >> 16) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - Window Horizontal Start Position
            #[inline(always)]
            pub fn whstpos(&mut self) -> WHSTPOS_W {
                WHSTPOS_W { w: self }
            }
            ///Bits 16:27 - Window Horizontal Stop Position
            #[inline(always)]
            pub fn whsppos(&mut self) -> WHSPPOS_W {
                WHSPPOS_W { w: self }
            }
        }
    }
    ///LTDC Layerx Window Horizontal Position Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2whpcr](l2whpcr) module
    pub type L2WHPCR = crate::Reg<u32, _L2WHPCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2WHPCR;
    ///`read()` method returns [l2whpcr::R](l2whpcr::R) reader structure
    impl crate::Readable for L2WHPCR {}
    ///`write(|w| ..)` method takes [l2whpcr::W](l2whpcr::W) writer structure
    impl crate::Writable for L2WHPCR {}
    ///LTDC Layerx Window Horizontal Position Configuration Register
    pub mod l2whpcr {
        ///Reader of register L2WHPCR
        pub type R = crate::R<u32, super::L2WHPCR>;
        ///Writer for register L2WHPCR
        pub type W = crate::W<u32, super::L2WHPCR>;
        ///Register L2WHPCR `reset()`'s with value 0
        impl crate::ResetValue for super::L2WHPCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `WHSTPOS`
        pub type WHSTPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `WHSTPOS`
        pub struct WHSTPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WHSTPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        ///Reader of field `WHSPPOS`
        pub type WHSPPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `WHSPPOS`
        pub struct WHSPPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WHSPPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0fff << 16)) | (((value as u32) & 0x0fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - Window Horizontal Start Position
            #[inline(always)]
            pub fn whstpos(&self) -> WHSTPOS_R {
                WHSTPOS_R::new((self.bits & 0x0fff) as u16)
            }
            ///Bits 16:27 - Window Horizontal Stop Position
            #[inline(always)]
            pub fn whsppos(&self) -> WHSPPOS_R {
                WHSPPOS_R::new(((self.bits >> 16) & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - Window Horizontal Start Position
            #[inline(always)]
            pub fn whstpos(&mut self) -> WHSTPOS_W {
                WHSTPOS_W { w: self }
            }
            ///Bits 16:27 - Window Horizontal Stop Position
            #[inline(always)]
            pub fn whsppos(&mut self) -> WHSPPOS_W {
                WHSPPOS_W { w: self }
            }
        }
    }
    ///LTDC Layer Window Vertical Position Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1wvpcr](l1wvpcr) module
    pub type L1WVPCR = crate::Reg<u32, _L1WVPCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1WVPCR;
    ///`read()` method returns [l1wvpcr::R](l1wvpcr::R) reader structure
    impl crate::Readable for L1WVPCR {}
    ///`write(|w| ..)` method takes [l1wvpcr::W](l1wvpcr::W) writer structure
    impl crate::Writable for L1WVPCR {}
    ///LTDC Layer Window Vertical Position Configuration Register
    pub mod l1wvpcr {
        ///Reader of register L1WVPCR
        pub type R = crate::R<u32, super::L1WVPCR>;
        ///Writer for register L1WVPCR
        pub type W = crate::W<u32, super::L1WVPCR>;
        ///Register L1WVPCR `reset()`'s with value 0
        impl crate::ResetValue for super::L1WVPCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `WVSTPOS`
        pub type WVSTPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `WVSTPOS`
        pub struct WVSTPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WVSTPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        ///Reader of field `WVSPPOS`
        pub type WVSPPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `WVSPPOS`
        pub struct WVSPPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WVSPPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07ff << 16)) | (((value as u32) & 0x07ff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Window Vertical Start Position
            #[inline(always)]
            pub fn wvstpos(&self) -> WVSTPOS_R {
                WVSTPOS_R::new((self.bits & 0x07ff) as u16)
            }
            ///Bits 16:26 - Window Vertical Stop Position
            #[inline(always)]
            pub fn wvsppos(&self) -> WVSPPOS_R {
                WVSPPOS_R::new(((self.bits >> 16) & 0x07ff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Window Vertical Start Position
            #[inline(always)]
            pub fn wvstpos(&mut self) -> WVSTPOS_W {
                WVSTPOS_W { w: self }
            }
            ///Bits 16:26 - Window Vertical Stop Position
            #[inline(always)]
            pub fn wvsppos(&mut self) -> WVSPPOS_W {
                WVSPPOS_W { w: self }
            }
        }
    }
    ///LTDC Layer Window Vertical Position Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2wvpcr](l2wvpcr) module
    pub type L2WVPCR = crate::Reg<u32, _L2WVPCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2WVPCR;
    ///`read()` method returns [l2wvpcr::R](l2wvpcr::R) reader structure
    impl crate::Readable for L2WVPCR {}
    ///`write(|w| ..)` method takes [l2wvpcr::W](l2wvpcr::W) writer structure
    impl crate::Writable for L2WVPCR {}
    ///LTDC Layer Window Vertical Position Configuration Register
    pub mod l2wvpcr {
        ///Reader of register L2WVPCR
        pub type R = crate::R<u32, super::L2WVPCR>;
        ///Writer for register L2WVPCR
        pub type W = crate::W<u32, super::L2WVPCR>;
        ///Register L2WVPCR `reset()`'s with value 0
        impl crate::ResetValue for super::L2WVPCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `WVSTPOS`
        pub type WVSTPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `WVSTPOS`
        pub struct WVSTPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WVSTPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        ///Reader of field `WVSPPOS`
        pub type WVSPPOS_R = crate::R<u16, u16>;
        ///Write proxy for field `WVSPPOS`
        pub struct WVSPPOS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WVSPPOS_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07ff << 16)) | (((value as u32) & 0x07ff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Window Vertical Start Position
            #[inline(always)]
            pub fn wvstpos(&self) -> WVSTPOS_R {
                WVSTPOS_R::new((self.bits & 0x07ff) as u16)
            }
            ///Bits 16:26 - Window Vertical Stop Position
            #[inline(always)]
            pub fn wvsppos(&self) -> WVSPPOS_R {
                WVSPPOS_R::new(((self.bits >> 16) & 0x07ff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Window Vertical Start Position
            #[inline(always)]
            pub fn wvstpos(&mut self) -> WVSTPOS_W {
                WVSTPOS_W { w: self }
            }
            ///Bits 16:26 - Window Vertical Stop Position
            #[inline(always)]
            pub fn wvsppos(&mut self) -> WVSPPOS_W {
                WVSPPOS_W { w: self }
            }
        }
    }
    ///LTDC Layer Color Keying Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1ckcr](l1ckcr) module
    pub type L1CKCR = crate::Reg<u32, _L1CKCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1CKCR;
    ///`read()` method returns [l1ckcr::R](l1ckcr::R) reader structure
    impl crate::Readable for L1CKCR {}
    ///`write(|w| ..)` method takes [l1ckcr::W](l1ckcr::W) writer structure
    impl crate::Writable for L1CKCR {}
    ///LTDC Layer Color Keying Configuration Register
    pub mod l1ckcr {
        ///Reader of register L1CKCR
        pub type R = crate::R<u32, super::L1CKCR>;
        ///Writer for register L1CKCR
        pub type W = crate::W<u32, super::L1CKCR>;
        ///Register L1CKCR `reset()`'s with value 0
        impl crate::ResetValue for super::L1CKCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CKBLUE`
        pub type CKBLUE_R = crate::R<u8, u8>;
        ///Write proxy for field `CKBLUE`
        pub struct CKBLUE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CKBLUE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `CKGREEN`
        pub type CKGREEN_R = crate::R<u8, u8>;
        ///Write proxy for field `CKGREEN`
        pub struct CKGREEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CKGREEN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        ///Reader of field `CKRED`
        pub type CKRED_R = crate::R<u8, u8>;
        ///Write proxy for field `CKRED`
        pub struct CKRED_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CKRED_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Color Key Blue value
            #[inline(always)]
            pub fn ckblue(&self) -> CKBLUE_R {
                CKBLUE_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 8:15 - Color Key Green value
            #[inline(always)]
            pub fn ckgreen(&self) -> CKGREEN_R {
                CKGREEN_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            ///Bits 16:23 - Color Key Red value
            #[inline(always)]
            pub fn ckred(&self) -> CKRED_R {
                CKRED_R::new(((self.bits >> 16) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Color Key Blue value
            #[inline(always)]
            pub fn ckblue(&mut self) -> CKBLUE_W {
                CKBLUE_W { w: self }
            }
            ///Bits 8:15 - Color Key Green value
            #[inline(always)]
            pub fn ckgreen(&mut self) -> CKGREEN_W {
                CKGREEN_W { w: self }
            }
            ///Bits 16:23 - Color Key Red value
            #[inline(always)]
            pub fn ckred(&mut self) -> CKRED_W {
                CKRED_W { w: self }
            }
        }
    }
    ///LTDC Layer Color Keying Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2ckcr](l2ckcr) module
    pub type L2CKCR = crate::Reg<u32, _L2CKCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2CKCR;
    ///`read()` method returns [l2ckcr::R](l2ckcr::R) reader structure
    impl crate::Readable for L2CKCR {}
    ///`write(|w| ..)` method takes [l2ckcr::W](l2ckcr::W) writer structure
    impl crate::Writable for L2CKCR {}
    ///LTDC Layer Color Keying Configuration Register
    pub mod l2ckcr {
        ///Reader of register L2CKCR
        pub type R = crate::R<u32, super::L2CKCR>;
        ///Writer for register L2CKCR
        pub type W = crate::W<u32, super::L2CKCR>;
        ///Register L2CKCR `reset()`'s with value 0
        impl crate::ResetValue for super::L2CKCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CKBLUE`
        pub type CKBLUE_R = crate::R<u8, u8>;
        ///Write proxy for field `CKBLUE`
        pub struct CKBLUE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CKBLUE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `CKGREEN`
        pub type CKGREEN_R = crate::R<u8, u8>;
        ///Write proxy for field `CKGREEN`
        pub struct CKGREEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CKGREEN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        ///Reader of field `CKRED`
        pub type CKRED_R = crate::R<u8, u8>;
        ///Write proxy for field `CKRED`
        pub struct CKRED_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CKRED_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Color Key Blue value
            #[inline(always)]
            pub fn ckblue(&self) -> CKBLUE_R {
                CKBLUE_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 8:15 - Color Key Green value
            #[inline(always)]
            pub fn ckgreen(&self) -> CKGREEN_R {
                CKGREEN_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            ///Bits 16:23 - Color Key Red value
            #[inline(always)]
            pub fn ckred(&self) -> CKRED_R {
                CKRED_R::new(((self.bits >> 16) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Color Key Blue value
            #[inline(always)]
            pub fn ckblue(&mut self) -> CKBLUE_W {
                CKBLUE_W { w: self }
            }
            ///Bits 8:15 - Color Key Green value
            #[inline(always)]
            pub fn ckgreen(&mut self) -> CKGREEN_W {
                CKGREEN_W { w: self }
            }
            ///Bits 16:23 - Color Key Red value
            #[inline(always)]
            pub fn ckred(&mut self) -> CKRED_W {
                CKRED_W { w: self }
            }
        }
    }
    ///LTDC Layer Pixel Format Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1pfcr](l1pfcr) module
    pub type L1PFCR = crate::Reg<u32, _L1PFCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1PFCR;
    ///`read()` method returns [l1pfcr::R](l1pfcr::R) reader structure
    impl crate::Readable for L1PFCR {}
    ///`write(|w| ..)` method takes [l1pfcr::W](l1pfcr::W) writer structure
    impl crate::Writable for L1PFCR {}
    ///LTDC Layer Pixel Format Configuration Register
    pub mod l1pfcr {
        ///Reader of register L1PFCR
        pub type R = crate::R<u32, super::L1PFCR>;
        ///Writer for register L1PFCR
        pub type W = crate::W<u32, super::L1PFCR>;
        ///Register L1PFCR `reset()`'s with value 0
        impl crate::ResetValue for super::L1PFCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PF`
        pub type PF_R = crate::R<u8, u8>;
        ///Write proxy for field `PF`
        pub struct PF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PF_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07) | ((value as u32) & 0x07);
                self.w
            }
        }
        impl R {
            ///Bits 0:2 - Pixel Format
            #[inline(always)]
            pub fn pf(&self) -> PF_R {
                PF_R::new((self.bits & 0x07) as u8)
            }
        }
        impl W {
            ///Bits 0:2 - Pixel Format
            #[inline(always)]
            pub fn pf(&mut self) -> PF_W {
                PF_W { w: self }
            }
        }
    }
    ///LTDC Layer Pixel Format Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2pfcr](l2pfcr) module
    pub type L2PFCR = crate::Reg<u32, _L2PFCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2PFCR;
    ///`read()` method returns [l2pfcr::R](l2pfcr::R) reader structure
    impl crate::Readable for L2PFCR {}
    ///`write(|w| ..)` method takes [l2pfcr::W](l2pfcr::W) writer structure
    impl crate::Writable for L2PFCR {}
    ///LTDC Layer Pixel Format Configuration Register
    pub mod l2pfcr {
        ///Reader of register L2PFCR
        pub type R = crate::R<u32, super::L2PFCR>;
        ///Writer for register L2PFCR
        pub type W = crate::W<u32, super::L2PFCR>;
        ///Register L2PFCR `reset()`'s with value 0
        impl crate::ResetValue for super::L2PFCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `PF`
        pub type PF_R = crate::R<u8, u8>;
        ///Write proxy for field `PF`
        pub struct PF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PF_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07) | ((value as u32) & 0x07);
                self.w
            }
        }
        impl R {
            ///Bits 0:2 - Pixel Format
            #[inline(always)]
            pub fn pf(&self) -> PF_R {
                PF_R::new((self.bits & 0x07) as u8)
            }
        }
        impl W {
            ///Bits 0:2 - Pixel Format
            #[inline(always)]
            pub fn pf(&mut self) -> PF_W {
                PF_W { w: self }
            }
        }
    }
    ///LTDC Layer Constant Alpha Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1cacr](l1cacr) module
    pub type L1CACR = crate::Reg<u32, _L1CACR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1CACR;
    ///`read()` method returns [l1cacr::R](l1cacr::R) reader structure
    impl crate::Readable for L1CACR {}
    ///`write(|w| ..)` method takes [l1cacr::W](l1cacr::W) writer structure
    impl crate::Writable for L1CACR {}
    ///LTDC Layer Constant Alpha Configuration Register
    pub mod l1cacr {
        ///Reader of register L1CACR
        pub type R = crate::R<u32, super::L1CACR>;
        ///Writer for register L1CACR
        pub type W = crate::W<u32, super::L1CACR>;
        ///Register L1CACR `reset()`'s with value 0
        impl crate::ResetValue for super::L1CACR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CONSTA`
        pub type CONSTA_R = crate::R<u8, u8>;
        ///Write proxy for field `CONSTA`
        pub struct CONSTA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CONSTA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Constant Alpha
            #[inline(always)]
            pub fn consta(&self) -> CONSTA_R {
                CONSTA_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Constant Alpha
            #[inline(always)]
            pub fn consta(&mut self) -> CONSTA_W {
                CONSTA_W { w: self }
            }
        }
    }
    ///LTDC Layer Constant Alpha Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2cacr](l2cacr) module
    pub type L2CACR = crate::Reg<u32, _L2CACR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2CACR;
    ///`read()` method returns [l2cacr::R](l2cacr::R) reader structure
    impl crate::Readable for L2CACR {}
    ///`write(|w| ..)` method takes [l2cacr::W](l2cacr::W) writer structure
    impl crate::Writable for L2CACR {}
    ///LTDC Layer Constant Alpha Configuration Register
    pub mod l2cacr {
        ///Reader of register L2CACR
        pub type R = crate::R<u32, super::L2CACR>;
        ///Writer for register L2CACR
        pub type W = crate::W<u32, super::L2CACR>;
        ///Register L2CACR `reset()`'s with value 0
        impl crate::ResetValue for super::L2CACR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CONSTA`
        pub type CONSTA_R = crate::R<u8, u8>;
        ///Write proxy for field `CONSTA`
        pub struct CONSTA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CONSTA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Constant Alpha
            #[inline(always)]
            pub fn consta(&self) -> CONSTA_R {
                CONSTA_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Constant Alpha
            #[inline(always)]
            pub fn consta(&mut self) -> CONSTA_W {
                CONSTA_W { w: self }
            }
        }
    }
    ///LTDC Layer Default Color Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1dccr](l1dccr) module
    pub type L1DCCR = crate::Reg<u32, _L1DCCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1DCCR;
    ///`read()` method returns [l1dccr::R](l1dccr::R) reader structure
    impl crate::Readable for L1DCCR {}
    ///`write(|w| ..)` method takes [l1dccr::W](l1dccr::W) writer structure
    impl crate::Writable for L1DCCR {}
    ///LTDC Layer Default Color Configuration Register
    pub mod l1dccr {
        ///Reader of register L1DCCR
        pub type R = crate::R<u32, super::L1DCCR>;
        ///Writer for register L1DCCR
        pub type W = crate::W<u32, super::L1DCCR>;
        ///Register L1DCCR `reset()`'s with value 0
        impl crate::ResetValue for super::L1DCCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DCBLUE`
        pub type DCBLUE_R = crate::R<u8, u8>;
        ///Write proxy for field `DCBLUE`
        pub struct DCBLUE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DCBLUE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `DCGREEN`
        pub type DCGREEN_R = crate::R<u8, u8>;
        ///Write proxy for field `DCGREEN`
        pub struct DCGREEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DCGREEN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        ///Reader of field `DCRED`
        pub type DCRED_R = crate::R<u8, u8>;
        ///Write proxy for field `DCRED`
        pub struct DCRED_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DCRED_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        ///Reader of field `DCALPHA`
        pub type DCALPHA_R = crate::R<u8, u8>;
        ///Write proxy for field `DCALPHA`
        pub struct DCALPHA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DCALPHA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | (((value as u32) & 0xff) << 24);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Default Color Blue
            #[inline(always)]
            pub fn dcblue(&self) -> DCBLUE_R {
                DCBLUE_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 8:15 - Default Color Green
            #[inline(always)]
            pub fn dcgreen(&self) -> DCGREEN_R {
                DCGREEN_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            ///Bits 16:23 - Default Color Red
            #[inline(always)]
            pub fn dcred(&self) -> DCRED_R {
                DCRED_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            ///Bits 24:31 - Default Color Alpha
            #[inline(always)]
            pub fn dcalpha(&self) -> DCALPHA_R {
                DCALPHA_R::new(((self.bits >> 24) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Default Color Blue
            #[inline(always)]
            pub fn dcblue(&mut self) -> DCBLUE_W {
                DCBLUE_W { w: self }
            }
            ///Bits 8:15 - Default Color Green
            #[inline(always)]
            pub fn dcgreen(&mut self) -> DCGREEN_W {
                DCGREEN_W { w: self }
            }
            ///Bits 16:23 - Default Color Red
            #[inline(always)]
            pub fn dcred(&mut self) -> DCRED_W {
                DCRED_W { w: self }
            }
            ///Bits 24:31 - Default Color Alpha
            #[inline(always)]
            pub fn dcalpha(&mut self) -> DCALPHA_W {
                DCALPHA_W { w: self }
            }
        }
    }
    ///LTDC Layer Default Color Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2dccr](l2dccr) module
    pub type L2DCCR = crate::Reg<u32, _L2DCCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2DCCR;
    ///`read()` method returns [l2dccr::R](l2dccr::R) reader structure
    impl crate::Readable for L2DCCR {}
    ///`write(|w| ..)` method takes [l2dccr::W](l2dccr::W) writer structure
    impl crate::Writable for L2DCCR {}
    ///LTDC Layer Default Color Configuration Register
    pub mod l2dccr {
        ///Reader of register L2DCCR
        pub type R = crate::R<u32, super::L2DCCR>;
        ///Writer for register L2DCCR
        pub type W = crate::W<u32, super::L2DCCR>;
        ///Register L2DCCR `reset()`'s with value 0
        impl crate::ResetValue for super::L2DCCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `DCBLUE`
        pub type DCBLUE_R = crate::R<u8, u8>;
        ///Write proxy for field `DCBLUE`
        pub struct DCBLUE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DCBLUE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Reader of field `DCGREEN`
        pub type DCGREEN_R = crate::R<u8, u8>;
        ///Write proxy for field `DCGREEN`
        pub struct DCGREEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DCGREEN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        ///Reader of field `DCRED`
        pub type DCRED_R = crate::R<u8, u8>;
        ///Write proxy for field `DCRED`
        pub struct DCRED_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DCRED_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        ///Reader of field `DCALPHA`
        pub type DCALPHA_R = crate::R<u8, u8>;
        ///Write proxy for field `DCALPHA`
        pub struct DCALPHA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DCALPHA_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | (((value as u32) & 0xff) << 24);
                self.w
            }
        }
        impl R {
            ///Bits 0:7 - Default Color Blue
            #[inline(always)]
            pub fn dcblue(&self) -> DCBLUE_R {
                DCBLUE_R::new((self.bits & 0xff) as u8)
            }
            ///Bits 8:15 - Default Color Green
            #[inline(always)]
            pub fn dcgreen(&self) -> DCGREEN_R {
                DCGREEN_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            ///Bits 16:23 - Default Color Red
            #[inline(always)]
            pub fn dcred(&self) -> DCRED_R {
                DCRED_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            ///Bits 24:31 - Default Color Alpha
            #[inline(always)]
            pub fn dcalpha(&self) -> DCALPHA_R {
                DCALPHA_R::new(((self.bits >> 24) & 0xff) as u8)
            }
        }
        impl W {
            ///Bits 0:7 - Default Color Blue
            #[inline(always)]
            pub fn dcblue(&mut self) -> DCBLUE_W {
                DCBLUE_W { w: self }
            }
            ///Bits 8:15 - Default Color Green
            #[inline(always)]
            pub fn dcgreen(&mut self) -> DCGREEN_W {
                DCGREEN_W { w: self }
            }
            ///Bits 16:23 - Default Color Red
            #[inline(always)]
            pub fn dcred(&mut self) -> DCRED_W {
                DCRED_W { w: self }
            }
            ///Bits 24:31 - Default Color Alpha
            #[inline(always)]
            pub fn dcalpha(&mut self) -> DCALPHA_W {
                DCALPHA_W { w: self }
            }
        }
    }
    ///LTDC Layer Blending Factors Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1bfcr](l1bfcr) module
    pub type L1BFCR = crate::Reg<u32, _L1BFCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1BFCR;
    ///`read()` method returns [l1bfcr::R](l1bfcr::R) reader structure
    impl crate::Readable for L1BFCR {}
    ///`write(|w| ..)` method takes [l1bfcr::W](l1bfcr::W) writer structure
    impl crate::Writable for L1BFCR {}
    ///LTDC Layer Blending Factors Configuration Register
    pub mod l1bfcr {
        ///Reader of register L1BFCR
        pub type R = crate::R<u32, super::L1BFCR>;
        ///Writer for register L1BFCR
        pub type W = crate::W<u32, super::L1BFCR>;
        ///Register L1BFCR `reset()`'s with value 0
        impl crate::ResetValue for super::L1BFCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `BF2`
        pub type BF2_R = crate::R<u8, u8>;
        ///Write proxy for field `BF2`
        pub struct BF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BF2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07) | ((value as u32) & 0x07);
                self.w
            }
        }
        ///Reader of field `BF1`
        pub type BF1_R = crate::R<u8, u8>;
        ///Write proxy for field `BF1`
        pub struct BF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BF1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 8)) | (((value as u32) & 0x07) << 8);
                self.w
            }
        }
        impl R {
            ///Bits 0:2 - Blending Factor 2
            #[inline(always)]
            pub fn bf2(&self) -> BF2_R {
                BF2_R::new((self.bits & 0x07) as u8)
            }
            ///Bits 8:10 - Blending Factor 1
            #[inline(always)]
            pub fn bf1(&self) -> BF1_R {
                BF1_R::new(((self.bits >> 8) & 0x07) as u8)
            }
        }
        impl W {
            ///Bits 0:2 - Blending Factor 2
            #[inline(always)]
            pub fn bf2(&mut self) -> BF2_W {
                BF2_W { w: self }
            }
            ///Bits 8:10 - Blending Factor 1
            #[inline(always)]
            pub fn bf1(&mut self) -> BF1_W {
                BF1_W { w: self }
            }
        }
    }
    ///LTDC Layer Blending Factors Configuration Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2bfcr](l2bfcr) module
    pub type L2BFCR = crate::Reg<u32, _L2BFCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2BFCR;
    ///`read()` method returns [l2bfcr::R](l2bfcr::R) reader structure
    impl crate::Readable for L2BFCR {}
    ///`write(|w| ..)` method takes [l2bfcr::W](l2bfcr::W) writer structure
    impl crate::Writable for L2BFCR {}
    ///LTDC Layer Blending Factors Configuration Register
    pub mod l2bfcr {
        ///Reader of register L2BFCR
        pub type R = crate::R<u32, super::L2BFCR>;
        ///Writer for register L2BFCR
        pub type W = crate::W<u32, super::L2BFCR>;
        ///Register L2BFCR `reset()`'s with value 0
        impl crate::ResetValue for super::L2BFCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `BF2`
        pub type BF2_R = crate::R<u8, u8>;
        ///Write proxy for field `BF2`
        pub struct BF2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BF2_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07) | ((value as u32) & 0x07);
                self.w
            }
        }
        ///Reader of field `BF1`
        pub type BF1_R = crate::R<u8, u8>;
        ///Write proxy for field `BF1`
        pub struct BF1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BF1_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 8)) | (((value as u32) & 0x07) << 8);
                self.w
            }
        }
        impl R {
            ///Bits 0:2 - Blending Factor 2
            #[inline(always)]
            pub fn bf2(&self) -> BF2_R {
                BF2_R::new((self.bits & 0x07) as u8)
            }
            ///Bits 8:10 - Blending Factor 1
            #[inline(always)]
            pub fn bf1(&self) -> BF1_R {
                BF1_R::new(((self.bits >> 8) & 0x07) as u8)
            }
        }
        impl W {
            ///Bits 0:2 - Blending Factor 2
            #[inline(always)]
            pub fn bf2(&mut self) -> BF2_W {
                BF2_W { w: self }
            }
            ///Bits 8:10 - Blending Factor 1
            #[inline(always)]
            pub fn bf1(&mut self) -> BF1_W {
                BF1_W { w: self }
            }
        }
    }
    ///LTDC Layer Color Frame Buffer Address Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1cfbar](l1cfbar) module
    pub type L1CFBAR = crate::Reg<u32, _L1CFBAR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1CFBAR;
    ///`read()` method returns [l1cfbar::R](l1cfbar::R) reader structure
    impl crate::Readable for L1CFBAR {}
    ///`write(|w| ..)` method takes [l1cfbar::W](l1cfbar::W) writer structure
    impl crate::Writable for L1CFBAR {}
    ///LTDC Layer Color Frame Buffer Address Register
    pub mod l1cfbar {
        ///Reader of register L1CFBAR
        pub type R = crate::R<u32, super::L1CFBAR>;
        ///Writer for register L1CFBAR
        pub type W = crate::W<u32, super::L1CFBAR>;
        ///Register L1CFBAR `reset()`'s with value 0
        impl crate::ResetValue for super::L1CFBAR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CFBADD`
        pub type CFBADD_R = crate::R<u32, u32>;
        ///Write proxy for field `CFBADD`
        pub struct CFBADD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFBADD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Color Frame Buffer Start Address
            #[inline(always)]
            pub fn cfbadd(&self) -> CFBADD_R {
                CFBADD_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Color Frame Buffer Start Address
            #[inline(always)]
            pub fn cfbadd(&mut self) -> CFBADD_W {
                CFBADD_W { w: self }
            }
        }
    }
    ///LTDC Layer Color Frame Buffer Address Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2cfbar](l2cfbar) module
    pub type L2CFBAR = crate::Reg<u32, _L2CFBAR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2CFBAR;
    ///`read()` method returns [l2cfbar::R](l2cfbar::R) reader structure
    impl crate::Readable for L2CFBAR {}
    ///`write(|w| ..)` method takes [l2cfbar::W](l2cfbar::W) writer structure
    impl crate::Writable for L2CFBAR {}
    ///LTDC Layer Color Frame Buffer Address Register
    pub mod l2cfbar {
        ///Reader of register L2CFBAR
        pub type R = crate::R<u32, super::L2CFBAR>;
        ///Writer for register L2CFBAR
        pub type W = crate::W<u32, super::L2CFBAR>;
        ///Register L2CFBAR `reset()`'s with value 0
        impl crate::ResetValue for super::L2CFBAR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CFBADD`
        pub type CFBADD_R = crate::R<u32, u32>;
        ///Write proxy for field `CFBADD`
        pub struct CFBADD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFBADD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
                self.w
            }
        }
        impl R {
            ///Bits 0:31 - Color Frame Buffer Start Address
            #[inline(always)]
            pub fn cfbadd(&self) -> CFBADD_R {
                CFBADD_R::new((self.bits & 0xffff_ffff) as u32)
            }
        }
        impl W {
            ///Bits 0:31 - Color Frame Buffer Start Address
            #[inline(always)]
            pub fn cfbadd(&mut self) -> CFBADD_W {
                CFBADD_W { w: self }
            }
        }
    }
    ///LTDC Layer Color Frame Buffer Length Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1cfblr](l1cfblr) module
    pub type L1CFBLR = crate::Reg<u32, _L1CFBLR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1CFBLR;
    ///`read()` method returns [l1cfblr::R](l1cfblr::R) reader structure
    impl crate::Readable for L1CFBLR {}
    ///`write(|w| ..)` method takes [l1cfblr::W](l1cfblr::W) writer structure
    impl crate::Writable for L1CFBLR {}
    ///LTDC Layer Color Frame Buffer Length Register
    pub mod l1cfblr {
        ///Reader of register L1CFBLR
        pub type R = crate::R<u32, super::L1CFBLR>;
        ///Writer for register L1CFBLR
        pub type W = crate::W<u32, super::L1CFBLR>;
        ///Register L1CFBLR `reset()`'s with value 0
        impl crate::ResetValue for super::L1CFBLR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CFBLL`
        pub type CFBLL_R = crate::R<u16, u16>;
        ///Write proxy for field `CFBLL`
        pub struct CFBLL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFBLL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1fff) | ((value as u32) & 0x1fff);
                self.w
            }
        }
        ///Reader of field `CFBP`
        pub type CFBP_R = crate::R<u16, u16>;
        ///Write proxy for field `CFBP`
        pub struct CFBP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFBP_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1fff << 16)) | (((value as u32) & 0x1fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:12 - Color Frame Buffer Line Length
            #[inline(always)]
            pub fn cfbll(&self) -> CFBLL_R {
                CFBLL_R::new((self.bits & 0x1fff) as u16)
            }
            ///Bits 16:28 - Color Frame Buffer Pitch in bytes
            #[inline(always)]
            pub fn cfbp(&self) -> CFBP_R {
                CFBP_R::new(((self.bits >> 16) & 0x1fff) as u16)
            }
        }
        impl W {
            ///Bits 0:12 - Color Frame Buffer Line Length
            #[inline(always)]
            pub fn cfbll(&mut self) -> CFBLL_W {
                CFBLL_W { w: self }
            }
            ///Bits 16:28 - Color Frame Buffer Pitch in bytes
            #[inline(always)]
            pub fn cfbp(&mut self) -> CFBP_W {
                CFBP_W { w: self }
            }
        }
    }
    ///LTDC Layer Color Frame Buffer Length Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2cfblr](l2cfblr) module
    pub type L2CFBLR = crate::Reg<u32, _L2CFBLR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2CFBLR;
    ///`read()` method returns [l2cfblr::R](l2cfblr::R) reader structure
    impl crate::Readable for L2CFBLR {}
    ///`write(|w| ..)` method takes [l2cfblr::W](l2cfblr::W) writer structure
    impl crate::Writable for L2CFBLR {}
    ///LTDC Layer Color Frame Buffer Length Register
    pub mod l2cfblr {
        ///Reader of register L2CFBLR
        pub type R = crate::R<u32, super::L2CFBLR>;
        ///Writer for register L2CFBLR
        pub type W = crate::W<u32, super::L2CFBLR>;
        ///Register L2CFBLR `reset()`'s with value 0
        impl crate::ResetValue for super::L2CFBLR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CFBLL`
        pub type CFBLL_R = crate::R<u16, u16>;
        ///Write proxy for field `CFBLL`
        pub struct CFBLL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFBLL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x1fff) | ((value as u32) & 0x1fff);
                self.w
            }
        }
        ///Reader of field `CFBP`
        pub type CFBP_R = crate::R<u16, u16>;
        ///Write proxy for field `CFBP`
        pub struct CFBP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFBP_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1fff << 16)) | (((value as u32) & 0x1fff) << 16);
                self.w
            }
        }
        impl R {
            ///Bits 0:12 - Color Frame Buffer Line Length
            #[inline(always)]
            pub fn cfbll(&self) -> CFBLL_R {
                CFBLL_R::new((self.bits & 0x1fff) as u16)
            }
            ///Bits 16:28 - Color Frame Buffer Pitch in bytes
            #[inline(always)]
            pub fn cfbp(&self) -> CFBP_R {
                CFBP_R::new(((self.bits >> 16) & 0x1fff) as u16)
            }
        }
        impl W {
            ///Bits 0:12 - Color Frame Buffer Line Length
            #[inline(always)]
            pub fn cfbll(&mut self) -> CFBLL_W {
                CFBLL_W { w: self }
            }
            ///Bits 16:28 - Color Frame Buffer Pitch in bytes
            #[inline(always)]
            pub fn cfbp(&mut self) -> CFBP_W {
                CFBP_W { w: self }
            }
        }
    }
    ///LTDC Layer ColorFrame Buffer Line Number Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1cfblnr](l1cfblnr) module
    pub type L1CFBLNR = crate::Reg<u32, _L1CFBLNR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1CFBLNR;
    ///`read()` method returns [l1cfblnr::R](l1cfblnr::R) reader structure
    impl crate::Readable for L1CFBLNR {}
    ///`write(|w| ..)` method takes [l1cfblnr::W](l1cfblnr::W) writer structure
    impl crate::Writable for L1CFBLNR {}
    ///LTDC Layer ColorFrame Buffer Line Number Register
    pub mod l1cfblnr {
        ///Reader of register L1CFBLNR
        pub type R = crate::R<u32, super::L1CFBLNR>;
        ///Writer for register L1CFBLNR
        pub type W = crate::W<u32, super::L1CFBLNR>;
        ///Register L1CFBLNR `reset()`'s with value 0
        impl crate::ResetValue for super::L1CFBLNR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CFBLNBR`
        pub type CFBLNBR_R = crate::R<u16, u16>;
        ///Write proxy for field `CFBLNBR`
        pub struct CFBLNBR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFBLNBR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Frame Buffer Line Number
            #[inline(always)]
            pub fn cfblnbr(&self) -> CFBLNBR_R {
                CFBLNBR_R::new((self.bits & 0x07ff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Frame Buffer Line Number
            #[inline(always)]
            pub fn cfblnbr(&mut self) -> CFBLNBR_W {
                CFBLNBR_W { w: self }
            }
        }
    }
    ///LTDC Layer ColorFrame Buffer Line Number Register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2cfblnr](l2cfblnr) module
    pub type L2CFBLNR = crate::Reg<u32, _L2CFBLNR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2CFBLNR;
    ///`read()` method returns [l2cfblnr::R](l2cfblnr::R) reader structure
    impl crate::Readable for L2CFBLNR {}
    ///`write(|w| ..)` method takes [l2cfblnr::W](l2cfblnr::W) writer structure
    impl crate::Writable for L2CFBLNR {}
    ///LTDC Layer ColorFrame Buffer Line Number Register
    pub mod l2cfblnr {
        ///Reader of register L2CFBLNR
        pub type R = crate::R<u32, super::L2CFBLNR>;
        ///Writer for register L2CFBLNR
        pub type W = crate::W<u32, super::L2CFBLNR>;
        ///Register L2CFBLNR `reset()`'s with value 0
        impl crate::ResetValue for super::L2CFBLNR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CFBLNBR`
        pub type CFBLNBR_R = crate::R<u16, u16>;
        ///Write proxy for field `CFBLNBR`
        pub struct CFBLNBR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CFBLNBR_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07ff) | ((value as u32) & 0x07ff);
                self.w
            }
        }
        impl R {
            ///Bits 0:10 - Frame Buffer Line Number
            #[inline(always)]
            pub fn cfblnbr(&self) -> CFBLNBR_R {
                CFBLNBR_R::new((self.bits & 0x07ff) as u16)
            }
        }
        impl W {
            ///Bits 0:10 - Frame Buffer Line Number
            #[inline(always)]
            pub fn cfblnbr(&mut self) -> CFBLNBR_W {
                CFBLNBR_W { w: self }
            }
        }
    }
    ///LTDC Layerx CLUT Write Register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l1clutwr](l1clutwr) module
    pub type L1CLUTWR = crate::Reg<u32, _L1CLUTWR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L1CLUTWR;
    ///`write(|w| ..)` method takes [l1clutwr::W](l1clutwr::W) writer structure
    impl crate::Writable for L1CLUTWR {}
    ///LTDC Layerx CLUT Write Register
    pub mod l1clutwr {
        ///Writer for register L1CLUTWR
        pub type W = crate::W<u32, super::L1CLUTWR>;
        ///Register L1CLUTWR `reset()`'s with value 0
        impl crate::ResetValue for super::L1CLUTWR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `BLUE`
        pub struct BLUE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BLUE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Write proxy for field `GREEN`
        pub struct GREEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GREEN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        ///Write proxy for field `RED`
        pub struct RED_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RED_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        ///Write proxy for field `CLUTADD`
        pub struct CLUTADD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CLUTADD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | (((value as u32) & 0xff) << 24);
                self.w
            }
        }
        impl W {
            ///Bits 0:7 - Blue value
            #[inline(always)]
            pub fn blue(&mut self) -> BLUE_W {
                BLUE_W { w: self }
            }
            ///Bits 8:15 - Green value
            #[inline(always)]
            pub fn green(&mut self) -> GREEN_W {
                GREEN_W { w: self }
            }
            ///Bits 16:23 - Red value
            #[inline(always)]
            pub fn red(&mut self) -> RED_W {
                RED_W { w: self }
            }
            ///Bits 24:31 - CLUT Address
            #[inline(always)]
            pub fn clutadd(&mut self) -> CLUTADD_W {
                CLUTADD_W { w: self }
            }
        }
    }
    ///LTDC Layerx CLUT Write Register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [l2clutwr](l2clutwr) module
    pub type L2CLUTWR = crate::Reg<u32, _L2CLUTWR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _L2CLUTWR;
    ///`write(|w| ..)` method takes [l2clutwr::W](l2clutwr::W) writer structure
    impl crate::Writable for L2CLUTWR {}
    ///LTDC Layerx CLUT Write Register
    pub mod l2clutwr {
        ///Writer for register L2CLUTWR
        pub type W = crate::W<u32, super::L2CLUTWR>;
        ///Register L2CLUTWR `reset()`'s with value 0
        impl crate::ResetValue for super::L2CLUTWR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Write proxy for field `BLUE`
        pub struct BLUE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BLUE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
                self.w
            }
        }
        ///Write proxy for field `GREEN`
        pub struct GREEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> GREEN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
                self.w
            }
        }
        ///Write proxy for field `RED`
        pub struct RED_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RED_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | (((value as u32) & 0xff) << 16);
                self.w
            }
        }
        ///Write proxy for field `CLUTADD`
        pub struct CLUTADD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CLUTADD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | (((value as u32) & 0xff) << 24);
                self.w
            }
        }
        impl W {
            ///Bits 0:7 - Blue value
            #[inline(always)]
            pub fn blue(&mut self) -> BLUE_W {
                BLUE_W { w: self }
            }
            ///Bits 8:15 - Green value
            #[inline(always)]
            pub fn green(&mut self) -> GREEN_W {
                GREEN_W { w: self }
            }
            ///Bits 16:23 - Red value
            #[inline(always)]
            pub fn red(&mut self) -> RED_W {
                RED_W { w: self }
            }
            ///Bits 24:31 - CLUT Address
            #[inline(always)]
            pub fn clutadd(&mut self) -> CLUTADD_W {
                CLUTADD_W { w: self }
            }
        }
    }
}
///Touch sensing controller
pub struct TSC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TSC {}
impl TSC {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const tsc::RegisterBlock {
        0x4002_4000 as *const _
    }
}
impl Deref for TSC {
    type Target = tsc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*TSC::ptr() }
    }
}
///Touch sensing controller
pub mod tsc {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - control register
        pub cr: CR,
        ///0x04 - interrupt enable register
        pub ier: IER,
        ///0x08 - interrupt clear register
        pub icr: ICR,
        ///0x0c - interrupt status register
        pub isr: ISR,
        ///0x10 - I/O hysteresis control register
        pub iohcr: IOHCR,
        _reserved5: [u8; 4usize],
        ///0x18 - I/O analog switch control register
        pub ioascr: IOASCR,
        _reserved6: [u8; 4usize],
        ///0x20 - I/O sampling control register
        pub ioscr: IOSCR,
        _reserved7: [u8; 4usize],
        ///0x28 - I/O channel control register
        pub ioccr: IOCCR,
        _reserved8: [u8; 4usize],
        ///0x30 - I/O group control status register
        pub iogcsr: IOGCSR,
        ///0x34 - I/O group x counter register
        pub iog1cr: IOGCR,
        ///0x38 - I/O group x counter register
        pub iog2cr: IOGCR,
        ///0x3c - I/O group x counter register
        pub iog3cr: IOGCR,
        ///0x40 - I/O group x counter register
        pub iog4cr: IOGCR,
        ///0x44 - I/O group x counter register
        pub iog5cr: IOGCR,
        ///0x48 - I/O group x counter register
        pub iog6cr: IOGCR,
        ///0x4c - I/O group x counter register
        pub iog7cr: IOGCR,
        ///0x50 - I/O group x counter register
        pub iog8cr: IOGCR,
    }
    ///control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `CTPH`
        pub type CTPH_R = crate::R<u8, u8>;
        ///Write proxy for field `CTPH`
        pub struct CTPH_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTPH_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 28)) | (((value as u32) & 0x0f) << 28);
                self.w
            }
        }
        ///Reader of field `CTPL`
        pub type CTPL_R = crate::R<u8, u8>;
        ///Write proxy for field `CTPL`
        pub struct CTPL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTPL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 24)) | (((value as u32) & 0x0f) << 24);
                self.w
            }
        }
        ///Reader of field `SSD`
        pub type SSD_R = crate::R<u8, u8>;
        ///Write proxy for field `SSD`
        pub struct SSD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSD_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x7f << 17)) | (((value as u32) & 0x7f) << 17);
                self.w
            }
        }
        ///Reader of field `SSE`
        pub type SSE_R = crate::R<bool, bool>;
        ///Write proxy for field `SSE`
        pub struct SSE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `SSPSC`
        pub type SSPSC_R = crate::R<bool, bool>;
        ///Write proxy for field `SSPSC`
        pub struct SSPSC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SSPSC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `PGPSC`
        pub type PGPSC_R = crate::R<u8, u8>;
        ///Write proxy for field `PGPSC`
        pub struct PGPSC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PGPSC_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 12)) | (((value as u32) & 0x07) << 12);
                self.w
            }
        }
        ///Reader of field `MCV`
        pub type MCV_R = crate::R<u8, u8>;
        ///Write proxy for field `MCV`
        pub struct MCV_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCV_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 5)) | (((value as u32) & 0x07) << 5);
                self.w
            }
        }
        ///Reader of field `IODEF`
        pub type IODEF_R = crate::R<bool, bool>;
        ///Write proxy for field `IODEF`
        pub struct IODEF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IODEF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `SYNCPOL`
        pub type SYNCPOL_R = crate::R<bool, bool>;
        ///Write proxy for field `SYNCPOL`
        pub struct SYNCPOL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SYNCPOL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `AM`
        pub type AM_R = crate::R<bool, bool>;
        ///Write proxy for field `AM`
        pub struct AM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> AM_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `START`
        pub type START_R = crate::R<bool, bool>;
        ///Write proxy for field `START`
        pub struct START_W<'a> {
            w: &'a mut W,
        }
        impl<'a> START_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `TSCE`
        pub type TSCE_R = crate::R<bool, bool>;
        ///Write proxy for field `TSCE`
        pub struct TSCE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TSCE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bits 28:31 - Charge transfer pulse high
            #[inline(always)]
            pub fn ctph(&self) -> CTPH_R {
                CTPH_R::new(((self.bits >> 28) & 0x0f) as u8)
            }
            ///Bits 24:27 - Charge transfer pulse low
            #[inline(always)]
            pub fn ctpl(&self) -> CTPL_R {
                CTPL_R::new(((self.bits >> 24) & 0x0f) as u8)
            }
            ///Bits 17:23 - Spread spectrum deviation
            #[inline(always)]
            pub fn ssd(&self) -> SSD_R {
                SSD_R::new(((self.bits >> 17) & 0x7f) as u8)
            }
            ///Bit 16 - Spread spectrum enable
            #[inline(always)]
            pub fn sse(&self) -> SSE_R {
                SSE_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - Spread spectrum prescaler
            #[inline(always)]
            pub fn sspsc(&self) -> SSPSC_R {
                SSPSC_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bits 12:14 - pulse generator prescaler
            #[inline(always)]
            pub fn pgpsc(&self) -> PGPSC_R {
                PGPSC_R::new(((self.bits >> 12) & 0x07) as u8)
            }
            ///Bits 5:7 - Max count value
            #[inline(always)]
            pub fn mcv(&self) -> MCV_R {
                MCV_R::new(((self.bits >> 5) & 0x07) as u8)
            }
            ///Bit 4 - I/O Default mode
            #[inline(always)]
            pub fn iodef(&self) -> IODEF_R {
                IODEF_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Synchronization pin polarity
            #[inline(always)]
            pub fn syncpol(&self) -> SYNCPOL_R {
                SYNCPOL_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Acquisition mode
            #[inline(always)]
            pub fn am(&self) -> AM_R {
                AM_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Start a new acquisition
            #[inline(always)]
            pub fn start(&self) -> START_R {
                START_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Touch sensing controller enable
            #[inline(always)]
            pub fn tsce(&self) -> TSCE_R {
                TSCE_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bits 28:31 - Charge transfer pulse high
            #[inline(always)]
            pub fn ctph(&mut self) -> CTPH_W {
                CTPH_W { w: self }
            }
            ///Bits 24:27 - Charge transfer pulse low
            #[inline(always)]
            pub fn ctpl(&mut self) -> CTPL_W {
                CTPL_W { w: self }
            }
            ///Bits 17:23 - Spread spectrum deviation
            #[inline(always)]
            pub fn ssd(&mut self) -> SSD_W {
                SSD_W { w: self }
            }
            ///Bit 16 - Spread spectrum enable
            #[inline(always)]
            pub fn sse(&mut self) -> SSE_W {
                SSE_W { w: self }
            }
            ///Bit 15 - Spread spectrum prescaler
            #[inline(always)]
            pub fn sspsc(&mut self) -> SSPSC_W {
                SSPSC_W { w: self }
            }
            ///Bits 12:14 - pulse generator prescaler
            #[inline(always)]
            pub fn pgpsc(&mut self) -> PGPSC_W {
                PGPSC_W { w: self }
            }
            ///Bits 5:7 - Max count value
            #[inline(always)]
            pub fn mcv(&mut self) -> MCV_W {
                MCV_W { w: self }
            }
            ///Bit 4 - I/O Default mode
            #[inline(always)]
            pub fn iodef(&mut self) -> IODEF_W {
                IODEF_W { w: self }
            }
            ///Bit 3 - Synchronization pin polarity
            #[inline(always)]
            pub fn syncpol(&mut self) -> SYNCPOL_W {
                SYNCPOL_W { w: self }
            }
            ///Bit 2 - Acquisition mode
            #[inline(always)]
            pub fn am(&mut self) -> AM_W {
                AM_W { w: self }
            }
            ///Bit 1 - Start a new acquisition
            #[inline(always)]
            pub fn start(&mut self) -> START_W {
                START_W { w: self }
            }
            ///Bit 0 - Touch sensing controller enable
            #[inline(always)]
            pub fn tsce(&mut self) -> TSCE_W {
                TSCE_W { w: self }
            }
        }
    }
    ///interrupt enable register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ier](ier) module
    pub type IER = crate::Reg<u32, _IER>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IER;
    ///`read()` method returns [ier::R](ier::R) reader structure
    impl crate::Readable for IER {}
    ///`write(|w| ..)` method takes [ier::W](ier::W) writer structure
    impl crate::Writable for IER {}
    ///interrupt enable register
    pub mod ier {
        ///Reader of register IER
        pub type R = crate::R<u32, super::IER>;
        ///Writer for register IER
        pub type W = crate::W<u32, super::IER>;
        ///Register IER `reset()`'s with value 0
        impl crate::ResetValue for super::IER {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEIE`
        pub type MCEIE_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEIE`
        pub struct MCEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAIE`
        pub type EOAIE_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAIE`
        pub struct EOAIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAIE_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error interrupt enable
            #[inline(always)]
            pub fn mceie(&self) -> MCEIE_R {
                MCEIE_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition interrupt enable
            #[inline(always)]
            pub fn eoaie(&self) -> EOAIE_R {
                EOAIE_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error interrupt enable
            #[inline(always)]
            pub fn mceie(&mut self) -> MCEIE_W {
                MCEIE_W { w: self }
            }
            ///Bit 0 - End of acquisition interrupt enable
            #[inline(always)]
            pub fn eoaie(&mut self) -> EOAIE_W {
                EOAIE_W { w: self }
            }
        }
    }
    ///interrupt clear register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [icr](icr) module
    pub type ICR = crate::Reg<u32, _ICR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ICR;
    ///`read()` method returns [icr::R](icr::R) reader structure
    impl crate::Readable for ICR {}
    ///`write(|w| ..)` method takes [icr::W](icr::W) writer structure
    impl crate::Writable for ICR {}
    ///interrupt clear register
    pub mod icr {
        ///Reader of register ICR
        pub type R = crate::R<u32, super::ICR>;
        ///Writer for register ICR
        pub type W = crate::W<u32, super::ICR>;
        ///Register ICR `reset()`'s with value 0
        impl crate::ResetValue for super::ICR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEIC`
        pub type MCEIC_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEIC`
        pub struct MCEIC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEIC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAIC`
        pub type EOAIC_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAIC`
        pub struct EOAIC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAIC_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error interrupt clear
            #[inline(always)]
            pub fn mceic(&self) -> MCEIC_R {
                MCEIC_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition interrupt clear
            #[inline(always)]
            pub fn eoaic(&self) -> EOAIC_R {
                EOAIC_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error interrupt clear
            #[inline(always)]
            pub fn mceic(&mut self) -> MCEIC_W {
                MCEIC_W { w: self }
            }
            ///Bit 0 - End of acquisition interrupt clear
            #[inline(always)]
            pub fn eoaic(&mut self) -> EOAIC_W {
                EOAIC_W { w: self }
            }
        }
    }
    ///interrupt status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [isr](isr) module
    pub type ISR = crate::Reg<u32, _ISR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _ISR;
    ///`read()` method returns [isr::R](isr::R) reader structure
    impl crate::Readable for ISR {}
    ///`write(|w| ..)` method takes [isr::W](isr::W) writer structure
    impl crate::Writable for ISR {}
    ///interrupt status register
    pub mod isr {
        ///Reader of register ISR
        pub type R = crate::R<u32, super::ISR>;
        ///Writer for register ISR
        pub type W = crate::W<u32, super::ISR>;
        ///Register ISR `reset()`'s with value 0
        impl crate::ResetValue for super::ISR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `MCEF`
        pub type MCEF_R = crate::R<bool, bool>;
        ///Write proxy for field `MCEF`
        pub struct MCEF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> MCEF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `EOAF`
        pub type EOAF_R = crate::R<bool, bool>;
        ///Write proxy for field `EOAF`
        pub struct EOAF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EOAF_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 1 - Max count error flag
            #[inline(always)]
            pub fn mcef(&self) -> MCEF_R {
                MCEF_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - End of acquisition flag
            #[inline(always)]
            pub fn eoaf(&self) -> EOAF_R {
                EOAF_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 1 - Max count error flag
            #[inline(always)]
            pub fn mcef(&mut self) -> MCEF_W {
                MCEF_W { w: self }
            }
            ///Bit 0 - End of acquisition flag
            #[inline(always)]
            pub fn eoaf(&mut self) -> EOAF_W {
                EOAF_W { w: self }
            }
        }
    }
    ///I/O hysteresis control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [iohcr](iohcr) module
    pub type IOHCR = crate::Reg<u32, _IOHCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOHCR;
    ///`read()` method returns [iohcr::R](iohcr::R) reader structure
    impl crate::Readable for IOHCR {}
    ///`write(|w| ..)` method takes [iohcr::W](iohcr::W) writer structure
    impl crate::Writable for IOHCR {}
    ///I/O hysteresis control register
    pub mod iohcr {
        ///Reader of register IOHCR
        pub type R = crate::R<u32, super::IOHCR>;
        ///Writer for register IOHCR
        pub type W = crate::W<u32, super::IOHCR>;
        ///Register IOHCR `reset()`'s with value 0xffff_ffff
        impl crate::ResetValue for super::IOHCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0xffff_ffff
            }
        }
        ///Reader of field `G8_IO4`
        pub type G8_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO4`
        pub struct G8_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `G8_IO3`
        pub type G8_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO3`
        pub struct G8_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `G8_IO2`
        pub type G8_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO2`
        pub struct G8_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `G8_IO1`
        pub type G8_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO1`
        pub struct G8_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&self) -> G8_IO4_R {
                G8_IO4_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&self) -> G8_IO3_R {
                G8_IO3_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&self) -> G8_IO2_R {
                G8_IO2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&self) -> G8_IO1_R {
                G8_IO1_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&mut self) -> G8_IO4_W {
                G8_IO4_W { w: self }
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&mut self) -> G8_IO3_W {
                G8_IO3_W { w: self }
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&mut self) -> G8_IO2_W {
                G8_IO2_W { w: self }
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&mut self) -> G8_IO1_W {
                G8_IO1_W { w: self }
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O analog switch control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ioascr](ioascr) module
    pub type IOASCR = crate::Reg<u32, _IOASCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOASCR;
    ///`read()` method returns [ioascr::R](ioascr::R) reader structure
    impl crate::Readable for IOASCR {}
    ///`write(|w| ..)` method takes [ioascr::W](ioascr::W) writer structure
    impl crate::Writable for IOASCR {}
    ///I/O analog switch control register
    pub mod ioascr {
        ///Reader of register IOASCR
        pub type R = crate::R<u32, super::IOASCR>;
        ///Writer for register IOASCR
        pub type W = crate::W<u32, super::IOASCR>;
        ///Register IOASCR `reset()`'s with value 0
        impl crate::ResetValue for super::IOASCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G8_IO4`
        pub type G8_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO4`
        pub struct G8_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `G8_IO3`
        pub type G8_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO3`
        pub struct G8_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `G8_IO2`
        pub type G8_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO2`
        pub struct G8_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `G8_IO1`
        pub type G8_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO1`
        pub struct G8_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&self) -> G8_IO4_R {
                G8_IO4_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&self) -> G8_IO3_R {
                G8_IO3_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&self) -> G8_IO2_R {
                G8_IO2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&self) -> G8_IO1_R {
                G8_IO1_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&mut self) -> G8_IO4_W {
                G8_IO4_W { w: self }
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&mut self) -> G8_IO3_W {
                G8_IO3_W { w: self }
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&mut self) -> G8_IO2_W {
                G8_IO2_W { w: self }
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&mut self) -> G8_IO1_W {
                G8_IO1_W { w: self }
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O sampling control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ioscr](ioscr) module
    pub type IOSCR = crate::Reg<u32, _IOSCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOSCR;
    ///`read()` method returns [ioscr::R](ioscr::R) reader structure
    impl crate::Readable for IOSCR {}
    ///`write(|w| ..)` method takes [ioscr::W](ioscr::W) writer structure
    impl crate::Writable for IOSCR {}
    ///I/O sampling control register
    pub mod ioscr {
        ///Reader of register IOSCR
        pub type R = crate::R<u32, super::IOSCR>;
        ///Writer for register IOSCR
        pub type W = crate::W<u32, super::IOSCR>;
        ///Register IOSCR `reset()`'s with value 0
        impl crate::ResetValue for super::IOSCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G8_IO4`
        pub type G8_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO4`
        pub struct G8_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `G8_IO3`
        pub type G8_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO3`
        pub struct G8_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `G8_IO2`
        pub type G8_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO2`
        pub struct G8_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `G8_IO1`
        pub type G8_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO1`
        pub struct G8_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&self) -> G8_IO4_R {
                G8_IO4_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&self) -> G8_IO3_R {
                G8_IO3_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&self) -> G8_IO2_R {
                G8_IO2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&self) -> G8_IO1_R {
                G8_IO1_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&mut self) -> G8_IO4_W {
                G8_IO4_W { w: self }
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&mut self) -> G8_IO3_W {
                G8_IO3_W { w: self }
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&mut self) -> G8_IO2_W {
                G8_IO2_W { w: self }
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&mut self) -> G8_IO1_W {
                G8_IO1_W { w: self }
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O channel control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [ioccr](ioccr) module
    pub type IOCCR = crate::Reg<u32, _IOCCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOCCR;
    ///`read()` method returns [ioccr::R](ioccr::R) reader structure
    impl crate::Readable for IOCCR {}
    ///`write(|w| ..)` method takes [ioccr::W](ioccr::W) writer structure
    impl crate::Writable for IOCCR {}
    ///I/O channel control register
    pub mod ioccr {
        ///Reader of register IOCCR
        pub type R = crate::R<u32, super::IOCCR>;
        ///Writer for register IOCCR
        pub type W = crate::W<u32, super::IOCCR>;
        ///Register IOCCR `reset()`'s with value 0
        impl crate::ResetValue for super::IOCCR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G8_IO4`
        pub type G8_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO4`
        pub struct G8_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
                self.w
            }
        }
        ///Reader of field `G8_IO3`
        pub type G8_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO3`
        pub struct G8_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
                self.w
            }
        }
        ///Reader of field `G8_IO2`
        pub type G8_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO2`
        pub struct G8_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
                self.w
            }
        }
        ///Reader of field `G8_IO1`
        pub type G8_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G8_IO1`
        pub struct G8_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
                self.w
            }
        }
        ///Reader of field `G7_IO4`
        pub type G7_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO4`
        pub struct G7_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
                self.w
            }
        }
        ///Reader of field `G7_IO3`
        pub type G7_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO3`
        pub struct G7_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 26)) | (((value as u32) & 0x01) << 26);
                self.w
            }
        }
        ///Reader of field `G7_IO2`
        pub type G7_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO2`
        pub struct G7_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 25)) | (((value as u32) & 0x01) << 25);
                self.w
            }
        }
        ///Reader of field `G7_IO1`
        pub type G7_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G7_IO1`
        pub struct G7_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 24)) | (((value as u32) & 0x01) << 24);
                self.w
            }
        }
        ///Reader of field `G6_IO4`
        pub type G6_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO4`
        pub struct G6_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 23)) | (((value as u32) & 0x01) << 23);
                self.w
            }
        }
        ///Reader of field `G6_IO3`
        pub type G6_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO3`
        pub struct G6_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 22)) | (((value as u32) & 0x01) << 22);
                self.w
            }
        }
        ///Reader of field `G6_IO2`
        pub type G6_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO2`
        pub struct G6_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 21)) | (((value as u32) & 0x01) << 21);
                self.w
            }
        }
        ///Reader of field `G6_IO1`
        pub type G6_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G6_IO1`
        pub struct G6_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 20)) | (((value as u32) & 0x01) << 20);
                self.w
            }
        }
        ///Reader of field `G5_IO4`
        pub type G5_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO4`
        pub struct G5_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 19)) | (((value as u32) & 0x01) << 19);
                self.w
            }
        }
        ///Reader of field `G5_IO3`
        pub type G5_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO3`
        pub struct G5_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 18)) | (((value as u32) & 0x01) << 18);
                self.w
            }
        }
        ///Reader of field `G5_IO2`
        pub type G5_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO2`
        pub struct G5_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 17)) | (((value as u32) & 0x01) << 17);
                self.w
            }
        }
        ///Reader of field `G5_IO1`
        pub type G5_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G5_IO1`
        pub struct G5_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
                self.w
            }
        }
        ///Reader of field `G4_IO4`
        pub type G4_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO4`
        pub struct G4_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `G4_IO3`
        pub type G4_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO3`
        pub struct G4_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 14)) | (((value as u32) & 0x01) << 14);
                self.w
            }
        }
        ///Reader of field `G4_IO2`
        pub type G4_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO2`
        pub struct G4_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 13)) | (((value as u32) & 0x01) << 13);
                self.w
            }
        }
        ///Reader of field `G4_IO1`
        pub type G4_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G4_IO1`
        pub struct G4_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 12)) | (((value as u32) & 0x01) << 12);
                self.w
            }
        }
        ///Reader of field `G3_IO4`
        pub type G3_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO4`
        pub struct G3_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
                self.w
            }
        }
        ///Reader of field `G3_IO3`
        pub type G3_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO3`
        pub struct G3_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
                self.w
            }
        }
        ///Reader of field `G3_IO2`
        pub type G3_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO2`
        pub struct G3_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `G3_IO1`
        pub type G3_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G3_IO1`
        pub struct G3_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
                self.w
            }
        }
        ///Reader of field `G2_IO4`
        pub type G2_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO4`
        pub struct G2_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G2_IO3`
        pub type G2_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO3`
        pub struct G2_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G2_IO2`
        pub type G2_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO2`
        pub struct G2_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G2_IO1`
        pub type G2_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G2_IO1`
        pub struct G2_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G1_IO4`
        pub type G1_IO4_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO4`
        pub struct G1_IO4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO4_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G1_IO3`
        pub type G1_IO3_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO3`
        pub struct G1_IO3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO3_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G1_IO2`
        pub type G1_IO2_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO2`
        pub struct G1_IO2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO2_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1_IO1`
        pub type G1_IO1_R = crate::R<bool, bool>;
        ///Write proxy for field `G1_IO1`
        pub struct G1_IO1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1_IO1_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&self) -> G8_IO4_R {
                G8_IO4_R::new(((self.bits >> 31) & 0x01) != 0)
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&self) -> G8_IO3_R {
                G8_IO3_R::new(((self.bits >> 30) & 0x01) != 0)
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&self) -> G8_IO2_R {
                G8_IO2_R::new(((self.bits >> 29) & 0x01) != 0)
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&self) -> G8_IO1_R {
                G8_IO1_R::new(((self.bits >> 28) & 0x01) != 0)
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&self) -> G7_IO4_R {
                G7_IO4_R::new(((self.bits >> 27) & 0x01) != 0)
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&self) -> G7_IO3_R {
                G7_IO3_R::new(((self.bits >> 26) & 0x01) != 0)
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&self) -> G7_IO2_R {
                G7_IO2_R::new(((self.bits >> 25) & 0x01) != 0)
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&self) -> G7_IO1_R {
                G7_IO1_R::new(((self.bits >> 24) & 0x01) != 0)
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&self) -> G6_IO4_R {
                G6_IO4_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&self) -> G6_IO3_R {
                G6_IO3_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&self) -> G6_IO2_R {
                G6_IO2_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&self) -> G6_IO1_R {
                G6_IO1_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&self) -> G5_IO4_R {
                G5_IO4_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&self) -> G5_IO3_R {
                G5_IO3_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&self) -> G5_IO2_R {
                G5_IO2_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&self) -> G5_IO1_R {
                G5_IO1_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&self) -> G4_IO4_R {
                G4_IO4_R::new(((self.bits >> 15) & 0x01) != 0)
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&self) -> G4_IO3_R {
                G4_IO3_R::new(((self.bits >> 14) & 0x01) != 0)
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&self) -> G4_IO2_R {
                G4_IO2_R::new(((self.bits >> 13) & 0x01) != 0)
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&self) -> G4_IO1_R {
                G4_IO1_R::new(((self.bits >> 12) & 0x01) != 0)
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&self) -> G3_IO4_R {
                G3_IO4_R::new(((self.bits >> 11) & 0x01) != 0)
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&self) -> G3_IO3_R {
                G3_IO3_R::new(((self.bits >> 10) & 0x01) != 0)
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&self) -> G3_IO2_R {
                G3_IO2_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&self) -> G3_IO1_R {
                G3_IO1_R::new(((self.bits >> 8) & 0x01) != 0)
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&self) -> G2_IO4_R {
                G2_IO4_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&self) -> G2_IO3_R {
                G2_IO3_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&self) -> G2_IO2_R {
                G2_IO2_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&self) -> G2_IO1_R {
                G2_IO1_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&self) -> G1_IO4_R {
                G1_IO4_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&self) -> G1_IO3_R {
                G1_IO3_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&self) -> G1_IO2_R {
                G1_IO2_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&self) -> G1_IO1_R {
                G1_IO1_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 31 - G8_IO4
            #[inline(always)]
            pub fn g8_io4(&mut self) -> G8_IO4_W {
                G8_IO4_W { w: self }
            }
            ///Bit 30 - G8_IO3
            #[inline(always)]
            pub fn g8_io3(&mut self) -> G8_IO3_W {
                G8_IO3_W { w: self }
            }
            ///Bit 29 - G8_IO2
            #[inline(always)]
            pub fn g8_io2(&mut self) -> G8_IO2_W {
                G8_IO2_W { w: self }
            }
            ///Bit 28 - G8_IO1
            #[inline(always)]
            pub fn g8_io1(&mut self) -> G8_IO1_W {
                G8_IO1_W { w: self }
            }
            ///Bit 27 - G7_IO4
            #[inline(always)]
            pub fn g7_io4(&mut self) -> G7_IO4_W {
                G7_IO4_W { w: self }
            }
            ///Bit 26 - G7_IO3
            #[inline(always)]
            pub fn g7_io3(&mut self) -> G7_IO3_W {
                G7_IO3_W { w: self }
            }
            ///Bit 25 - G7_IO2
            #[inline(always)]
            pub fn g7_io2(&mut self) -> G7_IO2_W {
                G7_IO2_W { w: self }
            }
            ///Bit 24 - G7_IO1
            #[inline(always)]
            pub fn g7_io1(&mut self) -> G7_IO1_W {
                G7_IO1_W { w: self }
            }
            ///Bit 23 - G6_IO4
            #[inline(always)]
            pub fn g6_io4(&mut self) -> G6_IO4_W {
                G6_IO4_W { w: self }
            }
            ///Bit 22 - G6_IO3
            #[inline(always)]
            pub fn g6_io3(&mut self) -> G6_IO3_W {
                G6_IO3_W { w: self }
            }
            ///Bit 21 - G6_IO2
            #[inline(always)]
            pub fn g6_io2(&mut self) -> G6_IO2_W {
                G6_IO2_W { w: self }
            }
            ///Bit 20 - G6_IO1
            #[inline(always)]
            pub fn g6_io1(&mut self) -> G6_IO1_W {
                G6_IO1_W { w: self }
            }
            ///Bit 19 - G5_IO4
            #[inline(always)]
            pub fn g5_io4(&mut self) -> G5_IO4_W {
                G5_IO4_W { w: self }
            }
            ///Bit 18 - G5_IO3
            #[inline(always)]
            pub fn g5_io3(&mut self) -> G5_IO3_W {
                G5_IO3_W { w: self }
            }
            ///Bit 17 - G5_IO2
            #[inline(always)]
            pub fn g5_io2(&mut self) -> G5_IO2_W {
                G5_IO2_W { w: self }
            }
            ///Bit 16 - G5_IO1
            #[inline(always)]
            pub fn g5_io1(&mut self) -> G5_IO1_W {
                G5_IO1_W { w: self }
            }
            ///Bit 15 - G4_IO4
            #[inline(always)]
            pub fn g4_io4(&mut self) -> G4_IO4_W {
                G4_IO4_W { w: self }
            }
            ///Bit 14 - G4_IO3
            #[inline(always)]
            pub fn g4_io3(&mut self) -> G4_IO3_W {
                G4_IO3_W { w: self }
            }
            ///Bit 13 - G4_IO2
            #[inline(always)]
            pub fn g4_io2(&mut self) -> G4_IO2_W {
                G4_IO2_W { w: self }
            }
            ///Bit 12 - G4_IO1
            #[inline(always)]
            pub fn g4_io1(&mut self) -> G4_IO1_W {
                G4_IO1_W { w: self }
            }
            ///Bit 11 - G3_IO4
            #[inline(always)]
            pub fn g3_io4(&mut self) -> G3_IO4_W {
                G3_IO4_W { w: self }
            }
            ///Bit 10 - G3_IO3
            #[inline(always)]
            pub fn g3_io3(&mut self) -> G3_IO3_W {
                G3_IO3_W { w: self }
            }
            ///Bit 9 - G3_IO2
            #[inline(always)]
            pub fn g3_io2(&mut self) -> G3_IO2_W {
                G3_IO2_W { w: self }
            }
            ///Bit 8 - G3_IO1
            #[inline(always)]
            pub fn g3_io1(&mut self) -> G3_IO1_W {
                G3_IO1_W { w: self }
            }
            ///Bit 7 - G2_IO4
            #[inline(always)]
            pub fn g2_io4(&mut self) -> G2_IO4_W {
                G2_IO4_W { w: self }
            }
            ///Bit 6 - G2_IO3
            #[inline(always)]
            pub fn g2_io3(&mut self) -> G2_IO3_W {
                G2_IO3_W { w: self }
            }
            ///Bit 5 - G2_IO2
            #[inline(always)]
            pub fn g2_io2(&mut self) -> G2_IO2_W {
                G2_IO2_W { w: self }
            }
            ///Bit 4 - G2_IO1
            #[inline(always)]
            pub fn g2_io1(&mut self) -> G2_IO1_W {
                G2_IO1_W { w: self }
            }
            ///Bit 3 - G1_IO4
            #[inline(always)]
            pub fn g1_io4(&mut self) -> G1_IO4_W {
                G1_IO4_W { w: self }
            }
            ///Bit 2 - G1_IO3
            #[inline(always)]
            pub fn g1_io3(&mut self) -> G1_IO3_W {
                G1_IO3_W { w: self }
            }
            ///Bit 1 - G1_IO2
            #[inline(always)]
            pub fn g1_io2(&mut self) -> G1_IO2_W {
                G1_IO2_W { w: self }
            }
            ///Bit 0 - G1_IO1
            #[inline(always)]
            pub fn g1_io1(&mut self) -> G1_IO1_W {
                G1_IO1_W { w: self }
            }
        }
    }
    ///I/O group control status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [iogcsr](iogcsr) module
    pub type IOGCSR = crate::Reg<u32, _IOGCSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOGCSR;
    ///`read()` method returns [iogcsr::R](iogcsr::R) reader structure
    impl crate::Readable for IOGCSR {}
    ///`write(|w| ..)` method takes [iogcsr::W](iogcsr::W) writer structure
    impl crate::Writable for IOGCSR {}
    ///I/O group control status register
    pub mod iogcsr {
        ///Reader of register IOGCSR
        pub type R = crate::R<u32, super::IOGCSR>;
        ///Writer for register IOGCSR
        pub type W = crate::W<u32, super::IOGCSR>;
        ///Register IOGCSR `reset()`'s with value 0
        impl crate::ResetValue for super::IOGCSR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `G8S`
        pub type G8S_R = crate::R<bool, bool>;
        ///Reader of field `G7S`
        pub type G7S_R = crate::R<bool, bool>;
        ///Reader of field `G6S`
        pub type G6S_R = crate::R<bool, bool>;
        ///Reader of field `G5S`
        pub type G5S_R = crate::R<bool, bool>;
        ///Reader of field `G4S`
        pub type G4S_R = crate::R<bool, bool>;
        ///Reader of field `G3S`
        pub type G3S_R = crate::R<bool, bool>;
        ///Reader of field `G2S`
        pub type G2S_R = crate::R<bool, bool>;
        ///Reader of field `G1S`
        pub type G1S_R = crate::R<bool, bool>;
        ///Reader of field `G8E`
        pub type G8E_R = crate::R<bool, bool>;
        ///Write proxy for field `G8E`
        pub struct G8E_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G8E_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `G7E`
        pub type G7E_R = crate::R<bool, bool>;
        ///Write proxy for field `G7E`
        pub struct G7E_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G7E_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
                self.w
            }
        }
        ///Reader of field `G6E`
        pub type G6E_R = crate::R<bool, bool>;
        ///Write proxy for field `G6E`
        pub struct G6E_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G6E_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
                self.w
            }
        }
        ///Reader of field `G5E`
        pub type G5E_R = crate::R<bool, bool>;
        ///Write proxy for field `G5E`
        pub struct G5E_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G5E_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
                self.w
            }
        }
        ///Reader of field `G4E`
        pub type G4E_R = crate::R<bool, bool>;
        ///Write proxy for field `G4E`
        pub struct G4E_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G4E_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
                self.w
            }
        }
        ///Reader of field `G3E`
        pub type G3E_R = crate::R<bool, bool>;
        ///Write proxy for field `G3E`
        pub struct G3E_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G3E_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
                self.w
            }
        }
        ///Reader of field `G2E`
        pub type G2E_R = crate::R<bool, bool>;
        ///Write proxy for field `G2E`
        pub struct G2E_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G2E_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
                self.w
            }
        }
        ///Reader of field `G1E`
        pub type G1E_R = crate::R<bool, bool>;
        ///Write proxy for field `G1E`
        pub struct G1E_W<'a> {
            w: &'a mut W,
        }
        impl<'a> G1E_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 23 - Analog I/O group x status
            #[inline(always)]
            pub fn g8s(&self) -> G8S_R {
                G8S_R::new(((self.bits >> 23) & 0x01) != 0)
            }
            ///Bit 22 - Analog I/O group x status
            #[inline(always)]
            pub fn g7s(&self) -> G7S_R {
                G7S_R::new(((self.bits >> 22) & 0x01) != 0)
            }
            ///Bit 21 - Analog I/O group x status
            #[inline(always)]
            pub fn g6s(&self) -> G6S_R {
                G6S_R::new(((self.bits >> 21) & 0x01) != 0)
            }
            ///Bit 20 - Analog I/O group x status
            #[inline(always)]
            pub fn g5s(&self) -> G5S_R {
                G5S_R::new(((self.bits >> 20) & 0x01) != 0)
            }
            ///Bit 19 - Analog I/O group x status
            #[inline(always)]
            pub fn g4s(&self) -> G4S_R {
                G4S_R::new(((self.bits >> 19) & 0x01) != 0)
            }
            ///Bit 18 - Analog I/O group x status
            #[inline(always)]
            pub fn g3s(&self) -> G3S_R {
                G3S_R::new(((self.bits >> 18) & 0x01) != 0)
            }
            ///Bit 17 - Analog I/O group x status
            #[inline(always)]
            pub fn g2s(&self) -> G2S_R {
                G2S_R::new(((self.bits >> 17) & 0x01) != 0)
            }
            ///Bit 16 - Analog I/O group x status
            #[inline(always)]
            pub fn g1s(&self) -> G1S_R {
                G1S_R::new(((self.bits >> 16) & 0x01) != 0)
            }
            ///Bit 7 - Analog I/O group x enable
            #[inline(always)]
            pub fn g8e(&self) -> G8E_R {
                G8E_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bit 6 - Analog I/O group x enable
            #[inline(always)]
            pub fn g7e(&self) -> G7E_R {
                G7E_R::new(((self.bits >> 6) & 0x01) != 0)
            }
            ///Bit 5 - Analog I/O group x enable
            #[inline(always)]
            pub fn g6e(&self) -> G6E_R {
                G6E_R::new(((self.bits >> 5) & 0x01) != 0)
            }
            ///Bit 4 - Analog I/O group x enable
            #[inline(always)]
            pub fn g5e(&self) -> G5E_R {
                G5E_R::new(((self.bits >> 4) & 0x01) != 0)
            }
            ///Bit 3 - Analog I/O group x enable
            #[inline(always)]
            pub fn g4e(&self) -> G4E_R {
                G4E_R::new(((self.bits >> 3) & 0x01) != 0)
            }
            ///Bit 2 - Analog I/O group x enable
            #[inline(always)]
            pub fn g3e(&self) -> G3E_R {
                G3E_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Analog I/O group x enable
            #[inline(always)]
            pub fn g2e(&self) -> G2E_R {
                G2E_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Analog I/O group x enable
            #[inline(always)]
            pub fn g1e(&self) -> G1E_R {
                G1E_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 7 - Analog I/O group x enable
            #[inline(always)]
            pub fn g8e(&mut self) -> G8E_W {
                G8E_W { w: self }
            }
            ///Bit 6 - Analog I/O group x enable
            #[inline(always)]
            pub fn g7e(&mut self) -> G7E_W {
                G7E_W { w: self }
            }
            ///Bit 5 - Analog I/O group x enable
            #[inline(always)]
            pub fn g6e(&mut self) -> G6E_W {
                G6E_W { w: self }
            }
            ///Bit 4 - Analog I/O group x enable
            #[inline(always)]
            pub fn g5e(&mut self) -> G5E_W {
                G5E_W { w: self }
            }
            ///Bit 3 - Analog I/O group x enable
            #[inline(always)]
            pub fn g4e(&mut self) -> G4E_W {
                G4E_W { w: self }
            }
            ///Bit 2 - Analog I/O group x enable
            #[inline(always)]
            pub fn g3e(&mut self) -> G3E_W {
                G3E_W { w: self }
            }
            ///Bit 1 - Analog I/O group x enable
            #[inline(always)]
            pub fn g2e(&mut self) -> G2E_W {
                G2E_W { w: self }
            }
            ///Bit 0 - Analog I/O group x enable
            #[inline(always)]
            pub fn g1e(&mut self) -> G1E_W {
                G1E_W { w: self }
            }
        }
    }
    ///I/O group x counter register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [iogcr](iogcr) module
    pub type IOGCR = crate::Reg<u32, _IOGCR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _IOGCR;
    ///`read()` method returns [iogcr::R](iogcr::R) reader structure
    impl crate::Readable for IOGCR {}
    ///I/O group x counter register
    pub mod iogcr {
        ///Reader of register IOG%sCR
        pub type R = crate::R<u32, super::IOGCR>;
        ///Reader of field `CNT`
        pub type CNT_R = crate::R<u16, u16>;
        impl R {
            ///Bits 0:13 - Counter value
            #[inline(always)]
            pub fn cnt(&self) -> CNT_R {
                CNT_R::new((self.bits & 0x3fff) as u16)
            }
        }
    }
}
///Independent watchdog
pub struct IWDG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IWDG {}
impl IWDG {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const iwdg::RegisterBlock {
        0x4000_3000 as *const _
    }
}
impl Deref for IWDG {
    type Target = iwdg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*IWDG::ptr() }
    }
}
///Independent watchdog
pub mod iwdg {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - Key register
        pub kr: KR,
        ///0x04 - Prescaler register
        pub pr: PR,
        ///0x08 - Reload register
        pub rlr: RLR,
        ///0x0c - Status register
        pub sr: SR,
        ///0x10 - Window register
        pub winr: WINR,
    }
    ///Key register
    ///
    ///This register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [kr](kr) module
    pub type KR = crate::Reg<u32, _KR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _KR;
    ///`write(|w| ..)` method takes [kr::W](kr::W) writer structure
    impl crate::Writable for KR {}
    ///Key register
    pub mod kr {
        ///Writer for register KR
        pub type W = crate::W<u32, super::KR>;
        ///Register KR `reset()`'s with value 0
        impl crate::ResetValue for super::KR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Key value (write only, read 0x0000)
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u16)]
        pub enum KEY_AW {
            ///21845: Enable access to PR, RLR and WINR registers (0x5555)
            ENABLE = 21845,
            ///43690: Reset the watchdog value (0xAAAA)
            RESET = 43690,
            ///52428: Start the watchdog (0xCCCC)
            START = 52428,
        }
        impl From<KEY_AW> for u16 {
            #[inline(always)]
            fn from(variant: KEY_AW) -> Self {
                variant as _
            }
        }
        ///Write proxy for field `KEY`
        pub struct KEY_W<'a> {
            w: &'a mut W,
        }
        impl<'a> KEY_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: KEY_AW) -> &'a mut W {
                unsafe { self.bits(variant.into()) }
            }
            ///Enable access to PR, RLR and WINR registers (0x5555)
            #[inline(always)]
            pub fn enable(self) -> &'a mut W {
                self.variant(KEY_AW::ENABLE)
            }
            ///Reset the watchdog value (0xAAAA)
            #[inline(always)]
            pub fn reset(self) -> &'a mut W {
                self.variant(KEY_AW::RESET)
            }
            ///Start the watchdog (0xCCCC)
            #[inline(always)]
            pub fn start(self) -> &'a mut W {
                self.variant(KEY_AW::START)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xffff) | ((value as u32) & 0xffff);
                self.w
            }
        }
        impl W {
            ///Bits 0:15 - Key value (write only, read 0x0000)
            #[inline(always)]
            pub fn key(&mut self) -> KEY_W {
                KEY_W { w: self }
            }
        }
    }
    ///Prescaler register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [pr](pr) module
    pub type PR = crate::Reg<u32, _PR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _PR;
    ///`read()` method returns [pr::R](pr::R) reader structure
    impl crate::Readable for PR {}
    ///`write(|w| ..)` method takes [pr::W](pr::W) writer structure
    impl crate::Writable for PR {}
    ///Prescaler register
    pub mod pr {
        ///Reader of register PR
        pub type R = crate::R<u32, super::PR>;
        ///Writer for register PR
        pub type W = crate::W<u32, super::PR>;
        ///Register PR `reset()`'s with value 0
        impl crate::ResetValue for super::PR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Prescaler divider
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum PR_A {
            ///0: Divider /4
            DIVIDEBY4 = 0,
            ///1: Divider /8
            DIVIDEBY8 = 1,
            ///2: Divider /16
            DIVIDEBY16 = 2,
            ///3: Divider /32
            DIVIDEBY32 = 3,
            ///4: Divider /64
            DIVIDEBY64 = 4,
            ///5: Divider /128
            DIVIDEBY128 = 5,
            ///6: Divider /256
            DIVIDEBY256 = 6,
            ///7: Divider /256
            DIVIDEBY256BIS = 7,
        }
        impl From<PR_A> for u8 {
            #[inline(always)]
            fn from(variant: PR_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `PR`
        pub type PR_R = crate::R<u8, PR_A>;
        impl PR_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> PR_A {
                match self.bits {
                    0 => PR_A::DIVIDEBY4,
                    1 => PR_A::DIVIDEBY8,
                    2 => PR_A::DIVIDEBY16,
                    3 => PR_A::DIVIDEBY32,
                    4 => PR_A::DIVIDEBY64,
                    5 => PR_A::DIVIDEBY128,
                    6 => PR_A::DIVIDEBY256,
                    7 => PR_A::DIVIDEBY256BIS,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `DIVIDEBY4`
            #[inline(always)]
            pub fn is_divide_by4(&self) -> bool {
                *self == PR_A::DIVIDEBY4
            }
            ///Checks if the value of the field is `DIVIDEBY8`
            #[inline(always)]
            pub fn is_divide_by8(&self) -> bool {
                *self == PR_A::DIVIDEBY8
            }
            ///Checks if the value of the field is `DIVIDEBY16`
            #[inline(always)]
            pub fn is_divide_by16(&self) -> bool {
                *self == PR_A::DIVIDEBY16
            }
            ///Checks if the value of the field is `DIVIDEBY32`
            #[inline(always)]
            pub fn is_divide_by32(&self) -> bool {
                *self == PR_A::DIVIDEBY32
            }
            ///Checks if the value of the field is `DIVIDEBY64`
            #[inline(always)]
            pub fn is_divide_by64(&self) -> bool {
                *self == PR_A::DIVIDEBY64
            }
            ///Checks if the value of the field is `DIVIDEBY128`
            #[inline(always)]
            pub fn is_divide_by128(&self) -> bool {
                *self == PR_A::DIVIDEBY128
            }
            ///Checks if the value of the field is `DIVIDEBY256`
            #[inline(always)]
            pub fn is_divide_by256(&self) -> bool {
                *self == PR_A::DIVIDEBY256
            }
            ///Checks if the value of the field is `DIVIDEBY256BIS`
            #[inline(always)]
            pub fn is_divide_by256bis(&self) -> bool {
                *self == PR_A::DIVIDEBY256BIS
            }
        }
        ///Write proxy for field `PR`
        pub struct PR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PR_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: PR_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Divider /4
            #[inline(always)]
            pub fn divide_by4(self) -> &'a mut W {
                self.variant(PR_A::DIVIDEBY4)
            }
            ///Divider /8
            #[inline(always)]
            pub fn divide_by8(self) -> &'a mut W {
                self.variant(PR_A::DIVIDEBY8)
            }
            ///Divider /16
            #[inline(always)]
            pub fn divide_by16(self) -> &'a mut W {
                self.variant(PR_A::DIVIDEBY16)
            }
            ///Divider /32
            #[inline(always)]
            pub fn divide_by32(self) -> &'a mut W {
                self.variant(PR_A::DIVIDEBY32)
            }
            ///Divider /64
            #[inline(always)]
            pub fn divide_by64(self) -> &'a mut W {
                self.variant(PR_A::DIVIDEBY64)
            }
            ///Divider /128
            #[inline(always)]
            pub fn divide_by128(self) -> &'a mut W {
                self.variant(PR_A::DIVIDEBY128)
            }
            ///Divider /256
            #[inline(always)]
            pub fn divide_by256(self) -> &'a mut W {
                self.variant(PR_A::DIVIDEBY256)
            }
            ///Divider /256
            #[inline(always)]
            pub fn divide_by256bis(self) -> &'a mut W {
                self.variant(PR_A::DIVIDEBY256BIS)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x07) | ((value as u32) & 0x07);
                self.w
            }
        }
        impl R {
            ///Bits 0:2 - Prescaler divider
            #[inline(always)]
            pub fn pr(&self) -> PR_R {
                PR_R::new((self.bits & 0x07) as u8)
            }
        }
        impl W {
            ///Bits 0:2 - Prescaler divider
            #[inline(always)]
            pub fn pr(&mut self) -> PR_W {
                PR_W { w: self }
            }
        }
    }
    ///Reload register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [rlr](rlr) module
    pub type RLR = crate::Reg<u32, _RLR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _RLR;
    ///`read()` method returns [rlr::R](rlr::R) reader structure
    impl crate::Readable for RLR {}
    ///`write(|w| ..)` method takes [rlr::W](rlr::W) writer structure
    impl crate::Writable for RLR {}
    ///Reload register
    pub mod rlr {
        ///Reader of register RLR
        pub type R = crate::R<u32, super::RLR>;
        ///Writer for register RLR
        pub type W = crate::W<u32, super::RLR>;
        ///Register RLR `reset()`'s with value 0x0fff
        impl crate::ResetValue for super::RLR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x0fff
            }
        }
        ///Reader of field `RL`
        pub type RL_R = crate::R<u16, u16>;
        ///Write proxy for field `RL`
        pub struct RL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - Watchdog counter reload value
            #[inline(always)]
            pub fn rl(&self) -> RL_R {
                RL_R::new((self.bits & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - Watchdog counter reload value
            #[inline(always)]
            pub fn rl(&mut self) -> RL_W {
                RL_W { w: self }
            }
        }
    }
    ///Status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [sr](sr) module
    pub type SR = crate::Reg<u32, _SR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SR;
    ///`read()` method returns [sr::R](sr::R) reader structure
    impl crate::Readable for SR {}
    ///Status register
    pub mod sr {
        ///Reader of register SR
        pub type R = crate::R<u32, super::SR>;
        ///Reader of field `WVU`
        pub type WVU_R = crate::R<bool, bool>;
        ///Reader of field `RVU`
        pub type RVU_R = crate::R<bool, bool>;
        ///Reader of field `PVU`
        pub type PVU_R = crate::R<bool, bool>;
        impl R {
            ///Bit 2 - Watchdog counter window value update
            #[inline(always)]
            pub fn wvu(&self) -> WVU_R {
                WVU_R::new(((self.bits >> 2) & 0x01) != 0)
            }
            ///Bit 1 - Watchdog counter reload value update
            #[inline(always)]
            pub fn rvu(&self) -> RVU_R {
                RVU_R::new(((self.bits >> 1) & 0x01) != 0)
            }
            ///Bit 0 - Watchdog prescaler value update
            #[inline(always)]
            pub fn pvu(&self) -> PVU_R {
                PVU_R::new((self.bits & 0x01) != 0)
            }
        }
    }
    ///Window register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [winr](winr) module
    pub type WINR = crate::Reg<u32, _WINR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _WINR;
    ///`read()` method returns [winr::R](winr::R) reader structure
    impl crate::Readable for WINR {}
    ///`write(|w| ..)` method takes [winr::W](winr::W) writer structure
    impl crate::Writable for WINR {}
    ///Window register
    pub mod winr {
        ///Reader of register WINR
        pub type R = crate::R<u32, super::WINR>;
        ///Writer for register WINR
        pub type W = crate::W<u32, super::WINR>;
        ///Register WINR `reset()`'s with value 0x0fff
        impl crate::ResetValue for super::WINR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x0fff
            }
        }
        ///Reader of field `WIN`
        pub type WIN_R = crate::R<u16, u16>;
        ///Write proxy for field `WIN`
        pub struct WIN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WIN_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0fff) | ((value as u32) & 0x0fff);
                self.w
            }
        }
        impl R {
            ///Bits 0:11 - Watchdog counter window value
            #[inline(always)]
            pub fn win(&self) -> WIN_R {
                WIN_R::new((self.bits & 0x0fff) as u16)
            }
        }
        impl W {
            ///Bits 0:11 - Watchdog counter window value
            #[inline(always)]
            pub fn win(&mut self) -> WIN_W {
                WIN_W { w: self }
            }
        }
    }
}
///System window watchdog
pub struct WWDG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WWDG {}
impl WWDG {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const wwdg::RegisterBlock {
        0x4000_2c00 as *const _
    }
}
impl Deref for WWDG {
    type Target = wwdg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*WWDG::ptr() }
    }
}
///System window watchdog
pub mod wwdg {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - Control register
        pub cr: CR,
        ///0x04 - Configuration register
        pub cfr: CFR,
        ///0x08 - Status register
        pub sr: SR,
    }
    ///Control register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cr](cr) module
    pub type CR = crate::Reg<u32, _CR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CR;
    ///`read()` method returns [cr::R](cr::R) reader structure
    impl crate::Readable for CR {}
    ///`write(|w| ..)` method takes [cr::W](cr::W) writer structure
    impl crate::Writable for CR {}
    ///Control register
    pub mod cr {
        ///Reader of register CR
        pub type R = crate::R<u32, super::CR>;
        ///Writer for register CR
        pub type W = crate::W<u32, super::CR>;
        ///Register CR `reset()`'s with value 0x7f
        impl crate::ResetValue for super::CR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x7f
            }
        }
        ///Activation bit
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum WDGA_A {
            ///0: Watchdog disabled
            DISABLED = 0,
            ///1: Watchdog enabled
            ENABLED = 1,
        }
        impl From<WDGA_A> for bool {
            #[inline(always)]
            fn from(variant: WDGA_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `WDGA`
        pub type WDGA_R = crate::R<bool, WDGA_A>;
        impl WDGA_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> WDGA_A {
                match self.bits {
                    false => WDGA_A::DISABLED,
                    true => WDGA_A::ENABLED,
                }
            }
            ///Checks if the value of the field is `DISABLED`
            #[inline(always)]
            pub fn is_disabled(&self) -> bool {
                *self == WDGA_A::DISABLED
            }
            ///Checks if the value of the field is `ENABLED`
            #[inline(always)]
            pub fn is_enabled(&self) -> bool {
                *self == WDGA_A::ENABLED
            }
        }
        ///Write proxy for field `WDGA`
        pub struct WDGA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WDGA_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: WDGA_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///Watchdog disabled
            #[inline(always)]
            pub fn disabled(self) -> &'a mut W {
                self.variant(WDGA_A::DISABLED)
            }
            ///Watchdog enabled
            #[inline(always)]
            pub fn enabled(self) -> &'a mut W {
                self.variant(WDGA_A::ENABLED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `T`
        pub type T_R = crate::R<u8, u8>;
        ///Write proxy for field `T`
        pub struct T_W<'a> {
            w: &'a mut W,
        }
        impl<'a> T_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        impl R {
            ///Bit 7 - Activation bit
            #[inline(always)]
            pub fn wdga(&self) -> WDGA_R {
                WDGA_R::new(((self.bits >> 7) & 0x01) != 0)
            }
            ///Bits 0:6 - 7-bit counter (MSB to LSB)
            #[inline(always)]
            pub fn t(&self) -> T_R {
                T_R::new((self.bits & 0x7f) as u8)
            }
        }
        impl W {
            ///Bit 7 - Activation bit
            #[inline(always)]
            pub fn wdga(&mut self) -> WDGA_W {
                WDGA_W { w: self }
            }
            ///Bits 0:6 - 7-bit counter (MSB to LSB)
            #[inline(always)]
            pub fn t(&mut self) -> T_W {
                T_W { w: self }
            }
        }
    }
    ///Configuration register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [cfr](cfr) module
    pub type CFR = crate::Reg<u32, _CFR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _CFR;
    ///`read()` method returns [cfr::R](cfr::R) reader structure
    impl crate::Readable for CFR {}
    ///`write(|w| ..)` method takes [cfr::W](cfr::W) writer structure
    impl crate::Writable for CFR {}
    ///Configuration register
    pub mod cfr {
        ///Reader of register CFR
        pub type R = crate::R<u32, super::CFR>;
        ///Writer for register CFR
        pub type W = crate::W<u32, super::CFR>;
        ///Register CFR `reset()`'s with value 0x7f
        impl crate::ResetValue for super::CFR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0x7f
            }
        }
        ///Early wakeup interrupt
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EWI_A {
            ///1: interrupt occurs whenever the counter reaches the value 0x40
            ENABLE = 1,
        }
        impl From<EWI_A> for bool {
            #[inline(always)]
            fn from(variant: EWI_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EWI`
        pub type EWI_R = crate::R<bool, EWI_A>;
        impl EWI_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> crate::Variant<bool, EWI_A> {
                use crate::Variant::*;
                match self.bits {
                    true => Val(EWI_A::ENABLE),
                    i => Res(i),
                }
            }
            ///Checks if the value of the field is `ENABLE`
            #[inline(always)]
            pub fn is_enable(&self) -> bool {
                *self == EWI_A::ENABLE
            }
        }
        ///Write proxy for field `EWI`
        pub struct EWI_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EWI_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EWI_A) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///interrupt occurs whenever the counter reaches the value 0x40
            #[inline(always)]
            pub fn enable(self) -> &'a mut W {
                self.variant(EWI_A::ENABLE)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
                self.w
            }
        }
        ///Reader of field `W`
        pub type W_R = crate::R<u8, u8>;
        ///Write proxy for field `W`
        pub struct W_W<'a> {
            w: &'a mut W,
        }
        impl<'a> W_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | ((value as u32) & 0x7f);
                self.w
            }
        }
        ///Timer base
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        #[repr(u8)]
        pub enum WDGTB_A {
            ///0: Counter clock (PCLK1 div 4096) div 1
            DIV1 = 0,
            ///1: Counter clock (PCLK1 div 4096) div 2
            DIV2 = 1,
            ///2: Counter clock (PCLK1 div 4096) div 4
            DIV4 = 2,
            ///3: Counter clock (PCLK1 div 4096) div 8
            DIV8 = 3,
        }
        impl From<WDGTB_A> for u8 {
            #[inline(always)]
            fn from(variant: WDGTB_A) -> Self {
                variant as _
            }
        }
        ///Reader of field `WDGTB`
        pub type WDGTB_R = crate::R<u8, WDGTB_A>;
        impl WDGTB_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> WDGTB_A {
                match self.bits {
                    0 => WDGTB_A::DIV1,
                    1 => WDGTB_A::DIV2,
                    2 => WDGTB_A::DIV4,
                    3 => WDGTB_A::DIV8,
                    _ => unreachable!(),
                }
            }
            ///Checks if the value of the field is `DIV1`
            #[inline(always)]
            pub fn is_div1(&self) -> bool {
                *self == WDGTB_A::DIV1
            }
            ///Checks if the value of the field is `DIV2`
            #[inline(always)]
            pub fn is_div2(&self) -> bool {
                *self == WDGTB_A::DIV2
            }
            ///Checks if the value of the field is `DIV4`
            #[inline(always)]
            pub fn is_div4(&self) -> bool {
                *self == WDGTB_A::DIV4
            }
            ///Checks if the value of the field is `DIV8`
            #[inline(always)]
            pub fn is_div8(&self) -> bool {
                *self == WDGTB_A::DIV8
            }
        }
        ///Write proxy for field `WDGTB`
        pub struct WDGTB_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WDGTB_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: WDGTB_A) -> &'a mut W {
                {
                    self.bits(variant.into())
                }
            }
            ///Counter clock (PCLK1 div 4096) div 1
            #[inline(always)]
            pub fn div1(self) -> &'a mut W {
                self.variant(WDGTB_A::DIV1)
            }
            ///Counter clock (PCLK1 div 4096) div 2
            #[inline(always)]
            pub fn div2(self) -> &'a mut W {
                self.variant(WDGTB_A::DIV2)
            }
            ///Counter clock (PCLK1 div 4096) div 4
            #[inline(always)]
            pub fn div4(self) -> &'a mut W {
                self.variant(WDGTB_A::DIV4)
            }
            ///Counter clock (PCLK1 div 4096) div 8
            #[inline(always)]
            pub fn div8(self) -> &'a mut W {
                self.variant(WDGTB_A::DIV8)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 7)) | (((value as u32) & 0x03) << 7);
                self.w
            }
        }
        impl R {
            ///Bit 9 - Early wakeup interrupt
            #[inline(always)]
            pub fn ewi(&self) -> EWI_R {
                EWI_R::new(((self.bits >> 9) & 0x01) != 0)
            }
            ///Bits 0:6 - 7-bit window value
            #[inline(always)]
            pub fn w(&self) -> W_R {
                W_R::new((self.bits & 0x7f) as u8)
            }
            ///Bits 7:8 - Timer base
            #[inline(always)]
            pub fn wdgtb(&self) -> WDGTB_R {
                WDGTB_R::new(((self.bits >> 7) & 0x03) as u8)
            }
        }
        impl W {
            ///Bit 9 - Early wakeup interrupt
            #[inline(always)]
            pub fn ewi(&mut self) -> EWI_W {
                EWI_W { w: self }
            }
            ///Bits 0:6 - 7-bit window value
            #[inline(always)]
            pub fn w(&mut self) -> W_W {
                W_W { w: self }
            }
            ///Bits 7:8 - Timer base
            #[inline(always)]
            pub fn wdgtb(&mut self) -> WDGTB_W {
                WDGTB_W { w: self }
            }
        }
    }
    ///Status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [sr](sr) module
    pub type SR = crate::Reg<u32, _SR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _SR;
    ///`read()` method returns [sr::R](sr::R) reader structure
    impl crate::Readable for SR {}
    ///`write(|w| ..)` method takes [sr::W](sr::W) writer structure
    impl crate::Writable for SR {}
    ///Status register
    pub mod sr {
        ///Reader of register SR
        pub type R = crate::R<u32, super::SR>;
        ///Writer for register SR
        pub type W = crate::W<u32, super::SR>;
        ///Register SR `reset()`'s with value 0
        impl crate::ResetValue for super::SR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Early wakeup interrupt flag
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EWIF_A {
            ///1: The EWI Interrupt Service Routine has been triggered
            PENDING = 1,
            ///0: The EWI Interrupt Service Routine has been serviced
            FINISHED = 0,
        }
        impl From<EWIF_A> for bool {
            #[inline(always)]
            fn from(variant: EWIF_A) -> Self {
                variant as u8 != 0
            }
        }
        ///Reader of field `EWIF`
        pub type EWIF_R = crate::R<bool, EWIF_A>;
        impl EWIF_R {
            ///Get enumerated values variant
            #[inline(always)]
            pub fn variant(&self) -> EWIF_A {
                match self.bits {
                    true => EWIF_A::PENDING,
                    false => EWIF_A::FINISHED,
                }
            }
            ///Checks if the value of the field is `PENDING`
            #[inline(always)]
            pub fn is_pending(&self) -> bool {
                *self == EWIF_A::PENDING
            }
            ///Checks if the value of the field is `FINISHED`
            #[inline(always)]
            pub fn is_finished(&self) -> bool {
                *self == EWIF_A::FINISHED
            }
        }
        ///Early wakeup interrupt flag
        ///
        ///Value on reset: 0
        #[derive(Clone, Copy, Debug, PartialEq)]
        pub enum EWIF_AW {
            ///0: The EWI Interrupt Service Routine has been serviced
            FINISHED = 0,
        }
        impl From<EWIF_AW> for bool {
            #[inline(always)]
            fn from(variant: EWIF_AW) -> Self {
                variant as u8 != 0
            }
        }
        ///Write proxy for field `EWIF`
        pub struct EWIF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EWIF_W<'a> {
            ///Writes `variant` to the field
            #[inline(always)]
            pub fn variant(self, variant: EWIF_AW) -> &'a mut W {
                {
                    self.bit(variant.into())
                }
            }
            ///The EWI Interrupt Service Routine has been serviced
            #[inline(always)]
            pub fn finished(self) -> &'a mut W {
                self.variant(EWIF_AW::FINISHED)
            }
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        impl R {
            ///Bit 0 - Early wakeup interrupt flag
            #[inline(always)]
            pub fn ewif(&self) -> EWIF_R {
                EWIF_R::new((self.bits & 0x01) != 0)
            }
        }
        impl W {
            ///Bit 0 - Early wakeup interrupt flag
            #[inline(always)]
            pub fn ewif(&mut self) -> EWIF_W {
                EWIF_W { w: self }
            }
        }
    }
}
///Comparator
pub struct COMP {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for COMP {}
impl COMP {
    ///Returns a pointer to the register block
    #[inline(always)]
    pub const fn ptr() -> *const comp::RegisterBlock {
        0x4001_0200 as *const _
    }
}
impl Deref for COMP {
    type Target = comp::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*COMP::ptr() }
    }
}
///Comparator
pub mod comp {
    ///Register block
    #[repr(C)]
    pub struct RegisterBlock {
        ///0x00 - Comparator 1 control and status register
        pub comp1_csr: COMP1_CSR,
        ///0x04 - Comparator 2 control and status register
        pub comp2_csr: COMP2_CSR,
    }
    ///Comparator 1 control and status register
    ///
    ///This register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).
    ///
    ///For information about available fields see [comp1_csr](comp1_csr) module
    pub type COMP1_CSR = crate::Reg<u32, _COMP1_CSR>;
    #[allow(missing_docs)]
    #[doc(hidden)]
    pub struct _COMP1_CSR;
    ///`read()` method returns [comp1_csr::R](comp1_csr::R) reader structure
    impl crate::Readable for COMP1_CSR {}
    ///`write(|w| ..)` method takes [comp1_csr::W](comp1_csr::W) writer structure
    impl crate::Writable for COMP1_CSR {}
    ///Comparator 1 control and status register
    pub mod comp1_csr {
        ///Reader of register COMP1_CSR
        pub type R = crate::R<u32, super::COMP1_CSR>;
        ///Writer for register COMP1_CSR
        pub type W = crate::W<u32, super::COMP1_CSR>;
        ///Register COMP1_CSR `reset()`'s with value 0
        impl crate::ResetValue for super::COMP1_CSR {
            type Type = u32;
            #[inline(always)]
            fn reset_value() -> Self::Type {
                0
            }
        }
        ///Reader of field `COMP1_EN`
        pub type COMP1_EN_R = crate::R<bool, bool>;
        ///Write proxy for field `COMP1_EN`
        pub struct COMP1_EN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COMP1_EN_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
                self.w
            }
        }
        ///Reader of field `COMP1_PWRMODE`
        pub type COMP1_PWRMODE_R = crate::R<u8, u8>;
        ///Write proxy for field `COMP1_PWRMODE`
        pub struct COMP1_PWRMODE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COMP1_PWRMODE_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 2)) | (((value as u32) & 0x03) << 2);
                self.w
            }
        }
        ///Reader of field `COMP1_INMSEL`
        pub type COMP1_INMSEL_R = crate::R<u8, u8>;
        ///Write proxy for field `COMP1_INMSEL`
        pub struct COMP1_INMSEL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COMP1_INMSEL_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07 << 4)) | (((value as u32) & 0x07) << 4);
                self.w
            }
        }
        ///Reader of field `COMP1_INPSEL`
        pub type COMP1_INPSEL_R = crate::R<bool, bool>;
        ///Write proxy for field `COMP1_INPSEL`
        pub struct COMP1_INPSEL_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COMP1_INPSEL_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
                self.w
            }
        }
        ///Reader of field `COMP1_POLARITY`
        pub type COMP1_POLARITY_R = crate::R<bool, bool>;
        ///Write proxy for field `COMP1_POLARITY`
        pub struct COMP1_POLARITY_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COMP1_POLARITY_W<'a> {
            ///Sets the field bit
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            ///Clears the field bit
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            ///Writes raw bits to the field
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x01 << 15)) | (((value as u32) & 0x01) << 15);
                self.w
            }
        }
        ///Reader of field `COMP1_HYST`
        pub type COMP1_HYST_R = crate::R<u8, u8>;
        ///Write proxy for field `COMP1_HYST`
        pub struct COMP1_HYST_W<'a> {
            w: &'a mut W,
        }
        impl<'a> COMP1_HYST_W<'a> {
            ///Writes raw bits to the field
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x03 << 16)) | (((value as u32) & 0x03) << 16);
                self.w
            }
        }
        ///Reader of field