# stm32f3
This crate provides an autogenerated API for access to STM32F3 peripherals.
The API is generated using [svd2rust] with patched svd files containing
extensive type-safe support. For more information please see the [main repo].

Refer to the [documentation] for full details.

[svd2rust]: https://github.com/japaric/svd2rust
[main repo]: https://github.com/stm32-rs/stm32-rs
[documentation]: https://docs.rs/stm32f3/latest/stm32f3/

## Usage
Each device supported by this crate is behind a feature gate so that you only
compile the device(s) you want. To use, in your Cargo.toml:

```toml
[dependencies.stm32f3]
version = "0.14.0"
features = ["stm32f301", "rt"]
```

The `rt` feature is optional and brings in support for `cortex-m-rt`.

In your code:

```rust
use stm32f3::stm32f301;

let mut peripherals = stm32f301::Peripherals::take().unwrap();
let gpioa = &peripherals.GPIOA;
gpioa.odr.modify(|_, w| w.odr0().set_bit());
```

For full details on the autogenerated API, please see:
https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api

## Supported Devices

| Module | Devices | Links |
|:------:|:-------:|:-----:|
| stm32f301 | STM32F301, STM32F318 | [RM0366](https://www.st.com/resource/en/reference_manual/dm00094350.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f301.html) |
| stm32f302 | STM32F302 | [RM0365](https://www.st.com/resource/en/reference_manual/dm00094349.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f302.html) |
| stm32f303 | STM32F303, STM32F328, STM32F358, STM32F398 | [RM0316](https://www.st.com/resource/en/reference_manual/dm00043574.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f303.html) |
| stm32f373 | STM32F373, STM32F378 | [RM0313](https://www.st.com/resource/en/reference_manual/dm00041563.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f373.html) |
| stm32f3x4 | STM32F334 | [RM0364](https://www.st.com/resource/en/reference_manual/dm00093941.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f334.html) |
