#[doc = "Register `FS_GCCFG` reader"]
pub struct R(crate::R<FS_GCCFG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<FS_GCCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<FS_GCCFG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<FS_GCCFG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `FS_GCCFG` writer"]
pub struct W(crate::W<FS_GCCFG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<FS_GCCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<FS_GCCFG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<FS_GCCFG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PWRDWN` reader - Power down"]
pub struct PWRDWN_R(crate::FieldReader<bool, bool>);
impl PWRDWN_R {
    pub(crate) fn new(bits: bool) -> Self {
        PWRDWN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PWRDWN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PWRDWN` writer - Power down"]
pub struct PWRDWN_W<'a> {
    w: &'a mut W,
}
impl<'a> PWRDWN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `VBUSASEN` reader - Enable the VBUS sensing device"]
pub struct VBUSASEN_R(crate::FieldReader<bool, bool>);
impl VBUSASEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        VBUSASEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VBUSASEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VBUSASEN` writer - Enable the VBUS sensing device"]
pub struct VBUSASEN_W<'a> {
    w: &'a mut W,
}
impl<'a> VBUSASEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `VBUSBSEN` reader - Enable the VBUS sensing device"]
pub struct VBUSBSEN_R(crate::FieldReader<bool, bool>);
impl VBUSBSEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        VBUSBSEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VBUSBSEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VBUSBSEN` writer - Enable the VBUS sensing device"]
pub struct VBUSBSEN_W<'a> {
    w: &'a mut W,
}
impl<'a> VBUSBSEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Field `SOFOUTEN` reader - SOF output enable"]
pub struct SOFOUTEN_R(crate::FieldReader<bool, bool>);
impl SOFOUTEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SOFOUTEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SOFOUTEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SOFOUTEN` writer - SOF output enable"]
pub struct SOFOUTEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SOFOUTEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
impl R {
    #[doc = "Bit 16 - Power down"]
    #[inline(always)]
    pub fn pwrdwn(&self) -> PWRDWN_R {
        PWRDWN_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Enable the VBUS sensing device"]
    #[inline(always)]
    pub fn vbusasen(&self) -> VBUSASEN_R {
        VBUSASEN_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Enable the VBUS sensing device"]
    #[inline(always)]
    pub fn vbusbsen(&self) -> VBUSBSEN_R {
        VBUSBSEN_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - SOF output enable"]
    #[inline(always)]
    pub fn sofouten(&self) -> SOFOUTEN_R {
        SOFOUTEN_R::new(((self.bits >> 20) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 16 - Power down"]
    #[inline(always)]
    pub fn pwrdwn(&mut self) -> PWRDWN_W {
        PWRDWN_W { w: self }
    }
    #[doc = "Bit 18 - Enable the VBUS sensing device"]
    #[inline(always)]
    pub fn vbusasen(&mut self) -> VBUSASEN_W {
        VBUSASEN_W { w: self }
    }
    #[doc = "Bit 19 - Enable the VBUS sensing device"]
    #[inline(always)]
    pub fn vbusbsen(&mut self) -> VBUSBSEN_W {
        VBUSBSEN_W { w: self }
    }
    #[doc = "Bit 20 - SOF output enable"]
    #[inline(always)]
    pub fn sofouten(&mut self) -> SOFOUTEN_W {
        SOFOUTEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "OTG_FS general core configuration register (OTG_FS_GCCFG)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fs_gccfg](index.html) module"]
pub struct FS_GCCFG_SPEC;
impl crate::RegisterSpec for FS_GCCFG_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [fs_gccfg::R](R) reader structure"]
impl crate::Readable for FS_GCCFG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [fs_gccfg::W](W) writer structure"]
impl crate::Writable for FS_GCCFG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets FS_GCCFG to value 0"]
impl crate::Resettable for FS_GCCFG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
