# stm32f2
This crate provides an autogenerated API for access to STM32F2 peripherals.
The API is generated using [svd2rust] with patched svd files containing
extensive type-safe support. For more information please see the [main repo].

Refer to the [documentation] for full details.

[svd2rust]: https://github.com/japaric/svd2rust
[main repo]: https://github.com/stm32-rs/stm32-rs
[documentation]: https://docs.rs/stm32f2/latest/stm32f2/

## Usage
Each device supported by this crate is behind a feature gate so that you only
compile the device(s) you want. To use, in your Cargo.toml:

```toml
[dependencies.stm32f2]
version = "0.14.0"
features = ["stm32f215", "rt"]
```

The `rt` feature is optional and brings in support for `cortex-m-rt`.

In your code:

```rust
use stm32f2::stm32f215;

let mut peripherals = stm32f215::Peripherals::take().unwrap();
let gpioa = &peripherals.GPIOA;
gpioa.odr.modify(|_, w| w.odr0().set_bit());
```

For full details on the autogenerated API, please see:
https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api

## Supported Devices

| Module | Devices | Links |
|:------:|:-------:|:-----:|
| stm32f215 | STM32F205, STM32F215 | [RM0033](https://www.st.com/resource/en/reference_manual/cd00225773.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f2x5.html) |
| stm32f217 | STM32F207, STM32F217 | [RM0033](https://www.st.com/resource/en/reference_manual/cd00225773.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f2x7.html) |
