# stm32f1
This crate provides an autogenerated API for access to STM32F1 peripherals.
The API is generated using [svd2rust] with patched svd files containing
extensive type-safe support. For more information please see the [main repo].

Refer to the [documentation] for full details.

[svd2rust]: https://github.com/japaric/svd2rust
[main repo]: https://github.com/stm32-rs/stm32-rs
[documentation]: https://docs.rs/stm32f1/latest/stm32f1/

## Usage
Each device supported by this crate is behind a feature gate so that you only
compile the device(s) you want. To use, in your Cargo.toml:

```toml
[dependencies.stm32f1]
version = "0.14.0"
features = ["stm32f100", "rt"]
```

The `rt` feature is optional and brings in support for `cortex-m-rt`.

In your code:

```rust
use stm32f1::stm32f100;

let mut peripherals = stm32f100::Peripherals::take().unwrap();
let gpioa = &peripherals.GPIOA;
gpioa.odr.modify(|_, w| w.odr0().set_bit());
```

For full details on the autogenerated API, please see:
https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api

## Supported Devices

| Module | Devices | Links |
|:------:|:-------:|:-----:|
| stm32f100 | STM32F100 | [RM0041](https://www.st.com/resource/en/reference_manual/cd00246267.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f100-value-line.html) |
| stm32f101 | STM32F101 | [RM0008](https://www.st.com/resource/en/reference_manual/cd00171190.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f101.html) |
| stm32f102 | STM32F102 | [RM0008](https://www.st.com/resource/en/reference_manual/cd00171190.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f102.html) |
| stm32f103 | STM32F103 | [RM0008](https://www.st.com/resource/en/reference_manual/cd00171190.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f103.html) |
| stm32f107 | STM32F105, STM32F107 | [RM0008](https://www.st.com/resource/en/reference_manual/cd00171190.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f105-107.html) |
