# stm32f0
This crate provides an autogenerated API for access to STM32F0 peripherals.
The API is generated using [svd2rust] with patched svd files containing
extensive type-safe support. For more information please see the [main repo].

Refer to the [documentation] for full details.

[svd2rust]: https://github.com/japaric/svd2rust
[main repo]: https://github.com/stm32-rs/stm32-rs
[documentation]: https://docs.rs/stm32f0/latest/stm32f0/

## Usage
Each device supported by this crate is behind a feature gate so that you only
compile the device(s) you want. To use, in your Cargo.toml:

```toml
[dependencies.stm32f0]
version = "0.14.0"
features = ["stm32f0x0", "rt"]
```

The `rt` feature is optional and brings in support for `cortex-m-rt`.

In your code:

```rust
use stm32f0::stm32f0x0;

let mut peripherals = stm32f0x0::Peripherals::take().unwrap();
let gpioa = &peripherals.GPIOA;
gpioa.odr.modify(|_, w| w.odr0().set_bit());
```

For full details on the autogenerated API, please see:
https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api

## Supported Devices

| Module | Devices | Links |
|:------:|:-------:|:-----:|
| stm32f0x0 | STM32F030, STM32F070 | [RM0360](https://www.st.com/resource/en/reference_manual/dm00091010.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f0x0-value-line.html) |
| stm32f0x1 | STM32F031, STM32F051, STM32F071, STM32F091 | [RM0091](https://www.st.com/resource/en/reference_manual/dm00031936.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f0x1.html) |
| stm32f0x2 | STM32F042, STM32F072 | [RM0091](https://www.st.com/resource/en/reference_manual/dm00031936.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f0x2.html) |
| stm32f0x8 | STM32F038, STM32F048, STM32F058, STM32F078, STM32F098 | [RM0091](https://www.st.com/resource/en/reference_manual/dm00031936.pdf), [st.com](https://www.st.com/en/microcontrollers-microprocessors/stm32f0x8.html) |
