

# [doc = "Window watchdog"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wwdg (pub * mut u8) ; unsafe impl Send for Wwdg { } unsafe impl Sync for Wwdg { } impl Wwdg { # [doc = "Control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Configuration register"]
pub fn cfr (self) -> crate :: common :: Reg < regs :: Cfr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } } pub mod regs { # [doc = "Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Early wakeup interrupt flag"]
pub const fn ewif (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Early wakeup interrupt flag"]
pub fn set_ewif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "Control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "7-bit counter (MSB to LSB)"]
pub const fn t (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x7f ; val as u8 } # [doc = "7-bit counter (MSB to LSB)"]
pub fn set_t (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 0usize)) | (((val as u32) & 0x7f) << 0usize) ; } # [doc = "Activation bit"]
pub const fn wdga (& self) -> super :: vals :: Wdga { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Wdga (val as u8) } # [doc = "Activation bit"]
pub fn set_wdga (& mut self , val : super :: vals :: Wdga) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfr (pub u32) ; impl Cfr { # [doc = "7-bit window value"]
pub const fn w (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x7f ; val as u8 } # [doc = "7-bit window value"]
pub fn set_w (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 0usize)) | (((val as u32) & 0x7f) << 0usize) ; } # [doc = "Timer base"]
pub const fn wdgtb (& self) -> super :: vals :: Wdgtb { let val = (self . 0 >> 7usize) & 0x03 ; super :: vals :: Wdgtb (val as u8) } # [doc = "Timer base"]
pub fn set_wdgtb (& mut self , val : super :: vals :: Wdgtb) { self . 0 = (self . 0 & ! (0x03 << 7usize)) | (((val . 0 as u32) & 0x03) << 7usize) ; } # [doc = "Early wakeup interrupt"]
pub const fn ewi (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Early wakeup interrupt"]
pub fn set_ewi (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for Cfr { fn default () -> Cfr { Cfr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wdgtb (pub u8) ; impl Wdgtb { # [doc = "Counter clock (PCLK1 div 4096) div 1"]
pub const DIV1 : Self = Self (0) ; # [doc = "Counter clock (PCLK1 div 4096) div 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "Counter clock (PCLK1 div 4096) div 4"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "Counter clock (PCLK1 div 4096) div 8"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ewifr (pub u8) ; impl Ewifr { # [doc = "The EWI Interrupt Service Routine has been serviced"]
pub const FINISHED : Self = Self (0) ; # [doc = "The EWI Interrupt Service Routine has been triggered"]
pub const PENDING : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wdga (pub u8) ; impl Wdga { # [doc = "Watchdog disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Watchdog enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ewiw (pub u8) ; impl Ewiw { # [doc = "interrupt occurs whenever the counter reaches the value 0x40"]
pub const ENABLE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ewifw (pub u8) ; impl Ewifw { # [doc = "The EWI Interrupt Service Routine has been serviced"]
pub const FINISHED : Self = Self (0) ; } }