

# [doc = "Universal synchronous asynchronous receiver transmitter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Usart (pub * mut u8) ; unsafe impl Send for Usart { } unsafe impl Sync for Usart { } impl Usart { # [doc = "Control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Control register 3"]
pub fn cr3 (self) -> crate :: common :: Reg < regs :: Cr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Baud rate register"]
pub fn brr (self) -> crate :: common :: Reg < regs :: Brr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Guard time and prescaler register"]
pub fn gtpr (self) -> crate :: common :: Reg < regs :: Gtpr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Receiver timeout register"]
pub fn rtor (self) -> crate :: common :: Reg < regs :: Rtor , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Request register"]
pub fn rqr (self) -> crate :: common :: Reg < regs :: Rqr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Interrupt & status register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Ixr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Interrupt flag clear register"]
pub fn icr (self) -> crate :: common :: Reg < regs :: Ixr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Receive data register"]
pub fn rdr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "Transmit data register"]
pub fn tdr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } } pub mod regs { # [doc = "Data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Data value"]
pub const fn dr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Data value"]
pub fn set_dr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "Request register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rqr (pub u32) ; impl Rqr { # [doc = "Auto baud rate request. Resets the ABRF flag in the USART_ISR and request an automatic baud rate measurement on the next received data frame."]
pub const fn abrrq (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Auto baud rate request. Resets the ABRF flag in the USART_ISR and request an automatic baud rate measurement on the next received data frame."]
pub fn set_abrrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Send break request. Sets the SBKF flag and request to send a BREAK on the line, as soon as the transmit machine is available"]
pub const fn sbkrq (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Send break request. Sets the SBKF flag and request to send a BREAK on the line, as soon as the transmit machine is available"]
pub fn set_sbkrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Mute mode request. Puts the USART in mute mode and sets the RWU flag."]
pub const fn mmrq (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Mute mode request. Puts the USART in mute mode and sets the RWU flag."]
pub fn set_mmrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Receive data flush request. Clears the RXNE flag. This allows to discard the received data without reading it, and avoid an overrun condition"]
pub const fn rxfrq (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Receive data flush request. Clears the RXNE flag. This allows to discard the received data without reading it, and avoid an overrun condition"]
pub fn set_rxfrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Transmit data flush request. Sets the TXE flags. This allows to discard the transmit data."]
pub const fn txfrq (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Transmit data flush request. Sets the TXE flags. This allows to discard the transmit data."]
pub fn set_txfrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Rqr { fn default () -> Rqr { Rqr (0) } } # [doc = "Guard time and prescaler register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gtpr (pub u32) ; impl Gtpr { # [doc = "Prescaler value"]
pub const fn psc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Prescaler value"]
pub fn set_psc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Guard time value"]
pub const fn gt (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Guard time value"]
pub fn set_gt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } } impl Default for Gtpr { fn default () -> Gtpr { Gtpr (0) } } # [doc = "Control register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr3 (pub u32) ; impl Cr3 { # [doc = "Error interrupt enable"]
pub const fn eie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_eie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IrDA mode enable"]
pub const fn iren (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IrDA mode enable"]
pub fn set_iren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IrDA low-power"]
pub const fn irlp (& self) -> super :: vals :: Irlp { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Irlp (val as u8) } # [doc = "IrDA low-power"]
pub fn set_irlp (& mut self , val : super :: vals :: Irlp) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Half-duplex selection"]
pub const fn hdsel (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Half-duplex selection"]
pub fn set_hdsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Smartcard NACK enable"]
pub const fn nack (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Smartcard NACK enable"]
pub fn set_nack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Smartcard mode enable"]
pub const fn scen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Smartcard mode enable"]
pub fn set_scen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "DMA enable receiver"]
pub const fn dmar (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "DMA enable receiver"]
pub fn set_dmar (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "DMA enable transmitter"]
pub const fn dmat (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "DMA enable transmitter"]
pub fn set_dmat (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "RTS enable"]
pub const fn rtse (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "RTS enable"]
pub fn set_rtse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CTS enable"]
pub const fn ctse (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CTS enable"]
pub fn set_ctse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CTS interrupt enable"]
pub const fn ctsie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CTS interrupt enable"]
pub fn set_ctsie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "One sample bit method enable"]
pub const fn onebit (& self) -> super :: vals :: Onebit { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Onebit (val as u8) } # [doc = "One sample bit method enable"]
pub fn set_onebit (& mut self , val : super :: vals :: Onebit) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Overrun Disable"]
pub const fn ovrdis (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Overrun Disable"]
pub fn set_ovrdis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DMA Disable on Reception Error"]
pub const fn ddre (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DMA Disable on Reception Error"]
pub fn set_ddre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Driver enable mode"]
pub const fn dem (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Driver enable mode"]
pub fn set_dem (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Driver enable polarity selection"]
pub const fn dep (& self) -> super :: vals :: Dep { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Dep (val as u8) } # [doc = "Driver enable polarity selection"]
pub fn set_dep (& mut self , val : super :: vals :: Dep) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Smartcard auto-retry count"]
pub const fn scarcnt (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x07 ; val as u8 } # [doc = "Smartcard auto-retry count"]
pub fn set_scarcnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 17usize)) | (((val as u32) & 0x07) << 17usize) ; } # [doc = "Wakeup from Stop mode interrupt flag selection"]
pub const fn wus (& self) -> super :: vals :: Wus { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Wus (val as u8) } # [doc = "Wakeup from Stop mode interrupt flag selection"]
pub fn set_wus (& mut self , val : super :: vals :: Wus) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "Wakeup from Stop mode interrupt enable"]
pub const fn wufie (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Wakeup from Stop mode interrupt enable"]
pub fn set_wufie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Cr3 { fn default () -> Cr3 { Cr3 (0) } } # [doc = "Control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "USART enable"]
pub const fn ue (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "USART enable"]
pub fn set_ue (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "USART enable in Stop mode"]
pub const fn uesm (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "USART enable in Stop mode"]
pub fn set_uesm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Receiver enable"]
pub const fn re (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Receiver enable"]
pub fn set_re (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Transmitter enable"]
pub const fn te (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Transmitter enable"]
pub fn set_te (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IDLE interrupt enable"]
pub const fn idleie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IDLE interrupt enable"]
pub fn set_idleie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RXNE interrupt enable"]
pub const fn rxneie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RXNE interrupt enable"]
pub fn set_rxneie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Transmission complete interrupt enable"]
pub const fn tcie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transmission complete interrupt enable"]
pub fn set_tcie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TXE interrupt enable"]
pub const fn txeie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TXE interrupt enable"]
pub fn set_txeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "PE interrupt enable"]
pub const fn peie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "PE interrupt enable"]
pub fn set_peie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Parity selection"]
pub const fn ps (& self) -> super :: vals :: Ps { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Ps (val as u8) } # [doc = "Parity selection"]
pub fn set_ps (& mut self , val : super :: vals :: Ps) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Parity control enable"]
pub const fn pce (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Parity control enable"]
pub fn set_pce (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Receiver wakeup method"]
pub const fn wake (& self) -> super :: vals :: Wake { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Wake (val as u8) } # [doc = "Receiver wakeup method"]
pub fn set_wake (& mut self , val : super :: vals :: Wake) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Word length"]
pub const fn m0 (& self) -> super :: vals :: M0 { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: M0 (val as u8) } # [doc = "Word length"]
pub fn set_m0 (& mut self , val : super :: vals :: M0) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Mute mode enable"]
pub const fn mme (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Mute mode enable"]
pub fn set_mme (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Character match interrupt enable"]
pub const fn cmie (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Character match interrupt enable"]
pub fn set_cmie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Oversampling mode"]
pub fn over (& self , n : usize) -> super :: vals :: Over { assert ! (n < 1usize) ; let offs = 15usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Over (val as u8) } # [doc = "Oversampling mode"]
pub fn set_over (& mut self , n : usize , val : super :: vals :: Over) { assert ! (n < 1usize) ; let offs = 15usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Driver Enable deassertion time"]
pub const fn dedt (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x1f ; val as u8 } # [doc = "Driver Enable deassertion time"]
pub fn set_dedt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 16usize)) | (((val as u32) & 0x1f) << 16usize) ; } # [doc = "Driver Enable assertion time"]
pub const fn deat (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x1f ; val as u8 } # [doc = "Driver Enable assertion time"]
pub fn set_deat (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 21usize)) | (((val as u32) & 0x1f) << 21usize) ; } # [doc = "Receiver timeout interrupt enable"]
pub const fn rtoie (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Receiver timeout interrupt enable"]
pub fn set_rtoie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "End of Block interrupt enable"]
pub const fn eobie (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "End of Block interrupt enable"]
pub fn set_eobie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Word length"]
pub const fn m1 (& self) -> super :: vals :: M1 { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: M1 (val as u8) } # [doc = "Word length"]
pub fn set_m1 (& mut self , val : super :: vals :: M1) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "Control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "7-bit Address Detection/4-bit Address Detection"]
pub fn addm (& self , n : usize) -> super :: vals :: Addm { assert ! (n < 1usize) ; let offs = 4usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Addm (val as u8) } # [doc = "7-bit Address Detection/4-bit Address Detection"]
pub fn set_addm (& mut self , n : usize , val : super :: vals :: Addm) { assert ! (n < 1usize) ; let offs = 4usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Line break detection length"]
pub const fn lbdl (& self) -> super :: vals :: Lbdl { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Lbdl (val as u8) } # [doc = "Line break detection length"]
pub fn set_lbdl (& mut self , val : super :: vals :: Lbdl) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "LIN break detection interrupt enable"]
pub const fn lbdie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LIN break detection interrupt enable"]
pub fn set_lbdie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Last bit clock pulse"]
pub const fn lbcl (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Last bit clock pulse"]
pub fn set_lbcl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Clock phase"]
pub const fn cpha (& self) -> super :: vals :: Cpha { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Cpha (val as u8) } # [doc = "Clock phase"]
pub fn set_cpha (& mut self , val : super :: vals :: Cpha) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Clock polarity"]
pub const fn cpol (& self) -> super :: vals :: Cpol { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Cpol (val as u8) } # [doc = "Clock polarity"]
pub fn set_cpol (& mut self , val : super :: vals :: Cpol) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Clock enable"]
pub const fn clken (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Clock enable"]
pub fn set_clken (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "STOP bits"]
pub const fn stop (& self) -> super :: vals :: Stop { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Stop (val as u8) } # [doc = "STOP bits"]
pub fn set_stop (& mut self , val : super :: vals :: Stop) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "LIN mode enable"]
pub const fn linen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "LIN mode enable"]
pub fn set_linen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Swap TX/RX pins"]
pub const fn swap (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Swap TX/RX pins"]
pub fn set_swap (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "RX pin active level inversion"]
pub const fn rxinv (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "RX pin active level inversion"]
pub fn set_rxinv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TX pin active level inversion"]
pub const fn txinv (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TX pin active level inversion"]
pub fn set_txinv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Binary data inversion"]
pub const fn datainv (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Binary data inversion"]
pub fn set_datainv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Most significant bit first"]
pub const fn msbfirst (& self) -> super :: vals :: Msbfirst { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: Msbfirst (val as u8) } # [doc = "Most significant bit first"]
pub fn set_msbfirst (& mut self , val : super :: vals :: Msbfirst) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "Auto baud rate enable"]
pub const fn abren (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Auto baud rate enable"]
pub fn set_abren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Auto baud rate mode"]
pub const fn abrmod (& self) -> super :: vals :: Abrmod { let val = (self . 0 >> 21usize) & 0x03 ; super :: vals :: Abrmod (val as u8) } # [doc = "Auto baud rate mode"]
pub fn set_abrmod (& mut self , val : super :: vals :: Abrmod) { self . 0 = (self . 0 & ! (0x03 << 21usize)) | (((val . 0 as u32) & 0x03) << 21usize) ; } # [doc = "Receiver timeout enable"]
pub const fn rtoen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Receiver timeout enable"]
pub fn set_rtoen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Address of the USART node"]
pub const fn add (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Address of the USART node"]
pub fn set_add (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "Interrupt & status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ixr (pub u32) ; impl Ixr { # [doc = "Parity error"]
pub const fn pe (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Parity error"]
pub fn set_pe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Framing error"]
pub const fn fe (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Framing error"]
pub fn set_fe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Noise error flag"]
pub const fn ne (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Noise error flag"]
pub fn set_ne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Overrun error"]
pub const fn ore (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Overrun error"]
pub fn set_ore (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Idle line detected"]
pub const fn idle (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Idle line detected"]
pub fn set_idle (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Read data register not empty"]
pub const fn rxne (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Read data register not empty"]
pub fn set_rxne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Transmission complete"]
pub const fn tc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transmission complete"]
pub fn set_tc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Transmit data register empty"]
pub const fn txe (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Transmit data register empty"]
pub fn set_txe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LIN break detection flag"]
pub const fn lbd (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "LIN break detection flag"]
pub fn set_lbd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CTS interrupt flag"]
pub const fn ctsif (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CTS interrupt flag"]
pub fn set_ctsif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CTS flag"]
pub const fn cts (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CTS flag"]
pub fn set_cts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Receiver timeout"]
pub const fn rtof (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Receiver timeout"]
pub fn set_rtof (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "End of block flag"]
pub const fn eobf (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "End of block flag"]
pub fn set_eobf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Auto baud rate error"]
pub const fn abre (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Auto baud rate error"]
pub fn set_abre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Auto baud rate flag"]
pub const fn abrf (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Auto baud rate flag"]
pub fn set_abrf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Busy flag"]
pub const fn busy (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Busy flag"]
pub fn set_busy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "character match flag"]
pub const fn cmf (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "character match flag"]
pub fn set_cmf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Send break flag"]
pub const fn sbkf (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Send break flag"]
pub fn set_sbkf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Receiver wakeup from Mute mode"]
pub const fn rwu (& self) -> super :: vals :: Rwu { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: Rwu (val as u8) } # [doc = "Receiver wakeup from Mute mode"]
pub fn set_rwu (& mut self , val : super :: vals :: Rwu) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "Wakeup from Stop mode flag"]
pub const fn wuf (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Wakeup from Stop mode flag"]
pub fn set_wuf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Transmit enable acknowledge flag"]
pub const fn teack (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Transmit enable acknowledge flag"]
pub fn set_teack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Receive enable acknowledge flag"]
pub const fn reack (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Receive enable acknowledge flag"]
pub fn set_reack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Ixr { fn default () -> Ixr { Ixr (0) } } # [doc = "Baud rate register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Brr (pub u32) ; impl Brr { # [doc = "mantissa of USARTDIV"]
pub const fn brr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "mantissa of USARTDIV"]
pub fn set_brr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Brr { fn default () -> Brr { Brr (0) } } # [doc = "Receiver timeout register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rtor (pub u32) ; impl Rtor { # [doc = "Receiver timeout value"]
pub const fn rto (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x00ff_ffff ; val as u32 } # [doc = "Receiver timeout value"]
pub fn set_rto (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x00ff_ffff << 0usize)) | (((val as u32) & 0x00ff_ffff) << 0usize) ; } # [doc = "Block Length"]
pub const fn blen (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Block Length"]
pub fn set_blen (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Rtor { fn default () -> Rtor { Rtor (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Irlp (pub u8) ; impl Irlp { # [doc = "Normal mode"]
pub const NORMAL : Self = Self (0) ; # [doc = "Low-power mode"]
pub const LOWPOWER : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct M1 (pub u8) ; impl M1 { # [doc = "Use M0 to set the data bits"]
pub const M0 : Self = Self (0) ; # [doc = "1 start bit, 7 data bits, n stop bits"]
pub const BIT7 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msbfirst (pub u8) ; impl Msbfirst { # [doc = "data is transmitted/received with data bit 0 first, following the start bit"]
pub const LSB : Self = Self (0) ; # [doc = "data is transmitted/received with MSB (bit 7/8/9) first, following the start bit"]
pub const MSB : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct M0 (pub u8) ; impl M0 { # [doc = "1 start bit, 8 data bits, n stop bits"]
pub const BIT8 : Self = Self (0) ; # [doc = "1 start bit, 9 data bits, n stop bits"]
pub const BIT9 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpha (pub u8) ; impl Cpha { # [doc = "The first clock transition is the first data capture edge"]
pub const FIRST : Self = Self (0) ; # [doc = "The second clock transition is the first data capture edge"]
pub const SECOND : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lbdl (pub u8) ; impl Lbdl { # [doc = "10-bit break detection"]
pub const BIT10 : Self = Self (0) ; # [doc = "11-bit break detection"]
pub const BIT11 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ps (pub u8) ; impl Ps { # [doc = "Even parity"]
pub const EVEN : Self = Self (0) ; # [doc = "Odd parity"]
pub const ODD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wake (pub u8) ; impl Wake { # [doc = "USART wakeup on idle line"]
pub const IDLELINE : Self = Self (0) ; # [doc = "USART wakeup on address mark"]
pub const ADDRESSMARK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wus (pub u8) ; impl Wus { # [doc = "WUF active on address match"]
pub const ADDRESS : Self = Self (0) ; # [doc = "WuF active on Start bit detection"]
pub const START : Self = Self (0x02) ; # [doc = "WUF active on RXNE"]
pub const RXNE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Over (pub u8) ; impl Over { # [doc = "Oversampling by 16"]
pub const OVERSAMPLING16 : Self = Self (0) ; # [doc = "Oversampling by 8"]
pub const OVERSAMPLING8 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rwu (pub u8) ; impl Rwu { # [doc = "Receiver in active mode"]
pub const ACTIVE : Self = Self (0) ; # [doc = "Receiver in mute mode"]
pub const MUTE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dep (pub u8) ; impl Dep { # [doc = "DE signal is active high"]
pub const HIGH : Self = Self (0) ; # [doc = "DE signal is active low"]
pub const LOW : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Addm (pub u8) ; impl Addm { # [doc = "4-bit address detection"]
pub const BIT4 : Self = Self (0) ; # [doc = "7-bit address detection"]
pub const BIT7 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Abrmod (pub u8) ; impl Abrmod { # [doc = "Measurement of the start bit is used to detect the baud rate"]
pub const START : Self = Self (0) ; # [doc = "Falling edge to falling edge measurement"]
pub const EDGE : Self = Self (0x01) ; # [doc = "0x7F frame detection"]
pub const FRAME7F : Self = Self (0x02) ; # [doc = "0x55 frame detection"]
pub const FRAME55 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Stop (pub u8) ; impl Stop { # [doc = "1 stop bit"]
pub const STOP1 : Self = Self (0) ; # [doc = "0.5 stop bit"]
pub const STOP0P5 : Self = Self (0x01) ; # [doc = "2 stop bit"]
pub const STOP2 : Self = Self (0x02) ; # [doc = "1.5 stop bit"]
pub const STOP1P5 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Onebit (pub u8) ; impl Onebit { # [doc = "Three sample bit method"]
pub const SAMPLE3 : Self = Self (0) ; # [doc = "One sample bit method"]
pub const SAMPLE1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpol (pub u8) ; impl Cpol { # [doc = "Steady low value on CK pin outside transmission window"]
pub const LOW : Self = Self (0) ; # [doc = "Steady high value on CK pin outside transmission window"]
pub const HIGH : Self = Self (0x01) ; } }