

# [doc = "Universal synchronous asynchronous receiver transmitter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Usart (pub * mut u8) ; unsafe impl Send for Usart { } unsafe impl Sync for Usart { } impl Usart { # [doc = "Status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Data register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Baud rate register"]
pub fn brr (self) -> crate :: common :: Reg < regs :: Brr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2Usart , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Control register 3"]
pub fn cr3 (self) -> crate :: common :: Reg < regs :: Cr3Usart , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Guard time and prescaler register"]
pub fn gtpr (self) -> crate :: common :: Reg < regs :: Gtpr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } } # [doc = "Universal asynchronous receiver transmitter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Uart (pub * mut u8) ; unsafe impl Send for Uart { } unsafe impl Sync for Uart { } impl Uart { # [doc = "Status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Data register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Baud rate register"]
pub fn brr (self) -> crate :: common :: Reg < regs :: Brr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Control register 3"]
pub fn cr3 (self) -> crate :: common :: Reg < regs :: Cr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wake (pub u8) ; impl Wake { # [doc = "USART wakeup on idle line"]
pub const IDLELINE : Self = Self (0) ; # [doc = "USART wakeup on address mark"]
pub const ADDRESSMARK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct M0 (pub u8) ; impl M0 { # [doc = "1 start bit, 8 data bits, n stop bits"]
pub const BIT8 : Self = Self (0) ; # [doc = "1 start bit, 9 data bits, n stop bits"]
pub const BIT9 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lbdl (pub u8) ; impl Lbdl { # [doc = "10-bit break detection"]
pub const BIT10 : Self = Self (0) ; # [doc = "11-bit break detection"]
pub const BIT11 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpha (pub u8) ; impl Cpha { # [doc = "The first clock transition is the first data capture edge"]
pub const FIRST : Self = Self (0) ; # [doc = "The second clock transition is the first data capture edge"]
pub const SECOND : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Stop (pub u8) ; impl Stop { # [doc = "1 stop bit"]
pub const STOP1 : Self = Self (0) ; # [doc = "0.5 stop bits"]
pub const STOP0P5 : Self = Self (0x01) ; # [doc = "2 stop bits"]
pub const STOP2 : Self = Self (0x02) ; # [doc = "1.5 stop bits"]
pub const STOP1P5 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpol (pub u8) ; impl Cpol { # [doc = "Steady low value on CK pin outside transmission window"]
pub const LOW : Self = Self (0) ; # [doc = "Steady high value on CK pin outside transmission window"]
pub const HIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rwu (pub u8) ; impl Rwu { # [doc = "Receiver in active mode"]
pub const ACTIVE : Self = Self (0) ; # [doc = "Receiver in mute mode"]
pub const MUTE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ps (pub u8) ; impl Ps { # [doc = "Even parity"]
pub const EVEN : Self = Self (0) ; # [doc = "Odd parity"]
pub const ODD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Irlp (pub u8) ; impl Irlp { # [doc = "Normal mode"]
pub const NORMAL : Self = Self (0) ; # [doc = "Low-power mode"]
pub const LOWPOWER : Self = Self (0x01) ; } } pub mod regs { # [doc = "Guard time and prescaler register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gtpr (pub u32) ; impl Gtpr { # [doc = "Prescaler value"]
pub const fn psc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Prescaler value"]
pub fn set_psc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Guard time value"]
pub const fn gt (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Guard time value"]
pub fn set_gt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } } impl Default for Gtpr { fn default () -> Gtpr { Gtpr (0) } } # [doc = "Control register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr3 (pub u32) ; impl Cr3 { # [doc = "Error interrupt enable"]
pub const fn eie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_eie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IrDA mode enable"]
pub const fn iren (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IrDA mode enable"]
pub fn set_iren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IrDA low-power"]
pub const fn irlp (& self) -> super :: vals :: Irlp { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Irlp (val as u8) } # [doc = "IrDA low-power"]
pub fn set_irlp (& mut self , val : super :: vals :: Irlp) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Half-duplex selection"]
pub const fn hdsel (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Half-duplex selection"]
pub fn set_hdsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "DMA enable receiver"]
pub const fn dmar (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "DMA enable receiver"]
pub fn set_dmar (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "DMA enable transmitter"]
pub const fn dmat (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "DMA enable transmitter"]
pub fn set_dmat (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Cr3 { fn default () -> Cr3 { Cr3 (0) } } # [doc = "Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct SrUsart (pub u32) ; impl SrUsart { # [doc = "Parity error"]
pub const fn pe (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Parity error"]
pub fn set_pe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Framing error"]
pub const fn fe (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Framing error"]
pub fn set_fe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Noise error flag"]
pub const fn ne (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Noise error flag"]
pub fn set_ne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Overrun error"]
pub const fn ore (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Overrun error"]
pub fn set_ore (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Idle line detected"]
pub const fn idle (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Idle line detected"]
pub fn set_idle (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Read data register not empty"]
pub const fn rxne (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Read data register not empty"]
pub fn set_rxne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Transmission complete"]
pub const fn tc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transmission complete"]
pub fn set_tc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Transmit data register empty"]
pub const fn txe (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Transmit data register empty"]
pub fn set_txe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LIN break detection flag"]
pub const fn lbd (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "LIN break detection flag"]
pub fn set_lbd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CTS flag"]
pub const fn cts (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CTS flag"]
pub fn set_cts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for SrUsart { fn default () -> SrUsart { SrUsart (0) } } # [doc = "Control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2Usart (pub u32) ; impl Cr2Usart { # [doc = "Address of the USART node"]
pub const fn add (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Address of the USART node"]
pub fn set_add (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Line break detection length"]
pub const fn lbdl (& self) -> super :: vals :: Lbdl { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Lbdl (val as u8) } # [doc = "Line break detection length"]
pub fn set_lbdl (& mut self , val : super :: vals :: Lbdl) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "LIN break detection interrupt enable"]
pub const fn lbdie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LIN break detection interrupt enable"]
pub fn set_lbdie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Last bit clock pulse"]
pub const fn lbcl (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Last bit clock pulse"]
pub fn set_lbcl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Clock phase"]
pub const fn cpha (& self) -> super :: vals :: Cpha { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Cpha (val as u8) } # [doc = "Clock phase"]
pub fn set_cpha (& mut self , val : super :: vals :: Cpha) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Clock polarity"]
pub const fn cpol (& self) -> super :: vals :: Cpol { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Cpol (val as u8) } # [doc = "Clock polarity"]
pub fn set_cpol (& mut self , val : super :: vals :: Cpol) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Clock enable"]
pub const fn clken (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Clock enable"]
pub fn set_clken (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "STOP bits"]
pub const fn stop (& self) -> super :: vals :: Stop { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Stop (val as u8) } # [doc = "STOP bits"]
pub fn set_stop (& mut self , val : super :: vals :: Stop) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "LIN mode enable"]
pub const fn linen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "LIN mode enable"]
pub fn set_linen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for Cr2Usart { fn default () -> Cr2Usart { Cr2Usart (0) } } # [doc = "Data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Data value"]
pub const fn dr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Data value"]
pub fn set_dr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "Baud rate register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Brr (pub u32) ; impl Brr { # [doc = "fraction of USARTDIV"]
pub const fn div_fraction (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "fraction of USARTDIV"]
pub fn set_div_fraction (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "mantissa of USARTDIV"]
pub const fn div_mantissa (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x0fff ; val as u16 } # [doc = "mantissa of USARTDIV"]
pub fn set_div_mantissa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 4usize)) | (((val as u32) & 0x0fff) << 4usize) ; } } impl Default for Brr { fn default () -> Brr { Brr (0) } } # [doc = "Control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Send break"]
pub const fn sbk (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Send break"]
pub fn set_sbk (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Receiver wakeup"]
pub const fn rwu (& self) -> super :: vals :: Rwu { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Rwu (val as u8) } # [doc = "Receiver wakeup"]
pub fn set_rwu (& mut self , val : super :: vals :: Rwu) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Receiver enable"]
pub const fn re (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Receiver enable"]
pub fn set_re (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Transmitter enable"]
pub const fn te (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Transmitter enable"]
pub fn set_te (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IDLE interrupt enable"]
pub const fn idleie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IDLE interrupt enable"]
pub fn set_idleie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RXNE interrupt enable"]
pub const fn rxneie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RXNE interrupt enable"]
pub fn set_rxneie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Transmission complete interrupt enable"]
pub const fn tcie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transmission complete interrupt enable"]
pub fn set_tcie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TXE interrupt enable"]
pub const fn txeie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TXE interrupt enable"]
pub fn set_txeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "PE interrupt enable"]
pub const fn peie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "PE interrupt enable"]
pub fn set_peie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Parity selection"]
pub const fn ps (& self) -> super :: vals :: Ps { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Ps (val as u8) } # [doc = "Parity selection"]
pub fn set_ps (& mut self , val : super :: vals :: Ps) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Parity control enable"]
pub const fn pce (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Parity control enable"]
pub fn set_pce (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Receiver wakeup method"]
pub const fn wake (& self) -> super :: vals :: Wake { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Wake (val as u8) } # [doc = "Receiver wakeup method"]
pub fn set_wake (& mut self , val : super :: vals :: Wake) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Word length"]
pub const fn m0 (& self) -> super :: vals :: M0 { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: M0 (val as u8) } # [doc = "Word length"]
pub fn set_m0 (& mut self , val : super :: vals :: M0) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "USART enable"]
pub const fn ue (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "USART enable"]
pub fn set_ue (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Parity error"]
pub const fn pe (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Parity error"]
pub fn set_pe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Framing error"]
pub const fn fe (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Framing error"]
pub fn set_fe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Noise error flag"]
pub const fn ne (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Noise error flag"]
pub fn set_ne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Overrun error"]
pub const fn ore (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Overrun error"]
pub fn set_ore (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Idle line detected"]
pub const fn idle (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Idle line detected"]
pub fn set_idle (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Read data register not empty"]
pub const fn rxne (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Read data register not empty"]
pub fn set_rxne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Transmission complete"]
pub const fn tc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transmission complete"]
pub fn set_tc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Transmit data register empty"]
pub const fn txe (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Transmit data register empty"]
pub fn set_txe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LIN break detection flag"]
pub const fn lbd (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "LIN break detection flag"]
pub fn set_lbd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "Control register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr3Usart (pub u32) ; impl Cr3Usart { # [doc = "Error interrupt enable"]
pub const fn eie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_eie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IrDA mode enable"]
pub const fn iren (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IrDA mode enable"]
pub fn set_iren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IrDA low-power"]
pub const fn irlp (& self) -> super :: vals :: Irlp { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Irlp (val as u8) } # [doc = "IrDA low-power"]
pub fn set_irlp (& mut self , val : super :: vals :: Irlp) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Half-duplex selection"]
pub const fn hdsel (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Half-duplex selection"]
pub fn set_hdsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Smartcard NACK enable"]
pub const fn nack (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Smartcard NACK enable"]
pub fn set_nack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Smartcard mode enable"]
pub const fn scen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Smartcard mode enable"]
pub fn set_scen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "DMA enable receiver"]
pub const fn dmar (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "DMA enable receiver"]
pub fn set_dmar (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "DMA enable transmitter"]
pub const fn dmat (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "DMA enable transmitter"]
pub fn set_dmat (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "RTS enable"]
pub const fn rtse (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "RTS enable"]
pub fn set_rtse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CTS enable"]
pub const fn ctse (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CTS enable"]
pub fn set_ctse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CTS interrupt enable"]
pub const fn ctsie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CTS interrupt enable"]
pub fn set_ctsie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Cr3Usart { fn default () -> Cr3Usart { Cr3Usart (0) } } # [doc = "Control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "Address of the USART node"]
pub const fn add (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Address of the USART node"]
pub fn set_add (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Line break detection length"]
pub const fn lbdl (& self) -> super :: vals :: Lbdl { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Lbdl (val as u8) } # [doc = "Line break detection length"]
pub fn set_lbdl (& mut self , val : super :: vals :: Lbdl) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "LIN break detection interrupt enable"]
pub const fn lbdie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LIN break detection interrupt enable"]
pub fn set_lbdie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "STOP bits"]
pub const fn stop (& self) -> super :: vals :: Stop { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Stop (val as u8) } # [doc = "STOP bits"]
pub fn set_stop (& mut self , val : super :: vals :: Stop) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "LIN mode enable"]
pub const fn linen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "LIN mode enable"]
pub fn set_linen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } }