

# [doc = "Basic timer"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct TimBasic (pub * mut u8) ; unsafe impl Send for TimBasic { } unsafe impl Sync for TimBasic { } impl TimBasic { # [doc = "control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1Basic , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2Basic , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "DMA/Interrupt enable register"]
pub fn dier (self) -> crate :: common :: Reg < regs :: DierBasic , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: SrBasic , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "event generation register"]
pub fn egr (self) -> crate :: common :: Reg < regs :: EgrBasic , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "counter"]
pub fn cnt (self) -> crate :: common :: Reg < regs :: Cnt16 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "prescaler"]
pub fn psc (self) -> crate :: common :: Reg < regs :: Psc , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "auto-reload register"]
pub fn arr (self) -> crate :: common :: Reg < regs :: Arr16 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } } # [doc = "Advanced-timers"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct TimAdv (pub * mut u8) ; unsafe impl Send for TimAdv { } unsafe impl Sync for TimAdv { } impl TimAdv { # [doc = "control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1Gp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2Adv , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "slave mode control register"]
pub fn smcr (self) -> crate :: common :: Reg < regs :: Smcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "DMA/Interrupt enable register"]
pub fn dier (self) -> crate :: common :: Reg < regs :: DierAdv , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: SrAdv , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "event generation register"]
pub fn egr (self) -> crate :: common :: Reg < regs :: EgrAdv , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "capture/compare mode register 1 (input mode)"]
pub fn ccmr_input (self , n : usize) -> crate :: common :: Reg < regs :: CcmrInput , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize + n * 4usize)) } } # [doc = "capture/compare mode register 1 (output mode)"]
pub fn ccmr_output (self , n : usize) -> crate :: common :: Reg < regs :: CcmrOutput , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize + n * 4usize)) } } # [doc = "capture/compare enable register"]
pub fn ccer (self) -> crate :: common :: Reg < regs :: CcerAdv , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "counter"]
pub fn cnt (self) -> crate :: common :: Reg < regs :: Cnt16 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "prescaler"]
pub fn psc (self) -> crate :: common :: Reg < regs :: Psc , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "auto-reload register"]
pub fn arr (self) -> crate :: common :: Reg < regs :: Arr16 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "repetition counter register"]
pub fn rcr (self) -> crate :: common :: Reg < regs :: Rcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "capture/compare register"]
pub fn ccr (self , n : usize) -> crate :: common :: Reg < regs :: Ccr16 , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize + n * 4usize)) } } # [doc = "break and dead-time register"]
pub fn bdtr (self) -> crate :: common :: Reg < regs :: Bdtr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "DMA control register"]
pub fn dcr (self) -> crate :: common :: Reg < regs :: Dcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "DMA address for full transfer"]
pub fn dmar (self) -> crate :: common :: Reg < regs :: Dmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } # [doc = "General purpose 32-bit timer"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct TimGp32 (pub * mut u8) ; unsafe impl Send for TimGp32 { } unsafe impl Sync for TimGp32 { } impl TimGp32 { # [doc = "control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1Gp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2Gp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "slave mode control register"]
pub fn smcr (self) -> crate :: common :: Reg < regs :: Smcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "DMA/Interrupt enable register"]
pub fn dier (self) -> crate :: common :: Reg < regs :: DierGp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: SrGp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "event generation register"]
pub fn egr (self) -> crate :: common :: Reg < regs :: EgrGp , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "capture/compare mode register 1 (input mode)"]
pub fn ccmr_input (self , n : usize) -> crate :: common :: Reg < regs :: CcmrInput , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize + n * 4usize)) } } # [doc = "capture/compare mode register 1 (output mode)"]
pub fn ccmr_output (self , n : usize) -> crate :: common :: Reg < regs :: CcmrOutput , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize + n * 4usize)) } } # [doc = "capture/compare enable register"]
pub fn ccer (self) -> crate :: common :: Reg < regs :: CcerGp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "counter"]
pub fn cnt (self) -> crate :: common :: Reg < regs :: Cnt32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "prescaler"]
pub fn psc (self) -> crate :: common :: Reg < regs :: Psc , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "auto-reload register"]
pub fn arr (self) -> crate :: common :: Reg < regs :: Arr32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "capture/compare register"]
pub fn ccr (self , n : usize) -> crate :: common :: Reg < regs :: Ccr32 , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize + n * 4usize)) } } # [doc = "DMA control register"]
pub fn dcr (self) -> crate :: common :: Reg < regs :: Dcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "DMA address for full transfer"]
pub fn dmar (self) -> crate :: common :: Reg < regs :: Dmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } # [doc = "General purpose 16-bit timer"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct TimGp16 (pub * mut u8) ; unsafe impl Send for TimGp16 { } unsafe impl Sync for TimGp16 { } impl TimGp16 { # [doc = "control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1Gp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2Gp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "slave mode control register"]
pub fn smcr (self) -> crate :: common :: Reg < regs :: Smcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "DMA/Interrupt enable register"]
pub fn dier (self) -> crate :: common :: Reg < regs :: DierGp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: SrGp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "event generation register"]
pub fn egr (self) -> crate :: common :: Reg < regs :: EgrGp , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "capture/compare mode register 1 (input mode)"]
pub fn ccmr_input (self , n : usize) -> crate :: common :: Reg < regs :: CcmrInput , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize + n * 4usize)) } } # [doc = "capture/compare mode register 1 (output mode)"]
pub fn ccmr_output (self , n : usize) -> crate :: common :: Reg < regs :: CcmrOutput , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize + n * 4usize)) } } # [doc = "capture/compare enable register"]
pub fn ccer (self) -> crate :: common :: Reg < regs :: CcerGp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "counter"]
pub fn cnt (self) -> crate :: common :: Reg < regs :: Cnt16 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "prescaler"]
pub fn psc (self) -> crate :: common :: Reg < regs :: Psc , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "auto-reload register"]
pub fn arr (self) -> crate :: common :: Reg < regs :: Arr16 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "capture/compare register"]
pub fn ccr (self , n : usize) -> crate :: common :: Reg < regs :: Ccr16 , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize + n * 4usize)) } } # [doc = "DMA control register"]
pub fn dcr (self) -> crate :: common :: Reg < regs :: Dcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "DMA address for full transfer"]
pub fn dmar (self) -> crate :: common :: Reg < regs :: Dmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } pub mod regs { # [doc = "capture/compare register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr32 (pub u32) ; impl Ccr32 { # [doc = "Capture/Compare 1 value"]
pub const fn ccr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Capture/Compare 1 value"]
pub fn set_ccr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ccr32 { fn default () -> Ccr32 { Ccr32 (0) } } # [doc = "DMA/Interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct DierGp (pub u32) ; impl DierGp { # [doc = "Update interrupt enable"]
pub const fn uie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update interrupt enable"]
pub fn set_uie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Capture/Compare 1 interrupt enable"]
pub fn ccie (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 interrupt enable"]
pub fn set_ccie (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Trigger interrupt enable"]
pub const fn tie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Trigger interrupt enable"]
pub fn set_tie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Update DMA request enable"]
pub const fn ude (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Update DMA request enable"]
pub fn set_ude (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Capture/Compare 1 DMA request enable"]
pub fn ccde (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 9usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 DMA request enable"]
pub fn set_ccde (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 9usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Trigger DMA request enable"]
pub const fn tde (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Trigger DMA request enable"]
pub fn set_tde (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for DierGp { fn default () -> DierGp { DierGp (0) } } # [doc = "DMA address for full transfer"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmar (pub u32) ; impl Dmar { # [doc = "DMA register for burst accesses"]
pub const fn dmab (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "DMA register for burst accesses"]
pub fn set_dmab (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Dmar { fn default () -> Dmar { Dmar (0) } } # [doc = "slave mode control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Smcr (pub u32) ; impl Smcr { # [doc = "Slave mode selection"]
pub const fn sms (& self) -> super :: vals :: Sms { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Sms (val as u8) } # [doc = "Slave mode selection"]
pub fn set_sms (& mut self , val : super :: vals :: Sms) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "Trigger selection"]
pub const fn ts (& self) -> super :: vals :: Ts { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Ts (val as u8) } # [doc = "Trigger selection"]
pub fn set_ts (& mut self , val : super :: vals :: Ts) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } # [doc = "Master/Slave mode"]
pub const fn msm (& self) -> super :: vals :: Msm { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Msm (val as u8) } # [doc = "Master/Slave mode"]
pub fn set_msm (& mut self , val : super :: vals :: Msm) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "External trigger filter"]
pub const fn etf (& self) -> super :: vals :: Etf { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Etf (val as u8) } # [doc = "External trigger filter"]
pub fn set_etf (& mut self , val : super :: vals :: Etf) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } # [doc = "External trigger prescaler"]
pub const fn etps (& self) -> super :: vals :: Etps { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Etps (val as u8) } # [doc = "External trigger prescaler"]
pub fn set_etps (& mut self , val : super :: vals :: Etps) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "External clock enable"]
pub const fn ece (& self) -> super :: vals :: Ece { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Ece (val as u8) } # [doc = "External clock enable"]
pub fn set_ece (& mut self , val : super :: vals :: Ece) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "External trigger polarity"]
pub const fn etp (& self) -> super :: vals :: Etp { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Etp (val as u8) } # [doc = "External trigger polarity"]
pub fn set_etp (& mut self , val : super :: vals :: Etp) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Smcr { fn default () -> Smcr { Smcr (0) } } # [doc = "control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2Gp (pub u32) ; impl Cr2Gp { # [doc = "Capture/compare DMA selection"]
pub const fn ccds (& self) -> super :: vals :: Ccds { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Ccds (val as u8) } # [doc = "Capture/compare DMA selection"]
pub fn set_ccds (& mut self , val : super :: vals :: Ccds) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Master mode selection"]
pub const fn mms (& self) -> super :: vals :: Mms { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Mms (val as u8) } # [doc = "Master mode selection"]
pub fn set_mms (& mut self , val : super :: vals :: Mms) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } # [doc = "TI1 selection"]
pub const fn ti1s (& self) -> super :: vals :: Tis { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Tis (val as u8) } # [doc = "TI1 selection"]
pub fn set_ti1s (& mut self , val : super :: vals :: Tis) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } } impl Default for Cr2Gp { fn default () -> Cr2Gp { Cr2Gp (0) } } # [doc = "event generation register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct EgrBasic (pub u32) ; impl EgrBasic { # [doc = "Update generation"]
pub const fn ug (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update generation"]
pub fn set_ug (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for EgrBasic { fn default () -> EgrBasic { EgrBasic (0) } } # [doc = "auto-reload register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Arr32 (pub u32) ; impl Arr32 { # [doc = "Auto-reload value"]
pub const fn arr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Auto-reload value"]
pub fn set_arr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Arr32 { fn default () -> Arr32 { Arr32 (0) } } # [doc = "DMA/Interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct DierAdv (pub u32) ; impl DierAdv { # [doc = "Update interrupt enable"]
pub const fn uie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update interrupt enable"]
pub fn set_uie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Capture/Compare 1 interrupt enable"]
pub fn ccie (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 interrupt enable"]
pub fn set_ccie (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "COM interrupt enable"]
pub const fn comie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "COM interrupt enable"]
pub fn set_comie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Trigger interrupt enable"]
pub const fn tie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Trigger interrupt enable"]
pub fn set_tie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Break interrupt enable"]
pub const fn bie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Break interrupt enable"]
pub fn set_bie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Update DMA request enable"]
pub const fn ude (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Update DMA request enable"]
pub fn set_ude (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Capture/Compare 1 DMA request enable"]
pub fn ccde (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 9usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 DMA request enable"]
pub fn set_ccde (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 9usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "COM DMA request enable"]
pub const fn comde (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "COM DMA request enable"]
pub fn set_comde (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Trigger DMA request enable"]
pub const fn tde (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Trigger DMA request enable"]
pub fn set_tde (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for DierAdv { fn default () -> DierAdv { DierAdv (0) } } # [doc = "event generation register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct EgrAdv (pub u32) ; impl EgrAdv { # [doc = "Update generation"]
pub const fn ug (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update generation"]
pub fn set_ug (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Capture/compare 1 generation"]
pub fn ccg (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/compare 1 generation"]
pub fn set_ccg (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Capture/Compare control update generation"]
pub const fn comg (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Capture/Compare control update generation"]
pub fn set_comg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Trigger generation"]
pub const fn tg (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Trigger generation"]
pub fn set_tg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Break generation"]
pub const fn bg (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Break generation"]
pub fn set_bg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for EgrAdv { fn default () -> EgrAdv { EgrAdv (0) } } # [doc = "DMA control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dcr (pub u32) ; impl Dcr { # [doc = "DMA base address"]
pub const fn dba (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "DMA base address"]
pub fn set_dba (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "DMA burst length"]
pub const fn dbl (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x1f ; val as u8 } # [doc = "DMA burst length"]
pub fn set_dbl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 8usize)) | (((val as u32) & 0x1f) << 8usize) ; } } impl Default for Dcr { fn default () -> Dcr { Dcr (0) } } # [doc = "DMA/Interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct DierBasic (pub u32) ; impl DierBasic { # [doc = "Update interrupt enable"]
pub const fn uie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update interrupt enable"]
pub fn set_uie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Update DMA request enable"]
pub const fn ude (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Update DMA request enable"]
pub fn set_ude (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for DierBasic { fn default () -> DierBasic { DierBasic (0) } } # [doc = "capture/compare register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr16 (pub u32) ; impl Ccr16 { # [doc = "Capture/Compare 1 value"]
pub const fn ccr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Capture/Compare 1 value"]
pub fn set_ccr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Ccr16 { fn default () -> Ccr16 { Ccr16 (0) } } # [doc = "event generation register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct EgrGp (pub u32) ; impl EgrGp { # [doc = "Update generation"]
pub const fn ug (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update generation"]
pub fn set_ug (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Capture/compare 1 generation"]
pub fn ccg (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/compare 1 generation"]
pub fn set_ccg (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Capture/Compare control update generation"]
pub const fn comg (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Capture/Compare control update generation"]
pub fn set_comg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Trigger generation"]
pub const fn tg (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Trigger generation"]
pub fn set_tg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Break generation"]
pub const fn bg (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Break generation"]
pub fn set_bg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for EgrGp { fn default () -> EgrGp { EgrGp (0) } } # [doc = "break and dead-time register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdtr (pub u32) ; impl Bdtr { # [doc = "Dead-time generator setup"]
pub const fn dtg (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Dead-time generator setup"]
pub fn set_dtg (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Lock configuration"]
pub const fn lock (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "Lock configuration"]
pub fn set_lock (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "Off-state selection for Idle mode"]
pub const fn ossi (& self) -> super :: vals :: Ossi { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Ossi (val as u8) } # [doc = "Off-state selection for Idle mode"]
pub fn set_ossi (& mut self , val : super :: vals :: Ossi) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Off-state selection for Run mode"]
pub const fn ossr (& self) -> super :: vals :: Ossr { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Ossr (val as u8) } # [doc = "Off-state selection for Run mode"]
pub fn set_ossr (& mut self , val : super :: vals :: Ossr) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Break enable"]
pub const fn bke (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Break enable"]
pub fn set_bke (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Break polarity"]
pub const fn bkp (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Break polarity"]
pub fn set_bkp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Automatic output enable"]
pub const fn aoe (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Automatic output enable"]
pub fn set_aoe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Main output enable"]
pub const fn moe (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Main output enable"]
pub fn set_moe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Bdtr { fn default () -> Bdtr { Bdtr (0) } } # [doc = "repetition counter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcr (pub u32) ; impl Rcr { # [doc = "Repetition counter value"]
pub const fn rep (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Repetition counter value"]
pub fn set_rep (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Rcr { fn default () -> Rcr { Rcr (0) } } # [doc = "counter"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cnt16 (pub u32) ; impl Cnt16 { # [doc = "counter value"]
pub const fn cnt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "counter value"]
pub fn set_cnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Cnt16 { fn default () -> Cnt16 { Cnt16 (0) } } # [doc = "counter"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cnt32 (pub u32) ; impl Cnt32 { # [doc = "counter value"]
pub const fn cnt (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "counter value"]
pub fn set_cnt (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Cnt32 { fn default () -> Cnt32 { Cnt32 (0) } } # [doc = "prescaler"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Psc (pub u32) ; impl Psc { # [doc = "Prescaler value"]
pub const fn psc (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Prescaler value"]
pub fn set_psc (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Psc { fn default () -> Psc { Psc (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct SrAdv (pub u32) ; impl SrAdv { # [doc = "Update interrupt flag"]
pub const fn uif (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update interrupt flag"]
pub fn set_uif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Capture/compare 1 interrupt flag"]
pub fn ccif (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/compare 1 interrupt flag"]
pub fn set_ccif (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "COM interrupt flag"]
pub const fn comif (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "COM interrupt flag"]
pub fn set_comif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Trigger interrupt flag"]
pub const fn tif (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Trigger interrupt flag"]
pub fn set_tif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Break interrupt flag"]
pub const fn bif (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Break interrupt flag"]
pub fn set_bif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Capture/Compare 1 overcapture flag"]
pub fn ccof (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 9usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 overcapture flag"]
pub fn set_ccof (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 9usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for SrAdv { fn default () -> SrAdv { SrAdv (0) } } # [doc = "auto-reload register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Arr16 (pub u32) ; impl Arr16 { # [doc = "Auto-reload value"]
pub const fn arr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Auto-reload value"]
pub fn set_arr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Arr16 { fn default () -> Arr16 { Arr16 (0) } } # [doc = "capture/compare enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct CcerGp (pub u32) ; impl CcerGp { # [doc = "Capture/Compare 1 output enable"]
pub fn cce (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 output enable"]
pub fn set_cce (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Capture/Compare 1 output Polarity"]
pub fn ccp (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 1usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 output Polarity"]
pub fn set_ccp (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 1usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Capture/Compare 1 output Polarity"]
pub fn ccnp (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 3usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 output Polarity"]
pub fn set_ccnp (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 3usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for CcerGp { fn default () -> CcerGp { CcerGp (0) } } # [doc = "control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2Basic (pub u32) ; impl Cr2Basic { # [doc = "Master mode selection"]
pub const fn mms (& self) -> super :: vals :: Mms { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Mms (val as u8) } # [doc = "Master mode selection"]
pub fn set_mms (& mut self , val : super :: vals :: Mms) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } } impl Default for Cr2Basic { fn default () -> Cr2Basic { Cr2Basic (0) } } # [doc = "control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1Basic (pub u32) ; impl Cr1Basic { # [doc = "Counter enable"]
pub const fn cen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Counter enable"]
pub fn set_cen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Update disable"]
pub const fn udis (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Update disable"]
pub fn set_udis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Update request source"]
pub const fn urs (& self) -> super :: vals :: Urs { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Urs (val as u8) } # [doc = "Update request source"]
pub fn set_urs (& mut self , val : super :: vals :: Urs) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "One-pulse mode"]
pub const fn opm (& self) -> super :: vals :: Opm { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Opm (val as u8) } # [doc = "One-pulse mode"]
pub fn set_opm (& mut self , val : super :: vals :: Opm) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Auto-reload preload enable"]
pub const fn arpe (& self) -> super :: vals :: Arpe { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Arpe (val as u8) } # [doc = "Auto-reload preload enable"]
pub fn set_arpe (& mut self , val : super :: vals :: Arpe) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } } impl Default for Cr1Basic { fn default () -> Cr1Basic { Cr1Basic (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct SrGp (pub u32) ; impl SrGp { # [doc = "Update interrupt flag"]
pub const fn uif (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update interrupt flag"]
pub fn set_uif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Capture/compare 1 interrupt flag"]
pub fn ccif (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/compare 1 interrupt flag"]
pub fn set_ccif (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 1usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "COM interrupt flag"]
pub const fn comif (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "COM interrupt flag"]
pub fn set_comif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Trigger interrupt flag"]
pub const fn tif (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Trigger interrupt flag"]
pub fn set_tif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Break interrupt flag"]
pub const fn bif (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Break interrupt flag"]
pub fn set_bif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Capture/Compare 1 overcapture flag"]
pub fn ccof (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 9usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 overcapture flag"]
pub fn set_ccof (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 9usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for SrGp { fn default () -> SrGp { SrGp (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct SrBasic (pub u32) ; impl SrBasic { # [doc = "Update interrupt flag"]
pub const fn uif (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Update interrupt flag"]
pub fn set_uif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for SrBasic { fn default () -> SrBasic { SrBasic (0) } } # [doc = "control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2Adv (pub u32) ; impl Cr2Adv { # [doc = "Capture/compare preloaded control"]
pub const fn ccpc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Capture/compare preloaded control"]
pub fn set_ccpc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Capture/compare control update selection"]
pub const fn ccus (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Capture/compare control update selection"]
pub fn set_ccus (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Capture/compare DMA selection"]
pub const fn ccds (& self) -> super :: vals :: Ccds { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Ccds (val as u8) } # [doc = "Capture/compare DMA selection"]
pub fn set_ccds (& mut self , val : super :: vals :: Ccds) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Master mode selection"]
pub const fn mms (& self) -> super :: vals :: Mms { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Mms (val as u8) } # [doc = "Master mode selection"]
pub fn set_mms (& mut self , val : super :: vals :: Mms) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } # [doc = "TI1 selection"]
pub const fn ti1s (& self) -> super :: vals :: Tis { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Tis (val as u8) } # [doc = "TI1 selection"]
pub fn set_ti1s (& mut self , val : super :: vals :: Tis) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Output Idle state 1"]
pub fn ois (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 8usize + n * 2usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Output Idle state 1"]
pub fn set_ois (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 8usize + n * 2usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Output Idle state 1"]
pub const fn ois1n (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Output Idle state 1"]
pub fn set_ois1n (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Output Idle state 2"]
pub const fn ois2n (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Output Idle state 2"]
pub fn set_ois2n (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Output Idle state 3"]
pub const fn ois3n (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Output Idle state 3"]
pub fn set_ois3n (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } } impl Default for Cr2Adv { fn default () -> Cr2Adv { Cr2Adv (0) } } # [doc = "capture/compare enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct CcerAdv (pub u32) ; impl CcerAdv { # [doc = "Capture/Compare 1 output enable"]
pub fn cce (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 output enable"]
pub fn set_cce (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Capture/Compare 1 output Polarity"]
pub fn ccp (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 1usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 output Polarity"]
pub fn set_ccp (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 1usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Capture/Compare 1 complementary output enable"]
pub fn ccne (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 2usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 complementary output enable"]
pub fn set_ccne (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 2usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Capture/Compare 1 output Polarity"]
pub fn ccnp (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 3usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Capture/Compare 1 output Polarity"]
pub fn set_ccnp (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 3usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for CcerAdv { fn default () -> CcerAdv { CcerAdv (0) } } # [doc = "control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1Gp (pub u32) ; impl Cr1Gp { # [doc = "Counter enable"]
pub const fn cen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Counter enable"]
pub fn set_cen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Update disable"]
pub const fn udis (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Update disable"]
pub fn set_udis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Update request source"]
pub const fn urs (& self) -> super :: vals :: Urs { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Urs (val as u8) } # [doc = "Update request source"]
pub fn set_urs (& mut self , val : super :: vals :: Urs) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "One-pulse mode"]
pub const fn opm (& self) -> super :: vals :: Opm { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Opm (val as u8) } # [doc = "One-pulse mode"]
pub fn set_opm (& mut self , val : super :: vals :: Opm) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Direction"]
pub const fn dir (& self) -> super :: vals :: Dir { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Dir (val as u8) } # [doc = "Direction"]
pub fn set_dir (& mut self , val : super :: vals :: Dir) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Center-aligned mode selection"]
pub const fn cms (& self) -> super :: vals :: Cms { let val = (self . 0 >> 5usize) & 0x03 ; super :: vals :: Cms (val as u8) } # [doc = "Center-aligned mode selection"]
pub fn set_cms (& mut self , val : super :: vals :: Cms) { self . 0 = (self . 0 & ! (0x03 << 5usize)) | (((val . 0 as u32) & 0x03) << 5usize) ; } # [doc = "Auto-reload preload enable"]
pub const fn arpe (& self) -> super :: vals :: Arpe { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Arpe (val as u8) } # [doc = "Auto-reload preload enable"]
pub fn set_arpe (& mut self , val : super :: vals :: Arpe) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Clock division"]
pub const fn ckd (& self) -> super :: vals :: Ckd { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Ckd (val as u8) } # [doc = "Clock division"]
pub fn set_ckd (& mut self , val : super :: vals :: Ckd) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } } impl Default for Cr1Gp { fn default () -> Cr1Gp { Cr1Gp (0) } } # [doc = "capture/compare mode register 1 (input mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct CcmrInput (pub u32) ; impl CcmrInput { # [doc = "Capture/Compare 1 selection"]
pub fn ccs (& self , n : usize) -> super :: vals :: CcmrInputCcs { assert ! (n < 2usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: CcmrInputCcs (val as u8) } # [doc = "Capture/Compare 1 selection"]
pub fn set_ccs (& mut self , n : usize , val : super :: vals :: CcmrInputCcs) { assert ! (n < 2usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } # [doc = "Input capture 1 prescaler"]
pub fn icpsc (& self , n : usize) -> u8 { assert ! (n < 2usize) ; let offs = 2usize + n * 8usize ; let val = (self . 0 >> offs) & 0x03 ; val as u8 } # [doc = "Input capture 1 prescaler"]
pub fn set_icpsc (& mut self , n : usize , val : u8) { assert ! (n < 2usize) ; let offs = 2usize + n * 8usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val as u32) & 0x03) << offs) ; } # [doc = "Input capture 1 filter"]
pub fn icf (& self , n : usize) -> super :: vals :: Icf { assert ! (n < 2usize) ; let offs = 4usize + n * 8usize ; let val = (self . 0 >> offs) & 0x0f ; super :: vals :: Icf (val as u8) } # [doc = "Input capture 1 filter"]
pub fn set_icf (& mut self , n : usize , val : super :: vals :: Icf) { assert ! (n < 2usize) ; let offs = 4usize + n * 8usize ; self . 0 = (self . 0 & ! (0x0f << offs)) | (((val . 0 as u32) & 0x0f) << offs) ; } } impl Default for CcmrInput { fn default () -> CcmrInput { CcmrInput (0) } } # [doc = "capture/compare mode register 2 (output mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct CcmrOutput (pub u32) ; impl CcmrOutput { # [doc = "Capture/Compare 3 selection"]
pub fn ccs (& self , n : usize) -> super :: vals :: CcmrOutputCcs { assert ! (n < 2usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: CcmrOutputCcs (val as u8) } # [doc = "Capture/Compare 3 selection"]
pub fn set_ccs (& mut self , n : usize , val : super :: vals :: CcmrOutputCcs) { assert ! (n < 2usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } # [doc = "Output compare 3 fast enable"]
pub fn ocfe (& self , n : usize) -> bool { assert ! (n < 2usize) ; let offs = 2usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Output compare 3 fast enable"]
pub fn set_ocfe (& mut self , n : usize , val : bool) { assert ! (n < 2usize) ; let offs = 2usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Output compare 3 preload enable"]
pub fn ocpe (& self , n : usize) -> super :: vals :: Ocpe { assert ! (n < 2usize) ; let offs = 3usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Ocpe (val as u8) } # [doc = "Output compare 3 preload enable"]
pub fn set_ocpe (& mut self , n : usize , val : super :: vals :: Ocpe) { assert ! (n < 2usize) ; let offs = 3usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Output compare 3 mode"]
pub fn ocm (& self , n : usize) -> super :: vals :: Ocm { assert ! (n < 2usize) ; let offs = 4usize + n * 8usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: Ocm (val as u8) } # [doc = "Output compare 3 mode"]
pub fn set_ocm (& mut self , n : usize , val : super :: vals :: Ocm) { assert ! (n < 2usize) ; let offs = 4usize + n * 8usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } # [doc = "Output compare 3 clear enable"]
pub fn occe (& self , n : usize) -> bool { assert ! (n < 2usize) ; let offs = 7usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Output compare 3 clear enable"]
pub fn set_occe (& mut self , n : usize , val : bool) { assert ! (n < 2usize) ; let offs = 7usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for CcmrOutput { fn default () -> CcmrOutput { CcmrOutput (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Etp (pub u8) ; impl Etp { # [doc = "ETR is noninverted, active at high level or rising edge"]
pub const NOTINVERTED : Self = Self (0) ; # [doc = "ETR is inverted, active at low level or falling edge"]
pub const INVERTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Etf (pub u8) ; impl Etf { # [doc = "No filter, sampling is done at fDTS"]
pub const NOFILTER : Self = Self (0) ; # [doc = "fSAMPLING=fCK_INT, N=2"]
pub const FCK_INT_N2 : Self = Self (0x01) ; # [doc = "fSAMPLING=fCK_INT, N=4"]
pub const FCK_INT_N4 : Self = Self (0x02) ; # [doc = "fSAMPLING=fCK_INT, N=8"]
pub const FCK_INT_N8 : Self = Self (0x03) ; # [doc = "fSAMPLING=fDTS/2, N=6"]
pub const FDTS_DIV2_N6 : Self = Self (0x04) ; # [doc = "fSAMPLING=fDTS/2, N=8"]
pub const FDTS_DIV2_N8 : Self = Self (0x05) ; # [doc = "fSAMPLING=fDTS/4, N=6"]
pub const FDTS_DIV4_N6 : Self = Self (0x06) ; # [doc = "fSAMPLING=fDTS/4, N=8"]
pub const FDTS_DIV4_N8 : Self = Self (0x07) ; # [doc = "fSAMPLING=fDTS/8, N=6"]
pub const FDTS_DIV8_N6 : Self = Self (0x08) ; # [doc = "fSAMPLING=fDTS/8, N=8"]
pub const FDTS_DIV8_N8 : Self = Self (0x09) ; # [doc = "fSAMPLING=fDTS/16, N=5"]
pub const FDTS_DIV16_N5 : Self = Self (0x0a) ; # [doc = "fSAMPLING=fDTS/16, N=6"]
pub const FDTS_DIV16_N6 : Self = Self (0x0b) ; # [doc = "fSAMPLING=fDTS/16, N=8"]
pub const FDTS_DIV16_N8 : Self = Self (0x0c) ; # [doc = "fSAMPLING=fDTS/32, N=5"]
pub const FDTS_DIV32_N5 : Self = Self (0x0d) ; # [doc = "fSAMPLING=fDTS/32, N=6"]
pub const FDTS_DIV32_N6 : Self = Self (0x0e) ; # [doc = "fSAMPLING=fDTS/32, N=8"]
pub const FDTS_DIV32_N8 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Opm (pub u8) ; impl Opm { # [doc = "Counter is not stopped at update event"]
pub const DISABLED : Self = Self (0) ; # [doc = "Counter stops counting at the next update event (clearing the CEN bit)"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icf (pub u8) ; impl Icf { # [doc = "No filter, sampling is done at fDTS"]
pub const NOFILTER : Self = Self (0) ; # [doc = "fSAMPLING=fCK_INT, N=2"]
pub const FCK_INT_N2 : Self = Self (0x01) ; # [doc = "fSAMPLING=fCK_INT, N=4"]
pub const FCK_INT_N4 : Self = Self (0x02) ; # [doc = "fSAMPLING=fCK_INT, N=8"]
pub const FCK_INT_N8 : Self = Self (0x03) ; # [doc = "fSAMPLING=fDTS/2, N=6"]
pub const FDTS_DIV2_N6 : Self = Self (0x04) ; # [doc = "fSAMPLING=fDTS/2, N=8"]
pub const FDTS_DIV2_N8 : Self = Self (0x05) ; # [doc = "fSAMPLING=fDTS/4, N=6"]
pub const FDTS_DIV4_N6 : Self = Self (0x06) ; # [doc = "fSAMPLING=fDTS/4, N=8"]
pub const FDTS_DIV4_N8 : Self = Self (0x07) ; # [doc = "fSAMPLING=fDTS/8, N=6"]
pub const FDTS_DIV8_N6 : Self = Self (0x08) ; # [doc = "fSAMPLING=fDTS/8, N=8"]
pub const FDTS_DIV8_N8 : Self = Self (0x09) ; # [doc = "fSAMPLING=fDTS/16, N=5"]
pub const FDTS_DIV16_N5 : Self = Self (0x0a) ; # [doc = "fSAMPLING=fDTS/16, N=6"]
pub const FDTS_DIV16_N6 : Self = Self (0x0b) ; # [doc = "fSAMPLING=fDTS/16, N=8"]
pub const FDTS_DIV16_N8 : Self = Self (0x0c) ; # [doc = "fSAMPLING=fDTS/32, N=5"]
pub const FDTS_DIV32_N5 : Self = Self (0x0d) ; # [doc = "fSAMPLING=fDTS/32, N=6"]
pub const FDTS_DIV32_N6 : Self = Self (0x0e) ; # [doc = "fSAMPLING=fDTS/32, N=8"]
pub const FDTS_DIV32_N8 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct CcmrInputCcs (pub u8) ; impl CcmrInputCcs { # [doc = "CCx channel is configured as input, normal mapping: ICx mapped to TIx"]
pub const TI4 : Self = Self (0x01) ; # [doc = "CCx channel is configured as input, alternate mapping (switches 1 with 2, 3 with 4)"]
pub const TI3 : Self = Self (0x02) ; # [doc = "CCx channel is configured as input, ICx is mapped on TRC"]
pub const TRC : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msm (pub u8) ; impl Msm { # [doc = "No action"]
pub const NOSYNC : Self = Self (0) ; # [doc = "The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event."]
pub const SYNC : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ossi (pub u8) ; impl Ossi { # [doc = "When inactive, OC/OCN outputs are disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "When inactive, OC/OCN outputs are forced to idle level"]
pub const IDLELEVEL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Arpe (pub u8) ; impl Arpe { # [doc = "TIMx_APRR register is not buffered"]
pub const DISABLED : Self = Self (0) ; # [doc = "TIMx_APRR register is buffered"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tis (pub u8) ; impl Tis { # [doc = "The TIMx_CH1 pin is connected to TI1 input"]
pub const NORMAL : Self = Self (0) ; # [doc = "The TIMx_CH1, CH2, CH3 pins are connected to TI1 input"]
pub const XOR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ccds (pub u8) ; impl Ccds { # [doc = "CCx DMA request sent when CCx event occurs"]
pub const ONCOMPARE : Self = Self (0) ; # [doc = "CCx DMA request sent when update event occurs"]
pub const ONUPDATE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ckd (pub u8) ; impl Ckd { # [doc = "t_DTS = t_CK_INT"]
pub const DIV1 : Self = Self (0) ; # [doc = "t_DTS = 2 × t_CK_INT"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "t_DTS = 4 × t_CK_INT"]
pub const DIV4 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Etps (pub u8) ; impl Etps { # [doc = "Prescaler OFF"]
pub const DIV1 : Self = Self (0) ; # [doc = "ETRP frequency divided by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "ETRP frequency divided by 4"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "ETRP frequency divided by 8"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mms (pub u8) ; impl Mms { # [doc = "The UG bit from the TIMx_EGR register is used as trigger output"]
pub const RESET : Self = Self (0) ; # [doc = "The counter enable signal, CNT_EN, is used as trigger output"]
pub const ENABLE : Self = Self (0x01) ; # [doc = "The update event is selected as trigger output"]
pub const UPDATE : Self = Self (0x02) ; # [doc = "The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred"]
pub const COMPAREPULSE : Self = Self (0x03) ; # [doc = "OC1REF signal is used as trigger output"]
pub const COMPAREOC1 : Self = Self (0x04) ; # [doc = "OC2REF signal is used as trigger output"]
pub const COMPAREOC2 : Self = Self (0x05) ; # [doc = "OC3REF signal is used as trigger output"]
pub const COMPAREOC3 : Self = Self (0x06) ; # [doc = "OC4REF signal is used as trigger output"]
pub const COMPAREOC4 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dir (pub u8) ; impl Dir { # [doc = "Counter used as upcounter"]
pub const UP : Self = Self (0) ; # [doc = "Counter used as downcounter"]
pub const DOWN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ts (pub u8) ; impl Ts { # [doc = "Internal Trigger 0 (ITR0)"]
pub const ITR0 : Self = Self (0) ; # [doc = "Internal Trigger 1 (ITR1)"]
pub const ITR1 : Self = Self (0x01) ; # [doc = "Internal Trigger 2 (ITR2)"]
pub const ITR2 : Self = Self (0x02) ; # [doc = "TI1 Edge Detector (TI1F_ED)"]
pub const TI1F_ED : Self = Self (0x04) ; # [doc = "Filtered Timer Input 1 (TI1FP1)"]
pub const TI1FP1 : Self = Self (0x05) ; # [doc = "Filtered Timer Input 2 (TI2FP2)"]
pub const TI2FP2 : Self = Self (0x06) ; # [doc = "External Trigger input (ETRF)"]
pub const ETRF : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Urs (pub u8) ; impl Urs { # [doc = "Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request"]
pub const ANYEVENT : Self = Self (0) ; # [doc = "Only counter overflow/underflow generates an update interrupt or DMA request"]
pub const COUNTERONLY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ossr (pub u8) ; impl Ossr { # [doc = "When inactive, OC/OCN outputs are disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "When inactive, OC/OCN outputs are enabled with their inactive level"]
pub const IDLELEVEL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ocpe (pub u8) ; impl Ocpe { # [doc = "Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately"]
pub const DISABLED : Self = Self (0) ; # [doc = "Preload register on CCR2 enabled. Preload value is loaded into active register on each update event"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct CcmrOutputCcs (pub u8) ; impl CcmrOutputCcs { # [doc = "CCx channel is configured as output"]
pub const OUTPUT : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sms (pub u8) ; impl Sms { # [doc = "Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock."]
pub const DISABLED : Self = Self (0) ; # [doc = "Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level."]
pub const ENCODER_MODE_1 : Self = Self (0x01) ; # [doc = "Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level."]
pub const ENCODER_MODE_2 : Self = Self (0x02) ; # [doc = "Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input."]
pub const ENCODER_MODE_3 : Self = Self (0x03) ; # [doc = "Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers."]
pub const RESET_MODE : Self = Self (0x04) ; # [doc = "Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled."]
pub const GATED_MODE : Self = Self (0x05) ; # [doc = "Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled."]
pub const TRIGGER_MODE : Self = Self (0x06) ; # [doc = "External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter."]
pub const EXT_CLOCK_MODE : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cms (pub u8) ; impl Cms { # [doc = "The counter counts up or down depending on the direction bit"]
pub const EDGEALIGNED : Self = Self (0) ; # [doc = "The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down."]
pub const CENTERALIGNED1 : Self = Self (0x01) ; # [doc = "The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up."]
pub const CENTERALIGNED2 : Self = Self (0x02) ; # [doc = "The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down."]
pub const CENTERALIGNED3 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ece (pub u8) ; impl Ece { # [doc = "External clock mode 2 disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal."]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ocm (pub u8) ; impl Ocm { # [doc = "The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs"]
pub const FROZEN : Self = Self (0) ; # [doc = "Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register"]
pub const ACTIVEONMATCH : Self = Self (0x01) ; # [doc = "Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register"]
pub const INACTIVEONMATCH : Self = Self (0x02) ; # [doc = "OCyREF toggles when TIMx_CNT=TIMx_CCRy"]
pub const TOGGLE : Self = Self (0x03) ; # [doc = "OCyREF is forced low"]
pub const FORCEINACTIVE : Self = Self (0x04) ; # [doc = "OCyREF is forced high"]
pub const FORCEACTIVE : Self = Self (0x05) ; # [doc = "In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active"]
pub const PWMMODE1 : Self = Self (0x06) ; # [doc = "Inversely to PwmMode1"]
pub const PWMMODE2 : Self = Self (0x07) ; } }