

# [doc = "System configuration controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Syscfg (pub * mut u8) ; unsafe impl Send for Syscfg { } unsafe impl Sync for Syscfg { } impl Syscfg { # [doc = "memory remap register"]
pub fn memrmp (self) -> crate :: common :: Reg < regs :: Memrmp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "configuration register 1"]
pub fn cfgr1 (self) -> crate :: common :: Reg < regs :: Cfgr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "external interrupt configuration register 1"]
pub fn exticr (self , n : usize) -> crate :: common :: Reg < regs :: Exticr , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize + n * 4usize)) } } # [doc = "SCSR"]
pub fn scsr (self) -> crate :: common :: Reg < regs :: Scsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "CFGR2"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "SWPR"]
pub fn swpr (self) -> crate :: common :: Reg < regs :: Swpr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "SKR"]
pub fn skr (self) -> crate :: common :: Reg < regs :: Skr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "radio debug control register"]
pub fn rfdcr (self) -> crate :: common :: Reg < regs :: Rfdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (520usize)) } } } pub mod regs { # [doc = "CFGR2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "CPU1 LOCKUP (Hardfault) output enable bit"]
pub const fn cll (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 LOCKUP (Hardfault) output enable bit"]
pub fn set_cll (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SRAM2 parity lock bit"]
pub const fn spl (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SRAM2 parity lock bit"]
pub fn set_spl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "PVD lock enable bit"]
pub const fn pvdl (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "PVD lock enable bit"]
pub fn set_pvdl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "ECC Lock"]
pub const fn eccl (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "ECC Lock"]
pub fn set_eccl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "SRAM2 parity error flag"]
pub const fn spf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "SRAM2 parity error flag"]
pub fn set_spf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "SCSR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Scsr (pub u32) ; impl Scsr { # [doc = "SRAM2 erase"]
pub const fn sram2er (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SRAM2 erase"]
pub fn set_sram2er (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SRAM1, SRAM2 and PKA SRAM busy by erase operation"]
pub const fn srambsy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SRAM1, SRAM2 and PKA SRAM busy by erase operation"]
pub fn set_srambsy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "PKA SRAM busy by erase operation"]
pub const fn pkasrambsy (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "PKA SRAM busy by erase operation"]
pub fn set_pkasrambsy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Scsr { fn default () -> Scsr { Scsr (0) } } # [doc = "SWPR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Swpr (pub u32) ; impl Swpr { # [doc = "SRAM2 1Kbyte page 0 write protection"]
pub fn pwp (& self , n : usize) -> bool { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "SRAM2 1Kbyte page 0 write protection"]
pub fn set_pwp (& mut self , n : usize , val : bool) { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Swpr { fn default () -> Swpr { Swpr (0) } } # [doc = "configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr1 (pub u32) ; impl Cfgr1 { # [doc = "I/O analog switch voltage booster enable"]
pub const fn boosten (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "I/O analog switch voltage booster enable"]
pub fn set_boosten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Fast-mode Plus (Fm+) driving capability activation on PB6"]
pub const fn i2c_pb6_fmp (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Fast-mode Plus (Fm+) driving capability activation on PB6"]
pub fn set_i2c_pb6_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Fast-mode Plus (Fm+) driving capability activation on PB7"]
pub const fn i2c_pb7_fmp (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Fast-mode Plus (Fm+) driving capability activation on PB7"]
pub fn set_i2c_pb7_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Fast-mode Plus (Fm+) driving capability activation on PB8"]
pub const fn i2c_pb8_fmp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Fast-mode Plus (Fm+) driving capability activation on PB8"]
pub fn set_i2c_pb8_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Fast-mode Plus (Fm+) driving capability activation on PB9"]
pub const fn i2c_pb9_fmp (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Fast-mode Plus (Fm+) driving capability activation on PB9"]
pub fn set_i2c_pb9_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "I2C1 Fast-mode Plus driving capability activation"]
pub const fn i2c1_fmp (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "I2C1 Fast-mode Plus driving capability activation"]
pub fn set_i2c1_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C2 Fast-mode Plus driving capability activation"]
pub const fn i2c2_fmp (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C2 Fast-mode Plus driving capability activation"]
pub fn set_i2c2_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C3 Fast-mode Plus driving capability activation"]
pub const fn i2c3_fmp (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C3 Fast-mode Plus driving capability activation"]
pub fn set_i2c3_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Cfgr1 { fn default () -> Cfgr1 { Cfgr1 (0) } } # [doc = "radio debug control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rfdcr (pub u32) ; impl Rfdcr { # [doc = "radio debug test bus selection"]
pub const fn rftbsel (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "radio debug test bus selection"]
pub fn set_rftbsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Rfdcr { fn default () -> Rfdcr { Rfdcr (0) } } # [doc = "SKR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Skr (pub u32) ; impl Skr { # [doc = "SRAM2 write protection key for software erase"]
pub const fn key (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "SRAM2 write protection key for software erase"]
pub fn set_key (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Skr { fn default () -> Skr { Skr (0) } } # [doc = "external interrupt configuration register 4"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Exticr (pub u32) ; impl Exticr { # [doc = "EXTI12 configuration bits"]
pub fn exti (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x07 ; val as u8 } # [doc = "EXTI12 configuration bits"]
pub fn set_exti (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val as u32) & 0x07) << offs) ; } } impl Default for Exticr { fn default () -> Exticr { Exticr (0) } } # [doc = "memory remap register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Memrmp (pub u32) ; impl Memrmp { # [doc = "Memory mapping selection"]
pub const fn mem_mode (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "Memory mapping selection"]
pub fn set_mem_mode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } } impl Default for Memrmp { fn default () -> Memrmp { Memrmp (0) } } }