

# [doc = "System configuration controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Syscfg (pub * mut u8) ; unsafe impl Send for Syscfg { } unsafe impl Sync for Syscfg { } impl Syscfg { # [doc = "SYSCFG secure configuration register"]
pub fn seccfgr (self) -> crate :: common :: Reg < regs :: Seccfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "configuration register 1"]
pub fn cfgr1 (self) -> crate :: common :: Reg < regs :: Cfgr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "FPU interrupt mask register"]
pub fn fpuimr (self) -> crate :: common :: Reg < regs :: Fpuimr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "SYSCFG CPU non-secure lock register"]
pub fn cnslckr (self) -> crate :: common :: Reg < regs :: Cnslckr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "SYSCFG CPU secure lock register"]
pub fn cslockr (self) -> crate :: common :: Reg < regs :: Cslockr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "configuration register 2"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "memory erase status register"]
pub fn mesr (self) -> crate :: common :: Reg < regs :: Mesr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "compensation cell control/status register"]
pub fn cccsr (self) -> crate :: common :: Reg < regs :: Cccsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "compensation cell value register"]
pub fn ccvr (self) -> crate :: common :: Reg < regs :: Ccvr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "compensation cell code register"]
pub fn cccr (self) -> crate :: common :: Reg < regs :: Cccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "RSS command register"]
pub fn rsscmdr (self) -> crate :: common :: Reg < regs :: Rsscmdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "USB Type C and Power Delivery register"]
pub fn ucpdr (self) -> crate :: common :: Reg < regs :: Ucpdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } } pub mod regs { # [doc = "configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "LOCKUP (hardfault) output enable bit"]
pub const fn cll (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LOCKUP (hardfault) output enable bit"]
pub fn set_cll (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SRAM ECC lock bit"]
pub const fn spl (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SRAM ECC lock bit"]
pub fn set_spl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "PVD lock enable bit"]
pub const fn pvdl (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "PVD lock enable bit"]
pub fn set_pvdl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "ECC Lock"]
pub const fn eccl (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "ECC Lock"]
pub fn set_eccl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "SYSCFG secure configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Seccfgr (pub u32) ; impl Seccfgr { # [doc = "SYSCFG clock control security"]
pub const fn syscfgsec (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYSCFG clock control security"]
pub fn set_syscfgsec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CLASSBSEC"]
pub const fn classbsec (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CLASSBSEC"]
pub fn set_classbsec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "FPUSEC"]
pub const fn fpusec (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "FPUSEC"]
pub fn set_fpusec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } } impl Default for Seccfgr { fn default () -> Seccfgr { Seccfgr (0) } } # [doc = "USB Type C and Power Delivery register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ucpdr (pub u32) ; impl Ucpdr { # [doc = "CC1ENRXFILTER"]
pub const fn cc1enrxfilter (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CC1ENRXFILTER"]
pub fn set_cc1enrxfilter (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CC2ENRXFILTER"]
pub const fn cc2enrxfilter (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CC2ENRXFILTER"]
pub fn set_cc2enrxfilter (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Ucpdr { fn default () -> Ucpdr { Ucpdr (0) } } # [doc = "FPU interrupt mask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fpuimr (pub u32) ; impl Fpuimr { # [doc = "Floating point unit interrupts enable bits"]
pub const fn fpu_ie (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Floating point unit interrupts enable bits"]
pub fn set_fpu_ie (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } } impl Default for Fpuimr { fn default () -> Fpuimr { Fpuimr (0) } } # [doc = "SYSCFG CPU non-secure lock register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cnslckr (pub u32) ; impl Cnslckr { # [doc = "VTOR_NS register lock"]
pub const fn locknsvtor (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "VTOR_NS register lock"]
pub fn set_locknsvtor (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Non-secure MPU registers lock"]
pub const fn locknsmpu (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Non-secure MPU registers lock"]
pub fn set_locknsmpu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Cnslckr { fn default () -> Cnslckr { Cnslckr (0) } } # [doc = "configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr1 (pub u32) ; impl Cfgr1 { # [doc = "I/O analog switch voltage booster enable"]
pub const fn boosten (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "I/O analog switch voltage booster enable"]
pub fn set_boosten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "GPIO analog switch control voltage selection"]
pub const fn anaswvdd (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "GPIO analog switch control voltage selection"]
pub fn set_anaswvdd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "PB6_FMP"]
pub const fn pb6_fmp (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PB6_FMP"]
pub fn set_pb6_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "PB7_FMP"]
pub const fn pb7_fmp (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "PB7_FMP"]
pub fn set_pb7_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "PB8_FMP"]
pub const fn pb8_fmp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "PB8_FMP"]
pub fn set_pb8_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "PB9_FMP"]
pub const fn pb9_fmp (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "PB9_FMP"]
pub fn set_pb9_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } } impl Default for Cfgr1 { fn default () -> Cfgr1 { Cfgr1 (0) } } # [doc = "SYSCFG CPU secure lock register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cslockr (pub u32) ; impl Cslockr { # [doc = "LOCKSVTAIRCR"]
pub const fn locksvtaircr (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LOCKSVTAIRCR"]
pub fn set_locksvtaircr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LOCKSMPU"]
pub const fn locksmpu (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LOCKSMPU"]
pub fn set_locksmpu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LOCKSAU"]
pub const fn locksau (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "LOCKSAU"]
pub fn set_locksau (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Cslockr { fn default () -> Cslockr { Cslockr (0) } } # [doc = "compensation cell code register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cccr (pub u32) ; impl Cccr { # [doc = "NCC1"]
pub const fn ncc1 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "NCC1"]
pub fn set_ncc1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "PCC1"]
pub const fn pcc1 (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "PCC1"]
pub fn set_pcc1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "NCC2"]
pub const fn ncc2 (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "NCC2"]
pub fn set_ncc2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "PCC2"]
pub const fn pcc2 (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x0f ; val as u8 } # [doc = "PCC2"]
pub fn set_pcc2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 12usize)) | (((val as u32) & 0x0f) << 12usize) ; } } impl Default for Cccr { fn default () -> Cccr { Cccr (0) } } # [doc = "compensation cell value register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccvr (pub u32) ; impl Ccvr { # [doc = "NCV1"]
pub const fn ncv1 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "NCV1"]
pub fn set_ncv1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "PCV1"]
pub const fn pcv1 (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "PCV1"]
pub fn set_pcv1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "NCV2"]
pub const fn ncv2 (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "NCV2"]
pub fn set_ncv2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "PCV2"]
pub const fn pcv2 (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x0f ; val as u8 } # [doc = "PCV2"]
pub fn set_pcv2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 12usize)) | (((val as u32) & 0x0f) << 12usize) ; } } impl Default for Ccvr { fn default () -> Ccvr { Ccvr (0) } } # [doc = "RSS command register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rsscmdr (pub u32) ; impl Rsscmdr { # [doc = "RSS commands"]
pub const fn rsscmd (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "RSS commands"]
pub fn set_rsscmd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Rsscmdr { fn default () -> Rsscmdr { Rsscmdr (0) } } # [doc = "memory erase status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mesr (pub u32) ; impl Mesr { # [doc = "MCLR"]
pub const fn mclr (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "MCLR"]
pub fn set_mclr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IPMEE"]
pub const fn ipmee (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "IPMEE"]
pub fn set_ipmee (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Mesr { fn default () -> Mesr { Mesr (0) } } # [doc = "compensation cell control/status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cccsr (pub u32) ; impl Cccsr { # [doc = "EN1"]
pub const fn en1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "EN1"]
pub fn set_en1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CS1"]
pub const fn cs1 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CS1"]
pub fn set_cs1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "EN2"]
pub const fn en2 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "EN2"]
pub fn set_en2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CS2"]
pub const fn cs2 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CS2"]
pub fn set_cs2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "RDY1"]
pub const fn rdy1 (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "RDY1"]
pub fn set_rdy1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "RDY2"]
pub const fn rdy2 (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "RDY2"]
pub fn set_rdy2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for Cccsr { fn default () -> Cccsr { Cccsr (0) } } }