

# [doc = "System configuration controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Syscfg (pub * mut u8) ; unsafe impl Send for Syscfg { } unsafe impl Sync for Syscfg { } impl Syscfg { # [doc = "memory remap register"]
pub fn memrmp (self) -> crate :: common :: Reg < regs :: Memrmp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "peripheral mode configuration register"]
pub fn pmc (self) -> crate :: common :: Reg < regs :: Pmc , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "external interrupt configuration register 1"]
pub fn exticr (self , n : usize) -> crate :: common :: Reg < regs :: Exticr , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize + n * 4usize)) } } } pub mod regs { # [doc = "peripheral mode configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pmc (pub u32) ; impl Pmc { # [doc = "USB pull-up"]
pub const fn usb_pu (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "USB pull-up"]
pub fn set_usb_pu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "USB pull-up enable on DP line"]
pub const fn lcd_capa (& self) -> u8 { let val = (self . 0 >> 1usize) & 0x1f ; val as u8 } # [doc = "USB pull-up enable on DP line"]
pub fn set_lcd_capa (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 1usize)) | (((val as u32) & 0x1f) << 1usize) ; } } impl Default for Pmc { fn default () -> Pmc { Pmc (0) } } # [doc = "external interrupt configuration register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Exticr (pub u32) ; impl Exticr { # [doc = "EXTI x configuration (x = 8 to 11)"]
pub fn exti (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x0f ; val as u8 } # [doc = "EXTI x configuration (x = 8 to 11)"]
pub fn set_exti (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x0f << offs)) | (((val as u32) & 0x0f) << offs) ; } } impl Default for Exticr { fn default () -> Exticr { Exticr (0) } } # [doc = "memory remap register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Memrmp (pub u32) ; impl Memrmp { # [doc = "MEM_MODE"]
pub const fn mem_mode (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "MEM_MODE"]
pub fn set_mem_mode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "BOOT_MODE"]
pub const fn boot_mode (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "BOOT_MODE"]
pub fn set_boot_mode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } } impl Default for Memrmp { fn default () -> Memrmp { Memrmp (0) } } }