

# [doc = "System configuration controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Syscfg (pub * mut u8) ; unsafe impl Send for Syscfg { } unsafe impl Sync for Syscfg { } impl Syscfg { # [doc = "peripheral mode configuration register"]
pub fn pmcr (self) -> crate :: common :: Reg < regs :: Pmcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "external interrupt configuration register"]
pub fn exticr (self , n : usize) -> crate :: common :: Reg < regs :: Exticr , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize + n * 4usize)) } } # [doc = "compensation cell control/status register"]
pub fn cccsr (self) -> crate :: common :: Reg < regs :: Cccsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "SYSCFG compensation cell value register"]
pub fn ccvr (self) -> crate :: common :: Reg < regs :: Ccvr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "SYSCFG compensation cell code register"]
pub fn cccr (self) -> crate :: common :: Reg < regs :: Cccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "SYSCFG power control register"]
pub fn pwrcr (self) -> crate :: common :: Reg < regs :: Pwrcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "SYSCFG package register"]
pub fn pkgr (self) -> crate :: common :: Reg < regs :: Pkgr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (292usize)) } } # [doc = "SYSCFG user register 0"]
pub fn ur0 (self) -> crate :: common :: Reg < regs :: Ur0 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (768usize)) } } # [doc = "SYSCFG user register 2"]
pub fn ur2 (self) -> crate :: common :: Reg < regs :: Ur2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (776usize)) } } # [doc = "SYSCFG user register 3"]
pub fn ur3 (self) -> crate :: common :: Reg < regs :: Ur3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (780usize)) } } # [doc = "SYSCFG user register 4"]
pub fn ur4 (self) -> crate :: common :: Reg < regs :: Ur4 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (784usize)) } } # [doc = "SYSCFG user register 5"]
pub fn ur5 (self) -> crate :: common :: Reg < regs :: Ur5 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (788usize)) } } # [doc = "SYSCFG user register 6"]
pub fn ur6 (self) -> crate :: common :: Reg < regs :: Ur6 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (792usize)) } } # [doc = "SYSCFG user register 7"]
pub fn ur7 (self) -> crate :: common :: Reg < regs :: Ur7 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (796usize)) } } # [doc = "SYSCFG user register 8"]
pub fn ur8 (self) -> crate :: common :: Reg < regs :: Ur8 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (800usize)) } } # [doc = "SYSCFG user register 9"]
pub fn ur9 (self) -> crate :: common :: Reg < regs :: Ur9 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (804usize)) } } # [doc = "SYSCFG user register 10"]
pub fn ur10 (self) -> crate :: common :: Reg < regs :: Ur10 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (808usize)) } } # [doc = "SYSCFG user register 11"]
pub fn ur11 (self) -> crate :: common :: Reg < regs :: Ur11 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (812usize)) } } # [doc = "SYSCFG user register 12"]
pub fn ur12 (self) -> crate :: common :: Reg < regs :: Ur12 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (816usize)) } } # [doc = "SYSCFG user register 13"]
pub fn ur13 (self) -> crate :: common :: Reg < regs :: Ur13 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (820usize)) } } # [doc = "SYSCFG user register 14"]
pub fn ur14 (self) -> crate :: common :: Reg < regs :: Ur14 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (824usize)) } } # [doc = "SYSCFG user register 15"]
pub fn ur15 (self) -> crate :: common :: Reg < regs :: Ur15 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (828usize)) } } # [doc = "SYSCFG user register 16"]
pub fn ur16 (self) -> crate :: common :: Reg < regs :: Ur16 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (832usize)) } } # [doc = "SYSCFG user register 17"]
pub fn ur17 (self) -> crate :: common :: Reg < regs :: Ur17 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (836usize)) } } } pub mod regs { # [doc = "SYSCFG user register 15"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur15 (pub u32) ; impl Ur15 { # [doc = "Freeze independent watchdog in Standby mode"]
pub const fn fziwdgstb (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Freeze independent watchdog in Standby mode"]
pub fn set_fziwdgstb (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ur15 { fn default () -> Ur15 { Ur15 (0) } } # [doc = "external interrupt configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Exticr (pub u32) ; impl Exticr { # [doc = "EXTI x configuration (x = 4 to 7)"]
pub fn exti (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x0f ; val as u8 } # [doc = "EXTI x configuration (x = 4 to 7)"]
pub fn set_exti (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x0f << offs)) | (((val as u32) & 0x0f) << offs) ; } } impl Default for Exticr { fn default () -> Exticr { Exticr (0) } } # [doc = "SYSCFG user register 6"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur6 (pub u32) ; impl Ur6 { # [doc = "Protected area start address for bank 1"]
pub const fn pa_beg_1 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Protected area start address for bank 1"]
pub fn set_pa_beg_1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Protected area end address for bank 1"]
pub const fn pa_end_1 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Protected area end address for bank 1"]
pub fn set_pa_end_1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Ur6 { fn default () -> Ur6 { Ur6 (0) } } # [doc = "SYSCFG user register 14"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur14 (pub u32) ; impl Ur14 { # [doc = "D1 Stop Reset"]
pub const fn d1stprst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "D1 Stop Reset"]
pub fn set_d1stprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Ur14 { fn default () -> Ur14 { Ur14 (0) } } # [doc = "SYSCFG user register 10"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur10 (pub u32) ; impl Ur10 { # [doc = "Protected area end address for bank 2"]
pub const fn pa_end_2 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Protected area end address for bank 2"]
pub fn set_pa_end_2 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Secured area start address for bank 2"]
pub const fn sa_beg_2 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Secured area start address for bank 2"]
pub fn set_sa_beg_2 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Ur10 { fn default () -> Ur10 { Ur10 (0) } } # [doc = "peripheral mode configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pmcr (pub u32) ; impl Pmcr { # [doc = "I2C1 Fm+"]
pub const fn i2c1fmp (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "I2C1 Fm+"]
pub fn set_i2c1fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "I2C2 Fm+"]
pub const fn i2c2fmp (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "I2C2 Fm+"]
pub fn set_i2c2fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "I2C3 Fm+"]
pub const fn i2c3fmp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "I2C3 Fm+"]
pub fn set_i2c3fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "I2C4 Fm+"]
pub const fn i2c4fmp (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "I2C4 Fm+"]
pub fn set_i2c4fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "PB(6) Fm+"]
pub const fn pb6fmp (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PB(6) Fm+"]
pub fn set_pb6fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PB(7) Fast Mode Plus"]
pub const fn pb7fmp (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PB(7) Fast Mode Plus"]
pub fn set_pb7fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PB(8) Fast Mode Plus"]
pub const fn pb8fmp (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "PB(8) Fast Mode Plus"]
pub fn set_pb8fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "PB(9) Fm+"]
pub const fn pb9fmp (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "PB(9) Fm+"]
pub fn set_pb9fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Booster Enable"]
pub const fn booste (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Booster Enable"]
pub fn set_booste (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Analog switch supply voltage selection"]
pub const fn boostvddsel (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Analog switch supply voltage selection"]
pub fn set_boostvddsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Ethernet PHY Interface Selection"]
pub const fn epis (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x07 ; val as u8 } # [doc = "Ethernet PHY Interface Selection"]
pub fn set_epis (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 21usize)) | (((val as u32) & 0x07) << 21usize) ; } # [doc = "PA0 Switch Open"]
pub const fn pa0so (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "PA0 Switch Open"]
pub fn set_pa0so (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "PA1 Switch Open"]
pub const fn pa1so (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "PA1 Switch Open"]
pub fn set_pa1so (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PC2 Switch Open"]
pub const fn pc2so (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PC2 Switch Open"]
pub fn set_pc2so (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "PC3 Switch Open"]
pub const fn pc3so (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "PC3 Switch Open"]
pub fn set_pc3so (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Pmcr { fn default () -> Pmcr { Pmcr (0) } } # [doc = "SYSCFG compensation cell code register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cccr (pub u32) ; impl Cccr { # [doc = "NMOS compensation code"]
pub const fn ncc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "NMOS compensation code"]
pub fn set_ncc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "PMOS compensation code"]
pub const fn pcc (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "PMOS compensation code"]
pub fn set_pcc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } } impl Default for Cccr { fn default () -> Cccr { Cccr (0) } } # [doc = "SYSCFG user register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur2 (pub u32) ; impl Ur2 { # [doc = "BOR_LVL Brownout Reset Threshold Level"]
pub const fn borh (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "BOR_LVL Brownout Reset Threshold Level"]
pub fn set_borh (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Boot Address 0"]
pub const fn boot_add0 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Boot Address 0"]
pub fn set_boot_add0 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Ur2 { fn default () -> Ur2 { Ur2 (0) } } # [doc = "SYSCFG user register 0"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur0 (pub u32) ; impl Ur0 { # [doc = "Bank Swap"]
pub const fn bks (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Bank Swap"]
pub fn set_bks (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Readout protection"]
pub const fn rdp (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Readout protection"]
pub fn set_rdp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Ur0 { fn default () -> Ur0 { Ur0 (0) } } # [doc = "SYSCFG user register 11"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur11 (pub u32) ; impl Ur11 { # [doc = "Secured area end address for bank 2"]
pub const fn sa_end_2 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Secured area end address for bank 2"]
pub fn set_sa_end_2 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Independent Watchdog 1 mode"]
pub const fn iwdg1m (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Independent Watchdog 1 mode"]
pub fn set_iwdg1m (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ur11 { fn default () -> Ur11 { Ur11 (0) } } # [doc = "SYSCFG power control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pwrcr (pub u32) ; impl Pwrcr { # [doc = "Overdrive enable"]
pub const fn oden (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Overdrive enable"]
pub fn set_oden (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } } impl Default for Pwrcr { fn default () -> Pwrcr { Pwrcr (0) } } # [doc = "SYSCFG user register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur3 (pub u32) ; impl Ur3 { # [doc = "Boot Address 1"]
pub const fn boot_add1 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Boot Address 1"]
pub fn set_boot_add1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Ur3 { fn default () -> Ur3 { Ur3 (0) } } # [doc = "SYSCFG user register 16"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur16 (pub u32) ; impl Ur16 { # [doc = "Freeze independent watchdog in Stop mode"]
pub const fn fziwdgstp (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Freeze independent watchdog in Stop mode"]
pub fn set_fziwdgstp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Private key programmed"]
pub const fn pkp (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Private key programmed"]
pub fn set_pkp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ur16 { fn default () -> Ur16 { Ur16 (0) } } # [doc = "SYSCFG user register 13"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur13 (pub u32) ; impl Ur13 { # [doc = "Secured DTCM RAM Size"]
pub const fn sdrs (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Secured DTCM RAM Size"]
pub fn set_sdrs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "D1 Standby reset"]
pub const fn d1sbrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "D1 Standby reset"]
pub fn set_d1sbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ur13 { fn default () -> Ur13 { Ur13 (0) } } # [doc = "compensation cell control/status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cccsr (pub u32) ; impl Cccsr { # [doc = "enable"]
pub const fn en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "enable"]
pub fn set_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Code selection"]
pub const fn cs (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Code selection"]
pub fn set_cs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Compensation cell ready flag"]
pub const fn ready (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Compensation cell ready flag"]
pub fn set_ready (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "High-speed at low-voltage"]
pub const fn hslv (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "High-speed at low-voltage"]
pub fn set_hslv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Cccsr { fn default () -> Cccsr { Cccsr (0) } } # [doc = "SYSCFG user register 17"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur17 (pub u32) ; impl Ur17 { # [doc = "I/O high speed / low voltage"]
pub const fn io_hslv (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "I/O high speed / low voltage"]
pub fn set_io_hslv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Ur17 { fn default () -> Ur17 { Ur17 (0) } } # [doc = "SYSCFG user register 12"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur12 (pub u32) ; impl Ur12 { # [doc = "Secure mode"]
pub const fn secure (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Secure mode"]
pub fn set_secure (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ur12 { fn default () -> Ur12 { Ur12 (0) } } # [doc = "SYSCFG package register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pkgr (pub u32) ; impl Pkgr { # [doc = "Package"]
pub const fn pkg (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Package"]
pub fn set_pkg (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } } impl Default for Pkgr { fn default () -> Pkgr { Pkgr (0) } } # [doc = "SYSCFG compensation cell value register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccvr (pub u32) ; impl Ccvr { # [doc = "NMOS compensation value"]
pub const fn ncv (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "NMOS compensation value"]
pub fn set_ncv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "PMOS compensation value"]
pub const fn pcv (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "PMOS compensation value"]
pub fn set_pcv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } } impl Default for Ccvr { fn default () -> Ccvr { Ccvr (0) } } # [doc = "SYSCFG user register 8"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur8 (pub u32) ; impl Ur8 { # [doc = "Mass erase protected area disabled for bank 2"]
pub const fn mepad_2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Mass erase protected area disabled for bank 2"]
pub fn set_mepad_2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Mass erase secured area disabled for bank 2"]
pub const fn mesad_2 (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Mass erase secured area disabled for bank 2"]
pub fn set_mesad_2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ur8 { fn default () -> Ur8 { Ur8 (0) } } # [doc = "SYSCFG user register 7"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur7 (pub u32) ; impl Ur7 { # [doc = "Secured area start address for bank 1"]
pub const fn sa_beg_1 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Secured area start address for bank 1"]
pub fn set_sa_beg_1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Secured area end address for bank 1"]
pub const fn sa_end_1 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Secured area end address for bank 1"]
pub fn set_sa_end_1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Ur7 { fn default () -> Ur7 { Ur7 (0) } } # [doc = "SYSCFG user register 4"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur4 (pub u32) ; impl Ur4 { # [doc = "Mass Erase Protected Area Disabled for bank 1"]
pub const fn mepad_1 (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Mass Erase Protected Area Disabled for bank 1"]
pub fn set_mepad_1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ur4 { fn default () -> Ur4 { Ur4 (0) } } # [doc = "SYSCFG user register 5"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur5 (pub u32) ; impl Ur5 { # [doc = "Mass erase secured area disabled for bank 1"]
pub const fn mesad_1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Mass erase secured area disabled for bank 1"]
pub fn set_mesad_1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Write protection for flash bank 1"]
pub const fn wrpn_1 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Write protection for flash bank 1"]
pub fn set_wrpn_1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Ur5 { fn default () -> Ur5 { Ur5 (0) } } # [doc = "SYSCFG user register 9"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ur9 (pub u32) ; impl Ur9 { # [doc = "Write protection for flash bank 2"]
pub const fn wrpn_2 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Write protection for flash bank 2"]
pub fn set_wrpn_2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Protected area start address for bank 2"]
pub const fn pa_beg_2 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Protected area start address for bank 2"]
pub fn set_pa_beg_2 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Ur9 { fn default () -> Ur9 { Ur9 (0) } } }