

# [doc = "System configuration controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Syscfg (pub * mut u8) ; unsafe impl Send for Syscfg { } unsafe impl Sync for Syscfg { } impl Syscfg { # [doc = "SYSCFG configuration register 1"]
pub fn cfgr1 (self) -> crate :: common :: Reg < regs :: Cfgr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "SYSCFG configuration register 1"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "VREFBUF control and status register"]
pub fn vrefbuf_csr (self) -> crate :: common :: Reg < regs :: VrefbufCsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "VREFBUF calibration control register"]
pub fn vrefbuf_ccr (self) -> crate :: common :: Reg < regs :: VrefbufCcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "interrupt line 0 status register"]
pub fn itline0 (self) -> crate :: common :: Reg < regs :: Itline0 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "interrupt line 1 status register"]
pub fn itline1 (self) -> crate :: common :: Reg < regs :: Itline1 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize)) } } # [doc = "interrupt line 2 status register"]
pub fn itline2 (self) -> crate :: common :: Reg < regs :: Itline2 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "interrupt line 3 status register"]
pub fn itline3 (self) -> crate :: common :: Reg < regs :: Itline3 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (140usize)) } } # [doc = "interrupt line 4 status register"]
pub fn itline4 (self) -> crate :: common :: Reg < regs :: Itline4 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } # [doc = "interrupt line 5 status register"]
pub fn itline5 (self) -> crate :: common :: Reg < regs :: Itline5 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (148usize)) } } # [doc = "interrupt line 6 status register"]
pub fn itline6 (self) -> crate :: common :: Reg < regs :: Itline6 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (152usize)) } } # [doc = "interrupt line 7 status register"]
pub fn itline7 (self) -> crate :: common :: Reg < regs :: Itline7 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (156usize)) } } # [doc = "interrupt line 8 status register"]
pub fn itline8 (self) -> crate :: common :: Reg < regs :: Itline8 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (160usize)) } } # [doc = "interrupt line 9 status register"]
pub fn itline9 (self) -> crate :: common :: Reg < regs :: Itline9 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (164usize)) } } # [doc = "interrupt line 10 status register"]
pub fn itline10 (self) -> crate :: common :: Reg < regs :: Itline10 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (168usize)) } } # [doc = "interrupt line 11 status register"]
pub fn itline11 (self) -> crate :: common :: Reg < regs :: Itline11 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (172usize)) } } # [doc = "interrupt line 12 status register"]
pub fn itline12 (self) -> crate :: common :: Reg < regs :: Itline12 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (176usize)) } } # [doc = "interrupt line 13 status register"]
pub fn itline13 (self) -> crate :: common :: Reg < regs :: Itline13 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (180usize)) } } # [doc = "interrupt line 14 status register"]
pub fn itline14 (self) -> crate :: common :: Reg < regs :: Itline14 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (184usize)) } } # [doc = "interrupt line 15 status register"]
pub fn itline15 (self) -> crate :: common :: Reg < regs :: Itline15 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (188usize)) } } # [doc = "interrupt line 16 status register"]
pub fn itline16 (self) -> crate :: common :: Reg < regs :: Itline16 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (192usize)) } } # [doc = "interrupt line 17 status register"]
pub fn itline17 (self) -> crate :: common :: Reg < regs :: Itline17 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (196usize)) } } # [doc = "interrupt line 18 status register"]
pub fn itline18 (self) -> crate :: common :: Reg < regs :: Itline18 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (200usize)) } } # [doc = "interrupt line 19 status register"]
pub fn itline19 (self) -> crate :: common :: Reg < regs :: Itline19 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (204usize)) } } # [doc = "interrupt line 20 status register"]
pub fn itline20 (self) -> crate :: common :: Reg < regs :: Itline20 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (208usize)) } } # [doc = "interrupt line 21 status register"]
pub fn itline21 (self) -> crate :: common :: Reg < regs :: Itline21 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (212usize)) } } # [doc = "interrupt line 22 status register"]
pub fn itline22 (self) -> crate :: common :: Reg < regs :: Itline22 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (216usize)) } } # [doc = "interrupt line 23 status register"]
pub fn itline23 (self) -> crate :: common :: Reg < regs :: Itline23 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (220usize)) } } # [doc = "interrupt line 24 status register"]
pub fn itline24 (self) -> crate :: common :: Reg < regs :: Itline24 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (224usize)) } } # [doc = "interrupt line 25 status register"]
pub fn itline25 (self) -> crate :: common :: Reg < regs :: Itline25 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (228usize)) } } # [doc = "interrupt line 26 status register"]
pub fn itline26 (self) -> crate :: common :: Reg < regs :: Itline26 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (232usize)) } } # [doc = "interrupt line 27 status register"]
pub fn itline27 (self) -> crate :: common :: Reg < regs :: Itline27 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (236usize)) } } # [doc = "interrupt line 28 status register"]
pub fn itline28 (self) -> crate :: common :: Reg < regs :: Itline28 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (240usize)) } } # [doc = "interrupt line 29 status register"]
pub fn itline29 (self) -> crate :: common :: Reg < regs :: Itline29 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (244usize)) } } # [doc = "interrupt line 30 status register"]
pub fn itline30 (self) -> crate :: common :: Reg < regs :: Itline30 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (248usize)) } } # [doc = "interrupt line 31 status register"]
pub fn itline31 (self) -> crate :: common :: Reg < regs :: Itline31 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (252usize)) } } } pub mod regs { # [doc = "interrupt line 6 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline6 (pub u32) ; impl Itline6 { # [doc = "EXTI2"]
pub fn exti (& self , n : usize) -> bool { assert ! (n < 2usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "EXTI2"]
pub fn set_exti (& mut self , n : usize , val : bool) { assert ! (n < 2usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline6 { fn default () -> Itline6 { Itline6 (0) } } # [doc = "interrupt line 10 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline10 (pub u32) ; impl Itline10 { # [doc = "DMA1_CH1"]
pub const fn dma1_ch2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1_CH1"]
pub fn set_dma1_ch2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA1_CH3"]
pub const fn dma1_ch3 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA1_CH3"]
pub fn set_dma1_ch3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Itline10 { fn default () -> Itline10 { Itline10 (0) } } # [doc = "interrupt line 9 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline9 (pub u32) ; impl Itline9 { # [doc = "DMA1_CH1"]
pub const fn dma1_ch1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1_CH1"]
pub fn set_dma1_ch1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Itline9 { fn default () -> Itline9 { Itline9 (0) } } # [doc = "interrupt line 14 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline14 (pub u32) ; impl Itline14 { # [doc = "TIM1_CC"]
pub const fn tim1_cc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1_CC"]
pub fn set_tim1_cc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Itline14 { fn default () -> Itline14 { Itline14 (0) } } # [doc = "interrupt line 18 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline18 (pub u32) ; impl Itline18 { # [doc = "TIM7"]
pub fn tim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TIM7"]
pub fn set_tim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "LPTIM2"]
pub fn lptim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 1usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "LPTIM2"]
pub fn set_lptim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 1usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline18 { fn default () -> Itline18 { Itline18 (0) } } # [doc = "interrupt line 16 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline16 (pub u32) ; impl Itline16 { # [doc = "TIM3"]
pub fn tim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TIM3"]
pub fn set_tim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline16 { fn default () -> Itline16 { Itline16 (0) } } # [doc = "interrupt line 1 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline1 (pub u32) ; impl Itline1 { # [doc = "PVD supply monitoring interrupt request pending (EXTI line 16)."]
pub const fn pvdout (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "PVD supply monitoring interrupt request pending (EXTI line 16)."]
pub fn set_pvdout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Itline1 { fn default () -> Itline1 { Itline1 (0) } } # [doc = "interrupt line 21 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline21 (pub u32) ; impl Itline21 { # [doc = "TIM16"]
pub fn tim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TIM16"]
pub fn set_tim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline21 { fn default () -> Itline21 { Itline21 (0) } } # [doc = "interrupt line 27 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline27 (pub u32) ; impl Itline27 { # [doc = "USART1"]
pub fn usart (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "USART1"]
pub fn set_usart (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline27 { fn default () -> Itline27 { Itline27 (0) } } # [doc = "interrupt line 23 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline23 (pub u32) ; impl Itline23 { # [doc = "I2C1"]
pub const fn i2c1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "I2C1"]
pub fn set_i2c1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Itline23 { fn default () -> Itline23 { Itline23 (0) } } # [doc = "interrupt line 19 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline19 (pub u32) ; impl Itline19 { # [doc = "TIM14"]
pub fn tim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TIM14"]
pub fn set_tim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline19 { fn default () -> Itline19 { Itline19 (0) } } # [doc = "interrupt line 11 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline11 (pub u32) ; impl Itline11 { # [doc = "DMAMUX"]
pub const fn dmamux (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMAMUX"]
pub fn set_dmamux (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA1_CH4"]
pub const fn dma1_ch4 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA1_CH4"]
pub fn set_dma1_ch4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMA1_CH5"]
pub const fn dma1_ch5 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMA1_CH5"]
pub fn set_dma1_ch5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "DMA1_CH6"]
pub const fn dma1_ch6 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "DMA1_CH6"]
pub fn set_dma1_ch6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "DMA1_CH7"]
pub const fn dma1_ch7 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "DMA1_CH7"]
pub fn set_dma1_ch7 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Itline11 { fn default () -> Itline11 { Itline11 (0) } } # [doc = "VREFBUF control and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct VrefbufCsr (pub u32) ; impl VrefbufCsr { # [doc = "Voltage reference buffer mode enable This bit is used to enable the voltage reference buffer mode."]
pub const fn envr (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Voltage reference buffer mode enable This bit is used to enable the voltage reference buffer mode."]
pub fn set_envr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "High impedance mode This bit controls the analog switch to connect or not the VREF+ pin. Refer to Table196: VREF buffer modes for the mode descriptions depending on ENVR bit configuration."]
pub const fn hiz (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "High impedance mode This bit controls the analog switch to connect or not the VREF+ pin. Refer to Table196: VREF buffer modes for the mode descriptions depending on ENVR bit configuration."]
pub fn set_hiz (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Voltage reference buffer ready"]
pub const fn vrr (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Voltage reference buffer ready"]
pub fn set_vrr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Voltage reference scale These bits select the value generated by the voltage reference buffer. Other: Reserved"]
pub const fn vrs (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Voltage reference scale These bits select the value generated by the voltage reference buffer. Other: Reserved"]
pub fn set_vrs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } } impl Default for VrefbufCsr { fn default () -> VrefbufCsr { VrefbufCsr (0) } } # [doc = "interrupt line 4 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline4 (pub u32) ; impl Itline4 { # [doc = "RCC"]
pub const fn rcc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "RCC"]
pub fn set_rcc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Itline4 { fn default () -> Itline4 { Itline4 (0) } } # [doc = "SYSCFG configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr1 (pub u32) ; impl Cfgr1 { # [doc = "Memory mapping selection bits"]
pub const fn mem_mode (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Memory mapping selection bits"]
pub fn set_mem_mode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "PA11 and PA12 remapping bit."]
pub const fn pa11_pa12_rmp (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PA11 and PA12 remapping bit."]
pub fn set_pa11_pa12_rmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IR output polarity selection"]
pub const fn ir_pol (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IR output polarity selection"]
pub fn set_ir_pol (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IR Modulation Envelope signal selection."]
pub const fn ir_mod (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x03 ; val as u8 } # [doc = "IR Modulation Envelope signal selection."]
pub fn set_ir_mod (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val as u32) & 0x03) << 6usize) ; } # [doc = "I/O analog switch voltage booster enable"]
pub const fn boosten (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "I/O analog switch voltage booster enable"]
pub fn set_boosten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Strobe signal bit for UCPD1"]
pub const fn ucpd1_strobe (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Strobe signal bit for UCPD1"]
pub fn set_ucpd1_strobe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Strobe signal bit for UCPD2"]
pub const fn ucpd2_strobe (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Strobe signal bit for UCPD2"]
pub fn set_ucpd2_strobe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits"]
pub const fn i2c_pbx_fmp (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Fast Mode Plus (FM+) driving capability activation bits"]
pub fn set_i2c_pbx_fmp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "FM+ driving capability activation for I2C1"]
pub const fn i2c1_fmp (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "FM+ driving capability activation for I2C1"]
pub fn set_i2c1_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "FM+ driving capability activation for I2C2"]
pub const fn i2c2_fmp (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "FM+ driving capability activation for I2C2"]
pub fn set_i2c2_fmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits"]
pub const fn i2c_pax_fmp (& self) -> u8 { let val = (self . 0 >> 22usize) & 0x03 ; val as u8 } # [doc = "Fast Mode Plus (FM+) driving capability activation bits"]
pub fn set_i2c_pax_fmp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val as u32) & 0x03) << 22usize) ; } } impl Default for Cfgr1 { fn default () -> Cfgr1 { Cfgr1 (0) } } # [doc = "interrupt line 12 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline12 (pub u32) ; impl Itline12 { # [doc = "ADC"]
pub const fn adc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "ADC"]
pub fn set_adc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "COMP1"]
pub fn comp (& self , n : usize) -> bool { assert ! (n < 2usize) ; let offs = 1usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "COMP1"]
pub fn set_comp (& mut self , n : usize , val : bool) { assert ! (n < 2usize) ; let offs = 1usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline12 { fn default () -> Itline12 { Itline12 (0) } } # [doc = "interrupt line 30 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline30 (pub u32) ; impl Itline30 { # [doc = "CEC"]
pub fn usart (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "CEC"]
pub fn set_usart (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline30 { fn default () -> Itline30 { Itline30 (0) } } # [doc = "interrupt line 20 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline20 (pub u32) ; impl Itline20 { # [doc = "TIM15"]
pub fn tim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TIM15"]
pub fn set_tim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline20 { fn default () -> Itline20 { Itline20 (0) } } # [doc = "interrupt line 13 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline13 (pub u32) ; impl Itline13 { # [doc = "TIM1_CCU"]
pub const fn tim1_ccu (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1_CCU"]
pub fn set_tim1_ccu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM1_TRG"]
pub const fn tim1_trg (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM1_TRG"]
pub fn set_tim1_trg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM1_UPD"]
pub const fn tim1_upd (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM1_UPD"]
pub fn set_tim1_upd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM1_BRK"]
pub const fn tim1_brk (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM1_BRK"]
pub fn set_tim1_brk (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } } impl Default for Itline13 { fn default () -> Itline13 { Itline13 (0) } } # [doc = "interrupt line 22 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline22 (pub u32) ; impl Itline22 { # [doc = "TIM17"]
pub fn tim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TIM17"]
pub fn set_tim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline22 { fn default () -> Itline22 { Itline22 (0) } } # [doc = "interrupt line 15 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline15 (pub u32) ; impl Itline15 { # [doc = "TIM2"]
pub fn tim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TIM2"]
pub fn set_tim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline15 { fn default () -> Itline15 { Itline15 (0) } } # [doc = "interrupt line 28 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline28 (pub u32) ; impl Itline28 { # [doc = "USART2"]
pub fn usart (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "USART2"]
pub fn set_usart (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline28 { fn default () -> Itline28 { Itline28 (0) } } # [doc = "interrupt line 31 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline31 (pub u32) ; impl Itline31 { # [doc = "RNG"]
pub const fn rng (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "RNG"]
pub fn set_rng (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "AES"]
pub const fn aes (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "AES"]
pub fn set_aes (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Itline31 { fn default () -> Itline31 { Itline31 (0) } } # [doc = "interrupt line 7 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline7 (pub u32) ; impl Itline7 { # [doc = "EXTI4"]
pub fn exti (& self , n : usize) -> bool { assert ! (n < 12usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "EXTI4"]
pub fn set_exti (& mut self , n : usize , val : bool) { assert ! (n < 12usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline7 { fn default () -> Itline7 { Itline7 (0) } } # [doc = "VREFBUF calibration control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct VrefbufCcr (pub u32) ; impl VrefbufCcr { # [doc = "Trimming code These bits are automatically initialized after reset with the trimming value stored in the Flash memory during the production test. Writing into these bits allows to tune the internal reference buffer voltage."]
pub const fn trim (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Trimming code These bits are automatically initialized after reset with the trimming value stored in the Flash memory during the production test. Writing into these bits allows to tune the internal reference buffer voltage."]
pub fn set_trim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } } impl Default for VrefbufCcr { fn default () -> VrefbufCcr { VrefbufCcr (0) } } # [doc = "interrupt line 3 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline3 (pub u32) ; impl Itline3 { # [doc = "FLASH_ITF"]
pub const fn flash_itf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "FLASH_ITF"]
pub fn set_flash_itf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "FLASH_ECC"]
pub const fn flash_ecc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "FLASH_ECC"]
pub fn set_flash_ecc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Itline3 { fn default () -> Itline3 { Itline3 (0) } } # [doc = "interrupt line 8 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline8 (pub u32) ; impl Itline8 { # [doc = "UCPD1"]
pub fn ucpd (& self , n : usize) -> bool { assert ! (n < 2usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "UCPD1"]
pub fn set_ucpd (& mut self , n : usize , val : bool) { assert ! (n < 2usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline8 { fn default () -> Itline8 { Itline8 (0) } } # [doc = "interrupt line 17 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline17 (pub u32) ; impl Itline17 { # [doc = "TIM6"]
pub fn tim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TIM6"]
pub fn set_tim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "DAC"]
pub const fn dac (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DAC"]
pub fn set_dac (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LPTIM1"]
pub fn lptim (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 2usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "LPTIM1"]
pub fn set_lptim (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 2usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline17 { fn default () -> Itline17 { Itline17 (0) } } # [doc = "interrupt line 26 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline26 (pub u32) ; impl Itline26 { # [doc = "SPI2"]
pub fn spi (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "SPI2"]
pub fn set_spi (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline26 { fn default () -> Itline26 { Itline26 (0) } } # [doc = "interrupt line 2 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline2 (pub u32) ; impl Itline2 { # [doc = "TAMP"]
pub const fn tamp (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TAMP"]
pub fn set_tamp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTC"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "RTC"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Itline2 { fn default () -> Itline2 { Itline2 (0) } } # [doc = "SYSCFG configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "Cortex-M0+ LOCKUP bit enable bit"]
pub const fn lockup_lock (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Cortex-M0+ LOCKUP bit enable bit"]
pub fn set_lockup_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SRAM parity lock bit"]
pub const fn sram_parity_lock (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SRAM parity lock bit"]
pub fn set_sram_parity_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "PVD lock enable bit"]
pub const fn pvd_lock (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "PVD lock enable bit"]
pub fn set_pvd_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "ECC error lock bit"]
pub const fn ecc_lock (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "ECC error lock bit"]
pub fn set_ecc_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "SRAM parity error flag"]
pub const fn sram_pef (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "SRAM parity error flag"]
pub fn set_sram_pef (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "PA1_CDEN"]
pub const fn pa1_cden (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PA1_CDEN"]
pub fn set_pa1_cden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "PA3_CDEN"]
pub const fn pa3_cden (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "PA3_CDEN"]
pub fn set_pa3_cden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "PA5_CDEN"]
pub const fn pa5_cden (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "PA5_CDEN"]
pub fn set_pa5_cden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "PA6_CDEN"]
pub const fn pa6_cden (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "PA6_CDEN"]
pub fn set_pa6_cden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "PA13_CDEN"]
pub const fn pa13_cden (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "PA13_CDEN"]
pub fn set_pa13_cden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "PB0_CDEN"]
pub const fn pb0_cden (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "PB0_CDEN"]
pub fn set_pb0_cden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "PB1_CDEN"]
pub const fn pb1_cden (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "PB1_CDEN"]
pub fn set_pb1_cden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "PB2_CDEN"]
pub const fn pb2_cden (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "PB2_CDEN"]
pub fn set_pb2_cden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "interrupt line 25 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline25 (pub u32) ; impl Itline25 { # [doc = "SPI1"]
pub fn spi (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "SPI1"]
pub fn set_spi (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline25 { fn default () -> Itline25 { Itline25 (0) } } # [doc = "interrupt line 24 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline24 (pub u32) ; impl Itline24 { # [doc = "I2C2"]
pub const fn i2c2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "I2C2"]
pub fn set_i2c2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Itline24 { fn default () -> Itline24 { Itline24 (0) } } # [doc = "interrupt line 29 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline29 (pub u32) ; impl Itline29 { # [doc = "USART3"]
pub fn usart (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "USART3"]
pub fn set_usart (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline29 { fn default () -> Itline29 { Itline29 (0) } } # [doc = "interrupt line 0 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline0 (pub u32) ; impl Itline0 { # [doc = "Window watchdog interrupt pending flag"]
pub const fn wwdg (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Window watchdog interrupt pending flag"]
pub fn set_wwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Itline0 { fn default () -> Itline0 { Itline0 (0) } } # [doc = "interrupt line 5 status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Itline5 (pub u32) ; impl Itline5 { # [doc = "EXTI0"]
pub fn exti (& self , n : usize) -> bool { assert ! (n < 2usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "EXTI0"]
pub fn set_exti (& mut self , n : usize , val : bool) { assert ! (n < 2usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Itline5 { fn default () -> Itline5 { Itline5 (0) } } }