

# [doc = "System configuration controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Syscfg (pub * mut u8) ; unsafe impl Send for Syscfg { } unsafe impl Sync for Syscfg { } impl Syscfg { # [doc = "configuration register 1"]
pub fn cfgr1 (self) -> crate :: common :: Reg < regs :: Cfgr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "CCM SRAM protection register"]
pub fn rcr (self) -> crate :: common :: Reg < regs :: Rcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "external interrupt configuration register"]
pub fn exticr (self , n : usize) -> crate :: common :: Reg < regs :: Exticr , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize + n * 4usize)) } } # [doc = "configuration register 2"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "configuration register 4"]
pub fn cfgr4 (self) -> crate :: common :: Reg < regs :: Cfgr4 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "configuration register 3"]
pub fn cfgr3 (self) -> crate :: common :: Reg < regs :: Cfgr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } } pub mod regs { # [doc = "CCM SRAM protection register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcr (pub u32) ; impl Rcr { # [doc = "CCM SRAM page write protection bit"]
pub const fn page0_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page0_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page1_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page1_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page2_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page2_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page3_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page3_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page4_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page4_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page5_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page5_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page6_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page6_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page7_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page7_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page8_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page8_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page9_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page9_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page10_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page10_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page11_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page11_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page12_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page12_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page13_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page13_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page14_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page14_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "CCM SRAM page write protection bit"]
pub const fn page15_wp (& self) -> super :: vals :: Page0Wp { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Page0Wp (val as u8) } # [doc = "CCM SRAM page write protection bit"]
pub fn set_page15_wp (& mut self , val : super :: vals :: Page0Wp) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Rcr { fn default () -> Rcr { Rcr (0) } } # [doc = "external interrupt configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Exticr (pub u32) ; impl Exticr { # [doc = "EXTI x configuration"]
pub fn exti (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x0f ; val as u8 } # [doc = "EXTI x configuration"]
pub fn set_exti (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x0f << offs)) | (((val as u32) & 0x0f) << offs) ; } } impl Default for Exticr { fn default () -> Exticr { Exticr (0) } } # [doc = "configuration register 4"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr4 (pub u32) ; impl Cfgr4 { # [doc = "Controls the Input trigger of ADC12 regular channel EXT2"]
pub const fn adc12_ext2_rmp (& self) -> super :: vals :: Adc12Ext2Rmp { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Adc12Ext2Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC12 regular channel EXT2"]
pub fn set_adc12_ext2_rmp (& mut self , val : super :: vals :: Adc12Ext2Rmp) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Controls the Input trigger of ADC12 regular channel EXT3"]
pub const fn adc12_ext3_rmp (& self) -> super :: vals :: Adc12Ext3Rmp { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Adc12Ext3Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC12 regular channel EXT3"]
pub fn set_adc12_ext3_rmp (& mut self , val : super :: vals :: Adc12Ext3Rmp) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Controls the Input trigger of ADC12 regular channel EXT5"]
pub const fn adc12_ext5_rmp (& self) -> super :: vals :: Adc12Ext5Rmp { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Adc12Ext5Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC12 regular channel EXT5"]
pub fn set_adc12_ext5_rmp (& mut self , val : super :: vals :: Adc12Ext5Rmp) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Controls the Input trigger of ADC12 regular channel EXT13"]
pub const fn adc12_ext13_rmp (& self) -> super :: vals :: Adc12Ext13Rmp { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Adc12Ext13Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC12 regular channel EXT13"]
pub fn set_adc12_ext13_rmp (& mut self , val : super :: vals :: Adc12Ext13Rmp) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Controls the Input trigger of ADC12 regular channel EXT15"]
pub const fn adc12_ext15_rmp (& self) -> super :: vals :: Adc12Ext15Rmp { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Adc12Ext15Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC12 regular channel EXT15"]
pub fn set_adc12_ext15_rmp (& mut self , val : super :: vals :: Adc12Ext15Rmp) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Controls the Input trigger of ADC12 injected channel JEXT3"]
pub const fn adc12_jext3_rmp (& self) -> super :: vals :: Adc12Jext3Rmp { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Adc12Jext3Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC12 injected channel JEXT3"]
pub fn set_adc12_jext3_rmp (& mut self , val : super :: vals :: Adc12Jext3Rmp) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Controls the Input trigger of ADC12 injected channel JEXT6"]
pub const fn adc12_jext6_rmp (& self) -> super :: vals :: Adc12Jext6Rmp { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Adc12Jext6Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC12 injected channel JEXT6"]
pub fn set_adc12_jext6_rmp (& mut self , val : super :: vals :: Adc12Jext6Rmp) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Controls the Input trigger of ADC12 injected channel JEXT13"]
pub const fn adc12_jext13_rmp (& self) -> super :: vals :: Adc12Jext13Rmp { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Adc12Jext13Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC12 injected channel JEXT13"]
pub fn set_adc12_jext13_rmp (& mut self , val : super :: vals :: Adc12Jext13Rmp) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Controls the Input trigger of ADC34 regular channel EXT5"]
pub const fn adc34_ext5_rmp (& self) -> super :: vals :: Adc34Ext5Rmp { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Adc34Ext5Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC34 regular channel EXT5"]
pub fn set_adc34_ext5_rmp (& mut self , val : super :: vals :: Adc34Ext5Rmp) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Controls the Input trigger of ADC34 regular channel EXT6"]
pub const fn adc34_ext6_rmp (& self) -> super :: vals :: Adc34Ext6Rmp { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Adc34Ext6Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC34 regular channel EXT6"]
pub fn set_adc34_ext6_rmp (& mut self , val : super :: vals :: Adc34Ext6Rmp) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Controls the Input trigger of ADC34 regular channel EXT15"]
pub const fn adc34_ext15_rmp (& self) -> super :: vals :: Adc34Ext15Rmp { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Adc34Ext15Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC34 regular channel EXT15"]
pub fn set_adc34_ext15_rmp (& mut self , val : super :: vals :: Adc34Ext15Rmp) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Controls the Input trigger of ADC34 injected channel JEXT5"]
pub const fn adc34_jext5_rmp (& self) -> super :: vals :: Adc34Jext5Rmp { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Adc34Jext5Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC34 injected channel JEXT5"]
pub fn set_adc34_jext5_rmp (& mut self , val : super :: vals :: Adc34Jext5Rmp) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Controls the Input trigger of ADC34 injected channel JEXT11"]
pub const fn adc34_jext11_rmp (& self) -> super :: vals :: Adc34Jext11Rmp { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Adc34Jext11Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC34 injected channel JEXT11"]
pub fn set_adc34_jext11_rmp (& mut self , val : super :: vals :: Adc34Jext11Rmp) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Controls the Input trigger of ADC34 injected channel JEXT14"]
pub const fn adc34_jext14_rmp (& self) -> super :: vals :: Adc34Jext14Rmp { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Adc34Jext14Rmp (val as u8) } # [doc = "Controls the Input trigger of ADC34 injected channel JEXT14"]
pub fn set_adc34_jext14_rmp (& mut self , val : super :: vals :: Adc34Jext14Rmp) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } } impl Default for Cfgr4 { fn default () -> Cfgr4 { Cfgr4 (0) } } # [doc = "configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "Cortex-M0 LOCKUP bit enable bit"]
pub const fn lockup_lock (& self) -> super :: vals :: LockupLock { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: LockupLock (val as u8) } # [doc = "Cortex-M0 LOCKUP bit enable bit"]
pub fn set_lockup_lock (& mut self , val : super :: vals :: LockupLock) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "SRAM parity lock bit"]
pub const fn sram_parity_lock (& self) -> super :: vals :: SramParityLock { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: SramParityLock (val as u8) } # [doc = "SRAM parity lock bit"]
pub fn set_sram_parity_lock (& mut self , val : super :: vals :: SramParityLock) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "PVD lock enable bit"]
pub const fn pvd_lock (& self) -> super :: vals :: PvdLock { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: PvdLock (val as u8) } # [doc = "PVD lock enable bit"]
pub fn set_pvd_lock (& mut self , val : super :: vals :: PvdLock) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Bypass address bit 29 in parity calculation"]
pub const fn byp_addr_par (& self) -> super :: vals :: BypAddrPar { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: BypAddrPar (val as u8) } # [doc = "Bypass address bit 29 in parity calculation"]
pub fn set_byp_addr_par (& mut self , val : super :: vals :: BypAddrPar) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "SRAM parity flag"]
pub const fn sram_pef (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "SRAM parity flag"]
pub fn set_sram_pef (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr1 (pub u32) ; impl Cfgr1 { # [doc = "Memory mapping selection bits"]
pub const fn mem_mode (& self) -> super :: vals :: MemMode { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: MemMode (val as u8) } # [doc = "Memory mapping selection bits"]
pub fn set_mem_mode (& mut self , val : super :: vals :: MemMode) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "USB interrupt remap"]
pub const fn usb_it_rmp (& self) -> super :: vals :: UsbItRmp { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: UsbItRmp (val as u8) } # [doc = "USB interrupt remap"]
pub fn set_usb_it_rmp (& mut self , val : super :: vals :: UsbItRmp) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Timer 1 ITR3 selection"]
pub const fn tim1_itr3_rmp (& self) -> super :: vals :: Tim1Itr3Rmp { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Tim1Itr3Rmp (val as u8) } # [doc = "Timer 1 ITR3 selection"]
pub fn set_tim1_itr3_rmp (& mut self , val : super :: vals :: Tim1Itr3Rmp) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "DAC trigger remap (when TSEL = 001)"]
pub const fn dac1_trig_rmp (& self) -> super :: vals :: Dac1TrigRmp { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Dac1TrigRmp (val as u8) } # [doc = "DAC trigger remap (when TSEL = 001)"]
pub fn set_dac1_trig_rmp (& mut self , val : super :: vals :: Dac1TrigRmp) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "DAC trigger remap (when TSEL = 001)"]
pub const fn dac_trig_rmp (& self) -> super :: vals :: DacTrigRmp { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: DacTrigRmp (val as u8) } # [doc = "DAC trigger remap (when TSEL = 001)"]
pub fn set_dac_trig_rmp (& mut self , val : super :: vals :: DacTrigRmp) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "ADC24 DMA remapping bit"]
pub const fn adc2_dma_rmp (& self) -> super :: vals :: Adc2DmaRmp { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Adc2DmaRmp (val as u8) } # [doc = "ADC24 DMA remapping bit"]
pub fn set_adc2_dma_rmp (& mut self , val : super :: vals :: Adc2DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "TIM16 DMA request remapping bit"]
pub const fn tim16_dma_rmp (& self) -> super :: vals :: Tim16DmaRmp { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Tim16DmaRmp (val as u8) } # [doc = "TIM16 DMA request remapping bit"]
pub fn set_tim16_dma_rmp (& mut self , val : super :: vals :: Tim16DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "TIM17 DMA request remapping bit"]
pub const fn tim17_dma_rmp (& self) -> super :: vals :: Tim17DmaRmp { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Tim17DmaRmp (val as u8) } # [doc = "TIM17 DMA request remapping bit"]
pub fn set_tim17_dma_rmp (& mut self , val : super :: vals :: Tim17DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "TIM6 and DAC1 DMA request remapping bit"]
pub const fn tim6_dac1_ch1_dma_rmp (& self) -> super :: vals :: Tim6Dac1Ch1DmaRmp { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Tim6Dac1Ch1DmaRmp (val as u8) } # [doc = "TIM6 and DAC1 DMA request remapping bit"]
pub fn set_tim6_dac1_ch1_dma_rmp (& mut self , val : super :: vals :: Tim6Dac1Ch1DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "TIM6 and DAC1 DMA request remapping bit"]
pub const fn tim6_dac1_dma_rmp (& self) -> super :: vals :: Tim6Dac1DmaRmp { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Tim6Dac1DmaRmp (val as u8) } # [doc = "TIM6 and DAC1 DMA request remapping bit"]
pub fn set_tim6_dac1_dma_rmp (& mut self , val : super :: vals :: Tim6Dac1DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "TIM6 and DAC1 DMA request remapping bit"]
pub const fn tim6_dac1_out1_dma_rmp (& self) -> super :: vals :: Tim6Dac1Out1DmaRmp { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Tim6Dac1Out1DmaRmp (val as u8) } # [doc = "TIM6 and DAC1 DMA request remapping bit"]
pub fn set_tim6_dac1_out1_dma_rmp (& mut self , val : super :: vals :: Tim6Dac1Out1DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "TIM7 and DAC2 DMA request remapping bit"]
pub const fn tim7_dac1_ch2_dma_rmp (& self) -> super :: vals :: Tim7Dac1Ch2DmaRmp { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Tim7Dac1Ch2DmaRmp (val as u8) } # [doc = "TIM7 and DAC2 DMA request remapping bit"]
pub fn set_tim7_dac1_ch2_dma_rmp (& mut self , val : super :: vals :: Tim7Dac1Ch2DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "TIM7 and DAC2 DMA request remapping bit"]
pub const fn tim7_dac1_out2_dma_rmp (& self) -> super :: vals :: Tim7Dac1Out2DmaRmp { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Tim7Dac1Out2DmaRmp (val as u8) } # [doc = "TIM7 and DAC2 DMA request remapping bit"]
pub fn set_tim7_dac1_out2_dma_rmp (& mut self , val : super :: vals :: Tim7Dac1Out2DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "DAC2 channel1 DMA remap"]
pub const fn dac2_ch1_dma_rmp (& self) -> super :: vals :: Dac2Ch1DmaRmp { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Dac2Ch1DmaRmp (val as u8) } # [doc = "DAC2 channel1 DMA remap"]
pub fn set_dac2_ch1_dma_rmp (& mut self , val : super :: vals :: Dac2Ch1DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "TIM18 and DAC2_OUT1 DMA request remapping bit"]
pub const fn tim18_dac2_out1_dma_rmp (& self) -> super :: vals :: Tim18Dac2Out1DmaRmp { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Tim18Dac2Out1DmaRmp (val as u8) } # [doc = "TIM18 and DAC2_OUT1 DMA request remapping bit"]
pub fn set_tim18_dac2_out1_dma_rmp (& mut self , val : super :: vals :: Tim18Dac2Out1DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub const fn i2c_pb6_fmp (& self) -> super :: vals :: I2cPb6Fmp { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: I2cPb6Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub fn set_i2c_pb6_fmp (& mut self , val : super :: vals :: I2cPb6Fmp) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub const fn i2c_pb7_fmp (& self) -> super :: vals :: I2cPb7Fmp { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: I2cPb7Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub fn set_i2c_pb7_fmp (& mut self , val : super :: vals :: I2cPb7Fmp) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub const fn i2c_pb8_fmp (& self) -> super :: vals :: I2cPb8Fmp { let val = (self . 0 >> 18usize) & 0x01 ; super :: vals :: I2cPb8Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub fn set_i2c_pb8_fmp (& mut self , val : super :: vals :: I2cPb8Fmp) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val . 0 as u32) & 0x01) << 18usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub const fn i2c_pb9_fmp (& self) -> super :: vals :: I2cPb9Fmp { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: I2cPb9Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub fn set_i2c_pb9_fmp (& mut self , val : super :: vals :: I2cPb9Fmp) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "I2C1 Fast Mode Plus"]
pub const fn i2c1_fmp (& self) -> super :: vals :: I2c1Fmp { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: I2c1Fmp (val as u8) } # [doc = "I2C1 Fast Mode Plus"]
pub fn set_i2c1_fmp (& mut self , val : super :: vals :: I2c1Fmp) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "I2C2 Fast Mode Plus"]
pub const fn i2c2_fmp (& self) -> super :: vals :: I2c2Fmp { let val = (self . 0 >> 21usize) & 0x01 ; super :: vals :: I2c2Fmp (val as u8) } # [doc = "I2C2 Fast Mode Plus"]
pub fn set_i2c2_fmp (& mut self , val : super :: vals :: I2c2Fmp) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val . 0 as u32) & 0x01) << 21usize) ; } # [doc = "Encoder mode"]
pub const fn encoder_mode (& self) -> super :: vals :: EncoderMode { let val = (self . 0 >> 22usize) & 0x03 ; super :: vals :: EncoderMode (val as u8) } # [doc = "Encoder mode"]
pub fn set_encoder_mode (& mut self , val : super :: vals :: EncoderMode) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val . 0 as u32) & 0x03) << 22usize) ; } # [doc = "I2C3 Fast Mode Plus"]
pub const fn i2c3_fmp (& self) -> super :: vals :: I2c3Fmp { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: I2c3Fmp (val as u8) } # [doc = "I2C3 Fast Mode Plus"]
pub fn set_i2c3_fmp (& mut self , val : super :: vals :: I2c3Fmp) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "VBAT monitoring enable"]
pub const fn vbat_mon (& self) -> super :: vals :: VbatMon { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: VbatMon (val as u8) } # [doc = "VBAT monitoring enable"]
pub fn set_vbat_mon (& mut self , val : super :: vals :: VbatMon) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "Invalid operation interrupt enable"]
pub const fn fpu_ie0 (& self) -> super :: vals :: FpuIe0 { let val = (self . 0 >> 26usize) & 0x01 ; super :: vals :: FpuIe0 (val as u8) } # [doc = "Invalid operation interrupt enable"]
pub fn set_fpu_ie0 (& mut self , val : super :: vals :: FpuIe0) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val . 0 as u32) & 0x01) << 26usize) ; } # [doc = "Devide-by-zero interrupt enable"]
pub const fn fpu_ie1 (& self) -> super :: vals :: FpuIe1 { let val = (self . 0 >> 27usize) & 0x01 ; super :: vals :: FpuIe1 (val as u8) } # [doc = "Devide-by-zero interrupt enable"]
pub fn set_fpu_ie1 (& mut self , val : super :: vals :: FpuIe1) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val . 0 as u32) & 0x01) << 27usize) ; } # [doc = "Underflow interrupt enable"]
pub const fn fpu_ie2 (& self) -> super :: vals :: FpuIe2 { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: FpuIe2 (val as u8) } # [doc = "Underflow interrupt enable"]
pub fn set_fpu_ie2 (& mut self , val : super :: vals :: FpuIe2) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } # [doc = "Overflow interrupt enable"]
pub const fn fpu_ie3 (& self) -> super :: vals :: FpuIe3 { let val = (self . 0 >> 29usize) & 0x01 ; super :: vals :: FpuIe3 (val as u8) } # [doc = "Overflow interrupt enable"]
pub fn set_fpu_ie3 (& mut self , val : super :: vals :: FpuIe3) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val . 0 as u32) & 0x01) << 29usize) ; } # [doc = "Input denormal interrupt enable"]
pub const fn fpu_ie4 (& self) -> super :: vals :: FpuIe4 { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: FpuIe4 (val as u8) } # [doc = "Input denormal interrupt enable"]
pub fn set_fpu_ie4 (& mut self , val : super :: vals :: FpuIe4) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "Inexact interrupt enable"]
pub const fn fpu_ie5 (& self) -> super :: vals :: FpuIe5 { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: FpuIe5 (val as u8) } # [doc = "Inexact interrupt enable"]
pub fn set_fpu_ie5 (& mut self , val : super :: vals :: FpuIe5) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Cfgr1 { fn default () -> Cfgr1 { Cfgr1 (0) } } # [doc = "configuration register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr3 (pub u32) ; impl Cfgr3 { # [doc = "SPI1_RX DMA remapping bit"]
pub const fn spi1_rx_dma_rmp (& self) -> super :: vals :: Spi1RxDmaRmp { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Spi1RxDmaRmp (val as u8) } # [doc = "SPI1_RX DMA remapping bit"]
pub fn set_spi1_rx_dma_rmp (& mut self , val : super :: vals :: Spi1RxDmaRmp) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "SPI1_TX DMA remapping bit"]
pub const fn spi1_tx_dma_rmp (& self) -> super :: vals :: Spi1TxDmaRmp { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Spi1TxDmaRmp (val as u8) } # [doc = "SPI1_TX DMA remapping bit"]
pub fn set_spi1_tx_dma_rmp (& mut self , val : super :: vals :: Spi1TxDmaRmp) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "I2C1_RX DMA remapping bit"]
pub const fn i2c1_rx_dma_rmp (& self) -> super :: vals :: I2c1RxDmaRmp { let val = (self . 0 >> 4usize) & 0x03 ; super :: vals :: I2c1RxDmaRmp (val as u8) } # [doc = "I2C1_RX DMA remapping bit"]
pub fn set_i2c1_rx_dma_rmp (& mut self , val : super :: vals :: I2c1RxDmaRmp) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val . 0 as u32) & 0x03) << 4usize) ; } # [doc = "I2C1_TX DMA remapping bit"]
pub const fn i2c1_tx_dma_rmp (& self) -> super :: vals :: I2c1TxDmaRmp { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: I2c1TxDmaRmp (val as u8) } # [doc = "I2C1_TX DMA remapping bit"]
pub fn set_i2c1_tx_dma_rmp (& mut self , val : super :: vals :: I2c1TxDmaRmp) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "ADC2 DMA remapping bit"]
pub const fn adc2_dma_rmp (& self) -> super :: vals :: Adc2DmaRmp { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Adc2DmaRmp (val as u8) } # [doc = "ADC2 DMA remapping bit"]
pub fn set_adc2_dma_rmp (& mut self , val : super :: vals :: Adc2DmaRmp) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "DAC1_CH1 / DAC1_CH2 Trigger remap"]
pub const fn dac1_trig3_rmp (& self) -> super :: vals :: Dac1Trig3Rmp { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Dac1Trig3Rmp (val as u8) } # [doc = "DAC1_CH1 / DAC1_CH2 Trigger remap"]
pub fn set_dac1_trig3_rmp (& mut self , val : super :: vals :: Dac1Trig3Rmp) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "DAC1_CH1 / DAC1_CH2 Trigger remap"]
pub const fn dac1_trig5_rmp (& self) -> super :: vals :: Dac1Trig5Rmp { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Dac1Trig5Rmp (val as u8) } # [doc = "DAC1_CH1 / DAC1_CH2 Trigger remap"]
pub fn set_dac1_trig5_rmp (& mut self , val : super :: vals :: Dac1Trig5Rmp) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } } impl Default for Cfgr3 { fn default () -> Cfgr3 { Cfgr3 (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct MemMode (pub u8) ; impl MemMode { # [doc = "Main Flash memory mapped at 0x0000_0000"]
pub const MAINFLASH : Self = Self (0) ; # [doc = "System Flash memory mapped at 0x0000_0000"]
pub const SYSTEMFLASH : Self = Self (0x01) ; # [doc = "Main Flash memory mapped at 0x0000_0000"]
pub const MAINFLASH2 : Self = Self (0x02) ; # [doc = "Embedded SRAM mapped at 0x0000_0000"]
pub const SRAM : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti0 (pub u8) ; impl Exti0 { # [doc = "Select PA0 as the source input for the EXTI0 external interrupt"]
pub const PA0 : Self = Self (0) ; # [doc = "Select PB0 as the source input for the EXTI0 external interrupt"]
pub const PB0 : Self = Self (0x01) ; # [doc = "Select PC0 as the source input for the EXTI0 external interrupt"]
pub const PC0 : Self = Self (0x02) ; # [doc = "Select PD0 as the source input for the EXTI0 external interrupt"]
pub const PD0 : Self = Self (0x03) ; # [doc = "Select PE0 as the source input for the EXTI0 external interrupt"]
pub const PE0 : Self = Self (0x04) ; # [doc = "Select PF0 as the source input for the EXTI0 external interrupt"]
pub const PF0 : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPb8Fmp (pub u8) ; impl I2cPb8Fmp { # [doc = "PB8 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PB8 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct VbatMon (pub u8) ; impl VbatMon { # [doc = "Disable the power switch to not deliver VBAT voltage on ADC channel 18 input"]
pub const DISABLE : Self = Self (0) ; # [doc = "Enable the power switch to deliver VBAT voltage on ADC channel 18 input"]
pub const ENABLE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dac1TrigRmp (pub u8) ; impl Dac1TrigRmp { # [doc = "DAC trigger is TIM8_TRGO in STM32F303xB/C and STM32F358xC devices"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "DAC trigger is TIM3_TRGO"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPb9Fmp (pub u8) ; impl I2cPb9Fmp { # [doc = "PB9 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PB9 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti8 (pub u8) ; impl Exti8 { # [doc = "Select PA8 as the source input for the EXTI8 external interrupt"]
pub const PA8 : Self = Self (0) ; # [doc = "Select PB8 as the source input for the EXTI8 external interrupt"]
pub const PB8 : Self = Self (0x01) ; # [doc = "Select PC8 as the source input for the EXTI8 external interrupt"]
pub const PC8 : Self = Self (0x02) ; # [doc = "Select PD8 as the source input for the EXTI8 external interrupt"]
pub const PD8 : Self = Self (0x03) ; # [doc = "Select PE8 as the source input for the EXTI8 external interrupt"]
pub const PE8 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti6 (pub u8) ; impl Exti6 { # [doc = "Select PA6 as the source input for the EXTI6 external interrupt"]
pub const PA6 : Self = Self (0) ; # [doc = "Select PB6 as the source input for the EXTI6 external interrupt"]
pub const PB6 : Self = Self (0x01) ; # [doc = "Select PC6 as the source input for the EXTI6 external interrupt"]
pub const PC6 : Self = Self (0x02) ; # [doc = "Select PD6 as the source input for the EXTI6 external interrupt"]
pub const PD6 : Self = Self (0x03) ; # [doc = "Select PE6 as the source input for the EXTI6 external interrupt"]
pub const PE6 : Self = Self (0x04) ; # [doc = "Select PF6 as the source input for the EXTI6 external interrupt"]
pub const PF6 : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SramPefr (pub u8) ; impl SramPefr { # [doc = "No SRAM parity error detected"]
pub const NOPARITYERROR : Self = Self (0) ; # [doc = "SRAM parity error detected"]
pub const PARITYERRORDETECTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti4 (pub u8) ; impl Exti4 { # [doc = "Select PA4 as the source input for the EXTI4 external interrupt"]
pub const PA4 : Self = Self (0) ; # [doc = "Select PB4 as the source input for the EXTI4 external interrupt"]
pub const PB4 : Self = Self (0x01) ; # [doc = "Select PC4 as the source input for the EXTI4 external interrupt"]
pub const PC4 : Self = Self (0x02) ; # [doc = "Select PD4 as the source input for the EXTI4 external interrupt"]
pub const PD4 : Self = Self (0x03) ; # [doc = "Select PE4 as the source input for the EXTI4 external interrupt"]
pub const PE4 : Self = Self (0x04) ; # [doc = "Select PF4 as the source input for the EXTI4 external interrupt"]
pub const PF4 : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti1 (pub u8) ; impl Exti1 { # [doc = "Select PA1 as the source input for the EXTI1 external interrupt"]
pub const PA1 : Self = Self (0) ; # [doc = "Select PB1 as the source input for the EXTI1 external interrupt"]
pub const PB1 : Self = Self (0x01) ; # [doc = "Select PC1 as the source input for the EXTI1 external interrupt"]
pub const PC1 : Self = Self (0x02) ; # [doc = "Select PD1 as the source input for the EXTI1 external interrupt"]
pub const PD1 : Self = Self (0x03) ; # [doc = "Select PE1 as the source input for the EXTI1 external interrupt"]
pub const PE1 : Self = Self (0x04) ; # [doc = "Select PF1 as the source input for the EXTI1 external interrupt"]
pub const PF1 : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc34Ext15Rmp (pub u8) ; impl Adc34Ext15Rmp { # [doc = "Trigger source is TIM2_CC1"]
pub const TIM2 : Self = Self (0) ; # [doc = "Trigger source is TIM20_CC1"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti14 (pub u8) ; impl Exti14 { # [doc = "Select PA14 as the source input for the EXTI14 external interrupt"]
pub const PA14 : Self = Self (0) ; # [doc = "Select PB14 as the source input for the EXTI14 external interrupt"]
pub const PB14 : Self = Self (0x01) ; # [doc = "Select PC14 as the source input for the EXTI14 external interrupt"]
pub const PC14 : Self = Self (0x02) ; # [doc = "Select PD14 as the source input for the EXTI14 external interrupt"]
pub const PD14 : Self = Self (0x03) ; # [doc = "Select PE14 as the source input for the EXTI14 external interrupt"]
pub const PE14 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti9 (pub u8) ; impl Exti9 { # [doc = "Select PA9 as the source input for the EXTI9 external interrupt"]
pub const PA9 : Self = Self (0) ; # [doc = "Select PB9 as the source input for the EXTI9 external interrupt"]
pub const PB9 : Self = Self (0x01) ; # [doc = "Select PC9 as the source input for the EXTI9 external interrupt"]
pub const PC9 : Self = Self (0x02) ; # [doc = "Select PD9 as the source input for the EXTI9 external interrupt"]
pub const PD9 : Self = Self (0x03) ; # [doc = "Select PE9 as the source input for the EXTI9 external interrupt"]
pub const PE9 : Self = Self (0x04) ; # [doc = "Select PF9 as the source input for the EXTI9 external interrupt"]
pub const PF9 : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim6Dac1DmaRmp (pub u8) ; impl Tim6Dac1DmaRmp { # [doc = "TIM6_UP and DAC_CH1 DMA requests mapped on DMA2 channel 3"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM6_UP and DAC_CH1 DMA requests mapped on DMA1 channel 3"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti10 (pub u8) ; impl Exti10 { # [doc = "Select PA10 as the source input for the EXTI10 external interrupt"]
pub const PA10 : Self = Self (0) ; # [doc = "Select PB10 as the source input for the EXTI10 external interrupt"]
pub const PB10 : Self = Self (0x01) ; # [doc = "Select PC10 as the source input for the EXTI10 external interrupt"]
pub const PC10 : Self = Self (0x02) ; # [doc = "Select PD10 as the source input for the EXTI10 external interrupt"]
pub const PD10 : Self = Self (0x03) ; # [doc = "Select PE10 as the source input for the EXTI10 external interrupt"]
pub const PE10 : Self = Self (0x04) ; # [doc = "Select PF10 as the source input for the EXTI10 external interrupt"]
pub const PF10 : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PvdLock (pub u8) ; impl PvdLock { # [doc = "PVD interrupt disconnected from TIM15/16/17 Break input"]
pub const DISCONNECTED : Self = Self (0) ; # [doc = "PVD interrupt connected to TIM15/16/17 Break input"]
pub const CONNECTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim6Dac1Ch1DmaRmp (pub u8) ; impl Tim6Dac1Ch1DmaRmp { # [doc = "TIM6_UP and DAC_CH1 DMA requests mapped on DMA2 channel 3"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM6_UP and DAC_CH1 DMA requests mapped on DMA1 channel 3"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dac1Trig3Rmp (pub u8) ; impl Dac1Trig3Rmp { # [doc = "DAC trigger is TIM15_TRGO"]
pub const TIM15 : Self = Self (0) ; # [doc = "DAC trigger is HRTIM1_DAC1_TRIG1"]
pub const HRTIM1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FpuIe3 (pub u8) ; impl FpuIe3 { # [doc = "Overflow interrupt disable"]
pub const DISABLED : Self = Self (0) ; # [doc = "Overflow interrupt enable"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti13 (pub u8) ; impl Exti13 { # [doc = "Select PA13 as the source input for the EXTI13 external interrupt"]
pub const PA13 : Self = Self (0) ; # [doc = "Select PB13 as the source input for the EXTI13 external interrupt"]
pub const PB13 : Self = Self (0x01) ; # [doc = "Select PC13 as the source input for the EXTI13 external interrupt"]
pub const PC13 : Self = Self (0x02) ; # [doc = "Select PD13 as the source input for the EXTI13 external interrupt"]
pub const PD13 : Self = Self (0x03) ; # [doc = "Select PE13 as the source input for the EXTI13 external interrupt"]
pub const PE13 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct DacTrigRmp (pub u8) ; impl DacTrigRmp { # [doc = "Not remapped"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "DAC trigger is TIM3_TRGO"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cfgr1Adc2DmaRmp (pub u8) ; impl Cfgr1Adc2DmaRmp { # [doc = "ADC24 DMA requests mapped on DMA2 channels 1 and 2"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "ADC24 DMA requests mapped on DMA2 channels 3 and 4"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc34Jext11Rmp (pub u8) ; impl Adc34Jext11Rmp { # [doc = "Trigger source is TIM1_CC3"]
pub const TIM1 : Self = Self (0) ; # [doc = "Trigger source is TIM20_TRGO2"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FpuIe0 (pub u8) ; impl FpuIe0 { # [doc = "Invalid operation interrupt disable"]
pub const DISABLED : Self = Self (0) ; # [doc = "Invalid operation interrupt enable"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spi1RxDmaRmp (pub u8) ; impl Spi1RxDmaRmp { # [doc = "SPI1_RX mapped on DMA1 CH2"]
pub const MAPDMA1CH3 : Self = Self (0) ; # [doc = "SPI1_RX mapped on DMA1 CH4"]
pub const MAPDMA1CH5 : Self = Self (0x01) ; # [doc = "SPI1_RX mapped on DMA1 CH6"]
pub const MAPDMA1CH7 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti2 (pub u8) ; impl Exti2 { # [doc = "Select PA2 as the source input for the EXTI2 external interrupt"]
pub const PA2 : Self = Self (0) ; # [doc = "Select PB2 as the source input for the EXTI2 external interrupt"]
pub const PB2 : Self = Self (0x01) ; # [doc = "Select PC2 as the source input for the EXTI2 external interrupt"]
pub const PC2 : Self = Self (0x02) ; # [doc = "Select PD2 as the source input for the EXTI2 external interrupt"]
pub const PD2 : Self = Self (0x03) ; # [doc = "Select PE2 as the source input for the EXTI2 external interrupt"]
pub const PE2 : Self = Self (0x04) ; # [doc = "Select PF2 as the source input for the EXTI2 external interrupt"]
pub const PF2 : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc34Ext5Rmp (pub u8) ; impl Adc34Ext5Rmp { # [doc = "Trigger source is EXTI line 2 when reset at 0"]
pub const EXTI2 : Self = Self (0) ; # [doc = "Trigger source is TIM20_TRGO"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc12Jext6Rmp (pub u8) ; impl Adc12Jext6Rmp { # [doc = "Trigger source is EXTI line 15"]
pub const EXTI15 : Self = Self (0) ; # [doc = "Trigger source is TIM20_TRGO2"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct UsbItRmp (pub u8) ; impl UsbItRmp { # [doc = "USB_HP, USB_LP and USB_WAKEUP interrupts are mapped on interrupt lines 19, 20 and 42 respectively"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "USB_HP, USB_LP and USB_WAKEUP interrupts are mapped on interrupt lines 74, 75 and 76 respectively"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c1RxDmaRmp (pub u8) ; impl I2c1RxDmaRmp { # [doc = "I2C1_RX mapped on DMA1 CH7"]
pub const MAPDMA1CH7 : Self = Self (0) ; # [doc = "I2C1_RX mapped on DMA1 CH3"]
pub const MAPDMA1CH3 : Self = Self (0x01) ; # [doc = "I2C1_RX mapped on DMA1 CH5"]
pub const MAPDMA1CH5 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c2Fmp (pub u8) ; impl I2c2Fmp { # [doc = "FM+ mode is controlled by I2C_Pxx_FMP bits only"]
pub const STANDARD : Self = Self (0) ; # [doc = "FM+ mode is enabled on all I2C2 pins selected through selection through IOPORT control registers AF selection bits"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim16DmaRmp (pub u8) ; impl Tim16DmaRmp { # [doc = "TIM16_CH1 and TIM16_UP DMA requests mapped on DMA channel 3"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM16_CH1 and TIM16_UP DMA requests mapped on DMA channel 4"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spi1TxDmaRmp (pub u8) ; impl Spi1TxDmaRmp { # [doc = "SPI1_TX mapped on DMA1 CH3"]
pub const MAPDMA1CH3 : Self = Self (0) ; # [doc = "SPI1_TX mapped on DMA1 CH5"]
pub const MAPDMA1CH5 : Self = Self (0x01) ; # [doc = "SPI1_TX mapped on DMA1 CH7"]
pub const MAPDMA1CH7 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc34Jext14Rmp (pub u8) ; impl Adc34Jext14Rmp { # [doc = "Trigger source is TIM7_TRGO"]
pub const TIM7 : Self = Self (0) ; # [doc = "Trigger source is TIM20_CC2"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SramParityLock (pub u8) ; impl SramParityLock { # [doc = "SRAM parity error signal disconnected from TIM1/15/16/17 and HRTIM1 SYSFLT Break inputs"]
pub const DISCONNECTED : Self = Self (0) ; # [doc = "SRAM parity error signal connected to TIM1/15/16/17 and HRTIM1 SYSFLT Break inputs"]
pub const CONNECTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc12Ext15Rmp (pub u8) ; impl Adc12Ext15Rmp { # [doc = "Trigger source is TIM3_CC4"]
pub const TIM3 : Self = Self (0) ; # [doc = "Trigger source is TIM20_CC3"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc12Jext13Rmp (pub u8) ; impl Adc12Jext13Rmp { # [doc = "Trigger source is TIM3_CC1"]
pub const TIM3 : Self = Self (0) ; # [doc = "Trigger source is TIM20_CC4"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim17DmaRmp (pub u8) ; impl Tim17DmaRmp { # [doc = "TIM17_CH1 and TIM17_UP DMA requests mapped on DMA channel 1"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM17_CH1 and TIM17_UP DMA requests mapped on DMA channel 2"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti12 (pub u8) ; impl Exti12 { # [doc = "Select PA12 as the source input for the EXTI12 external interrupt"]
pub const PA12 : Self = Self (0) ; # [doc = "Select PB12 as the source input for the EXTI12 external interrupt"]
pub const PB12 : Self = Self (0x01) ; # [doc = "Select PC12 as the source input for the EXTI12 external interrupt"]
pub const PC12 : Self = Self (0x02) ; # [doc = "Select PD12 as the source input for the EXTI12 external interrupt"]
pub const PD12 : Self = Self (0x03) ; # [doc = "Select PE12 as the source input for the EXTI12 external interrupt"]
pub const PE12 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cfgr3Adc2DmaRmp (pub u8) ; impl Cfgr3Adc2DmaRmp { # [doc = "ADC2 mapped on DMA2"]
pub const MAPDMA2 : Self = Self (0) ; # [doc = "ADC2 mapped on DMA1 channel 2"]
pub const MAPDMA1CH2 : Self = Self (0x02) ; # [doc = "ADC2 mapped on DMA1 channel 4"]
pub const MAPDMA1CH4 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPb6Fmp (pub u8) ; impl I2cPb6Fmp { # [doc = "PB6 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PB6 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FpuIe2 (pub u8) ; impl FpuIe2 { # [doc = "Underflow interrupt disable"]
pub const DISABLED : Self = Self (0) ; # [doc = "Underflow interrupt enable"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti3 (pub u8) ; impl Exti3 { # [doc = "Select PA3 as the source input for the EXTI3 external interrupt"]
pub const PA3 : Self = Self (0) ; # [doc = "Select PB3 as the source input for the EXTI3 external interrupt"]
pub const PB3 : Self = Self (0x01) ; # [doc = "Select PC3 as the source input for the EXTI3 external interrupt"]
pub const PC3 : Self = Self (0x02) ; # [doc = "Select PD3 as the source input for the EXTI3 external interrupt"]
pub const PD3 : Self = Self (0x03) ; # [doc = "Select PE3 as the source input for the EXTI3 external interrupt"]
pub const PE3 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc12Ext13Rmp (pub u8) ; impl Adc12Ext13Rmp { # [doc = "Trigger source is TIM6_TRGO"]
pub const TIM6 : Self = Self (0) ; # [doc = "Trigger source is TIM20_CC2"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dac1Trig5Rmp (pub u8) ; impl Dac1Trig5Rmp { # [doc = "Not remapped"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "DAC trigger is HRTIM1_DAC1_TRIG2"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc12Ext2Rmp (pub u8) ; impl Adc12Ext2Rmp { # [doc = "Trigger source is TIM3_CC3"]
pub const TIM1 : Self = Self (0) ; # [doc = "rigger source is TIM20_TRGO"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti7 (pub u8) ; impl Exti7 { # [doc = "Select PA7 as the source input for the EXTI7 external interrupt"]
pub const PA7 : Self = Self (0) ; # [doc = "Select PB7 as the source input for the EXTI7 external interrupt"]
pub const PB7 : Self = Self (0x01) ; # [doc = "Select PC7 as the source input for the EXTI7 external interrupt"]
pub const PC7 : Self = Self (0x02) ; # [doc = "Select PD7 as the source input for the EXTI7 external interrupt"]
pub const PD7 : Self = Self (0x03) ; # [doc = "Select PE7 as the source input for the EXTI7 external interrupt"]
pub const PE7 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti15 (pub u8) ; impl Exti15 { # [doc = "Select PA15 as the source input for the EXTI15 external interrupt"]
pub const PA15 : Self = Self (0) ; # [doc = "Select PB15 as the source input for the EXTI15 external interrupt"]
pub const PB15 : Self = Self (0x01) ; # [doc = "Select PC15 as the source input for the EXTI15 external interrupt"]
pub const PC15 : Self = Self (0x02) ; # [doc = "Select PD15 as the source input for the EXTI15 external interrupt"]
pub const PD15 : Self = Self (0x03) ; # [doc = "Select PE15 as the source input for the EXTI15 external interrupt"]
pub const PE15 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc2DmaRmp (pub u8) ; impl Adc2DmaRmp { # [doc = "ADC2 mapped on DMA2"]
pub const MAPDMA2 : Self = Self (0) ; # [doc = "ADC2 mapped on DMA1 channel 2"]
pub const MAPDMA1CH2 : Self = Self (0x02) ; # [doc = "ADC2 mapped on DMA1 channel 4"]
pub const MAPDMA1CH4 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c1Fmp (pub u8) ; impl I2c1Fmp { # [doc = "FM+ mode is controlled by I2C_Pxx_FMP bits only"]
pub const STANDARD : Self = Self (0) ; # [doc = "FM+ mode is enabled on all I2C1 pins selected through selection through IOPORT control registers AF selection bits"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPb7Fmp (pub u8) ; impl I2cPb7Fmp { # [doc = "PB7 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PB7 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct LockupLock (pub u8) ; impl LockupLock { # [doc = "Cortex-M4 LOCKUP output disconnected from TIM1/15/16/17 Break inputs and HRTIM1 SYSFLT."]
pub const DISCONNECTED : Self = Self (0) ; # [doc = "Cortex-M4 LOCKUP output connected to TIM1/15/16/17 and HRTIM1 SYSFLT Break inputs"]
pub const CONNECTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc12Jext3Rmp (pub u8) ; impl Adc12Jext3Rmp { # [doc = "Trigger source is TIM2_CC1"]
pub const TIM2 : Self = Self (0) ; # [doc = "Trigger source is TIM20_TRGO"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim1Itr3Rmp (pub u8) ; impl Tim1Itr3Rmp { # [doc = "Not remapped"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM1_ITR3 = TIM17_OC"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SramPefw (pub u8) ; impl SramPefw { # [doc = "Clear SRAM parity error flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc34Ext6Rmp (pub u8) ; impl Adc34Ext6Rmp { # [doc = "Trigger source is TIM4_CC1"]
pub const TIM4 : Self = Self (0) ; # [doc = "Trigger source is TIM20_TRGO2"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti11 (pub u8) ; impl Exti11 { # [doc = "Select PA11 as the source input for the EXTI11 external interrupt"]
pub const PA11 : Self = Self (0) ; # [doc = "Select PB11 as the source input for the EXTI11 external interrupt"]
pub const PB11 : Self = Self (0x01) ; # [doc = "Select PC11 as the source input for the EXTI11 external interrupt"]
pub const PC11 : Self = Self (0x02) ; # [doc = "Select PD11 as the source input for the EXTI11 external interrupt"]
pub const PD11 : Self = Self (0x03) ; # [doc = "Select PE11 as the source input for the EXTI11 external interrupt"]
pub const PE11 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Page0Wp (pub u8) ; impl Page0Wp { # [doc = "Write protection of pagex is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Write protection of pagex is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim7Dac1Out2DmaRmp (pub u8) ; impl Tim7Dac1Out2DmaRmp { # [doc = "TIM7 and DAC1_OUT2 DMA requests mapped on DMA2 channel 4"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM7 and DAC1_OUT2 DMA requests mapped on DMA1 channel 4"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim6Dac1Out1DmaRmp (pub u8) ; impl Tim6Dac1Out1DmaRmp { # [doc = "TIM7 and DAC1_OUT1 DMA requests mapped on DMA2 channel 3"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM7 and DAC1_OUT1 DMA requests mapped on DMA1 channel 3"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c1TxDmaRmp (pub u8) ; impl I2c1TxDmaRmp { # [doc = "I2C1_TX mapped on DMA1 CH6"]
pub const MAPDMA1CH6 : Self = Self (0) ; # [doc = "I2C1_TX mapped on DMA1 CH2"]
pub const MAPDMA1CH2 : Self = Self (0x01) ; # [doc = "I2C1_TX mapped on DMA1 CH4"]
pub const MAPDMA1CH4 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FpuIe5 (pub u8) ; impl FpuIe5 { # [doc = "Inexact interrupt disable"]
pub const DISABLED : Self = Self (0) ; # [doc = "Inexact interrupt enable"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc12Ext3Rmp (pub u8) ; impl Adc12Ext3Rmp { # [doc = "Trigger source is TIM2_CC2"]
pub const TIM2 : Self = Self (0) ; # [doc = "rigger source is TIM20_TRGO2"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FpuIe1 (pub u8) ; impl FpuIe1 { # [doc = "Devide-by-zero interrupt disable"]
pub const DISABLED : Self = Self (0) ; # [doc = "Devide-by-zero interrupt enable"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c3Fmp (pub u8) ; impl I2c3Fmp { # [doc = "FM+ mode is controlled by I2C_Pxx_FMP bits only"]
pub const STANDARD : Self = Self (0) ; # [doc = "FM+ mode is enabled on all I2C3 pins selected through selection trhough IOPORT control registers AF selection bits"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dac2Ch1DmaRmp (pub u8) ; impl Dac2Ch1DmaRmp { # [doc = "Not remapped"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "DAC2_CH1 DMA requests mapped on DMA1 channel 5"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exti5 (pub u8) ; impl Exti5 { # [doc = "Select PA5 as the source input for the EXTI5 external interrupt"]
pub const PA5 : Self = Self (0) ; # [doc = "Select PB5 as the source input for the EXTI5 external interrupt"]
pub const PB5 : Self = Self (0x01) ; # [doc = "Select PC5 as the source input for the EXTI5 external interrupt"]
pub const PC5 : Self = Self (0x02) ; # [doc = "Select PD5 as the source input for the EXTI5 external interrupt"]
pub const PD5 : Self = Self (0x03) ; # [doc = "Select PE5 as the source input for the EXTI5 external interrupt"]
pub const PE5 : Self = Self (0x04) ; # [doc = "Select PF5 as the source input for the EXTI5 external interrupt"]
pub const PF5 : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BypAddrPar (pub u8) ; impl BypAddrPar { # [doc = "The ramload operation is performed taking into consideration bit 29 of the address when the parity is calculated"]
pub const NOBYPASS : Self = Self (0) ; # [doc = "The ramload operation is performed without taking into consideration bit 29 of the address when the parity is calculated"]
pub const BYPASS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct EncoderMode (pub u8) ; impl EncoderMode { # [doc = "No redirection"]
pub const NOREDIRECTION : Self = Self (0) ; # [doc = "TIM2 IC1 and TIM2 IC2 are connected to TIM15 IC1 and TIM15 IC2 respectively"]
pub const MAPTIM2TIM15 : Self = Self (0x01) ; # [doc = "TIM3 IC1 and TIM3 IC2 are connected to TIM15 IC1 and TIM15 IC2 respectively"]
pub const MAPTIM3TIM15 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc12Ext5Rmp (pub u8) ; impl Adc12Ext5Rmp { # [doc = "Trigger source is TIM4_CC4"]
pub const TIM4 : Self = Self (0) ; # [doc = "Trigger source is TIM20_CC1"]
pub const TIM20 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FpuIe4 (pub u8) ; impl FpuIe4 { # [doc = "Input denormal interrupt disable"]
pub const DISABLED : Self = Self (0) ; # [doc = "Input denormal interrupt enable"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim7Dac1Ch2DmaRmp (pub u8) ; impl Tim7Dac1Ch2DmaRmp { # [doc = "Not remapped"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM7_UP and DAC_CH2 DMA requests mapped on DMA1 channel 4"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim18Dac2Out1DmaRmp (pub u8) ; impl Tim18Dac2Out1DmaRmp { # [doc = "TIM18 and DAC2_OUT1 DMA requests mapped on DMA2 channel 5"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM18 and DAC2_OUT1 DMA requests mapped on DMA1 channel 5"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adc34Jext5Rmp (pub u8) ; impl Adc34Jext5Rmp { # [doc = "Trigger source is TIM4_CC3"]
pub const TIM4 : Self = Self (0) ; # [doc = "Trigger source is TIM20_TRGO"]
pub const TIM20 : Self = Self (0x01) ; } }