

# [doc = "System configuration controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Syscfg (pub * mut u8) ; unsafe impl Send for Syscfg { } unsafe impl Sync for Syscfg { } impl Syscfg { # [doc = "configuration register 1"]
pub fn cfgr1 (self) -> crate :: common :: Reg < regs :: Cfgr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "external interrupt configuration register 1"]
pub fn exticr (self , n : usize) -> crate :: common :: Reg < regs :: Exticr , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize + n * 4usize)) } } # [doc = "configuration register 2"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } } pub mod regs { # [doc = "external interrupt configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Exticr (pub u32) ; impl Exticr { # [doc = "EXTI configuration bits"]
pub fn exti (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x0f ; val as u8 } # [doc = "EXTI configuration bits"]
pub fn set_exti (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x0f << offs)) | (((val as u32) & 0x0f) << offs) ; } } impl Default for Exticr { fn default () -> Exticr { Exticr (0) } } # [doc = "configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr1 (pub u32) ; impl Cfgr1 { # [doc = "Memory mapping selection bits"]
pub const fn mem_mode (& self) -> super :: vals :: MemMode { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: MemMode (val as u8) } # [doc = "Memory mapping selection bits"]
pub fn set_mem_mode (& mut self , val : super :: vals :: MemMode) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "PA11 and PA12 remapping bit for small packages (28 and 20 pins)"]
pub const fn pa11_pa12_rmp (& self) -> super :: vals :: Pa11Pa12Rmp { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Pa11Pa12Rmp (val as u8) } # [doc = "PA11 and PA12 remapping bit for small packages (28 and 20 pins)"]
pub fn set_pa11_pa12_rmp (& mut self , val : super :: vals :: Pa11Pa12Rmp) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "IR Modulation Envelope signal selection"]
pub const fn ir_mod (& self) -> super :: vals :: IrMod { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: IrMod (val as u8) } # [doc = "IR Modulation Envelope signal selection"]
pub fn set_ir_mod (& mut self , val : super :: vals :: IrMod) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "ADC DMA remapping bit"]
pub const fn adc_dma_rmp (& self) -> super :: vals :: AdcDmaRmp { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: AdcDmaRmp (val as u8) } # [doc = "ADC DMA remapping bit"]
pub fn set_adc_dma_rmp (& mut self , val : super :: vals :: AdcDmaRmp) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "USART1_TX DMA remapping bit"]
pub const fn usart1_tx_dma_rmp (& self) -> super :: vals :: Usart1TxDmaRmp { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Usart1TxDmaRmp (val as u8) } # [doc = "USART1_TX DMA remapping bit"]
pub fn set_usart1_tx_dma_rmp (& mut self , val : super :: vals :: Usart1TxDmaRmp) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "USART1_RX DMA request remapping bit"]
pub const fn usart1_rx_dma_rmp (& self) -> super :: vals :: Usart1RxDmaRmp { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Usart1RxDmaRmp (val as u8) } # [doc = "USART1_RX DMA request remapping bit"]
pub fn set_usart1_rx_dma_rmp (& mut self , val : super :: vals :: Usart1RxDmaRmp) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "TIM16 DMA request remapping bit"]
pub const fn tim16_dma_rmp (& self) -> super :: vals :: Tim16DmaRmp { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Tim16DmaRmp (val as u8) } # [doc = "TIM16 DMA request remapping bit"]
pub fn set_tim16_dma_rmp (& mut self , val : super :: vals :: Tim16DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "TIM17 DMA request remapping bit"]
pub const fn tim17_dma_rmp (& self) -> super :: vals :: Tim17DmaRmp { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Tim17DmaRmp (val as u8) } # [doc = "TIM17 DMA request remapping bit"]
pub fn set_tim17_dma_rmp (& mut self , val : super :: vals :: Tim17DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "TIM16 alternate DMA request remapping bit"]
pub const fn tim16_dma_rmp2 (& self) -> super :: vals :: Tim16DmaRmp2 { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Tim16DmaRmp2 (val as u8) } # [doc = "TIM16 alternate DMA request remapping bit"]
pub fn set_tim16_dma_rmp2 (& mut self , val : super :: vals :: Tim16DmaRmp2) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "TIM17 alternate DMA request remapping bit"]
pub const fn tim17_dma_rmp2 (& self) -> super :: vals :: Tim17DmaRmp2 { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Tim17DmaRmp2 (val as u8) } # [doc = "TIM17 alternate DMA request remapping bit"]
pub fn set_tim17_dma_rmp2 (& mut self , val : super :: vals :: Tim17DmaRmp2) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Fast Mode Plus (FM plus) driving capability activation bits."]
pub const fn i2c_pb6_fmp (& self) -> super :: vals :: I2cPb6Fmp { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: I2cPb6Fmp (val as u8) } # [doc = "Fast Mode Plus (FM plus) driving capability activation bits."]
pub fn set_i2c_pb6_fmp (& mut self , val : super :: vals :: I2cPb6Fmp) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub const fn i2c_pb7_fmp (& self) -> super :: vals :: I2cPb7Fmp { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: I2cPb7Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub fn set_i2c_pb7_fmp (& mut self , val : super :: vals :: I2cPb7Fmp) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub const fn i2c_pb8_fmp (& self) -> super :: vals :: I2cPb8Fmp { let val = (self . 0 >> 18usize) & 0x01 ; super :: vals :: I2cPb8Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub fn set_i2c_pb8_fmp (& mut self , val : super :: vals :: I2cPb8Fmp) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val . 0 as u32) & 0x01) << 18usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub const fn i2c_pb9_fmp (& self) -> super :: vals :: I2cPb9Fmp { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: I2cPb9Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits."]
pub fn set_i2c_pb9_fmp (& mut self , val : super :: vals :: I2cPb9Fmp) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "FM+ driving capability activation for I2C1"]
pub const fn i2c1_fmp (& self) -> super :: vals :: I2c1Fmp { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: I2c1Fmp (val as u8) } # [doc = "FM+ driving capability activation for I2C1"]
pub fn set_i2c1_fmp (& mut self , val : super :: vals :: I2c1Fmp) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "FM+ driving capability activation for I2C2"]
pub const fn i2c2_fmp (& self) -> super :: vals :: I2c2Fmp { let val = (self . 0 >> 21usize) & 0x01 ; super :: vals :: I2c2Fmp (val as u8) } # [doc = "FM+ driving capability activation for I2C2"]
pub fn set_i2c2_fmp (& mut self , val : super :: vals :: I2c2Fmp) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val . 0 as u32) & 0x01) << 21usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits"]
pub const fn i2c_pa9_fmp (& self) -> super :: vals :: I2cPa9Fmp { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: I2cPa9Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits"]
pub fn set_i2c_pa9_fmp (& mut self , val : super :: vals :: I2cPa9Fmp) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Fast Mode Plus (FM+) driving capability activation bits"]
pub const fn i2c_pa10_fmp (& self) -> super :: vals :: I2cPa10Fmp { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: I2cPa10Fmp (val as u8) } # [doc = "Fast Mode Plus (FM+) driving capability activation bits"]
pub fn set_i2c_pa10_fmp (& mut self , val : super :: vals :: I2cPa10Fmp) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "SPI2 DMA request remapping bit"]
pub const fn spi2_dma_rmp (& self) -> super :: vals :: Spi2DmaRmp { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Spi2DmaRmp (val as u8) } # [doc = "SPI2 DMA request remapping bit"]
pub fn set_spi2_dma_rmp (& mut self , val : super :: vals :: Spi2DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "USART2 DMA request remapping bit"]
pub const fn usart2_dma_rmp (& self) -> super :: vals :: Usart2DmaRmp { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Usart2DmaRmp (val as u8) } # [doc = "USART2 DMA request remapping bit"]
pub fn set_usart2_dma_rmp (& mut self , val : super :: vals :: Usart2DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "USART3 DMA request remapping bit"]
pub const fn usart3_dma_rmp (& self) -> super :: vals :: Usart3DmaRmp { let val = (self . 0 >> 26usize) & 0x01 ; super :: vals :: Usart3DmaRmp (val as u8) } # [doc = "USART3 DMA request remapping bit"]
pub fn set_usart3_dma_rmp (& mut self , val : super :: vals :: Usart3DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val . 0 as u32) & 0x01) << 26usize) ; } # [doc = "I2C1 DMA request remapping bit"]
pub const fn i2c1_dma_rmp (& self) -> super :: vals :: I2c1DmaRmp { let val = (self . 0 >> 27usize) & 0x01 ; super :: vals :: I2c1DmaRmp (val as u8) } # [doc = "I2C1 DMA request remapping bit"]
pub fn set_i2c1_dma_rmp (& mut self , val : super :: vals :: I2c1DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val . 0 as u32) & 0x01) << 27usize) ; } # [doc = "TIM1 DMA request remapping bit"]
pub const fn tim1_dma_rmp (& self) -> super :: vals :: Tim1DmaRmp { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: Tim1DmaRmp (val as u8) } # [doc = "TIM1 DMA request remapping bit"]
pub fn set_tim1_dma_rmp (& mut self , val : super :: vals :: Tim1DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } # [doc = "TIM2 DMA request remapping bit"]
pub const fn tim2_dma_rmp (& self) -> super :: vals :: Tim2DmaRmp { let val = (self . 0 >> 29usize) & 0x01 ; super :: vals :: Tim2DmaRmp (val as u8) } # [doc = "TIM2 DMA request remapping bit"]
pub fn set_tim2_dma_rmp (& mut self , val : super :: vals :: Tim2DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val . 0 as u32) & 0x01) << 29usize) ; } # [doc = "TIM3 DMA request remapping bit"]
pub const fn tim3_dma_rmp (& self) -> super :: vals :: Tim3DmaRmp { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: Tim3DmaRmp (val as u8) } # [doc = "TIM3 DMA request remapping bit"]
pub fn set_tim3_dma_rmp (& mut self , val : super :: vals :: Tim3DmaRmp) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } } impl Default for Cfgr1 { fn default () -> Cfgr1 { Cfgr1 (0) } } # [doc = "configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "Cortex-M0 LOCKUP bit enable bit"]
pub const fn lockup_lock (& self) -> super :: vals :: LockupLock { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: LockupLock (val as u8) } # [doc = "Cortex-M0 LOCKUP bit enable bit"]
pub fn set_lockup_lock (& mut self , val : super :: vals :: LockupLock) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "SRAM parity lock bit"]
pub const fn sram_parity_lock (& self) -> super :: vals :: SramParityLock { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: SramParityLock (val as u8) } # [doc = "SRAM parity lock bit"]
pub fn set_sram_parity_lock (& mut self , val : super :: vals :: SramParityLock) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "PVD lock enable bit"]
pub const fn pvd_lock (& self) -> super :: vals :: PvdLock { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: PvdLock (val as u8) } # [doc = "PVD lock enable bit"]
pub fn set_pvd_lock (& mut self , val : super :: vals :: PvdLock) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "SRAM parity flag"]
pub const fn sram_pef (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "SRAM parity flag"]
pub fn set_sram_pef (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PvdLock (pub u8) ; impl PvdLock { # [doc = "PVD interrupt disconnected from TIM1/15/16/17 Break input"]
pub const DISCONNECTED : Self = Self (0) ; # [doc = "PVD interrupt connected to TIM1/15/16/17 Break input"]
pub const CONNECTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usart3DmaRmp (pub u8) ; impl Usart3DmaRmp { # [doc = "USART3_RX and USART3_TX DMA requests mapped on DMA channel 6 and 7 respectively (or simply disabled on STM32F0x0)"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "USART3_RX and USART3_TX DMA requests mapped on DMA channel 3 and 2 respectively"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SramParityLock (pub u8) ; impl SramParityLock { # [doc = "SRAM parity error disconnected from TIM1/15/16/17 Break input"]
pub const DISCONNECTED : Self = Self (0) ; # [doc = "SRAM parity error connected to TIM1/15/16/17 Break input"]
pub const CONNECTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pa11Pa12Rmp (pub u8) ; impl Pa11Pa12Rmp { # [doc = "Pin pair PA9/PA10 mapped on the pins"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "Pin pair PA11/PA12 mapped instead of PA9/PA10"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim16DmaRmp2 (pub u8) ; impl Tim16DmaRmp2 { # [doc = "TIM16 DMA request mapped according to TIM16_DMA_RMP bit"]
pub const NOTALTERNATEREMAPPED : Self = Self (0) ; # [doc = "TIM16_CH1 and TIM16_UP DMA request mapped on DMA channel 6"]
pub const ALTERNATEREMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct MemMode (pub u8) ; impl MemMode { # [doc = "Main Flash memory mapped at 0x0000_0000"]
pub const MAINFLASH : Self = Self (0) ; # [doc = "System Flash memory mapped at 0x0000_0000"]
pub const SYSTEMFLASH : Self = Self (0x01) ; # [doc = "Main Flash memory mapped at 0x0000_0000"]
pub const MAINFLASH2 : Self = Self (0x02) ; # [doc = "Embedded SRAM mapped at 0x0000_0000"]
pub const SRAM : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c1Fmp (pub u8) ; impl I2c1Fmp { # [doc = "FM+ mode is controlled by I2C_Pxx_FMP bits only"]
pub const STANDARD : Self = Self (0) ; # [doc = "FM+ mode is enabled on all I2C1 pins selected through selection bits in GPIOx_AFR registers"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPa10Fmp (pub u8) ; impl I2cPa10Fmp { # [doc = "PA10 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PA10 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPb8Fmp (pub u8) ; impl I2cPb8Fmp { # [doc = "PB8 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PB8 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPb6Fmp (pub u8) ; impl I2cPb6Fmp { # [doc = "PB6 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PB6 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPb9Fmp (pub u8) ; impl I2cPb9Fmp { # [doc = "PB9 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PB9 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim17DmaRmp2 (pub u8) ; impl Tim17DmaRmp2 { # [doc = "TIM17 DMA request mapped according to TIM16_DMA_RMP bit"]
pub const NOTALTERNATEREMAPPED : Self = Self (0) ; # [doc = "TIM17_CH1 and TIM17_UP DMA request mapped on DMA channel 7"]
pub const ALTERNATEREMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim3DmaRmp (pub u8) ; impl Tim3DmaRmp { # [doc = "TIM3_CH1 and TIM3_TRIG DMA requests mapped on DMA channel 4"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM3_CH1 and TIM3_TRIG DMA requests mapped on DMA channel 6"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c2Fmp (pub u8) ; impl I2c2Fmp { # [doc = "FM+ mode is controlled by I2C_Pxx_FMP bits only"]
pub const STANDARD : Self = Self (0) ; # [doc = "FM+ mode is enabled on all I2C2 pins selected through selection bits in GPIOx_AFR registers"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usart1TxDmaRmp (pub u8) ; impl Usart1TxDmaRmp { # [doc = "USART1_TX DMA request mapped on DMA channel 2"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "USART1_TX DMA request mapped on DMA channel 4"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct AdcDmaRmp (pub u8) ; impl AdcDmaRmp { # [doc = "ADC DMA request mapped on DMA channel 1"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "ADC DMA request mapped on DMA channel 2"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPa9Fmp (pub u8) ; impl I2cPa9Fmp { # [doc = "PA9 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PA9 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2cPb7Fmp (pub u8) ; impl I2cPb7Fmp { # [doc = "PB7 pin operate in standard mode"]
pub const STANDARD : Self = Self (0) ; # [doc = "I2C FM+ mode enabled on PB7 and the Speed control is bypassed"]
pub const FMP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct LockupLock (pub u8) ; impl LockupLock { # [doc = "Cortex-M0 LOCKUP output disconnected from TIM1/15/16/17 Break input"]
pub const DISCONNECTED : Self = Self (0) ; # [doc = "Cortex-M0 LOCKUP output connected to TIM1/15/16/17 Break input"]
pub const CONNECTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SramPefr (pub u8) ; impl SramPefr { # [doc = "No SRAM parity error detected"]
pub const NOPARITYERROR : Self = Self (0) ; # [doc = "SRAM parity error detected"]
pub const PARITYERRORDETECTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim17DmaRmp (pub u8) ; impl Tim17DmaRmp { # [doc = "TIM17_CH1 and TIM17_UP DMA request mapped on DMA channel 1"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM17_CH1 and TIM17_UP DMA request mapped on DMA channel 2"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct IrMod (pub u8) ; impl IrMod { # [doc = "TIM16 selected"]
pub const TIM16 : Self = Self (0) ; # [doc = "USART1 selected"]
pub const USART1 : Self = Self (0x01) ; # [doc = "USART4 selected"]
pub const USART4 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usart1RxDmaRmp (pub u8) ; impl Usart1RxDmaRmp { # [doc = "USART1_RX DMA request mapped on DMA channel 3"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "USART1_RX DMA request mapped on DMA channel 5"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SramPefw (pub u8) ; impl SramPefw { # [doc = "Clear SRAM parity error flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usart2DmaRmp (pub u8) ; impl Usart2DmaRmp { # [doc = "USART2_RX and USART2_TX DMA requests mapped on DMA channel 5 and 4 respectively"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "USART2_RX and USART2_TX DMA requests mapped on DMA channel 6 and 7 respectively"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim2DmaRmp (pub u8) ; impl Tim2DmaRmp { # [doc = "TIM2_CH2 and TIM2_CH4 DMA requests mapped on DMA channel 3 and 4 respectively"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM2_CH2 and TIM2_CH4 DMA requests mapped on DMA channel 7"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spi2DmaRmp (pub u8) ; impl Spi2DmaRmp { # [doc = "SPI2_RX and SPI2_TX DMA requests mapped on DMA channel 4 and 5 respectively"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "SPI2_RX and SPI2_TX DMA requests mapped on DMA channel 6 and 7 respectively"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c1DmaRmp (pub u8) ; impl I2c1DmaRmp { # [doc = "I2C1_RX and I2C1_TX DMA requests mapped on DMA channel 3 and 2 respectively"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "I2C1_RX and I2C1_TX DMA requests mapped on DMA channel 7 and 6 respectively"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim16DmaRmp (pub u8) ; impl Tim16DmaRmp { # [doc = "TIM16_CH1 and TIM16_UP DMA request mapped on DMA channel 3"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM16_CH1 and TIM16_UP DMA request mapped on DMA channel 4"]
pub const REMAPPED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tim1DmaRmp (pub u8) ; impl Tim1DmaRmp { # [doc = "TIM1_CH1, TIM1_CH2 and TIM1_CH3 DMA requests mapped on DMA channel 2, 3 and 4 respectively"]
pub const NOTREMAPPED : Self = Self (0) ; # [doc = "TIM1_CH1, TIM1_CH2 and TIM1_CH3 DMA requests mapped on DMA channel 6"]
pub const REMAPPED : Self = Self (0x01) ; } }