

# [doc = "Serial peripheral interface"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Spi (pub * mut u8) ; unsafe impl Send for Spi { } unsafe impl Sync for Spi { } impl Spi { # [doc = "control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "configuration register 1"]
pub fn cfg1 (self) -> crate :: common :: Reg < regs :: Cfg1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "configuration register 2"]
pub fn cfg2 (self) -> crate :: common :: Reg < regs :: Cfg2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Interrupt Enable Register"]
pub fn ier (self) -> crate :: common :: Reg < regs :: Ier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Status Register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Interrupt/Status Flags Clear Register"]
pub fn ifcr (self) -> crate :: common :: Reg < regs :: Ifcr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Transmit Data Register"]
pub fn txdr (self) -> crate :: common :: Reg < regs :: Txdr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Receive Data Register"]
pub fn rxdr (self) -> crate :: common :: Reg < regs :: Rxdr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "Polynomial Register"]
pub fn crcpoly (self) -> crate :: common :: Reg < regs :: Crcpoly , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "Transmitter CRC Register"]
pub fn txcrc (self) -> crate :: common :: Reg < regs :: Txcrc , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "Receiver CRC Register"]
pub fn rxcrc (self) -> crate :: common :: Reg < regs :: Rxcrc , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "Underrun Data Register"]
pub fn udrdr (self) -> crate :: common :: Reg < regs :: Udrdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } pub mod regs { # [doc = "Receiver CRC Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rxcrc (pub u32) ; impl Rxcrc { # [doc = "CRC register for receiver"]
pub const fn rxcrc (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "CRC register for receiver"]
pub fn set_rxcrc (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Rxcrc { fn default () -> Rxcrc { Rxcrc (0) } } # [doc = "Polynomial Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crcpoly (pub u32) ; impl Crcpoly { # [doc = "CRC polynomial register"]
pub const fn crcpoly (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "CRC polynomial register"]
pub fn set_crcpoly (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Crcpoly { fn default () -> Crcpoly { Crcpoly (0) } } # [doc = "control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "Number of data at current transfer"]
pub const fn tsize (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Number of data at current transfer"]
pub fn set_tsize (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Number of data transfer extension to be reload into TSIZE just when a previous"]
pub const fn tser (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Number of data transfer extension to be reload into TSIZE just when a previous"]
pub fn set_tser (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Rx-Packet available"]
pub const fn rxp (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Rx-Packet available"]
pub fn set_rxp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Tx-Packet space available"]
pub const fn txp (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Tx-Packet space available"]
pub fn set_txp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Duplex Packet"]
pub const fn dxp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Duplex Packet"]
pub fn set_dxp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "End Of Transfer"]
pub const fn eot (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "End Of Transfer"]
pub fn set_eot (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Transmission Transfer Filled"]
pub const fn txtf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Transmission Transfer Filled"]
pub fn set_txtf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Underrun at slave transmission mode"]
pub const fn udr (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Underrun at slave transmission mode"]
pub fn set_udr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Overrun"]
pub const fn ovr (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Overrun"]
pub fn set_ovr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "CRC Error"]
pub const fn crce (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CRC Error"]
pub fn set_crce (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TI frame format error"]
pub const fn tifre (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TI frame format error"]
pub fn set_tifre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Mode Fault"]
pub const fn modf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Mode Fault"]
pub fn set_modf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Additional number of SPI data to be transacted was reload"]
pub const fn tserf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Additional number of SPI data to be transacted was reload"]
pub fn set_tserf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SUSPend"]
pub const fn susp (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SUSPend"]
pub fn set_susp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "TxFIFO transmission complete"]
pub const fn txc (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "TxFIFO transmission complete"]
pub fn set_txc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "RxFIFO Packing LeVeL"]
pub const fn rxplvl (& self) -> super :: vals :: Rxplvl { let val = (self . 0 >> 13usize) & 0x03 ; super :: vals :: Rxplvl (val as u8) } # [doc = "RxFIFO Packing LeVeL"]
pub fn set_rxplvl (& mut self , val : super :: vals :: Rxplvl) { self . 0 = (self . 0 & ! (0x03 << 13usize)) | (((val . 0 as u32) & 0x03) << 13usize) ; } # [doc = "RxFIFO Word Not Empty"]
pub const fn rxwne (& self) -> super :: vals :: Rxwne { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Rxwne (val as u8) } # [doc = "RxFIFO Word Not Empty"]
pub fn set_rxwne (& mut self , val : super :: vals :: Rxwne) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Number of data frames remaining in current TSIZE session"]
pub const fn ctsize (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Number of data frames remaining in current TSIZE session"]
pub fn set_ctsize (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "Receive Data Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rxdr (pub u32) ; impl Rxdr { # [doc = "Receive data register"]
pub const fn rxdr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Receive data register"]
pub fn set_rxdr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Rxdr { fn default () -> Rxdr { Rxdr (0) } } # [doc = "control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Serial Peripheral Enable"]
pub const fn spe (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Serial Peripheral Enable"]
pub fn set_spe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Master automatic SUSP in Receive mode"]
pub const fn masrx (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Master automatic SUSP in Receive mode"]
pub fn set_masrx (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Master transfer start"]
pub const fn cstart (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Master transfer start"]
pub fn set_cstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Master SUSPend request"]
pub const fn csusp (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Master SUSPend request"]
pub fn set_csusp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Rx/Tx direction at Half-duplex mode"]
pub const fn hddir (& self) -> super :: vals :: Hddir { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Hddir (val as u8) } # [doc = "Rx/Tx direction at Half-duplex mode"]
pub fn set_hddir (& mut self , val : super :: vals :: Hddir) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Internal SS signal input level"]
pub const fn ssi (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Internal SS signal input level"]
pub fn set_ssi (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "32-bit CRC polynomial configuration"]
pub const fn crc33_17 (& self) -> super :: vals :: Crc { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Crc (val as u8) } # [doc = "32-bit CRC polynomial configuration"]
pub fn set_crc33_17 (& mut self , val : super :: vals :: Crc) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "CRC calculation initialization pattern control for receiver"]
pub const fn rcrcini (& self) -> super :: vals :: Rcrcini { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Rcrcini (val as u8) } # [doc = "CRC calculation initialization pattern control for receiver"]
pub fn set_rcrcini (& mut self , val : super :: vals :: Rcrcini) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "CRC calculation initialization pattern control for transmitter"]
pub const fn tcrcini (& self) -> super :: vals :: Tcrcini { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Tcrcini (val as u8) } # [doc = "CRC calculation initialization pattern control for transmitter"]
pub fn set_tcrcini (& mut self , val : super :: vals :: Tcrcini) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Locking the AF configuration of associated IOs"]
pub const fn iolock (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Locking the AF configuration of associated IOs"]
pub fn set_iolock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "Interrupt/Status Flags Clear Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ifcr (pub u32) ; impl Ifcr { # [doc = "End Of Transfer flag clear"]
pub const fn eotc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "End Of Transfer flag clear"]
pub fn set_eotc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Transmission Transfer Filled flag clear"]
pub const fn txtfc (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Transmission Transfer Filled flag clear"]
pub fn set_txtfc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Underrun flag clear"]
pub const fn udrc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Underrun flag clear"]
pub fn set_udrc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Overrun flag clear"]
pub const fn ovrc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Overrun flag clear"]
pub fn set_ovrc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "CRC Error flag clear"]
pub const fn crcec (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CRC Error flag clear"]
pub fn set_crcec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TI frame format error flag clear"]
pub const fn tifrec (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TI frame format error flag clear"]
pub fn set_tifrec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Mode Fault flag clear"]
pub const fn modfc (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Mode Fault flag clear"]
pub fn set_modfc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TSERFC flag clear"]
pub const fn tserfc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "TSERFC flag clear"]
pub fn set_tserfc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SUSPend flag clear"]
pub const fn suspc (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SUSPend flag clear"]
pub fn set_suspc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Ifcr { fn default () -> Ifcr { Ifcr (0) } } # [doc = "configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfg1 (pub u32) ; impl Cfg1 { # [doc = "Number of bits in at single SPI data frame"]
pub const fn dsize (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "Number of bits in at single SPI data frame"]
pub fn set_dsize (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "threshold level"]
pub const fn fthlv (& self) -> super :: vals :: Fthlv { let val = (self . 0 >> 5usize) & 0x0f ; super :: vals :: Fthlv (val as u8) } # [doc = "threshold level"]
pub fn set_fthlv (& mut self , val : super :: vals :: Fthlv) { self . 0 = (self . 0 & ! (0x0f << 5usize)) | (((val . 0 as u32) & 0x0f) << 5usize) ; } # [doc = "Behavior of slave transmitter at underrun condition"]
pub const fn udrcfg (& self) -> super :: vals :: Udrcfg { let val = (self . 0 >> 9usize) & 0x03 ; super :: vals :: Udrcfg (val as u8) } # [doc = "Behavior of slave transmitter at underrun condition"]
pub fn set_udrcfg (& mut self , val : super :: vals :: Udrcfg) { self . 0 = (self . 0 & ! (0x03 << 9usize)) | (((val . 0 as u32) & 0x03) << 9usize) ; } # [doc = "Detection of underrun condition at slave transmitter"]
pub const fn udrdet (& self) -> super :: vals :: Udrdet { let val = (self . 0 >> 11usize) & 0x03 ; super :: vals :: Udrdet (val as u8) } # [doc = "Detection of underrun condition at slave transmitter"]
pub fn set_udrdet (& mut self , val : super :: vals :: Udrdet) { self . 0 = (self . 0 & ! (0x03 << 11usize)) | (((val . 0 as u32) & 0x03) << 11usize) ; } # [doc = "Rx DMA stream enable"]
pub const fn rxdmaen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Rx DMA stream enable"]
pub fn set_rxdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Tx DMA stream enable"]
pub const fn txdmaen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Tx DMA stream enable"]
pub fn set_txdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Length of CRC frame to be transacted and compared"]
pub const fn crcsize (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x1f ; val as u8 } # [doc = "Length of CRC frame to be transacted and compared"]
pub fn set_crcsize (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 16usize)) | (((val as u32) & 0x1f) << 16usize) ; } # [doc = "Hardware CRC computation enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Hardware CRC computation enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Master baud rate"]
pub const fn mbr (& self) -> super :: vals :: Mbr { let val = (self . 0 >> 28usize) & 0x07 ; super :: vals :: Mbr (val as u8) } # [doc = "Master baud rate"]
pub fn set_mbr (& mut self , val : super :: vals :: Mbr) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val . 0 as u32) & 0x07) << 28usize) ; } } impl Default for Cfg1 { fn default () -> Cfg1 { Cfg1 (0) } } # [doc = "Transmitter CRC Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Txcrc (pub u32) ; impl Txcrc { # [doc = "CRC register for transmitter"]
pub const fn txcrc (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "CRC register for transmitter"]
pub fn set_txcrc (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Txcrc { fn default () -> Txcrc { Txcrc (0) } } # [doc = "Transmit Data Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Txdr (pub u32) ; impl Txdr { # [doc = "Transmit data register"]
pub const fn txdr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Transmit data register"]
pub fn set_txdr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Txdr { fn default () -> Txdr { Txdr (0) } } # [doc = "configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfg2 (pub u32) ; impl Cfg2 { # [doc = "Master SS Idleness"]
pub const fn mssi (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Master SS Idleness"]
pub fn set_mssi (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Master Inter-Data Idleness"]
pub const fn midi (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "Master Inter-Data Idleness"]
pub fn set_midi (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "Swap functionality of MISO and MOSI pins"]
pub const fn ioswp (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Swap functionality of MISO and MOSI pins"]
pub fn set_ioswp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SPI Communication Mode"]
pub const fn comm (& self) -> super :: vals :: Comm { let val = (self . 0 >> 17usize) & 0x03 ; super :: vals :: Comm (val as u8) } # [doc = "SPI Communication Mode"]
pub fn set_comm (& mut self , val : super :: vals :: Comm) { self . 0 = (self . 0 & ! (0x03 << 17usize)) | (((val . 0 as u32) & 0x03) << 17usize) ; } # [doc = "Serial Protocol"]
pub const fn sp (& self) -> super :: vals :: Sp { let val = (self . 0 >> 19usize) & 0x07 ; super :: vals :: Sp (val as u8) } # [doc = "Serial Protocol"]
pub fn set_sp (& mut self , val : super :: vals :: Sp) { self . 0 = (self . 0 & ! (0x07 << 19usize)) | (((val . 0 as u32) & 0x07) << 19usize) ; } # [doc = "SPI Master"]
pub const fn master (& self) -> super :: vals :: Master { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Master (val as u8) } # [doc = "SPI Master"]
pub fn set_master (& mut self , val : super :: vals :: Master) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Data frame format"]
pub const fn lsbfirst (& self) -> super :: vals :: Lsbfirst { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Lsbfirst (val as u8) } # [doc = "Data frame format"]
pub fn set_lsbfirst (& mut self , val : super :: vals :: Lsbfirst) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "Clock phase"]
pub const fn cpha (& self) -> super :: vals :: Cpha { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Cpha (val as u8) } # [doc = "Clock phase"]
pub fn set_cpha (& mut self , val : super :: vals :: Cpha) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "Clock polarity"]
pub const fn cpol (& self) -> super :: vals :: Cpol { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Cpol (val as u8) } # [doc = "Clock polarity"]
pub fn set_cpol (& mut self , val : super :: vals :: Cpol) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "Software management of SS signal input"]
pub const fn ssm (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Software management of SS signal input"]
pub fn set_ssm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "SS input/output polarity"]
pub const fn ssiop (& self) -> super :: vals :: Ssiop { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: Ssiop (val as u8) } # [doc = "SS input/output polarity"]
pub fn set_ssiop (& mut self , val : super :: vals :: Ssiop) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } # [doc = "SS output enable"]
pub const fn ssoe (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "SS output enable"]
pub fn set_ssoe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "SS output management in master mode"]
pub const fn ssom (& self) -> super :: vals :: Ssom { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: Ssom (val as u8) } # [doc = "SS output management in master mode"]
pub fn set_ssom (& mut self , val : super :: vals :: Ssom) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "Alternate function GPIOs control"]
pub const fn afcntr (& self) -> super :: vals :: Afcntr { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Afcntr (val as u8) } # [doc = "Alternate function GPIOs control"]
pub fn set_afcntr (& mut self , val : super :: vals :: Afcntr) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Cfg2 { fn default () -> Cfg2 { Cfg2 (0) } } # [doc = "Interrupt Enable Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ier (pub u32) ; impl Ier { # [doc = "RXP Interrupt Enable"]
pub const fn rxpie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "RXP Interrupt Enable"]
pub fn set_rxpie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TXP interrupt enable"]
pub const fn txpie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TXP interrupt enable"]
pub fn set_txpie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DXP interrupt enabled"]
pub const fn dxpie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DXP interrupt enabled"]
pub fn set_dxpie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "EOT, SUSP and TXC interrupt enable"]
pub const fn eotie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "EOT, SUSP and TXC interrupt enable"]
pub fn set_eotie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TXTFIE interrupt enable"]
pub const fn txtfie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TXTFIE interrupt enable"]
pub fn set_txtfie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "UDR interrupt enable"]
pub const fn udrie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "UDR interrupt enable"]
pub fn set_udrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "OVR interrupt enable"]
pub const fn ovrie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "OVR interrupt enable"]
pub fn set_ovrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "CRC Interrupt enable"]
pub const fn crceie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CRC Interrupt enable"]
pub fn set_crceie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIFRE interrupt enable"]
pub const fn tifreie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIFRE interrupt enable"]
pub fn set_tifreie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Mode Fault interrupt enable"]
pub const fn modfie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Mode Fault interrupt enable"]
pub fn set_modfie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Additional number of transactions reload interrupt enable"]
pub const fn tserfie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Additional number of transactions reload interrupt enable"]
pub fn set_tserfie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Ier { fn default () -> Ier { Ier (0) } } # [doc = "Underrun Data Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Udrdr (pub u32) ; impl Udrdr { # [doc = "Data at slave underrun condition"]
pub const fn udrdr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Data at slave underrun condition"]
pub fn set_udrdr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Udrdr { fn default () -> Udrdr { Udrdr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hddir (pub u8) ; impl Hddir { # [doc = "Receiver in half duplex mode"]
pub const RECEIVER : Self = Self (0) ; # [doc = "Transmitter in half duplex mode"]
pub const TRANSMITTER : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpol (pub u8) ; impl Cpol { # [doc = "CK to 0 when idle"]
pub const IDLELOW : Self = Self (0) ; # [doc = "CK to 1 when idle"]
pub const IDLEHIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Afcntr (pub u8) ; impl Afcntr { # [doc = "Peripheral takes no control of GPIOs while disabled"]
pub const NOTCONTROLLED : Self = Self (0) ; # [doc = "Peripheral controls GPIOs while disabled"]
pub const CONTROLLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Udrcfg (pub u8) ; impl Udrcfg { # [doc = "Slave sends a constant underrun pattern"]
pub const CONSTANT : Self = Self (0) ; # [doc = "Slave repeats last received data frame from master"]
pub const REPEATRECEIVED : Self = Self (0x01) ; # [doc = "Slave repeats last transmitted data frame"]
pub const REPEATTRANSMITTED : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mbr (pub u8) ; impl Mbr { # [doc = "f_spi_ker_ck / 2"]
pub const DIV2 : Self = Self (0) ; # [doc = "f_spi_ker_ck / 4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "f_spi_ker_ck / 8"]
pub const DIV8 : Self = Self (0x02) ; # [doc = "f_spi_ker_ck / 16"]
pub const DIV16 : Self = Self (0x03) ; # [doc = "f_spi_ker_ck / 32"]
pub const DIV32 : Self = Self (0x04) ; # [doc = "f_spi_ker_ck / 64"]
pub const DIV64 : Self = Self (0x05) ; # [doc = "f_spi_ker_ck / 128"]
pub const DIV128 : Self = Self (0x06) ; # [doc = "f_spi_ker_ck / 256"]
pub const DIV256 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Udrdet (pub u8) ; impl Udrdet { # [doc = "Underrun is detected at begin of data frame"]
pub const STARTOFFRAME : Self = Self (0) ; # [doc = "Underrun is detected at end of last data frame"]
pub const ENDOFFRAME : Self = Self (0x01) ; # [doc = "Underrun is detected at begin of active SS signal"]
pub const STARTOFSLAVESELECT : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Comm (pub u8) ; impl Comm { # [doc = "Full duplex"]
pub const FULLDUPLEX : Self = Self (0) ; # [doc = "Simplex transmitter only"]
pub const TRANSMITTER : Self = Self (0x01) ; # [doc = "Simplex receiver only"]
pub const RECEIVER : Self = Self (0x02) ; # [doc = "Half duplex"]
pub const HALFDUPLEX : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ssom (pub u8) ; impl Ssom { # [doc = "SS is asserted until data transfer complete"]
pub const ASSERTED : Self = Self (0) ; # [doc = "Data frames interleaved with SS not asserted during MIDI"]
pub const NOTASSERTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fthlv (pub u8) ; impl Fthlv { # [doc = "1 frame"]
pub const ONEFRAME : Self = Self (0) ; # [doc = "2 frames"]
pub const TWOFRAMES : Self = Self (0x01) ; # [doc = "3 frames"]
pub const THREEFRAMES : Self = Self (0x02) ; # [doc = "4 frames"]
pub const FOURFRAMES : Self = Self (0x03) ; # [doc = "5 frames"]
pub const FIVEFRAMES : Self = Self (0x04) ; # [doc = "6 frames"]
pub const SIXFRAMES : Self = Self (0x05) ; # [doc = "7 frames"]
pub const SEVENFRAMES : Self = Self (0x06) ; # [doc = "8 frames"]
pub const EIGHTFRAMES : Self = Self (0x07) ; # [doc = "9 frames"]
pub const NINEFRAMES : Self = Self (0x08) ; # [doc = "10 frames"]
pub const TENFRAMES : Self = Self (0x09) ; # [doc = "11 frames"]
pub const ELEVENFRAMES : Self = Self (0x0a) ; # [doc = "12 frames"]
pub const TWELVEFRAMES : Self = Self (0x0b) ; # [doc = "13 frames"]
pub const THIRTEENFRAMES : Self = Self (0x0c) ; # [doc = "14 frames"]
pub const FOURTEENFRAMES : Self = Self (0x0d) ; # [doc = "15 frames"]
pub const FIFTEENFRAMES : Self = Self (0x0e) ; # [doc = "16 frames"]
pub const SIXTEENFRAMES : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ssiop (pub u8) ; impl Ssiop { # [doc = "Low level is active for SS signal"]
pub const ACTIVELOW : Self = Self (0) ; # [doc = "High level is active for SS signal"]
pub const ACTIVEHIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Crc (pub u8) ; impl Crc { # [doc = "Full size (33/17 bit) CRC polynomial is not used"]
pub const DISABLED : Self = Self (0) ; # [doc = "Full size (33/17 bit) CRC polynomial is used"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Master (pub u8) ; impl Master { # [doc = "Slave configuration"]
pub const SLAVE : Self = Self (0) ; # [doc = "Master configuration"]
pub const MASTER : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rxplvl (pub u8) ; impl Rxplvl { # [doc = "Zero frames beyond packing ratio available"]
pub const ZEROFRAMES : Self = Self (0) ; # [doc = "One frame beyond packing ratio available"]
pub const ONEFRAME : Self = Self (0x01) ; # [doc = "Two frame beyond packing ratio available"]
pub const TWOFRAMES : Self = Self (0x02) ; # [doc = "Three frame beyond packing ratio available"]
pub const THREEFRAMES : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rxwne (pub u8) ; impl Rxwne { # [doc = "Less than 32-bit data frame received"]
pub const LESSTHAN32 : Self = Self (0) ; # [doc = "At least 32-bit data frame received"]
pub const ATLEAST32 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Datfmt (pub u8) ; impl Datfmt { # [doc = "The data inside RXDR and TXDR are right aligned"]
pub const RIGHTALIGNED : Self = Self (0) ; # [doc = "The data inside RXDR and TXDR are left aligned"]
pub const LEFTALIGNED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sp (pub u8) ; impl Sp { # [doc = "Motorola SPI protocol"]
pub const MOTOROLA : Self = Self (0) ; # [doc = "TI SPI protocol"]
pub const TI : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rcrcini (pub u8) ; impl Rcrcini { # [doc = "All zeros RX CRC initialization pattern"]
pub const ALLZEROS : Self = Self (0) ; # [doc = "All ones RX CRC initialization pattern"]
pub const ALLONES : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsbfirst (pub u8) ; impl Lsbfirst { # [doc = "Data is transmitted/received with the MSB first"]
pub const MSBFIRST : Self = Self (0) ; # [doc = "Data is transmitted/received with the LSB first"]
pub const LSBFIRST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tcrcini (pub u8) ; impl Tcrcini { # [doc = "All zeros TX CRC initialization pattern"]
pub const ALLZEROS : Self = Self (0) ; # [doc = "All ones TX CRC initialization pattern"]
pub const ALLONES : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpha (pub u8) ; impl Cpha { # [doc = "The first clock transition is the first data capture edge"]
pub const FIRSTEDGE : Self = Self (0) ; # [doc = "The second clock transition is the first data capture edge"]
pub const SECONDEDGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Datlen (pub u8) ; impl Datlen { # [doc = "16 bit data length"]
pub const BITS16 : Self = Self (0) ; # [doc = "24 bit data length"]
pub const BITS24 : Self = Self (0x01) ; # [doc = "32 bit data length"]
pub const BITS32 : Self = Self (0x02) ; } }