

# [doc = "Serial peripheral interface"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Spi (pub * mut u8) ; unsafe impl Send for Spi { } unsafe impl Sync for Spi { } impl Spi { # [doc = "control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "data register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "CRC polynomial register"]
pub fn crcpr (self) -> crate :: common :: Reg < regs :: Crcpr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "RX CRC register"]
pub fn rxcrcr (self) -> crate :: common :: Reg < regs :: Rxcrcr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "TX CRC register"]
pub fn txcrcr (self) -> crate :: common :: Reg < regs :: Txcrcr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "I2S configuration register"]
pub fn i2scfgr (self) -> crate :: common :: Reg < regs :: I2scfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "I2S prescaler register"]
pub fn i2spr (self) -> crate :: common :: Reg < regs :: I2spr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } } pub mod regs { # [doc = "control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "Rx buffer DMA enable"]
pub const fn rxdmaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Rx buffer DMA enable"]
pub fn set_rxdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Tx buffer DMA enable"]
pub const fn txdmaen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Tx buffer DMA enable"]
pub fn set_txdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SS output enable"]
pub const fn ssoe (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "SS output enable"]
pub fn set_ssoe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "NSS pulse management"]
pub const fn nssp (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "NSS pulse management"]
pub fn set_nssp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Frame format"]
pub const fn frf (& self) -> super :: vals :: Frf { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Frf (val as u8) } # [doc = "Frame format"]
pub fn set_frf (& mut self , val : super :: vals :: Frf) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Error interrupt enable"]
pub const fn errie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_errie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "RX buffer not empty interrupt enable"]
pub const fn rxneie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "RX buffer not empty interrupt enable"]
pub fn set_rxneie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Tx buffer empty interrupt enable"]
pub const fn txeie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Tx buffer empty interrupt enable"]
pub fn set_txeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Data size"]
pub const fn ds (& self) -> super :: vals :: Ds { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Ds (val as u8) } # [doc = "Data size"]
pub fn set_ds (& mut self , val : super :: vals :: Ds) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } # [doc = "FIFO reception threshold"]
pub const fn frxth (& self) -> super :: vals :: Frxth { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Frxth (val as u8) } # [doc = "FIFO reception threshold"]
pub fn set_frxth (& mut self , val : super :: vals :: Frxth) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Last DMA transfer for reception"]
pub const fn ldma_rx (& self) -> super :: vals :: LdmaRx { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: LdmaRx (val as u8) } # [doc = "Last DMA transfer for reception"]
pub fn set_ldma_rx (& mut self , val : super :: vals :: LdmaRx) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Last DMA transfer for transmission"]
pub const fn ldma_tx (& self) -> super :: vals :: LdmaTx { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: LdmaTx (val as u8) } # [doc = "Last DMA transfer for transmission"]
pub fn set_ldma_tx (& mut self , val : super :: vals :: LdmaTx) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "I2S configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct I2scfgr (pub u32) ; impl I2scfgr { # [doc = "Channel length (number of bits per audio channel)"]
pub const fn chlen (& self) -> super :: vals :: Chlen { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Chlen (val as u8) } # [doc = "Channel length (number of bits per audio channel)"]
pub fn set_chlen (& mut self , val : super :: vals :: Chlen) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Data length to be transferred"]
pub const fn datlen (& self) -> super :: vals :: Datlen { let val = (self . 0 >> 1usize) & 0x03 ; super :: vals :: Datlen (val as u8) } # [doc = "Data length to be transferred"]
pub fn set_datlen (& mut self , val : super :: vals :: Datlen) { self . 0 = (self . 0 & ! (0x03 << 1usize)) | (((val . 0 as u32) & 0x03) << 1usize) ; } # [doc = "Steady state clock polarity"]
pub const fn ckpol (& self) -> super :: vals :: Ckpol { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Ckpol (val as u8) } # [doc = "Steady state clock polarity"]
pub fn set_ckpol (& mut self , val : super :: vals :: Ckpol) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "I2S standard selection"]
pub const fn i2sstd (& self) -> super :: vals :: Isstd { let val = (self . 0 >> 4usize) & 0x03 ; super :: vals :: Isstd (val as u8) } # [doc = "I2S standard selection"]
pub fn set_i2sstd (& mut self , val : super :: vals :: Isstd) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val . 0 as u32) & 0x03) << 4usize) ; } # [doc = "PCM frame synchronization"]
pub const fn pcmsync (& self) -> super :: vals :: Pcmsync { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Pcmsync (val as u8) } # [doc = "PCM frame synchronization"]
pub fn set_pcmsync (& mut self , val : super :: vals :: Pcmsync) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "I2S configuration mode"]
pub const fn i2scfg (& self) -> super :: vals :: Iscfg { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Iscfg (val as u8) } # [doc = "I2S configuration mode"]
pub fn set_i2scfg (& mut self , val : super :: vals :: Iscfg) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "I2S Enable"]
pub const fn i2se (& self) -> super :: vals :: Ise { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Ise (val as u8) } # [doc = "I2S Enable"]
pub fn set_i2se (& mut self , val : super :: vals :: Ise) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "I2S mode selection"]
pub const fn i2smod (& self) -> super :: vals :: Ismod { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Ismod (val as u8) } # [doc = "I2S mode selection"]
pub fn set_i2smod (& mut self , val : super :: vals :: Ismod) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Asynchronous start enable"]
pub const fn astrten (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Asynchronous start enable"]
pub fn set_astrten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for I2scfgr { fn default () -> I2scfgr { I2scfgr (0) } } # [doc = "control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Clock phase"]
pub const fn cpha (& self) -> super :: vals :: Cpha { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Cpha (val as u8) } # [doc = "Clock phase"]
pub fn set_cpha (& mut self , val : super :: vals :: Cpha) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Clock polarity"]
pub const fn cpol (& self) -> super :: vals :: Cpol { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Cpol (val as u8) } # [doc = "Clock polarity"]
pub fn set_cpol (& mut self , val : super :: vals :: Cpol) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Master selection"]
pub const fn mstr (& self) -> super :: vals :: Mstr { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Mstr (val as u8) } # [doc = "Master selection"]
pub fn set_mstr (& mut self , val : super :: vals :: Mstr) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Baud rate control"]
pub const fn br (& self) -> super :: vals :: Br { let val = (self . 0 >> 3usize) & 0x07 ; super :: vals :: Br (val as u8) } # [doc = "Baud rate control"]
pub fn set_br (& mut self , val : super :: vals :: Br) { self . 0 = (self . 0 & ! (0x07 << 3usize)) | (((val . 0 as u32) & 0x07) << 3usize) ; } # [doc = "SPI enable"]
pub const fn spe (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "SPI enable"]
pub fn set_spe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Frame format"]
pub const fn lsbfirst (& self) -> super :: vals :: Lsbfirst { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Lsbfirst (val as u8) } # [doc = "Frame format"]
pub fn set_lsbfirst (& mut self , val : super :: vals :: Lsbfirst) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Internal slave select"]
pub const fn ssi (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Internal slave select"]
pub fn set_ssi (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Software slave management"]
pub const fn ssm (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Software slave management"]
pub fn set_ssm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Receive only"]
pub const fn rxonly (& self) -> super :: vals :: Rxonly { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Rxonly (val as u8) } # [doc = "Receive only"]
pub fn set_rxonly (& mut self , val : super :: vals :: Rxonly) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "CRC length"]
pub const fn crcl (& self) -> super :: vals :: Crcl { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Crcl (val as u8) } # [doc = "CRC length"]
pub fn set_crcl (& mut self , val : super :: vals :: Crcl) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "CRC transfer next"]
pub const fn crcnext (& self) -> super :: vals :: Crcnext { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Crcnext (val as u8) } # [doc = "CRC transfer next"]
pub fn set_crcnext (& mut self , val : super :: vals :: Crcnext) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Hardware CRC calculation enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Hardware CRC calculation enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Output enable in bidirectional mode"]
pub const fn bidioe (& self) -> super :: vals :: Bidioe { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Bidioe (val as u8) } # [doc = "Output enable in bidirectional mode"]
pub fn set_bidioe (& mut self , val : super :: vals :: Bidioe) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Bidirectional data mode enable"]
pub const fn bidimode (& self) -> super :: vals :: Bidimode { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Bidimode (val as u8) } # [doc = "Bidirectional data mode enable"]
pub fn set_bidimode (& mut self , val : super :: vals :: Bidimode) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "CRC polynomial register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crcpr (pub u32) ; impl Crcpr { # [doc = "CRC polynomial register"]
pub const fn crcpoly (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "CRC polynomial register"]
pub fn set_crcpoly (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Crcpr { fn default () -> Crcpr { Crcpr (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Receive buffer not empty"]
pub const fn rxne (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Receive buffer not empty"]
pub fn set_rxne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Transmit buffer empty"]
pub const fn txe (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Transmit buffer empty"]
pub fn set_txe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Channel side"]
pub const fn chside (& self) -> super :: vals :: Chside { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Chside (val as u8) } # [doc = "Channel side"]
pub fn set_chside (& mut self , val : super :: vals :: Chside) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Underrun flag"]
pub const fn udr (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Underrun flag"]
pub fn set_udr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CRC error flag"]
pub const fn crcerr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CRC error flag"]
pub fn set_crcerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Mode fault"]
pub const fn modf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Mode fault"]
pub fn set_modf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Overrun flag"]
pub const fn ovr (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Overrun flag"]
pub fn set_ovr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Busy flag"]
pub const fn bsy (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Busy flag"]
pub fn set_bsy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "frame format error"]
pub const fn fre (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "frame format error"]
pub fn set_fre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "FIFO reception level"]
pub const fn frlvl (& self) -> u8 { let val = (self . 0 >> 9usize) & 0x03 ; val as u8 } # [doc = "FIFO reception level"]
pub fn set_frlvl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 9usize)) | (((val as u32) & 0x03) << 9usize) ; } # [doc = "FIFO Transmission Level"]
pub const fn ftlvl (& self) -> u8 { let val = (self . 0 >> 11usize) & 0x03 ; val as u8 } # [doc = "FIFO Transmission Level"]
pub fn set_ftlvl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 11usize)) | (((val as u32) & 0x03) << 11usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "TX CRC register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Txcrcr (pub u32) ; impl Txcrcr { # [doc = "Tx CRC register"]
pub const fn tx_crc (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Tx CRC register"]
pub fn set_tx_crc (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Txcrcr { fn default () -> Txcrcr { Txcrcr (0) } } # [doc = "data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Data register"]
pub const fn dr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Data register"]
pub fn set_dr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "I2S prescaler register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct I2spr (pub u32) ; impl I2spr { # [doc = "I2S Linear prescaler"]
pub const fn i2sdiv (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "I2S Linear prescaler"]
pub fn set_i2sdiv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Odd factor for the prescaler"]
pub const fn odd (& self) -> super :: vals :: Odd { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Odd (val as u8) } # [doc = "Odd factor for the prescaler"]
pub fn set_odd (& mut self , val : super :: vals :: Odd) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Master clock output enable"]
pub const fn mckoe (& self) -> super :: vals :: Mckoe { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Mckoe (val as u8) } # [doc = "Master clock output enable"]
pub fn set_mckoe (& mut self , val : super :: vals :: Mckoe) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } } impl Default for I2spr { fn default () -> I2spr { I2spr (0) } } # [doc = "RX CRC register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rxcrcr (pub u32) ; impl Rxcrcr { # [doc = "Rx CRC register"]
pub const fn rx_crc (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Rx CRC register"]
pub fn set_rx_crc (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Rxcrcr { fn default () -> Rxcrcr { Rxcrcr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpol (pub u8) ; impl Cpol { # [doc = "CK to 0 when idle"]
pub const IDLELOW : Self = Self (0) ; # [doc = "CK to 1 when idle"]
pub const IDLEHIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Iscfg (pub u8) ; impl Iscfg { # [doc = "Slave - transmit"]
pub const SLAVETX : Self = Self (0) ; # [doc = "Slave - receive"]
pub const SLAVERX : Self = Self (0x01) ; # [doc = "Master - transmit"]
pub const MASTERTX : Self = Self (0x02) ; # [doc = "Master - receive"]
pub const MASTERRX : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct LdmaRx (pub u8) ; impl LdmaRx { # [doc = "Number of data to transfer for receive is even"]
pub const EVEN : Self = Self (0) ; # [doc = "Number of data to transfer for receive is odd"]
pub const ODD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Frlvlr (pub u8) ; impl Frlvlr { # [doc = "Rx FIFO Empty"]
pub const EMPTY : Self = Self (0) ; # [doc = "Rx 1/4 FIFO"]
pub const QUARTER : Self = Self (0x01) ; # [doc = "Rx 1/2 FIFO"]
pub const HALF : Self = Self (0x02) ; # [doc = "Rx FIFO full"]
pub const FULL : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ftlvlr (pub u8) ; impl Ftlvlr { # [doc = "Tx FIFO Empty"]
pub const EMPTY : Self = Self (0) ; # [doc = "Tx 1/4 FIFO"]
pub const QUARTER : Self = Self (0x01) ; # [doc = "Tx 1/2 FIFO"]
pub const HALF : Self = Self (0x02) ; # [doc = "Tx FIFO full"]
pub const FULL : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ovrr (pub u8) ; impl Ovrr { # [doc = "No overrun occurred"]
pub const NOOVERRUN : Self = Self (0) ; # [doc = "Overrun occurred"]
pub const OVERRUN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pcmsync (pub u8) ; impl Pcmsync { # [doc = "Short frame synchronisation"]
pub const SHORT : Self = Self (0) ; # [doc = "Long frame synchronisation"]
pub const LONG : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Frf (pub u8) ; impl Frf { # [doc = "SPI Motorola mode"]
pub const MOTOROLA : Self = Self (0) ; # [doc = "SPI TI mode"]
pub const TI : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ise (pub u8) ; impl Ise { # [doc = "I2S peripheral is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "I2S peripheral is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct LdmaTx (pub u8) ; impl LdmaTx { # [doc = "Number of data to transfer for transmit is even"]
pub const EVEN : Self = Self (0) ; # [doc = "Number of data to transfer for transmit is odd"]
pub const ODD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpha (pub u8) ; impl Cpha { # [doc = "The first clock transition is the first data capture edge"]
pub const FIRSTEDGE : Self = Self (0) ; # [doc = "The second clock transition is the first data capture edge"]
pub const SECONDEDGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mstr (pub u8) ; impl Mstr { # [doc = "Slave configuration"]
pub const SLAVE : Self = Self (0) ; # [doc = "Master configuration"]
pub const MASTER : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Udrr (pub u8) ; impl Udrr { # [doc = "No underrun occurred"]
pub const NOUNDERRUN : Self = Self (0) ; # [doc = "Underrun occurred"]
pub const UNDERRUN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsbfirst (pub u8) ; impl Lsbfirst { # [doc = "Data is transmitted/received with the MSB first"]
pub const MSBFIRST : Self = Self (0) ; # [doc = "Data is transmitted/received with the LSB first"]
pub const LSBFIRST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Frer (pub u8) ; impl Frer { # [doc = "No frame format error"]
pub const NOERROR : Self = Self (0) ; # [doc = "A frame format error occurred"]
pub const ERROR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bidioe (pub u8) ; impl Bidioe { # [doc = "Output disabled (receive-only mode)"]
pub const OUTPUTDISABLED : Self = Self (0) ; # [doc = "Output enabled (transmit-only mode)"]
pub const OUTPUTENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bidimode (pub u8) ; impl Bidimode { # [doc = "2-line unidirectional data mode selected"]
pub const UNIDIRECTIONAL : Self = Self (0) ; # [doc = "1-line bidirectional data mode selected"]
pub const BIDIRECTIONAL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Datlen (pub u8) ; impl Datlen { # [doc = "16-bit data length"]
pub const SIXTEENBIT : Self = Self (0) ; # [doc = "24-bit data length"]
pub const TWENTYFOURBIT : Self = Self (0x01) ; # [doc = "32-bit data length"]
pub const THIRTYTWOBIT : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Odd (pub u8) ; impl Odd { # [doc = "Real divider value is I2SDIV * 2"]
pub const EVEN : Self = Self (0) ; # [doc = "Real divider value is (I2SDIV * 2) + 1"]
pub const ODD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Crcnext (pub u8) ; impl Crcnext { # [doc = "Next transmit value is from Tx buffer"]
pub const TXBUFFER : Self = Self (0) ; # [doc = "Next transmit value is from Tx CRC register"]
pub const CRC : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Frxth (pub u8) ; impl Frxth { # [doc = "RXNE event is generated if the FIFO level is greater than or equal to 1/2 (16-bit)"]
pub const HALF : Self = Self (0) ; # [doc = "RXNE event is generated if the FIFO level is greater than or equal to 1/4 (8-bit)"]
pub const QUARTER : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Crcl (pub u8) ; impl Crcl { # [doc = "8-bit CRC length"]
pub const EIGHTBIT : Self = Self (0) ; # [doc = "16-bit CRC length"]
pub const SIXTEENBIT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mckoe (pub u8) ; impl Mckoe { # [doc = "Master clock output is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Master clock output is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Isstd (pub u8) ; impl Isstd { # [doc = "I2S Philips standard"]
pub const PHILIPS : Self = Self (0) ; # [doc = "MSB justified standard"]
pub const MSB : Self = Self (0x01) ; # [doc = "LSB justified standard"]
pub const LSB : Self = Self (0x02) ; # [doc = "PCM standard"]
pub const PCM : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ckpol (pub u8) ; impl Ckpol { # [doc = "I2S clock inactive state is low level"]
pub const IDLELOW : Self = Self (0) ; # [doc = "I2S clock inactive state is high level"]
pub const IDLEHIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Chlen (pub u8) ; impl Chlen { # [doc = "16-bit wide"]
pub const SIXTEENBIT : Self = Self (0) ; # [doc = "32-bit wide"]
pub const THIRTYTWOBIT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ds (pub u8) ; impl Ds { # [doc = "4-bit"]
pub const FOURBIT : Self = Self (0x03) ; # [doc = "5-bit"]
pub const FIVEBIT : Self = Self (0x04) ; # [doc = "6-bit"]
pub const SIXBIT : Self = Self (0x05) ; # [doc = "7-bit"]
pub const SEVENBIT : Self = Self (0x06) ; # [doc = "8-bit"]
pub const EIGHTBIT : Self = Self (0x07) ; # [doc = "9-bit"]
pub const NINEBIT : Self = Self (0x08) ; # [doc = "10-bit"]
pub const TENBIT : Self = Self (0x09) ; # [doc = "11-bit"]
pub const ELEVENBIT : Self = Self (0x0a) ; # [doc = "12-bit"]
pub const TWELVEBIT : Self = Self (0x0b) ; # [doc = "13-bit"]
pub const THIRTEENBIT : Self = Self (0x0c) ; # [doc = "14-bit"]
pub const FOURTEENBIT : Self = Self (0x0d) ; # [doc = "15-bit"]
pub const FIFTEENBIT : Self = Self (0x0e) ; # [doc = "16-bit"]
pub const SIXTEENBIT : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Br (pub u8) ; impl Br { # [doc = "f_PCLK / 2"]
pub const DIV2 : Self = Self (0) ; # [doc = "f_PCLK / 4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "f_PCLK / 8"]
pub const DIV8 : Self = Self (0x02) ; # [doc = "f_PCLK / 16"]
pub const DIV16 : Self = Self (0x03) ; # [doc = "f_PCLK / 32"]
pub const DIV32 : Self = Self (0x04) ; # [doc = "f_PCLK / 64"]
pub const DIV64 : Self = Self (0x05) ; # [doc = "f_PCLK / 128"]
pub const DIV128 : Self = Self (0x06) ; # [doc = "f_PCLK / 256"]
pub const DIV256 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ismod (pub u8) ; impl Ismod { # [doc = "SPI mode is selected"]
pub const SPIMODE : Self = Self (0) ; # [doc = "I2S mode is selected"]
pub const I2SMODE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Chside (pub u8) ; impl Chside { # [doc = "Channel left has to be transmitted or has been received"]
pub const LEFT : Self = Self (0) ; # [doc = "Channel right has to be transmitted or has been received"]
pub const RIGHT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rxonly (pub u8) ; impl Rxonly { # [doc = "Full duplex (Transmit and receive)"]
pub const FULLDUPLEX : Self = Self (0) ; # [doc = "Output disabled (Receive-only mode)"]
pub const OUTPUTDISABLED : Self = Self (0x01) ; } }