

# [doc = "Receiver Interface"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Spdifrx (pub * mut u8) ; unsafe impl Send for Spdifrx { } unsafe impl Sync for Spdifrx { } impl Spdifrx { # [doc = "Control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Interrupt mask register"]
pub fn imr (self) -> crate :: common :: Reg < regs :: Imr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Interrupt Flag Clear register"]
pub fn ifcr (self) -> crate :: common :: Reg < regs :: Ifcr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Data input register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Channel Status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Debug Information register"]
pub fn dir (self) -> crate :: common :: Reg < regs :: Dir , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } } pub mod regs { # [doc = "Data input register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Parity Error bit"]
pub const fn dr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x00ff_ffff ; val as u32 } # [doc = "Parity Error bit"]
pub fn set_dr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x00ff_ffff << 0usize)) | (((val as u32) & 0x00ff_ffff) << 0usize) ; } # [doc = "Parity Error bit"]
pub const fn pe (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Parity Error bit"]
pub fn set_pe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Validity bit"]
pub const fn v (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Validity bit"]
pub fn set_v (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "User bit"]
pub const fn u (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "User bit"]
pub fn set_u (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Channel Status bit"]
pub const fn c (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Channel Status bit"]
pub fn set_c (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Preamble Type"]
pub const fn pt (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "Preamble Type"]
pub fn set_pt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "Control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Peripheral Block Enable"]
pub const fn spdifen (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Peripheral Block Enable"]
pub fn set_spdifen (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Receiver DMA ENable for data flow"]
pub const fn rxdmaen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Receiver DMA ENable for data flow"]
pub fn set_rxdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "STerEO Mode"]
pub const fn rxsteo (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "STerEO Mode"]
pub fn set_rxsteo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "RX Data format"]
pub const fn drfmt (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "RX Data format"]
pub fn set_drfmt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "Mask Parity error bit"]
pub const fn pmsk (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Mask Parity error bit"]
pub fn set_pmsk (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Mask of Validity bit"]
pub const fn vmsk (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Mask of Validity bit"]
pub fn set_vmsk (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Mask of channel status and user bits"]
pub const fn cumsk (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Mask of channel status and user bits"]
pub fn set_cumsk (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Mask of Preamble Type bits"]
pub const fn ptmsk (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Mask of Preamble Type bits"]
pub fn set_ptmsk (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Control Buffer DMA ENable for control flow"]
pub const fn cbdmaen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Control Buffer DMA ENable for control flow"]
pub fn set_cbdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Channel Selection"]
pub const fn chsel (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Channel Selection"]
pub fn set_chsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Maximum allowed re-tries during synchronization phase"]
pub const fn nbtr (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x03 ; val as u8 } # [doc = "Maximum allowed re-tries during synchronization phase"]
pub fn set_nbtr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val as u32) & 0x03) << 12usize) ; } # [doc = "Wait For Activity"]
pub const fn wfa (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Wait For Activity"]
pub fn set_wfa (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "input selection"]
pub const fn insel (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x07 ; val as u8 } # [doc = "input selection"]
pub fn set_insel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 16usize)) | (((val as u32) & 0x07) << 16usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Interrupt Flag Clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ifcr (pub u32) ; impl Ifcr { # [doc = "Clears the Parity error flag"]
pub const fn perrcf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Clears the Parity error flag"]
pub fn set_perrcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Clears the Overrun error flag"]
pub const fn ovrcf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Clears the Overrun error flag"]
pub fn set_ovrcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Clears the Synchronization Block Detected flag"]
pub const fn sbdcf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Clears the Synchronization Block Detected flag"]
pub fn set_sbdcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Clears the Synchronization Done flag"]
pub const fn syncdcf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Clears the Synchronization Done flag"]
pub fn set_syncdcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Ifcr { fn default () -> Ifcr { Ifcr (0) } } # [doc = "Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Read data register not empty"]
pub const fn rxne (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Read data register not empty"]
pub fn set_rxne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Control Buffer register is not empty"]
pub const fn csrne (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Control Buffer register is not empty"]
pub fn set_csrne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Parity error"]
pub const fn perr (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Parity error"]
pub fn set_perr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Overrun error"]
pub const fn ovr (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Overrun error"]
pub fn set_ovr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Synchronization Block Detected"]
pub const fn sbd (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Synchronization Block Detected"]
pub fn set_sbd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Synchronization Done"]
pub const fn syncd (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Synchronization Done"]
pub fn set_syncd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Framing error"]
pub const fn ferr (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Framing error"]
pub fn set_ferr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Synchronization error"]
pub const fn serr (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Synchronization error"]
pub fn set_serr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Time-out error"]
pub const fn terr (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Time-out error"]
pub fn set_terr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Duration of 5 symbols counted with SPDIF_CLK"]
pub fn width (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 16usize + n * 0usize ; let val = (self . 0 >> offs) & 0x7fff ; val as u16 } # [doc = "Duration of 5 symbols counted with SPDIF_CLK"]
pub fn set_width (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 16usize + n * 0usize ; self . 0 = (self . 0 & ! (0x7fff << offs)) | (((val as u32) & 0x7fff) << offs) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "Debug Information register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dir (pub u32) ; impl Dir { # [doc = "Threshold HIGH"]
pub const fn thi (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x1fff ; val as u16 } # [doc = "Threshold HIGH"]
pub fn set_thi (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 0usize)) | (((val as u32) & 0x1fff) << 0usize) ; } # [doc = "Threshold LOW"]
pub const fn tlo (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x1fff ; val as u16 } # [doc = "Threshold LOW"]
pub fn set_tlo (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 16usize)) | (((val as u32) & 0x1fff) << 16usize) ; } } impl Default for Dir { fn default () -> Dir { Dir (0) } } # [doc = "Channel Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "User data information"]
pub const fn usr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "User data information"]
pub fn set_usr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Channel A status information"]
pub const fn cs (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Channel A status information"]
pub fn set_cs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Start Of Block"]
pub const fn sob (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Start Of Block"]
pub fn set_sob (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "Interrupt mask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Imr (pub u32) ; impl Imr { # [doc = "RXNE interrupt enable"]
pub const fn rxneie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "RXNE interrupt enable"]
pub fn set_rxneie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Control Buffer Ready Interrupt Enable"]
pub const fn csrneie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Control Buffer Ready Interrupt Enable"]
pub fn set_csrneie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Parity error interrupt enable"]
pub const fn perrie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Parity error interrupt enable"]
pub fn set_perrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Overrun error Interrupt Enable"]
pub const fn ovrie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Overrun error Interrupt Enable"]
pub fn set_ovrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Synchronization Block Detected Interrupt Enable"]
pub const fn sblkie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Synchronization Block Detected Interrupt Enable"]
pub fn set_sblkie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Synchronization Done"]
pub const fn syncdie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Synchronization Done"]
pub fn set_syncdie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Serial Interface Error Interrupt Enable"]
pub const fn ifeie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Serial Interface Error Interrupt Enable"]
pub fn set_ifeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Imr { fn default () -> Imr { Imr (0) } } }