

# [doc = "Secure digital input/output interface"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sdmmc (pub * mut u8) ; unsafe impl Send for Sdmmc { } unsafe impl Sync for Sdmmc { } impl Sdmmc { # [doc = "power control register"]
pub fn power (self) -> crate :: common :: Reg < regs :: Power , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "SDI clock control register"]
pub fn clkcr (self) -> crate :: common :: Reg < regs :: Clkcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "argument register"]
pub fn arg (self) -> crate :: common :: Reg < regs :: Arg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "command register"]
pub fn cmd (self) -> crate :: common :: Reg < regs :: Cmd , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "command response register"]
pub fn respcmd (self) -> crate :: common :: Reg < regs :: Respcmd , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "response 1..4 register"]
pub fn resp1 (self) -> crate :: common :: Reg < regs :: Resp1 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "response 1..4 register"]
pub fn resp2 (self) -> crate :: common :: Reg < regs :: Resp2 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "response 1..4 register"]
pub fn resp3 (self) -> crate :: common :: Reg < regs :: Resp3 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "response 1..4 register"]
pub fn resp4 (self) -> crate :: common :: Reg < regs :: Resp4 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "data timer register"]
pub fn dtimer (self) -> crate :: common :: Reg < regs :: Dtimer , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "data length register"]
pub fn dlen (self) -> crate :: common :: Reg < regs :: Dlen , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "data control register"]
pub fn dctrl (self) -> crate :: common :: Reg < regs :: Dctrl , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "data counter register"]
pub fn dcount (self) -> crate :: common :: Reg < regs :: Dcount , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "status register"]
pub fn sta (self) -> crate :: common :: Reg < regs :: Sta , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "interrupt clear register"]
pub fn icr (self) -> crate :: common :: Reg < regs :: Icr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "mask register"]
pub fn mask (self) -> crate :: common :: Reg < regs :: Mask , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "FIFO counter register"]
pub fn fifocnt (self) -> crate :: common :: Reg < regs :: Fifocnt , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "data FIFO register"]
pub fn fifo (self) -> crate :: common :: Reg < regs :: Fifo , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } } pub mod regs { # [doc = "mask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mask (pub u32) ; impl Mask { # [doc = "Command CRC fail interrupt enable"]
pub const fn ccrcfailie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Command CRC fail interrupt enable"]
pub fn set_ccrcfailie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Data CRC fail interrupt enable"]
pub const fn dcrcfailie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Data CRC fail interrupt enable"]
pub fn set_dcrcfailie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Command timeout interrupt enable"]
pub const fn ctimeoutie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Command timeout interrupt enable"]
pub fn set_ctimeoutie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Data timeout interrupt enable"]
pub const fn dtimeoutie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Data timeout interrupt enable"]
pub fn set_dtimeoutie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Tx FIFO underrun error interrupt enable"]
pub const fn txunderrie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Tx FIFO underrun error interrupt enable"]
pub fn set_txunderrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Rx FIFO overrun error interrupt enable"]
pub const fn rxoverrie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Rx FIFO overrun error interrupt enable"]
pub fn set_rxoverrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Command response received interrupt enable"]
pub const fn cmdrendie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Command response received interrupt enable"]
pub fn set_cmdrendie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Command sent interrupt enable"]
pub const fn cmdsentie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Command sent interrupt enable"]
pub fn set_cmdsentie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Data end interrupt enable"]
pub const fn dataendie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Data end interrupt enable"]
pub fn set_dataendie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Data block end interrupt enable"]
pub const fn dbckendie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Data block end interrupt enable"]
pub fn set_dbckendie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Command acting interrupt enable"]
pub const fn cmdactie (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Command acting interrupt enable"]
pub fn set_cmdactie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Data transmit acting interrupt enable"]
pub const fn txactie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Data transmit acting interrupt enable"]
pub fn set_txactie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Data receive acting interrupt enable"]
pub const fn rxactie (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Data receive acting interrupt enable"]
pub fn set_rxactie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Tx FIFO half empty interrupt enable"]
pub const fn txfifoheie (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Tx FIFO half empty interrupt enable"]
pub fn set_txfifoheie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Rx FIFO half full interrupt enable"]
pub const fn rxfifohfie (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Rx FIFO half full interrupt enable"]
pub fn set_rxfifohfie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Tx FIFO full interrupt enable"]
pub const fn txfifofie (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Tx FIFO full interrupt enable"]
pub fn set_txfifofie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Rx FIFO full interrupt enable"]
pub const fn rxfifofie (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Rx FIFO full interrupt enable"]
pub fn set_rxfifofie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Tx FIFO empty interrupt enable"]
pub const fn txfifoeie (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Tx FIFO empty interrupt enable"]
pub fn set_txfifoeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Rx FIFO empty interrupt enable"]
pub const fn rxfifoeie (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Rx FIFO empty interrupt enable"]
pub fn set_rxfifoeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Data available in Tx FIFO interrupt enable"]
pub const fn txdavlie (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Data available in Tx FIFO interrupt enable"]
pub fn set_txdavlie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Data available in Rx FIFO interrupt enable"]
pub const fn rxdavlie (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Data available in Rx FIFO interrupt enable"]
pub fn set_rxdavlie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SDIO mode interrupt received interrupt enable"]
pub const fn sdioitie (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SDIO mode interrupt received interrupt enable"]
pub fn set_sdioitie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Mask { fn default () -> Mask { Mask (0) } } # [doc = "data timer register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dtimer (pub u32) ; impl Dtimer { # [doc = "Data timeout period"]
pub const fn datatime (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Data timeout period"]
pub fn set_datatime (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dtimer { fn default () -> Dtimer { Dtimer (0) } } # [doc = "data control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dctrl (pub u32) ; impl Dctrl { # [doc = "DTEN"]
pub const fn dten (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DTEN"]
pub fn set_dten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Data transfer direction selection"]
pub const fn dtdir (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Data transfer direction selection"]
pub fn set_dtdir (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Data transfer mode selection 1: Stream or SDIO multibyte data transfer"]
pub const fn dtmode (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Data transfer mode selection 1: Stream or SDIO multibyte data transfer"]
pub fn set_dtmode (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "DMA enable bit"]
pub const fn dmaen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "DMA enable bit"]
pub fn set_dmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Data block size"]
pub const fn dblocksize (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "Data block size"]
pub fn set_dblocksize (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "Read wait start"]
pub const fn rwstart (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Read wait start"]
pub fn set_rwstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Read wait stop"]
pub const fn rwstop (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Read wait stop"]
pub fn set_rwstop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Read wait mode"]
pub const fn rwmod (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Read wait mode"]
pub fn set_rwmod (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SD I/O enable functions"]
pub const fn sdioen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SD I/O enable functions"]
pub fn set_sdioen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Dctrl { fn default () -> Dctrl { Dctrl (0) } } # [doc = "argument register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Arg (pub u32) ; impl Arg { # [doc = "Command argument"]
pub const fn cmdarg (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Command argument"]
pub fn set_cmdarg (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Arg { fn default () -> Arg { Arg (0) } } # [doc = "data counter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dcount (pub u32) ; impl Dcount { # [doc = "Data count value"]
pub const fn datacount (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x01ff_ffff ; val as u32 } # [doc = "Data count value"]
pub fn set_datacount (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x01ff_ffff << 0usize)) | (((val as u32) & 0x01ff_ffff) << 0usize) ; } } impl Default for Dcount { fn default () -> Dcount { Dcount (0) } } # [doc = "response 1..4 register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Resp3 (pub u32) ; impl Resp3 { # [doc = "see Table 132"]
pub fn cardstatus (& self , n : usize) -> u32 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xffff_ffff ; val as u32 } # [doc = "see Table 132"]
pub fn set_cardstatus (& mut self , n : usize , val : u32) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xffff_ffff << offs)) | (((val as u32) & 0xffff_ffff) << offs) ; } } impl Default for Resp3 { fn default () -> Resp3 { Resp3 (0) } } # [doc = "command register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cmd (pub u32) ; impl Cmd { # [doc = "Command index"]
pub const fn cmdindex (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Command index"]
pub fn set_cmdindex (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } # [doc = "Wait for response bits"]
pub const fn waitresp (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x03 ; val as u8 } # [doc = "Wait for response bits"]
pub fn set_waitresp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val as u32) & 0x03) << 6usize) ; } # [doc = "CPSM waits for interrupt request"]
pub const fn waitint (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "CPSM waits for interrupt request"]
pub fn set_waitint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CPSM Waits for ends of data transfer (CmdPend internal signal)"]
pub const fn waitpend (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CPSM Waits for ends of data transfer (CmdPend internal signal)"]
pub fn set_waitpend (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Command path state machine (CPSM) Enable bit"]
pub const fn cpsmen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Command path state machine (CPSM) Enable bit"]
pub fn set_cpsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SD I/O suspend command"]
pub const fn sdiosuspend (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SD I/O suspend command"]
pub fn set_sdiosuspend (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Cmd { fn default () -> Cmd { Cmd (0) } } # [doc = "FIFO counter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fifocnt (pub u32) ; impl Fifocnt { # [doc = "Remaining number of words to be written to or read from the FIFO"]
pub const fn fifocount (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x00ff_ffff ; val as u32 } # [doc = "Remaining number of words to be written to or read from the FIFO"]
pub fn set_fifocount (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x00ff_ffff << 0usize)) | (((val as u32) & 0x00ff_ffff) << 0usize) ; } } impl Default for Fifocnt { fn default () -> Fifocnt { Fifocnt (0) } } # [doc = "response 1..4 register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Resp4 (pub u32) ; impl Resp4 { # [doc = "see Table 132"]
pub fn cardstatus (& self , n : usize) -> u32 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xffff_ffff ; val as u32 } # [doc = "see Table 132"]
pub fn set_cardstatus (& mut self , n : usize , val : u32) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xffff_ffff << offs)) | (((val as u32) & 0xffff_ffff) << offs) ; } } impl Default for Resp4 { fn default () -> Resp4 { Resp4 (0) } } # [doc = "response 1..4 register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Resp1 (pub u32) ; impl Resp1 { # [doc = "see Table 132"]
pub fn cardstatus (& self , n : usize) -> u32 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xffff_ffff ; val as u32 } # [doc = "see Table 132"]
pub fn set_cardstatus (& mut self , n : usize , val : u32) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xffff_ffff << offs)) | (((val as u32) & 0xffff_ffff) << offs) ; } } impl Default for Resp1 { fn default () -> Resp1 { Resp1 (0) } } # [doc = "SDI clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Clkcr (pub u32) ; impl Clkcr { # [doc = "Clock divide factor"]
pub const fn clkdiv (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Clock divide factor"]
pub fn set_clkdiv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Clock enable bit"]
pub const fn clken (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Clock enable bit"]
pub fn set_clken (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Power saving configuration bit"]
pub const fn pwrsav (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Power saving configuration bit"]
pub fn set_pwrsav (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Clock divider bypass enable bit"]
pub const fn bypass (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Clock divider bypass enable bit"]
pub fn set_bypass (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Wide bus mode enable bit"]
pub const fn widbus (& self) -> u8 { let val = (self . 0 >> 11usize) & 0x03 ; val as u8 } # [doc = "Wide bus mode enable bit"]
pub fn set_widbus (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 11usize)) | (((val as u32) & 0x03) << 11usize) ; } # [doc = "SDIO_CK dephasing selection bit"]
pub const fn negedge (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SDIO_CK dephasing selection bit"]
pub fn set_negedge (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "HW Flow Control enable"]
pub const fn hwfc_en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "HW Flow Control enable"]
pub fn set_hwfc_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for Clkcr { fn default () -> Clkcr { Clkcr (0) } } # [doc = "response 1..4 register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Resp2 (pub u32) ; impl Resp2 { # [doc = "see Table 132"]
pub fn cardstatus (& self , n : usize) -> u32 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xffff_ffff ; val as u32 } # [doc = "see Table 132"]
pub fn set_cardstatus (& mut self , n : usize , val : u32) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xffff_ffff << offs)) | (((val as u32) & 0xffff_ffff) << offs) ; } } impl Default for Resp2 { fn default () -> Resp2 { Resp2 (0) } } # [doc = "interrupt clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icr (pub u32) ; impl Icr { # [doc = "CCRCFAIL flag clear bit"]
pub const fn ccrcfailc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CCRCFAIL flag clear bit"]
pub fn set_ccrcfailc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DCRCFAIL flag clear bit"]
pub const fn dcrcfailc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DCRCFAIL flag clear bit"]
pub fn set_dcrcfailc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CTIMEOUT flag clear bit"]
pub const fn ctimeoutc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CTIMEOUT flag clear bit"]
pub fn set_ctimeoutc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "DTIMEOUT flag clear bit"]
pub const fn dtimeoutc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "DTIMEOUT flag clear bit"]
pub fn set_dtimeoutc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TXUNDERR flag clear bit"]
pub const fn txunderrc (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TXUNDERR flag clear bit"]
pub fn set_txunderrc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RXOVERR flag clear bit"]
pub const fn rxoverrc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RXOVERR flag clear bit"]
pub fn set_rxoverrc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CMDREND flag clear bit"]
pub const fn cmdrendc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CMDREND flag clear bit"]
pub fn set_cmdrendc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "CMDSENT flag clear bit"]
pub const fn cmdsentc (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CMDSENT flag clear bit"]
pub fn set_cmdsentc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "DATAEND flag clear bit"]
pub const fn dataendc (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "DATAEND flag clear bit"]
pub fn set_dataendc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "DBCKEND flag clear bit"]
pub const fn dbckendc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "DBCKEND flag clear bit"]
pub fn set_dbckendc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SDIOIT flag clear bit"]
pub const fn sdioitc (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SDIOIT flag clear bit"]
pub fn set_sdioitc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Icr { fn default () -> Icr { Icr (0) } } # [doc = "data length register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dlen (pub u32) ; impl Dlen { # [doc = "Data length value"]
pub const fn datalength (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x01ff_ffff ; val as u32 } # [doc = "Data length value"]
pub fn set_datalength (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x01ff_ffff << 0usize)) | (((val as u32) & 0x01ff_ffff) << 0usize) ; } } impl Default for Dlen { fn default () -> Dlen { Dlen (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sta (pub u32) ; impl Sta { # [doc = "Command response received (CRC check failed)"]
pub const fn ccrcfail (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Command response received (CRC check failed)"]
pub fn set_ccrcfail (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Data block sent/received (CRC check failed)"]
pub const fn dcrcfail (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Data block sent/received (CRC check failed)"]
pub fn set_dcrcfail (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Command response timeout"]
pub const fn ctimeout (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Command response timeout"]
pub fn set_ctimeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Data timeout"]
pub const fn dtimeout (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Data timeout"]
pub fn set_dtimeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Transmit FIFO underrun error"]
pub const fn txunderr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Transmit FIFO underrun error"]
pub fn set_txunderr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Received FIFO overrun error"]
pub const fn rxoverr (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Received FIFO overrun error"]
pub fn set_rxoverr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Command response received (CRC check passed)"]
pub const fn cmdrend (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Command response received (CRC check passed)"]
pub fn set_cmdrend (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Command sent (no response required)"]
pub const fn cmdsent (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Command sent (no response required)"]
pub fn set_cmdsent (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Data end (data counter, SDIDCOUNT, is zero)"]
pub const fn dataend (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Data end (data counter, SDIDCOUNT, is zero)"]
pub fn set_dataend (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Data block sent/received (CRC check passed)"]
pub const fn dbckend (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Data block sent/received (CRC check passed)"]
pub fn set_dbckend (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Command transfer in progress"]
pub const fn cmdact (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Command transfer in progress"]
pub fn set_cmdact (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Data transmit in progress"]
pub const fn txact (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Data transmit in progress"]
pub fn set_txact (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Data receive in progress"]
pub const fn rxact (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Data receive in progress"]
pub fn set_rxact (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Transmit FIFO half empty: at least 8 words can be written into the FIFO"]
pub const fn txfifohe (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Transmit FIFO half empty: at least 8 words can be written into the FIFO"]
pub fn set_txfifohe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Receive FIFO half full: there are at least 8 words in the FIFO"]
pub const fn rxfifohf (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Receive FIFO half full: there are at least 8 words in the FIFO"]
pub fn set_rxfifohf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Transmit FIFO full"]
pub const fn txfifof (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Transmit FIFO full"]
pub fn set_txfifof (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Receive FIFO full"]
pub const fn rxfifof (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Receive FIFO full"]
pub fn set_rxfifof (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Transmit FIFO empty"]
pub const fn txfifoe (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Transmit FIFO empty"]
pub fn set_txfifoe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Receive FIFO empty"]
pub const fn rxfifoe (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Receive FIFO empty"]
pub fn set_rxfifoe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Data available in transmit FIFO"]
pub const fn txdavl (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Data available in transmit FIFO"]
pub fn set_txdavl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Data available in receive FIFO"]
pub const fn rxdavl (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Data available in receive FIFO"]
pub fn set_rxdavl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SDIO interrupt received"]
pub const fn sdioit (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SDIO interrupt received"]
pub fn set_sdioit (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Sta { fn default () -> Sta { Sta (0) } } # [doc = "power control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Power (pub u32) ; impl Power { # [doc = "PWRCTRL"]
pub const fn pwrctrl (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "PWRCTRL"]
pub fn set_pwrctrl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } } impl Default for Power { fn default () -> Power { Power (0) } } # [doc = "data FIFO register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fifo (pub u32) ; impl Fifo { # [doc = "Receive and transmit FIFO data"]
pub const fn fifodata (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Receive and transmit FIFO data"]
pub fn set_fifodata (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Fifo { fn default () -> Fifo { Fifo (0) } } # [doc = "command response register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Respcmd (pub u32) ; impl Respcmd { # [doc = "Response command index"]
pub const fn respcmd (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Response command index"]
pub fn set_respcmd (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } } impl Default for Respcmd { fn default () -> Respcmd { Respcmd (0) } } }