

# [doc = "Serial audio interface"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sai (pub * mut u8) ; unsafe impl Send for Sai { } unsafe impl Sync for Sai { } impl Sai { # [doc = "Global configuration register"]
pub fn gcr (self) -> crate :: common :: Reg < regs :: Gcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Cluster CH%s, containing ?CR1, ?CR2, ?FRCR, ?SLOTR, ?IM, ?SR, ?CLRFR, ?DR"]
pub fn ch (self , n : usize) -> Ch { assert ! (n < 2usize) ; unsafe { Ch (self . 0 . add (4usize + n * 32usize)) } } } # [doc = "Cluster CH%s, containing ?CR1, ?CR2, ?FRCR, ?SLOTR, ?IM, ?SR, ?CLRFR, ?DR"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ch (pub * mut u8) ; unsafe impl Send for Ch { } unsafe impl Sync for Ch { } impl Ch { # [doc = "AConfiguration register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "AConfiguration register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "AFRCR"]
pub fn frcr (self) -> crate :: common :: Reg < regs :: Frcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "ASlot register"]
pub fn slotr (self) -> crate :: common :: Reg < regs :: Slotr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "AInterrupt mask register2"]
pub fn im (self) -> crate :: common :: Reg < regs :: Im , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "AStatus register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "AClear flag register"]
pub fn clrfr (self) -> crate :: common :: Reg < regs :: Clrfr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "AData register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } } pub mod regs { # [doc = "Global configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gcr (pub u32) ; impl Gcr { # [doc = "Synchronization inputs"]
pub const fn syncin (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Synchronization inputs"]
pub fn set_syncin (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Synchronization outputs"]
pub const fn syncout (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Synchronization outputs"]
pub fn set_syncout (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } } impl Default for Gcr { fn default () -> Gcr { Gcr (0) } } # [doc = "AConfiguration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "FIFO threshold"]
pub const fn fth (& self) -> super :: vals :: Fth { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Fth (val as u8) } # [doc = "FIFO threshold"]
pub fn set_fth (& mut self , val : super :: vals :: Fth) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "FIFO flush"]
pub const fn fflush (& self) -> super :: vals :: Fflush { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Fflush (val as u8) } # [doc = "FIFO flush"]
pub fn set_fflush (& mut self , val : super :: vals :: Fflush) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Tristate management on data line"]
pub const fn tris (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Tristate management on data line"]
pub fn set_tris (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Mute"]
pub const fn mute (& self) -> super :: vals :: Mute { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Mute (val as u8) } # [doc = "Mute"]
pub fn set_mute (& mut self , val : super :: vals :: Mute) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Mute value"]
pub const fn muteval (& self) -> super :: vals :: Muteval { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Muteval (val as u8) } # [doc = "Mute value"]
pub fn set_muteval (& mut self , val : super :: vals :: Muteval) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Mute counter"]
pub const fn mutecn (& self) -> u8 { let val = (self . 0 >> 7usize) & 0x3f ; val as u8 } # [doc = "Mute counter"]
pub fn set_mutecn (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 7usize)) | (((val as u32) & 0x3f) << 7usize) ; } # [doc = "Complement bit"]
pub const fn cpl (& self) -> super :: vals :: Cpl { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Cpl (val as u8) } # [doc = "Complement bit"]
pub fn set_cpl (& mut self , val : super :: vals :: Cpl) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Companding mode"]
pub const fn comp (& self) -> super :: vals :: Comp { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: Comp (val as u8) } # [doc = "Companding mode"]
pub fn set_comp (& mut self , val : super :: vals :: Comp) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "ASlot register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Slotr (pub u32) ; impl Slotr { # [doc = "First bit offset"]
pub const fn fboff (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "First bit offset"]
pub fn set_fboff (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "Slot size"]
pub const fn slotsz (& self) -> super :: vals :: Slotsz { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: Slotsz (val as u8) } # [doc = "Slot size"]
pub fn set_slotsz (& mut self , val : super :: vals :: Slotsz) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "Number of slots in an audio frame"]
pub const fn nbslot (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Number of slots in an audio frame"]
pub fn set_nbslot (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Slot enable"]
pub const fn sloten (& self) -> super :: vals :: Sloten { let val = (self . 0 >> 16usize) & 0xffff ; super :: vals :: Sloten (val as u16) } # [doc = "Slot enable"]
pub fn set_sloten (& mut self , val : super :: vals :: Sloten) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val . 0 as u32) & 0xffff) << 16usize) ; } } impl Default for Slotr { fn default () -> Slotr { Slotr (0) } } # [doc = "AConfiguration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Audio block mode"]
pub const fn mode (& self) -> super :: vals :: Mode { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Mode (val as u8) } # [doc = "Audio block mode"]
pub fn set_mode (& mut self , val : super :: vals :: Mode) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "Protocol configuration"]
pub const fn prtcfg (& self) -> super :: vals :: Prtcfg { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Prtcfg (val as u8) } # [doc = "Protocol configuration"]
pub fn set_prtcfg (& mut self , val : super :: vals :: Prtcfg) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "Data size"]
pub const fn ds (& self) -> super :: vals :: Ds { let val = (self . 0 >> 5usize) & 0x07 ; super :: vals :: Ds (val as u8) } # [doc = "Data size"]
pub fn set_ds (& mut self , val : super :: vals :: Ds) { self . 0 = (self . 0 & ! (0x07 << 5usize)) | (((val . 0 as u32) & 0x07) << 5usize) ; } # [doc = "Least significant bit first"]
pub const fn lsbfirst (& self) -> super :: vals :: Lsbfirst { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Lsbfirst (val as u8) } # [doc = "Least significant bit first"]
pub fn set_lsbfirst (& mut self , val : super :: vals :: Lsbfirst) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Clock strobing edge"]
pub const fn ckstr (& self) -> super :: vals :: Ckstr { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Ckstr (val as u8) } # [doc = "Clock strobing edge"]
pub fn set_ckstr (& mut self , val : super :: vals :: Ckstr) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Synchronization enable"]
pub const fn syncen (& self) -> super :: vals :: Syncen { let val = (self . 0 >> 10usize) & 0x03 ; super :: vals :: Syncen (val as u8) } # [doc = "Synchronization enable"]
pub fn set_syncen (& mut self , val : super :: vals :: Syncen) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val . 0 as u32) & 0x03) << 10usize) ; } # [doc = "Mono mode"]
pub const fn mono (& self) -> super :: vals :: Mono { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Mono (val as u8) } # [doc = "Mono mode"]
pub fn set_mono (& mut self , val : super :: vals :: Mono) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Output drive"]
pub const fn outdriv (& self) -> super :: vals :: Outdriv { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Outdriv (val as u8) } # [doc = "Output drive"]
pub fn set_outdriv (& mut self , val : super :: vals :: Outdriv) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Audio block A enable"]
pub const fn saien (& self) -> super :: vals :: Saien { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Saien (val as u8) } # [doc = "Audio block A enable"]
pub fn set_saien (& mut self , val : super :: vals :: Saien) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "DMA enable"]
pub const fn dmaen (& self) -> super :: vals :: Dmaen { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Dmaen (val as u8) } # [doc = "DMA enable"]
pub fn set_dmaen (& mut self , val : super :: vals :: Dmaen) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "No divider"]
pub const fn nodiv (& self) -> super :: vals :: Nodiv { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: Nodiv (val as u8) } # [doc = "No divider"]
pub fn set_nodiv (& mut self , val : super :: vals :: Nodiv) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "Master clock divider"]
pub const fn mckdiv (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x0f ; val as u8 } # [doc = "Master clock divider"]
pub fn set_mckdiv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 20usize)) | (((val as u32) & 0x0f) << 20usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "AInterrupt mask register2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Im (pub u32) ; impl Im { # [doc = "Overrun/underrun interrupt enable"]
pub const fn ovrudrie (& self) -> super :: vals :: Ovrudrie { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Ovrudrie (val as u8) } # [doc = "Overrun/underrun interrupt enable"]
pub fn set_ovrudrie (& mut self , val : super :: vals :: Ovrudrie) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Mute detection interrupt enable"]
pub const fn mutedetie (& self) -> super :: vals :: Mutedetie { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Mutedetie (val as u8) } # [doc = "Mute detection interrupt enable"]
pub fn set_mutedetie (& mut self , val : super :: vals :: Mutedetie) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Wrong clock configuration interrupt enable"]
pub const fn wckcfgie (& self) -> super :: vals :: Wckcfgie { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Wckcfgie (val as u8) } # [doc = "Wrong clock configuration interrupt enable"]
pub fn set_wckcfgie (& mut self , val : super :: vals :: Wckcfgie) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "FIFO request interrupt enable"]
pub const fn freqie (& self) -> super :: vals :: Freqie { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Freqie (val as u8) } # [doc = "FIFO request interrupt enable"]
pub fn set_freqie (& mut self , val : super :: vals :: Freqie) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Codec not ready interrupt enable"]
pub const fn cnrdyie (& self) -> super :: vals :: Cnrdyie { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Cnrdyie (val as u8) } # [doc = "Codec not ready interrupt enable"]
pub fn set_cnrdyie (& mut self , val : super :: vals :: Cnrdyie) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Anticipated frame synchronization detection interrupt enable"]
pub const fn afsdetie (& self) -> super :: vals :: Afsdetie { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Afsdetie (val as u8) } # [doc = "Anticipated frame synchronization detection interrupt enable"]
pub fn set_afsdetie (& mut self , val : super :: vals :: Afsdetie) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Late frame synchronization detection interrupt enable"]
pub const fn lfsdetie (& self) -> super :: vals :: Lfsdetie { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Lfsdetie (val as u8) } # [doc = "Late frame synchronization detection interrupt enable"]
pub fn set_lfsdetie (& mut self , val : super :: vals :: Lfsdetie) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } } impl Default for Im { fn default () -> Im { Im (0) } } # [doc = "AClear flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Clrfr (pub u32) ; impl Clrfr { # [doc = "Clear overrun / underrun"]
pub const fn covrudr (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Clear overrun / underrun"]
pub fn set_covrudr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Mute detection flag"]
pub const fn cmutedet (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Mute detection flag"]
pub fn set_cmutedet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Clear wrong clock configuration flag"]
pub const fn cwckcfg (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Clear wrong clock configuration flag"]
pub fn set_cwckcfg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Clear codec not ready flag"]
pub const fn ccnrdy (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Clear codec not ready flag"]
pub fn set_ccnrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Clear anticipated frame synchronization detection flag."]
pub const fn cafsdet (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Clear anticipated frame synchronization detection flag."]
pub fn set_cafsdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Clear late frame synchronization detection flag"]
pub const fn clfsdet (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Clear late frame synchronization detection flag"]
pub fn set_clfsdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Clrfr { fn default () -> Clrfr { Clrfr (0) } } # [doc = "AData register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Data"]
pub const fn data (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Data"]
pub fn set_data (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "AFRCR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Frcr (pub u32) ; impl Frcr { # [doc = "Frame length"]
pub const fn frl (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Frame length"]
pub fn set_frl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Frame synchronization active level length"]
pub const fn fsall (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x7f ; val as u8 } # [doc = "Frame synchronization active level length"]
pub fn set_fsall (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 8usize)) | (((val as u32) & 0x7f) << 8usize) ; } # [doc = "Frame synchronization definition"]
pub const fn fsdef (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Frame synchronization definition"]
pub fn set_fsdef (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Frame synchronization polarity"]
pub const fn fspol (& self) -> super :: vals :: Fspol { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Fspol (val as u8) } # [doc = "Frame synchronization polarity"]
pub fn set_fspol (& mut self , val : super :: vals :: Fspol) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "Frame synchronization offset"]
pub const fn fsoff (& self) -> super :: vals :: Fsoff { let val = (self . 0 >> 18usize) & 0x01 ; super :: vals :: Fsoff (val as u8) } # [doc = "Frame synchronization offset"]
pub fn set_fsoff (& mut self , val : super :: vals :: Fsoff) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val . 0 as u32) & 0x01) << 18usize) ; } } impl Default for Frcr { fn default () -> Frcr { Frcr (0) } } # [doc = "AStatus register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Overrun / underrun"]
pub const fn ovrudr (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Overrun / underrun"]
pub fn set_ovrudr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Mute detection"]
pub const fn mutedet (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Mute detection"]
pub fn set_mutedet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Wrong clock configuration flag. This bit is read only."]
pub const fn wckcfg (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Wrong clock configuration flag. This bit is read only."]
pub fn set_wckcfg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "FIFO request"]
pub const fn freq (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "FIFO request"]
pub fn set_freq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Codec not ready"]
pub const fn cnrdy (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Codec not ready"]
pub fn set_cnrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Anticipated frame synchronization detection"]
pub const fn afsdet (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Anticipated frame synchronization detection"]
pub fn set_afsdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Late frame synchronization detection"]
pub const fn lfsdet (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Late frame synchronization detection"]
pub fn set_lfsdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "FIFO level threshold"]
pub const fn flvl (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x07 ; val as u8 } # [doc = "FIFO level threshold"]
pub fn set_flvl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 16usize)) | (((val as u32) & 0x07) << 16usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lfsdetr (pub u8) ; impl Lfsdetr { # [doc = "No error"]
pub const NOERROR : Self = Self (0) ; # [doc = "Frame synchronization signal is not present at the right time"]
pub const NOSYNC : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Covrudrw (pub u8) ; impl Covrudrw { # [doc = "Clears the OVRUDR flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cpl (pub u8) ; impl Cpl { # [doc = "1’s complement representation"]
pub const ONESCOMPLEMENT : Self = Self (0) ; # [doc = "2’s complement representation"]
pub const TWOSCOMPLEMENT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cnrdyr (pub u8) ; impl Cnrdyr { # [doc = "External AC’97 Codec is ready"]
pub const READY : Self = Self (0) ; # [doc = "External AC’97 Codec is not ready"]
pub const NOTREADY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prtcfg (pub u8) ; impl Prtcfg { # [doc = "Free protocol. Free protocol allows to use the powerful configuration of the audio block to address a specific audio protocol"]
pub const FREE : Self = Self (0) ; # [doc = "SPDIF protocol"]
pub const SPDIF : Self = Self (0x01) ; # [doc = "AC’97 protocol"]
pub const AC97 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Comp (pub u8) ; impl Comp { # [doc = "No companding algorithm"]
pub const NOCOMPANDING : Self = Self (0) ; # [doc = "μ-Law algorithm"]
pub const MULAW : Self = Self (0x02) ; # [doc = "A-Law algorithm"]
pub const ALAW : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ccnrdyw (pub u8) ; impl Ccnrdyw { # [doc = "Clears the CNRDY flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Syncen (pub u8) ; impl Syncen { # [doc = "audio sub-block in asynchronous mode"]
pub const ASYNCHRONOUS : Self = Self (0) ; # [doc = "audio sub-block is synchronous with the other internal audio sub-block. In this case, the audio sub-block must be configured in slave mode"]
pub const INTERNAL : Self = Self (0x01) ; # [doc = "audio sub-block is synchronous with an external SAI embedded peripheral. In this case the audio sub-block should be configured in Slave mode"]
pub const EXTERNAL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Freqie (pub u8) ; impl Freqie { # [doc = "Interrupt is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fsoff (pub u8) ; impl Fsoff { # [doc = "FS is asserted on the first bit of the slot 0"]
pub const ONFIRST : Self = Self (0) ; # [doc = "FS is asserted one bit before the first bit of the slot 0"]
pub const BEFOREFIRST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsbfirst (pub u8) ; impl Lsbfirst { # [doc = "Data are transferred with MSB first"]
pub const MSBFIRST : Self = Self (0) ; # [doc = "Data are transferred with LSB first"]
pub const LSBFIRST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sloten (pub u16) ; impl Sloten { # [doc = "Inactive slot"]
pub const INACTIVE : Self = Self (0) ; # [doc = "Active slot"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mute (pub u8) ; impl Mute { # [doc = "No mute mode"]
pub const DISABLED : Self = Self (0) ; # [doc = "Mute mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Freqr (pub u8) ; impl Freqr { # [doc = "No FIFO request"]
pub const NOREQUEST : Self = Self (0) ; # [doc = "FIFO request to read or to write the SAI_xDR"]
pub const REQUEST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Flvlr (pub u8) ; impl Flvlr { # [doc = "FIFO empty"]
pub const EMPTY : Self = Self (0) ; # [doc = "FIFO <= 1⁄4 but not empty"]
pub const QUARTER1 : Self = Self (0x01) ; # [doc = "1⁄4 < FIFO <= 1⁄2"]
pub const QUARTER2 : Self = Self (0x02) ; # [doc = "1⁄2 < FIFO <= 3⁄4"]
pub const QUARTER3 : Self = Self (0x03) ; # [doc = "3⁄4 < FIFO but not full"]
pub const QUARTER4 : Self = Self (0x04) ; # [doc = "FIFO full"]
pub const FULL : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cafsdetw (pub u8) ; impl Cafsdetw { # [doc = "Clears the AFSDET flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Muteval (pub u8) ; impl Muteval { # [doc = "Bit value 0 is sent during the mute mode"]
pub const SENDZERO : Self = Self (0) ; # [doc = "Last values are sent during the mute mode"]
pub const SENDLAST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wckcfgie (pub u8) ; impl Wckcfgie { # [doc = "Interrupt is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ovrudrie (pub u8) ; impl Ovrudrie { # [doc = "Interrupt is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cnrdyie (pub u8) ; impl Cnrdyie { # [doc = "Interrupt is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fspol (pub u8) ; impl Fspol { # [doc = "FS is active low (falling edge)"]
pub const FALLINGEDGE : Self = Self (0) ; # [doc = "FS is active high (rising edge)"]
pub const RISINGEDGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cwckcfgw (pub u8) ; impl Cwckcfgw { # [doc = "Clears the WCKCFG flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cmutedetw (pub u8) ; impl Cmutedetw { # [doc = "Clears the MUTEDET flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Slotsz (pub u8) ; impl Slotsz { # [doc = "The slot size is equivalent to the data size (specified in DS[3:0]
in the SAI_xCR1 register)"]
pub const DATASIZE : Self = Self (0) ; # [doc = "16-bit"]
pub const BIT16 : Self = Self (0x01) ; # [doc = "32-bit"]
pub const BIT32 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Outdriv (pub u8) ; impl Outdriv { # [doc = "Audio block output driven when SAIEN is set"]
pub const ONSTART : Self = Self (0) ; # [doc = "Audio block output driven immediately after the setting of this bit"]
pub const IMMEDIATELY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Afsdetr (pub u8) ; impl Afsdetr { # [doc = "No error"]
pub const NOERROR : Self = Self (0) ; # [doc = "Frame synchronization signal is detected earlier than expected"]
pub const EARLYSYNC : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mutedetie (pub u8) ; impl Mutedetie { # [doc = "Interrupt is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dmaen (pub u8) ; impl Dmaen { # [doc = "DMA disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "DMA enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ckstr (pub u8) ; impl Ckstr { # [doc = "Data strobing edge is falling edge of SCK"]
pub const FALLINGEDGE : Self = Self (0) ; # [doc = "Data strobing edge is rising edge of SCK"]
pub const RISINGEDGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mode (pub u8) ; impl Mode { # [doc = "Master transmitter"]
pub const MASTERTX : Self = Self (0) ; # [doc = "Master receiver"]
pub const MASTERRX : Self = Self (0x01) ; # [doc = "Slave transmitter"]
pub const SLAVETX : Self = Self (0x02) ; # [doc = "Slave receiver"]
pub const SLAVERX : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Afsdetie (pub u8) ; impl Afsdetie { # [doc = "Interrupt is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fth (pub u8) ; impl Fth { # [doc = "FIFO empty"]
pub const EMPTY : Self = Self (0) ; # [doc = "1⁄4 FIFO"]
pub const QUARTER1 : Self = Self (0x01) ; # [doc = "1⁄2 FIFO"]
pub const QUARTER2 : Self = Self (0x02) ; # [doc = "3⁄4 FIFO"]
pub const QUARTER3 : Self = Self (0x03) ; # [doc = "FIFO full"]
pub const FULL : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mutedetr (pub u8) ; impl Mutedetr { # [doc = "No MUTE detection on the SD input line"]
pub const NOMUTE : Self = Self (0) ; # [doc = "MUTE value detected on the SD input line (0 value) for a specified number of consecutive audio frame"]
pub const MUTE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ovrudrr (pub u8) ; impl Ovrudrr { # [doc = "No overrun/underrun error"]
pub const NOERROR : Self = Self (0) ; # [doc = "Overrun/underrun error detection"]
pub const OVERRUN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Clfsdetw (pub u8) ; impl Clfsdetw { # [doc = "Clears the LFSDET flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fflush (pub u8) ; impl Fflush { # [doc = "No FIFO flush"]
pub const NOFLUSH : Self = Self (0) ; # [doc = "FIFO flush. Programming this bit to 1 triggers the FIFO Flush. All the internal FIFO pointers (read and write) are cleared"]
pub const FLUSH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lfsdetie (pub u8) ; impl Lfsdetie { # [doc = "Interrupt is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wckcfgr (pub u8) ; impl Wckcfgr { # [doc = "Clock configuration is correct"]
pub const CORRECT : Self = Self (0) ; # [doc = "Clock configuration does not respect the rule concerning the frame length specification"]
pub const WRONG : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ds (pub u8) ; impl Ds { # [doc = "8 bits"]
pub const BIT8 : Self = Self (0x02) ; # [doc = "10 bits"]
pub const BIT10 : Self = Self (0x03) ; # [doc = "16 bits"]
pub const BIT16 : Self = Self (0x04) ; # [doc = "20 bits"]
pub const BIT20 : Self = Self (0x05) ; # [doc = "24 bits"]
pub const BIT24 : Self = Self (0x06) ; # [doc = "32 bits"]
pub const BIT32 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Saien (pub u8) ; impl Saien { # [doc = "SAI audio block disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "SAI audio block enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Nodiv (pub u8) ; impl Nodiv { # [doc = "MCLK output is enabled. Forces the ratio between FS and MCLK to 256 or 512 according to the OSR value"]
pub const MASTERCLOCK : Self = Self (0) ; # [doc = "MCLK output enable set by the MCKEN bit (where present, else 0). Ratio between FS and MCLK depends on FRL."]
pub const NODIV : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mono (pub u8) ; impl Mono { # [doc = "Stereo mode"]
pub const STEREO : Self = Self (0) ; # [doc = "Mono mode"]
pub const MONO : Self = Self (0x01) ; } }