

# [doc = "Real-time clock"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rtc (pub * mut u8) ; unsafe impl Send for Rtc { } unsafe impl Sync for Rtc { } impl Rtc { # [doc = "time register"]
pub fn tr (self) -> crate :: common :: Reg < regs :: Tr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "date register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "initialization and status register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "prescaler register"]
pub fn prer (self) -> crate :: common :: Reg < regs :: Prer , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "wakeup timer register"]
pub fn wutr (self) -> crate :: common :: Reg < regs :: Wutr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "alarm A register"]
pub fn alrmar (self) -> crate :: common :: Reg < regs :: Alrmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "alarm B register"]
pub fn alrmbr (self) -> crate :: common :: Reg < regs :: Alrmbr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "write protection register"]
pub fn wpr (self) -> crate :: common :: Reg < regs :: Wpr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "sub second register"]
pub fn ssr (self) -> crate :: common :: Reg < regs :: Ssr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "shift control register"]
pub fn shiftr (self) -> crate :: common :: Reg < regs :: Shiftr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "time stamp time register"]
pub fn tstr (self) -> crate :: common :: Reg < regs :: Tstr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "time stamp date register"]
pub fn tsdr (self) -> crate :: common :: Reg < regs :: Tsdr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "timestamp sub second register"]
pub fn tsssr (self) -> crate :: common :: Reg < regs :: Tsssr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "calibration register"]
pub fn calr (self) -> crate :: common :: Reg < regs :: Calr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "tamper configuration register"]
pub fn tampcr (self) -> crate :: common :: Reg < regs :: Tampcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "alarm A sub second register"]
pub fn alrmassr (self) -> crate :: common :: Reg < regs :: Alrmassr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "alarm B sub second register"]
pub fn alrmbssr (self) -> crate :: common :: Reg < regs :: Alrmbssr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "option register"]
pub fn or (self) -> crate :: common :: Reg < regs :: Or , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "backup register"]
pub fn bkp0r (self) -> crate :: common :: Reg < regs :: Bkp0r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "backup register"]
pub fn bkp1r (self) -> crate :: common :: Reg < regs :: Bkp1r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "backup register"]
pub fn bkp2r (self) -> crate :: common :: Reg < regs :: Bkp2r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "backup register"]
pub fn bkp3r (self) -> crate :: common :: Reg < regs :: Bkp3r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (92usize)) } } # [doc = "backup register"]
pub fn bkp4r (self) -> crate :: common :: Reg < regs :: Bkp4r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "backup register"]
pub fn bkp5r (self) -> crate :: common :: Reg < regs :: Bkp5r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (100usize)) } } # [doc = "backup register"]
pub fn bkp6r (self) -> crate :: common :: Reg < regs :: Bkp6r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (104usize)) } } # [doc = "backup register"]
pub fn bkp7r (self) -> crate :: common :: Reg < regs :: Bkp7r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (108usize)) } } # [doc = "backup register"]
pub fn bkp8r (self) -> crate :: common :: Reg < regs :: Bkp8r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } # [doc = "backup register"]
pub fn bkp9r (self) -> crate :: common :: Reg < regs :: Bkp9r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (116usize)) } } # [doc = "backup register"]
pub fn bkp10r (self) -> crate :: common :: Reg < regs :: Bkp10r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (120usize)) } } # [doc = "backup register"]
pub fn bkp11r (self) -> crate :: common :: Reg < regs :: Bkp11r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (124usize)) } } # [doc = "backup register"]
pub fn bkp12r (self) -> crate :: common :: Reg < regs :: Bkp12r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "backup register"]
pub fn bkp13r (self) -> crate :: common :: Reg < regs :: Bkp13r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize)) } } # [doc = "backup register"]
pub fn bkp14r (self) -> crate :: common :: Reg < regs :: Bkp14r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "backup register"]
pub fn bkp15r (self) -> crate :: common :: Reg < regs :: Bkp15r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (140usize)) } } # [doc = "backup register"]
pub fn bkp16r (self) -> crate :: common :: Reg < regs :: Bkp16r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } # [doc = "backup register"]
pub fn bkp17r (self) -> crate :: common :: Reg < regs :: Bkp17r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (148usize)) } } # [doc = "backup register"]
pub fn bkp18r (self) -> crate :: common :: Reg < regs :: Bkp18r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (152usize)) } } # [doc = "backup register"]
pub fn bkp19r (self) -> crate :: common :: Reg < regs :: Bkp19r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (156usize)) } } } pub mod regs { # [doc = "time stamp date register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tsdr (pub u32) ; impl Tsdr { # [doc = "Date units in BCD format"]
pub const fn du (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Date units in BCD format"]
pub fn set_du (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Date tens in BCD format"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Date tens in BCD format"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "Month units in BCD format"]
pub const fn mu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Month units in BCD format"]
pub fn set_mu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Month tens in BCD format"]
pub const fn mt (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Month tens in BCD format"]
pub fn set_mt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Week day units"]
pub const fn wdu (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x07 ; val as u8 } # [doc = "Week day units"]
pub fn set_wdu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val as u32) & 0x07) << 13usize) ; } } impl Default for Tsdr { fn default () -> Tsdr { Tsdr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp16r (pub u32) ; impl Bkp16r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp16r { fn default () -> Bkp16r { Bkp16r (0) } } # [doc = "write protection register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wpr (pub u32) ; impl Wpr { # [doc = "Write protection key"]
pub const fn key (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Write protection key"]
pub fn set_key (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Wpr { fn default () -> Wpr { Wpr (0) } } # [doc = "calibration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Calr (pub u32) ; impl Calr { # [doc = "Calibration minus"]
pub const fn calm (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Calibration minus"]
pub fn set_calm (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "Use a 16-second calibration cycle period"]
pub const fn calw16 (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Use a 16-second calibration cycle period"]
pub fn set_calw16 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Use an 8-second calibration cycle period"]
pub const fn calw8 (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Use an 8-second calibration cycle period"]
pub fn set_calw8 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Increase frequency of RTC by 488.5 ppm"]
pub const fn calp (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Increase frequency of RTC by 488.5 ppm"]
pub fn set_calp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Calr { fn default () -> Calr { Calr (0) } } # [doc = "sub second register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ssr (pub u32) ; impl Ssr { # [doc = "Sub second value"]
pub const fn ss (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Sub second value"]
pub fn set_ss (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Ssr { fn default () -> Ssr { Ssr (0) } } # [doc = "tamper configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tampcr (pub u32) ; impl Tampcr { # [doc = "Tamper 1 detection enable"]
pub const fn tamp1e (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Tamper 1 detection enable"]
pub fn set_tamp1e (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Active level for tamper 1"]
pub const fn tamp1trg (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Active level for tamper 1"]
pub fn set_tamp1trg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Tamper interrupt enable"]
pub const fn tampie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Tamper interrupt enable"]
pub fn set_tampie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Tamper 2 detection enable"]
pub const fn tamp2e (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Tamper 2 detection enable"]
pub fn set_tamp2e (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Active level for tamper 2"]
pub const fn tamp2trg (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Active level for tamper 2"]
pub fn set_tamp2trg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Tamper 3 detection enable"]
pub const fn tamp3e (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Tamper 3 detection enable"]
pub fn set_tamp3e (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Active level for tamper 3"]
pub const fn tamp3trg (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Active level for tamper 3"]
pub fn set_tamp3trg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Activate timestamp on tamper detection event"]
pub const fn tampts (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Activate timestamp on tamper detection event"]
pub fn set_tampts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Tamper sampling frequency"]
pub const fn tampfreq (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "Tamper sampling frequency"]
pub fn set_tampfreq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "Tamper filter count"]
pub const fn tampflt (& self) -> u8 { let val = (self . 0 >> 11usize) & 0x03 ; val as u8 } # [doc = "Tamper filter count"]
pub fn set_tampflt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 11usize)) | (((val as u32) & 0x03) << 11usize) ; } # [doc = "Tamper precharge duration"]
pub const fn tampprch (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x03 ; val as u8 } # [doc = "Tamper precharge duration"]
pub fn set_tampprch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 13usize)) | (((val as u32) & 0x03) << 13usize) ; } # [doc = "TAMPER pull-up disable"]
pub const fn tamppudis (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "TAMPER pull-up disable"]
pub fn set_tamppudis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Tamper 1 interrupt enable"]
pub const fn tamp1ie (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Tamper 1 interrupt enable"]
pub fn set_tamp1ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Tamper 1 no erase"]
pub const fn tamp1noerase (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Tamper 1 no erase"]
pub fn set_tamp1noerase (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Tamper 1 mask flag"]
pub const fn tamp1mf (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Tamper 1 mask flag"]
pub fn set_tamp1mf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Tamper 2 interrupt enable"]
pub const fn tamp2ie (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Tamper 2 interrupt enable"]
pub fn set_tamp2ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Tamper 2 no erase"]
pub const fn tamp2noerase (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Tamper 2 no erase"]
pub fn set_tamp2noerase (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Tamper 2 mask flag"]
pub const fn tamp2mf (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Tamper 2 mask flag"]
pub fn set_tamp2mf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Tamper 3 interrupt enable"]
pub const fn tamp3ie (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Tamper 3 interrupt enable"]
pub fn set_tamp3ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Tamper 3 no erase"]
pub const fn tamp3noerase (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Tamper 3 no erase"]
pub fn set_tamp3noerase (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Tamper 3 mask flag"]
pub const fn tamp3mf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Tamper 3 mask flag"]
pub fn set_tamp3mf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Tampcr { fn default () -> Tampcr { Tampcr (0) } } # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Wakeup clock selection"]
pub const fn wucksel (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "Wakeup clock selection"]
pub fn set_wucksel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "Time-stamp event active edge"]
pub const fn tsedge (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Time-stamp event active edge"]
pub fn set_tsedge (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Reference clock detection enable (50 or 60 Hz)"]
pub const fn refckon (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Reference clock detection enable (50 or 60 Hz)"]
pub fn set_refckon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Bypass the shadow registers"]
pub const fn bypshad (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Bypass the shadow registers"]
pub fn set_bypshad (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Hour format"]
pub const fn fmt (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Hour format"]
pub fn set_fmt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Alarm A enable"]
pub const fn alrae (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Alarm A enable"]
pub fn set_alrae (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Alarm B enable"]
pub const fn alrbe (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Alarm B enable"]
pub fn set_alrbe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Wakeup timer enable"]
pub const fn wute (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Wakeup timer enable"]
pub fn set_wute (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Time stamp enable"]
pub const fn tse (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Time stamp enable"]
pub fn set_tse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Alarm A interrupt enable"]
pub const fn alraie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Alarm A interrupt enable"]
pub fn set_alraie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Alarm B interrupt enable"]
pub const fn alrbie (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Alarm B interrupt enable"]
pub fn set_alrbie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Wakeup timer interrupt enable"]
pub const fn wutie (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Wakeup timer interrupt enable"]
pub fn set_wutie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Time-stamp interrupt enable"]
pub const fn tsie (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Time-stamp interrupt enable"]
pub fn set_tsie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Add 1 hour (summer time change)"]
pub const fn add1h (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Add 1 hour (summer time change)"]
pub fn set_add1h (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Subtract 1 hour (winter time change)"]
pub const fn sub1h (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Subtract 1 hour (winter time change)"]
pub fn set_sub1h (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Backup"]
pub const fn bkp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Backup"]
pub fn set_bkp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Calibration output selection"]
pub const fn cosel (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Calibration output selection"]
pub fn set_cosel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Output polarity"]
pub const fn pol (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Output polarity"]
pub fn set_pol (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Output selection"]
pub const fn osel (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x03 ; val as u8 } # [doc = "Output selection"]
pub fn set_osel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 21usize)) | (((val as u32) & 0x03) << 21usize) ; } # [doc = "Calibration output enable"]
pub const fn coe (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Calibration output enable"]
pub fn set_coe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "timestamp on internal event enable"]
pub const fn itse (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "timestamp on internal event enable"]
pub fn set_itse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp13r (pub u32) ; impl Bkp13r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp13r { fn default () -> Bkp13r { Bkp13r (0) } } # [doc = "alarm B sub second register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Alrmbssr (pub u32) ; impl Alrmbssr { # [doc = "Sub seconds value"]
pub const fn ss (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Sub seconds value"]
pub fn set_ss (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } # [doc = "Mask the most-significant bits starting at this bit"]
pub const fn maskss (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Mask the most-significant bits starting at this bit"]
pub fn set_maskss (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } } impl Default for Alrmbssr { fn default () -> Alrmbssr { Alrmbssr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp19r (pub u32) ; impl Bkp19r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp19r { fn default () -> Bkp19r { Bkp19r (0) } } # [doc = "alarm A sub second register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Alrmassr (pub u32) ; impl Alrmassr { # [doc = "Sub seconds value"]
pub const fn ss (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Sub seconds value"]
pub fn set_ss (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } # [doc = "Mask the most-significant bits starting at this bit"]
pub const fn maskss (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Mask the most-significant bits starting at this bit"]
pub fn set_maskss (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } } impl Default for Alrmassr { fn default () -> Alrmassr { Alrmassr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp7r (pub u32) ; impl Bkp7r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp7r { fn default () -> Bkp7r { Bkp7r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp15r (pub u32) ; impl Bkp15r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp15r { fn default () -> Bkp15r { Bkp15r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp12r (pub u32) ; impl Bkp12r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp12r { fn default () -> Bkp12r { Bkp12r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp9r (pub u32) ; impl Bkp9r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp9r { fn default () -> Bkp9r { Bkp9r (0) } } # [doc = "date register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Date units in BCD format"]
pub const fn du (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Date units in BCD format"]
pub fn set_du (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Date tens in BCD format"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Date tens in BCD format"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "Month units in BCD format"]
pub const fn mu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Month units in BCD format"]
pub fn set_mu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Month tens in BCD format"]
pub const fn mt (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Month tens in BCD format"]
pub fn set_mt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Week day units"]
pub const fn wdu (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x07 ; val as u8 } # [doc = "Week day units"]
pub fn set_wdu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val as u32) & 0x07) << 13usize) ; } # [doc = "Year units in BCD format"]
pub const fn yu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Year units in BCD format"]
pub fn set_yu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Year tens in BCD format"]
pub const fn yt (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x0f ; val as u8 } # [doc = "Year tens in BCD format"]
pub fn set_yt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 20usize)) | (((val as u32) & 0x0f) << 20usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "prescaler register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Prer (pub u32) ; impl Prer { # [doc = "Synchronous prescaler factor"]
pub const fn prediv_s (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Synchronous prescaler factor"]
pub fn set_prediv_s (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } # [doc = "Asynchronous prescaler factor"]
pub const fn prediv_a (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "Asynchronous prescaler factor"]
pub fn set_prediv_a (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } } impl Default for Prer { fn default () -> Prer { Prer (0) } } # [doc = "alarm A register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Alrmar (pub u32) ; impl Alrmar { # [doc = "Second units in BCD format"]
pub const fn su (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Second units in BCD format"]
pub fn set_su (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Second tens in BCD format"]
pub const fn st (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Second tens in BCD format"]
pub fn set_st (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Alarm A seconds mask"]
pub const fn msk1 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Alarm A seconds mask"]
pub fn set_msk1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Minute units in BCD format"]
pub const fn mnu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Minute units in BCD format"]
pub fn set_mnu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Minute tens in BCD format"]
pub const fn mnt (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Minute tens in BCD format"]
pub fn set_mnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Alarm A minutes mask"]
pub const fn msk2 (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Alarm A minutes mask"]
pub fn set_msk2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Hour units in BCD format"]
pub const fn hu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Hour units in BCD format"]
pub fn set_hu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Hour tens in BCD format"]
pub const fn ht (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Hour tens in BCD format"]
pub fn set_ht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "AM/PM notation"]
pub const fn pm (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "AM/PM notation"]
pub fn set_pm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Alarm A hours mask"]
pub const fn msk3 (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Alarm A hours mask"]
pub fn set_msk3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Date units or day in BCD format"]
pub const fn du (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Date units or day in BCD format"]
pub fn set_du (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "Date tens in BCD format"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "Date tens in BCD format"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } # [doc = "Week day selection"]
pub const fn wdsel (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Week day selection"]
pub fn set_wdsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Alarm A date mask"]
pub const fn msk4 (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Alarm A date mask"]
pub fn set_msk4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Alrmar { fn default () -> Alrmar { Alrmar (0) } } # [doc = "timestamp sub second register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tsssr (pub u32) ; impl Tsssr { # [doc = "Sub second value"]
pub const fn ss (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Sub second value"]
pub fn set_ss (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Tsssr { fn default () -> Tsssr { Tsssr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp8r (pub u32) ; impl Bkp8r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp8r { fn default () -> Bkp8r { Bkp8r (0) } } # [doc = "time stamp time register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tstr (pub u32) ; impl Tstr { # [doc = "Second units in BCD format"]
pub const fn su (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Second units in BCD format"]
pub fn set_su (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Second tens in BCD format"]
pub const fn st (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Second tens in BCD format"]
pub fn set_st (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Minute units in BCD format"]
pub const fn mnu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Minute units in BCD format"]
pub fn set_mnu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Minute tens in BCD format"]
pub const fn mnt (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Minute tens in BCD format"]
pub fn set_mnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Hour units in BCD format"]
pub const fn hu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Hour units in BCD format"]
pub fn set_hu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Hour tens in BCD format"]
pub const fn ht (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Hour tens in BCD format"]
pub fn set_ht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "AM/PM notation"]
pub const fn pm (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "AM/PM notation"]
pub fn set_pm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Tstr { fn default () -> Tstr { Tstr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp6r (pub u32) ; impl Bkp6r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp6r { fn default () -> Bkp6r { Bkp6r (0) } } # [doc = "wakeup timer register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wutr (pub u32) ; impl Wutr { # [doc = "Wakeup auto-reload value bits"]
pub const fn wut (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Wakeup auto-reload value bits"]
pub fn set_wut (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Wutr { fn default () -> Wutr { Wutr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp18r (pub u32) ; impl Bkp18r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp18r { fn default () -> Bkp18r { Bkp18r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp17r (pub u32) ; impl Bkp17r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp17r { fn default () -> Bkp17r { Bkp17r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp1r (pub u32) ; impl Bkp1r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp1r { fn default () -> Bkp1r { Bkp1r (0) } } # [doc = "option register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Or (pub u32) ; impl Or { # [doc = "RTC_ALARM on PC13 output type"]
pub const fn rtc_alarm_type (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "RTC_ALARM on PC13 output type"]
pub fn set_rtc_alarm_type (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTC_OUT remap"]
pub const fn rtc_out_rmp (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "RTC_OUT remap"]
pub fn set_rtc_out_rmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Or { fn default () -> Or { Or (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp14r (pub u32) ; impl Bkp14r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp14r { fn default () -> Bkp14r { Bkp14r (0) } } # [doc = "alarm B register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Alrmbr (pub u32) ; impl Alrmbr { # [doc = "Second units in BCD format"]
pub const fn su (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Second units in BCD format"]
pub fn set_su (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Second tens in BCD format"]
pub const fn st (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Second tens in BCD format"]
pub fn set_st (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Alarm B seconds mask"]
pub const fn msk1 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Alarm B seconds mask"]
pub fn set_msk1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Minute units in BCD format"]
pub const fn mnu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Minute units in BCD format"]
pub fn set_mnu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Minute tens in BCD format"]
pub const fn mnt (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Minute tens in BCD format"]
pub fn set_mnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Alarm B minutes mask"]
pub const fn msk2 (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Alarm B minutes mask"]
pub fn set_msk2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Hour units in BCD format"]
pub const fn hu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Hour units in BCD format"]
pub fn set_hu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Hour tens in BCD format"]
pub const fn ht (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Hour tens in BCD format"]
pub fn set_ht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "AM/PM notation"]
pub const fn pm (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "AM/PM notation"]
pub fn set_pm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Alarm B hours mask"]
pub const fn msk3 (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Alarm B hours mask"]
pub fn set_msk3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Date units or day in BCD format"]
pub const fn du (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Date units or day in BCD format"]
pub fn set_du (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "Date tens in BCD format"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "Date tens in BCD format"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } # [doc = "Week day selection"]
pub const fn wdsel (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Week day selection"]
pub fn set_wdsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Alarm B date mask"]
pub const fn msk4 (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Alarm B date mask"]
pub fn set_msk4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Alrmbr { fn default () -> Alrmbr { Alrmbr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp11r (pub u32) ; impl Bkp11r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp11r { fn default () -> Bkp11r { Bkp11r (0) } } # [doc = "shift control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Shiftr (pub u32) ; impl Shiftr { # [doc = "Subtract a fraction of a second"]
pub const fn subfs (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Subtract a fraction of a second"]
pub fn set_subfs (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } # [doc = "Add one second"]
pub const fn add1s (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Add one second"]
pub fn set_add1s (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Shiftr { fn default () -> Shiftr { Shiftr (0) } } # [doc = "time register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tr (pub u32) ; impl Tr { # [doc = "Second units in BCD format"]
pub const fn su (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Second units in BCD format"]
pub fn set_su (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Second tens in BCD format"]
pub const fn st (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Second tens in BCD format"]
pub fn set_st (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Minute units in BCD format"]
pub const fn mnu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Minute units in BCD format"]
pub fn set_mnu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Minute tens in BCD format"]
pub const fn mnt (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Minute tens in BCD format"]
pub fn set_mnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Hour units in BCD format"]
pub const fn hu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Hour units in BCD format"]
pub fn set_hu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Hour tens in BCD format"]
pub const fn ht (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Hour tens in BCD format"]
pub fn set_ht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "AM/PM notation"]
pub const fn pm (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "AM/PM notation"]
pub fn set_pm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Tr { fn default () -> Tr { Tr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp0r (pub u32) ; impl Bkp0r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp0r { fn default () -> Bkp0r { Bkp0r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp3r (pub u32) ; impl Bkp3r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp3r { fn default () -> Bkp3r { Bkp3r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp10r (pub u32) ; impl Bkp10r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp10r { fn default () -> Bkp10r { Bkp10r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp5r (pub u32) ; impl Bkp5r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp5r { fn default () -> Bkp5r { Bkp5r (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp2r (pub u32) ; impl Bkp2r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp2r { fn default () -> Bkp2r { Bkp2r (0) } } # [doc = "initialization and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "Alarm A write flag"]
pub const fn alrawf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Alarm A write flag"]
pub fn set_alrawf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Alarm B write flag"]
pub const fn alrbwf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Alarm B write flag"]
pub fn set_alrbwf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup timer write flag"]
pub const fn wutwf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Wakeup timer write flag"]
pub fn set_wutwf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Shift operation pending"]
pub const fn shpf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Shift operation pending"]
pub fn set_shpf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Initialization status flag"]
pub const fn inits (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Initialization status flag"]
pub fn set_inits (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Registers synchronization flag"]
pub const fn rsf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Registers synchronization flag"]
pub fn set_rsf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Initialization flag"]
pub const fn initf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Initialization flag"]
pub fn set_initf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Initialization mode"]
pub const fn init (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Initialization mode"]
pub fn set_init (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Alarm A flag"]
pub const fn alraf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Alarm A flag"]
pub fn set_alraf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Alarm B flag"]
pub const fn alrbf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Alarm B flag"]
pub fn set_alrbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Wakeup timer flag"]
pub const fn wutf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Wakeup timer flag"]
pub fn set_wutf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Time-stamp flag"]
pub const fn tsf (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Time-stamp flag"]
pub fn set_tsf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Time-stamp overflow flag"]
pub const fn tsovf (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Time-stamp overflow flag"]
pub fn set_tsovf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Tamper detection flag"]
pub const fn tamp1f (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Tamper detection flag"]
pub fn set_tamp1f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "RTC_TAMP2 detection flag"]
pub const fn tamp2f (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "RTC_TAMP2 detection flag"]
pub fn set_tamp2f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "RTC_TAMP3 detection flag"]
pub const fn tamp3f (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC_TAMP3 detection flag"]
pub fn set_tamp3f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Recalibration pending Flag"]
pub const fn recalpf (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Recalibration pending Flag"]
pub fn set_recalpf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "INTERNAL TIME-STAMP FLAG"]
pub const fn itsf (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "INTERNAL TIME-STAMP FLAG"]
pub fn set_itsf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkp4r (pub u32) ; impl Bkp4r { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkp4r { fn default () -> Bkp4r { Bkp4r (0) } } }