

# [doc = "Real-time clock"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rtc (pub * mut u8) ; unsafe impl Send for Rtc { } unsafe impl Sync for Rtc { } impl Rtc { # [doc = "time register"]
pub fn tr (self) -> crate :: common :: Reg < regs :: Tr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "date register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "initialization and status register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "prescaler register"]
pub fn prer (self) -> crate :: common :: Reg < regs :: Prer , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "wakeup timer register"]
pub fn wutr (self) -> crate :: common :: Reg < regs :: Wutr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "alarm A register"]
pub fn alrmar (self) -> crate :: common :: Reg < regs :: Alrmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "alarm B register"]
pub fn alrmbr (self) -> crate :: common :: Reg < regs :: Alrmbr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "write protection register"]
pub fn wpr (self) -> crate :: common :: Reg < regs :: Wpr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "sub second register"]
pub fn ssr (self) -> crate :: common :: Reg < regs :: Ssr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "shift control register"]
pub fn shiftr (self) -> crate :: common :: Reg < regs :: Shiftr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "time stamp time register"]
pub fn tstr (self) -> crate :: common :: Reg < regs :: Tstr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "time stamp date register"]
pub fn tsdr (self) -> crate :: common :: Reg < regs :: Tsdr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "timestamp sub second register"]
pub fn tsssr (self) -> crate :: common :: Reg < regs :: Tsssr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "calibration register"]
pub fn calr (self) -> crate :: common :: Reg < regs :: Calr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "tamper configuration register"]
pub fn tampcr (self) -> crate :: common :: Reg < regs :: Tampcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "alarm A sub second register"]
pub fn alrmassr (self) -> crate :: common :: Reg < regs :: Alrmassr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "alarm B sub second register"]
pub fn alrmbssr (self) -> crate :: common :: Reg < regs :: Alrmbssr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "option register"]
pub fn or (self) -> crate :: common :: Reg < regs :: Or , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "backup register"]
pub fn bkpr (self , n : usize) -> crate :: common :: Reg < regs :: Bkpr , crate :: common :: RW > { assert ! (n < 32usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize + n * 4usize)) } } } pub mod regs { # [doc = "wakeup timer register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wutr (pub u32) ; impl Wutr { # [doc = "Wakeup auto-reload value bits"]
pub const fn wut (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Wakeup auto-reload value bits"]
pub fn set_wut (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Wutr { fn default () -> Wutr { Wutr (0) } } # [doc = "tamper configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tampcr (pub u32) ; impl Tampcr { # [doc = "Tamper 1 detection enable"]
pub const fn tamp1e (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Tamper 1 detection enable"]
pub fn set_tamp1e (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Active level for tamper 1"]
pub const fn tamp1trg (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Active level for tamper 1"]
pub fn set_tamp1trg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Tamper interrupt enable"]
pub const fn tampie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Tamper interrupt enable"]
pub fn set_tampie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Tamper 2 detection enable"]
pub const fn tamp2e (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Tamper 2 detection enable"]
pub fn set_tamp2e (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Active level for tamper 2"]
pub const fn tamp2trg (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Active level for tamper 2"]
pub fn set_tamp2trg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Tamper 3 detection enable"]
pub const fn tamp3e (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Tamper 3 detection enable"]
pub fn set_tamp3e (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Active level for tamper 3"]
pub const fn tamp3trg (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Active level for tamper 3"]
pub fn set_tamp3trg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Activate timestamp on tamper detection event"]
pub const fn tampts (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Activate timestamp on tamper detection event"]
pub fn set_tampts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Tamper sampling frequency"]
pub const fn tampfreq (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "Tamper sampling frequency"]
pub fn set_tampfreq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "Tamper filter count"]
pub const fn tampflt (& self) -> u8 { let val = (self . 0 >> 11usize) & 0x03 ; val as u8 } # [doc = "Tamper filter count"]
pub fn set_tampflt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 11usize)) | (((val as u32) & 0x03) << 11usize) ; } # [doc = "Tamper precharge duration"]
pub const fn tampprch (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x03 ; val as u8 } # [doc = "Tamper precharge duration"]
pub fn set_tampprch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 13usize)) | (((val as u32) & 0x03) << 13usize) ; } # [doc = "TAMPER pull-up disable"]
pub const fn tamppudis (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "TAMPER pull-up disable"]
pub fn set_tamppudis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Tamper 1 interrupt enable"]
pub const fn tamp1ie (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Tamper 1 interrupt enable"]
pub fn set_tamp1ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Tamper 1 no erase"]
pub const fn tamp1noerase (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Tamper 1 no erase"]
pub fn set_tamp1noerase (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Tamper 1 mask flag"]
pub const fn tamp1mf (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Tamper 1 mask flag"]
pub fn set_tamp1mf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Tamper 2 interrupt enable"]
pub const fn tamp2ie (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Tamper 2 interrupt enable"]
pub fn set_tamp2ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Tamper 2 no erase"]
pub const fn tamp2noerase (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Tamper 2 no erase"]
pub fn set_tamp2noerase (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Tamper 2 mask flag"]
pub const fn tamp2mf (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Tamper 2 mask flag"]
pub fn set_tamp2mf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Tamper 3 interrupt enable"]
pub const fn tamp3ie (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Tamper 3 interrupt enable"]
pub fn set_tamp3ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Tamper 3 no erase"]
pub const fn tamp3noerase (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Tamper 3 no erase"]
pub fn set_tamp3noerase (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Tamper 3 mask flag"]
pub const fn tamp3mf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Tamper 3 mask flag"]
pub fn set_tamp3mf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Tampcr { fn default () -> Tampcr { Tampcr (0) } } # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Wakeup clock selection"]
pub const fn wucksel (& self) -> super :: vals :: Wucksel { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Wucksel (val as u8) } # [doc = "Wakeup clock selection"]
pub fn set_wucksel (& mut self , val : super :: vals :: Wucksel) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "Time-stamp event active edge"]
pub const fn tsedge (& self) -> super :: vals :: Tsedge { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Tsedge (val as u8) } # [doc = "Time-stamp event active edge"]
pub fn set_tsedge (& mut self , val : super :: vals :: Tsedge) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Reference clock detection enable (50 or 60 Hz)"]
pub const fn refckon (& self) -> super :: vals :: Refckon { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Refckon (val as u8) } # [doc = "Reference clock detection enable (50 or 60 Hz)"]
pub fn set_refckon (& mut self , val : super :: vals :: Refckon) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Bypass the shadow registers"]
pub const fn bypshad (& self) -> super :: vals :: Bypshad { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Bypshad (val as u8) } # [doc = "Bypass the shadow registers"]
pub fn set_bypshad (& mut self , val : super :: vals :: Bypshad) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Hour format"]
pub const fn fmt (& self) -> super :: vals :: Fmt { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Fmt (val as u8) } # [doc = "Hour format"]
pub fn set_fmt (& mut self , val : super :: vals :: Fmt) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Alarm A enable"]
pub const fn alrae (& self) -> super :: vals :: Alrae { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Alrae (val as u8) } # [doc = "Alarm A enable"]
pub fn set_alrae (& mut self , val : super :: vals :: Alrae) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Alarm B enable"]
pub const fn alrbe (& self) -> super :: vals :: Alrbe { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Alrbe (val as u8) } # [doc = "Alarm B enable"]
pub fn set_alrbe (& mut self , val : super :: vals :: Alrbe) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Wakeup timer enable"]
pub const fn wute (& self) -> super :: vals :: Wute { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Wute (val as u8) } # [doc = "Wakeup timer enable"]
pub fn set_wute (& mut self , val : super :: vals :: Wute) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Time stamp enable"]
pub const fn tse (& self) -> super :: vals :: Tse { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Tse (val as u8) } # [doc = "Time stamp enable"]
pub fn set_tse (& mut self , val : super :: vals :: Tse) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Alarm A interrupt enable"]
pub const fn alraie (& self) -> super :: vals :: Alraie { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Alraie (val as u8) } # [doc = "Alarm A interrupt enable"]
pub fn set_alraie (& mut self , val : super :: vals :: Alraie) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Alarm B interrupt enable"]
pub const fn alrbie (& self) -> super :: vals :: Alrbie { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Alrbie (val as u8) } # [doc = "Alarm B interrupt enable"]
pub fn set_alrbie (& mut self , val : super :: vals :: Alrbie) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Wakeup timer interrupt enable"]
pub const fn wutie (& self) -> super :: vals :: Wutie { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Wutie (val as u8) } # [doc = "Wakeup timer interrupt enable"]
pub fn set_wutie (& mut self , val : super :: vals :: Wutie) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Time-stamp interrupt enable"]
pub const fn tsie (& self) -> super :: vals :: Tsie { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Tsie (val as u8) } # [doc = "Time-stamp interrupt enable"]
pub fn set_tsie (& mut self , val : super :: vals :: Tsie) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Add 1 hour (summer time change)"]
pub const fn add1h (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Add 1 hour (summer time change)"]
pub fn set_add1h (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Subtract 1 hour (winter time change)"]
pub const fn sub1h (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Subtract 1 hour (winter time change)"]
pub fn set_sub1h (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Backup"]
pub const fn bkp (& self) -> super :: vals :: Bkp { let val = (self . 0 >> 18usize) & 0x01 ; super :: vals :: Bkp (val as u8) } # [doc = "Backup"]
pub fn set_bkp (& mut self , val : super :: vals :: Bkp) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val . 0 as u32) & 0x01) << 18usize) ; } # [doc = "Calibration output selection"]
pub const fn cosel (& self) -> super :: vals :: Cosel { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: Cosel (val as u8) } # [doc = "Calibration output selection"]
pub fn set_cosel (& mut self , val : super :: vals :: Cosel) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "Output polarity"]
pub const fn pol (& self) -> super :: vals :: Pol { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: Pol (val as u8) } # [doc = "Output polarity"]
pub fn set_pol (& mut self , val : super :: vals :: Pol) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "Output selection"]
pub const fn osel (& self) -> super :: vals :: Osel { let val = (self . 0 >> 21usize) & 0x03 ; super :: vals :: Osel (val as u8) } # [doc = "Output selection"]
pub fn set_osel (& mut self , val : super :: vals :: Osel) { self . 0 = (self . 0 & ! (0x03 << 21usize)) | (((val . 0 as u32) & 0x03) << 21usize) ; } # [doc = "Calibration output enable"]
pub const fn coe (& self) -> super :: vals :: Coe { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Coe (val as u8) } # [doc = "Calibration output enable"]
pub fn set_coe (& mut self , val : super :: vals :: Coe) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "timestamp on internal event enable"]
pub const fn itse (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "timestamp on internal event enable"]
pub fn set_itse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "alarm A register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Alrmar (pub u32) ; impl Alrmar { # [doc = "Second units in BCD format"]
pub const fn su (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Second units in BCD format"]
pub fn set_su (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Second tens in BCD format"]
pub const fn st (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Second tens in BCD format"]
pub fn set_st (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Alarm A seconds mask"]
pub fn msk (& self , n : usize) -> super :: vals :: AlrmarMsk { assert ! (n < 4usize) ; let offs = 7usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: AlrmarMsk (val as u8) } # [doc = "Alarm A seconds mask"]
pub fn set_msk (& mut self , n : usize , val : super :: vals :: AlrmarMsk) { assert ! (n < 4usize) ; let offs = 7usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Minute units in BCD format"]
pub const fn mnu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Minute units in BCD format"]
pub fn set_mnu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Minute tens in BCD format"]
pub const fn mnt (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Minute tens in BCD format"]
pub fn set_mnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Hour units in BCD format"]
pub const fn hu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Hour units in BCD format"]
pub fn set_hu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Hour tens in BCD format"]
pub const fn ht (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Hour tens in BCD format"]
pub fn set_ht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "AM/PM notation"]
pub const fn pm (& self) -> super :: vals :: AlrmarPm { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: AlrmarPm (val as u8) } # [doc = "AM/PM notation"]
pub fn set_pm (& mut self , val : super :: vals :: AlrmarPm) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Date units or day in BCD format"]
pub const fn du (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Date units or day in BCD format"]
pub fn set_du (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "Date tens in BCD format"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "Date tens in BCD format"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } # [doc = "Week day selection"]
pub const fn wdsel (& self) -> super :: vals :: AlrmarWdsel { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: AlrmarWdsel (val as u8) } # [doc = "Week day selection"]
pub fn set_wdsel (& mut self , val : super :: vals :: AlrmarWdsel) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } } impl Default for Alrmar { fn default () -> Alrmar { Alrmar (0) } } # [doc = "timestamp sub second register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tsssr (pub u32) ; impl Tsssr { # [doc = "Sub second value"]
pub const fn ss (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Sub second value"]
pub fn set_ss (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Tsssr { fn default () -> Tsssr { Tsssr (0) } } # [doc = "write protection register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wpr (pub u32) ; impl Wpr { # [doc = "Write protection key"]
pub const fn key (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Write protection key"]
pub fn set_key (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Wpr { fn default () -> Wpr { Wpr (0) } } # [doc = "time stamp time register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tstr (pub u32) ; impl Tstr { # [doc = "Second units in BCD format"]
pub const fn su (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Second units in BCD format"]
pub fn set_su (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Second tens in BCD format"]
pub const fn st (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Second tens in BCD format"]
pub fn set_st (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Minute units in BCD format"]
pub const fn mnu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Minute units in BCD format"]
pub fn set_mnu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Minute tens in BCD format"]
pub const fn mnt (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Minute tens in BCD format"]
pub fn set_mnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Hour units in BCD format"]
pub const fn hu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Hour units in BCD format"]
pub fn set_hu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Hour tens in BCD format"]
pub const fn ht (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Hour tens in BCD format"]
pub fn set_ht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "AM/PM notation"]
pub const fn pm (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "AM/PM notation"]
pub fn set_pm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Tstr { fn default () -> Tstr { Tstr (0) } } # [doc = "alarm A sub second register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Alrmassr (pub u32) ; impl Alrmassr { # [doc = "Sub seconds value"]
pub const fn ss (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Sub seconds value"]
pub fn set_ss (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } # [doc = "Mask the most-significant bits starting at this bit"]
pub const fn maskss (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Mask the most-significant bits starting at this bit"]
pub fn set_maskss (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } } impl Default for Alrmassr { fn default () -> Alrmassr { Alrmassr (0) } } # [doc = "sub second register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ssr (pub u32) ; impl Ssr { # [doc = "Sub second value"]
pub const fn ss (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Sub second value"]
pub fn set_ss (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Ssr { fn default () -> Ssr { Ssr (0) } } # [doc = "time stamp date register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tsdr (pub u32) ; impl Tsdr { # [doc = "Date units in BCD format"]
pub const fn du (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Date units in BCD format"]
pub fn set_du (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Date tens in BCD format"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Date tens in BCD format"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "Month units in BCD format"]
pub const fn mu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Month units in BCD format"]
pub fn set_mu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Month tens in BCD format"]
pub const fn mt (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Month tens in BCD format"]
pub fn set_mt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Week day units"]
pub const fn wdu (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x07 ; val as u8 } # [doc = "Week day units"]
pub fn set_wdu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val as u32) & 0x07) << 13usize) ; } } impl Default for Tsdr { fn default () -> Tsdr { Tsdr (0) } } # [doc = "time register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tr (pub u32) ; impl Tr { # [doc = "Second units in BCD format"]
pub const fn su (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Second units in BCD format"]
pub fn set_su (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Second tens in BCD format"]
pub const fn st (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Second tens in BCD format"]
pub fn set_st (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Minute units in BCD format"]
pub const fn mnu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Minute units in BCD format"]
pub fn set_mnu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Minute tens in BCD format"]
pub const fn mnt (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Minute tens in BCD format"]
pub fn set_mnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Hour units in BCD format"]
pub const fn hu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Hour units in BCD format"]
pub fn set_hu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Hour tens in BCD format"]
pub const fn ht (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Hour tens in BCD format"]
pub fn set_ht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "AM/PM notation"]
pub const fn pm (& self) -> super :: vals :: TrPm { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: TrPm (val as u8) } # [doc = "AM/PM notation"]
pub fn set_pm (& mut self , val : super :: vals :: TrPm) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } } impl Default for Tr { fn default () -> Tr { Tr (0) } } # [doc = "option register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Or (pub u32) ; impl Or { # [doc = "RTC_OUT remap"]
pub const fn rtc_out_rmp (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "RTC_OUT remap"]
pub fn set_rtc_out_rmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIMESTAMP mapping"]
pub const fn tsinsel (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIMESTAMP mapping"]
pub fn set_tsinsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "RTC_ALARM on PC13 output type"]
pub const fn rtc_alarm_type (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "RTC_ALARM on PC13 output type"]
pub fn set_rtc_alarm_type (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } } impl Default for Or { fn default () -> Or { Or (0) } } # [doc = "alarm B sub second register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Alrmbssr (pub u32) ; impl Alrmbssr { # [doc = "Sub seconds value"]
pub const fn ss (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Sub seconds value"]
pub fn set_ss (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } # [doc = "Mask the most-significant bits starting at this bit"]
pub const fn maskss (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Mask the most-significant bits starting at this bit"]
pub fn set_maskss (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } } impl Default for Alrmbssr { fn default () -> Alrmbssr { Alrmbssr (0) } } # [doc = "backup register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bkpr (pub u32) ; impl Bkpr { # [doc = "BKP"]
pub const fn bkp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "BKP"]
pub fn set_bkp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bkpr { fn default () -> Bkpr { Bkpr (0) } } # [doc = "alarm B register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Alrmbr (pub u32) ; impl Alrmbr { # [doc = "Second units in BCD format"]
pub const fn su (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Second units in BCD format"]
pub fn set_su (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Second tens in BCD format"]
pub const fn st (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Second tens in BCD format"]
pub fn set_st (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Alarm B seconds mask"]
pub fn msk (& self , n : usize) -> super :: vals :: AlrmbrMsk { assert ! (n < 4usize) ; let offs = 7usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: AlrmbrMsk (val as u8) } # [doc = "Alarm B seconds mask"]
pub fn set_msk (& mut self , n : usize , val : super :: vals :: AlrmbrMsk) { assert ! (n < 4usize) ; let offs = 7usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Minute units in BCD format"]
pub const fn mnu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Minute units in BCD format"]
pub fn set_mnu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Minute tens in BCD format"]
pub const fn mnt (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Minute tens in BCD format"]
pub fn set_mnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Hour units in BCD format"]
pub const fn hu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Hour units in BCD format"]
pub fn set_hu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Hour tens in BCD format"]
pub const fn ht (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Hour tens in BCD format"]
pub fn set_ht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "AM/PM notation"]
pub const fn pm (& self) -> super :: vals :: AlrmbrPm { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: AlrmbrPm (val as u8) } # [doc = "AM/PM notation"]
pub fn set_pm (& mut self , val : super :: vals :: AlrmbrPm) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Date units or day in BCD format"]
pub const fn du (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Date units or day in BCD format"]
pub fn set_du (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "Date tens in BCD format"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "Date tens in BCD format"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } # [doc = "Week day selection"]
pub const fn wdsel (& self) -> super :: vals :: AlrmbrWdsel { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: AlrmbrWdsel (val as u8) } # [doc = "Week day selection"]
pub fn set_wdsel (& mut self , val : super :: vals :: AlrmbrWdsel) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } } impl Default for Alrmbr { fn default () -> Alrmbr { Alrmbr (0) } } # [doc = "calibration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Calr (pub u32) ; impl Calr { # [doc = "Calibration minus"]
pub const fn calm (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Calibration minus"]
pub fn set_calm (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "Use a 16-second calibration cycle period"]
pub fn calw (& self , n : usize) -> super :: vals :: Calw16 { assert ! (n < 2usize) ; let offs = 13usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Calw16 (val as u8) } # [doc = "Use a 16-second calibration cycle period"]
pub fn set_calw (& mut self , n : usize , val : super :: vals :: Calw16) { assert ! (n < 2usize) ; let offs = 13usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Increase frequency of RTC by 488.5 ppm"]
pub const fn calp (& self) -> super :: vals :: Calp { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Calp (val as u8) } # [doc = "Increase frequency of RTC by 488.5 ppm"]
pub fn set_calp (& mut self , val : super :: vals :: Calp) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Calr { fn default () -> Calr { Calr (0) } } # [doc = "initialization and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "Alarm A write flag"]
pub const fn alrawf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Alarm A write flag"]
pub fn set_alrawf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Alarm B write flag"]
pub const fn alrbwf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Alarm B write flag"]
pub fn set_alrbwf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup timer write flag"]
pub const fn wutwf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Wakeup timer write flag"]
pub fn set_wutwf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Shift operation pending"]
pub const fn shpf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Shift operation pending"]
pub fn set_shpf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Initialization status flag"]
pub const fn inits (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Initialization status flag"]
pub fn set_inits (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Registers synchronization flag"]
pub const fn rsf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Registers synchronization flag"]
pub fn set_rsf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Initialization flag"]
pub const fn initf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Initialization flag"]
pub fn set_initf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Initialization mode"]
pub const fn init (& self) -> super :: vals :: Init { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Init (val as u8) } # [doc = "Initialization mode"]
pub fn set_init (& mut self , val : super :: vals :: Init) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Alarm A flag"]
pub const fn alraf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Alarm A flag"]
pub fn set_alraf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Alarm B flag"]
pub const fn alrbf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Alarm B flag"]
pub fn set_alrbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Wakeup timer flag"]
pub const fn wutf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Wakeup timer flag"]
pub fn set_wutf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Time-stamp flag"]
pub const fn tsf (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Time-stamp flag"]
pub fn set_tsf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Time-stamp overflow flag"]
pub const fn tsovf (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Time-stamp overflow flag"]
pub fn set_tsovf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Tamper detection flag"]
pub const fn tamp1f (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Tamper detection flag"]
pub fn set_tamp1f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "RTC_TAMP2 detection flag"]
pub const fn tamp2f (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "RTC_TAMP2 detection flag"]
pub fn set_tamp2f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "RTC_TAMP3 detection flag"]
pub const fn tamp3f (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC_TAMP3 detection flag"]
pub fn set_tamp3f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Recalibration pending Flag"]
pub const fn recalpf (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Recalibration pending Flag"]
pub fn set_recalpf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Internal tTime-stamp flag"]
pub const fn itsf (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Internal tTime-stamp flag"]
pub fn set_itsf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "shift control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Shiftr (pub u32) ; impl Shiftr { # [doc = "Subtract a fraction of a second"]
pub const fn subfs (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Subtract a fraction of a second"]
pub fn set_subfs (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } # [doc = "Add one second"]
pub const fn add1s (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Add one second"]
pub fn set_add1s (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Shiftr { fn default () -> Shiftr { Shiftr (0) } } # [doc = "date register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Date units in BCD format"]
pub const fn du (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Date units in BCD format"]
pub fn set_du (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Date tens in BCD format"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Date tens in BCD format"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "Month units in BCD format"]
pub const fn mu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Month units in BCD format"]
pub fn set_mu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Month tens in BCD format"]
pub const fn mt (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Month tens in BCD format"]
pub fn set_mt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Week day units"]
pub const fn wdu (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x07 ; val as u8 } # [doc = "Week day units"]
pub fn set_wdu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val as u32) & 0x07) << 13usize) ; } # [doc = "Year units in BCD format"]
pub const fn yu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Year units in BCD format"]
pub fn set_yu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Year tens in BCD format"]
pub const fn yt (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x0f ; val as u8 } # [doc = "Year tens in BCD format"]
pub fn set_yt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 20usize)) | (((val as u32) & 0x0f) << 20usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "prescaler register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Prer (pub u32) ; impl Prer { # [doc = "Synchronous prescaler factor"]
pub const fn prediv_s (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Synchronous prescaler factor"]
pub fn set_prediv_s (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } # [doc = "Asynchronous prescaler factor"]
pub const fn prediv_a (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "Asynchronous prescaler factor"]
pub fn set_prediv_a (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } } impl Default for Prer { fn default () -> Prer { Prer (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsovfw (pub u8) ; impl Tsovfw { # [doc = "This flag is cleared by software by writing 0"]
pub const CLEAR : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bkp (pub u8) ; impl Bkp { # [doc = "Daylight Saving Time change has not been performed"]
pub const DST_NOT_CHANGED : Self = Self (0) ; # [doc = "Daylight Saving Time change has been performed"]
pub const DST_CHANGED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsfr (pub u8) ; impl Tsfr { # [doc = "This flag is set by hardware when a time-stamp event occurs"]
pub const TIMESTAMPEVENT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alrawfr (pub u8) ; impl Alrawfr { # [doc = "Alarm update not allowed"]
pub const UPDATENOTALLOWED : Self = Self (0) ; # [doc = "Alarm update allowed"]
pub const UPDATEALLOWED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Calw8 (pub u8) ; impl Calw8 { # [doc = "When CALW8 is set to ‘1’, the 8-second calibration cycle period is selected"]
pub const EIGHT_SECOND : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wutwfr (pub u8) ; impl Wutwfr { # [doc = "Wakeup timer configuration update not allowed"]
pub const UPDATENOTALLOWED : Self = Self (0) ; # [doc = "Wakeup timer configuration update allowed"]
pub const UPDATEALLOWED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rsfr (pub u8) ; impl Rsfr { # [doc = "Calendar shadow registers not yet synchronized"]
pub const NOTSYNCED : Self = Self (0) ; # [doc = "Calendar shadow registers synchronized"]
pub const SYNCED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rsfw (pub u8) ; impl Rsfw { # [doc = "This flag is cleared by software by writing 0"]
pub const CLEAR : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsie (pub u8) ; impl Tsie { # [doc = "Time-stamp Interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Time-stamp Interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsovfr (pub u8) ; impl Tsovfr { # [doc = "This flag is set by hardware when a time-stamp event occurs while TSF is already set"]
pub const OVERFLOW : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Refckon (pub u8) ; impl Refckon { # [doc = "RTC_REFIN detection disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "RTC_REFIN detection enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wute (pub u8) ; impl Wute { # [doc = "Wakeup timer disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Wakeup timer enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Addhw (pub u8) ; impl Addhw { # [doc = "Adds 1 hour to the current time. This can be used for summer time change outside initialization mode"]
pub const ADD1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Addsw (pub u8) ; impl Addsw { # [doc = "Add one second to the clock/calendar"]
pub const ADD1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct AlrmbrMsk (pub u8) ; impl AlrmbrMsk { # [doc = "Alarm set if the date/day match"]
pub const MASK : Self = Self (0) ; # [doc = "Date/day don’t care in Alarm comparison"]
pub const NOTMASK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsedge (pub u8) ; impl Tsedge { # [doc = "RTC_TS input rising edge generates a time-stamp event"]
pub const RISINGEDGE : Self = Self (0) ; # [doc = "RTC_TS input falling edge generates a time-stamp event"]
pub const FALLINGEDGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alrbie (pub u8) ; impl Alrbie { # [doc = "Alarm B Interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Alarm B Interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alrafr (pub u8) ; impl Alrafr { # [doc = "This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm A register (RTC_ALRMAR)"]
pub const MATCH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alrbfw (pub u8) ; impl Alrbfw { # [doc = "This flag is cleared by software by writing 0"]
pub const CLEAR : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alraie (pub u8) ; impl Alraie { # [doc = "Alarm A interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Alarm A interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bypshad (pub u8) ; impl Bypshad { # [doc = "Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken from the shadow registers, which are updated once every two RTCCLK cycles"]
pub const SHADOWREG : Self = Self (0) ; # [doc = "Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken directly from the calendar counters"]
pub const BYPASSSHADOWREG : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct AlrmarMsk (pub u8) ; impl AlrmarMsk { # [doc = "Alarm set if the date/day match"]
pub const MASK : Self = Self (0) ; # [doc = "Date/day don’t care in Alarm comparison"]
pub const NOTMASK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Calw16 (pub u8) ; impl Calw16 { # [doc = "When CALW16 is set to ‘1’, the 16-second calibration cycle period is selected.This bit must not be set to ‘1’ if CALW8=1"]
pub const SIXTEEN_SECOND : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fmt (pub u8) ; impl Fmt { # [doc = "24 hour/day format"]
pub const TWENTY_FOUR_HOUR : Self = Self (0) ; # [doc = "AM/PM hour format"]
pub const AM_PM : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tampfr (pub u8) ; impl Tampfr { # [doc = "This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input"]
pub const TAMPERED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alrbfr (pub u8) ; impl Alrbfr { # [doc = "This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm B register (RTC_ALRMBR)"]
pub const MATCH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct AlrmarWdsel (pub u8) ; impl AlrmarWdsel { # [doc = "DU[3:0]
represents the date units"]
pub const DATEUNITS : Self = Self (0) ; # [doc = "DU[3:0]
represents the week day. DT[1:0]
is don’t care."]
pub const WEEKDAY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct AlrmarPm (pub u8) ; impl AlrmarPm { # [doc = "AM or 24-hour format"]
pub const AM : Self = Self (0) ; # [doc = "PM"]
pub const PM : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Initsr (pub u8) ; impl Initsr { # [doc = "Calendar has not been initialized"]
pub const NOTINITALIZED : Self = Self (0) ; # [doc = "Calendar has been initialized"]
pub const INITALIZED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Initfr (pub u8) ; impl Initfr { # [doc = "Calendar registers update is not allowed"]
pub const NOTALLOWED : Self = Self (0) ; # [doc = "Calendar registers update is allowed"]
pub const ALLOWED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Shpfr (pub u8) ; impl Shpfr { # [doc = "No shift operation is pending"]
pub const NOSHIFTPENDING : Self = Self (0) ; # [doc = "A shift operation is pending"]
pub const SHIFTPENDING : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wutfw (pub u8) ; impl Wutfw { # [doc = "This flag is cleared by software by writing 0"]
pub const CLEAR : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wucksel (pub u8) ; impl Wucksel { # [doc = "RTC/16 clock is selected"]
pub const DIV16 : Self = Self (0) ; # [doc = "RTC/8 clock is selected"]
pub const DIV8 : Self = Self (0x01) ; # [doc = "RTC/4 clock is selected"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "RTC/2 clock is selected"]
pub const DIV2 : Self = Self (0x03) ; # [doc = "ck_spre (usually 1 Hz) clock is selected"]
pub const CLOCKSPARE : Self = Self (0x04) ; # [doc = "ck_spre (usually 1 Hz) clock is selected and 2^16 is added to the WUT counter value"]
pub const CLOCKSPAREWITHOFFSET : Self = Self (0x06) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Coe (pub u8) ; impl Coe { # [doc = "Calibration output disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Calibration output enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cosel (pub u8) ; impl Cosel { # [doc = "Calibration output is 512 Hz (with default prescaler setting)"]
pub const CALFREQ_512HZ : Self = Self (0) ; # [doc = "Calibration output is 1 Hz (with default prescaler setting)"]
pub const CALFREQ_1HZ : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tampfw (pub u8) ; impl Tampfw { # [doc = "Flag cleared by software writing 0"]
pub const CLEAR : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Calp (pub u8) ; impl Calp { # [doc = "No RTCCLK pulses are added"]
pub const NOCHANGE : Self = Self (0) ; # [doc = "One RTCCLK pulse is effectively inserted every 2^11 pulses (frequency increased by 488.5 ppm)"]
pub const INCREASEFREQ : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wutie (pub u8) ; impl Wutie { # [doc = "Wakeup timer interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Wakeup timer interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Subhw (pub u8) ; impl Subhw { # [doc = "Subtracts 1 hour to the current time. This can be used for winter time change outside initialization mode"]
pub const SUB1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wutfr (pub u8) ; impl Wutfr { # [doc = "This flag is set by hardware when the wakeup auto-reload counter reaches 0"]
pub const ZERO : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alrafw (pub u8) ; impl Alrafw { # [doc = "This flag is cleared by software by writing 0"]
pub const CLEAR : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct TrPm (pub u8) ; impl TrPm { # [doc = "AM or 24-hour format"]
pub const AM : Self = Self (0) ; # [doc = "PM"]
pub const PM : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Init (pub u8) ; impl Init { # [doc = "Free running mode"]
pub const FREERUNNINGMODE : Self = Self (0) ; # [doc = "Initialization mode used to program time and date register (RTC_TR and RTC_DR), and prescaler register (RTC_PRER). Counters are stopped and start counting from the new value when INIT is reset."]
pub const INITMODE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pol (pub u8) ; impl Pol { # [doc = "The pin is high when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])"]
pub const HIGH : Self = Self (0) ; # [doc = "The pin is low when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])"]
pub const LOW : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alrbe (pub u8) ; impl Alrbe { # [doc = "Alarm B disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Alarm B enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsfw (pub u8) ; impl Tsfw { # [doc = "This flag is cleared by software by writing 0"]
pub const CLEAR : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct AlrmbrWdsel (pub u8) ; impl AlrmbrWdsel { # [doc = "DU[3:0]
represents the date units"]
pub const DATEUNITS : Self = Self (0) ; # [doc = "DU[3:0]
represents the week day. DT[1:0]
is don’t care."]
pub const WEEKDAY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Alrae (pub u8) ; impl Alrae { # [doc = "Alarm A disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Alarm A enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Recalpfr (pub u8) ; impl Recalpfr { # [doc = "The RECALPF status flag is automatically set to 1 when software writes to the RTC_CALR register, indicating that the RTC_CALR register is blocked. When the new calibration settings are taken into account, this bit returns to 0"]
pub const PENDING : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct AlrmbrPm (pub u8) ; impl AlrmbrPm { # [doc = "AM or 24-hour format"]
pub const AM : Self = Self (0) ; # [doc = "PM"]
pub const PM : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tse (pub u8) ; impl Tse { # [doc = "Timestamp disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Timestamp enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Osel (pub u8) ; impl Osel { # [doc = "Output disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Alarm A output enabled"]
pub const ALARMA : Self = Self (0x01) ; # [doc = "Alarm B output enabled"]
pub const ALARMB : Self = Self (0x02) ; # [doc = "Wakeup output enabled"]
pub const WAKEUP : Self = Self (0x03) ; } }