

# [doc = "Random number generator"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rng (pub * mut u8) ; unsafe impl Send for Rng { } unsafe impl Sync for Rng { } impl Rng { # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "data register"]
pub fn dr (self) -> crate :: common :: Reg < u32 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } } pub mod regs { # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Random number generator enable"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Random number generator enable"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Interrupt enable"]
pub const fn ie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Interrupt enable"]
pub fn set_ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Data ready"]
pub const fn drdy (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Data ready"]
pub fn set_drdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Clock error current status"]
pub const fn cecs (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Clock error current status"]
pub fn set_cecs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Seed error current status"]
pub const fn secs (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Seed error current status"]
pub fn set_secs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Clock error interrupt status"]
pub const fn ceis (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Clock error interrupt status"]
pub fn set_ceis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Seed error interrupt status"]
pub const fn seis (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Seed error interrupt status"]
pub fn set_seis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } }