

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "Clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Internal clock sources calibration register"]
pub fn icscr (self) -> crate :: common :: Reg < regs :: Icscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Clock configuration register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "PLL configuration register"]
pub fn pllcfgr (self) -> crate :: common :: Reg < regs :: Pllcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Clock interrupt enable register"]
pub fn cier (self) -> crate :: common :: Reg < regs :: Cier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Clock interrupt flag register"]
pub fn cifr (self) -> crate :: common :: Reg < regs :: Cifr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Clock interrupt clear register"]
pub fn cicr (self) -> crate :: common :: Reg < regs :: Cicr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "AHB1 peripheral reset register"]
pub fn ahb1rstr (self) -> crate :: common :: Reg < regs :: Ahb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "AHB2 peripheral reset register"]
pub fn ahb2rstr (self) -> crate :: common :: Reg < regs :: Ahb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "AHB3 peripheral reset register"]
pub fn ahb3rstr (self) -> crate :: common :: Reg < regs :: Ahb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "APB1 peripheral reset register 1"]
pub fn apb1rstr1 (self) -> crate :: common :: Reg < regs :: Apb1rstr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "APB1 peripheral reset register 2"]
pub fn apb1rstr2 (self) -> crate :: common :: Reg < regs :: Apb1rstr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "APB2 peripheral reset register"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "APB3 peripheral reset register"]
pub fn apb3rstr (self) -> crate :: common :: Reg < regs :: Apb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "AHB1 peripheral clock enable register"]
pub fn ahb1enr (self) -> crate :: common :: Reg < regs :: Ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "AHB2 peripheral clock enable register"]
pub fn ahb2enr (self) -> crate :: common :: Reg < regs :: Ahb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "AHB3 peripheral clock enable register"]
pub fn ahb3enr (self) -> crate :: common :: Reg < regs :: Ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "APB1 peripheral clock enable register 1"]
pub fn apb1enr1 (self) -> crate :: common :: Reg < regs :: Apb1enr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "APB1 peripheral clock enable register 2"]
pub fn apb1enr2 (self) -> crate :: common :: Reg < regs :: Apb1enr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (92usize)) } } # [doc = "APB2 peripheral clock enable register"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "APB3 peripheral clock enable register"]
pub fn apb3enr (self) -> crate :: common :: Reg < regs :: Apb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (100usize)) } } # [doc = "AHB1 peripheral clocks enable in Sleep modes register"]
pub fn ahb1smenr (self) -> crate :: common :: Reg < regs :: Ahb1smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (104usize)) } } # [doc = "AHB2 peripheral clocks enable in Sleep modes register"]
pub fn ahb2smenr (self) -> crate :: common :: Reg < regs :: Ahb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (108usize)) } } # [doc = "AHB3 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb3smenr (self) -> crate :: common :: Reg < regs :: Ahb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } # [doc = "APB1 peripheral clocks enable in Sleep mode register 1"]
pub fn apb1smenr1 (self) -> crate :: common :: Reg < regs :: Apb1smenr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (120usize)) } } # [doc = "APB1 peripheral clocks enable in Sleep mode register 2"]
pub fn apb1smenr2 (self) -> crate :: common :: Reg < regs :: Apb1smenr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (124usize)) } } # [doc = "APB2 peripheral clocks enable in Sleep mode register"]
pub fn apb2smenr (self) -> crate :: common :: Reg < regs :: Apb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "APB3 peripheral clock enable in Sleep mode register"]
pub fn apb3smenr (self) -> crate :: common :: Reg < regs :: Apb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize)) } } # [doc = "Peripherals independent clock configuration register"]
pub fn ccipr (self) -> crate :: common :: Reg < regs :: Ccipr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "Backup domain control register"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } # [doc = "Control/status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (148usize)) } } # [doc = "Extended clock recovery register"]
pub fn extcfgr (self) -> crate :: common :: Reg < regs :: Extcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (264usize)) } } # [doc = "CPU2 AHB1 peripheral clock enable register"]
pub fn c2ahb1enr (self) -> crate :: common :: Reg < regs :: C2ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (328usize)) } } # [doc = "CPU2 AHB2 peripheral clock enable register"]
pub fn c2ahb2enr (self) -> crate :: common :: Reg < regs :: C2ahb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (332usize)) } } # [doc = "CPU2 AHB3 peripheral clock enable register [dual core device only]"]
pub fn c2ahb3enr (self) -> crate :: common :: Reg < regs :: C2ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (336usize)) } } # [doc = "CPU2 APB1 peripheral clock enable register 1 [dual core device only]"]
pub fn c2apb1enr1 (self) -> crate :: common :: Reg < regs :: C2apb1enr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (344usize)) } } # [doc = "CPU2 APB1 peripheral clock enable register 2 [dual core device only]"]
pub fn c2apb1enr2 (self) -> crate :: common :: Reg < regs :: C2apb1enr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (348usize)) } } # [doc = "CPU2 APB2 peripheral clock enable register [dual core device only]"]
pub fn c2apb2enr (self) -> crate :: common :: Reg < regs :: C2apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (352usize)) } } # [doc = "CPU2 APB3 peripheral clock enable register [dual core device only]"]
pub fn c2apb3enr (self) -> crate :: common :: Reg < regs :: C2apb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (356usize)) } } # [doc = "CPU2 AHB1 peripheral clocks enable in Sleep modes register [dual core device only]"]
pub fn c2ahb1smenr (self) -> crate :: common :: Reg < regs :: C2ahb1smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (360usize)) } } # [doc = "CPU2 AHB2 peripheral clocks enable in Sleep modes register [dual core device only]"]
pub fn c2ahb2smenr (self) -> crate :: common :: Reg < regs :: C2ahb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (364usize)) } } # [doc = "CPU2 AHB3 peripheral clocks enable in Sleep mode register [dual core device only]"]
pub fn c2ahb3smenr (self) -> crate :: common :: Reg < regs :: C2ahb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (368usize)) } } # [doc = "CPU2 APB1 peripheral clocks enable in Sleep mode register 1 [dual core device only]"]
pub fn c2apb1smenr1 (self) -> crate :: common :: Reg < regs :: C2apb1smenr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (376usize)) } } # [doc = "CPU2 APB1 peripheral clocks enable in Sleep mode register 2 [dual core device only]"]
pub fn c2apb1smenr2 (self) -> crate :: common :: Reg < regs :: C2apb1smenr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (380usize)) } } # [doc = "CPU2 APB2 peripheral clocks enable in Sleep mode register [dual core device only]"]
pub fn c2apb2smenr (self) -> crate :: common :: Reg < regs :: C2apb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (384usize)) } } # [doc = "CPU2 APB3 peripheral clock enable in Sleep mode register [dual core device only]"]
pub fn c2apb3smenr (self) -> crate :: common :: Reg < regs :: C2apb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (388usize)) } } } pub mod regs { # [doc = "CPU2 APB1 peripheral clock enable register 2 [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1enr2 (pub u32) ; impl C2apb1enr2 { # [doc = "CPU2 Low power UART 1 clocks enable"]
pub const fn lpuart1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 Low power UART 1 clocks enable"]
pub fn set_lpuart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 Low power timer 2 clocks enable"]
pub const fn lptim2en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "CPU2 Low power timer 2 clocks enable"]
pub fn set_lptim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CPU2 Low power timer 3 clocks enable"]
pub const fn lptim3en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CPU2 Low power timer 3 clocks enable"]
pub fn set_lptim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for C2apb1enr2 { fn default () -> C2apb1enr2 { C2apb1enr2 (0) } } # [doc = "AHB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2enr (pub u32) ; impl Ahb2enr { # [doc = "CPU1 IO port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU1 IO port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU1 IO port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU1 IO port H clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port H clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2enr { fn default () -> Ahb2enr { Ahb2enr (0) } } # [doc = "CPU2 AHB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb2enr (pub u32) ; impl C2ahb2enr { # [doc = "CPU2 IO port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 IO port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU2 IO port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU2 IO port H clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port H clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for C2ahb2enr { fn default () -> C2ahb2enr { C2ahb2enr (0) } } # [doc = "AHB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1enr (pub u32) ; impl Ahb1enr { # [doc = "CPU1 DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU1 DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU1 DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU1 DMAMUX1 clock enable"]
pub const fn dmamux1en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU1 DMAMUX1 clock enable"]
pub fn set_dmamux1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU1 CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU1 CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Ahb1enr { fn default () -> Ahb1enr { Ahb1enr (0) } } # [doc = "AHB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3rstr (pub u32) ; impl Ahb3rstr { # [doc = "PKARST"]
pub const fn pkarst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PKARST"]
pub fn set_pkarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AESRST"]
pub const fn aesrst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AESRST"]
pub fn set_aesrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "RNGRST"]
pub const fn rngrst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "RNGRST"]
pub fn set_rngrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSEMRST"]
pub const fn hsemrst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSEMRST"]
pub fn set_hsemrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "IPCCRST"]
pub const fn ipccrst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "IPCCRST"]
pub fn set_ipccrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Flash interface reset"]
pub const fn flashrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Flash interface reset"]
pub fn set_flashrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Ahb3rstr { fn default () -> Ahb3rstr { Ahb3rstr (0) } } # [doc = "CPU2 AHB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb1enr (pub u32) ; impl C2ahb1enr { # [doc = "CPU2 DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU2 DMAMUX1 clock enable"]
pub const fn dmamux1en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMAMUX1 clock enable"]
pub fn set_dmamux1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU2 CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU2 CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for C2ahb1enr { fn default () -> C2ahb1enr { C2ahb1enr (0) } } # [doc = "CPU2 APB1 peripheral clock enable register 1 [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1enr1 (pub u32) ; impl C2apb1enr1 { # [doc = "CPU2 TIM2 timer clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 TIM2 timer clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 RTC APB clock enable"]
pub const fn rtcapben (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CPU2 RTC APB clock enable"]
pub fn set_rtcapben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CPU2 SPI2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CPU2 SPI2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "CPU2 USART2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU2 USART2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "CPU2 I2C1 clocks enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "CPU2 I2C1 clocks enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "CPU2 I2C2 clocks enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "CPU2 I2C2 clocks enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "CPU2 I2C3 clocks enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "CPU2 I2C3 clocks enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CPU2 DAC1 clock enable"]
pub const fn dac1en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "CPU2 DAC1 clock enable"]
pub fn set_dac1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "CPU2 Low power timer 1 clocks enable"]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "CPU2 Low power timer 1 clocks enable"]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for C2apb1enr1 { fn default () -> C2apb1enr1 { C2apb1enr1 (0) } } # [doc = "CPU2 APB2 peripheral clocks enable in Sleep mode register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb2smenr (pub u32) ; impl C2apb2smenr { # [doc = "ADC clocks enable during CPU2 Csleep and CStop modes"]
pub const fn adcsmen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC clocks enable during CPU2 Csleep and CStop modes"]
pub fn set_adcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TIM1 timer clock enable during CPU2 CSleep mode"]
pub const fn tim1smen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer clock enable during CPU2 CSleep mode"]
pub fn set_tim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clock enable during CPU2 CSleep mode"]
pub const fn spi1smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clock enable during CPU2 CSleep mode"]
pub fn set_spi1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1clock enable during CPU2 CSleep and CStop mode"]
pub const fn usart1smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1clock enable during CPU2 CSleep and CStop mode"]
pub fn set_usart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM16 timer clock enable during CPU2 CSleep mode"]
pub const fn tim16smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer clock enable during CPU2 CSleep mode"]
pub fn set_tim16smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer clock enable during CPU2 CSleep mode"]
pub const fn tim17smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer clock enable during CPU2 CSleep mode"]
pub fn set_tim17smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for C2apb2smenr { fn default () -> C2apb2smenr { C2apb2smenr (0) } } # [doc = "APB2 peripheral clocks enable in Sleep mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2smenr (pub u32) ; impl Apb2smenr { # [doc = "ADC clocks enable during CPU1 Csleep and CStop modes"]
pub const fn adcsmen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC clocks enable during CPU1 Csleep and CStop modes"]
pub fn set_adcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TIM1 timer clock enable during CPU1 CSleep mode."]
pub const fn tim1smen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer clock enable during CPU1 CSleep mode."]
pub fn set_tim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clock enable during CPU1 CSleep mode."]
pub const fn spi1smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clock enable during CPU1 CSleep mode."]
pub fn set_spi1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1 clock enable during CPU1 Csleep and CStop modes."]
pub const fn usart1smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable during CPU1 Csleep and CStop modes."]
pub fn set_usart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM16 timer clock enable during CPU1 CSleep mode."]
pub const fn tim16smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer clock enable during CPU1 CSleep mode."]
pub fn set_tim16smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer clock enable during CPU1 CSleep mode."]
pub const fn tim17smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer clock enable during CPU1 CSleep mode."]
pub fn set_tim17smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2smenr { fn default () -> Apb2smenr { Apb2smenr (0) } } # [doc = "CPU2 APB3 peripheral clock enable register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb3enr (pub u32) ; impl C2apb3enr { # [doc = "CPU2 sub-GHz radio SPI clock enable"]
pub const fn subghzspien (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 sub-GHz radio SPI clock enable"]
pub fn set_subghzspien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for C2apb3enr { fn default () -> C2apb3enr { C2apb3enr (0) } } # [doc = "CPU2 APB2 peripheral clock enable register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb2enr (pub u32) ; impl C2apb2enr { # [doc = "ADC clocks enable"]
pub const fn adcen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC clocks enable"]
pub fn set_adcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CPU2 TIM1 timer clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "CPU2 TIM1 timer clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CPU2 SPI1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU2 SPI1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CPU2 USART1clocks enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CPU2 USART1clocks enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "CPU2 TIM16 timer clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU2 TIM16 timer clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "CPU2 TIM17 timer clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "CPU2 TIM17 timer clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for C2apb2enr { fn default () -> C2apb2enr { C2apb2enr (0) } } # [doc = "Clock interrupt clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cicr (pub u32) ; impl Cicr { # [doc = "LSI ready interrupt clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSI ready interrupt clear"]
pub const fn msirdyc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSI ready interrupt clear"]
pub fn set_msirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI16 ready interrupt clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready interrupt clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE32 ready interrupt clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE32 ready interrupt clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL ready interrupt clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "HSE32 Clock security system interrupt clear"]
pub const fn cssc (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "HSE32 Clock security system interrupt clear"]
pub fn set_cssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Clock security system interrupt clear"]
pub const fn lsecssc (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Clock security system interrupt clear"]
pub fn set_lsecssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for Cicr { fn default () -> Cicr { Cicr (0) } } # [doc = "AHB1 peripheral clocks enable in Sleep modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1smenr (pub u32) ; impl Ahb1smenr { # [doc = "DMA1 clock enable during CPU1 CSleep mode."]
pub const fn dma1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable during CPU1 CSleep mode."]
pub fn set_dma1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 clock enable during CPU1 CSleep mode"]
pub const fn dma2smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable during CPU1 CSleep mode"]
pub fn set_dma2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMAMUX1 clock enable during CPU1 CSleep mode."]
pub const fn dmamux1smen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMAMUX1 clock enable during CPU1 CSleep mode."]
pub fn set_dmamux1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CRC clock enable during CPU1 CSleep mode."]
pub const fn crcsmen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable during CPU1 CSleep mode."]
pub fn set_crcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Ahb1smenr { fn default () -> Ahb1smenr { Ahb1smenr (0) } } # [doc = "CPU2 AHB2 peripheral clocks enable in Sleep modes register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb2smenr (pub u32) ; impl C2ahb2smenr { # [doc = "IO port A clock enable during CPU2 CSleep mode."]
pub const fn gpioasmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable during CPU2 CSleep mode."]
pub fn set_gpioasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable during CPU2 CSleep mode."]
pub const fn gpiobsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable during CPU2 CSleep mode."]
pub fn set_gpiobsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable during CPU2 CSleep mode."]
pub const fn gpiocsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable during CPU2 CSleep mode."]
pub fn set_gpiocsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port H clock enable during CPU2 CSleep mode."]
pub const fn gpiohsmen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable during CPU2 CSleep mode."]
pub fn set_gpiohsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for C2ahb2smenr { fn default () -> C2ahb2smenr { C2ahb2smenr (0) } } # [doc = "APB1 peripheral clock enable register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr1 (pub u32) ; impl Apb1enr1 { # [doc = "CPU1 TIM2 timer clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 TIM2 timer clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU1 RTC APB clock enable"]
pub const fn rtcapben (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CPU1 RTC APB clock enable"]
pub fn set_rtcapben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CPU1 Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "CPU1 Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CPU1 SPI2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CPU1 SPI2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "CPU1 USART2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU1 USART2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "CPU1 I2C1 clocks enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "CPU1 I2C1 clocks enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "CPU1 I2C2 clocks enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "CPU1 I2C2 clocks enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "CPU1 I2C3 clocks enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "CPU1 I2C3 clocks enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CPU1 DAC1 clock enable"]
pub const fn dac1en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "CPU1 DAC1 clock enable"]
pub fn set_dac1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "CPU1 Low power timer 1 clocks enable"]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "CPU1 Low power timer 1 clocks enable"]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1enr1 { fn default () -> Apb1enr1 { Apb1enr1 (0) } } # [doc = "APB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3rstr (pub u32) ; impl Apb3rstr { # [doc = "Sub-GHz radio SPI reset"]
pub const fn subghzspirst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Sub-GHz radio SPI reset"]
pub fn set_subghzspirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Apb3rstr { fn default () -> Apb3rstr { Apb3rstr (0) } } # [doc = "Clock interrupt flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cifr (pub u32) ; impl Cifr { # [doc = "LSI ready interrupt flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSI ready interrupt flag"]
pub const fn msirdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSI ready interrupt flag"]
pub fn set_msirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI16 ready interrupt flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready interrupt flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE32 ready interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE32 ready interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL ready interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "HSE32 Clock security system interrupt flag"]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "HSE32 Clock security system interrupt flag"]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Clock security system interrupt flag"]
pub const fn lsecssf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Clock security system interrupt flag"]
pub fn set_lsecssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for Cifr { fn default () -> Cifr { Cifr (0) } } # [doc = "APB1 peripheral reset register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr1 (pub u32) ; impl Apb1rstr1 { # [doc = "TIM2 timer reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SPI2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART2 reset"]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 reset"]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "I2C1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 reset"]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 reset"]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "DAC1 reset"]
pub const fn dacrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC1 reset"]
pub fn set_dacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Low Power Timer 1 reset"]
pub const fn lptim1rst (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low Power Timer 1 reset"]
pub fn set_lptim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1rstr1 { fn default () -> Apb1rstr1 { Apb1rstr1 (0) } } # [doc = "Internal clock sources calibration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icscr (pub u32) ; impl Icscr { # [doc = "MSI clock calibration"]
pub const fn msical (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "MSI clock calibration"]
pub fn set_msical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "MSI clock trimming"]
pub const fn msitrim (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "MSI clock trimming"]
pub fn set_msitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "HSI16 clock calibration"]
pub const fn hsical (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "HSI16 clock calibration"]
pub fn set_hsical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "HSI16 clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "HSI16 clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Icscr { fn default () -> Icscr { Icscr (0) } } # [doc = "AHB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3enr (pub u32) ; impl Ahb3enr { # [doc = "PKAEN"]
pub const fn pkaen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PKAEN"]
pub fn set_pkaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AESEN"]
pub const fn aesen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AESEN"]
pub fn set_aesen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "RNGEN"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "RNGEN"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSEMEN"]
pub const fn hsemen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSEMEN"]
pub fn set_hsemen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "IPCCEN"]
pub const fn ipccen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "IPCCEN"]
pub fn set_ipccen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "CPU1 Flash interface clock enable"]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CPU1 Flash interface clock enable"]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Ahb3enr { fn default () -> Ahb3enr { Ahb3enr (0) } } # [doc = "APB1 peripheral clocks enable in Sleep mode register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr2 (pub u32) ; impl Apb1smenr2 { # [doc = "Low power UART 1 clock enable during CPU1 Csleep and CStop modes."]
pub const fn lpuart1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low power UART 1 clock enable during CPU1 Csleep and CStop modes."]
pub fn set_lpuart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Low power timer 2 clock enable during CPU1 Csleep and CStop modes"]
pub const fn lptim2smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Low power timer 2 clock enable during CPU1 Csleep and CStop modes"]
pub fn set_lptim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Low power timer 3 clock enable during CPU1 Csleep and CStop modes"]
pub const fn lptim3smen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Low power timer 3 clock enable during CPU1 Csleep and CStop modes"]
pub fn set_lptim3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Apb1smenr2 { fn default () -> Apb1smenr2 { Apb1smenr2 (0) } } # [doc = "CPU2 APB3 peripheral clock enable in Sleep mode register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb3smenr (pub u32) ; impl C2apb3smenr { # [doc = "sub-GHz radio SPI clock enable during CPU2 CSleep and CStop modes"]
pub const fn subghzspismen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "sub-GHz radio SPI clock enable during CPU2 CSleep and CStop modes"]
pub fn set_subghzspismen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for C2apb3smenr { fn default () -> C2apb3smenr { C2apb3smenr (0) } } # [doc = "Clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "MSI clock enable"]
pub const fn msion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "MSI clock enable"]
pub fn set_msion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "MSI clock ready flag (After reset this bit will be read 1 once the MSI is ready)"]
pub const fn msirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "MSI clock ready flag (After reset this bit will be read 1 once the MSI is ready)"]
pub fn set_msirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSI clock PLL enable"]
pub const fn msipllen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSI clock PLL enable"]
pub fn set_msipllen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "MSI range control selection"]
pub const fn msirgsel (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "MSI range control selection"]
pub fn set_msirgsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "MSI clock ranges"]
pub const fn msirange (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "MSI clock ranges"]
pub fn set_msirange (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "HSI16 clock enable"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "HSI16 clock enable"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "HSI16 always enable for peripheral kernel clocks."]
pub const fn hsikeron (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "HSI16 always enable for peripheral kernel clocks."]
pub fn set_hsikeron (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI16 clock ready flag. (After wakeup from Stop this bit will be read 1 once the HSI16 is ready)"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI16 clock ready flag. (After wakeup from Stop this bit will be read 1 once the HSI16 is ready)"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSI16 automatic start from Stop"]
pub const fn hsiasfs (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "HSI16 automatic start from Stop"]
pub fn set_hsiasfs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "HSI16 kernel clock ready flag for peripherals requests."]
pub const fn hsikerdy (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "HSI16 kernel clock ready flag for peripherals requests."]
pub fn set_hsikerdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "HSE32 clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSE32 clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSE32 clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSE32 clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSE32 Clock security system enable"]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSE32 Clock security system enable"]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "HSE32 sysclk prescaler"]
pub const fn hsepre (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "HSE32 sysclk prescaler"]
pub fn set_hsepre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Enable HSE32 VDDTCXO output on package pin PB0-VDDTCXO."]
pub const fn hsebyppwr (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Enable HSE32 VDDTCXO output on package pin PB0-VDDTCXO."]
pub fn set_hsebyppwr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Main PLL enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Main PLL enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Main PLL clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Main PLL clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "CPU2 APB1 peripheral clocks enable in Sleep mode register 1 [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1smenr1 (pub u32) ; impl C2apb1smenr1 { # [doc = "TIM2 timer clock enable during CPU2 CSleep mode."]
pub const fn tim2smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer clock enable during CPU2 CSleep mode."]
pub fn set_tim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTC bus clock enable during CPU2 CSleep mode."]
pub const fn rtcapbsmen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC bus clock enable during CPU2 CSleep mode."]
pub fn set_rtcapbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SPI2 clock enable during CPU2 CSleep mode."]
pub const fn spi2smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable during CPU2 CSleep mode."]
pub fn set_spi2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART2 clock enable during CPU2 CSleep mode."]
pub const fn usart2smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 clock enable during CPU2 CSleep mode."]
pub fn set_usart2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "I2C1 clock enable during CPU2 CSleep and CStop modes"]
pub const fn i2c1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable during CPU2 CSleep and CStop modes"]
pub fn set_i2c1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable during CPU2 CSleep and CStop modes"]
pub const fn i2c2smen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable during CPU2 CSleep and CStop modes"]
pub fn set_i2c2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 clock enable during CPU2 CSleep and CStop modes"]
pub const fn i2c3smen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable during CPU2 CSleep and CStop modes"]
pub fn set_i2c3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "DAC1 clock enable during CPU2 CSleep mode."]
pub const fn dac1smen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC1 clock enable during CPU2 CSleep mode."]
pub fn set_dac1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Low power timer 1 clock enable during CPU2 CSleep and CStop mode"]
pub const fn lptim1smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low power timer 1 clock enable during CPU2 CSleep and CStop mode"]
pub fn set_lptim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for C2apb1smenr1 { fn default () -> C2apb1smenr1 { C2apb1smenr1 (0) } } # [doc = "APB1 peripheral clock enable register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr2 (pub u32) ; impl Apb1enr2 { # [doc = "CPU1 Low power UART 1 clocks enable"]
pub const fn lpuart1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 Low power UART 1 clocks enable"]
pub fn set_lpuart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU1 Low power timer 2 clocks enable"]
pub const fn lptim2en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "CPU1 Low power timer 2 clocks enable"]
pub fn set_lptim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CPU1 Low power timer 3 clocks enable"]
pub const fn lptim3en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CPU1 Low power timer 3 clocks enable"]
pub fn set_lptim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Apb1enr2 { fn default () -> Apb1enr2 { Apb1enr2 (0) } } # [doc = "AHB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2rstr (pub u32) ; impl Ahb2rstr { # [doc = "IO port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port H reset"]
pub const fn gpiohrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H reset"]
pub fn set_gpiohrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2rstr { fn default () -> Ahb2rstr { Ahb2rstr (0) } } # [doc = "APB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "CPU1 ADC clocks enable"]
pub const fn adcen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CPU1 ADC clocks enable"]
pub fn set_adcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CPU1 TIM1 timer clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "CPU1 TIM1 timer clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CPU1 SPI1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU1 SPI1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CPU1 USART1clocks enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CPU1 USART1clocks enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "CPU1 TIM16 timer clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU1 TIM16 timer clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "CPU1 TIM17 timer clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "CPU1 TIM17 timer clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "Backup domain control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "LSE oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LSE oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "LSE oscillator drive capability"]
pub const fn lsedrv (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x03 ; val as u8 } # [doc = "LSE oscillator drive capability"]
pub fn set_lsedrv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val as u32) & 0x03) << 3usize) ; } # [doc = "CSS on LSE enable"]
pub const fn lsecsson (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "CSS on LSE enable"]
pub fn set_lsecsson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CSS on LSE failure Detection"]
pub const fn lsecssd (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CSS on LSE failure Detection"]
pub fn set_lsecssd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LSE system clock enable"]
pub const fn lsesysen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "LSE system clock enable"]
pub fn set_lsesysen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "LSE system clock ready"]
pub const fn lsesysrdy (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LSE system clock ready"]
pub fn set_lsesysrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Backup domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Low speed clock output enable"]
pub const fn lscoen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Low speed clock output enable"]
pub fn set_lscoen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Low speed clock output selection"]
pub const fn lscosel (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Low speed clock output selection"]
pub fn set_lscosel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "APB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "ADC reset"]
pub const fn adcrst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC reset"]
pub fn set_adcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TIM1 timer reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM16 timer reset"]
pub const fn tim16rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer reset"]
pub fn set_tim16rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer reset"]
pub const fn tim17rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer reset"]
pub fn set_tim17rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "APB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3enr (pub u32) ; impl Apb3enr { # [doc = "sub-GHz radio SPI clock enable"]
pub const fn subghzspien (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "sub-GHz radio SPI clock enable"]
pub fn set_subghzspien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Apb3enr { fn default () -> Apb3enr { Apb3enr (0) } } # [doc = "Control/status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "LSI oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSI oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSI oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LSI frequency prescaler"]
pub const fn lsipre (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "LSI frequency prescaler"]
pub fn set_lsipre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MSI clock ranges"]
pub const fn msisrange (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "MSI clock ranges"]
pub fn set_msisrange (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "Radio in reset status flag"]
pub const fn rfrstf (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Radio in reset status flag"]
pub fn set_rfrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Radio reset"]
pub const fn rfrst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Radio reset"]
pub fn set_rfrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Radio illegal access flag"]
pub const fn rfilarstf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Radio illegal access flag"]
pub fn set_rfilarstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Option byte loader reset flag"]
pub const fn oblrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Option byte loader reset flag"]
pub fn set_oblrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Pin reset flag"]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Pin reset flag"]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "BOR flag"]
pub const fn borrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "BOR flag"]
pub fn set_borrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent window watchdog reset flag"]
pub const fn iwdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent window watchdog reset flag"]
pub fn set_iwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "AHB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1rstr (pub u32) ; impl Ahb1rstr { # [doc = "DMA1 reset"]
pub const fn dma1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 reset"]
pub fn set_dma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 reset"]
pub const fn dma2rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 reset"]
pub fn set_dma2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMAMUX1 reset"]
pub const fn dmamux1rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMAMUX1 reset"]
pub fn set_dmamux1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CRC reset"]
pub const fn crcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC reset"]
pub fn set_crcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Ahb1rstr { fn default () -> Ahb1rstr { Ahb1rstr (0) } } # [doc = "AHB3 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3smenr (pub u32) ; impl Ahb3smenr { # [doc = "PKA accelerator clock enable during CPU1 CSleep mode."]
pub const fn pkasmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PKA accelerator clock enable during CPU1 CSleep mode."]
pub fn set_pkasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AES accelerator clock enable during CPU1 CSleep mode."]
pub const fn aessmen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AES accelerator clock enable during CPU1 CSleep mode."]
pub fn set_aessmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "True RNG clocks enable during CPU1 Csleep and CStop modes"]
pub const fn rngsmen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "True RNG clocks enable during CPU1 Csleep and CStop modes"]
pub fn set_rngsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SRAM1 interface clock enable during CPU1 CSleep mode."]
pub const fn sram1smen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "SRAM1 interface clock enable during CPU1 CSleep mode."]
pub fn set_sram1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "SRAM2 memory interface clock enable during CPU1 CSleep mode"]
pub const fn sram2smen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SRAM2 memory interface clock enable during CPU1 CSleep mode"]
pub fn set_sram2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Flash interface clock enable during CPU1 CSleep mode."]
pub const fn flashsmen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Flash interface clock enable during CPU1 CSleep mode."]
pub fn set_flashsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Ahb3smenr { fn default () -> Ahb3smenr { Ahb3smenr (0) } } # [doc = "CPU2 APB1 peripheral clocks enable in Sleep mode register 2 [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1smenr2 (pub u32) ; impl C2apb1smenr2 { # [doc = "Low power UART 1 clock enable during CPU2 CSleep and CStop mode"]
pub const fn lpuart1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low power UART 1 clock enable during CPU2 CSleep and CStop mode"]
pub fn set_lpuart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Low power timer 2 clocks enable during CPU2 CSleep and CStop modes."]
pub const fn lptim2smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Low power timer 2 clocks enable during CPU2 CSleep and CStop modes."]
pub fn set_lptim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Low power timer 3 clocks enable during CPU2 CSleep and CStop modes."]
pub const fn lptim3smen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Low power timer 3 clocks enable during CPU2 CSleep and CStop modes."]
pub fn set_lptim3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for C2apb1smenr2 { fn default () -> C2apb1smenr2 { C2apb1smenr2 (0) } } # [doc = "Extended clock recovery register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Extcfgr (pub u32) ; impl Extcfgr { # [doc = "HCLK3 shared prescaler (AHB3, Flash, and SRAM2)"]
pub const fn shdhpre (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "HCLK3 shared prescaler (AHB3, Flash, and SRAM2)"]
pub fn set_shdhpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "[dual core device only]
HCLK2 prescaler (CPU2)"]
pub const fn c2hpre (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "[dual core device only]
HCLK2 prescaler (CPU2)"]
pub fn set_c2hpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "HCLK3 shared prescaler flag (AHB3, Flash, and SRAM2)"]
pub const fn shdhpref (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HCLK3 shared prescaler flag (AHB3, Flash, and SRAM2)"]
pub fn set_shdhpref (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CLK2 prescaler flag (CPU2)"]
pub const fn c2hpref (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CLK2 prescaler flag (CPU2)"]
pub fn set_c2hpref (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } } impl Default for Extcfgr { fn default () -> Extcfgr { Extcfgr (0) } } # [doc = "Clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock switch"]
pub const fn sw (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "System clock switch"]
pub fn set_sw (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "System clock switch status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "System clock switch status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "HCLK1 prescaler (CPU1, AHB1, AHB2, and SRAM1.)"]
pub const fn hpre (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "HCLK1 prescaler (CPU1, AHB1, AHB2, and SRAM1.)"]
pub fn set_hpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "PCLK1 low-speed prescaler (APB1)"]
pub const fn ppre1 (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "PCLK1 low-speed prescaler (APB1)"]
pub fn set_ppre1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "PCLK2 high-speed prescaler (APB2)"]
pub const fn ppre2 (& self) -> u8 { let val = (self . 0 >> 11usize) & 0x07 ; val as u8 } # [doc = "PCLK2 high-speed prescaler (APB2)"]
pub fn set_ppre2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 11usize)) | (((val as u32) & 0x07) << 11usize) ; } # [doc = "Wakeup from Stop and CSS backup clock selection"]
pub const fn stopwuck (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Wakeup from Stop and CSS backup clock selection"]
pub fn set_stopwuck (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "HCLK1 prescaler flag (CPU1, AHB1, AHB2, and SRAM1)"]
pub const fn hpref (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HCLK1 prescaler flag (CPU1, AHB1, AHB2, and SRAM1)"]
pub fn set_hpref (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "PCLK1 prescaler flag (APB1)"]
pub const fn ppre1f (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "PCLK1 prescaler flag (APB1)"]
pub fn set_ppre1f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "PCLK2 prescaler flag (APB2)"]
pub const fn ppre2f (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "PCLK2 prescaler flag (APB2)"]
pub fn set_ppre2f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Microcontroller clock output"]
pub const fn mcosel (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Microcontroller clock output"]
pub fn set_mcosel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "Microcontroller clock output prescaler"]
pub const fn mcopre (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x07 ; val as u8 } # [doc = "Microcontroller clock output prescaler"]
pub fn set_mcopre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val as u32) & 0x07) << 28usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "APB1 peripheral reset register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr2 (pub u32) ; impl Apb1rstr2 { # [doc = "Low-power UART 1 reset"]
pub const fn lpuart1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low-power UART 1 reset"]
pub fn set_lpuart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Low-power timer 2 reset"]
pub const fn lptim2rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Low-power timer 2 reset"]
pub fn set_lptim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Low-power timer 3 reset"]
pub const fn lptim3rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Low-power timer 3 reset"]
pub fn set_lptim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Apb1rstr2 { fn default () -> Apb1rstr2 { Apb1rstr2 (0) } } # [doc = "APB3 peripheral clock enable in Sleep mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3smenr (pub u32) ; impl Apb3smenr { # [doc = "Sub-GHz radio SPI clock enable during Sleep and Stop modes"]
pub const fn subghzspismen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Sub-GHz radio SPI clock enable during Sleep and Stop modes"]
pub fn set_subghzspismen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Apb3smenr { fn default () -> Apb3smenr { Apb3smenr (0) } } # [doc = "Peripherals independent clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccipr (pub u32) ; impl Ccipr { # [doc = "USART1 clock source selection"]
pub const fn usart1sel (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "USART1 clock source selection"]
pub fn set_usart1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "USART2 clock source selection"]
pub const fn usart2sel (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "USART2 clock source selection"]
pub fn set_usart2sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "SPI2 I2S clock source selection"]
pub const fn spi2sel (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "SPI2 I2S clock source selection"]
pub fn set_spi2sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "LPUART1 clock source selection"]
pub const fn lpuart1sel (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x03 ; val as u8 } # [doc = "LPUART1 clock source selection"]
pub fn set_lpuart1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val as u32) & 0x03) << 10usize) ; } # [doc = "I2C1 clock source selection"]
pub const fn i2c1sel (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x03 ; val as u8 } # [doc = "I2C1 clock source selection"]
pub fn set_i2c1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val as u32) & 0x03) << 12usize) ; } # [doc = "I2C2 clock source selection"]
pub const fn i2c2sel (& self) -> u8 { let val = (self . 0 >> 14usize) & 0x03 ; val as u8 } # [doc = "I2C2 clock source selection"]
pub fn set_i2c2sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val as u32) & 0x03) << 14usize) ; } # [doc = "I2C3 clock source selection"]
pub const fn i2c3sel (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x03 ; val as u8 } # [doc = "I2C3 clock source selection"]
pub fn set_i2c3sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val as u32) & 0x03) << 16usize) ; } # [doc = "Low power timer 1 clock source selection"]
pub const fn lptim1sel (& self) -> u8 { let val = (self . 0 >> 18usize) & 0x03 ; val as u8 } # [doc = "Low power timer 1 clock source selection"]
pub fn set_lptim1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val as u32) & 0x03) << 18usize) ; } # [doc = "Low power timer 2 clock source selection"]
pub const fn lptim2sel (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Low power timer 2 clock source selection"]
pub fn set_lptim2sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "Low power timer 3 clock source selection"]
pub const fn lptim3sel (& self) -> u8 { let val = (self . 0 >> 22usize) & 0x03 ; val as u8 } # [doc = "Low power timer 3 clock source selection"]
pub fn set_lptim3sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val as u32) & 0x03) << 22usize) ; } # [doc = "ADC clock source selection"]
pub const fn adcsel (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "ADC clock source selection"]
pub fn set_adcsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } # [doc = "RNG clock source selection"]
pub const fn rngsel (& self) -> u8 { let val = (self . 0 >> 30usize) & 0x03 ; val as u8 } # [doc = "RNG clock source selection"]
pub fn set_rngsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 30usize)) | (((val as u32) & 0x03) << 30usize) ; } } impl Default for Ccipr { fn default () -> Ccipr { Ccipr (0) } } # [doc = "AHB2 peripheral clocks enable in Sleep modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2smenr (pub u32) ; impl Ahb2smenr { # [doc = "IO port A clock enable during CPU1 CSleep mode."]
pub const fn gpioasmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable during CPU1 CSleep mode."]
pub fn set_gpioasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable during CPU1 CSleep mode."]
pub const fn gpiobsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable during CPU1 CSleep mode."]
pub fn set_gpiobsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable during CPU1 CSleep mode."]
pub const fn gpiocsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable during CPU1 CSleep mode."]
pub fn set_gpiocsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port H clock enable during CPU1 CSleep mode."]
pub const fn gpiohsmen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable during CPU1 CSleep mode."]
pub fn set_gpiohsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2smenr { fn default () -> Ahb2smenr { Ahb2smenr (0) } } # [doc = "PLL configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllcfgr (pub u32) ; impl Pllcfgr { # [doc = "Main PLL entry clock source"]
pub const fn pllsrc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Main PLL entry clock source"]
pub fn set_pllsrc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Division factor for the main PLL input clock"]
pub const fn pllm (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Division factor for the main PLL input clock"]
pub fn set_pllm (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Main PLL multiplication factor for VCO"]
pub const fn plln (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x7f ; val as u8 } # [doc = "Main PLL multiplication factor for VCO"]
pub fn set_plln (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 8usize)) | (((val as u32) & 0x7f) << 8usize) ; } # [doc = "Main PLL PLLPCLK output enable"]
pub const fn pllpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Main PLL PLLPCLK output enable"]
pub fn set_pllpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Main PLL division factor for PLLPCLK."]
pub const fn pllp (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x1f ; val as u8 } # [doc = "Main PLL division factor for PLLPCLK."]
pub fn set_pllp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 17usize)) | (((val as u32) & 0x1f) << 17usize) ; } # [doc = "Main PLL PLLQCLK output enable"]
pub const fn pllqen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Main PLL PLLQCLK output enable"]
pub fn set_pllqen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Main PLL division factor for PLLQCLK"]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x07 ; val as u8 } # [doc = "Main PLL division factor for PLLQCLK"]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 25usize)) | (((val as u32) & 0x07) << 25usize) ; } # [doc = "Main PLL PLLRCLK output enable"]
pub const fn pllren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Main PLL PLLRCLK output enable"]
pub fn set_pllren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Main PLL division factor for PLLRCLK"]
pub const fn pllr (& self) -> u8 { let val = (self . 0 >> 29usize) & 0x07 ; val as u8 } # [doc = "Main PLL division factor for PLLRCLK"]
pub fn set_pllr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 29usize)) | (((val as u32) & 0x07) << 29usize) ; } } impl Default for Pllcfgr { fn default () -> Pllcfgr { Pllcfgr (0) } } # [doc = "APB1 peripheral clocks enable in Sleep mode register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr1 (pub u32) ; impl Apb1smenr1 { # [doc = "TIM2 timer clock enable during CPU1 CSleep mode."]
pub const fn tim2smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer clock enable during CPU1 CSleep mode."]
pub fn set_tim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTC bus clock enable during CPU1 CSleep mode."]
pub const fn rtcapbsmen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC bus clock enable during CPU1 CSleep mode."]
pub fn set_rtcapbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Window watchdog clocks enable during CPU1 CSleep mode."]
pub const fn wwdgsmen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clocks enable during CPU1 CSleep mode."]
pub fn set_wwdgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clock enable during CPU1 CSleep mode."]
pub const fn spi2smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable during CPU1 CSleep mode."]
pub fn set_spi2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART2 clock enable during CPU1 CSleep mode."]
pub const fn usart2smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 clock enable during CPU1 CSleep mode."]
pub fn set_usart2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "I2C1 clock enable during CPU1 Csleep and CStop modes"]
pub const fn i2c1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable during CPU1 Csleep and CStop modes"]
pub fn set_i2c1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable during CPU1 Csleep and CStop modes"]
pub const fn i2c2smen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable during CPU1 Csleep and CStop modes"]
pub fn set_i2c2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 clock enable during CPU1 Csleep and CStop modes"]
pub const fn i2c3smen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable during CPU1 Csleep and CStop modes"]
pub fn set_i2c3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "DAC1 clock enable during CPU1 CSleep mode."]
pub const fn dacsmen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC1 clock enable during CPU1 CSleep mode."]
pub fn set_dacsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Low power timer 1 clock enable during CPU1 Csleep and CStop mode"]
pub const fn lptim1smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low power timer 1 clock enable during CPU1 Csleep and CStop mode"]
pub fn set_lptim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1smenr1 { fn default () -> Apb1smenr1 { Apb1smenr1 (0) } } # [doc = "Clock interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cier (pub u32) ; impl Cier { # [doc = "LSI ready interrupt enable"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt enable"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSI ready interrupt enable"]
pub const fn msirdyie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSI ready interrupt enable"]
pub fn set_msirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI16 ready interrupt enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready interrupt enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE32 ready interrupt enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE32 ready interrupt enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL ready interrupt enable"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt enable"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LSE clock security system interrupt enable"]
pub const fn lsecssie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE clock security system interrupt enable"]
pub fn set_lsecssie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for Cier { fn default () -> Cier { Cier (0) } } # [doc = "CPU2 AHB3 peripheral clock enable register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb3enr (pub u32) ; impl C2ahb3enr { # [doc = "CPU2 PKA accelerator clock enable"]
pub const fn pkaen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "CPU2 PKA accelerator clock enable"]
pub fn set_pkaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CPU2 AES accelerator clock enable"]
pub const fn aesen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU2 AES accelerator clock enable"]
pub fn set_aesen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "CPU2 True RNG clocks enable"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "CPU2 True RNG clocks enable"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "CPU2 HSEM clock enable"]
pub const fn hsemen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "CPU2 HSEM clock enable"]
pub fn set_hsemen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "CPU2 IPCC interface clock enable"]
pub const fn ipccen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "CPU2 IPCC interface clock enable"]
pub fn set_ipccen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "CPU2 Flash interface clock enable"]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CPU2 Flash interface clock enable"]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for C2ahb3enr { fn default () -> C2ahb3enr { C2ahb3enr (0) } } # [doc = "CPU2 AHB1 peripheral clocks enable in Sleep modes register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb1smenr (pub u32) ; impl C2ahb1smenr { # [doc = "DMA1 clock enable during CPU2 CSleep mode."]
pub const fn dma1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable during CPU2 CSleep mode."]
pub fn set_dma1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 clock enable during CPU2 CSleep mode."]
pub const fn dma2smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable during CPU2 CSleep mode."]
pub fn set_dma2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMAMUX1 clock enable during CPU2 CSleep mode."]
pub const fn dmamux1smen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMAMUX1 clock enable during CPU2 CSleep mode."]
pub fn set_dmamux1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CRC clock enable during CPU2 CSleep mode."]
pub const fn crcsmen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable during CPU2 CSleep mode."]
pub fn set_crcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for C2ahb1smenr { fn default () -> C2ahb1smenr { C2ahb1smenr (0) } } # [doc = "CPU2 AHB3 peripheral clocks enable in Sleep mode register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb3smenr (pub u32) ; impl C2ahb3smenr { # [doc = "PKA accelerator clock enable during CPU2 CSleep mode."]
pub const fn pkasmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PKA accelerator clock enable during CPU2 CSleep mode."]
pub fn set_pkasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AES accelerator clock enable during CPU2 CSleep mode."]
pub const fn aessmen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AES accelerator clock enable during CPU2 CSleep mode."]
pub fn set_aessmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "True RNG clock enable during CPU2 CSleep and CStop mode."]
pub const fn rngsmen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "True RNG clock enable during CPU2 CSleep and CStop mode."]
pub fn set_rngsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SRAM1 interface clock enable during CPU2 CSleep mode."]
pub const fn sram1smen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "SRAM1 interface clock enable during CPU2 CSleep mode."]
pub fn set_sram1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "SRAM2 memory interface clock enable during CPU2 CSleep mode."]
pub const fn sram2smen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SRAM2 memory interface clock enable during CPU2 CSleep mode."]
pub fn set_sram2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Flash interface clock enable during CPU2 CSleep mode."]
pub const fn flashsmen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Flash interface clock enable during CPU2 CSleep mode."]
pub fn set_flashsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for C2ahb3smenr { fn default () -> C2ahb3smenr { C2ahb3smenr (0) } } }