

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "Clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Internal clock sources calibration register"]
pub fn icscr (self) -> crate :: common :: Reg < regs :: Icscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Clock configuration register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "PLLSYS configuration register"]
pub fn pllcfgr (self) -> crate :: common :: Reg < regs :: Pllcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "PLLSAI1 configuration register"]
pub fn pllsai1cfgr (self) -> crate :: common :: Reg < regs :: Pllsai1cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Clock interrupt enable register"]
pub fn cier (self) -> crate :: common :: Reg < regs :: Cier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Clock interrupt flag register"]
pub fn cifr (self) -> crate :: common :: Reg < regs :: Cifr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Clock interrupt clear register"]
pub fn cicr (self) -> crate :: common :: Reg < regs :: Cicr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Step Down converter control register"]
pub fn smpscr (self) -> crate :: common :: Reg < regs :: Smpscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "AHB1 peripheral reset register"]
pub fn ahb1rstr (self) -> crate :: common :: Reg < regs :: Ahb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "AHB2 peripheral reset register"]
pub fn ahb2rstr (self) -> crate :: common :: Reg < regs :: Ahb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "AHB3 peripheral reset register"]
pub fn ahb3rstr (self) -> crate :: common :: Reg < regs :: Ahb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "APB1 peripheral reset register 1"]
pub fn apb1rstr1 (self) -> crate :: common :: Reg < regs :: Apb1rstr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "APB1 peripheral reset register 2"]
pub fn apb1rstr2 (self) -> crate :: common :: Reg < regs :: Apb1rstr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "APB2 peripheral reset register"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "APB3 peripheral reset register"]
pub fn apb3rstr (self) -> crate :: common :: Reg < regs :: Apb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "AHB1 peripheral clock enable register"]
pub fn ahb1enr (self) -> crate :: common :: Reg < regs :: Ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "AHB2 peripheral clock enable register"]
pub fn ahb2enr (self) -> crate :: common :: Reg < regs :: Ahb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "AHB3 peripheral clock enable register"]
pub fn ahb3enr (self) -> crate :: common :: Reg < regs :: Ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "APB1ENR1"]
pub fn apb1enr1 (self) -> crate :: common :: Reg < regs :: Apb1enr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "APB1 peripheral clock enable register 2"]
pub fn apb1enr2 (self) -> crate :: common :: Reg < regs :: Apb1enr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (92usize)) } } # [doc = "APB2ENR"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "AHB1 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb1smenr (self) -> crate :: common :: Reg < regs :: Ahb1smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (104usize)) } } # [doc = "AHB2 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb2smenr (self) -> crate :: common :: Reg < regs :: Ahb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (108usize)) } } # [doc = "AHB3 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb3smenr (self) -> crate :: common :: Reg < regs :: Ahb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } # [doc = "APB1SMENR1"]
pub fn apb1smenr1 (self) -> crate :: common :: Reg < regs :: Apb1smenr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (120usize)) } } # [doc = "APB1 peripheral clocks enable in Sleep and Stop modes register 2"]
pub fn apb1smenr2 (self) -> crate :: common :: Reg < regs :: Apb1smenr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (124usize)) } } # [doc = "APB2SMENR"]
pub fn apb2smenr (self) -> crate :: common :: Reg < regs :: Apb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "CCIPR"]
pub fn ccipr (self) -> crate :: common :: Reg < regs :: Ccipr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "BDCR"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } # [doc = "CSR"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (148usize)) } } # [doc = "Clock recovery RC register"]
pub fn crrcr (self) -> crate :: common :: Reg < regs :: Crrcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (152usize)) } } # [doc = "Clock HSE register"]
pub fn hsecr (self) -> crate :: common :: Reg < regs :: Hsecr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (156usize)) } } # [doc = "Extended clock recovery register"]
pub fn extcfgr (self) -> crate :: common :: Reg < regs :: Extcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (264usize)) } } # [doc = "CPU2 AHB1 peripheral clock enable register"]
pub fn c2ahb1enr (self) -> crate :: common :: Reg < regs :: C2ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (328usize)) } } # [doc = "CPU2 AHB2 peripheral clock enable register"]
pub fn c2ahb2enr (self) -> crate :: common :: Reg < regs :: C2ahb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (332usize)) } } # [doc = "CPU2 AHB3 peripheral clock enable register"]
pub fn c2ahb3enr (self) -> crate :: common :: Reg < regs :: C2ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (336usize)) } } # [doc = "CPU2 APB1ENR1"]
pub fn c2apb1enr1 (self) -> crate :: common :: Reg < regs :: C2apb1enr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (344usize)) } } # [doc = "CPU2 APB1 peripheral clock enable register 2"]
pub fn c2apb1enr2 (self) -> crate :: common :: Reg < regs :: C2apb1enr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (348usize)) } } # [doc = "CPU2 APB2ENR"]
pub fn c2apb2enr (self) -> crate :: common :: Reg < regs :: C2apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (352usize)) } } # [doc = "CPU2 APB3ENR"]
pub fn c2apb3enr (self) -> crate :: common :: Reg < regs :: C2apb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (356usize)) } } # [doc = "CPU2 AHB1 peripheral clocks enable in Sleep and Stop modes register"]
pub fn c2ahb1smenr (self) -> crate :: common :: Reg < regs :: C2ahb1smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (360usize)) } } # [doc = "CPU2 AHB2 peripheral clocks enable in Sleep and Stop modes register"]
pub fn c2ahb2smenr (self) -> crate :: common :: Reg < regs :: C2ahb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (364usize)) } } # [doc = "CPU2 AHB3 peripheral clocks enable in Sleep and Stop modes register"]
pub fn c2ahb3smenr (self) -> crate :: common :: Reg < regs :: C2ahb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (368usize)) } } # [doc = "CPU2 APB1SMENR1"]
pub fn c2apb1smenr1 (self) -> crate :: common :: Reg < regs :: C2apb1smenr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (376usize)) } } # [doc = "CPU2 APB1 peripheral clocks enable in Sleep and Stop modes register 2"]
pub fn c2apb1smenr2 (self) -> crate :: common :: Reg < regs :: C2apb1smenr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (380usize)) } } # [doc = "CPU2 APB2SMENR"]
pub fn c2apb2smenr (self) -> crate :: common :: Reg < regs :: C2apb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (384usize)) } } # [doc = "CPU2 APB3SMENR"]
pub fn c2apb3smenr (self) -> crate :: common :: Reg < regs :: C2apb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (388usize)) } } } pub mod regs { # [doc = "PLLSYS configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllcfgr (pub u32) ; impl Pllcfgr { # [doc = "Main PLL, PLLSAI1 and PLLSAI2 entry clock source"]
pub const fn pllsrc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Main PLL, PLLSAI1 and PLLSAI2 entry clock source"]
pub fn set_pllsrc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Division factor M for the main PLL and audio PLL (PLLSAI1 and PLLSAI2) input clock"]
pub const fn pllm (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Division factor M for the main PLL and audio PLL (PLLSAI1 and PLLSAI2) input clock"]
pub fn set_pllm (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Main PLLSYS multiplication factor N"]
pub const fn plln (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x7f ; val as u8 } # [doc = "Main PLLSYS multiplication factor N"]
pub fn set_plln (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 8usize)) | (((val as u32) & 0x7f) << 8usize) ; } # [doc = "Main PLLSYSP output enable"]
pub const fn pllpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Main PLLSYSP output enable"]
pub fn set_pllpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Main PLL division factor P for PPLSYSSAICLK"]
pub const fn pllp (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x1f ; val as u8 } # [doc = "Main PLL division factor P for PPLSYSSAICLK"]
pub fn set_pllp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 17usize)) | (((val as u32) & 0x1f) << 17usize) ; } # [doc = "Main PLLSYSQ output enable"]
pub const fn pllqen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Main PLLSYSQ output enable"]
pub fn set_pllqen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Main PLLSYS division factor Q for PLLSYSUSBCLK"]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x07 ; val as u8 } # [doc = "Main PLLSYS division factor Q for PLLSYSUSBCLK"]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 25usize)) | (((val as u32) & 0x07) << 25usize) ; } # [doc = "Main PLLSYSR PLLCLK output enable"]
pub const fn pllren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Main PLLSYSR PLLCLK output enable"]
pub fn set_pllren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Main PLLSYS division factor R for SYSCLK (system clock)"]
pub const fn pllr (& self) -> u8 { let val = (self . 0 >> 29usize) & 0x07 ; val as u8 } # [doc = "Main PLLSYS division factor R for SYSCLK (system clock)"]
pub fn set_pllr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 29usize)) | (((val as u32) & 0x07) << 29usize) ; } } impl Default for Pllcfgr { fn default () -> Pllcfgr { Pllcfgr (0) } } # [doc = "Step Down converter control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Smpscr (pub u32) ; impl Smpscr { # [doc = "Step Down converter clock selection"]
pub const fn smpssel (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Step Down converter clock selection"]
pub fn set_smpssel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Step Down converter clock prescaler"]
pub const fn smpsdiv (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Step Down converter clock prescaler"]
pub fn set_smpsdiv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "Step Down converter clock switch status"]
pub const fn smpssws (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "Step Down converter clock switch status"]
pub fn set_smpssws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } } impl Default for Smpscr { fn default () -> Smpscr { Smpscr (0) } } # [doc = "APB1SMENR1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr1 (pub u32) ; impl Apb1smenr1 { # [doc = "TIM2 timer clocks enable during CPU1 Sleep mode"]
pub const fn tim2smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer clocks enable during CPU1 Sleep mode"]
pub fn set_tim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LCD clocks enable during CPU1 Sleep mode"]
pub const fn lcdsmen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LCD clocks enable during CPU1 Sleep mode"]
pub fn set_lcdsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "RTC APB clocks enable during CPU1 Sleep mode"]
pub const fn rtcapbsmen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC APB clocks enable during CPU1 Sleep mode"]
pub fn set_rtcapbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Window watchdog clocks enable during CPU1 Sleep mode"]
pub const fn wwdgsmen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clocks enable during CPU1 Sleep mode"]
pub fn set_wwdgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clocks enable during CPU1 Sleep mode"]
pub const fn spi2smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clocks enable during CPU1 Sleep mode"]
pub fn set_spi2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "I2C1 clocks enable during CPU1 Sleep mode"]
pub const fn i2c1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clocks enable during CPU1 Sleep mode"]
pub fn set_i2c1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C3 clocks enable during CPU1 Sleep mode"]
pub const fn i2c3smen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 clocks enable during CPU1 Sleep mode"]
pub fn set_i2c3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CRS clocks enable during CPU1 Sleep mode"]
pub const fn crsmen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CRS clocks enable during CPU1 Sleep mode"]
pub fn set_crsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "USB FS clocks enable during CPU1 Sleep mode"]
pub const fn usbsmen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "USB FS clocks enable during CPU1 Sleep mode"]
pub fn set_usbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Low power timer 1 clocks enable during CPU1 Sleep mode"]
pub const fn lptim1smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low power timer 1 clocks enable during CPU1 Sleep mode"]
pub fn set_lptim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1smenr1 { fn default () -> Apb1smenr1 { Apb1smenr1 (0) } } # [doc = "AHB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3rstr (pub u32) ; impl Ahb3rstr { # [doc = "Quad SPI memory interface reset"]
pub const fn qspirst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Quad SPI memory interface reset"]
pub fn set_qspirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "PKA interface reset"]
pub const fn pkarst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PKA interface reset"]
pub fn set_pkarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AES2 interface reset"]
pub const fn aes2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AES2 interface reset"]
pub fn set_aes2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "RNG interface reset"]
pub const fn rngrst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "RNG interface reset"]
pub fn set_rngrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSEM interface reset"]
pub const fn hsemrst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSEM interface reset"]
pub fn set_hsemrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "IPCC interface reset"]
pub const fn ipccrst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "IPCC interface reset"]
pub fn set_ipccrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Flash interface reset"]
pub const fn flashrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Flash interface reset"]
pub fn set_flashrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Ahb3rstr { fn default () -> Ahb3rstr { Ahb3rstr (0) } } # [doc = "CSR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "LSI1 oscillator enabled"]
pub const fn lsi1on (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI1 oscillator enabled"]
pub fn set_lsi1on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSI1 oscillator ready"]
pub const fn lsi1rdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSI1 oscillator ready"]
pub fn set_lsi1rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LSI2 oscillator enabled"]
pub const fn lsi2on (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "LSI2 oscillator enabled"]
pub fn set_lsi2on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "LSI2 oscillator ready"]
pub const fn lsi2rdy (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "LSI2 oscillator ready"]
pub fn set_lsi2rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "LSI2 oscillator trimming enable"]
pub const fn lsi2trimen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "LSI2 oscillator trimming enable"]
pub fn set_lsi2trimen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "LSI2 oscillator trim OK"]
pub const fn lsi2trimok (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LSI2 oscillator trim OK"]
pub fn set_lsi2trimok (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LSI2 oscillator bias configuration"]
pub const fn lsi2bw (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "LSI2 oscillator bias configuration"]
pub fn set_lsi2bw (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "RF system wakeup clock source selection"]
pub const fn rfwkpsel (& self) -> u8 { let val = (self . 0 >> 14usize) & 0x03 ; val as u8 } # [doc = "RF system wakeup clock source selection"]
pub fn set_rfwkpsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val as u32) & 0x03) << 14usize) ; } # [doc = "Radio system BLE and 802.15.4 reset status"]
pub const fn rfrsts (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Radio system BLE and 802.15.4 reset status"]
pub fn set_rfrsts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Option byte loader reset flag"]
pub const fn oblrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Option byte loader reset flag"]
pub fn set_oblrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Pin reset flag"]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Pin reset flag"]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "BOR flag"]
pub const fn borrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "BOR flag"]
pub fn set_borrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent window watchdog reset flag"]
pub const fn iwdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent window watchdog reset flag"]
pub fn set_iwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "CPU2 AHB3 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb3smenr (pub u32) ; impl C2ahb3smenr { # [doc = "PKA accelerator clocks enable during CPU2 sleep modes"]
pub const fn pkasmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PKA accelerator clocks enable during CPU2 sleep modes"]
pub fn set_pkasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AES2 accelerator clocks enable during CPU2 sleep modes"]
pub const fn aes2smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AES2 accelerator clocks enable during CPU2 sleep modes"]
pub fn set_aes2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "True RNG clocks enable during CPU2 sleep modes"]
pub const fn rngsmen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "True RNG clocks enable during CPU2 sleep modes"]
pub fn set_rngsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SRAM2a and SRAM2b memory interface clocks enable during CPU2 sleep modes"]
pub const fn sram2smen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SRAM2a and SRAM2b memory interface clocks enable during CPU2 sleep modes"]
pub fn set_sram2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Flash interface clocks enable during CPU2 sleep modes"]
pub const fn flashsmen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Flash interface clocks enable during CPU2 sleep modes"]
pub fn set_flashsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for C2ahb3smenr { fn default () -> C2ahb3smenr { C2ahb3smenr (0) } } # [doc = "CPU2 APB1 peripheral clock enable register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1enr2 (pub u32) ; impl C2apb1enr2 { # [doc = "CPU2 Low power UART 1 clock enable"]
pub const fn lpuart1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 Low power UART 1 clock enable"]
pub fn set_lpuart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 LPTIM2EN"]
pub const fn lptim2en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "CPU2 LPTIM2EN"]
pub fn set_lptim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for C2apb1enr2 { fn default () -> C2apb1enr2 { C2apb1enr2 (0) } } # [doc = "CPU2 APB1SMENR1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1smenr1 (pub u32) ; impl C2apb1smenr1 { # [doc = "TIM2 timer clocks enable during CPU2 Sleep mode"]
pub const fn tim2smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer clocks enable during CPU2 Sleep mode"]
pub fn set_tim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LCD clocks enable during CPU2 Sleep mode"]
pub const fn lcdsmen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LCD clocks enable during CPU2 Sleep mode"]
pub fn set_lcdsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "RTC APB clocks enable during CPU2 Sleep mode"]
pub const fn rtcapbsmen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC APB clocks enable during CPU2 Sleep mode"]
pub fn set_rtcapbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SPI2 clocks enable during CPU2 Sleep mode"]
pub const fn spi2smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clocks enable during CPU2 Sleep mode"]
pub fn set_spi2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "I2C1 clocks enable during CPU2 Sleep mode"]
pub const fn i2c1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clocks enable during CPU2 Sleep mode"]
pub fn set_i2c1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C3 clocks enable during CPU2 Sleep mode"]
pub const fn i2c3smen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 clocks enable during CPU2 Sleep mode"]
pub fn set_i2c3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CRS clocks enable during CPU2 Sleep mode"]
pub const fn crsmen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CRS clocks enable during CPU2 Sleep mode"]
pub fn set_crsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "USB FS clocks enable during CPU2 Sleep mode"]
pub const fn usbsmen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "USB FS clocks enable during CPU2 Sleep mode"]
pub fn set_usbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Low power timer 1 clocks enable during CPU2 Sleep mode"]
pub const fn lptim1smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low power timer 1 clocks enable during CPU2 Sleep mode"]
pub fn set_lptim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for C2apb1smenr1 { fn default () -> C2apb1smenr1 { C2apb1smenr1 (0) } } # [doc = "CPU2 APB2ENR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb2enr (pub u32) ; impl C2apb2enr { # [doc = "CPU2 TIM1 timer clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "CPU2 TIM1 timer clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CPU2 SPI1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU2 SPI1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CPU2 USART1clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CPU2 USART1clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "CPU2 TIM16 timer clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU2 TIM16 timer clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "CPU2 TIM17 timer clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "CPU2 TIM17 timer clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "CPU2 SAI1 clock enable"]
pub const fn sai1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "CPU2 SAI1 clock enable"]
pub fn set_sai1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for C2apb2enr { fn default () -> C2apb2enr { C2apb2enr (0) } } # [doc = "CPU2 AHB1 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb1smenr (pub u32) ; impl C2ahb1smenr { # [doc = "CPU2 DMA1 clocks enable during Sleep and Stop modes"]
pub const fn dma1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMA1 clocks enable during Sleep and Stop modes"]
pub fn set_dma1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 DMA2 clocks enable during Sleep and Stop modes"]
pub const fn dma2smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMA2 clocks enable during Sleep and Stop modes"]
pub fn set_dma2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU2 DMAMUX clocks enable during Sleep and Stop modes"]
pub const fn dmamux1smen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMAMUX clocks enable during Sleep and Stop modes"]
pub fn set_dmamux1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "SRAM1 interface clock enable during CPU1 CSleep mode"]
pub const fn sram1smen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "SRAM1 interface clock enable during CPU1 CSleep mode"]
pub fn set_sram1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CPU2 CRCSMEN"]
pub const fn crcsmen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU2 CRCSMEN"]
pub fn set_crcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CPU2 Touch Sensing Controller clocks enable during Sleep and Stop modes"]
pub const fn tscsmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "CPU2 Touch Sensing Controller clocks enable during Sleep and Stop modes"]
pub fn set_tscsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for C2ahb1smenr { fn default () -> C2ahb1smenr { C2ahb1smenr (0) } } # [doc = "CCIPR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccipr (pub u32) ; impl Ccipr { # [doc = "USART1 clock source selection"]
pub const fn usart1sel (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "USART1 clock source selection"]
pub fn set_usart1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "LPUART1 clock source selection"]
pub const fn lpuart1sel (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x03 ; val as u8 } # [doc = "LPUART1 clock source selection"]
pub fn set_lpuart1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val as u32) & 0x03) << 10usize) ; } # [doc = "I2C1 clock source selection"]
pub const fn i2c1sel (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x03 ; val as u8 } # [doc = "I2C1 clock source selection"]
pub fn set_i2c1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val as u32) & 0x03) << 12usize) ; } # [doc = "I2C3 clock source selection"]
pub const fn i2c3sel (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x03 ; val as u8 } # [doc = "I2C3 clock source selection"]
pub fn set_i2c3sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val as u32) & 0x03) << 16usize) ; } # [doc = "Low power timer 1 clock source selection"]
pub const fn lptim1sel (& self) -> u8 { let val = (self . 0 >> 18usize) & 0x03 ; val as u8 } # [doc = "Low power timer 1 clock source selection"]
pub fn set_lptim1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val as u32) & 0x03) << 18usize) ; } # [doc = "Low power timer 2 clock source selection"]
pub const fn lptim2sel (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Low power timer 2 clock source selection"]
pub fn set_lptim2sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "SAI1 clock source selection"]
pub const fn sai1sel (& self) -> u8 { let val = (self . 0 >> 22usize) & 0x03 ; val as u8 } # [doc = "SAI1 clock source selection"]
pub fn set_sai1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val as u32) & 0x03) << 22usize) ; } # [doc = "48 MHz clock source selection"]
pub const fn clk48sel (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x03 ; val as u8 } # [doc = "48 MHz clock source selection"]
pub fn set_clk48sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 26usize)) | (((val as u32) & 0x03) << 26usize) ; } # [doc = "ADCs clock source selection"]
pub const fn adcsel (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "ADCs clock source selection"]
pub fn set_adcsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } # [doc = "RNG clock source selection"]
pub const fn rngsel (& self) -> u8 { let val = (self . 0 >> 30usize) & 0x03 ; val as u8 } # [doc = "RNG clock source selection"]
pub fn set_rngsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 30usize)) | (((val as u32) & 0x03) << 30usize) ; } } impl Default for Ccipr { fn default () -> Ccipr { Ccipr (0) } } # [doc = "AHB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2rstr (pub u32) ; impl Ahb2rstr { # [doc = "IO port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port H reset"]
pub const fn gpiohrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H reset"]
pub fn set_gpiohrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "ADC reset"]
pub const fn adcrst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "ADC reset"]
pub fn set_adcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "AES1 hardware accelerator reset"]
pub const fn aes1rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AES1 hardware accelerator reset"]
pub fn set_aes1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ahb2rstr { fn default () -> Ahb2rstr { Ahb2rstr (0) } } # [doc = "APB2SMENR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2smenr (pub u32) ; impl Apb2smenr { # [doc = "TIM1 timer clocks enable during CPU1 Sleep mode"]
pub const fn tim1smen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer clocks enable during CPU1 Sleep mode"]
pub fn set_tim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clocks enable during CPU1 Sleep mode"]
pub const fn spi1smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clocks enable during CPU1 Sleep mode"]
pub fn set_spi1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1clocks enable during CPU1 Sleep mode"]
pub const fn usart1smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1clocks enable during CPU1 Sleep mode"]
pub fn set_usart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM16 timer clocks enable during CPU1 Sleep mode"]
pub const fn tim16smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer clocks enable during CPU1 Sleep mode"]
pub fn set_tim16smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer clocks enable during CPU1 Sleep mode"]
pub const fn tim17smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer clocks enable during CPU1 Sleep mode"]
pub fn set_tim17smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SAI1 clocks enable during CPU1 Sleep mode"]
pub const fn sai1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI1 clocks enable during CPU1 Sleep mode"]
pub fn set_sai1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Apb2smenr { fn default () -> Apb2smenr { Apb2smenr (0) } } # [doc = "APB1 peripheral reset register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr2 (pub u32) ; impl Apb1rstr2 { # [doc = "Low-power UART 1 reset"]
pub const fn lpuart1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low-power UART 1 reset"]
pub fn set_lpuart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Low-power timer 2 reset"]
pub const fn lptim2rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Low-power timer 2 reset"]
pub fn set_lptim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Apb1rstr2 { fn default () -> Apb1rstr2 { Apb1rstr2 (0) } } # [doc = "CPU2 APB1 peripheral clocks enable in Sleep and Stop modes register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1smenr2 (pub u32) ; impl C2apb1smenr2 { # [doc = "Low power UART 1 clocks enable during CPU2 Sleep mode"]
pub const fn lpuart1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low power UART 1 clocks enable during CPU2 Sleep mode"]
pub fn set_lpuart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Low power timer 2 clocks enable during CPU2 Sleep mode"]
pub const fn lptim2smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Low power timer 2 clocks enable during CPU2 Sleep mode"]
pub fn set_lptim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for C2apb1smenr2 { fn default () -> C2apb1smenr2 { C2apb1smenr2 (0) } } # [doc = "CPU2 AHB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb2enr (pub u32) ; impl C2ahb2enr { # [doc = "CPU2 IO port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 IO port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU2 IO port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU2 IO port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CPU2 IO port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "CPU2 IO port H clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port H clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "CPU2 ADC clock enable"]
pub const fn adcen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CPU2 ADC clock enable"]
pub fn set_adcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "CPU2 AES1 accelerator clock enable"]
pub const fn aes1en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "CPU2 AES1 accelerator clock enable"]
pub fn set_aes1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for C2ahb2enr { fn default () -> C2ahb2enr { C2ahb2enr (0) } } # [doc = "APB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3rstr (pub u32) ; impl Apb3rstr { # [doc = "Radio system BLE reset"]
pub const fn rfrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Radio system BLE reset"]
pub fn set_rfrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Apb3rstr { fn default () -> Apb3rstr { Apb3rstr (0) } } # [doc = "AHB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1enr (pub u32) ; impl Ahb1enr { # [doc = "DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMAMUX clock enable"]
pub const fn dmamux1en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMAMUX clock enable"]
pub fn set_dmamux1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU1 CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU1 CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Touch Sensing Controller clock enable"]
pub const fn tscen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Touch Sensing Controller clock enable"]
pub fn set_tscen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ahb1enr { fn default () -> Ahb1enr { Ahb1enr (0) } } # [doc = "AHB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1rstr (pub u32) ; impl Ahb1rstr { # [doc = "DMA1 reset"]
pub const fn dma1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 reset"]
pub fn set_dma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 reset"]
pub const fn dma2rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 reset"]
pub fn set_dma2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMAMUX reset"]
pub const fn dmamux1rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMAMUX reset"]
pub fn set_dmamux1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CRC reset"]
pub const fn crcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC reset"]
pub fn set_crcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Touch Sensing Controller reset"]
pub const fn tscrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Touch Sensing Controller reset"]
pub fn set_tscrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ahb1rstr { fn default () -> Ahb1rstr { Ahb1rstr (0) } } # [doc = "AHB1 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1smenr (pub u32) ; impl Ahb1smenr { # [doc = "CPU1 DMA1 clocks enable during Sleep and Stop modes"]
pub const fn dma1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 DMA1 clocks enable during Sleep and Stop modes"]
pub fn set_dma1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU1 DMA2 clocks enable during Sleep and Stop modes"]
pub const fn dma2smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU1 DMA2 clocks enable during Sleep and Stop modes"]
pub fn set_dma2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU1 DMAMUX clocks enable during Sleep and Stop modes"]
pub const fn dmamux1smen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU1 DMAMUX clocks enable during Sleep and Stop modes"]
pub fn set_dmamux1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU1 SRAM1 interface clocks enable during Sleep and Stop modes"]
pub const fn sram1smen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CPU1 SRAM1 interface clocks enable during Sleep and Stop modes"]
pub fn set_sram1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CPU1 CRCSMEN"]
pub const fn crcsmen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU1 CRCSMEN"]
pub fn set_crcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CPU1 Touch Sensing Controller clocks enable during Sleep and Stop modes"]
pub const fn tscsmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "CPU1 Touch Sensing Controller clocks enable during Sleep and Stop modes"]
pub fn set_tscsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ahb1smenr { fn default () -> Ahb1smenr { Ahb1smenr (0) } } # [doc = "Clock interrupt flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cifr (pub u32) ; impl Cifr { # [doc = "LSI1 ready interrupt flag"]
pub const fn lsi1rdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI1 ready interrupt flag"]
pub fn set_lsi1rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSI ready interrupt flag"]
pub const fn msirdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSI ready interrupt flag"]
pub fn set_msirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI ready interrupt flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL ready interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLLSAI1 ready interrupt flag"]
pub const fn pllsai1rdyf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "PLLSAI1 ready interrupt flag"]
pub fn set_pllsai1rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "HSE Clock security system interrupt flag"]
pub const fn hsecssf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "HSE Clock security system interrupt flag"]
pub fn set_hsecssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Clock security system interrupt flag"]
pub const fn lsecssf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Clock security system interrupt flag"]
pub fn set_lsecssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI48 ready interrupt flag"]
pub const fn hsi48rdyf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt flag"]
pub fn set_hsi48rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "LSI2 ready interrupt flag"]
pub const fn lsi2rdyf (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LSI2 ready interrupt flag"]
pub fn set_lsi2rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Cifr { fn default () -> Cifr { Cifr (0) } } # [doc = "Clock interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cier (pub u32) ; impl Cier { # [doc = "LSI1 ready interrupt enable"]
pub const fn lsi1rdyie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI1 ready interrupt enable"]
pub fn set_lsi1rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSI ready interrupt enable"]
pub const fn msirdyie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSI ready interrupt enable"]
pub fn set_msirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI ready interrupt enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLLSYS ready interrupt enable"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLLSYS ready interrupt enable"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLLSAI1 ready interrupt enable"]
pub const fn pllsai1rdyie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "PLLSAI1 ready interrupt enable"]
pub fn set_pllsai1rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LSE clock security system interrupt enable"]
pub const fn lsecssie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE clock security system interrupt enable"]
pub fn set_lsecssie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI48 ready interrupt enable"]
pub const fn hsi48rdyie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt enable"]
pub fn set_hsi48rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "LSI2 ready interrupt enable"]
pub const fn lsi2rdyie (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LSI2 ready interrupt enable"]
pub fn set_lsi2rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Cier { fn default () -> Cier { Cier (0) } } # [doc = "Internal clock sources calibration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icscr (pub u32) ; impl Icscr { # [doc = "MSI clock calibration"]
pub const fn msical (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "MSI clock calibration"]
pub fn set_msical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "MSI clock trimming"]
pub const fn msitrim (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "MSI clock trimming"]
pub fn set_msitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "HSI clock calibration"]
pub const fn hsical (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "HSI clock calibration"]
pub fn set_hsical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "HSI clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "HSI clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Icscr { fn default () -> Icscr { Icscr (0) } } # [doc = "APB1 peripheral reset register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr1 (pub u32) ; impl Apb1rstr1 { # [doc = "TIM2 timer reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LCD interface reset"]
pub const fn lcdrst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LCD interface reset"]
pub fn set_lcdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "SPI2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "I2C1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C3 reset"]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 reset"]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CRS reset"]
pub const fn crsrst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CRS reset"]
pub fn set_crsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "USB FS reset"]
pub const fn usbfsrst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "USB FS reset"]
pub fn set_usbfsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Low Power Timer 1 reset"]
pub const fn lptim1rst (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low Power Timer 1 reset"]
pub fn set_lptim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1rstr1 { fn default () -> Apb1rstr1 { Apb1rstr1 (0) } } # [doc = "CPU2 APB1ENR1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1enr1 (pub u32) ; impl C2apb1enr1 { # [doc = "CPU2 TIM2 timer clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 TIM2 timer clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 LCD clock enable"]
pub const fn lcden (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CPU2 LCD clock enable"]
pub fn set_lcden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CPU2 RTC APB clock enable"]
pub const fn rtcapben (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CPU2 RTC APB clock enable"]
pub fn set_rtcapben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CPU2 SPI2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CPU2 SPI2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "CPU2 I2C1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "CPU2 I2C1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "CPU2 I2C3 clock enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "CPU2 I2C3 clock enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CPU2 CRS clock enable"]
pub const fn crsen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CPU2 CRS clock enable"]
pub fn set_crsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "CPU2 USB clock enable"]
pub const fn usben (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CPU2 USB clock enable"]
pub fn set_usben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "CPU2 Low power timer 1 clock enable"]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "CPU2 Low power timer 1 clock enable"]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for C2apb1enr1 { fn default () -> C2apb1enr1 { C2apb1enr1 (0) } } # [doc = "Clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock switch"]
pub const fn sw (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "System clock switch"]
pub fn set_sw (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "System clock switch status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "System clock switch status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "AHB prescaler"]
pub const fn hpre (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "AHB prescaler"]
pub fn set_hpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "PB low-speed prescaler (APB1)"]
pub const fn ppre1 (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "PB low-speed prescaler (APB1)"]
pub fn set_ppre1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "APB high-speed prescaler (APB2)"]
pub const fn ppre2 (& self) -> u8 { let val = (self . 0 >> 11usize) & 0x07 ; val as u8 } # [doc = "APB high-speed prescaler (APB2)"]
pub fn set_ppre2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 11usize)) | (((val as u32) & 0x07) << 11usize) ; } # [doc = "Wakeup from Stop and CSS backup clock selection"]
pub const fn stopwuck (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Wakeup from Stop and CSS backup clock selection"]
pub fn set_stopwuck (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "AHB prescaler flag"]
pub const fn hpref (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AHB prescaler flag"]
pub fn set_hpref (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "APB1 prescaler flag"]
pub const fn ppre1f (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "APB1 prescaler flag"]
pub fn set_ppre1f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "APB2 prescaler flag"]
pub const fn ppre2f (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "APB2 prescaler flag"]
pub fn set_ppre2f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Microcontroller clock output"]
pub const fn mcosel (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Microcontroller clock output"]
pub fn set_mcosel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "Microcontroller clock output prescaler"]
pub const fn mcopre (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x07 ; val as u8 } # [doc = "Microcontroller clock output prescaler"]
pub fn set_mcopre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val as u32) & 0x07) << 28usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "APB1ENR1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr1 (pub u32) ; impl Apb1enr1 { # [doc = "CPU1 TIM2 timer clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 TIM2 timer clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU1 LCD clock enable"]
pub const fn lcden (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CPU1 LCD clock enable"]
pub fn set_lcden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CPU1 RTC APB clock enable"]
pub const fn rtcapben (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CPU1 RTC APB clock enable"]
pub fn set_rtcapben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CPU1 Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "CPU1 Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CPU1 SPI2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CPU1 SPI2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "CPU1 I2C1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "CPU1 I2C1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "CPU1 I2C3 clock enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "CPU1 I2C3 clock enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CPU1 CRS clock enable"]
pub const fn crsen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CPU1 CRS clock enable"]
pub fn set_crsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "CPU1 USB clock enable"]
pub const fn usben (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CPU1 USB clock enable"]
pub fn set_usben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "CPU1 Low power timer 1 clock enable"]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "CPU1 Low power timer 1 clock enable"]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1enr1 { fn default () -> Apb1enr1 { Apb1enr1 (0) } } # [doc = "APB1 peripheral clocks enable in Sleep and Stop modes register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr2 (pub u32) ; impl Apb1smenr2 { # [doc = "Low power UART 1 clocks enable during CPU1 Sleep mode"]
pub const fn lpuart1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low power UART 1 clocks enable during CPU1 Sleep mode"]
pub fn set_lpuart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Low power timer 2 clocks enable during CPU1 Sleep mode"]
pub const fn lptim2smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Low power timer 2 clocks enable during CPU1 Sleep mode"]
pub fn set_lptim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Apb1smenr2 { fn default () -> Apb1smenr2 { Apb1smenr2 (0) } } # [doc = "CPU2 APB3ENR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb3enr (pub u32) ; impl C2apb3enr { # [doc = "CPU2 BLE interface clock enable"]
pub const fn bleen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 BLE interface clock enable"]
pub fn set_bleen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 802.15.4 interface clock enable"]
pub const fn en802 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU2 802.15.4 interface clock enable"]
pub fn set_en802 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for C2apb3enr { fn default () -> C2apb3enr { C2apb3enr (0) } } # [doc = "AHB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3enr (pub u32) ; impl Ahb3enr { # [doc = "QSPIEN"]
pub const fn qspien (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "QSPIEN"]
pub fn set_qspien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "PKAEN"]
pub const fn pkaen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PKAEN"]
pub fn set_pkaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AES2EN"]
pub const fn aes2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AES2EN"]
pub fn set_aes2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "RNGEN"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "RNGEN"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSEMEN"]
pub const fn hsemen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSEMEN"]
pub fn set_hsemen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "IPCCEN"]
pub const fn ipccen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "IPCCEN"]
pub fn set_ipccen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "FLASHEN"]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "FLASHEN"]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Ahb3enr { fn default () -> Ahb3enr { Ahb3enr (0) } } # [doc = "APB2ENR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "CPU1 TIM1 timer clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "CPU1 TIM1 timer clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CPU1 SPI1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU1 SPI1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CPU1 USART1clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CPU1 USART1clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "CPU1 TIM16 timer clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU1 TIM16 timer clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "CPU1 TIM17 timer clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "CPU1 TIM17 timer clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "CPU1 SAI1 clock enable"]
pub const fn sai1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "CPU1 SAI1 clock enable"]
pub fn set_sai1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "Extended clock recovery register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Extcfgr (pub u32) ; impl Extcfgr { # [doc = "Shared AHB prescaler"]
pub const fn shdhpre (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Shared AHB prescaler"]
pub fn set_shdhpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "CPU2 AHB prescaler"]
pub const fn c2hpre (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "CPU2 AHB prescaler"]
pub fn set_c2hpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "Shared AHB prescaler flag"]
pub const fn shdhpref (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Shared AHB prescaler flag"]
pub fn set_shdhpref (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CPU2 AHB prescaler flag"]
pub const fn c2hpref (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU2 AHB prescaler flag"]
pub fn set_c2hpref (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "RF clock source selected"]
pub const fn rfcss (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "RF clock source selected"]
pub fn set_rfcss (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } } impl Default for Extcfgr { fn default () -> Extcfgr { Extcfgr (0) } } # [doc = "CPU2 AHB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb1enr (pub u32) ; impl C2ahb1enr { # [doc = "CPU2 DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU2 DMAMUX clock enable"]
pub const fn dmamux1en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU2 DMAMUX clock enable"]
pub fn set_dmamux1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU2 SRAM1 clock enable"]
pub const fn sram1en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CPU2 SRAM1 clock enable"]
pub fn set_sram1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CPU2 CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CPU2 CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CPU2 Touch Sensing Controller clock enable"]
pub const fn tscen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "CPU2 Touch Sensing Controller clock enable"]
pub fn set_tscen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for C2ahb1enr { fn default () -> C2ahb1enr { C2ahb1enr (0) } } # [doc = "Clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "MSI clock enable"]
pub const fn msion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "MSI clock enable"]
pub fn set_msion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "MSI clock ready flag"]
pub const fn msirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "MSI clock ready flag"]
pub fn set_msirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSI clock PLL enable"]
pub const fn msipllen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSI clock PLL enable"]
pub fn set_msipllen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "MSI clock ranges"]
pub const fn msirange (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "MSI clock ranges"]
pub fn set_msirange (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "HSI clock enabled"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "HSI clock enabled"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "HSI always enable for peripheral kernels"]
pub const fn hsikeron (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "HSI always enable for peripheral kernels"]
pub fn set_hsikeron (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI clock ready flag"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI clock ready flag"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSI automatic start from Stop"]
pub const fn hsiasfs (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "HSI automatic start from Stop"]
pub fn set_hsiasfs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "HSI kernel clock ready flag for peripherals requests"]
pub const fn hsikerdy (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "HSI kernel clock ready flag for peripherals requests"]
pub fn set_hsikerdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "HSE clock enabled"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSE clock enabled"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSE clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSE clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSE crystal oscillator bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSE crystal oscillator bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSE Clock security system enable"]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSE Clock security system enable"]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "HSE sysclk and PLL M divider prescaler"]
pub const fn hsepre (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "HSE sysclk and PLL M divider prescaler"]
pub fn set_hsepre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Main PLL enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Main PLL enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Main PLL clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Main PLL clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "SAI1 PLL enable"]
pub const fn pllsai1on (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "SAI1 PLL enable"]
pub fn set_pllsai1on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "SAI1 PLL clock ready flag"]
pub const fn pllsai1rdy (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "SAI1 PLL clock ready flag"]
pub fn set_pllsai1rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "CPU2 AHB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb3enr (pub u32) ; impl C2ahb3enr { # [doc = "CPU2 PKAEN"]
pub const fn pkaen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "CPU2 PKAEN"]
pub fn set_pkaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CPU2 AES2EN"]
pub const fn aes2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU2 AES2EN"]
pub fn set_aes2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "CPU2 RNGEN"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "CPU2 RNGEN"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "CPU2 HSEMEN"]
pub const fn hsemen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "CPU2 HSEMEN"]
pub fn set_hsemen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "CPU2 IPCCEN"]
pub const fn ipccen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "CPU2 IPCCEN"]
pub fn set_ipccen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "CPU2 FLASHEN"]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CPU2 FLASHEN"]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for C2ahb3enr { fn default () -> C2ahb3enr { C2ahb3enr (0) } } # [doc = "APB1 peripheral clock enable register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr2 (pub u32) ; impl Apb1enr2 { # [doc = "CPU1 Low power UART 1 clock enable"]
pub const fn lpuart1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 Low power UART 1 clock enable"]
pub fn set_lpuart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU1 LPTIM2EN"]
pub const fn lptim2en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "CPU1 LPTIM2EN"]
pub fn set_lptim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Apb1enr2 { fn default () -> Apb1enr2 { Apb1enr2 (0) } } # [doc = "CPU2 APB2SMENR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb2smenr (pub u32) ; impl C2apb2smenr { # [doc = "TIM1 timer clocks enable during CPU2 Sleep mode"]
pub const fn tim1smen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer clocks enable during CPU2 Sleep mode"]
pub fn set_tim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clocks enable during CPU2 Sleep mode"]
pub const fn spi1smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clocks enable during CPU2 Sleep mode"]
pub fn set_spi1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1clocks enable during CPU2 Sleep mode"]
pub const fn usart1smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1clocks enable during CPU2 Sleep mode"]
pub fn set_usart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM16 timer clocks enable during CPU2 Sleep mode"]
pub const fn tim16smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer clocks enable during CPU2 Sleep mode"]
pub fn set_tim16smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer clocks enable during CPU2 Sleep mode"]
pub const fn tim17smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer clocks enable during CPU2 Sleep mode"]
pub fn set_tim17smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SAI1 clocks enable during CPU2 Sleep mode"]
pub const fn sai1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI1 clocks enable during CPU2 Sleep mode"]
pub fn set_sai1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for C2apb2smenr { fn default () -> C2apb2smenr { C2apb2smenr (0) } } # [doc = "AHB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2enr (pub u32) ; impl Ahb2enr { # [doc = "IO port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port H clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "ADC clock enable"]
pub const fn adcen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "ADC clock enable"]
pub fn set_adcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "AES1 accelerator clock enable"]
pub const fn aes1en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AES1 accelerator clock enable"]
pub fn set_aes1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ahb2enr { fn default () -> Ahb2enr { Ahb2enr (0) } } # [doc = "PLLSAI1 configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllsai1cfgr (pub u32) ; impl Pllsai1cfgr { # [doc = "SAIPLL multiplication factor for VCO"]
pub const fn plln (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x7f ; val as u8 } # [doc = "SAIPLL multiplication factor for VCO"]
pub fn set_plln (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 8usize)) | (((val as u32) & 0x7f) << 8usize) ; } # [doc = "SAIPLL PLLSAI1CLK output enable"]
pub const fn pllpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SAIPLL PLLSAI1CLK output enable"]
pub fn set_pllpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "SAI1PLL division factor P for PLLSAICLK (SAI1clock)"]
pub const fn pllp (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x1f ; val as u8 } # [doc = "SAI1PLL division factor P for PLLSAICLK (SAI1clock)"]
pub fn set_pllp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 17usize)) | (((val as u32) & 0x1f) << 17usize) ; } # [doc = "SAIPLL PLLSAIUSBCLK output enable"]
pub const fn pllqen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SAIPLL PLLSAIUSBCLK output enable"]
pub fn set_pllqen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "SAIPLL division factor Q for PLLSAIUSBCLK (48 MHz clock)"]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x07 ; val as u8 } # [doc = "SAIPLL division factor Q for PLLSAIUSBCLK (48 MHz clock)"]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 25usize)) | (((val as u32) & 0x07) << 25usize) ; } # [doc = "PLLSAI PLLADC1CLK output enable"]
pub const fn pllren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "PLLSAI PLLADC1CLK output enable"]
pub fn set_pllren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "PLLSAI division factor R for PLLADC1CLK (ADC clock)"]
pub const fn pllr (& self) -> u8 { let val = (self . 0 >> 29usize) & 0x07 ; val as u8 } # [doc = "PLLSAI division factor R for PLLADC1CLK (ADC clock)"]
pub fn set_pllr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 29usize)) | (((val as u32) & 0x07) << 29usize) ; } } impl Default for Pllsai1cfgr { fn default () -> Pllsai1cfgr { Pllsai1cfgr (0) } } # [doc = "CPU2 AHB2 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2ahb2smenr (pub u32) ; impl C2ahb2smenr { # [doc = "CPU2 IO port A clocks enable during Sleep and Stop modes"]
pub const fn gpioasmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port A clocks enable during Sleep and Stop modes"]
pub fn set_gpioasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU2 IO port B clocks enable during Sleep and Stop modes"]
pub const fn gpiobsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port B clocks enable during Sleep and Stop modes"]
pub fn set_gpiobsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU2 IO port C clocks enable during Sleep and Stop modes"]
pub const fn gpiocsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port C clocks enable during Sleep and Stop modes"]
pub fn set_gpiocsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU2 IO port D clocks enable during Sleep and Stop modes"]
pub const fn gpiodsmen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port D clocks enable during Sleep and Stop modes"]
pub fn set_gpiodsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CPU2 IO port E clocks enable during Sleep and Stop modes"]
pub const fn gpioesmen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port E clocks enable during Sleep and Stop modes"]
pub fn set_gpioesmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "CPU2 IO port H clocks enable during Sleep and Stop modes"]
pub const fn gpiohsmen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CPU2 IO port H clocks enable during Sleep and Stop modes"]
pub fn set_gpiohsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "CPU2 ADC clocks enable during Sleep and Stop modes"]
pub const fn adcfssmen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CPU2 ADC clocks enable during Sleep and Stop modes"]
pub fn set_adcfssmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "CPU2 AES1 accelerator clocks enable during Sleep and Stop modes"]
pub const fn aes1smen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "CPU2 AES1 accelerator clocks enable during Sleep and Stop modes"]
pub fn set_aes1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for C2ahb2smenr { fn default () -> C2ahb2smenr { C2ahb2smenr (0) } } # [doc = "BDCR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "LSE oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LSE oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "SE oscillator drive capability"]
pub const fn lsedrv (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x03 ; val as u8 } # [doc = "SE oscillator drive capability"]
pub fn set_lsedrv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val as u32) & 0x03) << 3usize) ; } # [doc = "LSECSSON"]
pub const fn lsecsson (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LSECSSON"]
pub fn set_lsecsson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CSS on LSE failure detection"]
pub const fn lsecssd_ (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CSS on LSE failure detection"]
pub fn set_lsecssd_ (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Backup domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Low speed clock output enable"]
pub const fn lscoen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Low speed clock output enable"]
pub fn set_lscoen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Low speed clock output selection"]
pub const fn lscosel (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x03 ; val as u8 } # [doc = "Low speed clock output selection"]
pub fn set_lscosel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 25usize)) | (((val as u32) & 0x03) << 25usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "Clock interrupt clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cicr (pub u32) ; impl Cicr { # [doc = "LSI1 ready interrupt clear"]
pub const fn lsi1rdyc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI1 ready interrupt clear"]
pub fn set_lsi1rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSI ready interrupt clear"]
pub const fn msirdyc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSI ready interrupt clear"]
pub fn set_msirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI ready interrupt clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL ready interrupt clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLLSAI1 ready interrupt clear"]
pub const fn pllsai1rdyc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "PLLSAI1 ready interrupt clear"]
pub fn set_pllsai1rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "HSE Clock security system interrupt clear"]
pub const fn hsecssc (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "HSE Clock security system interrupt clear"]
pub fn set_hsecssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Clock security system interrupt clear"]
pub const fn lsecssc (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Clock security system interrupt clear"]
pub fn set_lsecssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI48 ready interrupt clear"]
pub const fn hsi48rdyc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt clear"]
pub fn set_hsi48rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "LSI2 ready interrupt clear"]
pub const fn lsi2rdyc (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LSI2 ready interrupt clear"]
pub fn set_lsi2rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Cicr { fn default () -> Cicr { Cicr (0) } } # [doc = "Clock recovery RC register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crrcr (pub u32) ; impl Crrcr { # [doc = "HSI48 oscillator enabled"]
pub const fn hsi48on (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "HSI48 oscillator enabled"]
pub fn set_hsi48on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "HSI48 clock ready"]
pub const fn hsi48rdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "HSI48 clock ready"]
pub fn set_hsi48rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI48 clock calibration"]
pub const fn hsi48cal (& self) -> u16 { let val = (self . 0 >> 7usize) & 0x01ff ; val as u16 } # [doc = "HSI48 clock calibration"]
pub fn set_hsi48cal (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 7usize)) | (((val as u32) & 0x01ff) << 7usize) ; } } impl Default for Crrcr { fn default () -> Crrcr { Crrcr (0) } } # [doc = "AHB3 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3smenr (pub u32) ; impl Ahb3smenr { # [doc = "QSPISMEN"]
pub const fn qspismen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "QSPISMEN"]
pub fn set_qspismen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "PKA accelerator clocks enable during CPU1 sleep mode"]
pub const fn pkasmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PKA accelerator clocks enable during CPU1 sleep mode"]
pub fn set_pkasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AES2 accelerator clocks enable during CPU1 sleep mode"]
pub const fn aes2smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AES2 accelerator clocks enable during CPU1 sleep mode"]
pub fn set_aes2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "True RNG clocks enable during CPU1 sleep mode"]
pub const fn rngsmen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "True RNG clocks enable during CPU1 sleep mode"]
pub fn set_rngsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SRAM2a and SRAM2b memory interface clocks enable during CPU1 sleep mode"]
pub const fn sram2smen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SRAM2a and SRAM2b memory interface clocks enable during CPU1 sleep mode"]
pub fn set_sram2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Flash interface clocks enable during CPU1 sleep mode"]
pub const fn flashsmen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Flash interface clocks enable during CPU1 sleep mode"]
pub fn set_flashsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Ahb3smenr { fn default () -> Ahb3smenr { Ahb3smenr (0) } } # [doc = "AHB2 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2smenr (pub u32) ; impl Ahb2smenr { # [doc = "CPU1 IO port A clocks enable during Sleep and Stop modes"]
pub const fn gpioasmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port A clocks enable during Sleep and Stop modes"]
pub fn set_gpioasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CPU1 IO port B clocks enable during Sleep and Stop modes"]
pub const fn gpiobsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port B clocks enable during Sleep and Stop modes"]
pub fn set_gpiobsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "CPU1 IO port C clocks enable during Sleep and Stop modes"]
pub const fn gpiocsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port C clocks enable during Sleep and Stop modes"]
pub fn set_gpiocsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CPU1 IO port D clocks enable during Sleep and Stop modes"]
pub const fn gpiodsmen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port D clocks enable during Sleep and Stop modes"]
pub fn set_gpiodsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CPU1 IO port E clocks enable during Sleep and Stop modes"]
pub const fn gpioesmen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port E clocks enable during Sleep and Stop modes"]
pub fn set_gpioesmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "CPU1 IO port H clocks enable during Sleep and Stop modes"]
pub const fn gpiohsmen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CPU1 IO port H clocks enable during Sleep and Stop modes"]
pub fn set_gpiohsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "CPU1 ADC clocks enable during Sleep and Stop modes"]
pub const fn adcfssmen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CPU1 ADC clocks enable during Sleep and Stop modes"]
pub fn set_adcfssmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "CPU1 AES1 accelerator clocks enable during Sleep and Stop modes"]
pub const fn aes1smen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "CPU1 AES1 accelerator clocks enable during Sleep and Stop modes"]
pub fn set_aes1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ahb2smenr { fn default () -> Ahb2smenr { Ahb2smenr (0) } } # [doc = "Clock HSE register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Hsecr (pub u32) ; impl Hsecr { # [doc = "Register lock system"]
pub const fn unlocked (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Register lock system"]
pub fn set_unlocked (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "HSE Sense amplifier threshold"]
pub const fn hses (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE Sense amplifier threshold"]
pub fn set_hses (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE current control"]
pub const fn hsegmc (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "HSE current control"]
pub fn set_hsegmc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "HSE capacitor tuning"]
pub const fn hsetune (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x3f ; val as u8 } # [doc = "HSE capacitor tuning"]
pub fn set_hsetune (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 8usize)) | (((val as u32) & 0x3f) << 8usize) ; } } impl Default for Hsecr { fn default () -> Hsecr { Hsecr (0) } } # [doc = "CPU2 APB3SMENR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb3smenr (pub u32) ; impl C2apb3smenr { # [doc = "BLE interface clocks enable during CPU2 Sleep mode"]
pub const fn blesmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "BLE interface clocks enable during CPU2 Sleep mode"]
pub fn set_blesmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "802.15.4 interface clocks enable during CPU2 Sleep modes"]
pub const fn smen802 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "802.15.4 interface clocks enable during CPU2 Sleep modes"]
pub fn set_smen802 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for C2apb3smenr { fn default () -> C2apb3smenr { C2apb3smenr (0) } } # [doc = "APB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "TIM1 timer reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM16 timer reset"]
pub const fn tim16rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer reset"]
pub fn set_tim16rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer reset"]
pub const fn tim17rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer reset"]
pub fn set_tim17rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Serial audio interface 1 (SAI1) reset"]
pub const fn sai1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Serial audio interface 1 (SAI1) reset"]
pub fn set_sai1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } }