

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "RCC clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "RCC internal clock sources calibration register 1"]
pub fn icscr1 (self) -> crate :: common :: Reg < regs :: Icscr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "RCC internal clock sources calibration register 2"]
pub fn icscr2 (self) -> crate :: common :: Reg < regs :: Icscr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "RCC internal clock sources calibration register 3"]
pub fn icscr3 (self) -> crate :: common :: Reg < regs :: Icscr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "RCC clock recovery RC register"]
pub fn crrcr (self) -> crate :: common :: Reg < regs :: Crrcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "RCC clock configuration register 1"]
pub fn cfgr1 (self) -> crate :: common :: Reg < regs :: Cfgr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "RCC clock configuration register 2"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "RCC clock configuration register 3"]
pub fn cfgr3 (self) -> crate :: common :: Reg < regs :: Cfgr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "RCC PLL1 configuration register"]
pub fn pll1cfgr (self) -> crate :: common :: Reg < regs :: Pll1cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "RCC PLL2 configuration register"]
pub fn pll2cfgr (self) -> crate :: common :: Reg < regs :: Pll2cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "RCC PLL3 configuration register"]
pub fn pll3cfgr (self) -> crate :: common :: Reg < regs :: Pll3cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "RCC PLL1 dividers register"]
pub fn pll1divr (self) -> crate :: common :: Reg < regs :: Pll1divr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "RCC PLL1 fractional divider register"]
pub fn pll1fracr (self) -> crate :: common :: Reg < regs :: Pll1fracr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "RCC PLL2 dividers configuration register"]
pub fn pll2divr (self) -> crate :: common :: Reg < regs :: Pll2divr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "RCC PLL2 fractional divider register"]
pub fn pll2fracr (self) -> crate :: common :: Reg < regs :: Pll2fracr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "RCC PLL3 dividers configuration register"]
pub fn pll3divr (self) -> crate :: common :: Reg < regs :: Pll3divr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "RCC PLL3 fractional divider register"]
pub fn pll3fracr (self) -> crate :: common :: Reg < regs :: Pll3fracr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "RCC clock interrupt enable register"]
pub fn cier (self) -> crate :: common :: Reg < regs :: Cier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "RCC clock interrupt flag register"]
pub fn cifr (self) -> crate :: common :: Reg < regs :: Cifr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "RCC clock interrupt clear register"]
pub fn cicr (self) -> crate :: common :: Reg < regs :: Cicr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "RCC AHB1 peripheral reset register"]
pub fn ahb1rstr (self) -> crate :: common :: Reg < regs :: Ahb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "RCC AHB2 peripheral reset register 1"]
pub fn ahb2rstr1 (self) -> crate :: common :: Reg < regs :: Ahb2rstr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (100usize)) } } # [doc = "RCC AHB2 peripheral reset register 2"]
pub fn ahb2rstr2 (self) -> crate :: common :: Reg < regs :: Ahb2rstr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (104usize)) } } # [doc = "RCC AHB3 peripheral reset register"]
pub fn ahb3rstr (self) -> crate :: common :: Reg < regs :: Ahb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (108usize)) } } # [doc = "RCC APB1 peripheral reset register 1"]
pub fn apb1rstr1 (self) -> crate :: common :: Reg < regs :: Apb1rstr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (116usize)) } } # [doc = "RCC APB1 peripheral reset register 2"]
pub fn apb1rstr2 (self) -> crate :: common :: Reg < regs :: Apb1rstr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (120usize)) } } # [doc = "RCC APB2 peripheral reset register"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (124usize)) } } # [doc = "RCC APB3 peripheral reset register"]
pub fn apb3rstr (self) -> crate :: common :: Reg < regs :: Apb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "RCC AHB1 peripheral clock enable register"]
pub fn ahb1enr (self) -> crate :: common :: Reg < regs :: Ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "RCC AHB2 peripheral clock enable register 1"]
pub fn ahb2enr1 (self) -> crate :: common :: Reg < regs :: Ahb2enr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (140usize)) } } # [doc = "RCC AHB2 peripheral clock enable register 2"]
pub fn ahb2enr2 (self) -> crate :: common :: Reg < regs :: Ahb2enr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } # [doc = "RCC AHB3 peripheral clock enable register"]
pub fn ahb3enr (self) -> crate :: common :: Reg < regs :: Ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (148usize)) } } # [doc = "RCC APB1 peripheral clock enable register 1"]
pub fn apb1enr1 (self) -> crate :: common :: Reg < regs :: Apb1enr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (156usize)) } } # [doc = "RCC APB1 peripheral clock enable register 2"]
pub fn apb1enr2 (self) -> crate :: common :: Reg < regs :: Apb1enr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (160usize)) } } # [doc = "RCC APB2 peripheral clock enable register"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (164usize)) } } # [doc = "RCC APB3 peripheral clock enable register"]
pub fn apb3enr (self) -> crate :: common :: Reg < regs :: Apb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (168usize)) } } # [doc = "RCC AHB1 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb1smenr (self) -> crate :: common :: Reg < regs :: Ahb1smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (176usize)) } } # [doc = "RCC AHB2 peripheral clocks enable in Sleep and Stop modes register 1"]
pub fn ahb2smenr1 (self) -> crate :: common :: Reg < regs :: Ahb2smenr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (180usize)) } } # [doc = "RCC AHB2 peripheral clocks enable in Sleep and Stop modes register 2"]
pub fn ahb2smenr2 (self) -> crate :: common :: Reg < regs :: Ahb2smenr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (184usize)) } } # [doc = "RCC AHB3 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb3smenr (self) -> crate :: common :: Reg < regs :: Ahb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (188usize)) } } # [doc = "RCC APB1 peripheral clocks enable in Sleep and Stop modes register 1"]
pub fn apb1smenr1 (self) -> crate :: common :: Reg < regs :: Apb1smenr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (196usize)) } } # [doc = "RCC APB1 peripheral clocks enable in Sleep and Stop modes register 2"]
pub fn apb1smenr2 (self) -> crate :: common :: Reg < regs :: Apb1smenr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (200usize)) } } # [doc = "RCC APB2 peripheral clocks enable in Sleep and Stop modes register"]
pub fn apb2smenr (self) -> crate :: common :: Reg < regs :: Apb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (204usize)) } } # [doc = "RCC APB3 peripheral clock enable in Sleep and Stop modes register"]
pub fn apb3smenr (self) -> crate :: common :: Reg < regs :: Apb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (208usize)) } } # [doc = "RCC SmartRun domain peripheral autonomous mode register"]
pub fn srdamr (self) -> crate :: common :: Reg < regs :: Srdamr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (216usize)) } } # [doc = "RCC peripherals independent clock configuration register 1"]
pub fn ccipr1 (self) -> crate :: common :: Reg < regs :: Ccipr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (224usize)) } } # [doc = "RCC peripherals independent clock configuration register 2"]
pub fn ccipr2 (self) -> crate :: common :: Reg < regs :: Ccipr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (228usize)) } } # [doc = "RCC peripherals independent clock configuration register 3"]
pub fn ccipr3 (self) -> crate :: common :: Reg < regs :: Ccipr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (232usize)) } } # [doc = "RCC Backup domain control register"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (240usize)) } } # [doc = "RCC control/status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (244usize)) } } # [doc = "RCC secure configuration register"]
pub fn seccfgr (self) -> crate :: common :: Reg < regs :: Seccfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (272usize)) } } # [doc = "RCC privilege configuration register"]
pub fn privcfgr (self) -> crate :: common :: Reg < regs :: Privcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (276usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Uartsel (pub u8) ; impl Uartsel { # [doc = "PCLK1 selected"]
pub const PCLK1 : Self = Self (0) ; # [doc = "SYSCLK selected"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI16 selected"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "LSE selected"]
pub const LSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adfsel (pub u8) ; impl Adfsel { # [doc = "HCLK selected"]
pub const HCLK : Self = Self (0) ; # [doc = "PLL1 P (pll1_p_ck) selected"]
pub const PLL1_P : Self = Self (0x01) ; # [doc = "PLL3 Q (pll3_q_ck) selected"]
pub const PLL3_Q : Self = Self (0x02) ; # [doc = "input pin AUDIOCLK selected"]
pub const AUDIOCLK : Self = Self (0x03) ; # [doc = "MSIK clock selected"]
pub const MSIK : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usartsel (pub u8) ; impl Usartsel { # [doc = "PCLK2 selected"]
pub const PCLK2 : Self = Self (0) ; # [doc = "SYSCLK selected"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI16 selected"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "LSE selected"]
pub const LSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msirange (pub u8) ; impl Msirange { # [doc = "range 0 around 48 MHz"]
pub const RANGE_48MHZ : Self = Self (0) ; # [doc = "range 1 around 24 MHz"]
pub const RANGE_24MHZ : Self = Self (0x01) ; # [doc = "range 2 around 16 MHz"]
pub const RANGE_16MHZ : Self = Self (0x02) ; # [doc = "range 3 around 12 MHz"]
pub const RANGE_12MHZ : Self = Self (0x03) ; # [doc = "range 4 around 4 MHz (reset value)"]
pub const RANGE_4MHZ : Self = Self (0x04) ; # [doc = "range 5 around 2 MHz"]
pub const RANGE_2MHZ : Self = Self (0x05) ; # [doc = "range 6 around 1.33 MHz"]
pub const RANGE_1_33MHZ : Self = Self (0x06) ; # [doc = "range 7 around 1 MHz"]
pub const RANGE_1MHZ : Self = Self (0x07) ; # [doc = "range 8 around 3.072 MHz"]
pub const RANGE_3_072MHZ : Self = Self (0x08) ; # [doc = "range 9 around 1.536 MHz"]
pub const RANGE_1_536MHZ : Self = Self (0x09) ; # [doc = "range 10 around 1.024 MHz"]
pub const RANGE_1_024MHZ : Self = Self (0x0a) ; # [doc = "range 11 around 768 kHz"]
pub const RANGE_768KHZ : Self = Self (0x0b) ; # [doc = "range 12 around 400 kHz"]
pub const RANGE_400KHZ : Self = Self (0x0c) ; # [doc = "range 13 around 200 kHz"]
pub const RANGE_200KHZ : Self = Self (0x0d) ; # [doc = "range 14 around 133 kHz"]
pub const RANGE_133KHZ : Self = Self (0x0e) ; # [doc = "range 15 around 100 kHz"]
pub const RANGE_100KHZ : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lptimsel (pub u8) ; impl Lptimsel { # [doc = "PCLK1 selected"]
pub const PCLK1 : Self = Self (0) ; # [doc = "LSI selected"]
pub const LSI : Self = Self (0x01) ; # [doc = "HSI16 selected"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "LSE selected"]
pub const LSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mdfsel (pub u8) ; impl Mdfsel { # [doc = "HCLK selected"]
pub const HCLK : Self = Self (0) ; # [doc = "PLL1 P (pll1_p_ck) selected"]
pub const PLL1_P : Self = Self (0x01) ; # [doc = "PLL3 Q (pll3_q_ck) selected"]
pub const PLL3_Q : Self = Self (0x02) ; # [doc = "input pin AUDIOCLK selected"]
pub const AUDIOCLK : Self = Self (0x03) ; # [doc = "MSIK clock selected"]
pub const MSIK : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Timicsel (pub u8) ; impl Timicsel { # [doc = "No sources can be selected by TIM16, TIM17 and LPTIM2 as internal input capture"]
pub const NONE : Self = Self (0) ; # [doc = "HSI/256, MSIS/1024 and MSIS/4 generated and can be selected by TIM16, TIM17 and LPTIM2 as internal input capture"]
pub const HSI256_MSIS1024_MSIS4 : Self = Self (0x04) ; # [doc = "HSI/256, MSIS/1024 and MSIK/4 generated and can be selected by TIM16, TIM17 and LPTIM2 as internal input capture"]
pub const HSI256_MSIS1024_MSIK4 : Self = Self (0x05) ; # [doc = "HSI/256, MSIK/1024 and MSIS/4 generated and can be selected by TIM16, TIM17 and LPTIM2 as internal input capture"]
pub const HSI256_MSIK1024_MSIS4 : Self = Self (0x06) ; # [doc = "HSI/256, MSIK/1024 and MSIK/4 generated and can be selected by TIM16, TIM17 and LPTIM2 as internal input capture"]
pub const HSI256_MSIK1024_MSIK4 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msipllsel (pub u8) ; impl Msipllsel { # [doc = "PLL mode applied to MSIK (MSI kernel) clock output"]
pub const MSIK : Self = Self (0) ; # [doc = "PLL mode applied to MSIS (MSI system) clock output"]
pub const MSIS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsrc (pub u8) ; impl Pllsrc { # [doc = "No clock sent to PLL3"]
pub const NONE : Self = Self (0) ; # [doc = "MSIS clock selected as PLL3 clock entry"]
pub const MSIS : Self = Self (0x01) ; # [doc = "HSI16 clock selected as PLL3 clock entry"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "HSE clock selected as PLL3 clock entry"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsiprediv (pub u8) ; impl Lsiprediv { # [doc = "LSI not divided"]
pub const NONE : Self = Self (0) ; # [doc = "LSI divided by 128"]
pub const DIV_128 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Priv (pub u8) ; impl Priv { # [doc = "Read and write to secure functions can be done by privileged or unprivileged access."]
pub const UNPRIVILEGED : Self = Self (0) ; # [doc = "Read and write to secure functions can be done by privileged access only."]
pub const PRIVILEGED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Security (pub u8) ; impl Security { # [doc = "non secure"]
pub const NON_SECURE : Self = Self (0) ; # [doc = "secure"]
pub const SECURE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcopre (pub u8) ; impl Mcopre { # [doc = "MCO divided by 1"]
pub const NONE : Self = Self (0) ; # [doc = "MCO divided by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "MCO divided by 4"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "MCO divided by 8"]
pub const DIV8 : Self = Self (0x03) ; # [doc = "MCO divided by 16"]
pub const DIV16 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dacsel (pub u8) ; impl Dacsel { # [doc = "LSE selected"]
pub const LSE : Self = Self (0) ; # [doc = "LSI selected"]
pub const LSI : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msirgsel (pub u8) ; impl Msirgsel { # [doc = "MSIS/MSIK ranges provided by MSISSRANGE[3:0]
and MSIKSRANGE[3:0]
in RCC_CSR"]
pub const RCC_CSR : Self = Self (0) ; # [doc = "MSIS/MSIK ranges provided by MSISRANGE[3:0]
and MSIKRANGE[3:0]
in RCC_ICSCR1"]
pub const RCC_ICSCR1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hseext (pub u8) ; impl Hseext { # [doc = "external HSE clock analog mode"]
pub const ANALOG : Self = Self (0) ; # [doc = "external HSE clock digital mode (through I/O Schmitt trigger)"]
pub const DIGITAL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msixsrange (pub u8) ; impl Msixsrange { # [doc = "range 4 around 4M Hz (reset value)"]
pub const RANGE_4MHZ : Self = Self (0x04) ; # [doc = "range 5 around 2 MHz"]
pub const RANGE_2MHZ : Self = Self (0x05) ; # [doc = "range 6 around 1.5 MHz"]
pub const RANGE_1_5MHZ : Self = Self (0x06) ; # [doc = "range 7 around 1 MHz"]
pub const RANGE_1MHZ : Self = Self (0x07) ; # [doc = "range 8 around 3.072 MHz"]
pub const RANGE_3_072MHZ : Self = Self (0x08) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Iclksel (pub u8) ; impl Iclksel { # [doc = "HSI48 clock selected"]
pub const HSI48 : Self = Self (0) ; # [doc = "PLL2 Q (pll2_q_ck) selected"]
pub const PLL2_Q : Self = Self (0x01) ; # [doc = "PLL1 Q (pll1_q_ck) selected"]
pub const PLL1_Q : Self = Self (0x02) ; # [doc = "MSIK clock selected"]
pub const MSIK : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpre (pub u8) ; impl Hpre { # [doc = "SYSCLK not divided"]
pub const NONE : Self = Self (0) ; # [doc = "SYSCLK divided by 2"]
pub const DIV2 : Self = Self (0x08) ; # [doc = "SYSCLK divided by 4"]
pub const DIV4 : Self = Self (0x09) ; # [doc = "SYSCLK divided by 8"]
pub const DIV8 : Self = Self (0x0a) ; # [doc = "SYSCLK divided by 16"]
pub const DIV16 : Self = Self (0x0b) ; # [doc = "SYSCLK divided by 64"]
pub const DIV64 : Self = Self (0x0c) ; # [doc = "SYSCLK divided by 128"]
pub const DIV128 : Self = Self (0x0d) ; # [doc = "SYSCLK divided by 256"]
pub const DIV256 : Self = Self (0x0e) ; # [doc = "SYSCLK divided by 512"]
pub const DIV512 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Stopwuck (pub u8) ; impl Stopwuck { # [doc = "MSIS oscillator selected as wakeup from stop clock and CSS backup clock"]
pub const MSIS : Self = Self (0) ; # [doc = "HSI16 oscillator selected as wakeup from stop clock and CSS backup clock"]
pub const HSI16 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sdmmcsel (pub u8) ; impl Sdmmcsel { # [doc = "ICLK clock selected"]
pub const ICLK : Self = Self (0) ; # [doc = "PLL1 P (pll1_p_ck) selected, in case higher than 48 MHz is needed (for SDR50 mode)"]
pub const PLL1_P : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lscosel (pub u8) ; impl Lscosel { # [doc = "LSI clock selected"]
pub const LSI : Self = Self (0) ; # [doc = "LSE clock selected"]
pub const LSE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ppre (pub u8) ; impl Ppre { # [doc = "HCLK not divided"]
pub const NONE : Self = Self (0) ; # [doc = "HCLK divided by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "HCLK divided by 4"]
pub const DIV4 : Self = Self (0x05) ; # [doc = "HCLK divided by 8"]
pub const DIV8 : Self = Self (0x06) ; # [doc = "HCLK divided by 16"]
pub const DIV16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msipllfast (pub u8) ; impl Msipllfast { # [doc = "MSI PLL normal start-up"]
pub const NORMAL : Self = Self (0) ; # [doc = "MSI PLL fast start-up"]
pub const FAST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllm (pub u8) ; impl Pllm { # [doc = "division by 1 (bypass)"]
pub const BYPASS : Self = Self (0) ; # [doc = "division by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "division by 3"]
pub const DIV3 : Self = Self (0x02) ; # [doc = "division by 16"]
pub const DIV16 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fdcansel (pub u8) ; impl Fdcansel { # [doc = "HSE clock selected"]
pub const HSE : Self = Self (0) ; # [doc = "PLL1 Q (pll1_q_ck) selected"]
pub const PLL1_Q : Self = Self (0x01) ; # [doc = "PLL2 P (pll2_p_ck) selected"]
pub const PLL2_P : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Systicksel (pub u8) ; impl Systicksel { # [doc = "HCLK/8 selected"]
pub const HCLK_DIV8 : Self = Self (0) ; # [doc = "LSI selected"]
pub const LSI : Self = Self (0x01) ; # [doc = "LSE selected"]
pub const LSE : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rngsel (pub u8) ; impl Rngsel { # [doc = "HSI48 selected"]
pub const HSI48 : Self = Self (0) ; # [doc = "HSI48 / 2 selected, can be used in Range 4"]
pub const HSI48_DIV2 : Self = Self (0x01) ; # [doc = "HSI16 selected"]
pub const HSI16 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lpuartsel (pub u8) ; impl Lpuartsel { # [doc = "PCLK3 selected"]
pub const PCLK3 : Self = Self (0) ; # [doc = "SYSCLK selected"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI16 selected"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "LSE selected"]
pub const LSE : Self = Self (0x03) ; # [doc = "MSIK selected"]
pub const MSIK : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Octospisel (pub u8) ; impl Octospisel { # [doc = "SYSCLK selected"]
pub const SYSCLK : Self = Self (0) ; # [doc = "MSIK selected"]
pub const MSIK : Self = Self (0x01) ; # [doc = "PLL1 Q (pll1_q_ck) selected, can be up to 200 MHz"]
pub const PLL1_Q : Self = Self (0x02) ; # [doc = "PLL2 Q (pll2_q_ck) selected, can be up to 200 MHz"]
pub const PLL2_Q : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllrge (pub u8) ; impl Pllrge { # [doc = "PLL2 input (ref2_ck) clock range frequency between 4 and 8 MHz"]
pub const FREQ_4TO8MHZ : Self = Self (0) ; # [doc = "PLL2 input (ref2_ck) clock range frequency between 8 and 16 MHz"]
pub const FREQ_8TO16MHZ : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Saisel (pub u8) ; impl Saisel { # [doc = "PLL2 P (pll2_p_ck) selected"]
pub const PLL2_P : Self = Self (0) ; # [doc = "PLL3 P (pll3_p_ck) selected"]
pub const PLL3_P : Self = Self (0x01) ; # [doc = "PLL1 P (pll1_p_ck) selected"]
pub const PLL1_P : Self = Self (0x02) ; # [doc = "input pin AUDIOCLK selected"]
pub const AUDIOCLK : Self = Self (0x03) ; # [doc = "HSI16 clock selected"]
pub const HSI16 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sw (pub u8) ; impl Sw { # [doc = "MSIS selected as system clock"]
pub const MSIS : Self = Self (0) ; # [doc = "HSI16 selected as system clock"]
pub const HSI16 : Self = Self (0x01) ; # [doc = "HSE selected as system clock"]
pub const HSE : Self = Self (0x02) ; # [doc = "PLL pll1_r_ck selected as system clock"]
pub const PLL1R : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spisel (pub u8) ; impl Spisel { # [doc = "PCLK2 selected"]
pub const PCLK2 : Self = Self (0) ; # [doc = "SYSCLK selected"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI16 selected"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "MSIK selected"]
pub const MSIK : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icsel (pub u8) ; impl Icsel { # [doc = "PCLK1 selected"]
pub const PCLK1 : Self = Self (0) ; # [doc = "SYSCLK selected"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI16 selected"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "MSIK selected"]
pub const MSIK : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllmboost (pub u8) ; impl Pllmboost { # [doc = "division by 1 (bypass)"]
pub const BYPASS : Self = Self (0) ; # [doc = "division by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "division by 4"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "division by 6"]
pub const DIV6 : Self = Self (0x03) ; # [doc = "division by 8"]
pub const DIV8 : Self = Self (0x04) ; # [doc = "division by 10"]
pub const DIV10 : Self = Self (0x05) ; # [doc = "division by 12"]
pub const DIV12 : Self = Self (0x06) ; # [doc = "division by 14"]
pub const DIV14 : Self = Self (0x07) ; # [doc = "division by 16"]
pub const DIV16 : Self = Self (0x08) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcosel (pub u8) ; impl Mcosel { # [doc = "MCO output disabled, no clock on MCO"]
pub const DISABLE : Self = Self (0) ; # [doc = "SYSCLK system clock selected"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "MSIS clock selected"]
pub const MSIS : Self = Self (0x02) ; # [doc = "HSI16 clock selected"]
pub const HSI16 : Self = Self (0x03) ; # [doc = "HSE clock selected"]
pub const HSE : Self = Self (0x04) ; # [doc = "Main PLL clock pll1_r_ck selected"]
pub const PLL1_R : Self = Self (0x05) ; # [doc = "LSI clock selected"]
pub const LSI : Self = Self (0x06) ; # [doc = "LSE clock selected"]
pub const LSE : Self = Self (0x07) ; # [doc = "Internal HSI48 clock selected"]
pub const HSI48 : Self = Self (0x08) ; # [doc = "MSIK clock selected"]
pub const MSIK : Self = Self (0x09) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Saessel (pub u8) ; impl Saessel { # [doc = "SHSI selected"]
pub const SHSI : Self = Self (0) ; # [doc = "SHSI / 2 selected, can be used in Range 4"]
pub const SHSI_DIV2 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Stopkerwuck (pub u8) ; impl Stopkerwuck { # [doc = "MSIK oscillator automatically enabled when exiting Stop mode"]
pub const MSIK : Self = Self (0) ; # [doc = "HSI16 oscillator automatically enabled when exiting Stop mode"]
pub const HSI16 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msibias (pub u8) ; impl Msibias { # [doc = "MSI bias continuous mode (clock accuracy fast settling time)"]
pub const CONTINUOUS : Self = Self (0) ; # [doc = "MSI bias sampling mode (ultra-low-power mode)"]
pub const SAMPLING : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adcdacsel (pub u8) ; impl Adcdacsel { # [doc = "HCLK clock selected"]
pub const HCLK : Self = Self (0) ; # [doc = "SYSCLK selected"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "PLL2 R (pll2_r_ck) selected"]
pub const PLL2_R : Self = Self (0x02) ; # [doc = "HSE clock selected"]
pub const HSE : Self = Self (0x03) ; # [doc = "HSI16 clock selected"]
pub const HSI16 : Self = Self (0x04) ; # [doc = "MSIK clock selected"]
pub const MSI_K : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcsel (pub u8) ; impl Rtcsel { # [doc = "No clock selected"]
pub const NONE : Self = Self (0) ; # [doc = "LSE oscillator clock selected"]
pub const LSE : Self = Self (0x01) ; # [doc = "LSI oscillator clock selected"]
pub const LSI : Self = Self (0x02) ; # [doc = "HSE oscillator clock divided by 32 selected"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsedrv (pub u8) ; impl Lsedrv { # [doc = "'Xtal mode lower driving capability"]
pub const LOW : Self = Self (0) ; # [doc = "'Xtal mode medium-low driving capability"]
pub const MEDIUM_LOW : Self = Self (0x01) ; # [doc = "'Xtal mode medium-high driving capability"]
pub const MEDIUM_HIGH : Self = Self (0x02) ; # [doc = "'Xtal mode higher driving capability"]
pub const HIGH : Self = Self (0x03) ; } } pub mod regs { # [doc = "RCC SmartRun domain peripheral autonomous mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Srdamr (pub u32) ; impl Srdamr { # [doc = "SPI3 autonomous mode enable in Stop 0,1, 2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn spi3amen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SPI3 autonomous mode enable in Stop 0,1, 2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_spi3amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LPUART1 autonomous mode enable in Stop 0,1, 2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lpuart1amen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LPUART1 autonomous mode enable in Stop 0,1, 2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lpuart1amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "I2C3 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn i2c3amen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I2C3 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_i2c3amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LPTIM1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lptim1amen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lptim1amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LPTIM3 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lptim3amen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LPTIM3 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lptim3amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "LPTIM4 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lptim4amen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "LPTIM4 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lptim4amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "OPAMP autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub const fn opampamen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "OPAMP autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub fn set_opampamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "COMP autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub const fn compamen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "COMP autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub fn set_compamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "VREFBUF autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub const fn vrefamen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "VREFBUF autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub fn set_vrefamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "RTC and TAMP autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn rtcapbamen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "RTC and TAMP autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_rtcapbamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "ADC4 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn adc4amen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "ADC4 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_adc4amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "LPGPIO1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub const fn lpgpio1amen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "LPGPIO1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub fn set_lpgpio1amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "DAC1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn dac1amen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "DAC1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_dac1amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "LPDMA1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lpdma1amen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "LPDMA1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lpdma1amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "ADF1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn adf1amen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "ADF1 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_adf1amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "SRAM4 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub const fn sram4amen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM4 autonomous mode enable in Stop 0,1,2 mode Set and cleared by software."]
pub fn set_sram4amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Srdamr { fn default () -> Srdamr { Srdamr (0) } } # [doc = "RCC internal clock sources calibration register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icscr3 (pub u32) ; impl Icscr3 { # [doc = "HSI clock calibration These bits are initialized at startup with the factory-programmed HSI calibration trim value. When HSITRIM is written, HSICAL is updated with the sum of HSITRIM and the factory trim value."]
pub const fn hsical (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "HSI clock calibration These bits are initialized at startup with the factory-programmed HSI calibration trim value. When HSITRIM is written, HSICAL is updated with the sum of HSITRIM and the factory trim value."]
pub fn set_hsical (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "HSI clock trimming These bits provide an additional user-programmable trimming value that is added to the HSICAL[11:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the HSI."]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x1f ; val as u8 } # [doc = "HSI clock trimming These bits provide an additional user-programmable trimming value that is added to the HSICAL[11:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the HSI."]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 16usize)) | (((val as u32) & 0x1f) << 16usize) ; } } impl Default for Icscr3 { fn default () -> Icscr3 { Icscr3 (0) } } # [doc = "RCC APB1 peripheral clock enable register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr1 (pub u32) ; impl Apb1enr1 { # [doc = "TIM2 clock enable Set and cleared by software."]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 clock enable Set and cleared by software."]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 clock enable Set and cleared by software."]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 clock enable Set and cleared by software."]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 clock enable Set and cleared by software."]
pub const fn tim4en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 clock enable Set and cleared by software."]
pub fn set_tim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 clock enable Set and cleared by software."]
pub const fn tim5en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 clock enable Set and cleared by software."]
pub fn set_tim5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 clock enable Set and cleared by software."]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 clock enable Set and cleared by software."]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 clock enable Set and cleared by software."]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 clock enable Set and cleared by software."]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "WWDG clock enable Set by software to enable the window watchdog clock. Reset by hardware system reset. This bit can also be set by hardware if the WWDG_SW option bit is reset."]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "WWDG clock enable Set by software to enable the window watchdog clock. Reset by hardware system reset. This bit can also be set by hardware if the WWDG_SW option bit is reset."]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clock enable Set and cleared by software."]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable Set and cleared by software."]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART2 clock enable Set and cleared by software."]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 clock enable Set and cleared by software."]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clock enable Set and cleared by software."]
pub const fn usart3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clock enable Set and cleared by software."]
pub fn set_usart3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clock enable Set and cleared by software."]
pub const fn uart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clock enable Set and cleared by software."]
pub fn set_uart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clock enable Set and cleared by software."]
pub const fn uart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clock enable Set and cleared by software."]
pub fn set_uart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clock enable Set and cleared by software."]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable Set and cleared by software."]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable Set and cleared by software."]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable Set and cleared by software."]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "CRS clock enable Set and cleared by software."]
pub const fn crsen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CRS clock enable Set and cleared by software."]
pub fn set_crsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Apb1enr1 { fn default () -> Apb1enr1 { Apb1enr1 (0) } } # [doc = "RCC AHB3 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3smenr (pub u32) ; impl Ahb3smenr { # [doc = "LPGPIO1 enable during Sleep and Stop modes Set and cleared by software."]
pub const fn lpgpio1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LPGPIO1 enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_lpgpio1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "PWR clock enable during Sleep and Stop modes Set and cleared by software."]
pub const fn pwrsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "PWR clock enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_pwrsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "ADC4 clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn adc4smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "ADC4 clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_adc4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "DAC1 clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn dac1smen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "DAC1 clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_dac1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LPDMA1 clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lpdma1smen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPDMA1 clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lpdma1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADF1 clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn adf1smen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADF1 clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_adf1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "GTZC2 clock enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gtzc2smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "GTZC2 clock enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gtzc2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SRAM4 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn sram4smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM4 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_sram4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb3smenr { fn default () -> Ahb3smenr { Ahb3smenr (0) } } # [doc = "RCC clock configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr1 (pub u32) ; impl Cfgr1 { # [doc = "system clock switch Set and cleared by software to select system clock source (SYSCLK). Configured by hardware to force MSIS oscillator selection when exiting Standby or Shutdown mode. Configured by hardware to force MSIS or HSI16 oscillator selection when exiting Stop mode or in case of HSE oscillator failure, depending on STOPWUCK value."]
pub const fn sw (& self) -> super :: vals :: Sw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "system clock switch Set and cleared by software to select system clock source (SYSCLK). Configured by hardware to force MSIS oscillator selection when exiting Standby or Shutdown mode. Configured by hardware to force MSIS or HSI16 oscillator selection when exiting Stop mode or in case of HSE oscillator failure, depending on STOPWUCK value."]
pub fn set_sw (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "system clock switch status Set and cleared by hardware to indicate which clock source is used as system clock."]
pub const fn sws (& self) -> super :: vals :: Sw { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "system clock switch status Set and cleared by hardware to indicate which clock source is used as system clock."]
pub fn set_sws (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "wakeup from Stop and CSS backup clock selection Set and cleared by software to select the system clock used when exiting Stop mode. The selected clock is also used as emergency clock for the clock security system on HSE. Warning: STOPWUCK must not be modified when the CSS is enabled by HSECSSON bit in RCC_CR and the system clock is HSE (SWS = 10) or a switch on HSE is requested (SW = 10)."]
pub const fn stopwuck (& self) -> super :: vals :: Stopwuck { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Stopwuck (val as u8) } # [doc = "wakeup from Stop and CSS backup clock selection Set and cleared by software to select the system clock used when exiting Stop mode. The selected clock is also used as emergency clock for the clock security system on HSE. Warning: STOPWUCK must not be modified when the CSS is enabled by HSECSSON bit in RCC_CR and the system clock is HSE (SWS = 10) or a switch on HSE is requested (SW = 10)."]
pub fn set_stopwuck (& mut self , val : super :: vals :: Stopwuck) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "wakeup from Stop kernel clock automatic enable selection Set and cleared by software to enable automatically another oscillator when exiting Stop mode. This oscillator can be used as independent kernel clock by peripherals."]
pub const fn stopkerwuck (& self) -> super :: vals :: Stopkerwuck { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Stopkerwuck (val as u8) } # [doc = "wakeup from Stop kernel clock automatic enable selection Set and cleared by software to enable automatically another oscillator when exiting Stop mode. This oscillator can be used as independent kernel clock by peripherals."]
pub fn set_stopkerwuck (& mut self , val : super :: vals :: Stopkerwuck) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "microcontroller clock output Set and cleared by software. Others: reserved Note: This clock output may have some truncated cycles at startup or during MCO clock source switching."]
pub const fn mcosel (& self) -> super :: vals :: Mcosel { let val = (self . 0 >> 24usize) & 0x0f ; super :: vals :: Mcosel (val as u8) } # [doc = "microcontroller clock output Set and cleared by software. Others: reserved Note: This clock output may have some truncated cycles at startup or during MCO clock source switching."]
pub fn set_mcosel (& mut self , val : super :: vals :: Mcosel) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val . 0 as u32) & 0x0f) << 24usize) ; } # [doc = "microcontroller clock output prescaler Set and cleared by software. It is highly recommended to change this prescaler before MCO output is enabled. Others: not allowed"]
pub const fn mcopre (& self) -> super :: vals :: Mcopre { let val = (self . 0 >> 28usize) & 0x07 ; super :: vals :: Mcopre (val as u8) } # [doc = "microcontroller clock output prescaler Set and cleared by software. It is highly recommended to change this prescaler before MCO output is enabled. Others: not allowed"]
pub fn set_mcopre (& mut self , val : super :: vals :: Mcopre) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val . 0 as u32) & 0x07) << 28usize) ; } } impl Default for Cfgr1 { fn default () -> Cfgr1 { Cfgr1 (0) } } # [doc = "RCC PLL1 fractional divider register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll1fracr (pub u32) ; impl Pll1fracr { # [doc = "Fractional part of the multiplication factor for PLL1 VCO Set and reset by software to control the fractional part of the multiplication factor of the VCO. These bits can be written at any time, allowing dynamic fine-tuning of the PLL1 VCO. VCO output frequency = Fref1_ck x (PLL1N + (PLL1FRACN / 213)), with: PLL1N must be between 4 and 512. PLL1FRACN can be between 0 and 213- 1. The input frequency Fref1_ck must be between 4 and 16 MHz. To change the FRACN value on-the-fly even if the PLL is enabled, the application must proceed as follows: Set the bit PLL1FRACEN to 0. Write the new fractional value into PLL1FRACN. Set the bit PLL1FRACEN to 1."]
pub const fn pllfracn (& self) -> u16 { let val = (self . 0 >> 3usize) & 0x1fff ; val as u16 } # [doc = "Fractional part of the multiplication factor for PLL1 VCO Set and reset by software to control the fractional part of the multiplication factor of the VCO. These bits can be written at any time, allowing dynamic fine-tuning of the PLL1 VCO. VCO output frequency = Fref1_ck x (PLL1N + (PLL1FRACN / 213)), with: PLL1N must be between 4 and 512. PLL1FRACN can be between 0 and 213- 1. The input frequency Fref1_ck must be between 4 and 16 MHz. To change the FRACN value on-the-fly even if the PLL is enabled, the application must proceed as follows: Set the bit PLL1FRACEN to 0. Write the new fractional value into PLL1FRACN. Set the bit PLL1FRACEN to 1."]
pub fn set_pllfracn (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 3usize)) | (((val as u32) & 0x1fff) << 3usize) ; } } impl Default for Pll1fracr { fn default () -> Pll1fracr { Pll1fracr (0) } } # [doc = "RCC privilege configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Privcfgr (pub u32) ; impl Privcfgr { # [doc = "RCC secure functions privilege configuration Set and reset by software. This bit can be written only by a secure privileged access."]
pub const fn spriv (& self) -> super :: vals :: Priv { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Priv (val as u8) } # [doc = "RCC secure functions privilege configuration Set and reset by software. This bit can be written only by a secure privileged access."]
pub fn set_spriv (& mut self , val : super :: vals :: Priv) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "RCC non-secure functions privilege configuration Set and reset by software. This bit can be written only by privileged access, secure or non-secure."]
pub const fn nspriv (& self) -> super :: vals :: Priv { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Priv (val as u8) } # [doc = "RCC non-secure functions privilege configuration Set and reset by software. This bit can be written only by privileged access, secure or non-secure."]
pub fn set_nspriv (& mut self , val : super :: vals :: Priv) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } } impl Default for Privcfgr { fn default () -> Privcfgr { Privcfgr (0) } } # [doc = "RCC Backup domain control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "LSE oscillator enable Set and cleared by software."]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator enable Set and cleared by software."]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE oscillator ready Set and cleared by hardware to indicate when the external 32 kHz oscillator is stable. After the LSEON bit is cleared, LSERDY goes low after six external low-speed oscillator clock cycles."]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator ready Set and cleared by hardware to indicate when the external 32 kHz oscillator is stable. After the LSEON bit is cleared, LSERDY goes low after six external low-speed oscillator clock cycles."]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LSE oscillator bypass Set and cleared by software to bypass oscillator in debug mode. This bit can be written only when the external 32 kHz oscillator is disabled (LSEON = 0 and LSERDY = 0)."]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator bypass Set and cleared by software to bypass oscillator in debug mode. This bit can be written only when the external 32 kHz oscillator is disabled (LSEON = 0 and LSERDY = 0)."]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "LSE oscillator drive capability Set by software to modulate the drive capability of the LSE oscillator. This field can be written only when the external 32 kHz oscillator is disabled (LSEON = 0 and LSERDY = 0). Note: The oscillator is in 'Xtal mode when it is not in bypass mode."]
pub const fn lsedrv (& self) -> super :: vals :: Lsedrv { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Lsedrv (val as u8) } # [doc = "LSE oscillator drive capability Set by software to modulate the drive capability of the LSE oscillator. This field can be written only when the external 32 kHz oscillator is disabled (LSEON = 0 and LSERDY = 0). Note: The oscillator is in 'Xtal mode when it is not in bypass mode."]
pub fn set_lsedrv (& mut self , val : super :: vals :: Lsedrv) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "CSS on LSE enable Set by software to enable the CSS on LSE. LSECSSON must be enabled after the LSE oscillator is enabled (LSEON bit enabled) and ready (LSERDY flag set by hardware), and after the RTCSEL bit is selected. Once enabled, this bit cannot be disabled, except after a LSE failure detection (LSECSSD = 1). In that case, the software must disable the LSECSSON bit."]
pub const fn lsecsson (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "CSS on LSE enable Set by software to enable the CSS on LSE. LSECSSON must be enabled after the LSE oscillator is enabled (LSEON bit enabled) and ready (LSERDY flag set by hardware), and after the RTCSEL bit is selected. Once enabled, this bit cannot be disabled, except after a LSE failure detection (LSECSSD = 1). In that case, the software must disable the LSECSSON bit."]
pub fn set_lsecsson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CSS on LSE failure Detection Set by hardware to indicate when a failure is detected by the CCS on the external 32 kHz oscillator (LSE)."]
pub const fn lsecssd (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CSS on LSE failure Detection Set by hardware to indicate when a failure is detected by the CCS on the external 32 kHz oscillator (LSE)."]
pub fn set_lsecssd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LSE system clock (LSESYS) enable Set by software to enable always the LSE system clock generated by RCC. This clock can be used by any peripheral when its source clock is the LSE or at system level in case of one of the LSCOSEL, MCO, MSI PLL mode or CSS on LSE is needed. The LSESYS clock can be generated even if LSESYSEN= 0 if the LSE clock is requested by the CSS on LSE, by a peripheral or any other source clock using LSE."]
pub const fn lsesysen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "LSE system clock (LSESYS) enable Set by software to enable always the LSE system clock generated by RCC. This clock can be used by any peripheral when its source clock is the LSE or at system level in case of one of the LSCOSEL, MCO, MSI PLL mode or CSS on LSE is needed. The LSESYS clock can be generated even if LSESYSEN= 0 if the LSE clock is requested by the CSS on LSE, by a peripheral or any other source clock using LSE."]
pub fn set_lsesysen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "RTC and TAMP clock source selection Set by software to select the clock source for the RTC and TAMP . Once the RTC and TAMP clock source has been selected, it cannot be changed anymore unless the Backup domain is reset, or unless a failure is detected on LSE (LSECSSD is set). The BDRST bit can be used to reset them."]
pub const fn rtcsel (& self) -> super :: vals :: Rtcsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Rtcsel (val as u8) } # [doc = "RTC and TAMP clock source selection Set by software to select the clock source for the RTC and TAMP . Once the RTC and TAMP clock source has been selected, it cannot be changed anymore unless the Backup domain is reset, or unless a failure is detected on LSE (LSECSSD is set). The BDRST bit can be used to reset them."]
pub fn set_rtcsel (& mut self , val : super :: vals :: Rtcsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "LSE system clock (LSESYS) ready Set and cleared by hardware to indicate when the LSE system clock is stable.When the LSESYSEN bit is set, the LSESYSRDY flag is set after two LSE clock cycles. The LSE clock must be already enabled and stable (LSEON and LSERDY are set). When the LSEON bit is cleared, LSERDY goes low after six external low-speed oscillator clock cycles."]
pub const fn lsesysrdy (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LSE system clock (LSESYS) ready Set and cleared by hardware to indicate when the LSE system clock is stable.When the LSESYSEN bit is set, the LSESYSRDY flag is set after two LSE clock cycles. The LSE clock must be already enabled and stable (LSEON and LSERDY are set). When the LSEON bit is cleared, LSERDY goes low after six external low-speed oscillator clock cycles."]
pub fn set_lsesysrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LSE clock glitch filter enable Set and cleared by hardware to enable the LSE glitch filter. This bit can be written only when the LSE is disabled (LSEON = 0 and LSERDY = 0)"]
pub const fn lsegfon (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LSE clock glitch filter enable Set and cleared by hardware to enable the LSE glitch filter. This bit can be written only when the LSE is disabled (LSEON = 0 and LSERDY = 0)"]
pub fn set_lsegfon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "RTC and TAMP clock enable Set and cleared by software."]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC and TAMP clock enable Set and cleared by software."]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Backup domain software reset Set and cleared by software."]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup domain software reset Set and cleared by software."]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Low-speed clock output (LSCO) enable Set and cleared by software."]
pub const fn lscoen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Low-speed clock output (LSCO) enable Set and cleared by software."]
pub fn set_lscoen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Low-speed clock output selection Set and cleared by software."]
pub const fn lscosel (& self) -> super :: vals :: Lscosel { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Lscosel (val as u8) } # [doc = "Low-speed clock output selection Set and cleared by software."]
pub fn set_lscosel (& mut self , val : super :: vals :: Lscosel) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "LSI oscillator enable Set and cleared by software."]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "LSI oscillator enable Set and cleared by software."]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "LSI oscillator ready Set and cleared by hardware to indicate when the LSI oscillator is stable. After the LSION bit is cleared, LSIRDY goes low after three internal low-speed oscillator clock cycles. This bit is set when the LSI is used by IWDG or RTC, even if LSION = 0."]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "LSI oscillator ready Set and cleared by hardware to indicate when the LSI oscillator is stable. After the LSION bit is cleared, LSIRDY goes low after three internal low-speed oscillator clock cycles. This bit is set when the LSI is used by IWDG or RTC, even if LSION = 0."]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Low-speed clock divider configuration Set and cleared by software to enable the LSI division. This bit can be written only when the LSI is disabled (LSION = 0 and LSIRDY = 0). If the LSI was previously enabled, it is necessary to wait for at least 60 Î¼s after clearing LSION bit (synchronization time for LSI to be really disabled), before writing LSIPREDIV. The LSIPREDIV cannot be changed if the LSI is used by the IWDG or by the RTC."]
pub const fn lsiprediv (& self) -> super :: vals :: Lsiprediv { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: Lsiprediv (val as u8) } # [doc = "Low-speed clock divider configuration Set and cleared by software to enable the LSI division. This bit can be written only when the LSI is disabled (LSION = 0 and LSIRDY = 0). If the LSI was previously enabled, it is necessary to wait for at least 60 Î¼s after clearing LSION bit (synchronization time for LSI to be really disabled), before writing LSIPREDIV. The LSIPREDIV cannot be changed if the LSI is used by the IWDG or by the RTC."]
pub fn set_lsiprediv (& mut self , val : super :: vals :: Lsiprediv) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "RCC APB1 peripheral clocks enable in Sleep and Stop modes register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr2 (pub u32) ; impl Apb1smenr2 { # [doc = "I2C4 clocks enable during Sleep and Stop modes Set and cleared by software Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn i2c4smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "I2C4 clocks enable during Sleep and Stop modes Set and cleared by software Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_i2c4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LPTIM2 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lptim2smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lptim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FDCAN1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn fdcan1smen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "FDCAN1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_fdcan1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "UCPD1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn ucpd1smen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "UCPD1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_ucpd1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Apb1smenr2 { fn default () -> Apb1smenr2 { Apb1smenr2 (0) } } # [doc = "RCC APB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3enr (pub u32) ; impl Apb3enr { # [doc = "SYSCFG clock enable Set and cleared by software."]
pub const fn syscfgen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYSCFG clock enable Set and cleared by software."]
pub fn set_syscfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SPI3 clock enable Set and cleared by software."]
pub const fn spi3en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SPI3 clock enable Set and cleared by software."]
pub fn set_spi3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LPUART1 clock enable Set and cleared by software."]
pub const fn lpuart1en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LPUART1 clock enable Set and cleared by software."]
pub fn set_lpuart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "I2C3 clock enable Set and cleared by software."]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable Set and cleared by software."]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LPTIM1 clock enable Set and cleared by software."]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 clock enable Set and cleared by software."]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LPTIM3 clock enable Set and cleared by software."]
pub const fn lptim3en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LPTIM3 clock enable Set and cleared by software."]
pub fn set_lptim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "LPTIM4 clock enable Set and cleared by software."]
pub const fn lptim4en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "LPTIM4 clock enable Set and cleared by software."]
pub fn set_lptim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "OPAMP clock enable Set and cleared by software."]
pub const fn opampen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "OPAMP clock enable Set and cleared by software."]
pub fn set_opampen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "COMP clock enable Set and cleared by software."]
pub const fn compen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "COMP clock enable Set and cleared by software."]
pub fn set_compen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "VREFBUF clock enable Set and cleared by software."]
pub const fn vrefen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "VREFBUF clock enable Set and cleared by software."]
pub fn set_vrefen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "RTC and TAMP APB clock enable Set and cleared by software."]
pub const fn rtcapben (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "RTC and TAMP APB clock enable Set and cleared by software."]
pub fn set_rtcapben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Apb3enr { fn default () -> Apb3enr { Apb3enr (0) } } # [doc = "RCC AHB2 peripheral clock enable register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2enr1 (pub u32) ; impl Ahb2enr1 { # [doc = "IO port A clock enable Set and cleared by software."]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable Set and cleared by software."]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable Set and cleared by software."]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable Set and cleared by software."]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable Set and cleared by software."]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable Set and cleared by software."]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clock enable Set and cleared by software."]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clock enable Set and cleared by software."]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clock enable Set and cleared by software."]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clock enable Set and cleared by software."]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F clock enable Set and cleared by software."]
pub const fn gpiofen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F clock enable Set and cleared by software."]
pub fn set_gpiofen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G clock enable Set and cleared by software."]
pub const fn gpiogen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G clock enable Set and cleared by software."]
pub fn set_gpiogen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H clock enable Set and cleared by software."]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable Set and cleared by software."]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I clock enable Set and cleared by software."]
pub const fn gpioien (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I clock enable Set and cleared by software."]
pub fn set_gpioien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC1 clock enable Set and cleared by software."]
pub const fn adc1en (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC1 clock enable Set and cleared by software."]
pub fn set_adc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "DCMI and PSSI clock enable Set and cleared by software."]
pub const fn dcmien (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "DCMI and PSSI clock enable Set and cleared by software."]
pub fn set_dcmien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "OTG_FS clock enable Set and cleared by software."]
pub const fn usb_otg_fsen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "OTG_FS clock enable Set and cleared by software."]
pub fn set_usb_otg_fsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "AES clock enable Set and cleared by software."]
pub const fn aesen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AES clock enable Set and cleared by software."]
pub fn set_aesen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HASH clock enable Set and cleared by software"]
pub const fn hashen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HASH clock enable Set and cleared by software"]
pub fn set_hashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "RNG clock enable Set and cleared by software."]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "RNG clock enable Set and cleared by software."]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "PKA clock enable Set and cleared by software."]
pub const fn pkaen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "PKA clock enable Set and cleared by software."]
pub fn set_pkaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "SAES clock enable Set and cleared by software."]
pub const fn saesen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SAES clock enable Set and cleared by software."]
pub fn set_saesen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "OCTOSPIM clock enable Set and cleared by software."]
pub const fn octospimen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "OCTOSPIM clock enable Set and cleared by software."]
pub fn set_octospimen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "OTFDEC1 clock enable Set and cleared by software."]
pub const fn otfdec1en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "OTFDEC1 clock enable Set and cleared by software."]
pub fn set_otfdec1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "OTFDEC2 clock enable Set and cleared by software."]
pub const fn otfdec2en (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "OTFDEC2 clock enable Set and cleared by software."]
pub fn set_otfdec2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "SDMMC1 clock enable Set and cleared by software."]
pub const fn sdmmc1en (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 clock enable Set and cleared by software."]
pub fn set_sdmmc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "SDMMC2 clock enable Set and cleared by software."]
pub const fn sdmmc2en (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 clock enable Set and cleared by software."]
pub fn set_sdmmc2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "SRAM2 clock enable Set and reset by software."]
pub const fn sram2en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "SRAM2 clock enable Set and reset by software."]
pub fn set_sram2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "SRAM3 clock enable Set and reset by software."]
pub const fn sram3en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM3 clock enable Set and reset by software."]
pub fn set_sram3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb2enr1 { fn default () -> Ahb2enr1 { Ahb2enr1 (0) } } # [doc = "RCC PLL2 fractional divider register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll2fracr (pub u32) ; impl Pll2fracr { # [doc = "Fractional part of the multiplication factor for PLL2 VCO Set and reset by software to control the fractional part of the multiplication factor of the VCO. These bits can be written at any time, allowing dynamic fine-tuning of the PLL2 VCO. VCO output frequency = Fref2_ck x (PLL2N + (PLL2FRACN / 213)), with PLL2N must be between 4 and 512. PLL2FRACN can be between 0 and 213 - 1. The input frequency Fref2_ck must be between 4 and 16 MHz. In order to change the FRACN value on-the-fly even if the PLL is enabled, the application must proceed as follows: Set the bit PLL2FRACEN to 0. Write the new fractional value into PLL2FRACN. Set the bit PLL2FRACEN to 1."]
pub const fn pllfracn (& self) -> u16 { let val = (self . 0 >> 3usize) & 0x1fff ; val as u16 } # [doc = "Fractional part of the multiplication factor for PLL2 VCO Set and reset by software to control the fractional part of the multiplication factor of the VCO. These bits can be written at any time, allowing dynamic fine-tuning of the PLL2 VCO. VCO output frequency = Fref2_ck x (PLL2N + (PLL2FRACN / 213)), with PLL2N must be between 4 and 512. PLL2FRACN can be between 0 and 213 - 1. The input frequency Fref2_ck must be between 4 and 16 MHz. In order to change the FRACN value on-the-fly even if the PLL is enabled, the application must proceed as follows: Set the bit PLL2FRACEN to 0. Write the new fractional value into PLL2FRACN. Set the bit PLL2FRACEN to 1."]
pub fn set_pllfracn (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 3usize)) | (((val as u32) & 0x1fff) << 3usize) ; } } impl Default for Pll2fracr { fn default () -> Pll2fracr { Pll2fracr (0) } } # [doc = "RCC AHB2 peripheral clocks enable in Sleep and Stop modes register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2smenr1 (pub u32) ; impl Ahb2smenr1 { # [doc = "IO port A clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpioasmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpioasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpiobsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpiobsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpiocsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpiocsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpiodsmen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpiodsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpioesmen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpioesmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpiofsmen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpiofsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpiogsmen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpiogsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpiohsmen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpiohsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gpioismen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gpioismen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn adc1smen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_adc1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "DCMI and PSSI clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn dcmismen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "DCMI and PSSI clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_dcmismen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "OTG_FS clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn usb_otg_fssmen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "OTG_FS clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_usb_otg_fssmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "AES clock enable during Sleep and Stop modes Set and cleared by software"]
pub const fn aessmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AES clock enable during Sleep and Stop modes Set and cleared by software"]
pub fn set_aessmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HASH clock enable during Sleep and Stop modes Set and cleared by software"]
pub const fn hashsmen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HASH clock enable during Sleep and Stop modes Set and cleared by software"]
pub fn set_hashsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Random number generator (RNG) clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn rngsmen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Random number generator (RNG) clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_rngsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "PKA clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn pkasmen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "PKA clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_pkasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "SAES accelerator clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn saessmen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SAES accelerator clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_saessmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "OCTOSPIM clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn octospimsmen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "OCTOSPIM clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_octospimsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "OTFDEC1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn otfdec1smen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "OTFDEC1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_otfdec1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "OTFDEC2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn otfdec2smen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "OTFDEC2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_otfdec2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "SDMMC1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn sdmmc1smen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_sdmmc1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "SDMMC2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn sdmmc2smen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_sdmmc2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "SRAM2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn sram2smen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "SRAM2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_sram2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "SRAM3 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn sram3smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM3 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_sram3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb2smenr1 { fn default () -> Ahb2smenr1 { Ahb2smenr1 (0) } } # [doc = "RCC APB1 peripheral reset register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr2 (pub u32) ; impl Apb1rstr2 { # [doc = "I2C4 reset Set and cleared by software"]
pub const fn i2c4rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "I2C4 reset Set and cleared by software"]
pub fn set_i2c4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LPTIM2 reset Set and cleared by software."]
pub const fn lptim2rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 reset Set and cleared by software."]
pub fn set_lptim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FDCAN1 reset Set and cleared by software."]
pub const fn fdcan1rst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "FDCAN1 reset Set and cleared by software."]
pub fn set_fdcan1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "UCPD1 reset Set and cleared by software."]
pub const fn ucpd1rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "UCPD1 reset Set and cleared by software."]
pub fn set_ucpd1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Apb1rstr2 { fn default () -> Apb1rstr2 { Apb1rstr2 (0) } } # [doc = "RCC PLL3 dividers configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll3divr (pub u32) ; impl Pll3divr { # [doc = "Multiplication factor for PLL3 VCO Set and reset by software to control the multiplication factor of the VCO. These bits can be written only when the PLL is disabled (PLL3ON = 0 and PLL3RDY = 0). ... ... Others: reserved VCO output frequency = Fref3_ck x PLL3N, when fractional value 0 has been loaded into PLL3FRACN, with: PLL3N between 4 and 512 input frequency Fref3_ck between 4 and 16MHz"]
pub const fn plln (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Multiplication factor for PLL3 VCO Set and reset by software to control the multiplication factor of the VCO. These bits can be written only when the PLL is disabled (PLL3ON = 0 and PLL3RDY = 0). ... ... Others: reserved VCO output frequency = Fref3_ck x PLL3N, when fractional value 0 has been loaded into PLL3FRACN, with: PLL3N between 4 and 512 input frequency Fref3_ck between 4 and 16MHz"]
pub fn set_plln (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "PLL3 DIVP division factor Set and reset by software to control the frequency of the pll3_p_ck clock. These bits can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0). ..."]
pub const fn pllp (& self) -> u8 { let val = (self . 0 >> 9usize) & 0x7f ; val as u8 } # [doc = "PLL3 DIVP division factor Set and reset by software to control the frequency of the pll3_p_ck clock. These bits can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0). ..."]
pub fn set_pllp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 9usize)) | (((val as u32) & 0x7f) << 9usize) ; } # [doc = "PLL3 DIVQ division factor Set and reset by software to control the frequency of the pll3_q_ck clock. These bits can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0). ..."]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "PLL3 DIVQ division factor Set and reset by software to control the frequency of the pll3_q_ck clock. These bits can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0). ..."]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } # [doc = "PLL3 DIVR division factor Set and reset by software to control the frequency of the pll3_r_ck clock. These bits can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0). ..."]
pub const fn pllr (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "PLL3 DIVR division factor Set and reset by software to control the frequency of the pll3_r_ck clock. These bits can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0). ..."]
pub fn set_pllr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Pll3divr { fn default () -> Pll3divr { Pll3divr (0) } } # [doc = "RCC APB2 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2smenr (pub u32) ; impl Apb2smenr { # [doc = "TIM1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim1smen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn spi1smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_spi1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim8smen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim8smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn usart1smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_usart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM15 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim15smen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim15smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim16smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim16smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim17smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim17smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SAI1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn sai1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_sai1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SAI2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn sai2smen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_sai2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb2smenr { fn default () -> Apb2smenr { Apb2smenr (0) } } # [doc = "RCC clock recovery RC register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crrcr (pub u32) ; impl Crrcr { # [doc = "HSI48 clock calibration These bits are initialized at startup with the factory-programmed HSI48 calibration trim value."]
pub const fn hsi48cal (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "HSI48 clock calibration These bits are initialized at startup with the factory-programmed HSI48 calibration trim value."]
pub fn set_hsi48cal (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } } impl Default for Crrcr { fn default () -> Crrcr { Crrcr (0) } } # [doc = "RCC APB1 peripheral clocks enable in Sleep and Stop modes register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr1 (pub u32) ; impl Apb1smenr1 { # [doc = "TIM2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim2smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim3smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim4smen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim5smen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim5smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim6smen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim6smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tim7smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tim7smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Window watchdog clocks enable during Sleep and Stop modes Set and cleared by software. This bit is forced to 1 by hardware when the hardware WWDG option is activated."]
pub const fn wwdgsmen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clocks enable during Sleep and Stop modes Set and cleared by software. This bit is forced to 1 by hardware when the hardware WWDG option is activated."]
pub fn set_wwdgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn spi2smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_spi2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART2 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn usart2smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_usart2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn usart3smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_usart3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn uart4smen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_uart4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn uart5smen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_uart5smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn i2c1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_i2c1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn i2c2smen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_i2c2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "CRS clock enable during Sleep and Stop modes Set and cleared by software."]
pub const fn crssmen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CRS clock enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_crssmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Apb1smenr1 { fn default () -> Apb1smenr1 { Apb1smenr1 (0) } } # [doc = "RCC PLL3 configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll3cfgr (pub u32) ; impl Pll3cfgr { # [doc = "PLL3 entry clock source Set and cleared by software to select PLL3 clock source. These bits can be written only when the PLL3 is disabled. In order to save power, when no PLL3 is used, the value of PLL3SRC must be 00."]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Pllsrc (val as u8) } # [doc = "PLL3 entry clock source Set and cleared by software to select PLL3 clock source. These bits can be written only when the PLL3 is disabled. In order to save power, when no PLL3 is used, the value of PLL3SRC must be 00."]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "PLL3 input frequency range Set and reset by software to select the proper reference frequency range used for PLL3. This bit must be written before enabling the PLL3. 00-01-10: PLL3 input (ref3_ck) clock range frequency between 4 and 8 MHz"]
pub const fn pllrge (& self) -> super :: vals :: Pllrge { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Pllrge (val as u8) } # [doc = "PLL3 input frequency range Set and reset by software to select the proper reference frequency range used for PLL3. This bit must be written before enabling the PLL3. 00-01-10: PLL3 input (ref3_ck) clock range frequency between 4 and 8 MHz"]
pub fn set_pllrge (& mut self , val : super :: vals :: Pllrge) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "PLL3 fractional latch enable Set and reset by software to latch the content of PLL3FRACN into the Î£Î modulator. In order to latch the PLL3FRACN value into the Î£Î modulator, PLL3FRACEN must be set to 0, then set to 1: the transition 0 to 1 transfers the content of PLL3FRACN into the modulator (see for details)."]
pub const fn pllfracen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL3 fractional latch enable Set and reset by software to latch the content of PLL3FRACN into the Î£Î modulator. In order to latch the PLL3FRACN value into the Î£Î modulator, PLL3FRACEN must be set to 0, then set to 1: the transition 0 to 1 transfers the content of PLL3FRACN into the modulator (see for details)."]
pub fn set_pllfracen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Prescaler for PLL3 Set and cleared by software to configure the prescaler of the PLL3. The VCO3 input frequency is PLL3 input clock frequency/PLL3M. This bit can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0). ..."]
pub const fn pllm (& self) -> super :: vals :: Pllm { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Pllm (val as u8) } # [doc = "Prescaler for PLL3 Set and cleared by software to configure the prescaler of the PLL3. The VCO3 input frequency is PLL3 input clock frequency/PLL3M. This bit can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0). ..."]
pub fn set_pllm (& mut self , val : super :: vals :: Pllm) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } # [doc = "PLL3 DIVP divider output enable Set and reset by software to enable the pll3_p_ck output of the PLL3. To save power, PLL3PEN and PLL3P bits must be set to 0 when the pll3_p_ck is not used. This bit can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0)."]
pub const fn pllpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PLL3 DIVP divider output enable Set and reset by software to enable the pll3_p_ck output of the PLL3. To save power, PLL3PEN and PLL3P bits must be set to 0 when the pll3_p_ck is not used. This bit can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0)."]
pub fn set_pllpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "PLL3 DIVQ divider output enable Set and reset by software to enable the pll3_q_ck output of the PLL3. To save power, PLL3QEN and PLL3Q bits must be set to 0 when the pll3_q_ck is not used. This bit can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0)."]
pub fn pllqen (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 17usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL3 DIVQ divider output enable Set and reset by software to enable the pll3_q_ck output of the PLL3. To save power, PLL3QEN and PLL3Q bits must be set to 0 when the pll3_q_ck is not used. This bit can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0)."]
pub fn set_pllqen (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 17usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "PLL3 DIVR divider output enable Set and reset by software to enable the pll3_r_ck output of the PLL3. To save power, PLL3REN and PLL3R bits must be set to 0 when the pll3_r_ck is not used. This bit can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0)."]
pub const fn pllren (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "PLL3 DIVR divider output enable Set and reset by software to enable the pll3_r_ck output of the PLL3. To save power, PLL3REN and PLL3R bits must be set to 0 when the pll3_r_ck is not used. This bit can be written only when the PLL3 is disabled (PLL3ON = 0 and PLL3RDY = 0)."]
pub fn set_pllren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Pll3cfgr { fn default () -> Pll3cfgr { Pll3cfgr (0) } } # [doc = "RCC clock interrupt flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cifr (pub u32) ; impl Cifr { # [doc = "LSI ready interrupt flag Set by hardware when the LSI clock becomes stable and LSIRDYIE is set. Cleared by software setting the LSIRDYC bit."]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt flag Set by hardware when the LSI clock becomes stable and LSIRDYIE is set. Cleared by software setting the LSIRDYC bit."]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt flag Set by hardware when the LSE clock becomes stable and LSERDYIE is set. Cleared by software setting the LSERDYC bit."]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt flag Set by hardware when the LSE clock becomes stable and LSERDYIE is set. Cleared by software setting the LSERDYC bit."]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSIS ready interrupt flag Set by hardware when the MSIS clock becomes stable and MSISRDYIE is set. Cleared by software setting the MSISRDYC bit."]
pub const fn msisrdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSIS ready interrupt flag Set by hardware when the MSIS clock becomes stable and MSISRDYIE is set. Cleared by software setting the MSISRDYC bit."]
pub fn set_msisrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI16 ready interrupt flag Set by hardware when the HSI16 clock becomes stable and HSIRDYIE is set in a response to setting the HSION (see RCC_CR). When HSION is not set but the HSI16 oscillator is enabled by the peripheral through a clock request, this bit is not set and no interrupt is generated. Cleared by software setting the HSIRDYC bit."]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready interrupt flag Set by hardware when the HSI16 clock becomes stable and HSIRDYIE is set in a response to setting the HSION (see RCC_CR). When HSION is not set but the HSI16 oscillator is enabled by the peripheral through a clock request, this bit is not set and no interrupt is generated. Cleared by software setting the HSIRDYC bit."]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt flag Set by hardware when the HSE clock becomes stable and HSERDYIE is set. Cleared by software setting the HSERDYC bit."]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt flag Set by hardware when the HSE clock becomes stable and HSERDYIE is set. Cleared by software setting the HSERDYC bit."]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "HSI48 ready interrupt flag Set by hardware when the HSI48 clock becomes stable and HSI48RDYIE is set. Cleared by software setting the HSI48RDYC bit."]
pub const fn hsi48rdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt flag Set by hardware when the HSI48 clock becomes stable and HSI48RDYIE is set. Cleared by software setting the HSI48RDYC bit."]
pub fn set_hsi48rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLL1 ready interrupt flag Set by hardware when the PLL1 locks and PLL1RDYIE is set. Cleared by software setting the PLL1RDYC bit."]
pub fn pllrdyf (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 ready interrupt flag Set by hardware when the PLL1 locks and PLL1RDYIE is set. Cleared by software setting the PLL1RDYC bit."]
pub fn set_pllrdyf (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Clock security system interrupt flag Set by hardware when a failure is detected in the HSE oscillator. Cleared by software setting the CSSC bit."]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt flag Set by hardware when a failure is detected in the HSE oscillator. Cleared by software setting the CSSC bit."]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "MSIK ready interrupt flag Set by hardware when the MSIK clock becomes stable and MSIKRDYIE is set. Cleared by software setting the MSIKRDYC bit."]
pub const fn msikrdyf (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "MSIK ready interrupt flag Set by hardware when the MSIK clock becomes stable and MSIKRDYIE is set. Cleared by software setting the MSIKRDYC bit."]
pub fn set_msikrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SHSI ready interrupt flag Set by hardware when the SHSI clock becomes stable and SHSIRDYIE is set. Cleared by software setting the SHSIRDYC bit."]
pub const fn shsirdyf (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SHSI ready interrupt flag Set by hardware when the SHSI clock becomes stable and SHSIRDYIE is set. Cleared by software setting the SHSIRDYC bit."]
pub fn set_shsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Cifr { fn default () -> Cifr { Cifr (0) } } # [doc = "RCC APB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3rstr (pub u32) ; impl Apb3rstr { # [doc = "SYSCFG reset Set and cleared by software."]
pub const fn syscfgrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYSCFG reset Set and cleared by software."]
pub fn set_syscfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SPI3 reset Set and cleared by software."]
pub const fn spi3rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SPI3 reset Set and cleared by software."]
pub fn set_spi3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LPUART1 reset Set and cleared by software."]
pub const fn lpuart1rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LPUART1 reset Set and cleared by software."]
pub fn set_lpuart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "I2C3 reset Set and cleared by software."]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I2C3 reset Set and cleared by software."]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LPTIM1 reset Set and cleared by software."]
pub const fn lptim1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 reset Set and cleared by software."]
pub fn set_lptim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LPTIM3 reset Set and cleared by software."]
pub const fn lptim3rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LPTIM3 reset Set and cleared by software."]
pub fn set_lptim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "LPTIM4 reset Set and cleared by software."]
pub const fn lptim4rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "LPTIM4 reset Set and cleared by software."]
pub fn set_lptim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "OPAMP reset Set and cleared by software."]
pub const fn opamprst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "OPAMP reset Set and cleared by software."]
pub fn set_opamprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "COMP reset Set and cleared by software."]
pub const fn comprst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "COMP reset Set and cleared by software."]
pub fn set_comprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "VREFBUF reset Set and cleared by software."]
pub const fn vrefrst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "VREFBUF reset Set and cleared by software."]
pub fn set_vrefrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } } impl Default for Apb3rstr { fn default () -> Apb3rstr { Apb3rstr (0) } } # [doc = "RCC APB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "TIM1 reset Set and cleared by software."]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 reset Set and cleared by software."]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 reset Set and cleared by software."]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 reset Set and cleared by software."]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 reset Set and cleared by software."]
pub const fn tim8rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 reset Set and cleared by software."]
pub fn set_tim8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1 reset Set and cleared by software."]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 reset Set and cleared by software."]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM15 reset Set and cleared by software."]
pub const fn tim15rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 reset Set and cleared by software."]
pub fn set_tim15rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 reset Set and cleared by software."]
pub const fn tim16rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 reset Set and cleared by software."]
pub fn set_tim16rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 reset Set and cleared by software."]
pub const fn tim17rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 reset Set and cleared by software."]
pub fn set_tim17rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SAI1 reset Set and cleared by software."]
pub const fn sai1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI1 reset Set and cleared by software."]
pub fn set_sai1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SAI2 reset Set and cleared by software."]
pub const fn sai2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI2 reset Set and cleared by software."]
pub fn set_sai2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "RCC PLL2 configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll2cfgr (pub u32) ; impl Pll2cfgr { # [doc = "PLL2 entry clock source Set and cleared by software to select PLL2 clock source. These bits can be written only when the PLL2 is disabled. In order to save power, when no PLL2 is used, the value of PLL2SRC must be 0."]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Pllsrc (val as u8) } # [doc = "PLL2 entry clock source Set and cleared by software to select PLL2 clock source. These bits can be written only when the PLL2 is disabled. In order to save power, when no PLL2 is used, the value of PLL2SRC must be 0."]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "PLL2 input frequency range Set and reset by software to select the proper reference frequency range used for PLL2. This bit must be written before enabling the PLL2. 00-01-10: PLL2 input (ref2_ck) clock range frequency between 4 and 8 MHz"]
pub const fn pllrge (& self) -> super :: vals :: Pllrge { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Pllrge (val as u8) } # [doc = "PLL2 input frequency range Set and reset by software to select the proper reference frequency range used for PLL2. This bit must be written before enabling the PLL2. 00-01-10: PLL2 input (ref2_ck) clock range frequency between 4 and 8 MHz"]
pub fn set_pllrge (& mut self , val : super :: vals :: Pllrge) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "PLL2 fractional latch enable Set and reset by software to latch the content of PLL2FRACN into the Î£Î modulator. In order to latch the PLL2FRACN value into the Î£Î modulator, PLL2FRACEN must be set to 0, then set to 1: the transition 0 to 1 transfers the content of PLL2FRACN into the modulator (see for details)."]
pub const fn pllfracen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL2 fractional latch enable Set and reset by software to latch the content of PLL2FRACN into the Î£Î modulator. In order to latch the PLL2FRACN value into the Î£Î modulator, PLL2FRACEN must be set to 0, then set to 1: the transition 0 to 1 transfers the content of PLL2FRACN into the modulator (see for details)."]
pub fn set_pllfracen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Prescaler for PLL2 Set and cleared by software to configure the prescaler of the PLL2. The VCO2 input frequency is PLL2 input clock frequency/PLL2M. This bit can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0). ..."]
pub const fn pllm (& self) -> super :: vals :: Pllm { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Pllm (val as u8) } # [doc = "Prescaler for PLL2 Set and cleared by software to configure the prescaler of the PLL2. The VCO2 input frequency is PLL2 input clock frequency/PLL2M. This bit can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0). ..."]
pub fn set_pllm (& mut self , val : super :: vals :: Pllm) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } # [doc = "PLL2 DIVP divider output enable Set and reset by software to enable the pll2_p_ck output of the PLL2. To save power, PLL2PEN and PLL2P bits must be set to 0 when the pll2_p_ck is not used. This bit can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0)."]
pub const fn pllpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PLL2 DIVP divider output enable Set and reset by software to enable the pll2_p_ck output of the PLL2. To save power, PLL2PEN and PLL2P bits must be set to 0 when the pll2_p_ck is not used. This bit can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0)."]
pub fn set_pllpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "PLL2 DIVQ divider output enable Set and reset by software to enable the pll2_q_ck output of the PLL2. To save power, PLL2QEN and PLL2Q bits must be set to 0 when the pll2_q_ck is not used. This bit can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0."]
pub const fn pllqen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "PLL2 DIVQ divider output enable Set and reset by software to enable the pll2_q_ck output of the PLL2. To save power, PLL2QEN and PLL2Q bits must be set to 0 when the pll2_q_ck is not used. This bit can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0."]
pub fn set_pllqen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "PLL2 DIVR divider output enable Set and reset by software to enable the pll2_r_ck output of the PLL2. To save power, PLL2REN and PLL2R bits must be set to 0 when the pll2_r_ck is not used. This bit can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0)."]
pub const fn pllren (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "PLL2 DIVR divider output enable Set and reset by software to enable the pll2_r_ck output of the PLL2. To save power, PLL2REN and PLL2R bits must be set to 0 when the pll2_r_ck is not used. This bit can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0)."]
pub fn set_pllren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Pll2cfgr { fn default () -> Pll2cfgr { Pll2cfgr (0) } } # [doc = "RCC clock configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "AHB prescaler Set and cleared by software to control the division factor of the AHB clock (HCLK). Depending on the device voltage range, the software must set these bits correctly to ensure that the system frequency does not exceed the maximum allowed frequency (for more details, refer to ). After a write operation to these bits and before decreasing the voltage range, this register must be read to be sure that the new value is taken into account. 0xxx: SYSCLK not divided"]
pub const fn hpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "AHB prescaler Set and cleared by software to control the division factor of the AHB clock (HCLK). Depending on the device voltage range, the software must set these bits correctly to ensure that the system frequency does not exceed the maximum allowed frequency (for more details, refer to ). After a write operation to these bits and before decreasing the voltage range, this register must be read to be sure that the new value is taken into account. 0xxx: SYSCLK not divided"]
pub fn set_hpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "APB1 prescaler Set and cleared by software to control the division factor of the APB1 clock (PCLK1). 0xx: HCLK not divided"]
pub const fn ppre1 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB1 prescaler Set and cleared by software to control the division factor of the APB1 clock (PCLK1). 0xx: HCLK not divided"]
pub fn set_ppre1 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } # [doc = "APB2 prescaler Set and cleared by software to control the division factor of the APB2 clock (PCLK2). 0xx: HCLK not divided"]
pub const fn ppre2 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 8usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB2 prescaler Set and cleared by software to control the division factor of the APB2 clock (PCLK2). 0xx: HCLK not divided"]
pub fn set_ppre2 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val . 0 as u32) & 0x07) << 8usize) ; } # [doc = "AHB1 clock disable This bit can be set in order to further reduce power consumption, when none of the AHB1 peripherals (except those listed hereafter) are used and when their clocks are disabled in RCC_AHB1ENR. When this bit is set, all the AHB1 peripherals clocks are off, except for FLASH, BKPSRAM, ICACHE, DCACHE1 and SRAM1."]
pub const fn ahb1dis (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AHB1 clock disable This bit can be set in order to further reduce power consumption, when none of the AHB1 peripherals (except those listed hereafter) are used and when their clocks are disabled in RCC_AHB1ENR. When this bit is set, all the AHB1 peripherals clocks are off, except for FLASH, BKPSRAM, ICACHE, DCACHE1 and SRAM1."]
pub fn set_ahb1dis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "AHB2_1 clock disable This bit can be set in order to further reduce power consumption, when none of the AHB2 peripherals from RCC_AHB2ENR1 (except SRAM2 and SRAM3) are used and when their clocks are disabled in RCC_AHB2ENR1. When this bit is set, all the AHB2 peripherals clocks from RCC_AHB2ENR1 are off, except for SRAM2 and SRAM3."]
pub const fn ahb2dis1 (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "AHB2_1 clock disable This bit can be set in order to further reduce power consumption, when none of the AHB2 peripherals from RCC_AHB2ENR1 (except SRAM2 and SRAM3) are used and when their clocks are disabled in RCC_AHB2ENR1. When this bit is set, all the AHB2 peripherals clocks from RCC_AHB2ENR1 are off, except for SRAM2 and SRAM3."]
pub fn set_ahb2dis1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "AHB2_2 clock disable This bit can be set in order to further reduce power consumption, when none of the AHB2 peripherals from RCC_AHB2ENR2 are used and when their clocks are disabled in RCC_AHB2ENR2. When this bit is set, all the AHB2 peripherals clocks from RCC_AHB2EBNR2 are off."]
pub const fn ahb2dis2 (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "AHB2_2 clock disable This bit can be set in order to further reduce power consumption, when none of the AHB2 peripherals from RCC_AHB2ENR2 are used and when their clocks are disabled in RCC_AHB2ENR2. When this bit is set, all the AHB2 peripherals clocks from RCC_AHB2EBNR2 are off."]
pub fn set_ahb2dis2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "APB1 clock disable This bit can be set in order to further reduce power consumption, when none of the APB1 peripherals (except IWDG) are used and when their clocks are disabled in RCC_APB1ENR. When this bit is set, all the APB1 peripherals clocks are off, except for IWDG."]
pub const fn apb1dis (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "APB1 clock disable This bit can be set in order to further reduce power consumption, when none of the APB1 peripherals (except IWDG) are used and when their clocks are disabled in RCC_APB1ENR. When this bit is set, all the APB1 peripherals clocks are off, except for IWDG."]
pub fn set_apb1dis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "APB2 clock disable This bit can be set in order to further reduce power consumption, when none of the APB2 peripherals are used and when their clocks are disabled in RCC_APB2ENR. When this bit is set, all the APB2 peripherals clocks are off."]
pub const fn apb2dis (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "APB2 clock disable This bit can be set in order to further reduce power consumption, when none of the APB2 peripherals are used and when their clocks are disabled in RCC_APB2ENR. When this bit is set, all the APB2 peripherals clocks are off."]
pub fn set_apb2dis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "RCC PLL2 dividers configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll2divr (pub u32) ; impl Pll2divr { # [doc = "Multiplication factor for PLL2 VCO Set and reset by software to control the multiplication factor of the VCO. These bits can be written only when the PLL is disabled (PLL2ON = 0 and PLL2RDY = 0). ... ... Others: reserved VCO output frequency = Fref2_ck x PLL2N, when fractional value 0 has been loaded into PLL2FRACN, with: PLL2N between 4 and 512 input frequency Fref2_ck between 1MHz and 16MHz"]
pub const fn plln (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Multiplication factor for PLL2 VCO Set and reset by software to control the multiplication factor of the VCO. These bits can be written only when the PLL is disabled (PLL2ON = 0 and PLL2RDY = 0). ... ... Others: reserved VCO output frequency = Fref2_ck x PLL2N, when fractional value 0 has been loaded into PLL2FRACN, with: PLL2N between 4 and 512 input frequency Fref2_ck between 1MHz and 16MHz"]
pub fn set_plln (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "PLL2 DIVP division factor Set and reset by software to control the frequency of the pll2_p_ck clock. These bits can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0). ..."]
pub const fn pllp (& self) -> u8 { let val = (self . 0 >> 9usize) & 0x7f ; val as u8 } # [doc = "PLL2 DIVP division factor Set and reset by software to control the frequency of the pll2_p_ck clock. These bits can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0). ..."]
pub fn set_pllp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 9usize)) | (((val as u32) & 0x7f) << 9usize) ; } # [doc = "PLL2 DIVQ division factor Set and reset by software to control the frequency of the pll2_q_ck clock. These bits can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0). ..."]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "PLL2 DIVQ division factor Set and reset by software to control the frequency of the pll2_q_ck clock. These bits can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0). ..."]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } # [doc = "PLL2 DIVR division factor Set and reset by software to control the frequency of the pll2_r_ck clock. These bits can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0). ..."]
pub const fn pllr (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "PLL2 DIVR division factor Set and reset by software to control the frequency of the pll2_r_ck clock. These bits can be written only when the PLL2 is disabled (PLL2ON = 0 and PLL2RDY = 0). ..."]
pub fn set_pllr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Pll2divr { fn default () -> Pll2divr { Pll2divr (0) } } # [doc = "RCC peripherals independent clock configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccipr2 (pub u32) ; impl Ccipr2 { # [doc = "MDF1 kernel clock source selection These bits are used to select the MDF1 kernel clock source. others: reserved"]
pub const fn mdf1sel (& self) -> super :: vals :: Mdfsel { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Mdfsel (val as u8) } # [doc = "MDF1 kernel clock source selection These bits are used to select the MDF1 kernel clock source. others: reserved"]
pub fn set_mdf1sel (& mut self , val : super :: vals :: Mdfsel) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "SAI1 kernel clock source selection These bits are used to select the SAI1 kernel clock source. others: reserved Note: If the selected clock is the external clock and this clock is stopped, a switch to another clock is impossible."]
pub const fn sai1sel (& self) -> super :: vals :: Saisel { let val = (self . 0 >> 5usize) & 0x07 ; super :: vals :: Saisel (val as u8) } # [doc = "SAI1 kernel clock source selection These bits are used to select the SAI1 kernel clock source. others: reserved Note: If the selected clock is the external clock and this clock is stopped, a switch to another clock is impossible."]
pub fn set_sai1sel (& mut self , val : super :: vals :: Saisel) { self . 0 = (self . 0 & ! (0x07 << 5usize)) | (((val . 0 as u32) & 0x07) << 5usize) ; } # [doc = "SAI2 kernel clock source selection These bits are used to select the SAI2 kernel clock source. others: reserved Note: If the selected clock is the external clock and this clock is stopped, a switch to another clock is impossible."]
pub const fn sai2sel (& self) -> super :: vals :: Saisel { let val = (self . 0 >> 8usize) & 0x07 ; super :: vals :: Saisel (val as u8) } # [doc = "SAI2 kernel clock source selection These bits are used to select the SAI2 kernel clock source. others: reserved Note: If the selected clock is the external clock and this clock is stopped, a switch to another clock is impossible."]
pub fn set_sai2sel (& mut self , val : super :: vals :: Saisel) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val . 0 as u32) & 0x07) << 8usize) ; } # [doc = "SAES kernel clock source selection This bit is used to select the SAES kernel clock source."]
pub const fn saessel (& self) -> super :: vals :: Saessel { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Saessel (val as u8) } # [doc = "SAES kernel clock source selection This bit is used to select the SAES kernel clock source."]
pub fn set_saessel (& mut self , val : super :: vals :: Saessel) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "RNGSEL kernel clock source selection These bits are used to select the RNG kernel clock source."]
pub const fn rngsel (& self) -> super :: vals :: Rngsel { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Rngsel (val as u8) } # [doc = "RNGSEL kernel clock source selection These bits are used to select the RNG kernel clock source."]
pub fn set_rngsel (& mut self , val : super :: vals :: Rngsel) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "SDMMC1 and SDMMC2 kernel clock source selection This bit is used to select the SDMMC kernel clock source. It is recommended to change this bit only after reset and before enabling the SDMMC."]
pub const fn sdmmcsel (& self) -> super :: vals :: Sdmmcsel { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Sdmmcsel (val as u8) } # [doc = "SDMMC1 and SDMMC2 kernel clock source selection This bit is used to select the SDMMC kernel clock source. It is recommended to change this bit only after reset and before enabling the SDMMC."]
pub fn set_sdmmcsel (& mut self , val : super :: vals :: Sdmmcsel) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "OCTOSPI1 and OCTOSPI2 kernel clock source selection These bits are used to select the OCTOSPI1 and OCTOSPI2 kernel clock source."]
pub const fn octospisel (& self) -> super :: vals :: Octospisel { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Octospisel (val as u8) } # [doc = "OCTOSPI1 and OCTOSPI2 kernel clock source selection These bits are used to select the OCTOSPI1 and OCTOSPI2 kernel clock source."]
pub fn set_octospisel (& mut self , val : super :: vals :: Octospisel) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } } impl Default for Ccipr2 { fn default () -> Ccipr2 { Ccipr2 (0) } } # [doc = "RCC APB1 peripheral reset register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr1 (pub u32) ; impl Apb1rstr1 { # [doc = "TIM2 reset Set and cleared by software."]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 reset Set and cleared by software."]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 reset Set and cleared by software."]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 reset Set and cleared by software."]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 reset Set and cleared by software."]
pub const fn tim4rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 reset Set and cleared by software."]
pub fn set_tim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 reset Set and cleared by software."]
pub const fn tim5rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 reset Set and cleared by software."]
pub fn set_tim5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 reset Set and cleared by software."]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 reset Set and cleared by software."]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 reset Set and cleared by software."]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 reset Set and cleared by software."]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "SPI2 reset Set and cleared by software."]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 reset Set and cleared by software."]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART2 reset Set and cleared by software."]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 reset Set and cleared by software."]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 reset Set and cleared by software."]
pub const fn usart3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 reset Set and cleared by software."]
pub fn set_usart3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 reset Set and cleared by software."]
pub const fn uart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 reset Set and cleared by software."]
pub fn set_uart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 reset Set and cleared by software."]
pub const fn uart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 reset Set and cleared by software."]
pub fn set_uart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 reset Set and cleared by software."]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 reset Set and cleared by software."]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 reset Set and cleared by software."]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 reset Set and cleared by software."]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "CRS reset Set and cleared by software."]
pub const fn crsrst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CRS reset Set and cleared by software."]
pub fn set_crsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Apb1rstr1 { fn default () -> Apb1rstr1 { Apb1rstr1 (0) } } # [doc = "RCC AHB1 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1smenr (pub u32) ; impl Ahb1smenr { # [doc = "GPDMA1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn gpdma1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "GPDMA1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_gpdma1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CORDIC clocks enable during Sleep and Stop modes Set and cleared by software during Sleep mode."]
pub const fn cordicsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CORDIC clocks enable during Sleep and Stop modes Set and cleared by software during Sleep mode."]
pub fn set_cordicsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "FMAC clocks enable during Sleep and Stop modes. Set and cleared by software."]
pub const fn fmacsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "FMAC clocks enable during Sleep and Stop modes. Set and cleared by software."]
pub fn set_fmacsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "MDF1 clocks enable during Sleep and Stop modes. Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn mdf1smen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "MDF1 clocks enable during Sleep and Stop modes. Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_mdf1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "FLASH clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn flashsmen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "FLASH clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_flashsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CRC clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn crcsmen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_crcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TSC clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn tscsmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TSC clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_tscsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "RAMCFG clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn ramcfgsmen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "RAMCFG clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_ramcfgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "DMA2D clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn dma2dsmen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "DMA2D clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_dma2dsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "GTZC1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn gtzc1smen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "GTZC1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_gtzc1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "BKPSRAM clocks enable during Sleep and Stop modes Set and cleared by software"]
pub const fn bkpsramsmen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "BKPSRAM clocks enable during Sleep and Stop modes Set and cleared by software"]
pub fn set_bkpsramsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "ICACHE clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn icachesmen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "ICACHE clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_icachesmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "DCACHE1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn dcache1smen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "DCACHE1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_dcache1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "SRAM1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn sram1smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_sram1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb1smenr { fn default () -> Ahb1smenr { Ahb1smenr (0) } } # [doc = "RCC APB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "TIM1 clock enable Set and cleared by software."]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 clock enable Set and cleared by software."]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clock enable Set and cleared by software."]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clock enable Set and cleared by software."]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 clock enable Set and cleared by software."]
pub const fn tim8en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 clock enable Set and cleared by software."]
pub fn set_tim8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1clock enable Set and cleared by software."]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1clock enable Set and cleared by software."]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM15 clock enable Set and cleared by software."]
pub const fn tim15en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 clock enable Set and cleared by software."]
pub fn set_tim15en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 clock enable Set and cleared by software."]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 clock enable Set and cleared by software."]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 clock enable Set and cleared by software."]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 clock enable Set and cleared by software."]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SAI1 clock enable Set and cleared by software."]
pub const fn sai1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI1 clock enable Set and cleared by software."]
pub fn set_sai1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SAI2 clock enable Set and cleared by software."]
pub const fn sai2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI2 clock enable Set and cleared by software."]
pub fn set_sai2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "RCC peripherals independent clock configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccipr1 (pub u32) ; impl Ccipr1 { # [doc = "USART1 kernel clock source selection This bits are used to select the USART1 kernel clock source. Note: The USART1 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub const fn usart1sel (& self) -> super :: vals :: Usartsel { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Usartsel (val as u8) } # [doc = "USART1 kernel clock source selection This bits are used to select the USART1 kernel clock source. Note: The USART1 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub fn set_usart1sel (& mut self , val : super :: vals :: Usartsel) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "USART2 kernel clock source selection This bits are used to select the USART2 kernel clock source. Note: The USART2 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub const fn usart2sel (& self) -> super :: vals :: Usartsel { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Usartsel (val as u8) } # [doc = "USART2 kernel clock source selection This bits are used to select the USART2 kernel clock source. Note: The USART2 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub fn set_usart2sel (& mut self , val : super :: vals :: Usartsel) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "USART3 kernel clock source selection This bits are used to select the USART3 kernel clock source. Note: The USART3 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub const fn usart3sel (& self) -> super :: vals :: Usartsel { let val = (self . 0 >> 4usize) & 0x03 ; super :: vals :: Usartsel (val as u8) } # [doc = "USART3 kernel clock source selection This bits are used to select the USART3 kernel clock source. Note: The USART3 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub fn set_usart3sel (& mut self , val : super :: vals :: Usartsel) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val . 0 as u32) & 0x03) << 4usize) ; } # [doc = "UART4 kernel clock source selection This bits are used to select the UART4 kernel clock source. Note: The UART4 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub const fn uart4sel (& self) -> super :: vals :: Uartsel { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: Uartsel (val as u8) } # [doc = "UART4 kernel clock source selection This bits are used to select the UART4 kernel clock source. Note: The UART4 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub fn set_uart4sel (& mut self , val : super :: vals :: Uartsel) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "UART5 kernel clock source selection These bits are used to select the UART5 kernel clock source. Note: The UART5 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub const fn uart5sel (& self) -> super :: vals :: Uartsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Uartsel (val as u8) } # [doc = "UART5 kernel clock source selection These bits are used to select the UART5 kernel clock source. Note: The UART5 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or LSE."]
pub fn set_uart5sel (& mut self , val : super :: vals :: Uartsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "I2C1 kernel clock source selection These bits are used to select the I2C1 kernel clock source. Note: The I2C1 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub const fn i2c1sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 10usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C1 kernel clock source selection These bits are used to select the I2C1 kernel clock source. Note: The I2C1 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub fn set_i2c1sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val . 0 as u32) & 0x03) << 10usize) ; } # [doc = "I2C2 kernel clock source selection These bits are used to select the I2C2 kernel clock source. Note: The I2C2 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub const fn i2c2sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C2 kernel clock source selection These bits are used to select the I2C2 kernel clock source. Note: The I2C2 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub fn set_i2c2sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "I2C4 kernel clock source selection These bits are used to select the I2C4 kernel clock source. Note: The I2C4 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub const fn i2c4sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C4 kernel clock source selection These bits are used to select the I2C4 kernel clock source. Note: The I2C4 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub fn set_i2c4sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } # [doc = "SPI2 kernel clock source selection These bits are used to select the SPI2 kernel clock source. Note: The SPI2 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub const fn spi2sel (& self) -> super :: vals :: Spisel { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Spisel (val as u8) } # [doc = "SPI2 kernel clock source selection These bits are used to select the SPI2 kernel clock source. Note: The SPI2 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub fn set_spi2sel (& mut self , val : super :: vals :: Spisel) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Low-power timer 2 kernel clock source selection These bits are used to select the LPTIM2 kernel clock source. Note: The LPTIM2 is functional in Stop 0 and Stop 1 mode only when the kernel clock is LSI, LSE or HSI16 if HSIKERON = 1."]
pub const fn lptim2sel (& self) -> super :: vals :: Lptimsel { let val = (self . 0 >> 18usize) & 0x03 ; super :: vals :: Lptimsel (val as u8) } # [doc = "Low-power timer 2 kernel clock source selection These bits are used to select the LPTIM2 kernel clock source. Note: The LPTIM2 is functional in Stop 0 and Stop 1 mode only when the kernel clock is LSI, LSE or HSI16 if HSIKERON = 1."]
pub fn set_lptim2sel (& mut self , val : super :: vals :: Lptimsel) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val . 0 as u32) & 0x03) << 18usize) ; } # [doc = "SPI1 kernel clock source selection These bits are used to select the SPI1 kernel clock source. Note: The SPI1 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub const fn spi1sel (& self) -> super :: vals :: Spisel { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Spisel (val as u8) } # [doc = "SPI1 kernel clock source selection These bits are used to select the SPI1 kernel clock source. Note: The SPI1 is functional in Stop 0 and Stop 1 mode only when the kernel clock is HSI16 or MSIK."]
pub fn set_spi1sel (& mut self , val : super :: vals :: Spisel) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "SysTick clock source selection These bits are used to select the SysTick clock source. Note: When LSE or LSI is selected, the AHB frequency must be at least four times higher than the LSI or LSE frequency. In addition, a jitter up to one HCLK cycle is introduced, due to the LSE or LSI sampling with HCLK in the SysTick circuitry."]
pub const fn systicksel (& self) -> super :: vals :: Systicksel { let val = (self . 0 >> 22usize) & 0x03 ; super :: vals :: Systicksel (val as u8) } # [doc = "SysTick clock source selection These bits are used to select the SysTick clock source. Note: When LSE or LSI is selected, the AHB frequency must be at least four times higher than the LSI or LSE frequency. In addition, a jitter up to one HCLK cycle is introduced, due to the LSE or LSI sampling with HCLK in the SysTick circuitry."]
pub fn set_systicksel (& mut self , val : super :: vals :: Systicksel) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val . 0 as u32) & 0x03) << 22usize) ; } # [doc = "FDCAN1 kernel clock source selection These bits are used to select the FDCAN1 kernel clock source."]
pub const fn fdcan1sel (& self) -> super :: vals :: Fdcansel { let val = (self . 0 >> 24usize) & 0x03 ; super :: vals :: Fdcansel (val as u8) } # [doc = "FDCAN1 kernel clock source selection These bits are used to select the FDCAN1 kernel clock source."]
pub fn set_fdcan1sel (& mut self , val : super :: vals :: Fdcansel) { self . 0 = (self . 0 & ! (0x03 << 24usize)) | (((val . 0 as u32) & 0x03) << 24usize) ; } # [doc = "intermediate clock source selection These bits are used to select the clock source used by OTG_FS and SDMMC."]
pub const fn iclksel (& self) -> super :: vals :: Iclksel { let val = (self . 0 >> 26usize) & 0x03 ; super :: vals :: Iclksel (val as u8) } # [doc = "intermediate clock source selection These bits are used to select the clock source used by OTG_FS and SDMMC."]
pub fn set_iclksel (& mut self , val : super :: vals :: Iclksel) { self . 0 = (self . 0 & ! (0x03 << 26usize)) | (((val . 0 as u32) & 0x03) << 26usize) ; } # [doc = "Clocks sources for TIM16,TIM17 and LPTIM2 internal input capture When the TIMICSEL2 bit is set, the TIM16, TIM17 and LPTIM2 internal input capture can be connected either to HSI/256, MSI/4 or MSI/1024. Depending on TIMICSEL[1:0]
value, MSI is either MSIK or MSIS. When TIMICSEL2 is cleared, the HSI, MSIK and MSIS clock sources cannot be selected as TIM16, TIM17 or LPTIM2 internal input capture. 0xx: HSI, MSIK and MSIS dividers disabled Note: The clock division must be disabled (TIMICSEL configured to 0xx) before selecting or changing a clock sources division."]
pub const fn timicsel (& self) -> super :: vals :: Timicsel { let val = (self . 0 >> 29usize) & 0x07 ; super :: vals :: Timicsel (val as u8) } # [doc = "Clocks sources for TIM16,TIM17 and LPTIM2 internal input capture When the TIMICSEL2 bit is set, the TIM16, TIM17 and LPTIM2 internal input capture can be connected either to HSI/256, MSI/4 or MSI/1024. Depending on TIMICSEL[1:0]
value, MSI is either MSIK or MSIS. When TIMICSEL2 is cleared, the HSI, MSIK and MSIS clock sources cannot be selected as TIM16, TIM17 or LPTIM2 internal input capture. 0xx: HSI, MSIK and MSIS dividers disabled Note: The clock division must be disabled (TIMICSEL configured to 0xx) before selecting or changing a clock sources division."]
pub fn set_timicsel (& mut self , val : super :: vals :: Timicsel) { self . 0 = (self . 0 & ! (0x07 << 29usize)) | (((val . 0 as u32) & 0x07) << 29usize) ; } } impl Default for Ccipr1 { fn default () -> Ccipr1 { Ccipr1 (0) } } # [doc = "RCC AHB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1enr (pub u32) ; impl Ahb1enr { # [doc = "GPDMA1 clock enable Set and cleared by software."]
pub const fn gpdma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "GPDMA1 clock enable Set and cleared by software."]
pub fn set_gpdma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CORDIC clock enable Set and cleared by software."]
pub const fn cordicen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CORDIC clock enable Set and cleared by software."]
pub fn set_cordicen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "FMAC clock enable Set and reset by software."]
pub const fn fmacen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "FMAC clock enable Set and reset by software."]
pub fn set_fmacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "MDF1 clock enable Set and reset by software."]
pub const fn mdf1en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "MDF1 clock enable Set and reset by software."]
pub fn set_mdf1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "FLASH clock enable Set and cleared by software. This bit can be disabled only when the Flash memory is in power down mode."]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "FLASH clock enable Set and cleared by software. This bit can be disabled only when the Flash memory is in power down mode."]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CRC clock enable Set and cleared by software."]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable Set and cleared by software."]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Touch sensing controller clock enable Set and cleared by software."]
pub const fn tscen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Touch sensing controller clock enable Set and cleared by software."]
pub fn set_tscen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "RAMCFG clock enable Set and cleared by software."]
pub const fn ramcfgen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "RAMCFG clock enable Set and cleared by software."]
pub fn set_ramcfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "DMA2D clock enable Set and cleared by software."]
pub const fn dma2den (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "DMA2D clock enable Set and cleared by software."]
pub fn set_dma2den (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "GTZC1 clock enable Set and reset by software."]
pub const fn gtzc1en (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "GTZC1 clock enable Set and reset by software."]
pub fn set_gtzc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "BKPSRAM clock enable Set and reset by software."]
pub const fn bkpsramen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "BKPSRAM clock enable Set and reset by software."]
pub fn set_bkpsramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DCACHE1 clock enable Set and reset by software. Note: DCACHE1 clock must be enabled when external memories are accessed through OCTOSPI1, OCTOSPI2 or FSMC, even if the DCACHE1 is bypassed."]
pub const fn dcache1en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "DCACHE1 clock enable Set and reset by software. Note: DCACHE1 clock must be enabled when external memories are accessed through OCTOSPI1, OCTOSPI2 or FSMC, even if the DCACHE1 is bypassed."]
pub fn set_dcache1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "SRAM1 clock enable Set and reset by software."]
pub const fn sram1en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM1 clock enable Set and reset by software."]
pub fn set_sram1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb1enr { fn default () -> Ahb1enr { Ahb1enr (0) } } # [doc = "RCC PLL1 dividers register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll1divr (pub u32) ; impl Pll1divr { # [doc = "Multiplication factor for PLL1 VCO Set and reset by software to control the multiplication factor of the VCO. These bits can be written only when the PLL is disabled (PLL1ON = 0 and PLL1RDY = 0). ... ... Others: reserved VCO output frequency = Fref1_ck x PLL1N, when fractional value 0 has been loaded into PLL1FRACN, with: PLL1N between 4 and 512 input frequency Fref1_ck between 4 and 16 MHz"]
pub const fn plln (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Multiplication factor for PLL1 VCO Set and reset by software to control the multiplication factor of the VCO. These bits can be written only when the PLL is disabled (PLL1ON = 0 and PLL1RDY = 0). ... ... Others: reserved VCO output frequency = Fref1_ck x PLL1N, when fractional value 0 has been loaded into PLL1FRACN, with: PLL1N between 4 and 512 input frequency Fref1_ck between 4 and 16 MHz"]
pub fn set_plln (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "PLL1 DIVP division factor Set and reset by software to control the frequency of the pll1_p_ck clock. These bits can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0). Note that odd division factors are not allowed. ..."]
pub const fn pllp (& self) -> u8 { let val = (self . 0 >> 9usize) & 0x7f ; val as u8 } # [doc = "PLL1 DIVP division factor Set and reset by software to control the frequency of the pll1_p_ck clock. These bits can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0). Note that odd division factors are not allowed. ..."]
pub fn set_pllp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 9usize)) | (((val as u32) & 0x7f) << 9usize) ; } # [doc = "PLL1 DIVQ division factor Set and reset by software to control the frequency of the pll1_q_ck clock. These bits can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0). ..."]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "PLL1 DIVQ division factor Set and reset by software to control the frequency of the pll1_q_ck clock. These bits can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0). ..."]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } # [doc = "PLL1 DIVR division factor Set and reset by software to control the frequency of the pll1_r_ck clock. These bits can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0). ..."]
pub const fn pllr (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "PLL1 DIVR division factor Set and reset by software to control the frequency of the pll1_r_ck clock. These bits can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0). ..."]
pub fn set_pllr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Pll1divr { fn default () -> Pll1divr { Pll1divr (0) } } # [doc = "RCC PLL1 configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll1cfgr (pub u32) ; impl Pll1cfgr { # [doc = "PLL1 entry clock source Set and cleared by software to select PLL1 clock source. These bits can be written only when the PLL1 is disabled. In order to save power, when no PLL1 is used, the value of PLL1SRC must be 0."]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Pllsrc (val as u8) } # [doc = "PLL1 entry clock source Set and cleared by software to select PLL1 clock source. These bits can be written only when the PLL1 is disabled. In order to save power, when no PLL1 is used, the value of PLL1SRC must be 0."]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "PLL1 input frequency range Set and reset by software to select the proper reference frequency range used for PLL1. This bit must be written before enabling the PLL1. 00-01-10: PLL1 input (ref1_ck) clock range frequency between 4 and 8 MHz"]
pub const fn pllrge (& self) -> super :: vals :: Pllrge { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Pllrge (val as u8) } # [doc = "PLL1 input frequency range Set and reset by software to select the proper reference frequency range used for PLL1. This bit must be written before enabling the PLL1. 00-01-10: PLL1 input (ref1_ck) clock range frequency between 4 and 8 MHz"]
pub fn set_pllrge (& mut self , val : super :: vals :: Pllrge) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "PLL1 fractional latch enable Set and reset by software to latch the content of PLL1FRACN into the Î£Î modulator. In order to latch the PLL1FRACN value into the Î£Î modulator, PLL1FRACEN must be set to 0, then set to 1: the transition 0 to 1 transfers the content of PLL1FRACN into the modulator (see for details)."]
pub const fn pllfracen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL1 fractional latch enable Set and reset by software to latch the content of PLL1FRACN into the Î£Î modulator. In order to latch the PLL1FRACN value into the Î£Î modulator, PLL1FRACEN must be set to 0, then set to 1: the transition 0 to 1 transfers the content of PLL1FRACN into the modulator (see for details)."]
pub fn set_pllfracen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Prescaler for PLL1 Set and cleared by software to configure the prescaler of the PLL1. The VCO1 input frequency is PLL1 input clock frequency/PLL1M. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0). ..."]
pub const fn pllm (& self) -> super :: vals :: Pllm { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Pllm (val as u8) } # [doc = "Prescaler for PLL1 Set and cleared by software to configure the prescaler of the PLL1. The VCO1 input frequency is PLL1 input clock frequency/PLL1M. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0). ..."]
pub fn set_pllm (& mut self , val : super :: vals :: Pllm) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } # [doc = "Prescaler for EPOD booster input clock Set and cleared by software to configure the prescaler of the PLL1, used for the EPOD booster. The EPOD booster input frequency is PLL1 input clock frequency/PLL1MBOOST. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0) and EPOD Boost mode is disabled (see ). others: reserved"]
pub const fn pllmboost (& self) -> super :: vals :: Pllmboost { let val = (self . 0 >> 12usize) & 0x0f ; super :: vals :: Pllmboost (val as u8) } # [doc = "Prescaler for EPOD booster input clock Set and cleared by software to configure the prescaler of the PLL1, used for the EPOD booster. The EPOD booster input frequency is PLL1 input clock frequency/PLL1MBOOST. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0) and EPOD Boost mode is disabled (see ). others: reserved"]
pub fn set_pllmboost (& mut self , val : super :: vals :: Pllmboost) { self . 0 = (self . 0 & ! (0x0f << 12usize)) | (((val . 0 as u32) & 0x0f) << 12usize) ; } # [doc = "PLL1 DIVP divider output enable Set and reset by software to enable the pll1_p_ck output of the PLL1. To save power, PLL1PEN and PLL1P bits must be set to 0 when the pll1_p_ck is not used. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0)."]
pub const fn pllpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "PLL1 DIVP divider output enable Set and reset by software to enable the pll1_p_ck output of the PLL1. To save power, PLL1PEN and PLL1P bits must be set to 0 when the pll1_p_ck is not used. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0)."]
pub fn set_pllpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "PLL1 DIVQ divider output enable Set and reset by software to enable the pll1_q_ck output of the PLL1. To save power, PLL1QEN and PLL1Q bits must be set to 0 when the pll1_q_ck is not used. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0)."]
pub const fn pllqen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "PLL1 DIVQ divider output enable Set and reset by software to enable the pll1_q_ck output of the PLL1. To save power, PLL1QEN and PLL1Q bits must be set to 0 when the pll1_q_ck is not used. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0)."]
pub fn set_pllqen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "PLL1 DIVR divider output enable Set and reset by software to enable the pll1_r_ck output of the PLL1. To save power, PLL1RENPLL2REN and PLL1R bits must be set to 0 when the pll1_r_ck is not used. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0)."]
pub const fn pllren (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "PLL1 DIVR divider output enable Set and reset by software to enable the pll1_r_ck output of the PLL1. To save power, PLL1RENPLL2REN and PLL1R bits must be set to 0 when the pll1_r_ck is not used. This bit can be written only when the PLL1 is disabled (PLL1ON = 0 and PLL1RDY = 0)."]
pub fn set_pllren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Pll1cfgr { fn default () -> Pll1cfgr { Pll1cfgr (0) } } # [doc = "RCC control/status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "MSIK range after Standby mode Set by software to chose the MSIK frequency at startup. This range is used after exiting Standby mode until MSIRGSEL is set. After a NRST pin or a power-on reset or when exiting Shutdown mode, the range is always 4 MHz. MSIKSRANGE can be written only when MSIRGSEL = 1. others: reserved Note: Changing the MSIKSRANGE does not change the current MSIK frequency."]
pub const fn msiksrange (& self) -> super :: vals :: Msixsrange { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Msixsrange (val as u8) } # [doc = "MSIK range after Standby mode Set by software to chose the MSIK frequency at startup. This range is used after exiting Standby mode until MSIRGSEL is set. After a NRST pin or a power-on reset or when exiting Shutdown mode, the range is always 4 MHz. MSIKSRANGE can be written only when MSIRGSEL = 1. others: reserved Note: Changing the MSIKSRANGE does not change the current MSIK frequency."]
pub fn set_msiksrange (& mut self , val : super :: vals :: Msixsrange) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } # [doc = "MSIS range after Standby mode Set by software to chose the MSIS frequency at startup. This range is used after exiting Standby mode until MSIRGSEL is set. After a NRST pin or a power-on reset or when exiting Shutdown mode, the range is always 4 MHz. MSISSRANGE can be written only when MSIRGSEL = 1. others: reserved Note: Changing the MSISSRANGE does not change the current MSIS frequency."]
pub const fn msissrange (& self) -> super :: vals :: Msixsrange { let val = (self . 0 >> 12usize) & 0x0f ; super :: vals :: Msixsrange (val as u8) } # [doc = "MSIS range after Standby mode Set by software to chose the MSIS frequency at startup. This range is used after exiting Standby mode until MSIRGSEL is set. After a NRST pin or a power-on reset or when exiting Shutdown mode, the range is always 4 MHz. MSISSRANGE can be written only when MSIRGSEL = 1. others: reserved Note: Changing the MSISSRANGE does not change the current MSIS frequency."]
pub fn set_msissrange (& mut self , val : super :: vals :: Msixsrange) { self . 0 = (self . 0 & ! (0x0f << 12usize)) | (((val . 0 as u32) & 0x0f) << 12usize) ; } # [doc = "Remove reset flag Set by software to clear the reset flags."]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag Set by software to clear the reset flags."]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Option byte loader reset flag Set by hardware when a reset from the option byte loading occurs. Cleared by writing to the RMVF bit."]
pub const fn oblrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Option byte loader reset flag Set by hardware when a reset from the option byte loading occurs. Cleared by writing to the RMVF bit."]
pub fn set_oblrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "NRST pin reset flag Set by hardware when a reset from the NRST pin occurs. Cleared by writing to the RMVF bit."]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "NRST pin reset flag Set by hardware when a reset from the NRST pin occurs. Cleared by writing to the RMVF bit."]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "BOR flag Set by hardware when a BOR occurs. Cleared by writing to the RMVF bit."]
pub const fn borrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "BOR flag Set by hardware when a BOR occurs. Cleared by writing to the RMVF bit."]
pub fn set_borrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag Set by hardware when a software reset occurs. Cleared by writing to the RMVF bit."]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag Set by hardware when a software reset occurs. Cleared by writing to the RMVF bit."]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent watchdog reset flag Set by hardware when an independent watchdog reset domain occurs. Cleared by writing to the RMVF bit."]
pub const fn iwdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog reset flag Set by hardware when an independent watchdog reset domain occurs. Cleared by writing to the RMVF bit."]
pub fn set_iwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag Set by hardware when a window watchdog reset occurs. Cleared by writing to the RMVF bit."]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag Set by hardware when a window watchdog reset occurs. Cleared by writing to the RMVF bit."]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag Set by hardware when a reset occurs due to Stop, Standby or Shutdown mode entry, whereas the corresponding nRST_STOP, nRST_STBY or nRST_SHDW option bit is cleared. Cleared by writing to the RMVF bit."]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag Set by hardware when a reset occurs due to Stop, Standby or Shutdown mode entry, whereas the corresponding nRST_STOP, nRST_STBY or nRST_SHDW option bit is cleared. Cleared by writing to the RMVF bit."]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "RCC AHB2 peripheral reset register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2rstr2 (pub u32) ; impl Ahb2rstr2 { # [doc = "Flexible memory controller reset Set and cleared by software."]
pub const fn fsmcrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible memory controller reset Set and cleared by software."]
pub fn set_fsmcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "OCTOSPI1 reset Set and cleared by software."]
pub const fn octospi1rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI1 reset Set and cleared by software."]
pub fn set_octospi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "OCTOSPI2 reset Set and cleared by software."]
pub const fn octospi2rst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI2 reset Set and cleared by software."]
pub fn set_octospi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Ahb2rstr2 { fn default () -> Ahb2rstr2 { Ahb2rstr2 (0) } } # [doc = "RCC AHB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1rstr (pub u32) ; impl Ahb1rstr { # [doc = "GPDMA1 reset Set and cleared by software."]
pub const fn gpdma1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "GPDMA1 reset Set and cleared by software."]
pub fn set_gpdma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CORDIC reset Set and cleared by software."]
pub const fn cordicrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "CORDIC reset Set and cleared by software."]
pub fn set_cordicrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "FMAC reset Set and cleared by software."]
pub const fn fmacrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "FMAC reset Set and cleared by software."]
pub fn set_fmacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "MDF1 reset Set and cleared by software."]
pub const fn mdf1rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "MDF1 reset Set and cleared by software."]
pub fn set_mdf1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CRC reset Set and cleared by software."]
pub const fn crcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC reset Set and cleared by software."]
pub fn set_crcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TSC reset Set and cleared by software."]
pub const fn tscrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TSC reset Set and cleared by software."]
pub fn set_tscrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "RAMCFG reset Set and cleared by software."]
pub const fn ramcfgrst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "RAMCFG reset Set and cleared by software."]
pub fn set_ramcfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "DMA2D reset Set and cleared by software."]
pub const fn dma2drst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "DMA2D reset Set and cleared by software."]
pub fn set_dma2drst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Ahb1rstr { fn default () -> Ahb1rstr { Ahb1rstr (0) } } # [doc = "RCC peripherals independent clock configuration register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccipr3 (pub u32) ; impl Ccipr3 { # [doc = "LPUART1 kernel clock source selection These bits are used to select the LPUART1 kernel clock source. others: reserved Note: The LPUART1 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is HSI16, LSE or MSIK."]
pub const fn lpuart1sel (& self) -> super :: vals :: Lpuartsel { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Lpuartsel (val as u8) } # [doc = "LPUART1 kernel clock source selection These bits are used to select the LPUART1 kernel clock source. others: reserved Note: The LPUART1 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is HSI16, LSE or MSIK."]
pub fn set_lpuart1sel (& mut self , val : super :: vals :: Lpuartsel) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "SPI3 kernel clock source selection These bits are used to select the SPI3 kernel clock source. Note: The SPI3 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is HSI16 or MSIK."]
pub const fn spi3sel (& self) -> super :: vals :: Spisel { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Spisel (val as u8) } # [doc = "SPI3 kernel clock source selection These bits are used to select the SPI3 kernel clock source. Note: The SPI3 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is HSI16 or MSIK."]
pub fn set_spi3sel (& mut self , val : super :: vals :: Spisel) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "I2C3 kernel clock source selection These bits are used to select the I2C3 kernel clock source. Note: The I2C3 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is HSI16 or MSIK."]
pub const fn i2c3sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C3 kernel clock source selection These bits are used to select the I2C3 kernel clock source. Note: The I2C3 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is HSI16 or MSIK."]
pub fn set_i2c3sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "LPTIM3 and LPTIM4 kernel clock source selection These bits are used to select the LPTIM3 and LPTIM4 kernel clock source. Note: The LPTIM3 and LPTIM4 are functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is LSI, LSE, HSI16 with HSIKERON = 1 or MSIK with MSIKERON = 1."]
pub const fn lptim34sel (& self) -> super :: vals :: Lptimsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Lptimsel (val as u8) } # [doc = "LPTIM3 and LPTIM4 kernel clock source selection These bits are used to select the LPTIM3 and LPTIM4 kernel clock source. Note: The LPTIM3 and LPTIM4 are functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is LSI, LSE, HSI16 with HSIKERON = 1 or MSIK with MSIKERON = 1."]
pub fn set_lptim34sel (& mut self , val : super :: vals :: Lptimsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "LPTIM1 kernel clock source selection These bits are used to select the LPTIM1 kernel clock source. Note: The LPTIM1 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is LSI, LSE, HSI16 with HSIKERON = 1 or MSIK with MSIKERON = 1."]
pub const fn lptim1sel (& self) -> super :: vals :: Lptimsel { let val = (self . 0 >> 10usize) & 0x03 ; super :: vals :: Lptimsel (val as u8) } # [doc = "LPTIM1 kernel clock source selection These bits are used to select the LPTIM1 kernel clock source. Note: The LPTIM1 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is LSI, LSE, HSI16 with HSIKERON = 1 or MSIK with MSIKERON = 1."]
pub fn set_lptim1sel (& mut self , val : super :: vals :: Lptimsel) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val . 0 as u32) & 0x03) << 10usize) ; } # [doc = "ADC1, ADC4 and DAC1 kernel clock source selection These bits are used to select the ADC1, ADC4 and DAC1 kernel clock source. others: reserved Note: The ADC1, ADC4 and DAC1 are functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is HSI16 or MSIK (only ADC4 and DAC1 are functional in Stop 2 mode)."]
pub const fn adcdacsel (& self) -> super :: vals :: Adcdacsel { let val = (self . 0 >> 12usize) & 0x07 ; super :: vals :: Adcdacsel (val as u8) } # [doc = "ADC1, ADC4 and DAC1 kernel clock source selection These bits are used to select the ADC1, ADC4 and DAC1 kernel clock source. others: reserved Note: The ADC1, ADC4 and DAC1 are functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is HSI16 or MSIK (only ADC4 and DAC1 are functional in Stop 2 mode)."]
pub fn set_adcdacsel (& mut self , val : super :: vals :: Adcdacsel) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val . 0 as u32) & 0x07) << 12usize) ; } # [doc = "DAC1 sample and hold clock source selection This bit is used to select the DAC1 sample and hold clock source."]
pub const fn dac1sel (& self) -> super :: vals :: Dacsel { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Dacsel (val as u8) } # [doc = "DAC1 sample and hold clock source selection This bit is used to select the DAC1 sample and hold clock source."]
pub fn set_dac1sel (& mut self , val : super :: vals :: Dacsel) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "ADF1 kernel clock source selection These bits are used to select the ADF1 kernel clock source. others: reserved Note: The ADF1 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is AUDIOCLK or MSIK."]
pub const fn adf1sel (& self) -> super :: vals :: Adfsel { let val = (self . 0 >> 16usize) & 0x07 ; super :: vals :: Adfsel (val as u8) } # [doc = "ADF1 kernel clock source selection These bits are used to select the ADF1 kernel clock source. others: reserved Note: The ADF1 is functional in Stop 0, Stop 1 and Stop 2 modes only when the kernel clock is AUDIOCLK or MSIK."]
pub fn set_adf1sel (& mut self , val : super :: vals :: Adfsel) { self . 0 = (self . 0 & ! (0x07 << 16usize)) | (((val . 0 as u32) & 0x07) << 16usize) ; } } impl Default for Ccipr3 { fn default () -> Ccipr3 { Ccipr3 (0) } } # [doc = "RCC AHB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3rstr (pub u32) ; impl Ahb3rstr { # [doc = "LPGPIO1 reset Set and cleared by software."]
pub const fn lpgpio1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LPGPIO1 reset Set and cleared by software."]
pub fn set_lpgpio1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "ADC4 reset Set and cleared by software."]
pub const fn adc4rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "ADC4 reset Set and cleared by software."]
pub fn set_adc4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "DAC1 reset Set and cleared by software."]
pub const fn dac1rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "DAC1 reset Set and cleared by software."]
pub fn set_dac1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LPDMA1 reset Set and cleared by software."]
pub const fn lpdma1rst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPDMA1 reset Set and cleared by software."]
pub fn set_lpdma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADF1 reset Set and cleared by software."]
pub const fn adf1rst (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADF1 reset Set and cleared by software."]
pub fn set_adf1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Ahb3rstr { fn default () -> Ahb3rstr { Ahb3rstr (0) } } # [doc = "RCC APB3 peripheral clock enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3smenr (pub u32) ; impl Apb3smenr { # [doc = "SYSCFG clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn syscfgsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYSCFG clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_syscfgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SPI3 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn spi3smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SPI3 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_spi3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LPUART1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lpuart1smen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LPUART1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lpuart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "I2C3 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn i2c3smen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I2C3 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_i2c3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LPTIM1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lptim1smen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lptim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LPTIM3 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lptim3smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LPTIM3 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lptim3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "LPTIM4 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn lptim4smen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "LPTIM4 clocks enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_lptim4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "OPAMP clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn opampsmen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "OPAMP clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_opampsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "COMP clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn compsmen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "COMP clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_compsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "VREFBUF clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn vrefsmen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "VREFBUF clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_vrefsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "RTC and TAMP APB clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub const fn rtcapbsmen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "RTC and TAMP APB clock enable during Sleep and Stop modes Set and cleared by software. Note: This bit must be set to allow the peripheral to wake up from Stop modes."]
pub fn set_rtcapbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Apb3smenr { fn default () -> Apb3smenr { Apb3smenr (0) } } # [doc = "RCC clock interrupt clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cicr (pub u32) ; impl Cicr { # [doc = "LSI ready interrupt clear Writing this bit to 1 clears the LSIRDYF flag. Writing 0 has no effect."]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt clear Writing this bit to 1 clears the LSIRDYF flag. Writing 0 has no effect."]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt clear Writing this bit to 1 clears the LSERDYF flag. Writing 0 has no effect."]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt clear Writing this bit to 1 clears the LSERDYF flag. Writing 0 has no effect."]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSIS ready interrupt clear Writing this bit to 1 clears the MSISRDYF flag. Writing 0 has no effect."]
pub const fn msisrdyc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSIS ready interrupt clear Writing this bit to 1 clears the MSISRDYF flag. Writing 0 has no effect."]
pub fn set_msisrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI16 ready interrupt clear Writing this bit to 1 clears the HSIRDYF flag. Writing 0 has no effect."]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready interrupt clear Writing this bit to 1 clears the HSIRDYF flag. Writing 0 has no effect."]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt clear Writing this bit to 1 clears the HSERDYF flag. Writing 0 has no effect."]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt clear Writing this bit to 1 clears the HSERDYF flag. Writing 0 has no effect."]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "HSI48 ready interrupt clear Writing this bit to 1 clears the HSI48RDYF flag. Writing 0 has no effect."]
pub const fn hsi48rdyc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt clear Writing this bit to 1 clears the HSI48RDYF flag. Writing 0 has no effect."]
pub fn set_hsi48rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLL1 ready interrupt clear Writing this bit to 1 clears the PLL1RDYF flag. Writing 0 has no effect."]
pub fn pllrdyc (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 ready interrupt clear Writing this bit to 1 clears the PLL1RDYF flag. Writing 0 has no effect."]
pub fn set_pllrdyc (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Clock security system interrupt clear Writing this bit to 1 clears the CSSF flag. Writing 0 has no effect."]
pub const fn cssc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt clear Writing this bit to 1 clears the CSSF flag. Writing 0 has no effect."]
pub fn set_cssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "MSIK oscillator ready interrupt clear Writing this bit to 1 clears the MSIKRDYF flag. Writing 0 has no effect."]
pub const fn msikrdyc (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "MSIK oscillator ready interrupt clear Writing this bit to 1 clears the MSIKRDYF flag. Writing 0 has no effect."]
pub fn set_msikrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SHSI oscillator ready interrupt clear Writing this bit to 1 clears the SHSIRDYF flag. Writing 0 has no effect."]
pub const fn shsirdyc (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SHSI oscillator ready interrupt clear Writing this bit to 1 clears the SHSIRDYF flag. Writing 0 has no effect."]
pub fn set_shsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Cicr { fn default () -> Cicr { Cicr (0) } } # [doc = "RCC AHB2 peripheral clock enable register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2enr2 (pub u32) ; impl Ahb2enr2 { # [doc = "FSMC clock enable Set and cleared by software."]
pub const fn fsmcen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "FSMC clock enable Set and cleared by software."]
pub fn set_fsmcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "OCTOSPI1 clock enable Set and cleared by software."]
pub const fn octospi1en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI1 clock enable Set and cleared by software."]
pub fn set_octospi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "OCTOSPI2 clock enable Set and cleared by software."]
pub const fn octospi2en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI2 clock enable Set and cleared by software."]
pub fn set_octospi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Ahb2enr2 { fn default () -> Ahb2enr2 { Ahb2enr2 (0) } } # [doc = "RCC AHB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3enr (pub u32) ; impl Ahb3enr { # [doc = "LPGPIO1 enable Set and cleared by software."]
pub const fn lpgpio1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LPGPIO1 enable Set and cleared by software."]
pub fn set_lpgpio1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "PWR clock enable Set and cleared by software."]
pub const fn pwren (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "PWR clock enable Set and cleared by software."]
pub fn set_pwren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "ADC4 clock enable Set and cleared by software."]
pub const fn adc4en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "ADC4 clock enable Set and cleared by software."]
pub fn set_adc4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "DAC1 clock enable Set and cleared by software."]
pub const fn dac1en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "DAC1 clock enable Set and cleared by software."]
pub fn set_dac1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LPDMA1 clock enable Set and cleared by software."]
pub const fn lpdma1en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPDMA1 clock enable Set and cleared by software."]
pub fn set_lpdma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADF1 clock enable Set and cleared by software."]
pub const fn adf1en (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADF1 clock enable Set and cleared by software."]
pub fn set_adf1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "GTZC2 clock enable Set and cleared by software."]
pub const fn gtzc2en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "GTZC2 clock enable Set and cleared by software."]
pub fn set_gtzc2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SRAM4 clock enable Set and reset by software."]
pub const fn sram4en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM4 clock enable Set and reset by software."]
pub fn set_sram4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb3enr { fn default () -> Ahb3enr { Ahb3enr (0) } } # [doc = "RCC AHB2 peripheral clocks enable in Sleep and Stop modes register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2smenr2 (pub u32) ; impl Ahb2smenr2 { # [doc = "FSMC clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn fsmcsmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "FSMC clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_fsmcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "OCTOSPI1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn octospi1smen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI1 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_octospi1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "OCTOSPI2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub const fn octospi2smen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI2 clocks enable during Sleep and Stop modes Set and cleared by software."]
pub fn set_octospi2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Ahb2smenr2 { fn default () -> Ahb2smenr2 { Ahb2smenr2 (0) } } # [doc = "RCC AHB2 peripheral reset register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2rstr1 (pub u32) ; impl Ahb2rstr1 { # [doc = "IO port A reset Set and cleared by software."]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A reset Set and cleared by software."]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B reset Set and cleared by software."]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B reset Set and cleared by software."]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C reset Set and cleared by software."]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C reset Set and cleared by software."]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D reset Set and cleared by software."]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D reset Set and cleared by software."]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E reset Set and cleared by software."]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E reset Set and cleared by software."]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F reset Set and cleared by software."]
pub const fn gpiofrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F reset Set and cleared by software."]
pub fn set_gpiofrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G reset Set and cleared by software."]
pub const fn gpiogrst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G reset Set and cleared by software."]
pub fn set_gpiogrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H reset Set and cleared by software."]
pub const fn gpiohrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H reset Set and cleared by software."]
pub fn set_gpiohrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I reset Set and cleared by software."]
pub const fn gpioirst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I reset Set and cleared by software."]
pub fn set_gpioirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC1 reset Set and cleared by software."]
pub const fn adc1rst (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC1 reset Set and cleared by software."]
pub fn set_adc1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "DCMI and PSSI reset Set and cleared by software."]
pub const fn dcmirst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "DCMI and PSSI reset Set and cleared by software."]
pub fn set_dcmirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "OTG_FS reset Set and cleared by software."]
pub const fn usb_otg_fsrst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "OTG_FS reset Set and cleared by software."]
pub fn set_usb_otg_fsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "AES hardware accelerator reset Set and cleared by software."]
pub const fn aesrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AES hardware accelerator reset Set and cleared by software."]
pub fn set_aesrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Hash reset Set and cleared by software."]
pub const fn hashrst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Hash reset Set and cleared by software."]
pub fn set_hashrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Random number generator reset Set and cleared by software."]
pub const fn rngrst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Random number generator reset Set and cleared by software."]
pub fn set_rngrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "PKA reset Set and cleared by software."]
pub const fn pkarst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "PKA reset Set and cleared by software."]
pub fn set_pkarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "SAES hardware accelerator reset Set and cleared by software."]
pub const fn saesrst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SAES hardware accelerator reset Set and cleared by software."]
pub fn set_saesrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "OCTOSPIM reset Set and cleared by software."]
pub const fn octospimrst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "OCTOSPIM reset Set and cleared by software."]
pub fn set_octospimrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "OTFDEC1 reset Set and cleared by software."]
pub const fn otfdec1rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "OTFDEC1 reset Set and cleared by software."]
pub fn set_otfdec1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "OTFDEC2 reset Set and cleared by software."]
pub const fn otfdec2rst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "OTFDEC2 reset Set and cleared by software."]
pub fn set_otfdec2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "SDMMC1 reset Set and cleared by software."]
pub const fn sdmmc1rst (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 reset Set and cleared by software."]
pub fn set_sdmmc1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "SDMMC2 reset Set and cleared by software."]
pub const fn sdmmc2rst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 reset Set and cleared by software."]
pub fn set_sdmmc2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } } impl Default for Ahb2rstr1 { fn default () -> Ahb2rstr1 { Ahb2rstr1 (0) } } # [doc = "RCC clock configuration register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr3 (pub u32) ; impl Cfgr3 { # [doc = "APB3 prescaler Set and cleared by software to control the division factor of the APB3 clock (PCLK3). 0xx: HCLK not divided"]
pub const fn ppre3 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB3 prescaler Set and cleared by software to control the division factor of the APB3 clock (PCLK3). 0xx: HCLK not divided"]
pub fn set_ppre3 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } # [doc = "AHB3 clock disable This bit can be set in order to further reduce power consumption, when none of the AHB3 peripherals (except SRAM4) are used and when their clocks are disabled in RCC_AHB3ENR. When this bit is set, all the AHB3 peripherals clocks are off, except for SRAM4."]
pub const fn ahb3dis (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AHB3 clock disable This bit can be set in order to further reduce power consumption, when none of the AHB3 peripherals (except SRAM4) are used and when their clocks are disabled in RCC_AHB3ENR. When this bit is set, all the AHB3 peripherals clocks are off, except for SRAM4."]
pub fn set_ahb3dis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "APB3 clock disable This bit can be set in order to further reduce power consumption, when none of the APB3 peripherals from RCC_APB3ENR are used and when their clocks are disabled in RCC_APB3ENR. When this bit is set, all the APB3 peripherals clocks are off."]
pub const fn apb3dis (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "APB3 clock disable This bit can be set in order to further reduce power consumption, when none of the APB3 peripherals from RCC_APB3ENR are used and when their clocks are disabled in RCC_APB3ENR. When this bit is set, all the APB3 peripherals clocks are off."]
pub fn set_apb3dis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } } impl Default for Cfgr3 { fn default () -> Cfgr3 { Cfgr3 (0) } } # [doc = "RCC clock interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cier (pub u32) ; impl Cier { # [doc = "LSI ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the LSI oscillator stabilization."]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the LSI oscillator stabilization."]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the LSE oscillator stabilization."]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the LSE oscillator stabilization."]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSIS ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the MSIS oscillator stabilization."]
pub const fn msisrdyie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSIS ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the MSIS oscillator stabilization."]
pub fn set_msisrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI16 ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the HSI16 oscillator stabilization."]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the HSI16 oscillator stabilization."]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the HSE oscillator stabilization."]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the HSE oscillator stabilization."]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "HSI48 ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the HSI48 oscillator stabilization."]
pub const fn hsi48rdyie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the HSI48 oscillator stabilization."]
pub fn set_hsi48rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLL ready interrupt enable Set and cleared by software to enable/disable interrupt caused by PLL1 lock."]
pub fn pllrdyie (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt enable Set and cleared by software to enable/disable interrupt caused by PLL1 lock."]
pub fn set_pllrdyie (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "MSIK ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the MSIK oscillator stabilization."]
pub const fn msikrdyie (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "MSIK ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the MSIK oscillator stabilization."]
pub fn set_msikrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SHSI ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the SHSI oscillator stabilization."]
pub const fn shsirdyie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SHSI ready interrupt enable Set and cleared by software to enable/disable interrupt caused by the SHSI oscillator stabilization."]
pub fn set_shsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Cier { fn default () -> Cier { Cier (0) } } # [doc = "RCC internal clock sources calibration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icscr1 (pub u32) ; impl Icscr1 { # [doc = "MSIRC3 clock calibration for MSI ranges 12 to 15 These bits are initialized at startup with the factory-programmed MSIRC3 calibration trim value for ranges 12 to 15. When MSITRIM3 is written, MSICAL3 is updated with the sum of MSITRIM3[4:0]
and the factory calibration trim value MSIRC2[4:0]. There is no hardware protection to limit a potential overflow due to the addition of MSITRIM bitfield and factory program bitfield for this calibration value. Control must be managed by software at user level."]
pub const fn msical3 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "MSIRC3 clock calibration for MSI ranges 12 to 15 These bits are initialized at startup with the factory-programmed MSIRC3 calibration trim value for ranges 12 to 15. When MSITRIM3 is written, MSICAL3 is updated with the sum of MSITRIM3[4:0]
and the factory calibration trim value MSIRC2[4:0]. There is no hardware protection to limit a potential overflow due to the addition of MSITRIM bitfield and factory program bitfield for this calibration value. Control must be managed by software at user level."]
pub fn set_msical3 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "MSIRC2 clock calibration for MSI ranges 8 to 11 These bits are initialized at startup with the factory-programmed MSIRC2 calibration trim value for ranges 8 to 11. When MSITRIM2 is written, MSICAL2 is updated with the sum of MSITRIM2[4:0]
and the factory calibration trim value MSIRC2[4:0]. There is no hardware protection to limit a potential overflow due to the addition of MSITRIM bitfield and factory program bitfield for this calibration value. Control must be managed by software at user level."]
pub const fn msical2 (& self) -> u8 { let val = (self . 0 >> 5usize) & 0x1f ; val as u8 } # [doc = "MSIRC2 clock calibration for MSI ranges 8 to 11 These bits are initialized at startup with the factory-programmed MSIRC2 calibration trim value for ranges 8 to 11. When MSITRIM2 is written, MSICAL2 is updated with the sum of MSITRIM2[4:0]
and the factory calibration trim value MSIRC2[4:0]. There is no hardware protection to limit a potential overflow due to the addition of MSITRIM bitfield and factory program bitfield for this calibration value. Control must be managed by software at user level."]
pub fn set_msical2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 5usize)) | (((val as u32) & 0x1f) << 5usize) ; } # [doc = "MSIRC1 clock calibration for MSI ranges 4 to 7 These bits are initialized at startup with the factory-programmed MSIRC1 calibration trim value for ranges 4 to 7. When MSITRIM1 is written, MSICAL1 is updated with the sum of MSITRIM1[4:0]
and the factory calibration trim value MSIRC1[4:0]. There is no hardware protection to limit a potential overflow due to the addition of MSITRIM bitfield and factory program bitfield for this calibration value. Control must be managed by software at user level."]
pub const fn msical1 (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x1f ; val as u8 } # [doc = "MSIRC1 clock calibration for MSI ranges 4 to 7 These bits are initialized at startup with the factory-programmed MSIRC1 calibration trim value for ranges 4 to 7. When MSITRIM1 is written, MSICAL1 is updated with the sum of MSITRIM1[4:0]
and the factory calibration trim value MSIRC1[4:0]. There is no hardware protection to limit a potential overflow due to the addition of MSITRIM bitfield and factory program bitfield for this calibration value. Control must be managed by software at user level."]
pub fn set_msical1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 10usize)) | (((val as u32) & 0x1f) << 10usize) ; } # [doc = "MSIRC0 clock calibration for MSI ranges 0 to 3 These bits are initialized at startup with the factory-programmed MSIRC0 calibration trim value for ranges 0 to 3. When MSITRIM0 is written, MSICAL0 is updated with the sum of MSITRIM0[4:0]
and the factory-programmed calibration trim value MSIRC0[4:0]."]
pub const fn msical0 (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x1f ; val as u8 } # [doc = "MSIRC0 clock calibration for MSI ranges 0 to 3 These bits are initialized at startup with the factory-programmed MSIRC0 calibration trim value for ranges 0 to 3. When MSITRIM0 is written, MSICAL0 is updated with the sum of MSITRIM0[4:0]
and the factory-programmed calibration trim value MSIRC0[4:0]."]
pub fn set_msical0 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 15usize)) | (((val as u32) & 0x1f) << 15usize) ; } # [doc = "MSI bias mode selection Set by software to select the MSI bias mode. By default, the MSI bias is in continuous mode in order to maintain the output clocks accuracy. Setting this bit reduces the MSI consumption under range 4 but decrease its accuracy."]
pub const fn msibias (& self) -> super :: vals :: Msibias { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Msibias (val as u8) } # [doc = "MSI bias mode selection Set by software to select the MSI bias mode. By default, the MSI bias is in continuous mode in order to maintain the output clocks accuracy. Setting this bit reduces the MSI consumption under range 4 but decrease its accuracy."]
pub fn set_msibias (& mut self , val : super :: vals :: Msibias) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "MSI clock range selection Set by software to select the MSIS and MSIK clocks range with MSISRANGE[3:0]
and MSIKRANGE[3:0]. Write 0 has no effect. After exiting Standby or Shutdown mode, or after a reset, this bit is at 0 and the MSIS and MSIK ranges are provided by MSISSRANGE[3:0]
and MSIKSRANGE[3:0]
in RCC_CSR."]
pub const fn msirgsel (& self) -> super :: vals :: Msirgsel { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Msirgsel (val as u8) } # [doc = "MSI clock range selection Set by software to select the MSIS and MSIK clocks range with MSISRANGE[3:0]
and MSIKRANGE[3:0]. Write 0 has no effect. After exiting Standby or Shutdown mode, or after a reset, this bit is at 0 and the MSIS and MSIK ranges are provided by MSISSRANGE[3:0]
and MSIKSRANGE[3:0]
in RCC_CSR."]
pub fn set_msirgsel (& mut self , val : super :: vals :: Msirgsel) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "MSIK clock ranges These bits are configured by software to choose the frequency range of MSIK oscillator when MSIRGSEL is set. 16 frequency ranges are available: Note: MSIKRANGE can be modified when MSIK is OFF (MSISON = 0) or when MSIK is ready (MSIKRDY = 1). MSIKRANGE must NOT be modified when MSIK is ON and NOT ready (MSIKON = 1 and MSIKRDY = 0) MSIKRANGE is kept when the device wakes up from Stop mode, except when the MSIK range is above 24 MHz. In this case MSIKRANGE is changed by hardware into Range 2 (24 MHz)."]
pub const fn msikrange (& self) -> super :: vals :: Msirange { let val = (self . 0 >> 24usize) & 0x0f ; super :: vals :: Msirange (val as u8) } # [doc = "MSIK clock ranges These bits are configured by software to choose the frequency range of MSIK oscillator when MSIRGSEL is set. 16 frequency ranges are available: Note: MSIKRANGE can be modified when MSIK is OFF (MSISON = 0) or when MSIK is ready (MSIKRDY = 1). MSIKRANGE must NOT be modified when MSIK is ON and NOT ready (MSIKON = 1 and MSIKRDY = 0) MSIKRANGE is kept when the device wakes up from Stop mode, except when the MSIK range is above 24 MHz. In this case MSIKRANGE is changed by hardware into Range 2 (24 MHz)."]
pub fn set_msikrange (& mut self , val : super :: vals :: Msirange) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val . 0 as u32) & 0x0f) << 24usize) ; } # [doc = "MSIS clock ranges These bits are configured by software to choose the frequency range of MSIS oscillator when MSIRGSEL is set. 16 frequency ranges are available: Note: MSISRANGE can be modified when MSIS is OFF (MSISON = 0) or when MSIS is ready (MSISRDY = 1). MSISRANGE must NOT be modified when MSIS is ON and NOT ready (MSISON = 1 and MSISRDY = 0) MSISRANGE is kept when the device wakes up from Stop mode, except when the MSIS range is above 24 MHz. In this case MSISRANGE is changed by hardware into Range 2 (24 MHz)."]
pub const fn msisrange (& self) -> super :: vals :: Msirange { let val = (self . 0 >> 28usize) & 0x0f ; super :: vals :: Msirange (val as u8) } # [doc = "MSIS clock ranges These bits are configured by software to choose the frequency range of MSIS oscillator when MSIRGSEL is set. 16 frequency ranges are available: Note: MSISRANGE can be modified when MSIS is OFF (MSISON = 0) or when MSIS is ready (MSISRDY = 1). MSISRANGE must NOT be modified when MSIS is ON and NOT ready (MSISON = 1 and MSISRDY = 0) MSISRANGE is kept when the device wakes up from Stop mode, except when the MSIS range is above 24 MHz. In this case MSISRANGE is changed by hardware into Range 2 (24 MHz)."]
pub fn set_msisrange (& mut self , val : super :: vals :: Msirange) { self . 0 = (self . 0 & ! (0x0f << 28usize)) | (((val . 0 as u32) & 0x0f) << 28usize) ; } } impl Default for Icscr1 { fn default () -> Icscr1 { Icscr1 (0) } } # [doc = "RCC secure configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Seccfgr (pub u32) ; impl Seccfgr { # [doc = "HSI clock configuration and status bits security Set and reset by software."]
pub const fn hsisec (& self) -> super :: vals :: Security { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "HSI clock configuration and status bits security Set and reset by software."]
pub fn set_hsisec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "HSE clock configuration bits, status bits and HSE_CSS security Set and reset by software."]
pub const fn hsesec (& self) -> super :: vals :: Security { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "HSE clock configuration bits, status bits and HSE_CSS security Set and reset by software."]
pub fn set_hsesec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "MSI clock configuration and status bits security Set and reset by software."]
pub const fn msisec (& self) -> super :: vals :: Security { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "MSI clock configuration and status bits security Set and reset by software."]
pub fn set_msisec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "LSI clock configuration and status bits security Set and reset by software."]
pub const fn lsisec (& self) -> super :: vals :: Security { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "LSI clock configuration and status bits security Set and reset by software."]
pub fn set_lsisec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "LSE clock configuration and status bits security Set and reset by software."]
pub const fn lsesec (& self) -> super :: vals :: Security { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "LSE clock configuration and status bits security Set and reset by software."]
pub fn set_lsesec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "SYSCLK clock selection, STOPWUCK bit, clock output on MCO configuration security Set and reset by software."]
pub const fn sysclksec (& self) -> super :: vals :: Security { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "SYSCLK clock selection, STOPWUCK bit, clock output on MCO configuration security Set and reset by software."]
pub fn set_sysclksec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "AHBx/APBx prescaler configuration bits security Set and reset by software."]
pub const fn prescsec (& self) -> super :: vals :: Security { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "AHBx/APBx prescaler configuration bits security Set and reset by software."]
pub fn set_prescsec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "PLL1 clock configuration and status bits security Set and reset by software."]
pub fn pllsec (& self , n : usize) -> super :: vals :: Security { assert ! (n < 3usize) ; let offs = 7usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "PLL1 clock configuration and status bits security Set and reset by software."]
pub fn set_pllsec (& mut self , n : usize , val : super :: vals :: Security) { assert ! (n < 3usize) ; let offs = 7usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "intermediate clock source selection security Set and reset by software."]
pub const fn iclksec (& self) -> super :: vals :: Security { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "intermediate clock source selection security Set and reset by software."]
pub fn set_iclksec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "HSI48 clock configuration and status bits security Set and reset by software."]
pub const fn hsi48sec (& self) -> super :: vals :: Security { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "HSI48 clock configuration and status bits security Set and reset by software."]
pub fn set_hsi48sec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Remove reset flag security Set and reset by software."]
pub const fn rmvfsec (& self) -> super :: vals :: Security { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Security (val as u8) } # [doc = "Remove reset flag security Set and reset by software."]
pub fn set_rmvfsec (& mut self , val : super :: vals :: Security) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } } impl Default for Seccfgr { fn default () -> Seccfgr { Seccfgr (0) } } # [doc = "RCC APB1 peripheral clock enable register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr2 (pub u32) ; impl Apb1enr2 { # [doc = "I2C4 clock enable Set and cleared by software"]
pub const fn i2c4en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "I2C4 clock enable Set and cleared by software"]
pub fn set_i2c4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LPTIM2 clock enable Set and cleared by software."]
pub const fn lptim2en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 clock enable Set and cleared by software."]
pub fn set_lptim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FDCAN1 clock enable Set and cleared by software."]
pub const fn fdcan1en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "FDCAN1 clock enable Set and cleared by software."]
pub fn set_fdcan1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "UCPD1 clock enable Set and cleared by software."]
pub const fn ucpd1en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "UCPD1 clock enable Set and cleared by software."]
pub fn set_ucpd1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Apb1enr2 { fn default () -> Apb1enr2 { Apb1enr2 (0) } } # [doc = "RCC PLL3 fractional divider register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll3fracr (pub u32) ; impl Pll3fracr { # [doc = "Fractional part of the multiplication factor for PLL3 VCO Set and reset by software to control the fractional part of the multiplication factor of the VCO. These bits can be written at any time, allowing dynamic fine-tuning of the PLL3 VCO. VCO output frequency = Fref3_ck x (PLL3N + (PLL3FRACN / 213)), with: PLL3N must be between 4 and 512. PLL3FRACN can be between 0 and 213 - 1. The input frequency Fref3_ck must be between 4 and 16 MHz. In order to change the FRACN value on-the-fly even if the PLL is enabled, the application must proceed as follows: Set the bit PLL3FRACEN to 0. Write the new fractional value into PLL3FRACN. Set the bit PLL3FRACEN to 1."]
pub const fn pllfracn (& self) -> u16 { let val = (self . 0 >> 3usize) & 0x1fff ; val as u16 } # [doc = "Fractional part of the multiplication factor for PLL3 VCO Set and reset by software to control the fractional part of the multiplication factor of the VCO. These bits can be written at any time, allowing dynamic fine-tuning of the PLL3 VCO. VCO output frequency = Fref3_ck x (PLL3N + (PLL3FRACN / 213)), with: PLL3N must be between 4 and 512. PLL3FRACN can be between 0 and 213 - 1. The input frequency Fref3_ck must be between 4 and 16 MHz. In order to change the FRACN value on-the-fly even if the PLL is enabled, the application must proceed as follows: Set the bit PLL3FRACEN to 0. Write the new fractional value into PLL3FRACN. Set the bit PLL3FRACEN to 1."]
pub fn set_pllfracn (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 3usize)) | (((val as u32) & 0x1fff) << 3usize) ; } } impl Default for Pll3fracr { fn default () -> Pll3fracr { Pll3fracr (0) } } # [doc = "RCC internal clock sources calibration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icscr2 (pub u32) ; impl Icscr2 { # [doc = "MSI clock trimming for ranges 12 to 15 These bits provide an additional user-programmable trimming value that is added to the factory-programmed calibration trim value MSIRC3[4:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the MSI."]
pub const fn msitrim3 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "MSI clock trimming for ranges 12 to 15 These bits provide an additional user-programmable trimming value that is added to the factory-programmed calibration trim value MSIRC3[4:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the MSI."]
pub fn set_msitrim3 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "MSI clock trimming for ranges 8 to 11 These bits provide an additional user-programmable trimming value that is added to the factory-programmed calibration trim value MSIRC2[4:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the MSI."]
pub const fn msitrim2 (& self) -> u8 { let val = (self . 0 >> 5usize) & 0x1f ; val as u8 } # [doc = "MSI clock trimming for ranges 8 to 11 These bits provide an additional user-programmable trimming value that is added to the factory-programmed calibration trim value MSIRC2[4:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the MSI."]
pub fn set_msitrim2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 5usize)) | (((val as u32) & 0x1f) << 5usize) ; } # [doc = "MSI clock trimming for ranges 4 to 7 These bits provide an additional user-programmable trimming value that is added to the factory-programmed calibration trim value MSIRC1[4:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the MSI."]
pub const fn msitrim1 (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x1f ; val as u8 } # [doc = "MSI clock trimming for ranges 4 to 7 These bits provide an additional user-programmable trimming value that is added to the factory-programmed calibration trim value MSIRC1[4:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the MSI."]
pub fn set_msitrim1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 10usize)) | (((val as u32) & 0x1f) << 10usize) ; } # [doc = "MSI clock trimming for ranges 0 to 3 These bits provide an additional user-programmable trimming value that is added to the factory-programmed calibration trim value MSIRC0[4:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the MSI."]
pub const fn msitrim0 (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x1f ; val as u8 } # [doc = "MSI clock trimming for ranges 0 to 3 These bits provide an additional user-programmable trimming value that is added to the factory-programmed calibration trim value MSIRC0[4:0]
bits. It can be programmed to adjust to voltage and temperature variations that influence the frequency of the MSI."]
pub fn set_msitrim0 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 15usize)) | (((val as u32) & 0x1f) << 15usize) ; } } impl Default for Icscr2 { fn default () -> Icscr2 { Icscr2 (0) } } # [doc = "RCC clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "MSIS clock enable Set and cleared by software. Cleared by hardware to stop the MSIS oscillator when entering Stop, Standby or Shutdown mode. Set by hardware to force the MSIS oscillator ON when exiting Standby or Shutdown mode. Set by hardware to force the MSIS oscillator ON when STOPWUCK = 0 when exiting Stop modes or in case of a failure of the HSE oscillator. Set by hardware when used directly or indirectly as system clock."]
pub const fn msison (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "MSIS clock enable Set and cleared by software. Cleared by hardware to stop the MSIS oscillator when entering Stop, Standby or Shutdown mode. Set by hardware to force the MSIS oscillator ON when exiting Standby or Shutdown mode. Set by hardware to force the MSIS oscillator ON when STOPWUCK = 0 when exiting Stop modes or in case of a failure of the HSE oscillator. Set by hardware when used directly or indirectly as system clock."]
pub fn set_msison (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "MSI enable for some peripheral kernels Set and cleared by software to force MSI ON even in Stop modes. Keeping the MSI ON in Stop mode allows the communication speed not to be reduced by the MSI startup time. This bit has no effect on MSISON and MSIKON values (see autonomous mode for more details). The MSIKERON must be configured at 0 before entering Stop 3 mode."]
pub const fn msikeron (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "MSI enable for some peripheral kernels Set and cleared by software to force MSI ON even in Stop modes. Keeping the MSI ON in Stop mode allows the communication speed not to be reduced by the MSI startup time. This bit has no effect on MSISON and MSIKON values (see autonomous mode for more details). The MSIKERON must be configured at 0 before entering Stop 3 mode."]
pub fn set_msikeron (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "MSIS clock ready flag Set by hardware to indicate that the MSIS oscillator is stable. This bit is set only when MSIS is enabled by software by setting MSISON. Note: Once the MSISON bit is cleared, MSISRDY goes low after six MSIS clock cycles."]
pub const fn msisrdy (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "MSIS clock ready flag Set by hardware to indicate that the MSIS oscillator is stable. This bit is set only when MSIS is enabled by software by setting MSISON. Note: Once the MSISON bit is cleared, MSISRDY goes low after six MSIS clock cycles."]
pub fn set_msisrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "MSI clock PLL-mode enable Set and cleared by software to enable/disable the PLL part of the MSI clock source. MSIPLLEN must be enabled after LSE is enabled (LSEON enabled) and ready (LSERDY set by hardware). A hardware protection prevents from enabling MSIPLLEN if LSE is not ready. This bit is cleared by hardware when LSE is disabled (LSEON = 0) or when the CSS on LSE detects a LSE failure (see RCC_CSR)."]
pub const fn msipllen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "MSI clock PLL-mode enable Set and cleared by software to enable/disable the PLL part of the MSI clock source. MSIPLLEN must be enabled after LSE is enabled (LSEON enabled) and ready (LSERDY set by hardware). A hardware protection prevents from enabling MSIPLLEN if LSE is not ready. This bit is cleared by hardware when LSE is disabled (LSEON = 0) or when the CSS on LSE detects a LSE failure (see RCC_CSR)."]
pub fn set_msipllen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "MSIK clock enable Set and cleared by software. Cleared by hardware to stop the MSIK when entering Stop, Standby or Shutdown mode. Set by hardware to force the MSIK oscillator ON when exiting Standby or Shutdown mode. Set by hardware to force the MSIK oscillator ON when STOPWUCK = 0 or STOPKERWUCK = 0 when exiting Stop modes or in case of a failure of the HSE oscillator."]
pub const fn msikon (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "MSIK clock enable Set and cleared by software. Cleared by hardware to stop the MSIK when entering Stop, Standby or Shutdown mode. Set by hardware to force the MSIK oscillator ON when exiting Standby or Shutdown mode. Set by hardware to force the MSIK oscillator ON when STOPWUCK = 0 or STOPKERWUCK = 0 when exiting Stop modes or in case of a failure of the HSE oscillator."]
pub fn set_msikon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MSIK clock ready flag Set by hardware to indicate that the MSIK is stable. This bit is set only when MSI kernel oscillator is enabled by software by setting MSIKON. Note: Once the MSIKON bit is cleared, MSIKRDY goes low after six MSIK oscillator clock cycles."]
pub const fn msikrdy (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "MSIK clock ready flag Set by hardware to indicate that the MSIK is stable. This bit is set only when MSI kernel oscillator is enabled by software by setting MSIKON. Note: Once the MSIKON bit is cleared, MSIKRDY goes low after six MSIK oscillator clock cycles."]
pub fn set_msikrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "MSI clock with PLL mode selection Set and cleared by software to select which MSI output clock uses the PLL mode. This bit can be written only when the MSI PLL mode is disabled (MSIPLLEN = 0). Note: If the MSI kernel clock output uses the same oscillator source than the MSI system clock output, then the PLL mode is applied to the both clocks outputs."]
pub const fn msipllsel (& self) -> super :: vals :: Msipllsel { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Msipllsel (val as u8) } # [doc = "MSI clock with PLL mode selection Set and cleared by software to select which MSI output clock uses the PLL mode. This bit can be written only when the MSI PLL mode is disabled (MSIPLLEN = 0). Note: If the MSI kernel clock output uses the same oscillator source than the MSI system clock output, then the PLL mode is applied to the both clocks outputs."]
pub fn set_msipllsel (& mut self , val : super :: vals :: Msipllsel) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "MSI PLL mode fast startup Set and reset by software to enable/disable the fast PLL mode start-up of the MSI clock source. This bit is used only if PLL mode is selected (MSIPLLEN = 1). The fast start-up feature is not active the first time the PLL mode is selected. The fast start-up is active when the MSI in PLL mode returns from switch off."]
pub const fn msipllfast (& self) -> super :: vals :: Msipllfast { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Msipllfast (val as u8) } # [doc = "MSI PLL mode fast startup Set and reset by software to enable/disable the fast PLL mode start-up of the MSI clock source. This bit is used only if PLL mode is selected (MSIPLLEN = 1). The fast start-up feature is not active the first time the PLL mode is selected. The fast start-up is active when the MSI in PLL mode returns from switch off."]
pub fn set_msipllfast (& mut self , val : super :: vals :: Msipllfast) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "HSI16 clock enable Set and cleared by software. Cleared by hardware to stop the HSI16 oscillator when entering Stop, Standby or Shutdown mode. Set by hardware to force the HSI16 oscillator ON when STOPWUCK = 1 when leaving Stop modes, or in case of failure of the HSE crystal oscillator. This bit is set by hardware if the HSI16 is used directly or indirectly as system clock."]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "HSI16 clock enable Set and cleared by software. Cleared by hardware to stop the HSI16 oscillator when entering Stop, Standby or Shutdown mode. Set by hardware to force the HSI16 oscillator ON when STOPWUCK = 1 when leaving Stop modes, or in case of failure of the HSE crystal oscillator. This bit is set by hardware if the HSI16 is used directly or indirectly as system clock."]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "HSI16 enable for some peripheral kernels Set and cleared by software to force HSI16 ON even in Stop modes. Keeping the HSI16 ON in Stop mode allows the communication speed not to be reduced by the HSI16 startup time. This bit has no effect on HSION value. Refer to for more details. The HSIKERON must be configured at 0 before entering Stop 3 mode."]
pub const fn hsikeron (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "HSI16 enable for some peripheral kernels Set and cleared by software to force HSI16 ON even in Stop modes. Keeping the HSI16 ON in Stop mode allows the communication speed not to be reduced by the HSI16 startup time. This bit has no effect on HSION value. Refer to for more details. The HSIKERON must be configured at 0 before entering Stop 3 mode."]
pub fn set_hsikeron (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI16 clock ready flag Set by hardware to indicate that HSI16 oscillator is stable. This bit is set only when HSI16 is enabled by software by setting HSION. Note: Once the HSION bit is cleared, HSIRDY goes low after six HSI16 clock cycles."]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI16 clock ready flag Set by hardware to indicate that HSI16 oscillator is stable. This bit is set only when HSI16 is enabled by software by setting HSION. Note: Once the HSION bit is cleared, HSIRDY goes low after six HSI16 clock cycles."]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSI48 clock enable Set and cleared by software. Cleared by hardware to stop the HSI48 when entering in Stop, Standby or Shutdown modes."]
pub const fn hsi48on (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "HSI48 clock enable Set and cleared by software. Cleared by hardware to stop the HSI48 when entering in Stop, Standby or Shutdown modes."]
pub fn set_hsi48on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "HSI48 clock ready flag Set by hardware to indicate that HSI48 oscillator is stable. This bit is set only when HSI48 is enabled by software by setting HSI48ON."]
pub const fn hsi48rdy (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "HSI48 clock ready flag Set by hardware to indicate that HSI48 oscillator is stable. This bit is set only when HSI48 is enabled by software by setting HSI48ON."]
pub fn set_hsi48rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "SHSI clock enable Set and cleared by software. Cleared by hardware to stop the SHSI when entering in Stop, Standby or Shutdown modes."]
pub const fn shsion (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SHSI clock enable Set and cleared by software. Cleared by hardware to stop the SHSI when entering in Stop, Standby or Shutdown modes."]
pub fn set_shsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SHSI clock ready flag Set by hardware to indicate that the SHSI oscillator is stable. This bit is set only when SHSI is enabled by software by setting SHSION. Note: Once the SHSION bit is cleared, SHSIRDY goes low after six SHSI clock cycles."]
pub const fn shsirdy (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SHSI clock ready flag Set by hardware to indicate that the SHSI oscillator is stable. This bit is set only when SHSI is enabled by software by setting SHSION. Note: Once the SHSION bit is cleared, SHSIRDY goes low after six SHSI clock cycles."]
pub fn set_shsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "HSE clock enable Set and cleared by software. Cleared by hardware to stop the HSE oscillator when entering Stop, Standby or Shutdown mode. This bit cannot be reset if the HSE oscillator is used directly or indirectly as the system clock."]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSE clock enable Set and cleared by software. Cleared by hardware to stop the HSE oscillator when entering Stop, Standby or Shutdown mode. This bit cannot be reset if the HSE oscillator is used directly or indirectly as the system clock."]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSE clock ready flag Set by hardware to indicate that the HSE oscillator is stable. Note: Once the HSEON bit is cleared, HSERDY goes low after six HSE clock cycles."]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSE clock ready flag Set by hardware to indicate that the HSE oscillator is stable. Note: Once the HSEON bit is cleared, HSERDY goes low after six HSE clock cycles."]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSE crystal oscillator bypass Set and cleared by software to bypass the oscillator with an external clock. The external clock must be enabled with the HSEON bit set, to be used by the device. The HSEBYP bit can be written only if the HSE oscillator is disabled."]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSE crystal oscillator bypass Set and cleared by software to bypass the oscillator with an external clock. The external clock must be enabled with the HSEON bit set, to be used by the device. The HSEBYP bit can be written only if the HSE oscillator is disabled."]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Clock security system enable Set by software to enable the clock security system. When CSSON is set, the clock detector is enabled by hardware when the HSE oscillator is ready, and disabled by hardware if a HSE clock failure is detected. This bit is set only and is cleared by reset."]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Clock security system enable Set by software to enable the clock security system. When CSSON is set, the clock detector is enabled by hardware when the HSE oscillator is ready, and disabled by hardware if a HSE clock failure is detected. This bit is set only and is cleared by reset."]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "HSE external clock bypass mode Set and reset by software to select the external clock mode in bypass mode. External clock mode must be configured with HSEON bit to be used by the device. This bit can be written only if the HSE oscillator is disabled. This bit is active only if the HSE bypass mode is enabled."]
pub const fn hseext (& self) -> super :: vals :: Hseext { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: Hseext (val as u8) } # [doc = "HSE external clock bypass mode Set and reset by software to select the external clock mode in bypass mode. External clock mode must be configured with HSEON bit to be used by the device. This bit can be written only if the HSE oscillator is disabled. This bit is active only if the HSE bypass mode is enabled."]
pub fn set_hseext (& mut self , val : super :: vals :: Hseext) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "PLL1 enable Set and cleared by software to enable the main PLL. Cleared by hardware when entering Stop, Standby or Shutdown mode. This bit cannot be reset if the PLL1 clock is used as the system clock."]
pub fn pllon (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 24usize + n * 2usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 enable Set and cleared by software to enable the main PLL. Cleared by hardware when entering Stop, Standby or Shutdown mode. This bit cannot be reset if the PLL1 clock is used as the system clock."]
pub fn set_pllon (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 24usize + n * 2usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "PLL1 clock ready flag Set by hardware to indicate that the PLL1 is locked."]
pub fn pllrdy (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 25usize + n * 2usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 clock ready flag Set by hardware to indicate that the PLL1 is locked."]
pub fn set_pllrdy (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 25usize + n * 2usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } }