

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "Clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Internal clock sources calibration register"]
pub fn icscr (self) -> crate :: common :: Reg < regs :: Icscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Clock recovery RC register"]
pub fn crrcr (self) -> crate :: common :: Reg < regs :: Crrcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Clock configuration register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Clock interrupt enable register"]
pub fn cier (self) -> crate :: common :: Reg < regs :: Cier , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Clock interrupt flag register"]
pub fn cifr (self) -> crate :: common :: Reg < regs :: Cifr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Clock interrupt clear register"]
pub fn cicr (self) -> crate :: common :: Reg < regs :: Cicr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "GPIO reset register"]
pub fn gpiorstr (self) -> crate :: common :: Reg < regs :: Gpiorstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "AHB peripheral reset register"]
pub fn ahbrstr (self) -> crate :: common :: Reg < regs :: Ahbrstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "APB2 peripheral reset register"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "APB1 peripheral reset register"]
pub fn apb1rstr (self) -> crate :: common :: Reg < regs :: Apb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "GPIO clock enable register"]
pub fn gpioenr (self) -> crate :: common :: Reg < regs :: Gpioenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "AHB peripheral clock enable register"]
pub fn ahbenr (self) -> crate :: common :: Reg < regs :: Ahbenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "APB2 peripheral clock enable register"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "APB1 peripheral clock enable register"]
pub fn apb1enr (self) -> crate :: common :: Reg < regs :: Apb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "GPIO clock enable in sleep mode register"]
pub fn gpiosmen (self) -> crate :: common :: Reg < regs :: Gpiosmen , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "AHB peripheral clock enable in sleep mode register"]
pub fn ahbsmenr (self) -> crate :: common :: Reg < regs :: Ahbsmenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "APB2 peripheral clock enable in sleep mode register"]
pub fn apb2smenr (self) -> crate :: common :: Reg < regs :: Apb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "APB1 peripheral clock enable in sleep mode register"]
pub fn apb1smenr (self) -> crate :: common :: Reg < regs :: Apb1smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "Clock configuration register"]
pub fn ccipr (self) -> crate :: common :: Reg < regs :: Ccipr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "Control and status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Uartsel (pub u8) ; impl Uartsel { # [doc = "APB clock selected as peripheral clock"]
pub const APB : Self = Self (0) ; # [doc = "System clock selected as peripheral clock"]
pub const SYSTEM : Self = Self (0x01) ; # [doc = "HSI16 clock selected as peripheral clock"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "LSE clock selected as peripheral clock"]
pub const LSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllmul (pub u8) ; impl Pllmul { # [doc = "PLL clock entry x 3"]
pub const MUL3 : Self = Self (0) ; # [doc = "PLL clock entry x 4"]
pub const MUL4 : Self = Self (0x01) ; # [doc = "PLL clock entry x 6"]
pub const MUL6 : Self = Self (0x02) ; # [doc = "PLL clock entry x 8"]
pub const MUL8 : Self = Self (0x03) ; # [doc = "PLL clock entry x 12"]
pub const MUL12 : Self = Self (0x04) ; # [doc = "PLL clock entry x 16"]
pub const MUL16 : Self = Self (0x05) ; # [doc = "PLL clock entry x 24"]
pub const MUL24 : Self = Self (0x06) ; # [doc = "PLL clock entry x 32"]
pub const MUL32 : Self = Self (0x07) ; # [doc = "PLL clock entry x 48"]
pub const MUL48 : Self = Self (0x08) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsrc (pub u8) ; impl Pllsrc { # [doc = "HSI selected as PLL input clock"]
pub const HSI16 : Self = Self (0) ; # [doc = "HSE selected as PLL input clock"]
pub const HSE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcosel (pub u8) ; impl Mcosel { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "SYSCLK clock selected"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI oscillator clock selected"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "MSI oscillator clock selected"]
pub const MSI : Self = Self (0x03) ; # [doc = "HSE oscillator clock selected"]
pub const HSE : Self = Self (0x04) ; # [doc = "PLL clock selected"]
pub const PLL : Self = Self (0x05) ; # [doc = "LSI oscillator clock selected"]
pub const LSI : Self = Self (0x06) ; # [doc = "LSE oscillator clock selected"]
pub const LSE : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icsel (pub u8) ; impl Icsel { # [doc = "APB clock selected as peripheral clock"]
pub const APB : Self = Self (0) ; # [doc = "System clock selected as peripheral clock"]
pub const SYSTEM : Self = Self (0x01) ; # [doc = "HSI16 clock selected as peripheral clock"]
pub const HSI16 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcsel (pub u8) ; impl Rtcsel { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "LSE oscillator clock used as RTC clock"]
pub const LSE : Self = Self (0x01) ; # [doc = "LSI oscillator clock used as RTC clock"]
pub const LSI : Self = Self (0x02) ; # [doc = "HSE oscillator clock divided by a programmable prescaler (selection through the RTCPRE[1:0]
bits in the RCC clock control register (RCC_CR)) used as the RTC clock"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Stopwuck (pub u8) ; impl Stopwuck { # [doc = "Internal 64 KHz to 4 MHz (MSI) oscillator selected as wake-up from Stop clock"]
pub const MSI : Self = Self (0) ; # [doc = "Internal 16 MHz (HSI) oscillator selected as wake-up from Stop clock (or HSI16/4 if HSI16DIVEN=1)"]
pub const HSI16 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Plldiv (pub u8) ; impl Plldiv { # [doc = "PLLVCO / 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "PLLVCO / 3"]
pub const DIV3 : Self = Self (0x02) ; # [doc = "PLLVCO / 4"]
pub const DIV4 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ppre (pub u8) ; impl Ppre { # [doc = "HCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HCLK divided by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "HCLK divided by 4"]
pub const DIV4 : Self = Self (0x05) ; # [doc = "HCLK divided by 8"]
pub const DIV8 : Self = Self (0x06) ; # [doc = "HCLK divided by 16"]
pub const DIV16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsedrv (pub u8) ; impl Lsedrv { # [doc = "Lowest drive"]
pub const LOW : Self = Self (0) ; # [doc = "Medium low drive"]
pub const MEDIUMLOW : Self = Self (0x01) ; # [doc = "Medium high drive"]
pub const MEDIUMHIGH : Self = Self (0x02) ; # [doc = "Highest drive"]
pub const HIGH : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msirange (pub u8) ; impl Msirange { # [doc = "range 0 around 65.536 kHz"]
pub const RANGE0 : Self = Self (0) ; # [doc = "range 1 around 131.072 kHz"]
pub const RANGE1 : Self = Self (0x01) ; # [doc = "range 2 around 262.144 kHz"]
pub const RANGE2 : Self = Self (0x02) ; # [doc = "range 3 around 524.288 kHz"]
pub const RANGE3 : Self = Self (0x03) ; # [doc = "range 4 around 1.048 MHz"]
pub const RANGE4 : Self = Self (0x04) ; # [doc = "range 5 around 2.097 MHz (reset value)"]
pub const RANGE5 : Self = Self (0x05) ; # [doc = "range 6 around 4.194 MHz"]
pub const RANGE6 : Self = Self (0x06) ; # [doc = "not allowed"]
pub const RANGE7 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcopre (pub u8) ; impl Mcopre { # [doc = "No division"]
pub const DIV1 : Self = Self (0) ; # [doc = "Division by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "Division by 4"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "Division by 8"]
pub const DIV8 : Self = Self (0x03) ; # [doc = "Division by 16"]
pub const DIV16 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sw (pub u8) ; impl Sw { # [doc = "MSI oscillator used as system clock"]
pub const MSI : Self = Self (0) ; # [doc = "HSI oscillator used as system clock"]
pub const HSI16 : Self = Self (0x01) ; # [doc = "HSE oscillator used as system clock"]
pub const HSE : Self = Self (0x02) ; # [doc = "PLL used as system clock"]
pub const PLL : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcpre (pub u8) ; impl Rtcpre { # [doc = "HSE divided by 2"]
pub const DIV2 : Self = Self (0) ; # [doc = "HSE divided by 4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "HSE divided by 8"]
pub const DIV8 : Self = Self (0x02) ; # [doc = "HSE divided by 16"]
pub const DIV16 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpre (pub u8) ; impl Hpre { # [doc = "system clock not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "system clock divided by 2"]
pub const DIV2 : Self = Self (0x08) ; # [doc = "system clock divided by 4"]
pub const DIV4 : Self = Self (0x09) ; # [doc = "system clock divided by 8"]
pub const DIV8 : Self = Self (0x0a) ; # [doc = "system clock divided by 16"]
pub const DIV16 : Self = Self (0x0b) ; # [doc = "system clock divided by 64"]
pub const DIV64 : Self = Self (0x0c) ; # [doc = "system clock divided by 128"]
pub const DIV128 : Self = Self (0x0d) ; # [doc = "system clock divided by 256"]
pub const DIV256 : Self = Self (0x0e) ; # [doc = "system clock divided by 512"]
pub const DIV512 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lptimsel (pub u8) ; impl Lptimsel { # [doc = "APB clock selected as Timer clock"]
pub const APB : Self = Self (0) ; # [doc = "LSI clock selected as Timer clock"]
pub const LSI : Self = Self (0x01) ; # [doc = "HSI16 clock selected as Timer clock"]
pub const HSI16 : Self = Self (0x02) ; # [doc = "LSE clock selected as Timer clock"]
pub const LSE : Self = Self (0x03) ; } } pub mod regs { # [doc = "APB1 peripheral clock enable in sleep mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr (pub u32) ; impl Apb1smenr { # [doc = "Timer2 clock enable during sleep mode"]
pub const fn tim2smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer2 clock enable during sleep mode"]
pub fn set_tim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 clock enable during sleep mode"]
pub const fn tim3smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 clock enable during sleep mode"]
pub fn set_tim3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 6 clock enable during sleep mode"]
pub const fn tim6smen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 clock enable during sleep mode"]
pub fn set_tim6smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Timer 7 clock enable during sleep mode"]
pub const fn tim7smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Timer 7 clock enable during sleep mode"]
pub fn set_tim7smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Window watchdog clock enable during sleep mode"]
pub const fn wwdgsmen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable during sleep mode"]
pub fn set_wwdgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clock enable during sleep mode"]
pub const fn spi2smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable during sleep mode"]
pub fn set_spi2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "UART2 clock enable during sleep mode"]
pub const fn usart2smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "UART2 clock enable during sleep mode"]
pub fn set_usart2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "LPUART1 clock enable during sleep mode"]
pub const fn lpuart1smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "LPUART1 clock enable during sleep mode"]
pub fn set_lpuart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USART4 clock enabe during sleep mode"]
pub const fn usart4smen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "USART4 clock enabe during sleep mode"]
pub fn set_usart4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "USART5 clock enable during sleep mode"]
pub const fn usart5smen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "USART5 clock enable during sleep mode"]
pub fn set_usart5smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clock enable during sleep mode"]
pub const fn i2c1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable during sleep mode"]
pub fn set_i2c1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable during sleep mode"]
pub const fn i2c2smen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable during sleep mode"]
pub fn set_i2c2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB clock enable during sleep mode"]
pub const fn usbsmen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB clock enable during sleep mode"]
pub fn set_usbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Clock recovery system clock enable during sleep mode"]
pub const fn crssmen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Clock recovery system clock enable during sleep mode"]
pub fn set_crssmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface clock enable during sleep mode"]
pub const fn pwrsmen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable during sleep mode"]
pub fn set_pwrsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable during sleep mode"]
pub const fn dacsmen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable during sleep mode"]
pub fn set_dacsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "I2C3 clock enable during sleep mode"]
pub const fn i2c3smen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable during sleep mode"]
pub fn set_i2c3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low power timer clock enable during sleep mode"]
pub const fn lptim1smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low power timer clock enable during sleep mode"]
pub fn set_lptim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1smenr { fn default () -> Apb1smenr { Apb1smenr (0) } } # [doc = "APB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr (pub u32) ; impl Apb1rstr { # [doc = "Timer 2 reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer 2 reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 reset"]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 reset"]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 6 reset"]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 reset"]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Timer 7 reset"]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Timer 7 reset"]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Window watchdog reset"]
pub const fn wwdgrst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset"]
pub fn set_wwdgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART2 reset"]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 reset"]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "LPUART1 reset"]
pub const fn lpuart1rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "LPUART1 reset"]
pub fn set_lpuart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USART4 reset"]
pub const fn usart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "USART4 reset"]
pub fn set_usart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "USART5 reset"]
pub const fn usart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "USART5 reset"]
pub fn set_usart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB reset"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB reset"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Clock recovery system reset"]
pub const fn crsrst (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Clock recovery system reset"]
pub fn set_crsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface reset"]
pub const fn pwrrst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface reset"]
pub fn set_pwrrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface reset"]
pub const fn dacrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface reset"]
pub fn set_dacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "I2C3 reset"]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "I2C3 reset"]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low power timer reset"]
pub const fn lptim1rst (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low power timer reset"]
pub fn set_lptim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1rstr { fn default () -> Apb1rstr { Apb1rstr (0) } } # [doc = "Clock interrupt flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cifr (pub u32) ; impl Cifr { # [doc = "LSI ready interrupt flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI16 ready interrupt flag"]
pub const fn hsi16rdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready interrupt flag"]
pub fn set_hsi16rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE ready interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "PLL ready interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MSI ready interrupt flag"]
pub const fn msirdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "MSI ready interrupt flag"]
pub fn set_msirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "HSI48 ready interrupt flag"]
pub const fn hsi48rdyf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt flag"]
pub fn set_hsi48rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LSE Clock Security System Interrupt flag"]
pub const fn csslsef (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "LSE Clock Security System Interrupt flag"]
pub fn set_csslsef (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Clock Security System Interrupt flag"]
pub const fn csshsef (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Clock Security System Interrupt flag"]
pub fn set_csshsef (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Cifr { fn default () -> Cifr { Cifr (0) } } # [doc = "Control and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Internal low-speed oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal low-speed oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal low-speed oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal low-speed oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External low-speed oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "External low-speed oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "External low-speed oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "LSEDRV"]
pub const fn lsedrv (& self) -> super :: vals :: Lsedrv { let val = (self . 0 >> 11usize) & 0x03 ; super :: vals :: Lsedrv (val as u8) } # [doc = "LSEDRV"]
pub fn set_lsedrv (& mut self , val : super :: vals :: Lsedrv) { self . 0 = (self . 0 & ! (0x03 << 11usize)) | (((val . 0 as u32) & 0x03) << 11usize) ; } # [doc = "CSSLSEON"]
pub const fn csslseon (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CSSLSEON"]
pub fn set_csslseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "CSS on LSE failure detection flag"]
pub const fn csslsed (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "CSS on LSE failure detection flag"]
pub fn set_csslsed (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "RTC and LCD clock source selection"]
pub const fn rtcsel (& self) -> super :: vals :: Rtcsel { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Rtcsel (val as u8) } # [doc = "RTC and LCD clock source selection"]
pub fn set_rtcsel (& mut self , val : super :: vals :: Rtcsel) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "RTC software reset"]
pub const fn rtcrst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "RTC software reset"]
pub fn set_rtcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Firewall reset flag"]
pub const fn fwrstf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Firewall reset flag"]
pub fn set_fwrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "OBLRSTF"]
pub const fn oblrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "OBLRSTF"]
pub fn set_oblrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PIN reset flag"]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PIN reset flag"]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "POR/PDR reset flag"]
pub const fn porrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "POR/PDR reset flag"]
pub fn set_porrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent watchdog reset flag"]
pub const fn iwdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog reset flag"]
pub fn set_iwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "Clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock switch"]
pub const fn sw (& self) -> super :: vals :: Sw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "System clock switch"]
pub fn set_sw (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "System clock switch status"]
pub const fn sws (& self) -> super :: vals :: Sw { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "System clock switch status"]
pub fn set_sws (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "AHB prescaler"]
pub const fn hpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 4usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "AHB prescaler"]
pub fn set_hpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val . 0 as u32) & 0x0f) << 4usize) ; } # [doc = "APB low-speed prescaler (APB1)"]
pub const fn ppre1 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 8usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB low-speed prescaler (APB1)"]
pub fn set_ppre1 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val . 0 as u32) & 0x07) << 8usize) ; } # [doc = "APB high-speed prescaler (APB2)"]
pub const fn ppre2 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 11usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB high-speed prescaler (APB2)"]
pub fn set_ppre2 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 11usize)) | (((val . 0 as u32) & 0x07) << 11usize) ; } # [doc = "Wake-up from stop clock selection"]
pub const fn stopwuck (& self) -> super :: vals :: Stopwuck { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Stopwuck (val as u8) } # [doc = "Wake-up from stop clock selection"]
pub fn set_stopwuck (& mut self , val : super :: vals :: Stopwuck) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "PLL entry clock source"]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Pllsrc (val as u8) } # [doc = "PLL entry clock source"]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "PLL multiplication factor"]
pub const fn pllmul (& self) -> super :: vals :: Pllmul { let val = (self . 0 >> 18usize) & 0x0f ; super :: vals :: Pllmul (val as u8) } # [doc = "PLL multiplication factor"]
pub fn set_pllmul (& mut self , val : super :: vals :: Pllmul) { self . 0 = (self . 0 & ! (0x0f << 18usize)) | (((val . 0 as u32) & 0x0f) << 18usize) ; } # [doc = "PLL output division"]
pub const fn plldiv (& self) -> super :: vals :: Plldiv { let val = (self . 0 >> 22usize) & 0x03 ; super :: vals :: Plldiv (val as u8) } # [doc = "PLL output division"]
pub fn set_plldiv (& mut self , val : super :: vals :: Plldiv) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val . 0 as u32) & 0x03) << 22usize) ; } # [doc = "Microcontroller clock output selection"]
pub const fn mcosel (& self) -> super :: vals :: Mcosel { let val = (self . 0 >> 24usize) & 0x07 ; super :: vals :: Mcosel (val as u8) } # [doc = "Microcontroller clock output selection"]
pub fn set_mcosel (& mut self , val : super :: vals :: Mcosel) { self . 0 = (self . 0 & ! (0x07 << 24usize)) | (((val . 0 as u32) & 0x07) << 24usize) ; } # [doc = "Microcontroller clock output prescaler"]
pub const fn mcopre (& self) -> super :: vals :: Mcopre { let val = (self . 0 >> 28usize) & 0x07 ; super :: vals :: Mcopre (val as u8) } # [doc = "Microcontroller clock output prescaler"]
pub fn set_mcopre (& mut self , val : super :: vals :: Mcopre) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val . 0 as u32) & 0x07) << 28usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "GPIO clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gpioenr (pub u32) ; impl Gpioenr { # [doc = "IO port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port A clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "I/O port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "I/O port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "I/O port H clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I/O port H clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Gpioenr { fn default () -> Gpioenr { Gpioenr (0) } } # [doc = "AHB peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbenr (pub u32) ; impl Ahbenr { # [doc = "DMA clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "NVM interface clock enable"]
pub const fn mifen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "NVM interface clock enable"]
pub fn set_mifen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Touch Sensing clock enable"]
pub const fn touchen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Touch Sensing clock enable"]
pub fn set_touchen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Random Number Generator clock enable"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Random Number Generator clock enable"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Crypto clock enable"]
pub const fn crypen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Crypto clock enable"]
pub fn set_crypen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Ahbenr { fn default () -> Ahbenr { Ahbenr (0) } } # [doc = "APB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr (pub u32) ; impl Apb1enr { # [doc = "Timer2 clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer2 clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 clock enbale"]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 clock enbale"]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 6 clock enable"]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 clock enable"]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Timer 7 clock enable"]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Timer 7 clock enable"]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "UART2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "UART2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "LPUART1 clock enable"]
pub const fn lpuart1en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "LPUART1 clock enable"]
pub fn set_lpuart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USART4 clock enable"]
pub const fn usart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "USART4 clock enable"]
pub fn set_usart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "USART5 clock enable"]
pub const fn usart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "USART5 clock enable"]
pub fn set_usart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB clock enable"]
pub const fn usben (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB clock enable"]
pub fn set_usben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Clock recovery system clock enable"]
pub const fn crsen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Clock recovery system clock enable"]
pub fn set_crsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface clock enable"]
pub const fn pwren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable"]
pub fn set_pwren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable"]
pub const fn dacen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable"]
pub fn set_dacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "I2C3 clock enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low power timer clock enable"]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low power timer clock enable"]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1enr { fn default () -> Apb1enr { Apb1enr (0) } } # [doc = "APB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "System configuration controller reset"]
pub const fn syscfgrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "System configuration controller reset"]
pub fn set_syscfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM21 timer reset"]
pub const fn tim21rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM21 timer reset"]
pub fn set_tim21rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM22 timer reset"]
pub const fn tim22rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM22 timer reset"]
pub fn set_tim22rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ADC interface reset"]
pub const fn adcrst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC interface reset"]
pub fn set_adcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "SPI 1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "DBG reset"]
pub const fn dbgrst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DBG reset"]
pub fn set_dbgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "Clock interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cier (pub u32) ; impl Cier { # [doc = "LSI ready interrupt flag"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt flag"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt flag"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt flag"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI16 ready interrupt flag"]
pub const fn hsi16rdyie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready interrupt flag"]
pub fn set_hsi16rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE ready interrupt flag"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt flag"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "PLL ready interrupt flag"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt flag"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MSI ready interrupt flag"]
pub const fn msirdyie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "MSI ready interrupt flag"]
pub fn set_msirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "HSI48 ready interrupt flag"]
pub const fn hsi48rdyie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt flag"]
pub fn set_hsi48rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LSE CSS interrupt flag"]
pub const fn csslse (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "LSE CSS interrupt flag"]
pub fn set_csslse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Cier { fn default () -> Cier { Cier (0) } } # [doc = "Clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccipr (pub u32) ; impl Ccipr { # [doc = "USART1 clock source selection"]
pub const fn usart1sel (& self) -> super :: vals :: Uartsel { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Uartsel (val as u8) } # [doc = "USART1 clock source selection"]
pub fn set_usart1sel (& mut self , val : super :: vals :: Uartsel) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "USART2 clock source selection"]
pub const fn usart2sel (& self) -> super :: vals :: Uartsel { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Uartsel (val as u8) } # [doc = "USART2 clock source selection"]
pub fn set_usart2sel (& mut self , val : super :: vals :: Uartsel) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "LPUART1 clock source selection"]
pub const fn lpuart1sel (& self) -> super :: vals :: Uartsel { let val = (self . 0 >> 10usize) & 0x03 ; super :: vals :: Uartsel (val as u8) } # [doc = "LPUART1 clock source selection"]
pub fn set_lpuart1sel (& mut self , val : super :: vals :: Uartsel) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val . 0 as u32) & 0x03) << 10usize) ; } # [doc = "I2C1 clock source selection"]
pub const fn i2c1sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C1 clock source selection"]
pub fn set_i2c1sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "I2C3 clock source selection"]
pub const fn i2c3sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C3 clock source selection"]
pub fn set_i2c3sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Low Power Timer clock source selection"]
pub const fn lptim1sel (& self) -> super :: vals :: Lptimsel { let val = (self . 0 >> 18usize) & 0x03 ; super :: vals :: Lptimsel (val as u8) } # [doc = "Low Power Timer clock source selection"]
pub fn set_lptim1sel (& mut self , val : super :: vals :: Lptimsel) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val . 0 as u32) & 0x03) << 18usize) ; } # [doc = "48 MHz HSI48 clock source selection"]
pub const fn hsi48msel (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "48 MHz HSI48 clock source selection"]
pub fn set_hsi48msel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Ccipr { fn default () -> Ccipr { Ccipr (0) } } # [doc = "APB2 peripheral clock enable in sleep mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2smenr (pub u32) ; impl Apb2smenr { # [doc = "System configuration controller clock enable during sleep mode"]
pub const fn syscfgsmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "System configuration controller clock enable during sleep mode"]
pub fn set_syscfgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM21 timer clock enable during sleep mode"]
pub const fn tim21smen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM21 timer clock enable during sleep mode"]
pub fn set_tim21smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM22 timer clock enable during sleep mode"]
pub const fn tim22smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM22 timer clock enable during sleep mode"]
pub fn set_tim22smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ADC clock enable during sleep mode"]
pub const fn adcsmen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC clock enable during sleep mode"]
pub fn set_adcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "SPI1 clock enable during sleep mode"]
pub const fn spi1smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clock enable during sleep mode"]
pub fn set_spi1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1 clock enable during sleep mode"]
pub const fn usart1smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable during sleep mode"]
pub fn set_usart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "DBG clock enable during sleep mode"]
pub const fn dbgsmen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DBG clock enable during sleep mode"]
pub fn set_dbgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb2smenr { fn default () -> Apb2smenr { Apb2smenr (0) } } # [doc = "Clock recovery RC register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crrcr (pub u32) ; impl Crrcr { # [doc = "48MHz HSI clock enable"]
pub const fn hsi48on (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "48MHz HSI clock enable"]
pub fn set_hsi48on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "48MHz HSI clock ready flag"]
pub const fn hsi48rdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "48MHz HSI clock ready flag"]
pub fn set_hsi48rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "48 MHz HSI clock divided by 6 output enable"]
pub const fn hsi48div6en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "48 MHz HSI clock divided by 6 output enable"]
pub fn set_hsi48div6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "48 MHz HSI clock calibration"]
pub const fn hsi48cal (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "48 MHz HSI clock calibration"]
pub fn set_hsi48cal (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } } impl Default for Crrcr { fn default () -> Crrcr { Crrcr (0) } } # [doc = "AHB peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbrstr (pub u32) ; impl Ahbrstr { # [doc = "DMA reset"]
pub const fn dma1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA reset"]
pub fn set_dma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Memory interface reset"]
pub const fn mifrst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Memory interface reset"]
pub fn set_mifrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Test integration module reset"]
pub const fn crcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Test integration module reset"]
pub fn set_crcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Touch Sensing reset"]
pub const fn touchrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Touch Sensing reset"]
pub fn set_touchrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Random Number Generator module reset"]
pub const fn rngrst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Random Number Generator module reset"]
pub fn set_rngrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Crypto module reset"]
pub const fn cryprst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Crypto module reset"]
pub fn set_cryprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Ahbrstr { fn default () -> Ahbrstr { Ahbrstr (0) } } # [doc = "Clock interrupt clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cicr (pub u32) ; impl Cicr { # [doc = "LSI ready Interrupt clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready Interrupt clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready Interrupt clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready Interrupt clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI16 ready Interrupt clear"]
pub const fn hsi16rdyc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI16 ready Interrupt clear"]
pub fn set_hsi16rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE ready Interrupt clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE ready Interrupt clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "PLL ready Interrupt clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL ready Interrupt clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MSI ready Interrupt clear"]
pub const fn msirdyc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "MSI ready Interrupt clear"]
pub fn set_msirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "HSI48 ready Interrupt clear"]
pub const fn hsi48rdyc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready Interrupt clear"]
pub fn set_hsi48rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "LSE Clock Security System Interrupt clear"]
pub const fn csslsec (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "LSE Clock Security System Interrupt clear"]
pub fn set_csslsec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Clock Security System Interrupt clear"]
pub const fn csshsec (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Clock Security System Interrupt clear"]
pub fn set_csshsec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Cicr { fn default () -> Cicr { Cicr (0) } } # [doc = "GPIO clock enable in sleep mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gpiosmen (pub u32) ; impl Gpiosmen { # [doc = "Port A clock enable during Sleep mode"]
pub const fn gpioasmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Port A clock enable during Sleep mode"]
pub fn set_gpioasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Port B clock enable during Sleep mode"]
pub const fn gpiobsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Port B clock enable during Sleep mode"]
pub fn set_gpiobsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Port C clock enable during Sleep mode"]
pub const fn gpiocsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Port C clock enable during Sleep mode"]
pub fn set_gpiocsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Port D clock enable during Sleep mode"]
pub const fn gpiodsmen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Port D clock enable during Sleep mode"]
pub fn set_gpiodsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Port E clock enable during Sleep mode"]
pub const fn gpioesmen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Port E clock enable during Sleep mode"]
pub fn set_gpioesmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Port H clock enable during Sleep mode"]
pub const fn gpiohsmen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Port H clock enable during Sleep mode"]
pub fn set_gpiohsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Gpiosmen { fn default () -> Gpiosmen { Gpiosmen (0) } } # [doc = "APB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "System configuration controller clock enable"]
pub const fn syscfgen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "System configuration controller clock enable"]
pub fn set_syscfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM21 timer clock enable"]
pub const fn tim21en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM21 timer clock enable"]
pub fn set_tim21en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM22 timer clock enable"]
pub const fn tim22en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM22 timer clock enable"]
pub fn set_tim22en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Firewall clock enable"]
pub const fn fwen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Firewall clock enable"]
pub fn set_fwen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "ADC clock enable"]
pub const fn adcen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC clock enable"]
pub fn set_adcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "SPI1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1 clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "DBG clock enable"]
pub const fn dbgen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DBG clock enable"]
pub fn set_dbgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "GPIO reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gpiorstr (pub u32) ; impl Gpiorstr { # [doc = "I/O port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "I/O port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "I/O port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "I/O port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "I/O port A reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "I/O port A reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "I/O port D reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "I/O port D reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "I/O port E reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "I/O port E reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "I/O port H reset"]
pub const fn gpiohrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I/O port H reset"]
pub fn set_gpiohrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Gpiorstr { fn default () -> Gpiorstr { Gpiorstr (0) } } # [doc = "AHB peripheral clock enable in sleep mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbsmenr (pub u32) ; impl Ahbsmenr { # [doc = "DMA clock enable during sleep mode"]
pub const fn dma1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA clock enable during sleep mode"]
pub fn set_dma1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "NVM interface clock enable during sleep mode"]
pub const fn mifsmen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "NVM interface clock enable during sleep mode"]
pub fn set_mifsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "SRAM interface clock enable during sleep mode"]
pub const fn sramsmen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "SRAM interface clock enable during sleep mode"]
pub fn set_sramsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CRC clock enable during sleep mode"]
pub const fn crcsmen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable during sleep mode"]
pub fn set_crcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Touch Sensing clock enable during sleep mode"]
pub const fn touchsmen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Touch Sensing clock enable during sleep mode"]
pub fn set_touchsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Random Number Generator clock enable during sleep mode"]
pub const fn rngsmen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Random Number Generator clock enable during sleep mode"]
pub fn set_rngsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Crypto clock enable during sleep mode"]
pub const fn crypsmen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Crypto clock enable during sleep mode"]
pub fn set_crypsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Ahbsmenr { fn default () -> Ahbsmenr { Ahbsmenr (0) } } # [doc = "Clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "16 MHz high-speed internal clock enable"]
pub const fn hsi16on (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "16 MHz high-speed internal clock enable"]
pub fn set_hsi16on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "High-speed internal clock enable bit for some IP kernels"]
pub const fn hsi16keron (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "High-speed internal clock enable bit for some IP kernels"]
pub fn set_hsi16keron (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Internal high-speed clock ready flag"]
pub const fn hsi16rdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Internal high-speed clock ready flag"]
pub fn set_hsi16rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI16DIVEN"]
pub const fn hsi16diven (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI16DIVEN"]
pub fn set_hsi16diven (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSI16DIVF"]
pub const fn hsi16divf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSI16DIVF"]
pub fn set_hsi16divf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "16 MHz high-speed internal clock output enable"]
pub const fn hsi16outen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "16 MHz high-speed internal clock output enable"]
pub fn set_hsi16outen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "MSI clock enable"]
pub const fn msion (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "MSI clock enable"]
pub fn set_msion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "MSI clock ready flag"]
pub const fn msirdy (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "MSI clock ready flag"]
pub fn set_msirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSE clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSE clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSE clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSE clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSE clock bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSE clock bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Clock security system on HSE enable"]
pub const fn csshseon (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Clock security system on HSE enable"]
pub fn set_csshseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "TC/LCD prescaler"]
pub const fn rtcpre (& self) -> super :: vals :: Rtcpre { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Rtcpre (val as u8) } # [doc = "TC/LCD prescaler"]
pub fn set_rtcpre (& mut self , val : super :: vals :: Rtcpre) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "PLL enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "PLL enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "PLL clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "PLL clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Internal clock sources calibration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icscr (pub u32) ; impl Icscr { # [doc = "nternal high speed clock calibration"]
pub const fn hsi16cal (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "nternal high speed clock calibration"]
pub fn set_hsi16cal (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "High speed internal clock trimming"]
pub const fn hsi16trim (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x1f ; val as u8 } # [doc = "High speed internal clock trimming"]
pub fn set_hsi16trim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 8usize)) | (((val as u32) & 0x1f) << 8usize) ; } # [doc = "MSI clock ranges"]
pub const fn msirange (& self) -> super :: vals :: Msirange { let val = (self . 0 >> 13usize) & 0x07 ; super :: vals :: Msirange (val as u8) } # [doc = "MSI clock ranges"]
pub fn set_msirange (& mut self , val : super :: vals :: Msirange) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val . 0 as u32) & 0x07) << 13usize) ; } # [doc = "MSI clock calibration"]
pub const fn msical (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "MSI clock calibration"]
pub fn set_msical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "MSI clock trimming"]
pub const fn msitrim (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "MSI clock trimming"]
pub fn set_msitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Icscr { fn default () -> Icscr { Icscr (0) } } }