

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "RCC HSI configuration register"]
pub fn hsicfgr (self) -> crate :: common :: Reg < regs :: Hsicfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "RCC Clock Recovery RC Register"]
pub fn crrcr (self) -> crate :: common :: Reg < regs :: Crrcr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "RCC CSI configuration register"]
pub fn csicfgr (self) -> crate :: common :: Reg < regs :: Csicfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "RCC Clock Configuration Register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "RCC Domain 1 Clock Configuration Register"]
pub fn d1cfgr (self) -> crate :: common :: Reg < regs :: D1cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "RCC Domain 2 Clock Configuration Register"]
pub fn d2cfgr (self) -> crate :: common :: Reg < regs :: D2cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "RCC Domain 3 Clock Configuration Register"]
pub fn d3cfgr (self) -> crate :: common :: Reg < regs :: D3cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "RCC PLLs Clock Source Selection Register"]
pub fn pllckselr (self) -> crate :: common :: Reg < regs :: Pllckselr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "RCC PLLs Configuration Register"]
pub fn pllcfgr (self) -> crate :: common :: Reg < regs :: Pllcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "RCC PLL1 Dividers Configuration Register"]
pub fn plldivr (self , n : usize) -> crate :: common :: Reg < regs :: Pll1divr , crate :: common :: RW > { assert ! (n < 3usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize + n * 8usize)) } } # [doc = "RCC PLL1 Fractional Divider Register"]
pub fn pllfracr (self , n : usize) -> crate :: common :: Reg < regs :: Pll1fracr , crate :: common :: RW > { assert ! (n < 3usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize + n * 8usize)) } } # [doc = "RCC Domain 1 Kernel Clock Configuration Register"]
pub fn d1ccipr (self) -> crate :: common :: Reg < regs :: D1ccipr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "RCC Domain 2 Kernel Clock Configuration Register"]
pub fn d2ccip1r (self) -> crate :: common :: Reg < regs :: D2ccip1r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "RCC Domain 2 Kernel Clock Configuration Register"]
pub fn d2ccip2r (self) -> crate :: common :: Reg < regs :: D2ccip2r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "RCC Domain 3 Kernel Clock Configuration Register"]
pub fn d3ccipr (self) -> crate :: common :: Reg < regs :: D3ccipr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "RCC Clock Source Interrupt Enable Register"]
pub fn cier (self) -> crate :: common :: Reg < regs :: Cier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "RCC Clock Source Interrupt Flag Register"]
pub fn cifr (self) -> crate :: common :: Reg < regs :: Cifr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (100usize)) } } # [doc = "RCC Clock Source Interrupt Clear Register"]
pub fn cicr (self) -> crate :: common :: Reg < regs :: Cicr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (104usize)) } } # [doc = "RCC Backup Domain Control Register"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } # [doc = "RCC Clock Control and Status Register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (116usize)) } } # [doc = "RCC AHB3 Reset Register"]
pub fn ahb3rstr (self) -> crate :: common :: Reg < regs :: Ahb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (124usize)) } } # [doc = "RCC AHB1 Peripheral Reset Register"]
pub fn ahb1rstr (self) -> crate :: common :: Reg < regs :: Ahb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "RCC AHB2 Peripheral Reset Register"]
pub fn ahb2rstr (self) -> crate :: common :: Reg < regs :: Ahb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize)) } } # [doc = "RCC AHB4 Peripheral Reset Register"]
pub fn ahb4rstr (self) -> crate :: common :: Reg < regs :: Ahb4rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "RCC APB3 Peripheral Reset Register"]
pub fn apb3rstr (self) -> crate :: common :: Reg < regs :: Apb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (140usize)) } } # [doc = "RCC APB1 Peripheral Reset Register"]
pub fn apb1lrstr (self) -> crate :: common :: Reg < regs :: Apb1lrstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } # [doc = "RCC APB1 Peripheral Reset Register"]
pub fn apb1hrstr (self) -> crate :: common :: Reg < regs :: Apb1hrstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (148usize)) } } # [doc = "RCC APB2 Peripheral Reset Register"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (152usize)) } } # [doc = "RCC APB4 Peripheral Reset Register"]
pub fn apb4rstr (self) -> crate :: common :: Reg < regs :: Apb4rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (156usize)) } } # [doc = "Global Control Register"]
pub fn gcr (self) -> crate :: common :: Reg < regs :: Gcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (160usize)) } } # [doc = "RCC D3 Autonomous mode Register"]
pub fn d3amr (self) -> crate :: common :: Reg < regs :: D3amr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (168usize)) } } # [doc = "RCC Reset Status Register"]
pub fn rsr (self) -> crate :: common :: Reg < regs :: Rsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (304usize)) } } # [doc = "RCC AHB3 Clock Register"]
pub fn ahb3enr (self) -> crate :: common :: Reg < regs :: Ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (308usize)) } } # [doc = "RCC AHB1 Clock Register"]
pub fn ahb1enr (self) -> crate :: common :: Reg < regs :: Ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (312usize)) } } # [doc = "RCC AHB2 Clock Register"]
pub fn ahb2enr (self) -> crate :: common :: Reg < regs :: Ahb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (316usize)) } } # [doc = "RCC AHB4 Clock Register"]
pub fn ahb4enr (self) -> crate :: common :: Reg < regs :: Ahb4enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (320usize)) } } # [doc = "RCC APB3 Clock Register"]
pub fn apb3enr (self) -> crate :: common :: Reg < regs :: Apb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (324usize)) } } # [doc = "RCC APB1 Clock Register"]
pub fn apb1lenr (self) -> crate :: common :: Reg < regs :: Apb1lenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (328usize)) } } # [doc = "RCC APB1 Clock Register"]
pub fn apb1henr (self) -> crate :: common :: Reg < regs :: Apb1henr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (332usize)) } } # [doc = "RCC APB2 Clock Register"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (336usize)) } } # [doc = "RCC APB4 Clock Register"]
pub fn apb4enr (self) -> crate :: common :: Reg < regs :: Apb4enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (340usize)) } } # [doc = "RCC AHB3 Sleep Clock Register"]
pub fn ahb3lpenr (self) -> crate :: common :: Reg < regs :: Ahb3lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (348usize)) } } # [doc = "RCC AHB1 Sleep Clock Register"]
pub fn ahb1lpenr (self) -> crate :: common :: Reg < regs :: Ahb1lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (352usize)) } } # [doc = "RCC AHB2 Sleep Clock Register"]
pub fn ahb2lpenr (self) -> crate :: common :: Reg < regs :: Ahb2lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (356usize)) } } # [doc = "RCC AHB4 Sleep Clock Register"]
pub fn ahb4lpenr (self) -> crate :: common :: Reg < regs :: Ahb4lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (360usize)) } } # [doc = "RCC APB3 Sleep Clock Register"]
pub fn apb3lpenr (self) -> crate :: common :: Reg < regs :: Apb3lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (364usize)) } } # [doc = "RCC APB1 Low Sleep Clock Register"]
pub fn apb1llpenr (self) -> crate :: common :: Reg < regs :: Apb1llpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (368usize)) } } # [doc = "RCC APB1 High Sleep Clock Register"]
pub fn apb1hlpenr (self) -> crate :: common :: Reg < regs :: Apb1hlpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (372usize)) } } # [doc = "RCC APB2 Sleep Clock Register"]
pub fn apb2lpenr (self) -> crate :: common :: Reg < regs :: Apb2lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (376usize)) } } # [doc = "RCC APB4 Sleep Clock Register"]
pub fn apb4lpenr (self) -> crate :: common :: Reg < regs :: Apb4lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (380usize)) } } } pub mod regs { # [doc = "RCC CSI configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csicfgr (pub u32) ; impl Csicfgr { # [doc = "CSI clock calibration"]
pub const fn csical (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "CSI clock calibration"]
pub fn set_csical (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "CSI clock trimming"]
pub const fn csitrim (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x3f ; val as u8 } # [doc = "CSI clock trimming"]
pub fn set_csitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 24usize)) | (((val as u32) & 0x3f) << 24usize) ; } } impl Default for Csicfgr { fn default () -> Csicfgr { Csicfgr (0) } } # [doc = "RCC Clock Source Interrupt Clear Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cicr (pub u32) ; impl Cicr { # [doc = "LSI ready Interrupt Clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready Interrupt Clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready Interrupt Clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready Interrupt Clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI ready Interrupt Clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI ready Interrupt Clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE ready Interrupt Clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE ready Interrupt Clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CSI ready Interrupt Clear"]
pub const fn hse_ready_interrupt_clear (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CSI ready Interrupt Clear"]
pub fn set_hse_ready_interrupt_clear (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RC48 ready Interrupt Clear"]
pub const fn hsi48rdyc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RC48 ready Interrupt Clear"]
pub fn set_hsi48rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLL1 ready Interrupt Clear"]
pub fn pllrdyc (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 ready Interrupt Clear"]
pub fn set_pllrdyc (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "LSE clock security system Interrupt Clear"]
pub const fn lsecssc (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE clock security system Interrupt Clear"]
pub fn set_lsecssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSE clock security system Interrupt Clear"]
pub const fn hsecssc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSE clock security system Interrupt Clear"]
pub fn set_hsecssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Cicr { fn default () -> Cicr { Cicr (0) } } # [doc = "RCC APB2 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "TIM1 peripheral clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 peripheral clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 peripheral clock enable"]
pub const fn tim8en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 peripheral clock enable"]
pub fn set_tim8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 Peripheral Clocks Enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 Peripheral Clocks Enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 Peripheral Clocks Enable"]
pub const fn usart6en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 Peripheral Clocks Enable"]
pub fn set_usart6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "UART9 Peripheral Clocks Enable"]
pub const fn uart9en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "UART9 Peripheral Clocks Enable"]
pub fn set_uart9en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USART10 Peripheral Clocks Enable"]
pub const fn usart10en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USART10 Peripheral Clocks Enable"]
pub fn set_usart10en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "SPI1 Peripheral Clocks Enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 Peripheral Clocks Enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SPI4 Peripheral Clocks Enable"]
pub const fn spi4en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SPI4 Peripheral Clocks Enable"]
pub fn set_spi4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "TIM15 peripheral clock enable"]
pub const fn tim15en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 peripheral clock enable"]
pub fn set_tim15en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 peripheral clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 peripheral clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 peripheral clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 peripheral clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SPI5 Peripheral Clocks Enable"]
pub const fn spi5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SPI5 Peripheral Clocks Enable"]
pub fn set_spi5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SAI1 Peripheral Clocks Enable"]
pub const fn sai1en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI1 Peripheral Clocks Enable"]
pub fn set_sai1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "SAI2 Peripheral Clocks Enable"]
pub const fn sai2en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "SAI2 Peripheral Clocks Enable"]
pub fn set_sai2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "SAI3 Peripheral Clocks Enable"]
pub const fn sai3en (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SAI3 Peripheral Clocks Enable"]
pub fn set_sai3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "DFSDM1 Peripheral Clocks Enable"]
pub const fn dfsdm1en (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "DFSDM1 Peripheral Clocks Enable"]
pub fn set_dfsdm1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "HRTIM peripheral clock enable"]
pub const fn hrtimen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "HRTIM peripheral clock enable"]
pub fn set_hrtimen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "RCC Reset Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rsr (pub u32) ; impl Rsr { # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CPU reset flag"]
pub const fn cpurstf (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CPU reset flag"]
pub fn set_cpurstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "D1 domain power switch reset flag"]
pub const fn d1rstf (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "D1 domain power switch reset flag"]
pub fn set_d1rstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "D2 domain power switch reset flag"]
pub const fn d2rstf (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "D2 domain power switch reset flag"]
pub fn set_d2rstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "BOR reset flag"]
pub const fn borrstf (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "BOR reset flag"]
pub fn set_borrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Pin reset flag (NRST)"]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Pin reset flag (NRST)"]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "POR/PDR reset flag"]
pub const fn porrstf (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "POR/PDR reset flag"]
pub fn set_porrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "System reset from CPU reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "System reset from CPU reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Independent Watchdog reset flag"]
pub const fn iwdg1rstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Independent Watchdog reset flag"]
pub fn set_iwdg1rstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Window Watchdog reset flag"]
pub const fn wwdg1rstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Window Watchdog reset flag"]
pub fn set_wwdg1rstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Reset due to illegal D1 DStandby or CPU CStop flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Reset due to illegal D1 DStandby or CPU CStop flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Rsr { fn default () -> Rsr { Rsr (0) } } # [doc = "RCC Domain 3 Kernel Clock Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D3ccipr (pub u32) ; impl D3ccipr { # [doc = "LPUART1 kernel clock source selection"]
pub const fn lpuart1sel (& self) -> super :: vals :: Lpuartsel { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Lpuartsel (val as u8) } # [doc = "LPUART1 kernel clock source selection"]
pub fn set_lpuart1sel (& mut self , val : super :: vals :: Lpuartsel) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "I2C4 kernel clock source selection"]
pub const fn i2c4sel (& self) -> super :: vals :: I2c4sel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: I2c4sel (val as u8) } # [doc = "I2C4 kernel clock source selection"]
pub fn set_i2c4sel (& mut self , val : super :: vals :: I2c4sel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "LPTIM2 kernel clock source selection"]
pub const fn lptim2sel (& self) -> super :: vals :: Lptim2sel { let val = (self . 0 >> 10usize) & 0x07 ; super :: vals :: Lptim2sel (val as u8) } # [doc = "LPTIM2 kernel clock source selection"]
pub fn set_lptim2sel (& mut self , val : super :: vals :: Lptim2sel) { self . 0 = (self . 0 & ! (0x07 << 10usize)) | (((val . 0 as u32) & 0x07) << 10usize) ; } # [doc = "LPTIM3,4,5 kernel clock source selection"]
pub const fn lptim345sel (& self) -> super :: vals :: Lptim2sel { let val = (self . 0 >> 13usize) & 0x07 ; super :: vals :: Lptim2sel (val as u8) } # [doc = "LPTIM3,4,5 kernel clock source selection"]
pub fn set_lptim345sel (& mut self , val : super :: vals :: Lptim2sel) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val . 0 as u32) & 0x07) << 13usize) ; } # [doc = "SAR ADC kernel clock source selection"]
pub const fn adcsel (& self) -> super :: vals :: Adcsel { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Adcsel (val as u8) } # [doc = "SAR ADC kernel clock source selection"]
pub fn set_adcsel (& mut self , val : super :: vals :: Adcsel) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "DFSDM2 kernel clock source selection"]
pub const fn dfsdm2sel (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "DFSDM2 kernel clock source selection"]
pub fn set_dfsdm2sel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "SPI6 kernel clock source selection"]
pub const fn spi6sel (& self) -> super :: vals :: Spi6sel { let val = (self . 0 >> 28usize) & 0x07 ; super :: vals :: Spi6sel (val as u8) } # [doc = "SPI6 kernel clock source selection"]
pub fn set_spi6sel (& mut self , val : super :: vals :: Spi6sel) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val . 0 as u32) & 0x07) << 28usize) ; } } impl Default for D3ccipr { fn default () -> D3ccipr { D3ccipr (0) } } # [doc = "RCC APB4 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb4enr (pub u32) ; impl Apb4enr { # [doc = "SYSCFG peripheral clock enable"]
pub const fn syscfgen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYSCFG peripheral clock enable"]
pub fn set_syscfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LPUART1 Peripheral Clocks Enable"]
pub const fn lpuart1en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "LPUART1 Peripheral Clocks Enable"]
pub fn set_lpuart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "SPI6 Peripheral Clocks Enable"]
pub const fn spi6en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SPI6 Peripheral Clocks Enable"]
pub fn set_spi6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "I2C4 Peripheral Clocks Enable"]
pub const fn i2c4en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I2C4 Peripheral Clocks Enable"]
pub fn set_i2c4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LPTIM2 Peripheral Clocks Enable"]
pub const fn lptim2en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 Peripheral Clocks Enable"]
pub fn set_lptim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "LPTIM3 Peripheral Clocks Enable"]
pub const fn lptim3en (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "LPTIM3 Peripheral Clocks Enable"]
pub fn set_lptim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "LPTIM4 Peripheral Clocks Enable"]
pub const fn lptim4en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LPTIM4 Peripheral Clocks Enable"]
pub fn set_lptim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LPTIM5 Peripheral Clocks Enable"]
pub const fn lptim5en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LPTIM5 Peripheral Clocks Enable"]
pub fn set_lptim5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DAC2 (containing one converter) peripheral clock enable"]
pub const fn dac2en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DAC2 (containing one converter) peripheral clock enable"]
pub fn set_dac2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "COMP1/2 peripheral clock enable"]
pub const fn comp12en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "COMP1/2 peripheral clock enable"]
pub fn set_comp12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "VREF peripheral clock enable"]
pub const fn vrefen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "VREF peripheral clock enable"]
pub fn set_vrefen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "RTC APB Clock Enable"]
pub const fn rtcapben (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "RTC APB Clock Enable"]
pub fn set_rtcapben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "SAI4 Peripheral Clocks Enable"]
pub const fn sai4en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI4 Peripheral Clocks Enable"]
pub fn set_sai4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Digital temperature sensor block enable"]
pub const fn dtsen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Digital temperature sensor block enable"]
pub fn set_dtsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Apb4enr { fn default () -> Apb4enr { Apb4enr (0) } } # [doc = "RCC AHB1 Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1lpenr (pub u32) ; impl Ahb1lpenr { # [doc = "DMA1 Clock Enable During CSleep Mode"]
pub const fn dma1lpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 Clock Enable During CSleep Mode"]
pub fn set_dma1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 Clock Enable During CSleep Mode"]
pub const fn dma2lpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 Clock Enable During CSleep Mode"]
pub fn set_dma2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "ADC1/2 Peripheral Clocks Enable During CSleep Mode"]
pub const fn adc12lpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "ADC1/2 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_adc12lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ART Clock Enable During CSleep Mode"]
pub const fn artlpen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "ART Clock Enable During CSleep Mode"]
pub fn set_artlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Ethernet MAC bus interface Clock Enable During CSleep Mode"]
pub const fn eth1maclpen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC bus interface Clock Enable During CSleep Mode"]
pub fn set_eth1maclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Ethernet Transmission Clock Enable During CSleep Mode"]
pub const fn eth1txlpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Ethernet Transmission Clock Enable During CSleep Mode"]
pub fn set_eth1txlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Ethernet Reception Clock Enable During CSleep Mode"]
pub const fn eth1rxlpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Ethernet Reception Clock Enable During CSleep Mode"]
pub fn set_eth1rxlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USB1OTG peripheral clock enable during CSleep mode"]
pub const fn usb1otglpen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "USB1OTG peripheral clock enable during CSleep mode"]
pub fn set_usb1otglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "USB_PHY1 clock enable during CSleep mode"]
pub const fn usb1otghsulpilpen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "USB_PHY1 clock enable during CSleep mode"]
pub fn set_usb1otghsulpilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "USB_PHY1 clock enable during CSleep mode"]
pub const fn usb1ulpilpen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "USB_PHY1 clock enable during CSleep mode"]
pub fn set_usb1ulpilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "USB2OTG peripheral clock enable during CSleep mode"]
pub const fn usb2otglpen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "USB2OTG peripheral clock enable during CSleep mode"]
pub fn set_usb2otglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "USB_PHY2 clocks enable during CSleep mode"]
pub const fn usb2otghsulpilpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "USB_PHY2 clocks enable during CSleep mode"]
pub fn set_usb2otghsulpilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "USB_PHY2 clocks enable during CSleep mode"]
pub const fn usb2ulpilpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "USB_PHY2 clocks enable during CSleep mode"]
pub fn set_usb2ulpilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } } impl Default for Ahb1lpenr { fn default () -> Ahb1lpenr { Ahb1lpenr (0) } } # [doc = "RCC Backup Domain Control Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "LSE oscillator enabled"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator enabled"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LSE oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "LSE oscillator driving capability"]
pub const fn lsedrv (& self) -> super :: vals :: Lsedrv { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Lsedrv (val as u8) } # [doc = "LSE oscillator driving capability"]
pub fn set_lsedrv (& mut self , val : super :: vals :: Lsedrv) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "LSE clock security system enable"]
pub const fn lsecsson (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LSE clock security system enable"]
pub fn set_lsecsson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LSE clock security system failure detection"]
pub const fn lsecssd (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LSE clock security system failure detection"]
pub fn set_lsecssd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> super :: vals :: Rtcsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Rtcsel (val as u8) } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : super :: vals :: Rtcsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "VSwitch domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "VSwitch domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "RCC Clock Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock switch"]
pub const fn sw (& self) -> super :: vals :: Sw { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Sw (val as u8) } # [doc = "System clock switch"]
pub fn set_sw (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "System clock switch status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x07 ; val as u8 } # [doc = "System clock switch status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 3usize)) | (((val as u32) & 0x07) << 3usize) ; } # [doc = "System clock selection after a wake up from system Stop"]
pub const fn stopwuck (& self) -> super :: vals :: Stopwuck { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Stopwuck (val as u8) } # [doc = "System clock selection after a wake up from system Stop"]
pub fn set_stopwuck (& mut self , val : super :: vals :: Stopwuck) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Kernel clock selection after a wake up from system Stop"]
pub const fn stopkerwuck (& self) -> super :: vals :: Stopwuck { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Stopwuck (val as u8) } # [doc = "Kernel clock selection after a wake up from system Stop"]
pub fn set_stopkerwuck (& mut self , val : super :: vals :: Stopwuck) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "HSE division factor for RTC clock"]
pub const fn rtcpre (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x3f ; val as u8 } # [doc = "HSE division factor for RTC clock"]
pub fn set_rtcpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 8usize)) | (((val as u32) & 0x3f) << 8usize) ; } # [doc = "High Resolution Timer clock prescaler selection"]
pub const fn hrtimsel (& self) -> super :: vals :: Hrtimsel { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Hrtimsel (val as u8) } # [doc = "High Resolution Timer clock prescaler selection"]
pub fn set_hrtimsel (& mut self , val : super :: vals :: Hrtimsel) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Timers clocks prescaler selection"]
pub const fn timpre (& self) -> super :: vals :: Timpre { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Timpre (val as u8) } # [doc = "Timers clocks prescaler selection"]
pub fn set_timpre (& mut self , val : super :: vals :: Timpre) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "MCO1 prescaler"]
pub const fn mco1pre (& self) -> u8 { let val = (self . 0 >> 18usize) & 0x0f ; val as u8 } # [doc = "MCO1 prescaler"]
pub fn set_mco1pre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 18usize)) | (((val as u32) & 0x0f) << 18usize) ; } # [doc = "Micro-controller clock output 1"]
pub const fn mco1 (& self) -> super :: vals :: Mco1 { let val = (self . 0 >> 22usize) & 0x07 ; super :: vals :: Mco1 (val as u8) } # [doc = "Micro-controller clock output 1"]
pub fn set_mco1 (& mut self , val : super :: vals :: Mco1) { self . 0 = (self . 0 & ! (0x07 << 22usize)) | (((val . 0 as u32) & 0x07) << 22usize) ; } # [doc = "MCO2 prescaler"]
pub const fn mco2pre (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x0f ; val as u8 } # [doc = "MCO2 prescaler"]
pub fn set_mco2pre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 25usize)) | (((val as u32) & 0x0f) << 25usize) ; } # [doc = "Micro-controller clock output 2"]
pub const fn mco2 (& self) -> super :: vals :: Mco2 { let val = (self . 0 >> 29usize) & 0x07 ; super :: vals :: Mco2 (val as u8) } # [doc = "Micro-controller clock output 2"]
pub fn set_mco2 (& mut self , val : super :: vals :: Mco2) { self . 0 = (self . 0 & ! (0x07 << 29usize)) | (((val . 0 as u32) & 0x07) << 29usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "RCC HSI configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Hsicfgr (pub u32) ; impl Hsicfgr { # [doc = "HSI clock calibration"]
pub const fn hsical (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "HSI clock calibration"]
pub fn set_hsical (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "HSI clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "HSI clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Hsicfgr { fn default () -> Hsicfgr { Hsicfgr (0) } } # [doc = "RCC APB3 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3enr (pub u32) ; impl Apb3enr { # [doc = "LTDC peripheral clock enable"]
pub const fn ltdcen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "LTDC peripheral clock enable"]
pub fn set_ltdcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "DSI Peripheral clocks enable"]
pub const fn dsien (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "DSI Peripheral clocks enable"]
pub fn set_dsien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "WWDG1 Clock Enable"]
pub const fn wwdg1en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "WWDG1 Clock Enable"]
pub fn set_wwdg1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Apb3enr { fn default () -> Apb3enr { Apb3enr (0) } } # [doc = "RCC AHB2 Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2lpenr (pub u32) ; impl Ahb2lpenr { # [doc = "DCMI peripheral clock enable during csleep mode"]
pub const fn dcmilpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DCMI peripheral clock enable during csleep mode"]
pub fn set_dcmilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CRYPT peripheral clock enable during CSleep mode"]
pub const fn cryptlpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CRYPT peripheral clock enable during CSleep mode"]
pub fn set_cryptlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "HASH peripheral clock enable during CSleep mode"]
pub const fn hashlpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "HASH peripheral clock enable during CSleep mode"]
pub fn set_hashlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "RNG peripheral clock enable during CSleep mode"]
pub const fn rnglpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "RNG peripheral clock enable during CSleep mode"]
pub fn set_rnglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "SDMMC2 and SDMMC2 Delay Clock Enable During CSleep Mode"]
pub const fn sdmmc2lpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 and SDMMC2 Delay Clock Enable During CSleep Mode"]
pub fn set_sdmmc2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "BDMA1 Clock Enable During CSleep Mode"]
pub const fn bdma1lpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "BDMA1 Clock Enable During CSleep Mode"]
pub fn set_bdma1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "FMAC enable during CSleep Mode"]
pub const fn fmaclpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "FMAC enable during CSleep Mode"]
pub fn set_fmaclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CORDIC enable during CSleep Mode"]
pub const fn cordiclpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CORDIC enable during CSleep Mode"]
pub fn set_cordiclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "SRAM1 Clock Enable During CSleep Mode"]
pub const fn sram1lpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "SRAM1 Clock Enable During CSleep Mode"]
pub fn set_sram1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "SRAM2 Clock Enable During CSleep Mode"]
pub const fn sram2lpen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "SRAM2 Clock Enable During CSleep Mode"]
pub fn set_sram2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "SRAM3 Clock Enable During CSleep Mode"]
pub const fn sram3lpen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM3 Clock Enable During CSleep Mode"]
pub fn set_sram3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb2lpenr { fn default () -> Ahb2lpenr { Ahb2lpenr (0) } } # [doc = "RCC PLL1 Fractional Divider Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll1fracr (pub u32) ; impl Pll1fracr { # [doc = "Fractional part of the multiplication factor for PLL1 VCO"]
pub const fn fracn1 (& self) -> u16 { let val = (self . 0 >> 3usize) & 0x1fff ; val as u16 } # [doc = "Fractional part of the multiplication factor for PLL1 VCO"]
pub fn set_fracn1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 3usize)) | (((val as u32) & 0x1fff) << 3usize) ; } } impl Default for Pll1fracr { fn default () -> Pll1fracr { Pll1fracr (0) } } # [doc = "RCC APB4 Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb4lpenr (pub u32) ; impl Apb4lpenr { # [doc = "SYSCFG peripheral clock enable during CSleep mode"]
pub const fn syscfglpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYSCFG peripheral clock enable during CSleep mode"]
pub fn set_syscfglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LPUART1 Peripheral Clocks Enable During CSleep Mode"]
pub const fn lpuart1lpen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "LPUART1 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_lpuart1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "SPI6 Peripheral Clocks Enable During CSleep Mode"]
pub const fn spi6lpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SPI6 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_spi6lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "I2C4 Peripheral Clocks Enable During CSleep Mode"]
pub const fn i2c4lpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I2C4 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_i2c4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LPTIM2 Peripheral Clocks Enable During CSleep Mode"]
pub const fn lptim2lpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_lptim2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "LPTIM3 Peripheral Clocks Enable During CSleep Mode"]
pub const fn lptim3lpen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "LPTIM3 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_lptim3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "LPTIM4 Peripheral Clocks Enable During CSleep Mode"]
pub const fn lptim4lpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LPTIM4 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_lptim4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LPTIM5 Peripheral Clocks Enable During CSleep Mode"]
pub const fn lptim5lpen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LPTIM5 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_lptim5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DAC2 (containing one converter) peripheral clock enable during CSleep mode"]
pub const fn dac2lpen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DAC2 (containing one converter) peripheral clock enable during CSleep mode"]
pub fn set_dac2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "COMP1/2 peripheral clock enable during CSleep mode"]
pub const fn comp12lpen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "COMP1/2 peripheral clock enable during CSleep mode"]
pub fn set_comp12lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "VREF peripheral clock enable during CSleep mode"]
pub const fn vreflpen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "VREF peripheral clock enable during CSleep mode"]
pub fn set_vreflpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "RTC APB Clock Enable During CSleep Mode"]
pub const fn rtcapblpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "RTC APB Clock Enable During CSleep Mode"]
pub fn set_rtcapblpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "SAI4 Peripheral Clocks Enable During CSleep Mode"]
pub const fn sai4lpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI4 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_sai4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Digital temperature sensor block enable during CSleep Mode"]
pub const fn dtslpen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Digital temperature sensor block enable during CSleep Mode"]
pub fn set_dtslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Apb4lpenr { fn default () -> Apb4lpenr { Apb4lpenr (0) } } # [doc = "RCC PLL1 Dividers Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll1divr (pub u32) ; impl Pll1divr { # [doc = "Multiplication factor for PLL1 VCO"]
pub const fn divn1 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Multiplication factor for PLL1 VCO"]
pub fn set_divn1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "PLL1 DIVP division factor"]
pub const fn divp1 (& self) -> super :: vals :: Divp { let val = (self . 0 >> 9usize) & 0x7f ; super :: vals :: Divp (val as u8) } # [doc = "PLL1 DIVP division factor"]
pub fn set_divp1 (& mut self , val : super :: vals :: Divp) { self . 0 = (self . 0 & ! (0x7f << 9usize)) | (((val . 0 as u32) & 0x7f) << 9usize) ; } # [doc = "PLL1 DIVQ division factor"]
pub const fn divq1 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "PLL1 DIVQ division factor"]
pub fn set_divq1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } # [doc = "PLL1 DIVR division factor"]
pub const fn divr1 (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "PLL1 DIVR division factor"]
pub fn set_divr1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Pll1divr { fn default () -> Pll1divr { Pll1divr (0) } } # [doc = "RCC PLL3 Dividers Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll3divr (pub u32) ; impl Pll3divr { # [doc = "Multiplication factor for PLL1 VCO"]
pub const fn divn3 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Multiplication factor for PLL1 VCO"]
pub fn set_divn3 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "PLL DIVP division factor"]
pub const fn divp3 (& self) -> u8 { let val = (self . 0 >> 9usize) & 0x7f ; val as u8 } # [doc = "PLL DIVP division factor"]
pub fn set_divp3 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 9usize)) | (((val as u32) & 0x7f) << 9usize) ; } # [doc = "PLL DIVQ division factor"]
pub const fn divq3 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "PLL DIVQ division factor"]
pub fn set_divq3 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } # [doc = "PLL DIVR division factor"]
pub const fn divr3 (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "PLL DIVR division factor"]
pub fn set_divr3 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Pll3divr { fn default () -> Pll3divr { Pll3divr (0) } } # [doc = "RCC Domain 1 Kernel Clock Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D1ccipr (pub u32) ; impl D1ccipr { # [doc = "FMC kernel clock source selection"]
pub const fn fmcsel (& self) -> super :: vals :: Fmcsel { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Fmcsel (val as u8) } # [doc = "FMC kernel clock source selection"]
pub fn set_fmcsel (& mut self , val : super :: vals :: Fmcsel) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "OCTOSPI kernel clock source selection"]
pub const fn octospisel (& self) -> super :: vals :: Fmcsel { let val = (self . 0 >> 4usize) & 0x03 ; super :: vals :: Fmcsel (val as u8) } # [doc = "OCTOSPI kernel clock source selection"]
pub fn set_octospisel (& mut self , val : super :: vals :: Fmcsel) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val . 0 as u32) & 0x03) << 4usize) ; } # [doc = "kernel clock source selection"]
pub const fn dsisel (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "kernel clock source selection"]
pub fn set_dsisel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "SDMMC kernel clock source selection"]
pub const fn sdmmcsel (& self) -> super :: vals :: Sdmmcsel { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Sdmmcsel (val as u8) } # [doc = "SDMMC kernel clock source selection"]
pub fn set_sdmmcsel (& mut self , val : super :: vals :: Sdmmcsel) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "per_ck clock source selection"]
pub const fn ckpersel (& self) -> super :: vals :: Ckpersel { let val = (self . 0 >> 28usize) & 0x03 ; super :: vals :: Ckpersel (val as u8) } # [doc = "per_ck clock source selection"]
pub fn set_ckpersel (& mut self , val : super :: vals :: Ckpersel) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val . 0 as u32) & 0x03) << 28usize) ; } } impl Default for D1ccipr { fn default () -> D1ccipr { D1ccipr (0) } } # [doc = "RCC D3 Autonomous mode Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D3amr (pub u32) ; impl D3amr { # [doc = "BDMA2 and DMAMUX Autonomous mode enable"]
pub const fn bdma2amen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "BDMA2 and DMAMUX Autonomous mode enable"]
pub fn set_bdma2amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "BDMA and DMAMUX Autonomous mode enable"]
pub const fn bdmaamen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "BDMA and DMAMUX Autonomous mode enable"]
pub fn set_bdmaamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LPUART1 Autonomous mode enable"]
pub const fn lpuart1amen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "LPUART1 Autonomous mode enable"]
pub fn set_lpuart1amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "SPI6 Autonomous mode enable"]
pub const fn spi6amen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SPI6 Autonomous mode enable"]
pub fn set_spi6amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "I2C4 Autonomous mode enable"]
pub const fn i2c4amen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I2C4 Autonomous mode enable"]
pub fn set_i2c4amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LPTIM2 Autonomous mode enable"]
pub const fn lptim2amen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 Autonomous mode enable"]
pub fn set_lptim2amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "LPTIM3 Autonomous mode enable"]
pub const fn lptim3amen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "LPTIM3 Autonomous mode enable"]
pub fn set_lptim3amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "LPTIM4 Autonomous mode enable"]
pub const fn lptim4amen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LPTIM4 Autonomous mode enable"]
pub fn set_lptim4amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LPTIM5 Autonomous mode enable"]
pub const fn lptim5amen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LPTIM5 Autonomous mode enable"]
pub fn set_lptim5amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DAC2 (containing one converter) Autonomous mode enable"]
pub const fn dac2amen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DAC2 (containing one converter) Autonomous mode enable"]
pub fn set_dac2amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "COMP12 Autonomous mode enable"]
pub const fn comp12amen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "COMP12 Autonomous mode enable"]
pub fn set_comp12amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "VREF Autonomous mode enable"]
pub const fn vrefamen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "VREF Autonomous mode enable"]
pub fn set_vrefamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "RTC Autonomous mode enable"]
pub const fn rtcamen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "RTC Autonomous mode enable"]
pub fn set_rtcamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CRC Autonomous mode enable"]
pub const fn crcamen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "CRC Autonomous mode enable"]
pub fn set_crcamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "SAI4 Autonomous mode enable"]
pub const fn sai4amen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI4 Autonomous mode enable"]
pub fn set_sai4amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "ADC3 Autonomous mode enable"]
pub const fn adc3amen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "ADC3 Autonomous mode enable"]
pub fn set_adc3amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Digital temperature sensor Autonomous mode enable"]
pub const fn dtsamen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Digital temperature sensor Autonomous mode enable"]
pub fn set_dtsamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Backup RAM Autonomous mode enable"]
pub const fn bkpsramamen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Backup RAM Autonomous mode enable"]
pub fn set_bkpsramamen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "SRAM4 Autonomous mode enable"]
pub const fn sram4amen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "SRAM4 Autonomous mode enable"]
pub fn set_sram4amen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for D3amr { fn default () -> D3amr { D3amr (0) } } # [doc = "RCC Clock Source Interrupt Enable Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cier (pub u32) ; impl Cier { # [doc = "LSI ready Interrupt Enable"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready Interrupt Enable"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready Interrupt Enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready Interrupt Enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI ready Interrupt Enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI ready Interrupt Enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE ready Interrupt Enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE ready Interrupt Enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CSI ready Interrupt Enable"]
pub const fn csirdyie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CSI ready Interrupt Enable"]
pub fn set_csirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RC48 ready Interrupt Enable"]
pub const fn hsi48rdyie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RC48 ready Interrupt Enable"]
pub fn set_hsi48rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLL1 ready Interrupt Enable"]
pub fn pllrdyie (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 ready Interrupt Enable"]
pub fn set_pllrdyie (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "LSE clock security system Interrupt Enable"]
pub const fn lsecssie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE clock security system Interrupt Enable"]
pub fn set_lsecssie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for Cier { fn default () -> Cier { Cier (0) } } # [doc = "RCC APB1 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1henr (pub u32) ; impl Apb1henr { # [doc = "Clock Recovery System peripheral clock enable"]
pub const fn crsen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Clock Recovery System peripheral clock enable"]
pub fn set_crsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SWPMI Peripheral Clocks Enable"]
pub const fn swpen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "SWPMI Peripheral Clocks Enable"]
pub fn set_swpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "OPAMP peripheral clock enable"]
pub const fn opampen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OPAMP peripheral clock enable"]
pub fn set_opampen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MDIOS peripheral clock enable"]
pub const fn mdiosen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "MDIOS peripheral clock enable"]
pub fn set_mdiosen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FDCAN Peripheral Clocks Enable"]
pub const fn fdcanen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "FDCAN Peripheral Clocks Enable"]
pub fn set_fdcanen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "TIM23 block enable"]
pub const fn tim23en (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "TIM23 block enable"]
pub fn set_tim23en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "TIM24 block enable"]
pub const fn tim24en (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "TIM24 block enable"]
pub fn set_tim24en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Apb1henr { fn default () -> Apb1henr { Apb1henr (0) } } # [doc = "RCC AHB4 Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb4lpenr (pub u32) ; impl Ahb4lpenr { # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpioalpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpioalpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpioblpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpioblpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpioclpen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpioclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpiodlpen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpiodlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpioelpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpioelpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpioflpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpioflpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpioglpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpioglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpiohlpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpiohlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpioilpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpioilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpiojlpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpiojlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub const fn gpioklpen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "GPIO peripheral clock enable during CSleep mode"]
pub fn set_gpioklpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CRC peripheral clock enable during CSleep mode"]
pub const fn crclpen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "CRC peripheral clock enable during CSleep mode"]
pub fn set_crclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "BDMA2 Clock Enable During CSleep Mode"]
pub const fn bdma2lpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "BDMA2 Clock Enable During CSleep Mode"]
pub fn set_bdma2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "BDMA Clock Enable During CSleep Mode"]
pub const fn bdmalpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "BDMA Clock Enable During CSleep Mode"]
pub fn set_bdmalpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "ADC3 Peripheral Clocks Enable During CSleep Mode"]
pub const fn adc3lpen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "ADC3 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_adc3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Backup RAM Clock Enable During CSleep Mode"]
pub const fn bkpsramlpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Backup RAM Clock Enable During CSleep Mode"]
pub fn set_bkpsramlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "SRAM4 Clock Enable During CSleep Mode"]
pub const fn sram4lpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "SRAM4 Clock Enable During CSleep Mode"]
pub fn set_sram4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Ahb4lpenr { fn default () -> Ahb4lpenr { Ahb4lpenr (0) } } # [doc = "RCC AHB2 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2enr (pub u32) ; impl Ahb2enr { # [doc = "DCMI peripheral clock"]
pub const fn dcmien (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DCMI peripheral clock"]
pub fn set_dcmien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CRYPT peripheral clock enable"]
pub const fn crypten (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CRYPT peripheral clock enable"]
pub fn set_crypten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "HASH peripheral clock enable"]
pub const fn hashen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "HASH peripheral clock enable"]
pub fn set_hashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "RNG peripheral clocks enable"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "RNG peripheral clocks enable"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "SDMMC2 and SDMMC2 delay clock enable"]
pub const fn sdmmc2en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 and SDMMC2 delay clock enable"]
pub fn set_sdmmc2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "BDMA1 clock enable"]
pub const fn bdma1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "BDMA1 clock enable"]
pub fn set_bdma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "FMAC enable"]
pub const fn fmacen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "FMAC enable"]
pub fn set_fmacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CORDIC enable"]
pub const fn cordicen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CORDIC enable"]
pub fn set_cordicen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "SRAM1 block enable"]
pub const fn sram1en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "SRAM1 block enable"]
pub fn set_sram1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "SRAM2 block enable"]
pub const fn sram2en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "SRAM2 block enable"]
pub fn set_sram2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "SRAM3 block enable"]
pub const fn sram3en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SRAM3 block enable"]
pub fn set_sram3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb2enr { fn default () -> Ahb2enr { Ahb2enr (0) } } # [doc = "Global Control Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gcr (pub u32) ; impl Gcr { # [doc = "WWDG1 reset scope control"]
pub const fn ww1rsc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "WWDG1 reset scope control"]
pub fn set_ww1rsc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Gcr { fn default () -> Gcr { Gcr (0) } } # [doc = "RCC APB1 Peripheral Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1hrstr (pub u32) ; impl Apb1hrstr { # [doc = "Clock Recovery System reset"]
pub const fn crsrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Clock Recovery System reset"]
pub fn set_crsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SWPMI block reset"]
pub const fn swprst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "SWPMI block reset"]
pub fn set_swprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "OPAMP block reset"]
pub const fn opamprst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OPAMP block reset"]
pub fn set_opamprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MDIOS block reset"]
pub const fn mdiosrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "MDIOS block reset"]
pub fn set_mdiosrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FDCAN block reset"]
pub const fn fdcanrst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "FDCAN block reset"]
pub fn set_fdcanrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "TIM23 block reset"]
pub const fn tim23rst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "TIM23 block reset"]
pub fn set_tim23rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "TIM24 block reset"]
pub const fn tim24rst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "TIM24 block reset"]
pub fn set_tim24rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Apb1hrstr { fn default () -> Apb1hrstr { Apb1hrstr (0) } } # [doc = "RCC Domain 3 Clock Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D3cfgr (pub u32) ; impl D3cfgr { # [doc = "D3 domain APB4 prescaler"]
pub const fn d3ppre (& self) -> super :: vals :: Dppre { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Dppre (val as u8) } # [doc = "D3 domain APB4 prescaler"]
pub fn set_d3ppre (& mut self , val : super :: vals :: Dppre) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } } impl Default for D3cfgr { fn default () -> D3cfgr { D3cfgr (0) } } # [doc = "RCC AHB1 Peripheral Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1rstr (pub u32) ; impl Ahb1rstr { # [doc = "DMA1 block reset"]
pub const fn dma1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 block reset"]
pub fn set_dma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 block reset"]
pub const fn dma2rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 block reset"]
pub fn set_dma2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "ADC1&2 block reset"]
pub const fn adc12rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "ADC1&2 block reset"]
pub fn set_adc12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ART block reset"]
pub const fn artrst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "ART block reset"]
pub fn set_artrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "ETH1MAC block reset"]
pub const fn eth1macrst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "ETH1MAC block reset"]
pub fn set_eth1macrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USB1OTG block reset"]
pub const fn usb1otgrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "USB1OTG block reset"]
pub fn set_usb1otgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "USB2OTG block reset"]
pub const fn usb2otgrst (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "USB2OTG block reset"]
pub fn set_usb2otgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Ahb1rstr { fn default () -> Ahb1rstr { Ahb1rstr (0) } } # [doc = "RCC PLL2 Fractional Divider Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll2fracr (pub u32) ; impl Pll2fracr { # [doc = "Fractional part of the multiplication factor for PLL VCO"]
pub const fn fracn2 (& self) -> u16 { let val = (self . 0 >> 3usize) & 0x1fff ; val as u16 } # [doc = "Fractional part of the multiplication factor for PLL VCO"]
pub fn set_fracn2 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 3usize)) | (((val as u32) & 0x1fff) << 3usize) ; } } impl Default for Pll2fracr { fn default () -> Pll2fracr { Pll2fracr (0) } } # [doc = "RCC AHB3 Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3rstr (pub u32) ; impl Ahb3rstr { # [doc = "MDMA block reset"]
pub const fn mdmarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "MDMA block reset"]
pub fn set_mdmarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2D block reset"]
pub const fn dma2drst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "DMA2D block reset"]
pub fn set_dma2drst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "JPGDEC block reset"]
pub const fn jpgdecrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "JPGDEC block reset"]
pub fn set_jpgdecrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FMC block reset"]
pub const fn fmcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "FMC block reset"]
pub fn set_fmcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "QUADSPI and QUADSPI delay block reset"]
pub const fn qspirst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "QUADSPI and QUADSPI delay block reset"]
pub fn set_qspirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SDMMC1 and SDMMC1 delay block reset"]
pub const fn sdmmc1rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 and SDMMC1 delay block reset"]
pub fn set_sdmmc1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "OCTOSPI2 and OCTOSPI2 delay block reset"]
pub const fn octospi2rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI2 and OCTOSPI2 delay block reset"]
pub fn set_octospi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "OCTOSPI IO manager reset"]
pub const fn iomngrrst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI IO manager reset"]
pub fn set_iomngrrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "OTFDEC1 reset"]
pub const fn otfd1rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "OTFDEC1 reset"]
pub fn set_otfd1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "OTFDEC2 reset"]
pub const fn otfd2rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "OTFDEC2 reset"]
pub fn set_otfd2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CPU reset"]
pub const fn cpurst (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "CPU reset"]
pub fn set_cpurst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb3rstr { fn default () -> Ahb3rstr { Ahb3rstr (0) } } # [doc = "RCC APB1 High Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1hlpenr (pub u32) ; impl Apb1hlpenr { # [doc = "Clock Recovery System peripheral clock enable during CSleep mode"]
pub const fn crslpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Clock Recovery System peripheral clock enable during CSleep mode"]
pub fn set_crslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SWPMI Peripheral Clocks Enable During CSleep Mode"]
pub const fn swplpen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "SWPMI Peripheral Clocks Enable During CSleep Mode"]
pub fn set_swplpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "OPAMP peripheral clock enable during CSleep mode"]
pub const fn opamplpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OPAMP peripheral clock enable during CSleep mode"]
pub fn set_opamplpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MDIOS peripheral clock enable during CSleep mode"]
pub const fn mdioslpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "MDIOS peripheral clock enable during CSleep mode"]
pub fn set_mdioslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FDCAN Peripheral Clocks Enable During CSleep Mode"]
pub const fn fdcanlpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "FDCAN Peripheral Clocks Enable During CSleep Mode"]
pub fn set_fdcanlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "TIM23 block enable during CSleep Mode"]
pub const fn tim23lpen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "TIM23 block enable during CSleep Mode"]
pub fn set_tim23lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "TIM24 block enable during CSleep Mode"]
pub const fn tim24lpen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "TIM24 block enable during CSleep Mode"]
pub fn set_tim24lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Apb1hlpenr { fn default () -> Apb1hlpenr { Apb1hlpenr (0) } } # [doc = "RCC APB1 Low Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1llpenr (pub u32) ; impl Apb1llpenr { # [doc = "TIM2 peripheral clock enable during CSleep mode"]
pub const fn tim2lpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 peripheral clock enable during CSleep mode"]
pub fn set_tim2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 peripheral clock enable during CSleep mode"]
pub const fn tim3lpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 peripheral clock enable during CSleep mode"]
pub fn set_tim3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 peripheral clock enable during CSleep mode"]
pub const fn tim4lpen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 peripheral clock enable during CSleep mode"]
pub fn set_tim4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 peripheral clock enable during CSleep mode"]
pub const fn tim5lpen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 peripheral clock enable during CSleep mode"]
pub fn set_tim5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 peripheral clock enable during CSleep mode"]
pub const fn tim6lpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 peripheral clock enable during CSleep mode"]
pub fn set_tim6lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 peripheral clock enable during CSleep mode"]
pub const fn tim7lpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 peripheral clock enable during CSleep mode"]
pub fn set_tim7lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM12 peripheral clock enable during CSleep mode"]
pub const fn tim12lpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM12 peripheral clock enable during CSleep mode"]
pub fn set_tim12lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM13 peripheral clock enable during CSleep mode"]
pub const fn tim13lpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM13 peripheral clock enable during CSleep mode"]
pub fn set_tim13lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM14 peripheral clock enable during CSleep mode"]
pub const fn tim14lpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14 peripheral clock enable during CSleep mode"]
pub fn set_tim14lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LPTIM1 Peripheral Clocks Enable During CSleep Mode"]
pub const fn lptim1lpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_lptim1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "WWDG2 peripheral Clocks Enable During CSleep Mode"]
pub const fn wwdg2lpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "WWDG2 peripheral Clocks Enable During CSleep Mode"]
pub fn set_wwdg2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 Peripheral Clocks Enable During CSleep Mode"]
pub const fn spi2lpen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_spi2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 Peripheral Clocks Enable During CSleep Mode"]
pub const fn spi3lpen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_spi3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SPDIFRX Peripheral Clocks Enable During CSleep Mode"]
pub const fn spdifrxlpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SPDIFRX Peripheral Clocks Enable During CSleep Mode"]
pub fn set_spdifrxlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "USART2 Peripheral Clocks Enable During CSleep Mode"]
pub const fn usart2lpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_usart2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 Peripheral Clocks Enable During CSleep Mode"]
pub const fn usart3lpen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_usart3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 Peripheral Clocks Enable During CSleep Mode"]
pub const fn uart4lpen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_uart4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 Peripheral Clocks Enable During CSleep Mode"]
pub const fn uart5lpen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_uart5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 Peripheral Clocks Enable During CSleep Mode"]
pub const fn i2c1lpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_i2c1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 Peripheral Clocks Enable During CSleep Mode"]
pub const fn i2c2lpen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_i2c2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 Peripheral Clocks Enable During CSleep Mode"]
pub const fn i2c3lpen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_i2c3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "I2C5 block enable during CSleep Mode"]
pub const fn i2c5lpen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "I2C5 block enable during CSleep Mode"]
pub fn set_i2c5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "HDMI-CEC Peripheral Clocks Enable During CSleep Mode"]
pub const fn ceclpen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "HDMI-CEC Peripheral Clocks Enable During CSleep Mode"]
pub fn set_ceclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "DAC1 (containing two converters) peripheral clock enable during CSleep mode"]
pub const fn dac1lpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC1 (containing two converters) peripheral clock enable during CSleep mode"]
pub fn set_dac1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "UART7 Peripheral Clocks Enable During CSleep Mode"]
pub const fn uart7lpen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "UART7 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_uart7lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "UART8 Peripheral Clocks Enable During CSleep Mode"]
pub const fn uart8lpen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "UART8 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_uart8lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1llpenr { fn default () -> Apb1llpenr { Apb1llpenr (0) } } # [doc = "RCC Domain 1 Clock Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D1cfgr (pub u32) ; impl D1cfgr { # [doc = "D1 domain AHB prescaler"]
pub const fn hpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "D1 domain AHB prescaler"]
pub fn set_hpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "D1 domain APB3 prescaler"]
pub const fn d1ppre (& self) -> super :: vals :: Dppre { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Dppre (val as u8) } # [doc = "D1 domain APB3 prescaler"]
pub fn set_d1ppre (& mut self , val : super :: vals :: Dppre) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } # [doc = "D1 domain Core prescaler"]
pub const fn d1cpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "D1 domain Core prescaler"]
pub fn set_d1cpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } } impl Default for D1cfgr { fn default () -> D1cfgr { D1cfgr (0) } } # [doc = "RCC AHB1 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1enr (pub u32) ; impl Ahb1enr { # [doc = "DMA1 Clock Enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 Clock Enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 Clock Enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 Clock Enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "ADC1/2 Peripheral Clocks Enable"]
pub const fn adc12en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "ADC1/2 Peripheral Clocks Enable"]
pub fn set_adc12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ART Clock Enable"]
pub const fn arten (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "ART Clock Enable"]
pub fn set_arten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Ethernet MAC bus interface Clock Enable"]
pub const fn eth1macen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC bus interface Clock Enable"]
pub fn set_eth1macen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Ethernet Transmission Clock Enable"]
pub const fn eth1txen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Ethernet Transmission Clock Enable"]
pub fn set_eth1txen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Ethernet Reception Clock Enable"]
pub const fn eth1rxen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Ethernet Reception Clock Enable"]
pub fn set_eth1rxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Enable USB_PHY2 clocks"]
pub const fn usb2otghsulpien (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Enable USB_PHY2 clocks"]
pub fn set_usb2otghsulpien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USB1OTG Peripheral Clocks Enable"]
pub const fn usb1otgen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "USB1OTG Peripheral Clocks Enable"]
pub fn set_usb1otgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "USB_PHY1 Clocks Enable"]
pub const fn usb1ulpien (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "USB_PHY1 Clocks Enable"]
pub fn set_usb1ulpien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "USB2OTG Peripheral Clocks Enable"]
pub const fn usb2otgen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "USB2OTG Peripheral Clocks Enable"]
pub fn set_usb2otgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "USB_PHY2 Clocks Enable"]
pub const fn usb2ulpien (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "USB_PHY2 Clocks Enable"]
pub fn set_usb2ulpien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } } impl Default for Ahb1enr { fn default () -> Ahb1enr { Ahb1enr (0) } } # [doc = "RCC Domain 2 Kernel Clock Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D2ccip1r (pub u32) ; impl D2ccip1r { # [doc = "SAI1 and DFSDM1 kernel Aclk clock source selection"]
pub const fn sai1sel (& self) -> super :: vals :: Saisel { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Saisel (val as u8) } # [doc = "SAI1 and DFSDM1 kernel Aclk clock source selection"]
pub fn set_sai1sel (& mut self , val : super :: vals :: Saisel) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "SAI2 kernel clock source A source selection"]
pub const fn sai2asel (& self) -> super :: vals :: Saiasel { let val = (self . 0 >> 6usize) & 0x07 ; super :: vals :: Saiasel (val as u8) } # [doc = "SAI2 kernel clock source A source selection"]
pub fn set_sai2asel (& mut self , val : super :: vals :: Saiasel) { self . 0 = (self . 0 & ! (0x07 << 6usize)) | (((val . 0 as u32) & 0x07) << 6usize) ; } # [doc = "SAI2 kernel clock source B source selection"]
pub const fn sai2bsel (& self) -> super :: vals :: Saiasel { let val = (self . 0 >> 9usize) & 0x07 ; super :: vals :: Saiasel (val as u8) } # [doc = "SAI2 kernel clock source B source selection"]
pub fn set_sai2bsel (& mut self , val : super :: vals :: Saiasel) { self . 0 = (self . 0 & ! (0x07 << 9usize)) | (((val . 0 as u32) & 0x07) << 9usize) ; } # [doc = "SPI/I2S1,2 and 3 kernel clock source selection"]
pub const fn spi123sel (& self) -> super :: vals :: Saisel { let val = (self . 0 >> 12usize) & 0x07 ; super :: vals :: Saisel (val as u8) } # [doc = "SPI/I2S1,2 and 3 kernel clock source selection"]
pub fn set_spi123sel (& mut self , val : super :: vals :: Saisel) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val . 0 as u32) & 0x07) << 12usize) ; } # [doc = "SPI4 and 5 kernel clock source selection"]
pub const fn spi45sel (& self) -> super :: vals :: Spi45sel { let val = (self . 0 >> 16usize) & 0x07 ; super :: vals :: Spi45sel (val as u8) } # [doc = "SPI4 and 5 kernel clock source selection"]
pub fn set_spi45sel (& mut self , val : super :: vals :: Spi45sel) { self . 0 = (self . 0 & ! (0x07 << 16usize)) | (((val . 0 as u32) & 0x07) << 16usize) ; } # [doc = "SPDIFRX kernel clock source selection"]
pub const fn spdifrxsel (& self) -> super :: vals :: Spdifrxsel { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Spdifrxsel (val as u8) } # [doc = "SPDIFRX kernel clock source selection"]
pub fn set_spdifrxsel (& mut self , val : super :: vals :: Spdifrxsel) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "DFSDM1 kernel Clk clock source selection"]
pub const fn dfsdm1sel (& self) -> super :: vals :: Dfsdmsel { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Dfsdmsel (val as u8) } # [doc = "DFSDM1 kernel Clk clock source selection"]
pub fn set_dfsdm1sel (& mut self , val : super :: vals :: Dfsdmsel) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "FDCAN kernel clock source selection"]
pub const fn fdcansel (& self) -> super :: vals :: Fdcansel { let val = (self . 0 >> 28usize) & 0x03 ; super :: vals :: Fdcansel (val as u8) } # [doc = "FDCAN kernel clock source selection"]
pub fn set_fdcansel (& mut self , val : super :: vals :: Fdcansel) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val . 0 as u32) & 0x03) << 28usize) ; } # [doc = "SWPMI kernel clock source selection"]
pub const fn swpsel (& self) -> super :: vals :: Swpsel { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Swpsel (val as u8) } # [doc = "SWPMI kernel clock source selection"]
pub fn set_swpsel (& mut self , val : super :: vals :: Swpsel) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for D2ccip1r { fn default () -> D2ccip1r { D2ccip1r (0) } } # [doc = "RCC AHB2 Peripheral Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2rstr (pub u32) ; impl Ahb2rstr { # [doc = "DCMI block reset"]
pub const fn dcmirst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DCMI block reset"]
pub fn set_dcmirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Cryptography block reset"]
pub const fn cryptrst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Cryptography block reset"]
pub fn set_cryptrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Hash block reset"]
pub const fn hashrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Hash block reset"]
pub fn set_hashrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Random Number Generator block reset"]
pub const fn rngrst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Random Number Generator block reset"]
pub fn set_rngrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "SDMMC2 and SDMMC2 Delay block reset"]
pub const fn sdmmc2rst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 and SDMMC2 Delay block reset"]
pub fn set_sdmmc2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "BDMA1 block reset"]
pub const fn bdma1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "BDMA1 block reset"]
pub fn set_bdma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "FMAC reset"]
pub const fn fmacrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "FMAC reset"]
pub fn set_fmacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CORDIC reset"]
pub const fn cordicrst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CORDIC reset"]
pub fn set_cordicrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } } impl Default for Ahb2rstr { fn default () -> Ahb2rstr { Ahb2rstr (0) } } # [doc = "RCC APB2 Peripheral Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "TIM1 block reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 block reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 block reset"]
pub const fn tim8rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 block reset"]
pub fn set_tim8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 block reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 block reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 block reset"]
pub const fn usart6rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 block reset"]
pub fn set_usart6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "UART9 block reset"]
pub const fn uart9rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "UART9 block reset"]
pub fn set_uart9rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USART10 block reset"]
pub const fn usart10rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USART10 block reset"]
pub fn set_usart10rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "SPI1 block reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 block reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SPI4 block reset"]
pub const fn spi4rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SPI4 block reset"]
pub fn set_spi4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "TIM15 block reset"]
pub const fn tim15rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 block reset"]
pub fn set_tim15rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 block reset"]
pub const fn tim16rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 block reset"]
pub fn set_tim16rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 block reset"]
pub const fn tim17rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 block reset"]
pub fn set_tim17rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SPI5 block reset"]
pub const fn spi5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SPI5 block reset"]
pub fn set_spi5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SAI1 block reset"]
pub const fn sai1rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI1 block reset"]
pub fn set_sai1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "SAI2 block reset"]
pub const fn sai2rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "SAI2 block reset"]
pub fn set_sai2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "SAI3 block reset"]
pub const fn sai3rst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SAI3 block reset"]
pub fn set_sai3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "DFSDM1 block reset"]
pub const fn dfsdm1rst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "DFSDM1 block reset"]
pub fn set_dfsdm1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "HRTIM block reset"]
pub const fn hrtimrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "HRTIM block reset"]
pub fn set_hrtimrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "RCC Clock Recovery RC Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crrcr (pub u32) ; impl Crrcr { # [doc = "Internal RC 48 MHz clock calibration"]
pub const fn hsi48cal (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x03ff ; val as u16 } # [doc = "Internal RC 48 MHz clock calibration"]
pub fn set_hsi48cal (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 0usize)) | (((val as u32) & 0x03ff) << 0usize) ; } } impl Default for Crrcr { fn default () -> Crrcr { Crrcr (0) } } # [doc = "RCC APB1 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1lenr (pub u32) ; impl Apb1lenr { # [doc = "TIM peripheral clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM peripheral clock enable"]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM peripheral clock enable"]
pub const fn tim4en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM peripheral clock enable"]
pub const fn tim5en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM peripheral clock enable"]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM peripheral clock enable"]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM peripheral clock enable"]
pub const fn tim12en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM peripheral clock enable"]
pub const fn tim13en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim13en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM peripheral clock enable"]
pub const fn tim14en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM peripheral clock enable"]
pub fn set_tim14en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LPTIM1 Peripheral Clocks Enable"]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 Peripheral Clocks Enable"]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "WWDG2 peripheral clock enable"]
pub const fn wwdg2en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "WWDG2 peripheral clock enable"]
pub fn set_wwdg2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 Peripheral Clocks Enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 Peripheral Clocks Enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 Peripheral Clocks Enable"]
pub const fn spi3en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 Peripheral Clocks Enable"]
pub fn set_spi3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SPDIFRX Peripheral Clocks Enable"]
pub const fn spdifrxen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SPDIFRX Peripheral Clocks Enable"]
pub fn set_spdifrxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "USART2 Peripheral Clocks Enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 Peripheral Clocks Enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 Peripheral Clocks Enable"]
pub const fn usart3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 Peripheral Clocks Enable"]
pub fn set_usart3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 Peripheral Clocks Enable"]
pub const fn uart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 Peripheral Clocks Enable"]
pub fn set_uart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 Peripheral Clocks Enable"]
pub const fn uart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 Peripheral Clocks Enable"]
pub fn set_uart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 Peripheral Clocks Enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 Peripheral Clocks Enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 Peripheral Clocks Enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 Peripheral Clocks Enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 Peripheral Clocks Enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 Peripheral Clocks Enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "I2C5 Peripheral Clocks Enable"]
pub const fn i2c5en (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "I2C5 Peripheral Clocks Enable"]
pub fn set_i2c5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "HDMI-CEC peripheral clock enable"]
pub const fn cecen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "HDMI-CEC peripheral clock enable"]
pub fn set_cecen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "DAC1 (containing two converters) peripheral clock enable"]
pub const fn dac1en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC1 (containing two converters) peripheral clock enable"]
pub fn set_dac1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "UART7 Peripheral Clocks Enable"]
pub const fn uart7en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "UART7 Peripheral Clocks Enable"]
pub fn set_uart7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "UART8 Peripheral Clocks Enable"]
pub const fn uart8en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "UART8 Peripheral Clocks Enable"]
pub fn set_uart8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1lenr { fn default () -> Apb1lenr { Apb1lenr (0) } } # [doc = "RCC PLLs Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllcfgr (pub u32) ; impl Pllcfgr { # [doc = "PLL1 fractional latch enable"]
pub fn pllfracen (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 fractional latch enable"]
pub fn set_pllfracen (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "PLL1 VCO selection"]
pub fn pllvcosel (& self , n : usize) -> super :: vals :: Pllvcosel { assert ! (n < 3usize) ; let offs = 1usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Pllvcosel (val as u8) } # [doc = "PLL1 VCO selection"]
pub fn set_pllvcosel (& mut self , n : usize , val : super :: vals :: Pllvcosel) { assert ! (n < 3usize) ; let offs = 1usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "PLL1 input frequency range"]
pub fn pllrge (& self , n : usize) -> super :: vals :: Pllrge { assert ! (n < 3usize) ; let offs = 2usize + n * 4usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: Pllrge (val as u8) } # [doc = "PLL1 input frequency range"]
pub fn set_pllrge (& mut self , n : usize , val : super :: vals :: Pllrge) { assert ! (n < 3usize) ; let offs = 2usize + n * 4usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } # [doc = "PLL1 DIVP divider output enable"]
pub fn divpen (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 16usize + n * 3usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 DIVP divider output enable"]
pub fn set_divpen (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 16usize + n * 3usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "PLL1 DIVQ divider output enable"]
pub fn divqen (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 17usize + n * 3usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 DIVQ divider output enable"]
pub fn set_divqen (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 17usize + n * 3usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "PLL1 DIVR divider output enable"]
pub fn divren (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 18usize + n * 3usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 DIVR divider output enable"]
pub fn set_divren (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 18usize + n * 3usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Pllcfgr { fn default () -> Pllcfgr { Pllcfgr (0) } } # [doc = "RCC Clock Source Interrupt Flag Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cifr (pub u32) ; impl Cifr { # [doc = "LSI ready Interrupt Flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready Interrupt Flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready Interrupt Flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready Interrupt Flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI ready Interrupt Flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI ready Interrupt Flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE ready Interrupt Flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE ready Interrupt Flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CSI ready Interrupt Flag"]
pub const fn csirdy (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CSI ready Interrupt Flag"]
pub fn set_csirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RC48 ready Interrupt Flag"]
pub const fn hsi48rdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RC48 ready Interrupt Flag"]
pub fn set_hsi48rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLL1 ready Interrupt Flag"]
pub fn pllrdyf (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 ready Interrupt Flag"]
pub fn set_pllrdyf (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 6usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "LSE clock security system Interrupt Flag"]
pub const fn lsecssf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE clock security system Interrupt Flag"]
pub fn set_lsecssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSE clock security system Interrupt Flag"]
pub const fn hsecssf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSE clock security system Interrupt Flag"]
pub fn set_hsecssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Cifr { fn default () -> Cifr { Cifr (0) } } # [doc = "RCC Clock Control and Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "LSI oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSI oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSI oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "RCC Domain 2 Kernel Clock Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D2ccip2r (pub u32) ; impl D2ccip2r { # [doc = "USART2/3, UART4,5, 7/8 (APB1) kernel clock source selection"]
pub const fn usart234578sel (& self) -> super :: vals :: Usart234578sel { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Usart234578sel (val as u8) } # [doc = "USART2/3, UART4,5, 7/8 (APB1) kernel clock source selection"]
pub fn set_usart234578sel (& mut self , val : super :: vals :: Usart234578sel) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "USART1, 6, 9 and 10 kernel clock source selection"]
pub const fn usart16910sel (& self) -> super :: vals :: Usart16910sel { let val = (self . 0 >> 3usize) & 0x07 ; super :: vals :: Usart16910sel (val as u8) } # [doc = "USART1, 6, 9 and 10 kernel clock source selection"]
pub fn set_usart16910sel (& mut self , val : super :: vals :: Usart16910sel) { self . 0 = (self . 0 & ! (0x07 << 3usize)) | (((val . 0 as u32) & 0x07) << 3usize) ; } # [doc = "RNG kernel clock source selection"]
pub const fn rngsel (& self) -> super :: vals :: Rngsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Rngsel (val as u8) } # [doc = "RNG kernel clock source selection"]
pub fn set_rngsel (& mut self , val : super :: vals :: Rngsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "I2C1,2,3 kernel clock source selection"]
pub const fn i2c1235sel (& self) -> super :: vals :: I2c1235sel { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: I2c1235sel (val as u8) } # [doc = "I2C1,2,3 kernel clock source selection"]
pub fn set_i2c1235sel (& mut self , val : super :: vals :: I2c1235sel) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "USBOTG 1 and 2 kernel clock source selection"]
pub const fn usbsel (& self) -> super :: vals :: Usbsel { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Usbsel (val as u8) } # [doc = "USBOTG 1 and 2 kernel clock source selection"]
pub fn set_usbsel (& mut self , val : super :: vals :: Usbsel) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "HDMI-CEC kernel clock source selection"]
pub const fn cecsel (& self) -> super :: vals :: Cecsel { let val = (self . 0 >> 22usize) & 0x03 ; super :: vals :: Cecsel (val as u8) } # [doc = "HDMI-CEC kernel clock source selection"]
pub fn set_cecsel (& mut self , val : super :: vals :: Cecsel) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val . 0 as u32) & 0x03) << 22usize) ; } # [doc = "LPTIM1 kernel clock source selection"]
pub const fn lptim1sel (& self) -> super :: vals :: Lptim1sel { let val = (self . 0 >> 28usize) & 0x07 ; super :: vals :: Lptim1sel (val as u8) } # [doc = "LPTIM1 kernel clock source selection"]
pub fn set_lptim1sel (& mut self , val : super :: vals :: Lptim1sel) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val . 0 as u32) & 0x07) << 28usize) ; } } impl Default for D2ccip2r { fn default () -> D2ccip2r { D2ccip2r (0) } } # [doc = "RCC PLL3 Fractional Divider Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll3fracr (pub u32) ; impl Pll3fracr { # [doc = "Fractional part of the multiplication factor for PLL3 VCO"]
pub const fn fracn3 (& self) -> u16 { let val = (self . 0 >> 3usize) & 0x1fff ; val as u16 } # [doc = "Fractional part of the multiplication factor for PLL3 VCO"]
pub fn set_fracn3 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 3usize)) | (((val as u32) & 0x1fff) << 3usize) ; } } impl Default for Pll3fracr { fn default () -> Pll3fracr { Pll3fracr (0) } } # [doc = "RCC AHB4 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb4enr (pub u32) ; impl Ahb4enr { # [doc = "0GPIO peripheral clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpiofen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpiofen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpiogen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpiogen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpioien (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpioien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpiojen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpiojen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "0GPIO peripheral clock enable"]
pub const fn gpioken (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "0GPIO peripheral clock enable"]
pub fn set_gpioken (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CRC peripheral clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "CRC peripheral clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "BDMA2 and DMAMUX2 Clock Enable"]
pub const fn bdma2en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "BDMA2 and DMAMUX2 Clock Enable"]
pub fn set_bdma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "BDMA and DMAMUX2 Clock Enable"]
pub const fn bdmaen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "BDMA and DMAMUX2 Clock Enable"]
pub fn set_bdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "ADC3 Peripheral Clocks Enable"]
pub const fn adc3en (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "ADC3 Peripheral Clocks Enable"]
pub fn set_adc3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "HSEM peripheral clock enable"]
pub const fn hsemen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "HSEM peripheral clock enable"]
pub fn set_hsemen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Backup RAM Clock Enable"]
pub const fn bkpsramen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Backup RAM Clock Enable"]
pub fn set_bkpsramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } } impl Default for Ahb4enr { fn default () -> Ahb4enr { Ahb4enr (0) } } # [doc = "RCC PLLs Clock Source Selection Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllckselr (pub u32) ; impl Pllckselr { # [doc = "DIVMx and PLLs clock source selection"]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Pllsrc (val as u8) } # [doc = "DIVMx and PLLs clock source selection"]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "Prescaler for PLL1"]
pub fn divm (& self , n : usize) -> u8 { assert ! (n < 3usize) ; let offs = 4usize + n * 8usize ; let val = (self . 0 >> offs) & 0x3f ; val as u8 } # [doc = "Prescaler for PLL1"]
pub fn set_divm (& mut self , n : usize , val : u8) { assert ! (n < 3usize) ; let offs = 4usize + n * 8usize ; self . 0 = (self . 0 & ! (0x3f << offs)) | (((val as u32) & 0x3f) << offs) ; } } impl Default for Pllckselr { fn default () -> Pllckselr { Pllckselr (0) } } # [doc = "RCC PLL2 Dividers Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pll2divr (pub u32) ; impl Pll2divr { # [doc = "Multiplication factor for PLL1 VCO"]
pub const fn divn2 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Multiplication factor for PLL1 VCO"]
pub fn set_divn2 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } # [doc = "PLL1 DIVP division factor"]
pub const fn divp2 (& self) -> u8 { let val = (self . 0 >> 9usize) & 0x7f ; val as u8 } # [doc = "PLL1 DIVP division factor"]
pub fn set_divp2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 9usize)) | (((val as u32) & 0x7f) << 9usize) ; } # [doc = "PLL1 DIVQ division factor"]
pub const fn divq2 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "PLL1 DIVQ division factor"]
pub fn set_divq2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } # [doc = "PLL1 DIVR division factor"]
pub const fn divr2 (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "PLL1 DIVR division factor"]
pub fn set_divr2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Pll2divr { fn default () -> Pll2divr { Pll2divr (0) } } # [doc = "clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Internal high-speed clock enable"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal high-speed clock enable"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "High Speed Internal clock enable in Stop mode"]
pub const fn hsikeron (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "High Speed Internal clock enable in Stop mode"]
pub fn set_hsikeron (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI clock ready flag"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI clock ready flag"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI clock divider"]
pub const fn hsidiv (& self) -> super :: vals :: Hsidiv { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Hsidiv (val as u8) } # [doc = "HSI clock divider"]
pub fn set_hsidiv (& mut self , val : super :: vals :: Hsidiv) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "HSI divider flag"]
pub const fn hsidivf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "HSI divider flag"]
pub fn set_hsidivf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CSI clock enable"]
pub const fn csion (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "CSI clock enable"]
pub fn set_csion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "CSI clock ready flag"]
pub const fn csirdy (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "CSI clock ready flag"]
pub fn set_csirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CSI clock enable in Stop mode"]
pub const fn csikeron (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CSI clock enable in Stop mode"]
pub fn set_csikeron (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "RC48 clock enable"]
pub const fn hsi48on (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "RC48 clock enable"]
pub fn set_hsi48on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "RC48 clock ready flag"]
pub const fn hsi48rdy (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "RC48 clock ready flag"]
pub fn set_hsi48rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "D1 domain clocks ready flag"]
pub const fn d1ckrdy (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "D1 domain clocks ready flag"]
pub fn set_d1ckrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "D2 domain clocks ready flag"]
pub const fn d2ckrdy (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "D2 domain clocks ready flag"]
pub fn set_d2ckrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "HSE clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSE clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSE clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSE clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSE clock bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSE clock bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSE Clock Security System enable"]
pub const fn hsecsson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSE Clock Security System enable"]
pub fn set_hsecsson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "PLL1 enable"]
pub fn pllon (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 24usize + n * 2usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 enable"]
pub fn set_pllon (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 24usize + n * 2usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "PLL1 clock ready flag"]
pub fn pllrdy (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 25usize + n * 2usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "PLL1 clock ready flag"]
pub fn set_pllrdy (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 25usize + n * 2usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "RCC AHB3 Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3enr (pub u32) ; impl Ahb3enr { # [doc = "MDMA Peripheral Clock Enable"]
pub const fn mdmaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "MDMA Peripheral Clock Enable"]
pub fn set_mdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2D Peripheral Clock Enable"]
pub const fn dma2den (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "DMA2D Peripheral Clock Enable"]
pub fn set_dma2den (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "JPGDEC Peripheral Clock Enable"]
pub const fn jpgdecen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "JPGDEC Peripheral Clock Enable"]
pub fn set_jpgdecen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FMC Peripheral Clocks Enable"]
pub const fn fmcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "FMC Peripheral Clocks Enable"]
pub fn set_fmcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "QUADSPI and QUADSPI Delay Clock Enable"]
pub const fn qspien (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "QUADSPI and QUADSPI Delay Clock Enable"]
pub fn set_qspien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SDMMC1 and SDMMC1 Delay Clock Enable"]
pub const fn sdmmc1en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 and SDMMC1 Delay Clock Enable"]
pub fn set_sdmmc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "OCTOSPI2 and OCTOSPI2 delay block enable"]
pub const fn octospi2en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI2 and OCTOSPI2 delay block enable"]
pub fn set_octospi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "OCTOSPI IO manager enable"]
pub const fn iomngren (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI IO manager enable"]
pub fn set_iomngren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "OTFDEC1 enable"]
pub const fn otfd1en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "OTFDEC1 enable"]
pub fn set_otfd1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "OTFDEC2 enable"]
pub const fn otfd2en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "OTFDEC2 enable"]
pub fn set_otfd2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "D1 DTCM1 block enable"]
pub const fn dtcm1en (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "D1 DTCM1 block enable"]
pub fn set_dtcm1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "D1 DTCM2 block enable"]
pub const fn dtcm2en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "D1 DTCM2 block enable"]
pub fn set_dtcm2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "D1 ITCM block enable"]
pub const fn itcm1en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "D1 ITCM block enable"]
pub fn set_itcm1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "AXISRAM block enable"]
pub const fn axisramen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "AXISRAM block enable"]
pub fn set_axisramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb3enr { fn default () -> Ahb3enr { Ahb3enr (0) } } # [doc = "RCC APB4 Peripheral Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb4rstr (pub u32) ; impl Apb4rstr { # [doc = "SYSCFG block reset"]
pub const fn syscfgrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYSCFG block reset"]
pub fn set_syscfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LPUART1 block reset"]
pub const fn lpuart1rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "LPUART1 block reset"]
pub fn set_lpuart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "SPI6 block reset"]
pub const fn spi6rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SPI6 block reset"]
pub fn set_spi6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "I2C4 block reset"]
pub const fn i2c4rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I2C4 block reset"]
pub fn set_i2c4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LPTIM2 block reset"]
pub const fn lptim2rst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 block reset"]
pub fn set_lptim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "LPTIM3 block reset"]
pub const fn lptim3rst (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "LPTIM3 block reset"]
pub fn set_lptim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "LPTIM4 block reset"]
pub const fn lptim4rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "LPTIM4 block reset"]
pub fn set_lptim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "LPTIM5 block reset"]
pub const fn lptim5rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "LPTIM5 block reset"]
pub fn set_lptim5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DAC2 (containing one converter) reset"]
pub const fn dac2rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DAC2 (containing one converter) reset"]
pub fn set_dac2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "COMP12 Blocks Reset"]
pub const fn comp12rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "COMP12 Blocks Reset"]
pub fn set_comp12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "VREF block reset"]
pub const fn vrefrst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "VREF block reset"]
pub fn set_vrefrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SAI4 block reset"]
pub const fn sai4rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI4 block reset"]
pub fn set_sai4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Digital temperature sensor block reset"]
pub const fn dtsrst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Digital temperature sensor block reset"]
pub fn set_dtsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Apb4rstr { fn default () -> Apb4rstr { Apb4rstr (0) } } # [doc = "RCC APB2 Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2lpenr (pub u32) ; impl Apb2lpenr { # [doc = "TIM1 peripheral clock enable during CSleep mode"]
pub const fn tim1lpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 peripheral clock enable during CSleep mode"]
pub fn set_tim1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 peripheral clock enable during CSleep mode"]
pub const fn tim8lpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 peripheral clock enable during CSleep mode"]
pub fn set_tim8lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 Peripheral Clocks Enable During CSleep Mode"]
pub const fn usart1lpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_usart1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 Peripheral Clocks Enable During CSleep Mode"]
pub const fn usart6lpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_usart6lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "SPI1 Peripheral Clocks Enable During CSleep Mode"]
pub const fn spi1lpen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_spi1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SPI4 Peripheral Clocks Enable During CSleep Mode"]
pub const fn spi4lpen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SPI4 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_spi4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "TIM15 peripheral clock enable during CSleep mode"]
pub const fn tim15lpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 peripheral clock enable during CSleep mode"]
pub fn set_tim15lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 peripheral clock enable during CSleep mode"]
pub const fn tim16lpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 peripheral clock enable during CSleep mode"]
pub fn set_tim16lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 peripheral clock enable during CSleep mode"]
pub const fn tim17lpen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 peripheral clock enable during CSleep mode"]
pub fn set_tim17lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SPI5 Peripheral Clocks Enable During CSleep Mode"]
pub const fn spi5lpen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SPI5 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_spi5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SAI1 Peripheral Clocks Enable During CSleep Mode"]
pub const fn sai1lpen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI1 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_sai1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "SAI2 Peripheral Clocks Enable During CSleep Mode"]
pub const fn sai2lpen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "SAI2 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_sai2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "SAI3 Peripheral Clocks Enable During CSleep Mode"]
pub const fn sai3lpen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SAI3 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_sai3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "DFSDM1 Peripheral Clocks Enable During CSleep Mode"]
pub const fn dfsdm1lpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "DFSDM1 Peripheral Clocks Enable During CSleep Mode"]
pub fn set_dfsdm1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "HRTIM peripheral clock enable during CSleep mode"]
pub const fn hrtimlpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "HRTIM peripheral clock enable during CSleep mode"]
pub fn set_hrtimlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Apb2lpenr { fn default () -> Apb2lpenr { Apb2lpenr (0) } } # [doc = "RCC APB1 Peripheral Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1lrstr (pub u32) ; impl Apb1lrstr { # [doc = "TIM block reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM block reset"]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM block reset"]
pub const fn tim4rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM block reset"]
pub const fn tim5rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM block reset"]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM block reset"]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM block reset"]
pub const fn tim12rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM block reset"]
pub const fn tim13rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim13rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM block reset"]
pub const fn tim14rst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_tim14rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "TIM block reset"]
pub const fn lptim1rst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "TIM block reset"]
pub fn set_lptim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "SPI2 block reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 block reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 block reset"]
pub const fn spi3rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 block reset"]
pub fn set_spi3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SPDIFRX block reset"]
pub const fn spdifrxrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SPDIFRX block reset"]
pub fn set_spdifrxrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "USART2 block reset"]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 block reset"]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 block reset"]
pub const fn usart3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 block reset"]
pub fn set_usart3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 block reset"]
pub const fn uart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 block reset"]
pub fn set_uart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 block reset"]
pub const fn uart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 block reset"]
pub fn set_uart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 block reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 block reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 block reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 block reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 block reset"]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 block reset"]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "I2C5 block reset"]
pub const fn i2c5rst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "I2C5 block reset"]
pub fn set_i2c5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "HDMI-CEC block reset"]
pub const fn cecrst (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "HDMI-CEC block reset"]
pub fn set_cecrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "DAC1 (containing two converters) reset"]
pub const fn dac1rst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC1 (containing two converters) reset"]
pub fn set_dac1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "UART7 block reset"]
pub const fn uart7rst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "UART7 block reset"]
pub fn set_uart7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "UART8 block reset"]
pub const fn uart8rst (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "UART8 block reset"]
pub fn set_uart8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1lrstr { fn default () -> Apb1lrstr { Apb1lrstr (0) } } # [doc = "RCC APB3 Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3lpenr (pub u32) ; impl Apb3lpenr { # [doc = "LTDC peripheral clock enable during CSleep mode"]
pub const fn ltdclpen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "LTDC peripheral clock enable during CSleep mode"]
pub fn set_ltdclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "DSI Peripheral Clock Enable During CSleep Mode"]
pub const fn dsilpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "DSI Peripheral Clock Enable During CSleep Mode"]
pub fn set_dsilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "WWDG1 Clock Enable During CSleep Mode"]
pub const fn wwdg1lpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "WWDG1 Clock Enable During CSleep Mode"]
pub fn set_wwdg1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Apb3lpenr { fn default () -> Apb3lpenr { Apb3lpenr (0) } } # [doc = "RCC APB3 Peripheral Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb3rstr (pub u32) ; impl Apb3rstr { # [doc = "LTDC block reset"]
pub const fn ltdcrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "LTDC block reset"]
pub fn set_ltdcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "DSI block reset"]
pub const fn dsirst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "DSI block reset"]
pub fn set_dsirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Apb3rstr { fn default () -> Apb3rstr { Apb3rstr (0) } } # [doc = "RCC AHB4 Peripheral Reset Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb4rstr (pub u32) ; impl Ahb4rstr { # [doc = "GPIO block reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "GPIO block reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "GPIO block reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "GPIO block reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "GPIO block reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "GPIO block reset"]
pub const fn gpiofrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpiofrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "GPIO block reset"]
pub const fn gpiogrst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpiogrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "GPIO block reset"]
pub const fn gpiohrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpiohrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "GPIO block reset"]
pub const fn gpioirst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpioirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "GPIO block reset"]
pub const fn gpiojrst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpiojrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "GPIO block reset"]
pub const fn gpiokrst (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "GPIO block reset"]
pub fn set_gpiokrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CRC block reset"]
pub const fn crcrst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "CRC block reset"]
pub fn set_crcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "BDMA2 block reset"]
pub const fn bdma2rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "BDMA2 block reset"]
pub fn set_bdma2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "BDMA block reset"]
pub const fn bdmarst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "BDMA block reset"]
pub fn set_bdmarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "ADC3 block reset"]
pub const fn adc3rst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "ADC3 block reset"]
pub fn set_adc3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "HSEM block reset"]
pub const fn hsemrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "HSEM block reset"]
pub fn set_hsemrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Ahb4rstr { fn default () -> Ahb4rstr { Ahb4rstr (0) } } # [doc = "RCC AHB3 Sleep Clock Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3lpenr (pub u32) ; impl Ahb3lpenr { # [doc = "MDMA Clock Enable During CSleep Mode"]
pub const fn mdmalpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "MDMA Clock Enable During CSleep Mode"]
pub fn set_mdmalpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2D Clock Enable During CSleep Mode"]
pub const fn dma2dlpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "DMA2D Clock Enable During CSleep Mode"]
pub fn set_dma2dlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "JPGDEC Clock Enable During CSleep Mode"]
pub const fn jpgdeclpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "JPGDEC Clock Enable During CSleep Mode"]
pub fn set_jpgdeclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FLASH Clock Enable During CSleep Mode"]
pub const fn flashlpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "FLASH Clock Enable During CSleep Mode"]
pub fn set_flashlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "FMC Peripheral Clocks Enable During CSleep Mode"]
pub const fn fmclpen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "FMC Peripheral Clocks Enable During CSleep Mode"]
pub fn set_fmclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "QUADSPI and QUADSPI Delay Clock Enable During CSleep Mode"]
pub const fn qspilpen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "QUADSPI and QUADSPI Delay Clock Enable During CSleep Mode"]
pub fn set_qspilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SDMMC1 and SDMMC1 Delay Clock Enable During CSleep Mode"]
pub const fn sdmmc1lpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 and SDMMC1 Delay Clock Enable During CSleep Mode"]
pub fn set_sdmmc1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "OCTOSPI2 and OCTOSPI2 delay block enable during CSleep Mode"]
pub const fn octospi2lpen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI2 and OCTOSPI2 delay block enable during CSleep Mode"]
pub fn set_octospi2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "OCTOSPI IO manager enable during CSleep Mode"]
pub const fn iomngrlpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "OCTOSPI IO manager enable during CSleep Mode"]
pub fn set_iomngrlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "OTFDEC1 enable during CSleep Mode"]
pub const fn otfd1lpen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "OTFDEC1 enable during CSleep Mode"]
pub fn set_otfd1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "OTFDEC2 enable during CSleep Mode"]
pub const fn otfd2lpen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "OTFDEC2 enable during CSleep Mode"]
pub fn set_otfd2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "D1DTCM1 Block Clock Enable During CSleep mode"]
pub const fn d1dtcm1lpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "D1DTCM1 Block Clock Enable During CSleep mode"]
pub fn set_d1dtcm1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "D1 DTCM2 Block Clock Enable During CSleep mode"]
pub const fn dtcm2lpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "D1 DTCM2 Block Clock Enable During CSleep mode"]
pub fn set_dtcm2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "D1ITCM Block Clock Enable During CSleep mode"]
pub const fn itcmlpen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "D1ITCM Block Clock Enable During CSleep mode"]
pub fn set_itcmlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "AXISRAM Block Clock Enable During CSleep mode"]
pub const fn axisramlpen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "AXISRAM Block Clock Enable During CSleep mode"]
pub fn set_axisramlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ahb3lpenr { fn default () -> Ahb3lpenr { Ahb3lpenr (0) } } # [doc = "RCC Domain 2 Clock Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D2cfgr (pub u32) ; impl D2cfgr { # [doc = "D2 domain APB1 prescaler"]
pub const fn d2ppre1 (& self) -> super :: vals :: Dppre { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Dppre (val as u8) } # [doc = "D2 domain APB1 prescaler"]
pub fn set_d2ppre1 (& mut self , val : super :: vals :: Dppre) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } # [doc = "D2 domain APB2 prescaler"]
pub const fn d2ppre2 (& self) -> super :: vals :: Dppre { let val = (self . 0 >> 8usize) & 0x07 ; super :: vals :: Dppre (val as u8) } # [doc = "D2 domain APB2 prescaler"]
pub fn set_d2ppre2 (& mut self , val : super :: vals :: Dppre) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val . 0 as u32) & 0x07) << 8usize) ; } } impl Default for D2cfgr { fn default () -> D2cfgr { D2cfgr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ckpersel (pub u8) ; impl Ckpersel { # [doc = "HSI selected as peripheral clock"]
pub const HSI : Self = Self (0) ; # [doc = "CSI selected as peripheral clock"]
pub const CSI : Self = Self (0x01) ; # [doc = "HSE selected as peripheral clock"]
pub const HSE : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spi45sel (pub u8) ; impl Spi45sel { # [doc = "APB clock selected as peripheral clock"]
pub const APB : Self = Self (0) ; # [doc = "pll2_q selected as peripheral clock"]
pub const PLL2_Q : Self = Self (0x01) ; # [doc = "pll3_q selected as peripheral clock"]
pub const PLL3_Q : Self = Self (0x02) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x03) ; # [doc = "csi_ker selected as peripheral clock"]
pub const CSI_KER : Self = Self (0x04) ; # [doc = "HSE selected as peripheral clock"]
pub const HSE : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usbsel (pub u8) ; impl Usbsel { # [doc = "Disable the kernel clock"]
pub const DISABLE : Self = Self (0) ; # [doc = "pll1_q selected as peripheral clock"]
pub const PLL1_Q : Self = Self (0x01) ; # [doc = "pll3_q selected as peripheral clock"]
pub const PLL3_Q : Self = Self (0x02) ; # [doc = "HSI48 selected as peripheral clock"]
pub const HSI48 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Saiasel (pub u8) ; impl Saiasel { # [doc = "pll1_q selected as peripheral clock"]
pub const PLL1_Q : Self = Self (0) ; # [doc = "pll2_p selected as peripheral clock"]
pub const PLL2_P : Self = Self (0x01) ; # [doc = "pll3_p selected as peripheral clock"]
pub const PLL3_P : Self = Self (0x02) ; # [doc = "i2s_ckin selected as peripheral clock"]
pub const I2S_CKIN : Self = Self (0x03) ; # [doc = "PER selected as peripheral clock"]
pub const PER : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hsidiv (pub u8) ; impl Hsidiv { # [doc = "No division"]
pub const DIV1 : Self = Self (0) ; # [doc = "Division by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "Division by 4"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "Division by 8"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swsr (pub u8) ; impl Swsr { # [doc = "HSI oscillator used as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "CSI oscillator used as system clock"]
pub const CSI : Self = Self (0x01) ; # [doc = "HSE oscillator used as system clock"]
pub const HSE : Self = Self (0x02) ; # [doc = "PLL1 used as system clock"]
pub const PLL1 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllvcosel (pub u8) ; impl Pllvcosel { # [doc = "VCO frequency range 192 to 836 MHz"]
pub const WIDEVCO : Self = Self (0) ; # [doc = "VCO frequency range 150 to 420 MHz"]
pub const MEDIUMVCO : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rngsel (pub u8) ; impl Rngsel { # [doc = "HSI48 selected as peripheral clock"]
pub const HSI48 : Self = Self (0) ; # [doc = "pll1_q selected as peripheral clock"]
pub const PLL1_Q : Self = Self (0x01) ; # [doc = "LSE selected as peripheral clock"]
pub const LSE : Self = Self (0x02) ; # [doc = "LSI selected as peripheral clock"]
pub const LSI : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c4sel (pub u8) ; impl I2c4sel { # [doc = "rcc_pclk4 selected as peripheral clock"]
pub const RCC_PCLK4 : Self = Self (0) ; # [doc = "pll3_r selected as peripheral clock"]
pub const PLL3_R : Self = Self (0x01) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x02) ; # [doc = "csi_ker selected as peripheral clock"]
pub const CSI_KER : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sw (pub u8) ; impl Sw { # [doc = "HSI selected as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "CSI selected as system clock"]
pub const CSI : Self = Self (0x01) ; # [doc = "HSE selected as system clock"]
pub const HSE : Self = Self (0x02) ; # [doc = "PLL1 selected as system clock"]
pub const PLL1 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsedrv (pub u8) ; impl Lsedrv { # [doc = "Lowest LSE oscillator driving capability"]
pub const LOWEST : Self = Self (0) ; # [doc = "Medium low LSE oscillator driving capability"]
pub const MEDIUMLOW : Self = Self (0x01) ; # [doc = "Medium high LSE oscillator driving capability"]
pub const MEDIUMHIGH : Self = Self (0x02) ; # [doc = "Highest LSE oscillator driving capability"]
pub const HIGHEST : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spdifrxsel (pub u8) ; impl Spdifrxsel { # [doc = "pll1_q selected as peripheral clock"]
pub const PLL1_Q : Self = Self (0) ; # [doc = "pll2_r selected as peripheral clock"]
pub const PLL2_R : Self = Self (0x01) ; # [doc = "pll3_r selected as peripheral clock"]
pub const PLL3_R : Self = Self (0x02) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usart16910sel (pub u8) ; impl Usart16910sel { # [doc = "rcc_pclk2 selected as peripheral clock"]
pub const RCC_PCLK2 : Self = Self (0) ; # [doc = "pll2_q selected as peripheral clock"]
pub const PLL2_Q : Self = Self (0x01) ; # [doc = "pll3_q selected as peripheral clock"]
pub const PLL3_Q : Self = Self (0x02) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x03) ; # [doc = "csi_ker selected as peripheral clock"]
pub const CSI_KER : Self = Self (0x04) ; # [doc = "LSE selected as peripheral clock"]
pub const LSE : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2c1235sel (pub u8) ; impl I2c1235sel { # [doc = "rcc_pclk1 selected as peripheral clock"]
pub const RCC_PCLK1 : Self = Self (0) ; # [doc = "pll3_r selected as peripheral clock"]
pub const PLL3_R : Self = Self (0x01) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x02) ; # [doc = "csi_ker selected as peripheral clock"]
pub const CSI_KER : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Stopwuck (pub u8) ; impl Stopwuck { # [doc = "HSI selected as wake up clock from system Stop"]
pub const HSI : Self = Self (0) ; # [doc = "CSI selected as wake up clock from system Stop"]
pub const CSI : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usart234578sel (pub u8) ; impl Usart234578sel { # [doc = "rcc_pclk1 selected as peripheral clock"]
pub const RCC_PCLK1 : Self = Self (0) ; # [doc = "pll2_q selected as peripheral clock"]
pub const PLL2_Q : Self = Self (0x01) ; # [doc = "pll3_q selected as peripheral clock"]
pub const PLL3_Q : Self = Self (0x02) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x03) ; # [doc = "csi_ker selected as peripheral clock"]
pub const CSI_KER : Self = Self (0x04) ; # [doc = "LSE selected as peripheral clock"]
pub const LSE : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsrc (pub u8) ; impl Pllsrc { # [doc = "HSI selected as PLL clock"]
pub const HSI : Self = Self (0) ; # [doc = "CSI selected as PLL clock"]
pub const CSI : Self = Self (0x01) ; # [doc = "HSE selected as PLL clock"]
pub const HSE : Self = Self (0x02) ; # [doc = "No clock sent to DIVMx dividers and PLLs"]
pub const NONE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hrtimsel (pub u8) ; impl Hrtimsel { # [doc = "The HRTIM prescaler clock source is the same as other timers (rcc_timy_ker_ck)"]
pub const TIMY_KER : Self = Self (0) ; # [doc = "The HRTIM prescaler clock source is the CPU clock (c_ck)"]
pub const C_CK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sdmmcsel (pub u8) ; impl Sdmmcsel { # [doc = "pll1_q selected as peripheral clock"]
pub const PLL1_Q : Self = Self (0) ; # [doc = "pll2_r selected as peripheral clock"]
pub const PLL2_R : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adcsel (pub u8) ; impl Adcsel { # [doc = "pll2_p selected as peripheral clock"]
pub const PLL2_P : Self = Self (0) ; # [doc = "pll3_r selected as peripheral clock"]
pub const PLL3_R : Self = Self (0x01) ; # [doc = "PER selected as peripheral clock"]
pub const PER : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Saisel (pub u8) ; impl Saisel { # [doc = "pll1_q selected as peripheral clock"]
pub const PLL1_Q : Self = Self (0) ; # [doc = "pll2_p selected as peripheral clock"]
pub const PLL2_P : Self = Self (0x01) ; # [doc = "pll3_p selected as peripheral clock"]
pub const PLL3_P : Self = Self (0x02) ; # [doc = "I2S_CKIN selected as peripheral clock"]
pub const I2S_CKIN : Self = Self (0x03) ; # [doc = "PER selected as peripheral clock"]
pub const PER : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lpuartsel (pub u8) ; impl Lpuartsel { # [doc = "rcc_pclk_d3 selected as peripheral clock"]
pub const RCC_PCLK_D3 : Self = Self (0) ; # [doc = "pll2_q selected as peripheral clock"]
pub const PLL2_Q : Self = Self (0x01) ; # [doc = "pll3_q selected as peripheral clock"]
pub const PLL3_Q : Self = Self (0x02) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x03) ; # [doc = "csi_ker selected as peripheral clock"]
pub const CSI_KER : Self = Self (0x04) ; # [doc = "LSE selected as peripheral clock"]
pub const LSE : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco1 (pub u8) ; impl Mco1 { # [doc = "HSI selected for micro-controller clock output"]
pub const HSI : Self = Self (0) ; # [doc = "LSE selected for micro-controller clock output"]
pub const LSE : Self = Self (0x01) ; # [doc = "HSE selected for micro-controller clock output"]
pub const HSE : Self = Self (0x02) ; # [doc = "pll1_q selected for micro-controller clock output"]
pub const PLL1_Q : Self = Self (0x03) ; # [doc = "HSI48 selected for micro-controller clock output"]
pub const HSI48 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swpsel (pub u8) ; impl Swpsel { # [doc = "pclk selected as peripheral clock"]
pub const PCLK : Self = Self (0) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpre (pub u8) ; impl Hpre { # [doc = "sys_ck not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "sys_ck divided by 2"]
pub const DIV2 : Self = Self (0x08) ; # [doc = "sys_ck divided by 4"]
pub const DIV4 : Self = Self (0x09) ; # [doc = "sys_ck divided by 8"]
pub const DIV8 : Self = Self (0x0a) ; # [doc = "sys_ck divided by 16"]
pub const DIV16 : Self = Self (0x0b) ; # [doc = "sys_ck divided by 64"]
pub const DIV64 : Self = Self (0x0c) ; # [doc = "sys_ck divided by 128"]
pub const DIV128 : Self = Self (0x0d) ; # [doc = "sys_ck divided by 256"]
pub const DIV256 : Self = Self (0x0e) ; # [doc = "sys_ck divided by 512"]
pub const DIV512 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco2 (pub u8) ; impl Mco2 { # [doc = "System clock selected for micro-controller clock output"]
pub const SYSCLK : Self = Self (0) ; # [doc = "pll2_p selected for micro-controller clock output"]
pub const PLL2_P : Self = Self (0x01) ; # [doc = "HSE selected for micro-controller clock output"]
pub const HSE : Self = Self (0x02) ; # [doc = "pll1_p selected for micro-controller clock output"]
pub const PLL1_P : Self = Self (0x03) ; # [doc = "CSI selected for micro-controller clock output"]
pub const CSI : Self = Self (0x04) ; # [doc = "LSI selected for micro-controller clock output"]
pub const LSI : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lptim1sel (pub u8) ; impl Lptim1sel { # [doc = "rcc_pclk1 selected as peripheral clock"]
pub const RCC_PCLK1 : Self = Self (0) ; # [doc = "pll2_p selected as peripheral clock"]
pub const PLL2_P : Self = Self (0x01) ; # [doc = "pll3_r selected as peripheral clock"]
pub const PLL3_R : Self = Self (0x02) ; # [doc = "LSE selected as peripheral clock"]
pub const LSE : Self = Self (0x03) ; # [doc = "LSI selected as peripheral clock"]
pub const LSI : Self = Self (0x04) ; # [doc = "PER selected as peripheral clock"]
pub const PER : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Divp (pub u8) ; impl Divp { # [doc = "pll_p_ck = vco_ck"]
pub const DIV1 : Self = Self (0) ; # [doc = "pll_p_ck = vco_ck / 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "pll_p_ck = vco_ck / 4"]
pub const DIV4 : Self = Self (0x03) ; # [doc = "pll_p_ck = vco_ck / 6"]
pub const DIV6 : Self = Self (0x05) ; # [doc = "pll_p_ck = vco_ck / 8"]
pub const DIV8 : Self = Self (0x07) ; # [doc = "pll_p_ck = vco_ck / 10"]
pub const DIV10 : Self = Self (0x09) ; # [doc = "pll_p_ck = vco_ck / 12"]
pub const DIV12 : Self = Self (0x0b) ; # [doc = "pll_p_ck = vco_ck / 14"]
pub const DIV14 : Self = Self (0x0d) ; # [doc = "pll_p_ck = vco_ck / 16"]
pub const DIV16 : Self = Self (0x0f) ; # [doc = "pll_p_ck = vco_ck / 18"]
pub const DIV18 : Self = Self (0x11) ; # [doc = "pll_p_ck = vco_ck / 20"]
pub const DIV20 : Self = Self (0x13) ; # [doc = "pll_p_ck = vco_ck / 22"]
pub const DIV22 : Self = Self (0x15) ; # [doc = "pll_p_ck = vco_ck / 24"]
pub const DIV24 : Self = Self (0x17) ; # [doc = "pll_p_ck = vco_ck / 26"]
pub const DIV26 : Self = Self (0x19) ; # [doc = "pll_p_ck = vco_ck / 28"]
pub const DIV28 : Self = Self (0x1b) ; # [doc = "pll_p_ck = vco_ck / 30"]
pub const DIV30 : Self = Self (0x1d) ; # [doc = "pll_p_ck = vco_ck / 32"]
pub const DIV32 : Self = Self (0x1f) ; # [doc = "pll_p_ck = vco_ck / 34"]
pub const DIV34 : Self = Self (0x21) ; # [doc = "pll_p_ck = vco_ck / 36"]
pub const DIV36 : Self = Self (0x23) ; # [doc = "pll_p_ck = vco_ck / 38"]
pub const DIV38 : Self = Self (0x25) ; # [doc = "pll_p_ck = vco_ck / 40"]
pub const DIV40 : Self = Self (0x27) ; # [doc = "pll_p_ck = vco_ck / 42"]
pub const DIV42 : Self = Self (0x29) ; # [doc = "pll_p_ck = vco_ck / 44"]
pub const DIV44 : Self = Self (0x2b) ; # [doc = "pll_p_ck = vco_ck / 46"]
pub const DIV46 : Self = Self (0x2d) ; # [doc = "pll_p_ck = vco_ck / 48"]
pub const DIV48 : Self = Self (0x2f) ; # [doc = "pll_p_ck = vco_ck / 50"]
pub const DIV50 : Self = Self (0x31) ; # [doc = "pll_p_ck = vco_ck / 52"]
pub const DIV52 : Self = Self (0x33) ; # [doc = "pll_p_ck = vco_ck / 54"]
pub const DIV54 : Self = Self (0x35) ; # [doc = "pll_p_ck = vco_ck / 56"]
pub const DIV56 : Self = Self (0x37) ; # [doc = "pll_p_ck = vco_ck / 58"]
pub const DIV58 : Self = Self (0x39) ; # [doc = "pll_p_ck = vco_ck / 60"]
pub const DIV60 : Self = Self (0x3b) ; # [doc = "pll_p_ck = vco_ck / 62"]
pub const DIV62 : Self = Self (0x3d) ; # [doc = "pll_p_ck = vco_ck / 64"]
pub const DIV64 : Self = Self (0x3f) ; # [doc = "pll_p_ck = vco_ck / 66"]
pub const DIV66 : Self = Self (0x41) ; # [doc = "pll_p_ck = vco_ck / 68"]
pub const DIV68 : Self = Self (0x43) ; # [doc = "pll_p_ck = vco_ck / 70"]
pub const DIV70 : Self = Self (0x45) ; # [doc = "pll_p_ck = vco_ck / 72"]
pub const DIV72 : Self = Self (0x47) ; # [doc = "pll_p_ck = vco_ck / 74"]
pub const DIV74 : Self = Self (0x49) ; # [doc = "pll_p_ck = vco_ck / 76"]
pub const DIV76 : Self = Self (0x4b) ; # [doc = "pll_p_ck = vco_ck / 78"]
pub const DIV78 : Self = Self (0x4d) ; # [doc = "pll_p_ck = vco_ck / 80"]
pub const DIV80 : Self = Self (0x4f) ; # [doc = "pll_p_ck = vco_ck / 82"]
pub const DIV82 : Self = Self (0x51) ; # [doc = "pll_p_ck = vco_ck / 84"]
pub const DIV84 : Self = Self (0x53) ; # [doc = "pll_p_ck = vco_ck / 86"]
pub const DIV86 : Self = Self (0x55) ; # [doc = "pll_p_ck = vco_ck / 88"]
pub const DIV88 : Self = Self (0x57) ; # [doc = "pll_p_ck = vco_ck / 90"]
pub const DIV90 : Self = Self (0x59) ; # [doc = "pll_p_ck = vco_ck / 92"]
pub const DIV92 : Self = Self (0x5b) ; # [doc = "pll_p_ck = vco_ck / 94"]
pub const DIV94 : Self = Self (0x5d) ; # [doc = "pll_p_ck = vco_ck / 96"]
pub const DIV96 : Self = Self (0x5f) ; # [doc = "pll_p_ck = vco_ck / 98"]
pub const DIV98 : Self = Self (0x61) ; # [doc = "pll_p_ck = vco_ck / 100"]
pub const DIV100 : Self = Self (0x63) ; # [doc = "pll_p_ck = vco_ck / 102"]
pub const DIV102 : Self = Self (0x65) ; # [doc = "pll_p_ck = vco_ck / 104"]
pub const DIV104 : Self = Self (0x67) ; # [doc = "pll_p_ck = vco_ck / 106"]
pub const DIV106 : Self = Self (0x69) ; # [doc = "pll_p_ck = vco_ck / 108"]
pub const DIV108 : Self = Self (0x6b) ; # [doc = "pll_p_ck = vco_ck / 110"]
pub const DIV110 : Self = Self (0x6d) ; # [doc = "pll_p_ck = vco_ck / 112"]
pub const DIV112 : Self = Self (0x6f) ; # [doc = "pll_p_ck = vco_ck / 114"]
pub const DIV114 : Self = Self (0x71) ; # [doc = "pll_p_ck = vco_ck / 116"]
pub const DIV116 : Self = Self (0x73) ; # [doc = "pll_p_ck = vco_ck / 118"]
pub const DIV118 : Self = Self (0x75) ; # [doc = "pll_p_ck = vco_ck / 120"]
pub const DIV120 : Self = Self (0x77) ; # [doc = "pll_p_ck = vco_ck / 122"]
pub const DIV122 : Self = Self (0x79) ; # [doc = "pll_p_ck = vco_ck / 124"]
pub const DIV124 : Self = Self (0x7b) ; # [doc = "pll_p_ck = vco_ck / 126"]
pub const DIV126 : Self = Self (0x7d) ; # [doc = "pll_p_ck = vco_ck / 128"]
pub const DIV128 : Self = Self (0x7f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Timpre (pub u8) ; impl Timpre { # [doc = "Timer kernel clock equal to 2x pclk by default"]
pub const DEFAULTX2 : Self = Self (0) ; # [doc = "Timer kernel clock equal to 4x pclk by default"]
pub const DEFAULTX4 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllrge (pub u8) ; impl Pllrge { # [doc = "Frequency is between 1 and 2 MHz"]
pub const RANGE1 : Self = Self (0) ; # [doc = "Frequency is between 2 and 4 MHz"]
pub const RANGE2 : Self = Self (0x01) ; # [doc = "Frequency is between 4 and 8 MHz"]
pub const RANGE4 : Self = Self (0x02) ; # [doc = "Frequency is between 8 and 16 MHz"]
pub const RANGE8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dppre (pub u8) ; impl Dppre { # [doc = "rcc_hclk not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "rcc_hclk divided by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "rcc_hclk divided by 4"]
pub const DIV4 : Self = Self (0x05) ; # [doc = "rcc_hclk divided by 8"]
pub const DIV8 : Self = Self (0x06) ; # [doc = "rcc_hclk divided by 16"]
pub const DIV16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spi6sel (pub u8) ; impl Spi6sel { # [doc = "rcc_pclk4 selected as peripheral clock"]
pub const RCC_PCLK4 : Self = Self (0) ; # [doc = "pll2_q selected as peripheral clock"]
pub const PLL2_Q : Self = Self (0x01) ; # [doc = "pll3_q selected as peripheral clock"]
pub const PLL3_Q : Self = Self (0x02) ; # [doc = "hsi_ker selected as peripheral clock"]
pub const HSI_KER : Self = Self (0x03) ; # [doc = "csi_ker selected as peripheral clock"]
pub const CSI_KER : Self = Self (0x04) ; # [doc = "HSE selected as peripheral clock"]
pub const HSE : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fdcansel (pub u8) ; impl Fdcansel { # [doc = "HSE selected as peripheral clock"]
pub const HSE : Self = Self (0) ; # [doc = "pll1_q selected as peripheral clock"]
pub const PLL1_Q : Self = Self (0x01) ; # [doc = "pll2_q selected as peripheral clock"]
pub const PLL2_Q : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcsel (pub u8) ; impl Rtcsel { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "LSE oscillator clock used as RTC clock"]
pub const LSE : Self = Self (0x01) ; # [doc = "LSI oscillator clock used as RTC clock"]
pub const LSI : Self = Self (0x02) ; # [doc = "HSE oscillator clock divided by a prescaler used as RTC clock"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fmcsel (pub u8) ; impl Fmcsel { # [doc = "rcc_hclk3 selected as peripheral clock"]
pub const RCC_HCLK3 : Self = Self (0) ; # [doc = "pll1_q selected as peripheral clock"]
pub const PLL1_Q : Self = Self (0x01) ; # [doc = "pll2_r selected as peripheral clock"]
pub const PLL2_R : Self = Self (0x02) ; # [doc = "PER selected as peripheral clock"]
pub const PER : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dfsdmsel (pub u8) ; impl Dfsdmsel { # [doc = "rcc_pclk2 selected as peripheral clock"]
pub const RCC_PCLK2 : Self = Self (0) ; # [doc = "System clock selected as peripheral clock"]
pub const SYS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cecsel (pub u8) ; impl Cecsel { # [doc = "LSE selected as peripheral clock"]
pub const LSE : Self = Self (0) ; # [doc = "LSI selected as peripheral clock"]
pub const LSI : Self = Self (0x01) ; # [doc = "csi_ker selected as peripheral clock"]
pub const CSI_KER : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lptim2sel (pub u8) ; impl Lptim2sel { # [doc = "rcc_pclk4 selected as peripheral clock"]
pub const RCC_PCLK4 : Self = Self (0) ; # [doc = "pll2_p selected as peripheral clock"]
pub const PLL2_P : Self = Self (0x01) ; # [doc = "pll3_r selected as peripheral clock"]
pub const PLL3_R : Self = Self (0x02) ; # [doc = "LSE selected as peripheral clock"]
pub const LSE : Self = Self (0x03) ; # [doc = "LSI selected as peripheral clock"]
pub const LSI : Self = Self (0x04) ; # [doc = "PER selected as peripheral clock"]
pub const PER : Self = Self (0x05) ; } }