

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "Clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Internal clock sources calibration register"]
pub fn icscr (self) -> crate :: common :: Reg < regs :: Icscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Clock configuration register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "PLL configuration register"]
pub fn pllcfgr (self) -> crate :: common :: Reg < regs :: Pllcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Clock interrupt enable register"]
pub fn cier (self) -> crate :: common :: Reg < regs :: Cier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Clock interrupt flag register"]
pub fn cifr (self) -> crate :: common :: Reg < regs :: Cifr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Clock interrupt clear register"]
pub fn cicr (self) -> crate :: common :: Reg < regs :: Cicr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "AHB1 peripheral reset register"]
pub fn ahb1rstr (self) -> crate :: common :: Reg < regs :: Ahb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "AHB2 peripheral reset register"]
pub fn ahb2rstr (self) -> crate :: common :: Reg < regs :: Ahb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "AHB3 peripheral reset register"]
pub fn ahb3rstr (self) -> crate :: common :: Reg < regs :: Ahb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "APB1 peripheral reset register 1"]
pub fn apb1rstr1 (self) -> crate :: common :: Reg < regs :: Apb1rstr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "APB1 peripheral reset register 2"]
pub fn apb1rstr2 (self) -> crate :: common :: Reg < regs :: Apb1rstr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "APB2 peripheral reset register"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "AHB1 peripheral clock enable register"]
pub fn ahb1enr (self) -> crate :: common :: Reg < regs :: Ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "AHB2 peripheral clock enable register"]
pub fn ahb2enr (self) -> crate :: common :: Reg < regs :: Ahb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "AHB3 peripheral clock enable register"]
pub fn ahb3enr (self) -> crate :: common :: Reg < regs :: Ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "APB1ENR1"]
pub fn apb1enr1 (self) -> crate :: common :: Reg < regs :: Apb1enr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "APB1 peripheral clock enable register 2"]
pub fn apb1enr2 (self) -> crate :: common :: Reg < regs :: Apb1enr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (92usize)) } } # [doc = "APB2ENR"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "AHB1 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb1smenr (self) -> crate :: common :: Reg < regs :: Ahb1smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (104usize)) } } # [doc = "AHB2 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb2smenr (self) -> crate :: common :: Reg < regs :: Ahb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (108usize)) } } # [doc = "AHB3 peripheral clocks enable in Sleep and Stop modes register"]
pub fn ahb3smenr (self) -> crate :: common :: Reg < regs :: Ahb3smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } # [doc = "APB1SMENR1"]
pub fn apb1smenr1 (self) -> crate :: common :: Reg < regs :: Apb1smenr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (120usize)) } } # [doc = "APB1 peripheral clocks enable in Sleep and Stop modes register 2"]
pub fn apb1smenr2 (self) -> crate :: common :: Reg < regs :: Apb1smenr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (124usize)) } } # [doc = "APB2SMENR"]
pub fn apb2smenr (self) -> crate :: common :: Reg < regs :: Apb2smenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "CCIPR"]
pub fn ccipr (self) -> crate :: common :: Reg < regs :: Ccipr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "BDCR"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } # [doc = "CSR"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (148usize)) } } # [doc = "Clock recovery RC register"]
pub fn crrcr (self) -> crate :: common :: Reg < regs :: Crrcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (152usize)) } } # [doc = "Peripherals independent clock configuration register"]
pub fn ccipr2 (self) -> crate :: common :: Reg < regs :: Ccipr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (156usize)) } } } pub mod regs { # [doc = "BDCR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "LSE oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "LSE oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "LSE oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "SE oscillator drive capability"]
pub const fn lsedrv (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x03 ; val as u8 } # [doc = "SE oscillator drive capability"]
pub fn set_lsedrv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val as u32) & 0x03) << 3usize) ; } # [doc = "LSECSSON"]
pub const fn lsecsson (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LSECSSON"]
pub fn set_lsecsson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LSECSSD"]
pub const fn lsecssd (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LSECSSD"]
pub fn set_lsecssd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "RTC domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "RTC domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Low speed clock output enable"]
pub const fn lscoen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Low speed clock output enable"]
pub fn set_lscoen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Low speed clock output selection"]
pub const fn lscosel (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Low speed clock output selection"]
pub fn set_lscosel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "Clock interrupt flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cifr (pub u32) ; impl Cifr { # [doc = "LSI ready interrupt flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI ready interrupt flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL ready interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Clock security system interrupt flag"]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt flag"]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Clock security system interrupt flag"]
pub const fn lsecssf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Clock security system interrupt flag"]
pub fn set_lsecssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI48 ready interrupt flag"]
pub const fn hsi48rdyf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt flag"]
pub fn set_hsi48rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Cifr { fn default () -> Cifr { Cifr (0) } } # [doc = "APB2ENR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "SYSCFG clock enable"]
pub const fn syscfgen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYSCFG clock enable"]
pub fn set_syscfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM1 timer clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 timer clock enable"]
pub const fn tim8en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 timer clock enable"]
pub fn set_tim8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI 4 clock enable"]
pub const fn spi4en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI 4 clock enable"]
pub fn set_spi4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "TIM15 timer clock enable"]
pub const fn tim15en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 timer clock enable"]
pub fn set_tim15en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 timer clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Timer 20 clock enable"]
pub const fn tim20en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Timer 20 clock enable"]
pub fn set_tim20en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SAI1 clock enable"]
pub const fn sai1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI1 clock enable"]
pub fn set_sai1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "HRTIMER clock enable"]
pub const fn hrtim1en (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "HRTIMER clock enable"]
pub fn set_hrtim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "APB1 peripheral clocks enable in Sleep and Stop modes register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr2 (pub u32) ; impl Apb1smenr2 { # [doc = "Low power UART 1 clocks enable during Sleep and Stop modes"]
pub const fn lpuart1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low power UART 1 clocks enable during Sleep and Stop modes"]
pub fn set_lpuart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "I2C4 clocks enable during Sleep and Stop modes"]
pub const fn i2c4smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "I2C4 clocks enable during Sleep and Stop modes"]
pub fn set_i2c4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "UCPD1 clocks enable during Sleep and Stop modes"]
pub const fn ucpd1smen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "UCPD1 clocks enable during Sleep and Stop modes"]
pub fn set_ucpd1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Apb1smenr2 { fn default () -> Apb1smenr2 { Apb1smenr2 (0) } } # [doc = "APB1 peripheral reset register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr1 (pub u32) ; impl Apb1rstr1 { # [doc = "TIM2 timer reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 timer reset"]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 timer reset"]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM3 timer reset"]
pub const fn tim4rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM3 timer reset"]
pub fn set_tim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 timer reset"]
pub const fn tim5rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 timer reset"]
pub fn set_tim5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 timer reset"]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 timer reset"]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 timer reset"]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 timer reset"]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Clock recovery system reset"]
pub const fn crsrst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Clock recovery system reset"]
pub fn set_crsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "SPI2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 reset"]
pub const fn spi3rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 reset"]
pub fn set_spi3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART2 reset"]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 reset"]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 reset"]
pub const fn usart3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 reset"]
pub fn set_usart3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 reset"]
pub const fn uart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 reset"]
pub fn set_uart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 reset"]
pub const fn uart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 reset"]
pub fn set_uart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USBD reset"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USBD reset"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "FDCAN reset"]
pub const fn fdcanrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "FDCAN reset"]
pub fn set_fdcanrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Power interface reset"]
pub const fn pwrrst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface reset"]
pub fn set_pwrrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "I2C3 interface reset"]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "I2C3 interface reset"]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low Power Timer 1 reset"]
pub const fn lptim1rst (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low Power Timer 1 reset"]
pub fn set_lptim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1rstr1 { fn default () -> Apb1rstr1 { Apb1rstr1 (0) } } # [doc = "PLL configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllcfgr (pub u32) ; impl Pllcfgr { # [doc = "Main PLL, PLLSAI1 and PLLSAI2 entry clock source"]
pub const fn pllsrc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Main PLL, PLLSAI1 and PLLSAI2 entry clock source"]
pub fn set_pllsrc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Division factor for the main PLL and audio PLL (PLLSAI1 and PLLSAI2) input clock"]
pub const fn pllm (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "Division factor for the main PLL and audio PLL (PLLSAI1 and PLLSAI2) input clock"]
pub fn set_pllm (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "Main PLL multiplication factor for VCO"]
pub const fn plln (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x7f ; val as u8 } # [doc = "Main PLL multiplication factor for VCO"]
pub fn set_plln (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 8usize)) | (((val as u32) & 0x7f) << 8usize) ; } # [doc = "Main PLL PLLSAI3CLK output enable"]
pub const fn pllpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Main PLL PLLSAI3CLK output enable"]
pub fn set_pllpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Main PLL division factor for PLLSAI3CLK (SAI1 and SAI2 clock)"]
pub const fn pllp (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Main PLL division factor for PLLSAI3CLK (SAI1 and SAI2 clock)"]
pub fn set_pllp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Main PLL PLLUSB1CLK output enable"]
pub const fn pllqen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Main PLL PLLUSB1CLK output enable"]
pub fn set_pllqen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Main PLL division factor for PLLUSB1CLK(48 MHz clock)"]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x03 ; val as u8 } # [doc = "Main PLL division factor for PLLUSB1CLK(48 MHz clock)"]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 21usize)) | (((val as u32) & 0x03) << 21usize) ; } # [doc = "Main PLL PLLCLK output enable"]
pub const fn pllren (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Main PLL PLLCLK output enable"]
pub fn set_pllren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Main PLL division factor for PLLCLK (system clock)"]
pub const fn pllr (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x03 ; val as u8 } # [doc = "Main PLL division factor for PLLCLK (system clock)"]
pub fn set_pllr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 25usize)) | (((val as u32) & 0x03) << 25usize) ; } # [doc = "Main PLL division factor for PLLSAI2CLK"]
pub const fn pllpdiv (& self) -> u8 { let val = (self . 0 >> 27usize) & 0x1f ; val as u8 } # [doc = "Main PLL division factor for PLLSAI2CLK"]
pub fn set_pllpdiv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 27usize)) | (((val as u32) & 0x1f) << 27usize) ; } } impl Default for Pllcfgr { fn default () -> Pllcfgr { Pllcfgr (0) } } # [doc = "AHB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1rstr (pub u32) ; impl Ahb1rstr { # [doc = "DMA1 reset"]
pub const fn dma1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 reset"]
pub fn set_dma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 reset"]
pub const fn dma2rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 reset"]
pub fn set_dma2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMAMUX1RST"]
pub const fn dmamux1rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMAMUX1RST"]
pub fn set_dmamux1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CORDIC reset"]
pub const fn cordicrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CORDIC reset"]
pub fn set_cordicrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "FMAC reset"]
pub const fn fmacrst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "FMAC reset"]
pub fn set_fmacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Flash memory interface reset"]
pub const fn flashrst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Flash memory interface reset"]
pub fn set_flashrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CRC reset"]
pub const fn crcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC reset"]
pub fn set_crcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Ahb1rstr { fn default () -> Ahb1rstr { Ahb1rstr (0) } } # [doc = "AHB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3enr (pub u32) ; impl Ahb3enr { # [doc = "Flexible memory controller clock enable"]
pub const fn fmcen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible memory controller clock enable"]
pub fn set_fmcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "QUADSPI memory interface clock enable"]
pub const fn qspien (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "QUADSPI memory interface clock enable"]
pub fn set_qspien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Ahb3enr { fn default () -> Ahb3enr { Ahb3enr (0) } } # [doc = "AHB1 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1smenr (pub u32) ; impl Ahb1smenr { # [doc = "DMA1 clocks enable during Sleep and Stop modes"]
pub const fn dma1smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 clocks enable during Sleep and Stop modes"]
pub fn set_dma1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 clocks enable during Sleep and Stop modes"]
pub const fn dma2smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 clocks enable during Sleep and Stop modes"]
pub fn set_dma2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMAMUX clock enable during Sleep and Stop modes"]
pub const fn dmamux1smen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMAMUX clock enable during Sleep and Stop modes"]
pub fn set_dmamux1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CORDIC clock enable during sleep mode"]
pub const fn cordicsmen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CORDIC clock enable during sleep mode"]
pub fn set_cordicsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "FMACSM clock enable"]
pub const fn fmacsmen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "FMACSM clock enable"]
pub fn set_fmacsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Flash memory interface clocks enable during Sleep and Stop modes"]
pub const fn flashsmen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Flash memory interface clocks enable during Sleep and Stop modes"]
pub fn set_flashsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "SRAM1 interface clocks enable during Sleep and Stop modes"]
pub const fn sram1smen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "SRAM1 interface clocks enable during Sleep and Stop modes"]
pub fn set_sram1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CRCSMEN"]
pub const fn crcsmen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRCSMEN"]
pub fn set_crcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Ahb1smenr { fn default () -> Ahb1smenr { Ahb1smenr (0) } } # [doc = "APB1 peripheral clock enable register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr2 (pub u32) ; impl Apb1enr2 { # [doc = "Low power UART 1 clock enable"]
pub const fn lpuart1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low power UART 1 clock enable"]
pub fn set_lpuart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "I2C4 clock enable"]
pub const fn i2c4en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "I2C4 clock enable"]
pub fn set_i2c4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "UCPD1 clock enable"]
pub const fn ucpd1en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "UCPD1 clock enable"]
pub fn set_ucpd1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Apb1enr2 { fn default () -> Apb1enr2 { Apb1enr2 (0) } } # [doc = "AHB2 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2smenr (pub u32) ; impl Ahb2smenr { # [doc = "IO port A clocks enable during Sleep and Stop modes"]
pub const fn gpioasmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clocks enable during Sleep and Stop modes"]
pub fn set_gpioasmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clocks enable during Sleep and Stop modes"]
pub const fn gpiobsmen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clocks enable during Sleep and Stop modes"]
pub fn set_gpiobsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clocks enable during Sleep and Stop modes"]
pub const fn gpiocsmen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clocks enable during Sleep and Stop modes"]
pub fn set_gpiocsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clocks enable during Sleep and Stop modes"]
pub const fn gpiodsmen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clocks enable during Sleep and Stop modes"]
pub fn set_gpiodsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clocks enable during Sleep and Stop modes"]
pub const fn gpioesmen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clocks enable during Sleep and Stop modes"]
pub fn set_gpioesmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F clocks enable during Sleep and Stop modes"]
pub const fn gpiofsmen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F clocks enable during Sleep and Stop modes"]
pub fn set_gpiofsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G clocks enable during Sleep and Stop modes"]
pub const fn gpiogsmen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G clocks enable during Sleep and Stop modes"]
pub fn set_gpiogsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "CCM SRAM interface clocks enable during Sleep and Stop modes"]
pub const fn ccmsramsmen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CCM SRAM interface clocks enable during Sleep and Stop modes"]
pub fn set_ccmsramsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "SRAM2 interface clocks enable during Sleep and Stop modes"]
pub const fn sram2smen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "SRAM2 interface clocks enable during Sleep and Stop modes"]
pub fn set_sram2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "ADC clocks enable during Sleep and Stop modes"]
pub const fn adc12smen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "ADC clocks enable during Sleep and Stop modes"]
pub fn set_adc12smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "DCMI clock enable during Sleep and Stop modes"]
pub const fn adc345smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "DCMI clock enable during Sleep and Stop modes"]
pub fn set_adc345smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "AES accelerator clocks enable during Sleep and Stop modes"]
pub const fn dac1smen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AES accelerator clocks enable during Sleep and Stop modes"]
pub fn set_dac1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HASH clock enable during Sleep and Stop modes"]
pub const fn dac2smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HASH clock enable during Sleep and Stop modes"]
pub fn set_dac2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "DAC3 clock enable during sleep mode"]
pub const fn dac3smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "DAC3 clock enable during sleep mode"]
pub fn set_dac3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "DAC4 clock enable during sleep mode"]
pub const fn dac4smen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "DAC4 clock enable during sleep mode"]
pub fn set_dac4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Cryptography clock enable during sleep mode"]
pub const fn aesmen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Cryptography clock enable during sleep mode"]
pub fn set_aesmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Random Number Generator clock enable during sleep mode"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Random Number Generator clock enable during sleep mode"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Ahb2smenr { fn default () -> Ahb2smenr { Ahb2smenr (0) } } # [doc = "AHB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1enr (pub u32) ; impl Ahb1enr { # [doc = "DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMAMUX clock enable"]
pub const fn dmamux1en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMAMUX clock enable"]
pub fn set_dmamux1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CORDIC clock enable"]
pub const fn cordicen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CORDIC clock enable"]
pub fn set_cordicen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "FMAC clock enable"]
pub const fn fmacen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "FMAC clock enable"]
pub fn set_fmacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Flash memory interface clock enable"]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Flash memory interface clock enable"]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Ahb1enr { fn default () -> Ahb1enr { Ahb1enr (0) } } # [doc = "APB2SMENR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2smenr (pub u32) ; impl Apb2smenr { # [doc = "SYSCFG clocks enable during Sleep and Stop modes"]
pub const fn syscfgsmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYSCFG clocks enable during Sleep and Stop modes"]
pub fn set_syscfgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM1 timer clocks enable during Sleep and Stop modes"]
pub const fn tim1smen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clocks enable during Sleep and Stop modes"]
pub const fn spi1smen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clocks enable during Sleep and Stop modes"]
pub fn set_spi1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 timer clocks enable during Sleep and Stop modes"]
pub const fn tim8smen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim8smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1clocks enable during Sleep and Stop modes"]
pub const fn usart1smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1clocks enable during Sleep and Stop modes"]
pub fn set_usart1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI4 timer clocks enable during Sleep and Stop modes"]
pub const fn spi4smen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI4 timer clocks enable during Sleep and Stop modes"]
pub fn set_spi4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "TIM15 timer clocks enable during Sleep and Stop modes"]
pub const fn tim15smen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim15smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 timer clocks enable during Sleep and Stop modes"]
pub const fn tim16smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim16smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer clocks enable during Sleep and Stop modes"]
pub const fn tim17smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim17smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Timer 20clock enable during sleep mode"]
pub const fn tim20smen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Timer 20clock enable during sleep mode"]
pub fn set_tim20smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SAI1 clock enable during sleep mode"]
pub const fn sai1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SAI1 clock enable during sleep mode"]
pub fn set_sai1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "HRTIMER clock enable during sleep mode"]
pub const fn hrtim1smen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "HRTIMER clock enable during sleep mode"]
pub fn set_hrtim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Apb2smenr { fn default () -> Apb2smenr { Apb2smenr (0) } } # [doc = "APB1SMENR1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1smenr1 (pub u32) ; impl Apb1smenr1 { # [doc = "TIM2 timer clocks enable during Sleep and Stop modes"]
pub const fn tim2smen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 timer clocks enable during Sleep and Stop modes"]
pub const fn tim3smen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 timer clocks enable during Sleep and Stop modes"]
pub const fn tim4smen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 timer clocks enable during Sleep and Stop modes"]
pub const fn tim5smen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim5smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 timer clocks enable during Sleep and Stop modes"]
pub const fn tim6smen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim6smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 timer clocks enable during Sleep and Stop modes"]
pub const fn tim7smen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 timer clocks enable during Sleep and Stop modes"]
pub fn set_tim7smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CRS clock enable during sleep mode"]
pub const fn crssmen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "CRS clock enable during sleep mode"]
pub fn set_crssmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "RTC APB clock enable during Sleep and Stop modes"]
pub const fn rtcapbsmen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC APB clock enable during Sleep and Stop modes"]
pub fn set_rtcapbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Window watchdog clocks enable during Sleep and Stop modes"]
pub const fn wwdgsmen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clocks enable during Sleep and Stop modes"]
pub fn set_wwdgsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clocks enable during Sleep and Stop modes"]
pub const fn spi2smen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clocks enable during Sleep and Stop modes"]
pub fn set_spi2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 clocks enable during Sleep and Stop modes"]
pub const fn sp3smen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 clocks enable during Sleep and Stop modes"]
pub fn set_sp3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART2 clocks enable during Sleep and Stop modes"]
pub const fn usart2smen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 clocks enable during Sleep and Stop modes"]
pub fn set_usart2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clocks enable during Sleep and Stop modes"]
pub const fn usart3smen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clocks enable during Sleep and Stop modes"]
pub fn set_usart3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clocks enable during Sleep and Stop modes"]
pub const fn uart4smen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clocks enable during Sleep and Stop modes"]
pub fn set_uart4smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clocks enable during Sleep and Stop modes"]
pub const fn uart5smen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clocks enable during Sleep and Stop modes"]
pub fn set_uart5smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clocks enable during Sleep and Stop modes"]
pub const fn i2c1smen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clocks enable during Sleep and Stop modes"]
pub fn set_i2c1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clocks enable during Sleep and Stop modes"]
pub const fn i2c2smen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clocks enable during Sleep and Stop modes"]
pub fn set_i2c2smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB device clocks enable during Sleep and Stop modes"]
pub const fn usbsmen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB device clocks enable during Sleep and Stop modes"]
pub fn set_usbsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "FDCAN clock enable during sleep mode"]
pub const fn fdcansmen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "FDCAN clock enable during sleep mode"]
pub fn set_fdcansmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Power interface clocks enable during Sleep and Stop modes"]
pub const fn pwrsmen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clocks enable during Sleep and Stop modes"]
pub fn set_pwrsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "I2C3 clocks enable during Sleep and Stop modes"]
pub const fn i2c3smen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "I2C3 clocks enable during Sleep and Stop modes"]
pub fn set_i2c3smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low Power Timer1 clock enable during sleep mode"]
pub const fn lptim1smen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low Power Timer1 clock enable during sleep mode"]
pub fn set_lptim1smen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1smenr1 { fn default () -> Apb1smenr1 { Apb1smenr1 (0) } } # [doc = "AHB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3rstr (pub u32) ; impl Ahb3rstr { # [doc = "Flexible memory controller reset"]
pub const fn fmcrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible memory controller reset"]
pub fn set_fmcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Quad SPI 1 module reset"]
pub const fn qspirst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Quad SPI 1 module reset"]
pub fn set_qspirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Ahb3rstr { fn default () -> Ahb3rstr { Ahb3rstr (0) } } # [doc = "Clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "HSI clock enable"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "HSI clock enable"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "HSI always enable for peripheral kernels"]
pub const fn hsikeron (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "HSI always enable for peripheral kernels"]
pub fn set_hsikeron (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI clock ready flag"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI clock ready flag"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSE clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSE clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSE clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSE clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSE crystal oscillator bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSE crystal oscillator bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Clock security system enable"]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Clock security system enable"]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Main PLL enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Main PLL enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Main PLL clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Main PLL clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "APB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "System configuration (SYSCFG) reset"]
pub const fn syscfgrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "System configuration (SYSCFG) reset"]
pub fn set_syscfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM1 timer reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 timer reset"]
pub const fn tim8rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 timer reset"]
pub fn set_tim8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI 4 reset"]
pub const fn spi4rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI 4 reset"]
pub fn set_spi4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "TIM15 timer reset"]
pub const fn tim15rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 timer reset"]
pub fn set_tim15rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 timer reset"]
pub const fn tim16rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer reset"]
pub fn set_tim16rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer reset"]
pub const fn tim17rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer reset"]
pub fn set_tim17rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Timer 20 reset"]
pub const fn tim20rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Timer 20 reset"]
pub fn set_tim20rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Serial audio interface 1 (SAI1) reset"]
pub const fn sai1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Serial audio interface 1 (SAI1) reset"]
pub fn set_sai1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "HRTIMER reset"]
pub const fn hrtim1rst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "HRTIMER reset"]
pub fn set_hrtim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "APB1ENR1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr1 (pub u32) ; impl Apb1enr1 { # [doc = "TIM2 timer clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 timer clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 timer clock enable"]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 timer clock enable"]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 timer clock enable"]
pub const fn tim4en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 timer clock enable"]
pub fn set_tim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 timer clock enable"]
pub const fn tim5en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 timer clock enable"]
pub fn set_tim5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 timer clock enable"]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 timer clock enable"]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 timer clock enable"]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 timer clock enable"]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CRSclock enable"]
pub const fn crsen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "CRSclock enable"]
pub fn set_crsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "RTC APB clock enable"]
pub const fn rtcapben (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC APB clock enable"]
pub fn set_rtcapben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 clock enable"]
pub const fn spi3en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 clock enable"]
pub fn set_spi3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clock enable"]
pub const fn usart3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clock enable"]
pub fn set_usart3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clock enable"]
pub const fn uart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clock enable"]
pub fn set_uart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clock enable"]
pub const fn uart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clock enable"]
pub fn set_uart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB device clock enable"]
pub const fn usben (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB device clock enable"]
pub fn set_usben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "FDCAN clock enable"]
pub const fn fdcanen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "FDCAN clock enable"]
pub fn set_fdcanen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Power interface clock enable"]
pub const fn pwren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable"]
pub fn set_pwren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "I2C3 clock enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low power timer 1 clock enable"]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low power timer 1 clock enable"]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1enr1 { fn default () -> Apb1enr1 { Apb1enr1 (0) } } # [doc = "CCIPR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccipr (pub u32) ; impl Ccipr { # [doc = "USART1 clock source selection"]
pub const fn usart1sel (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "USART1 clock source selection"]
pub fn set_usart1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "USART2 clock source selection"]
pub const fn usart2sel (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "USART2 clock source selection"]
pub fn set_usart2sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "USART3 clock source selection"]
pub const fn usart3sel (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "USART3 clock source selection"]
pub fn set_usart3sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "UART4 clock source selection"]
pub const fn uart4sel (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x03 ; val as u8 } # [doc = "UART4 clock source selection"]
pub fn set_uart4sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val as u32) & 0x03) << 6usize) ; } # [doc = "UART5 clock source selection"]
pub const fn uart5sel (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "UART5 clock source selection"]
pub fn set_uart5sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "LPUART1 clock source selection"]
pub const fn lpuart1sel (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x03 ; val as u8 } # [doc = "LPUART1 clock source selection"]
pub fn set_lpuart1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val as u32) & 0x03) << 10usize) ; } # [doc = "I2C1 clock source selection"]
pub const fn i2c1sel (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x03 ; val as u8 } # [doc = "I2C1 clock source selection"]
pub fn set_i2c1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val as u32) & 0x03) << 12usize) ; } # [doc = "I2C2 clock source selection"]
pub const fn i2c2sel (& self) -> u8 { let val = (self . 0 >> 14usize) & 0x03 ; val as u8 } # [doc = "I2C2 clock source selection"]
pub fn set_i2c2sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val as u32) & 0x03) << 14usize) ; } # [doc = "I2C3 clock source selection"]
pub const fn i2c3sel (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x03 ; val as u8 } # [doc = "I2C3 clock source selection"]
pub fn set_i2c3sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val as u32) & 0x03) << 16usize) ; } # [doc = "Low power timer 1 clock source selection"]
pub const fn lptim1sel (& self) -> u8 { let val = (self . 0 >> 18usize) & 0x03 ; val as u8 } # [doc = "Low power timer 1 clock source selection"]
pub fn set_lptim1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val as u32) & 0x03) << 18usize) ; } # [doc = "Low power timer 2 clock source selection"]
pub const fn sai1sel (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Low power timer 2 clock source selection"]
pub fn set_sai1sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "SAI1 clock source selection"]
pub const fn i2s23sel (& self) -> u8 { let val = (self . 0 >> 22usize) & 0x03 ; val as u8 } # [doc = "SAI1 clock source selection"]
pub fn set_i2s23sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val as u32) & 0x03) << 22usize) ; } # [doc = "SAI2 clock source selection"]
pub const fn fdcansel (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x03 ; val as u8 } # [doc = "SAI2 clock source selection"]
pub fn set_fdcansel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 24usize)) | (((val as u32) & 0x03) << 24usize) ; } # [doc = "48 MHz clock source selection"]
pub const fn clk48sel (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x03 ; val as u8 } # [doc = "48 MHz clock source selection"]
pub fn set_clk48sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 26usize)) | (((val as u32) & 0x03) << 26usize) ; } # [doc = "ADCs clock source selection"]
pub const fn adc12sel (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "ADCs clock source selection"]
pub fn set_adc12sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } # [doc = "ADC3/4/5 clock source selection"]
pub const fn adc345sel (& self) -> u8 { let val = (self . 0 >> 30usize) & 0x03 ; val as u8 } # [doc = "ADC3/4/5 clock source selection"]
pub fn set_adc345sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 30usize)) | (((val as u32) & 0x03) << 30usize) ; } } impl Default for Ccipr { fn default () -> Ccipr { Ccipr (0) } } # [doc = "CSR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "LSI oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSI oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSI oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Option byte loader reset flag"]
pub const fn oblrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Option byte loader reset flag"]
pub fn set_oblrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Pad reset flag"]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Pad reset flag"]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "BOR flag"]
pub const fn borrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "BOR flag"]
pub fn set_borrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent window watchdog reset flag"]
pub const fn iwdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent window watchdog reset flag"]
pub fn set_iwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "APB1 peripheral reset register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr2 (pub u32) ; impl Apb1rstr2 { # [doc = "Low-power UART 1 reset"]
pub const fn lpuart1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low-power UART 1 reset"]
pub fn set_lpuart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "I2C4 reset"]
pub const fn i2c4rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "I2C4 reset"]
pub fn set_i2c4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "UCPD1 reset"]
pub const fn ucpd1rst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "UCPD1 reset"]
pub fn set_ucpd1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Apb1rstr2 { fn default () -> Apb1rstr2 { Apb1rstr2 (0) } } # [doc = "Peripherals independent clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccipr2 (pub u32) ; impl Ccipr2 { # [doc = "I2C4 clock source selection"]
pub const fn i2c4sel (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "I2C4 clock source selection"]
pub fn set_i2c4sel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Octospi clock source selection"]
pub const fn qspisel (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Octospi clock source selection"]
pub fn set_qspisel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } } impl Default for Ccipr2 { fn default () -> Ccipr2 { Ccipr2 (0) } } # [doc = "Clock recovery RC register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crrcr (pub u32) ; impl Crrcr { # [doc = "HSI48 clock enable"]
pub const fn hsi48on (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "HSI48 clock enable"]
pub fn set_hsi48on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "HSI48 clock ready flag"]
pub const fn hsi48rdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "HSI48 clock ready flag"]
pub fn set_hsi48rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI48 clock calibration"]
pub const fn hsi48cal (& self) -> u16 { let val = (self . 0 >> 7usize) & 0x01ff ; val as u16 } # [doc = "HSI48 clock calibration"]
pub fn set_hsi48cal (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 7usize)) | (((val as u32) & 0x01ff) << 7usize) ; } } impl Default for Crrcr { fn default () -> Crrcr { Crrcr (0) } } # [doc = "AHB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2enr (pub u32) ; impl Ahb2enr { # [doc = "IO port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F clock enable"]
pub const fn gpiofen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F clock enable"]
pub fn set_gpiofen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G clock enable"]
pub const fn gpiogen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G clock enable"]
pub fn set_gpiogen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "ADC clock enable"]
pub const fn adc12en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "ADC clock enable"]
pub fn set_adc12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "DCMI clock enable"]
pub const fn adc345en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "DCMI clock enable"]
pub fn set_adc345en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "AES accelerator clock enable"]
pub const fn dac1en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "AES accelerator clock enable"]
pub fn set_dac1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HASH clock enable"]
pub const fn dac2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HASH clock enable"]
pub fn set_dac2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Random Number Generator clock enable"]
pub const fn dac3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Random Number Generator clock enable"]
pub fn set_dac3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "DAC4 clock enable"]
pub const fn dac4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "DAC4 clock enable"]
pub fn set_dac4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "AES clock enable"]
pub const fn aesen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "AES clock enable"]
pub fn set_aesen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Random Number Generator clock enable"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Random Number Generator clock enable"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Ahb2enr { fn default () -> Ahb2enr { Ahb2enr (0) } } # [doc = "Clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock switch"]
pub const fn sw (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "System clock switch"]
pub fn set_sw (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "System clock switch status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "System clock switch status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "AHB prescaler"]
pub const fn hpre (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x0f ; val as u8 } # [doc = "AHB prescaler"]
pub fn set_hpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val as u32) & 0x0f) << 4usize) ; } # [doc = "PB low-speed prescaler (APB1)"]
pub const fn ppre1 (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "PB low-speed prescaler (APB1)"]
pub fn set_ppre1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "APB high-speed prescaler (APB2)"]
pub const fn ppre2 (& self) -> u8 { let val = (self . 0 >> 11usize) & 0x07 ; val as u8 } # [doc = "APB high-speed prescaler (APB2)"]
pub fn set_ppre2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 11usize)) | (((val as u32) & 0x07) << 11usize) ; } # [doc = "Microcontroller clock output"]
pub const fn mcosel (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Microcontroller clock output"]
pub fn set_mcosel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "Microcontroller clock output prescaler"]
pub const fn mcopre (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x07 ; val as u8 } # [doc = "Microcontroller clock output prescaler"]
pub fn set_mcopre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val as u32) & 0x07) << 28usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "Internal clock sources calibration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icscr (pub u32) ; impl Icscr { # [doc = "Internal High Speed clock Calibration"]
pub const fn hsical0 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Internal High Speed clock Calibration"]
pub fn set_hsical0 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Internal High Speed clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "Internal High Speed clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for Icscr { fn default () -> Icscr { Icscr (0) } } # [doc = "Clock interrupt clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cicr (pub u32) ; impl Cicr { # [doc = "LSI ready interrupt clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI ready interrupt clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL ready interrupt clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Clock security system interrupt clear"]
pub const fn cssc (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt clear"]
pub fn set_cssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Clock security system interrupt clear"]
pub const fn lsecssc (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Clock security system interrupt clear"]
pub fn set_lsecssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI48 oscillator ready interrupt clear"]
pub const fn hsi48rdyc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI48 oscillator ready interrupt clear"]
pub fn set_hsi48rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Cicr { fn default () -> Cicr { Cicr (0) } } # [doc = "Clock interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cier (pub u32) ; impl Cier { # [doc = "LSI ready interrupt enable"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt enable"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI ready interrupt enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "HSE ready interrupt enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL ready interrupt enable"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL ready interrupt enable"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LSE clock security system interrupt enable"]
pub const fn lsecssie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE clock security system interrupt enable"]
pub fn set_lsecssie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI48 ready interrupt enable"]
pub const fn hsi48rdyie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt enable"]
pub fn set_hsi48rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Cier { fn default () -> Cier { Cier (0) } } # [doc = "AHB3 peripheral clocks enable in Sleep and Stop modes register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3smenr (pub u32) ; impl Ahb3smenr { # [doc = "Flexible memory controller clocks enable during Sleep and Stop modes"]
pub const fn fmcsmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible memory controller clocks enable during Sleep and Stop modes"]
pub fn set_fmcsmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "QUADSPI memory interface clock enable during Sleep and Stop modes"]
pub const fn qspismen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "QUADSPI memory interface clock enable during Sleep and Stop modes"]
pub fn set_qspismen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Ahb3smenr { fn default () -> Ahb3smenr { Ahb3smenr (0) } } # [doc = "AHB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2rstr (pub u32) ; impl Ahb2rstr { # [doc = "IO port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F reset"]
pub const fn gpiofrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F reset"]
pub fn set_gpiofrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G reset"]
pub const fn gpiogrst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G reset"]
pub fn set_gpiogrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "ADC reset"]
pub const fn adc12rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "ADC reset"]
pub fn set_adc12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "SAR ADC345 interface reset"]
pub const fn adc345rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SAR ADC345 interface reset"]
pub fn set_adc345rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "DAC1 interface reset"]
pub const fn dac1rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "DAC1 interface reset"]
pub fn set_dac1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "DAC2 interface reset"]
pub const fn dac2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "DAC2 interface reset"]
pub fn set_dac2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "DAC3 interface reset"]
pub const fn dac3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "DAC3 interface reset"]
pub fn set_dac3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "DAC4 interface reset"]
pub const fn dac4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "DAC4 interface reset"]
pub fn set_dac4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Cryptography module reset"]
pub const fn aesrst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Cryptography module reset"]
pub fn set_aesrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Random Number Generator module reset"]
pub const fn rngrst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Random Number Generator module reset"]
pub fn set_rngrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Ahb2rstr { fn default () -> Ahb2rstr { Ahb2rstr (0) } } }