

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "PLL configuration register"]
pub fn pllcfgr (self) -> crate :: common :: Reg < regs :: Pllcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "clock configuration register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "clock interrupt register"]
pub fn cir (self) -> crate :: common :: Reg < regs :: Cir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "AHB1 peripheral reset register"]
pub fn ahb1rstr (self) -> crate :: common :: Reg < regs :: Ahb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "AHB2 peripheral reset register"]
pub fn ahb2rstr (self) -> crate :: common :: Reg < regs :: Ahb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "AHB3 peripheral reset register"]
pub fn ahb3rstr (self) -> crate :: common :: Reg < regs :: Ahb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "APB1 peripheral reset register"]
pub fn apb1rstr (self) -> crate :: common :: Reg < regs :: Apb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "APB2 peripheral reset register"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "AHB1 peripheral clock register"]
pub fn ahb1enr (self) -> crate :: common :: Reg < regs :: Ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "AHB2 peripheral clock enable register"]
pub fn ahb2enr (self) -> crate :: common :: Reg < regs :: Ahb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "AHB3 peripheral clock enable register"]
pub fn ahb3enr (self) -> crate :: common :: Reg < regs :: Ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "APB1 peripheral clock enable register"]
pub fn apb1enr (self) -> crate :: common :: Reg < regs :: Apb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "APB2 peripheral clock enable register"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "AHB1 peripheral clock enable in low power mode register"]
pub fn ahb1lpenr (self) -> crate :: common :: Reg < regs :: Ahb1lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "AHB2 peripheral clock enable in low power mode register"]
pub fn ahb2lpenr (self) -> crate :: common :: Reg < regs :: Ahb2lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "AHB3 peripheral clock enable in low power mode register"]
pub fn ahb3lpenr (self) -> crate :: common :: Reg < regs :: Ahb3lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "APB1 peripheral clock enable in low power mode register"]
pub fn apb1lpenr (self) -> crate :: common :: Reg < regs :: Apb1lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "APB2 peripheral clock enabled in low power mode register"]
pub fn apb2lpenr (self) -> crate :: common :: Reg < regs :: Apb2lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (100usize)) } } # [doc = "Backup domain control register"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } # [doc = "clock control & status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (116usize)) } } # [doc = "spread spectrum clock generation register"]
pub fn sscgr (self) -> crate :: common :: Reg < regs :: Sscgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "PLLI2S configuration register"]
pub fn plli2scfgr (self) -> crate :: common :: Reg < regs :: Plli2scfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize)) } } # [doc = "PLL configuration register"]
pub fn pllsaicfgr (self) -> crate :: common :: Reg < regs :: Pllsaicfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "dedicated clocks configuration register"]
pub fn dckcfgr1 (self) -> crate :: common :: Reg < regs :: Dckcfgr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (140usize)) } } # [doc = "dedicated clocks configuration register"]
pub fn dckcfgr2 (self) -> crate :: common :: Reg < regs :: Dckcfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } } pub mod regs { # [doc = "AHB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2rstr (pub u32) ; impl Ahb2rstr { # [doc = "Camera interface reset"]
pub const fn dcmirst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Camera interface reset"]
pub fn set_dcmirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "AES module reset"]
pub const fn aesrst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "AES module reset"]
pub fn set_aesrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Cryptographic module reset"]
pub const fn cryprst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Cryptographic module reset"]
pub fn set_cryprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Hash module reset"]
pub const fn hsahrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Hash module reset"]
pub fn set_hsahrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Random number generator module reset"]
pub const fn rngrst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Random number generator module reset"]
pub fn set_rngrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USB OTG FS module reset"]
pub const fn usb_otg_fsrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USB OTG FS module reset"]
pub fn set_usb_otg_fsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2rstr { fn default () -> Ahb2rstr { Ahb2rstr (0) } } # [doc = "AHB3 peripheral clock enable in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3lpenr (pub u32) ; impl Ahb3lpenr { # [doc = "Flexible memory controller module clock enable during Sleep mode"]
pub const fn fmclpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible memory controller module clock enable during Sleep mode"]
pub fn set_fmclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Quand SPI memory controller clock enable during Sleep mode"]
pub const fn quadspilpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Quand SPI memory controller clock enable during Sleep mode"]
pub fn set_quadspilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Ahb3lpenr { fn default () -> Ahb3lpenr { Ahb3lpenr (0) } } # [doc = "AHB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3enr (pub u32) ; impl Ahb3enr { # [doc = "Flexible memory controller module clock enable"]
pub const fn fmcen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible memory controller module clock enable"]
pub fn set_fmcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Quad SPI memory controller clock enable"]
pub const fn quadspien (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Quad SPI memory controller clock enable"]
pub fn set_quadspien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Ahb3enr { fn default () -> Ahb3enr { Ahb3enr (0) } } # [doc = "dedicated clocks configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dckcfgr1 (pub u32) ; impl Dckcfgr1 { # [doc = "PLLI2S division factor for SAI1 clock"]
pub const fn plli2sdivq (& self) -> super :: vals :: Pllisdivq { let val = (self . 0 >> 0usize) & 0x1f ; super :: vals :: Pllisdivq (val as u8) } # [doc = "PLLI2S division factor for SAI1 clock"]
pub fn set_plli2sdivq (& mut self , val : super :: vals :: Pllisdivq) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val . 0 as u32) & 0x1f) << 0usize) ; } # [doc = "PLLSAI division factor for SAI1 clock"]
pub const fn pllsaidivq (& self) -> super :: vals :: Pllsaidivq { let val = (self . 0 >> 8usize) & 0x1f ; super :: vals :: Pllsaidivq (val as u8) } # [doc = "PLLSAI division factor for SAI1 clock"]
pub fn set_pllsaidivq (& mut self , val : super :: vals :: Pllsaidivq) { self . 0 = (self . 0 & ! (0x1f << 8usize)) | (((val . 0 as u32) & 0x1f) << 8usize) ; } # [doc = "division factor for LCD_CLK"]
pub const fn pllsaidivr (& self) -> super :: vals :: Pllsaidivr { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Pllsaidivr (val as u8) } # [doc = "division factor for LCD_CLK"]
pub fn set_pllsaidivr (& mut self , val : super :: vals :: Pllsaidivr) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "SAI1 clock source selection"]
pub const fn sai1sel (& self) -> super :: vals :: Saisel { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Saisel (val as u8) } # [doc = "SAI1 clock source selection"]
pub fn set_sai1sel (& mut self , val : super :: vals :: Saisel) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "SAI2 clock source selection"]
pub const fn sai2sel (& self) -> super :: vals :: Saisel { let val = (self . 0 >> 22usize) & 0x03 ; super :: vals :: Saisel (val as u8) } # [doc = "SAI2 clock source selection"]
pub fn set_sai2sel (& mut self , val : super :: vals :: Saisel) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val . 0 as u32) & 0x03) << 22usize) ; } # [doc = "Timers clocks prescalers selection"]
pub const fn timpre (& self) -> super :: vals :: Timpre { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Timpre (val as u8) } # [doc = "Timers clocks prescalers selection"]
pub fn set_timpre (& mut self , val : super :: vals :: Timpre) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "DFSDM1 clock source selection"]
pub const fn dfsdm1sel (& self) -> super :: vals :: Dfsdmsel { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Dfsdmsel (val as u8) } # [doc = "DFSDM1 clock source selection"]
pub fn set_dfsdm1sel (& mut self , val : super :: vals :: Dfsdmsel) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "DFSDM1 AUDIO clock source selection"]
pub const fn adfsdm1sel (& self) -> super :: vals :: Adfsdmsel { let val = (self . 0 >> 26usize) & 0x01 ; super :: vals :: Adfsdmsel (val as u8) } # [doc = "DFSDM1 AUDIO clock source selection"]
pub fn set_adfsdm1sel (& mut self , val : super :: vals :: Adfsdmsel) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val . 0 as u32) & 0x01) << 26usize) ; } } impl Default for Dckcfgr1 { fn default () -> Dckcfgr1 { Dckcfgr1 (0) } } # [doc = "APB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "TIM1 reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 reset"]
pub const fn tim8rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 reset"]
pub fn set_tim8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 reset"]
pub const fn usart6rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 reset"]
pub fn set_usart6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "SDMMC2 reset"]
pub const fn sdmmc2rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 reset"]
pub fn set_sdmmc2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "ADC interface reset (common to all ADCs)"]
pub const fn adcrst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "ADC interface reset (common to all ADCs)"]
pub fn set_adcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "SDMMC1 reset"]
pub const fn sdmmc1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 reset"]
pub fn set_sdmmc1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SPI4 reset"]
pub const fn spi4rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SPI4 reset"]
pub fn set_spi4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "System configuration controller reset"]
pub const fn syscfgrst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "System configuration controller reset"]
pub fn set_syscfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM9 reset"]
pub const fn tim9rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM9 reset"]
pub fn set_tim9rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM10 reset"]
pub const fn tim10rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM10 reset"]
pub fn set_tim10rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM11 reset"]
pub const fn tim11rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM11 reset"]
pub fn set_tim11rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SPI5 reset"]
pub const fn spi5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SPI5 reset"]
pub fn set_spi5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SPI6 reset"]
pub const fn spi6rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SPI6 reset"]
pub fn set_spi6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SAI1 reset"]
pub const fn sai1rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI1 reset"]
pub fn set_sai1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "SAI2 reset"]
pub const fn sai2rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "SAI2 reset"]
pub fn set_sai2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "LTDC reset"]
pub const fn ltdcrst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "LTDC reset"]
pub fn set_ltdcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "DSI reset"]
pub const fn dsirst (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "DSI reset"]
pub fn set_dsirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "DFSDM 1 reset"]
pub const fn dfsdm1rst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DFSDM 1 reset"]
pub fn set_dfsdm1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "MDIOS reset"]
pub const fn mdiosrst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "MDIOS reset"]
pub fn set_mdiosrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "USB OTG HS PHY controller reset"]
pub const fn usbphycrst (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS PHY controller reset"]
pub fn set_usbphycrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "APB1 peripheral clock enable in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1lpenr (pub u32) ; impl Apb1lpenr { # [doc = "TIM2 clock enable during Sleep mode"]
pub const fn tim2lpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 clock enable during Sleep mode"]
pub fn set_tim2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 clock enable during Sleep mode"]
pub const fn tim3lpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 clock enable during Sleep mode"]
pub fn set_tim3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 clock enable during Sleep mode"]
pub const fn tim4lpen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 clock enable during Sleep mode"]
pub fn set_tim4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 clock enable during Sleep mode"]
pub const fn tim5lpen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 clock enable during Sleep mode"]
pub fn set_tim5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 clock enable during Sleep mode"]
pub const fn tim6lpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 clock enable during Sleep mode"]
pub fn set_tim6lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 clock enable during Sleep mode"]
pub const fn tim7lpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 clock enable during Sleep mode"]
pub fn set_tim7lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM12 clock enable during Sleep mode"]
pub const fn tim12lpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM12 clock enable during Sleep mode"]
pub fn set_tim12lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM13 clock enable during Sleep mode"]
pub const fn tim13lpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM13 clock enable during Sleep mode"]
pub fn set_tim13lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM14 clock enable during Sleep mode"]
pub const fn tim14lpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14 clock enable during Sleep mode"]
pub fn set_tim14lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "low power timer 1 clock enable during Sleep mode"]
pub const fn lptim1lpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "low power timer 1 clock enable during Sleep mode"]
pub fn set_lptim1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "RTCAPB clock enable during Sleep mode"]
pub const fn rtclpen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTCAPB clock enable during Sleep mode"]
pub fn set_rtclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Window watchdog clock enable during Sleep mode"]
pub const fn wwdglpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable during Sleep mode"]
pub fn set_wwdglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CAN 3 clock enable during Sleep mode"]
pub const fn can3lpen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CAN 3 clock enable during Sleep mode"]
pub fn set_can3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "SPI2 clock enable during Sleep mode"]
pub const fn spi2lpen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable during Sleep mode"]
pub fn set_spi2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 clock enable during Sleep mode"]
pub const fn spi3lpen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 clock enable during Sleep mode"]
pub fn set_spi3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SPDIF-RX clock enable during sleep mode"]
pub const fn spdifrxlpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SPDIF-RX clock enable during sleep mode"]
pub fn set_spdifrxlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "USART2 clock enable during Sleep mode"]
pub const fn usart2lpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 clock enable during Sleep mode"]
pub fn set_usart2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clock enable during Sleep mode"]
pub const fn usart3lpen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clock enable during Sleep mode"]
pub fn set_usart3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clock enable during Sleep mode"]
pub const fn uart4lpen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clock enable during Sleep mode"]
pub fn set_uart4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clock enable during Sleep mode"]
pub const fn uart5lpen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clock enable during Sleep mode"]
pub fn set_uart5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clock enable during Sleep mode"]
pub const fn i2c1lpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable during Sleep mode"]
pub fn set_i2c1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable during Sleep mode"]
pub const fn i2c2lpen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable during Sleep mode"]
pub fn set_i2c2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 clock enable during Sleep mode"]
pub const fn i2c3lpen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable during Sleep mode"]
pub fn set_i2c3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "I2C4 clock enable during Sleep mode"]
pub const fn i2c4lpen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "I2C4 clock enable during Sleep mode"]
pub fn set_i2c4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "CAN 1 clock enable during Sleep mode"]
pub const fn can1lpen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN 1 clock enable during Sleep mode"]
pub fn set_can1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN 2 clock enable during Sleep mode"]
pub const fn can2lpen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN 2 clock enable during Sleep mode"]
pub fn set_can2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "HDMI-CEN clock enable during Sleep mode"]
pub const fn ceclpen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "HDMI-CEN clock enable during Sleep mode"]
pub fn set_ceclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface clock enable during Sleep mode"]
pub const fn pwrlpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable during Sleep mode"]
pub fn set_pwrlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable during Sleep mode"]
pub const fn daclpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable during Sleep mode"]
pub fn set_daclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "UART7 clock enable during Sleep mode"]
pub const fn uart7lpen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "UART7 clock enable during Sleep mode"]
pub fn set_uart7lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "UART8 clock enable during Sleep mode"]
pub const fn uart8lpen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "UART8 clock enable during Sleep mode"]
pub fn set_uart8lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1lpenr { fn default () -> Apb1lpenr { Apb1lpenr (0) } } # [doc = "AHB1 peripheral clock enable in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1lpenr (pub u32) ; impl Ahb1lpenr { # [doc = "IO port A clock enable during sleep mode"]
pub const fn gpioalpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable during sleep mode"]
pub fn set_gpioalpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable during Sleep mode"]
pub const fn gpioblpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable during Sleep mode"]
pub fn set_gpioblpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable during Sleep mode"]
pub const fn gpioclpen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable during Sleep mode"]
pub fn set_gpioclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clock enable during Sleep mode"]
pub const fn gpiodlpen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clock enable during Sleep mode"]
pub fn set_gpiodlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clock enable during Sleep mode"]
pub const fn gpioelpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clock enable during Sleep mode"]
pub fn set_gpioelpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F clock enable during Sleep mode"]
pub const fn gpioflpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F clock enable during Sleep mode"]
pub fn set_gpioflpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G clock enable during Sleep mode"]
pub const fn gpioglpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G clock enable during Sleep mode"]
pub fn set_gpioglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H clock enable during Sleep mode"]
pub const fn gpiohlpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable during Sleep mode"]
pub fn set_gpiohlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I clock enable during Sleep mode"]
pub const fn gpioilpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I clock enable during Sleep mode"]
pub fn set_gpioilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "IO port J clock enable during Sleep mode"]
pub const fn gpiojlpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "IO port J clock enable during Sleep mode"]
pub fn set_gpiojlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "IO port K clock enable during Sleep mode"]
pub const fn gpioklpen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "IO port K clock enable during Sleep mode"]
pub fn set_gpioklpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CRC clock enable during Sleep mode"]
pub const fn crclpen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable during Sleep mode"]
pub fn set_crclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "AXI to AHB bridge clock enable during Sleep mode"]
pub const fn axilpen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "AXI to AHB bridge clock enable during Sleep mode"]
pub fn set_axilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Flash interface clock enable during Sleep mode"]
pub const fn flashlpen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Flash interface clock enable during Sleep mode"]
pub fn set_flashlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SRAM 1interface clock enable during Sleep mode"]
pub const fn sram1lpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SRAM 1interface clock enable during Sleep mode"]
pub fn set_sram1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "SRAM 2 interface clock enable during Sleep mode"]
pub const fn sram2lpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "SRAM 2 interface clock enable during Sleep mode"]
pub fn set_sram2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Backup SRAM interface clock enable during Sleep mode"]
pub const fn bkpsramlpen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Backup SRAM interface clock enable during Sleep mode"]
pub fn set_bkpsramlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SRAM 3 interface clock enable during Sleep mode"]
pub const fn sram3lpen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "SRAM 3 interface clock enable during Sleep mode"]
pub fn set_sram3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "DTCM RAM interface clock enable during Sleep mode"]
pub const fn dtcmlpen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "DTCM RAM interface clock enable during Sleep mode"]
pub fn set_dtcmlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "DMA1 clock enable during Sleep mode"]
pub const fn dma1lpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable during Sleep mode"]
pub fn set_dma1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "DMA2 clock enable during Sleep mode"]
pub const fn dma2lpen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable during Sleep mode"]
pub fn set_dma2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "DMA2D clock enable during Sleep mode"]
pub const fn dma2dlpen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "DMA2D clock enable during Sleep mode"]
pub fn set_dma2dlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Ethernet MAC clock enable during Sleep mode"]
pub const fn ethlpen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC clock enable during Sleep mode"]
pub fn set_ethlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Ethernet transmission clock enable during Sleep mode"]
pub const fn ethtxlpen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Ethernet transmission clock enable during Sleep mode"]
pub fn set_ethtxlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Ethernet reception clock enable during Sleep mode"]
pub const fn ethrxlpen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Ethernet reception clock enable during Sleep mode"]
pub fn set_ethrxlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Ethernet PTP clock enable during Sleep mode"]
pub const fn ethptplpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Ethernet PTP clock enable during Sleep mode"]
pub fn set_ethptplpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "USB OTG HS clock enable during Sleep mode"]
pub const fn usb_otg_hslpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS clock enable during Sleep mode"]
pub fn set_usb_otg_hslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "USB OTG HS ULPI clock enable during Sleep mode"]
pub const fn usb_otg_hsulpilpen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS ULPI clock enable during Sleep mode"]
pub fn set_usb_otg_hsulpilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Ahb1lpenr { fn default () -> Ahb1lpenr { Ahb1lpenr (0) } } # [doc = "clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock switch"]
pub const fn sw (& self) -> super :: vals :: Sw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "System clock switch"]
pub fn set_sw (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "System clock switch status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "System clock switch status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "AHB prescaler"]
pub const fn hpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 4usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "AHB prescaler"]
pub fn set_hpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val . 0 as u32) & 0x0f) << 4usize) ; } # [doc = "APB Low speed prescaler (APB1)"]
pub const fn ppre1 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 10usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB Low speed prescaler (APB1)"]
pub fn set_ppre1 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 10usize)) | (((val . 0 as u32) & 0x07) << 10usize) ; } # [doc = "APB high-speed prescaler (APB2)"]
pub const fn ppre2 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 13usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB high-speed prescaler (APB2)"]
pub fn set_ppre2 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val . 0 as u32) & 0x07) << 13usize) ; } # [doc = "HSE division factor for RTC clock"]
pub const fn rtcpre (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x1f ; val as u8 } # [doc = "HSE division factor for RTC clock"]
pub fn set_rtcpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 16usize)) | (((val as u32) & 0x1f) << 16usize) ; } # [doc = "Microcontroller clock output 1"]
pub const fn mco1 (& self) -> super :: vals :: Mco1 { let val = (self . 0 >> 21usize) & 0x03 ; super :: vals :: Mco1 (val as u8) } # [doc = "Microcontroller clock output 1"]
pub fn set_mco1 (& mut self , val : super :: vals :: Mco1) { self . 0 = (self . 0 & ! (0x03 << 21usize)) | (((val . 0 as u32) & 0x03) << 21usize) ; } # [doc = "I2S clock selection"]
pub const fn i2ssrc (& self) -> super :: vals :: Issrc { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Issrc (val as u8) } # [doc = "I2S clock selection"]
pub fn set_i2ssrc (& mut self , val : super :: vals :: Issrc) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "MCO1 prescaler"]
pub const fn mco1pre (& self) -> super :: vals :: Mcopre { let val = (self . 0 >> 24usize) & 0x07 ; super :: vals :: Mcopre (val as u8) } # [doc = "MCO1 prescaler"]
pub fn set_mco1pre (& mut self , val : super :: vals :: Mcopre) { self . 0 = (self . 0 & ! (0x07 << 24usize)) | (((val . 0 as u32) & 0x07) << 24usize) ; } # [doc = "MCO2 prescaler"]
pub const fn mco2pre (& self) -> super :: vals :: Mcopre { let val = (self . 0 >> 27usize) & 0x07 ; super :: vals :: Mcopre (val as u8) } # [doc = "MCO2 prescaler"]
pub fn set_mco2pre (& mut self , val : super :: vals :: Mcopre) { self . 0 = (self . 0 & ! (0x07 << 27usize)) | (((val . 0 as u32) & 0x07) << 27usize) ; } # [doc = "Microcontroller clock output 2"]
pub const fn mco2 (& self) -> super :: vals :: Mco2 { let val = (self . 0 >> 30usize) & 0x03 ; super :: vals :: Mco2 (val as u8) } # [doc = "Microcontroller clock output 2"]
pub fn set_mco2 (& mut self , val : super :: vals :: Mco2) { self . 0 = (self . 0 & ! (0x03 << 30usize)) | (((val . 0 as u32) & 0x03) << 30usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "AHB2 peripheral clock enable in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2lpenr (pub u32) ; impl Ahb2lpenr { # [doc = "Camera interface enable during Sleep mode"]
pub const fn dcmilpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Camera interface enable during Sleep mode"]
pub fn set_dcmilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "JPEG module enabled during Sleep mode"]
pub const fn jpeglpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "JPEG module enabled during Sleep mode"]
pub fn set_jpeglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "AES module clock enable during Sleep mode"]
pub const fn aeslpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "AES module clock enable during Sleep mode"]
pub fn set_aeslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Cryptography modules clock enable during Sleep mode"]
pub const fn cryplpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Cryptography modules clock enable during Sleep mode"]
pub fn set_cryplpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Hash modules clock enable during Sleep mode"]
pub const fn hashlpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Hash modules clock enable during Sleep mode"]
pub fn set_hashlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Random number generator clock enable during Sleep mode"]
pub const fn rnglpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Random number generator clock enable during Sleep mode"]
pub fn set_rnglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USB OTG FS clock enable during Sleep mode"]
pub const fn usb_otg_fslpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USB OTG FS clock enable during Sleep mode"]
pub fn set_usb_otg_fslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2lpenr { fn default () -> Ahb2lpenr { Ahb2lpenr (0) } } # [doc = "Backup domain control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "External low-speed oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "External low-speed oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External low-speed oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "LSE oscillator drive capability"]
pub const fn lsedrv (& self) -> super :: vals :: Lsedrv { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Lsedrv (val as u8) } # [doc = "LSE oscillator drive capability"]
pub fn set_lsedrv (& mut self , val : super :: vals :: Lsedrv) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> super :: vals :: Rtcsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Rtcsel (val as u8) } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : super :: vals :: Rtcsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Backup domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "AHB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1rstr (pub u32) ; impl Ahb1rstr { # [doc = "IO port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F reset"]
pub const fn gpiofrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F reset"]
pub fn set_gpiofrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G reset"]
pub const fn gpiogrst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G reset"]
pub fn set_gpiogrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H reset"]
pub const fn gpiohrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H reset"]
pub fn set_gpiohrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I reset"]
pub const fn gpioirst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I reset"]
pub fn set_gpioirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "IO port J reset"]
pub const fn gpiojrst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "IO port J reset"]
pub fn set_gpiojrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "IO port K reset"]
pub const fn gpiokrst (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "IO port K reset"]
pub fn set_gpiokrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CRC reset"]
pub const fn crcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC reset"]
pub fn set_crcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DMA2 reset"]
pub const fn dma1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "DMA2 reset"]
pub fn set_dma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "DMA2 reset"]
pub const fn dma2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DMA2 reset"]
pub fn set_dma2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "DMA2D reset"]
pub const fn dma2drst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "DMA2D reset"]
pub fn set_dma2drst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Ethernet MAC reset"]
pub const fn ethrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC reset"]
pub fn set_ethrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "USB OTG HS module reset"]
pub const fn usb_otg_hsrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS module reset"]
pub fn set_usb_otg_hsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Ahb1rstr { fn default () -> Ahb1rstr { Ahb1rstr (0) } } # [doc = "APB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "TIM1 clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 clock enable"]
pub const fn tim8en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 clock enable"]
pub fn set_tim8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 clock enable"]
pub const fn usart6en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 clock enable"]
pub fn set_usart6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "SDMMC2 clock enable"]
pub const fn sdmmc2en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 clock enable"]
pub fn set_sdmmc2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "ADC1 clock enable"]
pub const fn adc1en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "ADC1 clock enable"]
pub fn set_adc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC2 clock enable"]
pub const fn adc2en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC2 clock enable"]
pub fn set_adc2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADC3 clock enable"]
pub const fn adc3en (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC3 clock enable"]
pub fn set_adc3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SDMMC1 clock enable"]
pub const fn sdmmc1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 clock enable"]
pub fn set_sdmmc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SPI4 clock enable"]
pub const fn spi4en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SPI4 clock enable"]
pub fn set_spi4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "System configuration controller clock enable"]
pub const fn syscfgen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "System configuration controller clock enable"]
pub fn set_syscfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM9 clock enable"]
pub const fn tim9en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM9 clock enable"]
pub fn set_tim9en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM10 clock enable"]
pub const fn tim10en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM10 clock enable"]
pub fn set_tim10en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM11 clock enable"]
pub const fn tim11en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM11 clock enable"]
pub fn set_tim11en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SPI5 clock enable"]
pub const fn spi5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SPI5 clock enable"]
pub fn set_spi5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SPI6 clock enable"]
pub const fn spi6en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SPI6 clock enable"]
pub fn set_spi6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SAI1 clock enable"]
pub const fn sai1en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI1 clock enable"]
pub fn set_sai1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "SAI2 clock enable"]
pub const fn sai2en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "SAI2 clock enable"]
pub fn set_sai2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "LTDC clock enable"]
pub const fn ltdcen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "LTDC clock enable"]
pub fn set_ltdcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "DSI clock enable"]
pub const fn dsien (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "DSI clock enable"]
pub fn set_dsien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "DFSDM1 clock enable"]
pub const fn dfsdm1en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DFSDM1 clock enable"]
pub fn set_dfsdm1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "MDIO clock enable"]
pub const fn mdiosen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "MDIO clock enable"]
pub fn set_mdiosen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "USB OTG HS PHY controller clock enable"]
pub const fn usbphycen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS PHY controller clock enable"]
pub fn set_usbphycen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "AHB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3rstr (pub u32) ; impl Ahb3rstr { # [doc = "Flexible memory controller module reset"]
pub const fn fmcrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible memory controller module reset"]
pub fn set_fmcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Quad SPI memory controller reset"]
pub const fn quadspirst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Quad SPI memory controller reset"]
pub fn set_quadspirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Ahb3rstr { fn default () -> Ahb3rstr { Ahb3rstr (0) } } # [doc = "APB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr (pub u32) ; impl Apb1rstr { # [doc = "TIM2 reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 reset"]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 reset"]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 reset"]
pub const fn tim4rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 reset"]
pub fn set_tim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 reset"]
pub const fn tim5rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 reset"]
pub fn set_tim5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 reset"]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 reset"]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 reset"]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 reset"]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM12 reset"]
pub const fn tim12rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM12 reset"]
pub fn set_tim12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM13 reset"]
pub const fn tim13rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM13 reset"]
pub fn set_tim13rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM14 reset"]
pub const fn tim14rst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14 reset"]
pub fn set_tim14rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Low power timer 1 reset"]
pub const fn lptim1rst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Low power timer 1 reset"]
pub fn set_lptim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Window watchdog reset"]
pub const fn wwdgrst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset"]
pub fn set_wwdgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CAN 3 reset"]
pub const fn can3rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CAN 3 reset"]
pub fn set_can3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "SPI 2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI 2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI 3 reset"]
pub const fn spi3rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI 3 reset"]
pub fn set_spi3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SPDIF-RX reset"]
pub const fn spdifrxrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SPDIF-RX reset"]
pub fn set_spdifrxrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "USART 2 reset"]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 reset"]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART 3 reset"]
pub const fn usart3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART 3 reset"]
pub fn set_usart3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USART 4 reset"]
pub const fn uart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "USART 4 reset"]
pub fn set_uart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "USART 5 reset"]
pub const fn uart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "USART 5 reset"]
pub fn set_uart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C 1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C 1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C 2 reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C 2 reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 reset"]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 reset"]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "I2C 4 reset"]
pub const fn i2c4rst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "I2C 4 reset"]
pub fn set_i2c4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "CAN1 reset"]
pub const fn can1rst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN1 reset"]
pub fn set_can1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN2 reset"]
pub const fn can2rst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN2 reset"]
pub fn set_can2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "HDMI-CEC reset"]
pub const fn cecrst (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "HDMI-CEC reset"]
pub fn set_cecrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface reset"]
pub const fn pwrrst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface reset"]
pub fn set_pwrrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC reset"]
pub const fn dacrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC reset"]
pub fn set_dacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "UART7 reset"]
pub const fn uart7rst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "UART7 reset"]
pub fn set_uart7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "UART8 reset"]
pub const fn uart8rst (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "UART8 reset"]
pub fn set_uart8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1rstr { fn default () -> Apb1rstr { Apb1rstr (0) } } # [doc = "spread spectrum clock generation register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sscgr (pub u32) ; impl Sscgr { # [doc = "Modulation period"]
pub const fn modper (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x1fff ; val as u16 } # [doc = "Modulation period"]
pub fn set_modper (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 0usize)) | (((val as u32) & 0x1fff) << 0usize) ; } # [doc = "Incrementation step"]
pub const fn incstep (& self) -> u16 { let val = (self . 0 >> 13usize) & 0x7fff ; val as u16 } # [doc = "Incrementation step"]
pub fn set_incstep (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 13usize)) | (((val as u32) & 0x7fff) << 13usize) ; } # [doc = "Spread Select"]
pub const fn spreadsel (& self) -> super :: vals :: Spreadsel { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: Spreadsel (val as u8) } # [doc = "Spread Select"]
pub fn set_spreadsel (& mut self , val : super :: vals :: Spreadsel) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "Spread spectrum modulation enable"]
pub const fn sscgen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Spread spectrum modulation enable"]
pub fn set_sscgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Sscgr { fn default () -> Sscgr { Sscgr (0) } } # [doc = "clock control & status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Internal low-speed oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal low-speed oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal low-speed oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal low-speed oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "BOR reset flag"]
pub const fn borrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "BOR reset flag"]
pub fn set_borrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PIN reset flag"]
pub const fn padrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PIN reset flag"]
pub fn set_padrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "POR/PDR reset flag"]
pub const fn porrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "POR/PDR reset flag"]
pub fn set_porrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent watchdog reset flag"]
pub const fn wdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog reset flag"]
pub fn set_wdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "PLL configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllsaicfgr (pub u32) ; impl Pllsaicfgr { # [doc = "PLLSAI division factor for VCO"]
pub const fn pllsain (& self) -> u16 { let val = (self . 0 >> 6usize) & 0x01ff ; val as u16 } # [doc = "PLLSAI division factor for VCO"]
pub fn set_pllsain (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 6usize)) | (((val as u32) & 0x01ff) << 6usize) ; } # [doc = "PLLSAI division factor for 48MHz clock"]
pub const fn pllsaip (& self) -> super :: vals :: Pllsaip { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Pllsaip (val as u8) } # [doc = "PLLSAI division factor for 48MHz clock"]
pub fn set_pllsaip (& mut self , val : super :: vals :: Pllsaip) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "PLLSAI division factor for SAI clock"]
pub const fn pllsaiq (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "PLLSAI division factor for SAI clock"]
pub fn set_pllsaiq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "PLLSAI division factor for LCD clock"]
pub const fn pllsair (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x07 ; val as u8 } # [doc = "PLLSAI division factor for LCD clock"]
pub fn set_pllsair (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val as u32) & 0x07) << 28usize) ; } } impl Default for Pllsaicfgr { fn default () -> Pllsaicfgr { Pllsaicfgr (0) } } # [doc = "clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Internal high-speed clock enable"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal high-speed clock enable"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal high-speed clock ready flag"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal high-speed clock ready flag"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Internal high-speed clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x1f ; val as u8 } # [doc = "Internal high-speed clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 3usize)) | (((val as u32) & 0x1f) << 3usize) ; } # [doc = "Internal high-speed clock calibration"]
pub const fn hsical (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Internal high-speed clock calibration"]
pub fn set_hsical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "HSE clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSE clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSE clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSE clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSE clock bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSE clock bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Clock security system enable"]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Clock security system enable"]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Main PLL (PLL) enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Main PLL (PLL) enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Main PLL (PLL) clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Main PLL (PLL) clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PLLI2S enable"]
pub const fn plli2son (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PLLI2S enable"]
pub fn set_plli2son (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "PLLI2S clock ready flag"]
pub const fn plli2srdy (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "PLLI2S clock ready flag"]
pub fn set_plli2srdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "PLLSAI enable"]
pub const fn pllsaion (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "PLLSAI enable"]
pub fn set_pllsaion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "PLLSAI clock ready flag"]
pub const fn pllsairdy (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "PLLSAI clock ready flag"]
pub fn set_pllsairdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "PLL configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllcfgr (pub u32) ; impl Pllcfgr { # [doc = "Division factor for the main PLL (PLL) and audio PLL (PLLI2S) input clock"]
pub const fn pllm (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Division factor for the main PLL (PLL) and audio PLL (PLLI2S) input clock"]
pub fn set_pllm (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } # [doc = "Main PLL (PLL) multiplication factor for VCO"]
pub const fn plln (& self) -> u16 { let val = (self . 0 >> 6usize) & 0x01ff ; val as u16 } # [doc = "Main PLL (PLL) multiplication factor for VCO"]
pub fn set_plln (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 6usize)) | (((val as u32) & 0x01ff) << 6usize) ; } # [doc = "Main PLL (PLL) division factor for main system clock"]
pub const fn pllp (& self) -> super :: vals :: Pllp { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Pllp (val as u8) } # [doc = "Main PLL (PLL) division factor for main system clock"]
pub fn set_pllp (& mut self , val : super :: vals :: Pllp) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Main PLL(PLL) and audio PLL (PLLI2S) entry clock source"]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Pllsrc (val as u8) } # [doc = "Main PLL(PLL) and audio PLL (PLLI2S) entry clock source"]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Main PLL (PLL) division factor for USB OTG FS, SDIO and random number generator clocks"]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Main PLL (PLL) division factor for USB OTG FS, SDIO and random number generator clocks"]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "PLL division factor for DSI clock"]
pub const fn pllr (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x07 ; val as u8 } # [doc = "PLL division factor for DSI clock"]
pub fn set_pllr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val as u32) & 0x07) << 28usize) ; } } impl Default for Pllcfgr { fn default () -> Pllcfgr { Pllcfgr (0) } } # [doc = "APB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr (pub u32) ; impl Apb1enr { # [doc = "TIM2 clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 clock enable"]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 clock enable"]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 clock enable"]
pub const fn tim4en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 clock enable"]
pub fn set_tim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 clock enable"]
pub const fn tim5en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 clock enable"]
pub fn set_tim5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 clock enable"]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 clock enable"]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 clock enable"]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 clock enable"]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM12 clock enable"]
pub const fn tim12en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM12 clock enable"]
pub fn set_tim12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM13 clock enable"]
pub const fn tim13en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM13 clock enable"]
pub fn set_tim13en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM14 clock enable"]
pub const fn tim14en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14 clock enable"]
pub fn set_tim14en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Low power timer 1 clock enable"]
pub const fn lptim1en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Low power timer 1 clock enable"]
pub fn set_lptim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "RTCAPB clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTCAPB clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "CAN 3 enable"]
pub const fn can3en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CAN 3 enable"]
pub fn set_can3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "SPI2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 clock enable"]
pub const fn spi3en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 clock enable"]
pub fn set_spi3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SPDIF-RX clock enable"]
pub const fn spdifrxen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SPDIF-RX clock enable"]
pub fn set_spdifrxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "USART 2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clock enable"]
pub const fn usart3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clock enable"]
pub fn set_usart3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clock enable"]
pub const fn uart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clock enable"]
pub fn set_uart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clock enable"]
pub const fn uart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clock enable"]
pub fn set_uart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 clock enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "I2C4 clock enable"]
pub const fn i2c4en (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "I2C4 clock enable"]
pub fn set_i2c4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "CAN 1 clock enable"]
pub const fn can1en (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN 1 clock enable"]
pub fn set_can1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN 2 clock enable"]
pub const fn can2en (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN 2 clock enable"]
pub fn set_can2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "HDMI-CEN clock enable"]
pub const fn cecen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "HDMI-CEN clock enable"]
pub fn set_cecen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface clock enable"]
pub const fn pwren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable"]
pub fn set_pwren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable"]
pub const fn dacen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable"]
pub fn set_dacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "UART7 clock enable"]
pub const fn uart7en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "UART7 clock enable"]
pub fn set_uart7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "UART8 clock enable"]
pub const fn uart8en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "UART8 clock enable"]
pub fn set_uart8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1enr { fn default () -> Apb1enr { Apb1enr (0) } } # [doc = "APB2 peripheral clock enabled in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2lpenr (pub u32) ; impl Apb2lpenr { # [doc = "TIM1 clock enable during Sleep mode"]
pub const fn tim1lpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 clock enable during Sleep mode"]
pub fn set_tim1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 clock enable during Sleep mode"]
pub const fn tim8lpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 clock enable during Sleep mode"]
pub fn set_tim8lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 clock enable during Sleep mode"]
pub const fn usart1lpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable during Sleep mode"]
pub fn set_usart1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 clock enable during Sleep mode"]
pub const fn usart6lpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 clock enable during Sleep mode"]
pub fn set_usart6lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "SDMMC2 clock enable during Sleep mode"]
pub const fn sdmmc2lpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "SDMMC2 clock enable during Sleep mode"]
pub fn set_sdmmc2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "ADC1 clock enable during Sleep mode"]
pub const fn adc1lpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "ADC1 clock enable during Sleep mode"]
pub fn set_adc1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC2 clock enable during Sleep mode"]
pub const fn adc2lpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC2 clock enable during Sleep mode"]
pub fn set_adc2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADC 3 clock enable during Sleep mode"]
pub const fn adc3lpen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC 3 clock enable during Sleep mode"]
pub fn set_adc3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SDMMC1 clock enable during Sleep mode"]
pub const fn sdmmc1lpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SDMMC1 clock enable during Sleep mode"]
pub fn set_sdmmc1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 clock enable during Sleep mode"]
pub const fn spi1lpen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 clock enable during Sleep mode"]
pub fn set_spi1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SPI 4 clock enable during Sleep mode"]
pub const fn spi4lpen (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SPI 4 clock enable during Sleep mode"]
pub fn set_spi4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "System configuration controller clock enable during Sleep mode"]
pub const fn syscfglpen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "System configuration controller clock enable during Sleep mode"]
pub fn set_syscfglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM9 clock enable during sleep mode"]
pub const fn tim9lpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM9 clock enable during sleep mode"]
pub fn set_tim9lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM10 clock enable during Sleep mode"]
pub const fn tim10lpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM10 clock enable during Sleep mode"]
pub fn set_tim10lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM11 clock enable during Sleep mode"]
pub const fn tim11lpen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM11 clock enable during Sleep mode"]
pub fn set_tim11lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "SPI 5 clock enable during Sleep mode"]
pub const fn spi5lpen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SPI 5 clock enable during Sleep mode"]
pub fn set_spi5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SPI 6 clock enable during Sleep mode"]
pub const fn spi6lpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SPI 6 clock enable during Sleep mode"]
pub fn set_spi6lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SAI1 clock enable during sleep mode"]
pub const fn sai1lpen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SAI1 clock enable during sleep mode"]
pub fn set_sai1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "SAI2 clock enable during sleep mode"]
pub const fn sai2lpen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "SAI2 clock enable during sleep mode"]
pub fn set_sai2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "LTDC clock enable during sleep mode"]
pub const fn ltdclpen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "LTDC clock enable during sleep mode"]
pub fn set_ltdclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "DSI clock enable during Sleep mode"]
pub const fn dsilpen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "DSI clock enable during Sleep mode"]
pub fn set_dsilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "DFSDM1 clock enable during Sleep mode"]
pub const fn dfsdm1lpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DFSDM1 clock enable during Sleep mode"]
pub fn set_dfsdm1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "MDIO clock enable during Sleep mode"]
pub const fn mdioslpen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "MDIO clock enable during Sleep mode"]
pub fn set_mdioslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Apb2lpenr { fn default () -> Apb2lpenr { Apb2lpenr (0) } } # [doc = "PLLI2S configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Plli2scfgr (pub u32) ; impl Plli2scfgr { # [doc = "PLLI2S multiplication factor for VCO"]
pub const fn plli2sn (& self) -> u16 { let val = (self . 0 >> 6usize) & 0x01ff ; val as u16 } # [doc = "PLLI2S multiplication factor for VCO"]
pub fn set_plli2sn (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 6usize)) | (((val as u32) & 0x01ff) << 6usize) ; } # [doc = "PLLI2S division factor for SPDIFRX clock"]
pub const fn plli2sp (& self) -> super :: vals :: Pllisp { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Pllisp (val as u8) } # [doc = "PLLI2S division factor for SPDIFRX clock"]
pub fn set_plli2sp (& mut self , val : super :: vals :: Pllisp) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "PLLI2S division factor for SAI1 clock"]
pub const fn plli2sq (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "PLLI2S division factor for SAI1 clock"]
pub fn set_plli2sq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "PLLI2S division factor for I2S clocks"]
pub const fn plli2sr (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x07 ; val as u8 } # [doc = "PLLI2S division factor for I2S clocks"]
pub fn set_plli2sr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val as u32) & 0x07) << 28usize) ; } } impl Default for Plli2scfgr { fn default () -> Plli2scfgr { Plli2scfgr (0) } } # [doc = "dedicated clocks configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dckcfgr2 (pub u32) ; impl Dckcfgr2 { # [doc = "USART 1 clock source selection"]
pub const fn usart1sel (& self) -> super :: vals :: Usart1sel { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Usart1sel (val as u8) } # [doc = "USART 1 clock source selection"]
pub fn set_usart1sel (& mut self , val : super :: vals :: Usart1sel) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "USART 2 clock source selection"]
pub const fn usart2sel (& self) -> super :: vals :: Usart2sel { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Usart2sel (val as u8) } # [doc = "USART 2 clock source selection"]
pub fn set_usart2sel (& mut self , val : super :: vals :: Usart2sel) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "USART 3 clock source selection"]
pub const fn usart3sel (& self) -> super :: vals :: Usart2sel { let val = (self . 0 >> 4usize) & 0x03 ; super :: vals :: Usart2sel (val as u8) } # [doc = "USART 3 clock source selection"]
pub fn set_usart3sel (& mut self , val : super :: vals :: Usart2sel) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val . 0 as u32) & 0x03) << 4usize) ; } # [doc = "UART 4 clock source selection"]
pub const fn uart4sel (& self) -> super :: vals :: Usart2sel { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: Usart2sel (val as u8) } # [doc = "UART 4 clock source selection"]
pub fn set_uart4sel (& mut self , val : super :: vals :: Usart2sel) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "UART 5 clock source selection"]
pub const fn uart5sel (& self) -> super :: vals :: Usart2sel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Usart2sel (val as u8) } # [doc = "UART 5 clock source selection"]
pub fn set_uart5sel (& mut self , val : super :: vals :: Usart2sel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "USART 6 clock source selection"]
pub const fn usart6sel (& self) -> super :: vals :: Usart1sel { let val = (self . 0 >> 10usize) & 0x03 ; super :: vals :: Usart1sel (val as u8) } # [doc = "USART 6 clock source selection"]
pub fn set_usart6sel (& mut self , val : super :: vals :: Usart1sel) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val . 0 as u32) & 0x03) << 10usize) ; } # [doc = "UART 7 clock source selection"]
pub const fn uart7sel (& self) -> super :: vals :: Usart2sel { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Usart2sel (val as u8) } # [doc = "UART 7 clock source selection"]
pub fn set_uart7sel (& mut self , val : super :: vals :: Usart2sel) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "UART 8 clock source selection"]
pub const fn uart8sel (& self) -> super :: vals :: Usart2sel { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: Usart2sel (val as u8) } # [doc = "UART 8 clock source selection"]
pub fn set_uart8sel (& mut self , val : super :: vals :: Usart2sel) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } # [doc = "I2C1 clock source selection"]
pub const fn i2c1sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C1 clock source selection"]
pub fn set_i2c1sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "I2C2 clock source selection"]
pub const fn i2c2sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 18usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C2 clock source selection"]
pub fn set_i2c2sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val . 0 as u32) & 0x03) << 18usize) ; } # [doc = "I2C3 clock source selection"]
pub const fn i2c3sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C3 clock source selection"]
pub fn set_i2c3sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "I2C4 clock source selection"]
pub const fn i2c4sel (& self) -> super :: vals :: Icsel { let val = (self . 0 >> 22usize) & 0x03 ; super :: vals :: Icsel (val as u8) } # [doc = "I2C4 clock source selection"]
pub fn set_i2c4sel (& mut self , val : super :: vals :: Icsel) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val . 0 as u32) & 0x03) << 22usize) ; } # [doc = "Low power timer 1 clock source selection"]
pub const fn lptim1sel (& self) -> super :: vals :: Lptimsel { let val = (self . 0 >> 24usize) & 0x03 ; super :: vals :: Lptimsel (val as u8) } # [doc = "Low power timer 1 clock source selection"]
pub fn set_lptim1sel (& mut self , val : super :: vals :: Lptimsel) { self . 0 = (self . 0 & ! (0x03 << 24usize)) | (((val . 0 as u32) & 0x03) << 24usize) ; } # [doc = "HDMI-CEC clock source selection"]
pub const fn cecsel (& self) -> super :: vals :: Cecsel { let val = (self . 0 >> 26usize) & 0x01 ; super :: vals :: Cecsel (val as u8) } # [doc = "HDMI-CEC clock source selection"]
pub fn set_cecsel (& mut self , val : super :: vals :: Cecsel) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val . 0 as u32) & 0x01) << 26usize) ; } # [doc = "48MHz clock source selection"]
pub const fn ck48msel (& self) -> super :: vals :: Ckmsel { let val = (self . 0 >> 27usize) & 0x01 ; super :: vals :: Ckmsel (val as u8) } # [doc = "48MHz clock source selection"]
pub fn set_ck48msel (& mut self , val : super :: vals :: Ckmsel) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val . 0 as u32) & 0x01) << 27usize) ; } # [doc = "SDMMC1 clock source selection"]
pub const fn sdmmc1sel (& self) -> super :: vals :: Sdmmcsel { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: Sdmmcsel (val as u8) } # [doc = "SDMMC1 clock source selection"]
pub fn set_sdmmc1sel (& mut self , val : super :: vals :: Sdmmcsel) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } # [doc = "SDMMC2 clock source selection"]
pub const fn sdmmc2sel (& self) -> super :: vals :: Sdmmcsel { let val = (self . 0 >> 29usize) & 0x01 ; super :: vals :: Sdmmcsel (val as u8) } # [doc = "SDMMC2 clock source selection"]
pub fn set_sdmmc2sel (& mut self , val : super :: vals :: Sdmmcsel) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val . 0 as u32) & 0x01) << 29usize) ; } # [doc = "DSI clock source selection"]
pub const fn dsisel (& self) -> super :: vals :: Dsisel { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: Dsisel (val as u8) } # [doc = "DSI clock source selection"]
pub fn set_dsisel (& mut self , val : super :: vals :: Dsisel) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } } impl Default for Dckcfgr2 { fn default () -> Dckcfgr2 { Dckcfgr2 (0) } } # [doc = "AHB1 peripheral clock register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1enr (pub u32) ; impl Ahb1enr { # [doc = "IO port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F clock enable"]
pub const fn gpiofen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F clock enable"]
pub fn set_gpiofen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G clock enable"]
pub const fn gpiogen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G clock enable"]
pub fn set_gpiogen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I clock enable"]
pub const fn gpioien (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I clock enable"]
pub fn set_gpioien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "IO port J clock enable"]
pub const fn gpiojen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "IO port J clock enable"]
pub fn set_gpiojen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "IO port K clock enable"]
pub const fn gpioken (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "IO port K clock enable"]
pub fn set_gpioken (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Backup SRAM interface clock enable"]
pub const fn bkpsramen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Backup SRAM interface clock enable"]
pub fn set_bkpsramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "CCM data RAM clock enable"]
pub const fn dtcmramen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "CCM data RAM clock enable"]
pub fn set_dtcmramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "DMA2D clock enable"]
pub const fn dma2den (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "DMA2D clock enable"]
pub fn set_dma2den (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Ethernet MAC clock enable"]
pub const fn ethen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC clock enable"]
pub fn set_ethen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Ethernet Transmission clock enable"]
pub const fn ethtxen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Ethernet Transmission clock enable"]
pub fn set_ethtxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Ethernet Reception clock enable"]
pub const fn ethrxen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Ethernet Reception clock enable"]
pub fn set_ethrxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Ethernet PTP clock enable"]
pub const fn ethptpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Ethernet PTP clock enable"]
pub fn set_ethptpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "USB OTG HS clock enable"]
pub const fn usb_otg_hsen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS clock enable"]
pub fn set_usb_otg_hsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "USB OTG HSULPI clock enable"]
pub const fn usb_otg_hsulpien (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "USB OTG HSULPI clock enable"]
pub fn set_usb_otg_hsulpien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Ahb1enr { fn default () -> Ahb1enr { Ahb1enr (0) } } # [doc = "AHB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2enr (pub u32) ; impl Ahb2enr { # [doc = "Camera interface enable"]
pub const fn dcmien (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Camera interface enable"]
pub fn set_dcmien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "JPEG enable"]
pub const fn jpegen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "JPEG enable"]
pub fn set_jpegen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "AES module clock enable"]
pub const fn aesen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "AES module clock enable"]
pub fn set_aesen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Cryptographic modules clock enable"]
pub const fn crypen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Cryptographic modules clock enable"]
pub fn set_crypen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Hash modules clock enable"]
pub const fn hashen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Hash modules clock enable"]
pub fn set_hashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Random number generator clock enable"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Random number generator clock enable"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USB OTG FS clock enable"]
pub const fn usb_otg_fsen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USB OTG FS clock enable"]
pub fn set_usb_otg_fsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2enr { fn default () -> Ahb2enr { Ahb2enr (0) } } # [doc = "clock interrupt register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cir (pub u32) ; impl Cir { # [doc = "LSI ready interrupt flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI ready interrupt flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE ready interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Main PLL (PLL) ready interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Main PLL (PLL) ready interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLLI2S ready interrupt flag"]
pub const fn plli2srdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLLI2S ready interrupt flag"]
pub fn set_plli2srdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLLSAI ready interrupt flag"]
pub const fn pllsairdyf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "PLLSAI ready interrupt flag"]
pub fn set_pllsairdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Clock security system interrupt flag"]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt flag"]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LSI ready interrupt enable"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt enable"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE ready interrupt enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI ready interrupt enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSE ready interrupt enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Main PLL (PLL) ready interrupt enable"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Main PLL (PLL) ready interrupt enable"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "PLLI2S ready interrupt enable"]
pub const fn plli2srdyie (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "PLLI2S ready interrupt enable"]
pub fn set_plli2srdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "PLLSAI Ready Interrupt Enable"]
pub const fn pllsairdyie (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "PLLSAI Ready Interrupt Enable"]
pub fn set_pllsairdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "LSI ready interrupt clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "LSE ready interrupt clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSI ready interrupt clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSE ready interrupt clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Main PLL(PLL) ready interrupt clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Main PLL(PLL) ready interrupt clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "PLLI2S ready interrupt clear"]
pub const fn plli2srdyc (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "PLLI2S ready interrupt clear"]
pub fn set_plli2srdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "PLLSAI Ready Interrupt Clear"]
pub const fn pllsairdyc (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "PLLSAI Ready Interrupt Clear"]
pub fn set_pllsairdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Clock security system interrupt clear"]
pub const fn cssc (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt clear"]
pub fn set_cssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cir { fn default () -> Cir { Cir (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpre (pub u8) ; impl Hpre { # [doc = "SYSCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "SYSCLK divided by 2"]
pub const DIV2 : Self = Self (0x08) ; # [doc = "SYSCLK divided by 4"]
pub const DIV4 : Self = Self (0x09) ; # [doc = "SYSCLK divided by 8"]
pub const DIV8 : Self = Self (0x0a) ; # [doc = "SYSCLK divided by 16"]
pub const DIV16 : Self = Self (0x0b) ; # [doc = "SYSCLK divided by 64"]
pub const DIV64 : Self = Self (0x0c) ; # [doc = "SYSCLK divided by 128"]
pub const DIV128 : Self = Self (0x0d) ; # [doc = "SYSCLK divided by 256"]
pub const DIV256 : Self = Self (0x0e) ; # [doc = "SYSCLK divided by 512"]
pub const DIV512 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcopre (pub u8) ; impl Mcopre { # [doc = "No division"]
pub const DIV1 : Self = Self (0) ; # [doc = "Division by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "Division by 3"]
pub const DIV3 : Self = Self (0x05) ; # [doc = "Division by 4"]
pub const DIV4 : Self = Self (0x06) ; # [doc = "Division by 5"]
pub const DIV5 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cecsel (pub u8) ; impl Cecsel { # [doc = "LSE clock is selected as HDMI-CEC clock"]
pub const LSE : Self = Self (0) ; # [doc = "HSI divided by 488 clock is selected as HDMI-CEC clock"]
pub const HSI_DIV488 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Saisel (pub u8) ; impl Saisel { # [doc = "SAI2 clock frequency = f(PLLSAI_Q) / PLLSAIDIVQ"]
pub const PLLSAI : Self = Self (0) ; # [doc = "SAI2 clock frequency = f(PLLI2S_Q) / PLLI2SDIVQ"]
pub const PLLI2S : Self = Self (0x01) ; # [doc = "SAI2 clock frequency = Alternate function input frequency"]
pub const AFIF : Self = Self (0x02) ; # [doc = "SAI2 clock frequency = HSI or HSE"]
pub const HSI_HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sw (pub u8) ; impl Sw { # [doc = "HSI selected as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE selected as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL selected as system clock"]
pub const PLL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usart1sel (pub u8) ; impl Usart1sel { # [doc = "APB2 clock (PCLK2) is selected as USART clock"]
pub const APB2 : Self = Self (0) ; # [doc = "System clock is selected as USART clock"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI clock is selected as USART clock"]
pub const HSI : Self = Self (0x02) ; # [doc = "LSE clock is selected as USART clock"]
pub const LSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsrc (pub u8) ; impl Pllsrc { # [doc = "HSI clock selected as PLL and PLLI2S clock entry"]
pub const HSI : Self = Self (0) ; # [doc = "HSE oscillator clock selected as PLL and PLLI2S clock entry"]
pub const HSE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swsr (pub u8) ; impl Swsr { # [doc = "HSI oscillator used as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE oscillator used as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL used as system clock"]
pub const PLL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsaidivq (pub u8) ; impl Pllsaidivq { # [doc = "PLLSAIDIVQ = /1"]
pub const DIV1 : Self = Self (0) ; # [doc = "PLLSAIDIVQ = /2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "PLLSAIDIVQ = /3"]
pub const DIV3 : Self = Self (0x02) ; # [doc = "PLLSAIDIVQ = /4"]
pub const DIV4 : Self = Self (0x03) ; # [doc = "PLLSAIDIVQ = /5"]
pub const DIV5 : Self = Self (0x04) ; # [doc = "PLLSAIDIVQ = /6"]
pub const DIV6 : Self = Self (0x05) ; # [doc = "PLLSAIDIVQ = /7"]
pub const DIV7 : Self = Self (0x06) ; # [doc = "PLLSAIDIVQ = /8"]
pub const DIV8 : Self = Self (0x07) ; # [doc = "PLLSAIDIVQ = /9"]
pub const DIV9 : Self = Self (0x08) ; # [doc = "PLLSAIDIVQ = /10"]
pub const DIV10 : Self = Self (0x09) ; # [doc = "PLLSAIDIVQ = /11"]
pub const DIV11 : Self = Self (0x0a) ; # [doc = "PLLSAIDIVQ = /12"]
pub const DIV12 : Self = Self (0x0b) ; # [doc = "PLLSAIDIVQ = /13"]
pub const DIV13 : Self = Self (0x0c) ; # [doc = "PLLSAIDIVQ = /14"]
pub const DIV14 : Self = Self (0x0d) ; # [doc = "PLLSAIDIVQ = /15"]
pub const DIV15 : Self = Self (0x0e) ; # [doc = "PLLSAIDIVQ = /16"]
pub const DIV16 : Self = Self (0x0f) ; # [doc = "PLLSAIDIVQ = /17"]
pub const DIV17 : Self = Self (0x10) ; # [doc = "PLLSAIDIVQ = /18"]
pub const DIV18 : Self = Self (0x11) ; # [doc = "PLLSAIDIVQ = /19"]
pub const DIV19 : Self = Self (0x12) ; # [doc = "PLLSAIDIVQ = /20"]
pub const DIV20 : Self = Self (0x13) ; # [doc = "PLLSAIDIVQ = /21"]
pub const DIV21 : Self = Self (0x14) ; # [doc = "PLLSAIDIVQ = /22"]
pub const DIV22 : Self = Self (0x15) ; # [doc = "PLLSAIDIVQ = /23"]
pub const DIV23 : Self = Self (0x16) ; # [doc = "PLLSAIDIVQ = /24"]
pub const DIV24 : Self = Self (0x17) ; # [doc = "PLLSAIDIVQ = /25"]
pub const DIV25 : Self = Self (0x18) ; # [doc = "PLLSAIDIVQ = /26"]
pub const DIV26 : Self = Self (0x19) ; # [doc = "PLLSAIDIVQ = /27"]
pub const DIV27 : Self = Self (0x1a) ; # [doc = "PLLSAIDIVQ = /28"]
pub const DIV28 : Self = Self (0x1b) ; # [doc = "PLLSAIDIVQ = /29"]
pub const DIV29 : Self = Self (0x1c) ; # [doc = "PLLSAIDIVQ = /30"]
pub const DIV30 : Self = Self (0x1d) ; # [doc = "PLLSAIDIVQ = /31"]
pub const DIV31 : Self = Self (0x1e) ; # [doc = "PLLSAIDIVQ = /32"]
pub const DIV32 : Self = Self (0x1f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ckmsel (pub u8) ; impl Ckmsel { # [doc = "48MHz clock from PLL is selected"]
pub const PLL : Self = Self (0) ; # [doc = "48MHz clock from PLLSAI is selected"]
pub const PLLSAI : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ppre (pub u8) ; impl Ppre { # [doc = "HCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HCLK divided by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "HCLK divided by 4"]
pub const DIV4 : Self = Self (0x05) ; # [doc = "HCLK divided by 8"]
pub const DIV8 : Self = Self (0x06) ; # [doc = "HCLK divided by 16"]
pub const DIV16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllisdivq (pub u8) ; impl Pllisdivq { # [doc = "PLLI2SDIVQ = /1"]
pub const DIV1 : Self = Self (0) ; # [doc = "PLLI2SDIVQ = /2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "PLLI2SDIVQ = /3"]
pub const DIV3 : Self = Self (0x02) ; # [doc = "PLLI2SDIVQ = /4"]
pub const DIV4 : Self = Self (0x03) ; # [doc = "PLLI2SDIVQ = /5"]
pub const DIV5 : Self = Self (0x04) ; # [doc = "PLLI2SDIVQ = /6"]
pub const DIV6 : Self = Self (0x05) ; # [doc = "PLLI2SDIVQ = /7"]
pub const DIV7 : Self = Self (0x06) ; # [doc = "PLLI2SDIVQ = /8"]
pub const DIV8 : Self = Self (0x07) ; # [doc = "PLLI2SDIVQ = /9"]
pub const DIV9 : Self = Self (0x08) ; # [doc = "PLLI2SDIVQ = /10"]
pub const DIV10 : Self = Self (0x09) ; # [doc = "PLLI2SDIVQ = /11"]
pub const DIV11 : Self = Self (0x0a) ; # [doc = "PLLI2SDIVQ = /12"]
pub const DIV12 : Self = Self (0x0b) ; # [doc = "PLLI2SDIVQ = /13"]
pub const DIV13 : Self = Self (0x0c) ; # [doc = "PLLI2SDIVQ = /14"]
pub const DIV14 : Self = Self (0x0d) ; # [doc = "PLLI2SDIVQ = /15"]
pub const DIV15 : Self = Self (0x0e) ; # [doc = "PLLI2SDIVQ = /16"]
pub const DIV16 : Self = Self (0x0f) ; # [doc = "PLLI2SDIVQ = /17"]
pub const DIV17 : Self = Self (0x10) ; # [doc = "PLLI2SDIVQ = /18"]
pub const DIV18 : Self = Self (0x11) ; # [doc = "PLLI2SDIVQ = /19"]
pub const DIV19 : Self = Self (0x12) ; # [doc = "PLLI2SDIVQ = /20"]
pub const DIV20 : Self = Self (0x13) ; # [doc = "PLLI2SDIVQ = /21"]
pub const DIV21 : Self = Self (0x14) ; # [doc = "PLLI2SDIVQ = /22"]
pub const DIV22 : Self = Self (0x15) ; # [doc = "PLLI2SDIVQ = /23"]
pub const DIV23 : Self = Self (0x16) ; # [doc = "PLLI2SDIVQ = /24"]
pub const DIV24 : Self = Self (0x17) ; # [doc = "PLLI2SDIVQ = /25"]
pub const DIV25 : Self = Self (0x18) ; # [doc = "PLLI2SDIVQ = /26"]
pub const DIV26 : Self = Self (0x19) ; # [doc = "PLLI2SDIVQ = /27"]
pub const DIV27 : Self = Self (0x1a) ; # [doc = "PLLI2SDIVQ = /28"]
pub const DIV28 : Self = Self (0x1b) ; # [doc = "PLLI2SDIVQ = /29"]
pub const DIV29 : Self = Self (0x1c) ; # [doc = "PLLI2SDIVQ = /30"]
pub const DIV30 : Self = Self (0x1d) ; # [doc = "PLLI2SDIVQ = /31"]
pub const DIV31 : Self = Self (0x1e) ; # [doc = "PLLI2SDIVQ = /32"]
pub const DIV32 : Self = Self (0x1f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Issrc (pub u8) ; impl Issrc { # [doc = "PLLI2S clock used as I2S clock source"]
pub const PLLI2S : Self = Self (0) ; # [doc = "External clock mapped on the I2S_CKIN pin used as I2S clock source"]
pub const CKIN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icsel (pub u8) ; impl Icsel { # [doc = "APB clock selected as I2C clock"]
pub const APB : Self = Self (0) ; # [doc = "System clock selected as I2C clock"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI clock selected as I2C clock"]
pub const HSI : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spreadsel (pub u8) ; impl Spreadsel { # [doc = "Center spread"]
pub const CENTER : Self = Self (0) ; # [doc = "Down spread"]
pub const DOWN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco1 (pub u8) ; impl Mco1 { # [doc = "HSI clock selected"]
pub const HSI : Self = Self (0) ; # [doc = "LSE oscillator selected"]
pub const LSE : Self = Self (0x01) ; # [doc = "HSE oscillator clock selected"]
pub const HSE : Self = Self (0x02) ; # [doc = "PLL clock selected"]
pub const PLL : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsedrv (pub u8) ; impl Lsedrv { # [doc = "Low drive capacity"]
pub const LOW : Self = Self (0) ; # [doc = "Medium-high drive capacity"]
pub const MEDIUMHIGH : Self = Self (0x01) ; # [doc = "Medium-low drive capacity"]
pub const MEDIUMLOW : Self = Self (0x02) ; # [doc = "High drive capacity"]
pub const HIGH : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dsisel (pub u8) ; impl Dsisel { # [doc = "DSI-PHY used as DSI byte lane clock source (usual case)"]
pub const DSI_PHY : Self = Self (0) ; # [doc = "PLLR used as DSI byte lane clock source, used in case DSI PLL and DSI-PHY are off (low power mode)"]
pub const PLLR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usart2sel (pub u8) ; impl Usart2sel { # [doc = "APB1 clock (PCLK1) is selected as USART clock"]
pub const APB1 : Self = Self (0) ; # [doc = "System clock is selected as USART clock"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "HSI clock is selected as USART clock"]
pub const HSI : Self = Self (0x02) ; # [doc = "LSE clock is selected as USART clock"]
pub const LSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lptimsel (pub u8) ; impl Lptimsel { # [doc = "APB1 clock (PCLK1) selected as LPTILM1 clock"]
pub const APB1 : Self = Self (0) ; # [doc = "LSI clock is selected as LPTILM1 clock"]
pub const LSI : Self = Self (0x01) ; # [doc = "HSI clock is selected as LPTILM1 clock"]
pub const HSI : Self = Self (0x02) ; # [doc = "LSE clock is selected as LPTILM1 clock"]
pub const LSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllp (pub u8) ; impl Pllp { # [doc = "PLLP=2"]
pub const DIV2 : Self = Self (0) ; # [doc = "PLLP=4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "PLLP=6"]
pub const DIV6 : Self = Self (0x02) ; # [doc = "PLLP=8"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dfsdmsel (pub u8) ; impl Dfsdmsel { # [doc = "APB2 clock (PCLK2) selected as DFSDM1 Kernel clock source"]
pub const APB2 : Self = Self (0) ; # [doc = "System clock (SYSCLK) clock selected as DFSDM1 Kernel clock source"]
pub const SYSCLK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Timpre (pub u8) ; impl Timpre { # [doc = "If the APB prescaler is configured 1, TIMxCLK = PCLKx. Otherwise, TIMxCLK = 2xPCLKx"]
pub const MUL2 : Self = Self (0) ; # [doc = "If the APB prescaler is configured 1, 2 or 4, TIMxCLK = HCLK. Otherwise, TIMxCLK = 4xPCLKx"]
pub const MUL4 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsaip (pub u8) ; impl Pllsaip { # [doc = "PLL*P=2"]
pub const DIV2 : Self = Self (0) ; # [doc = "PLL*P=4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "PLL*P=6"]
pub const DIV6 : Self = Self (0x02) ; # [doc = "PLL*P=8"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sdmmcsel (pub u8) ; impl Sdmmcsel { # [doc = "48 MHz clock is selected as SD clock"]
pub const CK48M : Self = Self (0) ; # [doc = "System clock is selected as SD clock"]
pub const SYSCLK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllisp (pub u8) ; impl Pllisp { # [doc = "PLL*P=2"]
pub const DIV2 : Self = Self (0) ; # [doc = "PLL*P=4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "PLL*P=6"]
pub const DIV6 : Self = Self (0x02) ; # [doc = "PLL*P=8"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adfsdmsel (pub u8) ; impl Adfsdmsel { # [doc = "SAI1 clock selected as DFSDM1 Audio clock source"]
pub const SAI1 : Self = Self (0) ; # [doc = "SAI2 clock selected as DFSDM1 Audio clock source"]
pub const SAI2 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco2 (pub u8) ; impl Mco2 { # [doc = "System clock (SYSCLK) selected"]
pub const SYSCLK : Self = Self (0) ; # [doc = "PLLI2S clock selected"]
pub const PLLI2S : Self = Self (0x01) ; # [doc = "HSE oscillator clock selected"]
pub const HSE : Self = Self (0x02) ; # [doc = "PLL clock selected"]
pub const PLL : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcsel (pub u8) ; impl Rtcsel { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "LSE oscillator clock used as RTC clock"]
pub const LSE : Self = Self (0x01) ; # [doc = "LSI oscillator clock used as RTC clock"]
pub const LSI : Self = Self (0x02) ; # [doc = "HSE oscillator clock divided by a prescaler used as RTC clock"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsaidivr (pub u8) ; impl Pllsaidivr { # [doc = "PLLSAIDIVR = /2"]
pub const DIV2 : Self = Self (0) ; # [doc = "PLLSAIDIVR = /4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "PLLSAIDIVR = /8"]
pub const DIV8 : Self = Self (0x02) ; # [doc = "PLLSAIDIVR = /16"]
pub const DIV16 : Self = Self (0x03) ; } }