

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "Clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Clock configuration register (RCC_CFGR)"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Clock interrupt register (RCC_CIR)"]
pub fn cir (self) -> crate :: common :: Reg < regs :: Cir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "APB2 peripheral reset register (RCC_APB2RSTR)"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "APB1 peripheral reset register (RCC_APB1RSTR)"]
pub fn apb1rstr (self) -> crate :: common :: Reg < regs :: Apb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "AHB Peripheral Clock enable register (RCC_AHBENR)"]
pub fn ahbenr (self) -> crate :: common :: Reg < regs :: Ahbenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "APB2 peripheral clock enable register (RCC_APB2ENR)"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "APB1 peripheral clock enable register (RCC_APB1ENR)"]
pub fn apb1enr (self) -> crate :: common :: Reg < regs :: Apb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Backup domain control register (RCC_BDCR)"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Control/status register (RCC_CSR)"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "AHB peripheral reset register"]
pub fn ahbrstr (self) -> crate :: common :: Reg < regs :: Ahbrstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "Clock configuration register 2"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "Clock configuration register 3"]
pub fn cfgr3 (self) -> crate :: common :: Reg < regs :: Cfgr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } } pub mod regs { # [doc = "Clock configuration register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr3 (pub u32) ; impl Cfgr3 { # [doc = "USART1 clock source selection"]
pub const fn usart1sw (& self) -> super :: vals :: Usartsw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Usartsw (val as u8) } # [doc = "USART1 clock source selection"]
pub fn set_usart1sw (& mut self , val : super :: vals :: Usartsw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "I2C1 clock source selection"]
pub const fn i2c1sw (& self) -> super :: vals :: Icsw { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Icsw (val as u8) } # [doc = "I2C1 clock source selection"]
pub fn set_i2c1sw (& mut self , val : super :: vals :: Icsw) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "I2C2 clock source selection"]
pub const fn i2c2sw (& self) -> super :: vals :: Icsw { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Icsw (val as u8) } # [doc = "I2C2 clock source selection"]
pub fn set_i2c2sw (& mut self , val : super :: vals :: Icsw) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "HDMI CEC clock source selection"]
pub const fn cecsw (& self) -> super :: vals :: Cecsw { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Cecsw (val as u8) } # [doc = "HDMI CEC clock source selection"]
pub fn set_cecsw (& mut self , val : super :: vals :: Cecsw) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "I2C3 clock source selection"]
pub const fn i2c3sw (& self) -> super :: vals :: Icsw { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Icsw (val as u8) } # [doc = "I2C3 clock source selection"]
pub fn set_i2c3sw (& mut self , val : super :: vals :: Icsw) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Timer1 clock source selection"]
pub const fn tim1sw (& self) -> super :: vals :: Timsw { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Timsw (val as u8) } # [doc = "Timer1 clock source selection"]
pub fn set_tim1sw (& mut self , val : super :: vals :: Timsw) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Timer8 clock source selection"]
pub const fn tim8sw (& self) -> super :: vals :: Timsw { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Timsw (val as u8) } # [doc = "Timer8 clock source selection"]
pub fn set_tim8sw (& mut self , val : super :: vals :: Timsw) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Timer15 clock source selection"]
pub const fn tim15sw (& self) -> super :: vals :: Timsw { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Timsw (val as u8) } # [doc = "Timer15 clock source selection"]
pub fn set_tim15sw (& mut self , val : super :: vals :: Timsw) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Timer16 clock source selection"]
pub const fn tim16sw (& self) -> super :: vals :: Timsw { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Timsw (val as u8) } # [doc = "Timer16 clock source selection"]
pub fn set_tim16sw (& mut self , val : super :: vals :: Timsw) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Timer17 clock source selection"]
pub const fn tim17sw (& self) -> super :: vals :: Timsw { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Timsw (val as u8) } # [doc = "Timer17 clock source selection"]
pub fn set_tim17sw (& mut self , val : super :: vals :: Timsw) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Timer20 clock source selection"]
pub const fn tim20sw (& self) -> super :: vals :: Timsw { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Timsw (val as u8) } # [doc = "Timer20 clock source selection"]
pub fn set_tim20sw (& mut self , val : super :: vals :: Timsw) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "USART2 clock source selection"]
pub const fn usart2sw (& self) -> super :: vals :: Usartsw { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Usartsw (val as u8) } # [doc = "USART2 clock source selection"]
pub fn set_usart2sw (& mut self , val : super :: vals :: Usartsw) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "USART3 clock source selection"]
pub const fn usart3sw (& self) -> super :: vals :: Usartsw { let val = (self . 0 >> 18usize) & 0x03 ; super :: vals :: Usartsw (val as u8) } # [doc = "USART3 clock source selection"]
pub fn set_usart3sw (& mut self , val : super :: vals :: Usartsw) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val . 0 as u32) & 0x03) << 18usize) ; } # [doc = "UART4 clock source selection"]
pub const fn uart4sw (& self) -> super :: vals :: Usartsw { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Usartsw (val as u8) } # [doc = "UART4 clock source selection"]
pub fn set_uart4sw (& mut self , val : super :: vals :: Usartsw) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "UART5 clock source selection"]
pub const fn uart5sw (& self) -> super :: vals :: Usartsw { let val = (self . 0 >> 22usize) & 0x03 ; super :: vals :: Usartsw (val as u8) } # [doc = "UART5 clock source selection"]
pub fn set_uart5sw (& mut self , val : super :: vals :: Usartsw) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val . 0 as u32) & 0x03) << 22usize) ; } # [doc = "Timer2 clock source selection"]
pub const fn tim2sw (& self) -> super :: vals :: Timsw { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Timsw (val as u8) } # [doc = "Timer2 clock source selection"]
pub fn set_tim2sw (& mut self , val : super :: vals :: Timsw) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "Timer34 clock source selection"]
pub const fn tim34sw (& self) -> super :: vals :: Timsw { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Timsw (val as u8) } # [doc = "Timer34 clock source selection"]
pub fn set_tim34sw (& mut self , val : super :: vals :: Timsw) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } } impl Default for Cfgr3 { fn default () -> Cfgr3 { Cfgr3 (0) } } # [doc = "AHB peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbrstr (pub u32) ; impl Ahbrstr { # [doc = "FMC reset"]
pub const fn fmcrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "FMC reset"]
pub fn set_fmcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port H reset"]
pub const fn gpiohrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "IO port H reset"]
pub fn set_gpiohrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "I/O port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "I/O port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "I/O port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "I/O port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "I/O port C reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "I/O port C reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "I/O port D reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "I/O port D reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I/O port E reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I/O port E reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I/O port F reset"]
pub const fn gpiofrst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I/O port F reset"]
pub fn set_gpiofrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "IO port G reset"]
pub const fn gpiogrst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "IO port G reset"]
pub fn set_gpiogrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Touch sensing controller reset"]
pub const fn tscrst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Touch sensing controller reset"]
pub fn set_tscrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "ADC1 and ADC2 reset"]
pub const fn adc12rst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "ADC1 and ADC2 reset"]
pub fn set_adc12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "ADC1 reset"]
pub const fn adc1rst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "ADC1 reset"]
pub fn set_adc1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "ADC3 and ADC4 reset"]
pub const fn adc34rst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "ADC3 and ADC4 reset"]
pub fn set_adc34rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Ahbrstr { fn default () -> Ahbrstr { Ahbrstr (0) } } # [doc = "Backup domain control register (RCC_BDCR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "External Low Speed oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "External Low Speed oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External Low Speed oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "LSE oscillator drive capability"]
pub const fn lsedrv (& self) -> super :: vals :: Lsedrv { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Lsedrv (val as u8) } # [doc = "LSE oscillator drive capability"]
pub fn set_lsedrv (& mut self , val : super :: vals :: Lsedrv) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> super :: vals :: Rtcsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Rtcsel (val as u8) } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : super :: vals :: Rtcsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Backup domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "APB1 peripheral clock enable register (RCC_APB1ENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr (pub u32) ; impl Apb1enr { # [doc = "Timer 2 clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer 2 clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 clock enable"]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 clock enable"]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 4 clock enable"]
pub const fn tim4en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Timer 4 clock enable"]
pub fn set_tim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Timer 5 clock enable"]
pub const fn tim5en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Timer 5 clock enable"]
pub fn set_tim5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Timer 6 clock enable"]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 clock enable"]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Timer 7 clock enable"]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Timer 7 clock enable"]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Timer 12 clock enable"]
pub const fn tim12en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Timer 12 clock enable"]
pub fn set_tim12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Timer 13 clock enable"]
pub const fn tim13en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Timer 13 clock enable"]
pub fn set_tim13en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Timer 14 clock enable"]
pub const fn tim14en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Timer 14 clock enable"]
pub fn set_tim14en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Timer 18 clock enable"]
pub const fn tim18en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Timer 18 clock enable"]
pub fn set_tim18en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI 2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI 3 clock enable"]
pub const fn spi3en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI 3 clock enable"]
pub fn set_spi3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART 2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART 3 clock enable"]
pub const fn usart3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART 3 clock enable"]
pub fn set_usart3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clock enable"]
pub const fn uart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clock enable"]
pub fn set_uart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clock enable"]
pub const fn uart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clock enable"]
pub fn set_uart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C 1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C 1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C 2 clock enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C 2 clock enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB clock enable"]
pub const fn usben (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB clock enable"]
pub fn set_usben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN clock enable"]
pub const fn canen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN clock enable"]
pub fn set_canen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "DAC2 interface clock enable"]
pub const fn dac2en (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "DAC2 interface clock enable"]
pub fn set_dac2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Power interface clock enable"]
pub const fn pwren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable"]
pub fn set_pwren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable"]
pub const fn dac1en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable"]
pub fn set_dac1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "HDMI CEC interface clock enable"]
pub const fn cecen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "HDMI CEC interface clock enable"]
pub fn set_cecen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "I2C3 clock enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Apb1enr { fn default () -> Apb1enr { Apb1enr (0) } } # [doc = "Clock configuration register (RCC_CFGR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock Switch"]
pub const fn sw (& self) -> super :: vals :: Sw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "System clock Switch"]
pub fn set_sw (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "System Clock Switch Status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "System Clock Switch Status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "AHB prescaler"]
pub const fn hpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 4usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "AHB prescaler"]
pub fn set_hpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val . 0 as u32) & 0x0f) << 4usize) ; } # [doc = "APB Low speed prescaler (APB1)"]
pub const fn ppre1 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 8usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB Low speed prescaler (APB1)"]
pub fn set_ppre1 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val . 0 as u32) & 0x07) << 8usize) ; } # [doc = "APB high speed prescaler (APB2)"]
pub const fn ppre2 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 11usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB high speed prescaler (APB2)"]
pub fn set_ppre2 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 11usize)) | (((val . 0 as u32) & 0x07) << 11usize) ; } # [doc = "ADC prescaler"]
pub const fn adcpre (& self) -> super :: vals :: Adcpre { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: Adcpre (val as u8) } # [doc = "ADC prescaler"]
pub fn set_adcpre (& mut self , val : super :: vals :: Adcpre) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } # [doc = "PLL entry clock source"]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 15usize) & 0x03 ; super :: vals :: Pllsrc (val as u8) } # [doc = "PLL entry clock source"]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val . 0 as u32) & 0x03) << 15usize) ; } # [doc = "HSE divider for PLL entry"]
pub const fn pllxtpre (& self) -> super :: vals :: Pllxtpre { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Pllxtpre (val as u8) } # [doc = "HSE divider for PLL entry"]
pub fn set_pllxtpre (& mut self , val : super :: vals :: Pllxtpre) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "PLL Multiplication Factor"]
pub const fn pllmul (& self) -> super :: vals :: Pllmul { let val = (self . 0 >> 18usize) & 0x0f ; super :: vals :: Pllmul (val as u8) } # [doc = "PLL Multiplication Factor"]
pub fn set_pllmul (& mut self , val : super :: vals :: Pllmul) { self . 0 = (self . 0 & ! (0x0f << 18usize)) | (((val . 0 as u32) & 0x0f) << 18usize) ; } # [doc = "USB prescaler"]
pub const fn usbpre (& self) -> super :: vals :: Usbpre { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Usbpre (val as u8) } # [doc = "USB prescaler"]
pub fn set_usbpre (& mut self , val : super :: vals :: Usbpre) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "I2S external clock source selection"]
pub const fn i2ssrc (& self) -> super :: vals :: Issrc { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Issrc (val as u8) } # [doc = "I2S external clock source selection"]
pub fn set_i2ssrc (& mut self , val : super :: vals :: Issrc) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "Microcontroller clock output"]
pub const fn mco (& self) -> super :: vals :: Mco { let val = (self . 0 >> 24usize) & 0x07 ; super :: vals :: Mco (val as u8) } # [doc = "Microcontroller clock output"]
pub fn set_mco (& mut self , val : super :: vals :: Mco) { self . 0 = (self . 0 & ! (0x07 << 24usize)) | (((val . 0 as u32) & 0x07) << 24usize) ; } # [doc = "SDADC prescaler"]
pub const fn sdpre (& self) -> super :: vals :: Sdpre { let val = (self . 0 >> 27usize) & 0x1f ; super :: vals :: Sdpre (val as u8) } # [doc = "SDADC prescaler"]
pub fn set_sdpre (& mut self , val : super :: vals :: Sdpre) { self . 0 = (self . 0 & ! (0x1f << 27usize)) | (((val . 0 as u32) & 0x1f) << 27usize) ; } # [doc = "Microcontroller Clock Output Prescaler"]
pub const fn mcopre (& self) -> super :: vals :: Mcopre { let val = (self . 0 >> 28usize) & 0x07 ; super :: vals :: Mcopre (val as u8) } # [doc = "Microcontroller Clock Output Prescaler"]
pub fn set_mcopre (& mut self , val : super :: vals :: Mcopre) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val . 0 as u32) & 0x07) << 28usize) ; } # [doc = "Do not divide PLL to MCO"]
pub const fn pllnodiv (& self) -> super :: vals :: Pllnodiv { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Pllnodiv (val as u8) } # [doc = "Do not divide PLL to MCO"]
pub fn set_pllnodiv (& mut self , val : super :: vals :: Pllnodiv) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "APB1 peripheral reset register (RCC_APB1RSTR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr (pub u32) ; impl Apb1rstr { # [doc = "Timer 2 reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer 2 reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 reset"]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 reset"]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 14 reset"]
pub const fn tim4rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Timer 14 reset"]
pub fn set_tim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Timer 5 reset"]
pub const fn tim5rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Timer 5 reset"]
pub fn set_tim5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Timer 6 reset"]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 reset"]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Timer 7 reset"]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Timer 7 reset"]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Timer 12 reset"]
pub const fn tim12rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Timer 12 reset"]
pub fn set_tim12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Timer 13 reset"]
pub const fn tim13rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Timer 13 reset"]
pub fn set_tim13rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Timer 14 reset"]
pub const fn tim14rst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Timer 14 reset"]
pub fn set_tim14rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Timer 18 reset"]
pub const fn tim18rst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Timer 18 reset"]
pub fn set_tim18rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Window watchdog reset"]
pub const fn wwdgrst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset"]
pub fn set_wwdgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 reset"]
pub const fn spi3rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 reset"]
pub fn set_spi3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART 2 reset"]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 reset"]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 reset"]
pub const fn usart3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 reset"]
pub fn set_usart3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART 4 reset"]
pub const fn uart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART 4 reset"]
pub fn set_uart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART 5 reset"]
pub const fn uart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART 5 reset"]
pub fn set_uart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB reset"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB reset"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN reset"]
pub const fn canrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN reset"]
pub fn set_canrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "DAC2 interface reset"]
pub const fn dac2rst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "DAC2 interface reset"]
pub fn set_dac2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Power interface reset"]
pub const fn pwrrst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface reset"]
pub fn set_pwrrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface reset"]
pub const fn dac1rst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface reset"]
pub fn set_dac1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "HDMI CEC reset"]
pub const fn cecrst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "HDMI CEC reset"]
pub fn set_cecrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "I2C3 reset"]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "I2C3 reset"]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Apb1rstr { fn default () -> Apb1rstr { Apb1rstr (0) } } # [doc = "Clock interrupt register (RCC_CIR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cir (pub u32) ; impl Cir { # [doc = "LSI Ready Interrupt flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE Ready Interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI Ready Interrupt flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE Ready Interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "PLL Ready Interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Clock Security System Interrupt flag"]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Clock Security System Interrupt flag"]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LSI Ready Interrupt Enable"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt Enable"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Ready Interrupt Enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt Enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI Ready Interrupt Enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt Enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSE Ready Interrupt Enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt Enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "PLL Ready Interrupt Enable"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt Enable"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "LSI Ready Interrupt Clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt Clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "LSE Ready Interrupt Clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt Clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSI Ready Interrupt Clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt Clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSE Ready Interrupt Clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt Clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "PLL Ready Interrupt Clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt Clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Clock security system interrupt clear"]
pub const fn cssc (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt clear"]
pub fn set_cssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cir { fn default () -> Cir { Cir (0) } } # [doc = "Clock configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "PREDIV division factor"]
pub const fn prediv (& self) -> super :: vals :: Prediv { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: Prediv (val as u8) } # [doc = "PREDIV division factor"]
pub fn set_prediv (& mut self , val : super :: vals :: Prediv) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "ADC1 and ADC2 prescaler"]
pub const fn adc12pres (& self) -> super :: vals :: Adcpres { let val = (self . 0 >> 4usize) & 0x1f ; super :: vals :: Adcpres (val as u8) } # [doc = "ADC1 and ADC2 prescaler"]
pub fn set_adc12pres (& mut self , val : super :: vals :: Adcpres) { self . 0 = (self . 0 & ! (0x1f << 4usize)) | (((val . 0 as u32) & 0x1f) << 4usize) ; } # [doc = "ADC1 prescaler"]
pub const fn adc1pres (& self) -> super :: vals :: Adcpres { let val = (self . 0 >> 4usize) & 0x1f ; super :: vals :: Adcpres (val as u8) } # [doc = "ADC1 prescaler"]
pub fn set_adc1pres (& mut self , val : super :: vals :: Adcpres) { self . 0 = (self . 0 & ! (0x1f << 4usize)) | (((val . 0 as u32) & 0x1f) << 4usize) ; } # [doc = "ADC3 and ADC4 prescaler"]
pub const fn adc34pres (& self) -> super :: vals :: Adcpres { let val = (self . 0 >> 9usize) & 0x1f ; super :: vals :: Adcpres (val as u8) } # [doc = "ADC3 and ADC4 prescaler"]
pub fn set_adc34pres (& mut self , val : super :: vals :: Adcpres) { self . 0 = (self . 0 & ! (0x1f << 9usize)) | (((val . 0 as u32) & 0x1f) << 9usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "Control/status register (RCC_CSR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Internal low speed oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal low speed oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal low speed oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal low speed oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Reset flag of the 1.8 V domain"]
pub const fn v18pwrrstf (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Reset flag of the 1.8 V domain"]
pub fn set_v18pwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Option byte loader reset flag"]
pub const fn oblrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Option byte loader reset flag"]
pub fn set_oblrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PIN reset flag"]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PIN reset flag"]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "POR/PDR reset flag"]
pub const fn porrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "POR/PDR reset flag"]
pub fn set_porrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent watchdog reset flag"]
pub const fn iwdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog reset flag"]
pub fn set_iwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "APB2 peripheral reset register (RCC_APB2RSTR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "SYSCFG and COMP reset"]
pub const fn syscfgrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYSCFG and COMP reset"]
pub fn set_syscfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "ADC interface reset"]
pub const fn adcrst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC interface reset"]
pub fn set_adcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TIM1 timer reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 timer reset"]
pub const fn tim8rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 timer reset"]
pub fn set_tim8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI4 reset"]
pub const fn spi4rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI4 reset"]
pub fn set_spi4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "TIM15 timer reset"]
pub const fn tim15rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 timer reset"]
pub fn set_tim15rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 timer reset"]
pub const fn tim16rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer reset"]
pub fn set_tim16rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer reset"]
pub const fn tim17rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer reset"]
pub fn set_tim17rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "TIM19 timer reset"]
pub const fn tim19rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "TIM19 timer reset"]
pub fn set_tim19rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "TIM20 timer reset"]
pub const fn tim20rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "TIM20 timer reset"]
pub fn set_tim20rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SDADC1 (Sigma delta ADC 1) reset"]
pub const fn sdadc1rst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SDADC1 (Sigma delta ADC 1) reset"]
pub fn set_sdadc1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "SDADC2 (Sigma delta ADC 2) reset"]
pub const fn sdadc2rst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "SDADC2 (Sigma delta ADC 2) reset"]
pub fn set_sdadc2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "SDADC3 (Sigma delta ADC 3) reset"]
pub const fn sdadc3rst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "SDADC3 (Sigma delta ADC 3) reset"]
pub fn set_sdadc3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "High Resolution Timer1 reset"]
pub const fn hrtim1rst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "High Resolution Timer1 reset"]
pub fn set_hrtim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "APB2 peripheral clock enable register (RCC_APB2ENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "SYSCFG clock enable"]
pub const fn syscfgen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYSCFG clock enable"]
pub fn set_syscfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "ADC 1 interface clock enable"]
pub const fn adcen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC 1 interface clock enable"]
pub fn set_adcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TIM1 Timer clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 Timer clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 Timer clock enable"]
pub const fn tim8en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 Timer clock enable"]
pub fn set_tim8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1 clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI4 clock enable"]
pub const fn spi4en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI4 clock enable"]
pub fn set_spi4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "TIM15 timer clock enable"]
pub const fn tim15en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 timer clock enable"]
pub fn set_tim15en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 timer clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "TIM19 timer clock enable"]
pub const fn tim19en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "TIM19 timer clock enable"]
pub fn set_tim19en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "TIM20 timer clock enable"]
pub const fn tim20en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "TIM20 timer clock enable"]
pub fn set_tim20en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "MCU debug module clock enable"]
pub const fn dbgmcuen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "MCU debug module clock enable"]
pub fn set_dbgmcuen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "SDADC1 (Sigma Delta ADC 1) clock enable"]
pub const fn sdadc1en (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SDADC1 (Sigma Delta ADC 1) clock enable"]
pub fn set_sdadc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "SDADC2 (Sigma Delta ADC 2) clock enable"]
pub const fn sdadc2en (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "SDADC2 (Sigma Delta ADC 2) clock enable"]
pub fn set_sdadc2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "SDADC3 (Sigma Delta ADC 3) clock enable"]
pub const fn sdadc3en (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "SDADC3 (Sigma Delta ADC 3) clock enable"]
pub fn set_sdadc3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "High Resolution Timer 1 clock enable"]
pub const fn hrtim1en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "High Resolution Timer 1 clock enable"]
pub fn set_hrtim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "Clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Internal High Speed clock enable"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal High Speed clock enable"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal High Speed clock ready flag"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal High Speed clock ready flag"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Internal High Speed clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x1f ; val as u8 } # [doc = "Internal High Speed clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 3usize)) | (((val as u32) & 0x1f) << 3usize) ; } # [doc = "Internal High Speed clock Calibration"]
pub const fn hsical (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Internal High Speed clock Calibration"]
pub fn set_hsical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "External High Speed clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "External High Speed clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "External High Speed clock Bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock Bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Clock Security System enable"]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Clock Security System enable"]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "PLL enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "PLL enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "PLL clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "PLL clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "AHB Peripheral Clock enable register (RCC_AHBENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbenr (pub u32) ; impl Ahbenr { # [doc = "DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SRAM interface clock enable"]
pub const fn sramen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "SRAM interface clock enable"]
pub fn set_sramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "FLASH clock enable"]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "FLASH clock enable"]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "FMC clock enable"]
pub const fn fmcen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "FMC clock enable"]
pub fn set_fmcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "I/O port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "I/O port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "I/O port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "I/O port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "I/O port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "I/O port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "I/O port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "I/O port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I/O port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I/O port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I/O port F clock enable"]
pub const fn gpiofen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I/O port F clock enable"]
pub fn set_gpiofen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "IO port G clock enable"]
pub const fn gpiogen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "IO port G clock enable"]
pub fn set_gpiogen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Touch sensing controller clock enable"]
pub const fn tscen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Touch sensing controller clock enable"]
pub fn set_tscen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "ADC1 and ADC2 clock enable"]
pub const fn adc12en (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "ADC1 and ADC2 clock enable"]
pub fn set_adc12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "ADC 1"]
pub const fn adc1en (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "ADC 1"]
pub fn set_adc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "ADC3 and ADC4 clock enable"]
pub const fn adc34en (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "ADC3 and ADC4 clock enable"]
pub fn set_adc34en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Ahbenr { fn default () -> Ahbenr { Ahbenr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcopre (pub u8) ; impl Mcopre { # [doc = "MCO is divided by 1"]
pub const DIV1 : Self = Self (0) ; # [doc = "MCO is divided by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "MCO is divided by 4"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "MCO is divided by 8"]
pub const DIV8 : Self = Self (0x03) ; # [doc = "MCO is divided by 16"]
pub const DIV16 : Self = Self (0x04) ; # [doc = "MCO is divided by 32"]
pub const DIV32 : Self = Self (0x05) ; # [doc = "MCO is divided by 64"]
pub const DIV64 : Self = Self (0x06) ; # [doc = "MCO is divided by 128"]
pub const DIV128 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usbpre (pub u8) ; impl Usbpre { # [doc = "PLL clock is divided by 1.5"]
pub const DIV1_5 : Self = Self (0) ; # [doc = "PLL clock is not divided"]
pub const DIV1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usartsw (pub u8) ; impl Usartsw { # [doc = "PCLK selected as USART clock source"]
pub const PCLK : Self = Self (0) ; # [doc = "SYSCLK selected as USART clock source"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "LSE selected as USART clock source"]
pub const LSE : Self = Self (0x02) ; # [doc = "HSI selected as USART clock source"]
pub const HSI : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsedrv (pub u8) ; impl Lsedrv { # [doc = "Low drive capacity"]
pub const LOW : Self = Self (0) ; # [doc = "Medium-high drive capacity"]
pub const MEDIUMHIGH : Self = Self (0x01) ; # [doc = "Medium-low drive capacity"]
pub const MEDIUMLOW : Self = Self (0x02) ; # [doc = "High drive capacity"]
pub const HIGH : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllmul (pub u8) ; impl Pllmul { # [doc = "PLL input clock x2"]
pub const MUL2 : Self = Self (0) ; # [doc = "PLL input clock x3"]
pub const MUL3 : Self = Self (0x01) ; # [doc = "PLL input clock x4"]
pub const MUL4 : Self = Self (0x02) ; # [doc = "PLL input clock x5"]
pub const MUL5 : Self = Self (0x03) ; # [doc = "PLL input clock x6"]
pub const MUL6 : Self = Self (0x04) ; # [doc = "PLL input clock x7"]
pub const MUL7 : Self = Self (0x05) ; # [doc = "PLL input clock x8"]
pub const MUL8 : Self = Self (0x06) ; # [doc = "PLL input clock x9"]
pub const MUL9 : Self = Self (0x07) ; # [doc = "PLL input clock x10"]
pub const MUL10 : Self = Self (0x08) ; # [doc = "PLL input clock x11"]
pub const MUL11 : Self = Self (0x09) ; # [doc = "PLL input clock x12"]
pub const MUL12 : Self = Self (0x0a) ; # [doc = "PLL input clock x13"]
pub const MUL13 : Self = Self (0x0b) ; # [doc = "PLL input clock x14"]
pub const MUL14 : Self = Self (0x0c) ; # [doc = "PLL input clock x15"]
pub const MUL15 : Self = Self (0x0d) ; # [doc = "PLL input clock x16"]
pub const MUL16 : Self = Self (0x0e) ; # [doc = "PLL input clock x16"]
pub const MUL16X : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sw (pub u8) ; impl Sw { # [doc = "HSI selected as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE selected as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL selected as system clock"]
pub const PLL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllnodiv (pub u8) ; impl Pllnodiv { # [doc = "PLL is divided by 2 for MCO"]
pub const DIV2 : Self = Self (0) ; # [doc = "PLL is not divided for MCO"]
pub const DIV1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcsel (pub u8) ; impl Rtcsel { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "LSE oscillator clock used as RTC clock"]
pub const LSE : Self = Self (0x01) ; # [doc = "LSI oscillator clock used as RTC clock"]
pub const LSI : Self = Self (0x02) ; # [doc = "HSE oscillator clock divided by a prescaler used as RTC clock"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Timsw (pub u8) ; impl Timsw { # [doc = "PCLK2 clock (doubled frequency when prescaled)"]
pub const PCLK2 : Self = Self (0) ; # [doc = "PLL vco output (running up to 144 MHz)"]
pub const PLL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsrc (pub u8) ; impl Pllsrc { # [doc = "HSI divided by 2 selected as PLL input clock"]
pub const HSI_DIV2 : Self = Self (0) ; # [doc = "HSI divided by PREDIV selected as PLL input clock"]
pub const HSI_DIV_PREDIV : Self = Self (0x01) ; # [doc = "HSE divided by PREDIV selected as PLL input clock"]
pub const HSE_DIV_PREDIV : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swsr (pub u8) ; impl Swsr { # [doc = "HSI oscillator used as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE oscillator used as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL used as system clock"]
pub const PLL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cecsw (pub u8) ; impl Cecsw { # [doc = "HSI clock divided by 244 selected as CEC clock source"]
pub const HSI_DIV244 : Self = Self (0) ; # [doc = "LSE clock selected as CEC clock source"]
pub const LSE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icsw (pub u8) ; impl Icsw { # [doc = "HSI clock selected as I2C clock source"]
pub const HSI : Self = Self (0) ; # [doc = "SYSCLK clock selected as I2C clock source"]
pub const SYSCLK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllxtpre (pub u8) ; impl Pllxtpre { # [doc = "HSE clock not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HSE clock divided by 2"]
pub const DIV2 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adcpres (pub u8) ; impl Adcpres { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "PLL clock not divided"]
pub const DIV1 : Self = Self (0x10) ; # [doc = "PLL clock divided by 2"]
pub const DIV2 : Self = Self (0x11) ; # [doc = "PLL clock divided by 4"]
pub const DIV4 : Self = Self (0x12) ; # [doc = "PLL clock divided by 6"]
pub const DIV6 : Self = Self (0x13) ; # [doc = "PLL clock divided by 8"]
pub const DIV8 : Self = Self (0x14) ; # [doc = "PLL clock divided by 10"]
pub const DIV10 : Self = Self (0x15) ; # [doc = "PLL clock divided by 12"]
pub const DIV12 : Self = Self (0x16) ; # [doc = "PLL clock divided by 16"]
pub const DIV16 : Self = Self (0x17) ; # [doc = "PLL clock divided by 32"]
pub const DIV32 : Self = Self (0x18) ; # [doc = "PLL clock divided by 64"]
pub const DIV64 : Self = Self (0x19) ; # [doc = "PLL clock divided by 128"]
pub const DIV128 : Self = Self (0x1a) ; # [doc = "PLL clock divided by 256"]
pub const DIV256 : Self = Self (0x1b) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sdpre (pub u8) ; impl Sdpre { # [doc = "SYSCLK divided by 2"]
pub const DIV2 : Self = Self (0) ; # [doc = "SYSCLK divided by 4"]
pub const DIV4 : Self = Self (0x11) ; # [doc = "SYSCLK divided by 6"]
pub const DIV6 : Self = Self (0x12) ; # [doc = "SYSCLK divided by 8"]
pub const DIV8 : Self = Self (0x13) ; # [doc = "SYSCLK divided by 10"]
pub const DIV10 : Self = Self (0x14) ; # [doc = "SYSCLK divided by 12"]
pub const DIV12 : Self = Self (0x15) ; # [doc = "SYSCLK divided by 14"]
pub const DIV14 : Self = Self (0x16) ; # [doc = "SYSCLK divided by 16"]
pub const DIV16 : Self = Self (0x17) ; # [doc = "SYSCLK divided by 20"]
pub const DIV20 : Self = Self (0x18) ; # [doc = "SYSCLK divided by 24"]
pub const DIV24 : Self = Self (0x19) ; # [doc = "SYSCLK divided by 28"]
pub const DIV28 : Self = Self (0x1a) ; # [doc = "SYSCLK divided by 32"]
pub const DIV32 : Self = Self (0x1b) ; # [doc = "SYSCLK divided by 36"]
pub const DIV36 : Self = Self (0x1c) ; # [doc = "SYSCLK divided by 40"]
pub const DIV40 : Self = Self (0x1d) ; # [doc = "SYSCLK divided by 44"]
pub const DIV44 : Self = Self (0x1e) ; # [doc = "SYSCLK divided by 48"]
pub const DIV48 : Self = Self (0x1f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco (pub u8) ; impl Mco { # [doc = "MCO output disabled, no clock on MCO"]
pub const NOMCO : Self = Self (0) ; # [doc = "Internal low speed (LSI) oscillator clock selected"]
pub const LSI : Self = Self (0x02) ; # [doc = "External low speed (LSE) oscillator clock selected"]
pub const LSE : Self = Self (0x03) ; # [doc = "System clock selected"]
pub const SYSCLK : Self = Self (0x04) ; # [doc = "Internal RC 8 MHz (HSI) oscillator clock selected"]
pub const HSI : Self = Self (0x05) ; # [doc = "External 4-32 MHz (HSE) oscillator clock selected"]
pub const HSE : Self = Self (0x06) ; # [doc = "PLL clock selected (divided by 1 or 2, depending en PLLNODIV)"]
pub const PLL : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prediv (pub u8) ; impl Prediv { # [doc = "PREDIV input clock not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "PREDIV input clock divided by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "PREDIV input clock divided by 3"]
pub const DIV3 : Self = Self (0x02) ; # [doc = "PREDIV input clock divided by 4"]
pub const DIV4 : Self = Self (0x03) ; # [doc = "PREDIV input clock divided by 5"]
pub const DIV5 : Self = Self (0x04) ; # [doc = "PREDIV input clock divided by 6"]
pub const DIV6 : Self = Self (0x05) ; # [doc = "PREDIV input clock divided by 7"]
pub const DIV7 : Self = Self (0x06) ; # [doc = "PREDIV input clock divided by 8"]
pub const DIV8 : Self = Self (0x07) ; # [doc = "PREDIV input clock divided by 9"]
pub const DIV9 : Self = Self (0x08) ; # [doc = "PREDIV input clock divided by 10"]
pub const DIV10 : Self = Self (0x09) ; # [doc = "PREDIV input clock divided by 11"]
pub const DIV11 : Self = Self (0x0a) ; # [doc = "PREDIV input clock divided by 12"]
pub const DIV12 : Self = Self (0x0b) ; # [doc = "PREDIV input clock divided by 13"]
pub const DIV13 : Self = Self (0x0c) ; # [doc = "PREDIV input clock divided by 14"]
pub const DIV14 : Self = Self (0x0d) ; # [doc = "PREDIV input clock divided by 15"]
pub const DIV15 : Self = Self (0x0e) ; # [doc = "PREDIV input clock divided by 16"]
pub const DIV16 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Issrc (pub u8) ; impl Issrc { # [doc = "System clock used as I2S clock source"]
pub const SYSCLK : Self = Self (0) ; # [doc = "External clock mapped on the I2S_CKIN pin used as I2S clock source"]
pub const CKIN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpre (pub u8) ; impl Hpre { # [doc = "SYSCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "SYSCLK divided by 2"]
pub const DIV2 : Self = Self (0x08) ; # [doc = "SYSCLK divided by 4"]
pub const DIV4 : Self = Self (0x09) ; # [doc = "SYSCLK divided by 8"]
pub const DIV8 : Self = Self (0x0a) ; # [doc = "SYSCLK divided by 16"]
pub const DIV16 : Self = Self (0x0b) ; # [doc = "SYSCLK divided by 64"]
pub const DIV64 : Self = Self (0x0c) ; # [doc = "SYSCLK divided by 128"]
pub const DIV128 : Self = Self (0x0d) ; # [doc = "SYSCLK divided by 256"]
pub const DIV256 : Self = Self (0x0e) ; # [doc = "SYSCLK divided by 512"]
pub const DIV512 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ppre (pub u8) ; impl Ppre { # [doc = "HCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HCLK divided by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "HCLK divided by 4"]
pub const DIV4 : Self = Self (0x05) ; # [doc = "HCLK divided by 8"]
pub const DIV8 : Self = Self (0x06) ; # [doc = "HCLK divided by 16"]
pub const DIV16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adcpre (pub u8) ; impl Adcpre { # [doc = "PCLK divided by 2"]
pub const DIV2 : Self = Self (0) ; # [doc = "PCLK divided by 4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "PCLK divided by 6"]
pub const DIV6 : Self = Self (0x02) ; # [doc = "PCLK divided by 8"]
pub const DIV8 : Self = Self (0x03) ; } }