

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "PLL configuration register"]
pub fn pllcfgr (self) -> crate :: common :: Reg < regs :: Pllcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "clock configuration register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "clock interrupt register"]
pub fn cir (self) -> crate :: common :: Reg < regs :: Cir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "AHB1 peripheral reset register"]
pub fn ahb1rstr (self) -> crate :: common :: Reg < regs :: Ahb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "AHB2 peripheral reset register"]
pub fn ahb2rstr (self) -> crate :: common :: Reg < regs :: Ahb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "AHB3 peripheral reset register"]
pub fn ahb3rstr (self) -> crate :: common :: Reg < regs :: Ahb3rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "APB1 peripheral reset register"]
pub fn apb1rstr (self) -> crate :: common :: Reg < regs :: Apb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "APB2 peripheral reset register"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "AHB1 peripheral clock register"]
pub fn ahb1enr (self) -> crate :: common :: Reg < regs :: Ahb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "AHB2 peripheral clock enable register"]
pub fn ahb2enr (self) -> crate :: common :: Reg < regs :: Ahb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "AHB3 peripheral clock enable register"]
pub fn ahb3enr (self) -> crate :: common :: Reg < regs :: Ahb3enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "APB1 peripheral clock enable register"]
pub fn apb1enr (self) -> crate :: common :: Reg < regs :: Apb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "APB2 peripheral clock enable register"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "AHB1 peripheral clock enable in low power mode register"]
pub fn ahb1lpenr (self) -> crate :: common :: Reg < regs :: Ahb1lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "AHB2 peripheral clock enable in low power mode register"]
pub fn ahb2lpenr (self) -> crate :: common :: Reg < regs :: Ahb2lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "AHB3 peripheral clock enable in low power mode register"]
pub fn ahb3lpenr (self) -> crate :: common :: Reg < regs :: Ahb3lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "APB1 peripheral clock enable in low power mode register"]
pub fn apb1lpenr (self) -> crate :: common :: Reg < regs :: Apb1lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "APB2 peripheral clock enabled in low power mode register"]
pub fn apb2lpenr (self) -> crate :: common :: Reg < regs :: Apb2lpenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (100usize)) } } # [doc = "Backup domain control register"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } # [doc = "clock control & status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (116usize)) } } # [doc = "spread spectrum clock generation register"]
pub fn sscgr (self) -> crate :: common :: Reg < regs :: Sscgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "PLLI2S configuration register"]
pub fn plli2scfgr (self) -> crate :: common :: Reg < regs :: Plli2scfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize)) } } } pub mod regs { # [doc = "clock configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock switch"]
pub const fn sw (& self) -> super :: vals :: Sw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "System clock switch"]
pub fn set_sw (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "System clock switch status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "System clock switch status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "AHB prescaler"]
pub const fn hpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 4usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "AHB prescaler"]
pub fn set_hpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val . 0 as u32) & 0x0f) << 4usize) ; } # [doc = "APB Low speed prescaler (APB1)"]
pub const fn ppre1 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 10usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB Low speed prescaler (APB1)"]
pub fn set_ppre1 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 10usize)) | (((val . 0 as u32) & 0x07) << 10usize) ; } # [doc = "APB high-speed prescaler (APB2)"]
pub const fn ppre2 (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 13usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB high-speed prescaler (APB2)"]
pub fn set_ppre2 (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val . 0 as u32) & 0x07) << 13usize) ; } # [doc = "HSE division factor for RTC clock"]
pub const fn rtcpre (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x1f ; val as u8 } # [doc = "HSE division factor for RTC clock"]
pub fn set_rtcpre (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 16usize)) | (((val as u32) & 0x1f) << 16usize) ; } # [doc = "Microcontroller clock output 1"]
pub const fn mco1 (& self) -> super :: vals :: Mco1 { let val = (self . 0 >> 21usize) & 0x03 ; super :: vals :: Mco1 (val as u8) } # [doc = "Microcontroller clock output 1"]
pub fn set_mco1 (& mut self , val : super :: vals :: Mco1) { self . 0 = (self . 0 & ! (0x03 << 21usize)) | (((val . 0 as u32) & 0x03) << 21usize) ; } # [doc = "I2S clock selection"]
pub const fn i2ssrc (& self) -> super :: vals :: Issrc { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Issrc (val as u8) } # [doc = "I2S clock selection"]
pub fn set_i2ssrc (& mut self , val : super :: vals :: Issrc) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "MCO1 prescaler"]
pub const fn mco1pre (& self) -> super :: vals :: Mcopre { let val = (self . 0 >> 24usize) & 0x07 ; super :: vals :: Mcopre (val as u8) } # [doc = "MCO1 prescaler"]
pub fn set_mco1pre (& mut self , val : super :: vals :: Mcopre) { self . 0 = (self . 0 & ! (0x07 << 24usize)) | (((val . 0 as u32) & 0x07) << 24usize) ; } # [doc = "MCO2 prescaler"]
pub const fn mco2pre (& self) -> super :: vals :: Mcopre { let val = (self . 0 >> 27usize) & 0x07 ; super :: vals :: Mcopre (val as u8) } # [doc = "MCO2 prescaler"]
pub fn set_mco2pre (& mut self , val : super :: vals :: Mcopre) { self . 0 = (self . 0 & ! (0x07 << 27usize)) | (((val . 0 as u32) & 0x07) << 27usize) ; } # [doc = "Microcontroller clock output 2"]
pub const fn mco2 (& self) -> super :: vals :: Mco2 { let val = (self . 0 >> 30usize) & 0x03 ; super :: vals :: Mco2 (val as u8) } # [doc = "Microcontroller clock output 2"]
pub fn set_mco2 (& mut self , val : super :: vals :: Mco2) { self . 0 = (self . 0 & ! (0x03 << 30usize)) | (((val . 0 as u32) & 0x03) << 30usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "PLL configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pllcfgr (pub u32) ; impl Pllcfgr { # [doc = "Division factor for the main PLL (PLL) and audio PLL (PLLI2S) input clock"]
pub const fn pllm (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Division factor for the main PLL (PLL) and audio PLL (PLLI2S) input clock"]
pub fn set_pllm (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } # [doc = "Main PLL (PLL) multiplication factor for VCO"]
pub const fn plln (& self) -> u16 { let val = (self . 0 >> 6usize) & 0x01ff ; val as u16 } # [doc = "Main PLL (PLL) multiplication factor for VCO"]
pub fn set_plln (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 6usize)) | (((val as u32) & 0x01ff) << 6usize) ; } # [doc = "Main PLL (PLL) division factor for main system clock"]
pub const fn pllp (& self) -> super :: vals :: Pllp { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Pllp (val as u8) } # [doc = "Main PLL (PLL) division factor for main system clock"]
pub fn set_pllp (& mut self , val : super :: vals :: Pllp) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Main PLL(PLL) and audio PLL (PLLI2S) entry clock source"]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Pllsrc (val as u8) } # [doc = "Main PLL(PLL) and audio PLL (PLLI2S) entry clock source"]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Main PLL (PLL) division factor for USB OTG FS, SDIO and random number generator clocks"]
pub const fn pllq (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "Main PLL (PLL) division factor for USB OTG FS, SDIO and random number generator clocks"]
pub fn set_pllq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } } impl Default for Pllcfgr { fn default () -> Pllcfgr { Pllcfgr (0) } } # [doc = "APB1 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr (pub u32) ; impl Apb1enr { # [doc = "TIM2 clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 clock enable"]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 clock enable"]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 clock enable"]
pub const fn tim4en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 clock enable"]
pub fn set_tim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 clock enable"]
pub const fn tim5en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 clock enable"]
pub fn set_tim5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 clock enable"]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 clock enable"]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 clock enable"]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 clock enable"]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM12 clock enable"]
pub const fn tim12en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM12 clock enable"]
pub fn set_tim12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM13 clock enable"]
pub const fn tim13en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM13 clock enable"]
pub fn set_tim13en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM14 clock enable"]
pub const fn tim14en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14 clock enable"]
pub fn set_tim14en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 clock enable"]
pub const fn spi3en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 clock enable"]
pub fn set_spi3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART 2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clock enable"]
pub const fn usart3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clock enable"]
pub fn set_usart3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clock enable"]
pub const fn uart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clock enable"]
pub fn set_uart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clock enable"]
pub const fn uart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clock enable"]
pub fn set_uart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 clock enable"]
pub const fn i2c3en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable"]
pub fn set_i2c3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN 1 clock enable"]
pub const fn can1en (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN 1 clock enable"]
pub fn set_can1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN 2 clock enable"]
pub const fn can2en (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN 2 clock enable"]
pub fn set_can2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Power interface clock enable"]
pub const fn pwren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable"]
pub fn set_pwren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable"]
pub const fn dacen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable"]
pub fn set_dacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Apb1enr { fn default () -> Apb1enr { Apb1enr (0) } } # [doc = "APB1 peripheral clock enable in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1lpenr (pub u32) ; impl Apb1lpenr { # [doc = "TIM2 clock enable during Sleep mode"]
pub const fn tim2lpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 clock enable during Sleep mode"]
pub fn set_tim2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 clock enable during Sleep mode"]
pub const fn tim3lpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 clock enable during Sleep mode"]
pub fn set_tim3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 clock enable during Sleep mode"]
pub const fn tim4lpen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 clock enable during Sleep mode"]
pub fn set_tim4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 clock enable during Sleep mode"]
pub const fn tim5lpen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 clock enable during Sleep mode"]
pub fn set_tim5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 clock enable during Sleep mode"]
pub const fn tim6lpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 clock enable during Sleep mode"]
pub fn set_tim6lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 clock enable during Sleep mode"]
pub const fn tim7lpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 clock enable during Sleep mode"]
pub fn set_tim7lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM12 clock enable during Sleep mode"]
pub const fn tim12lpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM12 clock enable during Sleep mode"]
pub fn set_tim12lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM13 clock enable during Sleep mode"]
pub const fn tim13lpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM13 clock enable during Sleep mode"]
pub fn set_tim13lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM14 clock enable during Sleep mode"]
pub const fn tim14lpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14 clock enable during Sleep mode"]
pub fn set_tim14lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Window watchdog clock enable during Sleep mode"]
pub const fn wwdglpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable during Sleep mode"]
pub fn set_wwdglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 clock enable during Sleep mode"]
pub const fn spi2lpen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 clock enable during Sleep mode"]
pub fn set_spi2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 clock enable during Sleep mode"]
pub const fn spi3lpen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 clock enable during Sleep mode"]
pub fn set_spi3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART2 clock enable during Sleep mode"]
pub const fn usart2lpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART2 clock enable during Sleep mode"]
pub fn set_usart2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clock enable during Sleep mode"]
pub const fn usart3lpen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clock enable during Sleep mode"]
pub fn set_usart3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART4 clock enable during Sleep mode"]
pub const fn uart4lpen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART4 clock enable during Sleep mode"]
pub fn set_uart4lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART5 clock enable during Sleep mode"]
pub const fn uart5lpen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART5 clock enable during Sleep mode"]
pub fn set_uart5lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 clock enable during Sleep mode"]
pub const fn i2c1lpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 clock enable during Sleep mode"]
pub fn set_i2c1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 clock enable during Sleep mode"]
pub const fn i2c2lpen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 clock enable during Sleep mode"]
pub fn set_i2c2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 clock enable during Sleep mode"]
pub const fn i2c3lpen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 clock enable during Sleep mode"]
pub fn set_i2c3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN 1 clock enable during Sleep mode"]
pub const fn can1lpen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN 1 clock enable during Sleep mode"]
pub fn set_can1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN 2 clock enable during Sleep mode"]
pub const fn can2lpen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN 2 clock enable during Sleep mode"]
pub fn set_can2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Power interface clock enable during Sleep mode"]
pub const fn pwrlpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable during Sleep mode"]
pub fn set_pwrlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable during Sleep mode"]
pub const fn daclpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable during Sleep mode"]
pub fn set_daclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Apb1lpenr { fn default () -> Apb1lpenr { Apb1lpenr (0) } } # [doc = "spread spectrum clock generation register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sscgr (pub u32) ; impl Sscgr { # [doc = "Modulation period"]
pub const fn modper (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x1fff ; val as u16 } # [doc = "Modulation period"]
pub fn set_modper (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 0usize)) | (((val as u32) & 0x1fff) << 0usize) ; } # [doc = "Incrementation step"]
pub const fn incstep (& self) -> u16 { let val = (self . 0 >> 13usize) & 0x7fff ; val as u16 } # [doc = "Incrementation step"]
pub fn set_incstep (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 13usize)) | (((val as u32) & 0x7fff) << 13usize) ; } # [doc = "Spread Select"]
pub const fn spreadsel (& self) -> super :: vals :: Spreadsel { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: Spreadsel (val as u8) } # [doc = "Spread Select"]
pub fn set_spreadsel (& mut self , val : super :: vals :: Spreadsel) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "Spread spectrum modulation enable"]
pub const fn sscgen (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Spread spectrum modulation enable"]
pub fn set_sscgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Sscgr { fn default () -> Sscgr { Sscgr (0) } } # [doc = "AHB3 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3enr (pub u32) ; impl Ahb3enr { # [doc = "Flexible static memory controller module clock enable"]
pub const fn fsmcen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible static memory controller module clock enable"]
pub fn set_fsmcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Ahb3enr { fn default () -> Ahb3enr { Ahb3enr (0) } } # [doc = "APB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr (pub u32) ; impl Apb1rstr { # [doc = "TIM2 reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 reset"]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 reset"]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 reset"]
pub const fn tim4rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 reset"]
pub fn set_tim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 reset"]
pub const fn tim5rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 reset"]
pub fn set_tim5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 reset"]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 reset"]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 reset"]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 reset"]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM12 reset"]
pub const fn tim12rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM12 reset"]
pub fn set_tim12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM13 reset"]
pub const fn tim13rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM13 reset"]
pub fn set_tim13rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM14 reset"]
pub const fn tim14rst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14 reset"]
pub fn set_tim14rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Window watchdog reset"]
pub const fn wwdgrst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset"]
pub fn set_wwdgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI 2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI 3 reset"]
pub const fn spi3rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI 3 reset"]
pub fn set_spi3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART 2 reset"]
pub const fn uart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 reset"]
pub fn set_uart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART 3 reset"]
pub const fn uart3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART 3 reset"]
pub fn set_uart3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USART 4 reset"]
pub const fn uart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "USART 4 reset"]
pub fn set_uart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "USART 5 reset"]
pub const fn uart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "USART 5 reset"]
pub fn set_uart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C 1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C 1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C 2 reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C 2 reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 reset"]
pub const fn i2c3rst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 reset"]
pub fn set_i2c3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN1 reset"]
pub const fn can1rst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN1 reset"]
pub fn set_can1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN2 reset"]
pub const fn can2rst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN2 reset"]
pub fn set_can2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Power interface reset"]
pub const fn pwrrst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface reset"]
pub fn set_pwrrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC reset"]
pub const fn dacrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC reset"]
pub fn set_dacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Apb1rstr { fn default () -> Apb1rstr { Apb1rstr (0) } } # [doc = "APB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "TIM1 reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 reset"]
pub const fn tim8rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 reset"]
pub fn set_tim8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 reset"]
pub const fn usart6rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 reset"]
pub fn set_usart6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ADC interface reset (common to all ADCs)"]
pub const fn adcrst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "ADC interface reset (common to all ADCs)"]
pub fn set_adcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "SDIO reset"]
pub const fn sdiorst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SDIO reset"]
pub fn set_sdiorst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "System configuration controller reset"]
pub const fn syscfgrst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "System configuration controller reset"]
pub fn set_syscfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM9 reset"]
pub const fn tim9rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM9 reset"]
pub fn set_tim9rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM10 reset"]
pub const fn tim10rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM10 reset"]
pub fn set_tim10rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM11 reset"]
pub const fn tim11rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM11 reset"]
pub fn set_tim11rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "AHB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2enr (pub u32) ; impl Ahb2enr { # [doc = "Camera interface enable"]
pub const fn dcmien (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Camera interface enable"]
pub fn set_dcmien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Cryptographic modules clock enable"]
pub const fn crypen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Cryptographic modules clock enable"]
pub fn set_crypen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Hash modules clock enable"]
pub const fn hashen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Hash modules clock enable"]
pub fn set_hashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Random number generator clock enable"]
pub const fn rngen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Random number generator clock enable"]
pub fn set_rngen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USB OTG FS clock enable"]
pub const fn usb_otg_fsen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USB OTG FS clock enable"]
pub fn set_usb_otg_fsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2enr { fn default () -> Ahb2enr { Ahb2enr (0) } } # [doc = "APB2 peripheral clock enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "TIM1 clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 clock enable"]
pub const fn tim8en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 clock enable"]
pub fn set_tim8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 clock enable"]
pub const fn usart6en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 clock enable"]
pub fn set_usart6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ADC1 clock enable"]
pub const fn adc1en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "ADC1 clock enable"]
pub fn set_adc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC2 clock enable"]
pub const fn adc2en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC2 clock enable"]
pub fn set_adc2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADC3 clock enable"]
pub const fn adc3en (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC3 clock enable"]
pub fn set_adc3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SDIO clock enable"]
pub const fn sdioen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SDIO clock enable"]
pub fn set_sdioen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "System configuration controller clock enable"]
pub const fn syscfgen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "System configuration controller clock enable"]
pub fn set_syscfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM9 clock enable"]
pub const fn tim9en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM9 clock enable"]
pub fn set_tim9en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM10 clock enable"]
pub const fn tim10en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM10 clock enable"]
pub fn set_tim10en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM11 clock enable"]
pub const fn tim11en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM11 clock enable"]
pub fn set_tim11en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "AHB1 peripheral clock enable in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1lpenr (pub u32) ; impl Ahb1lpenr { # [doc = "IO port A clock enable during sleep mode"]
pub const fn gpioalpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable during sleep mode"]
pub fn set_gpioalpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable during Sleep mode"]
pub const fn gpioblpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable during Sleep mode"]
pub fn set_gpioblpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable during Sleep mode"]
pub const fn gpioclpen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable during Sleep mode"]
pub fn set_gpioclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clock enable during Sleep mode"]
pub const fn gpiodlpen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clock enable during Sleep mode"]
pub fn set_gpiodlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clock enable during Sleep mode"]
pub const fn gpioelpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clock enable during Sleep mode"]
pub fn set_gpioelpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F clock enable during Sleep mode"]
pub const fn gpioflpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F clock enable during Sleep mode"]
pub fn set_gpioflpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G clock enable during Sleep mode"]
pub const fn gpioglpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G clock enable during Sleep mode"]
pub fn set_gpioglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H clock enable during Sleep mode"]
pub const fn gpiohlpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable during Sleep mode"]
pub fn set_gpiohlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I clock enable during Sleep mode"]
pub const fn gpioilpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I clock enable during Sleep mode"]
pub fn set_gpioilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CRC clock enable during Sleep mode"]
pub const fn crclpen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable during Sleep mode"]
pub fn set_crclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Flash interface clock enable during Sleep mode"]
pub const fn flashlpen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Flash interface clock enable during Sleep mode"]
pub fn set_flashlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "SRAM 1interface clock enable during Sleep mode"]
pub const fn sram1lpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "SRAM 1interface clock enable during Sleep mode"]
pub fn set_sram1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "SRAM 2 interface clock enable during Sleep mode"]
pub const fn sram2lpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "SRAM 2 interface clock enable during Sleep mode"]
pub fn set_sram2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Backup SRAM interface clock enable during Sleep mode"]
pub const fn bkpsramlpen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Backup SRAM interface clock enable during Sleep mode"]
pub fn set_bkpsramlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "DMA1 clock enable during Sleep mode"]
pub const fn dma1lpen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable during Sleep mode"]
pub fn set_dma1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "DMA2 clock enable during Sleep mode"]
pub const fn dma2lpen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable during Sleep mode"]
pub fn set_dma2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Ethernet MAC clock enable during Sleep mode"]
pub const fn ethmaclpen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC clock enable during Sleep mode"]
pub fn set_ethmaclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Ethernet transmission clock enable during Sleep mode"]
pub const fn ethmactxlpen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Ethernet transmission clock enable during Sleep mode"]
pub fn set_ethmactxlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Ethernet reception clock enable during Sleep mode"]
pub const fn ethmacrxlpen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Ethernet reception clock enable during Sleep mode"]
pub fn set_ethmacrxlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Ethernet PTP clock enable during Sleep mode"]
pub const fn ethmacptplpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Ethernet PTP clock enable during Sleep mode"]
pub fn set_ethmacptplpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "USB OTG HS clock enable during Sleep mode"]
pub const fn usb_otg_hslpen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS clock enable during Sleep mode"]
pub fn set_usb_otg_hslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "USB OTG HS ULPI clock enable during Sleep mode"]
pub const fn usb_otg_hsulpilpen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS ULPI clock enable during Sleep mode"]
pub fn set_usb_otg_hsulpilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Ahb1lpenr { fn default () -> Ahb1lpenr { Ahb1lpenr (0) } } # [doc = "AHB2 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2rstr (pub u32) ; impl Ahb2rstr { # [doc = "Camera interface reset"]
pub const fn dcmirst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Camera interface reset"]
pub fn set_dcmirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Cryptographic module reset"]
pub const fn cryprst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Cryptographic module reset"]
pub fn set_cryprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Hash module reset"]
pub const fn hsahrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Hash module reset"]
pub fn set_hsahrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Random number generator module reset"]
pub const fn rngrst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Random number generator module reset"]
pub fn set_rngrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USB OTG FS module reset"]
pub const fn usb_otg_fsrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USB OTG FS module reset"]
pub fn set_usb_otg_fsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2rstr { fn default () -> Ahb2rstr { Ahb2rstr (0) } } # [doc = "Backup domain control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "External low-speed oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "External low-speed oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External low-speed oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "External low-speed oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> super :: vals :: Rtcsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Rtcsel (val as u8) } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : super :: vals :: Rtcsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Backup domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "AHB3 peripheral clock enable in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3lpenr (pub u32) ; impl Ahb3lpenr { # [doc = "Flexible static memory controller module clock enable during Sleep mode"]
pub const fn fsmclpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible static memory controller module clock enable during Sleep mode"]
pub fn set_fsmclpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Ahb3lpenr { fn default () -> Ahb3lpenr { Ahb3lpenr (0) } } # [doc = "AHB1 peripheral clock register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1enr (pub u32) ; impl Ahb1enr { # [doc = "IO port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F clock enable"]
pub const fn gpiofen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F clock enable"]
pub fn set_gpiofen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G clock enable"]
pub const fn gpiogen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G clock enable"]
pub fn set_gpiogen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H clock enable"]
pub const fn gpiohen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H clock enable"]
pub fn set_gpiohen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I clock enable"]
pub const fn gpioien (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I clock enable"]
pub fn set_gpioien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Backup SRAM interface clock enable"]
pub const fn bkpsramen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Backup SRAM interface clock enable"]
pub fn set_bkpsramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Ethernet MAC clock enable"]
pub const fn ethmacen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC clock enable"]
pub fn set_ethmacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Ethernet Transmission clock enable"]
pub const fn ethmactxen (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Ethernet Transmission clock enable"]
pub fn set_ethmactxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Ethernet Reception clock enable"]
pub const fn ethmacrxen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Ethernet Reception clock enable"]
pub fn set_ethmacrxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Ethernet PTP clock enable"]
pub const fn ethmacptpen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Ethernet PTP clock enable"]
pub fn set_ethmacptpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "USB OTG HS clock enable"]
pub const fn usb_otg_hsen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS clock enable"]
pub fn set_usb_otg_hsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "USB OTG HSULPI clock enable"]
pub const fn usb_otg_hsulpien (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "USB OTG HSULPI clock enable"]
pub fn set_usb_otg_hsulpien (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Ahb1enr { fn default () -> Ahb1enr { Ahb1enr (0) } } # [doc = "PLLI2S configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Plli2scfgr (pub u32) ; impl Plli2scfgr { # [doc = "PLLI2S multiplication factor for VCO"]
pub const fn plli2sn (& self) -> u16 { let val = (self . 0 >> 6usize) & 0x01ff ; val as u16 } # [doc = "PLLI2S multiplication factor for VCO"]
pub fn set_plli2sn (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 6usize)) | (((val as u32) & 0x01ff) << 6usize) ; } # [doc = "PLLI2S division factor for I2S clocks"]
pub const fn plli2sr (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x07 ; val as u8 } # [doc = "PLLI2S division factor for I2S clocks"]
pub fn set_plli2sr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val as u32) & 0x07) << 28usize) ; } } impl Default for Plli2scfgr { fn default () -> Plli2scfgr { Plli2scfgr (0) } } # [doc = "clock control & status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Internal low-speed oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal low-speed oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal low-speed oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal low-speed oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "BOR reset flag"]
pub const fn borrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "BOR reset flag"]
pub fn set_borrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PIN reset flag"]
pub const fn padrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PIN reset flag"]
pub fn set_padrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "POR/PDR reset flag"]
pub const fn porrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "POR/PDR reset flag"]
pub fn set_porrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent watchdog reset flag"]
pub const fn wdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog reset flag"]
pub fn set_wdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Internal high-speed clock enable"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal high-speed clock enable"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal high-speed clock ready flag"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal high-speed clock ready flag"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Internal high-speed clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x1f ; val as u8 } # [doc = "Internal high-speed clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 3usize)) | (((val as u32) & 0x1f) << 3usize) ; } # [doc = "Internal high-speed clock calibration"]
pub const fn hsical (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Internal high-speed clock calibration"]
pub fn set_hsical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "HSE clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSE clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSE clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSE clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSE clock bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSE clock bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Clock security system enable"]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Clock security system enable"]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Main PLL (PLL) enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Main PLL (PLL) enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Main PLL (PLL) clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Main PLL (PLL) clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PLLI2S enable"]
pub const fn plli2son (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PLLI2S enable"]
pub fn set_plli2son (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "PLLI2S clock ready flag"]
pub const fn plli2srdy (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "PLLI2S clock ready flag"]
pub fn set_plli2srdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "AHB3 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb3rstr (pub u32) ; impl Ahb3rstr { # [doc = "Flexible static memory controller module reset"]
pub const fn fsmcrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Flexible static memory controller module reset"]
pub fn set_fsmcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Ahb3rstr { fn default () -> Ahb3rstr { Ahb3rstr (0) } } # [doc = "clock interrupt register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cir (pub u32) ; impl Cir { # [doc = "LSI ready interrupt flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE ready interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI ready interrupt flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE ready interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Main PLL (PLL) ready interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Main PLL (PLL) ready interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLLI2S ready interrupt flag"]
pub const fn plli2srdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLLI2S ready interrupt flag"]
pub fn set_plli2srdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Clock security system interrupt flag"]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt flag"]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LSI ready interrupt enable"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt enable"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE ready interrupt enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI ready interrupt enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSE ready interrupt enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Main PLL (PLL) ready interrupt enable"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Main PLL (PLL) ready interrupt enable"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "PLLI2S ready interrupt enable"]
pub const fn plli2srdyie (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "PLLI2S ready interrupt enable"]
pub fn set_plli2srdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "LSI ready interrupt clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "LSI ready interrupt clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "LSE ready interrupt clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "LSE ready interrupt clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSI ready interrupt clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSI ready interrupt clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSE ready interrupt clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSE ready interrupt clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Main PLL(PLL) ready interrupt clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Main PLL(PLL) ready interrupt clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "PLLI2S ready interrupt clear"]
pub const fn plli2srdyc (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "PLLI2S ready interrupt clear"]
pub fn set_plli2srdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Clock security system interrupt clear"]
pub const fn cssc (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt clear"]
pub fn set_cssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cir { fn default () -> Cir { Cir (0) } } # [doc = "APB2 peripheral clock enabled in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2lpenr (pub u32) ; impl Apb2lpenr { # [doc = "TIM1 clock enable during Sleep mode"]
pub const fn tim1lpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 clock enable during Sleep mode"]
pub fn set_tim1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 clock enable during Sleep mode"]
pub const fn tim8lpen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 clock enable during Sleep mode"]
pub fn set_tim8lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "USART1 clock enable during Sleep mode"]
pub const fn usart1lpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable during Sleep mode"]
pub fn set_usart1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "USART6 clock enable during Sleep mode"]
pub const fn usart6lpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 clock enable during Sleep mode"]
pub fn set_usart6lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ADC1 clock enable during Sleep mode"]
pub const fn adc1lpen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "ADC1 clock enable during Sleep mode"]
pub fn set_adc1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC2 clock enable during Sleep mode"]
pub const fn adc2lpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC2 clock enable during Sleep mode"]
pub fn set_adc2lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADC 3 clock enable during Sleep mode"]
pub const fn adc3lpen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC 3 clock enable during Sleep mode"]
pub fn set_adc3lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "SDIO clock enable during Sleep mode"]
pub const fn sdiolpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "SDIO clock enable during Sleep mode"]
pub fn set_sdiolpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 clock enable during Sleep mode"]
pub const fn spi1lpen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 clock enable during Sleep mode"]
pub fn set_spi1lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "System configuration controller clock enable during Sleep mode"]
pub const fn syscfglpen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "System configuration controller clock enable during Sleep mode"]
pub fn set_syscfglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM9 clock enable during sleep mode"]
pub const fn tim9lpen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM9 clock enable during sleep mode"]
pub fn set_tim9lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM10 clock enable during Sleep mode"]
pub const fn tim10lpen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM10 clock enable during Sleep mode"]
pub fn set_tim10lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM11 clock enable during Sleep mode"]
pub const fn tim11lpen (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM11 clock enable during Sleep mode"]
pub fn set_tim11lpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2lpenr { fn default () -> Apb2lpenr { Apb2lpenr (0) } } # [doc = "AHB2 peripheral clock enable in low power mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb2lpenr (pub u32) ; impl Ahb2lpenr { # [doc = "Camera interface enable during Sleep mode"]
pub const fn dcmilpen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Camera interface enable during Sleep mode"]
pub fn set_dcmilpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Cryptography modules clock enable during Sleep mode"]
pub const fn cryplpen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Cryptography modules clock enable during Sleep mode"]
pub fn set_cryplpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Hash modules clock enable during Sleep mode"]
pub const fn hashlpen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Hash modules clock enable during Sleep mode"]
pub fn set_hashlpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Random number generator clock enable during Sleep mode"]
pub const fn rnglpen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Random number generator clock enable during Sleep mode"]
pub fn set_rnglpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USB OTG FS clock enable during Sleep mode"]
pub const fn usb_otg_fslpen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USB OTG FS clock enable during Sleep mode"]
pub fn set_usb_otg_fslpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Ahb2lpenr { fn default () -> Ahb2lpenr { Ahb2lpenr (0) } } # [doc = "AHB1 peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahb1rstr (pub u32) ; impl Ahb1rstr { # [doc = "IO port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "IO port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "IO port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "IO port C reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port C reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port D reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port D reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port E reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port E reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port F reset"]
pub const fn gpiofrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port F reset"]
pub fn set_gpiofrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port G reset"]
pub const fn gpiogrst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port G reset"]
pub fn set_gpiogrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port H reset"]
pub const fn gpiohrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port H reset"]
pub fn set_gpiohrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port I reset"]
pub const fn gpioirst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port I reset"]
pub fn set_gpioirst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CRC reset"]
pub const fn crcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "CRC reset"]
pub fn set_crcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DMA2 reset"]
pub const fn dma1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "DMA2 reset"]
pub fn set_dma1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "DMA2 reset"]
pub const fn dma2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DMA2 reset"]
pub fn set_dma2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Ethernet MAC reset"]
pub const fn ethmacrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC reset"]
pub fn set_ethmacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "USB OTG HS module reset"]
pub const fn usb_otg_hsrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "USB OTG HS module reset"]
pub fn set_usb_otg_hsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Ahb1rstr { fn default () -> Ahb1rstr { Ahb1rstr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllp (pub u8) ; impl Pllp { # [doc = "PLLP=2"]
pub const DIV2 : Self = Self (0) ; # [doc = "PLLP=4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "PLLP=6"]
pub const DIV6 : Self = Self (0x02) ; # [doc = "PLLP=8"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcopre (pub u8) ; impl Mcopre { # [doc = "No division"]
pub const DIV1 : Self = Self (0) ; # [doc = "Division by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "Division by 3"]
pub const DIV3 : Self = Self (0x05) ; # [doc = "Division by 4"]
pub const DIV4 : Self = Self (0x06) ; # [doc = "Division by 5"]
pub const DIV5 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsrc (pub u8) ; impl Pllsrc { # [doc = "HSI clock selected as PLL and PLLI2S clock entry"]
pub const HSI : Self = Self (0) ; # [doc = "HSE oscillator clock selected as PLL and PLLI2S clock entry"]
pub const HSE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco2 (pub u8) ; impl Mco2 { # [doc = "System clock (SYSCLK) selected"]
pub const SYSCLK : Self = Self (0) ; # [doc = "PLLI2S clock selected"]
pub const PLLI2S : Self = Self (0x01) ; # [doc = "HSE oscillator clock selected"]
pub const HSE : Self = Self (0x02) ; # [doc = "PLL clock selected"]
pub const PLL : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Issrc (pub u8) ; impl Issrc { # [doc = "PLLI2S clock used as I2S clock source"]
pub const PLLI2S : Self = Self (0) ; # [doc = "External clock mapped on the I2S_CKIN pin used as I2S clock source"]
pub const CKIN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ppre (pub u8) ; impl Ppre { # [doc = "HCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HCLK divided by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "HCLK divided by 4"]
pub const DIV4 : Self = Self (0x05) ; # [doc = "HCLK divided by 8"]
pub const DIV8 : Self = Self (0x06) ; # [doc = "HCLK divided by 16"]
pub const DIV16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcsel (pub u8) ; impl Rtcsel { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "LSE oscillator clock used as RTC clock"]
pub const LSE : Self = Self (0x01) ; # [doc = "LSI oscillator clock used as RTC clock"]
pub const LSI : Self = Self (0x02) ; # [doc = "HSE oscillator clock divided by a prescaler used as RTC clock"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swsr (pub u8) ; impl Swsr { # [doc = "HSI oscillator used as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE oscillator used as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL used as system clock"]
pub const PLL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sw (pub u8) ; impl Sw { # [doc = "HSI selected as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE selected as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL selected as system clock"]
pub const PLL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpre (pub u8) ; impl Hpre { # [doc = "SYSCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "SYSCLK divided by 2"]
pub const DIV2 : Self = Self (0x08) ; # [doc = "SYSCLK divided by 4"]
pub const DIV4 : Self = Self (0x09) ; # [doc = "SYSCLK divided by 8"]
pub const DIV8 : Self = Self (0x0a) ; # [doc = "SYSCLK divided by 16"]
pub const DIV16 : Self = Self (0x0b) ; # [doc = "SYSCLK divided by 64"]
pub const DIV64 : Self = Self (0x0c) ; # [doc = "SYSCLK divided by 128"]
pub const DIV128 : Self = Self (0x0d) ; # [doc = "SYSCLK divided by 256"]
pub const DIV256 : Self = Self (0x0e) ; # [doc = "SYSCLK divided by 512"]
pub const DIV512 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco1 (pub u8) ; impl Mco1 { # [doc = "HSI clock selected"]
pub const HSI : Self = Self (0) ; # [doc = "LSE oscillator selected"]
pub const LSE : Self = Self (0x01) ; # [doc = "HSE oscillator clock selected"]
pub const HSE : Self = Self (0x02) ; # [doc = "PLL clock selected"]
pub const PLL : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spreadsel (pub u8) ; impl Spreadsel { # [doc = "Center spread"]
pub const CENTER : Self = Self (0) ; # [doc = "Down spread"]
pub const DOWN : Self = Self (0x01) ; } }