

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "Clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Clock configuration register (RCC_CFGR)"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Clock interrupt register (RCC_CIR)"]
pub fn cir (self) -> crate :: common :: Reg < regs :: Cir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "APB2 peripheral reset register (RCC_APB2RSTR)"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "APB1 peripheral reset register (RCC_APB1RSTR)"]
pub fn apb1rstr (self) -> crate :: common :: Reg < regs :: Apb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "AHB Peripheral Clock enable register (RCC_AHBENR)"]
pub fn ahbenr (self) -> crate :: common :: Reg < regs :: Ahbenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "APB2 peripheral clock enable register (RCC_APB2ENR)"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "APB1 peripheral clock enable register (RCC_APB1ENR)"]
pub fn apb1enr (self) -> crate :: common :: Reg < regs :: Apb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Backup domain control register (RCC_BDCR)"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Control/status register (RCC_CSR)"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "AHB peripheral clock reset register (RCC_AHBRSTR)"]
pub fn ahbrstr (self) -> crate :: common :: Reg < regs :: Ahbrstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "Clock configuration register 2"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } } pub mod regs { # [doc = "Clock interrupt register (RCC_CIR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cir (pub u32) ; impl Cir { # [doc = "LSI Ready Interrupt flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE Ready Interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI Ready Interrupt flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE Ready Interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "PLL Ready Interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PLL2 Ready Interrupt flag"]
pub const fn pll2rdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PLL2 Ready Interrupt flag"]
pub fn set_pll2rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "PLL3 Ready Interrupt flag"]
pub const fn pll3rdyf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "PLL3 Ready Interrupt flag"]
pub fn set_pll3rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Clock Security System Interrupt flag"]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Clock Security System Interrupt flag"]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LSI Ready Interrupt Enable"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt Enable"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Ready Interrupt Enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt Enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI Ready Interrupt Enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt Enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSE Ready Interrupt Enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt Enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "PLL Ready Interrupt Enable"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt Enable"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "PLL2 Ready Interrupt Enable"]
pub const fn pll2rdyie (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "PLL2 Ready Interrupt Enable"]
pub fn set_pll2rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "PLL3 Ready Interrupt Enable"]
pub const fn pll3rdyie (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "PLL3 Ready Interrupt Enable"]
pub fn set_pll3rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "LSI Ready Interrupt Clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt Clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "LSE Ready Interrupt Clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt Clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSI Ready Interrupt Clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt Clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSE Ready Interrupt Clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt Clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "PLL Ready Interrupt Clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt Clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "PLL2 Ready Interrupt Clear"]
pub const fn pll2rdyc (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "PLL2 Ready Interrupt Clear"]
pub fn set_pll2rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "PLL3 Ready Interrupt Clear"]
pub const fn pll3rdyc (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "PLL3 Ready Interrupt Clear"]
pub fn set_pll3rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Clock security system interrupt clear"]
pub const fn cssc (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt clear"]
pub fn set_cssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cir { fn default () -> Cir { Cir (0) } } # [doc = "APB1 peripheral reset register (RCC_APB1RSTR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr (pub u32) ; impl Apb1rstr { # [doc = "Timer 2 reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer 2 reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 reset"]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 reset"]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 4 reset"]
pub const fn tim4rst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Timer 4 reset"]
pub fn set_tim4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Timer 5 reset"]
pub const fn tim5rst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Timer 5 reset"]
pub fn set_tim5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Timer 6 reset"]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 reset"]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Timer 7 reset"]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Timer 7 reset"]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Timer 12 reset"]
pub const fn tim12rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Timer 12 reset"]
pub fn set_tim12rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Timer 13 reset"]
pub const fn tim13rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Timer 13 reset"]
pub fn set_tim13rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Timer 14 reset"]
pub const fn tim14rst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Timer 14 reset"]
pub fn set_tim14rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Window watchdog reset"]
pub const fn wwdgrst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset"]
pub fn set_wwdgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI3 reset"]
pub const fn spi3rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI3 reset"]
pub fn set_spi3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART 2 reset"]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 reset"]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART 3 reset"]
pub const fn usart3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART 3 reset"]
pub fn set_usart3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USART 4 reset"]
pub const fn uart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "USART 4 reset"]
pub fn set_uart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "USART 5 reset"]
pub const fn uart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "USART 5 reset"]
pub fn set_uart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB reset"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB reset"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN1 reset"]
pub const fn can1rst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN1 reset"]
pub fn set_can1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN reset"]
pub const fn canrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN reset"]
pub fn set_canrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN2 reset"]
pub const fn can2rst (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN2 reset"]
pub fn set_can2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Backup interface reset"]
pub const fn bkprst (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Backup interface reset"]
pub fn set_bkprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface reset"]
pub const fn pwrrst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface reset"]
pub fn set_pwrrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface reset"]
pub const fn dacrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface reset"]
pub fn set_dacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "CEC reset"]
pub const fn cecrst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "CEC reset"]
pub fn set_cecrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Apb1rstr { fn default () -> Apb1rstr { Apb1rstr (0) } } # [doc = "AHB peripheral clock reset register (RCC_AHBRSTR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbrstr (pub u32) ; impl Ahbrstr { # [doc = "USB OTG FS reset"]
pub const fn usb_otg_fsrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "USB OTG FS reset"]
pub fn set_usb_otg_fsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Ethernet MAC reset"]
pub const fn ethmacrst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC reset"]
pub fn set_ethmacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for Ahbrstr { fn default () -> Ahbrstr { Ahbrstr (0) } } # [doc = "Backup domain control register (RCC_BDCR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "External Low Speed oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "External Low Speed oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External Low Speed oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> super :: vals :: Rtcsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Rtcsel (val as u8) } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : super :: vals :: Rtcsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Backup domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "APB2 peripheral clock enable register (RCC_APB2ENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "Alternate function I/O clock enable"]
pub const fn afioen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Alternate function I/O clock enable"]
pub fn set_afioen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "I/O port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "I/O port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "I/O port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "I/O port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "I/O port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "I/O port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "I/O port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "I/O port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "I/O port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "I/O port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "I/O port F clock enable"]
pub const fn gpiofen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "I/O port F clock enable"]
pub fn set_gpiofen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "I/O port G clock enable"]
pub const fn gpiogen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "I/O port G clock enable"]
pub fn set_gpiogen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC 1 interface clock enable"]
pub const fn adc1en (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC 1 interface clock enable"]
pub fn set_adc1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADC 2 interface clock enable"]
pub const fn adc2en (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC 2 interface clock enable"]
pub fn set_adc2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "TIM1 Timer clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 Timer clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 Timer clock enable"]
pub const fn tim8en (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 Timer clock enable"]
pub fn set_tim8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1 clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "ADC3 interface clock enable"]
pub const fn adc3en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "ADC3 interface clock enable"]
pub fn set_adc3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "TIM15 Timer clock enable"]
pub const fn tim15en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 Timer clock enable"]
pub fn set_tim15en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 Timer clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 Timer clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 Timer clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 Timer clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "TIM9 Timer clock enable"]
pub const fn tim9en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "TIM9 Timer clock enable"]
pub fn set_tim9en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "TIM10 Timer clock enable"]
pub const fn tim10en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "TIM10 Timer clock enable"]
pub fn set_tim10en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "TIM11 Timer clock enable"]
pub const fn tim11en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "TIM11 Timer clock enable"]
pub fn set_tim11en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "Clock configuration register (RCC_CFGR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock Switch"]
pub const fn sw (& self) -> super :: vals :: Sw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "System clock Switch"]
pub fn set_sw (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "System Clock Switch Status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "System Clock Switch Status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "AHB prescaler"]
pub const fn hpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 4usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "AHB prescaler"]
pub fn set_hpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val . 0 as u32) & 0x0f) << 4usize) ; } # [doc = "APB Low speed prescaler (APB1)"]
pub const fn ppre1 (& self) -> super :: vals :: Ppre1 { let val = (self . 0 >> 8usize) & 0x07 ; super :: vals :: Ppre1 (val as u8) } # [doc = "APB Low speed prescaler (APB1)"]
pub fn set_ppre1 (& mut self , val : super :: vals :: Ppre1) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val . 0 as u32) & 0x07) << 8usize) ; } # [doc = "APB High speed prescaler (APB2)"]
pub const fn ppre2 (& self) -> super :: vals :: Ppre1 { let val = (self . 0 >> 11usize) & 0x07 ; super :: vals :: Ppre1 (val as u8) } # [doc = "APB High speed prescaler (APB2)"]
pub fn set_ppre2 (& mut self , val : super :: vals :: Ppre1) { self . 0 = (self . 0 & ! (0x07 << 11usize)) | (((val . 0 as u32) & 0x07) << 11usize) ; } # [doc = "ADC prescaler"]
pub const fn adcpre (& self) -> super :: vals :: Adcpre { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: Adcpre (val as u8) } # [doc = "ADC prescaler"]
pub fn set_adcpre (& mut self , val : super :: vals :: Adcpre) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } # [doc = "PLL entry clock source"]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Pllsrc (val as u8) } # [doc = "PLL entry clock source"]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "HSE divider for PLL entry"]
pub const fn pllxtpre (& self) -> super :: vals :: Pllxtpre { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Pllxtpre (val as u8) } # [doc = "HSE divider for PLL entry"]
pub fn set_pllxtpre (& mut self , val : super :: vals :: Pllxtpre) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "PLL Multiplication Factor"]
pub const fn pllmul (& self) -> super :: vals :: Pllmul { let val = (self . 0 >> 18usize) & 0x0f ; super :: vals :: Pllmul (val as u8) } # [doc = "PLL Multiplication Factor"]
pub fn set_pllmul (& mut self , val : super :: vals :: Pllmul) { self . 0 = (self . 0 & ! (0x0f << 18usize)) | (((val . 0 as u32) & 0x0f) << 18usize) ; } # [doc = "USB OTG FS prescaler"]
pub const fn otgfspre (& self) -> super :: vals :: Otgfspre { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Otgfspre (val as u8) } # [doc = "USB OTG FS prescaler"]
pub fn set_otgfspre (& mut self , val : super :: vals :: Otgfspre) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "USB prescaler"]
pub const fn usbpre (& self) -> super :: vals :: Usbpre { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Usbpre (val as u8) } # [doc = "USB prescaler"]
pub fn set_usbpre (& mut self , val : super :: vals :: Usbpre) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Microcontroller clock output"]
pub const fn mco (& self) -> super :: vals :: Mco { let val = (self . 0 >> 24usize) & 0x07 ; super :: vals :: Mco (val as u8) } # [doc = "Microcontroller clock output"]
pub fn set_mco (& mut self , val : super :: vals :: Mco) { self . 0 = (self . 0 & ! (0x07 << 24usize)) | (((val . 0 as u32) & 0x07) << 24usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "Clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Internal High Speed clock enable"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal High Speed clock enable"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal High Speed clock ready flag"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal High Speed clock ready flag"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Internal High Speed clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x1f ; val as u8 } # [doc = "Internal High Speed clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 3usize)) | (((val as u32) & 0x1f) << 3usize) ; } # [doc = "Internal High Speed clock Calibration"]
pub const fn hsical (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Internal High Speed clock Calibration"]
pub fn set_hsical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "External High Speed clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "External High Speed clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "External High Speed clock Bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock Bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Clock Security System enable"]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Clock Security System enable"]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "PLL enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "PLL enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "PLL clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "PLL clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PLL2 enable"]
pub const fn pll2on (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PLL2 enable"]
pub fn set_pll2on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "PLL2 clock ready flag"]
pub const fn pll2rdy (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "PLL2 clock ready flag"]
pub fn set_pll2rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "PLL3 enable"]
pub const fn pll3on (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "PLL3 enable"]
pub fn set_pll3on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "PLL3 clock ready flag"]
pub const fn pll3rdy (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "PLL3 clock ready flag"]
pub fn set_pll3rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "AHB Peripheral Clock enable register (RCC_AHBENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbenr (pub u32) ; impl Ahbenr { # [doc = "DMA1 clock enable"]
pub const fn dma1en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA1 clock enable"]
pub fn set_dma1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SRAM interface clock enable"]
pub const fn sramen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "SRAM interface clock enable"]
pub fn set_sramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "FLASH clock enable"]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "FLASH clock enable"]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "FSMC clock enable"]
pub const fn fsmcen (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "FSMC clock enable"]
pub fn set_fsmcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "SDIO clock enable"]
pub const fn sdioen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "SDIO clock enable"]
pub fn set_sdioen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "USB OTG FS clock enable"]
pub const fn usb_otg_fsen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "USB OTG FS clock enable"]
pub fn set_usb_otg_fsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Ethernet MAC clock enable"]
pub const fn ethmacen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC clock enable"]
pub fn set_ethmacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Ethernet MAC TX clock enable"]
pub const fn ethmactxen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC TX clock enable"]
pub fn set_ethmactxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Ethernet MAC RX clock enable"]
pub const fn ethmacrxen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Ethernet MAC RX clock enable"]
pub fn set_ethmacrxen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Ahbenr { fn default () -> Ahbenr { Ahbenr (0) } } # [doc = "Clock configuration register2 (RCC_CFGR2)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "PREDIV1 division factor"]
pub const fn prediv1 (& self) -> super :: vals :: Prediv1 { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: Prediv1 (val as u8) } # [doc = "PREDIV1 division factor"]
pub fn set_prediv1 (& mut self , val : super :: vals :: Prediv1) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "PREDIV2 division factor"]
pub const fn prediv2 (& self) -> super :: vals :: Prediv1 { let val = (self . 0 >> 4usize) & 0x0f ; super :: vals :: Prediv1 (val as u8) } # [doc = "PREDIV2 division factor"]
pub fn set_prediv2 (& mut self , val : super :: vals :: Prediv1) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val . 0 as u32) & 0x0f) << 4usize) ; } # [doc = "PLL2 Multiplication Factor"]
pub const fn pll2mul (& self) -> super :: vals :: Pll2mul { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Pll2mul (val as u8) } # [doc = "PLL2 Multiplication Factor"]
pub fn set_pll2mul (& mut self , val : super :: vals :: Pll2mul) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } # [doc = "PLL3 Multiplication Factor"]
pub const fn pll3mul (& self) -> super :: vals :: Pll2mul { let val = (self . 0 >> 12usize) & 0x0f ; super :: vals :: Pll2mul (val as u8) } # [doc = "PLL3 Multiplication Factor"]
pub fn set_pll3mul (& mut self , val : super :: vals :: Pll2mul) { self . 0 = (self . 0 & ! (0x0f << 12usize)) | (((val . 0 as u32) & 0x0f) << 12usize) ; } # [doc = "PREDIV1 entry clock source"]
pub const fn prediv1src (& self) -> super :: vals :: Prediv1src { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Prediv1src (val as u8) } # [doc = "PREDIV1 entry clock source"]
pub fn set_prediv1src (& mut self , val : super :: vals :: Prediv1src) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "I2S2 clock source"]
pub const fn i2s2src (& self) -> super :: vals :: I2s2src { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: I2s2src (val as u8) } # [doc = "I2S2 clock source"]
pub fn set_i2s2src (& mut self , val : super :: vals :: I2s2src) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "I2S3 clock source"]
pub const fn i2s3src (& self) -> super :: vals :: I2s2src { let val = (self . 0 >> 18usize) & 0x01 ; super :: vals :: I2s2src (val as u8) } # [doc = "I2S3 clock source"]
pub fn set_i2s3src (& mut self , val : super :: vals :: I2s2src) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val . 0 as u32) & 0x01) << 18usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "APB2 peripheral reset register (RCC_APB2RSTR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "Alternate function I/O reset"]
pub const fn afiorst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Alternate function I/O reset"]
pub fn set_afiorst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "IO port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "IO port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "IO port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "IO port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IO port C reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IO port C reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "IO port D reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "IO port D reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "IO port E reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "IO port E reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "IO port F reset"]
pub const fn gpiofrst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "IO port F reset"]
pub fn set_gpiofrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IO port G reset"]
pub const fn gpiogrst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "IO port G reset"]
pub fn set_gpiogrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ADC 1 interface reset"]
pub const fn adc1rst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC 1 interface reset"]
pub fn set_adc1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "ADC 2 interface reset"]
pub const fn adc2rst (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "ADC 2 interface reset"]
pub fn set_adc2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "TIM1 timer reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TIM8 timer reset"]
pub const fn tim8rst (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TIM8 timer reset"]
pub fn set_tim8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "ADC 3 interface reset"]
pub const fn adc3rst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "ADC 3 interface reset"]
pub fn set_adc3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "TIM15 timer reset"]
pub const fn tim15rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 timer reset"]
pub fn set_tim15rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 timer reset"]
pub const fn tim16rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer reset"]
pub fn set_tim16rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer reset"]
pub const fn tim17rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer reset"]
pub fn set_tim17rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "TIM9 timer reset"]
pub const fn tim9rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "TIM9 timer reset"]
pub fn set_tim9rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "TIM10 timer reset"]
pub const fn tim10rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "TIM10 timer reset"]
pub fn set_tim10rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "TIM11 timer reset"]
pub const fn tim11rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "TIM11 timer reset"]
pub fn set_tim11rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } # [doc = "APB1 peripheral clock enable register (RCC_APB1ENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr (pub u32) ; impl Apb1enr { # [doc = "Timer 2 clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer 2 clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 clock enable"]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 clock enable"]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 4 clock enable"]
pub const fn tim4en (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Timer 4 clock enable"]
pub fn set_tim4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Timer 5 clock enable"]
pub const fn tim5en (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Timer 5 clock enable"]
pub fn set_tim5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Timer 6 clock enable"]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 clock enable"]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Timer 7 clock enable"]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Timer 7 clock enable"]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Timer 12 clock enable"]
pub const fn tim12en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Timer 12 clock enable"]
pub fn set_tim12en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Timer 13 clock enable"]
pub const fn tim13en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Timer 13 clock enable"]
pub fn set_tim13en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Timer 14 clock enable"]
pub const fn tim14en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Timer 14 clock enable"]
pub fn set_tim14en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI 2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SPI 3 clock enable"]
pub const fn spi3en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SPI 3 clock enable"]
pub fn set_spi3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "USART 2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART 3 clock enable"]
pub const fn usart3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART 3 clock enable"]
pub fn set_usart3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "UART 4 clock enable"]
pub const fn uart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "UART 4 clock enable"]
pub fn set_uart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "UART 5 clock enable"]
pub const fn uart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "UART 5 clock enable"]
pub fn set_uart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C 1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C 1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C 2 clock enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C 2 clock enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB clock enable"]
pub const fn usben (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB clock enable"]
pub fn set_usben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN1 clock enable"]
pub const fn can1en (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN1 clock enable"]
pub fn set_can1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN clock enable"]
pub const fn canen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN clock enable"]
pub fn set_canen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN2 clock enable"]
pub const fn can2en (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN2 clock enable"]
pub fn set_can2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Backup interface clock enable"]
pub const fn bkpen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Backup interface clock enable"]
pub fn set_bkpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface clock enable"]
pub const fn pwren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable"]
pub fn set_pwren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable"]
pub const fn dacen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable"]
pub fn set_dacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "CEC clock enable"]
pub const fn cecen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "CEC clock enable"]
pub fn set_cecen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Apb1enr { fn default () -> Apb1enr { Apb1enr (0) } } # [doc = "Control/status register (RCC_CSR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Internal low speed oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal low speed oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal low speed oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal low speed oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "PIN reset flag"]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PIN reset flag"]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "POR/PDR reset flag"]
pub const fn porrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "POR/PDR reset flag"]
pub fn set_porrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent watchdog reset flag"]
pub const fn iwdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog reset flag"]
pub fn set_iwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usbpre (pub u8) ; impl Usbpre { # [doc = "PLL clock is divided by 1.5"]
pub const DIV1_5 : Self = Self (0) ; # [doc = "PLL clock is not divided"]
pub const DIV1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpre (pub u8) ; impl Hpre { # [doc = "SYSCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "SYSCLK divided by 2"]
pub const DIV2 : Self = Self (0x08) ; # [doc = "SYSCLK divided by 4"]
pub const DIV4 : Self = Self (0x09) ; # [doc = "SYSCLK divided by 8"]
pub const DIV8 : Self = Self (0x0a) ; # [doc = "SYSCLK divided by 16"]
pub const DIV16 : Self = Self (0x0b) ; # [doc = "SYSCLK divided by 64"]
pub const DIV64 : Self = Self (0x0c) ; # [doc = "SYSCLK divided by 128"]
pub const DIV128 : Self = Self (0x0d) ; # [doc = "SYSCLK divided by 256"]
pub const DIV256 : Self = Self (0x0e) ; # [doc = "SYSCLK divided by 512"]
pub const DIV512 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sw (pub u8) ; impl Sw { # [doc = "HSI selected as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE selected as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL selected as system clock"]
pub const PLL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllmul (pub u8) ; impl Pllmul { # [doc = "PLL input clock x2"]
pub const MUL2 : Self = Self (0) ; # [doc = "PLL input clock x3"]
pub const MUL3 : Self = Self (0x01) ; # [doc = "PLL input clock x4"]
pub const MUL4 : Self = Self (0x02) ; # [doc = "PLL input clock x5"]
pub const MUL5 : Self = Self (0x03) ; # [doc = "PLL input clock x6"]
pub const MUL6 : Self = Self (0x04) ; # [doc = "PLL input clock x7"]
pub const MUL7 : Self = Self (0x05) ; # [doc = "PLL input clock x8"]
pub const MUL8 : Self = Self (0x06) ; # [doc = "PLL input clock x9"]
pub const MUL9 : Self = Self (0x07) ; # [doc = "PLL input clock x10"]
pub const MUL10 : Self = Self (0x08) ; # [doc = "PLL input clock x11"]
pub const MUL11 : Self = Self (0x09) ; # [doc = "PLL input clock x12"]
pub const MUL12 : Self = Self (0x0a) ; # [doc = "PLL input clock x13"]
pub const MUL13 : Self = Self (0x0b) ; # [doc = "PLL input clock x14"]
pub const MUL14 : Self = Self (0x0c) ; # [doc = "PLL input clock x15"]
pub const MUL15 : Self = Self (0x0d) ; # [doc = "PLL input clock x16"]
pub const MUL16 : Self = Self (0x0e) ; # [doc = "PLL input clock x16"]
pub const MUL16X : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Otgfspre (pub u8) ; impl Otgfspre { # [doc = "PLL clock is divided by 1.5"]
pub const DIV1_5 : Self = Self (0) ; # [doc = "PLL clock is not divided"]
pub const DIV1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adcpre (pub u8) ; impl Adcpre { # [doc = "PCLK2 divided by 2"]
pub const DIV2 : Self = Self (0) ; # [doc = "PCLK2 divided by 4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "PCLK2 divided by 8"]
pub const DIV6 : Self = Self (0x02) ; # [doc = "PCLK2 divided by 16"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsrc (pub u8) ; impl Pllsrc { # [doc = "HSI divided by 2 selected as PLL input clock"]
pub const HSI_DIV2 : Self = Self (0) ; # [doc = "HSE divided by PREDIV selected as PLL input clock"]
pub const HSE_DIV_PREDIV : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pll2mul (pub u8) ; impl Pll2mul { # [doc = "PLL clock entry x8"]
pub const MUL8 : Self = Self (0x06) ; # [doc = "PLL clock entry x9"]
pub const MUL9 : Self = Self (0x07) ; # [doc = "PLL clock entry x10"]
pub const MUL10 : Self = Self (0x08) ; # [doc = "PLL clock entry x11"]
pub const MUL11 : Self = Self (0x09) ; # [doc = "PLL clock entry x12"]
pub const MUL12 : Self = Self (0x0a) ; # [doc = "PLL clock entry x13"]
pub const MUL13 : Self = Self (0x0b) ; # [doc = "PLL clock entry x14"]
pub const MUL14 : Self = Self (0x0c) ; # [doc = "PLL clock entry x16"]
pub const MUL16 : Self = Self (0x0e) ; # [doc = "PLL clock entry x20"]
pub const MUL20 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ppre1 (pub u8) ; impl Ppre1 { # [doc = "HCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HCLK divided by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "HCLK divided by 4"]
pub const DIV4 : Self = Self (0x05) ; # [doc = "HCLK divided by 8"]
pub const DIV8 : Self = Self (0x06) ; # [doc = "HCLK divided by 16"]
pub const DIV16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prediv1src (pub u8) ; impl Prediv1src { # [doc = "HSE oscillator clock selected as PREDIV1 clock entry"]
pub const HSE : Self = Self (0) ; # [doc = "PLL2 selected as PREDIV1 clock entry"]
pub const PLL2 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcsel (pub u8) ; impl Rtcsel { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "LSE oscillator clock used as RTC clock"]
pub const LSE : Self = Self (0x01) ; # [doc = "LSI oscillator clock used as RTC clock"]
pub const LSI : Self = Self (0x02) ; # [doc = "HSE oscillator clock divided by a prescaler used as RTC clock"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prediv1 (pub u8) ; impl Prediv1 { # [doc = "PREDIV input clock not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "PREDIV input clock divided by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "PREDIV input clock divided by 3"]
pub const DIV3 : Self = Self (0x02) ; # [doc = "PREDIV input clock divided by 4"]
pub const DIV4 : Self = Self (0x03) ; # [doc = "PREDIV input clock divided by 5"]
pub const DIV5 : Self = Self (0x04) ; # [doc = "PREDIV input clock divided by 6"]
pub const DIV6 : Self = Self (0x05) ; # [doc = "PREDIV input clock divided by 7"]
pub const DIV7 : Self = Self (0x06) ; # [doc = "PREDIV input clock divided by 8"]
pub const DIV8 : Self = Self (0x07) ; # [doc = "PREDIV input clock divided by 9"]
pub const DIV9 : Self = Self (0x08) ; # [doc = "PREDIV input clock divided by 10"]
pub const DIV10 : Self = Self (0x09) ; # [doc = "PREDIV input clock divided by 11"]
pub const DIV11 : Self = Self (0x0a) ; # [doc = "PREDIV input clock divided by 12"]
pub const DIV12 : Self = Self (0x0b) ; # [doc = "PREDIV input clock divided by 13"]
pub const DIV13 : Self = Self (0x0c) ; # [doc = "PREDIV input clock divided by 14"]
pub const DIV14 : Self = Self (0x0d) ; # [doc = "PREDIV input clock divided by 15"]
pub const DIV15 : Self = Self (0x0e) ; # [doc = "PREDIV input clock divided by 16"]
pub const DIV16 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllxtpre (pub u8) ; impl Pllxtpre { # [doc = "HSE clock not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HSE clock divided by 2"]
pub const DIV2 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct I2s2src (pub u8) ; impl I2s2src { # [doc = "System clock (SYSCLK) selected as I2S clock entry"]
pub const SYSCLK : Self = Self (0) ; # [doc = "PLL3 VCO clock selected as I2S clock entry"]
pub const PLL3 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco (pub u8) ; impl Mco { # [doc = "MCO output disabled, no clock on MCO"]
pub const NOMCO : Self = Self (0) ; # [doc = "System clock selected"]
pub const SYSCLK : Self = Self (0x04) ; # [doc = "HSI oscillator clock selected"]
pub const HSI : Self = Self (0x05) ; # [doc = "HSE oscillator clock selected"]
pub const HSE : Self = Self (0x06) ; # [doc = "PLL clock selected (divided by 1 or 2, depending en PLLNODIV)"]
pub const PLL : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swsr (pub u8) ; impl Swsr { # [doc = "HSI oscillator used as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE oscillator used as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL used as system clock"]
pub const PLL : Self = Self (0x02) ; } }