

# [doc = "Reset and clock control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rcc (pub * mut u8) ; unsafe impl Send for Rcc { } unsafe impl Sync for Rcc { } impl Rcc { # [doc = "Clock control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Clock configuration register (RCC_CFGR)"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Clock interrupt register (RCC_CIR)"]
pub fn cir (self) -> crate :: common :: Reg < regs :: Cir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "APB2 peripheral reset register (RCC_APB2RSTR)"]
pub fn apb2rstr (self) -> crate :: common :: Reg < regs :: Apb2rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "APB1 peripheral reset register (RCC_APB1RSTR)"]
pub fn apb1rstr (self) -> crate :: common :: Reg < regs :: Apb1rstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "AHB Peripheral Clock enable register (RCC_AHBENR)"]
pub fn ahbenr (self) -> crate :: common :: Reg < regs :: Ahbenr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "APB2 peripheral clock enable register (RCC_APB2ENR)"]
pub fn apb2enr (self) -> crate :: common :: Reg < regs :: Apb2enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "APB1 peripheral clock enable register (RCC_APB1ENR)"]
pub fn apb1enr (self) -> crate :: common :: Reg < regs :: Apb1enr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Backup domain control register (RCC_BDCR)"]
pub fn bdcr (self) -> crate :: common :: Reg < regs :: Bdcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Control/status register (RCC_CSR)"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "AHB peripheral reset register"]
pub fn ahbrstr (self) -> crate :: common :: Reg < regs :: Ahbrstr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "Clock configuration register 2"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "Clock configuration register 3"]
pub fn cfgr3 (self) -> crate :: common :: Reg < regs :: Cfgr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "Clock control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } } pub mod regs { # [doc = "Control/status register (RCC_CSR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Internal low speed oscillator enable"]
pub const fn lsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal low speed oscillator enable"]
pub fn set_lsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal low speed oscillator ready"]
pub const fn lsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal low speed oscillator ready"]
pub fn set_lsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "1.8 V domain reset flag"]
pub const fn v18pwrrstf (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "1.8 V domain reset flag"]
pub fn set_v18pwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Remove reset flag"]
pub const fn rmvf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Remove reset flag"]
pub fn set_rmvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Option byte loader reset flag"]
pub const fn oblrstf (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Option byte loader reset flag"]
pub fn set_oblrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PIN reset flag"]
pub const fn pinrstf (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PIN reset flag"]
pub fn set_pinrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "POR/PDR reset flag"]
pub const fn porrstf (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "POR/PDR reset flag"]
pub fn set_porrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Software reset flag"]
pub const fn sftrstf (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Software reset flag"]
pub fn set_sftrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Independent watchdog reset flag"]
pub const fn iwdgrstf (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog reset flag"]
pub fn set_iwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Window watchdog reset flag"]
pub const fn wwdgrstf (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset flag"]
pub fn set_wwdgrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Low-power reset flag"]
pub const fn lpwrrstf (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Low-power reset flag"]
pub fn set_lpwrrstf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "Clock configuration register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr3 (pub u32) ; impl Cfgr3 { # [doc = "USART1 clock source selection"]
pub const fn usart1sw (& self) -> super :: vals :: Usartsw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Usartsw (val as u8) } # [doc = "USART1 clock source selection"]
pub fn set_usart1sw (& mut self , val : super :: vals :: Usartsw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "I2C1 clock source selection"]
pub const fn i2c1sw (& self) -> super :: vals :: Icsw { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Icsw (val as u8) } # [doc = "I2C1 clock source selection"]
pub fn set_i2c1sw (& mut self , val : super :: vals :: Icsw) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "HDMI CEC clock source selection"]
pub const fn cecsw (& self) -> super :: vals :: Cecsw { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Cecsw (val as u8) } # [doc = "HDMI CEC clock source selection"]
pub fn set_cecsw (& mut self , val : super :: vals :: Cecsw) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "USB clock source selection"]
pub const fn usbsw (& self) -> super :: vals :: Usbsw { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Usbsw (val as u8) } # [doc = "USB clock source selection"]
pub fn set_usbsw (& mut self , val : super :: vals :: Usbsw) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "ADCSW is deprecated. See ADC field in CFGR2 register."]
pub const fn adcsw (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "ADCSW is deprecated. See ADC field in CFGR2 register."]
pub fn set_adcsw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "USART2 clock source selection"]
pub const fn usart2sw (& self) -> super :: vals :: Usartsw { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Usartsw (val as u8) } # [doc = "USART2 clock source selection"]
pub fn set_usart2sw (& mut self , val : super :: vals :: Usartsw) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "USART3 clock source"]
pub const fn usart3sw (& self) -> super :: vals :: Usartsw { let val = (self . 0 >> 18usize) & 0x03 ; super :: vals :: Usartsw (val as u8) } # [doc = "USART3 clock source"]
pub fn set_usart3sw (& mut self , val : super :: vals :: Usartsw) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val . 0 as u32) & 0x03) << 18usize) ; } } impl Default for Cfgr3 { fn default () -> Cfgr3 { Cfgr3 (0) } } # [doc = "Backup domain control register (RCC_BDCR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr (pub u32) ; impl Bdcr { # [doc = "External Low Speed oscillator enable"]
pub const fn lseon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator enable"]
pub fn set_lseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "External Low Speed oscillator ready"]
pub const fn lserdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator ready"]
pub fn set_lserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External Low Speed oscillator bypass"]
pub const fn lsebyp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "External Low Speed oscillator bypass"]
pub fn set_lsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "LSE oscillator drive capability"]
pub const fn lsedrv (& self) -> super :: vals :: Lsedrv { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Lsedrv (val as u8) } # [doc = "LSE oscillator drive capability"]
pub fn set_lsedrv (& mut self , val : super :: vals :: Lsedrv) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "RTC clock source selection"]
pub const fn rtcsel (& self) -> super :: vals :: Rtcsel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Rtcsel (val as u8) } # [doc = "RTC clock source selection"]
pub fn set_rtcsel (& mut self , val : super :: vals :: Rtcsel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "RTC clock enable"]
pub const fn rtcen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RTC clock enable"]
pub fn set_rtcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Backup domain software reset"]
pub const fn bdrst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup domain software reset"]
pub fn set_bdrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Bdcr { fn default () -> Bdcr { Bdcr (0) } } # [doc = "Clock configuration register (RCC_CFGR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "System clock Switch"]
pub const fn sw (& self) -> super :: vals :: Sw { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Sw (val as u8) } # [doc = "System clock Switch"]
pub fn set_sw (& mut self , val : super :: vals :: Sw) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "System Clock Switch Status"]
pub const fn sws (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "System Clock Switch Status"]
pub fn set_sws (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "AHB prescaler"]
pub const fn hpre (& self) -> super :: vals :: Hpre { let val = (self . 0 >> 4usize) & 0x0f ; super :: vals :: Hpre (val as u8) } # [doc = "AHB prescaler"]
pub fn set_hpre (& mut self , val : super :: vals :: Hpre) { self . 0 = (self . 0 & ! (0x0f << 4usize)) | (((val . 0 as u32) & 0x0f) << 4usize) ; } # [doc = "APB Low speed prescaler (APB1)"]
pub const fn ppre (& self) -> super :: vals :: Ppre { let val = (self . 0 >> 8usize) & 0x07 ; super :: vals :: Ppre (val as u8) } # [doc = "APB Low speed prescaler (APB1)"]
pub fn set_ppre (& mut self , val : super :: vals :: Ppre) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val . 0 as u32) & 0x07) << 8usize) ; } # [doc = "APCPRE is deprecated. See ADC field in CFGR2 register."]
pub const fn adcpre (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "APCPRE is deprecated. See ADC field in CFGR2 register."]
pub fn set_adcpre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "PLL input clock source"]
pub const fn pllsrc (& self) -> super :: vals :: Pllsrc { let val = (self . 0 >> 15usize) & 0x03 ; super :: vals :: Pllsrc (val as u8) } # [doc = "PLL input clock source"]
pub fn set_pllsrc (& mut self , val : super :: vals :: Pllsrc) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val . 0 as u32) & 0x03) << 15usize) ; } # [doc = "HSE divider for PLL entry. Same bit as PREDIC[0]
from CFGR2 register. Refer to it for its meaning"]
pub const fn pllxtpre (& self) -> super :: vals :: Pllxtpre { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Pllxtpre (val as u8) } # [doc = "HSE divider for PLL entry. Same bit as PREDIC[0]
from CFGR2 register. Refer to it for its meaning"]
pub fn set_pllxtpre (& mut self , val : super :: vals :: Pllxtpre) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "PLL Multiplication Factor"]
pub const fn pllmul (& self) -> super :: vals :: Pllmul { let val = (self . 0 >> 18usize) & 0x0f ; super :: vals :: Pllmul (val as u8) } # [doc = "PLL Multiplication Factor"]
pub fn set_pllmul (& mut self , val : super :: vals :: Pllmul) { self . 0 = (self . 0 & ! (0x0f << 18usize)) | (((val . 0 as u32) & 0x0f) << 18usize) ; } # [doc = "Microcontroller clock output"]
pub const fn mco (& self) -> super :: vals :: Mco { let val = (self . 0 >> 24usize) & 0x07 ; super :: vals :: Mco (val as u8) } # [doc = "Microcontroller clock output"]
pub fn set_mco (& mut self , val : super :: vals :: Mco) { self . 0 = (self . 0 & ! (0x07 << 24usize)) | (((val . 0 as u32) & 0x07) << 24usize) ; } # [doc = "Microcontroller Clock Output Prescaler"]
pub const fn mcopre (& self) -> super :: vals :: Mcopre { let val = (self . 0 >> 28usize) & 0x07 ; super :: vals :: Mcopre (val as u8) } # [doc = "Microcontroller Clock Output Prescaler"]
pub fn set_mcopre (& mut self , val : super :: vals :: Mcopre) { self . 0 = (self . 0 & ! (0x07 << 28usize)) | (((val . 0 as u32) & 0x07) << 28usize) ; } # [doc = "PLL clock not divided for MCO"]
pub const fn pllnodiv (& self) -> super :: vals :: Pllnodiv { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Pllnodiv (val as u8) } # [doc = "PLL clock not divided for MCO"]
pub fn set_pllnodiv (& mut self , val : super :: vals :: Pllnodiv) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "APB1 peripheral clock enable register (RCC_APB1ENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1enr (pub u32) ; impl Apb1enr { # [doc = "Timer 2 clock enable"]
pub const fn tim2en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer 2 clock enable"]
pub fn set_tim2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 clock enable"]
pub const fn tim3en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 clock enable"]
pub fn set_tim3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 6 clock enable"]
pub const fn tim6en (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 clock enable"]
pub fn set_tim6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 timer clock enable"]
pub const fn tim7en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 timer clock enable"]
pub fn set_tim7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Timer 14 clock enable"]
pub const fn tim14en (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Timer 14 clock enable"]
pub fn set_tim14en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Window watchdog clock enable"]
pub const fn wwdgen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog clock enable"]
pub fn set_wwdgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 2 clock enable"]
pub const fn spi2en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI 2 clock enable"]
pub fn set_spi2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART 2 clock enable"]
pub const fn usart2en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 clock enable"]
pub fn set_usart2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 clock enable"]
pub const fn usart3en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 clock enable"]
pub fn set_usart3en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USART4 clock enable"]
pub const fn usart4en (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "USART4 clock enable"]
pub fn set_usart4en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "USART5 clock enable"]
pub const fn usart5en (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "USART5 clock enable"]
pub fn set_usart5en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C 1 clock enable"]
pub const fn i2c1en (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C 1 clock enable"]
pub fn set_i2c1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C 2 clock enable"]
pub const fn i2c2en (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C 2 clock enable"]
pub fn set_i2c2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB interface clock enable"]
pub const fn usben (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB interface clock enable"]
pub fn set_usben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN interface clock enable"]
pub const fn canen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN interface clock enable"]
pub fn set_canen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Clock Recovery System interface clock enable"]
pub const fn crsen (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Clock Recovery System interface clock enable"]
pub fn set_crsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface clock enable"]
pub const fn pwren (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface clock enable"]
pub fn set_pwren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface clock enable"]
pub const fn dacen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface clock enable"]
pub fn set_dacen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "HDMI CEC interface clock enable"]
pub const fn cecen (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "HDMI CEC interface clock enable"]
pub fn set_cecen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Apb1enr { fn default () -> Apb1enr { Apb1enr (0) } } # [doc = "AHB Peripheral Clock enable register (RCC_AHBENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbenr (pub u32) ; impl Ahbenr { # [doc = "DMA clock enable"]
pub const fn dmaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMA clock enable"]
pub fn set_dmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA2 clock enable"]
pub const fn dma2en (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMA2 clock enable"]
pub fn set_dma2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SRAM interface clock enable"]
pub const fn sramen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "SRAM interface clock enable"]
pub fn set_sramen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "FLASH clock enable"]
pub const fn flashen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "FLASH clock enable"]
pub fn set_flashen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "CRC clock enable"]
pub const fn crcen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "CRC clock enable"]
pub fn set_crcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "I/O port A clock enable"]
pub const fn gpioaen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "I/O port A clock enable"]
pub fn set_gpioaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "I/O port B clock enable"]
pub const fn gpioben (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "I/O port B clock enable"]
pub fn set_gpioben (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "I/O port C clock enable"]
pub const fn gpiocen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "I/O port C clock enable"]
pub fn set_gpiocen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "I/O port D clock enable"]
pub const fn gpioden (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "I/O port D clock enable"]
pub fn set_gpioden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I/O port E clock enable"]
pub const fn gpioeen (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I/O port E clock enable"]
pub fn set_gpioeen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I/O port F clock enable"]
pub const fn gpiofen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I/O port F clock enable"]
pub fn set_gpiofen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Touch sensing controller clock enable"]
pub const fn tscen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Touch sensing controller clock enable"]
pub fn set_tscen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Ahbenr { fn default () -> Ahbenr { Ahbenr (0) } } # [doc = "APB2 peripheral clock enable register (RCC_APB2ENR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2enr (pub u32) ; impl Apb2enr { # [doc = "SYSCFG clock enable"]
pub const fn syscfgen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYSCFG clock enable"]
pub fn set_syscfgen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "USART6 clock enable"]
pub const fn usart6en (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 clock enable"]
pub fn set_usart6en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "USART7 clock enable"]
pub const fn usart7en (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "USART7 clock enable"]
pub fn set_usart7en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USART8 clock enable"]
pub const fn usart8en (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USART8 clock enable"]
pub fn set_usart8en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "ADC 1 interface clock enable"]
pub const fn adcen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC 1 interface clock enable"]
pub fn set_adcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TIM1 Timer clock enable"]
pub const fn tim1en (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 Timer clock enable"]
pub fn set_tim1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 clock enable"]
pub const fn spi1en (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 clock enable"]
pub fn set_spi1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1 clock enable"]
pub const fn usart1en (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 clock enable"]
pub fn set_usart1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM15 timer clock enable"]
pub const fn tim15en (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 timer clock enable"]
pub fn set_tim15en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 timer clock enable"]
pub const fn tim16en (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer clock enable"]
pub fn set_tim16en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer clock enable"]
pub const fn tim17en (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer clock enable"]
pub fn set_tim17en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "MCU debug module clock enable"]
pub const fn dbgmcuen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "MCU debug module clock enable"]
pub fn set_dbgmcuen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb2enr { fn default () -> Apb2enr { Apb2enr (0) } } # [doc = "AHB peripheral reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ahbrstr (pub u32) ; impl Ahbrstr { # [doc = "I/O port A reset"]
pub const fn gpioarst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "I/O port A reset"]
pub fn set_gpioarst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "I/O port B reset"]
pub const fn gpiobrst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "I/O port B reset"]
pub fn set_gpiobrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "I/O port C reset"]
pub const fn gpiocrst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "I/O port C reset"]
pub fn set_gpiocrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "I/O port D reset"]
pub const fn gpiodrst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "I/O port D reset"]
pub fn set_gpiodrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I/O port E reset"]
pub const fn gpioerst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I/O port E reset"]
pub fn set_gpioerst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I/O port F reset"]
pub const fn gpiofrst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I/O port F reset"]
pub fn set_gpiofrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Touch sensing controller reset"]
pub const fn tscrst (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Touch sensing controller reset"]
pub fn set_tscrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Ahbrstr { fn default () -> Ahbrstr { Ahbrstr (0) } } # [doc = "Clock interrupt register (RCC_CIR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cir (pub u32) ; impl Cir { # [doc = "LSI Ready Interrupt flag"]
pub const fn lsirdyf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt flag"]
pub fn set_lsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LSE Ready Interrupt flag"]
pub const fn lserdyf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt flag"]
pub fn set_lserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI Ready Interrupt flag"]
pub const fn hsirdyf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt flag"]
pub fn set_hsirdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSE Ready Interrupt flag"]
pub const fn hserdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt flag"]
pub fn set_hserdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "PLL Ready Interrupt flag"]
pub const fn pllrdyf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt flag"]
pub fn set_pllrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "HSI14 ready interrupt flag"]
pub const fn hsi14rdyf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "HSI14 ready interrupt flag"]
pub fn set_hsi14rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "HSI48 ready interrupt flag"]
pub const fn hsi48rdyf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt flag"]
pub fn set_hsi48rdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Clock Security System Interrupt flag"]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Clock Security System Interrupt flag"]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "LSI Ready Interrupt Enable"]
pub const fn lsirdyie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt Enable"]
pub fn set_lsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LSE Ready Interrupt Enable"]
pub const fn lserdyie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt Enable"]
pub fn set_lserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "HSI Ready Interrupt Enable"]
pub const fn hsirdyie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt Enable"]
pub fn set_hsirdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "HSE Ready Interrupt Enable"]
pub const fn hserdyie (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt Enable"]
pub fn set_hserdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "PLL Ready Interrupt Enable"]
pub const fn pllrdyie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt Enable"]
pub fn set_pllrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "HSI14 ready interrupt enable"]
pub const fn hsi14rdyie (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "HSI14 ready interrupt enable"]
pub fn set_hsi14rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "HSI48 ready interrupt enable"]
pub const fn hsi48rdyie (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "HSI48 ready interrupt enable"]
pub fn set_hsi48rdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "LSI Ready Interrupt Clear"]
pub const fn lsirdyc (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "LSI Ready Interrupt Clear"]
pub fn set_lsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "LSE Ready Interrupt Clear"]
pub const fn lserdyc (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "LSE Ready Interrupt Clear"]
pub fn set_lserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSI Ready Interrupt Clear"]
pub const fn hsirdyc (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "HSI Ready Interrupt Clear"]
pub fn set_hsirdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "HSE Ready Interrupt Clear"]
pub const fn hserdyc (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "HSE Ready Interrupt Clear"]
pub fn set_hserdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "PLL Ready Interrupt Clear"]
pub const fn pllrdyc (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "PLL Ready Interrupt Clear"]
pub fn set_pllrdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "HSI 14 MHz Ready Interrupt Clear"]
pub const fn hsi14rdyc (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "HSI 14 MHz Ready Interrupt Clear"]
pub fn set_hsi14rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "HSI48 Ready Interrupt Clear"]
pub const fn hsi48rdyc (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "HSI48 Ready Interrupt Clear"]
pub fn set_hsi48rdyc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Clock security system interrupt clear"]
pub const fn cssc (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Clock security system interrupt clear"]
pub fn set_cssc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cir { fn default () -> Cir { Cir (0) } } # [doc = "Clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Internal High Speed clock enable"]
pub const fn hsion (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Internal High Speed clock enable"]
pub fn set_hsion (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Internal High Speed clock ready flag"]
pub const fn hsirdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Internal High Speed clock ready flag"]
pub fn set_hsirdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Internal High Speed clock trimming"]
pub const fn hsitrim (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x1f ; val as u8 } # [doc = "Internal High Speed clock trimming"]
pub fn set_hsitrim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 3usize)) | (((val as u32) & 0x1f) << 3usize) ; } # [doc = "Internal High Speed clock Calibration"]
pub const fn hsical (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Internal High Speed clock Calibration"]
pub fn set_hsical (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "External High Speed clock enable"]
pub const fn hseon (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock enable"]
pub fn set_hseon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "External High Speed clock ready flag"]
pub const fn hserdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock ready flag"]
pub fn set_hserdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "External High Speed clock Bypass"]
pub const fn hsebyp (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "External High Speed clock Bypass"]
pub fn set_hsebyp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Clock Security System enable"]
pub const fn csson (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Clock Security System enable"]
pub fn set_csson (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "PLL enable"]
pub const fn pllon (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "PLL enable"]
pub fn set_pllon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "PLL clock ready flag"]
pub const fn pllrdy (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "PLL clock ready flag"]
pub fn set_pllrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "APB1 peripheral reset register (RCC_APB1RSTR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1rstr (pub u32) ; impl Apb1rstr { # [doc = "Timer 2 reset"]
pub const fn tim2rst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Timer 2 reset"]
pub fn set_tim2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Timer 3 reset"]
pub const fn tim3rst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Timer 3 reset"]
pub fn set_tim3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer 6 reset"]
pub const fn tim6rst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timer 6 reset"]
pub fn set_tim6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 timer reset"]
pub const fn tim7rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 timer reset"]
pub fn set_tim7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Timer 14 reset"]
pub const fn tim14rst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Timer 14 reset"]
pub fn set_tim14rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Window watchdog reset"]
pub const fn wwdgrst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Window watchdog reset"]
pub fn set_wwdgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI2 reset"]
pub const fn spi2rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SPI2 reset"]
pub fn set_spi2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "USART 2 reset"]
pub const fn usart2rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "USART 2 reset"]
pub fn set_usart2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "USART3 reset"]
pub const fn usart3rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "USART3 reset"]
pub fn set_usart3rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "USART4 reset"]
pub const fn usart4rst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "USART4 reset"]
pub fn set_usart4rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "USART5 reset"]
pub const fn usart5rst (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "USART5 reset"]
pub fn set_usart5rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "I2C1 reset"]
pub const fn i2c1rst (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 reset"]
pub fn set_i2c1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 reset"]
pub const fn i2c2rst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 reset"]
pub fn set_i2c2rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "USB interface reset"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "USB interface reset"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CAN interface reset"]
pub const fn canrst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN interface reset"]
pub fn set_canrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Clock Recovery System interface reset"]
pub const fn crsrst (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Clock Recovery System interface reset"]
pub fn set_crsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Power interface reset"]
pub const fn pwrrst (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Power interface reset"]
pub fn set_pwrrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC interface reset"]
pub const fn dacrst (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC interface reset"]
pub fn set_dacrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "HDMI CEC reset"]
pub const fn cecrst (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "HDMI CEC reset"]
pub fn set_cecrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Apb1rstr { fn default () -> Apb1rstr { Apb1rstr (0) } } # [doc = "Clock configuration register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "PREDIV division factor"]
pub const fn prediv (& self) -> super :: vals :: Prediv { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: Prediv (val as u8) } # [doc = "PREDIV division factor"]
pub fn set_prediv (& mut self , val : super :: vals :: Prediv) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "Clock control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "HSI14 clock enable"]
pub const fn hsi14on (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "HSI14 clock enable"]
pub fn set_hsi14on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "HR14 clock ready flag"]
pub const fn hsi14rdy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "HR14 clock ready flag"]
pub fn set_hsi14rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "HSI14 clock request from ADC disable"]
pub const fn hsi14dis (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "HSI14 clock request from ADC disable"]
pub fn set_hsi14dis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "HSI14 clock trimming"]
pub const fn hsi14trim (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x1f ; val as u8 } # [doc = "HSI14 clock trimming"]
pub fn set_hsi14trim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 3usize)) | (((val as u32) & 0x1f) << 3usize) ; } # [doc = "HSI14 clock calibration"]
pub const fn hsi14cal (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "HSI14 clock calibration"]
pub fn set_hsi14cal (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "HSI48 clock enable"]
pub const fn hsi48on (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "HSI48 clock enable"]
pub fn set_hsi48on (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "HSI48 clock ready flag"]
pub const fn hsi48rdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "HSI48 clock ready flag"]
pub fn set_hsi48rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "HSI48 factory clock calibration"]
pub const fn hsi48cal (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "HSI48 factory clock calibration"]
pub fn set_hsi48cal (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "APB2 peripheral reset register (RCC_APB2RSTR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2rstr (pub u32) ; impl Apb2rstr { # [doc = "SYSCFG and COMP reset"]
pub const fn syscfgrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYSCFG and COMP reset"]
pub fn set_syscfgrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "USART6 reset"]
pub const fn usart6rst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "USART6 reset"]
pub fn set_usart6rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "USART7 reset"]
pub const fn usart7rst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "USART7 reset"]
pub fn set_usart7rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "USART8 reset"]
pub const fn usart8rst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "USART8 reset"]
pub fn set_usart8rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "ADC interface reset"]
pub const fn adcrst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "ADC interface reset"]
pub fn set_adcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TIM1 timer reset"]
pub const fn tim1rst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 timer reset"]
pub fn set_tim1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "SPI 1 reset"]
pub const fn spi1rst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "SPI 1 reset"]
pub fn set_spi1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "USART1 reset"]
pub const fn usart1rst (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "USART1 reset"]
pub fn set_usart1rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TIM15 timer reset"]
pub const fn tim15rst (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 timer reset"]
pub fn set_tim15rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 timer reset"]
pub const fn tim16rst (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 timer reset"]
pub fn set_tim16rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 timer reset"]
pub const fn tim17rst (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 timer reset"]
pub fn set_tim17rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Debug MCU reset"]
pub const fn dbgmcurst (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Debug MCU reset"]
pub fn set_dbgmcurst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb2rstr { fn default () -> Apb2rstr { Apb2rstr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usbsw (pub u8) ; impl Usbsw { # [doc = "NOT ALLOWED IN F0x0 - HSI48 selected as USB clock source"]
pub const HSI48 : Self = Self (0) ; # [doc = "PLL clock selected as USB clock source"]
pub const PLLCLK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpre (pub u8) ; impl Hpre { # [doc = "SYSCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "SYSCLK divided by 2"]
pub const DIV2 : Self = Self (0x08) ; # [doc = "SYSCLK divided by 4"]
pub const DIV4 : Self = Self (0x09) ; # [doc = "SYSCLK divided by 8"]
pub const DIV8 : Self = Self (0x0a) ; # [doc = "SYSCLK divided by 16"]
pub const DIV16 : Self = Self (0x0b) ; # [doc = "SYSCLK divided by 64"]
pub const DIV64 : Self = Self (0x0c) ; # [doc = "SYSCLK divided by 128"]
pub const DIV128 : Self = Self (0x0d) ; # [doc = "SYSCLK divided by 256"]
pub const DIV256 : Self = Self (0x0e) ; # [doc = "SYSCLK divided by 512"]
pub const DIV512 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcopre (pub u8) ; impl Mcopre { # [doc = "MCO is divided by 1"]
pub const DIV1 : Self = Self (0) ; # [doc = "MCO is divided by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "MCO is divided by 4"]
pub const DIV4 : Self = Self (0x02) ; # [doc = "MCO is divided by 8"]
pub const DIV8 : Self = Self (0x03) ; # [doc = "MCO is divided by 16"]
pub const DIV16 : Self = Self (0x04) ; # [doc = "MCO is divided by 32"]
pub const DIV32 : Self = Self (0x05) ; # [doc = "MCO is divided by 64"]
pub const DIV64 : Self = Self (0x06) ; # [doc = "MCO is divided by 128"]
pub const DIV128 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllnodiv (pub u8) ; impl Pllnodiv { # [doc = "PLL is divided by 2 for MCO"]
pub const DIV2 : Self = Self (0) ; # [doc = "PLL is not divided for MCO"]
pub const DIV1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lsedrv (pub u8) ; impl Lsedrv { # [doc = "Low drive capacity"]
pub const LOW : Self = Self (0) ; # [doc = "Medium-high drive capacity"]
pub const MEDIUMHIGH : Self = Self (0x01) ; # [doc = "Medium-low drive capacity"]
pub const MEDIUMLOW : Self = Self (0x02) ; # [doc = "High drive capacity"]
pub const HIGH : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cecsw (pub u8) ; impl Cecsw { # [doc = "HSI clock divided by 244 selected as CEC clock source"]
pub const HSI_DIV244 : Self = Self (0) ; # [doc = "LSE clock selected as CEC clock source"]
pub const LSE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ppre (pub u8) ; impl Ppre { # [doc = "HCLK not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HCLK divided by 2"]
pub const DIV2 : Self = Self (0x04) ; # [doc = "HCLK divided by 4"]
pub const DIV4 : Self = Self (0x05) ; # [doc = "HCLK divided by 8"]
pub const DIV8 : Self = Self (0x06) ; # [doc = "HCLK divided by 16"]
pub const DIV16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mco (pub u8) ; impl Mco { # [doc = "MCO output disabled, no clock on MCO"]
pub const NOMCO : Self = Self (0) ; # [doc = "Internal RC 14 MHz (HSI14) oscillator clock selected"]
pub const HSI14 : Self = Self (0x01) ; # [doc = "Internal low speed (LSI) oscillator clock selected"]
pub const LSI : Self = Self (0x02) ; # [doc = "External low speed (LSE) oscillator clock selected"]
pub const LSE : Self = Self (0x03) ; # [doc = "System clock selected"]
pub const SYSCLK : Self = Self (0x04) ; # [doc = "Internal RC 8 MHz (HSI) oscillator clock selected"]
pub const HSI : Self = Self (0x05) ; # [doc = "External 4-32 MHz (HSE) oscillator clock selected"]
pub const HSE : Self = Self (0x06) ; # [doc = "PLL clock selected (divided by 1 or 2, depending en PLLNODIV)"]
pub const PLL : Self = Self (0x07) ; # [doc = "Internal RC 48 MHz (HSI48) oscillator clock selected"]
pub const HSI48 : Self = Self (0x08) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllsrc (pub u8) ; impl Pllsrc { # [doc = "HSI divided by 2 selected as PLL input clock"]
pub const HSI_DIV2 : Self = Self (0) ; # [doc = "NOT ALLOWED IN F0x0 - HSI divided by PREDIV selected as PLL input clock"]
pub const HSI_DIV_PREDIV : Self = Self (0x01) ; # [doc = "HSE divided by PREDIV selected as PLL input clock"]
pub const HSE_DIV_PREDIV : Self = Self (0x02) ; # [doc = "NOT ALLOWED IN F0x0 - HSI48 divided by PREDIV selected as PLL input clock"]
pub const HSI48_DIV_PREDIV : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prediv (pub u8) ; impl Prediv { # [doc = "PREDIV input clock not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "PREDIV input clock divided by 2"]
pub const DIV2 : Self = Self (0x01) ; # [doc = "PREDIV input clock divided by 3"]
pub const DIV3 : Self = Self (0x02) ; # [doc = "PREDIV input clock divided by 4"]
pub const DIV4 : Self = Self (0x03) ; # [doc = "PREDIV input clock divided by 5"]
pub const DIV5 : Self = Self (0x04) ; # [doc = "PREDIV input clock divided by 6"]
pub const DIV6 : Self = Self (0x05) ; # [doc = "PREDIV input clock divided by 7"]
pub const DIV7 : Self = Self (0x06) ; # [doc = "PREDIV input clock divided by 8"]
pub const DIV8 : Self = Self (0x07) ; # [doc = "PREDIV input clock divided by 9"]
pub const DIV9 : Self = Self (0x08) ; # [doc = "PREDIV input clock divided by 10"]
pub const DIV10 : Self = Self (0x09) ; # [doc = "PREDIV input clock divided by 11"]
pub const DIV11 : Self = Self (0x0a) ; # [doc = "PREDIV input clock divided by 12"]
pub const DIV12 : Self = Self (0x0b) ; # [doc = "PREDIV input clock divided by 13"]
pub const DIV13 : Self = Self (0x0c) ; # [doc = "PREDIV input clock divided by 14"]
pub const DIV14 : Self = Self (0x0d) ; # [doc = "PREDIV input clock divided by 15"]
pub const DIV15 : Self = Self (0x0e) ; # [doc = "PREDIV input clock divided by 16"]
pub const DIV16 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sw (pub u8) ; impl Sw { # [doc = "HSI selected as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE selected as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL selected as system clock"]
pub const PLL : Self = Self (0x02) ; # [doc = "HSI48 selected as system clock (when available)"]
pub const HSI48 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllxtpre (pub u8) ; impl Pllxtpre { # [doc = "HSE clock not divided"]
pub const DIV1 : Self = Self (0) ; # [doc = "HSE clock divided by 2"]
pub const DIV2 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usartsw (pub u8) ; impl Usartsw { # [doc = "PCLK selected as USART clock source"]
pub const PCLK : Self = Self (0) ; # [doc = "SYSCLK selected as USART clock source"]
pub const SYSCLK : Self = Self (0x01) ; # [doc = "LSE selected as USART clock source"]
pub const LSE : Self = Self (0x02) ; # [doc = "HSI selected as USART clock source"]
pub const HSI : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pllmul (pub u8) ; impl Pllmul { # [doc = "PLL input clock x2"]
pub const MUL2 : Self = Self (0) ; # [doc = "PLL input clock x3"]
pub const MUL3 : Self = Self (0x01) ; # [doc = "PLL input clock x4"]
pub const MUL4 : Self = Self (0x02) ; # [doc = "PLL input clock x5"]
pub const MUL5 : Self = Self (0x03) ; # [doc = "PLL input clock x6"]
pub const MUL6 : Self = Self (0x04) ; # [doc = "PLL input clock x7"]
pub const MUL7 : Self = Self (0x05) ; # [doc = "PLL input clock x8"]
pub const MUL8 : Self = Self (0x06) ; # [doc = "PLL input clock x9"]
pub const MUL9 : Self = Self (0x07) ; # [doc = "PLL input clock x10"]
pub const MUL10 : Self = Self (0x08) ; # [doc = "PLL input clock x11"]
pub const MUL11 : Self = Self (0x09) ; # [doc = "PLL input clock x12"]
pub const MUL12 : Self = Self (0x0a) ; # [doc = "PLL input clock x13"]
pub const MUL13 : Self = Self (0x0b) ; # [doc = "PLL input clock x14"]
pub const MUL14 : Self = Self (0x0c) ; # [doc = "PLL input clock x15"]
pub const MUL15 : Self = Self (0x0d) ; # [doc = "PLL input clock x16"]
pub const MUL16 : Self = Self (0x0e) ; # [doc = "PLL input clock x16"]
pub const MUL16X : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtcsel (pub u8) ; impl Rtcsel { # [doc = "No clock"]
pub const NOCLOCK : Self = Self (0) ; # [doc = "LSE oscillator clock used as RTC clock"]
pub const LSE : Self = Self (0x01) ; # [doc = "LSI oscillator clock used as RTC clock"]
pub const LSI : Self = Self (0x02) ; # [doc = "HSE oscillator clock divided by a prescaler used as RTC clock"]
pub const HSE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icsw (pub u8) ; impl Icsw { # [doc = "HSI clock selected as I2C clock source"]
pub const HSI : Self = Self (0) ; # [doc = "SYSCLK clock selected as I2C clock source"]
pub const SYSCLK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swsr (pub u8) ; impl Swsr { # [doc = "HSI oscillator used as system clock"]
pub const HSI : Self = Self (0) ; # [doc = "HSE oscillator used as system clock"]
pub const HSE : Self = Self (0x01) ; # [doc = "PLL used as system clock"]
pub const PLL : Self = Self (0x02) ; # [doc = "HSI48 used as system clock (when avaiable)"]
pub const HSI48 : Self = Self (0x03) ; } }