

# [doc = "QuadSPI interface"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Quadspi (pub * mut u8) ; unsafe impl Send for Quadspi { } unsafe impl Sync for Quadspi { } impl Quadspi { # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "device configuration register"]
pub fn dcr (self) -> crate :: common :: Reg < regs :: Dcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "flag clear register"]
pub fn fcr (self) -> crate :: common :: Reg < regs :: Fcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "data length register"]
pub fn dlr (self) -> crate :: common :: Reg < regs :: Dlr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "communication configuration register"]
pub fn ccr (self) -> crate :: common :: Reg < regs :: Ccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "address register"]
pub fn ar (self) -> crate :: common :: Reg < regs :: Ar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "ABR"]
pub fn abr (self) -> crate :: common :: Reg < regs :: Abr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "data register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "polling status mask register"]
pub fn psmkr (self) -> crate :: common :: Reg < regs :: Psmkr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "polling status match register"]
pub fn psmar (self) -> crate :: common :: Reg < regs :: Psmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "polling interval register"]
pub fn pir (self) -> crate :: common :: Reg < regs :: Pir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "low-power timeout register"]
pub fn lptr (self) -> crate :: common :: Reg < regs :: Lptr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } } pub mod regs { # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Transfer error flag"]
pub const fn tef (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Transfer error flag"]
pub fn set_tef (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Transfer complete flag"]
pub const fn tcf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Transfer complete flag"]
pub fn set_tcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "FIFO threshold flag"]
pub const fn ftf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "FIFO threshold flag"]
pub fn set_ftf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Status match flag"]
pub const fn smf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Status match flag"]
pub fn set_smf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Timeout flag"]
pub const fn tof (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Timeout flag"]
pub fn set_tof (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Busy"]
pub const fn busy (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Busy"]
pub fn set_busy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "FIFO level"]
pub const fn flevel (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x7f ; val as u8 } # [doc = "FIFO level"]
pub fn set_flevel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 8usize)) | (((val as u32) & 0x7f) << 8usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "data length register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dlr (pub u32) ; impl Dlr { # [doc = "Data length"]
pub const fn dl (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Data length"]
pub fn set_dl (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dlr { fn default () -> Dlr { Dlr (0) } } # [doc = "ABR"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Abr (pub u32) ; impl Abr { # [doc = "ALTERNATE"]
pub const fn alternate (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "ALTERNATE"]
pub fn set_alternate (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Abr { fn default () -> Abr { Abr (0) } } # [doc = "device configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dcr (pub u32) ; impl Dcr { # [doc = "Mode 0 / mode 3"]
pub const fn ckmode (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Mode 0 / mode 3"]
pub fn set_ckmode (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Chip select high time"]
pub const fn csht (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "Chip select high time"]
pub fn set_csht (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "FLASH memory size"]
pub const fn fsize (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x1f ; val as u8 } # [doc = "FLASH memory size"]
pub fn set_fsize (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 16usize)) | (((val as u32) & 0x1f) << 16usize) ; } } impl Default for Dcr { fn default () -> Dcr { Dcr (0) } } # [doc = "polling interval register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pir (pub u32) ; impl Pir { # [doc = "Polling interval"]
pub const fn interval (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Polling interval"]
pub fn set_interval (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Pir { fn default () -> Pir { Pir (0) } } # [doc = "low-power timeout register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lptr (pub u32) ; impl Lptr { # [doc = "Timeout period"]
pub const fn timeout (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Timeout period"]
pub fn set_timeout (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Lptr { fn default () -> Lptr { Lptr (0) } } # [doc = "flag clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fcr (pub u32) ; impl Fcr { # [doc = "Clear transfer error flag"]
pub const fn ctef (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Clear transfer error flag"]
pub fn set_ctef (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Clear transfer complete flag"]
pub const fn ctcf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Clear transfer complete flag"]
pub fn set_ctcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Clear status match flag"]
pub const fn csmf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Clear status match flag"]
pub fn set_csmf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Clear timeout flag"]
pub const fn ctof (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Clear timeout flag"]
pub fn set_ctof (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Fcr { fn default () -> Fcr { Fcr (0) } } # [doc = "address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ar (pub u32) ; impl Ar { # [doc = "Address"]
pub const fn address (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Address"]
pub fn set_address (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ar { fn default () -> Ar { Ar (0) } } # [doc = "communication configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr (pub u32) ; impl Ccr { # [doc = "Instruction"]
pub const fn instruction (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Instruction"]
pub fn set_instruction (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Instruction mode"]
pub const fn imode (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "Instruction mode"]
pub fn set_imode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "Address mode"]
pub const fn admode (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x03 ; val as u8 } # [doc = "Address mode"]
pub fn set_admode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val as u32) & 0x03) << 10usize) ; } # [doc = "Address size"]
pub const fn adsize (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x03 ; val as u8 } # [doc = "Address size"]
pub fn set_adsize (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val as u32) & 0x03) << 12usize) ; } # [doc = "Alternate bytes mode"]
pub const fn abmode (& self) -> u8 { let val = (self . 0 >> 14usize) & 0x03 ; val as u8 } # [doc = "Alternate bytes mode"]
pub fn set_abmode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val as u32) & 0x03) << 14usize) ; } # [doc = "Alternate bytes size"]
pub const fn absize (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x03 ; val as u8 } # [doc = "Alternate bytes size"]
pub fn set_absize (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val as u32) & 0x03) << 16usize) ; } # [doc = "Number of dummy cycles"]
pub const fn dcyc (& self) -> u8 { let val = (self . 0 >> 18usize) & 0x1f ; val as u8 } # [doc = "Number of dummy cycles"]
pub fn set_dcyc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 18usize)) | (((val as u32) & 0x1f) << 18usize) ; } # [doc = "Data mode"]
pub const fn dmode (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x03 ; val as u8 } # [doc = "Data mode"]
pub fn set_dmode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 24usize)) | (((val as u32) & 0x03) << 24usize) ; } # [doc = "Functional mode"]
pub const fn fmode (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x03 ; val as u8 } # [doc = "Functional mode"]
pub fn set_fmode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 26usize)) | (((val as u32) & 0x03) << 26usize) ; } # [doc = "Send instruction only once mode"]
pub const fn sioo (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Send instruction only once mode"]
pub fn set_sioo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DDR hold half cycle"]
pub const fn dhhc (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "DDR hold half cycle"]
pub fn set_dhhc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Double data rate mode"]
pub const fn ddrm (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Double data rate mode"]
pub fn set_ddrm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ccr { fn default () -> Ccr { Ccr (0) } } # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Enable"]
pub const fn en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Enable"]
pub fn set_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Abort request"]
pub const fn abort (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Abort request"]
pub fn set_abort (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DMA enable"]
pub const fn dmaen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DMA enable"]
pub fn set_dmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Timeout counter enable"]
pub const fn tcen (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Timeout counter enable"]
pub fn set_tcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Sample shift"]
pub const fn sshift (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Sample shift"]
pub fn set_sshift (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Dual-flash mode"]
pub const fn dfm (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Dual-flash mode"]
pub fn set_dfm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "FLASH memory selection"]
pub const fn fsel (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "FLASH memory selection"]
pub fn set_fsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "IFO threshold level"]
pub const fn fthres (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x1f ; val as u8 } # [doc = "IFO threshold level"]
pub fn set_fthres (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 8usize)) | (((val as u32) & 0x1f) << 8usize) ; } # [doc = "Transfer error interrupt enable"]
pub const fn teie (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Transfer error interrupt enable"]
pub fn set_teie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Transfer complete interrupt enable"]
pub const fn tcie (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Transfer complete interrupt enable"]
pub fn set_tcie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "FIFO threshold interrupt enable"]
pub const fn ftie (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "FIFO threshold interrupt enable"]
pub fn set_ftie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Status match interrupt enable"]
pub const fn smie (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Status match interrupt enable"]
pub fn set_smie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "TimeOut interrupt enable"]
pub const fn toie (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "TimeOut interrupt enable"]
pub fn set_toie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Automatic poll mode stop"]
pub const fn apms (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Automatic poll mode stop"]
pub fn set_apms (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Polling match mode"]
pub const fn pmm (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Polling match mode"]
pub fn set_pmm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Clock prescaler"]
pub const fn prescaler (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Clock prescaler"]
pub fn set_prescaler (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "polling status match register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Psmar (pub u32) ; impl Psmar { # [doc = "Status match"]
pub const fn match_ (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Status match"]
pub fn set_match_ (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Psmar { fn default () -> Psmar { Psmar (0) } } # [doc = "data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Data"]
pub const fn data (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Data"]
pub fn set_data (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "polling status mask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Psmkr (pub u32) ; impl Psmkr { # [doc = "Status mask"]
pub const fn mask (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Status mask"]
pub fn set_mask (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Psmkr { fn default () -> Psmkr { Psmkr (0) } } }