

# [doc = "Power control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pwr (pub * mut u8) ; unsafe impl Send for Pwr { } unsafe impl Sync for Pwr { } impl Pwr { # [doc = "Power control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Power control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Power control register 3"]
pub fn cr3 (self) -> crate :: common :: Reg < regs :: Cr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Power control register 4"]
pub fn cr4 (self) -> crate :: common :: Reg < regs :: Cr4 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Power status register 1"]
pub fn sr1 (self) -> crate :: common :: Reg < regs :: Sr1 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Power status register 2"]
pub fn sr2 (self) -> crate :: common :: Reg < regs :: Sr2 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Power status clear register"]
pub fn scr (self) -> crate :: common :: Reg < regs :: Scr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Power control register 5"]
pub fn cr5 (self) -> crate :: common :: Reg < regs :: Cr5 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Power Port pull-up control register"]
pub fn pucr (self , n : usize) -> crate :: common :: Reg < regs :: Pcr , crate :: common :: RW > { assert ! (n < 8usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize + n * 8usize)) } } # [doc = "Power Port pull-down control register"]
pub fn pdcr (self , n : usize) -> crate :: common :: Reg < regs :: Pcr , crate :: common :: RW > { assert ! (n < 8usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize + n * 8usize)) } } # [doc = "Power CPU2 control register 1 [dual core device only]"]
pub fn c2cr1 (self) -> crate :: common :: Reg < regs :: C2cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "Power CPU2 control register 3 [dual core device only]"]
pub fn c2cr3 (self) -> crate :: common :: Reg < regs :: C2cr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize)) } } # [doc = "Power extended status and status clear register"]
pub fn extscr (self) -> crate :: common :: Reg < regs :: Extscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (136usize)) } } # [doc = "Power security configuration register [dual core device only]"]
pub fn seccfgr (self) -> crate :: common :: Reg < regs :: Seccfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (140usize)) } } # [doc = "Power SPI3 control register"]
pub fn subghzspicr (self) -> crate :: common :: Reg < regs :: Subghzspicr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (144usize)) } } # [doc = "RSS Command register [dual core device only]"]
pub fn rsscmdr (self) -> crate :: common :: Reg < regs :: Rsscmdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (152usize)) } } } pub mod regs { # [doc = "Power SPI3 control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Subghzspicr (pub u32) ; impl Subghzspicr { # [doc = "sub-GHz SPI NSS control"]
pub const fn nss (& self) -> super :: vals :: Nss { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Nss (val as u8) } # [doc = "sub-GHz SPI NSS control"]
pub fn set_nss (& mut self , val : super :: vals :: Nss) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Subghzspicr { fn default () -> Subghzspicr { Subghzspicr (0) } } # [doc = "Power control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "Power voltage detector enable"]
pub const fn pvde (& self) -> super :: vals :: Pvde { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Pvde (val as u8) } # [doc = "Power voltage detector enable"]
pub fn set_pvde (& mut self , val : super :: vals :: Pvde) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Power voltage detector level selection."]
pub const fn pls (& self) -> super :: vals :: Pls { let val = (self . 0 >> 1usize) & 0x07 ; super :: vals :: Pls (val as u8) } # [doc = "Power voltage detector level selection."]
pub fn set_pls (& mut self , val : super :: vals :: Pls) { self . 0 = (self . 0 & ! (0x07 << 1usize)) | (((val . 0 as u32) & 0x07) << 1usize) ; } # [doc = "Peripheral voltage monitoring 3 enable: VDDA vs. 1.62V"]
pub fn pvme (& self , n : usize) -> super :: vals :: Pvme { assert ! (n < 1usize) ; let offs = 6usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Pvme (val as u8) } # [doc = "Peripheral voltage monitoring 3 enable: VDDA vs. 1.62V"]
pub fn set_pvme (& mut self , n : usize , val : super :: vals :: Pvme) { assert ! (n < 1usize) ; let offs = 6usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "RSS Command register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rsscmdr (pub u32) ; impl Rsscmdr { # [doc = "RSS command"]
pub const fn rsscmd (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "RSS command"]
pub fn set_rsscmd (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Rsscmdr { fn default () -> Rsscmdr { Rsscmdr (0) } } # [doc = "Power control register 5"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr5 (pub u32) ; impl Cr5 { # [doc = "Enable Radio End Of Life detector enabled"]
pub const fn rfeolen (& self) -> super :: vals :: Rfeolen { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Rfeolen (val as u8) } # [doc = "Enable Radio End Of Life detector enabled"]
pub fn set_rfeolen (& mut self , val : super :: vals :: Rfeolen) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Enable SMPS Step Down converter SMPS mode enabled."]
pub const fn smpsen (& self) -> super :: vals :: Smpsen { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Smpsen (val as u8) } # [doc = "Enable SMPS Step Down converter SMPS mode enabled."]
pub fn set_smpsen (& mut self , val : super :: vals :: Smpsen) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Cr5 { fn default () -> Cr5 { Cr5 (0) } } # [doc = "Power control register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr3 (pub u32) ; impl Cr3 { # [doc = "Enable Wakeup pin WKUP1 for CPU1"]
pub fn ewup (& self , n : usize) -> super :: vals :: Ewup { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Ewup (val as u8) } # [doc = "Enable Wakeup pin WKUP1 for CPU1"]
pub fn set_ewup (& mut self , n : usize , val : super :: vals :: Ewup) { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Ultra-low-power enable"]
pub const fn eulpen (& self) -> super :: vals :: Eulpen { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Eulpen (val as u8) } # [doc = "Ultra-low-power enable"]
pub fn set_eulpen (& mut self , val : super :: vals :: Eulpen) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Enable wakeup PVD for CPU1"]
pub const fn ewpvd (& self) -> super :: vals :: Ewpvd { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Ewpvd (val as u8) } # [doc = "Enable wakeup PVD for CPU1"]
pub fn set_ewpvd (& mut self , val : super :: vals :: Ewpvd) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "SRAM2 retention in Standby mode"]
pub const fn rrs (& self) -> super :: vals :: Rrs { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Rrs (val as u8) } # [doc = "SRAM2 retention in Standby mode"]
pub fn set_rrs (& mut self , val : super :: vals :: Rrs) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Apply pull-up and pull-down configuration from CPU1"]
pub const fn apc (& self) -> super :: vals :: Apc { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Apc (val as u8) } # [doc = "Apply pull-up and pull-down configuration from CPU1"]
pub fn set_apc (& mut self , val : super :: vals :: Apc) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Enable Radio BUSY Wakeup from Standby for CPU1"]
pub const fn ewrfbusy (& self) -> super :: vals :: Ewrfbusy { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Ewrfbusy (val as u8) } # [doc = "Enable Radio BUSY Wakeup from Standby for CPU1"]
pub fn set_ewrfbusy (& mut self , val : super :: vals :: Ewrfbusy) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "akeup for CPU1"]
pub const fn ewrfirq (& self) -> super :: vals :: Ewrfirq { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Ewrfirq (val as u8) } # [doc = "akeup for CPU1"]
pub fn set_ewrfirq (& mut self , val : super :: vals :: Ewrfirq) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "nable CPU2 Hold interrupt for CPU1"]
pub const fn ec2h (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "nable CPU2 Hold interrupt for CPU1"]
pub fn set_ec2h (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Enable internal wakeup line for CPU1"]
pub const fn eiwul (& self) -> super :: vals :: Eiwul { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Eiwul (val as u8) } # [doc = "Enable internal wakeup line for CPU1"]
pub fn set_eiwul (& mut self , val : super :: vals :: Eiwul) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Cr3 { fn default () -> Cr3 { Cr3 (0) } } # [doc = "Power extended status and status clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Extscr (pub u32) ; impl Extscr { # [doc = "Clear CPU1 Stop Standby flags"]
pub const fn c1cssf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Clear CPU1 Stop Standby flags"]
pub fn set_c1cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "lear CPU2 Stop Standby flags"]
pub const fn c2cssf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "lear CPU2 Stop Standby flags"]
pub fn set_c2cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "System Standby flag for CPU1. (no core states retained)"]
pub const fn c1sbf (& self) -> super :: vals :: Csbf { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Csbf (val as u8) } # [doc = "System Standby flag for CPU1. (no core states retained)"]
pub fn set_c1sbf (& mut self , val : super :: vals :: Csbf) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "System Stop2 flag for CPU1. (partial core states retained)"]
pub const fn c1stop2f (& self) -> super :: vals :: Cstopf { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Cstopf (val as u8) } # [doc = "System Stop2 flag for CPU1. (partial core states retained)"]
pub fn set_c1stop2f (& mut self , val : super :: vals :: Cstopf) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "System Stop0, 1 flag for CPU1. (All core states retained)"]
pub const fn c1stopf (& self) -> super :: vals :: Cstopf { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Cstopf (val as u8) } # [doc = "System Stop0, 1 flag for CPU1. (All core states retained)"]
pub fn set_c1stopf (& mut self , val : super :: vals :: Cstopf) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "ystem Standby flag for CPU2. (no core states retained)"]
pub const fn c2sbf (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "ystem Standby flag for CPU2. (no core states retained)"]
pub fn set_c2sbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "ystem Stop2 flag for CPU2. (partial core states retained)"]
pub const fn c2stop2f (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "ystem Stop2 flag for CPU2. (partial core states retained)"]
pub fn set_c2stop2f (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "ystem Stop0, 1 flag for CPU2. (All core states retained)"]
pub const fn c2stopf (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "ystem Stop0, 1 flag for CPU2. (All core states retained)"]
pub fn set_c2stopf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "CPU1 deepsleep mode"]
pub const fn c1ds (& self) -> super :: vals :: Cds { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Cds (val as u8) } # [doc = "CPU1 deepsleep mode"]
pub fn set_c1ds (& mut self , val : super :: vals :: Cds) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "PU2 deepsleep mode"]
pub const fn c2ds (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "PU2 deepsleep mode"]
pub fn set_c2ds (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Extscr { fn default () -> Extscr { Extscr (0) } } # [doc = "Power Port pull control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pcr (pub u32) ; impl Pcr { # [doc = "Port pull bit y (y=0..15)"]
pub fn p (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Port pull bit y (y=0..15)"]
pub fn set_p (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Pcr { fn default () -> Pcr { Pcr (0) } } # [doc = "Power control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Low-power mode selection for CPU1"]
pub const fn lpms (& self) -> super :: vals :: Lpms { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Lpms (val as u8) } # [doc = "Low-power mode selection for CPU1"]
pub fn set_lpms (& mut self , val : super :: vals :: Lpms) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "sub-GHz SPI NSS source select"]
pub const fn subghzspinsssel (& self) -> super :: vals :: Subghzspinsssel { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Subghzspinsssel (val as u8) } # [doc = "sub-GHz SPI NSS source select"]
pub fn set_subghzspinsssel (& mut self , val : super :: vals :: Subghzspinsssel) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Flash memory power down mode during LPRun for CPU1"]
pub const fn fpdr (& self) -> super :: vals :: Fpdr { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Fpdr (val as u8) } # [doc = "Flash memory power down mode during LPRun for CPU1"]
pub fn set_fpdr (& mut self , val : super :: vals :: Fpdr) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Flash memory power down mode during LPSleep for CPU1"]
pub const fn fpds (& self) -> super :: vals :: Fpds { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Fpds (val as u8) } # [doc = "Flash memory power down mode during LPSleep for CPU1"]
pub fn set_fpds (& mut self , val : super :: vals :: Fpds) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Disable backup domain write protection"]
pub const fn dbp (& self) -> super :: vals :: Dbp { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Dbp (val as u8) } # [doc = "Disable backup domain write protection"]
pub fn set_dbp (& mut self , val : super :: vals :: Dbp) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Voltage scaling range selection"]
pub const fn vos (& self) -> super :: vals :: Vos { let val = (self . 0 >> 9usize) & 0x03 ; super :: vals :: Vos (val as u8) } # [doc = "Voltage scaling range selection"]
pub fn set_vos (& mut self , val : super :: vals :: Vos) { self . 0 = (self . 0 & ! (0x03 << 9usize)) | (((val . 0 as u32) & 0x03) << 9usize) ; } # [doc = "Low-power run"]
pub const fn lpr (& self) -> super :: vals :: Lpr { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Lpr (val as u8) } # [doc = "Low-power run"]
pub fn set_lpr (& mut self , val : super :: vals :: Lpr) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "Power CPU2 control register 1 [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2cr1 (pub u32) ; impl C2cr1 { # [doc = "Low-power mode selection for CPU2"]
pub const fn lpms (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "Low-power mode selection for CPU2"]
pub fn set_lpms (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "Flash memory power down mode during LPRun for CPU2"]
pub const fn fpdr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Flash memory power down mode during LPRun for CPU2"]
pub fn set_fpdr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Flash memory power down mode during LPSleep for CPU2"]
pub const fn fpds (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Flash memory power down mode during LPSleep for CPU2"]
pub fn set_fpds (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for C2cr1 { fn default () -> C2cr1 { C2cr1 (0) } } # [doc = "Power CPU2 control register 3 [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2cr3 (pub u32) ; impl C2cr3 { # [doc = "Enable Wakeup pin WKUP1 for CPU2"]
pub fn ewup (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Enable Wakeup pin WKUP1 for CPU2"]
pub fn set_ewup (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Enable wakeup PVD for CPU2"]
pub const fn ewpvd (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Enable wakeup PVD for CPU2"]
pub fn set_ewpvd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Apply pull-up and pull-down configuration for CPU2"]
pub const fn apc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Apply pull-up and pull-down configuration for CPU2"]
pub fn set_apc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "EWRFBUSY"]
pub const fn ewrfbusy (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "EWRFBUSY"]
pub fn set_ewrfbusy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "akeup for CPU2"]
pub const fn ewrfirq (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "akeup for CPU2"]
pub fn set_ewrfirq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Enable internal wakeup line for CPU2"]
pub const fn eiwul (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Enable internal wakeup line for CPU2"]
pub fn set_eiwul (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for C2cr3 { fn default () -> C2cr3 { C2cr3 (0) } } # [doc = "Power control register 4"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr4 (pub u32) ; impl Cr4 { # [doc = "Wakeup pin WKUP1 polarity"]
pub fn wp (& self , n : usize) -> super :: vals :: Wp { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Wp (val as u8) } # [doc = "Wakeup pin WKUP1 polarity"]
pub fn set_wp (& mut self , n : usize , val : super :: vals :: Wp) { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "VBAT battery charging enable"]
pub const fn vbe (& self) -> super :: vals :: Vbe { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Vbe (val as u8) } # [doc = "VBAT battery charging enable"]
pub fn set_vbe (& mut self , val : super :: vals :: Vbe) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "VBAT battery charging resistor selection"]
pub const fn vbrs (& self) -> super :: vals :: Vbrs { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Vbrs (val as u8) } # [doc = "VBAT battery charging resistor selection"]
pub fn set_vbrs (& mut self , val : super :: vals :: Vbrs) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Wakeup Radio BUSY polarity"]
pub const fn wrfbusyp (& self) -> super :: vals :: Wrfbusyp { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Wrfbusyp (val as u8) } # [doc = "Wakeup Radio BUSY polarity"]
pub fn set_wrfbusyp (& mut self , val : super :: vals :: Wrfbusyp) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "oot CPU2 after reset or wakeup from Stop or Standby modes."]
pub const fn c2boot (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "oot CPU2 after reset or wakeup from Stop or Standby modes."]
pub fn set_c2boot (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Cr4 { fn default () -> Cr4 { Cr4 (0) } } # [doc = "Power status register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr1 (pub u32) ; impl Sr1 { # [doc = "Wakeup flag 1"]
pub fn wuf (& self , n : usize) -> super :: vals :: Wuf { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Wuf (val as u8) } # [doc = "Wakeup flag 1"]
pub fn set_wuf (& mut self , n : usize , val : super :: vals :: Wuf) { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Wakeup PVD flag"]
pub const fn wpvdf (& self) -> super :: vals :: Wpvdf { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Wpvdf (val as u8) } # [doc = "Wakeup PVD flag"]
pub fn set_wpvdf (& mut self , val : super :: vals :: Wpvdf) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Radio BUSY wakeup flag"]
pub const fn wrfbusyf (& self) -> super :: vals :: Wrfbusyf { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Wrfbusyf (val as u8) } # [doc = "Radio BUSY wakeup flag"]
pub fn set_wrfbusyf (& mut self , val : super :: vals :: Wrfbusyf) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "PU2 Hold interrupt flag"]
pub const fn c2hf (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "PU2 Hold interrupt flag"]
pub fn set_c2hf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Internal wakeup interrupt flag"]
pub const fn wufi (& self) -> super :: vals :: Wufi { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Wufi (val as u8) } # [doc = "Internal wakeup interrupt flag"]
pub fn set_wufi (& mut self , val : super :: vals :: Wufi) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Sr1 { fn default () -> Sr1 { Sr1 (0) } } # [doc = "Power security configuration register [dual core device only]"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Seccfgr (pub u32) ; impl Seccfgr { # [doc = "wakeup on CPU2 illegal access interrupt enable"]
pub const fn c2ewila (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "wakeup on CPU2 illegal access interrupt enable"]
pub fn set_c2ewila (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Seccfgr { fn default () -> Seccfgr { Seccfgr (0) } } # [doc = "Power status register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr2 (pub u32) ; impl Sr2 { # [doc = "PU2 boot/wakeup request source information"]
pub const fn c2boots (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "PU2 boot/wakeup request source information"]
pub fn set_c2boots (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Radio BUSY signal status"]
pub const fn rfbusys (& self) -> super :: vals :: Rfbusys { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Rfbusys (val as u8) } # [doc = "Radio BUSY signal status"]
pub fn set_rfbusys (& mut self , val : super :: vals :: Rfbusys) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Radio BUSY masked signal status"]
pub const fn rfbusyms (& self) -> super :: vals :: Rfbusyms { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Rfbusyms (val as u8) } # [doc = "Radio BUSY masked signal status"]
pub fn set_rfbusyms (& mut self , val : super :: vals :: Rfbusyms) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "SMPS ready flag"]
pub const fn smpsrdy (& self) -> super :: vals :: Smpsrdy { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Smpsrdy (val as u8) } # [doc = "SMPS ready flag"]
pub fn set_smpsrdy (& mut self , val : super :: vals :: Smpsrdy) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "LDO ready flag"]
pub const fn ldordy (& self) -> super :: vals :: Ldordy { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Ldordy (val as u8) } # [doc = "LDO ready flag"]
pub fn set_ldordy (& mut self , val : super :: vals :: Ldordy) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Radio end of life flag"]
pub const fn rfeolf (& self) -> super :: vals :: Rfeolf { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Rfeolf (val as u8) } # [doc = "Radio end of life flag"]
pub fn set_rfeolf (& mut self , val : super :: vals :: Rfeolf) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "regulator2 low power flag"]
pub const fn regmrs (& self) -> super :: vals :: Regmrs { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Regmrs (val as u8) } # [doc = "regulator2 low power flag"]
pub fn set_regmrs (& mut self , val : super :: vals :: Regmrs) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Flash ready"]
pub const fn flashrdy (& self) -> super :: vals :: Flashrdy { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Flashrdy (val as u8) } # [doc = "Flash ready"]
pub fn set_flashrdy (& mut self , val : super :: vals :: Flashrdy) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "regulator1 started"]
pub const fn reglps (& self) -> super :: vals :: Reglps { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Reglps (val as u8) } # [doc = "regulator1 started"]
pub fn set_reglps (& mut self , val : super :: vals :: Reglps) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "regulator1 low power flag"]
pub const fn reglpf (& self) -> super :: vals :: Reglpf { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Reglpf (val as u8) } # [doc = "regulator1 low power flag"]
pub fn set_reglpf (& mut self , val : super :: vals :: Reglpf) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Voltage scaling flag"]
pub const fn vosf (& self) -> super :: vals :: Vosf { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Vosf (val as u8) } # [doc = "Voltage scaling flag"]
pub fn set_vosf (& mut self , val : super :: vals :: Vosf) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Power voltage detector output"]
pub const fn pvdo (& self) -> super :: vals :: Pvdo { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Pvdo (val as u8) } # [doc = "Power voltage detector output"]
pub fn set_pvdo (& mut self , val : super :: vals :: Pvdo) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Peripheral voltage monitoring output: VDDA vs. 1.62 V"]
pub fn pvmo (& self , n : usize) -> super :: vals :: Pvmo { assert ! (n < 1usize) ; let offs = 14usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Pvmo (val as u8) } # [doc = "Peripheral voltage monitoring output: VDDA vs. 1.62 V"]
pub fn set_pvmo (& mut self , n : usize , val : super :: vals :: Pvmo) { assert ! (n < 1usize) ; let offs = 14usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Sr2 { fn default () -> Sr2 { Sr2 (0) } } # [doc = "Power status clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Scr (pub u32) ; impl Scr { # [doc = "Clear wakeup flag 1"]
pub fn cwuf (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Clear wakeup flag 1"]
pub fn set_cwuf (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Clear wakeup PVD interrupt flag"]
pub const fn cwpvdf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup PVD interrupt flag"]
pub fn set_cwpvdf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Clear wakeup Radio BUSY flag"]
pub const fn cwrfbusyf (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup Radio BUSY flag"]
pub fn set_cwrfbusyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "lear CPU2 Hold interrupt flag"]
pub const fn cc2hf (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "lear CPU2 Hold interrupt flag"]
pub fn set_cc2hf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for Scr { fn default () -> Scr { Scr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cwpvdfw (pub u8) ; impl Cwpvdfw { # [doc = "Setting this bit clears the WPVDF flag in the PWR_SR1. This bit is always read as 0."]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ewup (pub u8) ; impl Ewup { # [doc = "WKUP pin 3 is used for general purpose I/Os. An event on the WKUP pin 3 does not wakeup the device from Standby mode"]
pub const DISABLED : Self = Self (0) ; # [doc = "WKUP pin 3 is used for wakeup from Standby mode and forced in input pull down configuration (rising edge on WKUP pin 3wakes-up the system from Standby mode)"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pd (pub u8) ; impl Pd { # [doc = "Disable the pull-down on PC[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable the pull-down on PC[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ewrfbusy (pub u8) ; impl Ewrfbusy { # [doc = "Radio Busy is disabled and does not trigger a wakeup from Standby event to CPUwhen a rising or a falling edge occurs"]
pub const DISABLED : Self = Self (0) ; # [doc = "Radio Busy is enabled and triggers a wakeup from Standby event to CPUwhen a rising or a falling edge occurs. The active edge is configured via the WRFBUSYP bit in PWR_CR4"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vbe (pub u8) ; impl Vbe { # [doc = "VBAT battery charging disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "VBAT battery charging enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wufi (pub u8) ; impl Wufi { # [doc = "All internal wakeup sources are cleared"]
pub const CLEAR : Self = Self (0) ; # [doc = "wakeup is detected on the internal wakeup line"]
pub const WAKEUP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rfbusyms (pub u8) ; impl Rfbusyms { # [doc = "radio busy masked signal low (not busy)"]
pub const NOTBUSY : Self = Self (0) ; # [doc = "radio busy masked signal high (busy)"]
pub const BUSY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Regmrs (pub u8) ; impl Regmrs { # [doc = "Main regulator supplied directly from VDD"]
pub const V_DD : Self = Self (0) ; # [doc = "Main regulator supplied through LDO or SMPS"]
pub const LDO_SMPS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vbrs (pub u8) ; impl Vbrs { # [doc = "VBAT charging through a 5 kΩ resistor"]
pub const R5K : Self = Self (0) ; # [doc = "VBAT charging through a 1.5 kΩ resistor"]
pub const R1_5K : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fpdr (pub u8) ; impl Fpdr { # [doc = "Flash memory in Idle mode when system is in LPRun mode"]
pub const IDLE : Self = Self (0) ; # [doc = "Flash memory in Power-down mode when system is in LPRun mode"]
pub const POWERDOWN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Csbf (pub u8) ; impl Csbf { # [doc = "System has not been in Standby mode"]
pub const NOSTANDBY : Self = Self (0) ; # [doc = "System has been in Standby mode"]
pub const STANDBY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pvde (pub u8) ; impl Pvde { # [doc = "PVD Disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "PVD Enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pu (pub u8) ; impl Pu { # [doc = "Disable pull-up on PC[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable pull-up on PC[y]
when both APC bits are set in PWR control register 3 (PWR_CR3). The pull-up is not activated if the corresponding PC[y]
bit is also set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Smpsen (pub u8) ; impl Smpsen { # [doc = "SMPS step-down converter SMPS mode disabled (LDO mode enabled)"]
pub const DISABLED : Self = Self (0) ; # [doc = "SMPS step-down converter SMPS mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eulpen (pub u8) ; impl Eulpen { # [doc = "Disable (the supply voltage is monitored continuously)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable, when set, the supply voltage is sampled for PDR/BOR reset condition only periodically"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wuf (pub u8) ; impl Wuf { # [doc = "No wakeup event detected on WKUP3"]
pub const CLEAR : Self = Self (0) ; # [doc = "Wakeup event detected on WKUP3"]
pub const WAKEUP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Subghzspinsssel (pub u8) ; impl Subghzspinsssel { # [doc = "sub-GHz SPI NSS signal driven from PWR_SUBGHZSPICR.NSS (RFBUSYMS functionality enabled)"]
pub const SUBGHZSPICR : Self = Self (0) ; # [doc = "sub-GHz SPI NSS signal driven from LPTIM3_OUT (RFBUSYMS functionality disabled)"]
pub const LPTIM3 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vosf (pub u8) ; impl Vosf { # [doc = "Regulator ready in the selected voltage range"]
pub const READY : Self = Self (0) ; # [doc = "Regulator output voltage changed to the required voltage level"]
pub const CHANGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Nss (pub u8) ; impl Nss { # [doc = "Sub-GHz SPI NSS signal at level low"]
pub const LOW : Self = Self (0) ; # [doc = "Sub-GHz SPI NSS signal is at level high"]
pub const HIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wrfbusyf (pub u8) ; impl Wrfbusyf { # [doc = "No wakeup event detected on radio busy"]
pub const CLEAR : Self = Self (0) ; # [doc = "Wakeup event detected on radio busy"]
pub const WAKEUP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PucraPu (pub u8) ; impl PucraPu { # [doc = "Disable pull-up on PA[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable pull-up on PA[y]
when both APC bits are set in PWR control register 3 (PWR_CR3). The pull-up is not activated if the corresponding PA[y]
bit is also set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ewpvd (pub u8) ; impl Ewpvd { # [doc = "PVD not enabled by the sub-GHz radio active state"]
pub const DISABLED : Self = Self (0) ; # [doc = "PVD enabled while the sub-GHz radio is active"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lpr (pub u8) ; impl Lpr { # [doc = "Voltage regulator in Main mode in Low-power run mode"]
pub const MAINMODE : Self = Self (0) ; # [doc = "Voltage regulator in low-power mode in Low-power run mode"]
pub const LOWPOWERMODE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PdcraPd (pub u8) ; impl PdcraPd { # [doc = "Disable the pull-down on PA[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable the pull-down on PA[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rfbusys (pub u8) ; impl Rfbusys { # [doc = "radio busy signal low (not busy)"]
pub const NOTBUSY : Self = Self (0) ; # [doc = "radio busy signal high (busy)"]
pub const BUSY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pls (pub u8) ; impl Pls { # [doc = "2.0V"]
pub const V2_0 : Self = Self (0) ; # [doc = "2.2V"]
pub const V2_2 : Self = Self (0x01) ; # [doc = "2.4V"]
pub const V2_4 : Self = Self (0x02) ; # [doc = "2.5V"]
pub const V2_5 : Self = Self (0x03) ; # [doc = "2.6V"]
pub const V2_6 : Self = Self (0x04) ; # [doc = "2.8V"]
pub const V2_8 : Self = Self (0x05) ; # [doc = "2.9V"]
pub const V2_9 : Self = Self (0x06) ; # [doc = "External input analog voltage PVD_IN (compared internally to VREFINT)"]
pub const EXTERNAL : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PucrbPu (pub u8) ; impl PucrbPu { # [doc = "Disable pull-up on PB[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable pull-up on PB[y]
when both APC bits are set in PWR control register 3 (PWR_CR3). The pull-up is not activated if the corresponding PB[y]
bit is also set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eiwul (pub u8) ; impl Eiwul { # [doc = "Internal wakeup line interrupt to CPU disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Internal wakeup line interrupt to CPU enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Smpsrdy (pub u8) ; impl Smpsrdy { # [doc = "SMPS step-down converter not ready or off"]
pub const NOTREADY : Self = Self (0) ; # [doc = "SMPS step-down converter ready"]
pub const READY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cstopf (pub u8) ; impl Cstopf { # [doc = "System has not been in Stop 2 mode"]
pub const NOSTOP : Self = Self (0) ; # [doc = "System has been in Stop 2 mode"]
pub const STOP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ewrfirq (pub u8) ; impl Ewrfirq { # [doc = "Radio IRQ[2:0]
is disabled and does not trigger a wakeup from Standby event to CPU."]
pub const DISABLED : Self = Self (0) ; # [doc = "Radio IRQ[2:0]
is enabled and triggers a wakeup from Standby event to CPU."]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dbp (pub u8) ; impl Dbp { # [doc = "Access to RTC and backup registers disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Access to RTC and backup registers enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PucrcPu (pub u8) ; impl PucrcPu { # [doc = "Disable pull-up on PC[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable pull-up on PC[y]
when both APC bits are set in PWR control register 3 (PWR_CR3). The pull-up is not activated if the corresponding PC[y]
bit is also set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ldordy (pub u8) ; impl Ldordy { # [doc = "LDO not ready or off"]
pub const NOTREADY : Self = Self (0) ; # [doc = "LDO ready"]
pub const READY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Flashrdy (pub u8) ; impl Flashrdy { # [doc = "Flash memory not ready to be accessed"]
pub const NOTREADY : Self = Self (0) ; # [doc = "Flash memory ready to be accessed"]
pub const READY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Apc (pub u8) ; impl Apc { # [doc = "I/O pull-up and pull-down configurations defined in the PWR_PUCRx and PWR_PDCRx registers are applied"]
pub const DISABLED : Self = Self (0) ; # [doc = "PWR_PUCRx and PWR_PDCRx registers are NOT applied to the I/Os"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wrfbusyp (pub u8) ; impl Wrfbusyp { # [doc = "Detection on high level (rising edge)"]
pub const RISINGEDGE : Self = Self (0) ; # [doc = "Detection on low level (falling edge)"]
pub const FALLINGEDGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wp (pub u8) ; impl Wp { # [doc = "Detection on high level (rising edge)"]
pub const RISINGEDGE : Self = Self (0) ; # [doc = "Detection on low level (falling edge)"]
pub const FALLINGEDGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rfeolen (pub u8) ; impl Rfeolen { # [doc = "Radio end-of-life detector disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Radio end-of-life detector enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pvme (pub u8) ; impl Pvme { # [doc = "PVM3 (VDDA monitoring versus 1.62 V threshold) disable"]
pub const DISABLED : Self = Self (0) ; # [doc = "PVM3 (VDDA monitoring versus 1.62 V threshold) enable"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PdcrcPd (pub u8) ; impl PdcrcPd { # [doc = "Disable the pull-down on PC[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable the pull-down on PC[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lpms (pub u8) ; impl Lpms { # [doc = "Stop 0 mode"]
pub const STOP0 : Self = Self (0) ; # [doc = "Stop 1 mode"]
pub const STOP1 : Self = Self (0x01) ; # [doc = "Stop 2 mode"]
pub const STOP2 : Self = Self (0x02) ; # [doc = "Standby mode"]
pub const STANDBY : Self = Self (0x03) ; # [doc = "Shutdown mode"]
pub const SHUTDOWN : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cwufw (pub u8) ; impl Cwufw { # [doc = "Setting this bit clears the WUF2 flag in the PWR_SR1 register. This bit is always read as 0."]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wpvdf (pub u8) ; impl Wpvdf { # [doc = "No wakeup event detected on PVD"]
pub const CLEAR : Self = Self (0) ; # [doc = "Wakeup event detected on PVD"]
pub const WAKEUP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ccssfw (pub u8) ; impl Ccssfw { # [doc = "Setting this bit clears the C1STOPF and C1SBF bits"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PdcrbPd (pub u8) ; impl PdcrbPd { # [doc = "Disable the pull-down on PB[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable the pull-down on PB[y]
when both APC bits are set in PWR control register 3 (PWR_CR3)"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Reglps (pub u8) ; impl Reglps { # [doc = "LPR not ready"]
pub const NOTREADY : Self = Self (0) ; # [doc = "LPR ready"]
pub const READY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fpds (pub u8) ; impl Fpds { # [doc = "Flash memory in Idle mode when system is in LPSleep mode"]
pub const IDLE : Self = Self (0) ; # [doc = "Flash memory in Power-down mode when system is in LPSleep mode"]
pub const POWERDOWN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pvmo (pub u8) ; impl Pvmo { # [doc = "VDDA voltage above PVM3 threshold (around 1.62 V)"]
pub const ABOVE : Self = Self (0) ; # [doc = "VDDA voltage below PVM3 threshold (around 1.62 V)"]
pub const BELOW : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pvdo (pub u8) ; impl Pvdo { # [doc = "VDD or voltage level on PVD_IN above the selected PVD threshold"]
pub const ABOVE : Self = Self (0) ; # [doc = "VDD or voltage level on PVD_IN below the selected PVD threshold"]
pub const BELOW : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cds (pub u8) ; impl Cds { # [doc = "CPU is running or in sleep"]
pub const RUNNINGORSLEEP : Self = Self (0) ; # [doc = "CPU is in Deep-Sleep"]
pub const DEEPSLEEP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rfeolf (pub u8) ; impl Rfeolf { # [doc = "Supply voltage above radio end-of-life operating low level"]
pub const ABOVE : Self = Self (0) ; # [doc = "Supply voltage below radio end-of-life operating low level"]
pub const BELOW : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Reglpf (pub u8) ; impl Reglpf { # [doc = "Main regulator (MR) ready and used"]
pub const MAIN : Self = Self (0) ; # [doc = "Low-power regulator (LPR) used"]
pub const LOWPOWER : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cwrfbusyfw (pub u8) ; impl Cwrfbusyfw { # [doc = "Setting this bit clears the WRFBUSYF flag in the PWR_SR1. This bit is always read 0."]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rrs (pub u8) ; impl Rrs { # [doc = "SRAM2 powered off in Standby mode (SRAM2 content lost)"]
pub const POWEROFF : Self = Self (0) ; # [doc = "SRAM2 powered by the low-power regulator in Standby mode (SRAM2 content kept)"]
pub const ONLPR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vos (pub u8) ; impl Vos { # [doc = "1.2 V (range 1)"]
pub const V1_2 : Self = Self (0x01) ; # [doc = "1.0 V (range 2)"]
pub const V1_0 : Self = Self (0x02) ; } }