

# [doc = "Power control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pwr (pub * mut u8) ; unsafe impl Send for Pwr { } unsafe impl Sync for Pwr { } impl Pwr { # [doc = "PWR control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "PWR control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "PWR control register 3"]
pub fn cr3 (self) -> crate :: common :: Reg < regs :: Cr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "PWR voltage scaling register"]
pub fn vosr (self) -> crate :: common :: Reg < regs :: Vosr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "PWR supply voltage monitoring control register"]
pub fn svmcr (self) -> crate :: common :: Reg < regs :: Svmcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "PWR wakeup control register 1"]
pub fn wucr1 (self) -> crate :: common :: Reg < regs :: Wucr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "PWR wakeup control register 2"]
pub fn wucr2 (self) -> crate :: common :: Reg < regs :: Wucr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "PWR wakeup control register 3"]
pub fn wucr3 (self) -> crate :: common :: Reg < regs :: Wucr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "PWR Backup domain control register 1"]
pub fn bdcr1 (self) -> crate :: common :: Reg < regs :: Bdcr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "PWR Backup domain control register 2"]
pub fn bdcr2 (self) -> crate :: common :: Reg < regs :: Bdcr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "PWR disable Backup domain register"]
pub fn dbpr (self) -> crate :: common :: Reg < regs :: Dbpr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "PWR USB Type-C™ and Power Delivery register"]
pub fn ucpdr (self) -> crate :: common :: Reg < regs :: Ucpdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "PWR security configuration register"]
pub fn seccfgr (self) -> crate :: common :: Reg < regs :: Seccfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "PWR privilege control register"]
pub fn privcfgr (self) -> crate :: common :: Reg < regs :: Privcfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "PWR status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } pub fn svmsr (self) -> crate :: common :: Reg < regs :: Svmsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "PWR Backup domain status register"]
pub fn bdsr (self) -> crate :: common :: Reg < regs :: Bdsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "PWR wakeup status register"]
pub fn wusr (self) -> crate :: common :: Reg < regs :: Wusr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "PWR wakeup status clear register"]
pub fn wuscr (self) -> crate :: common :: Reg < regs :: Wuscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "PWR apply pull configuration register"]
pub fn apcr (self) -> crate :: common :: Reg < regs :: Apcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "Power Port pull-up control register"]
pub fn pucr (self , n : usize) -> crate :: common :: Reg < regs :: Pcr , crate :: common :: RW > { assert ! (n < 9usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize + n * 8usize)) } } # [doc = "Power Port pull-down control register"]
pub fn pdcr (self , n : usize) -> crate :: common :: Reg < regs :: Pcr , crate :: common :: RW > { assert ! (n < 9usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize + n * 8usize)) } } } pub mod regs { # [doc = "Power Port pull control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pcr (pub u32) ; impl Pcr { # [doc = "Port pull bit y (y=0..15)"]
pub fn p (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Port pull bit y (y=0..15)"]
pub fn set_p (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Pcr { fn default () -> Pcr { Pcr (0) } } # [doc = "PWR wakeup status clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wuscr (pub u32) ; impl Wuscr { # [doc = "Wakeup flag 1 Writing 1 to this bit clears the WUF1 flag in WUSR."]
pub const fn cwuf1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 1 Writing 1 to this bit clears the WUF1 flag in WUSR."]
pub fn set_cwuf1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Wakeup flag 2 Writing 1 to this bit clears the WUF2 flag in WUSR."]
pub const fn cwuf2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 2 Writing 1 to this bit clears the WUF2 flag in WUSR."]
pub fn set_cwuf2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup flag 3 Writing 1 to this bit clears the WUF3 flag in WUSR."]
pub const fn cwuf3 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 3 Writing 1 to this bit clears the WUF3 flag in WUSR."]
pub fn set_cwuf3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Wakeup flag 4 Writing 1 to this bit clears the WUF4 flag in WUSR."]
pub const fn cwuf4 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 4 Writing 1 to this bit clears the WUF4 flag in WUSR."]
pub fn set_cwuf4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Wakeup flag 5 Writing 1 to this bit clears the WUF5 flag in WUSR."]
pub const fn cwuf5 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 5 Writing 1 to this bit clears the WUF5 flag in WUSR."]
pub fn set_cwuf5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Wakeup flag 6 Writing 1 to this bit clears the WUF6 flag in WUSR."]
pub const fn cwuf6 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 6 Writing 1 to this bit clears the WUF6 flag in WUSR."]
pub fn set_cwuf6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Wakeup flag 7 Writing 1 to this bit clears the WUF7 flag in WUSR."]
pub const fn cwuf7 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 7 Writing 1 to this bit clears the WUF7 flag in WUSR."]
pub fn set_cwuf7 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Wakeup flag 8 Writing 1 to this bit clears the WUF8 flag in WUSR."]
pub const fn cwuf8 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 8 Writing 1 to this bit clears the WUF8 flag in WUSR."]
pub fn set_cwuf8 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Wuscr { fn default () -> Wuscr { Wuscr (0) } } # [doc = "PWR voltage scaling register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Vosr (pub u32) ; impl Vosr { # [doc = "EPOD booster ready This bit is set to 1 by hardware when the power booster startup time is reached. The system clock frequency can be switched higher than 50 MHz only after this bit is set."]
pub const fn boostrdy (& self) -> super :: vals :: Boostrdy { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Boostrdy (val as u8) } # [doc = "EPOD booster ready This bit is set to 1 by hardware when the power booster startup time is reached. The system clock frequency can be switched higher than 50 MHz only after this bit is set."]
pub fn set_boostrdy (& mut self , val : super :: vals :: Boostrdy) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Ready bit for VCORE voltage scaling output selection"]
pub const fn vosrdy (& self) -> super :: vals :: Vosrdy { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Vosrdy (val as u8) } # [doc = "Ready bit for VCORE voltage scaling output selection"]
pub fn set_vosrdy (& mut self , val : super :: vals :: Vosrdy) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Voltage scaling range selection This field is protected against non-secure access when SYSCLKSEC = 1 in RCC_SECCFGR. It is protected against unprivileged access when SYSCLKSEC = 1 in RCC_SECCFGR and SPRIV = 1 in PRIVCFGR, or when SYSCLKSEC = 0 and NSPRIV = 1."]
pub const fn vos (& self) -> super :: vals :: Vos { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Vos (val as u8) } # [doc = "Voltage scaling range selection This field is protected against non-secure access when SYSCLKSEC = 1 in RCC_SECCFGR. It is protected against unprivileged access when SYSCLKSEC = 1 in RCC_SECCFGR and SPRIV = 1 in PRIVCFGR, or when SYSCLKSEC = 0 and NSPRIV = 1."]
pub fn set_vos (& mut self , val : super :: vals :: Vos) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "EPOD booster enable"]
pub const fn boosten (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "EPOD booster enable"]
pub fn set_boosten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Vosr { fn default () -> Vosr { Vosr (0) } } # [doc = "PWR security configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Seccfgr (pub u32) ; impl Seccfgr { # [doc = "WUP1 secure protection"]
pub const fn wup1sec (& self) -> super :: vals :: Wupsec { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Wupsec (val as u8) } # [doc = "WUP1 secure protection"]
pub fn set_wup1sec (& mut self , val : super :: vals :: Wupsec) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "WUP2 secure protection"]
pub const fn wup2sec (& self) -> super :: vals :: Wupsec { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Wupsec (val as u8) } # [doc = "WUP2 secure protection"]
pub fn set_wup2sec (& mut self , val : super :: vals :: Wupsec) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "WUP3 secure protection"]
pub const fn wup3sec (& self) -> super :: vals :: Wupsec { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Wupsec (val as u8) } # [doc = "WUP3 secure protection"]
pub fn set_wup3sec (& mut self , val : super :: vals :: Wupsec) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "WUP4 secure protection"]
pub const fn wup4sec (& self) -> super :: vals :: Wupsec { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Wupsec (val as u8) } # [doc = "WUP4 secure protection"]
pub fn set_wup4sec (& mut self , val : super :: vals :: Wupsec) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "WUP5 secure protection"]
pub const fn wup5sec (& self) -> super :: vals :: Wupsec { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Wupsec (val as u8) } # [doc = "WUP5 secure protection"]
pub fn set_wup5sec (& mut self , val : super :: vals :: Wupsec) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "WUP6 secure protection"]
pub const fn wup6sec (& self) -> super :: vals :: Wupsec { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Wupsec (val as u8) } # [doc = "WUP6 secure protection"]
pub fn set_wup6sec (& mut self , val : super :: vals :: Wupsec) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "WUP7 secure protection"]
pub const fn wup7sec (& self) -> super :: vals :: Wupsec { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Wupsec (val as u8) } # [doc = "WUP7 secure protection"]
pub fn set_wup7sec (& mut self , val : super :: vals :: Wupsec) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "WUP8 secure protection"]
pub const fn wup8sec (& self) -> super :: vals :: Wupsec { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Wupsec (val as u8) } # [doc = "WUP8 secure protection"]
pub fn set_wup8sec (& mut self , val : super :: vals :: Wupsec) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Low-power modes secure protection"]
pub const fn lpmsec (& self) -> super :: vals :: Lpmsec { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Lpmsec (val as u8) } # [doc = "Low-power modes secure protection"]
pub fn set_lpmsec (& mut self , val : super :: vals :: Lpmsec) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Voltage detection and monitoring secure protection"]
pub const fn vdmsec (& self) -> super :: vals :: Vdmsec { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Vdmsec (val as u8) } # [doc = "Voltage detection and monitoring secure protection"]
pub fn set_vdmsec (& mut self , val : super :: vals :: Vdmsec) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Backup domain secure protection"]
pub const fn vbsec (& self) -> super :: vals :: Vbsec { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Vbsec (val as u8) } # [doc = "Backup domain secure protection"]
pub fn set_vbsec (& mut self , val : super :: vals :: Vbsec) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Pull-up/pull-down secure protection"]
pub const fn apcsec (& self) -> super :: vals :: Apcsec { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Apcsec (val as u8) } # [doc = "Pull-up/pull-down secure protection"]
pub fn set_apcsec (& mut self , val : super :: vals :: Apcsec) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Seccfgr { fn default () -> Seccfgr { Seccfgr (0) } } # [doc = "PWR privilege control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Privcfgr (pub u32) ; impl Privcfgr { # [doc = "PWR secure functions privilege configuration This bit is set and reset by software. It can be written only by a secure privileged access."]
pub const fn spriv (& self) -> super :: vals :: Spriv { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Spriv (val as u8) } # [doc = "PWR secure functions privilege configuration This bit is set and reset by software. It can be written only by a secure privileged access."]
pub fn set_spriv (& mut self , val : super :: vals :: Spriv) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "PWR non-secure functions privilege configuration This bit is set and reset by software. It can be written only by privileged access, secure or non-secure."]
pub const fn nspriv (& self) -> super :: vals :: Nspriv { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Nspriv (val as u8) } # [doc = "PWR non-secure functions privilege configuration This bit is set and reset by software. It can be written only by privileged access, secure or non-secure."]
pub fn set_nspriv (& mut self , val : super :: vals :: Nspriv) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } } impl Default for Privcfgr { fn default () -> Privcfgr { Privcfgr (0) } } # [doc = "PWR Backup domain status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdsr (pub u32) ; impl Bdsr { # [doc = "Backup domain voltage level monitoring versus high threshold"]
pub const fn vbath (& self) -> super :: vals :: Vbath { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Vbath (val as u8) } # [doc = "Backup domain voltage level monitoring versus high threshold"]
pub fn set_vbath (& mut self , val : super :: vals :: Vbath) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Temperature level monitoring versus low threshold"]
pub const fn templ (& self) -> super :: vals :: Templ { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Templ (val as u8) } # [doc = "Temperature level monitoring versus low threshold"]
pub fn set_templ (& mut self , val : super :: vals :: Templ) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Temperature level monitoring versus high threshold"]
pub const fn temph (& self) -> super :: vals :: Temph { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Temph (val as u8) } # [doc = "Temperature level monitoring versus high threshold"]
pub fn set_temph (& mut self , val : super :: vals :: Temph) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } } impl Default for Bdsr { fn default () -> Bdsr { Bdsr (0) } } # [doc = "PWR supply voltage monitoring control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Svmcr (pub u32) ; impl Svmcr { # [doc = "Power voltage detector enable"]
pub const fn pvde (& self) -> super :: vals :: Pvde { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Pvde (val as u8) } # [doc = "Power voltage detector enable"]
pub fn set_pvde (& mut self , val : super :: vals :: Pvde) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Power voltage detector level selection These bits select the voltage threshold detected by the power voltage detector:"]
pub const fn pvdls (& self) -> super :: vals :: Pvdls { let val = (self . 0 >> 5usize) & 0x07 ; super :: vals :: Pvdls (val as u8) } # [doc = "Power voltage detector level selection These bits select the voltage threshold detected by the power voltage detector:"]
pub fn set_pvdls (& mut self , val : super :: vals :: Pvdls) { self . 0 = (self . 0 & ! (0x07 << 5usize)) | (((val . 0 as u32) & 0x07) << 5usize) ; } # [doc = "VDDUSB independent USB voltage monitor enable"]
pub const fn uvmen (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "VDDUSB independent USB voltage monitor enable"]
pub fn set_uvmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "VDDIO2 independent I/Os voltage monitor enable"]
pub const fn io2vmen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "VDDIO2 independent I/Os voltage monitor enable"]
pub fn set_io2vmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "VDDA independent analog supply voltage monitor 1 enable (1.6 V threshold)"]
pub const fn avm1en (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "VDDA independent analog supply voltage monitor 1 enable (1.6 V threshold)"]
pub fn set_avm1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "VDDA independent analog supply voltage monitor 2 enable (1.8 V threshold)"]
pub const fn avm2en (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "VDDA independent analog supply voltage monitor 2 enable (1.8 V threshold)"]
pub fn set_avm2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "VDDUSB independent USB supply valid"]
pub const fn usv (& self) -> super :: vals :: Usv { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: Usv (val as u8) } # [doc = "VDDUSB independent USB supply valid"]
pub fn set_usv (& mut self , val : super :: vals :: Usv) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } # [doc = "VDDIO2 independent I/Os supply valid This bit is used to validate the VDDIO2 supply for electrical and logical isolation purpose. Setting this bit is mandatory to use PG[15:2]. If VDDIO2 is not always present in the application, the VDDIO2 voltage monitor can be used to determine whether this supply is ready or not."]
pub const fn io2sv (& self) -> super :: vals :: Iosv { let val = (self . 0 >> 29usize) & 0x01 ; super :: vals :: Iosv (val as u8) } # [doc = "VDDIO2 independent I/Os supply valid This bit is used to validate the VDDIO2 supply for electrical and logical isolation purpose. Setting this bit is mandatory to use PG[15:2]. If VDDIO2 is not always present in the application, the VDDIO2 voltage monitor can be used to determine whether this supply is ready or not."]
pub fn set_io2sv (& mut self , val : super :: vals :: Iosv) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val . 0 as u32) & 0x01) << 29usize) ; } # [doc = "VDDA independent analog supply valid"]
pub const fn asv (& self) -> super :: vals :: Asv { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: Asv (val as u8) } # [doc = "VDDA independent analog supply valid"]
pub fn set_asv (& mut self , val : super :: vals :: Asv) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } } impl Default for Svmcr { fn default () -> Svmcr { Svmcr (0) } } # [doc = "PWR control register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr3 (pub u32) ; impl Cr3 { # [doc = "Regulator selection Note: REGSEL is reserved and must be kept at reset value in packages without SMPS."]
pub const fn regsel (& self) -> super :: vals :: Regsel { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Regsel (val as u8) } # [doc = "Regulator selection Note: REGSEL is reserved and must be kept at reset value in packages without SMPS."]
pub fn set_regsel (& mut self , val : super :: vals :: Regsel) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Fast soft start"]
pub const fn fsten (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Fast soft start"]
pub fn set_fsten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Cr3 { fn default () -> Cr3 { Cr3 (0) } } # [doc = "PWR Backup domain control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr1 (pub u32) ; impl Bdcr1 { # [doc = "Backup RAM retention in Standby and VBAT modes When this bit is set, the backup RAM content is kept in Standby and VBAT modes. If BREN is reset, the backup RAM can still be used in Run, Sleep and Stop modes. However, its content is lost in Standby, Shutdown and VBAT modes. This bit can be written only when the regulator is LDO, which must be configured before switching to SMPS. Note: Backup RAM cannot be preserved in Shutdown mode."]
pub const fn bren (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Backup RAM retention in Standby and VBAT modes When this bit is set, the backup RAM content is kept in Standby and VBAT modes. If BREN is reset, the backup RAM can still be used in Run, Sleep and Stop modes. However, its content is lost in Standby, Shutdown and VBAT modes. This bit can be written only when the regulator is LDO, which must be configured before switching to SMPS. Note: Backup RAM cannot be preserved in Shutdown mode."]
pub fn set_bren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Backup domain voltage and temperature monitoring enable"]
pub const fn monen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Backup domain voltage and temperature monitoring enable"]
pub fn set_monen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Bdcr1 { fn default () -> Bdcr1 { Bdcr1 (0) } } # [doc = "PWR Backup domain control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bdcr2 (pub u32) ; impl Bdcr2 { # [doc = "VBAT charging enable"]
pub const fn vbe (& self) -> super :: vals :: Vbe { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Vbe (val as u8) } # [doc = "VBAT charging enable"]
pub fn set_vbe (& mut self , val : super :: vals :: Vbe) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "VBAT charging resistor selection"]
pub const fn vbrs (& self) -> super :: vals :: Vbrs { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Vbrs (val as u8) } # [doc = "VBAT charging resistor selection"]
pub fn set_vbrs (& mut self , val : super :: vals :: Vbrs) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } } impl Default for Bdcr2 { fn default () -> Bdcr2 { Bdcr2 (0) } } # [doc = "PWR wakeup status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wusr (pub u32) ; impl Wusr { # [doc = "Wakeup flag 1 This bit is set when a wakeup event is detected on WKUP1 pin. This bit is cleared by writing 1 in the CWUF1 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN1 = 0."]
pub const fn wuf1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 1 This bit is set when a wakeup event is detected on WKUP1 pin. This bit is cleared by writing 1 in the CWUF1 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN1 = 0."]
pub fn set_wuf1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Wakeup flag 2 This bit is set when a wakeup event is detected on WKUP2 pin. This bit is cleared by writing 1 in the CWUF2 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN2 = 0."]
pub const fn wuf2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 2 This bit is set when a wakeup event is detected on WKUP2 pin. This bit is cleared by writing 1 in the CWUF2 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN2 = 0."]
pub fn set_wuf2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup flag 3 This bit is set when a wakeup event is detected on WKUP3 pin. This bit is cleared by writing 1 in the CWUF3 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN3 = 0."]
pub const fn wuf3 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 3 This bit is set when a wakeup event is detected on WKUP3 pin. This bit is cleared by writing 1 in the CWUF3 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN3 = 0."]
pub fn set_wuf3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Wakeup flag 4 This bit is set when a wakeup event is detected on WKUP4 pin. This bit is cleared by writing 1 in the CWUF4 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN4 = 0."]
pub const fn wuf4 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 4 This bit is set when a wakeup event is detected on WKUP4 pin. This bit is cleared by writing 1 in the CWUF4 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN4 = 0."]
pub fn set_wuf4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Wakeup flag 5 This bit is set when a wakeup event is detected on WKUP5 pin. This bit is cleared by writing 1 in the CWUF5 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN5 = 0."]
pub const fn wuf5 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 5 This bit is set when a wakeup event is detected on WKUP5 pin. This bit is cleared by writing 1 in the CWUF5 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN5 = 0."]
pub fn set_wuf5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Wakeup flag 6 This bit is set when a wakeup event is detected on WKUP6 pin. This bit is cleared by writing 1 in the CWUF6 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN6 = 0. If WUSEL = 11, this bit is cleared by hardware when all internal wakeup source are cleared."]
pub const fn wuf6 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 6 This bit is set when a wakeup event is detected on WKUP6 pin. This bit is cleared by writing 1 in the CWUF6 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN6 = 0. If WUSEL = 11, this bit is cleared by hardware when all internal wakeup source are cleared."]
pub fn set_wuf6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Wakeup flag 7 This bit is set when a wakeup event is detected on WKUP7 pin. This bit is cleared by writing 1 in the CWUF7 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN7 = 0. If WUSEL = 11, this bit is cleared by hardware when all internal wakeup source are cleared."]
pub const fn wuf7 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 7 This bit is set when a wakeup event is detected on WKUP7 pin. This bit is cleared by writing 1 in the CWUF7 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN7 = 0. If WUSEL = 11, this bit is cleared by hardware when all internal wakeup source are cleared."]
pub fn set_wuf7 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Wakeup flag 8 This bit is set when a wakeup event is detected on WKUP8 pin. This bit is cleared by writing 1 in the CWUF8 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN8 = 0. If WUSEL = 11, this bit is cleared by hardware when all internal wakeup source are cleared."]
pub const fn wuf8 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 8 This bit is set when a wakeup event is detected on WKUP8 pin. This bit is cleared by writing 1 in the CWUF8 bit of WUSCR when WUSEL ≠ 11, or by hardware when WUPEN8 = 0. If WUSEL = 11, this bit is cleared by hardware when all internal wakeup source are cleared."]
pub fn set_wuf8 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Wusr { fn default () -> Wusr { Wusr (0) } } # [doc = "PWR wakeup control register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wucr3 (pub u32) ; impl Wucr3 { # [doc = "Wakeup pin WKUP1 selection This field must be configured when WUPEN1 = 0."]
pub const fn wusel1 (& self) -> super :: vals :: Wusel { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Wusel (val as u8) } # [doc = "Wakeup pin WKUP1 selection This field must be configured when WUPEN1 = 0."]
pub fn set_wusel1 (& mut self , val : super :: vals :: Wusel) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "Wakeup pin WKUP2 selection This field must be configured when WUPEN2 = 0."]
pub const fn wusel2 (& self) -> super :: vals :: Wusel { let val = (self . 0 >> 2usize) & 0x03 ; super :: vals :: Wusel (val as u8) } # [doc = "Wakeup pin WKUP2 selection This field must be configured when WUPEN2 = 0."]
pub fn set_wusel2 (& mut self , val : super :: vals :: Wusel) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val . 0 as u32) & 0x03) << 2usize) ; } # [doc = "Wakeup pin WKUP3 selection This field must be configured when WUPEN3 = 0."]
pub const fn wusel3 (& self) -> super :: vals :: Wusel { let val = (self . 0 >> 4usize) & 0x03 ; super :: vals :: Wusel (val as u8) } # [doc = "Wakeup pin WKUP3 selection This field must be configured when WUPEN3 = 0."]
pub fn set_wusel3 (& mut self , val : super :: vals :: Wusel) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val . 0 as u32) & 0x03) << 4usize) ; } # [doc = "Wakeup pin WKUP4 selection This field must be configured when WUPEN4 = 0."]
pub const fn wusel4 (& self) -> super :: vals :: Wusel { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: Wusel (val as u8) } # [doc = "Wakeup pin WKUP4 selection This field must be configured when WUPEN4 = 0."]
pub fn set_wusel4 (& mut self , val : super :: vals :: Wusel) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "Wakeup pin WKUP5 selection This field must be configured when WUPEN5 = 0."]
pub const fn wusel5 (& self) -> super :: vals :: Wusel { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Wusel (val as u8) } # [doc = "Wakeup pin WKUP5 selection This field must be configured when WUPEN5 = 0."]
pub fn set_wusel5 (& mut self , val : super :: vals :: Wusel) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "Wakeup pin WKUP6 selection This field must be configured when WUPEN6 = 0."]
pub const fn wusel6 (& self) -> super :: vals :: Wusel { let val = (self . 0 >> 10usize) & 0x03 ; super :: vals :: Wusel (val as u8) } # [doc = "Wakeup pin WKUP6 selection This field must be configured when WUPEN6 = 0."]
pub fn set_wusel6 (& mut self , val : super :: vals :: Wusel) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val . 0 as u32) & 0x03) << 10usize) ; } # [doc = "Wakeup pin WKUP7 selection This field must be configured when WUPEN7 = 0."]
pub const fn wusel7 (& self) -> super :: vals :: Wusel { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Wusel (val as u8) } # [doc = "Wakeup pin WKUP7 selection This field must be configured when WUPEN7 = 0."]
pub fn set_wusel7 (& mut self , val : super :: vals :: Wusel) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "Wakeup pin WKUP8 selection This field must be configured when WUPEN8 = 0."]
pub const fn wusel8 (& self) -> super :: vals :: Wusel { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: Wusel (val as u8) } # [doc = "Wakeup pin WKUP8 selection This field must be configured when WUPEN8 = 0."]
pub fn set_wusel8 (& mut self , val : super :: vals :: Wusel) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } } impl Default for Wucr3 { fn default () -> Wucr3 { Wucr3 (0) } } # [doc = "PWR USB Type-C™ and Power Delivery register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ucpdr (pub u32) ; impl Ucpdr { # [doc = "UCPD dead battery disable After exiting reset, the USB Type-C “dead battery” behavior is enabled, which may have a pull-down effect on CC1 and CC2 pins. It is recommended to disable it in all cases, either to stop this pull-down or to handover control to the UCPD (the UCPD must be initialized before doing the disable)."]
pub const fn ucpd_dbdis (& self) -> super :: vals :: UcpdDbdis { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: UcpdDbdis (val as u8) } # [doc = "UCPD dead battery disable After exiting reset, the USB Type-C “dead battery” behavior is enabled, which may have a pull-down effect on CC1 and CC2 pins. It is recommended to disable it in all cases, either to stop this pull-down or to handover control to the UCPD (the UCPD must be initialized before doing the disable)."]
pub fn set_ucpd_dbdis (& mut self , val : super :: vals :: UcpdDbdis) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "UCPD Standby mode When set, this bit is used to memorize the UCPD configuration in Standby mode. This bit must be written to 1 just before entering Standby mode when using UCPD. It must be written to 0 after exiting the Standby mode and before writing any UCPD registers."]
pub const fn ucpd_stby (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "UCPD Standby mode When set, this bit is used to memorize the UCPD configuration in Standby mode. This bit must be written to 1 just before entering Standby mode when using UCPD. It must be written to 0 after exiting the Standby mode and before writing any UCPD registers."]
pub fn set_ucpd_stby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Ucpdr { fn default () -> Ucpdr { Ucpdr (0) } } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Svmsr (pub u32) ; impl Svmsr { # [doc = "Regulator selection"]
pub const fn regs (& self) -> super :: vals :: Regs { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Regs (val as u8) } # [doc = "Regulator selection"]
pub fn set_regs (& mut self , val : super :: vals :: Regs) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "VDD voltage detector output"]
pub const fn pvdo (& self) -> super :: vals :: Pvdo { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Pvdo (val as u8) } # [doc = "VDD voltage detector output"]
pub fn set_pvdo (& mut self , val : super :: vals :: Pvdo) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Voltage level ready for currently used VOS"]
pub const fn actvosrdy (& self) -> super :: vals :: Actvosrdy { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Actvosrdy (val as u8) } # [doc = "Voltage level ready for currently used VOS"]
pub fn set_actvosrdy (& mut self , val : super :: vals :: Actvosrdy) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "VOS currently applied to VCORE This field provides the last VOS value."]
pub const fn actvos (& self) -> super :: vals :: Actvos { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Actvos (val as u8) } # [doc = "VOS currently applied to VCORE This field provides the last VOS value."]
pub fn set_actvos (& mut self , val : super :: vals :: Actvos) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "VDDUSB ready"]
pub const fn vddusbrdy (& self) -> super :: vals :: Vddusbrdy { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Vddusbrdy (val as u8) } # [doc = "VDDUSB ready"]
pub fn set_vddusbrdy (& mut self , val : super :: vals :: Vddusbrdy) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "VDDIO2 ready"]
pub const fn vddio2rdy (& self) -> super :: vals :: Vddiordy { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Vddiordy (val as u8) } # [doc = "VDDIO2 ready"]
pub fn set_vddio2rdy (& mut self , val : super :: vals :: Vddiordy) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "VDDA ready versus 1.6V voltage monitor"]
pub const fn vdda1rdy (& self) -> super :: vals :: Vddardy { let val = (self . 0 >> 26usize) & 0x01 ; super :: vals :: Vddardy (val as u8) } # [doc = "VDDA ready versus 1.6V voltage monitor"]
pub fn set_vdda1rdy (& mut self , val : super :: vals :: Vddardy) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val . 0 as u32) & 0x01) << 26usize) ; } # [doc = "VDDA ready versus 1.8 V voltage monitor"]
pub const fn vdda2rdy (& self) -> super :: vals :: Vddardy { let val = (self . 0 >> 27usize) & 0x01 ; super :: vals :: Vddardy (val as u8) } # [doc = "VDDA ready versus 1.8 V voltage monitor"]
pub fn set_vdda2rdy (& mut self , val : super :: vals :: Vddardy) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val . 0 as u32) & 0x01) << 27usize) ; } } impl Default for Svmsr { fn default () -> Svmsr { Svmsr (0) } } # [doc = "PWR status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Clear Stop and Standby flags This bit is protected against non-secure access when LPMSEC = 1 in SECCFGR. This bit is protected against unprivileged access when LPMSEC = 1 and SPRIV = 1 in PRIVCFGR, or when LPMSEC = 0 and NSPRIV = 1. Writing 1 to this bit clears the STOPF and SBF flags."]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Clear Stop and Standby flags This bit is protected against non-secure access when LPMSEC = 1 in SECCFGR. This bit is protected against unprivileged access when LPMSEC = 1 and SPRIV = 1 in PRIVCFGR, or when LPMSEC = 0 and NSPRIV = 1. Writing 1 to this bit clears the STOPF and SBF flags."]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Stop flag This bit is set by hardware when the device enters a Stop mode, and is cleared by software by writing 1 to the CSSF bit."]
pub const fn stopf (& self) -> super :: vals :: Stopf { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Stopf (val as u8) } # [doc = "Stop flag This bit is set by hardware when the device enters a Stop mode, and is cleared by software by writing 1 to the CSSF bit."]
pub fn set_stopf (& mut self , val : super :: vals :: Stopf) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Standby flag This bit is set by hardware when the device enters the Standby mode, and is cleared by writing 1 to the CSSF bit, or by a power-on reset. It is not cleared by the system reset."]
pub const fn sbf (& self) -> super :: vals :: Sbf { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Sbf (val as u8) } # [doc = "Standby flag This bit is set by hardware when the device enters the Standby mode, and is cleared by writing 1 to the CSSF bit, or by a power-on reset. It is not cleared by the system reset."]
pub fn set_sbf (& mut self , val : super :: vals :: Sbf) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "PWR control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "SRAM1 page 1 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram1pds1 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM1 page 1 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram1pds1 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "SRAM1 page 2 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram1pds2 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM1 page 2 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram1pds2 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "SRAM1 page 3 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram1pds3 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM1 page 3 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram1pds3 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "SRAM2 page 1 (8 Kbytes) power-down in Stop modes (Stop 0, 1, 2) Note: The SRAM2 page 1 retention in Stop 3 is controlled by RRSB1 bit in CR1."]
pub const fn sram2pds1 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM2 page 1 (8 Kbytes) power-down in Stop modes (Stop 0, 1, 2) Note: The SRAM2 page 1 retention in Stop 3 is controlled by RRSB1 bit in CR1."]
pub fn set_sram2pds1 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "SRAM2 page 2 (56 Kbytes) power-down in Stop modes (Stop 0, 1, 2) Note: The SRAM2 page 2 retention in Stop 3 is controlled by RRSB2 bit in CR1."]
pub const fn sram2pds2 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM2 page 2 (56 Kbytes) power-down in Stop modes (Stop 0, 1, 2) Note: The SRAM2 page 2 retention in Stop 3 is controlled by RRSB2 bit in CR1."]
pub fn set_sram2pds2 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "SRAM4 power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram4pds (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM4 power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram4pds (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "ICACHE SRAM power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn icrampds (& self) -> super :: vals :: Icrampds { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Icrampds (val as u8) } # [doc = "ICACHE SRAM power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_icrampds (& mut self , val : super :: vals :: Icrampds) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "DCACHE1 SRAM power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn dc1rampds (& self) -> super :: vals :: Dcrampds { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Dcrampds (val as u8) } # [doc = "DCACHE1 SRAM power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_dc1rampds (& mut self , val : super :: vals :: Dcrampds) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "DMA2D SRAM power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn dma2drampds (& self) -> super :: vals :: Dmadrampds { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Dmadrampds (val as u8) } # [doc = "DMA2D SRAM power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_dma2drampds (& mut self , val : super :: vals :: Dmadrampds) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "FMAC, FDCAN and USB peripherals SRAM power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn prampds (& self) -> super :: vals :: Prampds { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Prampds (val as u8) } # [doc = "FMAC, FDCAN and USB peripherals SRAM power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_prampds (& mut self , val : super :: vals :: Prampds) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "PKA SRAM power-down"]
pub const fn pkarampds (& self) -> super :: vals :: Pkarampds { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Pkarampds (val as u8) } # [doc = "PKA SRAM power-down"]
pub fn set_pkarampds (& mut self , val : super :: vals :: Pkarampds) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "SRAM4 fast wakeup from Stop 0, Stop 1 and Stop 2 modes This bit is used to obtain the best trade-off between low-power consumption and wakeup time. SRAM4 wakeup time increases the wakeup time when exiting Stop 0, 1 and 2 modes, and also increases the LPDMA access time to SRAM4 during Stop modes."]
pub const fn sram4fwu (& self) -> super :: vals :: Sramfwu { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Sramfwu (val as u8) } # [doc = "SRAM4 fast wakeup from Stop 0, Stop 1 and Stop 2 modes This bit is used to obtain the best trade-off between low-power consumption and wakeup time. SRAM4 wakeup time increases the wakeup time when exiting Stop 0, 1 and 2 modes, and also increases the LPDMA access time to SRAM4 during Stop modes."]
pub fn set_sram4fwu (& mut self , val : super :: vals :: Sramfwu) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Flash memory fast wakeup from Stop 0 and Stop 1 modes This bit is used to obtain the best trade-off between low-power consumption and wakeup time when exiting the Stop 0 or Stop 1 modes. When this bit is set, the Flash memory remains in normal mode in Stop 0 and Stop 1 modes, which offers a faster startup time with higher consumption."]
pub const fn flashfwu (& self) -> super :: vals :: Flashfwu { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Flashfwu (val as u8) } # [doc = "Flash memory fast wakeup from Stop 0 and Stop 1 modes This bit is used to obtain the best trade-off between low-power consumption and wakeup time when exiting the Stop 0 or Stop 1 modes. When this bit is set, the Flash memory remains in normal mode in Stop 0 and Stop 1 modes, which offers a faster startup time with higher consumption."]
pub fn set_flashfwu (& mut self , val : super :: vals :: Flashfwu) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "SRAM3 page 1 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram3pds1 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM3 page 1 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram3pds1 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "SRAM3 page 2 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram3pds2 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM3 page 2 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram3pds2 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } # [doc = "SRAM3 page 3 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram3pds3 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 18usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM3 page 3 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram3pds3 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val . 0 as u32) & 0x01) << 18usize) ; } # [doc = "SRAM3 page 4 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram3pds4 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM3 page 4 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram3pds4 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "SRAM3 page 5 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram3pds5 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM3 page 5 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram3pds5 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "SRAM3 page 6 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram3pds6 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 21usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM3 page 6 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram3pds6 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val . 0 as u32) & 0x01) << 21usize) ; } # [doc = "SRAM3 page 7 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram3pds7 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM3 page 7 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram3pds7 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "SRAM3 page 8 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub const fn sram3pds8 (& self) -> super :: vals :: Srampds { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Srampds (val as u8) } # [doc = "SRAM3 page 8 (64 Kbytes) power-down in Stop modes (Stop 0, 1, 2, 3)"]
pub fn set_sram3pds8 (& mut self , val : super :: vals :: Srampds) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "SmartRun domain in Run mode"]
pub const fn srdrun (& self) -> super :: vals :: Srdrun { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Srdrun (val as u8) } # [doc = "SmartRun domain in Run mode"]
pub fn set_srdrun (& mut self , val : super :: vals :: Srdrun) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "PWR apply pull configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apcr (pub u32) ; impl Apcr { # [doc = "Apply pull-up and pull-down configuration When this bit is set, the I/O pull-up and pull-down configurations defined in PUCRx and PDCRx are applied. When this bit is cleared, PUCRx and PDCRx are not applied to the I/Os."]
pub const fn apc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Apply pull-up and pull-down configuration When this bit is set, the I/O pull-up and pull-down configurations defined in PUCRx and PDCRx are applied. When this bit is cleared, PUCRx and PDCRx are not applied to the I/Os."]
pub fn set_apc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Apcr { fn default () -> Apcr { Apcr (0) } } # [doc = "PWR wakeup control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wucr1 (pub u32) ; impl Wucr1 { # [doc = "Wakeup pin WKUP1 enable"]
pub const fn wupen1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP1 enable"]
pub fn set_wupen1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Wakeup pin WKUP2 enable"]
pub const fn wupen2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP2 enable"]
pub fn set_wupen2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup pin WKUP3 enable"]
pub const fn wupen3 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP3 enable"]
pub fn set_wupen3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Wakeup pin WKUP4 enable"]
pub const fn wupen4 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP4 enable"]
pub fn set_wupen4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Wakeup pin WKUP5 enable"]
pub const fn wupen5 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP5 enable"]
pub fn set_wupen5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Wakeup pin WKUP6 enable"]
pub const fn wupen6 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP6 enable"]
pub fn set_wupen6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Wakeup pin WKUP7 enable"]
pub const fn wupen7 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP7 enable"]
pub fn set_wupen7 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Wakeup pin WKUP8 enable"]
pub const fn wupen8 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP8 enable"]
pub fn set_wupen8 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Wucr1 { fn default () -> Wucr1 { Wucr1 (0) } } # [doc = "PWR control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Low-power mode selection These bits select the low-power mode entered when the CPU enters the Deepsleep mode. 10x: Standby mode (Standby mode also entered if LPMS = 11X in CR1 with BREN = 1 in BDCR1) 11x: Shutdown mode if BREN = 0 in BDCR1"]
pub const fn lpms (& self) -> super :: vals :: Lpms { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Lpms (val as u8) } # [doc = "Low-power mode selection These bits select the low-power mode entered when the CPU enters the Deepsleep mode. 10x: Standby mode (Standby mode also entered if LPMS = 11X in CR1 with BREN = 1 in BDCR1) 11x: Shutdown mode if BREN = 0 in BDCR1"]
pub fn set_lpms (& mut self , val : super :: vals :: Lpms) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "SRAM2 page 1 retention in Stop 3 and Standby modes This bit is used to keep the SRAM2 page 1 content in Stop 3 and Standby modes. The SRAM2 page 1 corresponds to the first 8 Kbytes of the SRAM2 (from SRAM2 base address to SRAM2 base address + 0x1FFF). Note: This bit has no effect in Shutdown mode."]
pub const fn rrsb1 (& self) -> super :: vals :: Rrsb { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Rrsb (val as u8) } # [doc = "SRAM2 page 1 retention in Stop 3 and Standby modes This bit is used to keep the SRAM2 page 1 content in Stop 3 and Standby modes. The SRAM2 page 1 corresponds to the first 8 Kbytes of the SRAM2 (from SRAM2 base address to SRAM2 base address + 0x1FFF). Note: This bit has no effect in Shutdown mode."]
pub fn set_rrsb1 (& mut self , val : super :: vals :: Rrsb) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "SRAM2 page 2 retention in Stop 3 and Standby modes This bit is used to keep the SRAM2 page 2 content in Stop 3 and Standby modes. The SRAM2 page 2 corresponds to the last 56 Kbytes of the SRAM2 (from SRAM2 base address + 0x2000 to SRAM2 base address + 0xFFFF). Note: This bit has no effect in Shutdown mode."]
pub const fn rrsb2 (& self) -> super :: vals :: Rrsb { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Rrsb (val as u8) } # [doc = "SRAM2 page 2 retention in Stop 3 and Standby modes This bit is used to keep the SRAM2 page 2 content in Stop 3 and Standby modes. The SRAM2 page 2 corresponds to the last 56 Kbytes of the SRAM2 (from SRAM2 base address + 0x2000 to SRAM2 base address + 0xFFFF). Note: This bit has no effect in Shutdown mode."]
pub fn set_rrsb2 (& mut self , val : super :: vals :: Rrsb) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "BOR ultra-low power mode This bit is used to reduce the consumption by configuring the BOR in discontinuous mode. This bit must be set to reach the lowest power consumption in the low-power modes."]
pub const fn ulpmen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "BOR ultra-low power mode This bit is used to reduce the consumption by configuring the BOR in discontinuous mode. This bit must be set to reach the lowest power consumption in the low-power modes."]
pub fn set_ulpmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "SRAM1 power down This bit is used to reduce the consumption by powering off the SRAM1."]
pub const fn sram1pd (& self) -> super :: vals :: Srampd { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Srampd (val as u8) } # [doc = "SRAM1 power down This bit is used to reduce the consumption by powering off the SRAM1."]
pub fn set_sram1pd (& mut self , val : super :: vals :: Srampd) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "SRAM2 power down This bit is used to reduce the consumption by powering off the SRAM2."]
pub const fn sram2pd (& self) -> super :: vals :: Srampd { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Srampd (val as u8) } # [doc = "SRAM2 power down This bit is used to reduce the consumption by powering off the SRAM2."]
pub fn set_sram2pd (& mut self , val : super :: vals :: Srampd) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "SRAM3 power down This bit is used to reduce the consumption by powering off the SRAM3."]
pub const fn sram3pd (& self) -> super :: vals :: Srampd { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Srampd (val as u8) } # [doc = "SRAM3 power down This bit is used to reduce the consumption by powering off the SRAM3."]
pub fn set_sram3pd (& mut self , val : super :: vals :: Srampd) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "SRAM4 power down This bit is used to reduce the consumption by powering off the SRAM4."]
pub const fn sram4pd (& self) -> super :: vals :: Srampd { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Srampd (val as u8) } # [doc = "SRAM4 power down This bit is used to reduce the consumption by powering off the SRAM4."]
pub fn set_sram4pd (& mut self , val : super :: vals :: Srampd) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "PWR disable Backup domain register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dbpr (pub u32) ; impl Dbpr { # [doc = "Disable Backup domain write protection In reset state, all registers and SRAM in Backup domain are protected against parasitic write access. This bit must be set to enable the write access to these registers."]
pub const fn dbp (& self) -> super :: vals :: Dbp { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Dbp (val as u8) } # [doc = "Disable Backup domain write protection In reset state, all registers and SRAM in Backup domain are protected against parasitic write access. This bit must be set to enable the write access to these registers."]
pub fn set_dbp (& mut self , val : super :: vals :: Dbp) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } } impl Default for Dbpr { fn default () -> Dbpr { Dbpr (0) } } # [doc = "PWR wakeup control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wucr2 (pub u32) ; impl Wucr2 { # [doc = "Wakeup pin WKUP1 polarity. This bit must be configured when WUPEN1 = 0."]
pub const fn wupp1 (& self) -> super :: vals :: Wupp { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Wupp (val as u8) } # [doc = "Wakeup pin WKUP1 polarity. This bit must be configured when WUPEN1 = 0."]
pub fn set_wupp1 (& mut self , val : super :: vals :: Wupp) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Wakeup pin WKUP2 polarity This bit must be configured when WUPEN2 = 0."]
pub const fn wupp2 (& self) -> super :: vals :: Wupp { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Wupp (val as u8) } # [doc = "Wakeup pin WKUP2 polarity This bit must be configured when WUPEN2 = 0."]
pub fn set_wupp2 (& mut self , val : super :: vals :: Wupp) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup pin WKUP3 polarity This bit must be configured when WUPEN3 = 0."]
pub const fn wupp3 (& self) -> super :: vals :: Wupp { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Wupp (val as u8) } # [doc = "Wakeup pin WKUP3 polarity This bit must be configured when WUPEN3 = 0."]
pub fn set_wupp3 (& mut self , val : super :: vals :: Wupp) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Wakeup pin WKUP4 polarity This bit must be configured when WUPEN4 = 0."]
pub const fn wupp4 (& self) -> super :: vals :: Wupp { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Wupp (val as u8) } # [doc = "Wakeup pin WKUP4 polarity This bit must be configured when WUPEN4 = 0."]
pub fn set_wupp4 (& mut self , val : super :: vals :: Wupp) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Wakeup pin WKUP5 polarity This bit must be configured when WUPEN5 = 0."]
pub const fn wupp5 (& self) -> super :: vals :: Wupp { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Wupp (val as u8) } # [doc = "Wakeup pin WKUP5 polarity This bit must be configured when WUPEN5 = 0."]
pub fn set_wupp5 (& mut self , val : super :: vals :: Wupp) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Wakeup pin WKUP6 polarity This bit must be configured when WUPEN6 = 0."]
pub const fn wupp6 (& self) -> super :: vals :: Wupp { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Wupp (val as u8) } # [doc = "Wakeup pin WKUP6 polarity This bit must be configured when WUPEN6 = 0."]
pub fn set_wupp6 (& mut self , val : super :: vals :: Wupp) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Wakeup pin WKUP7 polarity This bit must be configured when WUPEN7 = 0."]
pub const fn wupp7 (& self) -> super :: vals :: Wupp { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Wupp (val as u8) } # [doc = "Wakeup pin WKUP7 polarity This bit must be configured when WUPEN7 = 0."]
pub fn set_wupp7 (& mut self , val : super :: vals :: Wupp) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Wakeup pin WKUP8 polarity This bit must be configured when WUPEN8 = 0."]
pub const fn wupp8 (& self) -> super :: vals :: Wupp { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Wupp (val as u8) } # [doc = "Wakeup pin WKUP8 polarity This bit must be configured when WUPEN8 = 0."]
pub fn set_wupp8 (& mut self , val : super :: vals :: Wupp) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } } impl Default for Wucr2 { fn default () -> Wucr2 { Wucr2 (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sbf (pub u8) ; impl Sbf { # [doc = "The device did not enter Standby mode."]
pub const B_0X0 : Self = Self (0) ; # [doc = "The device entered Standby mode."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Regsel (pub u8) ; impl Regsel { # [doc = "LDO selected"]
pub const B_0X0 : Self = Self (0) ; # [doc = "SMPS selected"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Actvos (pub u8) ; impl Actvos { # [doc = "Range 4 (lowest power)"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Range 3"]
pub const B_0X1 : Self = Self (0x01) ; # [doc = "Range 2"]
pub const B_0X2 : Self = Self (0x02) ; # [doc = "Range 1 (highest frequency)"]
pub const B_0X3 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vbrs (pub u8) ; impl Vbrs { # [doc = "Charge VBAT through a 5 kΩ resistor"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Charge VBAT through a 1.5 kΩ resistor"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct UcpdDbdis (pub u8) ; impl UcpdDbdis { # [doc = "UCPD dead battery pull-down behavior enabled on UCPDx_CC1 and UCPDx_CC2 pins"]
pub const B_0X0 : Self = Self (0) ; # [doc = "UCPD dead battery pull-down behavior disabled on UCPDx_CC1 and UCPDx_CC2 pins"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icrampds (pub u8) ; impl Icrampds { # [doc = "ICACHE SRAM content retained in Stop modes"]
pub const B_0X0 : Self = Self (0) ; # [doc = "ICACHE SRAM content lost in Stop modes"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dcrampds (pub u8) ; impl Dcrampds { # [doc = "DCACHE1 SRAM content retained in Stop modes"]
pub const B_0X0 : Self = Self (0) ; # [doc = "DCACHE1 SRAM content lost in Stop modes"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Actvosrdy (pub u8) ; impl Actvosrdy { # [doc = "VCORE is above or below the current voltage scaling provided by ACTVOS[1:0]."]
pub const B_0X0 : Self = Self (0) ; # [doc = "VCORE is equal to the current voltage scaling provided by ACTVOS[1:0]"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vdmsec (pub u8) ; impl Vdmsec { # [doc = "SVMCR and CR3 can be read and written with secure or non-secure access."]
pub const B_0X0 : Self = Self (0) ; # [doc = "SVMCR and CR3 can be read and written only with secure access."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pkarampds (pub u8) ; impl Pkarampds { # [doc = "PKA SRAM content retained in Stop modes"]
pub const B_0X0 : Self = Self (0) ; # [doc = "PKA SRAM content lost in Stop modes"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vbe (pub u8) ; impl Vbe { # [doc = "VBAT battery charging disabled"]
pub const B_0X0 : Self = Self (0) ; # [doc = "VBAT battery charging enabled"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wupp (pub u8) ; impl Wupp { # [doc = "Detection on high level (rising edge)"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Detection on low level (falling edge)"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Temph (pub u8) ; impl Temph { # [doc = "Temperature < high threshold"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Temperature ≥ high threshold"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lpms (pub u8) ; impl Lpms { # [doc = "Stop 0 mode"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Stop 1 mode"]
pub const B_0X1 : Self = Self (0x01) ; # [doc = "Stop 2 mode"]
pub const B_0X2 : Self = Self (0x02) ; # [doc = "Stop 3 mode"]
pub const B_0X3 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usv (pub u8) ; impl Usv { # [doc = "VDDUSB not present: logical and electrical isolation is applied to ignore this supply."]
pub const B_0X0 : Self = Self (0) ; # [doc = "VDDUSB valid"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Boostrdy (pub u8) ; impl Boostrdy { # [doc = "Power booster not ready"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Power booster ready"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vddusbrdy (pub u8) ; impl Vddusbrdy { # [doc = "VDDUSB is below the threshold of the VDDUSB voltage monitor."]
pub const B_0X0 : Self = Self (0) ; # [doc = "VDDUSB is equal or above the threshold of the VDDUSB voltage monitor."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Stopf (pub u8) ; impl Stopf { # [doc = "The device did not enter any Stop mode."]
pub const B_0X0 : Self = Self (0) ; # [doc = "The device entered a Stop mode."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vbsec (pub u8) ; impl Vbsec { # [doc = "BDCR1, BDCR2 and DBPR can be read and written with secure or non-secure access."]
pub const B_0X0 : Self = Self (0) ; # [doc = "BDCR1, BDCR2 and DBPR can be read and written only with secure access."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prampds (pub u8) ; impl Prampds { # [doc = "FMAC, FDCAN and USB peripherals SRAM content retained in Stop modes"]
pub const B_0X0 : Self = Self (0) ; # [doc = "FMAC, FDCAN and USB peripherals SRAM content lost in Stop modes"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Regs (pub u8) ; impl Regs { # [doc = "LDO selected"]
pub const B_0X0 : Self = Self (0) ; # [doc = "SMPS selected"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vddardy (pub u8) ; impl Vddardy { # [doc = "VDDA is below the threshold of the VDDA voltage monitor 2 (around 1.8 V)."]
pub const B_0X0 : Self = Self (0) ; # [doc = "VDDA is equal or above the threshold of the VDDA voltage monitor 2 (around 1.8 V)."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vbath (pub u8) ; impl Vbath { # [doc = "Backup domain voltage level < high threshold"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Backup domain voltage level ≥ high threshold"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Srampd (pub u8) ; impl Srampd { # [doc = "SRAM1 powered on"]
pub const B_0X0 : Self = Self (0) ; # [doc = "SRAM1 powered off"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pvdo (pub u8) ; impl Pvdo { # [doc = "VDD is equal or above the PVD threshold selected by PVDLS[2:0]."]
pub const B_0X0 : Self = Self (0) ; # [doc = "VDD is below the PVD threshold selected by PVDLS[2:0]."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rrsb (pub u8) ; impl Rrsb { # [doc = "SRAM2 page1 content not retained in Stop 3 and Standby modes"]
pub const B_0X0 : Self = Self (0) ; # [doc = "SRAM2 page1 content retained in Stop 3 and Standby modes"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Flashfwu (pub u8) ; impl Flashfwu { # [doc = "Flash memory enters low-power mode in Stop 0 and Stop 1 modes (lower-power consumption)."]
pub const B_0X0 : Self = Self (0) ; # [doc = "Flash memory remains in normal mode in Stop 0 and Stop 1 modes (faster wakeup time)."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dmadrampds (pub u8) ; impl Dmadrampds { # [doc = "DMA2D SRAM content retained in Stop modes"]
pub const B_0X0 : Self = Self (0) ; # [doc = "DMA2D SRAM content lost in Stop modes"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vos (pub u8) ; impl Vos { # [doc = "Range 4 (lowest power)"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Range 3"]
pub const B_0X1 : Self = Self (0x01) ; # [doc = "Range 2"]
pub const B_0X2 : Self = Self (0x02) ; # [doc = "Range 1 (highest frequency). This value cannot be written when VCOREMEN = 1 in TAMP_OR register."]
pub const B_0X3 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pvdls (pub u8) ; impl Pvdls { # [doc = "VPVD0 around 2.0 V"]
pub const B_0X0 : Self = Self (0) ; # [doc = "VPVD1 around 2.2 V"]
pub const B_0X1 : Self = Self (0x01) ; # [doc = "VPVD2 around 2.4 V"]
pub const B_0X2 : Self = Self (0x02) ; # [doc = "VPVD3 around 2.5 V"]
pub const B_0X3 : Self = Self (0x03) ; # [doc = "VPVD4 around 2.6 V"]
pub const B_0X4 : Self = Self (0x04) ; # [doc = "VPVD5 around 2.8 V"]
pub const B_0X5 : Self = Self (0x05) ; # [doc = "VPVD6 around 2.9 V"]
pub const B_0X6 : Self = Self (0x06) ; # [doc = "External input analog voltage PVD_IN (compared internally to VREFINT)"]
pub const B_0X7 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wupsec (pub u8) ; impl Wupsec { # [doc = "Bits related to the WKUP3 pin in WUCR1, WUCR2, WUCR3 and WUSCR can be read and written with secure or non-secure access."]
pub const B_0X0 : Self = Self (0) ; # [doc = "Bits related to the WKUP3 pin in WUCR1, WUCR2, WUCR3 and WUSCR can be read and written only with secure access."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pvde (pub u8) ; impl Pvde { # [doc = "Power voltage detector disabled"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Power voltage detector enabled"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Apcsec (pub u8) ; impl Apcsec { # [doc = "APCR can be read and written with secure or non-secure access."]
pub const B_0X0 : Self = Self (0) ; # [doc = "APCR can be read and written only with secure access."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sramfwu (pub u8) ; impl Sramfwu { # [doc = "SRAM4 enters low-power mode in Stop 0, 1 and 2 modes (source biasing for lower-power consumption)."]
pub const B_0X0 : Self = Self (0) ; # [doc = "SRAM4 remains in normal mode in Stop 0, 1 and 2 modes (higher consumption but no SRAM4 wakeup time)."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lpmsec (pub u8) ; impl Lpmsec { # [doc = "CR1, CR2 and CSSF in the SR can be read and written with secure or non-secure access."]
pub const B_0X0 : Self = Self (0) ; # [doc = "CR1, CR2, and CSSF in the SR can be read and written only with secure access."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Asv (pub u8) ; impl Asv { # [doc = "VDDA not present: logical and electrical isolation is applied to ignore this supply."]
pub const B_0X0 : Self = Self (0) ; # [doc = "VDDA valid"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Templ (pub u8) ; impl Templ { # [doc = "Temperature > low threshold"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Temperature ≤ low threshold"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wusel (pub u8) ; impl Wusel { # [doc = "WKUP7_0"]
pub const B_0X0 : Self = Self (0) ; # [doc = "WKUP7_1"]
pub const B_0X1 : Self = Self (0x01) ; # [doc = "WKUP7_2"]
pub const B_0X2 : Self = Self (0x02) ; # [doc = "WKUP7_3"]
pub const B_0X3 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Srdrun (pub u8) ; impl Srdrun { # [doc = "SmartRun domain AHB3 and APB3 clocks disabled by default in Stop 0,1, 2 modes"]
pub const B_0X0 : Self = Self (0) ; # [doc = "SmartRun domain AHB3 and APB3 clocks kept enabled in Stop 0,1, 2 modes"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Nspriv (pub u8) ; impl Nspriv { # [doc = "Read and write to PWR non-secure functions can be done by privileged or unprivileged access."]
pub const B_0X0 : Self = Self (0) ; # [doc = "Read and write to PWR non-secure functions can be done by privileged access only."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Iosv (pub u8) ; impl Iosv { # [doc = "VDDIO2 not present: logical and electrical isolation is applied to ignore this supply."]
pub const B_0X0 : Self = Self (0) ; # [doc = "VDDIO2 valid"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Spriv (pub u8) ; impl Spriv { # [doc = "Read and write to PWR secure functions can be done by privileged or unprivileged access."]
pub const B_0X0 : Self = Self (0) ; # [doc = "Read and write to PWR secure functions can be done by privileged access only."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Srampds (pub u8) ; impl Srampds { # [doc = "SRAM3 page 1 content retained in Stop modes"]
pub const B_0X0 : Self = Self (0) ; # [doc = "SRAM3 page 1 content lost in Stop modes"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vosrdy (pub u8) ; impl Vosrdy { # [doc = "Not ready, voltage level < VOS selected level"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Ready, voltage level ≥ VOS selected level"]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vddiordy (pub u8) ; impl Vddiordy { # [doc = "VDDIO2 is below the threshold of the VDDIO2 voltage monitor."]
pub const B_0X0 : Self = Self (0) ; # [doc = "VDDIO2 is equal or above the threshold of the VDDIO2 voltage monitor."]
pub const B_0X1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dbp (pub u8) ; impl Dbp { # [doc = "Write access to Backup domain disabled"]
pub const B_0X0 : Self = Self (0) ; # [doc = "Write access to Backup domain enabled"]
pub const B_0X1 : Self = Self (0x01) ; } }