

# [doc = "PWR"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pwr (pub * mut u8) ; unsafe impl Send for Pwr { } unsafe impl Sync for Pwr { } impl Pwr { # [doc = "PWR control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "PWR control status register 1"]
pub fn csr1 (self) -> crate :: common :: Reg < regs :: Csr1 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "This register is not reset by wakeup from Standby mode, RESET signal and VDD POR. It is only reset by VSW POR and VSWRST reset. This register shall not be accessed when VSWRST bit in RCC_BDCR register resets the VSW domain.After reset, PWR_CR2 register is write-protected. Prior to modifying its content, the DBP bit in PWR_CR1 register must be set to disable the write protection."]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Reset only by POR only, not reset by wakeup from Standby mode and RESET pad. The lower byte of this register is written once after POR and shall be written before changing VOS level or ck_sys clock frequency. No limitation applies to the upper bytes.Programming data corresponding to an invalid combination of SDLEVEL, SDEXTHP, SDEN, LDOEN and BYPASS bits (see Table9) will be ignored: data will not be written, the written-once mechanism will lock the register and any further write access will be ignored. The default supply configuration will be kept and the ACTVOSRDY bit in PWR control status register 1 (PWR_CSR1) will go on indicating invalid voltage levels. The system shall be power cycled before writing a new value."]
pub fn cr3 (self) -> crate :: common :: Reg < regs :: Cr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "This register allows controlling CPU1 power."]
pub fn cpucr (self) -> crate :: common :: Reg < regs :: Cpucr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "This register allows controlling D3 domain power.Following reset VOSRDY will be read 1 by software"]
pub fn d3cr (self) -> crate :: common :: Reg < regs :: D3cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "reset only by system reset, not reset by wakeup from Standby mode5 wait states are required when writing this register (when clearing a WKUPF bit in PWR_WKUPFR, the AHB write access will complete after the WKUPF has been cleared)."]
pub fn wkupcr (self) -> crate :: common :: Reg < regs :: Wkupcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "reset only by system reset, not reset by wakeup from Standby mode"]
pub fn wkupfr (self) -> crate :: common :: Reg < regs :: Wkupfr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "Reset only by system reset, not reset by wakeup from Standby mode"]
pub fn wkupepr (self) -> crate :: common :: Reg < regs :: Wkupepr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } } pub mod regs { # [doc = "reset only by system reset, not reset by wakeup from Standby mode"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wkupfr (pub u32) ; impl Wkupfr { # [doc = "Wakeup pin WKUPF flag. This bit is set by hardware and cleared only by a Reset pin or by setting the WKUPCn+1 bit in the PWR wakeup clear register (PWR_WKUPCR)."]
pub fn wkupf (& self , n : usize) -> bool { assert ! (n < 6usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUPF flag. This bit is set by hardware and cleared only by a Reset pin or by setting the WKUPCn+1 bit in the PWR wakeup clear register (PWR_WKUPCR)."]
pub fn set_wkupf (& mut self , n : usize , val : bool) { assert ! (n < 6usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Wkupfr { fn default () -> Wkupfr { Wkupfr (0) } } # [doc = "This register allows controlling D3 domain power.Following reset VOSRDY will be read 1 by software"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct D3cr (pub u32) ; impl D3cr { # [doc = "VOS Ready bit for VCORE voltage scaling output selection. This bit is set to 1 by hardware when Bypass mode is selected in PWR control register 3 (PWR_CR3)."]
pub const fn vosrdy (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "VOS Ready bit for VCORE voltage scaling output selection. This bit is set to 1 by hardware when Bypass mode is selected in PWR control register 3 (PWR_CR3)."]
pub fn set_vosrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Voltage scaling selection according to performance These bits control the VCORE voltage level and allow to obtains the best trade-off between power consumption and performance: When increasing the performance, the voltage scaling shall be changed before increasing the system frequency. When decreasing performance, the system frequency shall first be decreased before changing the voltage scaling."]
pub const fn vos (& self) -> u8 { let val = (self . 0 >> 14usize) & 0x03 ; val as u8 } # [doc = "Voltage scaling selection according to performance These bits control the VCORE voltage level and allow to obtains the best trade-off between power consumption and performance: When increasing the performance, the voltage scaling shall be changed before increasing the system frequency. When decreasing performance, the system frequency shall first be decreased before changing the voltage scaling."]
pub fn set_vos (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val as u32) & 0x03) << 14usize) ; } } impl Default for D3cr { fn default () -> D3cr { D3cr (0) } } # [doc = "PWR control status register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr1 (pub u32) ; impl Csr1 { # [doc = "Programmable voltage detect output This bit is set and cleared by hardware. It is valid only if the PVD has been enabled by the PVDE bit. Note: since the PVD is disabled in Standby mode, this bit is equal to 0 after Standby or reset until the PVDE bit is set."]
pub const fn pvdo (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Programmable voltage detect output This bit is set and cleared by hardware. It is valid only if the PVD has been enabled by the PVDE bit. Note: since the PVD is disabled in Standby mode, this bit is equal to 0 after Standby or reset until the PVDE bit is set."]
pub fn set_pvdo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Voltage levels ready bit for currently used VOS and SDLEVEL This bit is set to 1 by hardware when the voltage regulator and the SD converter are both disabled and Bypass mode is selected in PWR control register 3 (PWR_CR3)."]
pub const fn actvosrdy (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Voltage levels ready bit for currently used VOS and SDLEVEL This bit is set to 1 by hardware when the voltage regulator and the SD converter are both disabled and Bypass mode is selected in PWR control register 3 (PWR_CR3)."]
pub fn set_actvosrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "VOS currently applied for VCORE voltage scaling selection. These bits reflect the last VOS value applied to the PMU."]
pub const fn actvos (& self) -> u8 { let val = (self . 0 >> 14usize) & 0x03 ; val as u8 } # [doc = "VOS currently applied for VCORE voltage scaling selection. These bits reflect the last VOS value applied to the PMU."]
pub fn set_actvos (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val as u32) & 0x03) << 14usize) ; } # [doc = "Analog voltage detector output on VDDA This bit is set and cleared by hardware. It is valid only if AVD on VDDA is enabled by the AVDEN bit. Note: Since the AVD is disabled in Standby mode, this bit is equal to 0 after Standby or reset until the AVDEN bit is set."]
pub const fn avdo (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Analog voltage detector output on VDDA This bit is set and cleared by hardware. It is valid only if AVD on VDDA is enabled by the AVDEN bit. Note: Since the AVD is disabled in Standby mode, this bit is equal to 0 after Standby or reset until the AVDEN bit is set."]
pub fn set_avdo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Csr1 { fn default () -> Csr1 { Csr1 (0) } } # [doc = "This register is not reset by wakeup from Standby mode, RESET signal and VDD POR. It is only reset by VSW POR and VSWRST reset. This register shall not be accessed when VSWRST bit in RCC_BDCR register resets the VSW domain.After reset, PWR_CR2 register is write-protected. Prior to modifying its content, the DBP bit in PWR_CR1 register must be set to disable the write protection."]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "Backup regulator enable When set, the Backup regulator (used to maintain the backup RAM content in Standby and VBAT modes) is enabled. If BREN is reset, the backup regulator is switched off. The backup RAM can still be used in Run and Stop modes. However, its content will be lost in Standby and VBAT modes. If BREN is set, the application must wait till the Backup Regulator Ready flag (BRRDY) is set to indicate that the data written into the SRAM will be maintained in Standby and VBAT modes."]
pub const fn bren (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Backup regulator enable When set, the Backup regulator (used to maintain the backup RAM content in Standby and VBAT modes) is enabled. If BREN is reset, the backup regulator is switched off. The backup RAM can still be used in Run and Stop modes. However, its content will be lost in Standby and VBAT modes. If BREN is set, the application must wait till the Backup Regulator Ready flag (BRRDY) is set to indicate that the data written into the SRAM will be maintained in Standby and VBAT modes."]
pub fn set_bren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "VBAT and temperature monitoring enable When set, the VBAT supply and temperature monitoring is enabled."]
pub const fn monen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "VBAT and temperature monitoring enable When set, the VBAT supply and temperature monitoring is enabled."]
pub fn set_monen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Backup regulator ready This bit is set by hardware to indicate that the Backup regulator is ready."]
pub const fn brrdy (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Backup regulator ready This bit is set by hardware to indicate that the Backup regulator is ready."]
pub fn set_brrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "VBAT level monitoring versus low threshold"]
pub const fn vbatl (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "VBAT level monitoring versus low threshold"]
pub fn set_vbatl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "VBAT level monitoring versus high threshold"]
pub const fn vbath (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "VBAT level monitoring versus high threshold"]
pub fn set_vbath (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Temperature level monitoring versus low threshold"]
pub const fn templ (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Temperature level monitoring versus low threshold"]
pub fn set_templ (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Temperature level monitoring versus high threshold"]
pub const fn temph (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Temperature level monitoring versus high threshold"]
pub fn set_temph (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "reset only by system reset, not reset by wakeup from Standby mode5 wait states are required when writing this register (when clearing a WKUPF bit in PWR_WKUPFR, the AHB write access will complete after the WKUPF has been cleared)."]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wkupcr (pub u32) ; impl Wkupcr { # [doc = "Clear Wakeup pin flag for WKUP. These bits are always read as 0."]
pub const fn wkupc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Clear Wakeup pin flag for WKUP. These bits are always read as 0."]
pub fn set_wkupc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } } impl Default for Wkupcr { fn default () -> Wkupcr { Wkupcr (0) } } # [doc = "This register allows controlling CPU1 power."]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cpucr (pub u32) ; impl Cpucr { # [doc = "D1 domain Power Down Deepsleep selection. This bit allows CPU1 to define the Deepsleep mode for D1 domain."]
pub const fn pdds_d1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "D1 domain Power Down Deepsleep selection. This bit allows CPU1 to define the Deepsleep mode for D1 domain."]
pub fn set_pdds_d1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "D2 domain Power Down Deepsleep. This bit allows CPU1 to define the Deepsleep mode for D2 domain."]
pub const fn pdds_d2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "D2 domain Power Down Deepsleep. This bit allows CPU1 to define the Deepsleep mode for D2 domain."]
pub fn set_pdds_d2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "System D3 domain Power Down Deepsleep. This bit allows CPU1 to define the Deepsleep mode for System D3 domain."]
pub const fn pdds_d3 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "System D3 domain Power Down Deepsleep. This bit allows CPU1 to define the Deepsleep mode for System D3 domain."]
pub fn set_pdds_d3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "STOP flag This bit is set by hardware and cleared only by any reset or by setting the CPU1 CSSF bit."]
pub const fn stopf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "STOP flag This bit is set by hardware and cleared only by any reset or by setting the CPU1 CSSF bit."]
pub fn set_stopf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "System Standby flag This bit is set by hardware and cleared only by a POR (Power-on Reset) or by setting the CPU1 CSSF bit"]
pub const fn sbf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "System Standby flag This bit is set by hardware and cleared only by a POR (Power-on Reset) or by setting the CPU1 CSSF bit"]
pub fn set_sbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "D1 domain DStandby flag This bit is set by hardware and cleared by any system reset or by setting the CPU1 CSSF bit. Once set, this bit can be cleared only when the D1 domain is no longer in DStandby mode."]
pub const fn sbf_d1 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "D1 domain DStandby flag This bit is set by hardware and cleared by any system reset or by setting the CPU1 CSSF bit. Once set, this bit can be cleared only when the D1 domain is no longer in DStandby mode."]
pub fn set_sbf_d1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "D2 domain DStandby flag This bit is set by hardware and cleared by any system reset or by setting the CPU1 CSSF bit. Once set, this bit can be cleared only when the D2 domain is no longer in DStandby mode."]
pub const fn sbf_d2 (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "D2 domain DStandby flag This bit is set by hardware and cleared by any system reset or by setting the CPU1 CSSF bit. Once set, this bit can be cleared only when the D2 domain is no longer in DStandby mode."]
pub fn set_sbf_d2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Clear D1 domain CPU1 Standby, Stop and HOLD flags (always read as 0) This bit is cleared to 0 by hardware."]
pub const fn cssf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Clear D1 domain CPU1 Standby, Stop and HOLD flags (always read as 0) This bit is cleared to 0 by hardware."]
pub fn set_cssf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Keep system D3 domain in Run mode regardless of the CPU sub-systems modes"]
pub const fn run_d3 (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Keep system D3 domain in Run mode regardless of the CPU sub-systems modes"]
pub fn set_run_d3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Cpucr { fn default () -> Cpucr { Cpucr (0) } } # [doc = "Reset only by POR only, not reset by wakeup from Standby mode and RESET pad. The lower byte of this register is written once after POR and shall be written before changing VOS level or ck_sys clock frequency. No limitation applies to the upper bytes.Programming data corresponding to an invalid combination of SDLEVEL, SDEXTHP, SDEN, LDOEN and BYPASS bits (see Table9) will be ignored: data will not be written, the written-once mechanism will lock the register and any further write access will be ignored. The default supply configuration will be kept and the ACTVOSRDY bit in PWR control status register 1 (PWR_CSR1) will go on indicating invalid voltage levels. The system shall be power cycled before writing a new value."]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr3 (pub u32) ; impl Cr3 { # [doc = "Power management unit bypass"]
pub const fn bypass (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Power management unit bypass"]
pub fn set_bypass (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Low drop-out regulator enable"]
pub const fn ldoen (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Low drop-out regulator enable"]
pub fn set_ldoen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "SD converter Enable"]
pub const fn scuen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "SD converter Enable"]
pub fn set_scuen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "VBAT charging enable"]
pub const fn vbe (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "VBAT charging enable"]
pub fn set_vbe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "VBAT charging resistor selection"]
pub const fn vbrs (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "VBAT charging resistor selection"]
pub fn set_vbrs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "VDD33USB voltage level detector enable."]
pub const fn usb33den (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "VDD33USB voltage level detector enable."]
pub fn set_usb33den (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "USB regulator enable."]
pub const fn usbregen (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "USB regulator enable."]
pub fn set_usbregen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "USB supply ready."]
pub const fn usb33rdy (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "USB supply ready."]
pub fn set_usb33rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Cr3 { fn default () -> Cr3 { Cr3 (0) } } # [doc = "PWR control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Low-power Deepsleep with SVOS3 (SVOS4 and SVOS5 always use low-power, regardless of the setting of this bit)"]
pub const fn lpds (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low-power Deepsleep with SVOS3 (SVOS4 and SVOS5 always use low-power, regardless of the setting of this bit)"]
pub fn set_lpds (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Programmable voltage detector enable"]
pub const fn pvde (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Programmable voltage detector enable"]
pub fn set_pvde (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Programmable voltage detector level selection These bits select the voltage threshold detected by the PVD. Note: Refer to Section Electrical characteristics of the product datasheet for more details."]
pub const fn pls (& self) -> u8 { let val = (self . 0 >> 5usize) & 0x07 ; val as u8 } # [doc = "Programmable voltage detector level selection These bits select the voltage threshold detected by the PVD. Note: Refer to Section Electrical characteristics of the product datasheet for more details."]
pub fn set_pls (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 5usize)) | (((val as u32) & 0x07) << 5usize) ; } # [doc = "Disable backup domain write protection In reset state, the RCC_BDCR register, the RTC registers (including the backup registers), BREN and MOEN bits in PWR_CR2 register, are protected against parasitic write access. This bit must be set to enable write access to these registers."]
pub const fn dbp (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Disable backup domain write protection In reset state, the RCC_BDCR register, the RTC registers (including the backup registers), BREN and MOEN bits in PWR_CR2 register, are protected against parasitic write access. This bit must be set to enable write access to these registers."]
pub fn set_dbp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Flash low-power mode in DStop mode This bit allows to obtain the best trade-off between low-power consumption and restart time when exiting from DStop mode. When it is set, the Flash memory enters low-power mode when D1 domain is in DStop mode."]
pub const fn flps (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Flash low-power mode in DStop mode This bit allows to obtain the best trade-off between low-power consumption and restart time when exiting from DStop mode. When it is set, the Flash memory enters low-power mode when D1 domain is in DStop mode."]
pub fn set_flps (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "System Stop mode voltage scaling selection These bits control the VCORE voltage level in system Stop mode, to obtain the best trade-off between power consumption and performance."]
pub const fn svos (& self) -> u8 { let val = (self . 0 >> 14usize) & 0x03 ; val as u8 } # [doc = "System Stop mode voltage scaling selection These bits control the VCORE voltage level in system Stop mode, to obtain the best trade-off between power consumption and performance."]
pub fn set_svos (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val as u32) & 0x03) << 14usize) ; } # [doc = "Peripheral voltage monitor on VDDA enable"]
pub const fn avden (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Peripheral voltage monitor on VDDA enable"]
pub fn set_avden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Analog voltage detector level selection These bits select the voltage threshold detected by the AVD."]
pub const fn als (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x03 ; val as u8 } # [doc = "Analog voltage detector level selection These bits select the voltage threshold detected by the AVD."]
pub fn set_als (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 17usize)) | (((val as u32) & 0x03) << 17usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "Reset only by system reset, not reset by wakeup from Standby mode"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wkupepr (pub u32) ; impl Wkupepr { # [doc = "Enable Wakeup Pin WKUPn+1 Each bit is set and cleared by software. Note: An additional wakeup event is detected if WKUPn+1 pin is enabled (by setting the WKUPENn+1 bit) when WKUPn+1 pin level is already high when WKUPPn+1 selects rising edge, or low when WKUPPn+1 selects falling edge."]
pub fn wkupen (& self , n : usize) -> bool { assert ! (n < 6usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Enable Wakeup Pin WKUPn+1 Each bit is set and cleared by software. Note: An additional wakeup event is detected if WKUPn+1 pin is enabled (by setting the WKUPENn+1 bit) when WKUPn+1 pin level is already high when WKUPPn+1 selects rising edge, or low when WKUPPn+1 selects falling edge."]
pub fn set_wkupen (& mut self , n : usize , val : bool) { assert ! (n < 6usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Wakeup pin polarity bit for WKUPn-7 These bits define the polarity used for event detection on WKUPn-7 external wakeup pin."]
pub fn wkupp (& self , n : usize) -> bool { assert ! (n < 6usize) ; let offs = 8usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Wakeup pin polarity bit for WKUPn-7 These bits define the polarity used for event detection on WKUPn-7 external wakeup pin."]
pub fn set_wkupp (& mut self , n : usize , val : bool) { assert ! (n < 6usize) ; let offs = 8usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Wakeup pin pull configuration"]
pub fn wkuppupd (& self , n : usize) -> u8 { assert ! (n < 6usize) ; let offs = 16usize + n * 2usize ; let val = (self . 0 >> offs) & 0x03 ; val as u8 } # [doc = "Wakeup pin pull configuration"]
pub fn set_wkuppupd (& mut self , n : usize , val : u8) { assert ! (n < 6usize) ; let offs = 16usize + n * 2usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val as u32) & 0x03) << offs) ; } } impl Default for Wkupepr { fn default () -> Wkupepr { Wkupepr (0) } } }